/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2009 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 1.0.1
 */
 
var bWheelHandler = false;
var previewViewer;

function updateCode(skipconfig, bFixedSize, bForPreview, bByPassProxy){



	var t;
	var opt = document.settings;



	v = getDir();
	if(v[1].substring(v[1].length-1) == "/") v[1] = v[1].substring(0,v[1].length-1); //remove trailing slash (FSI Cache issue)
	qdata[""+v[0]+""] = v[1];

	opt.FSIwidth.value 	= ValidateInt(opt.FSIwidth);
	opt.FSIheight.value = ValidateInt(opt.FSIheight);

	if( (opt.FSIwidth.value == "error" || opt.FSIheight.value == "error") || (opt.FSIwidth.value == '' && opt.FSIheight.value == ''))  setInitialDimensions();

	if (opt.FSIwidth.value == '' || opt.FSIheight.value == '') {
		
		changeDimensionOnRatio();
	}
	
	if (opt.FSIunit.options[opt.FSIunit.selectedIndex].value == 'pc') {
		if (opt.FSIwidth.value > 100) opt.FSIwidth.value = 100;
		if (opt.FSIheight.value > 100) opt.FSIheight.value = 100;
	}
	
	Resizable = false;
	if (bForPreview) {
		fsiUrl = interfaceControl.getUserLocalFSIViewer();
		pagesMobileUrl = interfaceControl.getUserLocalFSIViewerBase() + "applications/pagesmobile/?";
	} else {
		fsiUrl = interfaceControl.getUserProxyViewerUrl();
		pagesMobileUrl = interfaceControl.getUserProxyPagesMobileUrl() + "?";
	}
	
	var effects = new Array();
	var renderingEffects = getEffectsArray();

	Resizable = opt.options_resizeable.checked;
	if (Resizable && !inArray('Resize',plugins))	handlePlugins('Resize');
	if (!Resizable && inArray('Resize',plugins))	handlePlugins('Resize');

	if (qdata["cfg"] && qdata["cfg"].substring(qdata["cfg"].length-4) == ".xml") qdata["cfg"] = qdata["cfg"].substr(0,qdata["cfg"].length-4) //remove suffix if present.
	
	
	if (bForPreview) {
		qdata["usenc"] = "true";
		qdata["usencQuery"] = "&headers=webinterface";
	} else {
		delete(qdata["usenc"]);
		delete(qdata["usencQuery"]);
	}
	StorePublishingSettings();
	qdata["debug"]= getRadioValue(opt.Debug);
	qdata["imagetransparency"]= getRadioValue(opt.Imagetransparency);
	


	if (qdata["debug"]=="false") qdata["debug"]="";
	//if (qdata["imagetransparency"]=="false") qdata["imagetransparency"]="";
	
	// Publish

	if (qdata["pages_bendeffect"]=="Glossy")			qdata["pages_bendeffect"] = "";
	if (qdata["pages_singlesided"]=="false")			qdata["pages_singlesided"] = "";
	if (qdata["options_animation"]=="BEST")				qdata["options_animation"] = "";

	// collect all effects
	qdata["effects"] ="";

	
	effects["quality"] = opt.effects_quality.value = ValidateInt(opt.effects_quality, '', 1);
	if (effects["quality"] != '') {
		qdata["effects"] +="quality="+effects["quality"]+"";
	}

	//Effects
	if (renderingEffects.length > 0) {
		if(qdata["effects"] != "") qdata["effects"] += "&"
		renderingEffects = renderingEffects.join(",");
		qdata["effects"] += renderingEffects;
	}


	if (qdata["param_backgroundcolor"]) {
		 fsiopt = "bgcolor="+qdata["param_backgroundcolor"]+";";
	} else {
		fsiopt = "";
	}

	// Build query
	
	query='';

		for (var option in qdata) {
			if (option.indexOf('effectsvalue') > -1) { delete(qdata[option]); continue; }
			if (option == 'notepad_uniqueid' && !inArray('Notepad',plugins)) { continue; }
			if (option == 'chaptersxml' || option == 'publishwmode' || option == 'options_htmltitle') { continue; }
			if (option == 'effects_lefteffects' || option == 'effects_righteffects') { continue; }
			if (option == 'chapters_xml' && !inArray('Chapters',plugins)) { continue; }
			
			if (option == 'param_backgroundcolor') { continue; }
			if (option == 'saturation' || option == 'param_lefteye' || option == 'param_righteye') { continue; }

			if ( option != "moreparams" && (qdata[option] != "" || typeof(qdata[option]) == "number") && typeof(qdata[option]) != "undefined") {

				if (qdata[option] == 'error') {
					return false;
				}

				arr = option.split("_");
				if (arr[0] != 'plugins') {
					if (arr[0] != 'options') {
						query +='&'+option+'='+encodeURIComponent(qdata[option]);
					} else {
						query +='&'+arr[1]+'='+encodeURIComponent(qdata[option]);
					}
				}
			}
		}

	if (croprect && croprect.length > 0) {
		query = query + croprect;
	}		

	try { //Download Only
			v = document.getElementById('image_profile').value.toLowerCase();
			if ( v != '')
			query = query + "&renderer="+encodeURIComponent(v);
			if (v == 'png') {
				compressionslider.setValue(0);
				compressionslider.setMaximum(0);
				compressionslider.recalculate();
			} else {
				compressionslider.setMaximum(100);
				compressionslider.recalculate();
			}
	} catch (e) {}
	
	// collect all dynamic plug-ins
	var enabledPlugins = fsiparser.getEnabledPlugins();
	var disabledPlugins = fsiparser.getDisabledPlugins();
	fsiparser.getPublishOptions();
	var joinarray=new Array();
	var explicitarray=new Array();
	var pluginsEnabled = new Array();
	for (var l = 0, i = 0, j = 0; l < plugins.length; l++){
		var pllower = plugins[l].toLowerCase();
		pluginsEnabled[pllower]=true;
		if (!enabledPlugins[pllower]){
			joinarray[i++]=pllower;
		}
		if (disabledPlugins[pllower]){
			explicitarray[j++]=pllower;
		}
	}

	// disabled Plugins
	var interfacePlugins = getInterfacePlugins();
	var disableNewPlugins = new Array();
	var i = 0;
	for (var lplugin in enabledPlugins){
		if (!pluginsEnabled[lplugin] && interfacePlugins[lplugin]){
			disableNewPlugins[i++] = lplugin;
		}
	}

	qdata["plugins"] = joinarray.join(",");
	if (qdata["plugins"].length > 0) {
		query += '&plugins='+qdata["plugins"];
		//if (bForPreview) query += ",webinterface";
	}
	
	
	if (explicitarray.length > 0){
		for (var d = 0; d < explicitarray.length; d++){
			 query += '&'+explicitarray[d]+"=1";
		}
	}

	//Append MoreOptions
	qdata["moreparams"] = escape(escape(opt.MoreParams.value));
	var t = opt.MoreParams.value;
	while (t.match(/(\r\n|\n)/)){
		t = t.replace(/(\r\n|\n)/,"&");
	}
	
	// escape keys and values
	arPairs = t.split("&");
	for (var i = 0; i < arPairs.length; i++){
		var t = arPairs[i].split("=");
		var key = escape(unescape(t.shift()));
		var value = escape(unescape(t.join("=")));
		if (key.length > 0) arPairs[i] = key + "=" + value;
	}
	t = arPairs.join("&");
	if (t.length > 0 && t.charAt(0) != "&") t ="&"+t;

	if (t != "&plugins=") query +=t;
		
	try {
		af = document.getElementById('autoflip');
		if (af.checked == false) query +="&Pages_AutoFlipCropRect=false";
	}catch(e) {}
	
	if (build != 'pages' && build != 'showcase') {
		if(interfaceControl.isBasePath3D()) {
			var eff ="&imageservertemplate=anaglyph";
			if (interfaceControl.isBasePath3DDirectories() && v[1] != 'images3durl' ) eff +="&Images3DListTemplate=image_list3d_anaglyph&";
			eff += "&effects=";
			try{
				if(qdata["effects_lefteffects"]) eff += "lefteffects%3D"+qdata["effects_lefteffects"];
				if(qdata["effects_lefteffects"] && qdata["effects_righteffects"]) eff += "%26" // &
				if(qdata["effects_righteffects"]) eff += "righteffects%3D"+qdata["effects_righteffects"];
			}catch(e) {}
			try{
				if(opt.saturation.value != "")
				eff+= "%26preeffects%3D"+encodeURIComponent("saturation(YIQ,"+parseInt(opt.saturation.value)+")&");
			}catch(e) {}
			query = query+eff;
		}
	}
	
	
	if (bByPassProxy) {
		if (query.length > 0) query += "&";
		query += "usenc=1"
	}


	if (opt.FSIunit.options[opt.FSIunit.selectedIndex].value == 'pc') {
		var unit = '%';
	}
	else {
		var unit = '';
	}

	if (Resizable) {
		try{
			PopupWidth  = oldPreviewWindowWidth;
			PopupHeight = oldPreviewWindowHeight;
			ObjectWidth = ObjectHeight = "100";

			if (isNaN(PopupWidth)  || PopupWidth < 100)  PopupWidth  = 360;
			if (isNaN(PopupHeight) || PopupHeight < 100) PopupHeight = 360;
		}catch(e){};
	}
	else {
			PopupWidth  = 360;
			ObjectWidth  = opt.FSIwidth.value;
			PopupHeight = 360;
			ObjectHeight = opt.FSIheight.value;
	}

	var htmlSnippet='';
	var externaljs='';
	var maincode='';



	if (Resizable && unit != "%" && !bFixedSize) fsiopt += ";width=100%;height=100%";
	else fsiopt += "width="+opt.FSIwidth.value+unit+";height="+opt.FSIheight.value+unit;
	
	var fallbackImage = getPublishImageEntry();
	
	
	
	var flashFallbackImage_full = "";
	if (fallbackImage){
		var fbih = 200;
		if (fsiFDA.flashVersion == 0) {
			preview_saved_height = opt.FSIheight.value;
		}
	
		if(preview_saved_height && bForPreview) {
			var fbih = preview_saved_height;
		} else {
			var fbih = opt.FSIheight.value;
		}
		flashFallbackImage_full =  interfaceControl.getUserProxyServerUrl()+'?type=image&source='+fallbackImage.fullsrc + '&height='+fbih;
	}

	
	if (bForPreview){
		fsiopt += ";wmode=opaque";
	}
	else if (opt.publishwmode && opt.publishwmode.value != "window"){
		fsiopt += ";wmode="+opt.publishwmode.value;
	}


	//FSI Pages mobile options:
	if (opt.mobilesupport && opt.mobilesupport.checked){
		fsiopt += ";mobilesupport="+opt.mobilesupport.value;
	}
	
	if (opt.mobileiossupport && opt.mobileiossupport.checked){
		fsiopt += ";mobileiossupport=true";
	}

	if (opt.mobileandroidsupport && opt.mobileandroidsupport.checked){
		fsiopt += ";mobileandroidsupport=true";
	}
	
	if (opt.mobiletouchtext && opt.mobiletouchtext.value != ""){
		fsiopt += ";mobiletouchtext="+encodeURIComponent(opt.mobiletouchtext.value);
	}
	
	if (opt.mobilepopupautomode && opt.mobilepopupautomode.checked){
		//fsiopt += ";mobilepopupautomode=true";
	} else {
		fsiopt += ";mobilepopupautomode=false";
	}
	
	if (query.charAt(0) == "&" && fsiUrl.length > 0){
		var chrEnd = fsiUrl.charAt(fsiUrl.length-1);
		if (chrEnd == "?" || chrEnd == "&") query = query.substr(1);
	}

	if (opt.publishjs && opt.publishjs.checked){
		if(bForPreview)
			externaljs = getFlashWriter(getUserLocalJSRoot());
		else
			externaljs = getFlashWriter(interfaceControl.getUserProxyJSUrl());

		
		maincode = writeJSHTMLCode( fsiUrl+query, flashFallbackImage_full, fsiopt);
	}
	else {
		
		maincode = writeFlashCode( fsiUrl+query, flashFallbackImage_full, fsiopt, true);
		
	}

	if (opt.publishwrap && opt.publishwrap.checked){
		htmlSnippet = warpInHTML("FSI Preview", maincode, "", externaljs);
	}
	else {
		htmlSnippet = externaljs + maincode;
	}

	opt.htmldata.value = htmlSnippet;
	if (bForPreview) {
			opt.previewdata.value = writeFlashCode(fsiUrl+query, flashFallbackImage_full, fsiopt, true);

			interfaceControl.updatePreviewCode(warpInHTML("", maincode, "", externaljs, true));
	}
	
	try {
		if (bForPreview) opt.pagesmobilepreviewdata.value = pagesMobileUrl+query;
		else opt.pagesmobiledata.value = pagesMobileUrl+query;
	} catch(e) {}
	StoreParameterValues(build);
	StorePublishingSettings();
	
	try{
		previewViewer = browser.isIE ? fsiwbeuipreviewviewer : document.fsiwbeuipreviewviewer;
	}
	catch(e){}
	if (!bWheelHandler){
		var el = document.getElementById("preview");
		if (el){
			bWheelHandler = true;
			interfaceControl.addFSIViewerWheelHandler(el, doWheel1, doWheel2);
		}
	}



	return true;
}


function doWheel1(evt){
	if (previewViewer && previewViewer.webui_handleMouseWheel) {
		previewViewer.webui_handleMouseWheel(evt.wheelDelta / 80);
	}
};

	
function doWheel2(evt){
	if (previewViewer && previewViewer.webui_handleMouseWheel) {
		previewViewer.webui_handleMouseWheel(-evt.detail );
	}
};

if(history.length > 0)
{
	history.forward();
}

var preloadFlag = false;
