/*!
 * FSI Viewer (tm)
 * Build: 18.06.18.8
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing;$FSI.console.info=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a==undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r==undefined)?"":strReturn+ar[i].r;strType=(ar[i].t==undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]==undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!=undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)=="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)=="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!=undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)=="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!=undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var oClassOptions={strVersion:"2018",strBuild:"18.06.18.8"};var classDef=new $FSI.ClassDef($FSI,"FSI Core",oClassOptions);$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof($FSI.iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!=undefined&&ar.length>0){for(var i=0;i<ar.length;i++){$FSI.deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};$FSI.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors==undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);$FSI.addCSSRule(strSelector,strRule,0)};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.deleteCSSRule=function(selector){var ret=false;if($FSI.oInsertedCSS!=undefined){try{var arDelete=[];var ar=$FSI.oInsertedCSS.sheet.cssRules;for(var i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText==selector){arDelete.push(i)}}if(arDelete.length>0){for(var i=arDelete.length-1;i>-1;i--){$FSI.oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		 @if (@_jscript_version < 9)
		 el.style.setAttribute('cssText', strStyle);
		 @else @*/
el.setAttribute("style",strStyle);
/*@end
		 @*/
};$FSI.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWidth=window.innerWidth;$FSI.bElementPosRespectsScroll=true;$FSI.oSupportedEvents={};$FSI.isEventSupported=function(eventName){if($FSI.oSupportedEvents[eventName]!=undefined){return $FSI.oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;$FSI.oSupportedEvents[eventName]=isSupported;return isSupported};var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}$FSI.userAgent=navigator.userAgent.toLowerCase();var uagent=$FSI.userAgent;var result,t,i;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!==-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;$FSI.versionInternetExplorer=0;$FSI.isIETouch=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("chrome")!==-1&&uagent.search("edge")===-1){$FSI.isChrome=true}else{if(uagent.search("safari")!==-1){$FSI.isSafari=true}else{if(uagent.search("firefox")!==-1){$FSI.isFirefox=true}else{if(uagent.search("opera")!==-1){$FSI.isOpera=true}}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)==="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(nam,unit){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return window.visualViewport.scale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){$FSI.documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";$FSI.getDocumentScale=function(){if(screen.width!=$FSI.topWindow.outerWidth){return($FSI.topWindow.outerWidth-192)/$FSI.topWindow.innerWidth}return($FSI.topWindow.outerWidth-83)/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth iOS";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.documentScaleMethod="fallback";$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!=="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getVisualViewportSize=function(){var ret={};if(window.visualViewport){ret.width=window.visualViewport.width;ret.height=window.visualViewport.height}else{ret.width=window.innerWidth;ret.height=window.innerHeight}return ret};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.visualViewport.width,height:wnd.visualViewport.height}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)==="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.replaceChild=function(parent,existingChild,newChild){try{var elNext=existingChild.nextSibling;if(elNext){parent.removeChild(existingChild);parent.insertBefore(newChild,elNext)}else{parent.appendChild(newChild)}}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(existingChild);$FSI.console.log(newChild)}};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.callbackFunctionID=0;$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.dispatchEvent=function(myEvent,props){var event;if($FSI.BrowserSupports.genericEvent()){event=new Event(myEvent)}else{event=document.createEvent("Event");event.initEvent(myEvent,true,true)}if(event){return window.dispatchEvent(event)}else{return false}};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!=="object"){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)==="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!=="string"){return false}var t=typeof(parameters);if(t!=="object"&&t!=="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!=="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!=="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!=="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!=="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)==="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!=="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!=="string"){return}if(typeof(strClass)!=="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!=="string"){return}if(typeof(strClass)!=="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.hasClass=function(el,strClass){if(typeof(strClass)!=="string"){return false}strClass=$FSI.trim(strClass);if(strClass.length<1){return false}var str=el.className;if(typeof(str)!=="string"||str.length<1){return false}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");return(str.match(regex)!=null)};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.regExEffects=/((\?)|&)effects=([^&]*)/ig;$FSI.regExPadEffect=/[=,]+Pad\([^)]*/ig;$FSI.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match($FSI.regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match($FSI.regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!=="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=scale.y=targetDimension.width/(sourceDimension.width*range.width)}else{scale.x=scale.y=targetDimension.height/(sourceDimension.height*range.height)}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)==="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(window.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.genericEvent=function(){var res=false;try{if(typeof(window.Event)==="function"){res=true}}catch(e){}$FSI.BrowserSupports.genericEvent=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)==="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)==="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!=b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m==b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m==b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(e){if(k.readyState!=4){return}delete c[n];if(m==b||this.FSIaborted){return}var r=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,r,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CanvasProgressBar!=b){return}a.CanvasProgressBar=function(s,m,j,d,q,e){var r=this;if(!e){e={}}if(typeof(e.border)!="string"){e.frame="#58a8ff"}if(typeof(e.color)!="string"){e.color="#58a8ff"}if(typeof(e.background)!="string"){e.background="rgba(255,255,255,0.5)"}if(typeof(e.text)!="string"){e.text="#FFFFFF"}var p=m;var o=j;var g=q;var l=d;var h=0;var k=(q>10&&d>40);this.draw=function(t){var u=l/100*t;i(p,o,l,g,h);c(p,o,u,g,h,l);if(k){f(p,o,u,g,h,l)}};this.setCtx=function(t){s=t};this.setPos=function(t,u){p=t;o=u};var i=function(v,z,w,u,t){s.save();s.fillStyle=e.border;n(v-1,z-1,w+2,1,t);n(v-1,z+u,w+2,1,t);n(v-1,z-1,1,u+2,t);n(v+w,z-1,1,u+2,t);s.fillStyle=e.background;n(v,z,w,u,t);s.restore()};var c=function(w,A,z,v,u,t){s.fillStyle=e.color;n(w,A,z,v,u)};var n=function(v,z,w,u,t){s.fillRect(v,z,w,u)};var f=function(B,z,t,D,w,A){s.save();s.font="10px Arial";s.textAlign="start";s.textBaseline="alphabetic";s.fillStyle=e.text;var C=Math.floor(t/A*100)+"%";var u=s.measureText(C).width;var v=B+t-u-w/2-4;if(t<=w+u){v=B+w/2}s.fillText(C,v,z+D/2+3.25);s.restore()}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!=b){return}a.Config=function(Z,z,g){if(typeof(g)!=="object"){g={}}if(!z||typeof(z)!=="object"){z={}}var p=this;this.parameters=(Z&&typeof(Z)==="object")?Z:{};this.queryParameters=b;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():b}catch(ab){}this.plugins={};this.arPlugins=[];this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=[];this.arConditions=[];this.locales={};this.locales.tips={};var R=false;this.strListFilePrefix="";this.strListFileSuffix="";var J={};var B=0;var t;var V={};var d="FSI> ";var E=p.debug=new a.EmptyDebugger();var C=false;var A={};var af=false;var M={stickynotes:"bookmarks"};var h;var Q=false;var v;var G;var W;var c;var o;var x="token";var y;this.strConfigFileExtension=".xml";p.strTemplateSuffix=".json";var r;var i=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){r=function(ag){var e;if(!a.isCrossDomain(ag)){af=false;e=new XMLHttpRequest()}else{af=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){r=function(){return new XMLHttpRequest()}}}if(!r){try{i=new ActiveXObject("Msxml2.XMLHTTP");r=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(ab){try{i=new ActiveXObject("Microsoft.XMLHTTP");r=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(ab){i=null;r=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters={};this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(ai){p.reset();v=(typeof(g.strSection)==="string")?g.strSection:"";G=v.toLowerCase();if(typeof(g.strTraceParam)==="string"){var ag=g.strTraceParam.toLowerCase();c={};c[ag]=true;if(ag.indexOf("_")>0&&ag.indexOf("pages")===0){ag=ag.split("_");ag.shift();ag=ag.join("_");c[ag]=true}var ah=p.getParameterAlias(ag);if(ah){c[ah]=true}}else{c=false}if(ai){if(p.parameters){p.parameters=a.mergeObjects(p.parameters,ai)}else{p.parameters=ai}}Y(p.parameters);p.getQueryParameters();p.cloneParameters(p.cfgDefaults,p.cfg);p.cloneParameters(p.queryParameters,p.cfg);p.elevateToHTTPS();f();p.BaseURL=p.getBaseURL();if(p.bForceVersion5==true){}var e=p.queryParameters.fsiviewerversion;if(p.bForceVersion5==true){e="5"}if(e!=b){if(parseInt(e)<6){p.strConfigFileExtension=".fsi"}}var aj=p.queryParameters.fsiserverversion;if(p.bForceVersion5==true){aj="2"}if(aj!=b){if(parseInt(aj)<3){p.strTemplateSuffix="_json"}}p.locationFSIViewer="";if(p.queryParameters.fsiviewerlocation!=b){p.locationFSIViewer=p.queryParameters.fsiviewerlocation}else{if(a!=b&&a._FSIViewerLocation!=b){E.log("FSI Viewer location guessed based on script location: "+a._FSIViewerLocation);p.locationFSIViewer=a._FSIViewerLocation}else{p.locationFSIViewer=p.BaseURL.split("/");if(p.locationFSIViewer.length>4){p.locationFSIViewer.splice(p.locationFSIViewer.length-3,2);p.locationFSIViewer=p.locationFSIViewer.join("/")}}}if(p.locationFSIViewer.charAt(p.locationFSIViewer.length-1)!="/"){p.locationFSIViewer+="/"}p.nextConfigURL=p.getReloadPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.defaultcfg));p.checkDebug(false)};var Y=this.makeObjectPropertiesLowerCase=function(e){for(var ag in e){var ah=ag.toLowerCase();if(ag!=ah){if(e[ah]==b){e[ah]=e[ag]}delete e[ag]}}};this.getClassParameters=function(){return W};this.setAccessToken=function(e){y=e};this.getParameterAlias=function(ah){var e;if(p.cfgAliasNames[ah]){e=p.cfgAliasNames[ah]}else{for(var ag in p.cfgAliasNames){if(p.cfgAliasNames[ag]===ah){e=ag;break}}}return e};var f=function(){R=p.makeBool(p.cfg.usenc,false);if(p.cfg.usencquery!=b&&p.cfg.usencquery.length>0){C=p.cfg.usencquery;R=true;p.queryToObject("?"+C,A)}};this.stopPendingRequests=function(){for(var ag in J){var e=J[ag];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){p.stopPendingRequests()};this.getBaseURL=function(){var ah;var ag=document.getElementsByTagName("base");if(ag&&ag.length>0){ah=ag[ag.length-1].href;if(ah&&ah.charAt(ah.length-1)!="/"){ah+="/"}}else{ah=document.location.href;var e=ah.indexOf("?");if(e!=-1){ah=ah.slice(0,e)}e=ah.indexOf("#");if(e!=-1){ah=ah.substring(0,e)}e=ah.lastIndexOf("/");if(e!=-1){ah=ah.slice(0,e+1)}}return ah};this.reset=function(){W={};p.parameters={};E=p.debug=new a.EmptyDebugger();p.stopPendingRequests();t=Math.random();p.nIncludedConfigs=0;p.completedConfigs={};p.plugins={};p.cfg={};p.queryParameters=b;p.arUnrecognizedConfigNodes=[];aa=0;p.arConditions=[];V={}};this.getQueryParameters=function(){if(p.queryParameters!=b){return}p.queryParameters={};p.cloneParameters(p.parameters,p.queryParameters)};this.makeBool=function(ai,e){if(typeof(e)!="boolean"){e=false}var ag=e;switch(typeof(ai)){case"string":var ah=a.makeBool(ai);if(ah!=b){ag=ah}break;case"number":ag=Boolean(ai);break;case"boolean":ag=ai;break}return ag};this.parsePositionParameter=function(ag){if(typeof(ag)!="string"||ag.length<3){return b}ag=ag.split(",");if(ag.length<3){return b}for(var e=0;e<3;e++){ag[e]=parseFloat(ag[e]);if(isNaN(ag[e])){ag[e]=0}}return{x:ag[0],y:ag[1],z:ag[2]}};this.logLoadFileFailed=function(e){if(!E.on){return}if(e&&e.status!=b){var ah="HTTP "+e.status;if(e&&e.statusText){ah+=", "+e.statusText}var ag=(e._url)?e._url:"";E.error("Failed to load "+ag+" ("+ah+")")}else{E.error("Failed loading a file");if(e&&e._url){E.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(aj){if(!aj||!aj.firstChild){return false}var e=aj.firstChild.childNodes;var ak,ah,ai;for(var ag=0;ag<e.length;ag++){ah=e[ag];ak=p.getAttributeValue(ah,"id");if(ak==b){continue}ak=ak.toLowerCase();if(ah.childNodes.length>0){ai=p.XMLChildNodesToString(ah)}else{ai=p.getAttributeValue(ah,"txt")}p.locales.tips[ak]=ai}return true};this.getAttributeValue=function(ag,e){if(!ag){return}return ag.getAttribute(e)};this.onLanguageLoaded=function(ag,e){E.log("Language loaded");if(ag){p.parseLanguage(e.responseXML)}if(z.onConfigReady){z.onConfigReady()}};this.onConfigReadyDone=function(){if(!p.readCustomPageNumbers()){p.loadImageList()}};this.swapParameters=function(ah,e){ah=ah.toLowerCase();e=e.toLowerCase();var ag=p.plugins.pages.parameters;if(ag==b){return}p.swapValues(ag,ah,e);p.swapValues(p.cfg,"pages_"+ah,"pages_"+e)};this.swapValues=function(ai,ah,ag){var e=ai[ah];ai[ah]=ai[ag];ai[ag]=e};this.getTranslation=function(ag){var e=p.locales.tips[ag.toLowerCase()];if(e==b){e=ag}return e};this.getImageURL=function(ah,e){if(ah==b){return""}if(e===b){e={}}if(e.type===b){e.type="image"}if(e.renderer===b){e.renderer="jpeg"}if(y){e[x]=y}e.source=ah;for(var ag in V){if(V[ag]!==b&&e[ag]===b){e[ag]=V[ag]}}for(var ag in T){if(e[ag]){if(T[ag]!==ag){if(!e[T[ag]]){e[T[ag]]=e[ag]}e[ag]=null}}}return p.requestBase+"?"+p.objectToQuery(e)};this.getImageInfoURL=function(ag,e){if(ag==b){return""}if(e==b){e={}}if(e.type==b){e.type="info"}if(e.tpl==b){if(p.cfg.fpxinfotemplate!=b){e.tpl=p.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(p.cfg.headers&&p.cfg.headers.length>0){e.headers=p.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=ag;if(y){e[x]=y}return p.requestBase+"?"+p.objectToQuery(e)};this.queryToObject=function(aj,ah){if(ah==b){ah={}}var ai,al,ak,e,ag;ai=aj.indexOf("?");if(ai!=-1){ag=aj.slice(ai+1)}else{ag=""}ai=ag.indexOf("#");if(ai!=-1){ag=ag.substring(0,ai)}ag=ag.split("&");for(ai=0;ai<ag.length;ai++){al=ag[ai].split("=");ak=a.urlDecode(al[0]).toLowerCase();if(ak.length>0){e=a.urlDecode(al[1]);ah[ak]=e}}return ah};this.parseSceneSets=function(e,aj){var aq={};if(aj==b){aj=true}var aw=[];var au=0;var ar=0;var ah;var al,ak,ai,ap,an,av;var am,ao,at;var ag=p.cfg.scenesets;if(e>1&&ag!=b&&typeof(ag)=="string"){ao=ag.split(";");for(al=0;al<ao.length;al++){at=[];am=ao[al].split(",");ar=0;for(ak=0;ak<am.length;ak++){av=am[ak].split("-");ap=an=0;if(av.length==1){ap=parseInt(av[0])}else{ap=parseInt(av[0]);if(isNaN(ap)){ap=1}ah=false;if(av[1].charAt(0)==">"){av[1]=av[1].substr(1);if(!isNaN(parseInt(av[1]))){ah=true}}an=parseInt(av[1]);if(isNaN(an)){an=e}if(ap>0&&an>0&&ap<=e&&an<=e){if(ah==true||ap!=an){if(ah!=true){if(an<ap){for(ai=ap;ai>=an;ai--){at[ar]=ai;ar++}}else{for(ai=ap;ai<=an;ai++){at[ar]=ai;ar++}}}else{for(ai=ap;ai<=e;ai++){at[ar]=ai;ar++}for(ai=1;ai<=an;ai++){at[ar]=ai;ar++}}}}}if(ap>0&&ap<=e&&(an==0||an==ap)){at[ar]=ap;ar++}}if(ar>0){aw[au]={};aw[au].arScenes=[];aw[au].arScenes=aw[au].arScenes.concat(at);au++}}}if(au==0){aq.bDefault=true;if(aj){aw[0]={};aw[0].arScenes=[];for(al=0;al<e;al++){aw[0][al]=al}}}aq.nSceneSets=au;aq.bHasMultipleSets=(aq.nSceneSets>1);aq.arSets=aw;aq.nCurrent=1;return aq};this.objectToQuery=function(ag){var e=[];var ai,ah;if(R&&C!==false){for(ai in A){ag[ai]=A[ai]}}for(ai in ag){ah=ag[ai];if(ah!==null){ah=encodeURIComponent(ah);e.push(encodeURIComponent(ai)+"="+ah)}}return e.join("&")};this.loadConfigs=function(){W=(v.length>0)?{}:false;h=true;p.loadNextConfig(true)};this.loadImageInfo=function(ai,e,ah){var ag=p.getImageInfoURL(ai);p.loadFile(ag,e,b,ah)};this.loadFile=function(aj,ai,ah,an,am,ag,ak){if(!aj||aj.length<0){if(ai){setTimeout(function(){ai(null,"",an)},0)}return}if(am==b){am="GET"}if(ag==b){ag=null}else{if(typeof(ag)=="object"){ag=p.objectToQuery(ag)}}if(ah==b){ah="application/json"}var al=r(aj);if(!al){return}if(ah&&al.overrideMimeType){al.overrideMimeType(ah)}al._url=aj;var e=B;J[B]=al;B++;if(af){al.onerror=function(){delete J[e];if(ai==b||this.FSIaborted){return}p.logLoadFileFailed(this)};al.onload=function(){delete J[e];if(ai==b||this.FSIaborted){return}var ao=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var ap=new ActiveXObject("Microsoft.XMLDOM");ap.async=false;ap.loadXML(ao);ao=this.responseXML=ap}catch(aq){E.log("Failed parsing XML using Microsoft.XMLDOM");E.log(aj)}break;case"application/json":ao={};try{ao=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ao=this.responseText}ai(this,ao,an)}}else{al.onreadystatechange=function(ao){var ap;if(al.readyState!=4){return}delete J[e];if(ai==b||this.FSIaborted){return}if(this.status>299){p.logLoadFileFailed(this)}switch(ah){case"application/xml":case"text/xml":ap=this.responseXML;break;case"application/json":ap={};try{ap=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ap=this.responseText}ai(this,ap,an)}}al.open(am,aj,true);if(ak&&y){al.setRequestHeader("x-token",y)}if(ag){al.setRequestHeader("Content-type","application/x-www-form-urlencoded");al.send(ag)}else{al.send()}return al};this.onConfigXMLLoaded=function(e,ag){p.logXMLResponseOK(e.response);p.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(ag){if(p.nextConfigURL==b){p.finalCheck();return}var ah={};if(g.bPreventCaching||p.makeBool(p.cfg.debug)||(!ag&&!p.makeBool(p.cfg.configcaching,true)&&p.makeBool(p.cfg.enableconfigcachingparameter))){p.addNoCacheParams(ah)}p.finishRequestParams(ah);var e=p.addURLParameters(p.nextConfigURL,ah);E.log("Loading config file: "+e);p.loadFile(e,p.onConfigXMLLoaded,"application/xml")};this.parseFloatPercentDef=function(ai,ah,ag,e){if(ai==b||ai.length<1){return ag}return Math.max(e,p.parseFloatPercent(ai,ah))};this.parsePercentDef=function(ah,e){if(ah==b||ah.length<1){return e}var ag=parseFloat(ah);if(isNaN(ag)){ag=0}else{if(ah.indexOf("%")!=-1){ag/=100}}return ag};this.parseFloatPercent=function(ah,ag){var e=parseFloat(ah);if(isNaN(e)||e<0){e=0}else{if(ah.indexOf("%")!=-1){e=Math.round(e*ag/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){d=e+"> "};this.setDebugger=function(e){E=p.debug=e};this.checkDebug=function(ah){if(g.bNoDebug){return}var ag;var e;if(p.parameters.debug!=b){e=p.makeBool(p.parameters.debug)}else{e=p.makeBool(p.cfg.debug)}if(e){if(!E||!E.on){E=p.debug=new a.Debugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}else{if(!E||E.on===true){E=p.debug=new a.EmptyDebugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}return ag};this.onConfigLoaded=function(ag){o=p.nextConfigURL;p.parseConfig(ag);o=b;p.elevateToHTTPS();if(p.checkDebug(true)==true){return}f();if(h&&g.bCaptureDefaultCfg){h=false;p.cfgFromDefaultConfig=a.cloneValue(p.cfg)}var e;if(p.cfg.includeconfig!=b&&p.nIncludedConfigs<10){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.includeconfig));p.nIncludedConfigs++;p.cfg["_includeconfig("+p.nIncludedConfigs+")"]=p.cfg.includeconfig;p.cfg.includeconfig=b}else{if(p.cfg.cfg!=b){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.cfg))}}if(e!=b&&!p.completedConfigs[e]){p.completedConfigs[e]=true;p.nextConfigURL=e;p.loadNextConfig()}else{p.evaluateQuery(p.queryParameters,p.cfg);p.finalCheck()}};this.elevateToHTTPS=function(){if(!a.bHTTPS){return}if(!p.makeBool(p.cfg.autoelevatetohttps,true)){return}k("fpxbase");k("fpxserver")};var k=function(e){if(p.cfg[e]!=b&&p.cfg[e].length>0&&p.cfg[e].indexOf("http://")==0){p.cfg[e]="https"+p.cfg[e].substr(4)}};this.evaluateQuery=function(ag,e){for(var ah in ag){p.setConfigParamByValue(e,ah.toLowerCase(),ag[ah])}};this.parseConfig=function(ag,ah){var aq="";var ak;var am=false;if(ag!=b){if(ah===b){ah=ag.firstChild}if(ah&&ah.nodeName=="xml"){ah=ah.nextSibling}var ap=ah.childNodes;for(var al=0;al<ap.length;al++){var aj=ap[al];if(aj.nodeType!=1){continue}var an;if(aj._myTagName!==b){an=aj._myTagName}else{an=aj.nodeName.toLowerCase()}aq=an;var ai=aj.childNodes;am=false;switch(an){case"licence":break;case"if":p.arConditions.push(aj);break;case"plugins":for(ak=0;ak<ai.length;ak++){p.parsePluginNode(ai[ak])}break;case G:am=true;case"info":case"options":aq=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ak=0;ak<ai.length;ak++){var ao=ai[ak];if(ao.nodeType!=1){continue}if(ao.tagName==="if"){ao._myTagName=an;p.arConditions.push(ao)}else{var e=p.getValueFromXMLNode(ao,aq);if(aq===b&&W){if(am){p.setConfigParam(W,e,null,true);p.setConfigParam(p.cfg,e,ao)}else{if(W[e.name]===b){p.setConfigParam(p.cfg,e,ao)}}}else{p.setConfigParam(p.cfg,e,ao)}}}break;default:p.arUnrecognizedConfigNodes.push(aj)}}}};this.getData=function(){var e={};e.cfg={};for(var ag in p.cfg){e.cfg[ag]=p.cfg[ag]}return e};this.setData=function(e){if(!e||!e.cfg){return}p.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var ag in e){p.cfg[ag]=e[ag]}P()};this.getImagesNodeList=function(ah){var e=[];if(ah==b){ah=p.getUnrecognizedConfigNode("images")}if(ah){var ai=ah.firstChild;while(ai){if(ai.nodeType==1){var ag={};ag.attributes={};I(ai,ag.attributes);ag.cfg={};p.parseConfigFragment(ai,ag.cfg);e.push(ag)}ai=ai.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){p.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ai){var e;ai=ai.toLowerCase();for(var ag=p.arUnrecognizedConfigNodes.length-1;ag>-1;ag--){var ah=p.arUnrecognizedConfigNodes[ag];if(ah&&ah.nodeName.toLowerCase()==ai){e=ah;break}}return e};this.parseConfigFragment=function(ag,am,al){var aq="";if(ag!=b&&am!=b){if(al==b){al=[]}var ap=ag.childNodes;for(var ak=0;ak<ap.length;ak++){var ai=ap[ak];if(ai.nodeType!=1){continue}var an=ai.nodeName.toLowerCase();aq=an;var ah=ai.childNodes;switch(an){case"info":case"options":aq=b;case"fpx":case"image":case"include":for(var aj=0;aj<ah.length;aj++){var ao=ah[aj];if(ao.nodeType!=1){continue}var e=p.getValueFromXMLNode(ao,aq);p.setConfigParam(am,e,ao)}break;default:al.push(ai)}}}};this.findXMLNode=function(ag,e){if(ag==b||ag.nodeType==b){return b}while(ag){if(ag.nodeName.toLowerCase()==e){break}if(ag.firstChild!=b){ag=ag.firstChild}else{if(ag.nextSibling!=b){ag=ag.nextSibling}else{ag=ag.parentNode.nextSibling}}}return ag};this.getValueFromXMLNode=function(ah,e){if(!ah||ah.nodeType!=1){return}var ag={};var ai=(e)?e:"";ag.name=ai+ah.nodeName.toLowerCase();var aj=ah.getAttribute("value");if(aj){ag.value=aj;return ag}ag.value=p.XMLChildNodesToString(ah);ag.node=ah;return ag};this.getXMLNodeAttribute=function(ai,ah,e){if(!ai||ai.nodeType!=1||!ai.getAttribute){return e}var ag=ai.getAttribute(ah);if(ag==b||ag==null){ag=e}return ag};this.XMLChildNodesToString=function(ah,ag){if(!ah||!ah.firstChild){return""}var e="";if(ah.childNodes.length===1&&ah.firstChild.nodeType==3){e=ah.firstChild.nodeValue}else{e=p._XMLChildNodesToString(ah)}if(ag!==b){e=e.replace(/[\x00-\x1f]/g,ag)}return e};this.hasPlugin=function(e){return(p.plugins&&p.plugins[e]!=b)};this.getPluginParameter=function(al,ag,e,ak,am){al=al.toLowerCase();ag=ag.toLowerCase();if(p.plugins[al]==b){E.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+al+"."+ag);return e}var aj;var ai=al+"_"+ag;if(am&&p.cfg[ai]==b){ai=ag}if(p.cfg[ai]!=b){aj=p.cfg[ai]}else{if(W&&W[ag]!==b&&G==="pages"){aj=W[ag]}else{var ah=p.plugins[al].parameters;if(ah!=b&&ah[ag]!=b){aj=ah[ag]}}}if(aj==b){aj=e}if(ak){aj=p.makeBool(aj,e)}return aj};var L=this.getAllPluginParameters=function(ag){ag=ag.toLowerCase();var ah=a.cloneObject(p.plugins[ag].parameters);var aj=ag+"_";var e=aj.length;for(var ak in p.cfg){if(ak.toLowerCase().indexOf(aj)==0){var ai=ak.substr(e);ah[ai]=p.cfg[ak]}}return ah};this.getIntParameterMinMax=function(ag,ah,e,ai){return Math.min(ai,Math.max(e,p.getIntParameter(ag,ah)))};this.getIntParameter=function(ag,ah){var e=parseInt(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getStringParameter=function(ag,ah){var e=p.cfg[ag.toLowerCase()];if(e==b){e=ah}return e};this.getFloatParameter=function(ag,ah){var e=parseFloat(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getRGBAValue=function(ag){var e={};if(ag==b){ag=""}if(ag.charAt(0)=="#"){ag=ag.substr(1)}if(ag.length>8){ag=ag.substr(0,8)}if(ag.length>5){e.webColor="#"+ag.substr(0,6);e.red=parseInt(ag.substr(0,2),16);e.green=parseInt(ag.substr(2,2),16);e.blue=parseInt(ag.substr(4,2),16);if(ag.length<7){e.alpha=255}else{e.alpha=parseInt(ag.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};var I=function(ak,ag){if(!ak||!ak.attributes||!ak.attributes.length||!ag){return false}var ah=ak.attributes;for(var aj=0;aj<ah.length;aj++){var e=ah[aj];var ai=e.nodeName.toLowerCase();ag[ai]=e.value}return true};this.parsePluginNode=function(ah){if(ah.nodeType!=1){return}var aj={};I(ah,aj);var ai=ah.childNodes;for(var e=0;e<ai.length;e++){var ak=ai[e];if(ak.nodeType!=1){continue}var ag=p.getValueFromXMLNode(ak);if(ag.value!=b){aj[ag.name]=ag.value;if(ag.node!=b){aj[ag.name+".node"]=ag.node}}}this.addPluginFromString(aj.src,aj)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.clone=function(){var e=new a.Config(Z,z,g);e.init();e.cfg=a.cloneObject(p.cfg);e.plugins=a.cloneObject(p.plugins);e.arPlugins=a.cloneArray(e.arPlugins);e.arUnrecognizedConfigNodes=a.cloneArray(e.arUnrecognizedConfigNodes);e.setImageQueryParameters(V);e.locales=a.cloneObject(p.locales);e.arConditions=a.cloneArray(p.arConditions);e.hasImageParameterConditions=p.hasImageParameterConditions;return e};this.setImageQueryParameters=function(e){V=a.cloneObject(e)};this.addPluginsFromString=function(ah){if(ah==b||ah.split==b||ah.length<1){return}var e=ah.split(",");for(var ag=0;ag<e.length;ag++){var ai=p.trimString(e[ag]);p.addPluginFromString(ai)}};this.addPluginFromString=function(ai,aj){if(ai==b||ai.length<1){E.error("PLUGIN without src parameter:");return}ai=ai.toLowerCase();if(M[ai]!=b){ai=M[ai]}if(aj==b){aj={}}var ag=p.plugins[ai]={};ag.name=ai;if(aj.src===b){aj.src=ai}if(p.pluginDefaultParameters[ai]!=b){ag.parameters={};p.cloneParameters(p.pluginDefaultParameters[ai],ag.parameters);p.cloneParameters(aj,ag.parameters)}else{ag.parameters=aj}if(c){for(var ak in c){if(ak.indexOf(ai+"_")===0){var ah=ai+"_";var e=ak.substr(ah.length);if(typeof(ag.parameters[e])!=="undefined"){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log(ag.parameters[e]);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}else{if(ak===ai){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log("(enabled)");p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ag,ah,e){p.setConfigParam(ag,{name:ah.toLowerCase(),value:e})};var O=function(ag){if(ag.nodeType!==1){return"<unknown>"}var e=p.XMLSerializer.serializeToString(ag.cloneNode(false));e=e.replace(/\/>$/gi,">");return e};this.setConfigParam=function(ai,e,aj,ak){var am=e.name;var ao=e.value;if(am==b){return}if(c){for(var an in c){if(an===am&&!ak){if(typeof(aj)==="object"&&typeof(aj.tagName)==="string"){var al;if(o){al=o}var ah=aj.parentNode;var ag=[];while(ah){if(ah.tagName==="if"){al="Matched Condition"}ag.unshift(O(ah));ah=ah.parentNode}ag.shift();ag.shift();p.iTraceParameterDebug.group(al);p.iTraceParameterDebug.log(ag.join(" "));p.iTraceParameterDebug.log(aj);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}else{p.iTraceParameterDebug.group("By Parameter/Attribute:");p.iTraceParameterDebug.log(ao);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}if(p.cfgAliasNames[am]!=b){am=p.cfgAliasNames[am]}if(ai[am]!=b&&(typeof(ao)=="string"&&a.BoolTable[ao.toLowerCase()]==false)&&a.BoolTable[ai[am]]==b){delete ai[am]}else{switch(am){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ai[am]!=b&&ai[am].length>0&&ai[am].indexOf(ao)==-1){ai[am]+=","+ao}else{ai[am]=ao}break;case"plugins":p.addPluginsFromString(ao);break;case"fpxpath":ai[am]=ao;ai.fpxsrc=encodeURIComponent(ao);break;default:ai[am]=ao;if(e.node!=b){ai[am+".node"]=e.node}}}};var n={};n["="]=function(ag,e){return(ag.toLowerCase()==e.toLowerCase())};n["=="]=function(ag,e){return(ag==e)};n["!="]=function(ag,e){return(ag.toLowerCase()!=e.toLowerCase())};n["!=="]=function(ag,e){return(ag!=e)};n["<"]=function(ag,e){return(ag<e)};n["<="]=function(ag,e){return(ag<=e)};n[">"]=function(ag,e){return(ag>e)};n[">="]=function(ag,e){return(ag>=e)};n.match=function(ah,ag){var ai=false;var ak="g";if(ag.charAt(0)==="/"&&ag.lastIndexOf("/")>0){var aj=ag.split("/");aj.shift();ak=aj.pop();ag=aj.join("/")}try{var al=new RegExp(ag,ak);ai=(ah.match(al)!==null)}catch(am){E.error("Invalid regex in condition: "+ag)}return ai};n.notmatch=function(ag,e){return !n.match(ag,e)};var u={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var w=function(ag,ah){if(p.cfgAliasNames[ah]){ah=p.cfgAliasNames[ah]}var e=p.cfg[ah];if(e==b){e=""}if(!p.hasImageParameterConditions){p.hasImageParameterConditions=(T[ah]!==b)}return D(ag,ah,e)};var H=function(ai,aj){var e=false;var ah;var ag=ai.getAttribute("value");switch(aj){case"@mobile":ag=p.makeBool(ag,true);ah=a.isMobileDevice;break;case"@devicepixelratio":ah=a.getDevicePixelRatio();break;case"@navigatoruseragent":ah=navigator.userAgent;break;case"@navigatorlanguage":ah=navigator.language;break;case"@navigatorplatform":ah=navigator.platform;break}if(ah!==b){if(typeof(ag)!=="string"){ag=""+ag}if(typeof(ah)!=="string"){ah=""+ah}e=D(ai,aj,ah,ag)}return e};var D=function(ai,ah,ak,aj){var am;var ag=ai.getAttribute("operator");if(typeof(ag)!=="string"){ag="="}ag=ag.toLowerCase();if(u[ag]){ag=u[ag]}if(n[ag]===b){ag="="}if(aj===b){aj=ai.getAttribute("value")}if(aj===null){aj=""}var e=n[ag];if(ag.match(/[<,>]+/)){var an=function(ao){ao=parseFloat(ao);if(isNaN(ao)){am=false}return ao};ak=an(ak);aj=an(aj)}else{ak=decodeURIComponent(ak)}if(am===b){am=e(ak,aj)}if(E.on){E.log("Evaluating condition: "+ah+": "+ak+" "+ag+" "+aj+" => "+am)}if(am===true){if(ai._myTagName!==b){var al={};al.nodeType=1;al.tagName=ai._myTagName;al.childNodes=[ai];ai=al}p.parseConfig(ai,ai)}return am};var T={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var U={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var S;var N=function(){if(S===b){S={};for(var e in T){S[T[e]]=e}}return S};var s=function(aj,ai,ah){if(ah===b){ah=""}var al=ah+"left";if(aj[al]===b){return}var ak=ah+"top";var ag=ah+"right";var e=ah+"bottom";if(ai==="pixelrange"){aj[ag]=aj[ag]-aj[al];aj[e]=aj[e]-aj[ak]}aj[ai]=aj[al]+","+aj[ak]+","+aj[ag]+","+aj[e];if(aj[al]){delete aj[al]}if(aj[ak]){delete aj[ak]}if(aj[ag]){delete aj[ag]}if(aj[e]){delete aj[e]}};var ad=this.mapImageParametersToViewer=function(e){s(e,"rect");s(e,"pixelrange","pixel");var ag=N();e=X(e,N())};var ac=this.mapImageParametersToServer=function(e){X(e,T)};var X=function(ag,e){for(var ah in ag){if(e[ah]&&ah!==e[ah]){ag[e[ah]]=ag[ah];delete ag[ah]}}};this.reWriteImageURLByConditions=function(am){if(p.arConditions.length<1){return am}if(typeof(am)!=="string"||am.length<1){return am}var ah=am.indexOf("?");if(ah===-1){return am}var ag=p.clone();var aj={};p.parseQuery(am,aj);ad(aj);p.evaluateQuery(aj,ag.cfg);var e=ag.evaluateConditions();if(!e){return am}var al;for(al in aj){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}for(al in U){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}ac(aj);var ai=am.substr(0,ah);var ak=ai+"?"+p.objectToQuery(aj);return ak};var q=this.applyConditions=function(){if(p.arConditions.length<1){return}if(p.cfgBeforeConditions===b){p.cfgBeforeConditions=a.cloneObject(p.cfg)}p.cfg=p.cfgBeforeConditions;return j()};var aa=0;var j=this.evaluateConditions=function(){if(p.arConditions.length<1){return false}var ag=false;for(var ah=aa;ah<p.arConditions.length;ah++){var ai=p.arConditions[ah];if(ai.fsiConfigEvaluated){continue}aa++;var aj=ai.getAttribute("parameter");if(typeof(aj)==="string"){aj=aj.toLowerCase();var e;if(aj.charAt(0)==="@"){e=H(ai,aj)}else{e=w(ai,aj)}if(!ag&&e){ag=e}}}return ag};var P=function(){q();p.serverProfile=p.cfg.fpxservertemplate;p.serverProfileDoublePage=p.cfg.fpxservertemplatedoublepage;if(p.serverProfileDoublePage==b){p.serverProfileDoublePage="doublepage"}p.serverBase=p.cfg.fpxserver;if(p.serverBase==b){E.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+p.locationFSIViewer+")");var ag;ag=p.locationFSIViewer.indexOf("/users/");if(ag!=-1){p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}else{ag=p.locationFSIViewer.indexOf("/viewer/");p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}E.log("Derived server location is: ["+p.serverBase+"]")}p.requestBase=p.serverBase;V={};var e=p.cfg;for(var ah in U){if(e[ah]!==b){V[ah]=e[ah]}}if(V.fpxsrc!==b){V.fpxsrc=decodeURIComponent(V.fpxsrc)}e=p.cfg.effects;if(e!=b){p.cfg.effectsUnFiltered=e;p.cfg.effects=e=m(e)}if(e!=b){V.effects=e}e=p.cfg.lefteffects;if(e!=b){V.lefteffects=e}e=p.cfg.righteffects;if(e!=b){V.righteffects=e}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){p.setEffectsFilter(p.getAreaEffects())};this.setEffectsFilter=function(ai){if(typeof(ai)!=="string"||ai.length<1){Q=false;return}ai=a.trim(ai);var ag=ai.split(",");for(var ah=0;ah<ag.length;ah++){ag[ah]=a.escapeRegEx(ag[ah])}var e="(^|[=,]+)("+ag.join("|")+")\\([^)]*\\)";Q=new RegExp(e,"ig")};var m=function(e){if(Q===false){return e}return e.replace(Q,"")};var l=function(){for(var ag in p.plugins){var ah=ag.toLowerCase();var e=p.makeBool(p.cfg[ah],true);if(!e){p.plugins[ag]=b}}};this.finalCheck=function(){p.elevateToHTTPS();l();P();p.dumpConfig();if(z.onConfigsReady){z.onConfigsReady()}};this.dumpConfig=function(ah){if(!ah){ah=E}if(ah.on){if(p.cfg.fpxsrc!==b){p.cfg["fpxsrc (decoded)"]=decodeURIComponent(p.cfg.fpxsrc)}ah.info("Evaluated Configuration:",K(p.cfg));if(p.queryParameters){ah.info("Parameters:",K(p.queryParameters))}if(W){ah.info("Class <"+v+"> Configuration:",K(W))}var ag=p.getPluginsAndParameters();var e=ag.data;if(ag.count===0){e="No active plugins."}ah.info("Plugin Configuration:",K(e))}};var K=function(ah){var e="--- none ---";if(typeof(ah)!=="object"){return e}for(var ag in ah){e=ah;break}return e};this.getPluginsAndParameters=function(){var e={};var ah=0;for(var ag in p.plugins){if(p.hasPlugin(ag)){e[ag]=L(ag);ah++}}return{count:ah,data:e}};var F=this.addQueryParameterToURL=function(ai,e,ah){var ag=ai.lastIndexOf("?");if(ag===-1){ai+="?"}else{if(ag!==ai.length-1){ai+="&"}}return ai+encodeURIComponent(e)+"="+encodeURIComponent(ah)};var ae=p.finishURL=function(e){if(y){e=F(e,x,y)}if(!R||e==b){return e}var ag;if(C===false){ag="cache=0&cachernd="+t;if(e.indexOf("?")==-1){e+="?"+ag}else{e+="&"+ag}}else{ag=C;if(e.indexOf("?")==-1){e+="?"+ag}else{e+=ag}}return e};this.addURLParameters=function(ag,ah){if(!ag||!ah){return ag}var e=[];for(var ai in ah){e.push(encodeURIComponent(ai)+"="+encodeURIComponent(ah[ai]))}if(e.length>0){if(ag.indexOf("?")==-1){ag+="?"}else{ag+="&"}ag+=e.join("&")}return ag};this.finishRequestParams=function(ag){if(R){if(C===false){ag.cache=0;ag.cachernd=t}else{for(var e in A){ag[e]=A[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=t};this.parseQuery=function(ag,e){if(e==b||ag==b||ag.length<1){return}p.queryToObject(ag,e);if(e.ignorequeryparameters!=b){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=b){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,ag){if(e==b||ag==b){E.error("Cloning object failed: "+e+" / "+ag)}for(var ah in e){ag[ah]=e[ah]}};this.getFSIPath=function(e,ag){if(ag.indexOf("//")!=-1){return ag}if(p.cfg.fsibase!=b){ag=p.cfg.fsibase+ag}return p.getReloadPath(e,ag)};this.expandFSIPath=function(ag){if(ag==b){return ag}var e=a.urlDecode(ag);if(e.indexOf("?")!=-1||e.indexOf(p.strConfigFileExtension)==(e.length-4)){return ag}return ag+p.strConfigFileExtension};this.getReloadPath=function(ai,ak){var ag,al,e,aj;if(ai==b){ai=p.locationFSIViewer}if(ak==b){ak=""}var ah="/";if(ak.indexOf("//")!=-1){return ak}ag=ai;aj=ag.lastIndexOf("?");if(aj==-1){aj=ag.length}al=ag.lastIndexOf("\\",aj);e=ag.lastIndexOf("/",aj);al=Math.max(al,e);if(al==-1){al=ag.length-1}ag=ag.slice(0,al);if(ag.length>0&&ak.indexOf(ah)!=0){ag+=ah}return ag+ak};this.cloneValueObject=function(ag){var e={};for(var ah in ag){e[ah]=ag[ah]}return e};this._getXMLConfigValue=function(e){var ag;if(!e){return}if(e.childNodes.length>0){ag=p._XMLChildNodesToString(e)}else{ag=e.getAttribute("value")}return ag};this._XMLChildNodesToString=function(ai){if(!ai||!ai.firstChild){return""}var ag="";var ah;try{if(ai.xml!=b){for(ah=0;ah<ai.childNodes.length;ah++){ag+=ai.childNodes[ah].xml}}else{for(ah=0;ah<ai.childNodes.length;ah++){ag+=p.XMLSerializer.serializeToString(ai.childNodes[ah])}}}catch(aj){}return ag};this._findFirstXMLNode=function(ah,ai){var ag,e;while(ah){if(ah.nodeName==ai){e=ah;break}ag=ah.firstChild;if(!ag){ag=ah.nextSibling}if(!ag&&ah.parentNode){ag=ah.parentNode.nextSibling}ah=ag}return e};this._parseXMLImageList=function(ag){var e=p._findFirstXMLNode(ag,"images");if(!e){e=p._findFirstXMLNode(ag,"images3d")}return p.parseXMLImageListNode(e)};this._parseXMLImageListNode=function(aj){var am={};var e=am.arImages=[];var ai="";var ak="";var ah;if(!aj){return am}var ag;ag=p.getAttributeValue(aj,"prefix");if(typeof(ag)=="string"){ai=ag}ag=p.getAttributeValue(aj,"suffix");if(typeof(ag)=="string"){ak=ag}aj=p._findFirstXMLNode(aj,"image");if(!aj){return am}while(aj){if(aj.nodeType==1){ah=p._findFirstXMLNode(aj,"path");var al=p._getXMLConfigValue(ah);if(!al){al=a.urlDecode(p.getAttributeValue(aj,"src"))}if(!al){al=a.urlDecode(p.getAttributeValue(aj,"file"))}if(al!=b){e.push(ai+al+ak)}if(am.width==b){ah=p._findFirstXMLNode(aj,"width");ah=p._getXMLConfigValue(ah);if(ah!=b){am.width=parseInt(ah)}ah=p._findFirstXMLNode(aj,"height");ah=p._getXMLConfigValue(ah);if(ah!=b){am.height=parseInt(ah)}}}aj=aj.nextSibling}return am};this.getImageList=function(){var e,ai;if(p.cfg&&p.cfg.fpxsources!=b){var ah=p.cfg.fpxsources;if(typeof(ah)=="string"||(typeof(ah)=="object")&&typeof(ah.push)=="function"){e={};e.oXML=null;if(typeof(ah)=="string"){e.arImages=ah.split(",");for(ai=0;ai<e.arImages.length;ai++){e.arImages[ai]=a.urlDecode(e.arImages[ai])}}else{e.arImages=ah}return e}}if(p.arUnrecognizedConfigNodes&&p.arUnrecognizedConfigNodes.length>0){var ag=p.arUnrecognizedConfigNodes;for(ai=0;ai<ag.length;ai++){var aj=ag[ai];if(typeof(aj.nodeName)=="string"){var ak=aj.nodeName.toLowerCase();if(ak=="images"||ak=="images3d"){if(E.on){E.log("Reading image list from XML node: <"+aj.nodeName+">")}e=p._parseXMLImageListNode(aj);e.oXML=aj;break}}}}if(p.cfg&&p.cfg.fpxsrc!=b){e={};e.oXML=null;e.arImages=[];e.arImages.push(a.urlDecode(p.cfg.fpxsrc));return e}return e};this.getServerBase=function(){return p.serverBase};this.loadImageList=function(ai,aj,al,ak){if(!p.serverBase||!ai){aj([],b,ak);return false}var ah=p.serverBase+"?type=list";if(ai.indexOf("tpl")==-1){var ag=p.cfg.listtemplate;if(ag&&ag.length>0&&ag.indexOf(".json")==-1&&ag.indexOf(".xml")==-1){ag+=".json"}ah+="&tpl="+ag}if(p.cfg.headers&&p.cfg.headers.length>0&&A.headers==b){ah+="&headers="+p.cfg.headers}if(typeof(p.cfg.imagelistlimit)==="string"&&p.cfg.imagelistlimit.length>0){ah+="&limit="+encodeURIComponent(p.cfg.imagelistlimit)}ah+="&source="+encodeURIComponent(ai);if(al!=b){ah+=al}ah=ae(ah);var e=p.loadFile(ah,function(am,ap){if(typeof(ap)=="object"&&typeof(ap.images)=="object"){ap.images.pop();var aq="";if(ap&&ap.imagesattributes&&ap.imagesattributes.dir){aq=ap.imagesattributes.dir}var an=new Array(ap.images.length);for(var ao=0;ao<ap.images.length;ao++){an[ao]=aq+ap.images[ao].src}aj(an,ap,ak)}else{aj([],ap,ak)}},"application/json",ak);return e};this.traceConfigValue=function(e,ai){if(typeof(e)!=="string"){return false}e=a.trim(e);if(e.length<1){return false}var ag=e.toLowerCase();if(ag.indexOf(".")!==-1){ag=ag.split(".").join("")}if(ag.indexOf("/")!==-1){ag=ag.split("/").join("")}if(ag.indexOf(" ")!==-1){ag=ag.split(" ").join("")}var ah=new a.Debugger();ah.setPrefix("");ah.group('Tracing parameter "'+e+'"');var aj=function(){var ak=e;var ap=p.getParameterAlias(ag);if(typeof(ap)==="string"){ak+=" (alias: "+ap+")";if(typeof(p.cfgAliasNames[ag])==="string"){ag=p.cfgAliasNames[ag]}}var al=p.cfg[ag];var ao=true;if(ag.indexOf("_")!==-1){var an=ag.split("_");var am=an.shift();var aq=an.join("_");if(p.hasPlugin(am)){al=p.getPluginParameter(am,aq)}}else{if(p.hasPlugin(ag)){ao=false;al="is enabled."}}if(al===b){ao=false;al="is undefined (default value applies)"}if(ao){al='= "'+al+'"'}ah.group("RESULT:");ah.log(ak+" "+al);ah.groupEnd();ah.groupEnd()};z={onConfigsReady:aj};g.strTraceParam=ag;g.bNoDebug=true;p.iTraceParameterDebug=ah;p.init(ai);p.loadConfigs();return""};this.loadLanguageFile=function(e,aq,aj,ah){var ak=arguments;var al,ao;if(typeof(aq)!=="string"||p.makeBool(aq,true)==false){return aj.call(p,{},"")}var ap=function(ar){try{a.oLanguageMap=JSON.parse(ar.responseText)}catch(at){a.oLanguageMap={"default":"english"}}p.loadLanguageFile.apply(this,ak)};var am=function(ar,av){e.urlLanguageCurrentLoaded=al;var au=e.oLanguageData={};if(av){var at=p.findXMLNode(av,"data");if(at){at=p.findXMLNode(at,"tip")}while(at){if(at.nodeType===1){var aw=at.getAttribute("id");au[aw]=p.XMLChildNodesToString(at)}at=at.nextSibling}}aj.call(p,e.oLanguageData,ao)};if(aq.toLowerCase()==="auto"){if(!a.oLanguageMap){p.loadFile(a._FSIViewerLocation+"/languages/mapping.json",ap,"application/json");return}if(a.oLanguageMap._current!==b){aq=a.oLanguageMap._current}else{aq=a.oLanguageMap["default"];var ai=navigator.language;if(typeof(ai)==="string"){ai=ai.toLowerCase()}if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}else{if(ai.indexOf("-")!=-1){ai=ai.split("-")[0];if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}}}}if(aq==b){return aj.call(p,{},"")}if(ah){ah.log('Automatically choosing language "'+aq+'" from navigator.language "'+navigator.language+'"')}a.oLanguageMap._current=aq}var an=aq+".xml";var ag=a._FSIViewerLocation+"/languages/"+an;if(ag!==e.urlLanguageCurrentLoaded){ao=aq;al=ag;if(ah){ah.log("Loading language file: "+ag)}p.loadFile(ag,am,"application/xml")}else{aj.call(p,e.oLanguageData,ao)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.callbackFunctionID++}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!=b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!=b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!=b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!=0||u!=0||v!=0||q!=0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!=-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!=-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!=b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!=b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRectByRefWidth=function(q){};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r==b&&u==b){r=i.width();u=i.height();A=1}else{if(r!=b){A=i.width()/r;if(u==b){u=i.height()/A}}else{A=i.height()/u;if(r==b){r=i.width()/A}}}if(z==b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left==0&&v.top==0&&v.width()==v._refWidth&&v.height()==v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left==0&&r.top==0&&r.width()==r._refWidth&&r.height()==r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,A){var B=new a.CroppedImage();var C,v;if(typeof(y)!="string"||y.length!=2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var z=p.isCropped();var q,D;var x,E;if(z){x=(1-h.left-h.right);E=(1-h.top-h.bottom);q=Math.round(x*c.width);D=Math.round(E*c.height)}else{q=c.width;D=c.height}if(u/q<s/D){v=s;C=Math.round(q/D*s);t=C-u;switch(y.charAt(1)){case"l":r.setRect(0,0,C-t,v);break;case"r":r.setRect(t,0,C,v);break;default:r.setRect(t/2,0,C-t/2,v)}}else{C=u;v=Math.round(D/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,C,v-t);break;case"b":r.setRect(0,t,C,v);break;default:r.setRect(0,t/2,C,v-t/2)}}r.scaleRectXY(1/C,1/v);if(p.isCropped()){C/=x;v/=E;if(A){C=Math.min(C,c.width);v=Math.min(v,c.height)}B.setSourceDimension(C,v);r.scaleRectXY(x,E);r.offsetRect(h.left,h.top)}else{if(A){C=Math.min(C,c.width);v=Math.min(v,c.height)}B.setSourceDimension(C,v)}B.widthUncropped=C;B.heightUncropped=v;B.setCropRect(r.left,r.top,r.right,r.bottom);return B}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomSkinClass!==b){return}a.CustomSkinClass=function(i,m,f,j){var q=this;var l;var o;var g;var k;var n=f.getCallbacks();var d=this.paramCustomSkinClass=m;var c;var p=function(){l=f.getRootContainer();o=f.getParentElement();q.destroy();c=a._FSIViewerLocation+"/skins/";if(typeof(m)==="string"){if(m.match(/\.js$/)){var r=a._FSIViewerLocation+"/"+m;c=r;c=c.replace(/\/[^/]*$/,"/");a.loadJavascript(r,f.getInstanceID(),q,e)}else{if(typeof(window[m])==="function"){k=new window[m](i,o,h,q)}}}else{if(typeof(m)==="function"){k=new m(i,o,h,q)}}};this.getSkinPath=function(){return c};this.replacePaths=function(r){r=r.replace(/\[fsi-skin-path\]/g,c);r=r.replace(/\[fsi-viewer-path\]/g,a._FSIViewerLocation+"/");return r};this.loadHTMLFragment=function(s,v,t,r){s=q.replacePaths(s);var u=function(y,w,x){w=q.replacePaths(w);if(v&&typeof(v)==="object"&&v.tagName){while(v.firstChild){v.removeChild(v.firstChild)}v.innerHTML=w}t(w,r)};i.loadFile(s,u,"text/plain; charset=utf-8")};var h=function(s){g=s;if(s&&typeof(s)==="object"&&s.tagName){s.appendChild(l)}if(n.isset("onResize")){var r=f.getElementSpace();n.run("onResize",[r.width,r.height,true,f.getIsFullScreen()])}if(i.onResize){i.onResize({FSI_after_treshold:true})}j.apply(i)};var e=function(){d=d.replace(/\.js$/,"");var r=d.lastIndexOf("/");if(r!==1){d=d.substr(r+1)}if(d.length>0&&typeof(window[d])==="function"){k=new window[d](i,o,h,q)}else{h()}};this.getCustomSkinInstance=function(){return k};this.destroy=function(){if(k&&typeof(k.destroy)==="function"){k.destroy(q);k=b}if(g!==b){g=b;while(o.firstChild){o.removeChild(o.firstChild)}o.appendChild(l)}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Sprite!=b){return}a.Sprite=function(k,i,t,o,s,m,f){var n=this;var c=0.075;var d;var e=true;var u;var j;var v=1;var l=n.margin={left:0,top:0,right:0,bottom:0};var r={};r.width=i;r.height=t;var p=(s)?"canvas":"div";d=n.element=document.createElement(p);d.setAttribute("draggable","false");if(f){d.className=f}var g="";switch(m){case"inline":break;default:g+="position:absolute;z-index:"+o}a.setStyleAttr(d,g);if(s){n.canvas=n.element;n.canvas.setAttribute("crossorigin","anonymous");n.canvas.setAttribute("width",r.width);n.canvas.setAttribute("height",r.height);n.ctx=n.canvas.getContext("2d")}if(k){k.appendChild(d)}this.remove=function(){if(k){a.removeChild(k,d)}};this.setPos=function(h,w){n.x=h;n.y=w;d.style.marginLeft=h+"px";d.style.marginTop=w+"px"};this.isVisible=function(){return(v>0)};this.show=function(h,w){if(e==h){return}e=h;if(j!=b){cancelAnimationFrame(j);j=b}if(!w){v=d.style.opacity=(h)?1:0;d.style.display=(h)?"block":"none"}else{u=(h)?c:-c;if(h){d.style.display="block"}q()}};this.updateMargins=function(){l=n.margin=a.getElementMargins(d)};this.getClientDim=function(){return a.getElementClientDim(n.element)};this.updateDimension=function(){r=a.getElementClientDim(d)};this.width=function(){return r.width};this.height=function(){return r.height};var q=function(){v+=u;if(u>0){if(v>=1){v=1;j=b}else{j=requestAnimationFrame(q)}}else{if(v<=0){v=0;j=b;d.style.display="none"}else{j=requestAnimationFrame(q)}}d.style.opacity=v};if(!s){this.setSize=function(x,y){r.width=x;r.height=y;if(typeof(x)!="string"){x+="px"}if(typeof(y)!="string"){y+="px"}n.element.style.width=x;n.element.style.height=y};this.clear=function(){}}else{this.setSize=function(x,y){r.width=x;r.height=y;n.canvas.width=x;n.canvas.height=y};this.clear=function(){n.ctx.clearRect(0,0,r.width,r.height)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ToolTip!=b){return}a.ToolTip=function(c){var q=this;var n;var h;var d;var m,l;var j;var k=false;var e={};var g=false;var i;var p=function(){n=document.createElement("div");a.addClass(n,"fsi-ui-tool-tip-container fsi-ui-tool-tip-container-hidden");h=document.createElement("div");a.addClass(h,"fsi-ui-tool-tip");n.appendChild(h);d=document.createElement("div");a.addClass(d,"fsi-ui-tool-tip-arrow");n.appendChild(d)};this.destroy=function(){q.hide();clearTimeout(j)};this.setContent=function(r){i=r};this.show=function(t,s,r,z,v,u,w){if(!i){return}e.strTip=t;e.elSrc=s;e.x=r;e.y=z;e.bNoAutoBold=w;e.fnGetToolTipText=v;if(l!=b){clearTimeout(l);l=b}if(m!=b){clearTimeout(m)}if(u==b){u=(k)?100:1000}m=setTimeout(f,u)};this.setParentContainer=function(r){q.hide();c=r};var f=function(){if(m!=b){clearTimeout(m);m=b}var w=e.strTip;var C,D;if(e.fnGetToolTipText!=b){D=e.fnGetToolTipText(w,i);if(D==b){D=i[w]}}else{D=i[w]}if(D!=b){w=D}else{if(!e.bNoAutoBold){w="<b>"+w+"</b>"}}h.innerHTML=w;c.appendChild(n);d.style.left="0px";n.style.display="inline-block";n.style.width=c.offsetWidth+"px";C=a.getElementClientPos(h);n.style.display="block";n.style.width=C.width+"px";var G=e.x;if(G==b){G=0}var F=e.y;if(F==b){F=0}var v;var u=a.getElementClientPos(c);if(e.elSrc!=b){v=a.getElementClientPos(e.elSrc);G+=v.left-u.left+(v.right-v.left)/2;F+=v.top-u.top}C=a.getElementClientPos(n);G-=C.width/2;F-=C.height+2;var t=document.body;var z=4;var E=G;var s=t.clientWidth;if(a.isMobileDevice){s=Math.max(t.clientWidth,u.width+u.left)}G=Math.min(s-u.left-C.width-z,Math.max(-u.left+z,G));var B=E-G;var r=d.offsetWidth/2;if(B!=0){var A=Math.min(n.offsetWidth/2-r,Math.abs(B));if(B<0){B=-A}else{B=A}}d.style.left=(n.offsetWidth/2-r+B)+"px";n.style.left=G+"px";n.style.top=F+"px";g=true;k=true;clearTimeout(j);j=setTimeout(o,1000);a.removeClass(n,"fsi-ui-tool-tip-container-hidden");a.addClass(n,"fsi-ui-tool-tip-container-visible")};var o=function(){k=false};this.hideAfter=function(r){if(r==b||isNaN(r)||r<1){r=2500}if(l!=b){clearTimeout(l);l=b}l=setTimeout(q.hide,r)};this.hide=function(){if(m!=b){clearTimeout(m);m=b}if(l!=b){clearTimeout(l);l=b}if(g){a.removeClass(n,"fsi-ui-tool-tip-container-visible");a.addClass(n,"fsi-ui-tool-tip-container-hidden");a.removeChild(c,n);g=false}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FullScreen!==b){return}a.FullScreen={};a.FullScreen.__initDone=false;a.FullScreen._nIDChangeEvent=0;a.FullScreen._nIDErrorEvent=0;a.FullScreen._eventHandlers={};a.FullScreen.__init=function(){var d=a.FullScreen;if(d.__initDone){return}d.__initDone=true;var c=0;if(document.webkitExitFullscreen){c=3}else{if(document.msExitFullscreen){c=1}else{if(document.mozCancelFullScreen){c=2}else{if(document.exitFullscreen){c=0}}}}switch(c){case 1:d.requestFullscreen="msRequestFullscreen";d.exitFullscreen="msExitFullscreen";d.fullscreenPseudoClass=":-ms-fullscreen";d.fullscreenChange="MSFullscreenChange";d.fullscreenError="MSFullscreenError";d.fullScreen="msFullscreenElement";d.fullscreenElement="msFullscreenElement";break;case 2:d.requestFullscreen="mozRequestFullScreen";d.exitFullscreen="mozCancelFullScreen";d.fullscreenPseudoClass=":-moz-full-screen";d.fullscreenChange="mozfullscreenchange";d.fullscreenError="mozfullscreenerror";d.fullScreen="mozFullScreen";d.fullscreenElement="mozFullScreenElement";break;case 3:d.requestFullscreen="webkitRequestFullscreen";d.exitFullscreen="webkitExitFullscreen";d.fullscreenPseudoClass=":-webkit-full-screen";d.fullscreenChange="webkitfullscreenchange";d.fullscreenError="webkitfullscreenerror";d.fullScreen="webkitIsFullScreen";d.fullscreenElement="webkitFullscreenElement";break;default:d.requestFullscreen="requestFullscreen";d.exitFullscreen="exitFullscreen";d.fullscreenPseudoClass=":fullscreen";d.fullscreenChange="fullscreenChange";d.fullscreenError="fullscreenError";d.fullScreen="fullScreen";d.fullscreenElement="fullscreenElement"}if(typeof(document[d.exitFullscreen])!=="function"){a.FullScreen.bUseFakeFullScreen=true}d.nMode=c};a.FullScreen.start=function(c){a.FullScreen.__init();a.FullScreen.quit();if(!a.FullScreen.bUseFakeFullScreen){c[a.FullScreen.requestFullscreen]()}else{a.FullScreen._enterFakeFullScreen(c)}};a.FullScreen.quit=function(){a.FullScreen.__init();if(!a.FullScreen._exitFakeFullScreen()&&!a.FullScreen.bUseFakeFullScreen){document[a.FullScreen.exitFullscreen]()}};a.FullScreen._enterFakeFullScreen=function(c){if(!c){return}var f=a.FullScreen.oFake={};f.elParentOriginal=c.parentNode;f.elNextSibling=c.nextSibling;f.el=c;var e,d;e=document.documentElement;f.docScrollLeft=e.scrollLeft;f.docScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;e=document.body;f.bodyScrollLeft=e.scrollLeft;f.bodyScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;d=f.bodyStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box";if(document.documentElement){e=document.documentElement;d=f.documentStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box"}a.FullScreen.bChanging=true;document.body.appendChild(c);a.FullScreen.bChanging=false;a.addEvent(window,"keydown",a.FullScreen._keyDown);a.FullScreen.callHandlers()};a.FullScreen._keyDown=function(c){if(c&&c.keyCode===27){a.FullScreen.quit()}};a.FullScreen._exitFakeFullScreen=function(){if(!a.FullScreen.oFake){return false}var f=a.FullScreen.oFake;a.FullScreen.bChanging=true;if(f.elParentOriginal){if(f.elNextSibling){f.elParentOriginal.insertBefore(f.el,f.elNextSibling)}else{f.elParentOriginal.appendChild(f.el)}}var e=document.body;var d=f.bodyStyle;var c;for(c in d){e.style[c]=d[c]}e.scrollLeft=f.bodyScrollLeft;e.scrollTop=f.bodyScrollTop;if(document.documentElement){e=document.documentElement;d=f.documentStyle;for(c in d){e.style[c]=d[c]}e.scrollLeft=f.docScrollLeft;e.scrollTop=f.docScrollTop}a.FullScreen.bChanging=false;a.FullScreen.oFake=b;a.FullScreen.callHandlers();a.removeEvent(window,"keydown",a.FullScreen._keyDown);return true};a.FullScreen.toggle=function(c){if(a.FullScreen.getEnabled()){a.FullScreen.quit()}else{a.FullScreen.start(c)}};a.FullScreen.getFullscreenPseudoClass=function(){a.FullScreen.__init();return a.FullScreen.fullscreenPseudoClass};a.FullScreen.addChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();a.FullScreen._nIDChangeEvent++;if(typeof(e)==="function"){if(!e._FSIFullScreenEventID){a.FullScreen._eventHandlers[a.FullScreen._nIDChangeEvent]=e;e._FSIFullScreenEventID=a.FullScreen._nIDChangeEvent}a.addEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.addEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.callHandlers=function(){var c={type:"fullscreenchange",FSI_fake:true};for(var e in a.FullScreen._eventHandlers){var d=a.FullScreen._eventHandlers[e];d(c)}};a.FullScreen.removeChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)==="function"){if(e._FSIFullScreenEventID&&a.FullScreen._eventHandlers[e._FSIFullScreenEventID]){delete a.FullScreen._eventHandlers[e._FSIFullScreenEventID]}a.removeEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.removeEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.getAvailable=function(d){a.FullScreen.__init();var c=d[a.FullScreen.requestFullscreen];return(c)};a.FullScreen.getEnabled=function(){a.FullScreen.__init();var c=a.FullScreen.getElement();return(c!==b&&c!==null)};a.FullScreen.getElement=function(){a.FullScreen.__init();var c;if(a.FullScreen.bUseFakeFullScreen){if(a.FullScreen.oFake){c=a.FullScreen.oFake.el}}else{c=document[a.FullScreen.fullscreenElement]}return c}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(n,aY,am,e,aO){var aF=this;var aM=false;var al=true;var p=false;var aU=false;var aL=false;var aC,F,j,ae;var aD,Z,aJ;var h=false;var af;var s;var a1={};var ar=[];var ad=0;var J=window;var aW;var t;var aV;var d;var a0=[];var aS={x:0,y:0};var w={x:0,y:0};var at=40;var o={};o.enabled=false;o.factor=5;o.fEndDiff=1;var az={};az.enabled=false;az.minFrames=14;az.factorAmount=23;az.factorAmountQuad=0;az.factorFrames=2.6;az.offsetFrames=5;var ac;var aA;var aI,x,l;var G;var au={};var Y;var aN=false;var A=false;var an={};an.name="none";var O;var X;var aP;var f=false;var aa={};if(!aY||typeof(aY)!="object"){aY={}}var ao=function(){var a7;if(aM){aF.destroy()}aV=B;t=b;if(a.topWindow!=window){t=a.topWindow;try{var a6=a.getWindowOffset(window);if(a6.x!=b&&a6.y!=b){aV=aq}}catch(a5){aV=B;t=b}}else{t=b}G=aY.oPassTrough;aX(aY.panDirectionAllowed,true);if(aY.getPageCoords){s=aG}else{s=N}if(aY.afterTouch){for(a7 in aY.afterTouch){az[a7]=aY.afterTouch[a7]}}if(az.minDelta==b){az.minDelta=15}if(aY.nClickRadius){ac=aY.nClickRadius}else{ac=10}if(az.fnStartStopAfterTouch&&typeof(az.fnStartStopAfterTouch)!="function"){az.fnStartStopAfterTouch=b}if(az.fnStartStopAfterTouch){az.useAnimationFrame=b}if(typeof(az.modifyTarget)!="function"){az.modifyTarget=b}if(typeof(az.fnGetAfterTouchEnabled)=="function"){aA=az.fnGetAfterTouchEnabled}else{aA=b}if(aY.smoothing){for(a7 in aY.smoothing){o[a7]=aY.smoothing[a7]}}if(aY.detectClick==true){Y=true}if(aY.preventSelection!==false){aY.preventSelection=true}if(!n){return}if(typeof(n.join)!="function"){n=[n]}if(typeof(am)!="function"){am=B}if(typeof(e)!="function"){e=B}if(typeof(aO)!="function"){aO=B}if(typeof(aY.onPinchChange)=="function"){O=aY.onPinchChange}else{O=b}aN=aY.detectGestures;a0=[];ay(true,aN);for(var a4=0;a4<n.length;a4++){var a3=n[a4];if(a3&&typeof(a3.nodeName)!="undefined"){a7={};a7.element=a3;a0.push(a7);ap(a3,S);if(a.isTouch){try{if(a3.style!=b){if(a.BrowserSupports.cssTouchAction()){if(au.cssTouchAction!=b){r(a3,au.cssTouchAction)}}}}catch(a5){}}}}if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aE,false)}};var aX=this.setAllowedPanDirection=function(a4,a3){if(typeof(a4)=="string"){if(a4=="pan-x"||a4=="pan-y"||a4=="pan-x pan-y"){aW=a4+" "}else{aW=""}}else{aW=""}if(!a3){au.nCheck=b;ai(au.captureScroll,au.capturePinch)}};this.enable=function(a3){if(al==a3){return}if(!a3){R();ai(false,false)}else{ai(au.captureScrollUser,au.capturePinchUser)}al=a3};this.getEnabled=function(){return al};this.cancel=function(){Q();ah();aK();R()};var aK=function(){if(o.enabled){i()}C()};this.cancelAfterTouch=function(){C()};this.getInitialDownEvent=function(){return X};var R=function(){if(!p){return}aK();p=false;X=b;A=false;if(ad==0){aQ()}};var aQ=function(){f=false;c()};this.destroy=function(){if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aE,false)}if(aP){clearTimeout(aP)}aF.cancel();var a3;for(var a4=0;a4<a0.length;a4++){var a5=a0[a4];a3=a5.element;y(a3,S)}au={}};var r=function(a3,a4){if(!a.BrowserSupports.cssTouchAction()||!a3||!a3.style){return}a3.style.touchAction=a3.style.msTouchAction=a4};var U=function(a3){if(a3.preventDefault){a3.preventDefault()}};var m=function(a3){U(a3);return false};var ap=function(a4,a3){a.addEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{a.addEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a4,"touchstart",a3);a.addEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a4,"MSPointerDown",a3)}a.addEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var y=function(a4,a3){a.removeEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{a.removeEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a4,"touchstart",a3);a.removeEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a4,"MSPointerDown",a3)}a.removeEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var B=function(){return true};var aR=function(a3){if(aL){W(a3,a3.pointerId)}else{var a4=a3.changedTouches;for(var a5=0;a5<a4.length;a5++){W(a4[a5],a4[a5].identifier)}}};var W=function(a3,a5){if(a5==b||a1[a5]!=b){if(aY.debug){if(a5==b){a.console.error("doRegisterPointer: no pointerId")}if(a1[a5]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a5)}}return}ad++;var a4=a1[a5]={};a4.identifier=a5;s(a4,a3);ar.push(a4)};var ak=function(a3){var a5=false;if(aL){a5=L(a3.pointerId)}else{var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){a5=L(a4[a6].identifier)}}}if(a5){ar=new Array(ad);var a8=0;for(var a7 in a1){ar[a8++]=a1[a7]}}};var L=function(a3){if(a3==b||a1[a3]==b){if(aY.debug){if(a3==b){a.console.error("doUnregisterPointer: no pointerId")}if(a1[a3]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+a3)}}return false}delete a1[a3];ad--;return true};var I=function(){ad=0;a1={};ar=[]};var N=function(a4,a3){a4.x=a3.clientX;a4.y=a3.clientY};var aG=function(a4,a3){a4.x=a3.pageX;a4.y=a3.pageY};var v=function(a3){var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){var a5=a1[a4[a6].identifier];if(a5){s(a5,a4[a6])}}}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y}};var ax=function(a3){var a4=a1[a3.pointerId];if(a4){s(a4,a3)}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y;aV(a3,aS)}};var V=function(a3){s(aS,a3);aV(a3,aS)};this.getMousePositionFromMouseEvent=function(a3){V(a3);return aS};this.getMousePositionPage=function(a4){var a3={};aG(a3,a4);aV(a4,a3);return a3};this.getMousePositionClient=function(a4){var a3={};N(a3,a4);aV(a4,a3);return a3};var u=function(a3,a4){if(window!=a3.view){var a5=a.getWindowOffset(window);a4.x-=a5.x;a4.y-=a5.y}};var aq=function(a3){try{u(a3);aV=u}catch(a4){aV=B}};var aB=function(a3){if(!al){return}var a5=ad;if(A&&a5==0){A=false}var a6=a3.type;if(p||an.started){if(a6!=aC){if(an.started){Q();ah()}else{a3._FSI_Canceled=true;a2(a3,true)}}}aC=a6;d=false;var a4=true;switch(a6){case"touchstart":aU=true;aL=false;af=v;j="touchmove";F="touchend";ae="touchcancel";aI=false;break;case"MSPointerDown":af=ax;aU=true;aL=true;j="MSPointerDown";F="MSPointerUp";ae="MSPointerCancel";aI=false;d=true;break;case"pointerdown":af=ax;aU=true;aL=true;j="pointermove";F="pointerup";ae="pointercancel";aI=true;d=true;break;default:if(ad>0){I()}aU=false;aL=false;aI=(aY.preventSelection);a4=false;af=V;j="mousemove";F="mouseup";ae=b;d=true}if(aU&&a4){aR(a3)}af(a3);if(!aY.bAllowMouseDown&&aI){U(a3)}if(ad>1){aa.bClick=false}x=false;if(a4&&aj(a3)){if(a5==0){C();E()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ad};var S=function(a3){if(aY.bMouseOnly&&a3.type==="pointerdown"&&a3.pointerType!=="mouse"){return true}if(!aB(a3)){return}if(p||a3.which>1){return}g(a3)};this.getCurrentPos=function(){return w};var g=function(a3){aK();if(p){return}az.evtMove=b;if(o.enabled){w={x:aS.x,y:aS.y}}else{w=aS}aa.x=aS.x;aa.y=aS.y;var a4=X;X=a3;if(!am.call(J,a3,w,G)){X=a4;return false}p=f=true;if(Y&&!A){aa.bClick=true;aa.clickRadiusX=aa.clickRadiusY=0}else{aa.bClick=false}E();if(az.enabled){az.x=az.y=0;az.lastX=aS.x;az.lastY=aS.y;if(az.nInterval){clearInterval(az.nInterval)}az.nInterval=setInterval(ab,30)}return true};var c=function(){if(h&&Z!=b){var a3={passive:false,capture:false};var a5=(t==b)?a3:b;h=false;a.removeEvent(window,Z,ag,a5);a.removeEvent(window,aD,a2,a5);if(d&&t){try{a.removeEvent(t,Z,ag,a3);a.removeEvent(t,aD,a2,a3)}catch(a4){}}if(aJ!=b){a.removeEvent(window,aJ,av,a5)}Z=aD=aJ=b}};var aE=function(a3){};var E=function(){if(h){c()}h=true;var a3={passive:false,capture:false};var a5=(t==b)?a3:b;Z=j;aD=F;aJ=ae;a.addEvent(window,Z,ag,a5);a.addEvent(window,aD,a2,a5);if(d&&t){try{a.addEvent(t,Z,ag,a3);a.addEvent(t,aD,a2,a3)}catch(a4){}}if(ae!=b){a.addEvent(window,aJ,av,a5)}};var ag=function(a3){af(a3);a3.FSI_start_x=aa.x;a3.FSI_start_y=aa.y;if(az.enabled&&az.evtMove==b){az.evtMove=a3}if(p){if(aa.bClick){aa.clickRadiusX=Math.max(aa.clickRadiusX,Math.abs(aS.x-aa.x));if(aa.clickRadiusX>ac){aa.bClick=false}else{aa.clickRadiusY=Math.max(aa.clickRadiusY,Math.abs(aS.y-aa.y));if(aa.clickRadiusY>ac){aa.bClick=false}}}if(o.enabled){o.evt=a3;aZ()}else{e.call(J,a3,w,G)}}else{if(an.started){if(an.nType==1){aw(a3)}}}if(x&&!a3.FSI_allowEventDefault){U(a3)}};var aw=function(a3){var a4=k();if(!O){return}a3._FSI_PinchDeltaStart=an.nPinchDistance-an.pinchDistanceStart;a3._FSI_PinchDeltaRelative=an.nPinchDistance-an.pinchDistanceLast;a3._FSI_PinchScale=Math.max(at,an.pinchDistanceLast)/an.pinchDistanceStartMaxed;an.pinchDistanceLast=an.nPinchDistance;a3._FSI_PinchDistance=a4;O.call(J,a3,aS,G)};var av=function(a3){if(aU){ak(a3);if(ad<1){if(p){a3._FSI_Canceled=true;a2(a3,true);return}else{R();return}}}af(a3);aj(a3)};var a2=function(a4,a5){var a3=aa.bClick;aa.bClick=false;if(a5){a4._FSI_Canceled=true}if(aU){ak(a4)}if(ad==0){aQ()}af(a4);if(!a5&&aj(a4)){return}aK();if(!a5){if(!p||ad>0){return}}a4.FSI_start_x=aa.x;a4.FSI_start_y=aa.y;var a6=false;if(!a5&&az.enabled){if(aA==b||aA()){a6=T(a4)}}if(a6){R();z(a4)}else{if(Y){a4._FSI_Click=a3}aO.call(J,a4,w,G);if(a4.type=="touchend"){aP=setTimeout(q,1)}R()}U(a4)};var q=function(){R();I();aP=b};var H=function(a3){return ar};var aZ=function(){if(o.animationFrame!=b){return}aT()};var i=function(){if(o.animationFrame==b){return}cancelAnimationFrame(o.animationFrame);o.animationFrame=b};var aT=function(){var a3=Math.abs(w.x-aS.x)+Math.abs(w.y-aS.y);if(a3>o.fEndDiff){w.x+=(aS.x-w.x)/o.factor;w.y+=(aS.y-w.y)/o.factor;o.animationFrame=requestAnimationFrame(aT)}else{w.x=aS.x;w.y=aS.y;o.animationFrame=b}e.call(J,o.evt,w,G)};var T=function(a3){var a4;if(!az.enabled){return false}if(az.running){C()}az.pos=0;var a6=(a3.touches!=b)?1.8:1;if(az.factorAmountQuad){a4=(az.x>0)?1:-1;az.x=az.x+a4*az.x*az.x/az.factorAmountQuad;a4=(az.y>0)?1:-1;az.y=az.y+a4*az.y*az.y/az.factorAmountQuad}var a8=a6*az.factorAmount;az.startX=w.x;az.startY=w.y;var a7={};a7.x=az.startX+a8*az.x;a7.y=az.startY+a8*az.y;if(az.roundTargetPos){a7.x=Math.round(a7.x);a7.y=Math.round(a7.y)}if(az.modifyTarget){a7=az.modifyTarget.call(J,a7,G);if(a7===false){return false}}az.amountX=a7.x-az.startX;az.amountY=a7.y-az.startY;az.amountXABS=Math.abs(az.amountX);az.amountYABS=Math.abs(az.amountY);var a5=(az.amountXABS>az.minDelta||az.amountYABS>az.minDelta);if(a5){a8=az.factorFrames/100;az.frames=az.offsetFrames+Math.round(a8*az.amountXABS+a8*az.amountYABS)}else{if(typeof(aY.onAfterTouchCancel)=="function"){aY.onAfterTouchCancel.call(J,a3,w,G)}}return a5};this.isAfterTouchRunning=function(){return az.running};var z=function(a3){if(typeof(aY.onAfterTouchStart)=="function"){aY.onAfterTouchStart.call(J,a3,w,G)}az.running=true;az.evtUp=a3;if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,true,az.evtMove,G)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}else{az.intervalRun=setInterval(K,16)}}return true};var aH=function(a4,a3,a6,a5){return a6*((a4=a4/a5-1)*a4*a4+1)+a3};var K=this.runAfterTouch=function(){var a3=false;az.pos++;w.x=aH(az.pos,az.startX,az.amountX,az.frames);w.y=aH(az.pos,az.startY,az.amountY,az.frames);e.call(J,az.evtMove,w,G);if(az.pos===az.frames){C(true)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}a3=true}return a3};this.enableAfterTouch=function(a3){if(az.enabled==a3){return}if(!a3){C()}az.enabled=a3};var C=function(a3){if(!az.running){return}if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,false,az.evtMove,G)}else{if(az.useAnimationFrame){if(az.animationFrameRun){cancelAnimationFrame(az.animationFrameRun)}}else{if(az.intervalRun){clearInterval(az.intervalRun);az.intervalRun=b}}}if(typeof(aY.onAfterTouchEnd)=="function"){aY.onAfterTouchEnd.call(J,az.evtMove,G)}az.evtMove=b;az.running=false;az.evtUp._FSI_Canceled=(a3!==true);az.evtUp._FSI_fromAfterTouch=true;aO.call(J,az.evtUp,w,G)};var ab=function(){az.x=(2*az.x+aS.x-az.lastX)/5;az.y=(2*az.y+aS.y-az.lastY)/5;az.lastX=aS.x;az.lastY=aS.y};var ay=this.setCapture=function(a3,a5){var a4=ai(a3,a5);if(a4){au.captureScrollUser=a3;au.capturePinchUser=a5}return a4};var ai=function(a3,a5){var a4=0;if(a3){a4+=2}if(a5){a4+=4}if(a4==au.nCheck){return}au.nCheck=a4;au.captureScroll=a3;au.capturePinch=a5;if(a.BrowserSupports.cssTouchAction()){P(a3,a5)}return true};var P=function(a3,a7){if(aY.bMouseOnly){return}var a6;switch(au.nCheck){case 0:a6="auto";break;case 2:a6=aW+"pinch-zoom";break;case 4:a6="pan-x pan-y";break;default:a6=(aW.length>0)?aW:"none"}au.cssTouchAction=a6;for(var a5=0;a5<n.length;a5++){var a4=n[a5];r(a4,au.cssTouchAction)}};var k=function(){if(ar.length<1){return 0}var a4=Math.abs(ar[1].x-ar[0].x);var a3=Math.abs(ar[1].y-ar[0].y);return an.nPinchDistance=Math.sqrt(a4*a4+a3*a3)};var aj=function(a3){x=false;if(!al){return}var a4=ar.length;if(!aN){x=(a4==1&&au.captureScroll);return}if(an.pointerCount!=a4){Q(a3);if(a4>1){ah();an.nPointers=a4;switch(a4){case 2:an.started=true;an.name="pinch";an.nType=1;if(typeof(aY.onPinchStart)=="function"){M(a3);an.nPinchDistance=0;an.nPinchDistance=k();an.pinchDistanceStart=an.pinchDistanceLast=an.nPinchDistance;an.pinchDistanceStartMaxed=Math.max(at,an.pinchDistanceStart);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchStart.call(J,a3,aS,G)}break;default:an.started=true;an.name="unknown";an.nType=-1}if(an.started){A=true;if(p){aK();p=false;a3._FSI_Canceled=true;aO.call(J,a3,w,G)}if(typeof(aY.onGestureStart)=="function"){M(a3);aY.onGestureStart.call(J,a3,aS,G)}}}else{if(a4<1){ah()}}an.pointerCount=a4;x=false;if(a4==1){if(au.captureScroll){x=true}}else{if(au.capturePinch&&an.nType==1){x=true}}}return an.started};var ah=function(){if(!an.timeoutRestartDown){return}clearTimeout(an.timeoutRestartDown);an.timeoutRestartDown=b};var D=function(){if(ad!=1){return}g(X);ah()};var M=function(a3){a3._FSI_Gesture=an.name;a3._FSI_GestureType=an.nType;a3._FSI_PointerCount=an.nPointers};var Q=function(a3){if(!an.started){return}an.started=false;if(!a3){a3={}}if(an.nType==1&&typeof(aY.onPinchEnd)=="function"){M(a3);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchEnd.call(J,a3,aS,G)}if(typeof(aY.onGestureEnd)=="function"){M(a3);aY.onGestureEnd.call(J,a3,aS,G)}an.name="none";an.nType=0;if(a3&&ad==1){ah();an.timeoutRestartDown=setTimeout(D,20)}};ao()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.IMGLoadingEngine!==b){return}a.IMGLoadingEngine=function(q,h){var p=this;var n=0;var w=0;var l=(typeof(h)==="function")?h:a.fnDoNothing;var j={};var c=1;var s;var g,d;var v;this.destroy=function(){e();p.abortAll();c=1;u()};this.getCountLoading=function(){return n};this.load=function(x,z,B,y,C){var A=(!v||v[B]===b);if(typeof(C)!=="object"){C={}}if(typeof(x)!=="object"){return C}if(typeof(B)!=="string"||B.length<1){B="default"}if(j[B]===b){j[B]={__count:0}}j[B][c]=x;j[B].__count++;n++;if(A){if(w===0){m(1)}w++}a.addEvent(x,"load",r);a.addEvent(x,"error",f);x.FSIIMGLoadingEngineData=C;C.uid=c;C.url=z;C.strPurpose=B;C.bLoading=true;C.bVisual=A;if(typeof(y)==="function"){C.fnLoad=y}a.loadImageCors(x,z);c++};this.setNotVisualPurposes=function(x){if(typeof(x)&&x!==null&&typeof(x.concat)==="function"){if(x.length>0){v={};for(var y=0;y<x.length;y++){v[x[y]]=true}}else{v=b}}};var m=function(x){if(!l||x===g){return}g=x;e();s=setTimeout(i,50)};var i=function(){if(g===d){return}d=g;e();l.call(q,d)};var e=function(){if(s!==b){clearTimeout(s);s=b}};var u=this.reset=function(){if(n>0){for(var y in j){var z=y[j];for(var x in z){t(z[x])}}}n=w=0;j={}};var k=function(x){return(typeof(x)==="object"&&typeof(x.FSIIMGLoadingEngineData)==="object")};var t=function(x){if(!k(x)){return false}var y=x.FSIIMGLoadingEngineData;if(!y.bLoaded){y.bAborted=true}n--;if(x.FSIIMGLoadingEngineData.bVisual){w--;if(w===0){m(0)}}if(j[y.strPurpose]!=b){if(j[y.strPurpose][y.uid]===b){a.console.error("IMGLoadingEngine: failed to remove item with purpose '"+y.strPurpose+" and uid "+y.uid)}else{j[y.strPurpose][y.uid]=b;delete j[y.strPurpose][y.uid];delete x.FSIIMGLoadingEngineData}j[y.strPurpose].__count--;if(j[y.strPurpose].__count===0){delete j[y.strPurpose]}}return true};this.abortAll=function(){if(n>0){for(var y in j){var z=j[y];for(var x in z){o(z[x]);if(!z[x]){break}}}}};var o=this.abortItem=function(x){if(!k(x)){return false}if(x.FSIIMGLoadingEngineData.bAborted){return true}x.FSIIMGLoadingEngineData.bAborted=true;if(x.FSIIMGLoadingEngineData.bLoaded){t(x)}return true};this.abortPurpose=function(y){if(n<1){return false}if(typeof(j[y])!=="object"||j[y].__count<1){return false}for(var x in j[y]){o(j[y][x]);if(!j[y]){break}}return true};var f=function(x){var y=this.FSIIMGLoadingEngineData;y.bError=true;r.apply(this,[x])};var r=function(x){var y=this;a.removeEvent(y,"load",r);a.removeEvent(y,"error",f);var z=y.FSIIMGLoadingEngineData;z.bLoading=false;z.bLoaded=true;if(!z.bError&&!z.bAborted){z.bSuccess=true}t(y);if(!z.bAborted&&z.fnLoad){z.fnLoad.apply(y,[x,z])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderCSSSkin!=b){return}a.LoaderCSSSkin=function(){var e=this;var j=0;var h={};var c=0;var d=new a.CORSLoader();var f=function(l){var k=false;try{if(l.cssRules!=b){k=l.cssRules}else{k=l.rules}}catch(m){console.error(m.message)}return k};var i=function(n,m,v,l,t){var s=this;var u;var B=[];var o;var y=0;var r=false;var q=false;this.uniqueID=c++;this.bReleased=false;this.getSkinName=function(){return m.getSkinName()};this.callReady=function(D,E,G,F){if(this.bReleased){return}if(F){q=true}o=arguments;r=true;p()};var p=function(){if(!r||y>0){return}if(q){u=setTimeout(z,1)}else{z()}};var z=function(){k();v.apply(l,o)};var k=function(){if(u!=b){clearTimeout(u);u=b}};this.remove=function(){k();if(s.bReleased){return}m.removeWaiter(s.uniqueID);for(var D=0;D<B.length;D++){B[D].remove()}this.bReleased=true};var C=function(D,E,G,F){if(F){q=true}y--;p()};if(t&&typeof(t)=="object"&&t.length>0){for(var w=0;w<t.length;w++){var x=t[w];y++;var A=a.loadSkinCSS(x.file,s,C,x.nPriority);B.push(A)}}};var g=function(k,w){var t=false;var l=0;var v={};var q=false;var r=false;var s;var p;var m;var o;m=k.match(/(.*)\/[^/]*$/);m=m[1]+"/";m=m.replace(/\/resources\/$/,"/");p=k.replace(/\.[^/]*$/,"");p=p.match(/([^/]*)$/);p=p[1].toLowerCase();this.removeWaiter=function(x){if(v[x]==b){return}delete v[x];l--};this.addWaiter=function(x){if(x.uniqueID==b||x.bReleased){return}if(q){x.callReady(r,o,"ALREADY LOADED",false)}else{if(v[x.uniqueID]==b){v[x.uniqueID]=x;l++;if(!t){u()}}}};this.getSkinName=function(){return p};var n=function(H,A,I,C){var F=false;if(C>299||typeof(A)!="string"){a.console.error("Failed to load Skin CSS (HTTP "+C+"): "+k)}else{F=true;A=A.replace(/\[fsi-skin-path\]/g,m);s=document.createElement("style");s.setAttribute("type","text/css");s.setAttribute("x-generated-by","FSI");s.setAttribute("x-fsi-skin",p);s.setAttribute("x-fsi-priority",w);s.appendChild(document.createTextNode(A));var E=document.head;if(!E){E=document.getElementsByTagName("head");if(E&&E.length>0){E=E[0]}}if(E&&E.firstChild){try{var z;var J=E.getElementsByTagName("style");for(var B=0;B<J.length;B++){var G=J[B];var y=parseInt(G.getAttribute("x-fsi-priority"));if(isNaN(y)||y>w){z=G;break}}if(z){E.insertBefore(s,z)}else{E.appendChild(s)}}catch(D){E.appendChild(s)}}else{E.appendChild(s)}o=s.sheet;r=F}q=true;for(var x in v){v[x].callReady(r,o,"onLoaded",true)}v={};l=0};var u=function(){t=true;if(typeof(k)!="string"||k.length<0){return false}d.load(k,n,"text/css");return true}};this.load=function(p,q,m,r,l){if(r==b){r=100}var o=false;if(a.versionInternetExplorer<9){o=true}if(o){a.console.error("Unable to load skin: unsupported browser version.");if(m){m.call(q,false)}return false}if(a._FSIViewerLocation==b||typeof(p)!="string"||p.length<1){a.console.error("Unable to load skin:");if(a._FSIViewerLocation==b){a.console.error("FSI Viewer path not known")}else{a.console.error("Invalid skin URL "+p)}if(m){m.call(q,false)}return false}var k=p;if(k.indexOf("http")!=0){k=a._FSIViewerLocation+"/skins/"+k}if(!k.match(/\.css$/)){k+=".css"}var s;if(h[k]==b){j++;s=h[k]=new g(k,r)}else{s=h[k]}var n=new i(k,s,m,q,l);s.addWaiter(n);return n}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderJavascript!=b){return}a.LoaderJavascript=function(){var e={};this.load=function(h,l,n,j,m){var k=e[h];if(n==b){n=window}if(typeof(j)!="function"){return false}if(k==b){k=e[h]={};k.path=h;k.loaded=false;k.failed=false;f(k);if(!g(k)){k.failed=true;k.loaded=true;k.addNodeFailed=true}}else{if(k.oListeners[l]!=b){d(h,l)}}k.nListeners++;var i=k.oListeners[l]={};i.argScope=n;i.argFunction=j;i.oPassThrough=m;if(k.loaded==true){c(k)}return true};var d=this.release=function(h,j){var i=e[h];if(i==b){return}if(i.oListeners[j]!=b){delete i.oListeners[j];i.nListeners--}};var g=function(l){var h=false;try{var i=document.getElementsByTagName("head");if(i&&i.length>0){i=i[0];var j=l.node=document.createElement("script");var k=l.onLoad=function(n){if(n.type=="error"){l.failed=true;c(l)}else{l.failed=false;c(l)}l.loaded=true};a.addEvent(j,"load",k);l.onError=function(n){l.failed=true;c(l);l.loaded=true};a.addEvent(j,"error",k);i.appendChild(j);j.src=l.path;h=true}}catch(m){}return h};var c=function(j){var h=!j.failed;a.removeEvent(j.node,j.onLoad);a.removeEvent(j.node,j.onError);for(var k in j.oListeners){var i=j.oListeners[k];i.argFunction.call(i.argScope,h,j.path,i.oPassThrough)}f(j)};var f=function(h){h.oListeners={};h.nListeners=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.AboutWindow!=b){return}a.AboutWindow=function(d,k){var m=this;var e;var g;var h;var f;var i;var l=function(){e=document.createElement("div");a.setStyleAttr(e,"position: absolute;z-index:1000;width:12em;");e.className="fsi-ui-info-window";h=document.createElement("div");h.className="fsi-ui-title";f=document.createElement("div");f.style.display="inline-block";f.innerHTML=k.title;h.appendChild(f);i=document.createElement("div");i.style.display="inline-block";i.style["float"]="right";i.style.cursor="pointer";i.innerHTML="X";h.appendChild(i);e.appendChild(h);g=document.createElement("div");g.className="fsi-ui-content";var o=k.strLongVersion;o="<h3>"+o.replace(/ build/,'</h3><span class="small">build')+"</span>";var n;if(k.strCopyright==b){n="<br/><br/>&copy; 2018 NeptuneLabs GmbH<br/>";n+='<hr/><a style="color:inherit;text-decoration:none" href="//www.neptunelabs.com/" target="_blank">www.neptunelabs.com</a><br/><br/><span class="small">FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany<br/></span>'}else{k.strCopy=k.strCopyright}o+="<br/>"+n;g.innerHTML=o;e.appendChild(g);d.appendChild(e);a.addEvent(e,"click",j);c()};var c=function(){var o=a.getElementPosition(d);o.width=(o.right-o.left);o.height=(o.bottom-o.top);var n=a.getElementPosition(e);n.width=(n.right-n.left);n.height=(n.bottom-n.top);e.style.left=Math.round((o.width-n.width)/2)+"px";e.style.top=Math.round((o.height-n.height)/2)+"px"};var j=this.destroy=function(){if(typeof(k.fnOnDestroy)=="function"){if(!k.fnOnDestroy.call(this)){return}}a.removeEvent(e,"click",j);a.removeChild(e.parentNode,e)};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.eventElementID++}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.eventFunctionID++}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerDocumentZoom!=b){return}a.CustomEventListenerDocumentZoom=a.oCustomEventListenerClasses.FSIDocumentZoomChange=function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!=c){if(q){j()}else{i()}}};var m=function(p){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var p;var q=a.getDocumentScaleWithPixelRatio();if(g!=q){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerViewport!=b){return}a.CustomEventListenerViewport=a.oCustomEventListenerClasses.FSIViewport=function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!=b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!=b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!=d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!=b){return}w=setTimeout(K,N);K()};var K=function(){if(w!=b){clearTimeout(w);w=b}var e=false;var U=L();if(C!=U){C=U;e=true;f()}return e};var J=function(){n=a.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.topWindow);T=a.getBoundingClientRect(a.topWindow.document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.topWindow);T=a.getBoundingClientRect(a.topWindow.document.documentElement);h.left=a.topWindow.pageXOffset;h.top=a.topWindow.pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!=b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!=b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u==b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!=b){if(U==b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length==0){r()}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerElementDimension!=b){return}a.CustomEventListenerElementDimension=a.oCustomEventListenerClasses.FSIElementDimension=function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)=="function";a.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerMouseWheel!==b){return}a.CustomEventListenerMouseWheel=a.oCustomEventListenerClasses.FSIMouseWheel=function(){var c=this;var f=100000;var g;a.CustomEventListener.prototype.constructor.call(c,"FSIMouseWheel");c._strClassName="$FSI.CustomEventListenerMouseWheel";this._onListenerAdd=function(h){h.callback=function(i){d(h,i)};a.addEvent(h.element,"mousewheel",h.callback);a.addEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerRemove=function(h){a.removeEvent(h.element,"mousewheel",h.callback);a.removeEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerCountChange=function(h){if(h<1){if(g!=b){clearInterval(g);g=b}}};this.setListenerProps=function(k,i,j){if(typeof(i)!=="string"){return false}var h=c.getListenerObjectByID(k);if(!h){return false}switch(i){case"acceleration":if(j){h.bAccelerate=true;h.acceleration=j;h._accelerate=1;if(h._accelerateMax==b){h._accelerateMax=10}}break;case"accelerationMax":h._accelerateMax=j;break}};var e=function(){var j=c.getListenersArray();var k=true;for(var l=0;l<j.length;l++){var h=j[l];if(h.bAccelerate&&h._accelerate>1){h._accelerate/=1.5*h.acceleration;if(h._accelerate>1.5){k=false}else{k=true;h._accelerate=1}}}if(k){clearInterval(g);g=b}};var d=function(h,i){var k=0;if(i.detail){k=i.detail}else{if(i.wheelDelta){k=-i.wheelDelta}}if(k!=0){i.FSI_normalized_delta=(k>0)?-1:1;f=Math.min(f,Math.abs(k))}else{i.FSI_normalized_delta=0}if(h.bAccelerate){if(g==b){g=setInterval(e,200)}h._accelerate*=h.acceleration;h._accelerate=Math.min(h._accelerateMax,h._accelerate);k=Math.round(h._accelerate*k)}else{h._accelerate=1}i.FSI_delta=-k;i.FSI_weighted_delta=i.FSI_delta/f;i.FSI_normalized_accelerated_delta=(k>0)?-h._accelerate:h._accelerate;var j=c.fireEvent(h,i);if(j===false){h._accelerate=1}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.NavigatorWindow!=b){return}a.NavigatorWindow=function(q,A,w,J,E){var j=this;var af=q.iViewer;var t;var aa=0;var m;var p,C;var h;var F,r;var i,f;var u=false;var x=false;var M=q.getElementSpace();var N=q.getinPlaceZoom();var g=af.getImageIsTransparent();var U=q.getDrawRatio();var s=af.getSrcDim();var ad=q.getdrawRatioUnZoomed();var G=q.getdrawRatioUnResized();var W=q.viewport;var I;var V;var c={x:2,y:2};var d;var ae;var O=false;var Y;var Q;var ac={};var H;var B=false;var z;var K;var v=false;var e=true;var o;var Z=function(){u=A.result.autoHideNav;m=[];aa=4;h=16;o=A.makeBool(A.cfg.autohidenaviftoosmall,true);var aj=l(A.result.navWidth,W.width,120);var ap=l(A.result.navHeight,W.height,120);var am=Math.min(M.width-2*aa,aj);var an=Math.min(M.height-2*aa-20,ap);am=Math.max(60,am);an=Math.max(40,an);var al,ah;al=am;ah=al/ad.imageWidth*ad.imageHeight;if(ah>an){ah=an;al=ah/ad.imageHeight*ad.imageWidth}p=Math.max(10,Math.round(al));C=Math.max(10,Math.round(ah));var ao=p+2*aa;var ak=C+2*aa+h;F=ao;r=ak;j.sprite=new a.Sprite(J,ao,ak,500);a.addClass(j.sprite.element,"fsi-ui-nav-window");j.sprite.element.style.width=j.sprite.element.style.height="auto";if(w){d=w.navFrameBorderColor;ae=w.navFrameBackgroundColor}else{d="red";ae="rgba(255,255,255,0.5)"}j.canvasSprite=new a.Sprite(j.sprite.element,p,C,2,true,"inline");j.canvasSprite.element.style.clear="both";a.addClass(j.canvasSprite.element,"fsi-ui-nav-window-image");if(A.hasPlugin("zoommeter")){I=document.createElement("div");a.addClass(I,"fsi-ui-nav-window-zoom-text");j.sprite.element.appendChild(I);V=document.createTextNode("100 %");I.appendChild(V);var ai=A.getPluginParameter("zoommeter","color");if(ai){I.style.color="#"+ai}O=A.getPluginParameter("zoommeter","srcrelative",false,true)}j.sprite.updateMargins();j.sprite.updateDimension();var ag={};ag.smoothing={enabled:true,factor:7,fEndDiff:0.03};z=new a.TouchHandler(j.canvasSprite.canvas,ag,S,X,T);Q=j.canvasSprite.ctx;L();n();if(u){R(false,false)}};this.destroy=function(){if(z){z.destroy();z=b}a.removeChild(J,j.sprite.element)};this.enable=function(ag,ah){z.enable(ag);if(j.sprite&&j.sprite.element){if(ah){j.sprite.element.style.visibility="hidden"}else{j.sprite.element.style.visibility=""}}};var l=function(aj,ah,ai){var ag=parseInt(aj);if(typeof(aj)=="string"&&aj.indexOf("%")!=-1){ag=Math.max(0,Math.min(100,ag));ag=Math.round(ag*ah/100)}else{ag=parseInt(aj)}if(isNaN(ag)){ag=ai}return ag};this.isDragging=function(){return x};var S=function(ah,ak){q.onUserAction();q.stopAutoSpin();var ai=a.getElementPosition(j.canvasSprite.element);i=-ai.left;f=-ai.top;var ag=ak.x+i;var aj=ak.y+f;if(ag<0||aj<0||ag>p||aj>C){return false}x=true;q.stopDesktopAnimation();q.stopAfterTouch();y(ak,true);q.autoShowHideHotSpots(false);q.iCallbacks.run("onStartDragging",[true]);return true};var X=function(ag,ah){y(ah,true)};var T=function(ag,ah){q.onUserAction();x=false;y(ah,false);q.onAfterinPlaceZoomChanged();q.autoShowHideHotSpots(true);q.iCallbacks.run("onStopDragging",[true])};var y=function(aj,ah){var ag=aj.x+i-p/2;var ai=aj.y+f-C/2;N.panPos.left=K*-ag;N.panPos.top=K*-ai;q.updateInPlaceZoom(ah)};var P=function(ao,ax,ap,av,aq){var am,ak,aj,ai,an,aw,au;aw=ax;au=ap;ax=Math.max(1,Math.round(ax/2));if(ax<av){ax=av}ap=Math.max(1,Math.round(ap/2));if(ap<aq){ap=aq}ak=ai=document.createElement("canvas");ai.setAttribute("crossorigin","anonymous");ai.width=ax;ai.height=ap;an=ai.getContext("2d");an.drawImage(ao,0,0,aw,au,0,0,ax,ap);var ah=document.createElement("canvas");ah.setAttribute("crossorigin","anonymous");var al=ah.getContext("2d");var ag=false;while(ax>av||ap>aq){am=ak;aw=ax;au=ap;if(ag){ak=ai;aj=an;ag=false}else{ak=ah;aj=al;ag=true}ax=Math.round(ax/2);if(ax<av){ax=av}ap=Math.round(ap/2);if(ap<aq){ap=aq}ak.width=ax;ak.height=ap;aj.drawImage(am,0,0,aw,au,0,0,ax,ap)}var at;try{at=aj.getImageData(0,0,ax,ap);Y=D}catch(ar){at=ak;Y=k}return at};var D=function(ah,ag,ai){Q.putImageData(ah,ag,ai)};var k=function(ah,ag,ai){Q.drawImage(ah,ag,ai)};var L=function(){switch(c.x){case 2:j.sprite.element.style.left="auto";j.sprite.element.style.right=j.sprite.margin.right+"px";break;default:j.sprite.element.style.right="auto";j.sprite.element.style.left=j.sprite.margin.left+"px";break}switch(c.y){case 2:j.sprite.element.style.top="auto";j.sprite.element.style.bottom=j.sprite.margin.bottom+af.getMenuHeight("navWindow")+"px";break;default:j.sprite.element.style.bottom="auto";j.sprite.element.style.top=j.sprite.margin.top+"px";break}};this.setContainerSize=function(ag,aj,ai){var ah=j.sprite.element.style.display;j.sprite.element.style.display="block";j.sprite.updateDimension();U=aj;ad=ai;M=ag;j.sprite.element.style.display=ah;n()};var R=function(ag,ah){if(ag==b){ag=(!B&&v)}if(e==ag){return}e=ag;j.sprite.show(ag,ah)};var n=function(){if(!o){return}B=(M.width<4*j.sprite.width()||M.height<4*j.sprite.height());R(b,false)};var ab=this.autoShowHide=function(ag){if(!u){return}if(v!=(N.scale>1.05)){v=!v;R(b,ag)}};this.setPreviewImageSize=function(ag,ah){if(ag==b){H=b}else{ac.width=ag;ac.height=ah;H=ac}};this.update=function(aA,al){ab(true);if(!j.sprite.isVisible()){return}K=U.imageWidth/p;var aq=Q;if(m[aA]==b){var au=q.getPreviewImage(aA);var aw=(H)?H:au;m[aA]=P(au,aw.width,aw.height,p,C)}aq.lineWidth=0;var an=0;var am=0;if(I&&t!=al){t=al;var av,ag;if(O){av=al*G.imageWidth/s.width}else{av=U.imageWidth/ad.imageWidth}av=Math.round(100*10*av)/10;ag=""+av;if(ag.indexOf(".")==-1){ag+=".0"}ag+=" %";V.nodeValue=ag}Y(m[aA],an,am);var az=N.scale;if(az>1.05){var ap=p/G.imageWidth/az;var aj=ap*W.width;var ar=ap*W.height;var ax=p/U.imageWidth;var ao=(p-aj)/2-N.panPos.left*ax;var ay=(C-ar)/2-N.panPos.top*ax;var ai=an+ao;var ah=am+ay;var ak=an;var at=am;if(aj<4||ar<4){ai+=aj/2;ah+=ar/2;aq.strokeStyle=d;aq.strokeRect(ai,ah-3,1,7);aq.strokeRect(ai-3,ah,7,1)}else{aq.save();aq.fillStyle=ae;aq.beginPath();aq.rect(ak,at,p,ah-at);aq.rect(ak,ah,ai-ak,ar);aq.rect(ai+aj,ah,p-ao-aj,ar);aq.rect(ak,ah+ar,p,C-ay-ar);aq.closePath();aq.clip();aq.fillRect(an,am,p,C);aq.restore();aq.save();aq.strokeStyle=d;aq.beginPath();aq.rect(an,am,p,C);aq.clip();aq.strokeRect(ai,ah,aj,ar);aq.restore()}}};this.reverseImageSequence=function(){m.reverse();m.unshift(m.pop())};Z()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MenuBar!==b){return}a.MenuBar=function(k,s,A,J,r){var i=this;var M=this.myViewer=k.iViewer;var B=k.getElementSpace();var h;var x;var u=0;var D=[];var m=b;if(r===b){r={}}this.bEnabled=b;var C={};var n={};var L={};var g=0;var j=0;var z="fsi-ui-button-icon";var q;var E;var o=1;var y=[];var d;var v,K;var p=this.setInterface=function(){v=k.getDebug();K=k.getToolTip()};var G=function(){i.oInterface=k;var N=k.iConfig;E=N.makeBool(N.cfg.menubuttontooltips,true,true);p(k);i.btnID=0;i.sprite=new a.Sprite(A,B.width,g,450,b,b,"fsi-ui-menu-bar");i.sprite.element.style.width="100%";i.sprite.element.style.top="auto";i.sprite.element.style.left="0px";i.sprite.element.style.right="auto";i.sprite.element.style.lineHeight="100%";i.sprite.element.style.bottom="0px";i.sprite.element.style.visibility="hidden";i.iconClassNamesNormal=z;m=setTimeout(f,0)};this.groupButtons=function(N){var Q;var O=[];for(Q=0;Q<N.length;Q++){var P=i.getButtonByCMD(N[Q]);if(P&&P.elButton){O.push(P.elButton)}}if(O.length>0){var S=document.createElement("span");S.className="fsi-ui-button-group-container";var R=O[0].parentNode;R.replaceChild(S,O[0]);for(Q=0;Q<N.length;Q++){S.appendChild(O[Q])}y.push(S)}};var f=function(){if(i.sprite.element.offsetHeight!==0||u++>200){m=b;l()}else{m=setTimeout(f,25)}};this.getButtonContainerWidth=function(){return x.element.offsetWidth};this.addButtonCSSClass=function(N,O){F(N,O,true)};this.removeButtonCSSClass=function(N,O){F(N,O,false)};var F=function(P,Q,O){var N=n[P];if(N===b){return}if(O){a.addClass(N.elButton,Q)}else{a.removeClass(N.elButton,Q)}i.setExternalButtonState(P,N.getState(),N.elButton.className)};this.getExternalButtonID=function(){return o++};var l=function(){var O=i.sprite.getClientDim();g=Math.round(O.height);i.sprite.setSize("100%",g);i.setEnabled(false);if(typeof(s.urlLogo)==="string"&&s.urlLogo.length>0&&s.urlLogo!=="none"){h=document.createElement("div");a.addClass(h,"fsi-ui-logo");a.setStyleAttr(h,"position:absolute;display:none");var N=document.createElement("img");N.className="fsi-ui-logo-image";N.style.backgroundImage="none";N.src=s.urlLogo;h.appendChild(N);a.addEvent(N,"load",w);i.sprite.element.appendChild(h);a.addEvent(h,"click",M.showAboutWindow)}a.addEvent(i.sprite.element,"mouseup",e);a.addEvent(i.sprite.element,"contextmenu",H);i.sprite.element.style.visibility="";J()};this.show=function(N){if(d===N){return}d=N;i.sprite.show(N,false)};this.getVisible=function(){return d};this.destroy=function(){t("onMenuDestroy");if(m!==b){clearTimeout(m);m=b}if(h){a.removeEvent(h,"click",M.showAboutWindow)}a.removeEvent(i.sprite.element,"mouseup",e);a.removeEvent(i.sprite.element,"contextmenu",H);i.removeButtons();i.removeDomElement()};this.removeDomElement=function(){if(i.sprite.element.parentNode){a.removeChild(i.sprite.element.parentNode,i.sprite.element);g=0}};var e=function(N){if(N.which&&N.which===3){j=new Date().getTime()}};var H=function(O){if(j){var N=new Date().getTime()-j;if(N<300){return}}O.preventDefault&&O.preventDefault()};this.getHeight=function(){return g};this.pressButton=function(O){var N=n[O];if(N!==b){N.onMouseDown()}};this.releaseButton=function(O){var N=n[O];if(N!==b){N.onMouseUp()}};var c=function(N,P){var Q=b;if(!N||!P){return Q}if(N.indexOf("_")!==-1){var O=N.split("_");switch(O[0]){case"MouseMode":Q="";if(P.Mode){Q+="<b>"+P.Mode+"</b>"}if(P["Mode"+O[1]]){Q+=" "+P["Mode"+O[1]]}break}}return Q};this.showButtonToolTip=function(O,P){var N;if(P){N=P.getAttribute("fsi-tool-tip");if(k.iConfig.makeBool(N,true)===false){return}}if(N==b){N=O.getCMD()}if(typeof(r[N])==="string"){N=r[N]}i.showToolTip(N,P)};this.getButtonDomElement=function(O){var N=n[O];if(N){return N.elButton}};this.showToolTip=function(P,O,N,Q){if(!K||!E){return}K.show(P,O,N,Q,c)};this.hideToolTip=function(){if(!K||!E){return}K.hide()};this.setEnabled=function(N,O){if(i.bEnabled===N){return}i.bEnabled=N;if(O){return}if(N){a.removeClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}else{a.addClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}t("onMenuEnabled",[N])};this.getButtonEnabled=function(O){var N=n[O];if(N===b){return}return N.bEnabled};this.showButton=function(P,N){var O=n[P];if(O===b){return false}return O.show(N)};this.enableButton=function(P,N){var O=n[P];if(O===b){return false}return O.setEnabled(N)};this.getButtonPressed=function(O){var N=n[O];if(N===b){return false}return N.getPressed()};this.setButtonPressed=function(P,N){var O=n[P];if(O===b){return false}O.setPressed(N);return true};var I=function(O,P){var N;if(C[P]===b){N=C[P]={};N.arButtons=[]}else{N=C[P]}N.arButtons.push(O);O.oGroup=N;O.makeRadioButton()};this.removeButtons=function(){var N;i.unregisterExternalButtons();for(N=0;N<D.length;N++){D[N].destroy()}for(N=0;N<y.length;N++){if(y[N]&&y[N].parentNode){y[N].parentNode.removeChild(y[N])}}D=[];C={};n={}};this.unregisterExternalButtons=function(){for(var P in L){var N=L[P];for(var O=0;O<N.length;O++){N[O].destroy(true)}}L={}};this.addButtons=function(Y,ac){i.removeButtons();var Q;var Z=g-6;var S,ad;var R,aa,T;var O="";if(typeof(ac)==="string"&&ac.length>0){O=" (sorted by parameter MenuButtonOrder)";var N=ac.split(",");var W={};for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){W[Y[aa].cmd.toLowerCase()]=aa}}var V=[];var ab={};for(aa=0;aa<N.length;aa++){T=a.trim(N[aa].toLowerCase());if(W[T]!==b){if(ab[T]===b){ab[T]=true;V.push(Y[W[T]])}}}for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){T=Y[aa].cmd.toLowerCase();if(!ab[T]){V.push(Y[aa])}}}Y=V}else{O=" (default)"}if(!x){x=new a.Sprite(i.sprite.element,B.width,g,2);a.setStyleAttr(x.element,"position:relative");a.addClass(x.element,"fsi-ui-button-container")}var ae;if(v.on){ae=[]}for(aa=0;aa<Y.length;aa++){Q=Y[aa];if(Q.cmd){if(v.on){ae.push(Q.cmd)}if(Q.width===b){S=Z}else{S=Q.width}if(Q.height===b){ad=Z}else{ad=Q.height}R=new a.MenuBarButton(i,x.element,Q,Q.bCheckButton);n[Q.cmd]=R;D.push(R);if(Q.groupID!==b){I(R,Q.groupID)}}if(typeof(Q.fnCreate)==="function"){Q.fnCreate.apply(Q.fnCreateInstance,[R,Q])}if(Q.enabled===false){i.enableButton(Q.cmd,false)}}if(v.on){v.log("Button sequence"+O+": "+ae.join(","))}w();var P=q.run("onRegisterExternalMenuButtons");if(P){i.registerExternalButtonsFromContainer(P)}var U=k.iConfig;if(typeof(U.cfg.externalbuttoncontainer)!=="undefined"){i.registerExternalButtonsFromContainer(U.cfg.externalbuttoncontainer)}t("onMenuReady",[i]);for(var X in C){C[X].arButtons[0].setPressed(true)}};this.createHiddenButton=function(O,Q){if(n[O]!==b){return n[O]}var N={cmd:O,bCheckButton:Q};var P=new a.MenuBarButton(i,b,N,N.bCheckButton);P.bUserButton=true;n[N.cmd]=P;D.push(P);return P};this.setCallbacks=function(N){q=N};var t=this.callListeners=function(O,N){if(q){q.run(O,N)}};this.setContainerSize=function(N){var O=i.sprite.element.style.display;i.sprite.element.style.display="block";var P=a.getElementClientDim(i.sprite.element);g=P.height;if(P.width==0&&P.height==0){return}i.sprite.updateDimension();B=N;i.sprite.setSize("100%",g);i.sprite.element.style.display=O;w();if(d){i.sprite.show(true)}};var w=function(){if(!h){return}h.style.display="";if(h.firstChild!==b&&h.firstChild.offsetWidth>0&&x!==b){var N=(i.sprite.element.offsetWidth-x.element.offsetWidth)/2;if(N-8<h.firstChild.offsetWidth){h.style.display="none"}}};this.setPressedExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setPressed(O)}}};this.enableExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setEnabled(O)}}};this.setExternalButtonState=function(Q,P,R){if(L[Q]!==b){var N=L[Q];for(var O=0;O<N.length;O++){N[O].setState(P,R)}}};this.removeExternalButton=function(P,Q){var N=L[P];if(N!==b){for(var O=0;O<N.length;O++){if(N[O].nExternalButtonID===Q){N.splice(O,1)}}}};M.getMenuButtonPresent=function(O){var N=i.getButtonByCMD(O);return(N!==b&&N.bUserButton!==true)};M.registerExternalMenuButtonsFromContainer=this.registerExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Registering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.registerExternalButton(Q[O],R)}}}v.groupEnd()};M.unregisterExternalMenuButtonsFromContainer=this.unregisterExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Unregistering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.unregisterExternalButton(Q[O],R)}}}v.groupEnd()};M.registerExternalMenuButton=this.registerExternalButton=function(O,R,N){var P=R;if(typeof(P)!=="string"||P.length<1){P="user_tool_tip_only"}if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b){return false}if(O.FSIExternalButton!==b){if(v.on){v.error("The dom element has already been registered as external button for command '"+O.FSIExternalButton.getCMD()+"'.")}return false}var Q=new a.MenuBarExternalButton(i,k,O,P);if(!Q.init()){v.error("The dom element could not be registered as external button for command '"+P+"'.",O);Q.destroy();return false}if(Q.bUserButton){v.log("Registering external button for user command: "+P,O)}else{v.log("Registering external button for command: "+P,O)}O.FSIExternalButton=Q;if(L[P]===b){L[P]=[]}L[P].push(Q);if(q.isset("onAfterRegisterExternalButton")){q.run("onAfterRegisterExternalButton",[O,R,(Q.bUserButton!==true)])}};M.unregisterExternalMenuButton=this.unregisterExternalButton=function(O){if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b||typeof(O.FSIExternalButton)!=="object"||typeof(O.FSIExternalButton.destroy)!=="function"){return false}var N=O.FSIExternalButton;if(v.on){v.log("Unregistering external button for command: "+N.getCMD(),O)}O.FSIExternalButton.destroy();O.FSIExternalButton=b;return true};this.getButtonByCMD=function(N){return n[N]};G()};a.MenuBarExternalButton=function(i,e,c,g){var k=this;var h=i;var f="";var j;var d;this.init=function(){if(c.style===b){return false}k.nExternalButtonID=i.getExternalButtonID();d=i.getButtonByCMD(g);if(d===b){d=h.createHiddenButton(g,e.iConfig.makeBool(c.getAttribute("fsi-check-button")))}if(d===b){return false}k.bUserButton=d.bUserButton;f=a.trim(c.className);if(f.length>0){f+=" "}d.addEvents(c);k.setState(d.getState(),d.getCSSClass());k.setEnabled(d.getEnabled());k.setPressed(d.getIsPressed());c.setAttribute("fsi-registered","true");return true};this.getCMD=function(){return g};this.setPressed=function(l){if(l){c.setAttribute("checked","checked")}else{c.removeAttribute("checked")}};this.setEnabled=function(l){if(l){c.removeAttribute("disabled");a.removeClass(c,"fsi-ui-button-disabled")}else{c.setAttribute("disabled","disabled");a.addClass(c,"fsi-ui-button-disabled")}};this.setState=function(l,m){j=l;c.className=f+m};this.destroy=function(l){if(c.FSIExternalButton){d.removeEvents(c);c.FSIExternalButton=b;c.removeAttribute("fsi-registered");if(d){c.className=a.trim(f)}if(!l){h.removeExternalButton(g,k.nExternalButtonID)}}}};a.MenuBarButton=function(u,f,i,h){var q=this;var v=i.cmd;var k=u;var C;this.bEnabled=true;this.id=k.btnID++;var m=false;var B;var c;var l="";var e=true;var d;var y;var x="";var A,r;var g;var j={passive:false,capture:false};var w=function(){B=q.elButton=document.createElement("div");a.addClass(B,"fsi-ui-button");c=document.createElement("div");a.addClass(c,k.iconClassNamesNormal);B.appendChild(c);if(f){f.appendChild(B)}if(v.length>0){l=v.replace(/#.*$/,"")}else{l=""}if(i.cssClass){if(l.length>0){l+=" "}l+=i.cssClass}B.className="fsi-ui-button "+l;if(!i.bNoMouseEvents){q.addEvents(B)}s(1)};var t=function(D){D.cancelBubble=true;if(D.stopPropagation){D.stopPropagation()}if(D.preventDefault){D.preventDefault()}return false};this.addEvents=function(D){a.addEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.addEvent(D,"mousedown",q.onMouseDown,j);a.addEvent(D,"mouseleave",q.onMouseOut,j);a.addEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.addEvent(D,"touchstart",q.onTouchDown,j);a.addEvent(D,"touchcancel",q.onTouchUp,j);a.addEvent(D,"touchend",q.onTouchUp,j)}};this.removeEvents=function(D){a.removeEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.removeEvent(D,"mousedown",q.onMouseDown,j);a.removeEvent(D,"mouseleave",q.onMouseOut,j);a.removeEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.removeEvent(D,"touchstart",q.onTouchDown,j);a.removeEvent(D,"touchcancel",q.onTouchUp,j);a.removeEvent(D,"touchend",q.onTouchUp,j)}};this.destroy=function(){if(!i.bNoMouseEvents){q.removeEvents(B)}if(B&&B.parentNode){a.removeChild(B.parentNode,B)}};this.getCMD=function(){return v};this.makeCheckButton=function(){h=true};this.makeRadioButton=function(){h=true;m=true};this.getState=function(){return C};this.getCSSClass=function(){return B.className};var s=this.setState=function(E){if(C===E){return}if(h){var D=(E>2);if(D!==y){y=D;z("onMenuButtonSetPressed",null,D)}}o(E)};var o=this.setState=function(F){if(F===C){return}C=F;var G="";if(!q.bEnabled){G="fsi-ui-button-disabled "}switch(C){case 2:G+="fsi-ui-button-hover";break;case 3:G+="fsi-ui-button-active";break;case 4:G+="fsi-ui-button-active";if(q.oGroup!==b){for(var E=0;E<q.oGroup.arButtons.length;E++){var D=q.oGroup.arButtons[E];if(D.id!==q.id){D.setPressed(false)}}}break;default:break}if(G!==x){if(x.length>0){a.removeClass(B,x)}if(G.length>0){a.addClass(B,G)}x=G}k.setExternalButtonState(v,C,B.className)};this.onMouseOver=function(D){A=true;var E=D.target;if(a.hasClass(E,"fsi-ui-button-icon")&&E.parentNode){E=E.parentNode}k.showButtonToolTip(q,E);if(!q.bEnabled||!k.bEnabled){return}if(C===1){s(2)}};this.onMouseOut=function(D){A=false;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}if(r){return}if(C!==1&&C!==4){s(1)}};this.onMouseDown=function(D){z("onMenuButtonMouseDown",D);if(D&&D.type==="mousedown"){if(D.preventDefault){D.preventDefault()}if(D.which!==1){return true}}r=true;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}a.addEvent(window,"mouseup",q.onMouseUp);g=true;if(h){if(C===4){if(!m){s(3)}}else{s(4)}}else{s(3)}p(D)};this.show=function(D){if(e===D){return}e=D;q.elButton.style.display=(D)?"":"none"};this.onTouchDown=function(D){if(A){q.onMouseOut(D)}if(r){q.onMouseUp(D)}q.onMouseDown(D)};this.onTouchUp=function(D){if(A){k.hideToolTip();A=false}q.onMouseUp(D);if(D.preventDefault){D.preventDefault()}};this.onMouseUp=function(E){if(g){a.removeEvent(window,"mouseup",q.onMouseUp);g=false}var F=(E&&E.type==="touchend");if(!F&&!r){return}r=false;if(!q.bEnabled||!k.bEnabled){return}if(!F&&!A&&h&&!m){if(C===4){s(1)}else{s(4)}}var D=(!A)?1:2;if(h){if(C===3){s(D)}}else{s(D)}n(E);if(F||A){u.oInterface.clickMenuButton(v,E);z("onMenuButtonClicked",E)}};this.getEnabled=function(){return q.bEnabled};this.setEnabled=function(D){if(q.bEnabled===D){return}if(!D&&d){n()}if(!D&&(C===1||!h)){q.setState(1)}if(D){a.removeClass(B,"fsi-ui-button-disabled")}else{a.addClass(B,"fsi-ui-button-disabled")}q.bEnabled=D;k.enableExternalButtons(v,D);z("onMenuButtonEnabled",null,D);return true};this.getPressed=function(){return(C>2)};this.getIsPressed=function(){return(h&&q.getPressed())};this.setPressed=function(D){if(!h){return}if(D){s(4)}else{s(1)}k.setPressedExternalButtons(v,D)};var p=function(D){d=true;z("onMenuButtonPressed",D);u.oInterface.pressMenuButton(v,D)};var n=function(D){d=false;z("onMenuButtonReleased",D);u.oInterface.releaseMenuButton(v,D)};var z=function(F,D){var E=[v,D];if(arguments.length>2){E=E.concat(Array.prototype.slice.call(arguments,2))}k.callListeners(F,E)};w()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a._API_Viewer!=b){return}a._API_Viewer=function(d,e){var c=this;c.scriptMainFile="FSI.Viewer.js";c.getActiveMenuButtons=function(){if(e.arMenuButtons==b){return b}var f={};for(var g=0;g<e.arMenuButtons.length;g++){var h=e.arMenuButtons[g].cmd;if(h!=b){f[h]=true}}return f};c.oMenuCommands={Reset:1,ZoomOut:1,ZoomIn:1,MouseMode_0:"MouseMode_0",MouseMode_1:"MouseMode_1",MouseMode_2:"MouseMode_2",MaxZoom:1,HotSpots:"Hotspots",ToggleAutoSpin:"autospin-button-toggle",ToggleFullScreen:"FullScreen"};c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeImage:{a:"oParameters, strViewString",r:"bSuccess"},clickMenuButton:{a:"strButtonID"},debugEnabled:{r:"bEnabled"},debugError:{a:"mixed"},debugLog:{a:"mixed"},debugWarn:{a:"mixed"},destroy:{},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getHotspotViewString:{a:"nHotspotID",r:"strViewString"},getImageIsTransparent:{r:"bTransparent"},getInFullScreenMode:{r:"bFullScreen"},getInitDone:{r:"bInitDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getMenuButtonPresent:{a:"strButtonID",r:"bPresent"},getMenuHeight:{a:"strPurpose",r:"nHeight"},getMouseMode:{r:"nMouseMode"},getParameters:{r:"oParameters"},getPluginParameter:{a:"strPluginName, strParameterName, defaultValue, bMakeBoolean",r:"mixed"},getSkinClassName:{r:"strClassName"},getSpinFrames:{r:"nFrames"},getSrcDim:{r:"oDimension"},getVersion:{r:"strVersion"},getViewString:{r:"strViewString"},getZoom:{r:"fZoomInPercent"},gotoHotspot:{a:"FSIHotspotID, bAnimate",r:"bSuccess"},gotoViewString:{a:"strView, bAnimated",r:"bSuccess"},hideMenuToolTip:{},init:{a:"elementID, oParameters, bDebug"},makeBoolean:{a:"value, bDefaultValue",r:"bResult"},pressMenuButton:{a:"strButtonID"},printAPI:{},registerExternalMenuButton:{a:"elButton, strButtonID, strTip"},registerExternalMenuButtonsFromContainer:{a:"elContainer"},releaseMenuButton:{a:"strButtonID"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},resetView:{},setFullScreenElement:{a:"elFullScreenContainer",r:"bSuccess"},setMouseMode:{a:"nMode"},setZoom:{a:"fZoomPercent, bPreliminary, bAnimate"},showAboutWindow:{},showMenuButton:{a:"strButtonID, bShow"},showMenuToolTip:{a:"strTip, elSrc, x, y"},spinToDegree:{a:"fDegree"},spinToTarget:{a:"nTargetFrame, nStopSceneSet, nFrames"},start:{},startAutoSpin:{r:"bSuccess"},stopAutoSpin:{r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unregisterExternalMenuButton:{a:"elButton"},unregisterExternalMenuButtonsFromContainer:{a:"elContainer"},updateSize:{}};c.oProperties={};c.oCallbacks={onAfterRegisterExternalButton:{a:"elButton, strButtonID, bButtonPresentInViewer"},onAnimationComplete:{},onAnimationStart:{},onChangeConfig:{a:"strCfgFileName, oParameters"},onChangeImage:{a:"oParameters, strView"},onClickDemoMode:{a:"url, targetFrame"},onConfigsReady:{a:"oConfigValues"},onDataComplete:{},onDestroy:{},onEnterDemoMode:{},onExitDemoMode:{},onFullScreen:{a:"bSet"},onHotspotEvent:{a:"strAction, nHotspotID, strHotspotAttributeID, strContent"},onInit:{a:"oParameters)"},onInitFailed:{a:"strReason"},onInitMenu:{},onMenuButtonEnabled:{a:"strButtonID, null, bEnable"},onMenuButtonPressed:{a:"strButtonID, evt"},onMenuButtonReleased:{a:"strButtonID, evt"},onMenuButtonClicked:{a:"strButtonID, evt"},onMenuButtonSetPressed:{a:"bPressed"},onMenuDestroy:{},onMenuEnabled:{a:"bEnabled"},onMenuReady:{},onMouseModeChanged:{a:"nMouseMode"},onProgress:{a:"fPercent"},onReady:{},onRegisterExternalMenuButtons:{},onReset:{},onResize:{a:"nWidth, nHeight, bResizeDone, bFullscreen"},onSkinChanged:{a:"strCurrentSkinClass, strCurrentSkinClassBefore"},onStartDragging:{a:"bInNavWindow"},onStopDragging:{a:"bInNavWindow"},onViewChanged:{a:"strViewString"},onZoomChanged:{a:"fScale, fScaleMax"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Viewer!=b){return}a.Viewer=function(gj,ei){var gM={};var ax={strVersion:"2018",strBuild:"18.06.18.8",strConfigSection:"Viewer",oTraceConfigParameters:ei,bHasListeners:true};var cE=new a.ClassDef(this,"FSI Viewer",ax);cE.oAPI=new a._API_Viewer(this,gM);var ba=cE.instance;a.guessFSIViewerLocation("fsiviewer.js",3);var dQ=a.getViewerInstanceID();this.getInstanceID=gM.getInstanceID=function(){return dQ};this.getInstanceName=function(){return cE.strClassName+" ["+M+"]"};this.debugLog=function(){dv.log.apply(dv,arguments)};this.debugWarn=function(){dv.warn.apply(dv,arguments)};this.debugError=function(){dv.error.apply(dv,arguments)};this.debugEnabled=function(){return dv.on};var gO;var f4,c9,b4;var am;var m;var c6;var ep;var h;var gs={};var S;var dy;var A;var eV;var bx;var di=false;var F;var dC=0;var fx=0;var aA={};var dB,dR;var eA;var bL;var b6;var cB;var bF,a2;var dD=false;var g1;var H;var aT;var bo={};var fD={};var aK;var aI;var eN=8;var hl=1;var ac;var d=false;var g3=false;var f1;var ca;var bs;var c2;var e3;var ha,cT;var e2;var by=true;var gz=100;var b5=true;var eC;var bU;var ay;var c0;var g2;var du;var eJ;var r;var bn;var dN=false;var fn=new a.CroppedImage();var fm=new a.Rect();var aF=a.Easing.easeOutCubic;var eQ;var eR={width:0,height:0};var bI;var T;var at;var gN;var bv;var aP={};var cD=10000;var hg=cD;var e1;var bq;var Q;var df;var aX={x:0,y:0,z:0};var gQ;var gH;var ab;var a1=new a.Rect(0,0,-1,-1);var dJ=new a.Rect(0,0,-1,-1);var fs=new a.Rect(0,0,-1,-1);var fK=new a.Rect(0,0,-1,-1);var fX=new a.Rect(0,0,-1,-1);var aJ=new a.Rect(0,0,0,0);var gD=new a.Rect(0,0,0,0);var aw=false;var R=true;var hc=!(a.isChrome);var d3=false;var bH=false;var bK=false;var c1=true;var dK=false;var z;var fd=false;var g6;var dc=false;var gB=true;var gZ=false;var fT=false;var fo;var b1=new a.Rect(0,0,0,0);var ew=0;var dk;var cM=0;var bz=0;var ad=0;var aR;var em=0;var ec=0;var cu=0;var dA={x:0,y:0};var W={};var bd={};var v={};var ey="auto";var eB;var fp=1;var aq;var bl;var gt=true;var aU={};var cK,cJ;var fw=b;var f;var c5;var hj=false;var eE=false;var dW=true;var dh=true;var gl=false;var cl=false;var e6=false;var fB;var b9;var gS;var br=false;var gE;var ez;var be;var fa={};var cr;var dj;var ga;var cs;var dY;var d6,dO;var Y;var ea;var ek;var dr;var hf;var e=[];var gX=[];var dE;var dL={};var cw={};var ge;var d8=false;var he;var bA,dn;var dP;var e5={};var M;var dF;var V;var g4={};var ah;var bc=gM.viewport={};var dz=a.SVGNameSpaceURL;var fO="1.1";var bu;var gY;var ao;var cf=1;var bb=1;var aD;var ch;var e4;var fr=0;var e0=1;var an=2;var f3=fr;var gi;var i=false;var aZ;var bT;var fS;var g7;var aG=false;var fI=false;var gk;var eL=1;var b2={};var E=false;var K;var f6;var gv;var fv;var cS={width:0,height:0};var b3=false;var aE=false;var d7;var ci="&limit=0,360";var eW;var gP=false;var gJ;var w;var fZ={};var fq=false;var bX;var cn="&effects=Matte(FFFFFF)";var c;var al;var au;var cY={};var bm=true;var f8;var cQ;var fM;var dI;var bC=0;var cv=0;var bE={};var cN=false;var eU=true;var G;var fi={};var ak=0;var aW={};var cO={};var gf;var eb={};var dv=new a.EmptyDebugger();var g9=function(hm,o){if(o&&!dv.on&&hm.on){ge.stopPendingRequests();ba.destroy(true);ba.init(gf,eb,true);ba.start();return true}dv=hm;if(cB){cB.setDebug(dv)}if(dv.on){dv.setPrefix(ba.getInstanceName())}};var f9=gM;f9.iViewer=ba;f9.getDebug=function(){return dv};f9.getToolTip=function(){return fM};f9.getElementSpace=function(){return ah};f9.getDrawRatio=function(){return W};f9.getdrawRatioUnZoomed=function(){return bd};f9.getdrawRatioUnResized=function(){return v};f9.getinPlaceZoom=function(){return b2};f9.getRootContainer=function(){return gO};f9.getParentElement=function(){return am};f9.getCallbacks=function(){return cB};f9.getIsFullScreen=function(){return d8};f9.getImageArray=function(){return gX};f9.getCurrentSkin=function(){return aU};this.init=function(hm,hp,o){if(gl){ba.destroy()}gf=hm;if(typeof(hm)=="object"){if(typeof(hm.id)=="string"){M=hm.id}}else{if(typeof(hm)=="string"){M=hm}}if(!M){M="fsi.viewer #"+dQ}if(ba._fsi_parameters){hp=ba._fsi_parameters;delete ba._fsi_parameters;ba._fsi_parameters=b}if(a.isMobileDevice){gi=5000000}else{gi=8000000}aK=new a.IMGLoadingEngine(ba,eY);var hn;if(typeof(hm)=="object"&&hm.tagName!=b){hn=hm}else{hn=document.getElementById(hm)}if(typeof(hp)=="object"&&typeof(window[hp.oninit])=="function"){window[hp.oninit](ba,M,hp)}eb=(hp&&typeof(hp)=="object")?a.cloneParameters(hp):{};gq();var ho=eb;if(o){ho=a.cloneObject(eb);ho.debug=true}ge.init(ho);if(dv.on){dv.log(ba.getVersion())}y();if(!hn){dv.error("A DOM element with the id '"+hm+"' could not be found. Aborting.");return}bu="1.5px";if(a.isSmallMobileDevice){dv.log("Small mobile Device detected.");b3="fsi-ui-hotspot-mobile fsi-ui-hotspot-mobile-small";bu="4px"}else{if(a.isMobileDevice){dv.log("Mobile Device detected.");b3="fsi-ui-hotspot-mobile"}}if(hn.firstChild!=b){hn.innerHTML=""}am=hn;if(am.tagName.toLowerCase()!="fsi-viewer"){a.addClass(am,"fsi-viewer")}am.setAttribute("x-fsi-id",M);e4=(a.isMobileDevice)?0.2:0.15;if(!gO){gO=document.createElement("div");gO.className="fsi-root fsi-viewer-root";a.setStyleAttr(gO,"position:relative;left:0px;top:0px;padding:0px;margin:0px;border:0px none;z-index:0;width:100%;height:100%;text-align:left;vertical-align:top;");hn.appendChild(gO)}af();dt(true);if(dv.on){dv.log("Container element: "+ah.width+" x "+ah.height+" ("+hn.nodeName+")")}gl=true;bn=a.getCSSTransformStyleName();eC=false};var gq=function(){var o={};o.onConfigsReady=d0;o.onDebuggerChange=g9;ge=gM.iConfig=new a.Config(null,o,{strSection:cE.strConfigSection});ge.setEffectsFilterArea();ba.loadFile=ge.loadFile;if(aT){ge.setAccessToken(aT)}if(!cB){cB=gM.iCallbacks=new a.Callbacks(ba,ge)}else{cB.setConfig(ge)}};this.getInitDone=function(){return gl};gM.getViewportSize=function(){return bc};var af=function(){var o=a.getBoundingClientRect(gO);ah={width:o.width,height:o.height};var hm=(gs&&gs.minInstanceSize>1)?gs.minInstanceSize:60;if(ah.width<hm||ah.height-cv<hm){ah.visible=false;ah.width=hm;ah.height=hm+cv}else{ah.visible=true}bc.width=ah.width;bc.height=ah.height-cv};var bW=function(o){if(bX==o){return}if(g7){if(bX!=b){a.removeClass(g7,"fsi-ui-cursor-"+bX)}if(o!=b){a.addClass(g7,"fsi-ui-cursor-"+o)}}bX=o};var fC=function(hs,hr,hu,hq,o){var ho=bc.width*at.scale;var hm=bc.height*at.scale;if(hs==b){hs=ho/2}if(hr==b){hr=hm/2}var hn;if(hu!=b){hn=Math.max(1,Math.min(b2.maxScale,b2.scale+hu))}else{hn=b2.defaultZoom}var ht=hn/b2.scale;hs=ht*(b2.panPos.left-(hs-ho/2));hr=ht*(b2.panPos.top-(hr-hm/2));var hp=(hq)?0:o;eM(hs,hr,hn,hp)};var gm=function(o,hp,hn,hm){if(!b2.enabled){return}if(b2.panPos.left==0&&b2.panPos.top==0&&(gY<=1||(Q&&b2.targetZoom==1))){return}var ho=(hn)?0:hm;eM(0,0,1,ho)};var eF=function(o){if(at.scale>1){o.scaleRect(1/at.scale)}var hv=o.width();var hq=o.height();if(hv<1||hq<1){return}var hr=hv/hq;var hp=bc.width/bc.height;if(hr>hp){hq=hv*bc.height/bc.width;o.inflateRect(0,hq-o.height())}else{if(hr<hp){hv=hq*bc.width/bc.height;o.inflateRect(hv-o.width(),0)}}var hm=gY*bc.width/hv;hm=Math.max(1,Math.min(b2.maxScale,hm));var hu=hm/gY;var ho=o.left+o.width()/2;var hn=o.top+o.height()/2;var ht=(b2.panPos.left-ho+bc.width/2)*hu;var hs=(b2.panPos.top-hn+bc.height/2)*hu;eM(ht*at.scale,hs*at.scale,hm)};var eM=function(o,hp,ho,hm){ho=Math.max(1,Math.min(b2.maxScale,ho));eu();b2.pos=0;b2.frames=(hm!=b)?hm:28;if(b2.frames<1){b2.frames=1}b2.sourceZoom=b2.scale;b2.sourceX=b2.panPos.left;b2.sourceY=b2.panPos.top;if(o==b){o=b2.sourceX}if(hp==b){hp=b2.sourceY}var hn=gW(o,hp,ho);b2.targetX=hn.x;b2.targetY=hn.y;b2.targetZoom=ho;b2.dX=hn.x-b2.sourceX;b2.dY=hn.y-b2.sourceY;b2.dZoom=ho-b2.sourceZoom;bf()};var x=gM.stopAfterTouch=function(){if(G){G.cancelAfterTouch()}};var aM=gM.autoShowHideHotSpots=function(o){if(dh==o){return}dh=o;if(!eE||!a.isMobileDevice){return}dW=o;fY(o);dH();if(o){g5()}};var bf=function(){if(Q){return}dn=false;b2.lockPanAnimation=false;E=true;aM(false);Q=true;cB.run("onAnimationStart");g5()};var eu=gM.stopDesktopAnimation=function(){if(Q){aM(true);E=false;Q=false;b2.pos=b2.frames=0;b2.targetZoom=b;b0();dT();fN();cV()}};var ce=function(){if(Q||hj){return}cB.run("onAnimationComplete")};var ft=function(){b2.pos++;f0(aF(b2.pos,b2.frames,b2.sourceZoom,b2.dZoom,3));if(!b2.lockPanAnimation){b2.panPos.left=aF(b2.pos,b2.frames,b2.sourceX,b2.dX,3);b2.panPos.top=aF(b2.pos,b2.frames,b2.sourceY,b2.dY,3)}b0();if(b2.pos===b2.frames){eu();ce();if(dn){fA()}return false}return true};var eP=gM.onAfterinPlaceZoomChanged=function(){b0();dT();fN()};this.getMouseMode=function(){return eB};var e9=this.setMouseMode=function(o){if(G){G.cancel()}ey=o;switch(o){case"auto":if(w){o=(b2.bZoomedIn)?1:0}else{o=(b2.bAutoMouseModePan)?1:2}break;case 0:case 1:break;case 2:if(w){o=(b2.bZoomedIn)?1:0}else{o=2}break}cL(o)};var cL=function(o){eB=o;switch(eB){case 0:bW("zoom");break;case 1:bW("pan");break;case 2:if(aW.nSceneSets>1){bW("rotate3d")}else{bW("rotate")}break}cB.runPersistent("onMouseModeChanged",[eB]);if(cQ){cQ.setButtonPressed("MouseMode_"+eB,true)}};var fN=function(){if(!b2.enabled||ey!="auto"){return}var o=(b2.scale>1);if(b2.bZoomedIn==o){return}b2.bZoomedIn=o;if(o){b2.bAutoMouseModePan=true;cL(1)}else{b2.bAutoMouseModePan=false;if(w){cL(0)}else{cL(2)}}};var gW=function(o,hs,hr){var hp={x:o,y:hs};var hq=Math.round(bd.imageWidth*hr);var hn=Math.round(bd.imageHeight*hr);var ho=Math.max(0,(hq-W.maxPanReferenceWidth)/2);var hm=Math.max(0,(hn-W.maxPanReferenceHeight)/2);hp.x=Math.max(-ho,Math.min(ho,o));hp.y=Math.max(-hm,Math.min(hm,hs));return hp};this.getZoom=function(){return gY/b2.maxScale*100};this.setZoom=function(hn,o,hm){if(!cl||!b2.enabled){return false}az(true);eu();hn=hn*b2.maxScale/100;if(hm){eM(b,b,hn);return}else{f0(hn)}b0(o);if(!o){dT();fN()}return true};this.gotoHotspot=function(hn,hm){if(!cl){return false}az();if(hm!==false){hm=true}var o=ba.getHotspotViewString(hn);if(o===false){return false}gT(o,hm);return true};this.getHotspotViewString=function(o){if(!cl||eA[o]==b){return false}return fe(eA[o],true,true)};var fe=function(hu,hE,ht){if(typeof(hu)!="object"){return false}if(ht==b){ht=hu.rotateOnFocus}if(hE==b){hE=hu.zoomOnFocus}var hN;var hv;var o=(aW.nCurrent==b)?0:aW.nCurrent;var hB=o+1;var hG=Math.round(ew/(em/bz));var hL=1+hG;var hz=false;var hF=false;var hO=false;var hr=ec;var hA;var hs=false;if(ht){if(hu._focusSceneSet!=b){hs=true;if(hu._focusSceneSet!==false){hB=hu._focusSceneSet}}else{if(aW.nSceneSets==b||aW.nSceneSets<2||hu.perimeterAngleX==b){hu._focusSceneSet=false}else{var hM=cF();var hH=hM.angle;var hq=Math.abs(hM.stepAngle);hA=(hu.focusAngleX!=b)?hu.focusAngleX:hu.perimeterAngleX;if(typeof(hA)=="number"){var hP=hA-hH;if(!isNaN(hP)){while(hP<0){hP+=360}while(hP>360){hP-=360}var hp=Math.round(hP/hq);hp=Math.max(0,Math.min(aW.nSceneSets,hp))+1;if(hp!=hB){hB=hp;if(hE){hF=ew;hO=hz=true;fL(hB-1)}}}hu._focusSceneSet=false}else{hu._focusSceneSet=false}hu._focusSceneSet=hB}}if(hu._focusScene!=b){hs=true;if(hu._focusScene!==false){hL=hu._focusScene}}else{hA=(hu.focusAngleY!=b)?hu.focusAngleY:hu.perimeterAngleY;if(typeof(hA)=="number"){var hC=he(Math.round(hA/360*bz))+1;hF=he(Math.round(hA/360*em));if(!isNaN(hC)){if(hE){if(hF!=ew){hz=true}}hu._focusScene=hL=hC;hu._focusSpinPos=hF}else{hu._focusScene=false}}else{hu._focusScene=false}}}var hy=(ht&&typeof(hu._focusScene)=="number"&&typeof(hu._focusSceneSet)=="number");if(hE&&ht&&hs&&!hy){if(hu._focusSceneSet!==false&&hu._focusSceneSet!=hB){hF=ew;hO=hz=true;fL(hu._focusSceneSet-1)}if(hu._focusScene!==false&&hu._focusScene!=hG){hF=hu._focusSpinPos;hz=true}}if(hz){cb(hF);er()}if(hE==true){if(hy&&hu._focusZoom!=b){hv=hu._focusZoom}else{var hx=new THREE.Vector3();dL.camera.setViewOffset(bc.width,bc.height,0,0,bc.width,bc.height);if(hz){dL.renderer.render(dL.scene,dL.camera)}hx.setFromMatrixPosition(hu.object.matrixWorld);hx.project(dL.camera);var hK=0.5;var hm=0.5;var hJ=bd.imageWidth/bc.width;var hI=bd.imageHeight/bc.height;var ho=hx.x/hJ*hK+hK;var hn=hm-hx.y/hI*hm;gZ=true;var hD=new a.Rect(ho,hn,ho,hn);if(typeof(hu.focusRadius)=="number"&&hu.focusRadius>0){hD.inflateRect(hu.focusRadius,hu.focusRadius)}hv=hD.toString();if(hy){hu._focusZoom=hv}}}if(hO){fL(o)}if(hz){cb(hr);er();g5()}hN=hB+","+hL;if(hv!=b){hN+=","+hv}return hN};var ct=this.getViewString=function(){if(!au){return b}var ho=[];var hs=aW.nCurrent+1;var hp=1+Math.round(ew/(em/bz));if(isNaN(hp)){hp=1}var hq=W.imageWidth;var hn=hq/au.width*au.height;var ht=hl/gY;var hr=0.5-b2.panPos.left/hq-ht/2;var hm=0.5-b2.panPos.top/hn-ht/2;var o=new a.Rect(hr,hm,hr+ht,hm+ht);o.round();ho.push(hs);ho.push(hp);ho.push(o.toString());ho.push(0);return ho.join(",")};var eH=function(hn,hm){var o=parseFloat(hn);if(isNaN(o)){o=hm}return o};var cH=function(hn){if(typeof(hn)!="string"){hn=""}var o=[1,1,0,0,1,1,0];hn=hn.split(",");for(var hm=hn.length;hm<7;hm++){hn.push(o[hm])}return hn.join(",")};var eq=function(hr){var hq={SceneSet:0,scene:0,frame:0};if(hr==b||typeof(hr)!="string"||hr.length<3){return hq}var ht=hr.split(",");if(ht.length<2){return hq}if(aW.nSceneSets<2){hq.SceneSet=0}else{hq.SceneSet=parseInt(ht[0])-1;if(isNaN(hq.SceneSet)){hq.SceneSet=b}}hq.scene=parseInt(ht[1]);if(isNaN(hq.scene)){hq.scene=1}hq.scene=hq.scene%bz-1;if(hq.scene<0){hq.scene+=bz}hq.frame=hq.scene*em/bz;if(ht.length>5){var hw=eH(ht[2],0);var hn=eH(ht[3],0);var hv=eH(ht[4],1);var ho=eH(ht[5],1);var hm=hq.rc=new a.Rect(hw,hn,hv,ho);hm.normalizeRect();var hp=hm.width();var hx=hm.height();var hy=1/Math.max(hp,hx);hq.zoom=hy=Math.max(1,Math.min(b2.maxScale,hy));var hu=bd.imageWidth;var hz=bd.imageWidth/au.width*au.height;hq.x=-hu*hy*((hm.left+hm.width()/2)-0.5);hq.y=-hz*hy*((hm.top+hm.height()/2)-0.5);var hs=gW(hq.x,hq.y,hq.zoom);hq.x=hs.x;hq.y=hs.y}return hq};var gT=this.gotoViewString=function(hn,ho){if(!cl){return false}az();var o=(ho)?30:0;var hm=eq(hn);if(hm.scene==b){return false}var hp=eq(ct());if(hm.SceneSet==hp.SceneSet&&hm.scene==hp.scene&&Math.abs(hm.x-hp.x)<1&&Math.abs(hm.y-hp.y)<1&&Math.abs(hm.zoom-hp.zoom)<0.000001){if(dn){fA()}return true}if(hm.SceneSet!=hp.SceneSet||hm.scene!=hp.scene){ba.spinToTarget(hm.frame,hm.SceneSet,o)}if(b2.enabled&&hm.rc!=b){eM(hm.x,hm.y,hm.zoom,o)}return true};this.changeImage=function(ho,hp){cB.run("onChangeImage",[ho,hp]);ge.makeObjectPropertiesLowerCase(ho);if(!e6){fB=arguments;return false}al=ct();if(dv.on){a.console.log("")}dv.log("--- changeImage() called ---");ge.stopPendingRequests();var hr=false;if(ho!=b){if(ho.fpxsrc!=b||ho.imagepath!=b){hr=true}if(ho.dir!=b){hr=true}}if(!hr){return ba.gotoViewString(hp,true)}if(ho.imagepath!=b){ho.fpxsrc=ho.imagepath;ho.imagepath=b}ho.fpxsrc=encodeURIComponent(ho.fpxsrc);var o=["imagesrc","imagepath","imagesources","imagewidth","imageheight","imagetilesx","imagetilesy","imagetransparency","images3durl"];var hn=ge.cfgAliasNames;var hm=ge.cfg;for(var hq=0;hq<o.length;hq++){var hs=o[hq];delete hm[hs];if(hn[hs]){delete hm[hn[hs]]}}ge.setCfgValues(ho);y();c=hp;bp();ge.dumpConfig();fG();return true};var f7=function(){var o=bI;if(gY<=1){e3=1;o=aD}else{var hn=gY*v.imageWidth;var hp=Math.round(au.width/eR.width*hn);var ho;for(var hm=0;hm<bs.length;hm++){if(bs[hm]>=hp){ho=T=bs[hm];break}}if(!ho){if(bs.length>0){ho=bs[bs.length-1]}if(ho<=1.1*v.imageWidth){ho=b}}if(ho){o=Math.round(ho*fn.getImageRect().width()/au.width)}e3=o/aD}return o};var f0=function(o){o=Math.max(1,Math.min(b2.maxScale,o));b2.scale=o;gY=b2.scale*at.scale;ao=Math.min(b2.maxScaleInitial,cf*b2.scale);c2=b2.scale*cf};var fJ=function(){var o=Math.min(b2.maxScaleInitial,cf);if(o*b2.scale>b2.maxScaleInitial){b2.scale=b2.maxScaleInitial/o}ao=Math.min(b2.maxScaleInitial,cf*b2.scale);return o};var Z=function(o){at.scale=o;gY=at.scale*b2.scale;ao=Math.min(b2.maxScaleInitial,cf*b2.scale);b2.scale=Math.max(1,ao/cf);c2=cf*b2.scale};var b0=gM.updateInPlaceZoom=function(hn){if(Q){hn=true}var ho=false;if(hn){if(b2.nLastScalePreliminary!=gY){b2.nLastScalePreliminary=gY;ho=true}}else{if(b2.nLastScaleFinal!=gY){b2.nLastScaleFinal=gY;ho=true}}if(ho){if(!hn&&cJ){cB.runPersistent("onZoomChanged",[gY,b2.maxScaleInitial])}if(hn&&dj&&gY-dj.renderScale<-1){fl()}W.imageWidth=g4.testWidth=Math.round(v.imageWidth*gY);W.imageHeight=Math.round(v.imageHeight*gY);W.imageX=Math.round(bd.imageX-(W.imageWidth-bd.imageWidth)/2);W.imageY=Math.round(bd.imageY-(W.imageHeight-bd.imageHeight)/2);W.maxImageOffsetX=Math.floor(Math.max(0,(W.imageWidth-W.maxPanReferenceWidth)/2-0.01));W.maxImageOffsetY=Math.floor(Math.max(0,(W.imageHeight-W.maxPanReferenceHeight)/2-0.01));if(gS){W.videoWidth=Math.round(v.videoWidth*gY);W.videoHeight=Math.round(v.videoHeight*gY);W.videoX=bd.videoX-(W.videoWidth-bd.videoWidth)/2;W.videoY=bd.videoY-(W.videoHeight-bd.videoHeight)/2}if(!hn){var o;o=(b2.scale>1);cx("ZoomOut",o);if(f3<an){cx("MouseMode_1",o)}o=(b2.scale<b2.maxScale);var hm=cx("ZoomIn",o);cx("MaxZoom",eR.width!=W.imageWidth);bI=f7();cB.run("onAnimationComplete")}}if(!Q){b2.panPos.left=Math.max(-W.maxImageOffsetX,Math.min(W.maxImageOffsetX,b2.panPos.left));b2.panPos.top=Math.max(-W.maxImageOffsetY,Math.min(W.maxImageOffsetY,b2.panPos.top))}if(!hn){b2.panPos.left=Math.floor(b2.panPos.left);b2.panPos.top=Math.floor(b2.panPos.top)}gZ=true;dH();z=true;g5();if(!hn){ag()}};var ag=function(){if(!cB.isset("onViewChanged")){return}if(bF!=b){clearTimeout(bF)}bF=setTimeout(bD,250)};var bD=function(){bF=b;var o=ct();if(o==a2){return}a2=o;cB.runPersistent("onViewChanged",[o])};var dT=function(){if(!c5&&!hj){ff()}};var cg=function(){var o=a.getElementClientPos(e2);a1.copyRect(b1);fX.copyRect(o);a1.interSectRectValidate(fX);a1.offsetRect(-fX.left,-fX.top);var hm=(a1.width()>0&&a1.height()>0);var hn=(hm!=at.visible);at.visible=hm;return hn};var ck=function(o){fK.copyRect(o);fK.offsetRect(-v.imageX,-v.imageY);if(by&&fK.width()>0&&fK.height()>0){fK.inflateRect(gz/gY,gz/gY)}fK.scaleRect(e3)};var k=function(){var hm;var o;hm=(a1.left+a1.width()/2)-at.widthUnScaled/2;if(at.leftLast!=hm){at.leftLast=hm;if(hm<0){hm=0}if(hm>at.maxLeft){hm=at.maxLeft}at.left=hm}at.drawOffsetX=at.scale*-at.left;o=(a1.top+a1.height()/2)-at.heightUnScaled/2;if(at.topLast!=o){at.topLast=o;if(o<0){o=0}if(o>at.maxTop){o=at.maxTop}at.top=o}at.drawOffsetY=at.scale*-at.top;if(d3){dG(at.totalWidth,at.totalHeight);gZ=true;dH()}};var dG=function(hn,hp){if(dL.renderer.setSizeNeLa){dL.renderer.setSizeNeLa(hn,hp)}else{var o=ga.style.width;var ho=ga.style.height;var hq=ga.width;var hm=ga.height;dL.renderer.setSize(hn,hp);ga.style.width=o;ga.style.height=ho;ga.width=hq;ga.height=hm}};var s=function(hm,ho){if(e1){return}var hv=cf;if(!i){l(W.widthForRatio,W.heightForRatio,true);g5();return}var hq=false;var hn=fJ();c2=b2.scale*cf;var hs=cg();if(hs){hm=true}else{if(!at.visible){return}}if(!hm&&dj){if((hs&&!at.visible)||(at.widthUnScaled<a1.width()||at.heightUnScaled<a1.height()-cv)||(Math.abs(hn-at.scale)>1)){if(hv>1){hv=1;hm=true}}}if(!hm){var hp=at.left;var hz=at.top;k();df=(hp!=at.left||hz!=at.top);z=true;g5();return}if(ho||at.lastScale!=hn){at.lastScale=hn;Z(hn);var hr=Math.ceil(bc.width*hn);var o=Math.ceil(bc.height*hn);var hy,hx;var hw=0;if(by){hw=gz}var ht=a.getVisualViewportSize();at.maxWidth=Math.round((ht.width*cf+hw)*hn/hv);at.maxHeight=Math.round((ht.height*cf+hw)*hn/hv);if(hr>at.maxWidth){hy=at.maxWidth}else{hy=hr}if(o>at.maxHeight){hx=at.maxHeight}else{hx=o}at.width=hy;at.height=hx;at.widthUnScaled=Math.ceil(hy/hn);at.heightUnScaled=Math.ceil(hx/hn);at.totalWidth=hr;at.totalHeight=o;hq=(ho||ga.width!=hy||ga.height!=hx)}at.maxLeft=(at.totalWidth-at.width)/at.scale;at.maxTop=(at.totalHeight-at.height)/at.scale;if(eC){if(at.scale!=1){var hu=1/at.scale;if(b5){at.strTransformScale=" scale3d("+hu+","+hu+","+hu+")"}else{at.strTransformScale=" scale("+hu+","+hu+")"}}else{at.strTransformScale=""}}else{at.strTransformScale=""}k();if(hq){if(b5){g(ga,"translate3d("+at.left+"px,"+at.top+"px,0px)"+at.strTransformScale)}else{g(ga,"translate("+at.left+"px,"+at.top+"px)"+at.strTransformScale)}if(!eC){ga.style.width=hy/hn+"px";ga.style.height=hx/hn+"px"}ga.width=hy;ga.height=hx;cs=ga.getContext("2d");ha=hr;cT=o;l(W.widthForRatio,W.heightForRatio,true);bI=f7();if(b2.enabled){cZ();b0()}}else{if(b5){g(ga,"translate3d("+at.left+"px,"+at.top+"px,0px)"+at.strTransformScale)}else{g(ga,"translate("+at.left+"px,"+at.top+"px)"+at.strTransformScale)}if(!eC){ga.style.width=ga.width/hn+"px";ga.style.height=ga.height/hn+"px"}}if(!b9){ff();z=true;g5()}else{cI()}};var g=function(o,hm){o.style[bn]=hm};this.showAboutWindow=function(){if(m){m.destroy();m=b;return}var o={};o.title="About FSI Viewer";o.fnOnDestroy=hi;o.strLongVersion=ba.getVersion();m=new a.AboutWindow(gO,o)};var hi=function(){m=b;return true};this.getParameters=function(){return a.cloneParameters(eb)};this.getConfigValue=function(o){if(ge&&typeof(o)==="string"){return ge.cfg[a.trim(o.toLowerCase())]}};this.makeBoolean=function(hm,o){if(ge){return ge.makeBool(hm,o)}};this.getPluginParameter=function(ho,hn,hm,o){if(ge){return ge.getPluginParameter(ho,hn,hm,o)}};this.changeConfig=function(o,hm){cB.run("onChangeConfig",[o,hm]);if(dv.on){a.console.log("")}al=ct();gh();if(hm!=null&&typeof(hm)=="object"){eb=a.cloneParameters(hm)}if(typeof(o)=="string"){eb.cfg=o}gq();dD=true;gh();ba.start()};var fb=function(o,hm){if(!o){return}if(!hm){if(o.FSI_prevDisplayState==b){o.FSI_prevDisplayState=o.style.display}o.style.display="none"}else{if(o.FSI_prevDisplayState!=b){o.style.display=o.FSI_prevDisplayState}o.FSI_prevDisplayState=b}};var fY=function(o){if(!di){o=false}fb(V,o)};var a4=this.onResize=function(o){if(eI()){return}if(!e1){e1=true;hb();bq=ct();if(G){G.cancel()}fb(g7,false);fY(false);if(fM){fM.hide()}}if(o.FSI_after_treshold!=b){bV()}dt(o.FSI_after_treshold)};var dt=function(o){var hm=a.getElementDimension(gO);cB.runPersistent("onResize",[hm.width,hm.height,(o!=b),d8])};this.updatePosition=function(){cg();z=true;g5()};this.updateSize=function(){dx();gQ=setTimeout(hd,0)};var dx=function(){if(gQ===b){return}clearTimeout(gQ);gQ=b};var hd=function(){dx();ba.updatePosition();bV()};var bV=function(hm){var ho={};ho.width=bc.width;ho.height=bc.height;var o;if(gs.keepViewOnResize){if(!bq){bq=ct()}o=bq}bq=false;e1=false;af();fb(g7,true);fY(true);if(!hm&&ho.width===bc.width&&ho.height===bc.height){return}hb();es();if(ga==b||bc.width<1||bc.height<1){return}var hn=c0;ha=bc.width;cT=bc.height;l(W.widthForRatio,W.heightForRatio);l(W.widthForRatio,W.heightForRatio,true);fz();z=true;if(d3){dG(bc.width,bc.height);cd();dH();gZ=true}eJ=c0=b;fl();aH();if(f8){f8.setContainerSize(ah,W,bd)}if(cQ){cQ.setContainerSize(ah)}e7();b0();eO(hn);if(o&&!fD.bEnabled){gT(o)}s(true)};var gh=function(){if(e5.nInterval!==b){clearInterval(e5.nInterval);e5.nInterval=b}dx();a.FullScreen.removeChangeEvents(window,cP,aV);cB.run("onReset");if(cQ){cQ.unregisterExternalButtons()}if(bF){clearTimeout(bF);bF=b}a2=b;cB.removeConfigListeners();g0();if(gE){gE.remove();gE=b}hb();aA={};dZ();aP={};dv=new a.EmptyDebugger();y();if(ge){ge.reset();ge.init(eb)}gs={}};var gG=function(){if(eQ&&bT){eQ.lockImageSourceDimension(bT,false);eQ.lockImage(bT,false);eQ.removeImages(bT,false)}};var cZ=function(){b2.nLastScalePreliminary=b;b2.nLastScaleFinal=b};var aH=function(){cZ();bI=T=b;fo=b};var gA=function(){g4={}};var es=function(){at=gM.oDynamicCanvas={};at.lastScale=b;Z(1);var o,hm;if(ga){o=ga.width;hm=ga.height}at.leftLast=at.topLast=b;at.width=at.widthUnScaled=at.totalWidth=o;at.height=at.heightUnScaled=at.totalHeight=hm;at.left=at.top=0;at.drawOffsetX=at.drawOffsetY=0};var y=function(){dx();hb();aK.abortAll();dC=0;gB=true;bB();if(G){G.cancel()}az();bP();eu();fl();ai();ej();b2.panPos={left:0,top:0};b2.maxScale=b2.maxScaleInitial=1;b2.scaleToSourceImage=1;b2.scale=1;b2.pos=b2.frames=0;b2.sourceX=b2.sourceY=0;b2.targetX=b2.targetY=0;b2.sourceZoom=b2.targetZoom=1;b2.dX=b2.dY=b2.dZoom=0;b2.lockPanAnimation=false;es();f0(1);cf=eL=1;gA();bv=b;eR={width:0,height:0};ak++;aH();dW=true;fY(false);ay=b;c0=b;eJ=b;hj=false;c1=true;bK=false;if(cQ){cQ.setEnabled(false,true)}br=false;c=b;cl=false;if(!i&&bT){a.removeEvent(bT,"load",dp)}cS={width:0,height:0};gG();hg=cD;fN();if(f6){clearTimeout(f6);f6=b}if(d7){clearTimeout(d7);d7=b}el("image",true);gu();e=[];if(eE){if(bL!=b){a.removeChild(V,bL);bL=b}for(var o=0;o<gs.hotspots.points.length;o++){var hm=gs.hotspots.points[o];if(hm&&hm.tooltip){if(hm.interactive){a.removeEvent(hm.tooltip,"mouseover",fg);a.removeEvent(hm.tooltip,"mouseout",fg)}a.removeChild(hm.tooltip.parentNode,hm.tooltip);a.removeChild(hm.marker.parentNode,hm.marker)}}}b9=false;eE=false;em=b;be="";dE=0;aZ=b;gX=[];ej();if(cr){cr=b}fa={};ea=b};var ej=function(){if(dP){fy(dP);if(dP.parentNode){a.removeChild(dP.parentNode,dP)}dP=b}};var fy=function(hn){try{if(hn&&hn.FSIEvents){for(var hp in hn.FSIEvents){var hm=hn.FSIEvents[hp];a.removeEvent(hn,hp,hm.fn,hm.phase)}}}catch(ho){}};this.addListener=function(ho,hm,hn){var o=false;if(cB){o=cB.addListener(ho,hm,hn);cc()}return o};this.removeListener=function(hn,hm){var o=false;if(cB){o=cB.removeListener(hn,hm);cc()}return o};var cc=function(){cK=cB.isset("onProgress");cJ=cB.isset("onZoomChanged")};var eo=function(o,ho){gM.onUserAction();if(!cl||eB<0){return false}db("mousedown");b6=(fZ.interval!=b);az();hb();bP();if(b2.enabled){var hn=false;if(cY&&cY.timeStamp!=b&&(o.timeStamp-cY.timeStamp)<300){if(Math.abs(cY._posx-ho.x)<50&&Math.abs(cY._posy-ho.y)<50){hn=true}}if(!hn){var hm=(Q)?b2.targetZoom:b2.scale;eU=(hm<=1)}cY=o;cY._posx=ho.x;cY._posy=ho.y;eu()}c5=true;cB.run("onStartDragging",[false]);if(eQ&&eB==2&&!w){eQ.lockImageSourceDimension(bT,true);eQ.lockImage(bT,true)}ga.lastOffsetX=ho.x;ga.lastOffsetY=ho.y;cu=ec;dA.x=ho.x;dA.y=ho.y;switch(eB){case 0:if(b2.enabled){aJ.clientOffset=a.getElementPosition(g7);aJ.setRect(ho.x,ho.y,ho.x,ho.y);fT=true;g5()}break;case 2:e5.bEnabled=(gY>1);e5.bEnabled=true;e5.bSuspended=false;if(e5.bEnabled){e5.nTimeLastMove=e5.nTime=a.now();e5.nInterval=setInterval(fk,200)}dA.SceneSetStart=dA.SceneSetLast=aW.nCurrent;aJ.clientOffset=a.getElementPosition(g7);bY("mouseDown");break}return true};var U=function(hs,hr){if(bb>1.2){hs.FSI_allowEventDefault=true;return}var hm=ga.lastOffsetX-hr.x;var o=ga.lastOffsetY-hr.y;switch(eB){case 0:if(b2.enabled){aJ.setRect(aJ.left,aJ.top,hr.x,hr.y);g5()}break;case 2:if(e5.bSuspended){e5.nTimeLastMove=e5.nTime=a.now();e5.nInterval=setInterval(fk,200);bY("mouseDown");e5.bSuspended=false}if(aW.nSceneSets<2){if(Math.abs(o)>3*Math.abs(hm)){hs.FSI_allowEventDefault=true}}else{var ht=hr.y-dA.y;var hq=dA.SceneSetStart-Math.round(ht*aW.nSceneSets/bc.height);hq=X(hq);if(hq!==dA.SceneSetLast){fL(hq);dA.SceneSetLast=hq}}gV(cu-(hr.x-hs.FSI_start_x)/fp);dE=(hm<0)?-1:1;e5.nTimeLastMove=e5.nTime;break;default:var hn=false;if(b2.enabled){var hp=b2.panPos.left;var ho=b2.panPos.top;b2.panPos.left-=hm*at.scale;b2.panPos.top-=o*at.scale;b0();hn=(hp!=b2.panPos.left||ho!=b2.panPos.top);if(!hn){aM(true);hs.FSI_allowEventDefault=true}else{aM(false);g5()}}else{hs.FSI_allowEventDefault=true}}ga.lastOffsetX=hr.x;ga.lastOffsetY=hr.y};var fk=function(){e5.nTime+=200;if(e5.nTime-e5.nTimeLastMove>400){cG()}};var cG=function(){if(e5.nInterval!==b){clearInterval(e5.nInterval);e5.nInterval=b}e5.bSuspended=true;gg()};var fH=function(hm,hq,hp){gM.onUserAction();if(!fi.bActive){aM(true)}var o=hm._FSI_Canceled;var hn=hm._FSI_Click;if(hn&&h){if(h.onClick(hm,hq)){hn=false}}cB.run("onStopDragging",[false]);c5=false;fT=false;db("mouseup");if(o){if(eB==2){gg("pointer up - canceled")}return}switch(eB){case 0:if(b2.enabled){go();if(!hn&&b2.maxScale>1){eF(gD)}g5()}break;case 1:if(f3==an&&gY<=1){gm(0,0)}break;case 2:if(e5.nInterval){clearInterval(e5.nInterval);e5.nInterval=b}if(!hm._FSI_fromAfterTouch){eG(b,false)}else{var ho=dg(ec,false);ef(ho,ho,1,1);gg("pointer up")}break}fN();if(hn){bS(hm,hq,hp)}};var bh=function(){return(eB==2||(eB==1&&gY>1))};var N=function(hq){if(eB==2){var hn=em/bz;var hm=hq.x-dA.x;var o=-hm/fp+cu;var hp=Math.round(o/hn)*hn;var ho=-(hp-cu)*fp;hq.x=ho+dA.x}return hq};var bS=function(hm,hp){if(b6&&ge.getPluginParameter("autospin","preventClickZoomWhileSpinning",false,true)){return}if(db("click")===true){return}if(gs.clickZoomInAllMouseModes||eB==0){if(!eU){gm(0,0)}else{if(b2.maxScale>1){var hn=a.getElementPosition(g7);var o=hp.x-hn.left;var ho=hp.y-hn.top;fC(o*at.scale,ho*at.scale)}}}};var db=function(hm){var hn=G.getInitialDownEvent();if(!hn||!hn.target||hn.target==g7){return false}var o=hn.target;while(o!=b&&o!=gO&&o.FSIHotspot==b){o=o.parentNode}if(o&&o.FSIHotspot){return fP(hm,o)}return false};var gb=function(hn,hm,hq,ho){for(var hp in hq){hm[hp]=hn.getFloatParameter(ho+hp,hq[hp])}};var eh=function(hn,hm,hq,ho){for(var hp in hq){hm[hp]=hn.getIntParameter(ho+hp,hq[hp])}};var dl=function(ho,hn,hm,hp){for(var hq in hm){hn[hq]=ho.getStringParameter(hp+hq,hm[hq])}},u=function(hn,hm,hp,ho){for(var hq in hp){hm[hq]=hn.makeBool(hn.getStringParameter(ho+hq),hp[hq])}};var c8=function(hm,o,ho,hn){var hp;if(ho&&ho.length>0){if(o[ho]==b){o[ho]={}}hn=hn[ho];hp=o[ho]}else{hp=o}if(hn.strings){dl(hm,hp,hn.strings,ho)}if(hn.booleans){u(hm,hp,hn.booleans,ho)}if(hn.floats){gb(hm,hp,hn.floats,ho)}if(hn.integers){eh(hm,hp,hn.integers,ho)}};var co=function(hm){var hn={strings:{dir:"",skin:"black",language:"english",backgroundColor:"#FFF",hotspotLineColor1:"#000000",hotspotLineColor2:"#FFFFFF",hotspotDotColor1:"#58a8ff",hotspotDotColor2:"#FFFFFF",hotspotCallbackFunction:b,headers:"cors",fpxservertemplate:b,imagemattecolor:"FFFFFF",initialview:"",initialMouseMode:"auto",navWidth:"120",navHeight:"120",panLimits:"strict",inPlaceZoom:"true",documentZoom:"auto",hideUI:"false",spinDirectionImage:"right",progressBarVAlign:"bottom",progressBarHAlign:"center",MenuButtonOrder:b,urlLoadingAnimation:"/skins/resources/loading.svg"},booleans:{menubar:true,keepViewOnResize:true,useDevicePixelRatio:true,adaptiveUISize:true,drawCube:false,drawTable:false,drawGroundPlate:false,pellets:true,enableHotspots:true,decodeHTMLEntitiesInHotSpotTexts:false,enableZoom:true,noCanvas:false,useMaskedJPEGs:true,noNav:false,autoHideNav:true,autoDisablePointerActions:true,loadExactPreviewImagesAfterResize:false,preventImageTransparency:false,noSetLoop:false,noSceneLoop:false,initialViewPersistent:false,showPreviewWhileLoading:true,spinPreviewWhileLoading:true,showProgressbar:true,reverseSceneSets:false,autoDestroy:true,clickZoomInAllMouseModes:true},floats:{pelletsOpacity:0.15,fMouseSensitivity:1,desktopClickZoomScale:3,autoSpinSpeed:0,autoSpinInterval:0,tableDiameter:950,maxZoom:100,progressBarWidth:35,progressBarHeight:14},integers:{hotspotDotRadius:4,zoomPrecision:1,minInstanceSize:60,quality:-1},video:{strings:{skin:"black",base:"videos/",source:"",spinDirection:"right",sceneSet:0},integers:{captureFrames:120,frameOffset:0},floats:{captureOffsetStart:0,captureOffsetEnd:0,widthCorrectionFactor:1,heightCorrectionFactor:1,xCorrectionFactor:0,yCorrectionFactor:0}},camera:{strings:{position:"",targetPosition:"",armJointPosition:""},floats:{digitalCropFactor:1,focalLength:50,distanceToTableCenter:1500,heightAboveTable:500,heightTable:b,heightCamera:b,targetHeightOffset:0,targetWidthOffset:0,shiftX:0,armLength:0,armAngleMeasureSetup:0,armAngleStart:0,armAngleEnd:0}},virtualSpace:{strings:{position:""},floats:{cubeSizeX:100,cubeSizeY:100,cubeSizeZ:100,cubeLineWidth:1,baseRotationX:0,rotationXRange:180,rotationXSets:0,baseRotationY:0,rotationYRange:360,rotationYScenes:0,baseRotationZ:0,shiftX:0,shiftZ:0,shiftY:0}}};if(hm==b){hm={}}hm.serverBase=ge.serverBase;c8(ge,hm,"",hn);c8(ge,hm,"camera",hn);c8(ge,hm,"virtualSpace",hn);c8(ge,hm,"video",hn);if(gs.enableHotspots){var o=ge.getUnrecognizedConfigNode("hotspots3d");c7(o)}cn="&effects=Matte("+encodeURIComponent(gs.imagemattecolor)+")"};var c7=function(ho){var hw={strings:{id:"",normalClass:"",hoverClass:"",activeClass:"",text:"",actionParameter:b,url:b,urlTarget:"_self",cssStyle:"",cssClass:""},booleans:{interactive:false,rotateOnFocus:true,zoomOnFocus:true,focusOnClick:true},floats:{perimeterZoom:1,perimeterImageWidth:0,perimeterAngle:b,perimeterAngleRange:30,perimeterAngleFadeOut:10,perimeterAngleX:b,perimeterAngleXRange:30,perimeterAngleXFadeOut:10,perimeterAngleY:b,perimeterAngleYRange:30,perimeterAngleYFadeOut:10,verticalMarkerSize:100,horizontalMarkerSize:30,markerAngle:45,horizontalMarkerPosition:0,verticalMarkerPosition:0.5,perimeterDistance:b,perimeterTerminator:b,x:0,y:0,z:0,focusRadius:0.25,focusAngleX:b,focusAngleY:b}};var hq=[];var hp;var hu=new a.Config();var hn,ht,hv;var hs,hm,hx;if(ge.cfg.hotspots!=b&&ge.cfg.hotspots.length>0&&typeof(ge.cfg.hotspots.join)=="function"){dv.log("Using HotSpots from JS parameters");gs.hotspots={};gs.hotspots.defaults={};gs.hotspots.points=new Array(ge.cfg.hotspots.length);hn=ge.cfg.hotspotsdefaults;if(hn==b){hn=ge.cfg.hotspotdefaults}if(hn!=b){hu.makeObjectPropertiesLowerCase(hn);hu.cfg=hn;hp={};c8(hu,hp,"",hw);for(hm in hw){ht=hw[hm];for(hx in ht){if(hp[hx]!=b){ht[hx]=hp[hx]}}}hn=hp;hp={};for(hm in hn){if(hn[hm]!=b){hp[hm]=hn[hm]}}gs.hotspots.defaults=hp}for(hs=0;hs<ge.cfg.hotspots.length;hs++){hv=ge.cfg.hotspots[hs];hu.makeObjectPropertiesLowerCase(hv);hu.cfg=hv;hv={};c8(hu,hv,"",hw);gs.hotspots.points[hs]=hv}}else{if(!ho){return}ho=ho.firstChild;while(ho){if(ho.nodeType!=1){ho=ho.nextSibling;continue}var hr=ho.nodeName.toLowerCase();switch(hr){case"hotspot":hq.push(ho);break;case"defaults":hp=ex(hu,ho,hw);break}ho=ho.nextSibling}if(hp!=b){for(hm in hw){ht=hw[hm];for(hx in ht){if(hp[hx]!=b){ht[hx]=hp[hx]}}}hn=hp;hp={};for(hm in hn){if(hn[hm]!=b){hp[hm]=hn[hm]}}}if(hq.length>0){for(hs=0;hs<hq.length;hs++){hq[hs]=ex(hu,hq[hs],hw)}gs.hotspots={};gs.hotspots.points=hq;gs.hotspots.defaults=hp}}if(gs.hotspots&&gs.hotspots.points){dv.log("HotSpots parsed: "+gs.hotspots.points.length);eE=(gs.hotspots.points.length>0)}else{eE=false}};var ex=function(hm,hp,ho){var o=a.attributes2parameters(hp);hp=hp.firstChild;while(hp){if(hp.nodeType!=1){hp=hp.nextSibling;continue}var hn=hm.getValueFromXMLNode(hp,"");o[hn.name]=hn.value;hp=hp.nextSibling}hm.cfg=o;var hq={};c8(hm,hq,"",ho);return hq};var d2=function(){co(gs);ge.result=gs;var o=Math.PI/180;gs.virtualSpace.baseRotationXRad=gs.virtualSpace.baseRotationX*o;gs.virtualSpace.baseRotationYRad=gs.virtualSpace.baseRotationY*o;gs.virtualSpace.baseRotationZRad=gs.virtualSpace.baseRotationZ*o};var gC=function(o,hv){dv.log("Video Dimension: "+o+" x "+hv+"px");var hr=fn.isCropped();var hs=false;var hm=fn.getCropMargins();var hp=au.width;var hu=hp/o;var ht=hv*hu;var hq=Math.round((au.height-ht)/2);if(hq>hm.top){hs=true;hm.top=hq}if(hq>hm.bottom){hs=true;hm.bottom=hq}if(hs){dv.log("Cropping images to match video dimension ("+hq+"px)");fn.setCropValues(hm.left+"px",hm.top+"px",hm.right+"px",hm.bottom+"px");p()}if(hr){hm=fn.getCropMargins();hm.scaleRectInt(1/hu);hq=Math.round(hq/hu);fm.left=hm.left;fm.right=hm.right;fm.top=hm.top-hq;fm.bottom=hm.bottom-hq}else{fm.setRect(0,0,0,0)}bv=b;bM();var hn=o-fm.left-fm.right;var ho=hv-fm.top-fm.bottom;cS={width:o,height:hv,croppedWidth:hn,croppedHeight:ho};l(hn,ho);dU();if(cs&&gs.pellets&&gs.pelletsOpacity>0){cq()}};var l=function(hw,hL,hz){if(!gs||!gs.video||au===b||!gs.video.widthCorrectionFactor){return}var hD,hG;var hx;var hv;var hy,hI,hF,hp;if(!i){hF=bc.width;hp=bc.height}else{hF=ha;hp=cT}var hM=hw/hL;var hu=hF/hp;var ht,o;if(hM>hu){ht=hF}else{o=hp}bM();hD=fn.getFloatRect();var hA=hD.getRange();var hC=a.getFSIServerImageDim(au.width,au.height,ht,o,hA,true);hy=hC.width;hI=hC.height;if(hy>eR.width||hI>eR.height){hy=eR.width;hI=eR.height}bI=Math.min(hg,Math.round(hy));hx=Math.round((hF-hy)/2);hv=Math.round((hp-hI)/2);W.widthForRatio=hw;W.heightForRatio=hL;W.imageWidth=hy;W.imageHeight=hI;W.imageX=hx;W.imageY=hv;if(at.scale===1){W.imageWidthAbsolute=W.imageWidth;W.imageHeightAbsolute=W.imageHeight;W.imageXAbsolute=(at.drawOffsetX+W.imageX-(W.imageWidth*at.scale-W.imageWidth)/2)/at.scale;W.imageYAbsolute=(at.drawOffsetY+W.imageY-(W.imageHeight*at.scale-W.imageHeight)/2)/at.scale}W.videoWidth=hy*gs.video.widthCorrectionFactor;W.videoHeight=hI*gs.video.heightCorrectionFactor;W.videoX=hx+hy*gs.video.xCorrectionFactor-(hy*gs.video.widthCorrectionFactor-hy)/2;W.videoY=hv+hI*gs.video.yCorrectionFactor-(hI*gs.video.heightCorrectionFactor-hI)/2;if(!hz){aD=bI;ev(v)}ev(bd);if(!hz){hD=fn.getImageRect();var hE;if(hD.width()>0){hE=au.width/hD.width()}else{hE=0}var hq=Math.ceil(hE*v.imageWidth);if(au.__levelsCalculatedFor!=hq){au.__levelsCalculatedFor=hq;dv.log("Calculating image levels for image base width: "+hq+" px");dv.log("Source image dimension: "+au.width+" x "+au.height);var hB=Math.ceil(1.1*hq);bs=[];if(hq>0){if(au.levels&&au.levels.length>0){var hK=[];for(hG=0;hG<au.levels.length;hG++){var ho=parseInt(au.levels[hG].width);if(!isNaN(ho)){if(ho>hB){hK.push(ho)}else{break}}}if(dv.on){dv.log("Matching server side image levels: "+hK.join(", "))}if(hK.length>0){hK.push(hq);var hn=hK[0];bs.push(hn);for(hG=1;hG<hK.length;hG++){var hH=hK[hG];var hr=hn/hH;while(hr>2.5){hn/=2;hr=hn/hH;if(hn>hB){bs.push(Math.round(hn))}}bs.push(hH);hn=hH}bs.pop();hK.pop();bs.reverse()}if(dv.on){var hJ=(bs.length-hK.length);if(hJ==0){dv.log("Using server side image levels only.")}else{dv.log("Using "+hJ+" additional virtual image levels.")}}}else{dv.log("No image level information from server. Using virtual image levels.");var hm=au.width;var hN=au.height;if(hB>0){while(hm>hB&&hN>0){bs.push(hm);hm=Math.round(hm/2);hN=Math.round(hN/2)}}bs.reverse()}}if(dv.on){dv.log("Using image levels: "+bs.join(", "))}}bi()}switch(f3){case fr:W.maxPanReferenceWidth=bc.width*at.scale;W.maxPanReferenceHeight=bc.height*at.scale;break;case an:W.maxPanReferenceWidth=0;W.maxPanReferenceHeight=0;break;default:W.maxPanReferenceWidth=bd.imageWidth;W.maxPanReferenceHeight=bd.imageHeight;break}};var ev=function(hm){for(var hn in W){hm[hn]=W[hn]}};var ap=function(){var o=gs.video.source;if(o&&o.indexOf("[static]")==0&&gs.serverBase!=b){var hm=gs.serverBase;hm=hm.split("/");hm.pop();hm=hm.join("/");o=o.replace(/\[static\]\/*/,hm+"/static/")}return o};this.start=function(){c6=a.now();fx=0;eg();if(cQ&&!dD){cQ.destroy();cQ=b}if(!gl){return}et()};var et=function(){gs={};ge.loadConfigs()};var d0=function(){if(a.oSupportedViewers[cE.strClassName]==b){var hs=false;try{hs=(!a.isInternetExplorer||a.versionInternetExplorer>8)}catch(hq){}a.oSupportedViewers[cE.strClassName]=hs}d2();af();cc();var hp=[];if(typeof(ge.cfg.invisibleloadingpurposes)==="string"){hp=ge.cfg.invisibleloadingpurposes.split(",")}aK.setNotVisualPurposes(hp);if(ge.hasPlugin("autospin")){var ho=ge.getPluginParameter("autospin","speed",4);if(ho!=b){ho=parseFloat(ho);if(!isNaN(ho)){gs.autoSpinSpeed=ho}}var o=ge.getPluginParameter("autospin","interval");if(o!=b){o=parseInt(o);if(!isNaN(o)){gs.autoSpinInterval=o}}}if(ge.hasPlugin("fullscreen")&&!ge.hasPlugin("resize")){ge.addPluginFromString("resize")}var hu=gs.enableZoom;i=(a.BrowserSupports.canvas());b2.enabled=false;r=false;if(hu&&a.BrowserSupports.canvas()){var hm=""+gs.inPlaceZoom;switch(hm.toLowerCase()){case"auto":b2.enabled=(!a.isMobileDevice);break;default:b2.enabled=ge.makeBool(hm,true);break}hm=""+gs.documentZoom;switch(hm.toLowerCase()){case"auto":r=(a.isTouch);break;default:r=ge.makeBool(hm,true);break}}d=false;hm=""+gs.hideUI;hm=hm.toLowerCase();if((a.isMobileDevice&&hm=="onmobiledevices")||(!b2.enabled&&hm=="ifnoinplacezoom")||ge.makeBool(gs.hideUI)==true){d=true}bm=(!gs.noNav&&!d&&b2.enabled);g3=!ge.makeBool(gs.menubar,true);if(i){eQ=b}else{eQ=a._FSITouchZoomInstance}if(i&&ge.hasPlugin("resize")){if(!gP){var hr=gJ=a.addCustomEvent(gO,"FSIElementDimension",a4);a.setCustomEventListenerProperty(hr,"treshold",100);gP=true}}else{if(gP){a.removeCustomEvent(gO,"FSIElementDimension",a4);gP=false}}if(gs.noCanvas){i=false}var hn=a0;var ht=ge.cfg.customskinclass;if(H&&H.paramCustomSkinClass!==ht){H.destroy()}if(ht!==b){if(!H||H.paramCustomSkinClass!==ht){H=new a.CustomSkinClass(ba,ht,gM,hn)}}else{hn()}};var a0=function(hm){if(ge.makeBool(gs.urlLoadingAnimation,true)&&b4!==gs.urlLoadingAnimation){b4=gs.urlLoadingAnimation;var o=ge.getReloadPath(ge.locationFSIViewer,gs.urlLoadingAnimation);ge.loadFile(o,gd,"text/html; charset=utf-8")}else{t()}};var gd=function(o){var hm=o.responseText;if(f4){f4=b}if(typeof(hm)==="string"&&hm.length>0){if(!a.bViewerLoadingAnimationCSSClassAdded){a.bViewerLoadingAnimationCSSClassAdded=true;a.addViewerClassCSSRule(".fsi-viewer-loading-animation","position:absolute;padding:15px;z-index:10;left:100%;top:0%;transform:translate(-100%,0%);pointer-events:none;")}f4=document.createElement("div");a.addClass(f4,"fsi-viewer-loading-animation");f4.innerHTML=hm}t()};var eS=function(){if(!f4||aI){return}c9=f4;if(c9){aI=true;gO.appendChild(c9)}};var g0=function(){if(aI&&c9&&c9.parentNode){a.removeChild(c9.parentNode,c9);c9=b}aI=false};var d5=function(){var o="/linkeditor/js/fsilinkeditor.js";var hm="fsiviewer.js";var hn=a.getScriptPath(hm,2);dv.log("Loading LLoading language fileinkEditor: "+hn+o);a.loadJavascript(hn+o,dQ,ba,gp,hn)};var gp=function(hm,ho,hn){h=new a.LinkEditor(ba,gM,gO,{});h.init(dQ,hn,t);var o=ar;ar=function(){o.apply(ba,arguments);h.drawScene(at,gY)}};var t=function(){if(ge.hasPlugin("linkeditor")&&!h){d5();return}eS();var hm=gs.skin;if(g1!=hm){dD=false;g1=hm}dv.log("Loading skin: "+hm+".css");if(gE){gE.remove();gE=b}if(!dD&&a.oSupportedViewers[cE.strClassName]==true){var hn=aU.className;aU.name=hm;aU.className="fsi-skin-"+aU.name;gO.className="fsi-root fsi-viewer-root "+aU.className;var o=[{file:"resources/fsi-core.css",nPriority:1},{file:"resources/fsi-viewer-core.css",nPriority:5}];gE=a.loadSkinCSS(hm,ba,c4,10,o);if(hn!=aU.className){cB.runPersistent("onSkinChanged",[aU.className,hn])}}else{c4(dD)}};this.getSkinClassName=function(){return aU.className};var f2=function(){if(fD.bEnabled){return}fD.bEnabled=true;bq=b;if(typeof(gs.initialview)==="string"&&gs.initialview.length>0){var hm=gs.initialViewPersistent;gs.initialViewPersistent=true;ba.resetView(false);gs.initialViewPersistent=hm}else{ba.resetView(false)}fD.hideUI=ge.makeBool(ge.cfg.hideuiindemomode,true);a.addClass(gO,"fsi-demo-mode");a.addEvent(am,"click",a8,true);if(fD.hideUI){if(cQ){cQ.show(false);cv=0}if(f8){f8.enable(false,true)}}var o=ge.cfg.demotooltip;if(!a.isMobileDevice&&typeof(o)==="string"&&o.length>0){fD.bToolTip=true;fD.strTip=o;a.addEvent(am,"mousemove",g8);a.addEvent(am,"mouseout",fF)}else{fD.strTip="";fD.bToolTip=false}cB.runPersistent("onEnterDemoMode")};var g8=function(o){if(!fD.oToolTip){if(gM.getToolTip()){fD.oToolTip=gM.getToolTip();fD.bDestroyToolTip=false}else{fD.oToolTip=new a.ToolTip(gO);fD.oToolTip.setContent({});fD.bDestroyToolTip=true}}var hm=a.getElementClientPos(gO);fD.oToolTip.show(fD.strTip,null,o.clientX-hm.left,o.clientY-hm.top,b,100,true)};var fF=function(){if(fD.oToolTip){fD.oToolTip.hide()}};var cA=function(){if(!fD.bEnabled){return}a.removeClass(gO,"fsi-demo-mode");a.removeEvent(am,"click",a8);if(fD.hideUI){if(cQ){cQ.show(true);cv=bC}if(f8){f8.enable(true,false)}}if(fD.bToolTip){a.removeEvent(am,"mousemove",g8);a.removeEvent(am,"mouseout",fF);fD.oToolTip.hide();if(fD.bDestroyToolTip){fD.oToolTip.destroy();fD.oToolTip=b}}fD.bEnabled=false;fD.hideUI=false;cB.runPersistent("onExitDemoMode")};var a8=function(){if(!fD.bEnabled){return}var hm=ge.cfg.demourl;var hn=ge.cfg.demourltarget;if(!hn){hn="_self"}var o=cB.run("onClickDemoMode",[hm,hn]);if(o===false){return}if(hm==="no action"){return}if(hm==="enter fullscreen"){fD.bRestore=true;if(ge.hasPlugin("fullscreen")){gM.clickMenuButton("ToggleFullScreen",b,true)}}else{window.open(hm,hn)}};var c4=function(o){if(ge.cfg.demourl){f2()}else{cA()}gE=b;if(o){dv.log("Skin loaded successfully. ");cR()}else{dv.error("Failed to load skin.");ez={hMenuBar:0};aU._nameParsedLast=b}ed()};this.showMenuButton=function(hm,o){if(cQ){cQ.showButton(hm,o)}};this.getMenuHeight=function(hm){var o=bC;if(hm!=b){switch(hm){case"navWindow":if(ez.bFloatingNavWindow){o=0}break}}return o};var cR=function(){if(aU._nameParsedLast!=aU.name){aU._nameParsedLast=aU.name;var hr=document.createElement("div");hr.style.position="absolute";hr.style.top="0px";hr.style.left="0px";hr.style.width="1px";hr.style.height="1px";hr.style.overflow="hidden";hr.style.visibility="hidden";var hm=document.createElement("div");hr.appendChild(hm);gO.appendChild(hr);var ht={};var ho=function(hB,hy,hw,hv,hx){var hu,hA;if(ht[hB]==b){hm.className=hB;hA=ht[hB]=getComputedStyle(hm,hx)}else{hA=ht[hB]}hu=hA.getPropertyValue(hy);if(hv){hu=hu.replace(/^[^{]*/g,"");hu=hu.replace(/[^}]*$/g,"");hu=hu.replace(/\\"/g,'"');if(hu.length>0){try{hu=a.JSON.parse(hu)}catch(hz){a.console.error("ERROR parsing JSON from CSS selector '"+hB+"' property '"+hy+"'.");a.console.error(hz.message)}}else{hu={}}}if(hu==b){hu=hw}return hu};ez=ho("fsi-ui-info","content",b,true,":before");ez.bFloatingMenuBar=ge.makeBool(ez.floatingMenuBar);ez.bFloatingNavWindow=ge.makeBool(ez.floatingNavWindow);ez.hMenuBar=ho("fsi-ui-menu-bar","height");aU.urlLogo=ho("fsi-ui-logo-image","background-image");if(typeof(aU.urlLogo)=="string"){var hq=/url\(\s*["']?([^"')]*)["']?\s*\)/;var o=hq.exec(aU.urlLogo);if(o&&o.length>0){aU.urlLogo=o[1]}}aU.navFrameBorderColor=ho("fsi-ui-nav-frame","border-left-color","red");aU.navFrameBackgroundColor=ho("fsi-ui-nav-frame","background-color","rgba(255,255,255,0.5)");aq=ho("fsi-ui-select-frame","border-left-color","red");bl=ho("fsi-ui-select-frame","background-color","rgba(255,255,255,0.25)");aU.oProgressBarStyle={};aU.oProgressBarStyle.color=ho("fsi-ui-progressbar","color","#CCC");aU.oProgressBarStyle.background=ho("fsi-ui-progressbar","background-color","#FFF");aU.oProgressBarStyle.border=ho("fsi-ui-progressbar","border-left-color","#CCC");aU.oProgressBarStyle.text=ho("fsi-ui-progressbar-text","color","#555");var hs=16;var hn=8;if(ez){if(!isNaN(ez.baseSize)&&ez.baseSize>0){hs=ez.baseSize}if(!isNaN(ez.baseEnlargement)&&ez.baseEnlargement>0){hn=ez.baseEnlargement}}else{ez={}}var hp=1;if(a.isMobileDevice&&gs.adaptiveUISize==true){hp=a.getDevicePixelRatio()}ab=Math.round(hs+hn*hp);ez._baseSkinSize=ab;gO.removeChild(hr)}gO.style.fontSize=ab+"px"};var ed=function(){if(typeof(ez.hMenuBar)!="string"||ez.hMenuBar.length<1||isNaN(parseFloat(ez.hMenuBar))){cN=false}else{cN=(a.oSupportedViewers[cE.strClassName]==true&&d!=true&&!g3)}j()};var d1=function(){if(!cN){cQ.removeDomElement()}bC=cQ.getHeight();if(ez&&ez.bFloatingMenuBar){cv=0}else{cv=bC}if(fD.bEnabled&&fD.hideUI){cQ.show(false);cv=0}af();bp()};this.showMenuToolTip=function(hn,hm,o,ho){if(cQ){cQ.showToolTip(hn,hm,o,ho)}};this.hideMenuToolTip=function(){if(cQ){cQ.hideToolTip()}};var j=function(){if(fM==b){if(a._FSIViewerLocation!=b){fM=new a.ToolTip(gO)}}fG();if(cQ==b||!dD){if(cQ){cQ.destroy()}cQ=new a.MenuBar(gM,aU,gO,d1,cE.oAPI.oMenuCommands);cQ.setCallbacks(cB)}else{if(dD&&cQ){cQ.setInterface(gM)}d1()}};var fG=function(){if(fM!=b&&gs){ge.loadLanguageFile(bo,gs.language,f5,dv)}};var f5=function(hm,o){dI=hm;cB.runPersistent("onLanguageData",[dI]);fM.setContent(dI)};var eK=function(){if(!cQ){return}var hn;var hm=gM.arMenuButtons=[];hm.push({cmd:"Reset"});if(b2.enabled==true){hm.push({cmd:"ZoomOut",enabled:false});hm.push({cmd:"ZoomIn"})}if(ge.hasPlugin("mousemodes")||ge.hasPlugin("mousemodeselect")){var hq=ge.getPluginParameter("mousemodes","sequence","0,1,3,2");hq=hq.split(",");var ho=[];for(hn=0;hn<4;hn++){ho[hn]=ge.getPluginParameter("mousemodes","mode"+hn,true,true)}if(!b2.enabled){ho[0]=ho[1]=false}var hp=function(hr){if(isNaN(hr)||hr<0||hr>2){return}if(!ho[hr]){return}if(hr==2&&gX.length<2){return}var hs=true;if(hr==1){hs=(f3>e0)}hm.push({cmd:"MouseMode_"+hr,groupID:"MouseMode",enabled:hs})};for(hn=0;hn<hq.length;hn++){hp(parseInt(hq[hn]))}}if(ge.hasPlugin("maxzoom")&&b2.enabled){hm.push({cmd:"MaxZoom"})}if(eE){if(!ge.hasPlugin("hotspots")){ge.addPluginFromString("hotspots")}if(ge.getPluginParameter("hotspots","button","true",true)){hm.push({cmd:"HotSpots",bCheckButton:true})}di=ge.getPluginParameter("hotspots","visible","true",true)}if(gs.autoSpinSpeed!=0&&ge.hasPlugin("autospin")&&ge.getPluginParameter("autospin","button",true,true)){hm.push({cmd:"ToggleAutoSpin",bCheckButton:true})}var o=false;if(ge.hasPlugin("fullscreen")){o=true;a.FullScreen.addChangeEvents(window,cP,aV);hm.push({cmd:"ToggleFullScreen",bCheckButton:1})}cQ.addButtons(hm,gs.MenuButtonOrder);cB.run("onInitMenu");if(o&&d8){cQ.setButtonPressed("ToggleFullScreen",true)}if(eE&&di){cQ.setButtonPressed("HotSpots",true)}};var fz=function(){var o;if(!r){o=Math.round(Math.max(1,hl)*Math.max(bc.width,bc.height))}else{o=Math.round(Math.max(1,hl)*Math.max(screen.width,screen.height))}fv=Math.min(1024,Math.max(2,Math.ceil(o/3/128))*128)};var bp=function(){if(typeof(gs.virtualSpace)!="object"){return}var hp=ge.parsePositionParameter(gs.virtualSpace.position);if(hp!=b){gs.virtualSpace.shiftX=hp.x;gs.virtualSpace.shiftY=hp.y;gs.virtualSpace.shiftZ=hp.z}if(ge.cfg.cameraarmanglestart!=b){gs.virtualSpace.baseRotationX=gs.camera.armAngleStart;if(ge.cfg.cameraarmangleend!=b){gs.virtualSpace.rotationXRange=gs.camera.armAngleEnd-gs.camera.armAngleStart}}if(gs.useDevicePixelRatio){hl=a.getDevicePixelRatio()}else{hl=1}gM.devicePixelRatio=hl;fz();fn=new a.CroppedImage();fn.setCropFromConfig(ge.cfg);switch(gs.panLimits){case"loose":f3=an;break;case"medium":f3=e0;break;default:f3=fr;break}n();e6=true;if(gs.noSceneLoop){he=aY}else{he=eX}F=gs.virtualSpace.rotationYRange*-Math.PI/180;aW.rotXRange=gs.virtualSpace.rotationXRange;var o=(gs.virtualSpace.rotationXSets>0)?gs.virtualSpace.rotationXSets:aW.nSceneSets-1;aW.rotXGradPerSet=(aW.rotXRange/(aW.nSceneSets-1))*Math.PI/180;if(fB!==b){var ho=fB;fB=b;ba.changeImage.apply(ba,ho);return}var hn=gs.dir;if(hn===b||hn.length===0){hn=ge.cfg.images3durl}if(!hn||hn.length===0){var hm=ge.getImageList();if(hm){bN(hm.arImages,hm.oXML,hm)}else{return da("failed to load image list")}}else{hm=ge.loadImageList(hn,bN,ci);if(dv.on&&typeof(hm._url)=="string"){dv.log("Loading image list: "+hm._url)}}};var bN=function(hm,hn){if(!hm||hm.length<1){dv.error("Failed to load image list.");return da("image list is empty")}dZ();gX=hm;bz=ad=hm.length;aW=ge.parseSceneSets(gX.length,false);dv.log("Image list ready ("+gX.length+" images)");if(gX.length>0){if(ge.cfg.fpxwidth!==b&&ge.cfg.fpxheight!==b){var o={};o.width=parseInt(ge.cfg.fpxwidth);o.height=parseInt(ge.cfg.fpxheight);bR(null,o)}else{ge.loadImageInfo(gX[0],bR)}}else{bt()}};var cF=function(){var o={};o.angle=gs.virtualSpace.baseRotationX;o.stepAngle=gs.virtualSpace.rotationXRange/(aW.nSceneSets-1);return o};var eT=function(){if(!d3||aW.nSceneSets<1){return}if(aW.bSetCameraPosition){return}aW.bSetCameraPosition=true;var hs=new THREE.Vector3();var hm=new THREE.Vector3();var hx=new THREE.Vector3();var hv=new THREE.Object3D();var hn=new THREE.Object3D();hv.add(hn);var hy=new THREE.Object3D();hn.add(hy);var hr=180/Math.PI;var hC;var hD=dL.targetObj.position;hn.rotation.set(0,0,0);hx.set(0,hD.y,hD.z);if(ge.cfg.cameraarmlength==b){hC=dL.camera.position.distanceTo(hD)}else{hC=gs.camera.armLength}var hu=ge.parsePositionParameter(gs.camera.armJointPosition);if(hu==b){hn.position.set(hD.x,hD.y,hD.z)}else{hn.position.set(hu.x,hu.y,hu.z)}hn.rotation.x=gs.camera.armAngleMeasureSetup/hr;hv.rotation.set(0,0,0);hy.rotation.set(0,0,0);hy.position.set(0,0,hC);hv.updateMatrixWorld();hm.setFromMatrixPosition(hy.matrixWorld);var hB=cF();var hA=hB.angle;var ht=hB.stepAngle;if(gs.reverseSceneSets){hA+=gs.virtualSpace.rotationXRange;ht=-ht}dv.log("Calculated Camera Positions:");dv.log("----------------------------");var o=180/Math.PI;for(var hw=0;hw<aW.nSceneSets;hw++){var ho=aW.arSets[hw];ho.cameraArmAngle=hA;hn.rotation.x=hA/hr;hv.updateMatrixWorld();hs.setFromMatrixPosition(hy.matrixWorld);ho.posCamera=new THREE.Vector3(dL.camera.position.x+hs.x-hm.x,dL.camera.position.y+hs.y-hm.y,dL.camera.position.z+hs.z-hm.z);hs.x=0;ho.xAngleToTarget=hx.angleTo(hs)-Math.PI/2;ho.xAngleToTargetDeg=ho.xAngleToTarget*o;if(dv.on){dv.log("SceneSet "+(hw+1)+", arm angle "+hA+"°, angle to target: "+ho.xAngleToTargetDeg+"°, position (x,y,z): "+ho.posCamera.x+", "+ho.posCamera.y+", "+ho.posCamera.z)}if(eE){ho.visibleHotSpots={};for(var hz=0;hz<gs.hotspots.points.length;hz++){var hp=gs.hotspots.points[hz];var hq=1;if(hp.perimeterAngleX!=b){var hE=Math.abs(hp.perimeterAngleX-ho.xAngleToTargetDeg);if(hE>180){hE=Math.abs(360-hE)}if(hE<hp.perimeterAngleXRange){if(hE>hp.perimeterAngleXRange-hp.perimeterAngleXFadeOut){hq=(hp.perimeterAngleXRange-hE)/hp.perimeterAngleXFadeOut}}else{hq=0}ho.visibleHotSpots[hp.FSIHotspotID]=hq}else{ho.visibleHotSpots[hp.FSIHotspotID]=1}}}hA+=ht}};var dM=function(){if(aW.bDefault){return}var hp=100000000;var hu=0;var hq,ho,ht;var hw;if(dv.on){hw=a.cloneObject(aW.arSets)}var hv={};for(hq=0;hq<aW.arSets.length;hq++){ht=aW.arSets[hq].arScenes;for(ho=0;ho<ht.length;ho++){var hr=ht[ho]=ht[ho]-1;hv[hr]=gX[hr]}}var hs=[];var hn=e.length;for(var hm in hv){hs.push(hv[hm]);hv[hm]=hn;hn++}for(hq=0;hq<aW.arSets.length;hq++){ht=aW.arSets[hq].arScenes;for(ho=0;ho<ht.length;ho++){ht[ho]=hv[ht[ho]]}hp=Math.min(hp,ht.length);hu=Math.max(hu,ht.length)}if(aW.arSets[0].arScenes.length>0){aW.bDefault=false;aW.quantizeMin=hp;aW.quantizeMax=aW.quantizeMaxImages=hu;if(dv.on){dv.log('Using SceneSets Parameter: "'+ge.cfg.scenesets+'"');dv.log("Parsed SceneSets:");for(hq=0;hq<hw.length;hq++){dv.log("Scene "+(hq+1)+": "+hw[hq].arScenes.join(", "))}}gX=hs;if(aW.arSets.length>1){if(hp!=hu){aW.bQuantize=true}if(dC!=b&&dC>0){aW.quantizeMax=Math.max(aW.quantizeMax,dC);if(hu!=aW.quantizeMax){aW.bQuantize=true}}}}else{aW.bDefault=true;aW.bHasMultipleSets=false;dv.error('Invalid SecenSet definition: "'+ge.cfg.scenesets+'"')}};var a7=function(){var ho=100000000;var o=0;for(var hn=0;hn<aW.arSets.length;hn++){var hm=aW.arSets[hn].arScenes;ho=Math.min(ho,hm.length);o=Math.max(o,hm.length)}return{min:ho,max:o}};var fU=function(){var hp,hs;var hm=aW.quantizeMax;for(var hr=0;hr<aW.arSets.length;hr++){if(hr==aW.nVideoSet){continue}var hq=aW.arSets[hr].arScenes;if(hq.length<hm){var o=hq.length;aW.arSets[hr].fQuantizeFactor=hm/o;var hn=o-1;var ho=new Array(hm);for(hp=0;hp<hm;hp++){hs=(hp*hn/(hm-1));ho[hp]=hq[Math.round(hs)]}aW.arSets[hr].arScenes=ho}else{aW.arSets[hr].oSpinPositions=false}}};var a3=function(){var hq,hp,hr,ho,hv;if(aW.bDefault){return}var hn=gs.virtualSpace.rotationYScenes;for(hq=0;hq<aW.arSets.length;hq++){if(hq===aW.nVideoSet){continue}var hw=aW.arSets[hq];var hu=hw.arScenes;var ht=hu.length;hv=ho=b;for(hp=0;hp<ht;hp++){hr=hu[hp];if(ho===b||ho>hr){ho=hr}if(hv===b||hv<hr){hv=hr}}hw.minScene=ho;hw.maxScene=hv;hw.sceneRange=hv-ho;var hm=(hn>0)?hn:hw.sceneRange+1;var o=hw.oSpinPositions={};var hs=o.arPositions={};for(hp=0;hp<ht;hp++){hr=hu[hp];hs[hr]=(hr-ho)/hm}}};var da=function(o){g0();bW("default");if(cQ){cQ.setEnabled(false)}cB.run("onInitFailed",[o])};var bR=function(hm,o){if(!o||o.width==b||isNaN(o.width)){return da("Failed to load image info")}au=o;au.transparency=ge.makeBool(au.alpha);au.width=parseInt(au.width);au.height=parseInt(au.height);if(gs.fpxservertemplate!=b){fa.renderer=gs.fpxservertemplate}if(gs.headers!=b){fa.headers=gs.headers}dN=(au.transparency&&!gs.preventImageTransparency);if(dN){if(i){br=gs.useMaskedJPEGs}else{var hn=ge.cfg.fpxservertemplate;if((gs.video==b||!gs.video.source.length)&&(hn==b||hn=="jpeg")){fa.renderer="png"}}}g6=(!dN||!br);if(typeof(au.levels)=="object"&&typeof(au.levels.sort)=="function"){au.levels.sort(aL)}else{au.levels=b}fn.setSourceDimension(au.width,au.height);p();l(eR.width,eR.height);dU();bt()};var aL=function(hm,o){return o.width-hm.width};var dU=function(){if(fn.isCropped()){var hm=fn.getImageRect();var o=hm.width()/W.imageWidth;aP.cropScaleX=au.width/hm.width();aP.cropScaleY=au.height/hm.height();aP.x=(hm.left+hm.width()/2-au.width/2)/o;aP.y=(hm.top+hm.height()/2-au.height/2)/o}else{aP.cropScaleX=1;aP.cropScaleY=1;aP.x=0;aP.y=0}};var p=function(){var o;if(fn.isCropped()){o=fn.getPixelRangeRect();eR.width=o.right;eR.height=o.bottom}else{eR.width=au.width;eR.height=au.height}};var bt=function(){if(typeof(ge.cfg.fullscreenelement)!="undefined"){dB=ge.cfg.fullscreenelement}else{dB=am}gA();d3=false;bH=false;var o=true;if(a.BrowserSupports.canvas()){if(gs.drawCube||gs.drawGroundPlate||gs.drawTable){bH=d3=true}if(!d3&&gs.enableHotspots){if(gs.hotspots&&gs.hotspots.points&&gs.hotspots.points.length>0){d3=true}}var hm="js/three_custom_min.js";if(a._FSIViewerLocation!=b){hm=a._FSIViewerLocation+"/applications/viewer/"+hm}o=false;if(d3){if(typeof(window.THREE)=="object"){o=true}else{if(!a.loadJavascript(hm,dQ,ba,eZ)){o=true;d3=false}}}else{a.releaseLoadJavascript(hm,dQ);o=true}}if(!d3){bH=false}if(o){dw()}};var eZ=function(o,hn,hm){if(typeof(window.THREE)!="object"){d3=false}if(!d3){bH=false}dw()};var dw=function(){if(gs.video.spinDirection&&gs.video.spinDirection.toLowerCase()=="left"){gs._reverseVideoDirection=true}if(gs.spinDirectionImage!=b){if(gs.spinDirectionImage.toLowerCase()=="left"){gs._reverseImageDirection=true}}else{gs._reverseImageDirection=gs._reverseVideoDirection}if(!aW.bDefault){if(gs._reverseImageDirection){for(var o=0;o<aW.arSets.length;o++){aW.arSets[o].arScenes.reverse()}gs._reverseImageDirection=false}if(gs.reverseSceneSets){aW.arSets.reverse()}}if(gs._reverseImageDirection){gX.reverse();gX.unshift(gX.pop())}f=ap();cU();eK();if(eE){fY(true)}else{fY(false)}if(ga){hh();fQ()}cB.run("onDataComplete")};var cy=function(){if(eB!=b&&cQ){cQ.setButtonPressed("MouseMode_"+eB,true)}if(bm){cW()}};var cU=function(){if(eR.width){hg=Math.min(cD,eR.width)}else{hg=cD}bi()};var bi=function(){b2.scaleToSourceImage=Math.max(1,eR.width/bd.imageWidth);b2.maxScale=b2.maxScaleInitial=gs.maxZoom/100*b2.scaleToSourceImage;b2.defaultZoom=Math.min(gs.desktopClickZoomScale,b2.maxScale)};this.destroyOnDetach=function(){if(gs&&gs.autoDestroy!=false){fW()}};var fW=this.destroy=function(o){cA();if(h){h=h.destroy()}if(H){H.destroy()}aK.destroy();hb();if(ge){ge.destroy()}if(am){am.removeAttribute("x-fsi-id");a.removeClass(am,"fsi-viewer")}if(m){m.destroy()}if(gE){gE.remove();gE=b}if(bx!=b){a.removeCustomEvent(gO,"FSIMouseWheel",fE);bx=b}if(A!=b){a.removeCustomEvent(g7,"FSIDocumentZoomChange",dX);A=b}if(eV!=b){a.removeCustomEvent(e2,"FSIViewport",a9);eV=b}if(gP){a.removeCustomEvent(gO,"FSIElementDimension",a4);gP=false}if(d7){clearTimeout(d7);d7=b}O();if(fM){fM.destroy();fM=b}eg();if(G){G.destroy();G=b}gl=false;gh();if(cQ){cQ.destroy();cQ=b}if(gO){if(ga){a.removeChild(e2,ga);a.removeChild(gO,e2);ga=b}if(gO.parentNode==am){a.removeChild(am,gO)}gO=b}if(V){a.removeChild(V.parentNode,V);V=b}if(g7){if(!a.isMobileDevice){a.removeEvent(g7,"keydown",cX);a.removeEvent(g7,"keyup",cj)}a.removeChild(g7.parentNode,g7);g7=b}if(!o&&cB){cB.run("onDestroy");cB.destroy()}};var n=function(){if(!bc||bc.width<10||bc.height<10){return false}if(g7==b){gM.eventOverlay=g7=document.createElement("div");g7.className="fsi-event-overlay";var hm="position:absolute;z-index:300;width:100%;height:100%;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;";if(a.isInternetExplorer){a.setStyleAttr(g7,hm+";background-color:rgba(0,0,0,0)")}else{a.setStyleAttr(g7,hm)}bW("wait");if(!a.isMobileDevice){g7.setAttribute("tabIndex","0")}gO.appendChild(g7);if(!G){var hn={};hn.detectGestures=true;hn.afterTouch={enabled:true};hn.afterTouch.modifyTarget=N;hn.afterTouch.fnGetAfterTouchEnabled=bh;hn.afterTouch.fnStartStopAfterTouch=I;if(b2.enabled){hn.detectClick=true;hn.onPinchStart=q;hn.onPinchChange=dV;hn.onPinchEnd=gL}G=new a.TouchHandler(g7,hn,eo,U,fH)}if(!a.isMobileDevice){a.addEvent(g7,"keydown",cX);a.addEvent(g7,"keyup",cj)}if(b2.enabled){bx=a.addCustomEvent(gO,"FSIMouseWheel",fE);a.setCustomEventListenerProperty(bx,"acceleration",1.7);a.setCustomEventListenerProperty(bx,"accelerationMax",30)}else{if(bx!=b){a.removeCustomEvent(gO,"FSIMouseWheel",fE);bx=b}}if(b2.enabled){if(A==b){A=a.addCustomEvent(g7,"FSIDocumentZoomChange",dX);a.triggerCustomEvent(A)}}else{if(A){a.removeCustomEvent(g7,"FSIDocumentZoomChange",dX);A=b}if(G){G.enable(true)}}}if(V==b&&eE){V=document.createElement("div");a.addClass(V,"fsi-ui-hotspot-container");a.setStyleAttr(V,"position:absolute;z-index:4;");g7.appendChild(V)}if(V){fb(V,false)}if(ga==b||ga.FSIisCanvas!=i){if(ga!=b&&ga.FSIisCanvas!=i){a.removeChild(gO,ga);fS=ga=bT=b}e2=document.createElement("div");e2.setAttribute("draggable","false");a.setStyleAttr(e2,"overflow:hidden;width:100%;height:100%;position:absolute;overflow:hidden;width:100%;height:100%;overflow:hidden");if(i){ga=document.createElement("canvas")}else{ga=document.createElement("div")}e2.appendChild(ga);gO.appendChild(e2);var o="z-index:1;position:absolute;transform-origin:0px 0px;	-webkit-transform-origin:0px 0px;	-ms-transform-origin:0px 0px;";o+="backface-visibility: hidden;-webkit-backface-visibility: hidden;";a.setStyleAttr(ga,o);if(i){cs=ga.getContext("2d");dy=cs.webkitBackingStorePixelRatio||cs.mozBackingStorePixelRatio||cs.msBackingStorePixelRatio||cs.oBackingStorePixelRatio||cs.backingStorePixelRatio||1;if(!eC){ga.style.width=ga.style.height=""}}else{ga.style.textAlign="left"}ga.FSIisCanvas=i}if(typeof(gs.backgroundColor)=="string"&&gs.backgroundColor.toLowerCase()=="none"){gs.backgroundColor="transparent"}gO.style.backgroundColor=gs.backgroundColor;if(!i){if(fS==b){fS=bT;bT=b}if(bT!=b){a.removeChild(bT.parentNode,bT)}bT=document.createElement("img");if(fS!=b){bT.style.display="none"}ga.appendChild(bT)}if(i){if(eV==b){eV=a.addCustomEvent(e2,"FSIViewport",a9);a.setCustomEventListenerProperty(eV,"treshold",250)}}else{if(eV!=b){a.removeCustomEvent(e2,"FSIViewport",a9);eV=b}a1.setRect(0,0,bc.width,bc.height)}ha=ga.width=Math.ceil(bc.width*at.scale);cT=ga.height=Math.ceil(bc.height*at.scale);ga.lastOffsetX=ga.lastOffsetY=0;if((a.BrowserSupports.documentZoom()&&!a.isMobileDevice)||(a.isMobileDevice&&!i)){fI=true}es();return true};var q=function(o,ho,hn){if(b2.maxScale<=1){fi.bActive=false;return}fi.bActive=true;fi.lastX=ho.x;fi.lastY=ho.y;fi.distanceStart=o._FSI_PinchDistance;var hm=a.getElementPosition(g7);fi.offsetX=-hm.left-bc.width/2;fi.offsetY=-hm.top-bc.height/2;fi.startZoom=b2.scale;aM(false)};var dV=function(hr,hp,hs){if(!fi.bActive){return}if(bb>1.2){hr.FSI_allowEventDefault=true;return}var hn=hp.x-fi.lastX;var o=hp.y-fi.lastY;fi.lastX=hp.x;fi.lastY=hp.y;var hu=fi.startZoom*hr._FSI_PinchScale;hu=Math.max(1,Math.min(b2.maxScale,hu));var ht=hu*100/b2.maxScale;var hq=hp.x+fi.offsetX;var ho=hp.y+fi.offsetY;var hm=hu/b2.scale;b2.panPos.left-=hq;b2.panPos.top-=ho;b2.panPos.left*=hm;b2.panPos.top*=hm;b2.panPos.left+=hq;b2.panPos.top+=ho;b2.panPos.left+=hn;b2.panPos.top+=o;ba.setZoom(ht,true,false)};var gL=function(o,ho,hn){if(!fi.bActive){return}fi.bActive=false;aM(true);var hm=b2.scale*100/b2.maxScale;ba.setZoom(hm,false,false)};var J=function(hn){bb=hn;var hm=hl;if(hm<1||gs.useDevicePixelRatio){hn=hm*hn}if(fo!=hn){fo=hn;b2.maxScale=Math.max(1,b2.maxScaleInitial/hn);dH();cf=hn;if(eE){var o=cf;if(!a.isMobileDevice&&hl!==1){o/=hl}if(eL!==o){eL=o;dK=true}if(!b9){g5()}}}};var eI=function(){var o=false;if(a.FullScreen){o=a.FullScreen.getElement()}return(o&&o!=dR)};var a9=function(o){if(eI()){return}b1=o.FSI_viewport_rect;J(o.FSI_scale);if(!cl){return}s(o.FSI_after_treshold)};var dX=function(){e7()};var e7=function(){if(gs.autoDisablePointerActions){var hm=a.getVisualViewportSize();var o=(ba.getInFullScreenMode()||(ah.width<=hm.width&&ah.height<=hm.height));if(o!==gt){gt=o;G.enable(o);if(f8){f8.enable(o)}}}};var aO=function(){return(c5&&(!G||!G.isAfterTouchRunning()))};var fE=function(ht){gM.onUserAction();if(fD.bEnabled||ht.FSI_delta==0){return}az(false);if(ht.preventDefault){ht.preventDefault()}x();bO();var hu=aO();if(b9||hu){return}if(b2.maxScale<=1){return}var hs=0.45*ht.FSI_normalized_accelerated_delta;cw=G.getMousePositionClient(ht);var hr=a.getElementPosition(g7);var hn=1+Math.abs(hs)/6;if(hs<0){hn=1/hn}var hv=Math.max(1,Math.min(b2.maxScale,b2.scale*hn));var hq=cw.x*at.scale-hr.left-bc.width*at.scale/2;var hp=cw.y*at.scale-hr.top-bc.height*at.scale/2;var o=hv/b2.scale;var ho=b2.panPos.left-hq;var hm=b2.panPos.top-hp;ho*=o;hm*=o;ho+=hq;hm+=hp;eM(ho,hm,hv,13);if(f8&&f8.isDragging()){b2.lockPanAnimation=true}ht.cancelBubble=true};var I=function(o){gH=o;if(o){g5()}};var gu=function(){if(!dY){return}aw=false;if(dY._timeOutDraw){clearTimeout(dY._timeOutDraw)}dY=b};var eD=function(){if(!gs.showProgressbar){return}if(gX.length<2){gu();return}if(!i){return}var o=0;switch(gs.progressBarHAlign){case"left":case"right":o=8;break}d6=Math.max(10,(bc.width*(Math.max(0,Math.min(100,gs.progressBarWidth/100)))-2*o))*at.scale;dO=Math.max(1,Math.min(bc.height,gs.progressBarHeight))*at.scale;dY=new a.CanvasProgressBar(cs,0,0,d6,dO,aU.oProgressBarStyle);cI();dY._timeOutDraw=setTimeout(bw,100)};var bw=function(){if(dY){aw=true}};var cI=function(){if(!dY){return}var o,hm;switch(gs.progressBarHAlign){case"left":o=at.scale*8;break;case"right":o=at.scale*(bc.width-d6-8);break;default:o=at.scale*((bc.width-d6)/2)}switch(gs.progressBarVAlign){case"middle":case"center":hm=at.scale*(bc.height/2-dO/2);break;case"top":hm=at.scale*4;break;default:hm=at.scale*(bc.height-4-dO)}dY.setPos(o,hm)};var fQ=function(){var hy;cz(0);var hq=false;aE=(!a.isMobileDevice&&(a.isOpera||a.isInternetExplorer));eD();bW("wait");var hs="";if(f.indexOf("//")==-1){hs=gs.video.base}if(!i||a.isMobileDevice||!f){dv.log("Using image sequence w/o video.");return de()}var hw=gs.video.captureOffsetStart;if(hw==b||isNaN(hw)){hw=0}var ho=gs.video.captureOffsetEnd;if(ho==b||isNaN(ho)){ho=0}var hr;hy=gs.video.captureFrames;if(hy==b||isNaN(hy)){gs.video.captureFrames=120}if(aW.nSceneSets>1){var ht=a7();gs.video.captureFrames=Math.max(gs.video.captureFrames,ht.max)}else{gs.video.captureFrames-=gs.video.captureFrames%gX.length;gs.video.captureFrames=Math.max(gs.video.captureFrames,gX.length)}var hx=document.createElement("canvas");hx.setAttribute("webkit-playsinline","");var hu=hx.getContext("2d");if(!dr){dr=document.createElement("canvas");hf=dr.getContext("2d")}hy=hs+f;if(a.isInternetExplorer&&a.versionInternetExplorer<10&&a.isCrossDomain(hy)){dv.error("CROSS DOMAIN VIDEO ACCESS not possible with this browser.");dv.log("Falling back to using image sequence.");return de()}dv.log("Capture "+gs.video.captureFrames+" video frames");dP=document.createElement("video");dP.setAttribute("muted","muted");dP.setAttribute("preload","auto");dP.setAttribute("webkit-playsinline","");dP.setAttribute("crossorigin","anonymous");a.setStyleAttr(dP,"position:absolute;z-index:10000;width:1px;height:1px");if(a.isSafari){dP.style.display="none"}dP.style.marginLeft=bc.width/2+"px";dP.style.marginTop=bc.height/2+"px";if(!a.isSafari&&!a.isInternetExplorer){var hn=document.createElement("source");hn.setAttribute("src",hs+f+".webm");dP.appendChild(hn)}var hm=document.createElement("source");hm.setAttribute("src",hs+f+".mp4");dP.appendChild(hm);if(!a.isSafari&&!a.isInternetExplorer){var o=document.createElement("source");o.setAttribute("src",hs+f+".ogv");dP.appendChild(hm)}gO.appendChild(dP);dP.FSIEvents={};var hv=function(hA,hB,hz){dP.FSIEvents[hA]={fn:hB,phase:hz};a.addEvent(dP,hA,hB,hz)};hv("error",function(hz){if(dP.networkState==dP.NETWORK_NO_SOURCE){dv.error('Failed loading the video: "'+f+'"');dv.log("Falling back to using image sequence w/o video.");de()}},true);hv("loadedmetadata",function(hA){b9=true;el("video");var hB=dP.videoWidth;var hz=dP.videoHeight;dP.setAttribute("width",hB);dP.setAttribute("height",hz);hr=(dP.duration-hw-ho)/gs.video.captureFrames;gC(hB,hz);hx.setAttribute("width",cS.croppedWidth);hx.setAttribute("height",cS.croppedHeight);dr.setAttribute("width",cS.croppedWidth);dr.setAttribute("height",cS.croppedHeight);cy();gU()},true);hv("canplaythrough",function(hz){if(!hq){if(a.isSafari){dP.style.display=""}hq=true;this.currentTime=Math.max(0,hw)}},true);var hp=0;hv("seeked",function(hz){if(!b9){return}var hA=dP.duration;if(a.isInternetExplorer){hA-=0.3}if(e.length<gs.video.captureFrames){try{hu.drawImage(hz.target,0,0,cS.width,cS.height,-fm.left,-fm.top,cS.width,cS.height);var hC=hu.getImageData(0,0,hx.width,hx.height);e.push(hC)}catch(hB){dv.error('Failed capturing the video: "'+f+'"');dv.log("REASON: "+hB.message);dv.log("Falling back to using image sequence w/o video.");b9=false;de();return}cz(100*e.length/gs.video.captureFrames);cb(e.length-1);g5();hp=Math.min(hA,hr*e.length+hw);if(aE){d7=setTimeout(function(hD){dP.currentTime=hp},1)}else{dP.currentTime=hp}}else{c3()}},true)};var fA=this.startAutoSpin=function(){if(!cl||!fZ.bEnabledByConfig){return false}if(fZ.interval){return true}if(cQ){cQ.setButtonPressed("ToggleAutoSpin",true)}x();bP();bY("autoSpin");fZ.enabled=true;eu();fZ.interval=setInterval(fR,fZ.nIntervalTime);return true};var gy=function(){if(!cl||!fZ.bEnabledByConfig){return false}if(!fZ.enabled){fA()}else{az(true)}};this.stopAutoSpin=function(){return az()};var az=gM.stopAutoSpin=function(o){if(!cl||!fZ.bEnabledByConfig){return false}if(!fZ.interval){return true}if(cQ){cQ.setButtonPressed("ToggleAutoSpin",false)}fZ.enabled=false;gg("autoSpin");clearInterval(fZ.interval);fZ.interval=b;if(o){eG()}return true};var fR=function(){if(!hj){bY("autoSpin")}var o=ew+fZ.nDirection;if(o>=em){o-=em}else{if(o<0){o+=em}}gV(o);g5()};var aQ=function(hm){em=hm;var o=1;if(typeof(gs.fMouseSensitivity)!="undefined"){o=parseFloat(gs.fMouseSensitivity);if(isNaN(o)||o==0){o=1}}fp=160/em*4/o;dF=em/120};var gn=function(){var o;if(!aW.bDefault&&aW.nSceneSets>1){o=Math.max(1,Math.min(aW.nSceneSets,gs.video.sceneSet))-1;if(gs.reverseSceneSets){o=(-(o+1)+aW.nSceneSets)%aW.nSceneSets}}return o};var c3=function(){if(gs._reverseVideoDirection){e.reverse();e.unshift(e.pop())}bs.unshift(v.imageWidth);fx=e.length;if(e.length>0){aW.nVideoSet=gn()}else{aW.nVideoSet=b}if(aW.nVideoSet!=b){var o=gS;de();gS=o}else{dM();bZ()}};var bZ=function(){var hm;cz(100);g0();if(ca!=b){f1=ca}a3();if(aW.bQuantize){fU()}cb(0);aw=false;bK=d3;cr=b;if(gs._reverseImageDirection&&f8){f8.reverseImageSequence()}if(eQ){g5()}ej();gu();bj();bA=false;fZ.bEnabledByConfig=false;if(em>1||aW.nSceneSets>1){w=false;if(a.isIETouch){if(aW.nSceneSets>1){g7.style.msTouchAction="pinch-zoom double-tap-zoom"}else{g7.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}}if(gs.autoSpinSpeed!=0||gs.autoSpinInterval!=0){if(gs.autoSpinInterval!=0){hm=gs.autoSpinInterval;fZ.nDirection=(hm>0)?1:-1;hm=Math.abs(hm)}else{if(gs.autoSpinSpeed<0){gs.autoSpinSpeed=-gs.autoSpinSpeed;fZ.nDirection=-1}else{fZ.nDirection=1}hm=gs.autoSpinSpeed*1000/em;if(hm==0){hm=1}while(hm<20&&Math.abs(fZ.nDirection)<em/2){hm*=2;fZ.nDirection*=2}hm=Math.max(20,Math.ceil(hm))}fZ.nIntervalTime=hm;fZ.bEnabledByConfig=true;if(!ge.hasPlugin("autospin")||ge.getPluginParameter("autospin","enabled",true,true)){bA=ge.getPluginParameter("autospin","restartonreset",false,true);cl=true;fA();cl=false}}}else{w=true;if(a.isIETouch){g7.style.msTouchAction=b}if(!b2.enabled){bW("default")}}hm=gs.initialMouseMode;if(hm!="auto"){hm=parseInt(hm)}e9(hm);b9=false;var o=b;if(gs.video.frameOffset&&gS){o=ew+gs.video.frameOffset;o=he(em+o);cb(o)}b8();cl=true;if(cQ){cQ.setEnabled(true)}if(c!=b){gT(c,(gX.length>1));c=b}else{if(al!=b&&ge.makeBool(ge.cfg.keepcurrentviewafterconfigchange,false)){gs.initialview=al}if(gs){if(typeof(gs.initialview)==="string"&&gs.initialview.length>0){if(!gT(gs.initialview,false)){gs.initialview=b}else{gs.initialview=cH(gs.initialview)}}else{gs.initialview=b}}}al=b;if(dv.on){dv.log("Startup time: "+(a.now()-c6)+"ms")}cB.run("onReady");ag();ce();if(b2.enabled){b0()}if(!b2.enabled){if(w){G.setCapture(false,false)}else{G.setCapture(true,false)}}if(eV){a.triggerCustomEvent(eV);s(true)}cB.runPersistent("onAfterReady")};var de=function(){hb();dC=e.length;el("image");gU();dM();ej();l(eR.width,eR.height);cy();fj()};var dp=function(){a.removeEvent(bT,"load",dp);if(fS!=b&&fS.parentNode!=b){a.removeChild(fS.parentNode,fS);fS=b}bT.style.display="inline";ga.style.paddingLeft=W.imageX+"px";ga.style.paddingTop=W.imageY+"px"};var fj=function(){b9=true;if(!i){bT.width=W.imageWidth;bT.height=W.imageHeight;a.addEvent(bT,"load",dp,true);if(fS==b){try{ga.style.paddingLeft=ga.style.paddingRight="auto";ga.style.paddingTop=ga.style.paddingRight="auto"}catch(o){}}}if(dr){dr.setAttribute("width",W.imageWidth);dr.setAttribute("height",W.imageHeight)}e8()};var eY=function(o){if(o){eS()}else{g0()}};var fV=function(o,hn,ho,hm){var hp;o.FSI_image_context=o;if(br){hp={};hp.argsJPEG=Array.prototype.slice.call(arguments);hm=dq;hn=a.changeRendererInURL(hn,"png.alpha");o=hp.argsJPEG[0]._FSI_alpha_mask=new Image()}aK.load(o,hn,ho,hm,hp)};var dq=function(o,hm){aK.load.apply(this,hm.argsJPEG)};var cp=function(hn){if(!hn){return}if(hn.FSI_alpha_channel){var hm=hn.width;var hp=hn.height;var ho=hn.FSI_image_context=document.createElement("canvas");ho.setAttribute("width",hm);ho.setAttribute("height",hp);ho.setAttribute("crossorigin","anonymous");var o=ho.getContext("2d");o.drawImage(hn.FSI_alpha_channel,0,0,hm,hp);o.globalCompositeOperation="xor";o.drawImage(hn,0,0,hm,hp);hn.FSI_alpha_channel=b}};var cz=function(o){Y=o;if(cK){cB.runPersistent("onProgress",[o])}};var e8=function(){ep={};ep.oImages={};ep.nPendingImages=0;ep.nNext=0;ep.nCurrentIndex=-1;ep.nLoaded=0;if(!i){ep.img=new Image()}var hm=Math.min(6,gX.length);for(var o=0;o<hm;o++){C()}};var gx=function(o){ep.nLoaded++;cz(100*ep.nLoaded/gX.length);if(ep.nNext!==this.FSI_nImage){ep.oImages[this.FSI_nImage]=this;ep.nPendingImages++}else{bQ(this);dS()}C()};var dS=function(){if(ep&&ep.nPendingImages>0){while(ep&&ep.oImages[ep.nNext]){var hm=ep.nNext;var o=ep.oImages[hm];ep.oImages[hm]=b;ep.nPendingImages--;bQ(o)}}};var bQ=function(o){ep.nNext++;cp(o);if(i){e.push(o)}else{e.push(o.src)}cb(e.length-1);g5();if(ep.nLoaded>=gX.length){dS();ai();if(eQ){eQ.addImage(bT)}bZ()}};var C=function(){if(!ep||++ep.nCurrentIndex>=gX.length){return}var o;if(i){o=eW=new Image();o.FSI_nImage=ep.nCurrentIndex}else{o=ep.img}fV(o,gK(ep.nCurrentIndex).fullURL,"sequence",gx)};var ai=function(){if(ep===b){return}aK.abortPurpose("sequence");ep=b};var gV=function(o){var hm=he(Math.round(o));if(hm!=he(ew)){dH();cb(hm);g5();if(cl&&fw==b&&fZ.interval==b){ag()}}ec=o};var bY=function(o){if(hj){return}R=true;hj=true;O();c1=false;z=false};var gg=function(o){if(!hj){return}cb(he(ew));hj=false;c1=true;z=true;if(!dj||ew!=dj.spinPos){if(dj){fl()}ff()}else{cV(50)}};var cb=function(o){ew=ec=o;if(!aR){dk=ew}else{dk=aR[ew]}};var cq=function(){var o,hr,hn;ea=document.createElement("canvas");ea.setAttribute("width",cS.croppedWidth);ea.setAttribute("height",cS.croppedHeight);ek=ea.getContext("2d");var hp=ea.width;var hm=ea.height;var ho=ek.createImageData(hp,hm);var hq=ho.data;for(hr=0;hr<hm;hr++){if(hr%4==0){for(o=0;o<hp;o++){if(o%4!=0){hn=hr*hp*4+o*4;hq[hn]=0;hq[hn+1]=0;hq[hn+2]=0;hq[hn+3]=255}}}else{if(hr%4==1||hr%4==2){for(o=1;o<hp;o+=4){hn=hr*hp*4+o*4;hq[hn]=0;hq[hn+1]=0;hq[hn+2]=0;hq[hn+3]=255}}}}ek.putImageData(ho,0,0)};var g5=function(){if(K!=b||e1){return}K=requestAnimationFrame(ar)};var hb=function(){if(K==b){return}cancelAnimationFrame(K);K=b};var ar=function(){K=b;var o=false;if(gH&&G.runAfterTouch()){o=true}if(!i){if(aZ!=dk){bT.src=e[dk];aZ=dk}}else{if(Q&&ft()){o=true}cs.globalAlpha=1;cs.clearRect(0,0,ha,cT);f1();if(c1&&dj){if(hk()){o=true}}}if(bK){if(gZ){var hp=gY*bc.width;var hn=gY*bc.height;gZ=false;var ho=-at.drawOffsetX+(hp-bc.width*at.scale)/2-b2.panPos.left+aP.x*b2.scale;var hm=-at.drawOffsetY+(hn-bc.height*at.scale)/2-b2.panPos.top+aP.y*b2.scale;dL.camera.setViewOffset(hp,hn,ho,hm,at.totalWidth,at.totalHeight)}if(dc){er()}if(bH){dL.renderer.render(dL.scene,dL.camera)}if(dc){dc=false;if(eE&&dW){if(!bH){dL.renderer.render(dL.scene,dL.camera)}bJ()}}}if(gB){gB=false;if(f8){f8.update(dk,ao)}}if(fT){go();cs.fillStyle=bl;cs.fillRect(gD.left+1,gD.top+1,gD.width()-1,gD.height()-1);cs.fillStyle=aq;cs.fillRect(gD.left,gD.top,gD.width(),1);cs.fillRect(gD.left,gD.bottom,gD.width(),1);cs.fillRect(gD.left,gD.top,1,gD.height());cs.fillRect(gD.right,gD.top,1,gD.height())}if(aw){dY.draw(Y)}if(df){if(b5){g(ga,"translate3d("+at.left+"px,"+at.top+"px,0px)"+at.strTransformScale)}else{g(ga,"translate("+at.left+"px,"+at.top+"px)"+at.strTransformScale)}}if(o){g5()}};var er=function(){var o;if(cO.oSpinPositions){o=cO.oSpinPositions.arPositions[dk]}else{o=ew/em}fh(0,o*F,0)};var go=function(){gD.copyRect(aJ);gD.offsetRect(-aJ.clientOffset.left,-aJ.clientOffset.top);gD.normalizeRect();if(at.scale!=1){gD.scaleRect(at.scale)}};var dH=function(){dc=gB=true};var en=function(){return false};var L=function(o){cs.drawImage(o.img.FSI_image_context,o.x,o.y,o.width,o.height);return false};gM.getAccessToken=function(){return aT};this.setAccessToken=function(o){aT=o;if(ge){ge.setAccessToken(aT)}};var gI=function(hm){var o;hm.alpha+=e4;if(hm.alpha>=1){hm.fnDraw=L;hm.alpha=1;o=false}else{o=true}cs.globalAlpha=hm.alpha;L(hm);cs.globalAlpha=1;return o};var hk=function(){var o=false;if(z){gR()}if(dj.nVisibleTiles>0){var hq=at.drawOffsetX+W.imageX+b2.panPos.left;var hp=at.drawOffsetY+W.imageY+b2.panPos.top;var ho=W.imageWidth/dj.width;cs.save();cs.translate(hq,hp);cs.scale(ho,ho);var hm=dj.arVisibleTiles;for(var hn=0;hn<dj.nVisibleTiles;hn++){if(hm[hn].fnDraw(hm[hn])){o=true}}cs.restore()}dj.bTilesFading=o;if(!hc&&R&&!o&&dj.bFilesArePreparedForLoading){if(cr.nTilesLoading==0&&dj.arTilesToLoad.length==0){R=false}}return o};var el=function(o,hm){fd=(o=="video");if(fd){eJ=b;du=dr;bU=gM.getPreviewImage=aC;f1=cm}else{bU=gM.getPreviewImage=cC;f1=gr}if(!hm){gS=fd;if(gs){if(gX.length>1){if(!gs.showPreviewWhileLoading){ca=f1;f1=a.fnDoNothing}else{if(!gs.spinPreviewWhileLoading){ca=f1;if(!aA.bSetup){aA.bStillPreview=true;f1=a.fnDoNothing}else{if(aA.imgDraw){f1=gc}else{f1=a.fnDoNothing}}}else{ca=b}}}aA.bSetup=true}}};var gU=function(){if(!aA.bStillPreview||aA.bStillPreviewDone){return}gw()};var gw=function(){aA.bStillPreviewDone=true;var ho=cl;cl=true;var hp;var hq=eq(gs.initialview);var o;if(aW.bDefault){hp=hq.scene}else{var hn=aW.arSets[hq.SceneSet];hp=hn.arScenes[hq.scene]-1}bM();var hm=gK(hp).fullURL;aA.img=new Image();fV(aA.img,hm,"stillPreview",B);cl=ho;bv=b};var B=function(){cp(this);aA.imgDraw=this.FSI_image_context;f1=gc};var gc=function(){av(aA.imgDraw,W.imageX,W.imageY,gY)};var aC=function(o){if(eJ==o){return du}eJ=o;hf.putImageData(e[o],0,0);du=dr;return du};var cC=function(o){if(eJ==o){return du}eJ=o;if(!c0){c0=v.imageWidth;if(g6){ay=document.createElement("canvas");ay.setAttribute("width",v.imageWidth);ay.setAttribute("height",v.imageHeight);g2=ay.getContext("2d")}}if(!g6){du=e[o].FSI_image_context}else{g2.drawImage(e[o].FSI_image_context,0,0,v.imageWidth,v.imageHeight);du=ay}return du};var cm=function(){cs.globalAlpha=1;var o=gY*v.videoWidth/cS.croppedWidth;av(aC(dk),W.videoX,W.videoY,o);if(R&&gs.pellets&&!E){cs.globalAlpha=gs.pelletsOpacity;cs.globalCompositeOperation="xor";av(ea,W.videoX,W.videoY,o);cs.globalAlpha=1;cs.globalCompositeOperation="source-over"}};var gr=function(){av(cC(dk),W.imageX,W.imageY,gY)};var av=function(ho,hv,hs,hm){if(!ho){return}var hu=0;var ht=0;var hp=at.drawOffsetX+hv+b2.panPos.left;var hn=at.drawOffsetY+hs+b2.panPos.top;if(hp<0){hu=-hp/hm;hp=0}if(hn<0){ht=-hn/hm;hn=0}var hw=ho.width-hu;var hr=ho.height-ht;var hq=hw*hm;var o=hr*hm;cs.drawImage(ho,hu,ht,hw,hr,hp,hn,hq,o)};gM.getImagePos=function(ho){var hn,o,hm,hp;if(ho){hn=bd.imageXAbsolute;o=bd.imageYAbsolute;hm=bd.imageWidthAbsolute;hp=bd.imageHeightAbsolute}else{hn=at.drawOffsetX+(W.imageX+b2.panPos.left)/at.scale;o=at.drawOffsetY+(W.imageY+b2.panPos.top)/at.scale;hm=W.imageWidth/at.scale;hp=W.imageHeight/at.scale}return{x:hn,y:o,width:hm,height:hp}};var cW=function(){if(f8!=b){eg()}if(b2.enabled&&i){f8=new a.NavigatorWindow(gM,ge,aU,gO);if(fD.hideUI){f8.enable(false,true)}}};var eg=function(){if(f8==b){return}f8.destroy();f8=b};var cd=function(){if(!d3||!dL.targetObj){return}var ho=bc.width*at.scale;var hs=bc.height*at.scale;dL.sceneWidth=bd.imageWidth*aP.cropScaleX;dL.sceneHeight=bd.imageHeight*aP.cropScaleY;var hp=dL.sceneWidth;var o=hp/1.5;var hr=o/hs;var hq=gs.camera.digitalCropFactor*gs.camera.focalLength*hr;var hm=2*THREE.Math.radToDeg(Math.atan(24/hq/2));dL.camera=new THREE.PerspectiveCamera(hm,dL.sceneWidth/dL.sceneHeight,0.1,10000);var hn=ge.parsePositionParameter(gs.camera.position);if(hn!=b){aX.x=hn.x;aX.y=hn.y;aX.z=hn.z}else{if(gs.camera.heightTable!=b&&gs.camera.heightCamera!=b){gs.camera.heightAboveTable=gs.camera.heightCamera-gs.camera.heightTable}if(gs.camera.shiftX==b){gs.camera.shiftX=0}aX.x=gs.camera.shiftX;aX.y=gs.camera.heightAboveTable;aX.z=gs.camera.distanceToTableCenter}dL.camera.position.x=aX.x;dL.camera.position.y=aX.y;dL.camera.position.z=aX.z;eT();dL.camera.lookAt(dL.targetObj.position);dL.camera.rotation.z=0;fc();dL.camera.setViewOffset(ho,hs,-at.drawOffsetX+aP.x,-at.drawOffsetY+aP.y,ho,hs)};var hh=function(){if(!d3){return}var hN;hN=window.THREE;if(a.BrowserSupports.canvas()&&typeof hN!=="undefined"){if(i){dL.renderer=new hN.CanvasRenderer({canvas:ga,clearColor:0,clearAlpha:0,devicePixelRatio:1});dL.renderer.autoClear=false;dG(bc.width*at.scale,bc.height*at.scale)}else{dL.renderer=new hN.CanvasRenderer({clearColor:0,clearAlpha:0});dL.renderer.autoClear=false;dG(bc.width,bc.height)}dL.scene=new hN.Scene();dL.objects=new hN.Object3D();var hw=new hN.Object3D();var hM=ge.parsePositionParameter(gs.camera.targetPosition);if(hM==b){hw.position.x=gs.camera.targetWidthOffset;hw.position.y=gs.camera.targetHeightOffset;hw.position.z=0}else{hw.position.x=hM.x;hw.position.y=hM.y;hw.position.z=hM.z}dL.scene.add(hw);dL.targetObj=hw;var hv;if(gs.virtualSpace.cubeLineWidth>0&&gs.drawCube){var hK,hn;if(gs.virtualSpace.cubeSizeX){hK=new hN.CubeGeometry(gs.virtualSpace.cubeSizeX,gs.virtualSpace.cubeSizeY,gs.virtualSpace.cubeSizeZ);hv=gs.virtualSpace.cubeSizeY/2}else{hK=new hN.CubeGeometry(gs.virtualSpace.cubeSize,gs.virtualSpace.cubeSize,gs.virtualSpace.cubeSize);hv=gs.virtualSpace.cubeSize/2}hn=new hN.MeshBasicMaterial({color:65280,wireframe:true,wireframeLinewidth:gs.virtualSpace.cubeLineWidth});var hr=new hN.Mesh(hK,hn);if(gs.virtualSpace.shiftY==b){gs.virtualSpace.shiftY=0}hr.position.x=gs.virtualSpace.shiftX;hr.position.y=hv+gs.virtualSpace.shiftY;hr.position.z=gs.virtualSpace.shiftZ;dL.cube=hr;dL.objects.add(hr)}if(gs.drawGroundPlate){var hC=new hN.PlaneGeometry(500,500,10,10);var hx=new hN.MeshBasicMaterial({color:15626314,wireframe:true});var ho=new hN.Mesh(hC,hx);ho.rotation.x=-Math.PI/2;ho.position.y=0;dL.objects.add(ho);dL.plane=ho}if(gs.drawTable){var o=gs.tableDiameter/2;var hG=50;var hm=new hN.Geometry();var hO;hO=Math.PI*2/360;var hD=0;var hs=function(hS,hR){var hU=0;var hV=0;var hZ=0;var hT=0;for(var hW=0;hW<=36;hW++,hD+=4){var hQ=Math.sin(hO*hW)*hS;var hY=Math.cos(hO*hW)*hS;var hP=Math.sin(hO*hW)*hR;var hX=Math.cos(hO*hW)*hR;hm.vertices.push(new hN.Vector3(hP,hX,0));hm.vertices.push(new hN.Vector3(hZ,hT,0));hm.vertices.push(new hN.Vector3(hU,hV,0));hm.vertices.push(new hN.Vector3(hQ,hY,0));hm.faces.push(new hN.Face3(hD,hD+1,hD+2));hU=hQ;hV=hY;hZ=hP;hT=hX}};var ht=0;var hq=0;for(var hL=0;hL<=4;hL++,hD+=3){var hA=Math.sin(hO*hL*90)*hG;var hz=Math.cos(hO*hL*90)*hG;hm.vertices.push(new hN.Vector3(0,0,0));hm.vertices.push(new hN.Vector3(hA,hz,0));hm.vertices.push(new hN.Vector3(ht,hq,0));hm.faces.push(new hN.Face3(hD,hD+1,hD+2));ht=hA;hq=hz}hO=Math.PI*2/36;var hF=0;var hE=hG;while(hE<o){hF+=hG;hE=hF+hG;if(hE>o){hE=o}hs(hF,hE)}var hJ=new hN.Mesh(hm,new hN.MeshBasicMaterial({color:5810431,wireframe:true}));hJ.rotation.x=-Math.PI/2;dL.disk=hJ;dL.objects.add(hJ)}if(gs.hotspots&&gs.hotspots.points){aS();gk=gs.hotspotCallbackFunction;if(typeof(gk)=="string"){try{gk=window[gk]}catch(hI){}}else{if(typeof(gk)!="function"){gk=b}}var hB=1;eA={};for(var hH=0;hH<gs.hotspots.points.length;hH++,hB++){var hu=gs.hotspots.points[hH];hu.FSIHotspotID=hB;eA[hB]=hu;if(hu.perimeterAngle!=b&&hu.perimeterAngleY==b){hu.perimeterAngleY=hu.perimeterAngle;hu.perimeterAngleYRange=hu.perimeterAngleRange;hu.perimeterAngleYFadeOut=hu.perimeterAngleFadeOut}if(hu.perimeterAngleY&&hu.perimeterAngleY<0){hu.perimeterAngleY=360+hu.perimeterAngleY}hu.perimeterAngleYFadeOut=Math.min(hu.perimeterAngleYRange,hu.perimeterAngleYFadeOut);if(hu.perimeterAngleX!=b&&hu.perimeterAngleX<0){hu.perimeterAngleX=360+hu.perimeterAngleX}hu.perimeterAngleXFadeOut=Math.min(hu.perimeterAngleXRange,hu.perimeterAngleXFadeOut);var hy=new hN.Object3D();hy.position.x=hu.x+gs.virtualSpace.shiftX;hy.position.y=hu.y+gs.virtualSpace.shiftY;hy.position.z=hu.z+gs.virtualSpace.shiftZ;hu.object=hy;dL.objects.add(hy);if(gs.hotspots.defaults){for(var hp in gs.hotspots.defaults){if(hu[hp]==b){hu[hp]=gs.hotspots.defaults[hp]}}}dm(hu)}dv.log(hH+" HotSpots created.")}dL.scene.add(dL.objects);cd()}};var fg=function(o){var hm=o.type;fP(hm,this)};var fP=function(hp,hn){var hr=false;var o=hn.FSIHotspot;if(!o||!hp){return false}switch(hp){case"mouseover":a.addClass(hn,o.hoverClass);o._bMouseOver=true;o.marker.style.zIndex=o.tooltip.style.zIndex=5000000;break;case"mousedown":a.addClass(hn,o.activeClass);break;case"mouseout":o._bMouseOver=false;a.removeClass(hn,o.hoverClass);o.marker.style.zIndex=o.tooltip.style.zIndex=o.zIndex;break;default:a.removeClass(hn,o.activeClass)}if(gk){var hq=o.FSIHotspotID;var ho=o.tooltip;var ht=o.actionParameter;var hs=gk(hp,ba,M,hq,ho,ht,o.perimeterAngleY,o.perimeterAngleX);if(hs===true){hr=true}}if(hp=="click"){if(o.url!=b){window.open(o.url,o.urlTarget);hr=true}if(hr==false&&o.focusOnClick==true){var hm=fe(o);gT(hm,true);hr=true}}cB.run("onHotspotEvent",[hp,o.FSIHotspotID,o.id,o.text]);return hr};var fh=function(hn,hm,o){dL.objects.rotation.x=hn;dL.objects.rotation.y=hm+gs.virtualSpace.baseRotationYRad;dL.objects.rotation.z=o};var bJ=function(){var hD,hE;var hy=new THREE.Vector3();if(dK){dK=false;var hn=1/eL;g4.testWidth=gY*v.imageWidth;V.style.webkitTransform="scale("+hn+")";V.style.transform="scale("+hn+","+hn+")"}var hG=eL*at.left;var hF=eL*at.top;var hH=eL*bc.width/2;var hp=eL*bc.height/2;var ht,hv;var hC=false;var hu;var hJ=bc.width*eL;var hI=bc.height*eL;if(g4.spinFrame!=dk){g4.spinFrame=dk;if(g4.arSpotsAtFrame==b){g4.arSpotsAtFrame=new Array(em)}var hB=g4.hotSpotsAtThisFrame;g4.hotSpotsAtThisFrame=g4.arSpotsAtFrame[dk];if(g4.hotSpotsAtThisFrame==b){var hs;if(cO.oSpinPositions){hs=gs.virtualSpace.rotationYRange*cO.oSpinPositions.arPositions[dk]}else{hs=gs.virtualSpace.rotationYRange*he(ew)/em}g4.hotSpotsAtThisFrame=g4.arSpotsAtFrame[dk]=[];for(hE=0;hE<gs.hotspots.points.length;hE++){hu=gs.hotspots.points[hE];hv=1;if(hu.perimeterAngleY!=b){var hK=Math.abs(hu.perimeterAngleY-hs);if(hK>180){hK=Math.abs(360-hK)}if(hK<hu.perimeterAngleYRange){if(hK>hu.perimeterAngleYRange-hu.perimeterAngleYFadeOut){hv=(hu.perimeterAngleYRange-hK)/hu.perimeterAngleYFadeOut}}else{hv=0}}if(hv!=0){var hA={};hA.index=hE;hA.hotspot=hu;hA.op=hv;g4.hotSpotsAtThisFrame.push(hA);hy.setFromMatrixPosition(hu.object.matrixWorld);hu.zIndex=hA.zIndex=Math.round(hy.z);if(!hu._bMouseOver){hu.marker.style.zIndex=hu.tooltip.style.zIndex=hu.zIndex}}}}if(hB&&hB.length>0){var hz={};for(hD=0;hD<g4.hotSpotsAtThisFrame.length;hD++){var hm=g4.hotSpotsAtThisFrame[hD];hu=hm.hotspot;if(!hu._bMouseOver){hu.marker.style.zIndex=hu.tooltip.style.zIndex=hu.zIndex}hz[hm.index]=hu.bVisible}for(hD=0;hD<hB.length;hD++){if(!hz[hB[hD].index]){bG(hB[hD].hotspot,false)}}}}if(g4.scale!=eL){g4.scale=eL;hC=true}for(hE=0;hE<g4.hotSpotsAtThisFrame.length;hE++){var ho=g4.hotSpotsAtThisFrame[hE];hu=ho.hotspot;hv=1;if(cO.visibleHotSpots){hv=cO.visibleHotSpots[hu.FSIHotspotID]}hv=hv*ho.op;if(!hC&&hu._opScale!=b){if(hu._opScale==0){hv=0}}else{hu._opScale=1;if(gs.enableZoom&&hu.perimeterZoom!=b){if(gY<hu.perimeterZoom){hv=hu._opScale=0}}if(hv!=0&&hu.perimeterImageWidth!=b){if(g4.testWidth<hu.perimeterImageWidth){hv=hu._opScale=0}}}if(hv!=0){hy.setFromMatrixPosition(hu.object.matrixWorld);hy.project(dL.camera);var hr=Math.round(hG+hy.x*hH+hH);var hq=Math.round(hF+hp-hy.y*hp);if(b2.enabled){if(hr<0||hq<0||hr>hJ||hq>hI){hv=0}}}if(hv!=0){bG(hu,true);if(hu._opacity!=hv){hu._opacity=hv;hu.marker.style.opacity=hu.tooltip.style.opacity=hv}var hx=hu.oSvg;hu.tooltip.style.left=hr+hx.endX+(hu.tooltip.offsetWidth*hx.xAlign)+"px";hu.tooltip.style.top=hq+hx.endY+(hu.tooltip.offsetHeight*hx.yAlign)+"px";hu.marker.style.left=hr+hx.startX+"px";hu.marker.style.top=hq+hx.startY+"px"}else{bG(hu,false)}}};var aN=function(ho,ht,hm,hs,o,hr,hp,hn,hq){if(hn==b){hn=bu}if(hq==b){hq=1}var hu=document.createElementNS(dz,"polyline");hu.setAttribute("points",ho+","+ht+" "+hm+","+hs+" "+o+" , "+hr+" "+hm+","+hs+" "+ho+","+ht);hu.setAttribute("stroke",hp);hu.setAttribute("stroke-width",hn);hu.setAttribute("stroke-opacity",hq);hu.setAttribute("stroke-linecap","square");return hu};var aS=function(){var hm=aG=document.createElementNS(dz,"svg");try{if(!hm.style){aG=b;dv.log("ERROR: SVG Gradient not supported");return false}}catch(ho){aG=b;dv.log("ERROR: SVG Gradient not supported");return false}var hr=a.getSVGID();var hn=gs.hotspotDotRadius;hm.setAttribute("xmlns",dz);hm.setAttribute("version",fO);hm.setAttribute("baseProfile","tiny");var o=bL=hm.cloneNode(true);try{var ht=document.createElementNS(dz,"radialGradient");ht.setAttribute("id",hr);ht.setAttribute("cx","0.5");ht.setAttribute("cy","0.5");ht.setAttribute("r","0.5");var hs=document.createElementNS(dz,"stop");hs.setAttribute("stop-color",gs.hotspotDotColor1);hs.setAttribute("offset","0.5");var hq=document.createElementNS(dz,"stop");hq.setAttribute("stop-color",gs.hotspotDotColor2);hq.setAttribute("offset","1");ht.appendChild(hs);ht.appendChild(hq);o.appendChild(ht);o.style.position="absolute";o.style.width="0px";o.style.height="0px";o.style.left="0";o.style.top="0";o.style.zIndex=-500000;o.style.visibility="hidden";V.appendChild(o)}catch(ho){dv.log("ERROR: SVG Gradient not supported")}var hp=document.createElementNS(dz,"circle");hp.setAttribute("r",hn);hp.setAttribute("stroke",gs.hotspotLineColor2);hp.setAttribute("stroke-width","1px");hp.setAttribute("stroke-opacity","0.85");hp.setAttribute("fill","url(#"+hr+")");hp.setAttribute("fill-opacity","0.5");hm.appendChild(hp);return true};var a5=function(hr){var hv=hr.horizontalMarkerSize;var hz=Math.abs(hr.verticalMarkerSize);var hD;if(!aG){return{width:0,height:0,startX:0,startY:0,endX:0,endY:0,xAlign:0,yAlign:0}}var ht=hr.markerAngle*Math.PI/180;var hA,hp,hy,ho,hw,hn;var hF={};var hq=hF.radius=gs.hotspotDotRadius+1;hD=Math.max(0,Math.min(1,hr.horizontalMarkerPosition));if(hD>0.5){hv=-hv}hF.xAlign=-hD;hD=Math.max(0,Math.min(1,hr.verticalMarkerPosition));hF.yAlign=-hD;hA=0;hp=0;hy=hA+Math.sin(ht)*hz;ho=hp-Math.cos(ht)*hz;hw=hy+hv;var hB=Math.min(hA-hq,hy);var o=Math.min(hp-hq,ho);hB=Math.min(hB,hw);hA-=hB;hy-=hB;hw-=hB;hp-=o;ho-=o;hn=ho;hF.startX=-hA;hF.startY=-hp;hF.endX=hF.startX+hw;hF.endY=hF.startY+hn;var hE=Math.max(hA+hq,hy);hE=Math.max(hE,hw);var hm=Math.max(hp+hq,ho);var hu=hF.svg=aG.cloneNode(true);var hs=hF.width=hE;var hx=hF.height=hm;hu.setAttribute("width",hs);hu.setAttribute("height",hx);hu.setAttribute("viewBox","0 0 "+hs+" "+hx);hu.setAttribute("class","fsi-ui-hotspot-line");var hC=hu.firstChild;hC.setAttribute("cx",hA);hC.setAttribute("cy",hp);hA+=Math.sin(ht)*hq;hp-=Math.cos(ht)*hq;hu.appendChild(aN(hA,hp,hy,ho,hw,hn,gs.hotspotLineColor1,"5px","0.25"));hu.appendChild(aN(hA,hp,hy,ho,hw,hn,gs.hotspotLineColor2,"1px"));return hF};var bG=function(hm,o){if(hm.bVisible==o){return}hm.bVisible=o;if(o){hm._opacity=b;hm.marker.style.display=hm.tooltip.style.display="block"}else{hm.marker.style.display=hm.tooltip.style.display="none";hm._opacity=0;hm.marker.style.opacity=hm.tooltip.style.opacity=0}};var dm=function(hq){var hm=document.createElement("div");var hn="fsi-ui-hotspot";if(b3){hn+=" "+b3}if(hq.cssClass!=b&&hq.cssClass.length>0){hn+=" "+hq.cssClass}if(hq.normalClass.length>0){hq.normalClass=hn+" "+hq.normalClass}else{hq.normalClass=hn}if(hq.hoverClass.length>0){hq.hoverClass="fsi-ui-hotspot-hover "+hq.hoverClass}else{hq.hoverClass="fsi-ui-hotspot-hover"}if(hq.activeClass.length>0){hq.activeClass="fsi-ui-hotspot-active "+hq.activeClass}else{hq.activeClass="fsi-ui-hotspot-active"}hm.className=hq.normalClass;var ho="position:absolute;left:0px;top:0px;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;"+hq.cssStyle;a.setStyleAttr(hm,ho);hm.innerHTML=hq.text;if(gs.decodeHTMLEntitiesInHotSpotTexts){hm.innerHTML=hm.innerText}var hp=a5(hq);var o;if(hp&&hp.svg){o=hp.svg;o.style.position="absolute";V.appendChild(o)}else{o={style:{}}}if(hq.interactive){hm.FSIHotspot=hq;V.appendChild(hm);a.addEvent(hm,"mouseover",fg);a.addEvent(hm,"mouseout",fg)}else{hm.style.zIndex="1";V.appendChild(hm)}hq.bVisible=false;hq.tooltip=hm;hq.marker=o;hq.oSvg=hp;hm.style.display="none";o.style.display="none"};var cX=function(o){az();var hm=true;var hn=(em&&!c5);fq=o.shiftKey;switch(o.keyCode){case 37:if(hn){bP();dE=1;gV(ec+dF)}hm=false;break;case 39:if(hn){bP();dE=-1;gV(ec-dF)}hm=false;break;case 32:hm=false;break}if(!hm&&o.preventDefault){o.preventDefault()}return hm};var cj=function(o){fq=o.shiftKey;if(dv&&dv.on){if(!fq){bW(bX)}}var hm=true;var hn=(em&&!c5);switch(o.keyCode){case 37:if(hn){eG(ew,true)}hm=false;break;case 39:if(hn){eG(ew,true)}hm=false;break;case 32:ba.resetView();hm=false;break}if(!hm){o.cancelBubble=true;if(o.stopPropagation){o.stopPropagation()}if(o.preventDefault){o.preventDefault()}}return hm};this.resetView=function(o){if(o===b){o=true}az(false);eu();dn=bA;if(gs.initialview&&gs.initialViewPersistent){gT(gs.initialview,o)}else{gT("1,1,0,0,1,1",o)}dn=bA};this.spinToDegree=function(o){if(!cl){return}var hm=he(Math.round(o/360*em));ba.spinToTarget(hm)};this.spinToTarget=function(ho,hr,hp){if(!cl){return}ho=dg(ho);var hu=he(ew);var hq=ho-hu;var o=(hr!=b&&!isNaN(hr)&&hr!=aW.nCurrent);if(hq==0&&!o){ef(ho,ho,0,0);return true}var ht;if(hq!=0){dE=(hq>0)?1:-1;ht=hu;if(!gs.noSceneLoop){if(Math.abs(hq)>em/2){if(dE>0){ho-=em}else{ht-=em}dE=-dE;hq=Math.abs(ho-ht)}}}else{ht=ho}var hm=aW.nCurrent;var hs;if(o&&!gs.noSetLoop&&aW.nSceneSets>1){hs=hr-aW.nCurrent;if(Math.abs(hs)>aW.nSceneSets/2){if(hs>0){hr-=aW.nSceneSets}else{hm-=aW.nSceneSets}}}bP();if(hp==b||isNaN(hp)){hp=4;if(hq!=0){hp=Math.ceil(0.2*360/em*Math.abs(hq))}if(o){hs=Math.abs(hr-hm);var hn=Math.ceil(0.1*360/aW.nSceneSets*hs);hp=Math.max(hp,hn)}}ef(ht,ho,0,hp,hm,hr);return true};var X=function(o){if(aW.nSceneSets<2){return 0}if(gs.noSetLoop){o=Math.max(0,Math.min(aW.nSceneSets-1,o))}else{o=o%aW.nSceneSets;if(o<0){o=aW.nSceneSets+o}}return o};var dZ=function(){cO={};aW.bSetCameraPosition=false;aW.initialScene=aW.initialSceneSet=aW.nCurrent=0;aW.arCurrentSetIndex=false;bz=ad=gX.length;cM=(e.length>0)?e.length:bz;aQ(cM);aR=false};var bj=function(){if(aW.bHasMultipleSets||!aW.bDefault){aQ(aW.quantizeMax);ad=aW.quantizeMax;aW.nCurrent=b;fL(0)}else{dZ()}};var fL=function(hn){hn=X(hn);if(hn==aW.nCurrent){return}aW.nCurrent=hn;cO=aW.arSets[hn];var hm=aW.arCurrentSetIndex=aW.arSets[hn].arScenes;aR=hm;bz=aW.quantizeMaxImages;cM=bz;if(aW.nVideoSet!=b){if(aW.nVideoSet==hn){ad=bz=hm.length;cM=dC;if(f8){f8.setPreviewImageSize(cS.croppedWidth,cS.croppedHeight)}if(!fd){el("video",true)}aR=b}else{if(f8){f8.setPreviewImageSize()}ad=aW.quantizeMax;if(fd){el("image",true)}}}fc();dH();var o=ew;eJ=ew=b;if(dj){dj.spinPos=b}cb(o);g5();return hn};var fc=function(){if(!aW.bSetCameraPosition||!cO.posCamera){return}var o=cO.posCamera;dL.camera.position.set(o.x,o.y,o.z);dL.camera.lookAt(dL.targetObj.position);dL.camera.rotation.z=0};var aY=function(o){o=Math.max(0,Math.min(em-1,o));return o};var eX=function(o){o%=em;if(o<0){o=em+o}return o};var dg=function(hm,hp){if(!gS){return hm}var ho;var o=em/bz;var hn=Math.round(hm/o)*o;if(!hp||hm==hn){ho=hn}else{if(dE==1){ho=Math.round(hn+o)}else{ho=Math.round(hn-o)}}ho=he(ho);return ho};var eG=function(o,ho){var hm=(o!=b)?o:ew;var hn=dg(hm,ho);ba.spinToTarget(hn)};var ef=function(o,hp,hq,ho,hn,hm){o=Math.round(o);hp=Math.round(hp);bP();if(hm!=b&&!isNaN(hm)&&hm!=aW.nCurrent){if(hn==b){hn=aW.nCurrent}}else{hn=b}if(o!=hp||hn!=hm){if(bk(o,hp,hq,ho,hn,hm)){bY("spinToFrame")}else{gg("doSpinToFrame")}}else{gg("doSpinToFrame")}};var bP=function(){if(fw==b){return}cancelAnimationFrame(fw);fw=b;gg("cancelSpinToFrame")};var bk=function(hp,hv,hu,hq,hm,hs){var ht=hv-hp;var hr;if(ht==0){hr=hv}else{hr=aF(hu,hq,hp,ht)}var ho;if(hm!=b){var hn=hs-hm;ho=Math.round(aF(hu,hq,hm,hn))}if(hu!=hq){if(eQ){eQ.lockImageSourceDimension(bT,true);eQ.lockImage(bT,true)}var o=Math.round(hr);if(o<0){o=em+o}else{if(o==em){o=0}}fw=requestAnimationFrame(function(){if(hm!=b){fL(ho)}if(o!=ew){dH();cb(o);g5()}bk(hp,hv,++hu,hq,hm,hs)});return true}else{fw=b;if(eQ){eQ.lockImage(bT,false)}cb(he(hv));if(hs!=b){fL(hs)}b8();ce();gg("doSpinToFrame")}};var b8=function(){cb(he(ew));g5();if(i){ff()}};var gK=function(hm){var o={};o.baseURL=ge.getImageURL(gX[hm],fa);o.fullURL=o.baseURL+gN;return o};var fl=function(){if(!dj){return}ch=b;dj=b;be=b;R=true;O();d9()};var d9=function(){aK.abortPurpose("tile")};var bM=function(){if(bv==bI){return}bv=bI;var o=fn.getPixelRangeRect(bI);gN=fn.getPixelRangeParametersByCalculatedResult(o)};var aB=function(o){if(o==b){o=Math.round(ew/(em/ad))}if(isNaN(o)||o<0||o>=ad){dv.error("invalid image index in loadHDImage "+o);return}if(aW.arCurrentSetIndex){o=aW.arCurrentSetIndex[o]}o-=dC;return o};var ff=function(hy){if(i&&!fd&&gY<=1){fl();return}if(e1||ch==bI){return}ch=bI;hy=aB(hy);bM();var o=gK(hy);if(be==o.fullURL){return}if(dj&&o.fullURL==dj.src){return}cr={};cr.img=new Image();cr.nImage=hy;cr.renderScale=gY;var hm=em/bz;cr.spinPos=dg(hy*hm);cr.img.crossOrigin="anonymous";cr.img.FSI_ImageObject=cr;be=cr.src=o.fullURL;if(i){R=true;cr.bTilesFading=false;cr.bFillsViewport=false;var ht=eR.width;var hs=eR.height;var hr=bI;var hp=Math.round(hr/ht*hs);d9();cr.width=hr;cr.height=hp;var hz=fv;cr.tiles=[];var hw=0;var hu=0;var hx=hz;var hv=hz;hx=Math.min(hx,hr);hv=Math.min(hv,hp);var ho;var hn=false;while(hu<hp){ho={};ho.fnDraw=en;ho.FSI_ImageObject=cr;ho.x=hw;ho.y=hu;if(hw+hx>=hr){ho.width=hr-hw;hx=Math.min(hz,hr-hw);hn=true}ho.width=hx;ho.height=hv;var hq=fn.getPixelRangeParameters(hr,hp,hw,hu,hx,hv);ho.url=o.baseURL+hq;if(hn){hn=false;hu+=hz;hw=0;hx=hz;if(hu+hz>hp){hv=Math.min(hz,hp-hu)}}else{hw+=hz}cr.tiles.push(ho)}cr.nTiles=cr.tiles.length;cr.arVisibleTiles=new Array(cr.nTiles);cr.nVisibleTiles=0;cr.nTilesLoading=0;cr.nTilesLoaded=0;cr.nTilesRequested=0;cr.nTileColumns=Math.ceil(hr/hz);cr.nTileRows=Math.ceil(hp/hz);z=true;P(null,cr)}};var ee=function(o){o.bLoading=true;o.img=new Image();o.img.oTile=o;fV(o.img,o.url,"tile",a6)};var a6=function(){a.removeEvent(this,"load",a6);var hm=this.oTile;hm.bLoading=false;hm.bLoaded=true;var o=hm.FSI_ImageObject;if(o.nTilesLoaded===o.nTiles){o.bComplete=true;o.bFillsViewport=true}if(o.src!==be){return}hm.alpha=0;hm.fnDraw=gI;o.nTilesLoading--;o.nTilesLoaded++;P(null,o);cp(this);g5();cV(25)};var b7=function(hm,o){return o.distance-hm.distance};var gR=function(){z=false;if(!dj){return}var hs=dj;var hC,hB,hn,o;var hr;if(b2.enabled){fs.setRect(0,0,bc.width,bc.height);fs.scaleRect(1/b2.scale);fs.offsetRect(-b2.panPos.left/gY,-b2.panPos.top/gY);fs.offsetRect((bc.width-fs.width())/2,(bc.height-fs.height())/2);dJ.copyRect(a1);dJ.scaleRect(1/b2.scale);dJ.offsetRect(fs.left,fs.top);hr=dJ}else{hr=a1}ck(hr);hC=fK.left;hB=fK.top;hn=fK.right;o=fK.bottom;var hy=Math.max(0,Math.floor(hC/fv));var ho=Math.min(hs.nTileColumns-1,Math.floor(hn/fv));var hx=Math.max(0,Math.floor(hB/fv));var hm=Math.min(hs.nTileRows-1,Math.floor(o/fv));var hp=ho-hy+1;var ht=hm-hx+1;var hu=Math.max(0,ht)*hp;if(hs.nFirstTileXLastGetVisible===hy&&hs.nFirstTileYLastGetVisible===hx&&hs.nTilesLastGetVisible===hu){return}hs.nFirstTileXLastGetVisible=hy;hs.nFirstTileYLastGetVisible=hx;hs.nTilesLastGetVisible=hu;var hE=hs.tiles;var hD=hs.arVisibleTiles;var hv=hx*hs.nTileColumns;var hq=hy;var hw;var hA=hc;for(var hz=0;hz<hu;hz++){hw=hD[hz]=hE[hv+hq];if(!hA&&hw.alpha!==1){hA=true}if(++hq>ho){hq=hy;hv+=hs.nTileColumns}}hs.nVisibleTiles=hu;hs.bFilesArePreparedForLoading=false;if(hA&&!R){cs.globalAlpha=1;f1()}if(hA){R=hA}cV(50)};var O=function(){if(gv){clearTimeout(gv);gv=b}};var cV=function(o){if(gv!==b){return}if(!dj||dj.bRequestsComplete){return}gv=setTimeout(gF,o)};var gF=function(){O();D()};var D=function(){if(Q){return}var hp=dj;if(hp.nTilesLoading>=eN){return}var hs,hn,hm,ho,hr;if(!hp.bFilesArePreparedForLoading){hp.bFilesArePreparedForLoading=true;if(!hp.arTilesToLoad||hp.arTilesToLoad.length!=0){hp.arTilesToLoad=[]}hs=hp.arTilesToLoad;var hq=hp.arVisibleTiles;for(ho=0;ho<hp.nVisibleTiles;ho++){if(!hq[ho].bLoaded&&!hq[ho].bLoading){hs.push(hq[ho])}}if(hs.length>1){b2.centerX=fK.left+fK.width()/2;b2.centerY=fK.top+fK.height()/2;for(ho=0;ho<hs.length;ho++){hr=hs[ho];hn=hr.x-b2.centerX+hr.width/2;hm=hr.y-b2.centerY+hr.height/2;hr.distance=Math.abs(hn)+Math.abs(hm)}hs.sort(b7)}}var o=0;hs=hp.arTilesToLoad;while(hp.nTilesLoading<eN&&hs.length>0){hr=hs.pop();ee(hr);o++;hp.nTilesLoading++}hp.nTilesRequested+=o;if(hp.nTilesRequested==hp.nTiles){hp.bRequestsComplete=true}};var P=function(o,hm){if(hm==b){a.removeEvent(this,"load",P);hm=this.FSI_ImageObject;hm.width=this.width;hm.height=this.height}if(hm.src!=be){return}cp(this);dj=hm;if(hj){return}if(gl){g5()}};var bg=this.clickMenuButton=function(o){gM.pressMenuButton(o,b,true);gM.releaseMenuButton(o,b,true);gM.clickMenuButton(o,b,true)};this.pressMenuButton=function(o){cQ.pressButton(o)};this.releaseMenuButton=function(o){cQ.releaseButton(o)};gM.onUserAction=function(){};gM.pressMenuButton=function(hn,o,hp){if(!hp){gM.onUserAction()}if(hn!="ToggleAutoSpin"&&hn!="ToggleFullScreen"){az()}eu();bO();var hm,ho;if(hn.indexOf("_")!=-1){hm=hn.split("_");hn=hm[0];ho=hm[1]}switch(hn){case"Reset":ba.resetView();break;case"ZoomOut":case"ZoomIn":aa(hn,150,10);break;case"MouseMode":e9(parseInt(ho));break;case"MaxZoom":fC(b,b,b2.scaleToSourceImage-gY,false,30);break}};var cx=function(hm,o){if(!cQ){return false}return cQ.enableButton(hm,o)};gM.releaseMenuButton=function(hm,o,hn){if(!hn){gM.onUserAction()}bO()};gM.clickMenuButton=function(ho,o,hq){var hm,hp;if(typeof(ho)==="string"&&ho.indexOf("_")!==-1){hm=ho.split("_");ho=hm[0];hp=hm[1]}switch(ho){case"ToggleFullScreen":if(a.FullScreen.getEnabled()){a.FullScreen.quit();ds()}else{var hn=dB;if(typeof(hn)==="string"){hn=document.getElementById(hn);if(hn==b){hn=am}}dR=hn;a.FullScreen.start(hn);ds()}break;case"HotSpots":di=cQ.getButtonPressed("HotSpots");fY(di);break;case"ToggleAutoSpin":gy();break}};var ae=function(hm){if(!b2.enabled){return}var o=gY;f0(hm);b2.panPos.left*=gY/o;b2.panPos.top*=gY/o;b0(true)};var fu=function(hm){var o;if(hm==b){hm=bE.cmd;bE.nRepeatCount++}switch(hm){case"ZoomOut":o=(bE.nRepeatCount<1)?1.01:1.035;ae(b2.scale/o);break;case"ZoomIn":o=(bE.nRepeatCount<1)?1.01:1.035;ae(b2.scale*o);break}if(bE.nRepeatCount==1){if(bE.intervalTimeFirst!=bE.intervalTimeRepeat){clearInterval(bE.interval);bE.interval=setInterval(fu,bE.intervalTimeRepeat)}}};var aa=function(hn,o,hm){aM(false);bO();bE={};bE.bRunning=true;if(o==b){o=500}bE.intervalTimeFirst=o;if(hm==b){bE.intervalTimeRepeat=o}else{bE.intervalTimeRepeat=hm}bE.nRepeatCount=0;bE.cmd=hn;bE.interval=setInterval(fu,bE.intervalTimeFirst);fu(hn)};var bO=function(){if(!bE.bRunning){return}aM(true);clearInterval(bE.interval);switch(bE.cmd){case"ZoomOut":case"ZoomIn":eP();break}bE={}};var eO=function(o){if(S!=b){if(S.width!=bd.imageWidth){bB()}else{return}}if(fx>0&&e.length==fx){return}bB();aK.abortPurpose("asyncResize");S={};S.width=bd.imageWidth;S.previewImageCanvasWidthBeforeResize=o;S.uniqueInstanceID=ak;S.nTimeout=setTimeout(d4,50)};var d4=function(){if(!cl){S.nTimeout=setTimeout(d4,250);return}S.nTimeout=b;S.img=new Image();a.addEvent(S.img,"load",aj);a.addEvent(S.img,"error",aj);var hn=0;var hm=dk;S.pos=0;S.arIndex=new Array(gX.length);if(hm>=fx){S.arIndex[0]=hm;hn+=1}for(var o=fx;o<e.length;o++){if(o!=dk){S.arIndex[hn++]=o}}aj()};var aj=function(o){if(o!=b){if(!S||S.uniqueInstanceID!=ak){return}a.removeEvent(S.img,"load",aj);cp(S.img);e[S.indexCurrent]=S.img;if(S.indexCurrent==dk){ay=b;c0=b;eJ=b;bU(S.indexCurrent);g5()}S.img=new Image();a.addEvent(S.img,"load",aj)}S.indexCurrent=S.arIndex[S.pos];S.pos++;if(S.pos>gX.length){bB()}else{var hm=bI;bI=aD;bM();S.url=gK(S.indexCurrent-dC).fullURL;bI=hm;bM();S.nTimeout=setTimeout(dd,25)}};var dd=function(){fV(S.img,S.url,"asyncResize")};var bB=function(){if(S==b){return}if(S.nTimeout){clearTimeout(S.nTimeout);S.nTimeout=b}a.removeEvent(S.img,"load",aj);a.removeEvent(S.img,"error",aj);S=b};var cP=function(){ds()};var aV=function(){dv.error("ERROR entering FullScreen")};this.setFullScreenElement=function(o){if(d8){ds();a.FullScreen.quit()}dB=ge.cfg.fullscreenelement=o};var ds=function(o){var hm=a.FullScreen.getEnabled();if(hm&&eI()){return}if(hm==d8){return}if(cQ){cQ.setButtonPressed("ToggleFullScreen",hm)}cB.runPersistent("onFullScreen",[hm]);d8=hm;a.setCustomEventListenerProperty(gJ,"skiptreshold",true);if(m){ba.showAboutWindow()}if(hm==true){a.addClass(dR,"fsi-fullscreen-element")}else{a.removeClass(dR,"fsi-fullscreen-element")}if(!hm){dR=b}if(hm){cA()}else{if(fD.bRestore){f2();if(fZ.bEnabledByConfig){setTimeout(fA,0)}}}};this.getInFullScreenMode=function(){return d8};this.getSpinFrames=function(){return em};this.getImageIsTransparent=function(){return dN};this.getSrcDim=function(){return eR};if(typeof(ei)!=="object"||a.makeBool(ei.autoInit,true)){ba.init(gj,ei)}};(function(){var d="fsi-viewer";var e="display:block;width:300px;height:300px;";var g=a.customTags[d];if(g){return}var c=function(i){var h=a.attributes2parameters(i);if(h.src!==b&&h.imagesrc===b){h.imagesrc=h.src}return h};var f={};f.registerElement=function(){a.addViewerClassCSSRule(d,e);var h=Object.create(HTMLDivElement.prototype);h.createdCallback=function(){a.customTagDimFromAttributes(this);a.Viewer.prototype.constructor.call(this,this,{autoInit:false})};h.attachedCallback=function(){if(this.getInitDone()){return}if(a.FullScreen&&a.FullScreen.bChanging){return}this.init(this,c(this));this.start()};h.detachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}this.destroyOnDetach()};document.registerElement(d,{prototype:h})};f.replaceTagInit=function(h){a.addViewerClassCSSRule(d,e)};f.replaceTag=function(h){if(!h||(typeof(h.getInitDone)==="function"&&h.getInitDone())){return}a.customTagDimFromAttributes(h);a.Viewer.prototype.constructor.call(h,h,c(h));h.start()};a.registerCustomTag(d,f)}());a.dispatchEvent("FSIViewerLoaded")}(window.$FSI=window.$FSI||{}));