/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.logging;

import com.neptunelabs.fsiserver.framework.H.oooO;
import com.neptunelabs.fsiserver.framework.logging.new;
import com.neptunelabs.fsiserver.framework.ooOO.super;
import com.yworks.util.annotation.Obfuscation;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Obfuscation
public class FSILogger
extends Thread {
    private boolean running = true;
    private List<Handler> logHandler = null;
    private new log4jHandler;
    boolean encounteredErrors = false;
    String lastErrorMessage;
    String lastMessage = null;
    int lastLogCompileLevel;
    volatile int lastMessageCounter = 0;
    long maxTimeLogRepeat = 60000L;
    long lastMessageTime = 0L;
    String lastLoglevel = null;
    Object[] lastArgs = null;
    private boolean nelaDebugMode = false;
    Properties codeMessages = null;
    private final HashMap<Integer, oooO<Integer, String>> compiledMessages = new HashMap();
    private static final Pattern log4pattern = Pattern.compile("(TRACE|DEBUG|INFO|WARN|ERROR|FATAL|)[:,]?[ ]*(.+)", 2);
    private final BlockingQueue<LogContainer> logQueue = new LinkedBlockingQueue<LogContainer>(1024);

    public FSILogger(Path path, String string, String string2) {
        this.initFSILogger(null, path, string, string2, "log4j", true);
    }

    public FSILogger(Path path, String string, String string2, boolean bl) {
        this.initFSILogger(null, path, string, string2, "log4j", bl);
    }

    public FSILogger(Path path, String string, String string2, String string3) {
        this.initFSILogger(null, path, string, string2, string3, true);
    }

    public FSILogger(Path path, String string, String string2, String string3, boolean bl) {
        this.initFSILogger(null, path, string, string2, string3, bl);
    }

    public FSILogger(Handler handler, String string) {
        this.initFSILogger(handler, null, null, string, null, true);
    }

    public void addCodes(String string) {
        this.addCodes(string, true);
    }

    private void addCodes(String string, boolean bl) {
        Properties properties = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(string);){
            properties.load(inputStream);
        }
        catch (Exception exception) {
            this.logLoggerError("Logging not properly initializied - codes missing.");
        }
        if (this.codeMessages == null) {
            this.codeMessages = new Properties();
        }
        this.codeMessages.putAll((Map<?, ?>)properties);
        if (bl) {
            this.compileLogCodes(properties, string);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                LogContainer logContainer = this.logQueue.take();
                if (logContainer.type == LogType.LOG) {
                    this.logAsync(logContainer.code, logContainer.args);
                    continue;
                }
                if (logContainer.type != LogType.LOGACCESS) continue;
                this.logAccessAsync(logContainer.host, logContainer.user, logContainer.code, logContainer.args);
            }
            catch (InterruptedException interruptedException) {
                this.running = false;
            }
        }
    }

    public boolean hasNeLaDebug() {
        return this.nelaDebugMode;
    }

    private void initFSILogger(Handler handler, Path path, String string, String string2, String string3, boolean bl) {
        this.setDaemon(true);
        this.setPriority(1);
        this.setName("Logger " + string);
        boolean bl2 = false;
        if (Boolean.valueOf(System.getProperty("com.neptunelabs.devmode", "false")).booleanValue()) {
            this.nelaDebugMode = true;
        }
        if (handler != null) {
            if (this.logHandler == null) {
                this.logHandler = new ArrayList<Handler>();
            }
            this.logHandler.add(handler);
            bl2 = true;
        } else if (string != null && string2 != null) {
            this.log4jHandler = new new(this, string, path, string3);
            bl2 = true;
        }
        if (string2 != null) {
            this.addCodes(string2, bl);
        }
        if (!bl2) {
            if (path != null) {
                System.err.println("Missing log4j.xml or log4j.properties file in " + path.toAbsolutePath());
            } else {
                System.err.println("No logger config directory given");
            }
            System.err.println("Will log to system error console instead.");
        }
    }

    public void addHandler(Handler handler) {
        if (this.logHandler == null) {
            this.logHandler = new ArrayList<Handler>();
        }
        this.logHandler.add(handler);
    }

    public void logAccess(String string, String string2, int n, Object ... objectArray) {
        if (this.isAlive()) {
            LogContainer logContainer = new LogContainer();
            logContainer.type = LogType.LOGACCESS;
            logContainer.host = string;
            logContainer.user = string2;
            logContainer.code = n;
            logContainer.args = objectArray;
            try {
                this.logQueue.put(logContainer);
            }
            catch (InterruptedException interruptedException) {
                this.logAccessAsync(string, string2, n, objectArray);
            }
        } else {
            this.logAccessAsync(string, string2, n, objectArray);
        }
    }

    public void log(int n, Object ... objectArray) {
        if (this.isAlive()) {
            LogContainer logContainer = new LogContainer();
            logContainer.type = LogType.LOG;
            logContainer.code = n;
            logContainer.args = objectArray;
            try {
                this.logQueue.put(logContainer);
            }
            catch (InterruptedException interruptedException) {
                this.logAsync(n, objectArray);
            }
        } else {
            this.logAsync(n, objectArray);
        }
    }

    public void logException(Exception exception, int n, Object ... objectArray) {
        this.log(n, objectArray);
        if (exception != null && (this.log4jHandler != null && this.log4jHandler.super() || this.nelaDebugMode)) {
            System.err.println("Debug StackTrace:");
            exception.printStackTrace();
        }
    }

    public void logError(Error error, int n, Object ... objectArray) {
        this.log(n, objectArray);
        if (error != null && (this.log4jHandler != null && this.log4jHandler.super() || this.nelaDebugMode)) {
            System.err.println("Debug StackTrace:");
            error.printStackTrace();
        }
    }

    private void logAccessAsync(String string, String string2, int n, Object ... objectArray) {
        if (this.log4jHandler != null) {
            this.log4jHandler.\u00f800000(string, string2, n, objectArray);
        } else {
            this.logLoggerError("Logging with log4j not initialized");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logAsync(int n, Object ... objectArray) {
        if (this.codeMessages == null) {
            System.err.println("Logger not initialized");
            return;
        } else if (this.compiledMessages.containsKey(n)) {
            oooO<Integer, String> oooO2 = this.compiledMessages.get(n);
            Integer n2 = oooO2.\u00d500000();
            String string = oooO2.\u00d400000();
            if (this.logHandler != null) {
                for (Handler handler : this.logHandler) {
                    String string2 = String.format(string, objectArray);
                    LogRecord logRecord = new LogRecord(FSILogger.log4jIntLevel2LoggingLevel(n2), string2);
                    handler.publish(logRecord);
                }
                return;
            } else if (this.log4jHandler == null) {
                String string3 = String.format(string, objectArray);
                System.err.println(string3);
                return;
            } else {
                if (this.log4jHandler == null || !this.log4jHandler.\u00f600000(n2)) return;
                this.log4jHandler.\u00f400000(n2, string, n, objectArray);
            }
            return;
        } else {
            String string = this.codeMessages.getProperty(Integer.toString(n));
            if (string == null) {
                this.logLoggerError("Unknown log code number " + n);
                super.OO0000();
                return;
            } else {
                Matcher matcher = log4pattern.matcher(string);
                if (!matcher.find()) {
                    this.logLoggerError("Unknown log code number " + n);
                    return;
                } else {
                    String string4 = matcher.group(1);
                    String string5 = matcher.group(2);
                    try {
                        String string6 = String.format(string5, objectArray);
                        if (this.logHandler != null) {
                            for (Handler handler : this.logHandler) {
                                LogRecord logRecord = new LogRecord(FSILogger.getLoggingLevel(string4.toUpperCase()), string6);
                                handler.publish(logRecord);
                            }
                            return;
                        }
                        if (this.log4jHandler == null) {
                            System.err.println(string6);
                            return;
                        }
                        if (this.log4jHandler == null) return;
                        this.log4jHandler.\u00d800000(string6, string4, n, objectArray);
                        return;
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        this.logLoggerError(illegalFormatException.getLocalizedMessage() + " (" + n + " " + string5 + ")");
                        return;
                    }
                    catch (Exception exception) {
                        this.logLoggerError("Error while logging code " + n);
                    }
                }
            }
        }
    }

    public String getLogMessage(int n, Object ... objectArray) {
        String string = "";
        try {
            String string2 = this.codeMessages.getProperty(Integer.toString(n));
            if (string2 != null) {
                Matcher matcher = log4pattern.matcher(string2);
                if (matcher.find()) {
                    String string3 = matcher.group(2);
                    string = String.format(string3, objectArray).trim();
                }
            } else {
                this.logLoggerError("Unknown log code number " + n);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception while logging: " + exception.getLocalizedMessage());
            exception.printStackTrace();
        }
        return string;
    }

    public boolean encounteredErrors() {
        return this.encounteredErrors;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void resetErrorStatus() {
        this.encounteredErrors = false;
        this.lastErrorMessage = null;
    }

    public boolean isTraceEnabled() {
        if (this.log4jHandler != null) {
            return this.log4jHandler.super();
        }
        return false;
    }

    public boolean isDebugEnabled() {
        if (this.log4jHandler != null) {
            return this.log4jHandler.\u00d200000();
        }
        return false;
    }

    public boolean isInfoEnabled() {
        if (this.log4jHandler != null) {
            return this.log4jHandler.\u00d300000();
        }
        return false;
    }

    public void setMaxRepeatTime(int n) {
        this.maxTimeLogRepeat = n;
    }

    public void shutdown() {
        LogContainer logContainer;
        this.running = false;
        this.interrupt();
        while ((logContainer = (LogContainer)this.logQueue.poll()) != null) {
            if (logContainer.type == LogType.LOG) {
                this.logAsync(logContainer.code, logContainer.args);
                continue;
            }
            if (logContainer.type != LogType.LOGACCESS) continue;
            this.logAccessAsync(logContainer.host, logContainer.user, logContainer.code, logContainer.args);
        }
        if (this.log4jHandler != null) {
            this.log4jHandler.\u00d400000();
        }
    }

    private void logLoggerError(String string) {
        if (this.log4jHandler != null) {
            this.log4jHandler.OO0000(string);
        } else {
            System.err.println(string);
        }
    }

    private void compileLogCodes(Properties properties, String string) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                Matcher matcher = log4pattern.matcher(string3);
                if (matcher.find()) {
                    String string4 = matcher.group(1);
                    String string5 = matcher.group(2);
                    try {
                        Integer n = this.getLogLevelInt(string4.toUpperCase());
                        oooO<Integer, String> oooO2 = new oooO<Integer, String>(n, string5);
                        this.compiledMessages.put(Integer.valueOf(string2), oooO2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Invalid Log Code: " + string2 + " in " + string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("Invalid Log Level: " + string4 + " (" + string3 + " in " + string + ")");
                    }
                    continue;
                }
                System.err.println("Log Entry: " + string3 + " in " + string);
            }
        }
    }

    static boolean compareArgs(Object[] objectArray, Object[] objectArray2) {
        boolean bl;
        if (objectArray != null && objectArray2 != null) {
            if (objectArray.length == objectArray2.length) {
                bl = true;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null || objectArray2[i] == null || objectArray[i].hashCode() == objectArray2[i].hashCode()) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
        } else {
            bl = objectArray == null && objectArray2 == null;
        }
        return bl;
    }

    private static Level getLoggingLevel(String string) {
        Level level = string.equals("OFF") ? Level.OFF : (string.equals("FATAL") ? Level.SEVERE : (string.equals("ERROR") ? Level.SEVERE : (string.equals("WARN") ? Level.WARNING : (string.equals("DEBUG") ? Level.FINE : (string.equals("TRACE") ? Level.FINER : (string.equals("ALL") ? Level.ALL : Level.INFO))))));
        return level;
    }

    private static Level log4jIntLevel2LoggingLevel(int n) {
        Level level = n == Integer.MIN_VALUE ? Level.ALL : (n == Integer.MAX_VALUE ? Level.OFF : (n == 10000 ? Level.FINE : (n == 5000 ? Level.FINER : (n == 40000 ? Level.SEVERE : (n == 50000 ? Level.SEVERE : (n == 20000 ? Level.INFO : Level.WARNING))))));
        return level;
    }

    private int getLogLevelInt(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("T") || string.equalsIgnoreCase("TRACE")) {
            n = 5000;
        } else if (string.equalsIgnoreCase("D") || string.equalsIgnoreCase("DEBUG")) {
            n = 10000;
        } else if (string.equalsIgnoreCase("I") || string.equalsIgnoreCase("INFO")) {
            n = 20000;
        } else if (string.equalsIgnoreCase("W") || string.equalsIgnoreCase("WARN")) {
            n = 30000;
        } else if (string.equalsIgnoreCase("E") || string.equalsIgnoreCase("ERROR")) {
            n = 40000;
        } else if (string.equalsIgnoreCase("F") || string.equalsIgnoreCase("FATAL")) {
            n = 50000;
        }
        return n;
    }

    boolean levelIsEnabled(int n) {
        boolean bl = false;
        if (this.log4jHandler != null) {
            bl = this.log4jHandler.\u00f600000(n);
        }
        return bl;
    }

    private class LogContainer {
        LogType type;
        int code;
        String host;
        String user;
        Object[] args;

        LogContainer() {
        }
    }

    private static enum LogType {
        LOG,
        LOGACCESS;

    }
}

