/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.UnpackedImageData;

final class BinarizeOpImage
extends PointOpImage {
    private static byte[] byteTable = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static int[] bitsOn = null;
    private double threshold;

    public BinarizeOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double d) {
        super(renderedImage, BinarizeOpImage.layoutHelper(renderedImage, imageLayout, map), map, true);
        if (renderedImage.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("BinarizeOpImage0"));
        }
        this.threshold = d;
    }

    private static ImageLayout layoutHelper(RenderedImage renderedImage, ImageLayout imageLayout, Map map) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (!ImageUtil.isBinary(sampleModel)) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if ((colorModel = imageLayout2.getColorModel(null)) == null || !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.setColorModel(ImageUtil.getCompatibleColorModel(sampleModel, map));
        }
        return imageLayout2;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        switch (rasterArray[0].getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 2: {
                this.shortLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 1: {
                this.ushortLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 4: {
                this.floatLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            case 5: {
                this.doubleLoop(rasterArray[0], writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("BinarizeOpImage1"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.threshold <= 0.0) {
            this.setTo1(writableRaster, rectangle);
            return;
        }
        if (this.threshold > 255.0) {
            return;
        }
        short s = (short)Math.ceil(this.threshold);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 0, false);
        int n2 = unpackedImageData.bandOffsets[0];
        byte[] byArray = ((byte[][])unpackedImageData.data)[0];
        int n3 = unpackedImageData.pixelStride;
        int n4 = packedImageData.bitOffset;
        for (int i = 0; i < rectangle.height; ++i) {
            int n5 = n4 + rectangle.width;
            int n6 = n4;
            int n7 = n2;
            while (n6 < n5) {
                if ((byArray[n7] & 0xFF) >= s) {
                    int n8 = n + (n6 >> 3);
                    packedImageData.data[n8] = (byte)(packedImageData.data[n8] | byteTable[n6 % 8]);
                }
                ++n6;
                n7 += n3;
            }
            n += packedImageData.lineStride;
            n2 += unpackedImageData.lineStride;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.threshold <= -32768.0) {
            this.setTo1(writableRaster, rectangle);
            return;
        }
        if (this.threshold > 32767.0) {
            return;
        }
        short s = (short)Math.ceil(this.threshold);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 2, false);
        int n2 = unpackedImageData.bandOffsets[0];
        short[] sArray = ((short[][])unpackedImageData.data)[0];
        int n3 = unpackedImageData.pixelStride;
        int n4 = packedImageData.bitOffset;
        for (int i = 0; i < rectangle.height; ++i) {
            int n5 = n4 + rectangle.width;
            int n6 = n4;
            int n7 = n2;
            while (n6 < n5) {
                if (sArray[n7] >= s) {
                    int n8 = n + (n6 >> 3);
                    packedImageData.data[n8] = (byte)(packedImageData.data[n8] | byteTable[n6 % 8]);
                }
                ++n6;
                n7 += n3;
            }
            n += packedImageData.lineStride;
            n2 += unpackedImageData.lineStride;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void ushortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.threshold <= 0.0) {
            this.setTo1(writableRaster, rectangle);
            return;
        }
        if (this.threshold > 65535.0) {
            return;
        }
        int n = (int)Math.ceil(this.threshold);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n2 = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 1, false);
        int n3 = unpackedImageData.bandOffsets[0];
        short[] sArray = ((short[][])unpackedImageData.data)[0];
        int n4 = unpackedImageData.pixelStride;
        int n5 = packedImageData.bitOffset;
        for (int i = 0; i < rectangle.height; ++i) {
            int n6 = n5 + rectangle.width;
            int n7 = n5;
            int n8 = n3;
            while (n7 < n6) {
                if ((sArray[n8] & 0xFFFF) >= n) {
                    int n9 = n2 + (n7 >> 3);
                    packedImageData.data[n9] = (byte)(packedImageData.data[n9] | byteTable[n7 % 8]);
                }
                ++n7;
                n8 += n4;
            }
            n2 += packedImageData.lineStride;
            n3 += unpackedImageData.lineStride;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.threshold <= -2.147483648E9) {
            this.setTo1(writableRaster, rectangle);
            return;
        }
        if (this.threshold > 2.147483647E9) {
            return;
        }
        int n = (int)Math.ceil(this.threshold);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n2 = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 3, false);
        int n3 = unpackedImageData.bandOffsets[0];
        int[] nArray = ((int[][])unpackedImageData.data)[0];
        int n4 = unpackedImageData.pixelStride;
        int n5 = packedImageData.bitOffset;
        for (int i = 0; i < rectangle.height; ++i) {
            int n6 = n5 + rectangle.width;
            int n7 = n5;
            int n8 = n3;
            while (n7 < n6) {
                if ((double)nArray[n8] >= this.threshold) {
                    int n9 = n2 + (n7 >> 3);
                    packedImageData.data[n9] = (byte)(packedImageData.data[n9] | byteTable[n7 % 8]);
                }
                ++n7;
                n8 += n4;
            }
            n2 += packedImageData.lineStride;
            n3 += unpackedImageData.lineStride;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void floatLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 4, false);
        int n2 = unpackedImageData.bandOffsets[0];
        float[] fArray = ((float[][])unpackedImageData.data)[0];
        int n3 = unpackedImageData.pixelStride;
        int n4 = packedImageData.bitOffset;
        for (int i = 0; i < rectangle.height; ++i) {
            int n5 = n4 + rectangle.width;
            int n6 = n4;
            int n7 = n2;
            while (n6 < n5) {
                if ((double)fArray[n7] > this.threshold) {
                    int n8 = n + (n6 >> 3);
                    packedImageData.data[n8] = (byte)(packedImageData.data[n8] | byteTable[n6 % 8]);
                }
                ++n6;
                n7 += n3;
            }
            n += packedImageData.lineStride;
            n2 += unpackedImageData.lineStride;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void doubleLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(writableRaster, rectangle, true, false);
        int n = packedImageData.offset;
        PixelAccessor pixelAccessor2 = new PixelAccessor(raster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor2.getPixels(raster, rectangle2, 5, false);
        int n2 = unpackedImageData.bandOffsets[0];
        double[] dArray = ((double[][])unpackedImageData.data)[0];
        int n3 = unpackedImageData.pixelStride;
        int n4 = packedImageData.bitOffset;
        for (int i = 0; i < rectangle.height; ++i) {
            int n5 = n4 + rectangle.width;
            int n6 = n4;
            int n7 = n2;
            while (n6 < n5) {
                if (dArray[n7] > this.threshold) {
                    int n8 = n + (n6 >> 3);
                    packedImageData.data[n8] = (byte)(packedImageData.data[n8] | byteTable[n6 % 8]);
                }
                ++n6;
                n7 += n3;
            }
            n += packedImageData.lineStride;
            n2 += unpackedImageData.lineStride;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private void setTo1(Raster raster, Rectangle rectangle) {
        BinarizeOpImage.initBitsOn();
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, rectangle, true, false);
        int n = packedImageData.offset;
        for (int i = 0; i < rectangle.height; ++i) {
            int n2 = packedImageData.bitOffset;
            int n3 = n2 + rectangle.width - 1;
            if (n3 < 8) {
                packedImageData.data[n] = (byte)(packedImageData.data[n] | bitsOn[n3]);
            } else {
                int n4;
                packedImageData.data[n] = (byte)(packedImageData.data[n] | bitsOn[7]);
                for (n4 = n + 1; n4 <= n + (n3 - 7) / 8; ++n4) {
                    packedImageData.data[n4] = -1;
                }
                n4 = n3 % 8;
                if (n4 % 8 != 7) {
                    n3 = n + n3 / 8;
                    packedImageData.data[n3] = (byte)(packedImageData.data[n3] | bitsOn[n4]);
                }
            }
            n += packedImageData.lineStride;
        }
        pixelAccessor.setPackedPixels(packedImageData);
    }

    private static synchronized void initBitsOn() {
        if (bitsOn != null) {
            return;
        }
        bitsOn = new int[64];
        for (int i = 0; i < 8; ++i) {
            for (int j = i; j < 8; ++j) {
                int n = 255 >> i;
                int n2 = 255 << 7 - j;
                BinarizeOpImage.bitsOn[j + (i << 3)] = n & n2;
            }
        }
    }
}

