/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;
import javax.media.jai.UnpackedImageData;

public class ExtremaOpImage
extends StatisticsOpImage {
    protected double[][] extrema = null;
    protected ArrayList[] minLocations;
    protected ArrayList[] maxLocations;
    protected int[] minCounts;
    protected int[] maxCounts;
    protected boolean saveLocations;
    protected int maxRuns;
    protected int numMinLocations = 0;
    protected int numMaxLocations = 0;
    private boolean isInitialized = false;
    private PixelAccessor srcPA;
    private int srcSampleType;

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }

    public ExtremaOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4, boolean bl, int n5) {
        super(renderedImage, rOI, n, n2, n3, n4);
        this.saveLocations = bl;
        this.maxRuns = n5;
    }

    public Object getProperty(String string) {
        int n = this.sampleModel.getNumBands();
        if (this.extrema == null) {
            return super.getProperty(string);
        }
        if (string.equalsIgnoreCase("extrema")) {
            double[][] dArray = new double[2][n];
            for (int i = 0; i < n; ++i) {
                dArray[0][i] = this.extrema[0][i];
                dArray[1][i] = this.extrema[1][i];
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("minimum")) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.extrema[0][i];
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("maximum")) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.extrema[1][i];
            }
            return dArray;
        }
        if (this.saveLocations && string.equalsIgnoreCase("minLocations")) {
            return this.minLocations;
        }
        if (this.saveLocations && string.equalsIgnoreCase("maxLocations")) {
            return this.maxLocations;
        }
        return Image.UndefinedProperty;
    }

    protected String[] getStatisticsNames() {
        return new String[]{"extrema", "maximum", "minimum", "maxLocations", "minLocations"};
    }

    protected Object createStatistics(String string) {
        int n = this.sampleModel.getNumBands();
        Object object = null;
        object = string.equalsIgnoreCase("extrema") ? new double[2][n] : (string.equalsIgnoreCase("minimum") || string.equalsIgnoreCase("maximum") ? (Object)new double[n] : (this.saveLocations && (string.equalsIgnoreCase("minLocations") || string.equalsIgnoreCase("maxLocations")) ? (Object)new ArrayList[n] : (Object)Image.UndefinedProperty));
        return object;
    }

    private final int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        return n4 == 0 ? n : n + (n3 - n4);
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        block19: {
            int n;
            ArrayList[] arrayListArray;
            block22: {
                block21: {
                    block20: {
                        block18: {
                            LinkedList linkedList;
                            if (!this.isInitialized) {
                                this.srcPA = new PixelAccessor(this.getSourceImage(0));
                                this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
                                this.isInitialized = true;
                            }
                            Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
                            if (this.roi == null) {
                                linkedList = new LinkedList();
                                linkedList.addLast(rectangle);
                            } else {
                                linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                                if (linkedList == null) {
                                    return;
                                }
                            }
                            ListIterator listIterator = linkedList.listIterator(0);
                            while (listIterator.hasNext()) {
                                arrayListArray = rectangle.intersection((Rectangle)listIterator.next());
                                n = arrayListArray.x;
                                int n2 = arrayListArray.y;
                                arrayListArray.x = this.startPosition(n, this.xStart, this.xPeriod);
                                arrayListArray.y = this.startPosition(n2, this.yStart, this.yPeriod);
                                arrayListArray.width = n + arrayListArray.width - arrayListArray.x;
                                arrayListArray.height = n2 + arrayListArray.height - arrayListArray.y;
                                if (arrayListArray.isEmpty()) continue;
                                this.initializeState(raster);
                                UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, (Rectangle)arrayListArray, this.srcSampleType, false);
                                switch (unpackedImageData.type) {
                                    case 0: {
                                        this.accumulateStatisticsByte(unpackedImageData);
                                        break;
                                    }
                                    case 1: {
                                        this.accumulateStatisticsUShort(unpackedImageData);
                                        break;
                                    }
                                    case 2: {
                                        this.accumulateStatisticsShort(unpackedImageData);
                                        break;
                                    }
                                    case 3: {
                                        this.accumulateStatisticsInt(unpackedImageData);
                                        break;
                                    }
                                    case 4: {
                                        this.accumulateStatisticsFloat(unpackedImageData);
                                        break;
                                    }
                                    case 5: {
                                        this.accumulateStatisticsDouble(unpackedImageData);
                                    }
                                }
                            }
                            if (!string.equalsIgnoreCase("extrema")) break block18;
                            arrayListArray = (ArrayList[])((double[][])object);
                            for (n = 0; n < this.srcPA.numBands; ++n) {
                                arrayListArray[0][n] = this.extrema[0][n];
                                arrayListArray[1][n] = (ArrayList)this.extrema[1][n];
                            }
                            break block19;
                        }
                        if (!string.equalsIgnoreCase("minimum")) break block20;
                        arrayListArray = (ArrayList[])((double[])object);
                        for (n = 0; n < this.srcPA.numBands; ++n) {
                            arrayListArray[n] = (ArrayList)this.extrema[0][n];
                        }
                        break block19;
                    }
                    if (!string.equalsIgnoreCase("maximum")) break block21;
                    arrayListArray = (ArrayList[])((double[])object);
                    for (n = 0; n < this.srcPA.numBands; ++n) {
                        arrayListArray[n] = (ArrayList)this.extrema[1][n];
                    }
                    break block19;
                }
                if (!string.equalsIgnoreCase("minLocations")) break block22;
                arrayListArray = (ArrayList[])object;
                for (n = 0; n < this.srcPA.numBands; ++n) {
                    arrayListArray[n] = this.minLocations[n];
                }
                break block19;
            }
            if (!string.equalsIgnoreCase("maxLocations")) break block19;
            arrayListArray = (ArrayList[])object;
            for (n = 0; n < this.srcPA.numBands; ++n) {
                arrayListArray[n] = this.maxLocations[n];
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                int n5 = (int)this.extrema[0][i];
                int n6 = (int)this.extrema[1][i];
                byte[] byArray2 = byArray[i];
                int n7 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                for (int j = unpackedImageData.bandOffsets[i]; j < n7; j += n3) {
                    int n8 = j + rectangle.width * n2;
                    for (int k = j; k < n8; k += n4) {
                        int n9 = byArray2[k] & 0xFF;
                        if (n9 < n5) {
                            n5 = n9;
                            continue;
                        }
                        if (n9 <= n6) continue;
                        n6 = n9;
                    }
                }
                this.extrema[0][i] = n5;
                this.extrema[1][i] = n6;
            }
        } else {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                int n10 = (int)this.extrema[0][i];
                int n11 = (int)this.extrema[1][i];
                ArrayList arrayList = this.minLocations[i];
                ArrayList arrayList2 = this.maxLocations[i];
                int n12 = this.minCounts[i];
                int n13 = this.maxCounts[i];
                byte[] byArray3 = byArray[i];
                int n14 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                int n15 = unpackedImageData.bandOffsets[i];
                int n16 = rectangle.y;
                while (n15 < n14) {
                    int n17 = n15 + rectangle.width * n2;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = n15;
                    int n23 = rectangle.x;
                    while (n22 < n17) {
                        int n24 = byArray3[n22] & 0xFF;
                        if (n24 < n10) {
                            n10 = n24;
                            n18 = n23;
                            n20 = 1;
                            arrayList.clear();
                            n12 = 0;
                        } else if (n24 > n11) {
                            n11 = n24;
                            n19 = n23;
                            n21 = 1;
                            arrayList2.clear();
                            n13 = 0;
                        } else {
                            if (n24 == n10) {
                                if (n20 == 0) {
                                    n18 = n23;
                                }
                                ++n20;
                            } else if (n20 > 0 && n12 < this.maxRuns) {
                                arrayList.add(new int[]{n18, n16, n20});
                                ++n12;
                                n20 = 0;
                            }
                            if (n24 == n11) {
                                if (n21 == 0) {
                                    n19 = n23;
                                }
                                ++n21;
                            } else if (n21 > 0 && n13 < this.maxRuns) {
                                arrayList2.add(new int[]{n19, n16, n21});
                                ++n13;
                                n21 = 0;
                            }
                        }
                        n22 += n4;
                        n23 += this.xPeriod;
                    }
                    if (n21 > 0 && n13 < this.maxRuns) {
                        arrayList2.add(new int[]{n19, n16, n21});
                        ++n13;
                    }
                    if (n20 > 0 && n12 < this.maxRuns) {
                        arrayList.add(new int[]{n18, n16, n20});
                        ++n12;
                    }
                    n15 += n3;
                    n16 += this.yPeriod;
                }
                this.extrema[0][i] = n10;
                this.extrema[1][i] = n11;
                this.minCounts[i] = n12;
                this.maxCounts[i] = n13;
            }
        }
    }

    private void accumulateStatisticsUShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                int n5 = (int)this.extrema[0][i];
                int n6 = (int)this.extrema[1][i];
                short[] sArray2 = sArray[i];
                int n7 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                for (int j = unpackedImageData.bandOffsets[i]; j < n7; j += n3) {
                    int n8 = j + rectangle.width * n2;
                    for (int k = j; k < n8; k += n4) {
                        int n9 = sArray2[k] & 0xFFFF;
                        if (n9 < n5) {
                            n5 = n9;
                            continue;
                        }
                        if (n9 <= n6) continue;
                        n6 = n9;
                    }
                }
                this.extrema[0][i] = n5;
                this.extrema[1][i] = n6;
            }
        } else {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                int n10 = (int)this.extrema[0][i];
                int n11 = (int)this.extrema[1][i];
                ArrayList arrayList = this.minLocations[i];
                ArrayList arrayList2 = this.maxLocations[i];
                int n12 = this.minCounts[i];
                int n13 = this.maxCounts[i];
                short[] sArray3 = sArray[i];
                int n14 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                int n15 = unpackedImageData.bandOffsets[i];
                int n16 = rectangle.y;
                while (n15 < n14) {
                    int n17 = n15 + rectangle.width * n2;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = n15;
                    int n23 = rectangle.x;
                    while (n22 < n17) {
                        int n24 = sArray3[n22] & 0xFFFF;
                        if (n24 < n10) {
                            n10 = n24;
                            n18 = n23;
                            n20 = 1;
                            arrayList.clear();
                            n12 = 0;
                        } else if (n24 > n11) {
                            n11 = n24;
                            n19 = n23;
                            n21 = 1;
                            arrayList2.clear();
                            n13 = 0;
                        } else {
                            if (n24 == n10) {
                                if (n20 == 0) {
                                    n18 = n23;
                                }
                                ++n20;
                            } else if (n20 > 0 && n12 < this.maxRuns) {
                                arrayList.add(new int[]{n18, n16, n20});
                                ++n12;
                                n20 = 0;
                            }
                            if (n24 == n11) {
                                if (n21 == 0) {
                                    n19 = n23;
                                }
                                ++n21;
                            } else if (n21 > 0 && n13 < this.maxRuns) {
                                arrayList2.add(new int[]{n19, n16, n21});
                                ++n13;
                                n21 = 0;
                            }
                        }
                        n22 += n4;
                        n23 += this.xPeriod;
                    }
                    if (n21 > 0 && n13 < this.maxRuns) {
                        arrayList2.add(new int[]{n19, n16, n21});
                        ++n13;
                    }
                    if (n20 > 0 && n12 < this.maxRuns) {
                        arrayList.add(new int[]{n18, n16, n20});
                        ++n12;
                    }
                    n15 += n3;
                    n16 += this.yPeriod;
                }
                this.extrema[0][i] = n10;
                this.extrema[1][i] = n11;
                this.minCounts[i] = n12;
                this.maxCounts[i] = n13;
            }
        }
    }

    private void accumulateStatisticsShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                int n5 = (int)this.extrema[0][i];
                int n6 = (int)this.extrema[1][i];
                short[] sArray2 = sArray[i];
                int n7 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                for (int j = unpackedImageData.bandOffsets[i]; j < n7; j += n3) {
                    int n8 = j + rectangle.width * n2;
                    for (int k = j; k < n8; k += n4) {
                        int n9 = sArray2[k];
                        if (n9 < n5) {
                            n5 = n9;
                            continue;
                        }
                        if (n9 <= n6) continue;
                        n6 = n9;
                    }
                }
                this.extrema[0][i] = n5;
                this.extrema[1][i] = n6;
            }
        } else {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                int n10 = (int)this.extrema[0][i];
                int n11 = (int)this.extrema[1][i];
                ArrayList arrayList = this.minLocations[i];
                ArrayList arrayList2 = this.maxLocations[i];
                int n12 = this.minCounts[i];
                int n13 = this.maxCounts[i];
                short[] sArray3 = sArray[i];
                int n14 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                int n15 = unpackedImageData.bandOffsets[i];
                int n16 = rectangle.y;
                while (n15 < n14) {
                    int n17 = n15 + rectangle.width * n2;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = n15;
                    int n23 = rectangle.x;
                    while (n22 < n17) {
                        int n24 = sArray3[n22];
                        if (n24 < n10) {
                            n10 = n24;
                            n18 = n23;
                            n20 = 1;
                            arrayList.clear();
                            n12 = 0;
                        } else if (n24 > n11) {
                            n11 = n24;
                            n19 = n23;
                            n21 = 1;
                            arrayList2.clear();
                            n13 = 0;
                        } else {
                            if (n24 == n10) {
                                if (n20 == 0) {
                                    n18 = n23;
                                }
                                ++n20;
                            } else if (n20 > 0 && n12 < this.maxRuns) {
                                arrayList.add(new int[]{n18, n16, n20});
                                ++n12;
                                n20 = 0;
                            }
                            if (n24 == n11) {
                                if (n21 == 0) {
                                    n19 = n23;
                                }
                                ++n21;
                            } else if (n21 > 0 && n13 < this.maxRuns) {
                                arrayList2.add(new int[]{n19, n16, n21});
                                ++n13;
                                n21 = 0;
                            }
                        }
                        n22 += n4;
                        n23 += this.xPeriod;
                    }
                    if (n21 > 0 && n13 < this.maxRuns) {
                        arrayList2.add(new int[]{n19, n16, n21});
                        ++n13;
                    }
                    if (n20 > 0 && n12 < this.maxRuns) {
                        arrayList.add(new int[]{n18, n16, n20});
                        ++n12;
                    }
                    n15 += n3;
                    n16 += this.yPeriod;
                }
                this.extrema[0][i] = n10;
                this.extrema[1][i] = n11;
                this.minCounts[i] = n12;
                this.maxCounts[i] = n13;
            }
        }
    }

    private void accumulateStatisticsInt(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        int[][] nArray = unpackedImageData.getIntData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                int n5 = (int)this.extrema[0][i];
                int n6 = (int)this.extrema[1][i];
                int[] nArray2 = nArray[i];
                int n7 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                for (int j = unpackedImageData.bandOffsets[i]; j < n7; j += n3) {
                    int n8 = j + rectangle.width * n2;
                    for (int k = j; k < n8; k += n4) {
                        int n9 = nArray2[k];
                        if (n9 < n5) {
                            n5 = n9;
                            continue;
                        }
                        if (n9 <= n6) continue;
                        n6 = n9;
                    }
                }
                this.extrema[0][i] = n5;
                this.extrema[1][i] = n6;
            }
        } else {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                int n10 = (int)this.extrema[0][i];
                int n11 = (int)this.extrema[1][i];
                ArrayList arrayList = this.minLocations[i];
                ArrayList arrayList2 = this.maxLocations[i];
                int n12 = this.minCounts[i];
                int n13 = this.maxCounts[i];
                int[] nArray3 = nArray[i];
                int n14 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                int n15 = unpackedImageData.bandOffsets[i];
                int n16 = rectangle.y;
                while (n15 < n14) {
                    int n17 = n15 + rectangle.width * n2;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = n15;
                    int n23 = rectangle.x;
                    while (n22 < n17) {
                        int n24 = nArray3[n22];
                        if (n24 < n10) {
                            n10 = n24;
                            n18 = n23;
                            n20 = 1;
                            arrayList.clear();
                            n12 = 0;
                        } else if (n24 > n11) {
                            n11 = n24;
                            n19 = n23;
                            n21 = 1;
                            arrayList2.clear();
                            n13 = 0;
                        } else {
                            if (n24 == n10) {
                                if (n20 == 0) {
                                    n18 = n23;
                                }
                                ++n20;
                            } else if (n20 > 0 && n12 < this.maxRuns) {
                                arrayList.add(new int[]{n18, n16, n20});
                                ++n12;
                                n20 = 0;
                            }
                            if (n24 == n11) {
                                if (n21 == 0) {
                                    n19 = n23;
                                }
                                ++n21;
                            } else if (n21 > 0 && n13 < this.maxRuns) {
                                arrayList2.add(new int[]{n19, n16, n21});
                                ++n13;
                                n21 = 0;
                            }
                        }
                        n22 += n4;
                        n23 += this.xPeriod;
                    }
                    if (n21 > 0 && n13 < this.maxRuns) {
                        arrayList2.add(new int[]{n19, n16, n21});
                        ++n13;
                    }
                    if (n20 > 0 && n12 < this.maxRuns) {
                        arrayList.add(new int[]{n18, n16, n20});
                        ++n12;
                    }
                    n15 += n3;
                    n16 += this.yPeriod;
                }
                this.extrema[0][i] = n10;
                this.extrema[1][i] = n11;
                this.minCounts[i] = n12;
                this.maxCounts[i] = n13;
            }
        }
    }

    private void accumulateStatisticsFloat(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        float[][] fArray = unpackedImageData.getFloatData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                float f = (float)this.extrema[0][i];
                float f2 = (float)this.extrema[1][i];
                float[] fArray2 = fArray[i];
                int n5 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                for (int j = unpackedImageData.bandOffsets[i]; j < n5; j += n3) {
                    int n6 = j + rectangle.width * n2;
                    for (int k = j; k < n6; k += n4) {
                        float f3 = fArray2[k];
                        if (f3 < f) {
                            f = f3;
                            continue;
                        }
                        if (!(f3 > f2)) continue;
                        f2 = f3;
                    }
                }
                this.extrema[0][i] = f;
                this.extrema[1][i] = f2;
            }
        } else {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                float f = (float)this.extrema[0][i];
                float f4 = (float)this.extrema[1][i];
                ArrayList arrayList = this.minLocations[i];
                ArrayList arrayList2 = this.maxLocations[i];
                int n7 = this.minCounts[i];
                int n8 = this.maxCounts[i];
                float[] fArray3 = fArray[i];
                int n9 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                int n10 = unpackedImageData.bandOffsets[i];
                int n11 = rectangle.y;
                while (n10 < n9) {
                    int n12 = n10 + rectangle.width * n2;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = n10;
                    int n18 = rectangle.x;
                    while (n17 < n12) {
                        float f5 = fArray3[n17];
                        if (f5 < f) {
                            f = f5;
                            n13 = n18;
                            n15 = 1;
                            arrayList.clear();
                            n7 = 0;
                        } else if (f5 > f4) {
                            f4 = f5;
                            n14 = n18;
                            n16 = 1;
                            arrayList2.clear();
                            n8 = 0;
                        } else {
                            if (f5 == f) {
                                if (n15 == 0) {
                                    n13 = n18;
                                }
                                ++n15;
                            } else if (n15 > 0 && n7 < this.maxRuns) {
                                arrayList.add(new int[]{n13, n11, n15});
                                ++n7;
                                n15 = 0;
                            }
                            if (f5 == f4) {
                                if (n16 == 0) {
                                    n14 = n18;
                                }
                                ++n16;
                            } else if (n16 > 0 && n8 < this.maxRuns) {
                                arrayList2.add(new int[]{n14, n11, n16});
                                ++n8;
                                n16 = 0;
                            }
                        }
                        n17 += n4;
                        n18 += this.xPeriod;
                    }
                    if (n16 > 0 && n8 < this.maxRuns) {
                        arrayList2.add(new int[]{n14, n11, n16});
                        ++n8;
                    }
                    if (n15 > 0 && n7 < this.maxRuns) {
                        arrayList.add(new int[]{n13, n11, n15});
                        ++n7;
                    }
                    n10 += n3;
                    n11 += this.yPeriod;
                }
                this.extrema[0][i] = f;
                this.extrema[1][i] = f4;
                this.minCounts[i] = n7;
                this.maxCounts[i] = n8;
            }
        }
    }

    private void accumulateStatisticsDouble(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        double[][] dArray = unpackedImageData.getDoubleData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                double d = this.extrema[0][i];
                double d2 = this.extrema[1][i];
                double[] dArray2 = dArray[i];
                int n5 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                for (int j = unpackedImageData.bandOffsets[i]; j < n5; j += n3) {
                    int n6 = j + rectangle.width * n2;
                    for (int k = j; k < n6; k += n4) {
                        double d3 = dArray2[k];
                        if (d3 < d) {
                            d = d3;
                            continue;
                        }
                        if (!(d3 > d2)) continue;
                        d2 = d3;
                    }
                }
                this.extrema[0][i] = d;
                this.extrema[1][i] = d2;
            }
        } else {
            for (int i = 0; i < this.srcPA.numBands; ++i) {
                double d = this.extrema[0][i];
                double d4 = this.extrema[1][i];
                ArrayList arrayList = this.minLocations[i];
                ArrayList arrayList2 = this.maxLocations[i];
                int n7 = this.minCounts[i];
                int n8 = this.maxCounts[i];
                double[] dArray3 = dArray[i];
                int n9 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
                int n10 = unpackedImageData.bandOffsets[i];
                int n11 = rectangle.y;
                while (n10 < n9) {
                    int n12 = n10 + rectangle.width * n2;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = n10;
                    int n18 = rectangle.x;
                    while (n17 < n12) {
                        double d5 = dArray3[n17];
                        if (d5 < d) {
                            d = d5;
                            n13 = n18;
                            n15 = 1;
                            arrayList.clear();
                            n7 = 0;
                        } else if (d5 > d4) {
                            d4 = d5;
                            n14 = n18;
                            n16 = 1;
                            arrayList2.clear();
                            n8 = 0;
                        } else {
                            if (d5 == d) {
                                if (n15 == 0) {
                                    n13 = n18;
                                }
                                ++n15;
                            } else if (n15 > 0 && n7 < this.maxRuns) {
                                arrayList.add(new int[]{n13, n11, n15});
                                ++n7;
                                n15 = 0;
                            }
                            if (d5 == d4) {
                                if (n16 == 0) {
                                    n14 = n18;
                                }
                                ++n16;
                            } else if (n16 > 0 && n8 < this.maxRuns) {
                                arrayList2.add(new int[]{n14, n11, n16});
                                ++n8;
                                n16 = 0;
                            }
                        }
                        n17 += n4;
                        n18 += this.xPeriod;
                    }
                    if (n16 > 0 && n8 < this.maxRuns) {
                        arrayList2.add(new int[]{n14, n11, n16});
                        ++n8;
                    }
                    if (n15 > 0 && n7 < this.maxRuns) {
                        arrayList.add(new int[]{n13, n11, n15});
                        ++n7;
                    }
                    n10 += n3;
                    n11 += this.yPeriod;
                }
                this.extrema[0][i] = d;
                this.extrema[1][i] = d4;
                this.minCounts[i] = n7;
                this.maxCounts[i] = n8;
            }
        }
    }

    protected void initializeState(Raster raster) {
        if (this.extrema == null) {
            int n;
            int n2 = this.sampleModel.getNumBands();
            this.extrema = new double[2][n2];
            Rectangle rectangle = raster.getBounds();
            if (this.roi != null) {
                LinkedList linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (linkedList == null) {
                    return;
                }
                ListIterator listIterator = linkedList.listIterator(0);
                if (listIterator.hasNext()) {
                    rectangle = rectangle.intersection((Rectangle)listIterator.next());
                }
            }
            rectangle.x = this.startPosition(rectangle.x, this.xStart, this.xPeriod);
            rectangle.y = this.startPosition(rectangle.y, this.yStart, this.yPeriod);
            raster.getPixel(rectangle.x, rectangle.y, this.extrema[0]);
            for (n = 0; n < n2; ++n) {
                this.extrema[1][n] = this.extrema[0][n];
            }
            if (this.saveLocations) {
                this.minLocations = new ArrayList[n2];
                this.maxLocations = new ArrayList[n2];
                this.minCounts = new int[n2];
                this.maxCounts = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this.minLocations[n] = new ArrayList();
                    this.maxLocations[n] = new ArrayList();
                    this.maxCounts[n] = 0;
                    this.minCounts[n] = 0;
                }
            }
        }
    }
}

