/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpBilinearOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, borderExtender, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        byte[] byArray2 = new byte[n8];
        for (n = 0; n < n8; ++n) {
            byArray2[n] = (byte)this.backgroundValues[n];
        }
        if (this.ctable == null) {
            for (n = 0; n < n7; ++n) {
                int n12 = n11;
                n11 += n9;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
                int n13 = 0;
                for (int i = 0; i < n6; ++i) {
                    int n14;
                    float f = fArray[n13++];
                    float f2 = fArray[n13++];
                    int n15 = WarpBilinearOpImage.floor(f);
                    int n16 = WarpBilinearOpImage.floor(f2);
                    float f3 = f - (float)n15;
                    float f4 = f2 - (float)n16;
                    if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                        if (this.setBackground) {
                            for (n14 = 0; n14 < n8; ++n14) {
                                byArray[n14][n12 + nArray[n14]] = byArray2[n14];
                            }
                        }
                    } else {
                        for (n14 = 0; n14 < n8; ++n14) {
                            int n17 = randomIter.getSample(n15, n16, n14) & 0xFF;
                            int n18 = randomIter.getSample(n15 + 1, n16, n14) & 0xFF;
                            int n19 = randomIter.getSample(n15, n16 + 1, n14) & 0xFF;
                            int n20 = randomIter.getSample(n15 + 1, n16 + 1, n14) & 0xFF;
                            float f5 = (float)(n18 - n17) * f3 + (float)n17;
                            float f6 = (float)(n20 - n19) * f3 + (float)n19;
                            float f7 = (f6 - f5) * f4 + f5;
                            byArray[n14][n12 + nArray[n14]] = (byte)f7;
                        }
                    }
                    n12 += n10;
                }
            }
        } else {
            for (n = 0; n < n7; ++n) {
                int n21 = n11;
                n11 += n9;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
                int n22 = 0;
                for (int i = 0; i < n6; ++i) {
                    int n23;
                    float f = fArray[n22++];
                    float f8 = fArray[n22++];
                    int n24 = WarpBilinearOpImage.floor(f);
                    int n25 = WarpBilinearOpImage.floor(f8);
                    float f9 = f - (float)n24;
                    float f10 = f8 - (float)n25;
                    if (n24 < n2 || n24 >= n3 || n25 < n4 || n25 >= n5) {
                        if (this.setBackground) {
                            for (n23 = 0; n23 < n8; ++n23) {
                                byArray[n23][n21 + nArray[n23]] = byArray2[n23];
                            }
                        }
                    } else {
                        for (n23 = 0; n23 < n8; ++n23) {
                            byte[] byArray3 = this.ctable[n23];
                            int n26 = byArray3[randomIter.getSample(n24, n25, 0) & 0xFF] & 0xFF;
                            int n27 = byArray3[randomIter.getSample(n24 + 1, n25, 0) & 0xFF] & 0xFF;
                            int n28 = byArray3[randomIter.getSample(n24, n25 + 1, 0) & 0xFF] & 0xFF;
                            int n29 = byArray3[randomIter.getSample(n24 + 1, n25 + 1, 0) & 0xFF] & 0xFF;
                            float f11 = (float)(n27 - n26) * f9 + (float)n26;
                            float f12 = (float)(n29 - n28) * f9 + (float)n28;
                            float f13 = (f12 - f11) * f10 + f11;
                            byArray[n23][n21 + nArray[n23]] = (byte)f13;
                        }
                    }
                    n21 += n10;
                }
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        short[] sArray2 = new short[n8];
        for (n = 0; n < n8; ++n) {
            sArray2[n] = (short)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                float f = fArray[n13++];
                float f2 = fArray[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            sArray[n14][n12 + nArray[n14]] = sArray2[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        int n17 = randomIter.getSample(n15, n16, n14) & 0xFFFF;
                        int n18 = randomIter.getSample(n15 + 1, n16, n14) & 0xFFFF;
                        int n19 = randomIter.getSample(n15, n16 + 1, n14) & 0xFFFF;
                        int n20 = randomIter.getSample(n15 + 1, n16 + 1, n14) & 0xFFFF;
                        float f5 = (float)(n18 - n17) * f3 + (float)n17;
                        float f6 = (float)(n20 - n19) * f3 + (float)n19;
                        float f7 = (f6 - f5) * f4 + f5;
                        sArray[n14][n12 + nArray[n14]] = (short)f7;
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        short[] sArray2 = new short[n8];
        for (n = 0; n < n8; ++n) {
            sArray2[n] = (short)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                float f = fArray[n13++];
                float f2 = fArray[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            sArray[n14][n12 + nArray[n14]] = sArray2[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        int n17 = randomIter.getSample(n15, n16, n14);
                        int n18 = randomIter.getSample(n15 + 1, n16, n14);
                        int n19 = randomIter.getSample(n15, n16 + 1, n14);
                        int n20 = randomIter.getSample(n15 + 1, n16 + 1, n14);
                        float f5 = (float)(n18 - n17) * f3 + (float)n17;
                        float f6 = (float)(n20 - n19) * f3 + (float)n19;
                        float f7 = (f6 - f5) * f4 + f5;
                        sArray[n14][n12 + nArray[n14]] = (short)f7;
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        int[] nArray3 = new int[n8];
        for (n = 0; n < n8; ++n) {
            nArray3[n] = (int)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                float f = fArray[n13++];
                float f2 = fArray[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            nArray2[n14][n12 + nArray[n14]] = nArray3[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        int n17 = randomIter.getSample(n15, n16, n14);
                        int n18 = randomIter.getSample(n15 + 1, n16, n14);
                        int n19 = randomIter.getSample(n15, n16 + 1, n14);
                        int n20 = randomIter.getSample(n15 + 1, n16 + 1, n14);
                        float f5 = (float)(n18 - n17) * f3 + (float)n17;
                        float f6 = (float)(n20 - n19) * f3 + (float)n19;
                        float f7 = (f6 - f5) * f4 + f5;
                        nArray2[n14][n12 + nArray[n14]] = (int)f7;
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        int n;
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n6];
        int n11 = 0;
        float[] fArray3 = new float[n8];
        for (n = 0; n < n8; ++n) {
            fArray3[n] = (float)this.backgroundValues[n];
        }
        for (n = 0; n < n7; ++n) {
            int n12 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n, n6, 1, fArray2);
            int n13 = 0;
            for (int i = 0; i < n6; ++i) {
                int n14;
                float f = fArray2[n13++];
                float f2 = fArray2[n13++];
                int n15 = WarpBilinearOpImage.floor(f);
                int n16 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n15;
                float f4 = f2 - (float)n16;
                if (n15 < n2 || n15 >= n3 || n16 < n4 || n16 >= n5) {
                    if (this.setBackground) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            fArray[n14][n12 + nArray[n14]] = fArray3[n14];
                        }
                    }
                } else {
                    for (n14 = 0; n14 < n8; ++n14) {
                        float f5;
                        float f6 = randomIter.getSampleFloat(n15, n16, n14);
                        float f7 = randomIter.getSampleFloat(n15 + 1, n16, n14);
                        float f8 = randomIter.getSampleFloat(n15, n16 + 1, n14);
                        float f9 = randomIter.getSampleFloat(n15 + 1, n16 + 1, n14);
                        float f10 = (f7 - f6) * f3 + f6;
                        float f11 = (f9 - f8) * f3 + f8;
                        fArray[n14][n12 + nArray[n14]] = f5 = (f11 - f10) * f4 + f10;
                    }
                }
                n12 += n10;
            }
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        if (this.extender != null) {
            Rectangle rectangle = new Rectangle(planarImage.getMinX(), planarImage.getMinY(), planarImage.getWidth() + 1, planarImage.getHeight() + 1);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX() - (this.extender != null ? 0 : 1);
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY() - (this.extender != null ? 0 : 1);
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        for (int i = 0; i < n6; ++i) {
            int n11 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + i, n5, 1, fArray);
            int n12 = 0;
            for (int j = 0; j < n5; ++j) {
                int n13;
                float f = fArray[n12++];
                float f2 = fArray[n12++];
                int n14 = WarpBilinearOpImage.floor(f);
                int n15 = WarpBilinearOpImage.floor(f2);
                float f3 = f - (float)n14;
                float f4 = f2 - (float)n15;
                if (n14 < n || n14 >= n2 || n15 < n3 || n15 >= n4) {
                    if (this.setBackground) {
                        for (n13 = 0; n13 < n7; ++n13) {
                            dArray[n13][n11 + nArray[n13]] = this.backgroundValues[n13];
                        }
                    }
                } else {
                    for (n13 = 0; n13 < n7; ++n13) {
                        double d;
                        double d2 = randomIter.getSampleDouble(n14, n15, n13);
                        double d3 = randomIter.getSampleDouble(n14 + 1, n15, n13);
                        double d4 = randomIter.getSampleDouble(n14, n15 + 1, n13);
                        double d5 = randomIter.getSampleDouble(n14 + 1, n15 + 1, n13);
                        double d6 = (d3 - d2) * (double)f3 + d2;
                        double d7 = (d5 - d4) * (double)f3 + d4;
                        dArray[n13][n11 + nArray[n13]] = d = (d7 - d6) * (double)f4 + d6;
                    }
                }
                n11 += n9;
            }
        }
    }

    private static final int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }
}

