/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PartialOrderNode;

class OperationGraph
implements Serializable {
    Vector operations = new Vector();
    Vector orderedOperations;
    boolean isChanged = true;
    private boolean lookupByName = false;

    OperationGraph() {
    }

    OperationGraph(boolean bl) {
        this.lookupByName = bl;
    }

    private boolean compare(PartialOrderNode partialOrderNode, Object object) {
        if (this.lookupByName) {
            return partialOrderNode.getName().equalsIgnoreCase((String)object);
        }
        return partialOrderNode.getData() == object;
    }

    void addOp(PartialOrderNode partialOrderNode) {
        this.operations.addElement(partialOrderNode);
        this.isChanged = true;
    }

    synchronized boolean removeOp(Object object) {
        boolean bl = false;
        PartialOrderNode partialOrderNode = this.lookupOp(object);
        if (partialOrderNode != null && (bl = this.operations.removeElement(partialOrderNode))) {
            this.isChanged = true;
        }
        return bl;
    }

    PartialOrderNode lookupOp(Object object) {
        int n = this.operations.size();
        for (int i = 0; i < n; ++i) {
            PartialOrderNode partialOrderNode = (PartialOrderNode)this.operations.elementAt(i);
            if (!this.compare(partialOrderNode, object)) continue;
            PartialOrderNode partialOrderNode2 = partialOrderNode;
            return partialOrderNode2;
        }
        return null;
    }

    synchronized boolean setPreference(Object object, Object object2) {
        boolean bl = false;
        if (object == null || object2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (object == object2) {
            return bl;
        }
        PartialOrderNode partialOrderNode = this.lookupOp(object);
        PartialOrderNode partialOrderNode2 = this.lookupOp(object2);
        if (partialOrderNode != null && partialOrderNode2 != null) {
            partialOrderNode.addEdge(partialOrderNode2);
            bl = true;
            this.isChanged = true;
        }
        return bl;
    }

    synchronized boolean unsetPreference(Object object, Object object2) {
        boolean bl = false;
        if (object == null || object2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (object == object2) {
            return bl;
        }
        PartialOrderNode partialOrderNode = this.lookupOp(object);
        PartialOrderNode partialOrderNode2 = this.lookupOp(object2);
        if (partialOrderNode != null && partialOrderNode2 != null) {
            partialOrderNode.removeEdge(partialOrderNode2);
            bl = true;
            this.isChanged = true;
        }
        return bl;
    }

    public synchronized Vector getOrderedOperationList() {
        Vector vector;
        int n;
        PartialOrderNode partialOrderNode;
        if (!this.isChanged) {
            Vector vector2 = this.orderedOperations;
            return vector2;
        }
        int n2 = this.operations.size();
        for (int i = 0; i < n2; ++i) {
            partialOrderNode = (PartialOrderNode)this.operations.elementAt(i);
            partialOrderNode.setCopyInDegree(partialOrderNode.getInDegree());
        }
        this.orderedOperations = new Vector(n2);
        this.isChanged = false;
        PartialOrderNode partialOrderNode2 = null;
        for (n = 0; n < n2; ++n) {
            partialOrderNode = (PartialOrderNode)this.operations.elementAt(n);
            if (partialOrderNode.getCopyInDegree() != 0) continue;
            partialOrderNode.setZeroLink(partialOrderNode2);
            partialOrderNode2 = partialOrderNode;
        }
        for (n = 0; n < n2; ++n) {
            if (partialOrderNode2 == null) {
                this.orderedOperations = null;
                return null;
            }
            vector = partialOrderNode2;
            this.orderedOperations.addElement(vector);
            partialOrderNode2 = partialOrderNode2.getZeroLink();
            Enumeration enumeration = ((PartialOrderNode)((Object)vector)).getNeighbors();
            while (enumeration.hasMoreElements()) {
                partialOrderNode = (PartialOrderNode)enumeration.nextElement();
                partialOrderNode.decrementCopyInDegree();
                if (partialOrderNode.getCopyInDegree() != 0) continue;
                partialOrderNode.setZeroLink(partialOrderNode2);
                partialOrderNode2 = partialOrderNode;
            }
        }
        vector = this.orderedOperations;
        return vector;
    }
}

