/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Point;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Observable;
import javax.media.jai.JaiI18N;
import javax.media.jai.TileFactory;
import javax.media.jai.TileRecycler;

public class RecyclingTileFactory
extends Observable
implements TileFactory,
TileRecycler {
    private static final boolean DEBUG = false;
    private HashMap recycledArrays = new HashMap(32);
    private long memoryUsed = 0L;

    private static long getBufferSizeCSM(ComponentSampleModel componentSampleModel) {
        int n;
        int n2;
        int[] nArray = componentSampleModel.getBandOffsets();
        int n3 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n3 = Math.max(n3, nArray[i]);
        }
        long l = 0L;
        if (n3 >= 0) {
            l += (long)(n3 + 1);
        }
        if ((n2 = componentSampleModel.getPixelStride()) > 0) {
            l += (long)(n2 * (componentSampleModel.getWidth() - 1));
        }
        if ((n = componentSampleModel.getScanlineStride()) > 0) {
            l += (long)(n * (componentSampleModel.getHeight() - 1));
        }
        return l;
    }

    private static long getNumBanksCSM(ComponentSampleModel componentSampleModel) {
        int[] nArray = componentSampleModel.getBankIndices();
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    private static SoftReference getBankReference(DataBuffer dataBuffer) {
        Object object = null;
        switch (dataBuffer.getDataType()) {
            case 0: {
                object = ((DataBufferByte)dataBuffer).getBankData();
                break;
            }
            case 1: {
                object = ((DataBufferUShort)dataBuffer).getBankData();
                break;
            }
            case 2: {
                object = ((DataBufferShort)dataBuffer).getBankData();
                break;
            }
            case 3: {
                object = ((DataBufferInt)dataBuffer).getBankData();
                break;
            }
            case 4: {
                object = DataBufferUtils.getBankDataFloat(dataBuffer);
                break;
            }
            case 5: {
                object = DataBufferUtils.getBankDataDouble(dataBuffer);
                break;
            }
            default: {
                throw new UnsupportedOperationException(JaiI18N.getString("Generic3"));
            }
        }
        return new SoftReference<float[][]>((float[][])object);
    }

    private static long getDataBankSize(int n, int n2, int n3) {
        int n4 = 0;
        switch (n) {
            case 0: {
                n4 = 1;
                break;
            }
            case 1: 
            case 2: {
                n4 = 2;
                break;
            }
            case 3: 
            case 4: {
                n4 = 4;
                break;
            }
            case 5: {
                n4 = 8;
                break;
            }
            default: {
                throw new UnsupportedOperationException(JaiI18N.getString("Generic3"));
            }
        }
        return n2 * n3 * n4;
    }

    public boolean canReclaimMemory() {
        return true;
    }

    public boolean isMemoryCache() {
        return true;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        HashMap hashMap = this.recycledArrays;
        synchronized (hashMap) {
            this.recycledArrays.clear();
            this.memoryUsed = 0L;
        }
    }

    public WritableRaster createTile(SampleModel sampleModel, Point point) {
        Object object;
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        DataBuffer dataBuffer = null;
        int n = sampleModel.getTransferType();
        long l = 0L;
        long l2 = 0L;
        if (sampleModel instanceof ComponentSampleModel) {
            object = (ComponentSampleModel)sampleModel;
            l = RecyclingTileFactory.getNumBanksCSM((ComponentSampleModel)object);
            l2 = RecyclingTileFactory.getBufferSizeCSM((ComponentSampleModel)object);
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            object = (MultiPixelPackedSampleModel)sampleModel;
            l = 1L;
            int n2 = DataBuffer.getDataTypeSize(n);
            l2 = ((MultiPixelPackedSampleModel)object).getScanlineStride() * ((SampleModel)object).getHeight() + (((MultiPixelPackedSampleModel)object).getDataBitOffset() + n2 - 1) / n2;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            object = (SinglePixelPackedSampleModel)sampleModel;
            l = 1L;
            l2 = ((SinglePixelPackedSampleModel)object).getScanlineStride() * (((SampleModel)object).getHeight() - 1) + ((SampleModel)object).getWidth();
        }
        if (l2 != 0L && (object = this.getRecycledArray(n, l, l2)) != null) {
            switch (n) {
                case 0: {
                    byte[][] byArray = (byte[][])object;
                    int n3 = 0;
                    while ((long)n3 < l) {
                        Arrays.fill(byArray[n3], (byte)0);
                        ++n3;
                    }
                    dataBuffer = new DataBufferByte(byArray, (int)l2);
                    break;
                }
                case 1: {
                    short[][] sArray = (short[][])object;
                    int n4 = 0;
                    while ((long)n4 < l) {
                        Arrays.fill(sArray[n4], (short)0);
                        ++n4;
                    }
                    dataBuffer = new DataBufferUShort(sArray, (int)l2);
                    break;
                }
                case 2: {
                    short[][] sArray = (short[][])object;
                    int n5 = 0;
                    while ((long)n5 < l) {
                        Arrays.fill(sArray[n5], (short)0);
                        ++n5;
                    }
                    dataBuffer = new DataBufferShort(sArray, (int)l2);
                    break;
                }
                case 3: {
                    int[][] nArray = (int[][])object;
                    int n6 = 0;
                    while ((long)n6 < l) {
                        Arrays.fill(nArray[n6], 0);
                        ++n6;
                    }
                    dataBuffer = new DataBufferInt(nArray, (int)l2);
                    break;
                }
                case 4: {
                    float[][] fArray = (float[][])object;
                    int n7 = 0;
                    while ((long)n7 < l) {
                        Arrays.fill(fArray[n7], 0.0f);
                        ++n7;
                    }
                    dataBuffer = DataBufferUtils.createDataBufferFloat(fArray, (int)l2);
                    break;
                }
                case 5: {
                    double[][] dArray = (double[][])object;
                    int n8 = 0;
                    while ((long)n8 < l) {
                        Arrays.fill(dArray[n8], 0.0);
                        ++n8;
                    }
                    dataBuffer = DataBufferUtils.createDataBufferDouble(dArray, (int)l2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
                }
            }
        }
        if (dataBuffer == null) {
            dataBuffer = sampleModel.createDataBuffer();
        }
        return Raster.createWritableRaster(sampleModel, dataBuffer, point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleTile(Raster raster) {
        DataBuffer dataBuffer = raster.getDataBuffer();
        Long l = new Long((long)dataBuffer.getDataType() << 56 | (long)dataBuffer.getNumBanks() << 32 | (long)dataBuffer.getSize());
        HashMap hashMap = this.recycledArrays;
        synchronized (hashMap) {
            Object v = this.recycledArrays.get(l);
            ArrayList<SoftReference> arrayList = null;
            arrayList = v != null ? (ArrayList<SoftReference>)v : new ArrayList<SoftReference>();
            this.memoryUsed += RecyclingTileFactory.getDataBankSize(dataBuffer.getDataType(), dataBuffer.getNumBanks(), dataBuffer.getSize());
            arrayList.add(RecyclingTileFactory.getBankReference(dataBuffer));
            if (v == null) {
                this.recycledArrays.put(l, arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRecycledArray(int n, long l, long l2) {
        Long l3 = new Long((long)n << 56 | l << 32 | l2);
        HashMap hashMap = this.recycledArrays;
        synchronized (hashMap) {
            Object v = this.recycledArrays.get(l3);
            if (v != null) {
                ArrayList arrayList = (ArrayList)v;
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    Object t;
                    SoftReference softReference = (SoftReference)arrayList.remove(i);
                    this.memoryUsed -= RecyclingTileFactory.getDataBankSize(n, (int)l, (int)l2);
                    if (i == 0) {
                        this.recycledArrays.remove(l3);
                    }
                    if ((t = softReference.get()) == null) continue;
                    return t;
                }
            }
        }
        return null;
    }
}

