/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.PropertyUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationNodeSupport;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryMode;
import javax.media.jai.RenderedOp;
import javax.media.jai.WritablePropertySource;
import javax.media.jai.WritablePropertySourceImpl;
import javax.media.jai.registry.CRIFRegistry;
import javax.media.jai.util.CaselessStringKey;

public class RenderableOp
implements RenderableImage,
OperationNode,
WritablePropertySource,
Serializable {
    protected PropertyChangeSupportJAI eventManager = null;
    protected WritablePropertySourceImpl properties = null;
    protected OperationNodeSupport nodeSupport;
    protected transient PropertySource thePropertySource;
    protected transient ContextualRenderedImageFactory crif = null;

    public RenderableOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        parameterBlock = parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone();
        if (renderingHints != null) {
            renderingHints = (RenderingHints)renderingHints.clone();
        }
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
        this.nodeSupport = new OperationNodeSupport(this.getRegistryModeName(), string, operationRegistry, parameterBlock, renderingHints, this.eventManager);
    }

    public RenderableOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock) {
        this(operationRegistry, string, parameterBlock, null);
    }

    public RenderableOp(String string, ParameterBlock parameterBlock) {
        this(null, string, parameterBlock);
    }

    public String getRegistryModeName() {
        return RegistryMode.getMode("renderable").getName();
    }

    public synchronized OperationRegistry getRegistry() {
        return this.nodeSupport.getRegistry();
    }

    public synchronized void setRegistry(OperationRegistry operationRegistry) {
        this.nodeSupport.setRegistry(operationRegistry);
    }

    public String getOperationName() {
        return this.nodeSupport.getOperationName();
    }

    public synchronized void setOperationName(String string) {
        this.nodeSupport.setOperationName(string);
    }

    public ParameterBlock getParameterBlock() {
        return (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
    }

    public synchronized void setParameterBlock(ParameterBlock parameterBlock) {
        this.nodeSupport.setParameterBlock(parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone());
    }

    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        return renderingHints == null ? null : (RenderingHints)renderingHints.clone();
    }

    public synchronized void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints != null) {
            renderingHints = (RenderingHints)renderingHints.clone();
        }
        this.nodeSupport.setRenderingHints(renderingHints);
    }

    private Vector getRenderableSources() {
        Vector<Object> vector = null;
        int n = this.nodeSupport.getParameterBlock().getNumSources();
        if (n > 0) {
            vector = new Vector<Object>();
            for (int i = 0; i < n; ++i) {
                Object object = this.nodeSupport.getParameterBlock().getSource(i);
                if (!(object instanceof RenderableImage)) continue;
                vector.add(object);
            }
        }
        return vector;
    }

    public Vector getSources() {
        return this.getRenderableSources();
    }

    private synchronized ContextualRenderedImageFactory findCRIF() {
        if (this.crif == null) {
            this.crif = CRIFRegistry.get(this.getRegistry(), this.getOperationName());
        }
        if (this.crif == null) {
            throw new RuntimeException(JaiI18N.getString("RenderableOp2"));
        }
        return this.crif;
    }

    public float getWidth() {
        this.findCRIF();
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters(this.nodeSupport.getParameterBlock());
        Rectangle2D rectangle2D = this.crif.getBounds2D(parameterBlock);
        return (float)rectangle2D.getWidth();
    }

    public float getHeight() {
        this.findCRIF();
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters(this.nodeSupport.getParameterBlock());
        Rectangle2D rectangle2D = this.crif.getBounds2D(parameterBlock);
        return (float)rectangle2D.getHeight();
    }

    public float getMinX() {
        this.findCRIF();
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters(this.nodeSupport.getParameterBlock());
        Rectangle2D rectangle2D = this.crif.getBounds2D(parameterBlock);
        return (float)rectangle2D.getX();
    }

    public float getMinY() {
        this.findCRIF();
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters(this.nodeSupport.getParameterBlock());
        Rectangle2D rectangle2D = this.crif.getBounds2D(parameterBlock);
        return (float)rectangle2D.getY();
    }

    public RenderedImage createDefaultRendering() {
        Dimension dimension = null;
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints != null && renderingHints.containsKey(JAI.KEY_DEFAULT_RENDERING_SIZE)) {
            dimension = (Dimension)renderingHints.get(JAI.KEY_DEFAULT_RENDERING_SIZE);
        }
        if (dimension == null || dimension.width <= 0 && dimension.height <= 0) {
            dimension = JAI.getDefaultRenderingSize();
        }
        double d = 1.0;
        double d2 = 1.0;
        if (dimension != null && (dimension.width > 0 || dimension.height > 0)) {
            if (dimension.width > 0 && dimension.height > 0) {
                d = (float)dimension.width / this.getWidth();
                d2 = (float)dimension.height / this.getHeight();
            } else {
                d = dimension.width > 0 ? (d2 = (double)((float)dimension.width / this.getWidth())) : (d2 = (double)((float)dimension.height / this.getHeight()));
            }
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        return this.createRendering(new RenderContext(affineTransform));
    }

    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderableOp3"));
        }
        if (n == 0) {
            n = Math.round((float)n2 * (this.getWidth() / this.getHeight()));
        } else if (n2 == 0) {
            n2 = Math.round((float)n * (this.getHeight() / this.getWidth()));
        }
        double d = (double)n / (double)this.getWidth();
        double d2 = (double)n2 / (double)this.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        RenderContext renderContext = new RenderContext(affineTransform, renderingHints);
        return this.createRendering(renderContext);
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        this.findCRIF();
        ParameterBlock parameterBlock = this.nodeSupport.getParameterBlock();
        Vector vector = ImageUtil.evaluateParameters(parameterBlock.getParameters());
        ParameterBlock parameterBlock2 = new ParameterBlock((Vector)parameterBlock.getSources().clone(), vector);
        Vector vector2 = this.getRenderableSources();
        try {
            String[] stringArray;
            Object object;
            Object object2;
            Object object3;
            String[] stringArray2;
            RenderContext renderContext2 = renderContext;
            RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
            if (renderingHints != null && (stringArray2 = JAI.mergeRenderingHints(renderingHints, (RenderingHints)(object3 = renderContext.getRenderingHints()))) != object3) {
                renderContext2 = new RenderContext(renderContext.getTransform(), renderContext.getAreaOfInterest(), (RenderingHints)stringArray2);
            }
            if (vector2 != null) {
                object3 = new Vector();
                for (int i = 0; i < vector2.size(); ++i) {
                    object2 = this.crif.mapRenderContext(i, renderContext2, parameterBlock2, this);
                    object = (RenderableImage)vector2.elementAt(i);
                    stringArray = object.createRendering((RenderContext)object2);
                    if (stringArray == null) {
                        return null;
                    }
                    ((Vector)object3).addElement(stringArray);
                }
                if (((Vector)object3).size() > 0) {
                    parameterBlock2.setSources((Vector<Object>)object3);
                }
            }
            if ((object3 = this.crif.create(renderContext2, parameterBlock2)) instanceof RenderedOp) {
                object3 = ((RenderedOp)object3).getRendering();
            }
            if (object3 != null && object3 instanceof WritablePropertySource && (stringArray2 = this.getPropertyNames()) != null) {
                int n;
                object2 = (WritablePropertySource)object3;
                object = null;
                stringArray = object2.getPropertyNames();
                if (stringArray != null) {
                    object = new HashSet();
                    for (n = 0; n < stringArray.length; ++n) {
                        ((HashSet)object).add(new CaselessStringKey(stringArray[n]));
                    }
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    Object object4;
                    String string = stringArray2[n];
                    if (object != null && ((HashSet)object).contains(new CaselessStringKey(string)) || (object4 = this.getProperty(string)) == null || object4 == Image.UndefinedProperty) continue;
                    object2.setProperty(string, object4);
                }
            }
            return object3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public boolean isDynamic() {
        return false;
    }

    private synchronized void createPropertySource() {
        if (this.thePropertySource == null) {
            this.thePropertySource = this.nodeSupport.getPropertySource(this, null);
            this.properties.addProperties(this.thePropertySource);
        }
    }

    public String[] getPropertyNames() {
        this.createPropertySource();
        return this.properties.getPropertyNames();
    }

    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    public Class getPropertyClass(String string) {
        this.createPropertySource();
        return this.properties.getPropertyClass(string);
    }

    public Object getProperty(String string) {
        this.createPropertySource();
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.createPropertySource();
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.createPropertySource();
        this.properties.removeProperty(string);
    }

    public synchronized Object getDynamicProperty(String string) {
        this.createPropertySource();
        return this.thePropertySource.getProperty(string);
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.nodeSupport.addPropertyGenerator(propertyGenerator);
    }

    public synchronized void copyPropertyFromSource(String string, int n) {
        this.nodeSupport.copyPropertyFromSource(string, n);
    }

    public void suppressProperty(String string) {
        this.nodeSupport.suppressProperty(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string, propertyChangeListener);
    }

    public Object getSource(int n) {
        Vector<Object> vector = this.nodeSupport.getParameterBlock().getSources();
        return vector.elementAt(n);
    }

    public void setSource(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.setSource(object, n);
        this.nodeSupport.setParameterBlock(parameterBlock);
    }

    public void removeSources() {
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.removeSources();
        this.nodeSupport.setParameterBlock(parameterBlock);
    }

    public byte getByteParameter(int n) {
        return this.nodeSupport.getParameterBlock().getByteParameter(n);
    }

    public char getCharParameter(int n) {
        return this.nodeSupport.getParameterBlock().getCharParameter(n);
    }

    public short getShortParameter(int n) {
        return this.nodeSupport.getParameterBlock().getShortParameter(n);
    }

    public int getIntParameter(int n) {
        return this.nodeSupport.getParameterBlock().getIntParameter(n);
    }

    public long getLongParameter(int n) {
        return this.nodeSupport.getParameterBlock().getLongParameter(n);
    }

    public float getFloatParameter(int n) {
        return this.nodeSupport.getParameterBlock().getFloatParameter(n);
    }

    public double getDoubleParameter(int n) {
        return this.nodeSupport.getParameterBlock().getDoubleParameter(n);
    }

    public Object getObjectParameter(int n) {
        return this.nodeSupport.getParameterBlock().getObjectParameter(n);
    }

    public void setParameter(byte by, int n) {
        this.setParameter(new Byte(by), n);
    }

    public void setParameter(char c, int n) {
        this.setParameter(new Character(c), n);
    }

    public void setParameter(short s, int n) {
        this.setParameter(new Short(s), n);
    }

    public void setParameter(int n, int n2) {
        this.setParameter(new Integer(n), n2);
    }

    public void setParameter(long l, int n) {
        this.setParameter(new Long(l), n);
    }

    public void setParameter(float f, int n) {
        this.setParameter(new Float(f), n);
    }

    public void setParameter(double d, int n) {
        this.setParameter(new Double(d), n);
    }

    public void setParameter(Object object, int n) {
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.set(object, n);
        this.nodeSupport.setParameterBlock(parameterBlock);
    }
}

