/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.logging;

import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.MissingFormatArgumentException;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class new {
    private Logger \u00d200000 = null;
    private final FSILogger o00000;
    private Level Object = null;

    new(FSILogger fSILogger, String string, Path path, String string2) {
        this.o00000 = fSILogger;
        boolean bl = false;
        if (path != null && string2 != null) {
            Path path2;
            Path path3 = path.resolve(string2 + ".xml");
            if (Files.isReadable(path3) && Files.isRegularFile(path3, new LinkOption[0])) {
                try {
                    DOMConfigurator.configure((String)path3.toAbsolutePath().toString());
                    bl = true;
                }
                catch (Exception | FactoryConfigurationError throwable) {
                    System.err.println("Logging not properly initializied - could not read " + path3);
                }
            }
            if (!bl && Files.isReadable(path2 = path.resolve(string2 + ".properties")) && Files.isRegularFile(path2, new LinkOption[0])) {
                try {
                    PropertyConfigurator.configure((String)path2.toAbsolutePath().toString());
                    bl = true;
                }
                catch (AccessControlException accessControlException) {
                    System.err.println("Logging not properly initializied - could not read " + path2.toAbsolutePath().toString());
                }
            }
            this.\u00d200000 = Logger.getLogger((String)string);
            this.Object = this.\u00d200000.getEffectiveLevel();
        }
    }

    boolean super() {
        return this.\u00d200000.isTraceEnabled();
    }

    boolean \u00d200000() {
        return this.\u00d200000.isDebugEnabled();
    }

    boolean \u00d300000() {
        return this.\u00d200000.isInfoEnabled();
    }

    boolean \u00f600000(int n) {
        if (this.Object != null) {
            return Level.toLevel((int)n).isGreaterOrEqual((Priority)this.Object);
        }
        return false;
    }

    void \u00f400000(int n, String string, int n2, Object ... objectArray) {
        if (n == this.o00000.lastLogCompileLevel && string.equals(this.o00000.lastMessage) && FSILogger.compareArgs(objectArray, this.o00000.lastArgs) && System.currentTimeMillis() - this.o00000.lastMessageTime < this.o00000.maxTimeLogRepeat) {
            ++this.o00000.lastMessageCounter;
            this.o00000.lastMessageTime = System.currentTimeMillis();
        } else {
            if (this.o00000.lastMessageCounter > 1) {
                this.\u00d200000.log((Priority)Level.toLevel((int)this.o00000.lastLogCompileLevel), (Object)("Last message repeated " + (this.o00000.lastMessageCounter - 1) + " times."));
            }
            boolean bl = false;
            try {
                String string2 = String.format(string, objectArray);
                if (string2 != null) {
                    if (n == 5000 && this.\u00d200000.isTraceEnabled()) {
                        MDC.put((String)"code", (Object)n2);
                        this.\u00d200000.trace((Object)string2);
                        bl = true;
                    } else if (n == 10000 && this.\u00d200000.isDebugEnabled()) {
                        MDC.put((String)"code", (Object)n2);
                        this.\u00d200000.debug((Object)string2);
                        bl = true;
                    } else if (n == 20000 && this.\u00d200000.isInfoEnabled()) {
                        MDC.put((String)"code", (Object)n2);
                        this.\u00d200000.info((Object)string2);
                        bl = true;
                    } else if (n == 30000 && this.\u00d200000.isEnabledFor((Priority)Level.WARN)) {
                        MDC.put((String)"code", (Object)n2);
                        this.\u00d200000.warn((Object)string2);
                        bl = true;
                    } else if (n == 40000 && this.\u00d200000.isEnabledFor((Priority)Level.ERROR)) {
                        MDC.put((String)"code", (Object)n2);
                        this.\u00d200000.error((Object)string2);
                        this.o00000.encounteredErrors = true;
                        this.o00000.lastErrorMessage = string2;
                        bl = true;
                    } else if (n == 50000 && this.\u00d200000.isEnabledFor((Priority)Level.FATAL)) {
                        MDC.put((String)"code", (Object)n2);
                        this.\u00d200000.fatal((Object)string2);
                        this.o00000.encounteredErrors = true;
                        this.o00000.lastErrorMessage = string2;
                        bl = true;
                    }
                } else {
                    System.err.println("Wrong Message: " + string);
                }
            }
            catch (MissingFormatArgumentException missingFormatArgumentException) {
                System.err.println("Error formatting message for log code: " + n2 + ": " + missingFormatArgumentException.getMessage());
            }
            if (bl) {
                this.o00000.lastMessageCounter = 1;
                this.o00000.lastMessage = string;
                this.o00000.lastMessageTime = System.currentTimeMillis();
                this.o00000.lastLogCompileLevel = n;
                this.o00000.lastArgs = objectArray;
            }
        }
    }

    void \u00d800000(String string, String string2, int n, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
        if (string.equals(this.o00000.lastMessage)) {
            ++this.o00000.lastMessageCounter;
        } else {
            Object object;
            if (this.o00000.lastMessageCounter > 1) {
                object = this.class(this.o00000.lastLoglevel);
                ((Method)object).invoke((Object)this.\u00d200000, "Last message repeated " + (this.o00000.lastMessageCounter - 1) + " times.");
            }
            this.o00000.lastMessageCounter = 1;
            this.o00000.lastMessage = string;
            this.o00000.lastLoglevel = object = this.\u00d600000(string2);
            Method method = this.class((String)object);
            MDC.put((String)"code", (Object)n);
            method.invoke((Object)this.\u00d200000, string);
            if (((String)object).equals("error") || ((String)object).equals("fatal")) {
                this.o00000.encounteredErrors = true;
                this.o00000.lastErrorMessage = string;
            }
        }
    }

    void \u00f800000(String string, String string2, int n, Object ... objectArray) {
        Method method = this.class("info");
        MDC.put((String)"code", (Object)n);
        if (string != null) {
            MDC.put((String)"ip", (Object)string);
        } else {
            MDC.put((String)"ip", (Object)"-");
        }
        if (string2 != null) {
            MDC.put((String)"user", (Object)string2);
        } else {
            MDC.put((String)"user", (Object)"-");
        }
        String string3 = this.o00000.codeMessages.getProperty(Integer.toString(n));
        if (string3 == null) {
            string3 = "Unknown logging code " + n;
        }
        String string4 = String.format(string3, objectArray).trim();
        try {
            method.invoke((Object)this.\u00d200000, string4);
        }
        catch (Exception exception) {
            this.do("Error while logging code " + string4 + (exception.getLocalizedMessage() != null ? " " + exception.getLocalizedMessage() : "(" + this.\u00d200000 + ")"));
        }
    }

    private Method class(String string) {
        Method method = null;
        if (string != null) {
            try {
                method = this.\u00d200000.getClass().getMethod(string, new Object().getClass());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    private void do(String string) {
        if (this.\u00d200000 != null) {
            this.\u00d200000.error((Object)string);
        } else {
            System.err.println(string);
        }
    }

    void int(Object object) {
        this.\u00d200000.warn(object);
    }

    void OO0000(Object object) {
        this.\u00d200000.error(object);
    }

    void \u00d400000() {
        Appender appender;
        Enumeration enumeration = this.\u00d200000.getAllAppenders();
        if (enumeration.hasMoreElements() && !((appender = (Appender)enumeration.nextElement()) instanceof ConsoleAppender)) {
            appender.close();
        }
        MDC.clear();
    }

    private String \u00d600000(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("T") || string.equalsIgnoreCase("TRACE")) {
            string2 = "trace";
        } else if (string.equalsIgnoreCase("D") || string.equalsIgnoreCase("DEBUG")) {
            string2 = "debug";
        } else if (string.equalsIgnoreCase("I") || string.equalsIgnoreCase("INFO")) {
            string2 = "info";
        } else if (string.equalsIgnoreCase("W") || string.equalsIgnoreCase("WARN")) {
            string2 = "warn";
        } else if (string.equalsIgnoreCase("E") || string.equalsIgnoreCase("ERROR")) {
            string2 = "error";
        } else if (string.equalsIgnoreCase("F") || string.equalsIgnoreCase("FATAL")) {
            string2 = "fatal";
        }
        if (string2 == null) {
            this.do("Invalid log-level for following message - using ERROR level");
            string2 = "error";
        }
        return string2;
    }
}

