/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFTag;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TIFFTagSet {
    private SortedMap<Integer, TIFFTag> allowedTagsByNumber = new TreeMap<Integer, TIFFTag>();
    private SortedMap<String, TIFFTag> allowedTagsByName = new TreeMap<String, TIFFTag>();

    private TIFFTagSet() {
    }

    public TIFFTagSet(List<TIFFTag> list) {
        if (list == null) {
            throw new IllegalArgumentException("tags == null!");
        }
        for (TIFFTag tIFFTag : list) {
            if (!(tIFFTag instanceof TIFFTag)) {
                throw new IllegalArgumentException("tags contains a non-TIFFTag!");
            }
            TIFFTag tIFFTag2 = tIFFTag;
            this.allowedTagsByNumber.put(new Integer(tIFFTag2.getNumber()), tIFFTag2);
            this.allowedTagsByName.put(tIFFTag2.getName(), tIFFTag2);
        }
    }

    public TIFFTag getTag(int n) {
        return (TIFFTag)this.allowedTagsByNumber.get(new Integer(n));
    }

    public TIFFTag getTag(String string) {
        if (string == null) {
            throw new IllegalArgumentException("tagName == null!");
        }
        return (TIFFTag)this.allowedTagsByName.get(string);
    }

    public SortedSet getTagNumbers() {
        Set<Integer> set = this.allowedTagsByNumber.keySet();
        TreeSet<Integer> treeSet = set instanceof SortedSet ? (TreeSet<Integer>)set : new TreeSet<Integer>(set);
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getTagNames() {
        Set<String> set = this.allowedTagsByName.keySet();
        TreeSet<String> treeSet = set instanceof SortedSet ? (TreeSet<String>)set : new TreeSet<String>(set);
        return Collections.unmodifiableSortedSet(treeSet);
    }
}

