/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

abstract class GIFMetadata
extends IIOMetadata {
    static final int UNDEFINED_INTEGER_VALUE = -1;

    protected static void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    protected static String getStringAttribute(Node node, String string, String string2, boolean bl, String[] stringArray) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return string2;
            }
            GIFMetadata.fatal(node, "Required attribute " + string + " not present!");
            return null;
        }
        String string3 = node2.getNodeValue();
        if (stringArray != null) {
            if (string3 == null) {
                GIFMetadata.fatal(node, "Null value for " + node.getNodeName() + " attribute " + string + "!");
                return null;
            }
            boolean bl2 = false;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!string3.equals(stringArray[i])) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                GIFMetadata.fatal(node, "Bad value for " + node.getNodeName() + " attribute " + string + "!");
            }
        }
        return string3;
    }

    protected static int getIntAttribute(Node node, String string, int n, boolean bl, boolean bl2, int n2, int n3) throws IIOInvalidTreeException {
        String string2 = GIFMetadata.getStringAttribute(node, string, null, bl, null);
        if (string2 == null || "".equals(string2)) {
            return n;
        }
        int n4 = n;
        try {
            n4 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            GIFMetadata.fatal(node, "Bad value for " + node.getNodeName() + " attribute " + string + "!");
        }
        if (bl2 && (n4 < n2 || n4 > n3)) {
            GIFMetadata.fatal(node, "Bad value for " + node.getNodeName() + " attribute " + string + "!");
        }
        return n4;
    }

    protected static float getFloatAttribute(Node node, String string, float f2, boolean bl) throws IIOInvalidTreeException {
        String string2 = GIFMetadata.getStringAttribute(node, string, null, bl, null);
        if (string2 == null) {
            return f2;
        }
        return Float.parseFloat(string2);
    }

    protected static int getIntAttribute(Node node, String string, boolean bl, int n, int n2) throws IIOInvalidTreeException {
        return GIFMetadata.getIntAttribute(node, string, -1, true, bl, n, n2);
    }

    protected static float getFloatAttribute(Node node, String string) throws IIOInvalidTreeException {
        return GIFMetadata.getFloatAttribute(node, string, -1.0f, true);
    }

    protected static boolean getBooleanAttribute(Node node, String string, boolean bl, boolean bl2) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return bl;
            }
            GIFMetadata.fatal(node, "Required attribute " + string + " not present!");
            return false;
        }
        String string2 = node2.getNodeValue();
        if (string2.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (string2.equalsIgnoreCase("FALSE")) {
            return false;
        }
        GIFMetadata.fatal(node, "Attribute " + string + " must be 'TRUE' or 'FALSE'!");
        return false;
    }

    protected static boolean getBooleanAttribute(Node node, String string) throws IIOInvalidTreeException {
        return GIFMetadata.getBooleanAttribute(node, string, false, true);
    }

    protected static int getEnumeratedAttribute(Node node, String string, String[] stringArray, int n, boolean bl) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return n;
            }
            GIFMetadata.fatal(node, "Required attribute " + string + " not present!");
            return 0;
        }
        String string2 = node2.getNodeValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            return i;
        }
        GIFMetadata.fatal(node, "Illegal value for attribute " + string + "!");
        return -1;
    }

    protected static int getEnumeratedAttribute(Node node, String string, String[] stringArray) throws IIOInvalidTreeException {
        return GIFMetadata.getEnumeratedAttribute(node, string, stringArray, -1, true);
    }

    protected static String getAttribute(Node node, String string, String string2, boolean bl) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return string2;
            }
            GIFMetadata.fatal(node, "Required attribute " + string + " not present!");
            return null;
        }
        return node2.getNodeValue();
    }

    protected static String getAttribute(Node node, String string) throws IIOInvalidTreeException {
        return GIFMetadata.getAttribute(node, string, null, true);
    }

    protected GIFMetadata(boolean bl, String string, String string2, String[] stringArray, String[] stringArray2) {
        super(bl, string, string2, stringArray, stringArray2);
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(this.nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    protected byte[] getColorTable(Node node, String string, boolean bl, int n) throws IIOInvalidTreeException {
        int n2;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        int n3 = -1;
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            GIFMetadata.fatal(node, "Palette has no entries!");
        }
        while (node2 != null) {
            if (!node2.getNodeName().equals(string)) {
                GIFMetadata.fatal(node, "Only a " + string + " may be a child of a " + node2.getNodeName() + "!");
            }
            if ((n2 = GIFMetadata.getIntAttribute(node2, "index", true, 0, 255)) > n3) {
                n3 = n2;
            }
            byArray[n2] = (byte)GIFMetadata.getIntAttribute(node2, "red", true, 0, 255);
            byArray2[n2] = (byte)GIFMetadata.getIntAttribute(node2, "green", true, 0, 255);
            byArray3[n2] = (byte)GIFMetadata.getIntAttribute(node2, "blue", true, 0, 255);
            node2 = node2.getNextSibling();
        }
        n2 = n3 + 1;
        if (bl && n2 != n) {
            GIFMetadata.fatal(node, "Unexpected length for palette!");
        }
        byte[] byArray4 = new byte[3 * n2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            byArray4[n4++] = byArray[i];
            byArray4[n4++] = byArray2[i];
            byArray4[n4++] = byArray3[i];
        }
        return byArray4;
    }

    protected abstract void mergeNativeTree(Node var1) throws IIOInvalidTreeException;

    protected abstract void mergeStandardTree(Node var1) throws IIOInvalidTreeException;
}

