/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFImageReadParam;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCIELabColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFDeflateDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGCMYKDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLSBDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLZWDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFNullDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFOldJPEGDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFPackBitsDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFStreamMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFYCbCrColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFYCbCrDecompressor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;

public class TIFFImageReader
extends ImageReader {
    private static final boolean DEBUG = false;
    ImageInputStream stream = null;
    boolean gotHeader = false;
    ImageReadParam imageReadParam = this.getDefaultReadParam();
    TIFFStreamMetadata streamMetadata = null;
    int currIndex = -1;
    TIFFImageMetadata imageMetadata = null;
    List imageStartPosition = new ArrayList();
    int numImages = -1;
    HashMap imageTypeMap = new HashMap();
    BufferedImage theImage = null;
    int width = -1;
    int height = -1;
    int numBands = -1;
    int tileOrStripWidth = -1;
    int tileOrStripHeight = -1;
    int planarConfiguration = 1;
    int rowsDone = 0;
    int compression;
    int photometricInterpretation;
    int samplesPerPixel;
    int[] sampleFormat;
    int[] bitsPerSample;
    int[] extraSamples;
    char[] colorMap;
    int sourceXOffset;
    int sourceYOffset;
    int srcXSubsampling;
    int srcYSubsampling;
    int dstWidth;
    int dstHeight;
    int dstMinX;
    int dstMinY;
    int dstXOffset;
    int dstYOffset;
    int tilesAcross;
    int tilesDown;
    int pixelsRead;
    int pixelsToRead;
    private Map<Integer, Integer> cacheWidth = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> cacheHeight = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> cacheTileWidth = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> cacheTileHeight = new HashMap<Integer, Integer>();
    private boolean isOldFSITool;
    public static final int[] compressionNumbers = new int[]{2, 3, 4, 5, 6, 7, 8, 32773, 32946, 6};
    static final String EXIF_JPEG_COMPRESSION_TYPE = "EXIF JPEG";
    public static final String[] TIFFCompressionTypes = new String[]{"CCITT RLE", "CCITT T.4", "CCITT T.6", "LZW", "JPEG", "ZLib", "PackBits", "Deflate", "EXIF JPEG"};
    public static final String[] compressionTypes = new String[]{"CCITT RLE", "CCITT T.4", "CCITT T.6", "LZW", "Old JPEG", "JPEG", "ZLib", "PackBits", "Deflate", "EXIF JPEG"};
    public static final boolean[] isCompressionLossless = new boolean[]{true, true, true, true, false, false, true, true, true, false};
    private int[] sourceBands;
    private int[] destinationBands;
    private TIFFDecompressor decompressor;

    public TIFFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.resetLocal();
        if (object != null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)object;
        } else {
            this.stream = null;
        }
    }

    public void setIsOldFSITool(boolean bl) {
        this.isOldFSITool = bl;
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new TIFFStreamMetadata();
        try {
            int n = this.stream.readUnsignedShort();
            if (n == 19789) {
                this.streamMetadata.byteOrder = ByteOrder.BIG_ENDIAN;
                this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
            } else if (n == 18761) {
                this.streamMetadata.byteOrder = ByteOrder.LITTLE_ENDIAN;
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.processWarningOccurred("Bad byte order in header, assuming little-endian");
                this.streamMetadata.byteOrder = ByteOrder.LITTLE_ENDIAN;
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            }
            int n2 = this.stream.readUnsignedShort();
            if (n2 != 42) {
                this.processWarningOccurred("Bad magic number in header, continuing");
            }
            long l = this.stream.readUnsignedInt();
            this.imageStartPosition.add(new Long(l));
            this.stream.seek(l);
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading header!", iOException);
        }
        this.gotHeader = true;
    }

    private int locateImage(int n) throws IIOException {
        this.readHeader();
        try {
            int n2;
            Long l = (Long)this.imageStartPosition.get(n2);
            this.stream.seek(l);
            for (n2 = Math.min(n, this.imageStartPosition.size() - 1); n2 < n; ++n2) {
                int n3 = this.stream.readUnsignedShort();
                long l2 = 0L;
                for (int i = 0; i < n3; ++i) {
                    int n4 = this.stream.readUnsignedShort();
                    int n5 = this.stream.readUnsignedShort();
                    long l3 = this.stream.readUnsignedInt();
                    long l4 = this.stream.readUnsignedInt();
                    if (n4 != 330 || n5 != 13 && n5 != 4) continue;
                    l2 = l4;
                }
                long l5 = l2 == 0L ? this.stream.readUnsignedInt() : l2;
                if (l5 == 0L) {
                    return n2;
                }
                this.imageStartPosition.add(new Long(l5));
                this.stream.seek(l5);
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Couldn't seek!", iOException);
        }
        if (this.currIndex != n) {
            this.imageMetadata = null;
        }
        this.currIndex = n;
        return n;
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.seekForwardOnly && bl) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (bl) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        this.readHeader();
        return this.streamMetadata;
    }

    private void checkIndex(int n) {
        if (n < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = n;
        }
    }

    private void seekToImage(int n) throws IIOException {
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException("imageIndex " + n + " out of bounds " + n2);
        }
        try {
            this.readMetadata();
        }
        catch (IIOException iIOException) {
            // empty catch block
        }
        this.initializeFromMetadata();
    }

    private void readMetadata() throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.imageMetadata != null) {
            return;
        }
        try {
            ArrayList<BaselineTIFFTagSet> arrayList;
            if (this.imageReadParam instanceof TIFFImageReadParam) {
                arrayList = ((TIFFImageReadParam)this.imageReadParam).getAllowedTagSets();
            } else {
                arrayList = new ArrayList<BaselineTIFFTagSet>(1);
                arrayList.add(BaselineTIFFTagSet.getInstance());
            }
            this.imageMetadata = new TIFFImageMetadata(arrayList);
            this.imageMetadata.initializeFromStream(this.stream, this.ignoreMetadata);
        }
        catch (IIOException iIOException) {
            throw iIOException;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading image metadata!", iOException);
        }
    }

    private int getWidth() {
        return this.width;
    }

    private int getHeight() {
        return this.height;
    }

    private int getNumBands() {
        return this.numBands;
    }

    private int getTileOrStripWidth() {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(322);
        return tIFFField == null ? this.getWidth() : tIFFField.getAsInt(0);
    }

    private int getTileOrStripHeight() {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(323);
        if (tIFFField != null) {
            return tIFFField.getAsInt(0);
        }
        tIFFField = this.imageMetadata.getTIFFField(278);
        int n = tIFFField == null ? -1 : tIFFField.getAsInt(0);
        return n == -1 ? this.getHeight() : n;
    }

    private int getPlanarConfiguration() {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(284);
        if (tIFFField != null) {
            int n = tIFFField.getAsInt(0);
            if (n == 2) {
                if (this.getCompression() == 6 && this.imageMetadata.getTIFFField(513) != null) {
                    this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with JPEGInterchangeFormat; resetting to \"Chunky\".");
                    n = 1;
                } else {
                    TIFFField tIFFField2 = this.imageMetadata.getTIFFField(324);
                    if (tIFFField2 == null) {
                        tIFFField2 = this.imageMetadata.getTIFFField(273);
                        int n2 = this.getTileOrStripWidth();
                        int n3 = this.getTileOrStripHeight();
                        int n4 = (this.getWidth() + n2 - 1) / n2;
                        int n5 = (this.getHeight() + n3 - 1) / n3;
                        int n6 = n4 * n5;
                        long[] lArray = tIFFField2.getAsLongs();
                        if (lArray != null && lArray.length == n6) {
                            this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with TileOffsets field value count; resetting to \"Chunky\".");
                            n = 1;
                        }
                    } else {
                        int n7 = this.getTileOrStripHeight();
                        int n8 = (this.getHeight() + n7 - 1) / n7;
                        long[] lArray = tIFFField2.getAsLongs();
                        if (lArray != null && lArray.length == n8) {
                            this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with StripOffsets field value count; resetting to \"Chunky\".");
                            n = 1;
                        }
                    }
                }
            }
            return n;
        }
        return 1;
    }

    private long getTileOrStripOffset(int n) throws IIOException {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(324);
        if (tIFFField == null) {
            tIFFField = this.imageMetadata.getTIFFField(273);
        }
        if (tIFFField == null) {
            tIFFField = this.imageMetadata.getTIFFField(513);
        }
        if (tIFFField == null) {
            throw new IIOException("Missing required strip or tile offsets field.");
        }
        return tIFFField.getAsLong(n);
    }

    private long getTileOrStripByteCount(int n) throws IOException {
        long l;
        TIFFField tIFFField = this.imageMetadata.getTIFFField(325);
        if (tIFFField == null) {
            tIFFField = this.imageMetadata.getTIFFField(279);
        }
        if (tIFFField == null) {
            tIFFField = this.imageMetadata.getTIFFField(514);
        }
        if (tIFFField != null) {
            l = tIFFField.getAsLong(n);
        } else {
            int n2;
            this.processWarningOccurred("TIFF directory contains neither StripByteCounts nor TileByteCounts field: attempting to calculate from strip or tile width and height.");
            int n3 = this.bitsPerSample[0];
            for (n2 = 1; n2 < this.samplesPerPixel; ++n2) {
                n3 += this.bitsPerSample[n2];
            }
            n2 = (this.getTileOrStripWidth() * n3 + 7) / 8;
            l = n2 * this.getTileOrStripHeight();
            long l2 = this.stream.length();
            if (l2 != -1L) {
                l = Math.min(l, l2 - this.getTileOrStripOffset(n));
            } else {
                this.processWarningOccurred("Stream length is unknown: cannot clamp estimated strip or tile byte count to EOF.");
            }
        }
        return l;
    }

    private int getCompression() {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(259);
        if (tIFFField == null) {
            return 1;
        }
        return tIFFField.getAsInt(0);
    }

    @Override
    public int getWidth(int n) throws IOException {
        Integer n2 = this.cacheWidth.get(n);
        if (n2 != null) {
            return n2;
        }
        this.seekToImage(n);
        int n3 = this.getWidth();
        this.cacheWidth.put(n, n3);
        return n3;
    }

    @Override
    public int getHeight(int n) throws IOException {
        Integer n2 = this.cacheHeight.get(n);
        if (n2 != null) {
            return n2;
        }
        this.seekToImage(n);
        int n3 = this.getHeight();
        this.cacheHeight.put(n, n3);
        return n3;
    }

    private void initializeFromMetadata() {
        Object object;
        Iterator<ImageReader> iterator;
        TIFFField tIFFField = this.imageMetadata.getTIFFField(259);
        if (tIFFField == null) {
            this.processWarningOccurred("Compression field is missing; assuming no compression");
            this.compression = 1;
        } else {
            this.compression = tIFFField.getAsInt(0);
        }
        boolean bl = false;
        tIFFField = this.imageMetadata.getTIFFField(256);
        if (tIFFField != null) {
            this.width = tIFFField.getAsInt(0);
        } else {
            this.processWarningOccurred("ImageWidth field is missing.");
            bl = true;
        }
        tIFFField = this.imageMetadata.getTIFFField(257);
        if (tIFFField != null) {
            this.height = tIFFField.getAsInt(0);
        } else {
            this.processWarningOccurred("ImageLength field is missing.");
            bl = true;
        }
        tIFFField = this.imageMetadata.getTIFFField(277);
        if (tIFFField != null) {
            this.samplesPerPixel = tIFFField.getAsInt(0);
        } else {
            this.samplesPerPixel = 1;
            bl = true;
        }
        int n = 1;
        if (bl && (tIFFField = this.imageMetadata.getTIFFField(513)) != null && (iterator = ImageIO.getImageReadersByFormatName("JPEG")) != null && iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            try {
                this.stream.mark();
                this.stream.seek(tIFFField.getAsLong(0));
                imageReader.setInput(this.stream);
                if (this.imageMetadata.getTIFFField(256) == null) {
                    this.width = imageReader.getWidth(0);
                }
                if (this.imageMetadata.getTIFFField(257) == null) {
                    this.height = imageReader.getHeight(0);
                }
                object = imageReader.getRawImageType(0);
                if (this.imageMetadata.getTIFFField(277) == null) {
                    this.samplesPerPixel = ((ImageTypeSpecifier)object).getSampleModel().getNumBands();
                }
                this.stream.reset();
                n = ((ImageTypeSpecifier)object).getColorModel().getComponentSize(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            imageReader.dispose();
        }
        if (this.samplesPerPixel < 1) {
            this.processWarningOccurred("Samples per pixel < 1!");
        }
        this.numBands = this.samplesPerPixel;
        this.colorMap = null;
        tIFFField = this.imageMetadata.getTIFFField(320);
        if (tIFFField != null) {
            this.colorMap = tIFFField.getAsChars();
        }
        if ((tIFFField = this.imageMetadata.getTIFFField(262)) == null) {
            if (this.compression == 2 || this.compression == 3 || this.compression == 4) {
                this.processWarningOccurred("PhotometricInterpretation field is missing; assuming WhiteIsZero");
                this.photometricInterpretation = 0;
            } else if (this.colorMap != null) {
                this.photometricInterpretation = 3;
            } else if (this.samplesPerPixel == 3 || this.samplesPerPixel == 4) {
                this.photometricInterpretation = 2;
            } else {
                this.processWarningOccurred("PhotometricInterpretation field is missing; assuming BlackIsZero");
                this.photometricInterpretation = 1;
            }
        } else {
            this.photometricInterpretation = tIFFField.getAsInt(0);
        }
        boolean bl2 = false;
        int n2 = -1;
        tIFFField = this.imageMetadata.getTIFFField(339);
        this.sampleFormat = new int[this.samplesPerPixel];
        bl2 = false;
        if (tIFFField == null) {
            bl2 = true;
            n2 = 4;
            object = new TIFFTag("sf", n2, 3);
            tIFFField = new TIFFField((TIFFTag)object, n2);
        } else if (tIFFField.getCount() != this.samplesPerPixel) {
            bl2 = true;
            n2 = tIFFField.getAsInt(0);
        }
        if (tIFFField != null) {
            for (int i = 0; i < this.samplesPerPixel; ++i) {
                int n3 = this.sampleFormat[i] = bl2 ? n2 : tIFFField.getAsInt(i);
                if (this.sampleFormat[i] == 1 || this.sampleFormat[i] == 2 || this.sampleFormat[i] == 3 || this.sampleFormat[i] == 4) continue;
                this.processWarningOccurred("Illegal value for SAMPLE_FORMAT, assuming SAMPLE_FORMAT_UNDEFINED");
                this.sampleFormat[i] = 4;
            }
        }
        tIFFField = this.imageMetadata.getTIFFField(258);
        this.bitsPerSample = new int[this.samplesPerPixel];
        bl2 = false;
        if (tIFFField == null) {
            bl2 = true;
            n2 = n;
        } else if (tIFFField.getCount() != this.samplesPerPixel) {
            bl2 = true;
            n2 = tIFFField.getAsInt(0);
        }
        if (tIFFField != null) {
            for (int i = 0; i < this.samplesPerPixel; ++i) {
                this.bitsPerSample[i] = bl2 ? n2 : tIFFField.getAsInt(i);
            }
        }
        this.extraSamples = null;
        tIFFField = this.imageMetadata.getTIFFField(338);
        if (tIFFField != null) {
            this.extraSamples = tIFFField.getAsInts();
        }
    }

    public Iterator getImageTypes(int n) throws IIOException {
        List<ImageTypeSpecifier> list;
        Integer n2 = new Integer(n);
        if (this.imageTypeMap.containsKey(n2)) {
            list = (List)this.imageTypeMap.get(n2);
        } else {
            block8: {
                list = new ArrayList(1);
                this.seekToImage(n);
                ImageTypeSpecifier imageTypeSpecifier = TIFFDecompressor.getRawImageTypeSpecifier(this.photometricInterpretation, this.compression, this.samplesPerPixel, this.bitsPerSample, this.sampleFormat, this.extraSamples, this.colorMap);
                TIFFField tIFFField = this.imageMetadata.getTIFFField(34675);
                if (tIFFField != null && imageTypeSpecifier.getColorModel() instanceof ComponentColorModel) {
                    byte[] byArray = tIFFField.getAsBytes();
                    try {
                        ICC_Profile iCC_Profile = ICC_Profile.getInstance(byArray);
                        ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
                        ColorModel colorModel = imageTypeSpecifier.getColorModel();
                        ColorSpace colorSpace = colorModel.getColorSpace();
                        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
                        int n3 = sampleModel.getNumBands();
                        int n4 = iCC_ColorSpace.getNumComponents();
                        if (n3 == n4 || n3 == n4 + 1) {
                            boolean bl = n4 != n3;
                            boolean bl2 = bl && colorModel.isAlphaPremultiplied();
                            ComponentColorModel componentColorModel = new ComponentColorModel(iCC_ColorSpace, colorModel.getComponentSize(), bl, bl2, colorModel.getTransparency(), colorModel.getTransferType());
                            list.add(new ImageTypeSpecifier(componentColorModel, sampleModel));
                            if (colorSpace.getType() == iCC_ColorSpace.getType() && colorSpace.getNumComponents() == iCC_ColorSpace.getNumComponents()) {
                                list.add(imageTypeSpecifier);
                            }
                            break block8;
                        }
                        list.add(imageTypeSpecifier);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        list.add(imageTypeSpecifier);
                    }
                } else {
                    list.add(imageTypeSpecifier);
                }
            }
            this.imageTypeMap.put(n2, list);
        }
        return list.iterator();
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IIOException {
        this.seekToImage(n);
        TIFFImageMetadata tIFFImageMetadata = new TIFFImageMetadata(this.imageMetadata.getRootIFD().getTagSetList());
        Node node = this.imageMetadata.getAsTree("com_sun_media_imageio_plugins_tiff_image_1.0");
        tIFFImageMetadata.setFromTree("com_sun_media_imageio_plugins_tiff_image_1.0", node);
        return tIFFImageMetadata;
    }

    public IIOMetadata getStreamMetadata(int n) throws IIOException {
        this.readHeader();
        TIFFStreamMetadata tIFFStreamMetadata = new TIFFStreamMetadata();
        Node node = tIFFStreamMetadata.getAsTree("com_sun_media_imageio_plugins_tiff_stream_1.0");
        tIFFStreamMetadata.setFromTree("com_sun_media_imageio_plugins_tiff_stream_1.0", node);
        return tIFFStreamMetadata;
    }

    @Override
    public boolean isRandomAccessEasy(int n) throws IOException {
        if (this.currIndex != -1) {
            this.seekToImage(this.currIndex);
            return this.getCompression() == 1;
        }
        return false;
    }

    public boolean readSupportsThumbnails() {
        return false;
    }

    @Override
    public boolean hasThumbnails(int n) {
        return false;
    }

    @Override
    public int getNumThumbnails(int n) throws IOException {
        return 0;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new TIFFImageReadParam();
    }

    @Override
    public boolean isImageTiled(int n) throws IOException {
        this.seekToImage(n);
        TIFFField tIFFField = this.imageMetadata.getTIFFField(322);
        return tIFFField != null;
    }

    @Override
    public int getTileWidth(int n) throws IOException {
        Integer n2 = this.cacheTileWidth.get(n);
        if (n2 != null) {
            return n2;
        }
        this.seekToImage(n);
        int n3 = this.getTileOrStripWidth();
        this.cacheTileWidth.put(n, n3);
        return n3;
    }

    @Override
    public int getTileHeight(int n) throws IOException {
        Integer n2 = this.cacheTileHeight.get(n);
        if (n2 != null) {
            return n2;
        }
        this.seekToImage(n);
        int n3 = this.getTileOrStripHeight();
        this.cacheTileHeight.put(n, n3);
        return n3;
    }

    @Override
    public BufferedImage readTile(int n, int n2, int n3) throws IOException {
        int n4 = this.getWidth(n);
        int n5 = this.getHeight(n);
        int n6 = this.getTileWidth(n);
        int n7 = this.getTileHeight(n);
        int n8 = n6 * n2;
        int n9 = n7 * n3;
        if (n2 < 0 || n3 < 0 || n8 >= n4 || n9 >= n5) {
            throw new IllegalArgumentException("Tile indices are out of bounds!");
        }
        if (n8 + n6 > n4) {
            n6 = n4 - n8;
        }
        if (n9 + n7 > n5) {
            n7 = n5 - n9;
        }
        ImageReadParam imageReadParam = this.getDefaultReadParam();
        Rectangle rectangle = new Rectangle(n8, n9, n6, n7);
        imageReadParam.setSourceRegion(rectangle);
        return this.read(n, imageReadParam);
    }

    @Override
    public boolean canReadRaster() {
        return false;
    }

    @Override
    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static int ifloor(int n, int n2) {
        if (n < 0) {
            n -= n2 - 1;
        }
        return n / n2;
    }

    private static int iceil(int n, int n2) {
        if (n > 0) {
            n += n2 - 1;
        }
        return n / n2;
    }

    private void prepareRead(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.imageReadParam = imageReadParam;
        this.seekToImage(n);
        this.tileOrStripWidth = this.getTileOrStripWidth();
        this.tileOrStripHeight = this.getTileOrStripHeight();
        this.planarConfiguration = this.getPlanarConfiguration();
        this.sourceBands = imageReadParam.getSourceBands();
        if (this.sourceBands == null) {
            this.sourceBands = new int[this.numBands];
            for (int i = 0; i < this.numBands; ++i) {
                this.sourceBands[i] = i;
            }
        }
        Iterator iterator = this.getImageTypes(n);
        ImageTypeSpecifier imageTypeSpecifier = ImageUtil.getDestinationType(imageReadParam, iterator);
        int n3 = imageTypeSpecifier.getSampleModel().getNumBands();
        this.destinationBands = imageReadParam.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.destinationBands[n2] = n2;
            }
        }
        if (this.sourceBands.length != this.destinationBands.length) {
            throw new IllegalArgumentException("sourceBands.length != destinationBands.length");
        }
        for (n2 = 0; n2 < this.sourceBands.length; ++n2) {
            int n4 = this.sourceBands[n2];
            if (n4 < 0 || n4 >= this.numBands) {
                throw new IllegalArgumentException("Source band out of range!");
            }
            int n5 = this.destinationBands[n2];
            if (n5 >= 0 && n5 < n3) continue;
            throw new IllegalArgumentException("Destination band out of range!");
        }
    }

    private void decodeTile(int n, int n2, int n3) throws IOException {
        Rectangle rectangle = new Rectangle(n * this.tileOrStripWidth, n2 * this.tileOrStripHeight, this.tileOrStripWidth, this.tileOrStripHeight);
        if (!this.isImageTiled(this.currIndex)) {
            rectangle = rectangle.intersection(new Rectangle(0, 0, this.width, this.height));
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        this.dstMinX = TIFFImageReader.iceil(n4 - this.sourceXOffset, this.srcXSubsampling);
        int n8 = TIFFImageReader.ifloor(n4 + n6 - 1 - this.sourceXOffset, this.srcXSubsampling);
        this.dstMinY = TIFFImageReader.iceil(n5 - this.sourceYOffset, this.srcYSubsampling);
        int n9 = TIFFImageReader.ifloor(n5 + n7 - 1 - this.sourceYOffset, this.srcYSubsampling);
        this.dstWidth = n8 - this.dstMinX + 1;
        this.dstHeight = n9 - this.dstMinY + 1;
        this.dstMinX += this.dstXOffset;
        this.dstMinY += this.dstYOffset;
        Rectangle rectangle2 = new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight);
        rectangle2 = rectangle2.intersection(this.theImage.getRaster().getBounds());
        this.dstMinX = rectangle2.x;
        this.dstMinY = rectangle2.y;
        this.dstWidth = rectangle2.width;
        this.dstHeight = rectangle2.height;
        if (this.dstWidth <= 0 || this.dstHeight <= 0) {
            return;
        }
        int n10 = (this.dstMinX - this.dstXOffset) * this.srcXSubsampling + this.sourceXOffset;
        int n11 = (this.dstMinX + this.dstWidth - 1 - this.dstXOffset) * this.srcXSubsampling + this.sourceXOffset;
        int n12 = n11 - n10 + 1;
        int n13 = (this.dstMinY - this.dstYOffset) * this.srcYSubsampling + this.sourceYOffset;
        int n14 = (this.dstMinY + this.dstHeight - 1 - this.dstYOffset) * this.srcYSubsampling + this.sourceYOffset;
        int n15 = n14 - n13 + 1;
        this.decompressor.setSrcMinX(n4);
        this.decompressor.setSrcMinY(n5);
        this.decompressor.setSrcWidth(n6);
        this.decompressor.setSrcHeight(n7);
        this.decompressor.setDstMinX(this.dstMinX);
        this.decompressor.setDstMinY(this.dstMinY);
        this.decompressor.setDstWidth(this.dstWidth);
        this.decompressor.setDstHeight(this.dstHeight);
        this.decompressor.setActiveSrcMinX(n10);
        this.decompressor.setActiveSrcMinY(n13);
        this.decompressor.setActiveSrcWidth(n12);
        this.decompressor.setActiveSrcHeight(n15);
        int n16 = n2 * this.tilesAcross + n;
        if (this.planarConfiguration == 2) {
            n16 += n3 * this.tilesAcross * this.tilesDown;
        }
        long l = this.getTileOrStripOffset(n16);
        long l2 = this.getTileOrStripByteCount(n16);
        long l3 = this.stream.length();
        if (l3 > 0L && l + l2 > l3) {
            this.processWarningOccurred("Attempting to process truncated stream.");
            l2 = l3 - l;
            if (Math.max(l2, 0L) == 0L) {
                this.processWarningOccurred("No bytes in strip/tile: skipping.");
                return;
            }
        }
        this.decompressor.setStream(this.stream);
        this.decompressor.setOffset(l);
        this.decompressor.setByteCount((int)l2);
        this.decompressor.beginDecoding();
        this.stream.mark();
        this.decompressor.decode();
        this.stream.reset();
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        Object object;
        this.prepareRead(n, imageReadParam);
        this.theImage = TIFFImageReader.getDestination(imageReadParam, this.getImageTypes(n), this.width, this.height);
        this.srcXSubsampling = this.imageReadParam.getSourceXSubsampling();
        this.srcYSubsampling = this.imageReadParam.getSourceYSubsampling();
        Point point = this.imageReadParam.getDestinationOffset();
        this.dstXOffset = point.x;
        this.dstYOffset = point.y;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        TIFFImageReader.computeRegions(this.imageReadParam, this.width, this.height, this.theImage, rectangle, rectangle2);
        this.sourceXOffset = rectangle.x;
        this.sourceYOffset = rectangle.y;
        this.pixelsToRead = rectangle2.width * rectangle2.height;
        this.pixelsRead = 0;
        this.processImageStarted(n);
        this.processImageProgress(0.0f);
        this.tilesAcross = (this.width + this.tileOrStripWidth - 1) / this.tileOrStripWidth;
        this.tilesDown = (this.height + this.tileOrStripHeight - 1) / this.tileOrStripHeight;
        int n2 = this.getCompression();
        TIFFColorConverter tIFFColorConverter = null;
        if (this.imageReadParam instanceof TIFFImageReadParam) {
            object = (TIFFImageReadParam)this.imageReadParam;
            this.decompressor = ((TIFFImageReadParam)object).getTIFFDecompressor();
            tIFFColorConverter = ((TIFFImageReadParam)object).getColorConverter();
        }
        if (this.decompressor == null) {
            int n3;
            if (this.photometricInterpretation == 8 && this.bitsPerSample[0] != 8) {
                throw new IIOException("Lab 16bit images unsupported");
            }
            if (this.photometricInterpretation == 8 && this.bitsPerSample[0] == 8 && this.samplesPerPixel > 3) {
                throw new IIOException("Lab with alpha channels unsupported");
            }
            if (this.photometricInterpretation == 8 && this.planarConfiguration == 2) {
                throw new IIOException("Lab planar images unsupported");
            }
            if (n2 == 1) {
                object = this.imageMetadata.getTIFFField(266);
                this.decompressor = object != null && ((TIFFField)object).getAsInt(0) == 2 ? new TIFFLSBDecompressor() : new TIFFNullDecompressor();
            } else if (n2 == 4) {
                if (this.decompressor == null) {
                    this.decompressor = new TIFFFaxDecompressor();
                }
            } else if (n2 == 3) {
                if (this.decompressor == null) {
                    this.decompressor = new TIFFFaxDecompressor();
                }
            } else if (n2 == 2) {
                this.decompressor = new TIFFFaxDecompressor();
            } else if (n2 == 32773) {
                this.decompressor = new TIFFPackBitsDecompressor();
            } else if (n2 == 5) {
                object = this.imageMetadata.getTIFFField(317);
                n3 = object == null ? 1 : ((TIFFField)object).getAsInt(0);
                this.decompressor = new TIFFLZWDecompressor(n3);
            } else if (n2 == 7) {
                this.decompressor = this.samplesPerPixel == 4 ? new TIFFJPEGCMYKDecompressor() : new TIFFJPEGDecompressor();
            } else if (n2 == 8 || n2 == 32946) {
                object = this.imageMetadata.getTIFFField(317);
                n3 = object == null ? 1 : ((TIFFField)object).getAsInt(0);
                this.decompressor = new TIFFDeflateDecompressor(n3);
            } else if (n2 == 6) {
                object = this.imageMetadata.getTIFFField(512);
                if (object == null) {
                    this.processWarningOccurred("JPEGProc field missing; assuming baseline sequential JPEG process.");
                } else if (((TIFFField)object).getAsInt(0) != 1) {
                    throw new IIOException("Old-style JPEG supported for baseline sequential JPEG process only!");
                }
                this.decompressor = new TIFFOldJPEGDecompressor();
            } else {
                throw new IIOException("Unsupported compression type (tag number = " + n2 + ")!");
            }
            if (this.photometricInterpretation == 6 && n2 != 7 && n2 != 6) {
                boolean bl = this.theImage.getColorModel().getColorSpace().getType() == 5;
                TIFFDecompressor tIFFDecompressor = this.decompressor instanceof TIFFNullDecompressor ? null : this.decompressor;
                this.decompressor = new TIFFYCbCrDecompressor(tIFFDecompressor, bl);
            }
        }
        if (tIFFColorConverter == null) {
            if (this.photometricInterpretation == 8 && this.theImage.getColorModel().getColorSpace().getType() == 5) {
                tIFFColorConverter = new TIFFCIELabColorConverter();
            } else if (this.photometricInterpretation == 6 && !(this.decompressor instanceof TIFFYCbCrDecompressor) && n2 != 7 && n2 != 6) {
                tIFFColorConverter = new TIFFYCbCrColorConverter(this.imageMetadata);
            }
        }
        this.decompressor.setReader(this);
        this.decompressor.setMetadata(this.imageMetadata);
        this.decompressor.setImage(this.theImage);
        this.decompressor.setOldFSITool(this.isOldFSITool);
        this.decompressor.setPhotometricInterpretation(this.photometricInterpretation);
        this.decompressor.setCompression(n2);
        this.decompressor.setSamplesPerPixel(this.samplesPerPixel);
        this.decompressor.setBitsPerSample(this.bitsPerSample);
        this.decompressor.setSampleFormat(this.sampleFormat);
        this.decompressor.setExtraSamples(this.extraSamples);
        this.decompressor.setColorMap(this.colorMap);
        this.decompressor.setColorConverter(tIFFColorConverter);
        this.decompressor.setSourceXOffset(this.sourceXOffset);
        this.decompressor.setSourceYOffset(this.sourceYOffset);
        this.decompressor.setSubsampleX(this.srcXSubsampling);
        this.decompressor.setSubsampleY(this.srcYSubsampling);
        this.decompressor.setDstXOffset(this.dstXOffset);
        this.decompressor.setDstYOffset(this.dstYOffset);
        this.decompressor.setSourceBands(this.sourceBands);
        this.decompressor.setDestinationBands(this.destinationBands);
        int n4 = this.XToTileX(rectangle.x, 0, this.tileOrStripWidth);
        int n5 = this.YToTileY(rectangle.y, 0, this.tileOrStripHeight);
        int n6 = this.XToTileX(rectangle.x + rectangle.width - 1, 0, this.tileOrStripWidth);
        int n7 = this.YToTileY(rectangle.y + rectangle.height - 1, 0, this.tileOrStripHeight);
        boolean bl = false;
        if (this.planarConfiguration == 2) {
            this.decompressor.setPlanar(true);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            for (int i = n5; i <= n7; ++i) {
                for (int j = n4; j <= n6; ++j) {
                    for (int k = 0; k < this.numBands; ++k) {
                        nArray[0] = this.sourceBands[k];
                        this.decompressor.setSourceBands(nArray);
                        nArray2[0] = this.destinationBands[k];
                        this.decompressor.setDestinationBands(nArray2);
                        if (this.abortRequested()) {
                            bl = true;
                            break;
                        }
                        this.decodeTile(j, i, k);
                    }
                    if (bl) break;
                }
                if (!bl) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = n5; i <= n7; ++i) {
                for (int j = n4; j <= n6; ++j) {
                    if (this.abortRequested()) {
                        bl = true;
                        break;
                    }
                    this.decodeTile(j, i, -1);
                }
                if (!bl) {
                    continue;
                }
                break;
            }
        }
        if (bl) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.theImage;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetLocal();
    }

    int XToTileX(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    int YToTileY(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    protected void resetLocal() {
        this.stream = null;
        this.gotHeader = false;
        this.imageReadParam = this.getDefaultReadParam();
        this.streamMetadata = null;
        this.currIndex = -1;
        this.imageMetadata = null;
        this.imageStartPosition = new ArrayList();
        this.numImages = -1;
        this.imageTypeMap = new HashMap();
        this.width = -1;
        this.height = -1;
        this.numBands = -1;
        this.tileOrStripWidth = -1;
        this.tileOrStripHeight = -1;
        this.planarConfiguration = 1;
        this.rowsDone = 0;
        this.theImage = null;
    }

    void forwardWarningMessage(String string) {
        this.processWarningOccurred(string);
    }

    protected static BufferedImage getDestination(ImageReadParam imageReadParam, Iterator iterator, int n, int n2) throws IIOException {
        Object object;
        Object object2;
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty!");
        }
        BufferedImage bufferedImage = null;
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageReadParam != null) {
            bufferedImage = imageReadParam.getDestination();
            if (bufferedImage != null) {
                return bufferedImage;
            }
            imageTypeSpecifier = imageReadParam.getDestinationType();
        }
        if (imageTypeSpecifier == null) {
            object2 = iterator.next();
            if (!(object2 instanceof ImageTypeSpecifier)) {
                throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
            }
            imageTypeSpecifier = (ImageTypeSpecifier)object2;
        } else {
            boolean bl = false;
            while (iterator.hasNext()) {
                object = (ImageTypeSpecifier)iterator.next();
                if (!((ImageTypeSpecifier)object).equals(imageTypeSpecifier)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IIOException("Destination type from ImageReadParam does not match!");
            }
        }
        object2 = new Rectangle(0, 0, 0, 0);
        object = new Rectangle(0, 0, 0, 0);
        TIFFImageReader.computeRegions(imageReadParam, n, n2, null, object2, (Rectangle)object);
        int n3 = ((Rectangle)object).x + ((Rectangle)object).width;
        int n4 = ((Rectangle)object).y + ((Rectangle)object).height;
        if ((long)n3 * (long)n4 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("width*height (" + n3 + "*" + n4 + ") > Integer.MAX_VALUE!");
        }
        return imageTypeSpecifier.createBufferedImage(n3, n4);
    }
}

