/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.RandomIterCSM;
import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;

public class RandomIterCSMFloat
extends RandomIterCSM {
    float[][] bankData;

    public RandomIterCSMFloat(RenderedImage renderedImage, Rectangle rectangle) {
        super(renderedImage, rectangle);
    }

    protected final void dataBufferChanged() {
        this.bankData = DataBufferUtils.getBankDataFloat(this.dataBuffer);
    }

    public final int getSample(int n, int n2, int n3) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsX);
        return (int)this.bankData[n3][(n - this.sampleModelTranslateX) * this.pixelStride + (n2 - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[n3]];
    }

    public final float getSampleFloat(int n, int n2, int n3) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsX);
        return this.bankData[n3][(n - this.sampleModelTranslateX) * this.pixelStride + (n2 - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[n3]];
    }

    public final double getSampleDouble(int n, int n2, int n3) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsX);
        return this.bankData[n3][(n - this.sampleModelTranslateX) * this.pixelStride + (n2 - this.sampleModelTranslateY) * this.scanlineStride + this.bandOffsets[n3]];
    }

    public float[] getPixel(int n, int n2, float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        int n3 = (n - this.sampleModelTranslateX) * this.pixelStride + (n2 - this.sampleModelTranslateY) * this.scanlineStride;
        for (int i = 0; i < this.numBands; ++i) {
            fArray[i] = this.bankData[i][n3 + this.bandOffsets[i]];
        }
        return fArray;
    }
}

