/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class Convolve3x3OpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    float[][] tables = new float[9][256];

    public Convolve3x3OpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        if (kernelJAI.getWidth() != 3 || kernelJAI.getHeight() != 3 || kernelJAI.getXOrigin() != 1 || kernelJAI.getYOrigin() != 1) {
            throw new RuntimeException(JaiI18N.getString("Convolve3x3OpImage0"));
        }
        if (this.sampleModel.getDataType() == 0) {
            float[] fArray = kernelJAI.getKernelData();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray[3];
            float f5 = fArray[4];
            float f6 = fArray[5];
            float f7 = fArray[6];
            float f8 = fArray[7];
            float f9 = fArray[8];
            for (int i = 0; i < 256; ++i) {
                byte by = (byte)i;
                float f10 = i;
                this.tables[0][by + 128] = f * f10 + 0.5f;
                this.tables[1][by + 128] = f2 * f10;
                this.tables[2][by + 128] = f3 * f10;
                this.tables[3][by + 128] = f4 * f10;
                this.tables[4][by + 128] = f5 * f10;
                this.tables[5][by + 128] = f6 * f10;
                this.tables[6][by + 128] = f7 * f10;
                this.tables[7][by + 128] = f8 * f10;
                this.tables[8][by + 128] = f9 * f10;
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(JaiI18N.getString("Convolve3x3OpImage1"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n;
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        float[] fArray = this.tables[0];
        float[] fArray2 = this.tables[1];
        float[] fArray3 = this.tables[2];
        float[] fArray4 = this.tables[3];
        float[] fArray5 = this.tables[4];
        float[] fArray6 = this.tables[5];
        float[] fArray7 = this.tables[6];
        float[] fArray8 = this.tables[7];
        float[] fArray9 = this.tables[8];
        float[] fArray10 = this.kernel.getKernelData();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = n = rasterAccessor.getScanlineStride();
        int n9 = n * 2;
        int n10 = n4;
        int n11 = n4 * 2;
        for (int i = 0; i < n4; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            for (int j = 0; j < n3; ++j) {
                int n14 = n12;
                int n15 = n13;
                for (int k = 0; k < n2; ++k) {
                    float f = fArray[128 + byArray4[n14]] + fArray2[128 + byArray4[n14 + n10]] + fArray3[128 + byArray4[n14 + n11]] + fArray4[128 + byArray4[n14 + n8]] + fArray5[128 + byArray4[n14 + n8 + n10]] + fArray6[128 + byArray4[n14 + n8 + n11]] + fArray7[128 + byArray4[n14 + n9]] + fArray8[128 + byArray4[n14 + n9 + n10]] + fArray9[128 + byArray4[n14 + n9 + n11]];
                    int n16 = (int)f;
                    if (n16 < 0) {
                        n16 = 0;
                    } else if (n16 > 255) {
                        n16 = 255;
                    }
                    byArray3[n15] = (byte)n16;
                    n14 += n7;
                    n15 += n5;
                }
                n12 += n;
                n13 += n6;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n;
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = n = rasterAccessor.getScanlineStride();
        int n9 = n * 2;
        int n10 = n4;
        int n11 = n4 * 2;
        float[] fArray = this.kernel.getKernelData();
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float f5 = fArray[4];
        float f6 = fArray[5];
        float f7 = fArray[6];
        float f8 = fArray[7];
        float f9 = fArray[8];
        for (int i = 0; i < n4; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            for (int j = 0; j < n3; ++j) {
                int n14 = n12;
                int n15 = n13;
                for (int k = 0; k < n2; ++k) {
                    float f10 = f * (float)sArray4[n14] + f2 * (float)sArray4[n14 + n10] + f3 * (float)sArray4[n14 + n11] + f4 * (float)sArray4[n14 + n8] + f5 * (float)sArray4[n14 + n8 + n10] + f6 * (float)sArray4[n14 + n8 + n11] + f7 * (float)sArray4[n14 + n9] + f8 * (float)sArray4[n14 + n9 + n10] + f9 * (float)sArray4[n14 + n9 + n11];
                    int n16 = (int)f10;
                    if (n16 < Short.MIN_VALUE) {
                        n16 = Short.MIN_VALUE;
                    } else if (n16 > Short.MAX_VALUE) {
                        n16 = Short.MAX_VALUE;
                    }
                    sArray3[n15] = (short)n16;
                    n14 += n7;
                    n15 += n5;
                }
                n12 += n;
                n13 += n6;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n;
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = n = rasterAccessor.getScanlineStride();
        int n9 = n * 2;
        int n10 = n4;
        int n11 = n4 * 2;
        float[] fArray = this.kernel.getKernelData();
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        float f5 = fArray[4];
        float f6 = fArray[5];
        float f7 = fArray[6];
        float f8 = fArray[7];
        float f9 = fArray[8];
        for (int i = 0; i < n4; ++i) {
            int[] nArray5 = nArray[i];
            int[] nArray6 = nArray3[i];
            int n12 = nArray4[i];
            int n13 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                int n14 = n12;
                int n15 = n13;
                for (int k = 0; k < n2; ++k) {
                    float f10 = f * (float)nArray6[n14] + f2 * (float)nArray6[n14 + n10] + f3 * (float)nArray6[n14 + n11] + f4 * (float)nArray6[n14 + n8] + f5 * (float)nArray6[n14 + n8 + n10] + f6 * (float)nArray6[n14 + n8 + n11] + f7 * (float)nArray6[n14 + n9] + f8 * (float)nArray6[n14 + n9 + n10] + f9 * (float)nArray6[n14 + n9 + n11];
                    nArray5[n15] = (int)f10;
                    n14 += n7;
                    n15 += n5;
                }
                n12 += n;
                n13 += n6;
            }
        }
    }
}

