/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;

public class TIFFCIELabColorConverter
extends TIFFColorConverter {
    private static final float Xn = 95.047f;
    private static final float Yn = 100.0f;
    private static final float Zn = 108.883f;
    private static final float THRESHOLD = (float)Math.pow(0.008856, 0.3333333333333333);

    private float clamp(float f2) {
        if (f2 < 0.0f) {
            return 0.0f;
        }
        if (f2 > 100.0f) {
            return 255.0f;
        }
        return f2 * 255.0f / 100.0f;
    }

    private float clamp2(float f2) {
        if (f2 < 0.0f) {
            return 0.0f;
        }
        if (f2 > 255.0f) {
            return 255.0f;
        }
        return f2;
    }

    @Override
    public void fromRGB(float f2, float f3, float f4, float[] fArray) {
        float f5 = 0.412453f * f2 + 0.35758f * f3 + 0.180423f * f4;
        float f6 = 0.212671f * f2 + 0.71516f * f3 + 0.072169f * f4;
        float f7 = 0.019334f * f2 + 0.119193f * f3 + 0.950227f * f4;
        float f8 = f6 / 100.0f;
        float f9 = f5 / 95.047f;
        float f10 = f7 / 108.883f;
        f8 = f8 < 0.008856f ? 7.787f * f8 + 0.13793103f : (float)Math.pow(f8, 0.3333333333333333);
        f9 = f9 < 0.008856f ? 7.787f * f9 + 0.13793103f : (float)Math.pow(f9, 0.3333333333333333);
        f10 = f10 < 0.008856f ? 7.787f * f10 + 0.13793103f : (float)Math.pow(f10, 0.3333333333333333);
        float f11 = 116.0f * f8 - 16.0f;
        float f12 = 500.0f * (f9 - f8);
        float f13 = 200.0f * (f8 - f10);
        f11 *= 2.55f;
        if (f12 < 0.0f) {
            f12 += 256.0f;
        }
        if (f13 < 0.0f) {
            f13 += 256.0f;
        }
        fArray[0] = this.clamp2(f11);
        fArray[1] = this.clamp2(f12);
        fArray[2] = this.clamp2(f13);
    }

    @Override
    public void toRGB(float f2, float f3, float f4, float[] fArray) {
        float f5;
        float f6;
        float f7;
        float f8;
        float f9 = f2 * 100.0f / 255.0f;
        float f10 = f3 > 128.0f ? f3 - 256.0f : f3;
        float f11 = f8 = f4 > 128.0f ? f4 - 256.0f : f4;
        if (f9 < 8.0f) {
            f7 = f9 / 903.3f;
            f6 = 7.787f * f7 + 0.13793103f;
        } else {
            f5 = (f9 + 16.0f) / 116.0f;
            f7 = f5 * f5 * f5;
            f6 = (float)Math.pow(f7, 0.3333333333333333);
        }
        f5 = f7 * 100.0f;
        float f12 = f6 + f10 / 500.0f;
        float f13 = f12 <= THRESHOLD ? 95.047f * (f12 - 0.13793103f) / 7.787f : 95.047f * f12 * f12 * f12;
        float f14 = f6 - f8 / 200.0f;
        float f15 = f14 <= THRESHOLD ? 108.883f * (f14 - 0.13793103f) / 7.787f : 108.883f * f14 * f14 * f14;
        float f16 = 3.240479f * f13 - 1.53715f * f5 - 0.498535f * f15;
        float f17 = -0.969256f * f13 + 1.875992f * f5 + 0.041556f * f15;
        float f18 = 0.055648f * f13 - 0.204043f * f5 + 1.057311f * f15;
        fArray[0] = this.clamp(f16);
        fArray[1] = this.clamp(f17);
        fArray[2] = this.clamp(f18);
    }
}

