/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2017 NeptuneLabs GmbH - All rights reserved.
 *
 */

function getRadioValue(radio, defaultvalue){
	if( radio ) {
		for(var i=0; i<radio.length; i++)	{
			if (radio[i].checked) {
				if (radio[i].value != defaultvalue) {
					return radio[i].value;
				} else {
					return; //No value if default
				}
			}
		}
	}	
}

function setRadioValue(radio, newvalue, len){
	for(var i=0; i<len; i++) {
		if (radio[i].value == newvalue) {
			radio[i].checked = true;
			break;
		}
	}
}

function getMultiSelect(select){
	var opts = new Array();
	for (var i=0; i < select.options.length; i++) if (select.options[i].selected) opts.push(i);
	return opts.join(",");
}

function getSingleSelectValue(selectf){
	var opts = new Array();
	for (var i=0; i < selectf.options.length; i++) {
		if (selectf.options[i].selected) return selectf.options[i].value;
	}
}

function getFileOnly(filePath, truncateSuffix){
	var result = filePath;
	if (filePath){
		var mat = filePath.match(/(.+)\/(.+)$/);
		if (mat) {
			result = mat[2];
			if (truncateSuffix){
				mat = result.match(/(.+)\.\w{3}/);
				if (mat){
					result = mat[1];
				}
			}
		}
	}
	return result;
}

function getMultiSelectValues(select, joinString){
	var opts = new Array();
	for (var i=0; i < select.options.length; i++) if (select.options[i].selected) opts.push(select.options[i].value);
	return opts.join(joinString);
}

function getTextValue(input){
	if( input != null && input.value != "" ) {
		return input.value; //removed encodeUri weg savedocumenturl
	} else {
		return '';
	}
}

function setMultiSelect(select, opts){
	opts = opts.split(",");
	var len = select.options.length;
	for (var i=0; i < opts.length; i++){
		if (opts[i] < len && opts[i] > -1) select.options[opts[i]].selected = true;
	}
}

function setSingleSelect(sel, val){
	for (var i=0; i < sel.length; i++){
		if (sel[i].value == val) {
			sel[i].selected = true;
			return;
		}
	}
}

function getStorageParameters(ID){
	
	try{
		if (interfaceControl.PublishData[ID].value == null) {
			interfaceControl.PublishData[ID] = new Object();
		}
	}
	catch(e){};

	try{
		if (interfaceControl.PublishData[ID] == null) {
			interfaceControl.PublishData[ID] = new Array();
		}
	}
	catch(e){ };
	
	return interfaceControl.PublishData[ID];
}


function StoreParameterValues(ID){
	cookievalue = "";
	for (var option in qdata) {
	
		if ( (qdata[option] != "" || typeof(qdata[option]) == "number") && typeof(qdata[option]) != "undefined") { 
			if (qdata[option] != 'error') {
				el = document.getElementById(option);
				if (typeof(el) == 'undefined') continue;
					try {
						state = null;
						switch (el.type){
							case 'select-one':
								state = el.value;
							break;
							case 'select-multiple':
								state = getMultiSelect(el);
							break;
							case 'radio':
								state = qdata[option]
								//i += el.length-1;
							break;
							case 'checkbox':
								state = el.checked;
							break;
							case 'hidden':
							case 'text':
							case 'textarea':
							default:
								state = escape(el.value);
							break;
						}
			
						if (state != null){
							cookievalue += el.type+"."+el.id+"="+escape(state)+";";
						}
					}
					catch(e){};
			}
		}
	}
	cookievalue += "bool.moreoptions="+escape(moreoptions);
	cookievalue += ";text.moreparams="+qdata["moreparams"];
	cookievalue += ";text.effects="+qdata["effects"];
	if (document.settings.savecfg) {
		cookievalue += ";select-one.cfg="+escape(document.settings.cfg.value);
		cookievalue += ";text.savecfg="+document.settings.savecfg.value;
	}
	
	place2put = getStorageParameters(ID);
	place2put.value = cookievalue;
	
	place2put2 = getStorageParameters(ID+"_PLUGINS");
    place2put2.value = plugins.join(";");
	
	place2put3 = getStorageParameters(ID+"_CFG");
    place2put3.value = qdata['cfg'];
	
	return;

}

function setFSIFormValue(elid, val){
	if (!elid) return;
	if(val == "") return;
	el = document.getElementById(elid);
	opt = document.settings;
	try{
		switch (el.type){
			case 'select-one':
				 setSingleSelect(el, val)
			break;
			case 'select-multiple':
				setMultiSelect(el, val);
			break;
			case 'radio':
				radio = document.settings[elid];
				setRadioValue(radio, val, radio.length);
			break;
			case 'checkbox':
				el.checked = eval(val);
			break;
			case 'hidden':
			case 'text':
			case 'textarea':
			default:
				if ("#" == val.substr(0,1)) val = val.substr(1,val.length);
				el.value = decodeURIComponent(val);
			break;
		}
	}
	catch(e){ }
}

function RestoreParameterValues(ID){
	var o,opt,el,storage;
	var myform = document.settings;

	// Reset all form data if new cfg is selected
	var c = "";
	try {
		c = getStorageParameters(ID+'_CFG').value;
	} catch (e) { c = new Object(); }
	
	if (typeof(c) != 'undefined' && c != qdata['cfg']) {
		place2put = getStorageParameters(ID);
		
		place2put2 = getStorageParameters(ID+"_PLUGINS");
	}
	
	// Plugins
	try{
		var txt = getStorageParameters(ID+'_PLUGINS').value;
		pluginlist = txt.split(";");
	}
	catch(e){
		return;
	};

	// Show more Options if something is selected in it;
	if( pluginlist.length > 0 ) {

		for (x=0; x < pluginlist.length ; x++){
			try {
				if (!inArray(pluginlist[x],plugins)) {
					handlePlugins(pluginlist[x]);
					if( pluginlist[x] == "Resize" ) {
						document.settings.options_resizeable.checked = true;
					}
				}
			}
			catch(e){ continue; }
		}
	}
	
	//Options
	var paramlist="";
	try{
		var txt = getStorageParameters(ID).value;
		if (txt != "") paramlist = txt.split(";");
	}
	catch(e){
		return;
	};

	more = false;
	
	for (x=0; x<paramlist.length; x++){
		try {
			opt = paramlist[x].split("=");
			ty = opt[0].split(".");
			
			elementname = ty[1];
			elementstate = unescape(opt[1]);
			
			el = myform[x];
			if (typeof(el) != 'object') continue;
		}
		catch(e){continue;}
		
		if (elementname == 'moreparams') {
			document.getElementById('MoreParams').value = unescape(elementstate);
		}  else if (elementname == 'effects') {
			var t = unescape(paramlist[x]);
			t = t.replace(/text.effects=/,"");
			var tlist = t.split("&");
			try {
			o1 = tlist[0].split("=");			
			document.getElementById('effects_'+o1[0]).value=o1[1];
			}catch(e){}
			try {
			o2 = tlist[1].split("=");	
			document.getElementById('effects_'+o2[0]).value=o2[1];
			}catch(e){}
		} else {
			setFSIFormValue(elementname, unescape(elementstate));
		}
				
		if( elementname != 'moreoptions' && elementname != 'savecfg') {
			qdata[elementname] = elementstate; // !			
		}		
				
		try {
			det = elementname.split("_");				
			if (!more && (det[0] == 'pages' || det[0] == 'showcase' || det[0] == 'options')) {
				more = true;
			}
		}
		catch(e) {continue;}
	}
	storage = getStorageParameters(ID);
	return storage;
}

function ValidateInt(input, defVal, minVal, maxVal){

	
	if (typeof(input) != "undefined")  { 
		val = input.value; 
	}
	else return;
	if (val == 0) {
		r = document.getElementById(input.id);
		if (r) {
			setWarnBorder(r, false);
		}
		return val;
	}
	
	if (val && val != '' && val.match(/%$/)) { //Percentage entered
		return val;
	}
	//val = parseInt(val);
	oldval = val;
	if (minVal != '' && maxVal != '') {
		if (val=='' || isNaN(val)) val = defVal;
		else{
			if (!isNaN(minVal)) val = Math.max(minVal, val);
			if (!isNaN(maxVal)) val = Math.min(maxVal, val);
			
		}
	}
	if( isNaN(val) || (val == '' && oldval != '') ) { //something entered that does not end up as a number
		try {
			r = document.getElementById(input.id);
			if (r) {
				setWarnBorder(r, true);
			}
		} catch(e){}
		return 'error';
	} else {
		r = document.getElementById(input.id);
		setWarnBorder(r, false);
		input.value = val; //Set to max default if set.
		return val;
	}
}

function getHexValue(input){
	val = input.value;
	
	if (val == "") {
		r = document.getElementById(input.id);
		if (r) r.style.border = '';
		return val;
	}
	if (val == 'none') return val;
	if (val != 'undefined' && val != '' ) {
		if( val.length != 6 || !val.match(/^[0-9a-f]{6}$/i) ) { //something entered that does not end up as a hexcolor
			r = document.getElementById(input.id);
			if (r) if (r) setWarnBorder(r, true);
			return 'error';
		} else {
			r = document.getElementById(input.id);
			if (r) setWarnBorder(r, false);
			if(build == "html360" || build == "html" || build == "imageflow" || build == "htmlshowcase") {val = "#"+val.toUpperCase();}
			return val;
		}
	}
}

function getRGBAValue(input){
	val = input.value;
	if (val != 'undefined' && val != '' ) {
		if( val.length != 8 || !val.match(/^[0-9a-f]{8}$/i) ) { //something entered that does not end up as a RGBA color
			r = document.getElementById(input.id);
			if (r) setWarnBorder(r, true);
			return 'error';
		} else {
			r = document.getElementById(input.id);
			if (r) setWarnBorder(r, false);
			return val;
		}
	}
}

function setWarnBorder(obj, state){
	if (obj) {
		if (state){
			if (!obj.rescueStyle) obj.rescueStyle = new Object();
			obj.rescueStyle.backgroundColor = getStyle(obj, "backgroundColor");
			obj.style.backgroundColor = '#ff9d9d';
		}
		else {
			try {
				if (obj.rescueStyle) {
					if (obj.rescueStyle.border){
						obj.style.backgroundColor = obj.rescueStyle.backgroundColor;
					}
					else {
						obj.style.backgroundColor = "";
					}
				}
			} catch(e){}
		}
	}
}


function FormValueFromString(el, val){

	var ret;
	try{
		switch (el.type){
			case 'select-one':
				for (var i=0;  i < el.options.length; i++) if (el.options[i].text == val) {
					ret = i;
					break;
				}
			break;
			case 'select-multiple':
				ret = new Array();
				var SelectedOptions  = val.split(",");
				for (var i=0;  i < el.options.length; i++) {
					for (var j=0; j < SelectedOptions.length; j++){
						if (el.options[i].text == SelectedOptions[j]) {
							ret.push(i);
							break;
						}
					}
				}
				ret = ret.join(",");
			break;
			case 'checkbox':
				ret = eval(val);
			break;
			default:
				ret = val;
			break;
		}
	}
	catch(e){}

	return ret;
}


function onPresetChanged(combo){

	try{
		var myform = document[MainFormName];

		var values = combo.options[combo.selectedIndex].value.split(";");
		
		if (values.length > 1){
			for (var i = 1; i < values.length; i++){

				var valuepair = values[i].split("=");
				try{
					var el = myform[valuepair[0]];
					var ElementType = el.type;
					if (ElementType == undefined && el.length > 0) ElementType = el[0].type;
					setFSIFormValue(ElementType, el, FormValueFromString(el, unescape(valuepair[1])));
				}
				catch(e){}
			}
		}
	}
	catch(e){}
}


function getFSIPresetFile(val, dir, prefix, suffix){
		var ret=val;
		try {
			values = ret.split(";");
			if (values.length > 0) {
				ret = values[0];
				if (ret.indexOf("servertemplate:")==0){
					FPXSrcValue = '';
					ret = ret.substr(15, ret.length-15);
					ret = escape(prefix + ret + suffix);
				}
				else if (val.length > 0) ret = dir + ret;
			}
		}
		catch(e){};
		return ret;
}




function showPagesMobile(title) {
	if (browser.webkit == true) {
		var windowHeight = (browser.name=="Safari")? "664":"690";
		
		var options = new Array("toolbar=no","status=no","location=no","menubar=no"); 
			
		// center popup for Safari and Chrome
		if (browser.name == "Chrome" || browser.name == "Safari" && screen && screen.availHeight != undefined){
			var x = Math.round((screen.availWidth - 1024)/2);
			var y = Math.round((screen.availHeight - windowHeight)/2);
			options.push("left="+x);
			options.push("top="+y);
		}
		
		options = options.join(",");
		
		
		updateCode(false,false,true);
		CurrentPreviewWindow = window.open(document.settings.pagesmobilepreviewdata.value, "FSIPagesMobilePreview", "innerWidth=1024,innerHeight="+windowHeight+","+options);
	}
	else {
		interfaceControl.showPublishMessage("Not supported","You need a WebKit based browser like Google Chrome or Apple Safari to preview FSI Pages mobile on a desktop computer.")
	}
}


function updateChangedInput(element, val){
	if (elCropFocus != element && element.value != val) element.value=val;
}

function getStyle(el, prop) {
	try {
		if (document.defaultView && document.defaultView.getComputedStyle) {
			return document.defaultView.getComputedStyle(el, null)[prop];
		}
		else if (el.currentStyle) {
			return el.currentStyle[prop];
		}
		else {
			return el.style[prop];
		}
	}
	catch (e){}
}



	