﻿/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2017 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 1.1
 */

function fsiParser(serviceURL){
	var baseURL = serviceURL + "";

	var xmlHttp = null;
	var licence = null;
	var fsiloaded = false;
	var valid = false;
	var prefsObj = false;
	
	var fsiobject;
	var fsiobjectFiles;
	var xmlrequestkhtml = false;

	var publish = new Array();
	
	this.init = function(){

		fsiobject = new Array();
		fsiobjectFiles = new Array();

		if (typeof XMLHttpRequest != 'undefined') {
			xmlHttp = new XMLHttpRequest();
		}
		// old IE < 7
		if (!xmlHttp) {
			// Internet Explorer <= 6
			try {
				xmlHttp  = new ActiveXObject("Msxml2.XMLHTTP");
			}
			catch(e) {
				try {
					xmlHttp  = new ActiveXObject("Microsoft.XMLHTTP");
				}
				catch(e) {
					xmlHttp  = null;
					valid = false;
				}
			}
		}

		if (navigator.userAgent.match(/Safari/gi) || navigator.userAgent.match(/KHTML/gi)){
			xmlrequestkhtml = true;
		}

	}

	this.getBaseURL = function(){
		return baseURL;
	}

	this.loadDefaultFSI = function(relURL, fileName){
		
		var result = 0;

		if (this.isValid() || fsiloaded == false){
			valid = true;
			result = getFSIXML("default", relURL, fileName);
			if (result == 404) {
				valid = false;
				fsiloaded = false;
			}
			else { valid = true; fsiloaded = true; }
		}
		else printError('Internal State is not valid.');

		return result;
	}

	this.loadFSI = function(relURL, fileName){

		var result = 0;

		if (this.isValid() || fsiloaded == false){
			valid = true;
			result = getFSIXML("fsi", relURL, fileName);
			fsiloaded = true;
		}
		else printError('Internal State is not valid.');

		return result;
	}

	this.addQuery = function(query){
		if (query && query.length > 0){

			var section = "query";
			fsiobject[section] = new Array();

			var queryspl = query.split(/&/);
			if (queryspl && queryspl.length > 0){

				for (var qc = 0; qc < queryspl.length; qc++){
					var cmdspl = queryspl[qc].split(/=/);
					if (cmdspl && cmdspl[0]){
						if (!cmdspl[1]){
							cmdspl[1] = null;
						}

						var cmdmat = cmdspl[0].match(/([\w\d]+)_([\w\d]+)/i);
						var categorie;
						if (cmdmat){
							categorie = cmdmat[1].toLowerCase();
							parameter = cmdmat[2].toLowerCase();
						}
						else {
							categorie = "options";
							parameter = cmdspl[0].toLowerCase();
						}

						if (!fsiobject[section][categorie]){
							fsiobject[section][categorie] = new Array();
						}

						if (parameter != "cfg"){

							if (parameter != "plugins"){

								// exception image
								/*
								cmdmat = parameter.match(/^image([\w\d]+)/i);
								if (cmdmat){
									categorie = "image";
									parameter = cmdmat[1].toLowerCase();
									if (!fsiobject[section][categorie]){
										fsiobject[section][categorie] = new Array();
										fsiobject[section][categorie][parameter]=xmlEncode(cmdspl[1]);
									}
								}
								else {
									fsiobject[section][categorie][parameter]=xmlEncode(cmdspl[1]);
								} */
								fsiobject[section][categorie][parameter]=xmlEncode(cmdspl[1]);
							}
							// load plugins
							else if (cmdspl[1]){
								var pluginload = cmdspl[1].split(/,/);
								if (pluginload){
									for (var pl = 0; pl < pluginload.length; pl++){
										var pluginName = pluginload[pl].toLowerCase();
										if (!fsiobject[section][pluginName]){
											fsiobject[section][pluginName] = new Array();
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	
	
	this.addPlugin = function(pluginName) {
		
		if(typeof(fsiobject["query"]) == 'undefined') {
			fsiobject["query"] = new Array();
		}
		if(typeof(fsiobject["query"][pluginName]) == 'undefined') {
			fsiobject["query"][pluginName] = new Array();
		}
		fsiobject["query"][pluginName]["src"] = true;
	}
	
	this.removePlugin = function(pluginName) {
		if(typeof(fsiobject['query'][pluginName]) != "undefined" && fsiobject['query'][pluginName]['src']) delete(fsiobject['query'][pluginName]['src']);
	}
	
	this.getPublishOptions = function(initial) {
	
		//if(initial) return publish;
		
		publish = new Array();
		
		var opt = document.settings;
		
		Resizable = false;
		if (opt.options_resizeable) Resizable = opt.options_resizeable.checked;
		if (Resizable) publish['options_resizeable'] = "true";
		
		PublishJS = false;
		if (opt.publishjs) PublishJS = opt.publishjs.checked;
		if (PublishJS) publish['publishjs'] = "true";
		
		PublishWrap = false;
		if (opt.publishwrap) PublishWrap = opt.publishwrap.checked;
		if (PublishWrap) publish['publishwrap'] = "true";
		
		publish['options_width'] = opt.options_width.value;
		publish['options_height'] = opt.options_height.value;

		if (opt.effects_quality) publish['effects_quality'] = opt.effects_quality.value;
		if (opt.MoreParams) publish['MoreParams'] = opt.MoreParams.value;
		if (opt.options_skin) publish['options_skin'] = opt.options_skin.value;
		if (opt.options_intro) publish['options_intro'] = opt.options_intro.value;
		if (opt.options_language) publish['options_language'] = opt.options_language.value;
		if (opt.publishwmode) publish['publishwmode'] = opt.publishwmode.value;
		if (opt.param_backgroundcolor) publish['param_backgroundcolor'] = qdata['param_backgroundcolor'] = opt.param_backgroundcolor.value;
		if (opt.options_backgroundcolor) publish['options_backgroundcolor'] = qdata['options_backgroundcolor'] = opt.options_backgroundcolor.value;
		if (opt.options_viewerborder) publish['options_viewerborder'] = qdata['options_viewerborder'] = opt.options_viewerborder.value;
		if (opt.options_roundedskincorners) publish['options_roundedskincorners'] = opt.options_roundedskincorners.value;
		if (opt.Debug) publish['Debug'] = getRadioValue(opt.Debug);
		if (opt.options_htmltitle) publish['options_htmltitle'] = qdata['options_htmltitle'] = opt.options_htmltitle.value;

		if (build=='pages') {
			publish['mobilesupport'] = opt.mobilesupport.checked;
			publish['mobileiossupport'] = opt.mobileiossupport.checked;
			publish['mobileandroidsupport'] = opt.mobileandroidsupport.checked;
			publish['mobiletouchtext'] = opt.mobiletouchtext.value;
			publish['mobilepopupautomode'] = opt.mobilepopupautomode.checked;
		}

		if (build=='imageflow') {
			if (opt.options_elementwidth && opt.options_elementwidth.value != "") publish['options_elementwidth'] = opt.options_elementwidth.value;
			if (opt.options_elementspacing && opt.options_elementspacing.value != "") publish['options_elementspacing'] = opt.options_elementspacing.value;
			if (opt.options_preloadcount) publish['options_preloadcount'] = opt.options_preloadcount.value;
			if (opt.options_autorotatespeed && opt.options_autorotatespeed.value != "") publish['options_autorotatespeed'] = opt.options_autorotatespeed.value;
			if (opt.options_enablescrollbar) publish['options_enablescrollbar'] = getRadioValue(opt.options_enablescrollbar);
			if (opt.options_presentationtype) publish['options_presentationtype'] = opt.options_presentationtype.value;		
			if (opt.options_imageflowheight) publish['options_imageflowheight'] = opt.options_imageflowheight.value;		
			if (opt.options_initialimage) publish['options_initialimage'] = opt.options_initialimage.value;		
			if (opt.options_enablezoom) publish['options_enablezoom'] = getRadioValue(opt.options_enablezoom.value);		
			if (opt.options_centerzoomedimage) publish['options_centerzoomedimage'] = getRadioValue(opt.options_centerzoomedimage.value);		
			if (opt.options_usetouchzoom) publish['options_usetouchzoom'] = getRadioValue(opt.options_usetouchzoom.value);		
			if (opt.options_depthfadeout) publish['options_depthfadeout'] = getRadioValue(opt.options_depthfadeout.value);		
			if (opt.options_zIndexZoom) publish['options_zIndexZoom'] = opt.options_zIndexZoom.value;		
			if (opt.options_paddingtop) publish['options_paddingtop'] = opt.options_paddingtop.value;		
			if (opt.options_paddingbottom) publish['options_paddingbottom'] = opt.options_paddingbottom.value;		
			if (opt.options_cmdbuttonselector) publish['options_cmdbuttonselector'] = opt.options_cmdbuttonselector.value;		
			if (opt.options_garbagecollectionsize) publish['options_garbagecollectionsize'] = opt.options_garbagecollectionsize.value;		
			if (opt.options_placeholderimage) publish['options_placeholderimage'] = opt.options_placeholderimage.value;		
			if (opt.options_placeholderpadeffect) publish['options_placeholderpadeffect'] = opt.options_placeholderpadeffect.value;		
			if (opt.options_autoresize) publish['options_autoresize'] = getRadioValue(opt.options_autoresize.value);		
			if (opt.options_vertical) publish['options_vertical'] = getRadioValue(opt.options_vertical.value);	
			if (opt.options_endlessscrolling) publish['options_endlessscrolling'] = getRadioValue(opt.options_endlessscrolling.value);		
			if (opt.options_autodestroy) publish['options_autodestroy'] = getRadioValue(opt.options_autodestroy.value);		
			if (opt.options_alignment) publish['options_alignment'] = opt.options_alignment.value;		
			if (opt.options_perspectivealignment) publish['options_perspectivealignment'] = opt.options_perspectivealignment.value;		
			if (opt.options_zoomshaderstartopacity) publish['options_zoomshaderstartopacity'] = opt.options_zoomshaderstartopacity.value;		
			if (opt.options_zoomshaderendopacity) publish['options_zoomshaderendopacity'] = opt.options_zoomshaderendopacity.value;		
		}

		if (build=='htmlshowcase') {
			if (opt.imageflow_elementwidth && opt.imageflow_elementwidth.value != "") publish['imageflow_elementwidth'] = opt.imageflow_elementwidth.value;
			if (opt.imageflow_elementspacing && opt.imageflow_elementspacing.value != "") publish['imageflow_elementspacing'] = opt.imageflow_elementspacing.value;
			if (opt.imageflow_preloadcount) publish['imageflow_preloadcount'] = opt.imageflow_preloadcount.value;
			if (opt.imageflow_autorotatespeed && opt.imageflow_autorotatespeed.value != "") publish['imageflow_autorotatespeed'] = opt.imageflow_autorotatespeed.value;
			if (opt.imageflow_enablescrollbar) publish['imageflow_enablescrollbar'] = getRadioValue(opt.imageflow_enablescrollbar);
			if (opt.imageflow_presentationtype) publish['imageflow_presentationtype'] = opt.imageflow_presentationtype.value;		
			if (opt.imageflow_imageflowheight) publish['imageflow_imageflowheight'] = opt.imageflow_imageflowheight.value;		
			if (opt.imageflow_initialimage) publish['imageflow_initialimage'] = opt.imageflow_initialimage.value;		
			if (opt.imageflow_enablezoom) publish['imageflow_enablezoom'] = getRadioValue(opt.imageflow_enablezoom.value);		
			if (opt.imageflow_centerzoomedimage) publish['imageflow_centerzoomedimage'] = getRadioValue(opt.imageflow_centerzoomedimage.value);		
			if (opt.imageflow_usetouchzoom) publish['imageflow_usetouchzoom'] = getRadioValue(opt.imageflow_usetouchzoom.value);		
			if (opt.imageflow_depthfadeout) publish['imageflow_depthfadeout'] = getRadioValue(opt.imageflow_depthfadeout.value);		
			if (opt.imageflow_zIndexZoom) publish['imageflow_zIndexZoom'] = opt.imageflow_zIndexZoom.value;		
			if (opt.imageflow_paddingtop) publish['imageflow_paddingtop'] = opt.imageflow_paddingtop.value;		
			if (opt.imageflow_paddingbottom) publish['imageflow_paddingbottom'] = opt.imageflow_paddingbottom.value;		
			if (opt.imageflow_cmdbuttonselector) publish['imageflow_cmdbuttonselector'] = opt.imageflow_cmdbuttonselector.value;		
			if (opt.imageflow_garbagecollectionsize) publish['imageflow_garbagecollectionsize'] = opt.imageflow_garbagecollectionsize.value;		
			if (opt.imageflow_placeholderimage) publish['imageflow_placeholderimage'] = opt.imageflow_placeholderimage.value;		
			if (opt.imageflow_placeholderpadeffect) publish['imageflow_placeholderpadeffect'] = opt.imageflow_placeholderpadeffect.value;		
			if (opt.imageflow_autoresize) publish['imageflow_autoresize'] = getRadioValue(opt.imageflow_autoresize.value);		
			if (opt.imageflow_vertical) publish['imageflow_vertical'] = getRadioValue(opt.imageflow_vertical.value);	
			if (opt.imageflow_endlessscrolling) publish['imageflow_endlessscrolling'] = getRadioValue(opt.imageflow_endlessscrolling.value);		
			if (opt.imageflow_autodestroy) publish['imageflow_autodestroy'] = getRadioValue(opt.imageflow_autodestroy.value);		
			if (opt.imageflow_alignment) publish['imageflow_alignment'] = opt.imageflow_alignment.value;		
			if (opt.imageflow_perspectivealignment) publish['imageflow_perspectivealignment'] = opt.imageflow_perspectivealignment.value;		
			if (opt.imageflow_zoomshaderstartopacity) publish['imageflow_zoomshaderstartopacity'] = opt.imageflow_zoomshaderstartopacity.value;		
			if (opt.imageflow_zoomshaderendopacity) publish['imageflow_zoomshaderendopacity'] = opt.imageflow_zoomshaderendopacity.value;		
		}

		for (var key in qdata){
			var paramatch = key.match(/^options_(.+)/);
			if(paramatch === null || typeof(paramatch[1]) == "undefined") continue;
			if(paramatch[1].toLowerCase == "cfg" || paramatch[1].toLowerCase == "dir" || paramatch[1].toLowerCase == "imagesource") continue;
			var getid = "options_"+paramatch[1];
			var optitem = document.getElementById(getid);
			if (optitem) {    

				if(optitem.value != "") publish[getid] = optitem.value;

			}
		}

		return publish;
	
	}

	this.isValid = function(){
		return valid;
	}

	this.hasLicence = function(){

		var result = false;
		if (licence != null){
			result = true;
		}

		return result;
	}

	this.getParameterArray = function(diff){

		var narray = new Array();
		var parray = null;

		if (fsiobject){
			if (diff){
				parray = new Array();
				getParameter(fsiobject['default'], parray, null);
				getParameter(fsiobject['fsi'], parray, null);
			}
			else {
				getParameter(fsiobject['default'], narray, null);
				getParameter(fsiobject['fsi'], narray, null);
			}
			//getParameter(fsiobject['fsi'], narray, parray);
			getParameter(fsiobject['query'], narray, parray);
			
		}

		narray = assocKeySort(narray);

		return narray;
	}

	this.getFSIParameterArray = function(){

		var narray = new Array();
		var parray = null;

		if (fsiobject){
			getParameter(fsiobject['fsi'], narray, null);
			getParameter(fsiobject['query'], narray, parray);
		}

		narray = assocKeySort(narray);

		return narray;
	}
	
	this.getEnabledPlugins = function(){

		var narray = new Array();

		if (fsiobject){
			getPlugins(fsiobject['default'], narray);
			getPlugins(fsiobject['fsi'], narray);
			getPlugins(fsiobject['query'], narray);
		}

		return narray;
	}

	this.getDisabledPlugins = function(){

		var narray = new Array();

		if (fsiobject){
			getDisabledPlugins(fsiobject['default'], narray);
			getDisabledPlugins(fsiobject['fsi'], narray);
			getDisabledPlugins(fsiobject['query'], narray);
		}

		var resultArray = new Array();
		for (var key in narray){
			if (narray[key] == false){
				resultArray[key] = true;
			}
		}

		return resultArray;
	}

	this.getXML = function(diff){

		if(diff)
			var narray = fsiparser.getFSIParameterArray(diff);
		else
			var narray = fsiparser.getParameterArray(diff);
		
		return fsiparser.buildXML(narray);

	}
	
	this.wrapInXML = function(theXMLtoBeWrapped){
		var xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
		xml += "<fsi_parameter>\n";
		xml += theXMLtoBeWrapped;
		xml += "\n</fsi_parameter>";
		return xml;
	}

	this.getThumbbarXML = function(){

		var xml = "\t<ThumbBar>\n";
		for (var key in imageflowdata){
			var paramatch = key.match(/^imageflow_(.+)/);//key.match(/^imagepath/); //|^options_(.+)
			if(paramatch === null || typeof(paramatch[1]) == "undefined") continue;
			if(paramatch[1] == "cfg" || paramatch[1] == "dir") continue;
			xml += "\t\t<"+paramatch[1]+" value=\""+imageflowdata[key]+"\"/>\n";
		}
		xml += "\t</ThumbBar>\n";
		return xml;

	}
	
	this.buildXML = function(narray){
		
		
		var xml = "";
		
		// FPX
		var secopen = false;
		var foundsec = false;
		
		for (var key in narray){
			var paramatch = key.match(/^imagepath/);
			if (paramatch){
				foundsec = true;
				if (secopen == false){
					xml += "\n\t<!-- Base Settings -->\n";
					xml += "\t<image>\n";
					secopen = true;
				}
				xml += "\t\t<"+paramatch[1]+" value=\""+narray[key]+"\" />\n";
			}
		}
		if (foundsec){
			xml += "\t</image>\n";
		}
		
		// Plugins
		secopen = false;
		foundsec = false;
		var pluginname = null;
		for (var key in narray){
			var paramatch = key.match(/^(.+?)_(.+)/);
			var penamatch = key.match(/^([a-z0-9]+)$/);
			var cmdparam = null;
			var cmd;
			if (penamatch) cmd=penamatch[1];
			else if (paramatch){
				cmd = paramatch[1];
				cmdparam = paramatch[2];
			}
			if (cmd && cmd != "image" && cmd != "options" && cmd != "thumbbar"){
				foundsec = true;
				if (secopen == false){
					xml += "\n\t<!-- Plugins Configuration -->\n";
					xml += "\t<plugins>\n";
					secopen = true;
				}
				if (pluginname != 'imagepath' && (pluginname == null || pluginname != cmd)){
					if (pluginname != null){
						xml += "\t\t</plugin>\n";
					}
					if (cmdparam){
						xml += "\t\t<plugin src=\""+cmd+"\">\n";
						pluginname = cmd;
					}
					else {
						if (cmd == "imagesources" || cmd == "imagesource") continue;
						xml += "\t\t<plugin src=\""+cmd+"\" />\n";
						pluginname = null;
					}
				}
				if (cmdparam != null && cmdparam != "dir" && cmdparam != "src"){
					xml += "\t\t\t<"+cmdparam+" value=\""+narray[key]+"\" />\n";
				}
			}
		}
		if (foundsec){
			if (pluginname != null){
				xml += "\t\t</plugin>\n";
			}
			xml += "\t</plugins>\n";
		}
		// Options
		var secopen = false;
		var foundsec = false;
		for (var key in narray){
			
			var paramatch = key.match(/^options_(.+)/);
			if (paramatch){
				foundsec = true;
				if (secopen == false){
					xml += "\n\t<!-- Additional Settings -->\n";
					xml += "\t<options>\n";
					secopen = true;
				}
				if (paramatch[1] == 'effects') {
					var theval = narray[key];
					theval = theval.replace("%3D","=");
					xml += "\t\t<"+paramatch[1]+" value=\""+theval+"\" />\n";
					continue;
				}
				if (paramatch[1] != 'imagepath' && paramatch[1] != 'images3durl' && paramatch[1] != 'dir' && paramatch[1].substr(0,6) != "camera" && paramatch[1].substr(0,7) != "hotspot" && paramatch[1].substr(0,5) != "video" && paramatch[1].substr(0,12) != "virtualspace") {
					xml += "\t\t<"+paramatch[1]+" value=\""+narray[key]+"\" />\n";
				}
			}
		}
		
		if (foundsec){
			xml += "\t</options>\n";
		}
		if (build == "html360") xml += fsiparser.getCameraOptionsXML();
		 
		/*
		//PublishOptions
		var secopen = false;
		var foundsec = false;
		var narray = this.getPublishOptions(false);
		for (var key in narray){
			foundsec = true;
			if (secopen == false){
				xml += "\n\t<!-- Publishing Interface Options -->\n";
				xml += "\t<!-- IGNORED by FSI Viewer! -->\n";
				xml += "\t<publish>\n";
				secopen = true;
			}
			
			var validPublishParams = new Array("options_width","options_height","options_debug","options_skin","options_language","options_intro","options_MoreParams","options_navwidth","options_navheight");
			if (!inArray(key,validPublishParams)) continue;
			
			if (narray[key] != "" && key == "MoreParams") xml += "\t\t<"+key+" value=\""+encodeURIComponent(narray[key])+"\" />\n";
			else if (narray[key] != "") xml += "\t\t<"+key+" value=\""+narray[key]+"\" />\n";
		}
			xml += "\t\t<FSIunit value=\""+document.getElementById("FSIunit").value+"\" />\n";
		if (foundsec){
			xml += "\t</publish>\n";
		} */
		
		
		xml += "\n";

		return xml;
	}

	

	this.getCameraOptionsXML = function() {
	
	var camera = "";
	var hotspots = "";
	var hotspots3d = "";
	var video = "";
	var options = "";
	var virtualspace = "";
	var val;
	
	for (var option in paramsfromcfg) {
		if(typeof(qdata[option]) == 'undefined') qdata[option] = paramsfromcfg[option];
	}
	paramsfromcfg = new Array();
	//qdata = qdata.sort(); Das funzt leider nicht
	var saveXML ="";	

	for (var option in qdata) {
		if (option == "Dir") continue;
			something = option.split("_");
			if (something[1] == "cfg" || something[1] == "Dir" || something[1] == "imagesources" || something[1] == "imagesource" || something[1] == "dir" || something[1] == "cropvalues") continue;
			switch(something[0]) {
				case 'camera':
					if(something[1] == "cameraheightcamera" ) camera += "\t\t<heightcamera value=\""+qdata[option]+"\" />\n";
					else camera += "\t\t<"+something[1].replace(/camera/g,"")+" value=\""+qdata[option]+"\" />\n";
				break;
				case 'hotspots':
					hotspots += "\t\t<"+something[1]+" value=\""+qdata[option]+"\" />\n";
				break;
				case 'hotspots3d':
					val = something[1];
					hotspots3d += "\t\t\t<"+val.replace("hotspots3d","")+" value=\""+qdata[option]+"\" />\n";
				break;
				case 'video':
					video += "\t\t<"+something[1].replace(/video/g,"")+" value=\""+qdata[option]+"\" />\n";
				break;
				case 'options':
					options += "\t\t<"+something[1]+" value=\""+qdata[option]+"\" />\n";
				break;
				case 'virtualspace':
					virtualspace += "\t\t<"+something[1].replace(/virtualspace/g,"")+" value=\""+qdata[option]+"\" />\n";
				break;
			}
	}
	
	
	
	if (camera.length > 0) {
			saveXML += "\t<camera>\n";
			saveXML += camera;
			saveXML += "\t</camera>\n";
	}
	if (hotspots.length > 0) {
			saveXML += "\t<hotspots>\n";
			saveXML += hotspots;
			saveXML += "\t</hotspots>\n";
	}
	if (hotspots3d.length > 0) {
			saveXML += "\t<hotspots3d>\n\t\t<defaults>\n";
			saveXML += hotspots3d;
			saveXML += "\t\t</defaults>\n\t</hotspots3d>\n";
	}
	if (video.length > 0) {
			saveXML += "\t<video>\n";
			saveXML += video;
			saveXML += "\t</video>\n";
	}
	if (virtualspace.length > 0) {
			saveXML += "\t<virtualspace>\n";
			saveXML += virtualspace;
			saveXML += "\t</virtualspace>\n";
	}
	
	return saveXML;
}

	this.getUserPrefs = function(serviceBase, type) {
	
		if (!prefsObj) this.loadUserPrefs(serviceBase);
		
		var result = new Array();
		
		for (var i = 0; i < prefsObj.pref.length; i++) {
		  var entry = prefsObj.pref[i];
		  if (entry['@name'] == type) {
			if (typeof(entry.value) == 'string') {
				var obj = new Object();
				var prefvalue = entry.value;
				obj.value = prefvalue;
				obj.label = prefvalue;
				result.push(obj);
			} else {
			  try {
					for (var j = 0; j < entry.value.length; j++) {
						var obj = new Object();
						var prefvalue = entry.value[j];
						obj.value = prefvalue;
						obj.label = prefvalue;
						result.push(obj);
					}
				}
				catch(e) {}
			}
		  }
		}
		
		return result;
	
	}
	
	this.loadFileList = function(pathname, preArray, regexpat){

		var result;
		if (preArray) result = preArray;
		else result = new Array();

		if (xmlHttp){
			try {
				var fullURL = baseURL+pathname;
				xmlHttp.open("GET", fullURL, false);
				xmlHttp.send(null);

				result = parseImageXML(xmlHttp.status, xmlHttp.responseXML, regexpat);
			}
			catch (e) {
			}
		}

		return result;
	}

	this.deleteFile = function(filepath){

		var result=false;

		if (xmlHttp){
			try {
				var fullURL = baseURL+pathname;
				xmlHttp.open("GET", fullURL, false);
				xmlHttp.send(null);
				if (xmlHttp.status == 200) result=true;
			}
			catch (e) {
			}
		}

		return result;

	}
	
	
	this.saveChaptersXML = function(serviceurl, content, encoding){

		var result = 0;

		if (xmlHttp){
			
			var pcontent = "cmd=saveMetaData&";
			if (!encoding) pcontent += "encoding=utf-8&";
			else if (encoding != "") pcontent += "encoding="+encoding+"&";
			pcontent += "fsi.chapters="+encodeURIComponent(content);

			try {
				xmlHttp.open("POST", serviceurl, false);
				xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
				if (!xmlrequestkhtml){
					xmlHttp.setRequestHeader("Content-Length", pcontent.length);
				}
				xmlHttp.setRequestHeader("Connection", "close");
				xmlHttp.send(pcontent);

				result = xmlHttp.status;
				if (result != 200){
					printError("Save Error\n:"+serviceurl);
				}
			}
			catch (e) {
				printError("Save Error\n:"+serviceurl+"\n"+e);
			}
		}

		return result;
	}
	
	
	this.deleteChapters = function(serviceurl){

		var result = 0;

		if (xmlHttp){
			
			var pcontent = "cmd=deleteMetaData&fsi.chapters=";

			try {
				xmlHttp.open("POST", serviceurl, false);
				xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
				if (!xmlrequestkhtml){
					xmlHttp.setRequestHeader("Content-Length", pcontent.length);
				}
				xmlHttp.setRequestHeader("Connection", "close");
				xmlHttp.send(pcontent);

				result = xmlHttp.status;
				if (parseInt(result) != parseInt(200)){
					printError("Save Error\n:"+serviceurl);
				}
			}
			catch (e) {
				printError("Save Error\n:"+serviceurl+"\n"+e);
			}
		}

		return result;
	}
	
	
	this.saveFSI = function(serviceurl, fileName, content, encoding){

		var result = 0;

		if (xmlHttp){
			
			try {
				xmlHttp.open("POST", serviceurl+fileName, false);
				var boundary=Math.random().toString().substr(2);
                //xmlHttp.setRequestHeader("Connection", "close");

				xmlHttp.setRequestHeader("Content-Type", "multipart/form-data; charset=utf-8; boundary=" + boundary);

                var body = '\r\n';
				body += '--' + boundary + '\r\n' + 'Content-Disposition: form-data; name="';
				body += "data";
				body += '"; filename="xy"\r\n\r\n';
				body += content;
				body += '\r\n'
				body += '--' + boundary + '--';

                xmlHttp.send(body); 

				result = xmlHttp.status;
				
			}
			catch (e) {
				printError("Save Error 2\n:"+fileName+"\n"+e);
			}
		}

		return result;
	} 
	
	
	this.loadChapters = function(loadName){

		var result = new Array();

		if (xmlHttp){
			try {
				var fullURL = baseURL.substr(0,baseURL.length-7)+'server?type=info&source='+loadName+"&tpl=chapters.xml&headers=webinterface";
				xmlHttp = new XMLHttpRequest(); //Chrome Bug response XML = null
				xmlHttp.open("GET", fullURL, false);
				xmlHttp.send(null);
				result = parseChapterXML(xmlHttp.status, xmlHttp.responseXML);
			}
			catch (e) {
			}
		}

		return result;

	}

	this.saveChapters = function(serviceurl, cList){

		var xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

		xml += "<indexdata>\n";
		for (var c = 0; c < cList.length; c++){
			xml += "<index";
			if (cList[c].title) xml += ' label="'+xmlEncode(cList[c].title)+'"';
			if (cList[c].title) xml += ' page="'+parseInt(cList[c].pagenum)+'"';
			xml += "/>\n";
		}
		xml += "</indexdata>";

		return this.saveChaptersXML(serviceurl, xml);

	}

	this.dumpInternal = function(){

		var result = "";

		if (fsiobject){
			for (var fsifile in fsiobject){
				result += "FILE:"+fsifile+"\n"+dumpLine(80);
				for (var section in fsiobject[fsifile]){
					result += "SECTION:"+section+"\n";
					for (var paramName in fsiobject[fsifile][section]){
						var paramValue = fsiobject[fsifile][section][paramName];
						result += paramName+"="+paramValue+"\n";
					}
					result += dumpLine(20);
				}
			}
		}

		return result;
	}

	this.dumpNArray = function(narray){

		var result = "";

		for (var nkey in narray){
			result += nkey+" = "+narray[nkey]+"\n";
		}

		return result;
	}

	/*
	 * Privates
	 */

	dumpLine = function(len){
		var result="";
		for (var c=0; c<len; c++) result+="-";
		return result+="\n";
	}


	getFSIXML = function(section, relURL, fileName){

		var result = 0;
		if (fileName.substring(fileName.length-4) != ".xml") fileName += ".xml"; //append suffix if missing.

		if (xmlHttp){
			try {
				var fullURL = "";
				
				if (relURL != null) fullURL = relURL + fileName + "?headers=webinterface";
				else fullURL = fileName;
				
				//ffDump("getFSIXML: "+fullURL);
				
				xmlHttp.open("GET", fullURL, false);
				if (xmlHttp.overrideMimeType)	xmlHttp.overrideMimeType("application/xml");
				xmlHttp.setRequestHeader("Accept", "application/xml");
				
				
				xmlHttp.send(null);
				if (build == "html360") result = parseSpin360XML(xmlHttp.status, section, fullURL, xmlHttp.responseXML);
				//if (build == "imageflow") result = parseThumbbarXML(xmlHttp.status, section, fullURL, xmlHttp.responseXML);
				if (build == "htmlshowcase") {
					result = parseThumbbarXML(xmlHttp.status, section, fullURL, xmlHttp.responseXML);
					result = parseFSIXML(xmlHttp.status, section, fullURL, xmlHttp.responseXML);
				}
				else result = parseFSIXML(xmlHttp.status, section, fullURL, xmlHttp.responseXML);
				fsiobjectFiles[section]=fileName;

			}
			catch (e) {
				printError("Load:"+fileName+"\n"+e);
			}
		}

		return result;
	}


	parseFSIXML = function(state, section, geturl, xmlobj){
		
		if (state == 200){
			if (xmlobj){
				var roots = xmlobj.getElementsByTagName("fsi_parameter");
				if (roots && roots.length > 0){
					fsiobject[section]=new Object();
					// save section to file
					fsiobjectFiles[section]=geturl;

					// Scan for categories
					for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
						var cnpnode = roots[0].childNodes[cnp];
						if (cnpnode.nodeType == 1){
							// Known Subnodes
							var nodeName = cnpnode.nodeName.toLowerCase();
							if (isValidFSISubNode(nodeName)){
								// licence
								if (nodeName == "licence" && cnpnode.childNodes && cnpnode.childNodes[0].nodeType == 3){
									licence = cnpnode.childNodes[0].value;
								}
								// other subnodes
								else {
									var categorie = nodeName;
									var catnodes = cnpnode.childNodes;

									if (categorie == 'publish'){ //categorie == 'viewer' || 
										// ignore obsolete section
									}
									else if (categorie != 'plugins'){
										if (!fsiobject[section][categorie]){
											fsiobject[section][categorie] = new Array();
										}

										// scan for plugin_parameter
										var optionmode;
										if (categorie == 'options') optionmode = true;
										else optionmode = false;

										var categorieover = null;

										for (var cn = 0; cn < catnodes.length; cn++){
											var cnnode = catnodes[cn];
											var parameter = cnnode.nodeName.toLowerCase();
											if (cnnode.nodeType == 1 && cnnode.attributes && cnnode.attributes.length > 0 && parameter != "cfg"){
												for (var cna = 0; cna < cnnode.attributes.length; cna++){
													var attr = cnnode.attributes[cna].nodeName.toLowerCase();
													if (attr == 'value'){

														if (optionmode){

															// scan for plugin_parameter
															var cmdmat = parameter.match(/([\w\d]+)_([\w\d]+)/i);
															if (cmdmat){
																categorieover = cmdmat[1].toLowerCase();
																parameter = cmdmat[2].toLowerCase();
																if (!fsiobject[section][categorieover]){
																	fsiobject[section][categorieover] = new Array();
																}
															}
															else {
																// exception fpx
																cmdmat = parameter.match(/^image([\w\d]+)/i);
																if (cmdmat){
																	categorieover = "image";
																	parameter = cmdmat[1].toLowerCase();
																	if (!fsiobject[section][categorieover]){
																		fsiobject[section][categorieover] = new Array();
																	}
																}
															}
														}

														if (!categorieover){
															fsiobject[section][categorie][parameter]=cnnode.attributes[cna].value;
														}
														else {
															fsiobject[section][categorieover][parameter]=cnnode.attributes[cna].value;
															categorieover = null;
														}
													}
												}
											}
										}
									}
									// Plugins Section
									else {
										var catnodes = cnpnode.childNodes;
										for (var cn = 0; cn < catnodes.length; cn++){
											var cnnode = catnodes[cn];
											if (cnnode.nodeType == 1 && cnnode.attributes && cnnode.attributes.length > 0){
												var pluginName = null;
												for (var cna = 0; cna < cnnode.attributes.length; cna++){
													var attr = cnnode.attributes[cna].nodeName.toLowerCase();
													var attrval = cnnode.attributes[cna].value;
													if (attr == 'src'){
														pluginName = attrval.toLowerCase();
														if (!fsiobject[section][pluginName]) fsiobject[section][pluginName]=new Array();
														fsiobject[section][pluginName]['src'] = true; //set to determine if activated or parameter only!
													}
													// Plugin Attr Parameter
													else if (pluginName){
														if (!fsiobject[section][pluginName]) fsiobject[section][pluginName]=new Array();
														if (!fsiobject[section][pluginName][attr]) fsiobject[section][pluginName][attr]=new Array();
														fsiobject[section][pluginName][attr]=attrval;
													}
												}
												if (pluginName){
													// Subnodes
													for (var cns = 0; cns < cnnode.childNodes.length; cns++){
														var cnsnode = cnnode.childNodes[cns];
														if (cnsnode.nodeType == 1 && cnsnode.attributes && cnsnode.attributes.length > 0){
															var paramName = cnsnode.nodeName.toLowerCase();

															for (var cnsa = 0; cnsa < cnsnode.attributes.length; cnsa++){
																var attrsub = cnsnode.attributes[cnsa].nodeName.toLowerCase();
																var attrsubval;
																if (attrsub == 'value'){
																	attrsubval = cnsnode.attributes[cnsa].value;
																}
																if (attrsubval == "") attrsubval=null;

																if (!fsiobject[section][pluginName]) fsiobject[section][pluginName]=new Array();
																if (!fsiobject[section][pluginName][paramName]) fsiobject[section][pluginName][paramName]=new Array();
																fsiobject[section][pluginName][paramName]=attrsubval;

															}
														}
													}
												}
											}
										}
									}
								}
							}
							else {
								printError(geturl+"\nInvalid Node "+nodeName);
							}
						}
					}
				}
				else {
					printError('No valid FSI File ' + geturl);
				}
			}
		}
		else {
			printError(geturl+"\nHTTP Status: "+state);
		}
		/*
		//Publish Options 
			publish = new Array();
			var roots = xmlobj.getElementsByTagName("publish");
			if (roots && roots.length > 0){
				for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
					var cnpnode = roots[0].childNodes[cnp];
					if (cnpnode.nodeType == 1){
						publish[cnpnode.tagName] = cnpnode.attributes[0].value;//.firstChild.wholeText;
					}
					if (cnpnode.nodeType == 3){
					//	publish[''+cnpnode.nextSibling+''] = cnpnode.nextSibling.attributes[0].textContent;
					}
				}
			}
	*/		
		return state;
	}


	parseImageXML = function(state, xmlobj, regexpat){

		var ri = 0;
		var result = new Array();

		if (state == 200){

			if (xmlobj){
				var roots = xmlobj.getElementsByTagName("images");
				if (roots && roots[0]){

					// Scan for categories
					for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
						var cnpnode = roots[0].childNodes[cnp];
						if (cnpnode.nodeType == 1){
							var nodeName = cnpnode.nodeName.toLowerCase();
							if (nodeName == "image"){
								var obj = new Object();
								for (var cna = 0; cna < cnpnode.attributes.length; cna++){
									var attr = cnpnode.attributes[cna].nodeName.toLowerCase();
									var attrval = decodeURIComponent(cnpnode.attributes[cna].value);
									if (attr == 'name'){
										if (regexpat){
											var regexres = new RegExp(regexpat);
											if (regexres.test(attrval)){
												obj.label = attrval;
											}
										}
										else {
											obj.label = attrval;
										}
									}
									else if (attr == 'src'){
										obj.value = attrval;
									}
								}
								if (obj && obj.label){
									result[ri++] = obj;
								}
							}
						}
					}
				}
				else {
					printError('No valid XML Response');
				}
			}
		}
		else {
			printError(geturl+"\nHTTP Status: "+state);
		}

		return result;
	}


	parseChapterXML = function(state, xmlobj){

		var ri = 0;
		var result = new Array();

		if (state == 200){

			if (xmlobj){
				var roots = xmlobj.getElementsByTagName("indexdata");
				if (roots && roots[0]){

					// Scan for categories
					for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
						var cnpnode = roots[0].childNodes[cnp];
						if (cnpnode.nodeType == 1){
							var nodeName = cnpnode.nodeName.toLowerCase();
							if (nodeName == "index"){
								result[ri] = new Object();
								for (var cna = 0; cna < cnpnode.attributes.length; cna++){
									var attr = cnpnode.attributes[cna].nodeName.toLowerCase();
									var attrval = cnpnode.attributes[cna].value;
									if (attr == 'label'){
										result[ri].label = attrval;
									}
									else if (attr == 'page'){
										result[ri].page = attrval;
									}
								}
								ri++;
							}
						}
					}
				}
				else {
					printError('No valid XML Response');
				}
			}
		}
		else {
			printError(geturl+"\nHTTP Status: "+state);
		}

		return result;
	}


	getParameter = function(fileobj, narray, parray){

		if (fileobj){
			for (var section in fileobj){

				if (assocSize(fileobj[section]) > 0){

					for (var parameter in fileobj[section]){
						if (section == "image"){
							if (parray == null || !parray[section+parameter] || parray[section+parameter] != fileobj[section][parameter]){
								narray[section+parameter]=fileobj[section][parameter];
							}
						}
						else if (section != "options" && section != "publish"){ // plugins
							if (parray == null || !parray[section+"_"+parameter] || parray[section+"_"+parameter] != fileobj[section][parameter]){
								narray[section+"_"+parameter]=fileobj[section][parameter];
							}
						}
					}
					// Options nochmal durchgehen
					for (var parameter in fileobj[section]){
						if (section == "options"){
							if (!fileobj[parameter]){
								if (parray == null || !parray[section+"_"+parameter] || parray[section+"_"+parameter] != fileobj[section][parameter]){
									narray[section+"_"+parameter]=fileobj[section][parameter];
								}
							}
						}
					}
				}
				else if (!narray[section]){
					// prevent load only
					var pass = true;
					for (var vkey in narray){
						var vkeyregex = new RegExp("^"+section+"_");
						if (vkeyregex.test(vkey)){
							pass = false;
							if (narray[section] && narray[section] == true){
								delete narray[section];
							}
							break;
						}
					}
					if (pass == true){
						narray[section]=true;
					}
				}
			}

			// options nochmal durchgehen
			for (var section in fileobj){
				if (section == "options"){
					for (var parameter in fileobj[section]){
						if (narray[parameter]){
							var value = fileobj[section][parameter].toLowerCase();
							if (value == "false" || value == "0"){
								delete narray[parameter];
							}
						}
					}
				}
			}
		}
	}


	getPlugins = function(fileobj, narray){

		if (fileobj){
			for (var section in fileobj){
				var sub = fileobj[section];
				if (section != "options" && section != "image"){
					if( sub['src']) narray[section]=true;
				}
			}
			// options nochmal durchgehen
			for (var section in fileobj){
				if (section == "options"){
					for (var parameter in fileobj[section]){
						if (narray[parameter]){
							var value = fileobj[section][parameter].toLowerCase();
							if (value == "false" || value == "0"){
								delete narray[parameter];
							}
						}
					}
				}
			}
		}
	
	}

	getDisabledPlugins = function(fileobj, narray){

		if (fileobj){
			for (var section in fileobj){
				var sub = fileobj[section];
				if (section != "options" && section != "image"){
					if( sub['src']) narray[section]=true;
				}
			}
			for (var section in fileobj){
				if (section == "options"){
					for (var parameter in fileobj[section]){
						if (narray[parameter] != undefined){
							var value = fileobj[section][parameter].toLowerCase();
							if (value == "false" || value == "0"){
								narray[parameter] = false;
							}
							else if (value == "true" || value == "1"){
								narray[parameter] = true;
							}
						}
					}
				}
			}
		}
	}


	xmlEncode = function(str){
		if(typeof(str) == undefined) return "";
		if(str == null) return ""; //IE ftw
		str = str.replace(/&/g, "&amp;");
		str = str.replace(/</g, "&lt;");
		str = str.replace(/>/g, "&gt;");
		str = str.replace(/\"/g, "&quot;");
		str = str.replace(/\'/g, "&apos;");

		return str;
	}

	smallEncode = function(str){
		str = str.replace(/,/g, "%2C");
		str = str.replace(/\//g, "%2F");
		str = str.replace(/\?/g, "%3F");
		str = str.replace(/:/g, "%3A");
		str = str.replace(/@/g, "%40");
		str = str.replace(/&/g, "%26");
		str = str.replace(/=/g, "%3D");
		str = str.replace(/\+/g, "%2B");
		str = str.replace(/\$/g, "%24");

		return str;
	}

	

	isValidFSISubNode = function(nodeName){

		var result = false;

		switch (nodeName){
			case 'licence':
			case 'image':
			case 'options':
			case 'viewer':
			case 'if':
			case 'quickzoom':
			case 'publish':
			case 'plugins':
			case 'viewer':
			case 'thumbbar':
				result = true;
				break;
		}

		return result;
	}

	assocKeySort = function(oAssoc) {
		var arVal=[];
		var arValKey=[];
		var oRes = {};

		for (var key in oAssoc) {
			arVal[arVal.length] = key;
		}
		arVal.sort();
		for (var idx in arVal){
			oRes[arVal[idx]] = oAssoc[arVal[idx]];
		}
		return oRes;
	}

	assocSize = function(aAssoc){
		var len = 0;
		for (var key in aAssoc) len++;
		return len;
	}

	printError = function(message){
		//alert("FSI Parser\n"+message);
		try{
			ffDump("FSIParser> ERROR!");
			ffDump(message);
		} catch(e){}
	}

}

if (!this.bNativeJSON){

        JSON = new Object();
        JSON.parse = function(str){
                eval("var ret="+str);
                return ret;
        }
}


parseSpin360XML = function(state, section, geturl, xmlobj){
	
	if (state == 200){
		
		camera = new Array();
		var roots = xmlobj.getElementsByTagName("camera");
		if (roots && roots.length > 0){
			for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
				var cnpnode = roots[0].childNodes[cnp];
				if (cnpnode.nodeType == 1){
					camera[cnpnode.tagName] = cnpnode.attributes[0].value;//.firstChild.wholeText;
					var tag = cnpnode.tagName.toLowerCase();
					tag = tag.replace(/camera/g,"");
					if (tag=="height") tag = "heightcamera";
					f = document.getElementById("camera_camera"+tag);
						if (f) {
							setFSIFormValue("camera_camera"+tag,cnpnode.attributes[0].value);
							paramsfromcfg["camera_camera"+tag] = cnpnode.attributes[0].value; //save
						}
				}
			}
		}
		
	//hotspots Options 
		hotspots = new Array();
		var roots = xmlobj.getElementsByTagName("hotspots");
		if (roots && roots.length > 0){
			for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
				var cnpnode = roots[0].childNodes[cnp];
				if (cnpnode.nodeType == 1){
					hotspots[cnpnode.tagName] = cnpnode.attributes[0].value;//.firstChild.wholeText;
					var tag = cnpnode.tagName.toLowerCase();
					f = document.getElementById("hotspots_"+tag);
						if (f) {
							setFSIFormValue("hotspots_"+tag,cnpnode.attributes[0].value);
							paramsfromcfg["hotspots_"+tag] = cnpnode.attributes[0].value; //save
						}
					
				}
			}
		}
		
	//video Options 
		video = new Array();
		var roots = xmlobj.getElementsByTagName("video");
		if (roots && roots.length > 0){
			for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
				var cnpnode = roots[0].childNodes[cnp];
				if (cnpnode.nodeType == 1){
					video[cnpnode.tagName] = cnpnode.attributes[0].value;//.firstChild.wholeText;
					var tag = cnpnode.tagName.toLowerCase();
					tag = tag.replace(/video/g,"");
					f = document.getElementById("video_video"+tag);
						if (f) {
							setFSIFormValue("video_video"+tag,cnpnode.attributes[0].value);
							paramsfromcfg["video_video"+tag] = cnpnode.attributes[0].value; //save
						}
				}
			}
		}
		
	//virtualspace Options 
		virtualspace = new Array();
		var roots = xmlobj.getElementsByTagName("virtualspace");
		if (roots && roots.length > 0){
			for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
				var cnpnode = roots[0].childNodes[cnp];
				if (cnpnode.nodeType == 1){
					virtualspace[cnpnode.tagName] = cnpnode.attributes[0].value;//.firstChild.wholeText;
					var tag = cnpnode.tagName.toLowerCase();
					tag = tag.replace(/virtualspace/g,"");
					f = document.getElementById("virtualspace_virtualspace"+tag);
						if (f) {
							setFSIFormValue("virtualspace_virtualspace"+tag,cnpnode.attributes[0].value);
							paramsfromcfg["virtualspace_virtualspace"+tag] = cnpnode.attributes[0].value; //save
						}
				}
			}
		}
		
	//options Options 
		options = new Array();
		var roots = xmlobj.getElementsByTagName("options");
		if (roots && roots.length > 0){
			for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
				var cnpnode = roots[0].childNodes[cnp];
				if (cnpnode.nodeType == 1){
					options[cnpnode.tagName] = cnpnode.attributes[0].value;//.firstChild.wholeText;
					var tag = cnpnode.tagName.toLowerCase();
					if(tag == "dir") continue;
					if(tag == "imagesources") continue;
					if(tag == "imagesource") continue;
					if(tag == "cropvalues") continue;
					f = document.getElementById("options_"+tag);
						if (f) {
							setFSIFormValue("options_"+tag,cnpnode.attributes[0].value);
							paramsfromcfg["options_"+tag] = cnpnode.attributes[0].value; //save
						}
				}
			}
		}
		

	//hotspots3d Options 
		hotspots3d = new Array();
		var roots = xmlobj.getElementsByTagName("hotspots3d");
		if (roots && roots.length > 0){
				
			for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
				var cnpnode = roots[0].childNodes[cnp];
				if (cnpnode.nodeName == 'defaults'){
					
					var params = cnpnode.childNodes;
					for (var pc = 0; pc < params.length; pc++){
			
						var pnode = params[pc];
						if (pnode.nodeType == 1){
							hotspots3d[pnode.tagName] = pnode.attributes[0].value;//.firstChild.wholeText;
							var tag = pnode.tagName.toLowerCase();
							f = document.getElementById("hotspots3d_hotspots3d"+tag);
							if (f) {
								setFSIFormValue("hotspots3d_hotspots3d"+tag,pnode.attributes[0].value);
								paramsfromcfg["hotspots3d_"+tag] = pnode.attributes[0].value; //save
							}
						}
					}
					
				}
			
			}
		}
		/*
		//Publish Options 
			publish = new Array();
			var roots = xmlobj.getElementsByTagName("publish");
			if (roots && roots.length > 0){
				for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
					var cnpnode = roots[0].childNodes[cnp];
					if (cnpnode.nodeType == 1){
						setFSIFormValue(cnpnode.tagName,cnpnode.attributes[0].value);
						publish[cnpnode.tagName] = cnpnode.attributes[0].value;//.firstChild.wholeText;
					}
					if (cnpnode.nodeType == 3){
					//	publish[''+cnpnode.nextSibling+''] = cnpnode.nextSibling.attributes[0].textContent;
					}
				}
			} */
		
	}
	else {
		printError(geturl+"\nHTTP Status: "+state);
	}

	
	
	return state;
}



parseThumbbarXML = function(state, section, geturl, xmlobj){
	
	if (state == 200){
		
		//options Options 
		options = new Array();
		var roots = xmlobj.getElementsByTagName("ThumbBar");
		if (roots.length <= 0) roots = xmlobj.getElementsByTagName("options");
		if (roots && roots.length > 0){
			for (var cnp = 0; cnp < roots[0].childNodes.length; cnp++){
				var cnpnode = roots[0].childNodes[cnp];
				if (cnpnode.nodeType == 1){
					options[cnpnode.tagName] = cnpnode.attributes[0].value;//.firstChild.wholeText;
					if (cnpnode.tagName == "effects") effectsfromcfg = cnpnode.attributes[0].value;
					var tname = cnpnode.tagName;
					tname = tname.toLowerCase();
					f = document.getElementById("imageflow_"+tname);
						if (f) {
							setFSIFormValue("imageflow_"+tname,cnpnode.attributes[0].value);
							//imageflowdata["imageflow_"+tname] = cnpnode.attributes[0].value; //save
						} else {
							/*
							f = document.getElementById("options_"+tname);
							if (f) {
								setFSIFormValue("options_"+tname,cnpnode.attributes[0].value);
								qdata["options_"+tname] = cnpnode.attributes[0].value; //save
							}
							*/
						}
				}
				//if (cnpnode.nodeType == 3){
				//	options[''+cnpnode.nextSibling+''] = cnpnode.nextSibling.attributes[0].textContent;
				//}
			}
		}
		
		
		
	}
	else {
		printError(geturl+"\nHTTP Status: "+state);
	}

	
	
	return state;
}


// Copyright 2017 NeptuneLabs GmbH (http://www.neptunelabs.com)
