/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2017 NeptuneLabs GmbH - All rights reserved.
 *
 */
 var _updatetimer;
 var uniqueID = false;
 var FSIPages;
 var FSITouchZoom;
 var oldPWidth;
 var oldPHeight;
 var boPSC = false; 
 var plugins = new Array();
 
 
if (!fsiparser) {
	fsiparser = new fsiParser(fsirooturl);
}
if (fsiparser.init) fsiparser.init();
else interfaceControl.showPublishMessage("Error","FSI Parser initialisation error");

var currentColor = Colors.ColorFromRGB(64,128,128);
CurrentPreviewWindow = false;
oldPreviewWindowWidth = oldPreviewWindowHeight = -1;
colorPickerVisible = false;
var query='';
var moreoptions = false;
var bPublishFromDirSelection;
var currentColor = Colors.ColorFromRGB(255,255,255);
var fsiparser;
var fsiparser_basepath = fsirooturl;
var relSectionPath = 'viewer3d_presets';
var fsiparser_presetpath = fsiparser_basepath+'config/pages_presets';
var opt = document.settings;

if (interfaceControl.isBasePath3DDirectories()) bPublishFromDirSelection = true; 			
else bPublishFromDirSelection = (interfaceControl.getThumbView().getSingleSelectedItemType() == "directory");


function getDir() {

	var dir = new Array();
	dir[0] = 'options_Dir';

	var entry = interfaceControl.getThumbView().getFirstSelectedThumb();
	if (entry && entry.type == 'directory') { dir[1] = interfaceControl.escapeXML(decodeURIComponent(entry.fullsrc)); 
	} else {
	dir[1] = interfaceControl.getBasePath();
	qdata["options_Dir"] = dir[1];
	}
	return dir;
}


function scrollTextArea(from,to) {
	from.onscroll = function (evt) {
		to.scrollTop = this.scrollTop;
	}
}

function toggleView(elid) {
	var theThing = document.getElementById(elid);

	if (theThing && theThing.style.display == "block" && qdata['pages_pagelayout'] == 'flip') {
		theThing.style.display = "none";	
	} 
	else theThing.style.display = "block";
}

function  initit() {
	
	loadJSFiles('pages');
	loadJSFiles('touchzoom');

	var publishingsettings = "";
	if (typeof(interfaceControl.PublishData[build+'_PUBLISHING']) != "undefined") publishingsettings = interfaceControl.PublishData[build+'_PUBLISHING'].value;

	initGlobal();
	v = getDir();
	
	setDirImageValue(v[1]);
	initPluginButtons();
	cfg = interfaceControl.getPublishingView().getPresetFile();
	if (cfg != '' && typeof cfg != 'undefined') { 
		qdata['cfg'] = cfg;
	} else {
		qdata['cfg'] = ''; 
	}
	
	fsiparser.loadDefaultFSI(fsiparser_basepath, '_default.xml');
	
	if (qdata["cfg"] != "") {
		loadSelectedConfig(qdata["cfg"]);
	} else delete qdata["cfg"];
	
	preUpdateInterface(build);
	RestoreParameterValues(build);
	setInitialDimensions();
	fsiparser.getPublishOptions();

	addEvent(window,"resize",resizePreview);
	addEvent(window,"unload",removeResizePreview);

	restorePublishingSettings(publishingsettings);

	toActive('1', 'false');
	enableRatio();
	//changeDimensionOnRatio()
	appendEffectNodes(); 
	getFirstDimensions();
}  
  
  
function toActive(o,skipupdate) {

	/*if (typeof(forceupdate) == 'undefined') {
		var focEle = document.getElementById("updateFocus"); //Must be done before updateCode!
		if (focEle){
			focEle.focus();
		}
	} */
		
	if (o=='7' || o=='6') {
		document.body.className = "grey";
		updateCrop(true); 
		initCrop();
		bindCropHelper(true);
	}
	else {
		document.body.className = "";
		bindCropHelper(false);
	}

	if ( colorPickerVisible ) hideCP('false');
	if ( helpvisible ) closeHelp();
	
	var iframe = parent.document.getElementById("iFramePublish");
	var p = document.getElementById('preview');
	var px = document.layers ? "" : "px";
	
	if( document.settings.FSIunit.value=="pc" ) px="%";
	
	for (x=0; x<divs.length+1; x++) { // 8
		hide(divs[x]);
		hide('div' + x);
		changeImages(divs[x],'inactive');
	}

	show('div' + o);
	if (o=="5") updateEffectThumbs();
	if (o=='6' || o =='7') { //Preview
		
		if(document.settings.FSIunit.value=="pc") px="%";
		
		var new_w = preview_saved_width = save_width = document.settings.FSIwidth.value;
		var new_h = preview_saved_height = save_height = document.settings.FSIheight.value;
		var maxWidth = iframe.offsetWidth - 50;
		var maxHeight = iframe.offsetHeight - 50;
		
		//set current settings
		p.style.width=new_w+""+px;
		p.style.height=new_h+""+px;
		p.style.display="block";
		
		try {
			document.getElementById("size_notification").innerHTML = '';
		}catch(e){}
		
		if(px!="%") {
			//calc preview dimensions if custom dimension exceed viewport
			if (save_height > maxHeight) {
				try {		
					var entry = oPreviewEntry;
				
					//var maxWidth = parseInt(interfaceControl.getPublishingView().getDimension().width) - 20;
					var aspectX = maxWidth / entry.width;
					var aspectY = maxHeight / entry.height;

					if (aspectX < aspectY){
						if (entry.width < maxWidth) new_w = entry.width;
						else new_w = maxWidth;
						new_h = Math.round(new_w * entry.height / entry.width);
						
					}
					else {
						if (entry.height < maxHeight) new_h = entry.height;
						else new_h = maxHeight;
						if (build=="pages") new_w = Math.round(new_h * entry.width / entry.height);
					}
					if(build=="pages") new_w = parseInt(new_w*1.4);
				} catch (e) {
					new_w = 700;
					new_h = maxHeight - 60;
				}
				
				try {
					if (build != 'html') document.getElementById("size_notification").innerHTML = 'The preview size has been reduced to fit the current viewport.';			
				}catch(e){}
			}
		}
		//exit if no change in dimensions && nochange in aktivediv
		if (!boPSC && preview_saved_width == new_w && preview_saved_height == new_h && aktiveDiv == o && typeof(forceupdate) == 'undefined') { 					
			show('div' + o);
			return;
		} 
		
		if (p) { 
			if (px == "%") {
				new_h=Math.round(parseInt(interfaceControl.getPublishingView().getDimension().height)/100*new_h-100);
				new_w=Math.round(parseInt(interfaceControl.getPublishingView().getDimension().width)/100*new_w-20);
				p.style.width=new_w+"px";
			    p.style.height=new_h+"px";
			} else {
				p.style.width=new_w+px;
				p.style.height=new_h+px;
			}
			p.style.display="block";
			writePreviewURL("preview_notification");
			initPreview();
		}
	
	} else {
		p.style.width = 750 + px;
	}
	oldPWidth = new_w;
	oldPHeight = new_h;
	
	aktiveDiv = o;
	updateCode(true);

	if (o == '5'){
		if (typeof(resizeEffectsTable) == "function") resizeEffectsTable();
	}

	return true;

}



function checkJPEGType() {
	if (document.getElementById('image_format').value.toLowerCase() == 'jpeg' ||  document.getElementById('image_format').value.toLowerCase() == 'overlay') {
		if (document.getElementById('effects_compression').value.toLowerCase() == '0') {
			compressionslider.setMaximum(100);
			compressionslider.setValue(95);
			compressionslider.recalculate();
		}
	}
}


function toggleActivity(id) {
	
	for(x=0;x<aEffects.length;x++) {
					
		var currentEffect = aEffects[x].split("\",\"");
		
		var name = currentEffect[0].split("\":\"");
		name = name[1].replace(/"/,"");
		
		var pa = document.getElementById('effect_'+name);
		if (!pa) continue;
		el = pa.childNodes[0];
		el.className = "effectDialogTitleNonActive";
		
	}
	
	el = id.childNodes[0];
	
	if(el.className == "effectDialogTitleNonActive") {
		el.className="effectDialogTitleActive";
	}
	else
	if(el.className == "effectDialogTitleActive") {
		el.className="effectDialogTitleNonActive";
	}

}


function doResizePreview() {

	if (typeof(resizeEffectsTable) == "function") resizeEffectsTable();

	if (interfaceControl.getPublishingView().getDimension().height == -1) return;
	
	if (aktiveDiv == '5') { if (document.getElementById("effectsContainer").innerHTML == "") { appendEffectNodes(); }} //may vanish?!
	if (aktiveDiv == '6') toActive('6');
	if (aktiveDiv == '7') updateCrop(); 
	
}

function updateCode() {
	
	var opt=document.settings;
	
	var imgurl = getSSImage(opt.FSIwidth.value, opt.FSIheight.value, false, false, false);
	if(imgurl == false) return;
	
	var alt = "";
	try {
		alt = getPublishImageEntry().src;
	}  catch(e) {}
	
	imgtag = wrapinXHTML();
	
	try 
	{
		var unit=document.settings.FSIunit.value;
		if (unit == "pc") unit = "%";
		if (unit == "px") unit = "";
		opt.htmldata.value = imgtag; 
		opt.dirvalue.value = imgurl;
		opt.previewdata.value = '<div id="'+getUniqueID()+'" style="width:'+opt.FSIwidth.value+unit+';height:'+opt.FSIheight.value+'unit+"></div>\n';
		opt.renderingquery.value = getSSImage(opt.FSIwidth.value, opt.FSIheight.value, false, false, false, true);
	
	} catch (e){}
	
	interfaceControl.updatePreviewCode(wrapinXHTML(true));
	v = getDir();
	document.getElementById('dirvalue').value = v[1];
	StorePublishingSettings();
	return imgtag;
	
}

function updateSpinZoomOptions(elid) {
		
	var pname = elid.id;
	pname = pname.toLowerCase();
	var opt = document.settings;
	qdata[pname] = elid.value; 
	updateCode();

}

function getSpinZoomOptions(asString,forPreview,forSavefile) {

	if(typeof(forSavefile) == "undefined") forSavefile = false;
	
	var opt=document.settings;
	if(typeof(qdata['options_backgroundColor']) != 'undefined' && qdata['options_backgroundColor'] != '') {
		var cval = qdata['options_backgroundcolor'];
		if ("#" != cval.substr(0, 1) )
			qdata['options_backgroundcolor'] = '#' + cval;
	}
	v = getDir();
	qdata["options_Dir"] = v[1];
	//Prepare
	renderingquery = getSSImage(opt.FSIwidth.value, opt.FSIheight.value, false, false, false, true, false);	
	if (renderingquery && renderingquery.length > 0) {
		delete(qdata['options_overlays']);
		delete(qdata['options_cropValues'])
		delete(qdata['options_imageServerTemplate']);
		delete(qdata['options_effects']);
		var parts = renderingquery.split("&");
		for (var x = 0; x<parts.length; x++) {
			var cparts = parts[x].split("=");
			if (cparts[0] == "effects") {
				qdata['options_effects'] = cparts[1]+",";	
			}
			if (cparts[0] == "overlays") {
				qdata['options_overlays'] = cparts[1];	
				qdata['options_imageServerTemplate'] = "overlay";
			}
		}
	} else { qdata['options_effects'] = ""; }


	if (qdata['options_effects'] && qdata['options_effects'].charAt(qdata['options_effects'].length - 1) == ',') {
 		 qdata['options_effects'] = qdata['options_effects'].substr(0, qdata['options_effects'].length - 1);
	}

	if (croprect && croprect.length > 0) {
		var parts = croprect.split("=");
		qdata["options_cropValues"] = parts[1];
	}
	delete(qdata['FSIunit']);
	
	//Build
	if(typeof(asString) != 'undefined' && asString != false) {
		var retstr = "";
			
			for (var option in qdata) {
				if (qdata[option] == "") continue;
				if (option.indexOf('effectsvalue') > -1) { delete(qdata[option]); continue; }
				var something = option.split("_");
				if (something[1] == 'FSIunit' || something[1] == 'fsiunit' || (something[1] == 'options' && something[0] == "width" ) || (something[1] == 'height' && something[0] != "pagesthumbbar" ) ) continue;
				if (something[1] == "imagesources") retstr += "src=\""+decodeURIComponent(qdata[option])+"\" ";
				else if ( something[0] == "pages" ) retstr += ""+something[1] + "=\"" + qdata[option] + "\" ";
				else if ( (something[0] == "pages" && forSavefile) || inArray(something[0],pluginNames) ) retstr += ""+something[0]+"_"+something[1]+"=\""+qdata[option]+"\" ";
				else if (something[0] != "options") retstr += ""+something[1]+"=\""+qdata[option]+"\" ";
				else retstr += ""+something[1]+"=\""+qdata[option]+"\" ";
			}
			if (plugins.length > 0 ) retstr += "plugins=\""
			for (var x=0;x<plugins.length;x++) {
				retstr += plugins[x]+",";
			}
			if (plugins.length > 0 ) retstr = retstr.substr(0,retstr.length-1) + "\"";
			if(typeof(forPreview) != "undefined" && forPreview) { 
				retstr += "usenc=\"true\" usencquery=\"&headers=webinterface\"";
				if (inArray("resize",plugins)) retstr += "plugins=\"resize\"";
			}
	}

	else { //get Object

		var retstr = new Object;
		for (var option in qdata) {
			if (qdata[option] == "") continue;
			if (option.indexOf('effectsvalue') > -1) { delete(qdata[option]); continue; }
			something = option.split("_");
			if (something[1] == 'FSIunit' || something[1] == 'fsiunit' || (something[1] == 'options' && something[0] == "width" ) || (something[1] == 'height' && something[0] != "pagesthumbbar" )) continue;
			if (something[1] == "imagesources") retstr[something[1]] = encodeBrowsePath(qdata[option]);
			else if ( something[0] == "pages" ) retstr[something[1]] = qdata[option];
			else if ( (something[0] == "pages" && forSavefile) || inArray(something[0],pluginNames) ) retstr[something[0]+"_"+something[1]] = qdata[option];
			
			else if (something[0] != "options") retstr[option] = qdata[option];
			else retstr[something[1]] = qdata[option];
		}

		if(typeof(forPreview) != "undefined" && forPreview) {
			retstr["usenc"]= true;
			retstr["usencquery"] = "&headers=webinterface";
			if (!inArray("resize",plugins)) retstr["plugins"] = "resize";
		}

		var plstr = "";
		
		if (plugins.length > 0 ) {
			for (var x=0;x<plugins.length;x++) {
				plstr += plugins[x]+",";
			}
			plstr = plstr.substr(0,plstr.length-1); //last komma
		}
		if (plstr != "") retstr["plugins"] = plstr;	
		

	}
	return retstr;
}


function getSpinZoomHeaders(forPreview) {

	var retstr = "";

	if (!forPreview)var jsurl = interfaceControl.getUserProxyPagesMobileUrl(); //req HLK
	else var jsurl = interfaceControl.getUserLocalFSIViewerBase() + "applications/pagesmobile/";

	jsurl = jsurl.replace(/pagesmobile/g, "pages");
	retstr += '<script type="text/javascript" src="'+jsurl+'js/fsipages.js"><\/script>\n';
	
	return retstr;
	
} 

function initPreview() {
	
	if (FSIPages && FSIPages.inFullScreenMode) return;
	if (FSIPages && FSIPages.destroy) FSIPages.destroy();

	var p = document.getElementById("preview");
	p.innerHTML = wrapinXHTML(true);
	
	var id = 'preview';
	if (typeof($FSI) != "undefined" && typeof($FSI.Pages) != "undefined") {
		var opts = getSpinZoomOptions(false,true);
		
		//$FSI.initCustomTags();
		FSIPages = new $FSI.Pages(id,opts);
		FSIPages.start();
	} else {
		interfaceControl.showPublishMessage("Error","Error initializing preview. Scripts have not loaded yet.");
	}

}


function jsParamsToQuery(forSavefile) {
	var nquery = "";

	var jp = getSpinZoomOptions(true,false, forSavefile);
	
	var jplspl = jp.split(" "); // war "\","
	if (jplspl && jplspl.length > 0){

		for (var qc = 0; qc < jplspl.length; qc++){
			var cmdspl = jplspl[qc].split("=\""); //  war /:/
			if(cmdspl[1]) {
				cmdspl[1] = cmdspl[1].replace("\"",""); //remove "s
				cmdspl[1] = cmdspl[1].replace("\"",""); //remove "s
			}
			if (cmdspl && cmdspl[0]){
				if (cmdspl[0] == "imagesources" || cmdspl[0] == "src" || cmdspl[0] == "dir") continue;
				if (!cmdspl[1]){
					cmdspl[1] = null;
				}
			}
			if (cmdspl[0] && cmdspl[1]) {
				if (nquery.length > 0) nquery = nquery + "&";
				nquery += cmdspl[0]+"="+cmdspl[1];
			}
		}
	}

	if (nquery.length > 0) return nquery;
}

function saveSelectedConfig(filename) {
	
	if (filename != null && filename != "" && fsiparser.isValid()) {

		if (filename.substring(filename.length-4) != ".xml") filename += ".xml"; //append suffix if missing.
		var jsparamquery = jsParamsToQuery(true);

		fsiparser.addQuery(jsparamquery);
		fsiparser.getPublishOptions(false);	
		
		if (fsiparser.isValid()){ 
		    var fsixml = fsiparser.getXML(true);
			if (fsixml){
				interfaceControl.lockInterface();
				var serviceurl = interfaceControl.getBaseServiceURL() + "postupload/_configs/";

				serviceurl += interfaceControl.getActivePublishingSet()+ "/";
				success = fsiparser.saveFSI(serviceurl, filename, fsixml);
				interfaceControl.unlockInterface();
				if (parseInt(success) == parseInt(200)) {
					//done
				}
				else {
					interfaceControl.showPublishMessage("Error","Settings have not been saved");
				}
			}
		}
	}

	var w = opt.options_width.value;
	var h = opt.options_height.value;
	document.settings.reset();
	opt.options_width.value = w;
	opt.options_height.value = h;
	
	var tmp = new Array();
	if (typeof(qdata['options_dir']) != "undefined") tmp['options_dir'] = qdata['options_dir'];
	if (typeof(qdata['options_imagesources']) != "undefined") tmp['options_imagesources'] = qdata['options_imagesources'];
	
	qdata = new Array();
	qdata = tmp;
	qdata["cfg"] = filename;
	loadSelectedConfig(filename);
	document.getElementById("currentLoadedConfig").value = filename;

	plugins = new Array();
	updateCode();
}
	


function getUniqueID() {
	
	if(uniqueID != false) return uniqueID;

    var length=12;
    var uid = "FSI_";

    var noPunction = true;

    for (i=0; i < length; i++) {

        numI = getRandomNum();
        if (noPunction) { while (checkPunc(numI)) { numI = getRandomNum(); } }

        uid = uid + String.fromCharCode(numI);
    }
	uniqueID = uid;
    return uid;
}

function getRandomNum() {

    // between 0 - 1
    var rndNum = Math.random()

    // rndNum from 0 - 1000
    rndNum = parseInt(rndNum * 1000);

    // rndNum from 33 - 127
    rndNum = (rndNum % 94) + 33;

    return rndNum;
}

function checkPunc(num) {

    if ((num >=33) && (num <=47)) { return true; }
    if ((num >=58) && (num <=64)) { return true; }
    if ((num >=91) && (num <=96)) { return true; }
    if ((num >=123) && (num <=126)) { return true; }

    return false;
}


function wrapinXHTML(forPreview) {
		
	var unit=document.settings.FSIunit.value;
	if (unit == "pc") unit = "%";
	if (unit == "px") unit = "";
	
	htmlcode = '<!DOCTYPE HTML>\n';
	if(typeof(forPreview) != undefined && forPreview) htmlcode += interfaceControl.getPreviewWindowComment();
	htmlcode+='<html>\n';
	htmlcode+='<head>\n';
	htmlcode+='<meta http-equiv="content-type" content="text/html; charset=UTF-8">\n';
	htmlcode+='<meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1">\n';
	htmlcode+='<title>FSI Pages JS</title>\n';

	if( (typeof(forPreview) != undefined && forPreview) || unit == "%") {
		htmlcode += interfaceControl.getPreviewWindowStyle();
	}
	htmlcode+=getSpinZoomHeaders(forPreview);
	htmlcode+='</head>\n';
	htmlcode+='<body>\n';


	htmlcode+='<fsi-pages width=\"'+document.settings.FSIwidth.value+unit+'\" height=\"'+document.settings.FSIheight.value+unit+'\" '+getSpinZoomOptions(true,forPreview)+'>'; 
	if(typeof(forPreview) != undefined && forPreview)  { var serverUrl = interfaceControl.getUserLocalFSIViewerBase(); serverUrl = serverUrl.replace(/viewer\//,"server"); }
	else var serverUrl = interfaceControl.getUserProxyServerUrl();

	if(document.settings.fsipagesintrocontent.value!="") {
		htmlcode+='\n<fsi-pages-intro-content>\n'+document.settings.fsipagesintrocontent.value+'\n</fsi-pages-intro-content>';
	}
	var image = getFirstImage();
	htmlcode+='\n<noscript>\n<img src="'+serverUrl+'?type=image&source='+image.fullsrc+'&width='+document.settings.FSIwidth.value+'&height='+document.settings.FSIheight.value+'" width="'+document.settings.FSIwidth.value+'" height="'+document.settings.FSIheight.value+'" alt="'+image.fullsrc+'">\n</noscript>';
	
	htmlcode+='\n</fsi-pages>\n';

	htmlcode+='</body>\n';
	htmlcode+='</html>\n';
	
	return htmlcode;
}


function openImage() {
	
	w = document.settings.FSIwidth.value;
	h = document.settings.FSIheight.value;
	var url = getSSImage(w,h, false, false, true);
	url = interfaceControl.appendQueryParameterToUrl(url, "disposition=true&save=true");
	
	if (browser.name == "IE" || browser.name == "Chrome") window.open(url, "_self");
	else window.open(url);

}

function getPublishImageEntry(){
	
	var entry = interfaceControl.getThumbView().getFirstSelectedThumb();
	var basePath = interfaceControl.getBasePath();
	
	if(entry && entry.type != 'file') {
		entry = entryFirstImage = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(entry.fullsrc), interfaceControl.getBasePathType());
	} else if (!entry) {	
		entry = entryFirstImage = interfaceControl.getThumbView().getFirstImageEntryForDir(basePath, interfaceControl.getBasePathType());
	}
		
	if (entry) {
		oPreviewEntry = entry;
	}
	else entry = oPreviewEntry;
	
	return entry;
}



function onPublishingSourceChanged(){

	var oldPrevEntry = oPreviewEntry;
	var newPrevEntry = getPublishImageEntry();
	updateCrop(true); 
	if (typeof(oldPrevEntry) != "undefined" && oldPrevEntry.type != newPrevEntry.type) return;
	if (typeof(newPrevEntry) == 'undefined' ) return;
	if ( getBasePathFromEntry(oldPrevEntry) == getBasePathFromEntry(newPrevEntry) ) return;
	v = getDir();
	
	getFirstDimensions();
	
	updateEffectThumbs();
	updateEffectPreview();
	updateCode();
	updateCrop(true);
	
	boPSC = true;
	if (aktiveDiv == '6') toActive('6');

	boPSC = false;
	
	checkRestrictions();
}


function loadSelectedConfig(fileName) {
	
	if (fileName.substring(fileName.length-4) != ".xml") fileName += ".xml"; //append suffix if missing.
	loadedConfig = fileName;
	
	var oldplugins = new Array();
	if (typeof(plugins) != 'undefined') {
		oldplugins = plugins;
		for (var p in oldplugins) {
			handlePlugins(oldplugins[p]); //Disable activated plugins in Interface
			fsiparser.removePlugin(p);
		}
	}
	plugins = new Array();

	//reset form
	var opt = document.settings;
	var w = opt.FSIwidth.value;
	var h = opt.FSIheight.value;
	if (opt) opt.reset();
	opt.FSIwidth.value = w;
	opt.FSIheight.value = h;
	
	qdata = new Array();
	
	document.getElementById("currentLoadedConfig").value=fileName;
	
	v = getDir();
	document.getElementById('dirvalue').value = v[1];
	
	qdata['options_cfg'] = fileName;

	// Load settings from file and set form:
	if(fileName != "") {
		fsiparser.loadFSI(fsirooturl+"config/", fileName);
	}

	if (fileName != "" && fsiparser.isValid()) { // !
		//RestoreParameterValues(build);
		preUpdateInterface(build);
	}

	updateCode();
}

