/*!
 * FSI Thumb Bar
 * Build: 18.06.18.8
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing;$FSI.console.info=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a==undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r==undefined)?"":strReturn+ar[i].r;strType=(ar[i].t==undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]==undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!=undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)=="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)=="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!=undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)=="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!=undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var oClassOptions={strVersion:"2018",strBuild:"18.06.18.8"};var classDef=new $FSI.ClassDef($FSI,"FSI Core",oClassOptions);$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof($FSI.iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!=undefined&&ar.length>0){for(var i=0;i<ar.length;i++){$FSI.deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};$FSI.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors==undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);$FSI.addCSSRule(strSelector,strRule,0)};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.deleteCSSRule=function(selector){var ret=false;if($FSI.oInsertedCSS!=undefined){try{var arDelete=[];var ar=$FSI.oInsertedCSS.sheet.cssRules;for(var i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText==selector){arDelete.push(i)}}if(arDelete.length>0){for(var i=arDelete.length-1;i>-1;i--){$FSI.oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		 @if (@_jscript_version < 9)
		 el.style.setAttribute('cssText', strStyle);
		 @else @*/
el.setAttribute("style",strStyle);
/*@end
		 @*/
};$FSI.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWidth=window.innerWidth;$FSI.bElementPosRespectsScroll=true;$FSI.oSupportedEvents={};$FSI.isEventSupported=function(eventName){if($FSI.oSupportedEvents[eventName]!=undefined){return $FSI.oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;$FSI.oSupportedEvents[eventName]=isSupported;return isSupported};var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}$FSI.userAgent=navigator.userAgent.toLowerCase();var uagent=$FSI.userAgent;var result,t,i;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!==-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;$FSI.versionInternetExplorer=0;$FSI.isIETouch=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("chrome")!==-1&&uagent.search("edge")===-1){$FSI.isChrome=true}else{if(uagent.search("safari")!==-1){$FSI.isSafari=true}else{if(uagent.search("firefox")!==-1){$FSI.isFirefox=true}else{if(uagent.search("opera")!==-1){$FSI.isOpera=true}}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)==="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(nam,unit){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return window.visualViewport.scale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){$FSI.documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";$FSI.getDocumentScale=function(){if(screen.width!=$FSI.topWindow.outerWidth){return($FSI.topWindow.outerWidth-192)/$FSI.topWindow.innerWidth}return($FSI.topWindow.outerWidth-83)/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth iOS";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.documentScaleMethod="fallback";$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!=="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getVisualViewportSize=function(){var ret={};if(window.visualViewport){ret.width=window.visualViewport.width;ret.height=window.visualViewport.height}else{ret.width=window.innerWidth;ret.height=window.innerHeight}return ret};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.visualViewport.width,height:wnd.visualViewport.height}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)==="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.replaceChild=function(parent,existingChild,newChild){try{var elNext=existingChild.nextSibling;if(elNext){parent.removeChild(existingChild);parent.insertBefore(newChild,elNext)}else{parent.appendChild(newChild)}}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(existingChild);$FSI.console.log(newChild)}};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.callbackFunctionID=0;$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.dispatchEvent=function(myEvent,props){var event;if($FSI.BrowserSupports.genericEvent()){event=new Event(myEvent)}else{event=document.createEvent("Event");event.initEvent(myEvent,true,true)}if(event){return window.dispatchEvent(event)}else{return false}};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!=="object"){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)==="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!=="string"){return false}var t=typeof(parameters);if(t!=="object"&&t!=="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!=="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!=="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!=="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!=="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)==="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!=="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!=="string"){return}if(typeof(strClass)!=="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!=="string"){return}if(typeof(strClass)!=="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.hasClass=function(el,strClass){if(typeof(strClass)!=="string"){return false}strClass=$FSI.trim(strClass);if(strClass.length<1){return false}var str=el.className;if(typeof(str)!=="string"||str.length<1){return false}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");return(str.match(regex)!=null)};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.regExEffects=/((\?)|&)effects=([^&]*)/ig;$FSI.regExPadEffect=/[=,]+Pad\([^)]*/ig;$FSI.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match($FSI.regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match($FSI.regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!=="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=scale.y=targetDimension.width/(sourceDimension.width*range.width)}else{scale.x=scale.y=targetDimension.height/(sourceDimension.height*range.height)}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)==="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(window.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.genericEvent=function(){var res=false;try{if(typeof(window.Event)==="function"){res=true}}catch(e){}$FSI.BrowserSupports.genericEvent=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)==="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)==="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!=b){return}a.Config=function(Z,z,g){if(typeof(g)!=="object"){g={}}if(!z||typeof(z)!=="object"){z={}}var p=this;this.parameters=(Z&&typeof(Z)==="object")?Z:{};this.queryParameters=b;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():b}catch(ab){}this.plugins={};this.arPlugins=[];this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=[];this.arConditions=[];this.locales={};this.locales.tips={};var R=false;this.strListFilePrefix="";this.strListFileSuffix="";var J={};var B=0;var t;var V={};var d="FSI> ";var E=p.debug=new a.EmptyDebugger();var C=false;var A={};var af=false;var M={stickynotes:"bookmarks"};var h;var Q=false;var v;var G;var W;var c;var o;var x="token";var y;this.strConfigFileExtension=".xml";p.strTemplateSuffix=".json";var r;var i=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){r=function(ag){var e;if(!a.isCrossDomain(ag)){af=false;e=new XMLHttpRequest()}else{af=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){r=function(){return new XMLHttpRequest()}}}if(!r){try{i=new ActiveXObject("Msxml2.XMLHTTP");r=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(ab){try{i=new ActiveXObject("Microsoft.XMLHTTP");r=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(ab){i=null;r=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters={};this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(ai){p.reset();v=(typeof(g.strSection)==="string")?g.strSection:"";G=v.toLowerCase();if(typeof(g.strTraceParam)==="string"){var ag=g.strTraceParam.toLowerCase();c={};c[ag]=true;if(ag.indexOf("_")>0&&ag.indexOf("pages")===0){ag=ag.split("_");ag.shift();ag=ag.join("_");c[ag]=true}var ah=p.getParameterAlias(ag);if(ah){c[ah]=true}}else{c=false}if(ai){if(p.parameters){p.parameters=a.mergeObjects(p.parameters,ai)}else{p.parameters=ai}}Y(p.parameters);p.getQueryParameters();p.cloneParameters(p.cfgDefaults,p.cfg);p.cloneParameters(p.queryParameters,p.cfg);p.elevateToHTTPS();f();p.BaseURL=p.getBaseURL();if(p.bForceVersion5==true){}var e=p.queryParameters.fsiviewerversion;if(p.bForceVersion5==true){e="5"}if(e!=b){if(parseInt(e)<6){p.strConfigFileExtension=".fsi"}}var aj=p.queryParameters.fsiserverversion;if(p.bForceVersion5==true){aj="2"}if(aj!=b){if(parseInt(aj)<3){p.strTemplateSuffix="_json"}}p.locationFSIViewer="";if(p.queryParameters.fsiviewerlocation!=b){p.locationFSIViewer=p.queryParameters.fsiviewerlocation}else{if(a!=b&&a._FSIViewerLocation!=b){E.log("FSI Viewer location guessed based on script location: "+a._FSIViewerLocation);p.locationFSIViewer=a._FSIViewerLocation}else{p.locationFSIViewer=p.BaseURL.split("/");if(p.locationFSIViewer.length>4){p.locationFSIViewer.splice(p.locationFSIViewer.length-3,2);p.locationFSIViewer=p.locationFSIViewer.join("/")}}}if(p.locationFSIViewer.charAt(p.locationFSIViewer.length-1)!="/"){p.locationFSIViewer+="/"}p.nextConfigURL=p.getReloadPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.defaultcfg));p.checkDebug(false)};var Y=this.makeObjectPropertiesLowerCase=function(e){for(var ag in e){var ah=ag.toLowerCase();if(ag!=ah){if(e[ah]==b){e[ah]=e[ag]}delete e[ag]}}};this.getClassParameters=function(){return W};this.setAccessToken=function(e){y=e};this.getParameterAlias=function(ah){var e;if(p.cfgAliasNames[ah]){e=p.cfgAliasNames[ah]}else{for(var ag in p.cfgAliasNames){if(p.cfgAliasNames[ag]===ah){e=ag;break}}}return e};var f=function(){R=p.makeBool(p.cfg.usenc,false);if(p.cfg.usencquery!=b&&p.cfg.usencquery.length>0){C=p.cfg.usencquery;R=true;p.queryToObject("?"+C,A)}};this.stopPendingRequests=function(){for(var ag in J){var e=J[ag];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){p.stopPendingRequests()};this.getBaseURL=function(){var ah;var ag=document.getElementsByTagName("base");if(ag&&ag.length>0){ah=ag[ag.length-1].href;if(ah&&ah.charAt(ah.length-1)!="/"){ah+="/"}}else{ah=document.location.href;var e=ah.indexOf("?");if(e!=-1){ah=ah.slice(0,e)}e=ah.indexOf("#");if(e!=-1){ah=ah.substring(0,e)}e=ah.lastIndexOf("/");if(e!=-1){ah=ah.slice(0,e+1)}}return ah};this.reset=function(){W={};p.parameters={};E=p.debug=new a.EmptyDebugger();p.stopPendingRequests();t=Math.random();p.nIncludedConfigs=0;p.completedConfigs={};p.plugins={};p.cfg={};p.queryParameters=b;p.arUnrecognizedConfigNodes=[];aa=0;p.arConditions=[];V={}};this.getQueryParameters=function(){if(p.queryParameters!=b){return}p.queryParameters={};p.cloneParameters(p.parameters,p.queryParameters)};this.makeBool=function(ai,e){if(typeof(e)!="boolean"){e=false}var ag=e;switch(typeof(ai)){case"string":var ah=a.makeBool(ai);if(ah!=b){ag=ah}break;case"number":ag=Boolean(ai);break;case"boolean":ag=ai;break}return ag};this.parsePositionParameter=function(ag){if(typeof(ag)!="string"||ag.length<3){return b}ag=ag.split(",");if(ag.length<3){return b}for(var e=0;e<3;e++){ag[e]=parseFloat(ag[e]);if(isNaN(ag[e])){ag[e]=0}}return{x:ag[0],y:ag[1],z:ag[2]}};this.logLoadFileFailed=function(e){if(!E.on){return}if(e&&e.status!=b){var ah="HTTP "+e.status;if(e&&e.statusText){ah+=", "+e.statusText}var ag=(e._url)?e._url:"";E.error("Failed to load "+ag+" ("+ah+")")}else{E.error("Failed loading a file");if(e&&e._url){E.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(aj){if(!aj||!aj.firstChild){return false}var e=aj.firstChild.childNodes;var ak,ah,ai;for(var ag=0;ag<e.length;ag++){ah=e[ag];ak=p.getAttributeValue(ah,"id");if(ak==b){continue}ak=ak.toLowerCase();if(ah.childNodes.length>0){ai=p.XMLChildNodesToString(ah)}else{ai=p.getAttributeValue(ah,"txt")}p.locales.tips[ak]=ai}return true};this.getAttributeValue=function(ag,e){if(!ag){return}return ag.getAttribute(e)};this.onLanguageLoaded=function(ag,e){E.log("Language loaded");if(ag){p.parseLanguage(e.responseXML)}if(z.onConfigReady){z.onConfigReady()}};this.onConfigReadyDone=function(){if(!p.readCustomPageNumbers()){p.loadImageList()}};this.swapParameters=function(ah,e){ah=ah.toLowerCase();e=e.toLowerCase();var ag=p.plugins.pages.parameters;if(ag==b){return}p.swapValues(ag,ah,e);p.swapValues(p.cfg,"pages_"+ah,"pages_"+e)};this.swapValues=function(ai,ah,ag){var e=ai[ah];ai[ah]=ai[ag];ai[ag]=e};this.getTranslation=function(ag){var e=p.locales.tips[ag.toLowerCase()];if(e==b){e=ag}return e};this.getImageURL=function(ah,e){if(ah==b){return""}if(e===b){e={}}if(e.type===b){e.type="image"}if(e.renderer===b){e.renderer="jpeg"}if(y){e[x]=y}e.source=ah;for(var ag in V){if(V[ag]!==b&&e[ag]===b){e[ag]=V[ag]}}for(var ag in T){if(e[ag]){if(T[ag]!==ag){if(!e[T[ag]]){e[T[ag]]=e[ag]}e[ag]=null}}}return p.requestBase+"?"+p.objectToQuery(e)};this.getImageInfoURL=function(ag,e){if(ag==b){return""}if(e==b){e={}}if(e.type==b){e.type="info"}if(e.tpl==b){if(p.cfg.fpxinfotemplate!=b){e.tpl=p.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(p.cfg.headers&&p.cfg.headers.length>0){e.headers=p.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=ag;if(y){e[x]=y}return p.requestBase+"?"+p.objectToQuery(e)};this.queryToObject=function(aj,ah){if(ah==b){ah={}}var ai,al,ak,e,ag;ai=aj.indexOf("?");if(ai!=-1){ag=aj.slice(ai+1)}else{ag=""}ai=ag.indexOf("#");if(ai!=-1){ag=ag.substring(0,ai)}ag=ag.split("&");for(ai=0;ai<ag.length;ai++){al=ag[ai].split("=");ak=a.urlDecode(al[0]).toLowerCase();if(ak.length>0){e=a.urlDecode(al[1]);ah[ak]=e}}return ah};this.parseSceneSets=function(e,aj){var aq={};if(aj==b){aj=true}var aw=[];var au=0;var ar=0;var ah;var al,ak,ai,ap,an,av;var am,ao,at;var ag=p.cfg.scenesets;if(e>1&&ag!=b&&typeof(ag)=="string"){ao=ag.split(";");for(al=0;al<ao.length;al++){at=[];am=ao[al].split(",");ar=0;for(ak=0;ak<am.length;ak++){av=am[ak].split("-");ap=an=0;if(av.length==1){ap=parseInt(av[0])}else{ap=parseInt(av[0]);if(isNaN(ap)){ap=1}ah=false;if(av[1].charAt(0)==">"){av[1]=av[1].substr(1);if(!isNaN(parseInt(av[1]))){ah=true}}an=parseInt(av[1]);if(isNaN(an)){an=e}if(ap>0&&an>0&&ap<=e&&an<=e){if(ah==true||ap!=an){if(ah!=true){if(an<ap){for(ai=ap;ai>=an;ai--){at[ar]=ai;ar++}}else{for(ai=ap;ai<=an;ai++){at[ar]=ai;ar++}}}else{for(ai=ap;ai<=e;ai++){at[ar]=ai;ar++}for(ai=1;ai<=an;ai++){at[ar]=ai;ar++}}}}}if(ap>0&&ap<=e&&(an==0||an==ap)){at[ar]=ap;ar++}}if(ar>0){aw[au]={};aw[au].arScenes=[];aw[au].arScenes=aw[au].arScenes.concat(at);au++}}}if(au==0){aq.bDefault=true;if(aj){aw[0]={};aw[0].arScenes=[];for(al=0;al<e;al++){aw[0][al]=al}}}aq.nSceneSets=au;aq.bHasMultipleSets=(aq.nSceneSets>1);aq.arSets=aw;aq.nCurrent=1;return aq};this.objectToQuery=function(ag){var e=[];var ai,ah;if(R&&C!==false){for(ai in A){ag[ai]=A[ai]}}for(ai in ag){ah=ag[ai];if(ah!==null){ah=encodeURIComponent(ah);e.push(encodeURIComponent(ai)+"="+ah)}}return e.join("&")};this.loadConfigs=function(){W=(v.length>0)?{}:false;h=true;p.loadNextConfig(true)};this.loadImageInfo=function(ai,e,ah){var ag=p.getImageInfoURL(ai);p.loadFile(ag,e,b,ah)};this.loadFile=function(aj,ai,ah,an,am,ag,ak){if(!aj||aj.length<0){if(ai){setTimeout(function(){ai(null,"",an)},0)}return}if(am==b){am="GET"}if(ag==b){ag=null}else{if(typeof(ag)=="object"){ag=p.objectToQuery(ag)}}if(ah==b){ah="application/json"}var al=r(aj);if(!al){return}if(ah&&al.overrideMimeType){al.overrideMimeType(ah)}al._url=aj;var e=B;J[B]=al;B++;if(af){al.onerror=function(){delete J[e];if(ai==b||this.FSIaborted){return}p.logLoadFileFailed(this)};al.onload=function(){delete J[e];if(ai==b||this.FSIaborted){return}var ao=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var ap=new ActiveXObject("Microsoft.XMLDOM");ap.async=false;ap.loadXML(ao);ao=this.responseXML=ap}catch(aq){E.log("Failed parsing XML using Microsoft.XMLDOM");E.log(aj)}break;case"application/json":ao={};try{ao=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ao=this.responseText}ai(this,ao,an)}}else{al.onreadystatechange=function(ao){var ap;if(al.readyState!=4){return}delete J[e];if(ai==b||this.FSIaborted){return}if(this.status>299){p.logLoadFileFailed(this)}switch(ah){case"application/xml":case"text/xml":ap=this.responseXML;break;case"application/json":ap={};try{ap=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ap=this.responseText}ai(this,ap,an)}}al.open(am,aj,true);if(ak&&y){al.setRequestHeader("x-token",y)}if(ag){al.setRequestHeader("Content-type","application/x-www-form-urlencoded");al.send(ag)}else{al.send()}return al};this.onConfigXMLLoaded=function(e,ag){p.logXMLResponseOK(e.response);p.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(ag){if(p.nextConfigURL==b){p.finalCheck();return}var ah={};if(g.bPreventCaching||p.makeBool(p.cfg.debug)||(!ag&&!p.makeBool(p.cfg.configcaching,true)&&p.makeBool(p.cfg.enableconfigcachingparameter))){p.addNoCacheParams(ah)}p.finishRequestParams(ah);var e=p.addURLParameters(p.nextConfigURL,ah);E.log("Loading config file: "+e);p.loadFile(e,p.onConfigXMLLoaded,"application/xml")};this.parseFloatPercentDef=function(ai,ah,ag,e){if(ai==b||ai.length<1){return ag}return Math.max(e,p.parseFloatPercent(ai,ah))};this.parsePercentDef=function(ah,e){if(ah==b||ah.length<1){return e}var ag=parseFloat(ah);if(isNaN(ag)){ag=0}else{if(ah.indexOf("%")!=-1){ag/=100}}return ag};this.parseFloatPercent=function(ah,ag){var e=parseFloat(ah);if(isNaN(e)||e<0){e=0}else{if(ah.indexOf("%")!=-1){e=Math.round(e*ag/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){d=e+"> "};this.setDebugger=function(e){E=p.debug=e};this.checkDebug=function(ah){if(g.bNoDebug){return}var ag;var e;if(p.parameters.debug!=b){e=p.makeBool(p.parameters.debug)}else{e=p.makeBool(p.cfg.debug)}if(e){if(!E||!E.on){E=p.debug=new a.Debugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}else{if(!E||E.on===true){E=p.debug=new a.EmptyDebugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}return ag};this.onConfigLoaded=function(ag){o=p.nextConfigURL;p.parseConfig(ag);o=b;p.elevateToHTTPS();if(p.checkDebug(true)==true){return}f();if(h&&g.bCaptureDefaultCfg){h=false;p.cfgFromDefaultConfig=a.cloneValue(p.cfg)}var e;if(p.cfg.includeconfig!=b&&p.nIncludedConfigs<10){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.includeconfig));p.nIncludedConfigs++;p.cfg["_includeconfig("+p.nIncludedConfigs+")"]=p.cfg.includeconfig;p.cfg.includeconfig=b}else{if(p.cfg.cfg!=b){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.cfg))}}if(e!=b&&!p.completedConfigs[e]){p.completedConfigs[e]=true;p.nextConfigURL=e;p.loadNextConfig()}else{p.evaluateQuery(p.queryParameters,p.cfg);p.finalCheck()}};this.elevateToHTTPS=function(){if(!a.bHTTPS){return}if(!p.makeBool(p.cfg.autoelevatetohttps,true)){return}k("fpxbase");k("fpxserver")};var k=function(e){if(p.cfg[e]!=b&&p.cfg[e].length>0&&p.cfg[e].indexOf("http://")==0){p.cfg[e]="https"+p.cfg[e].substr(4)}};this.evaluateQuery=function(ag,e){for(var ah in ag){p.setConfigParamByValue(e,ah.toLowerCase(),ag[ah])}};this.parseConfig=function(ag,ah){var aq="";var ak;var am=false;if(ag!=b){if(ah===b){ah=ag.firstChild}if(ah&&ah.nodeName=="xml"){ah=ah.nextSibling}var ap=ah.childNodes;for(var al=0;al<ap.length;al++){var aj=ap[al];if(aj.nodeType!=1){continue}var an;if(aj._myTagName!==b){an=aj._myTagName}else{an=aj.nodeName.toLowerCase()}aq=an;var ai=aj.childNodes;am=false;switch(an){case"licence":break;case"if":p.arConditions.push(aj);break;case"plugins":for(ak=0;ak<ai.length;ak++){p.parsePluginNode(ai[ak])}break;case G:am=true;case"info":case"options":aq=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ak=0;ak<ai.length;ak++){var ao=ai[ak];if(ao.nodeType!=1){continue}if(ao.tagName==="if"){ao._myTagName=an;p.arConditions.push(ao)}else{var e=p.getValueFromXMLNode(ao,aq);if(aq===b&&W){if(am){p.setConfigParam(W,e,null,true);p.setConfigParam(p.cfg,e,ao)}else{if(W[e.name]===b){p.setConfigParam(p.cfg,e,ao)}}}else{p.setConfigParam(p.cfg,e,ao)}}}break;default:p.arUnrecognizedConfigNodes.push(aj)}}}};this.getData=function(){var e={};e.cfg={};for(var ag in p.cfg){e.cfg[ag]=p.cfg[ag]}return e};this.setData=function(e){if(!e||!e.cfg){return}p.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var ag in e){p.cfg[ag]=e[ag]}P()};this.getImagesNodeList=function(ah){var e=[];if(ah==b){ah=p.getUnrecognizedConfigNode("images")}if(ah){var ai=ah.firstChild;while(ai){if(ai.nodeType==1){var ag={};ag.attributes={};I(ai,ag.attributes);ag.cfg={};p.parseConfigFragment(ai,ag.cfg);e.push(ag)}ai=ai.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){p.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ai){var e;ai=ai.toLowerCase();for(var ag=p.arUnrecognizedConfigNodes.length-1;ag>-1;ag--){var ah=p.arUnrecognizedConfigNodes[ag];if(ah&&ah.nodeName.toLowerCase()==ai){e=ah;break}}return e};this.parseConfigFragment=function(ag,am,al){var aq="";if(ag!=b&&am!=b){if(al==b){al=[]}var ap=ag.childNodes;for(var ak=0;ak<ap.length;ak++){var ai=ap[ak];if(ai.nodeType!=1){continue}var an=ai.nodeName.toLowerCase();aq=an;var ah=ai.childNodes;switch(an){case"info":case"options":aq=b;case"fpx":case"image":case"include":for(var aj=0;aj<ah.length;aj++){var ao=ah[aj];if(ao.nodeType!=1){continue}var e=p.getValueFromXMLNode(ao,aq);p.setConfigParam(am,e,ao)}break;default:al.push(ai)}}}};this.findXMLNode=function(ag,e){if(ag==b||ag.nodeType==b){return b}while(ag){if(ag.nodeName.toLowerCase()==e){break}if(ag.firstChild!=b){ag=ag.firstChild}else{if(ag.nextSibling!=b){ag=ag.nextSibling}else{ag=ag.parentNode.nextSibling}}}return ag};this.getValueFromXMLNode=function(ah,e){if(!ah||ah.nodeType!=1){return}var ag={};var ai=(e)?e:"";ag.name=ai+ah.nodeName.toLowerCase();var aj=ah.getAttribute("value");if(aj){ag.value=aj;return ag}ag.value=p.XMLChildNodesToString(ah);ag.node=ah;return ag};this.getXMLNodeAttribute=function(ai,ah,e){if(!ai||ai.nodeType!=1||!ai.getAttribute){return e}var ag=ai.getAttribute(ah);if(ag==b||ag==null){ag=e}return ag};this.XMLChildNodesToString=function(ah,ag){if(!ah||!ah.firstChild){return""}var e="";if(ah.childNodes.length===1&&ah.firstChild.nodeType==3){e=ah.firstChild.nodeValue}else{e=p._XMLChildNodesToString(ah)}if(ag!==b){e=e.replace(/[\x00-\x1f]/g,ag)}return e};this.hasPlugin=function(e){return(p.plugins&&p.plugins[e]!=b)};this.getPluginParameter=function(al,ag,e,ak,am){al=al.toLowerCase();ag=ag.toLowerCase();if(p.plugins[al]==b){E.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+al+"."+ag);return e}var aj;var ai=al+"_"+ag;if(am&&p.cfg[ai]==b){ai=ag}if(p.cfg[ai]!=b){aj=p.cfg[ai]}else{if(W&&W[ag]!==b&&G==="pages"){aj=W[ag]}else{var ah=p.plugins[al].parameters;if(ah!=b&&ah[ag]!=b){aj=ah[ag]}}}if(aj==b){aj=e}if(ak){aj=p.makeBool(aj,e)}return aj};var L=this.getAllPluginParameters=function(ag){ag=ag.toLowerCase();var ah=a.cloneObject(p.plugins[ag].parameters);var aj=ag+"_";var e=aj.length;for(var ak in p.cfg){if(ak.toLowerCase().indexOf(aj)==0){var ai=ak.substr(e);ah[ai]=p.cfg[ak]}}return ah};this.getIntParameterMinMax=function(ag,ah,e,ai){return Math.min(ai,Math.max(e,p.getIntParameter(ag,ah)))};this.getIntParameter=function(ag,ah){var e=parseInt(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getStringParameter=function(ag,ah){var e=p.cfg[ag.toLowerCase()];if(e==b){e=ah}return e};this.getFloatParameter=function(ag,ah){var e=parseFloat(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getRGBAValue=function(ag){var e={};if(ag==b){ag=""}if(ag.charAt(0)=="#"){ag=ag.substr(1)}if(ag.length>8){ag=ag.substr(0,8)}if(ag.length>5){e.webColor="#"+ag.substr(0,6);e.red=parseInt(ag.substr(0,2),16);e.green=parseInt(ag.substr(2,2),16);e.blue=parseInt(ag.substr(4,2),16);if(ag.length<7){e.alpha=255}else{e.alpha=parseInt(ag.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};var I=function(ak,ag){if(!ak||!ak.attributes||!ak.attributes.length||!ag){return false}var ah=ak.attributes;for(var aj=0;aj<ah.length;aj++){var e=ah[aj];var ai=e.nodeName.toLowerCase();ag[ai]=e.value}return true};this.parsePluginNode=function(ah){if(ah.nodeType!=1){return}var aj={};I(ah,aj);var ai=ah.childNodes;for(var e=0;e<ai.length;e++){var ak=ai[e];if(ak.nodeType!=1){continue}var ag=p.getValueFromXMLNode(ak);if(ag.value!=b){aj[ag.name]=ag.value;if(ag.node!=b){aj[ag.name+".node"]=ag.node}}}this.addPluginFromString(aj.src,aj)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.clone=function(){var e=new a.Config(Z,z,g);e.init();e.cfg=a.cloneObject(p.cfg);e.plugins=a.cloneObject(p.plugins);e.arPlugins=a.cloneArray(e.arPlugins);e.arUnrecognizedConfigNodes=a.cloneArray(e.arUnrecognizedConfigNodes);e.setImageQueryParameters(V);e.locales=a.cloneObject(p.locales);e.arConditions=a.cloneArray(p.arConditions);e.hasImageParameterConditions=p.hasImageParameterConditions;return e};this.setImageQueryParameters=function(e){V=a.cloneObject(e)};this.addPluginsFromString=function(ah){if(ah==b||ah.split==b||ah.length<1){return}var e=ah.split(",");for(var ag=0;ag<e.length;ag++){var ai=p.trimString(e[ag]);p.addPluginFromString(ai)}};this.addPluginFromString=function(ai,aj){if(ai==b||ai.length<1){E.error("PLUGIN without src parameter:");return}ai=ai.toLowerCase();if(M[ai]!=b){ai=M[ai]}if(aj==b){aj={}}var ag=p.plugins[ai]={};ag.name=ai;if(aj.src===b){aj.src=ai}if(p.pluginDefaultParameters[ai]!=b){ag.parameters={};p.cloneParameters(p.pluginDefaultParameters[ai],ag.parameters);p.cloneParameters(aj,ag.parameters)}else{ag.parameters=aj}if(c){for(var ak in c){if(ak.indexOf(ai+"_")===0){var ah=ai+"_";var e=ak.substr(ah.length);if(typeof(ag.parameters[e])!=="undefined"){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log(ag.parameters[e]);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}else{if(ak===ai){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log("(enabled)");p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ag,ah,e){p.setConfigParam(ag,{name:ah.toLowerCase(),value:e})};var O=function(ag){if(ag.nodeType!==1){return"<unknown>"}var e=p.XMLSerializer.serializeToString(ag.cloneNode(false));e=e.replace(/\/>$/gi,">");return e};this.setConfigParam=function(ai,e,aj,ak){var am=e.name;var ao=e.value;if(am==b){return}if(c){for(var an in c){if(an===am&&!ak){if(typeof(aj)==="object"&&typeof(aj.tagName)==="string"){var al;if(o){al=o}var ah=aj.parentNode;var ag=[];while(ah){if(ah.tagName==="if"){al="Matched Condition"}ag.unshift(O(ah));ah=ah.parentNode}ag.shift();ag.shift();p.iTraceParameterDebug.group(al);p.iTraceParameterDebug.log(ag.join(" "));p.iTraceParameterDebug.log(aj);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}else{p.iTraceParameterDebug.group("By Parameter/Attribute:");p.iTraceParameterDebug.log(ao);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}if(p.cfgAliasNames[am]!=b){am=p.cfgAliasNames[am]}if(ai[am]!=b&&(typeof(ao)=="string"&&a.BoolTable[ao.toLowerCase()]==false)&&a.BoolTable[ai[am]]==b){delete ai[am]}else{switch(am){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ai[am]!=b&&ai[am].length>0&&ai[am].indexOf(ao)==-1){ai[am]+=","+ao}else{ai[am]=ao}break;case"plugins":p.addPluginsFromString(ao);break;case"fpxpath":ai[am]=ao;ai.fpxsrc=encodeURIComponent(ao);break;default:ai[am]=ao;if(e.node!=b){ai[am+".node"]=e.node}}}};var n={};n["="]=function(ag,e){return(ag.toLowerCase()==e.toLowerCase())};n["=="]=function(ag,e){return(ag==e)};n["!="]=function(ag,e){return(ag.toLowerCase()!=e.toLowerCase())};n["!=="]=function(ag,e){return(ag!=e)};n["<"]=function(ag,e){return(ag<e)};n["<="]=function(ag,e){return(ag<=e)};n[">"]=function(ag,e){return(ag>e)};n[">="]=function(ag,e){return(ag>=e)};n.match=function(ah,ag){var ai=false;var ak="g";if(ag.charAt(0)==="/"&&ag.lastIndexOf("/")>0){var aj=ag.split("/");aj.shift();ak=aj.pop();ag=aj.join("/")}try{var al=new RegExp(ag,ak);ai=(ah.match(al)!==null)}catch(am){E.error("Invalid regex in condition: "+ag)}return ai};n.notmatch=function(ag,e){return !n.match(ag,e)};var u={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var w=function(ag,ah){if(p.cfgAliasNames[ah]){ah=p.cfgAliasNames[ah]}var e=p.cfg[ah];if(e==b){e=""}if(!p.hasImageParameterConditions){p.hasImageParameterConditions=(T[ah]!==b)}return D(ag,ah,e)};var H=function(ai,aj){var e=false;var ah;var ag=ai.getAttribute("value");switch(aj){case"@mobile":ag=p.makeBool(ag,true);ah=a.isMobileDevice;break;case"@devicepixelratio":ah=a.getDevicePixelRatio();break;case"@navigatoruseragent":ah=navigator.userAgent;break;case"@navigatorlanguage":ah=navigator.language;break;case"@navigatorplatform":ah=navigator.platform;break}if(ah!==b){if(typeof(ag)!=="string"){ag=""+ag}if(typeof(ah)!=="string"){ah=""+ah}e=D(ai,aj,ah,ag)}return e};var D=function(ai,ah,ak,aj){var am;var ag=ai.getAttribute("operator");if(typeof(ag)!=="string"){ag="="}ag=ag.toLowerCase();if(u[ag]){ag=u[ag]}if(n[ag]===b){ag="="}if(aj===b){aj=ai.getAttribute("value")}if(aj===null){aj=""}var e=n[ag];if(ag.match(/[<,>]+/)){var an=function(ao){ao=parseFloat(ao);if(isNaN(ao)){am=false}return ao};ak=an(ak);aj=an(aj)}else{ak=decodeURIComponent(ak)}if(am===b){am=e(ak,aj)}if(E.on){E.log("Evaluating condition: "+ah+": "+ak+" "+ag+" "+aj+" => "+am)}if(am===true){if(ai._myTagName!==b){var al={};al.nodeType=1;al.tagName=ai._myTagName;al.childNodes=[ai];ai=al}p.parseConfig(ai,ai)}return am};var T={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var U={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var S;var N=function(){if(S===b){S={};for(var e in T){S[T[e]]=e}}return S};var s=function(aj,ai,ah){if(ah===b){ah=""}var al=ah+"left";if(aj[al]===b){return}var ak=ah+"top";var ag=ah+"right";var e=ah+"bottom";if(ai==="pixelrange"){aj[ag]=aj[ag]-aj[al];aj[e]=aj[e]-aj[ak]}aj[ai]=aj[al]+","+aj[ak]+","+aj[ag]+","+aj[e];if(aj[al]){delete aj[al]}if(aj[ak]){delete aj[ak]}if(aj[ag]){delete aj[ag]}if(aj[e]){delete aj[e]}};var ad=this.mapImageParametersToViewer=function(e){s(e,"rect");s(e,"pixelrange","pixel");var ag=N();e=X(e,N())};var ac=this.mapImageParametersToServer=function(e){X(e,T)};var X=function(ag,e){for(var ah in ag){if(e[ah]&&ah!==e[ah]){ag[e[ah]]=ag[ah];delete ag[ah]}}};this.reWriteImageURLByConditions=function(am){if(p.arConditions.length<1){return am}if(typeof(am)!=="string"||am.length<1){return am}var ah=am.indexOf("?");if(ah===-1){return am}var ag=p.clone();var aj={};p.parseQuery(am,aj);ad(aj);p.evaluateQuery(aj,ag.cfg);var e=ag.evaluateConditions();if(!e){return am}var al;for(al in aj){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}for(al in U){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}ac(aj);var ai=am.substr(0,ah);var ak=ai+"?"+p.objectToQuery(aj);return ak};var q=this.applyConditions=function(){if(p.arConditions.length<1){return}if(p.cfgBeforeConditions===b){p.cfgBeforeConditions=a.cloneObject(p.cfg)}p.cfg=p.cfgBeforeConditions;return j()};var aa=0;var j=this.evaluateConditions=function(){if(p.arConditions.length<1){return false}var ag=false;for(var ah=aa;ah<p.arConditions.length;ah++){var ai=p.arConditions[ah];if(ai.fsiConfigEvaluated){continue}aa++;var aj=ai.getAttribute("parameter");if(typeof(aj)==="string"){aj=aj.toLowerCase();var e;if(aj.charAt(0)==="@"){e=H(ai,aj)}else{e=w(ai,aj)}if(!ag&&e){ag=e}}}return ag};var P=function(){q();p.serverProfile=p.cfg.fpxservertemplate;p.serverProfileDoublePage=p.cfg.fpxservertemplatedoublepage;if(p.serverProfileDoublePage==b){p.serverProfileDoublePage="doublepage"}p.serverBase=p.cfg.fpxserver;if(p.serverBase==b){E.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+p.locationFSIViewer+")");var ag;ag=p.locationFSIViewer.indexOf("/users/");if(ag!=-1){p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}else{ag=p.locationFSIViewer.indexOf("/viewer/");p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}E.log("Derived server location is: ["+p.serverBase+"]")}p.requestBase=p.serverBase;V={};var e=p.cfg;for(var ah in U){if(e[ah]!==b){V[ah]=e[ah]}}if(V.fpxsrc!==b){V.fpxsrc=decodeURIComponent(V.fpxsrc)}e=p.cfg.effects;if(e!=b){p.cfg.effectsUnFiltered=e;p.cfg.effects=e=m(e)}if(e!=b){V.effects=e}e=p.cfg.lefteffects;if(e!=b){V.lefteffects=e}e=p.cfg.righteffects;if(e!=b){V.righteffects=e}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){p.setEffectsFilter(p.getAreaEffects())};this.setEffectsFilter=function(ai){if(typeof(ai)!=="string"||ai.length<1){Q=false;return}ai=a.trim(ai);var ag=ai.split(",");for(var ah=0;ah<ag.length;ah++){ag[ah]=a.escapeRegEx(ag[ah])}var e="(^|[=,]+)("+ag.join("|")+")\\([^)]*\\)";Q=new RegExp(e,"ig")};var m=function(e){if(Q===false){return e}return e.replace(Q,"")};var l=function(){for(var ag in p.plugins){var ah=ag.toLowerCase();var e=p.makeBool(p.cfg[ah],true);if(!e){p.plugins[ag]=b}}};this.finalCheck=function(){p.elevateToHTTPS();l();P();p.dumpConfig();if(z.onConfigsReady){z.onConfigsReady()}};this.dumpConfig=function(ah){if(!ah){ah=E}if(ah.on){if(p.cfg.fpxsrc!==b){p.cfg["fpxsrc (decoded)"]=decodeURIComponent(p.cfg.fpxsrc)}ah.info("Evaluated Configuration:",K(p.cfg));if(p.queryParameters){ah.info("Parameters:",K(p.queryParameters))}if(W){ah.info("Class <"+v+"> Configuration:",K(W))}var ag=p.getPluginsAndParameters();var e=ag.data;if(ag.count===0){e="No active plugins."}ah.info("Plugin Configuration:",K(e))}};var K=function(ah){var e="--- none ---";if(typeof(ah)!=="object"){return e}for(var ag in ah){e=ah;break}return e};this.getPluginsAndParameters=function(){var e={};var ah=0;for(var ag in p.plugins){if(p.hasPlugin(ag)){e[ag]=L(ag);ah++}}return{count:ah,data:e}};var F=this.addQueryParameterToURL=function(ai,e,ah){var ag=ai.lastIndexOf("?");if(ag===-1){ai+="?"}else{if(ag!==ai.length-1){ai+="&"}}return ai+encodeURIComponent(e)+"="+encodeURIComponent(ah)};var ae=p.finishURL=function(e){if(y){e=F(e,x,y)}if(!R||e==b){return e}var ag;if(C===false){ag="cache=0&cachernd="+t;if(e.indexOf("?")==-1){e+="?"+ag}else{e+="&"+ag}}else{ag=C;if(e.indexOf("?")==-1){e+="?"+ag}else{e+=ag}}return e};this.addURLParameters=function(ag,ah){if(!ag||!ah){return ag}var e=[];for(var ai in ah){e.push(encodeURIComponent(ai)+"="+encodeURIComponent(ah[ai]))}if(e.length>0){if(ag.indexOf("?")==-1){ag+="?"}else{ag+="&"}ag+=e.join("&")}return ag};this.finishRequestParams=function(ag){if(R){if(C===false){ag.cache=0;ag.cachernd=t}else{for(var e in A){ag[e]=A[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=t};this.parseQuery=function(ag,e){if(e==b||ag==b||ag.length<1){return}p.queryToObject(ag,e);if(e.ignorequeryparameters!=b){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=b){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,ag){if(e==b||ag==b){E.error("Cloning object failed: "+e+" / "+ag)}for(var ah in e){ag[ah]=e[ah]}};this.getFSIPath=function(e,ag){if(ag.indexOf("//")!=-1){return ag}if(p.cfg.fsibase!=b){ag=p.cfg.fsibase+ag}return p.getReloadPath(e,ag)};this.expandFSIPath=function(ag){if(ag==b){return ag}var e=a.urlDecode(ag);if(e.indexOf("?")!=-1||e.indexOf(p.strConfigFileExtension)==(e.length-4)){return ag}return ag+p.strConfigFileExtension};this.getReloadPath=function(ai,ak){var ag,al,e,aj;if(ai==b){ai=p.locationFSIViewer}if(ak==b){ak=""}var ah="/";if(ak.indexOf("//")!=-1){return ak}ag=ai;aj=ag.lastIndexOf("?");if(aj==-1){aj=ag.length}al=ag.lastIndexOf("\\",aj);e=ag.lastIndexOf("/",aj);al=Math.max(al,e);if(al==-1){al=ag.length-1}ag=ag.slice(0,al);if(ag.length>0&&ak.indexOf(ah)!=0){ag+=ah}return ag+ak};this.cloneValueObject=function(ag){var e={};for(var ah in ag){e[ah]=ag[ah]}return e};this._getXMLConfigValue=function(e){var ag;if(!e){return}if(e.childNodes.length>0){ag=p._XMLChildNodesToString(e)}else{ag=e.getAttribute("value")}return ag};this._XMLChildNodesToString=function(ai){if(!ai||!ai.firstChild){return""}var ag="";var ah;try{if(ai.xml!=b){for(ah=0;ah<ai.childNodes.length;ah++){ag+=ai.childNodes[ah].xml}}else{for(ah=0;ah<ai.childNodes.length;ah++){ag+=p.XMLSerializer.serializeToString(ai.childNodes[ah])}}}catch(aj){}return ag};this._findFirstXMLNode=function(ah,ai){var ag,e;while(ah){if(ah.nodeName==ai){e=ah;break}ag=ah.firstChild;if(!ag){ag=ah.nextSibling}if(!ag&&ah.parentNode){ag=ah.parentNode.nextSibling}ah=ag}return e};this._parseXMLImageList=function(ag){var e=p._findFirstXMLNode(ag,"images");if(!e){e=p._findFirstXMLNode(ag,"images3d")}return p.parseXMLImageListNode(e)};this._parseXMLImageListNode=function(aj){var am={};var e=am.arImages=[];var ai="";var ak="";var ah;if(!aj){return am}var ag;ag=p.getAttributeValue(aj,"prefix");if(typeof(ag)=="string"){ai=ag}ag=p.getAttributeValue(aj,"suffix");if(typeof(ag)=="string"){ak=ag}aj=p._findFirstXMLNode(aj,"image");if(!aj){return am}while(aj){if(aj.nodeType==1){ah=p._findFirstXMLNode(aj,"path");var al=p._getXMLConfigValue(ah);if(!al){al=a.urlDecode(p.getAttributeValue(aj,"src"))}if(!al){al=a.urlDecode(p.getAttributeValue(aj,"file"))}if(al!=b){e.push(ai+al+ak)}if(am.width==b){ah=p._findFirstXMLNode(aj,"width");ah=p._getXMLConfigValue(ah);if(ah!=b){am.width=parseInt(ah)}ah=p._findFirstXMLNode(aj,"height");ah=p._getXMLConfigValue(ah);if(ah!=b){am.height=parseInt(ah)}}}aj=aj.nextSibling}return am};this.getImageList=function(){var e,ai;if(p.cfg&&p.cfg.fpxsources!=b){var ah=p.cfg.fpxsources;if(typeof(ah)=="string"||(typeof(ah)=="object")&&typeof(ah.push)=="function"){e={};e.oXML=null;if(typeof(ah)=="string"){e.arImages=ah.split(",");for(ai=0;ai<e.arImages.length;ai++){e.arImages[ai]=a.urlDecode(e.arImages[ai])}}else{e.arImages=ah}return e}}if(p.arUnrecognizedConfigNodes&&p.arUnrecognizedConfigNodes.length>0){var ag=p.arUnrecognizedConfigNodes;for(ai=0;ai<ag.length;ai++){var aj=ag[ai];if(typeof(aj.nodeName)=="string"){var ak=aj.nodeName.toLowerCase();if(ak=="images"||ak=="images3d"){if(E.on){E.log("Reading image list from XML node: <"+aj.nodeName+">")}e=p._parseXMLImageListNode(aj);e.oXML=aj;break}}}}if(p.cfg&&p.cfg.fpxsrc!=b){e={};e.oXML=null;e.arImages=[];e.arImages.push(a.urlDecode(p.cfg.fpxsrc));return e}return e};this.getServerBase=function(){return p.serverBase};this.loadImageList=function(ai,aj,al,ak){if(!p.serverBase||!ai){aj([],b,ak);return false}var ah=p.serverBase+"?type=list";if(ai.indexOf("tpl")==-1){var ag=p.cfg.listtemplate;if(ag&&ag.length>0&&ag.indexOf(".json")==-1&&ag.indexOf(".xml")==-1){ag+=".json"}ah+="&tpl="+ag}if(p.cfg.headers&&p.cfg.headers.length>0&&A.headers==b){ah+="&headers="+p.cfg.headers}if(typeof(p.cfg.imagelistlimit)==="string"&&p.cfg.imagelistlimit.length>0){ah+="&limit="+encodeURIComponent(p.cfg.imagelistlimit)}ah+="&source="+encodeURIComponent(ai);if(al!=b){ah+=al}ah=ae(ah);var e=p.loadFile(ah,function(am,ap){if(typeof(ap)=="object"&&typeof(ap.images)=="object"){ap.images.pop();var aq="";if(ap&&ap.imagesattributes&&ap.imagesattributes.dir){aq=ap.imagesattributes.dir}var an=new Array(ap.images.length);for(var ao=0;ao<ap.images.length;ao++){an[ao]=aq+ap.images[ao].src}aj(an,ap,ak)}else{aj([],ap,ak)}},"application/json",ak);return e};this.traceConfigValue=function(e,ai){if(typeof(e)!=="string"){return false}e=a.trim(e);if(e.length<1){return false}var ag=e.toLowerCase();if(ag.indexOf(".")!==-1){ag=ag.split(".").join("")}if(ag.indexOf("/")!==-1){ag=ag.split("/").join("")}if(ag.indexOf(" ")!==-1){ag=ag.split(" ").join("")}var ah=new a.Debugger();ah.setPrefix("");ah.group('Tracing parameter "'+e+'"');var aj=function(){var ak=e;var ap=p.getParameterAlias(ag);if(typeof(ap)==="string"){ak+=" (alias: "+ap+")";if(typeof(p.cfgAliasNames[ag])==="string"){ag=p.cfgAliasNames[ag]}}var al=p.cfg[ag];var ao=true;if(ag.indexOf("_")!==-1){var an=ag.split("_");var am=an.shift();var aq=an.join("_");if(p.hasPlugin(am)){al=p.getPluginParameter(am,aq)}}else{if(p.hasPlugin(ag)){ao=false;al="is enabled."}}if(al===b){ao=false;al="is undefined (default value applies)"}if(ao){al='= "'+al+'"'}ah.group("RESULT:");ah.log(ak+" "+al);ah.groupEnd();ah.groupEnd()};z={onConfigsReady:aj};g.strTraceParam=ag;g.bNoDebug=true;p.iTraceParameterDebug=ah;p.init(ai);p.loadConfigs();return""};this.loadLanguageFile=function(e,aq,aj,ah){var ak=arguments;var al,ao;if(typeof(aq)!=="string"||p.makeBool(aq,true)==false){return aj.call(p,{},"")}var ap=function(ar){try{a.oLanguageMap=JSON.parse(ar.responseText)}catch(at){a.oLanguageMap={"default":"english"}}p.loadLanguageFile.apply(this,ak)};var am=function(ar,av){e.urlLanguageCurrentLoaded=al;var au=e.oLanguageData={};if(av){var at=p.findXMLNode(av,"data");if(at){at=p.findXMLNode(at,"tip")}while(at){if(at.nodeType===1){var aw=at.getAttribute("id");au[aw]=p.XMLChildNodesToString(at)}at=at.nextSibling}}aj.call(p,e.oLanguageData,ao)};if(aq.toLowerCase()==="auto"){if(!a.oLanguageMap){p.loadFile(a._FSIViewerLocation+"/languages/mapping.json",ap,"application/json");return}if(a.oLanguageMap._current!==b){aq=a.oLanguageMap._current}else{aq=a.oLanguageMap["default"];var ai=navigator.language;if(typeof(ai)==="string"){ai=ai.toLowerCase()}if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}else{if(ai.indexOf("-")!=-1){ai=ai.split("-")[0];if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}}}}if(aq==b){return aj.call(p,{},"")}if(ah){ah.log('Automatically choosing language "'+aq+'" from navigator.language "'+navigator.language+'"')}a.oLanguageMap._current=aq}var an=aq+".xml";var ag=a._FSIViewerLocation+"/languages/"+an;if(ag!==e.urlLanguageCurrentLoaded){ao=aq;al=ag;if(ah){ah.log("Loading language file: "+ag)}p.loadFile(ag,am,"application/xml")}else{aj.call(p,e.oLanguageData,ao)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.eventElementID++}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.eventFunctionID++}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerDocumentZoom!=b){return}a.CustomEventListenerDocumentZoom=a.oCustomEventListenerClasses.FSIDocumentZoomChange=function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!=c){if(q){j()}else{i()}}};var m=function(p){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var p;var q=a.getDocumentScaleWithPixelRatio();if(g!=q){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerElementDimension!=b){return}a.CustomEventListenerElementDimension=a.oCustomEventListenerClasses.FSIElementDimension=function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)=="function";a.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerViewport!=b){return}a.CustomEventListenerViewport=a.oCustomEventListenerClasses.FSIViewport=function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!=b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!=b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!=d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!=b){return}w=setTimeout(K,N);K()};var K=function(){if(w!=b){clearTimeout(w);w=b}var e=false;var U=L();if(C!=U){C=U;e=true;f()}return e};var J=function(){n=a.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.topWindow);T=a.getBoundingClientRect(a.topWindow.document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.topWindow);T=a.getBoundingClientRect(a.topWindow.document.documentElement);h.left=a.topWindow.pageXOffset;h.top=a.topWindow.pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!=b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!=b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u==b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!=b){if(U==b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length==0){r()}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(n,aY,am,e,aO){var aF=this;var aM=false;var al=true;var p=false;var aU=false;var aL=false;var aC,F,j,ae;var aD,Z,aJ;var h=false;var af;var s;var a1={};var ar=[];var ad=0;var J=window;var aW;var t;var aV;var d;var a0=[];var aS={x:0,y:0};var w={x:0,y:0};var at=40;var o={};o.enabled=false;o.factor=5;o.fEndDiff=1;var az={};az.enabled=false;az.minFrames=14;az.factorAmount=23;az.factorAmountQuad=0;az.factorFrames=2.6;az.offsetFrames=5;var ac;var aA;var aI,x,l;var G;var au={};var Y;var aN=false;var A=false;var an={};an.name="none";var O;var X;var aP;var f=false;var aa={};if(!aY||typeof(aY)!="object"){aY={}}var ao=function(){var a7;if(aM){aF.destroy()}aV=B;t=b;if(a.topWindow!=window){t=a.topWindow;try{var a6=a.getWindowOffset(window);if(a6.x!=b&&a6.y!=b){aV=aq}}catch(a5){aV=B;t=b}}else{t=b}G=aY.oPassTrough;aX(aY.panDirectionAllowed,true);if(aY.getPageCoords){s=aG}else{s=N}if(aY.afterTouch){for(a7 in aY.afterTouch){az[a7]=aY.afterTouch[a7]}}if(az.minDelta==b){az.minDelta=15}if(aY.nClickRadius){ac=aY.nClickRadius}else{ac=10}if(az.fnStartStopAfterTouch&&typeof(az.fnStartStopAfterTouch)!="function"){az.fnStartStopAfterTouch=b}if(az.fnStartStopAfterTouch){az.useAnimationFrame=b}if(typeof(az.modifyTarget)!="function"){az.modifyTarget=b}if(typeof(az.fnGetAfterTouchEnabled)=="function"){aA=az.fnGetAfterTouchEnabled}else{aA=b}if(aY.smoothing){for(a7 in aY.smoothing){o[a7]=aY.smoothing[a7]}}if(aY.detectClick==true){Y=true}if(aY.preventSelection!==false){aY.preventSelection=true}if(!n){return}if(typeof(n.join)!="function"){n=[n]}if(typeof(am)!="function"){am=B}if(typeof(e)!="function"){e=B}if(typeof(aO)!="function"){aO=B}if(typeof(aY.onPinchChange)=="function"){O=aY.onPinchChange}else{O=b}aN=aY.detectGestures;a0=[];ay(true,aN);for(var a4=0;a4<n.length;a4++){var a3=n[a4];if(a3&&typeof(a3.nodeName)!="undefined"){a7={};a7.element=a3;a0.push(a7);ap(a3,S);if(a.isTouch){try{if(a3.style!=b){if(a.BrowserSupports.cssTouchAction()){if(au.cssTouchAction!=b){r(a3,au.cssTouchAction)}}}}catch(a5){}}}}if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aE,false)}};var aX=this.setAllowedPanDirection=function(a4,a3){if(typeof(a4)=="string"){if(a4=="pan-x"||a4=="pan-y"||a4=="pan-x pan-y"){aW=a4+" "}else{aW=""}}else{aW=""}if(!a3){au.nCheck=b;ai(au.captureScroll,au.capturePinch)}};this.enable=function(a3){if(al==a3){return}if(!a3){R();ai(false,false)}else{ai(au.captureScrollUser,au.capturePinchUser)}al=a3};this.getEnabled=function(){return al};this.cancel=function(){Q();ah();aK();R()};var aK=function(){if(o.enabled){i()}C()};this.cancelAfterTouch=function(){C()};this.getInitialDownEvent=function(){return X};var R=function(){if(!p){return}aK();p=false;X=b;A=false;if(ad==0){aQ()}};var aQ=function(){f=false;c()};this.destroy=function(){if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aE,false)}if(aP){clearTimeout(aP)}aF.cancel();var a3;for(var a4=0;a4<a0.length;a4++){var a5=a0[a4];a3=a5.element;y(a3,S)}au={}};var r=function(a3,a4){if(!a.BrowserSupports.cssTouchAction()||!a3||!a3.style){return}a3.style.touchAction=a3.style.msTouchAction=a4};var U=function(a3){if(a3.preventDefault){a3.preventDefault()}};var m=function(a3){U(a3);return false};var ap=function(a4,a3){a.addEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{a.addEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a4,"touchstart",a3);a.addEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a4,"MSPointerDown",a3)}a.addEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var y=function(a4,a3){a.removeEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{a.removeEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a4,"touchstart",a3);a.removeEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a4,"MSPointerDown",a3)}a.removeEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var B=function(){return true};var aR=function(a3){if(aL){W(a3,a3.pointerId)}else{var a4=a3.changedTouches;for(var a5=0;a5<a4.length;a5++){W(a4[a5],a4[a5].identifier)}}};var W=function(a3,a5){if(a5==b||a1[a5]!=b){if(aY.debug){if(a5==b){a.console.error("doRegisterPointer: no pointerId")}if(a1[a5]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a5)}}return}ad++;var a4=a1[a5]={};a4.identifier=a5;s(a4,a3);ar.push(a4)};var ak=function(a3){var a5=false;if(aL){a5=L(a3.pointerId)}else{var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){a5=L(a4[a6].identifier)}}}if(a5){ar=new Array(ad);var a8=0;for(var a7 in a1){ar[a8++]=a1[a7]}}};var L=function(a3){if(a3==b||a1[a3]==b){if(aY.debug){if(a3==b){a.console.error("doUnregisterPointer: no pointerId")}if(a1[a3]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+a3)}}return false}delete a1[a3];ad--;return true};var I=function(){ad=0;a1={};ar=[]};var N=function(a4,a3){a4.x=a3.clientX;a4.y=a3.clientY};var aG=function(a4,a3){a4.x=a3.pageX;a4.y=a3.pageY};var v=function(a3){var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){var a5=a1[a4[a6].identifier];if(a5){s(a5,a4[a6])}}}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y}};var ax=function(a3){var a4=a1[a3.pointerId];if(a4){s(a4,a3)}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y;aV(a3,aS)}};var V=function(a3){s(aS,a3);aV(a3,aS)};this.getMousePositionFromMouseEvent=function(a3){V(a3);return aS};this.getMousePositionPage=function(a4){var a3={};aG(a3,a4);aV(a4,a3);return a3};this.getMousePositionClient=function(a4){var a3={};N(a3,a4);aV(a4,a3);return a3};var u=function(a3,a4){if(window!=a3.view){var a5=a.getWindowOffset(window);a4.x-=a5.x;a4.y-=a5.y}};var aq=function(a3){try{u(a3);aV=u}catch(a4){aV=B}};var aB=function(a3){if(!al){return}var a5=ad;if(A&&a5==0){A=false}var a6=a3.type;if(p||an.started){if(a6!=aC){if(an.started){Q();ah()}else{a3._FSI_Canceled=true;a2(a3,true)}}}aC=a6;d=false;var a4=true;switch(a6){case"touchstart":aU=true;aL=false;af=v;j="touchmove";F="touchend";ae="touchcancel";aI=false;break;case"MSPointerDown":af=ax;aU=true;aL=true;j="MSPointerDown";F="MSPointerUp";ae="MSPointerCancel";aI=false;d=true;break;case"pointerdown":af=ax;aU=true;aL=true;j="pointermove";F="pointerup";ae="pointercancel";aI=true;d=true;break;default:if(ad>0){I()}aU=false;aL=false;aI=(aY.preventSelection);a4=false;af=V;j="mousemove";F="mouseup";ae=b;d=true}if(aU&&a4){aR(a3)}af(a3);if(!aY.bAllowMouseDown&&aI){U(a3)}if(ad>1){aa.bClick=false}x=false;if(a4&&aj(a3)){if(a5==0){C();E()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ad};var S=function(a3){if(aY.bMouseOnly&&a3.type==="pointerdown"&&a3.pointerType!=="mouse"){return true}if(!aB(a3)){return}if(p||a3.which>1){return}g(a3)};this.getCurrentPos=function(){return w};var g=function(a3){aK();if(p){return}az.evtMove=b;if(o.enabled){w={x:aS.x,y:aS.y}}else{w=aS}aa.x=aS.x;aa.y=aS.y;var a4=X;X=a3;if(!am.call(J,a3,w,G)){X=a4;return false}p=f=true;if(Y&&!A){aa.bClick=true;aa.clickRadiusX=aa.clickRadiusY=0}else{aa.bClick=false}E();if(az.enabled){az.x=az.y=0;az.lastX=aS.x;az.lastY=aS.y;if(az.nInterval){clearInterval(az.nInterval)}az.nInterval=setInterval(ab,30)}return true};var c=function(){if(h&&Z!=b){var a3={passive:false,capture:false};var a5=(t==b)?a3:b;h=false;a.removeEvent(window,Z,ag,a5);a.removeEvent(window,aD,a2,a5);if(d&&t){try{a.removeEvent(t,Z,ag,a3);a.removeEvent(t,aD,a2,a3)}catch(a4){}}if(aJ!=b){a.removeEvent(window,aJ,av,a5)}Z=aD=aJ=b}};var aE=function(a3){};var E=function(){if(h){c()}h=true;var a3={passive:false,capture:false};var a5=(t==b)?a3:b;Z=j;aD=F;aJ=ae;a.addEvent(window,Z,ag,a5);a.addEvent(window,aD,a2,a5);if(d&&t){try{a.addEvent(t,Z,ag,a3);a.addEvent(t,aD,a2,a3)}catch(a4){}}if(ae!=b){a.addEvent(window,aJ,av,a5)}};var ag=function(a3){af(a3);a3.FSI_start_x=aa.x;a3.FSI_start_y=aa.y;if(az.enabled&&az.evtMove==b){az.evtMove=a3}if(p){if(aa.bClick){aa.clickRadiusX=Math.max(aa.clickRadiusX,Math.abs(aS.x-aa.x));if(aa.clickRadiusX>ac){aa.bClick=false}else{aa.clickRadiusY=Math.max(aa.clickRadiusY,Math.abs(aS.y-aa.y));if(aa.clickRadiusY>ac){aa.bClick=false}}}if(o.enabled){o.evt=a3;aZ()}else{e.call(J,a3,w,G)}}else{if(an.started){if(an.nType==1){aw(a3)}}}if(x&&!a3.FSI_allowEventDefault){U(a3)}};var aw=function(a3){var a4=k();if(!O){return}a3._FSI_PinchDeltaStart=an.nPinchDistance-an.pinchDistanceStart;a3._FSI_PinchDeltaRelative=an.nPinchDistance-an.pinchDistanceLast;a3._FSI_PinchScale=Math.max(at,an.pinchDistanceLast)/an.pinchDistanceStartMaxed;an.pinchDistanceLast=an.nPinchDistance;a3._FSI_PinchDistance=a4;O.call(J,a3,aS,G)};var av=function(a3){if(aU){ak(a3);if(ad<1){if(p){a3._FSI_Canceled=true;a2(a3,true);return}else{R();return}}}af(a3);aj(a3)};var a2=function(a4,a5){var a3=aa.bClick;aa.bClick=false;if(a5){a4._FSI_Canceled=true}if(aU){ak(a4)}if(ad==0){aQ()}af(a4);if(!a5&&aj(a4)){return}aK();if(!a5){if(!p||ad>0){return}}a4.FSI_start_x=aa.x;a4.FSI_start_y=aa.y;var a6=false;if(!a5&&az.enabled){if(aA==b||aA()){a6=T(a4)}}if(a6){R();z(a4)}else{if(Y){a4._FSI_Click=a3}aO.call(J,a4,w,G);if(a4.type=="touchend"){aP=setTimeout(q,1)}R()}U(a4)};var q=function(){R();I();aP=b};var H=function(a3){return ar};var aZ=function(){if(o.animationFrame!=b){return}aT()};var i=function(){if(o.animationFrame==b){return}cancelAnimationFrame(o.animationFrame);o.animationFrame=b};var aT=function(){var a3=Math.abs(w.x-aS.x)+Math.abs(w.y-aS.y);if(a3>o.fEndDiff){w.x+=(aS.x-w.x)/o.factor;w.y+=(aS.y-w.y)/o.factor;o.animationFrame=requestAnimationFrame(aT)}else{w.x=aS.x;w.y=aS.y;o.animationFrame=b}e.call(J,o.evt,w,G)};var T=function(a3){var a4;if(!az.enabled){return false}if(az.running){C()}az.pos=0;var a6=(a3.touches!=b)?1.8:1;if(az.factorAmountQuad){a4=(az.x>0)?1:-1;az.x=az.x+a4*az.x*az.x/az.factorAmountQuad;a4=(az.y>0)?1:-1;az.y=az.y+a4*az.y*az.y/az.factorAmountQuad}var a8=a6*az.factorAmount;az.startX=w.x;az.startY=w.y;var a7={};a7.x=az.startX+a8*az.x;a7.y=az.startY+a8*az.y;if(az.roundTargetPos){a7.x=Math.round(a7.x);a7.y=Math.round(a7.y)}if(az.modifyTarget){a7=az.modifyTarget.call(J,a7,G);if(a7===false){return false}}az.amountX=a7.x-az.startX;az.amountY=a7.y-az.startY;az.amountXABS=Math.abs(az.amountX);az.amountYABS=Math.abs(az.amountY);var a5=(az.amountXABS>az.minDelta||az.amountYABS>az.minDelta);if(a5){a8=az.factorFrames/100;az.frames=az.offsetFrames+Math.round(a8*az.amountXABS+a8*az.amountYABS)}else{if(typeof(aY.onAfterTouchCancel)=="function"){aY.onAfterTouchCancel.call(J,a3,w,G)}}return a5};this.isAfterTouchRunning=function(){return az.running};var z=function(a3){if(typeof(aY.onAfterTouchStart)=="function"){aY.onAfterTouchStart.call(J,a3,w,G)}az.running=true;az.evtUp=a3;if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,true,az.evtMove,G)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}else{az.intervalRun=setInterval(K,16)}}return true};var aH=function(a4,a3,a6,a5){return a6*((a4=a4/a5-1)*a4*a4+1)+a3};var K=this.runAfterTouch=function(){var a3=false;az.pos++;w.x=aH(az.pos,az.startX,az.amountX,az.frames);w.y=aH(az.pos,az.startY,az.amountY,az.frames);e.call(J,az.evtMove,w,G);if(az.pos===az.frames){C(true)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}a3=true}return a3};this.enableAfterTouch=function(a3){if(az.enabled==a3){return}if(!a3){C()}az.enabled=a3};var C=function(a3){if(!az.running){return}if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,false,az.evtMove,G)}else{if(az.useAnimationFrame){if(az.animationFrameRun){cancelAnimationFrame(az.animationFrameRun)}}else{if(az.intervalRun){clearInterval(az.intervalRun);az.intervalRun=b}}}if(typeof(aY.onAfterTouchEnd)=="function"){aY.onAfterTouchEnd.call(J,az.evtMove,G)}az.evtMove=b;az.running=false;az.evtUp._FSI_Canceled=(a3!==true);az.evtUp._FSI_fromAfterTouch=true;aO.call(J,az.evtUp,w,G)};var ab=function(){az.x=(2*az.x+aS.x-az.lastX)/5;az.y=(2*az.y+aS.y-az.lastY)/5;az.lastX=aS.x;az.lastY=aS.y};var ay=this.setCapture=function(a3,a5){var a4=ai(a3,a5);if(a4){au.captureScrollUser=a3;au.capturePinchUser=a5}return a4};var ai=function(a3,a5){var a4=0;if(a3){a4+=2}if(a5){a4+=4}if(a4==au.nCheck){return}au.nCheck=a4;au.captureScroll=a3;au.capturePinch=a5;if(a.BrowserSupports.cssTouchAction()){P(a3,a5)}return true};var P=function(a3,a7){if(aY.bMouseOnly){return}var a6;switch(au.nCheck){case 0:a6="auto";break;case 2:a6=aW+"pinch-zoom";break;case 4:a6="pan-x pan-y";break;default:a6=(aW.length>0)?aW:"none"}au.cssTouchAction=a6;for(var a5=0;a5<n.length;a5++){var a4=n[a5];r(a4,au.cssTouchAction)}};var k=function(){if(ar.length<1){return 0}var a4=Math.abs(ar[1].x-ar[0].x);var a3=Math.abs(ar[1].y-ar[0].y);return an.nPinchDistance=Math.sqrt(a4*a4+a3*a3)};var aj=function(a3){x=false;if(!al){return}var a4=ar.length;if(!aN){x=(a4==1&&au.captureScroll);return}if(an.pointerCount!=a4){Q(a3);if(a4>1){ah();an.nPointers=a4;switch(a4){case 2:an.started=true;an.name="pinch";an.nType=1;if(typeof(aY.onPinchStart)=="function"){M(a3);an.nPinchDistance=0;an.nPinchDistance=k();an.pinchDistanceStart=an.pinchDistanceLast=an.nPinchDistance;an.pinchDistanceStartMaxed=Math.max(at,an.pinchDistanceStart);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchStart.call(J,a3,aS,G)}break;default:an.started=true;an.name="unknown";an.nType=-1}if(an.started){A=true;if(p){aK();p=false;a3._FSI_Canceled=true;aO.call(J,a3,w,G)}if(typeof(aY.onGestureStart)=="function"){M(a3);aY.onGestureStart.call(J,a3,aS,G)}}}else{if(a4<1){ah()}}an.pointerCount=a4;x=false;if(a4==1){if(au.captureScroll){x=true}}else{if(au.capturePinch&&an.nType==1){x=true}}}return an.started};var ah=function(){if(!an.timeoutRestartDown){return}clearTimeout(an.timeoutRestartDown);an.timeoutRestartDown=b};var D=function(){if(ad!=1){return}g(X);ah()};var M=function(a3){a3._FSI_Gesture=an.name;a3._FSI_GestureType=an.nType;a3._FSI_PointerCount=an.nPointers};var Q=function(a3){if(!an.started){return}an.started=false;if(!a3){a3={}}if(an.nType==1&&typeof(aY.onPinchEnd)=="function"){M(a3);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchEnd.call(J,a3,aS,G)}if(typeof(aY.onGestureEnd)=="function"){M(a3);aY.onGestureEnd.call(J,a3,aS,G)}an.name="none";an.nType=0;if(a3&&ad==1){ah();an.timeoutRestartDown=setTimeout(D,20)}};ao()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.callbackFunctionID++}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a._API_Thumbar!==b){return}a._API_ThumbBar=function(d,e){var c=this;c.scriptMainFile="FSI.ThumbBar.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},assignFSIViewer:{a:"iFSIViewerInstance"},buttonDown:{a:"strCommand",r:"bSuccess"},buttonUp:{r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeDir:{a:"strDirectory",r:"bSuccess"},closeZoom:{a:"evt, bImmediate"},destroy:{},firstImage:{a:"nAnimationFrames"},focusImage:{a:"nImage"},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getImageCount:{r:"nImages"},getInitDone:{r:"bDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getScrollPos:{r:"fPosition"},getVersion:{r:"strVersion"},init:{a:"elementID, oParameters, bDebug"},isScrolling:{r:"bScrolling"},lastImage:{a:"nAnimationFrames"},nextImage:{a:"nAnimationFrames"},nextPage:{a:"nAnimationFrames"},previousImage:{a:"nAnimationFrames"},previousPage:{a:"nAnimationFrames"},printAPI:{},registerButton:{a:"DOMElement, strCommand",r:"bSuccess"},setScrollPos:{a:"fPosition, nAnimationFrames",r:"fPosition"},startAutoRotate:{a:"fSpeed"},stopAutoRotate:{},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unRegisterButton:{a:"DOMElement",r:"bSuccess"},zoomImage:{a:"nImage"}};c.oCallbacks={onClick:{a:"nIndex, oItem"},onConfigsReady:{a:"oConfigValues"},onDestroy:{},onFocus:{a:"nImageIndex, strImagePath"},onInit:{a:"oParameters)"},onMouseEnter:{a:"nIndex, oItem)"},onMouseLeave:{a:"nIndex, oItem)"},onScrollStart:{a:"fPosition"},onScrollEnd:{a:"fPosition"},onSetScrollRange:{a:"fTotalSize, fRange, bEndlessScrolling, nTotalImages"},onStart:{a:"strDirectory, nImages, arImagePaths"},onZoomEnd:{},onZoomReady:{a:"nImageIndex, strZoomedImageURL, elZoomedImage"},onZoomStart:{a:"nImageIndex, strImageURL"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ThumbBar!==b){return}a.ThumbBar=function(cn){var dZ={};var ab={strVersion:"2018",strBuild:"18.06.18.8",strConfigSection:"ThumbBar",bHasListeners:true};var bm=new a.ClassDef(this,"FSI ThumbBar",ab);bm.oAPI=new a._API_ThumbBar(this,dZ);var az=bm.instance;a.guessFSIViewerLocation("fsithumbbar.js",3);var bX=a.getViewerInstanceID();this.getInstanceID=function(){return bX};this.getInstanceName=function(){return bm.strClassName+" ["+A+"]"};var cg=(cn)?a.cloneParameters(cn):{};var dd;var cS;var aw;var cW;var dP;var v;var A;var cd;var aX,aJ;var bN,df;var cY=0;var dM=false;var cN;var cx,b2,cf,R,P;var cM;var cy;var dq={};var ac;var dR=false;var S;var ao;var ca;var aC,aq,a2;var E;var cE={};var b6;var cQ;var aa;var d3=[];var cF,F;var Y;var ba,dT;var ea;var d;var bp;var dk=100;var aU;var ce=0;var bV={};var c4;var ck=0;var e;var d7=false;var du=0;var ch;var di;var T;var dY={};var bG={};var cT={};var dy;var Q;var al;var y,ae;var dp;var aY;var bf;var cD;var bE={};var av;var b3,bQ;var dC;var an;var ay={};var G;var dQ=false;var dI;var bi;var bk=false;var b1=false;var C;var b8,dA;var a1;var c0=false;var aM;var eg;var aP;var cH;var cv;var d5;var X,dg,a8;var c8=0;var aK=0;var aD;var da;var c9,bt;var bq=[];var a0;var W;var d6={};var cl;var be=(a.isMobileDevice)?" mobile":"";var aO={};var bg={};var b0,c5;var cG={};var ag;var cC;var dv=0;var dj;var h;var cz;var bM;var dS;var c1={};var dn;var ap;var a6;var bF={};var dh=0;var c7=0;var aW=512;var c3={ts:0,dist:0};var cX={passive:true,capture:false};var a7=/((\?)|&)(width|height)=[^&]*/ig;var bu=("filter" in document.body.style)?"filter":"webkitFilter";var u;var cV;var aE;var ci;var bR={};var V=0;var dx=(a.isMobileDevice)?8:16;var at=[];var aT=0;var ad;var dl="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";var d9=true;var dJ;var dX;var j;var o;var aL={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",format:"",headers:"cors",presentationType:"flat",elementWidth:"10%",elementSpacing:"0.25%",placeHolderImage:"default",placeHolderPadEffect:"Pad(CC,FFFFFF)"},booleans:{autoDestroy:true,autoResize:true,depthFadeout:true,enableZoom:true,ScrollBar:true,centerZoomedImage:true,endlessScrolling:false,useTouchZoom:true,vertical:false},floats:{autoRotateSpeed:0,Alignment:1,PerspectiveAlignment:1,zoomShaderStartOpacity:0,zoomShaderEndOpacity:0.8},integers:{initialImage:0,preloadCount:40,paddingTop:10,paddingBottom:0,garbageCollectionSize:-1}};var bP=new a.EmptyDebugger();var ee=function(ej,ei){if(ei&&!bP.on&&ej.on){if(dI){dI.stopPendingRequests()}az.destroy(true);az.init(dJ,cg,true);return true}bP=ej;if(bP.on){bP.setPrefix(az.getInstanceName())}};var bK=function(ej,eo,ei){var el;var ek;dJ=ej;if(!ej){return}if(typeof(ej)==="object"){if(typeof(ej.id)==="string"){A=ej.id}}else{if(typeof(ej)==="string"){A=ej}}if(!A){A="fsi.thumbbar #"+bX}if(az._fsi_parameters){eo=az._fsi_parameters;delete az._fsi_parameters}if(typeof(ej)==="object"&&ej.tagName!==b){el=ej}else{el=document.getElementById(ej)}if(!el){return}if(dM){az.destroy()}el.setAttribute("x-fsi-id",A);cg=(eo)?a.cloneParameters(eo):cg;var ep={};ep.onConfigsReady=b9;ep.onDebuggerChange=ee;dI=new a.Config(null,ep,{strSection:bm.strConfigSection});bi=dZ.iCallbacks=new a.Callbacks(az,dI);if(bi.isset("onInit")){bi.runPersistent("onInit",[cg])}var en=cg;if(ei){en=a.cloneObject(cg);en.debug=true}dI.init(en);bP.log(az.getVersion());ad=document.createElement("img");ad.crossOrigin="anonymous";cN=el;el.innerHTML="";cx=document.createElement("div");var em="fsi-thumbbar-root";if(a.isMobileDevice){em+=" mobile"}cx.className=em;ek="position:relative;width:100%;height:100%;border:0 none;margin:0px;padding:0px;overflow:hidden;";a.setStyleAttr(cx,ek);b2=document.createElement("div");b2.className="fsi-thumbbar-container";ek="position:absolute;z-index:1;width:100%;height:100%;border:0 none;margin:0px;padding:0px;";ek+="text-align:left;vertical-align:top;";ek+="perspective:100px;perspective-origin:50% 100%;pointer-events:none;";if(a.isInternetExplorer){ek+="transform-style:preserve-3d;"}else{ek+="transform-style:flat;"}a.setStyleAttr(b2,ek);cx.appendChild(b2);cN.appendChild(cx);aH();dM=true;dP={};dI.loadConfigs()};this.getConfigValue=function(ei){if(dI&&typeof(ei)==="string"){return dI.cfg[a.trim(ei.toLowerCase())]}};this.getParameters=function(){return a.cloneParameters(cg)};var dU=function(ei){if(cE.bImageDragging){return}if(a.now()-c3.ts<25&&c3.dist>10){return}c3.ts=0;cf.style.pointerEvents="none";b2.style.pointerEvents="all";var ej=document.elementFromPoint(ei.clientX,ei.clientY);if(ej&&ej.oSprite){bh(ej.oSprite)}cf.style.pointerEvents="all";b2.style.pointerEvents="none"};var bh=function(ei){if(bi.isset("onClick")){bi.run("onClick",[ei.nIndex,ei])}if(dP.enableZoom){J(ei)}if(dP.centerZoomedImage){a4(ei)}};var br=function(ei){if(ei===cf[E]){return}cf[E]=ei;cE.bIgnoreEvent=true;cE.bIgnoreEventPos=cf[E]};var dm=function(){if(cE.bIgnoreEvent){cE.bIgnoreEvent=false;var el=cE.bIgnoreEventPos;cE.bIgnoreEventPos=false;if(cf[E]===el){return}}if(cE.bImageDragging){if(!v.isAfterTouchRunning()){return}}var ej=(ca)?cf.offsetHeight:cf.offsetWidth;if(ej!==S){return}var ei=cf[E];var ek=ch;if(T){ek=by(ei,c8)}M(-ei,true,ek,1)};var by=function(ei,el){var ek;var ej=Math.abs(Math.round(ei+el));if(ej<20){ek=0}else{ek=Math.floor(Math.max(0,Math.min(20,ej/45)))}return ek};var Z=function(){dK();c8=0};var dK=function(){at=[];ak();if(bf){bf.style.display="none"}for(var ei=0;ei<bq.length;ei++){bj(bq[ei])}Y={};bF={};dq={};at=[];bq=[];dh=0;cY=0;ck=0;b0=0;cY=0;return true};var b9=function(){dK();dy={};cv=b;d5=b;if(dI.cfg.viewerselector){az.assignFSIViewer(dI.cfg.viewerselector)}if(dI.cfg.viewerid){az.assignFSIViewer(dI.cfg.viewerid)}var ej=dI.cfg.dir;if(!ej||ej.length===0){var ei=dI.getImageList();if(ei){aQ(ei.arImages,ei)}}else{dI.loadImageList(dI.cfg.dir,aQ)}if(bi.isset("onConfigsReady")){bi.runPersistent("onConfigsReady",[a.cloneObject(dI.cfg)])}};var cI=function(ei,ej){bi.run("onChangeConfig",[ei,ej]);if(bP.on){a.console.log("")}if(ej!==null&&typeof(ej)==="object"){cg=a.cloneParameters(ej)}if(typeof(ei)==="string"){cg.cfg=ei}az.destroy(true);bP=new a.EmptyDebugger();az.init(dJ,cg)};var ec=function(ei){if(typeof(ei)!=="string"){return false}Z();dI.cfg.dir=ei;b9();return true};var aQ=function(ei,ej){if(!dM){return}if(!ei){ei=[]}cv=ej;d5=(cv&&cv.images&&cv.images[0]&&cv.images[0].width!==b&&cv.images[0].height!==b);d3=ei;du=ei.length;bP.log("Image list loaded ("+d3.length+" images)");cc();aI()};var cc=function(){bd(dP)};var dH=function(ej,ei,em,ek){for(var el in em){ei[el]=ej.getFloatParameter(ek+el,em[el])}};var cj=function(ej,ei,em,ek){for(var el in em){ei[el]=ej.getIntParameter(ek+el,em[el])}};var bL=function(ek,ej,ei,el){for(var em in ei){ej[em]=ek.getStringParameter(el+em,ei[em])}};var p=function(ej,ei,el,ek){for(var em in el){ei[em]=ej.makeBool(ej.getStringParameter(ek+em),el[em])}};var bA=function(ej,ei,el,ek){var em;if(el&&el.length>0){if(ei[el]===b){ei[el]={}}ek=ek[el];em=ei[el]}else{em=ei}if(ek.strings){bL(ej,em,ek.strings,el)}if(ek.booleans){p(ej,em,ek.booleans,el)}if(ek.floats){dH(ej,em,ek.floats,el)}if(ek.integers){cj(ej,em,ek.integers,el)}};var bd=function(ei){if(ei===b){ei={}}ei.serverBase=dI.serverBase;bA(dI,ei,"",aL);var el=/[\dabcdef]{3,6}/i;for(var em in aL.strings){if(em.indexOf("Color")!==-1){var ek=dP[em];if(ek.indexOf("#")!==0){var ej=ek.match(el);if(ej){if(ej[0].length===ek.length&&(ej[0].length===3||ej[0].length===6)){dP[em]="#"+ej[0]}}}}}};var ai=function(ek){var ej,ei;if(typeof(ek)==="string"){ei=ek.indexOf("%");ej=parseFloat(ek)}else{ei=-1;ej=ek}if(ei!==-1){ej=Math.round(X.width*ej/100)}return{val:ej,bRelative:(ei!==-1)}};var db=function(){var ej,ei;ej=ai(dP.elementWidth);if(isNaN(ej.val)){ej=ai(aL.strings.elementWidth)}ei=bE.width=Math.max(1,ej.val);if(ca){ci=ei}else{aP=ei}bE.widthRelative=ej.bRelative;ej=ai(dP.elementSpacing);if(isNaN(ej.val)){ej=ai(aL.strings.elementSpacing)}cH=bE.spacing=ej.val;bE.spacingRelative=ej.bRelative};var w=function(){if(!cf){return}a.removeEvent(cf,"scroll",dm,cX);a.removeEvent(cf,"click",dU);if(j!==b){aV()}if(!a.isMobileDevice){a.removeEvent(cf,"mouseenter",I)}cx.removeChild(cf);cf=b};var aH=function(){cf=document.createElement("div");cf.className="fsi-thumbbar-scroll-bar";var ei="z-index:2;width:100%;height:100%;margin:0px;padding:0px;border:0 none;position:absolute;overflow:hidden;-webkit-overflow-scrolling:touch;";a.setStyleAttr(cf,ei);P=document.createElement("div");a.setStyleAttr(P,"width:1px;height:1px;visibility:hidden;");cf.appendChild(P);cx.appendChild(cf);a.addEvent(cf,"scroll",dm,cX);a.addEvent(cf,"click",dU);if(!a.isMobileDevice){a.addEvent(cf,"mouseenter",I)}};var d2=function(){if(!R){return}a.removeEvent(R,"scroll",U,cX);a.removeEvent(R,"mouseup",bs);a.removeEvent(R,"pointerup",bs);a.removeEvent(R,"touchend",bs);cx.removeChild(R);R=b};var q=function(){if(a.isInternetExplorer&&G>0){cf.style.display="";if(!R){bP.info("Using scroll bar optimization");R=document.createElement("div");R.className="fsi-thumbbar-scroll-bar fake";var ei="z-index:20;width:0px;height:0px;margin:0px;padding:0px;border:0 none;position:absolute;overflow:hidden;-webkit-overflow-scrolling:touch;";a.setStyleAttr(R,ei);cx.appendChild(R);a.addEvent(R,"scroll",U,cX);a.addEvent(R,"mouseup",bs);a.addEvent(R,"pointerup",bs);a.addEvent(R,"touchend",bs)}R.style.overflowX=cf.style.overflowX;R.style.overflowY=cf.style.overflowY;while(R.firstChild){R.removeChild(R.firstChild)}R.appendChild(P.cloneNode(false));if(ca){R.style.width=G+"px";R.style.height="100%";if(d9){R.style.bottom="";if(!cC){R.style.right="0px"}else{R.style.right=-G+"px"}cf.style.width=(cf.offsetWidth+G)+"px"}}else{R.style.width="100%";R.style.height=G+"px";if(d9){if(!cC){R.style.bottom="0px"}else{R.style.bottom=-G+"px"}R.style.right="";cf.style.height=(cf.offsetHeight+G)+"px"}}aY=aj;bf=R;cM=true}else{d2();aY=a.fnDoNothing;bf=cf;cM=false;if(cC){cf.style.display="";if(ca){cf.style.width=(cf.offsetWidth+G)+"px"}else{cf.style.height=(cf.offsetHeight+G)+"px"}}}};var aj=function(ei){R[E]=ei;cE.bIgnoreFakeEvent=true;cE.bIgnoreFakeEventPos=R[E]};var bs=function(){br(-c8)};var U=function(){if(cE.bIgnoreFakeEvent){cE.bIgnoreFakeEvent=false;var el=cE.bIgnoreFakeEventPos;cE.bIgnoreFakeEventPos=false;if(R[E]===el){return}}var ej=(ca)?R.offsetHeight:R.offsetWidth;if(ej!==S){return}var ei=R[E];var ek=ch;if(T){ek=by(ei,c8)}M(-ei,true,ek,2)};var aI=function(){dG();dT=dP.initialImage;var ei={debug:false,useimagetiles:false,usedevicepixelratio:false,imgsrcattributename:"src",scanOnInit:false};if(dP.useTouchZoom){if(typeof(a.TouchZoom)!=="function"){bP.error("FSI TouchZoom script missing")}else{dd=new a.TouchZoom(ei);dd.init(false,true);aw=setInterval(cm,500)}}else{if(dd){dd.destroy();dd=b}}ca=dP.vertical;C=dP.presentationType.toLowerCase();bk=dP.endlessScrolling;s();b0=d3.length;X=a8=dg=cb();cV=dP.autoRotateSpeed;db();cF=a.cloneArray(d3);if(cv&&cv.images){F=a.cloneArray(cv.images)}else{F=b}Y={};if(dP.autoResize===true){if(eg===b){eg=a.addCustomEvent(cN,"FSIElementDimension",ax);a.setCustomEventListenerProperty(eg,"treshold",200)}}else{if(eg!==b){a.removeCustomEvent(cN,"FSIElementDimension",ax);eg=b}}ar()};var d1=function(){var ek=bm.strClassName;if(!a.cssClassExists(ek)){var ei="div.fsi-thumbbar-container img{\n\tposition:absolute!important;\n\t-moz-backface-visibility: hidden;\n\t-ms-backface-visibility: hidden;\n\t-webkit-backface-visibility: hidden;\n\tbackface-visibility: hidden;\n\ttransform-origin: center;\n\tbox-sizing: content-box;\n}\n";ei+="div.fsi-thumbbar-container.stacks,\ndiv.fsi-thumbbar-container.ring {\n\t-webkit-transform: translate3d(0, 0, 0);;\n\ttransform: translate3d(0, 0, 0);\n}\n";ei+="div.fsi-thumbbar-container.custom,\ndiv.fsi-thumbbar-container.ring img{\n\twill-change: transform,filter;\n}\n";ei+="div.fsi-thumbbar-container.stacks img{\n\twill-change: transform;\n}\n";ei+="div.fsi-thumbbar-container img.placeholder.none{\n\tdisplay:none;\n}\n";ei+="div.fsi-thumbbar-container img.placeholder.blank{\n\tbackground-color:#eee;\n}\n";var ej="R0lGODlhFwAXAIABAMzMzAAAACH5BAEAAAEALAAAAAAXABcAAAI5jI+py30AYwyyoiophncDvXWh9z0eiIkpqVqsOZ7wKjt2m70Gq6Nu7csBecNTjxia/ZI7I/AGjSYKADs=";ei+="div.fsi-thumbbar-root div.fsi-thumbbar-container img.placeholder.default,\ndiv.fsi-thumbbar-root div.fsi-thumbbar-container img.placeholder.custom{\n\tbackground-color:#eee;\n\tbackground-repeat:no-repeat;\n\tbackground-position:bottom center;\n\tbackground-image:url(data:image/gif;base64,"+ej+");\n}\n";ei+="div.fsi-thumbbar-shader{\n\tposition:absolute;\n\tz-index:10000;\n\tbox-sizing:border-box;\n\tbackground-color:#FFF;\n\topacity:0;\n}\n";ei+="div.fsi-thumbbar-zoom-div{\n\tposition:absolute;\n\tz-index:10001;\n\tmargin:0px!important;\n\tbox-sizing:content-box;\n\tbackground-color:#FFF;\n\tline-height:0;\n}\n";a.addCSSClass(ek,ei)}};var aR=function(ej){var ei;if(d5&&cv.images[ej]){ei=cv.images[ej]}return ei};var aF=function(ej){var ei=typeof(ej);if(ei==="string"){ej=window[ej];ei=typeof(ej)}return(ei==="function")?ej:false};var ar=function(){dA=b;if(ca){E="scrollTop";aC=dD;aq=cP;a2=b4}else{E="scrollLeft";aC=t;aq=d0;a2=ds}aT++;b6=dP.Alignment;cQ=dP.PerspectiveAlignment;if(!dP.depthFadeout){ao=false}else{ao=(!a.isInternetExplorer||a.versionInternetExplorer>11)}var ej=Q={};if(dP.effects.length>0){ej.effects=dP.effects;ea="&effects="+dP.effects}else{ea=""}if(dP.overlays.length>0){ej.overlays=dP.overlays}if(dP.quality.length>0){ej.quality=dP.quality}if(dP.format.length>0){ej.format=dP.format}if(dP.fpxservertemplate.length>0){ej.renderer=dP.fpxservertemplate}d1();aA();dQ=false;if(cF.length<1){return}cf.style.display="";if(ca){cf.style.width="100%";aa=-1;cf.style.overflowX="hidden";cf.style.overflowY="auto";P.style.height=2*X.width+"px";G=(cf.offsetWidth-cf.scrollWidth);S=cf.offsetHeight}else{cf.style.height="100%";aa=1;cf.style.overflowX="auto";cf.style.overflowY="hidden";P.style.width=2*X.width+"px";G=(cf.offsetHeight-cf.scrollHeight);S=cf.offsetWidth}cf.style.display="none";cC=!dP.ScrollBar;ag=(d3.length<2);if(ag){cC=true}T=(G>0);ch=(G>0&&!a.isChrome)?1:0;av=0;ck=0;aT++;if(d3.length!==cF.length){d3=a.cloneArray(cF);if(F&&cv){cv.images=a.cloneArray(F)}}b0=d3.length;bv();e=false;c9=X.width/2;b1=false;var en=C;cD=false;ae=false;switch(C){case"stacks":cy=de;break;case"flat":cD=true;cy=c;b1=!bk;dP.zoomCenteredImageOnly=false;if(!bk){e=true;c9=da/2}break;case"custom":var ek=aF(dI.cfg.custompresentationfunction);if(ek){y=ek}else{y=d4}ek=aF(dI.cfg.custompresentationinitfunction);if(ek){ae=ek}cy=a9;break;default:en="ring";dR=(C!=="innerring");cy=bD;C="carousel";break}a.addClass(b2,en);if(ca){c9-=ci/2}else{c9-=aP/2}var ei=(ca)?ci:aP;bt=(X.width-ei)/2/Math.sin(1);if(C!=="stacks"){var em;if(dR){em=1}else{em=0.75}bt=Math.sin(1)*(em*X.width)}bt=Math.round(bt);ac=10*Math.ceil(X.width/ei);b2.style.perspective=bt+"px";dy.width=aP;dy.height=ci;cR();a3();if(!a.isMobileDevice){cJ()}if(aM!==b){var el=aM.offsetLeft/aM.nAdvance;c8=el*da;aM=b}c8=r(c8);bS();dQ=true;if(ci<1){bP.error("Insufficient instance height. Resulting image height is "+ci+"px");return}b3=b5;bQ=aG;dc()};var bv=function(){var ej=X.height;if(!cC&&T){ej-=G}var ei=ej-dP.paddingTop-dP.paddingBottom;if(ca){aP=ei;da=ci+cH}else{ci=ei;da=aP+cH}};var bS=function(){var ei;if(ca){ei=dP.paddingTop+cQ*aP;b2.style.perspectiveOrigin=ei+"px "+X.width/2+"px"}else{ei=dP.paddingTop+cQ*ci;b2.style.perspectiveOrigin=X.width/2+"px "+ei+"px"}};var dc=function(){al=b;if(ca){dy.width=Math.min(dy.width,dy.height)}else{dy.height=Math.min(dy.width,dy.height)}if(dP.placeHolderImage.length<1){dP.placeHolderImage="none"}var ej=dP.placeHolderImage.toLowerCase();switch(ej){case"blank":case"default":case"custom":ad.src=dl;df="placeholder "+ej+be;dy.nMode=1;m();break;case"none":df="placeholder none"+be;m();dy.nMode=1;break;default:df="placeholder image"+be;dy.nMode=2;var ek=aR(0);if(ek){dL(null,ek)}else{var ei=dI.getImageInfoURL(d3[ba]);dI.loadFile(ei,dL)}}ad.className=df};var dL=function(ek,ei){cr(dy,ei);var ej=aB(dy.maxWidth,dy.maxHeight,aP,ci);dy.width=ej.width;dy.height=ej.height;dy.bHasPadEffect=true;dy.objCropCurrent=false;ad.src=cK(dy,dP.placeHolderImage,{effects:dP.placeHolderPadEffect});m()};var m=function(){if(!b8&&dP.enableZoom){if(!cW){cW=a.addCustomEvent(az,"FSIViewport",cU);a.setCustomEventListenerProperty(cW,"treshold",150);a.setCustomEventListenerProperty(cW,"fireTresholdEventOnly",true);a.triggerCustomEvent(cW)}}else{if(cW){a.removeCustomEvent(az,"FSIViewport",cU);cW=b}}d={scope:az,elementID:A,nMaxThumbWidth:da,totalWidth:X.width,totalHeight:X.height,nPerspective:bt,nHorizontalFactor:aa};if(ae){ae.apply(this,[d])}c6();if(bk){if(b0===1){d3.push(d3[0]);if(cv&&cv.images){cv.images=cv.images.concat(cv.images)}b0++}var ej=0;while(d3.length<=bq.length+2){ej++;d3=d3.concat(d3);if(d5){cv.images=cv.images.concat(cv.images)}b0=d3.length}}c5=b0-1;av=d3.length;a3();if(cl<=0){cC=true}bv();ba=Math.max(0,Math.min(b0-1,dT));c8=r(ba*-da);if(dP.garbageCollectionSize<0){if(a.isMobileDevice){aU=2*(dP.preloadCount+bq.length)}else{aU=Math.max(250,6*(dP.preloadCount+bq.length))}}else{if(dP.garbageCollectionSize===0){aU=b0}else{aU=Math.max(dP.preloadCount+bq.length,dP.garbageCollectionSize)}}var ei;if(e){ei=da*b0}else{ei=X.width+(da*b0);if(!bk){ei-=da}}bi.runPersistent("onSetScrollRange",[ei,ei-X.width,bk,b0]);if(ca){P.style.height=ei+"px";if(cD){b2.style.height=ei+"px"}}else{P.style.width=ei+"px";if(cD){b2.style.width=ei+"px"}}q();bf.style.display="";if(dP.preloadCount>0){cG.bEnabled=true;cd=bT}else{cG.bEnabled=false;cd=a.fnDoNothing()}n();if(cV){cO()}bp=a.now();if(aU<b0){bP.info("Enabling garbage collection (max. "+aU+" images)")}else{bP.info("Garbage collection disabled");bU()}br(-c8);if(cM){aj(-c8)}b7()};var cU=function(ei){aX=ei.FSI_viewport_rect;aJ=ei.FSI_client_rect_body_top};var dG=function(){if(document.querySelectorAll===b){return}var ei=dI.cfg.cmdbuttonselector;if(typeof(ei)!=="string"){return false}var el=document.querySelectorAll(ei);for(var ej=0;ej<el.length;ej++){var ek=el[ej].getAttribute("x-fsi-cmd");if(typeof(ek)==="string"&&ek.length>0){bP.log("Registering button from config for command: "+ek);az.registerButton(el[ej],ek)}}dI.cfg.cmdbuttonselector=b};var cR=function(){if(b0<1){dC=dN}else{if(b1){dC=ct}else{dC=c2}}};var b7=function(){if(bi.isset("onStart")){bi.runPersistent("onStart",[dP.dir,d3.length,a.cloneArray(d3)])}aN(0);bw()};var a3=function(){cl=b0*da;if(!bk){if(C==="flat"){cl-=X.width}else{cl-=da}}};var cJ=function(){if(!X||X.width<1||X.height<1){return false}if(a.isIETouch){cx.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}if(!v){var ei={};ei.bMouseOnly=true;ei.afterTouch={enabled:true};ei.afterTouch.factorAmount=25;ei.afterTouch.factorFrames=3;ei.afterTouch.minFrames=5;ei.afterTouch.offsetFrames=1;ei.afterTouch.useAnimationFrame=true;ei.detectGestures=false;v=new a.TouchHandler(cf,ei,cp,K,dr);v.setCapture(true,false)}};var B=function(ej,ei){return ej};var cp=function(ei,el,ek){c3.ts=0;bg.x=el.x;bg.y=el.y;if(G>0){var ej=cf.getBoundingClientRect();if(ca){if(el.x-ej.left>ej.width-G){return false}}else{if(el.y-ej.top>ej.height-G){return false}}}eh();cV=0;cancelAnimationFrame(W);W=b;c8=r(c8);v.enableAfterTouch(true);cE.bImageDragging=true;aO.startX=bg.x;aO.startY=bg.y;aO.offsetLeft=c8;D();return true};var K=function(ei,el,ej){bg.x=el.x;bg.y=el.y;if(cE.bImageDragging){if(ca){aO.dy=bg.x-aO.startX;aO.dx=bg.y-aO.startY}else{aO.dx=bg.x-aO.startX;aO.dy=bg.y-aO.startY}if(!d7){dO(true)}var ek=c8;c8=r(aO.offsetLeft+aO.dx);D();if(cM){aY(-c8)}else{br(-c8)}if(ek===c8||Math.abs(aO.dy)>3*Math.abs(aO.dx)){ei.FSI_allowEventDefault=true}}};var dr=function(ej,en,el){bg.x=en.x;bg.y=en.y;if(cE.bImageDragging){cE.bImageDragging=false;dO(false);if(cM){br(-c8)}}var ek=en.x-ej.FSI_start_x;var ei=en.y-ej.FSI_start_y;var em=Math.sqrt(ek*ek+ei*ei);c3.ts=a.now();c3.dist=em;D()};var N=function(ek,el){var ei=false;el=Math.ceil(el);if(isNaN(el)||el<0){el=0}if(isNaN(ek)){return false}ek=ek%cl;var ej=M(-ek,false,el);if(ej!==false){ei=d6.end}return ei};var dV=function(ei){cE.bSetIsScrolling=ei;if(di){clearTimeout(di)}di=setTimeout(O,100)};var O=function(){dO(cE.bSetIsScrolling);di=b;cG.nLoad=dP.preloadCount;b3()};var dO=function(ei){if(di){clearTimeout(di);di=b}if(ei===d7){return}d7=ei;if(d7){bi.run("onScrollStart",[-c8])}else{bi.run("onScrollEnd",[-c8])}};var aN=function(ei){dv=ei;a6=b;if(bi.isset("onFocus")){var ej=Y[ei];if(ej){bi.runPersistent("onFocus",[ej.nIndex,d3[ej.nIndex]])}}};var bw=function(){if(!dM||!b8||a1||!Y||!Y[ba]){return}L(Y[ba]);a1=true;co(Y[ba])};var co=function(ei){if(!ei||!b8||typeof(b8.changeImage)!=="function"){return}if(dA===ei.nIndex){return}dA=ei.nIndex;var ej={};ej.fpxsrc=d3[ei.nIndex];ej.imageWidth=ei.sourceWidth;ej.imageHeight=ei.sourceHeight;ej.cropRect=dI.cfg.croprect;ej.cropValues=dI.cfg.cropvalues;ej.effects=dI.cfg.effects;b8.changeImage(ej)};var J=function(er){if(er.bError){return}L(er);if(b8!==b){co(er);return}dw(b,true);if(!er.bReady){return}var eC=document.body.scrollWidth;var ex=document.body.scrollHeight;var eF=a.getDocumentScaleWithPixelRatio();var eu=aX.left-aJ.left;var el=aX.top-aJ.top;dj=document.createElement("div");h=document.createElement("div");h.style.willChange="opacity";bM=document.createElement("img");c1.alphaShader=0;dj.setAttribute("class","fsi-thumbbar-zoom-div");dS=er.nIndex;cz=er.img.cloneNode();cz.style.transform="";cz.style.position="static";cz.style[bu]="none";var ey=er.img.getBoundingClientRect();cz.style.width=cz.style.height="100%";dj.appendChild(cz);document.body.appendChild(dj);var ek=a.getElementClientPos(document.body);var ew=-ek.left;var ev=-ek.top;var ep=a.getElementBorders(dj);var en=a.getElementPaddings(dj);c1.startX=ew+ey.left-ep.left;c1.startY=ev+ey.top-ep.top;c1.startWidth=ey.width;c1.startHeight=ey.height;dj.style.width=c1.startWidth+"px";dj.style.height=c1.startHeight+"px";dj.style.left=c1.startX+"px";dj.style.top=c1.startY+"px";dj.style.willChange="left,top,width,height";var eE=a.getViewportSize(window);a.addEvent(h,"mousedown",dw,false);a.addEvent(window,"touchstart",dw,false);a.addEvent(dj,"mousedown",dw,false);a.addEvent(window,"scroll",dw,false);var eB=Math.ceil(40/eF);var ej=eE.width-eB-ep.left-ep.right-en.left-en.right;var eD=eE.height-eB-ep.top-ep.bottom-en.top-en.bottom;var es=er.maxWidth;var eA=er.maxHeight;if(ej/es<eD/eA){es=ej;eA=Math.round(es*er.maxHeight/er.maxWidth)}else{eA=eD;es=Math.round(eA*er.maxWidth/er.maxHeight)}if(es>er.maxWidth||eA>er.maxHeight){es=er.maxWidth;eA=er.maxHeight}c1.endWidth=es;c1.enddHeight=eA;c1.dWidth=es-c1.startWidth;c1.dHeight=eA-c1.startHeight;c1.endX=eu+Math.round((eE.width-es-ep.left-ep.right-en.left-en.right)/2);c1.endY=el+Math.round((eE.height-eA-ep.top-ep.bottom-en.top-en.bottom)/2);c1.dx=c1.endX-c1.startX;c1.dy=c1.endY-c1.startY;var eq="left:"+eu+"px;top:"+el+"px;";if(eF===1){eq+="width:100%;height:100%"}else{var em=aX.width();var et=aX.height();if(eu+em>eC){em-=eu+em-eC}if(el+et>ex){et-=el+et-ex}eq+="width:"+em+"px;height:"+et+"px"}c1.bImageReady=false;var eo=er.img.src;eo=eo.replace(a7,"$1");var ei=Math.min(er.maxWidth,Math.round(eF*es));var ez=Math.min(er.maxHeight,Math.round(eF*eA));eo+="&width="+ei+"&height="+ez;aE=true;a.addEvent(bM,"load",bH,false);bM.style.width=c1.endWidth+"px";bM.style.height=c1.endHeight+"px";bM.setAttribute("crossorigin","anonymous");bM.src=eo;c1.pos=0;c1.frames=bC(32);a.setStyleAttr(h,eq);h.setAttribute("class","fsi-thumbbar-shader");document.body.appendChild(h);c1.alphaShader=dP.zoomShaderStartOpacity;cancelAnimationFrame(dn);dn=requestAnimationFrame(aS);c1.posFader=0;c1.framesShader=bC(12);c1.startAlpha=c1.alphaShader;c1.endAlpha=dP.zoomShaderEndOpacity;c1.dAlpha=c1.endAlpha-c1.startAlpha;c1.bRemoveOnEnd=false;ap=requestAnimationFrame(f);bi.run("onZoomStart",[er.nIndex,eo]);if(!a.isMobileDevice){a.addEvent(window,"resize",dw,false)}else{a.addEvent(window,"orientationchange",dw,false)}};var bl=a.Easing.easeOutCubic;var aS=function(){c1.pos++;if(c1.pos>c1.frames){dn=b;requestAnimationFrame(cA);return}var ei=bl(c1.pos,c1.frames,c1.startX,c1.dx);var el=bl(c1.pos,c1.frames,c1.startY,c1.dy);var ej=bl(c1.pos,c1.frames,c1.startWidth,c1.dWidth);var ek=bl(c1.pos,c1.frames,c1.startHeight,c1.dHeight);dj.style.left=ei.toFixed(2)+"px";dj.style.top=el.toFixed(2)+"px";dj.style.width=ej.toFixed(2)+"px";dj.style.height=ek.toFixed(2)+"px";dn=requestAnimationFrame(aS)};var cA=function(){if(!dj||!c1.bImageReady||dn!==b){return}dj.replaceChild(bM,dj.firstChild);dj.firstChild.style.width=bM.style.width;dj.firstChild.style.height=bM.style.height;dj.firstChild.src=bM.src;dj.style.width="";dj.style.height="";dj.style.willChange="auto";h.style.willChange="auto";bi.run("onZoomReady",[dS,bM.src,bM]);bM=b};var bH=function(){c1.bImageReady=true;a.removeEvent(bM,"load",bH,false);aE=false;cA()};var dw=this.closeZoom=function(ei,ej){if(!dj){return}L();a6=b;if(!a.isMobileDevice){a.removeEvent(window,"resize",dw,false)}else{a.removeEvent(window,"orientationchange",dw,false)}if(ap){cancelAnimationFrame(ap);ap=b}cancelAnimationFrame(dn);dn=b;a.removeEvent(h,"mousedown",dw,false);a.removeEvent(dj,"mousedown",dw,false);a.removeEvent(window,"touchstart",dw,false);a.removeEvent(window,"scroll",dw,false);if(aE){a.removeEvent(bM,"load",bH,false)}if(bM){bM=b}a.removeChild(dj.parentNode,dj);dj=b;if(ej===true){a.removeChild(h.parentNode,h);h=b}else{h.style.willChange="opacity";c1.posFader=0;c1.framesShader=10;c1.startAlpha=c1.alphaShader;c1.endAlpha=0;c1.dAlpha=c1.endAlpha-c1.startAlpha;c1.bRemoveOnEnd=true;ap=requestAnimationFrame(f)}bi.run("onZoomEnd");if(ei&&ei.touches&&ei.touches.length===1){ei.cancelBubble=true;if(ei.stopPropagation){ei.stopPropagation()}if(ei.preventDefault){ei.preventDefault()}}dS=b};var cs=function(ei){h.style.opacity=c1.alphaShader=ei};var f=function(){c1.posFader++;if(c1.posFader>c1.framesShader){if(c1.bRemoveOnEnd){a.removeChild(h.parentNode,h);h=b}ap=b;return}var ei=bl(c1.posFader,c1.framesShader,c1.startAlpha,c1.dAlpha,3);cs(ei);ap=requestAnimationFrame(f)};var a4=function(ej,ei){if(!ej){return false}aN(ej.nIndex);return M(-ej.nIndex*da,ei,30)};var r=function(ei){if(bk){ei=Math.round(ei)%cl;if(ei>0){ei-=cl}}else{ei=Math.min(0,Math.max(-cl,ei))}return ei};var bC=function(ei){if(a.isMobileDevice){ei=Math.ceil(ei/1.3)}return ei};var M=function(em,ej,el,ei){if(ag){return}if(el===b){el=40}if(el>0){el=bC(el)}eh();if(bk&&!ej){em=r(em);c8=r(c8);var ek=em-c8;if(Math.abs(ek)>cl/2){if(ek>0){em=-cl+em}else{em=cl+em}}}if(em===c8||(W!==b&&em===d6.end)){return false}dO(true);cancelAnimationFrame(W);W=b;d6.frames=el;d6.pos=0;d6.nScrollBarID=ei;d6.start=c8;d6.end=em;if(!ei&&((bk&&ej)||!bk)){d6.end=r(d6.end)}d6.diff=d6.end-d6.start;if(el<1){l()}else{W=requestAnimationFrame(l)}return true};var l=function(){d6.pos++;if(d6.pos>=d6.frames){c8=d6.end;if(d6.bUpdateVisibleScrollBar){bf[E]=-c8}dV(false);W=b;n();bZ();if(cM&&d6.nScrollBarID!==2){aY(-c8)}if(!d6.nScrollBarID){br(-c8)}dW();return}c8=bl(d6.pos,d6.frames,d6.start,d6.diff,3);if(!bk){c8=r(c8)}if(cM&&d6.nScrollBarID!==2){aY(-c8)}else{if(!d6.nScrollBarID){br(-c8)}}n();bZ();W=requestAnimationFrame(l)};var cw=function(ek){if(d5){var ej=aR(ek.nIndex);dF(ek,ej)}else{if(ek.sourceWidth!==b){dF(ek,{width:ek.sourceWidth,height:ek.sourceHeight})}else{ek.bInfoLoading=true;var ei=dI.getImageInfoURL(d3[ek.nIndex]);dI.loadFile(ei,k,b,ek)}}};var k=function(ei,ej,ek){ej.width=parseInt(ej.width);ej.height=parseInt(ej.height);if(isNaN(ej.width)){dB.call(ek.img)}dF(ek,ej)};var cr=function(ek,ei){if(ek.bImageInfoCalculated){return}ek.bImageInfoCalculated=true;ek.nThumbnailDimWidth=aP;ek.nThumbnailDimHeight=ci;ek.bInfoReady=true;ek.sourceWidth=ei.width;ek.sourceHeight=ei.height;if(bR.bLive){H(ek)}var ej=(bR.bCrop&&!ek.bNoCropping);if(ej){ek.rectWidth=bR.rectWidth;ek.rectHeight=bR.rectHeight}ek.src=ea;a.expandSourceDimensionForPadEffect(ek,aP,ci);if(ej){ek.objCropCurrent=(ek.oCrop)?ek.oCrop:bR;ek.maxWidth=Math.round(ek.objCropCurrent.rectWidth*ek.sourceWidth);ek.maxHeight=Math.round(ek.objCropCurrent.rectHeight*ek.sourceHeight)}else{ek.maxWidth=ek.sourceWidth;ek.maxHeight=ek.sourceHeight}if(dy.nMode===1){au(ek,ek.maxWidth,ek.maxHeight)}};var dF=function(ej,ei){if(!dM){return}if(!ei||!ej||ej.nStartID!==aT){return}cr(ej,ei);eb(ej)};var bc=function(ei){if(ca){ei.offsetX=(ci-ei.height)/2;ei.offsetY=b6*(aP-ei.width)+dP.paddingTop}else{ei.offsetX=(aP-ei.width)/2;ei.offsetY=b6*(ci-ei.height)+dP.paddingTop}};var cK=function(el,ek,ei){if(ei===b){ei={};for(var ej in Q){ei[ej]=Q[ej]}}ei.width=el.width;if(el.objCropCurrent){ei.rect=el.objCropCurrent.query}if(el.bHasPadEffect){ei.height=el.height}return dI.getImageURL(ek,ei)};var aB=function(ei,ej,ek,em){var el={};if(ek/ei<em/ej){el.width=Math.min(ek,ei);el.height=Math.round(el.width*ej/ei)}else{el.height=Math.min(em,ej);el.width=Math.round(el.height*ei/ej)}return el};var eb=function(ek){if(!ek.bInfoReady||ek.bThumbLoadStarted){return false}ek.tsRemovedFromDOM=bp;var ei=ek.img;ek.nThumbnailDimWidth=aP;ek.nThumbnailDimHeight=ci;ek.bThumbLoadStarted=true;ek.nStartID=aT;if(ek.width<1||ek.height<1){dB.call(ei)}else{V++;var ej=cK(ek,d3[ek.nIndex]);ay[ek.nIndex]=ek;ek.bHasEvents=true;a.addEvent(ei,"load",cu);a.addEvent(ei,"error",dB);if(dI.hasImageParameterConditions){ej=dI.reWriteImageURLByConditions(ej)}ek.src=ei.src=ej}return true};var au=function(el,ei,ej){var ek=aB(ei,ej,aP,ci);if(ek.width!==el.width||ek.height!==el.height){el.width=ek.width;el.height=ek.height;el.img.style.width=el.width+"px";el.img.style.height=el.height+"px";el.placedX=b;bc(el);if(el.bVisible){cy(el)}}};var bn=function(ei){return(ei.nThumbnailDimWidth===aP&&ei.nThumbnailDimHeight===ci)};var af=function(ei){return(ei&&ei.nStartID===aT)};var bo=function(ei){if(ei.bHasEvents===true){delete ay[ei.nIndex];a.removeEvent(ei.img,"load",cu);a.removeEvent(ei.img,"error",dB);ei.bHasEvents=false}};var dB=function(ei){var ej=this.oSprite;if(!ej){return}ej.bReady=false;ej.bError=true;if(isNaN(ej.sourceWidth)||isNaN(ej.sourceHeight)){ej.width=ej.sourceWidth=ej.maxWidth=dy.width;ej.height=ej.sourceHeight=ej.maxHeight=dy.height;bc(ej);au(ej,ej.width,ej.height)}ej.bLoadComplete=true;ej.bThumbLoading=false;ej.img.src=dl;ej.img.className="placeholder blank error";if(af(ej)&&ei){V--}bo(ej);b3()};var cu=function(ej){var em=this.oSprite;if(!em||!dM){return}bo(em);if(em.bLoadComplete||!af(em)){return}V--;if(!bn(em)){return}var ei,el;var ek=em.img;if(ek.naturalWidth){ei=ek.naturalWidth;el=ek.naturalHeight}else{ei=ek.width;el=ek.height}if(ei<2&&el<2){ei=em.width;el=em.height}em.bReady=true;em.bLoadComplete=true;em.placedX=b;em.img.style.width=em.img.style.height=b;a.removeClass(em.img,df);au(em,ei,el);if(em.bVisible){dE(em)}bZ();bF[em.nIndex]=em;dh++;if(bN&&bN.nIndex===em.nIndex){L(em)}b3();if(dh>=aU){bO()}};var dE=function(ei){if(!dd){return}cS=true;bG[ei.nIndex]=ei};var d8=function(ei){if(!dd){return}cS=true;cT[ei.nIndex]=ei;bG[ei.nIndex]=b;delete bG[ei.nIndex]};var cm=function(){if(!cS){return}cS=false;var ej,ei;for(ej in bG){if(bG[ej]){dd.addImage(bG[ej].img)}}ei=[];for(ej in cT){if(cT[ej]){ei.push(cT[ej].img)}}if(ei.length>0){dd.removeImages(ei)}bG={};cT={}};var bZ=function(){if(a6===b){return}var ei=x(a6);if(!ei.bReady||!ah(ei)){return}J(ei);a6=b};var I=function(ei){if(!bi.isset("onMouseEnter")&&!bi.isset("onMouseLeave")){return}j=ei;dX={};a.addEvent(cf,"mouseleave",aV);a.addEvent(cf,"mousemove",dt)};var aV=function(){a.removeEvent(cf,"mouseleave",aV);a.removeEvent(cf,"mousemove",dt);if(o!==b){clearTimeout(o)}o=b;if(dX.nIndex!==b){bi.run("onMouseLeave",[dX.nIndex,dX])}dX={};j=b};var dt=function(ei){j=ei;dW()};var dW=function(){if(!j){return}if(o===b){o=setTimeout(cL,100)}};var cL=function(){o=b;cf.style.pointerEvents="none";b2.style.pointerEvents="all";var ej=document.elementFromPoint(j.clientX,j.clientY);cf.style.pointerEvents="all";b2.style.pointerEvents="none";var ei;if(ej&&ej.oSprite){ei=ej.oSprite.nIndex}if(dX.nIndex!==ei){if(dX.nIndex!==b){bi.run("onMouseLeave",[dX.nIndex,dX])}if(ei===b){dX={}}else{dX=ej.oSprite;bi.run("onMouseEnter",[dX.nIndex,dX])}}};var x=function(ej,el){ej%=b0;if(ej<0){ej+=b0}var ek=Y[ej];if(ek===b){cY++;ek=Y[ej]={};ek.nStartID=aT;ek.nIndex=ej;ek.offsetX=0;ek.offsetY=ci-ek.height+dP.paddingTop}if(!ek.img){var ei=ek.img=ad.cloneNode(false);ei.oSprite=ek;if(ek.bPurged){ei.style.width=ek.width+"px";ei.style.height=ek.height+"px";delete ek.bPurged}else{if(dy.nMode===1&&d5){cr(ek,cv.images[ej])}else{ek.width=dy.width;ek.height=dy.height;ei.style.width=dy.width+"px";ei.style.height=dy.height+"px";bc(ek)}}}if(el&&!ek.bImageLoadStarted){at.push(ek)}return ek};var aA=function(){b3=bQ=a.fnDoNothing;if(an){clearTimeout(an);an=b}};var b5=function(){if(!an){an=setTimeout(aG,25)}};var aG=function(){if(an){clearTimeout(an);an=b}cd();while(at.length>0&&V<dx){var ei=at.shift();if(!ei.bImageLoadStarted){ei.bImageLoadStarted=true;ck++;if(ck===b0&&aU>=b0){aA()}av--;cw(ei)}}};var bz=function(ek,ei){if(!bk){if(ek<0||ek>=b0){return 0}}var ej;var el=x(ek);if(ei!==el.position){el.position=ei;ej=cy(el);if(ej&&!el.bVisible){bb(el)}el.bVisible=el.calculatedRet=ej}else{ej=el.calculatedRet;if(ej&&!el.bVisible){bb(el)}el.bVisible=ej}if(el.bVisible){bq.push(el);if(!el.bImageLoadStarted){at.push(el)}}return el.bVisible};var bD=function(em){var ek,el;ek=em.position/bt;el=Math.cos(ek);em.z=el;if(el<0.5){return 0}em.x=c9+em.offsetX+Math.sin(ek)*bt;em.y=em.offsetY;var ej=em.img.style;if(dR){aq(em.img,em.x,em.y,-bt+bt*em.z,aa*ek)}else{aq(em.img,em.x,em.y,bt-bt*em.z,-aa*ek)}if(ao){var ei=(Math.round(120*el)-20)/100;if(ei<0.99){ej[bu]="brightness("+ei+")"}else{ej[bu]="none"}}return 1};var de=function(ek){var ei=c9+ek.position+ek.offsetX;if(ei+3*da<=0||ei>=X.width+3*da){return 0}ei=Math.max(-bt,Math.min(ek.position,bt));var ej=ek.position/bt;ek.z=Math.cos(ej);ek.x=c9+ek.offsetX+Math.sin(ei/bt)*bt;ek.y=ek.offsetY;aC(ek.img,ek.x,ek.y);ek.img.style.zIndex=ac+Math.round(ac*ek.z);return 1};var c=function(ei){ei.x=c9+ei.position+ei.offsetX;if(ei.x+da<=0||ei.x>=X.width){return 0}ei.x=Math.round(ei.x-c8);ei.y=ei.offsetY;if(ei.x!==ei.placedX){ei.placedX=ei.x;if(ca){ei.img.style.left=ei.y+"px";ei.img.style.top=ei.x+"px"}else{ei.img.style.left=ei.x+"px";ei.img.style.top=ei.y+"px"}}return 1};var d4=function(ei){if(ei.x+da<=0||ei.x>=X.width){return 0}return 1};var a9=function(ej){ej.x=c9+ej.position+ej.offsetX;ej.y=ej.offsetY;ej.z=0;var ei=y.apply(d.scope,[d,ej]);if(ei){a2(ej)}return ei};var ah=function(ei){return(ei&&ei.bVisible)};var c6=function(){if(at.length>0){at=[]}bq=[];var el;var ej=r(c8);el=Math.floor(-ej/da);var ei=ej%da;bz(el,ei);var ek=dC(el,ei);if(cG.bEnabled){cG.nLastLeftImage=el-ek+1;cG.nLastRightImage=el+ek-1;if(W===b&&!d7){cG.nLoad=dP.preloadCount}else{cG.nLoad=0}}};var bb=function(ei){if(!ei.bAppended){dq[ei.nIndex]=ei;ei.bAppended=true;b2.appendChild(ei.img);dE(ei)}};var bj=function(ei){if(ei.bAppended){ei.bAppended=false;d8(ei);b2.removeChild(ei.img);ei.tsRemovedFromDOM=bp;delete dq[ei.nIndex]}};var dN=function(){return 0};var c2=function(el,ei){var em;var ek=0;var ej=0;do{ek+=da;ej++;em=bz(el-ej,ei-ek);em+=bz(el+ej,ei+ek)}while(em>0&&ej<aW);return ej};var ct=function(el,ei){var em;var ek=0;var ej=0;do{ek+=da;ej++;em=bz(el+ej,ei+ek)}while(em>0&&ej<aW);return ej};var bT=function(){if(!cG.nLoad||at.length>2){return}var ei=at.length;var ej=1;while(ej>0&&at.length<6&&cG.nLoad>0){ej=0;if(bk||cG.nLastLeftImage>0){x(--cG.nLastLeftImage,true);cG.nLoad--;ej++}if(bk||cG.nLastRightImage<c5){x(++cG.nLastRightImage,true);cG.nLoad--;ej++}}};var bO=function(){if(dp){return}dp=setInterval(a5,dk);bp=a.now()};var bU=function(){if(!dp){return}clearInterval(dp);dp=b};var a5=function(){bp+=dk;if(dh>aU){bW()}else{bU()}};var bW=function(){if(cE.bImageDragging||dh<=aU){return}var ek=new Array(dh);var el=0;var en,ei;for(var em in bF){en=bF[em];if(!en.bAppended&&en.bReady){ek[el++]=bF[em]}}ek=ek.splice(0,el);ek.sort(cq);var ej=Math.max(0,Math.min(dh-aU,Math.min(el,50)));for(el=0;el<ej;el++){en=ek[el];ei=en.nIndex;delete en.img;delete en.placedX;en.bPurged=true;en.bThumbLoadStarted=en.bLoadComplete=en.bReady=en.bImageLoadStarted=false;delete bF[ei]}c7+=ej;dh-=ej;ck-=ej};var cq=function(ej,ei){return ej.tsRemovedFromDOM-ei.tsRemovedFromDOM};var D=function(){if(aD!==b){return}aD=requestAnimationFrame(n)};var ak=function(){if(aD!==b){cancelAnimationFrame(aD);aD=b}};var n=function(){if(!dp){bp=a.now()}if(aD!==b){cancelAnimationFrame(aD);aD=b}for(var ei in dq){dq[ei].bVisible=false}c6();for(var ei in dq){if(!dq[ei].bVisible){bj(dq[ei])}}if(cD){aC(b2,c8,0)}b3()};var cO=function(ei){if(u!==b){return}c8=r(c8);cV=Math.sign(cV)*Math.min(Math.abs(cV),Math.abs(cl)/50);cE.nAutoRotateUpdateCount=0;a.addEvent(cf,"pointerdown",eh);if(ei!==b&&!isNaN(ei)){cV=ei}u=requestAnimationFrame(g);dO(true)};var g=function(){if(bk){c8=r(c8-cV)}else{c8-=cV;if(c8>0||c8<-cl){cV=-cV;c8-=cV}}if(cM){aY(-c8)}br(-c8);D();u=requestAnimationFrame(g);dW()};var eh=function(){if(u===b){return}a.removeEvent(cf,"pointerdown",eh);cancelAnimationFrame(u);u=b;dO(false);return false};var cb=function(){var ei=a.getElementDimension(cx);if(ei.width<1){ei.width=1}if(ei.height<1){ei.height=1}if(ca){var ej=ei.width;ei.width=ei.height;ei.height=ej}return ei};var ed=function(){X=dg=cb()};var ax=function(ei){if(!dQ||cF.length<1){return}if(aM===b){dT=-c8/da;c0=true;aM={};aM.offsetLeft=c8;aM.nAdvance=da;aM.nCenter=c9;ak();eh();cancelAnimationFrame(W);v.cancel();v.enable(false)}if(ei.FSI_after_treshold!==b){c0=false;v.enable(true);aA();at=[];ed();if(X.width>1&&X.height>1){db();dK();ar()}}};var t=function(ej,ei,ek){ej.style.transform="translate("+ei.toFixed(2)+"px,"+ek.toFixed(2)+"px)"};var dD=function(ej,ek,ei){ej.style.transform="translate("+ei.toFixed(2)+"px,"+ek.toFixed(2)+"px)"};var d0=function(ej,ei,en,em,ek){ej.style.transform="translate3d("+ei.toFixed(2)+"px,"+en.toFixed(2)+"px,"+em.toFixed(2)+"px) rotateY("+ek.toFixed(6)+"rad)"};var cP=function(ej,en,ei,em,ek){ej.style.transform="translate3d("+ei.toFixed(2)+"px,"+en.toFixed(2)+"px,"+em.toFixed(2)+"px) rotateX("+ek.toFixed(6)+"rad)"};var ds=function(el){var ek="translate3d("+el.x.toFixed(2)+"px,"+el.y.toFixed(2)+"px,"+el.z.toFixed(2)+"px)";if(el.rx){ek+=" rotateX("+el.rx.toFixed(6)+"rad)"}if(el.ry){ek+=" rotateY("+el.ry.toFixed(6)+"rad)"}if(el.rz){ek+=" rotateZ("+el.rz.toFixed(6)+"rad)"}if(el.sx){ek+=" scaleX("+el.sx.toFixed(2)+")"}if(el.sy){ek+=" scaleY("+el.sy.toFixed(2)+")"}if(el.brightness!==b&&ao){var ei=el.brightness;var ej=el.img.style;if(ei<0.99){ej[bu]="brightness("+ei+")"}else{ej[bu]="none"}}if(el.bSetZIndex){el.img.style.zIndex=ac+Math.round(ac*el.z/bt)}el.img.style.transform=ek};var b4=function(el){var ek="translate3d("+el.y.toFixed(2)+"px,"+el.x.toFixed(2)+"px,"+el.z.toFixed(2)+"px)";if(el.rx){ek+=" rotateY("+el.rx.toFixed(6)+"rad)"}if(el.ry){ek+=" rotateX("+el.ry.toFixed(6)+"rad)"}if(el.rz){ek+=" rotateZ("+el.rz.toFixed(6)+"rad)"}if(el.sx){ek+=" scaleY("+el.sx.toFixed(2)+")"}if(el.sy){ek+=" scaleX("+el.sy.toFixed(2)+")"}if(el.brightness!==b&&ao){var ei=el.brightness;var ej=el.img.style;if(ei<0.99){ej[bu]="brightness("+ei+")"}else{ej[bu]="none"}}if(el.bSetZIndex){el.img.style.zIndex=ac+Math.round(ac*el.z/bt)}el.img.style.transform=ek};var H=function(ej){var ei=ej.oCrop={};cZ(ei,"rectLeft",ej.sourceWidth,0);cZ(ei,"rectTop",ej.sourceHeight,0);cZ(ei,"rectRight",ej.sourceWidth,1);cZ(ei,"rectBottom",ej.sourceHeight,1);ei.rectWidth=1-ei.rectRight-ei.rectLeft;ei.rectHeight=1-ei.rectBottom-ei.rectTop;ei.bCrop=true;ei.query=ei.rectLeft+","+ei.rectTop+","+ei.rectWidth+","+ei.rectHeight};var cZ=function(en,ek,el,ej){var em=bR[ek];if(typeof(em)!=="string"){en[ek]=em;return}var ei=parseInt(em);if(isNaN(ei)){en[ek]=ej;return}ei=Math.max(0,Math.min(el,ei));en[ek]=ei/el};var aZ=function(ek,ej){ek=ek.toLowerCase();var ei=ej;if(ek.indexOf("px")!==-1){ei=parseInt(ek);if(isNaN(ei)||ei<=0){ei=ej}else{ei=""+ei+"live";bR.bLive=true}}else{if(ek.indexOf("%")!==-1){ei=Math.max(0,Math.min(100,parseFloat(ek)));ei/=100;if(isNaN(ei)||ei<0){ei=ej}}else{ei=Math.max(0,Math.min(1,parseFloat(ek)));if(isNaN(ei)||ei<0){ei=ej}}}return ei};var s=function(){var ej;var ek=bR;ek.rectWidth=ek.rectHeight=1;ek.rectLeft=ek.rectTop=0;ek.bCrop=bR.bLive=false;ek.query="";if(dP.cropValues&&dP.cropValues.length>6){ej=dP.cropValues.split(",");ek.rectLeft=aZ(ej[0],0);ek.rectTop=aZ(ej[1],0);ek.rectRight=aZ(ej[2],0);ek.rectBottom=aZ(ej[3],0);ek.rectWidth=1-ek.rectRight-ek.rectLeft;ek.rectHeight=1-ek.rectBottom-ek.rectTop;ek.bCrop=true;if(!ek.bLive){ek.query=ek.rectLeft+","+ek.rectTop+","+ek.rectWidth+","+ek.rectHeight}}else{if(dP.cropRect&&dP.cropRect.length>6){ej=dP.cropRect.split(",");if(ej.length>3){while(ej.length>4){ej.pop()}for(var ei=0;ei<ej.length;ei++){ej[ei]=parseFloat(ej[ei])}var el=ej[0]*ej[1]*ej[2]*ej[3];if(isNaN(el)){return}ek.rectLeft=ej[0];ek.rectTop=ej[1];ek.rectRight=ej[2];ek.rectBottom=ej[3];ek.rectWidth=ej[2]-ej[0];ek.rectHeight=ej[3]-ej[1];ek.bCrop=true;ek.query=ek.rectLeft+","+ek.rectTop+","+ek.rectWidth+","+ek.rectHeight}}}};var bx=function(ek){if(ce>0){for(var el in bV){var ei=bV[el];for(var ej=0;ej<ei.length;ej++){if(!ek||ei[ej].bByConfig){az.unRegisterButton(ei[ej].el)}}}}};var L=function(ei){if(bN&&bN.img){a.removeClass(bN.img,"fsi-selected-thumb")}if(ei){if(ei.img){a.addClass(ei.img,"fsi-selected-thumb")}bN=ei}else{bN=b}};var dz=function(ei){if(!dM){return}dM=false;L();if(cW!==b){a.removeCustomEvent(az,"FSIViewport",cU);cW=b}bx();bU();if(dI){dI.destroy()}if(dd!==b){clearInterval(aw);dd.destroy();dd=b}if(di){clearTimeout(di);di=b}w();d2();cN.removeAttribute("x-fsi-id");aA();for(var ej in ay){bo(ay[ej])}ay={};if(eg!==b){a.removeCustomEvent(cN,"FSIElementDimension",ax);eg=b}at=[];eh();a6=b;dw(b,true);dv=0;cancelAnimationFrame(dn);cancelAnimationFrame(aD);aD=b;cancelAnimationFrame(W);W=b;cancelAnimationFrame(ap);ap=b;bq=[];cG={};if(v){v.destroy();v=b}c8=aK=0;a0=b;d3=[];bR={};V=0;a.removeChild(cx.parentNode,cx);if(bi){bi.run("onDestroy");bi.destroy()}};var cB=function(){if(!W){return c8}else{return d6.end}};this.init=bK;this.destroy=dz;this.getInitDone=function(){return dM};this.addListener=function(el,ej,ek){var ei=false;if(bi){ei=bi.addListener(el,ej,ek)}return ei};this.changeDir=function(ei){return ec(ei)};this.removeListener=function(ek,ej){var ei=false;if(bi){ei=bi.removeListener(ek,ej)}return ei};this.getImageCount=function(){return du};this.setScrollPos=N;this.getScrollPos=function(){return -c8};this.isScrolling=function(){return d7};this.firstImage=function(ei){M(0,false,ei)};this.lastImage=function(ei){var ej=(bk)?-cl+da:-cl;M(ej,false,ei)};this.previousPage=function(ei){M(cB()+X.width,false,ei)};this.nextPage=function(ei){M(cB()-X.width,false,ei)};this.nextImage=function(ei){M(cB()-da,false,ei)};this.previousImage=function(ei){M(cB()+da,false,ei)};this.assignFSIViewer=function(ei){var ej=ei;if(ej&&typeof(ej)==="string"){if(ej.toLowerCase()==="auto"){var ek=document.getElementsByTagName("fsi-viewer");if(ek&&ek.length>0){ei=ek[0]}else{ei=b}}else{ei=document.querySelector(ej);if(!ei){ei=document.getElementById(ej)}}}if(!ei||typeof(ei.changeImage)!=="function"){b8=b}else{b8=ei}a1=false;bw()};this.focusImage=function(ei){if(ei<0||ei>=d3){return false}var ej=x(ei);a4(ej);return true};this.startAutoRotate=cO;this.stopAutoRotate=eh;this.zoomImage=function(ei){if(!dP.enableZoom||!this.focusImage(ei)){return false}var ej=x(ei);a6=ej.nIndex;bZ()};this.destroyOnDetach=function(){if(dP&&dP.autoDestroy!==false){dz()}};var z={lastimage:{fn:this.lastImage,bSingleCommand:true},firstimage:{fn:this.firstImage,bSingleCommand:false},nextimage:{fn:this.nextImage},previousimage:{fn:this.previousImage},nextpage:{fn:this.nextPage,ntRepeat:350},previouspage:{fn:this.previousPage,ntRepeat:350}};var bB=this.buttonDown=function(ei){if(typeof(ei)!=="string"){return false}ei=ei.toLowerCase();if(!z[ei]){return false}if(dY.cmd){if(ei===dY.cmd){return false}am()}if(z[ei].ntRepeat){dY.ntRepeat=z[ei].ntRepeat}else{dY.ntRepeat=125}dY.fn=z[ei].fn;dY.bSingleCommand=z[ei].bSingleCommand;dY.cmd=ei;dY.repeat=0;dY.nInterval=setInterval(ef,350);ef()};var ef=function(){dY.fn.apply(az);dY.repeat++;if(dY.bSingleCommand){am()}else{if(dY.repeat===2){clearInterval(dY.nInterval);dY.nInterval=setInterval(ef,dY.ntRepeat)}}};var am=this.buttonUp=function(){if(dY.nInterval){clearInterval(dY.nInterval)}dY.cmd=b};this.registerButton=function(ej,ek,em){if(typeof(ej)==="string"){ej=document.getElementById(ej)}if(!ej||typeof(ej)!=="object"||typeof(ej.tagName)!=="string"){return false}ek=ek.toLowerCase();if(!z[ek]){return false}if(!ej.x_fsi_thumbbar_cmd_count){ej.setAttribute("x-fsi-thumbbar-cmd",ek);ej.x_fsi_thumbbar_cmd_count=1}else{ej.x_fsi_thumbbar_cmd_count++}a.addEvent(ej,"contextmenu",a.preventDefaultEvent);a.addEvent(ej,"mousedown",bY);if(a.isEventSupported("touchstart")){a.addEvent(ej,"touchstart",bY)}ce++;var ei=bV[ek];if(ei===b){ei=bV[ek]=[]}ei.push({el:ej,bByConfig:em});return true};this.changeConfig=cI;var bI=function(ei){a.addEvent(window,"mouseup",bJ);if(a.isEventSupported("touchstart")){a.addEvent(ei,"touchcancel",bJ);a.addEvent(ei,"touchend",bJ)}};var i=function(ei){a.removeEvent(window,"mouseup",bJ);if(a.isEventSupported("touchstart")){a.removeEvent(ei,"touchcancel",bJ);a.removeEvent(ei,"touchend",bJ)}};this.unRegisterButton=function(ei){if(typeof(ei)==="string"){ei=document.getElementById(ei)}if(!ei||typeof(ei)!=="object"||typeof(ei.tagName)!=="string"||!ei.x_fsi_thumbbar_cmd_count){return false}if(--ei.x_fsi_thumbbar_cmd_count===0){ei.x_fsi_thumbbar_cmd_count=b;ei.removeAttribute("x-fsi-thumbbar-cmd")}a.removeEvent(ei,"mousedown",bY);if(a.isEventSupported("touchstart")){a.removeEvent(ei,"touchstart",bY)}i(ei);ce--;return true};var bJ=function(){if(c4){a.removeClass(c4,"fsi-pressed")}am();i(c4);c4=b};var bY=function(ei){if(c4){bJ()}var ej=ei.target||ei.srcElement;if(!ej||!ej.getAttribute("x-fsi-thumbbar-cmd")){return}c4=ej;bI(ej);var ek=ej.getAttribute("x-fsi-thumbbar-cmd");a.addClass(ej,"fsi-pressed");bB(ek);a.preventDefaultEvent(ei);return true}};(function(){var d="fsi-thumbbar";var e="display:block;width:300px;height:300px;";var g=a.customTags[d];if(g){return}var c=function(i){var h=a.attributes2parameters(i);if(h.src!==b&&h.dir===b){h.dir=h.src}return h};var f={};f.registerElement=function(){a.addViewerClassCSSRule(d,e);var h=Object.create(HTMLDivElement.prototype);h.createdCallback=function(){a.customTagDimFromAttributes(this);a.ThumbBar.prototype.constructor.call(this)};h.attachedCallback=function(){if(this.getInitDone()){return}if(a.FullScreen&&a.FullScreen.bChanging){return}this.init(this,c(this))};h.detachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}this.destroyOnDetach()};document.registerElement(d,{prototype:h})};f.replaceTagInit=function(){a.addViewerClassCSSRule(d,e)};f.replaceTag=function(h){if(!h||(typeof(h.getInitDone)==="function"&&h.getInitDone())){return}a.customTagDimFromAttributes(h);a.ThumbBar.prototype.constructor.call(h);h.init(h,c(h))};a.registerCustomTag(d,f)}());a.dispatchEvent("FSIThumbBarLoaded")}(window.$FSI=window.$FSI||{}));