/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageio.plugins.tiff;

import com.neptunelabs.fsiserver.framework.O0OO.H;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFieldNode;
import java.util.StringTokenizer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TIFFField
implements Comparable<TIFFField> {
    private static final String[] typeNames = new String[]{null, "Byte", "Ascii", "Short", "Long", "Rational", "SByte", "Undefined", "SShort", "SLong", "SRational", "Float", "Double", "IFDPointer"};
    private static final boolean[] isIntegral = new boolean[]{false, true, false, true, true, false, true, true, true, true, false, false, false, false};
    private TIFFTag tag;
    private int tagNumber;
    private int type;
    private int count;
    private Object data;

    private TIFFField() {
    }

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        return namedNodeMap.getNamedItem(string).getNodeValue();
    }

    private static void initData(Node node, int[] nArray, int[] nArray2, Object[] objectArray) {
        Node node2;
        Object object = null;
        String string = node.getNodeName();
        string = string.substring(4);
        int n = TIFFField.getTypeByName(string = string.substring(0, string.length() - 1));
        if (n == -1) {
            throw new IllegalArgumentException("typeName = " + string);
        }
        int n2 = 0;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string2 = node2.getNodeName().substring(4);
            if (!string.equals(string2)) {
                // empty if block
            }
            ++n2;
        }
        if (n2 > 0) {
            object = TIFFField.createArrayForType(n, n2);
            int n3 = 0;
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string3 = TIFFField.getAttribute(node2, "value");
                switch (n) {
                    case 2: {
                        ((String[])object)[n3] = string3;
                        break;
                    }
                    case 1: 
                    case 6: {
                        ((byte[])object)[n3] = (byte)Integer.parseInt(string3);
                        break;
                    }
                    case 3: {
                        ((char[])object)[n3] = (char)Integer.parseInt(string3);
                        break;
                    }
                    case 8: {
                        ((short[])object)[n3] = (short)Integer.parseInt(string3);
                        break;
                    }
                    case 9: {
                        ((int[])object)[n3] = Integer.parseInt(string3);
                        break;
                    }
                    case 4: 
                    case 13: {
                        ((long[])object)[n3] = Long.parseLong(string3);
                        break;
                    }
                    case 11: {
                        ((float[])object)[n3] = Float.parseFloat(string3);
                        break;
                    }
                    case 12: {
                        ((double[])object)[n3] = H.OO0000(string3);
                        break;
                    }
                    case 10: {
                        int n4 = string3.indexOf("/");
                        String string4 = string3.substring(0, n4);
                        String string5 = string3.substring(n4 + 1);
                        ((int[][])object)[n3] = new int[2];
                        ((int[][])object)[n3][0] = Integer.parseInt(string4);
                        ((int[][])object)[n3][1] = Integer.parseInt(string5);
                        break;
                    }
                    case 5: {
                        int n4 = string3.indexOf("/");
                        String string4 = string3.substring(0, n4);
                        String string5 = string3.substring(n4 + 1);
                        ((long[][])object)[n3] = new long[2];
                        ((long[][])object)[n3][0] = Long.parseLong(string4);
                        ((long[][])object)[n3][1] = Long.parseLong(string5);
                        break;
                    }
                }
                ++n3;
            }
        }
        nArray[0] = n;
        nArray2[0] = n2;
        objectArray[0] = object;
    }

    public static TIFFField createFromMetadataNode(TIFFTagSet tIFFTagSet, Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null!");
        }
        String string = node.getNodeName();
        if (!string.equals("TIFFField")) {
            throw new IllegalArgumentException("!name.equals(\"TIFFField\")");
        }
        int n = Integer.parseInt(TIFFField.getAttribute(node, "number"));
        TIFFTag tIFFTag = tIFFTagSet != null ? tIFFTagSet.getTag(n) : new TIFFTag("unknown", n, 0, null);
        int n2 = 7;
        int n3 = 0;
        Object object = null;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            String string2 = node2.getNodeName();
            if (string2.equals("TIFFUndefined")) {
                String string3 = TIFFField.getAttribute(node2, "value");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                n3 = stringTokenizer.countTokens();
                byte[] byArray = new byte[n3];
                for (int i = 0; i < n3; ++i) {
                    byArray[i] = (byte)Integer.parseInt(stringTokenizer.nextToken());
                }
                n2 = 7;
                object = byArray;
            } else {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                Object[] objectArray = new Object[1];
                TIFFField.initData(node.getFirstChild(), nArray, nArray2, objectArray);
                n2 = nArray[0];
                n3 = nArray2[0];
                object = objectArray[0];
            }
        } else {
            int n4;
            for (n4 = 13; n4 >= 1 && !tIFFTag.isDataTypeOK(n4); --n4) {
            }
            n2 = n4;
        }
        return new TIFFField(tIFFTag, n2, n3, object);
    }

    public TIFFField(TIFFTag tIFFTag, int n, int n2, Object object) {
        if (tIFFTag == null) {
            throw new IllegalArgumentException("tag == null!");
        }
        if (n < 1 || n > 13) {
            throw new IllegalArgumentException("Unknown data type " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("count < 0!");
        }
        this.tag = tIFFTag;
        this.tagNumber = tIFFTag.getNumber();
        this.type = n;
        this.count = n2;
        this.data = object;
    }

    public TIFFField(TIFFTag tIFFTag, int n, int n2) {
        this(tIFFTag, n, n2, TIFFField.createArrayForType(n, n2));
    }

    public TIFFField(TIFFTag tIFFTag, int n) {
        if (tIFFTag == null) {
            throw new IllegalArgumentException("tag == null!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("value < 0!");
        }
        this.tag = tIFFTag;
        this.tagNumber = tIFFTag.getNumber();
        this.count = 1;
        if (n < 65536) {
            this.type = 3;
            char[] cArray = new char[]{(char)n};
            this.data = cArray;
        } else {
            this.type = 4;
            long[] lArray = new long[]{n};
            this.data = lArray;
        }
    }

    public TIFFTag getTag() {
        return this.tag;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public int getType() {
        return this.type;
    }

    public static String getTypeName(int n) {
        if (n < 1 || n > 13) {
            throw new IllegalArgumentException("Unknown data type " + n);
        }
        return typeNames[n];
    }

    public static int getTypeByName(String string) {
        for (int i = 1; i <= 13; ++i) {
            if (!string.equals(typeNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static Object createArrayForType(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("count < 0!");
        }
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                return new byte[n2];
            }
            case 2: {
                return new String[n2];
            }
            case 3: {
                return new char[n2];
            }
            case 4: 
            case 13: {
                return new long[n2];
            }
            case 5: {
                return new long[n2][2];
            }
            case 8: {
                return new short[n2];
            }
            case 9: {
                return new int[n2];
            }
            case 10: {
                return new int[n2][2];
            }
            case 11: {
                return new float[n2];
            }
            case 12: {
                return new double[n2];
            }
        }
        throw new IllegalArgumentException("Unknown data type " + n);
    }

    public Node getAsNativeNode() {
        return new TIFFFieldNode(this);
    }

    public boolean isIntegral() {
        return isIntegral[this.type];
    }

    public int getCount() {
        return this.count;
    }

    public Object getData() {
        return this.data;
    }

    public byte[] getAsBytes() {
        return (byte[])this.data;
    }

    public char[] getAsChars() {
        return (char[])this.data;
    }

    public short[] getAsShorts() {
        return (short[])this.data;
    }

    public int[] getAsInts() {
        if (this.data instanceof int[]) {
            return (int[])this.data;
        }
        if (this.data instanceof char[]) {
            char[] cArray = (char[])this.data;
            int[] nArray = new int[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                nArray[i] = cArray[i] & 0xFFFF;
            }
            return nArray;
        }
        if (this.data instanceof short[]) {
            short[] sArray = (short[])this.data;
            int[] nArray = new int[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                nArray[i] = sArray[i];
            }
            return nArray;
        }
        throw new ClassCastException("Data not char[], short[], or int[]!");
    }

    public long[] getAsLongs() {
        return (long[])this.data;
    }

    public float[] getAsFloats() {
        return (float[])this.data;
    }

    public double[] getAsDoubles() {
        return (double[])this.data;
    }

    public int[][] getAsSRationals() {
        return (int[][])this.data;
    }

    public long[][] getAsRationals() {
        return (long[][])this.data;
    }

    public int getAsInt(int n) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n];
            }
            case 3: {
                return ((char[])this.data)[n] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n];
            }
            case 9: {
                return ((int[])this.data)[n];
            }
            case 4: 
            case 13: {
                return (int)((long[])this.data)[n];
            }
            case 11: {
                return (int)((float[])this.data)[n];
            }
            case 12: {
                return (int)((double[])this.data)[n];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n);
                return (int)((double)nArray[0] / (double)nArray[1]);
            }
            case 5: {
                long[] lArray = this.getAsRational(n);
                return (int)((double)lArray[0] / (double)lArray[1]);
            }
            case 2: {
                String string = ((String[])this.data)[n];
                return (int)H.OO0000(string);
            }
        }
        throw new ClassCastException();
    }

    public long getAsLong(int n) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n];
            }
            case 3: {
                return ((char[])this.data)[n] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n];
            }
            case 9: {
                return ((int[])this.data)[n];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[n];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n);
                return (long)((double)nArray[0] / (double)nArray[1]);
            }
            case 5: {
                long[] lArray = this.getAsRational(n);
                return (long)((double)lArray[0] / (double)lArray[1]);
            }
            case 2: {
                String string = ((String[])this.data)[n];
                return (long)H.OO0000(string);
            }
        }
        throw new ClassCastException();
    }

    public float getAsFloat(int n) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n];
            }
            case 3: {
                return ((char[])this.data)[n] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n];
            }
            case 9: {
                return ((int[])this.data)[n];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[n];
            }
            case 11: {
                return ((float[])this.data)[n];
            }
            case 12: {
                return (float)((double[])this.data)[n];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n);
                return (float)((double)nArray[0] / (double)nArray[1]);
            }
            case 5: {
                long[] lArray = this.getAsRational(n);
                return (float)((double)lArray[0] / (double)lArray[1]);
            }
            case 2: {
                String string = ((String[])this.data)[n];
                return (float)H.OO0000(string);
            }
        }
        throw new ClassCastException();
    }

    public double getAsDouble(int n) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n];
            }
            case 3: {
                return ((char[])this.data)[n] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n];
            }
            case 9: {
                return ((int[])this.data)[n];
            }
            case 4: 
            case 13: {
                return ((long[])this.data)[n];
            }
            case 11: {
                return ((float[])this.data)[n];
            }
            case 12: {
                return ((double[])this.data)[n];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n);
                return (double)nArray[0] / (double)nArray[1];
            }
            case 5: {
                long[] lArray = this.getAsRational(n);
                return (double)lArray[0] / (double)lArray[1];
            }
            case 2: {
                String string = ((String[])this.data)[n];
                return H.OO0000(string);
            }
        }
        throw new ClassCastException();
    }

    public String getAsString(int n) {
        return ((String[])this.data)[n];
    }

    public int[] getAsSRational(int n) {
        return ((int[][])this.data)[n];
    }

    public long[] getAsRational(int n) {
        return ((long[][])this.data)[n];
    }

    public String getValueAsString(int n) {
        switch (this.type) {
            case 2: {
                return ((String[])this.data)[n];
            }
            case 1: 
            case 7: {
                return Integer.toString(((byte[])this.data)[n] & 0xFF);
            }
            case 6: {
                return Integer.toString(((byte[])this.data)[n]);
            }
            case 3: {
                return Integer.toString(((char[])this.data)[n] & 0xFFFF);
            }
            case 8: {
                return Integer.toString(((short[])this.data)[n]);
            }
            case 9: {
                return Integer.toString(((int[])this.data)[n]);
            }
            case 4: 
            case 13: {
                return Long.toString(((long[])this.data)[n]);
            }
            case 11: {
                return Float.toString(((float[])this.data)[n]);
            }
            case 12: {
                return Double.toString(((double[])this.data)[n]);
            }
            case 10: {
                int[] nArray = this.getAsSRational(n);
                String string = nArray[1] != 0 && nArray[0] % nArray[1] == 0 ? Integer.toString(nArray[0] / nArray[1]) + "/1" : Integer.toString(nArray[0]) + "/" + Integer.toString(nArray[1]);
                return string;
            }
            case 5: {
                long[] lArray = this.getAsRational(n);
                String string = lArray[1] != 0L && lArray[0] % lArray[1] == 0L ? Long.toString(lArray[0] / lArray[1]) + "/1" : Long.toString(lArray[0]) + "/" + Long.toString(lArray[1]);
                return string;
            }
        }
        throw new ClassCastException();
    }

    @Override
    public int compareTo(TIFFField tIFFField) {
        if (tIFFField == null) {
            throw new IllegalArgumentException();
        }
        int n = tIFFField.getTagNumber();
        if (this.tagNumber < n) {
            return -1;
        }
        if (this.tagNumber > n) {
            return 1;
        }
        return 0;
    }
}

