/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.neptunelabs.fsiserver.framework.J.classsuper;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGDecompressor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFOldJPEGDecompressor
extends TIFFJPEGDecompressor {
    private static final boolean DEBUG = false;
    private static final int DHT = 196;
    private static final int DQT = 219;
    private static final int DRI = 221;
    private static final int SOF0 = 192;
    private static final int SOS = 218;
    private boolean isInitialized = false;
    private Long JPEGStreamOffset = null;
    private int SOFPosition = -1;
    private byte[] SOSMarker = null;
    private int subsamplingX = 2;
    private int subsamplingY = 2;

    private synchronized void initialize() throws IOException {
        int n;
        TIFFField tIFFField;
        long[] lArray;
        boolean bl;
        if (this.isInitialized) {
            return;
        }
        TIFFImageMetadata tIFFImageMetadata = (TIFFImageMetadata)this.metadata;
        TIFFField tIFFField2 = tIFFImageMetadata.getTIFFField(513);
        TIFFField tIFFField3 = tIFFImageMetadata.getTIFFField(324);
        if (tIFFField3 == null && (tIFFField3 = tIFFImageMetadata.getTIFFField(273)) == null) {
            tIFFField3 = tIFFField2;
        }
        boolean bl2 = bl = (lArray = tIFFField3.getAsLongs()).length > 1;
        if (!bl) {
            this.stream.seek(this.offset);
            this.stream.mark();
            if (this.stream.read() == 255 && this.stream.read() == 216) {
                this.JPEGStreamOffset = new Long(this.offset);
                ((TIFFImageReader)this.reader).forwardWarningMessage("SOI marker detected at start of strip or tile.");
                this.isInitialized = true;
                this.stream.reset();
                return;
            }
            this.stream.reset();
            if (tIFFField2 != null) {
                long l = tIFFField2.getAsLong(0);
                this.stream.mark();
                this.stream.seek(l);
                if (this.stream.read() == 255 && this.stream.read() == 216) {
                    this.JPEGStreamOffset = new Long(l);
                } else {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormat does not point to SOI");
                }
                this.stream.reset();
                TIFFField tIFFField4 = tIFFImageMetadata.getTIFFField(514);
                if (tIFFField4 == null) {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormatLength field is missing");
                } else {
                    long l2 = tIFFField4.getAsLong(0);
                    if (l >= lArray[0] || l + l2 <= lArray[0]) {
                        ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormatLength field value is invalid");
                    }
                }
                if (this.JPEGStreamOffset != null) {
                    this.isInitialized = true;
                    return;
                }
            }
        }
        if ((tIFFField = tIFFImageMetadata.getTIFFField(530)) != null) {
            this.subsamplingX = tIFFField.getAsChars()[0];
            this.subsamplingY = tIFFField.getAsChars()[1];
        }
        if (tIFFField2 != null) {
            long l = tIFFField2.getAsLong(0);
            TIFFField tIFFField5 = tIFFImageMetadata.getTIFFField(514);
            if (tIFFField5 != null) {
                long l3 = tIFFField5.getAsLong(0);
                if (l3 >= 2L && l + l3 <= lArray[0]) {
                    this.stream.mark();
                    this.stream.seek(l + l3 - 2L);
                    this.tables = this.stream.read() == 255 && this.stream.read() == 217 ? new byte[(int)(l3 - 2L)] : new byte[(int)l3];
                    this.stream.reset();
                    this.stream.mark();
                    this.stream.seek(l);
                    this.stream.readFully(this.tables);
                    this.stream.reset();
                    ((TIFFImageReader)this.reader).forwardWarningMessage("Incorrect JPEG interchange format: using JPEGInterchangeFormat offset to derive tables.");
                } else {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormat+JPEGInterchangeFormatLength > offset to first strip or tile.");
                }
            }
        }
        if (this.tables == null) {
            Object object;
            int n2;
            classsuper classsuper2 = new classsuper();
            long l = this.stream.length();
            classsuper2.write(255);
            classsuper2.write(216);
            TIFFField tIFFField6 = tIFFImageMetadata.getTIFFField(519);
            if (tIFFField6 == null) {
                throw new IIOException("JPEGQTables field missing!");
            }
            long[] lArray2 = tIFFField6.getAsLongs();
            for (n = 0; n < lArray2.length; ++n) {
                classsuper2.write(255);
                classsuper2.write(219);
                n2 = 67;
                classsuper2.write(n2 >>> 8 & 0xFF);
                classsuper2.write(n2 & 0xFF);
                classsuper2.write(n);
                object = new byte[64];
                if (l != -1L && lArray2[n] > l) {
                    throw new IIOException("JPEGQTables offset for index " + n + " is not in the stream!");
                }
                this.stream.seek(lArray2[n]);
                this.stream.readFully((byte[])object);
                classsuper2.write((byte[])object);
            }
            for (n = 0; n < 2; ++n) {
                n2 = n == 0 ? 520 : 521;
                tIFFField6 = tIFFImageMetadata.getTIFFField(n2);
                Object object2 = object = n2 == 520 ? "JPEGDCTables" : "JPEGACTables";
                if (tIFFField6 == null) {
                    throw new IIOException((String)object + " field missing!");
                }
                lArray2 = tIFFField6.getAsLongs();
                for (int i = 0; i < lArray2.length; ++i) {
                    int n3;
                    classsuper2.write(255);
                    classsuper2.write(196);
                    byte[] byArray = new byte[16];
                    if (l != -1L && lArray2[i] > l) {
                        throw new IIOException((String)object + " offset for index " + i + " is not in the stream!");
                    }
                    this.stream.seek(lArray2[i]);
                    this.stream.readFully(byArray);
                    int n4 = 0;
                    for (n3 = 0; n3 < 16; ++n3) {
                        n4 += byArray[n3] & 0xFF;
                    }
                    n3 = (char)(19 + n4);
                    classsuper2.write(n3 >>> 8 & 0xFF);
                    classsuper2.write(n3 & 0xFF);
                    classsuper2.write(i | n << 4);
                    classsuper2.write(byArray);
                    byte[] byArray2 = new byte[n4];
                    this.stream.readFully(byArray2);
                    classsuper2.write(byArray2);
                }
            }
            classsuper2.write(-1);
            classsuper2.write(-64);
            n = (short)(8 + 3 * this.samplesPerPixel);
            classsuper2.write((byte)(n >>> 8 & 0xFF));
            classsuper2.write((byte)(n & 0xFF));
            classsuper2.write(8);
            n = (short)this.srcHeight;
            classsuper2.write((byte)(n >>> 8 & 0xFF));
            classsuper2.write((byte)(n & 0xFF));
            n = (short)this.srcWidth;
            classsuper2.write((byte)(n >>> 8 & 0xFF));
            classsuper2.write((byte)(n & 0xFF));
            classsuper2.write((byte)this.samplesPerPixel);
            if (this.samplesPerPixel == 1) {
                classsuper2.write(1);
                classsuper2.write(17);
                classsuper2.write(0);
            } else {
                for (n2 = 0; n2 < 3; ++n2) {
                    classsuper2.write((byte)(n2 + 1));
                    classsuper2.write((byte)(n2 != 0 ? 17 : (byte)((this.subsamplingX & 0xF) << 4 | this.subsamplingY & 0xF)));
                    classsuper2.write((byte)n2);
                }
            }
            tIFFField6 = tIFFImageMetadata.getTIFFField(515);
            if (tIFFField6 != null && (n2 = tIFFField6.getAsChars()[0]) != 0) {
                classsuper2.write(-1);
                classsuper2.write(-35);
                n = 4;
                classsuper2.write((byte)(n >>> 8 & 0xFF));
                classsuper2.write((byte)(n & 0xFF));
                classsuper2.write((byte)(n2 >>> 8 & 0xFF));
                classsuper2.write((byte)(n2 & 0xFF));
            }
            this.tables = classsuper2.\u00d500000();
        }
        int n5 = this.tables.length - 1;
        for (int i = 0; i < n5; ++i) {
            if ((this.tables[i] & 0xFF) != 255 || (this.tables[i + 1] & 0xFF) != 192) continue;
            this.SOFPosition = i;
            break;
        }
        if (this.SOFPosition == -1) {
            byte[] byArray = new byte[this.tables.length + 10 + 3 * this.samplesPerPixel];
            System.arraycopy(this.tables, 0, byArray, 0, this.tables.length);
            int n6 = this.tables.length;
            this.SOFPosition = this.tables.length;
            this.tables = byArray;
            this.tables[n6++] = -1;
            this.tables[n6++] = -64;
            short s = (short)(8 + 3 * this.samplesPerPixel);
            this.tables[n6++] = (byte)(s >>> 8 & 0xFF);
            this.tables[n6++] = (byte)(s & 0xFF);
            this.tables[n6++] = 8;
            s = (short)this.srcHeight;
            this.tables[n6++] = (byte)(s >>> 8 & 0xFF);
            this.tables[n6++] = (byte)(s & 0xFF);
            s = (short)this.srcWidth;
            this.tables[n6++] = (byte)(s >>> 8 & 0xFF);
            this.tables[n6++] = (byte)(s & 0xFF);
            this.tables[n6++] = (byte)this.samplesPerPixel;
            if (this.samplesPerPixel == 1) {
                this.tables[n6++] = 1;
                this.tables[n6++] = 17;
                this.tables[n6++] = 0;
            } else {
                for (n = 0; n < 3; ++n) {
                    this.tables[n6++] = (byte)(n + 1);
                    this.tables[n6++] = (byte)(n != 0 ? 17 : (byte)((this.subsamplingX & 0xF) << 4 | this.subsamplingY & 0xF));
                    this.tables[n6++] = (byte)n;
                }
            }
        }
        this.stream.mark();
        this.stream.seek(lArray[0]);
        if (this.stream.read() == 255 && this.stream.read() == 218) {
            int n7 = this.stream.read() << 8 | this.stream.read();
            this.SOSMarker = new byte[n7 + 2];
            this.SOSMarker[0] = -1;
            this.SOSMarker[1] = -38;
            this.SOSMarker[2] = (byte)((n7 & 0xFF00) >> 8);
            this.SOSMarker[3] = (byte)(n7 & 0xFF);
            this.stream.readFully(this.SOSMarker, 4, n7 - 2);
        } else {
            this.SOSMarker = new byte[8 + 2 * this.samplesPerPixel];
            int n8 = 0;
            this.SOSMarker[n8++] = -1;
            this.SOSMarker[n8++] = -38;
            short s = (short)(6 + 2 * this.samplesPerPixel);
            this.SOSMarker[n8++] = (byte)(s >>> 8 & 0xFF);
            this.SOSMarker[n8++] = (byte)(s & 0xFF);
            this.SOSMarker[n8++] = (byte)this.samplesPerPixel;
            if (this.samplesPerPixel == 1) {
                this.SOSMarker[n8++] = 1;
                this.SOSMarker[n8++] = 0;
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.SOSMarker[n8++] = (byte)(i + 1);
                    this.SOSMarker[n8++] = (byte)(i << 4 | i);
                }
            }
            this.SOSMarker[n8++] = 0;
            this.SOSMarker[n8++] = 63;
            this.SOSMarker[n8++] = 0;
        }
        this.stream.reset();
        this.isInitialized = true;
    }

    @Override
    public void decodeRaw(byte[] byArray, int n, int n2, int n3) throws IOException {
        this.initialize();
        TIFFImageMetadata tIFFImageMetadata = (TIFFImageMetadata)this.metadata;
        if (this.JPEGStreamOffset != null) {
            this.stream.seek(this.JPEGStreamOffset);
            this.JPEGReader.setInput(this.stream, false, true);
        } else {
            int n4 = this.tables.length;
            int n5 = n4 + this.SOSMarker.length + this.byteCount + 2;
            byte[] byArray2 = new byte[n5];
            if (this.tables != null) {
                System.arraycopy(this.tables, 0, byArray2, 0, n4);
            }
            int n6 = n4;
            short s = (short)this.srcHeight;
            byArray2[this.SOFPosition + 5] = (byte)(s >>> 8 & 0xFF);
            byArray2[this.SOFPosition + 6] = (byte)(s & 0xFF);
            s = (short)this.srcWidth;
            byArray2[this.SOFPosition + 7] = (byte)(s >>> 8 & 0xFF);
            byArray2[this.SOFPosition + 8] = (byte)(s & 0xFF);
            this.stream.seek(this.offset);
            byte[] byArray3 = new byte[2];
            this.stream.readFully(byArray3);
            if ((byArray3[0] & 0xFF) != 255 || (byArray3[1] & 0xFF) != 218) {
                System.arraycopy(this.SOSMarker, 0, byArray2, n6, this.SOSMarker.length);
                n6 += this.SOSMarker.length;
            }
            byArray2[n6++] = byArray3[0];
            byArray2[n6++] = byArray3[1];
            this.stream.readFully(byArray2, n6, this.byteCount - 2);
            n6 += this.byteCount - 2;
            byArray2[n6++] = -1;
            byArray2[n6++] = -39;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 0, n6);
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
            this.JPEGReader.setInput(memoryCacheImageInputStream, true, true);
        }
        this.JPEGParam.setDestination(this.rawImage);
        this.JPEGReader.read(0, this.JPEGParam);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.JPEGReader.dispose();
    }
}

