/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class SubtractOpImage
extends PointOpImage {
    private int s1bd = 1;
    private int s2bd = 1;

    public SubtractOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        SampleModel sampleModel;
        int n;
        int n2 = renderedImage.getSampleModel().getNumBands();
        int n3 = renderedImage2.getSampleModel().getNumBands();
        if (imageLayout != null && imageLayout.isValid(256) && (n = (sampleModel = imageLayout.getSampleModel(null)).getNumBands()) > 1 && (n2 > 1 && n3 == 1 || n2 == 1 && n3 > 1)) {
            n = Math.min(Math.max(n2, n3), n);
            if (n != this.sampleModel.getNumBands()) {
                this.sampleModel = RasterFactory.createComponentSampleModel(sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n);
                if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                    this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
                }
            }
            this.s1bd = n2 == 1 ? 0 : 1;
            this.s2bd = n3 == 1 ? 0 : 1;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSource(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        if (rasterAccessor3.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            byte[] byArray3 = rasterAccessor3.getBinaryDataArray();
            int n = byArray3.length;
            for (int i = 0; i < n; ++i) {
                byArray3[i] = (byte)(byArray[i] & (byte)(~byArray2[i]));
            }
            rasterAccessor3.copyBinaryDataToRaster();
            return;
        }
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3);
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        byte[][] byArray3 = rasterAccessor3.getByteDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            byte[] byArray4 = byArray[n11];
            byte[] byArray5 = byArray2[n12];
            byte[] byArray6 = byArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n6; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                int n19 = 0;
                for (int j = 0; j < n5; ++j) {
                    n19 = (byArray4[n16] & 0xFF) - (byArray5[n17] & 0xFF);
                    byArray6[n18] = (byte)(n19 & ~(n19 >> 8) & 0xFF);
                    n16 += n2;
                    n17 += n4;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n12];
            short[] sArray6 = sArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n6; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                for (int j = 0; j < n5; ++j) {
                    sArray6[n18] = ImageUtil.clampUShortNegative((sArray4[n16] & 0xFFFF) - (sArray5[n17] & 0xFFFF));
                    n16 += n2;
                    n17 += n4;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n12];
            short[] sArray6 = sArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n6; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                for (int j = 0; j < n5; ++j) {
                    sArray6[n18] = ImageUtil.clampShort(sArray4[n16] - sArray5[n17]);
                    n16 += n2;
                    n17 += n4;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray5 = rasterAccessor3.getBandOffsets();
        int[][] nArray6 = rasterAccessor3.getIntDataArrays();
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                while (n10 < n7) {
                    int[] nArray7 = nArray2[n11];
                    int[] nArray8 = nArray4[n12];
                    int[] nArray9 = nArray6[n10];
                    int n13 = nArray[n11];
                    int n14 = nArray3[n12];
                    int n15 = nArray5[n10];
                    for (int i = 0; i < n6; ++i) {
                        int n16 = n13;
                        int n17 = n14;
                        int n18 = n15;
                        n13 += n;
                        n14 += n3;
                        n15 += n8;
                        int n19 = 0;
                        for (int j = 0; j < n5; ++j) {
                            n19 = (nArray7[n16] & 0xFF) - (nArray8[n17] & 0xFF);
                            nArray9[n18] = n19 & ~(n19 >> 8) & 0xFF;
                            n16 += n2;
                            n17 += n4;
                            n18 += n9;
                        }
                    }
                    ++n10;
                    n11 += this.s1bd;
                    n12 += this.s2bd;
                }
                break;
            }
            case 1: {
                int n20 = 0;
                int n21 = 0;
                int n22 = 0;
                while (n20 < n7) {
                    int[] nArray10 = nArray2[n21];
                    int[] nArray11 = nArray4[n22];
                    int[] nArray12 = nArray6[n20];
                    int n23 = nArray[n21];
                    int n24 = nArray3[n22];
                    int n25 = nArray5[n20];
                    for (int i = 0; i < n6; ++i) {
                        int n26 = n23;
                        int n27 = n24;
                        int n28 = n25;
                        n23 += n;
                        n24 += n3;
                        n25 += n8;
                        for (int j = 0; j < n5; ++j) {
                            nArray12[n28] = ImageUtil.clampUShortNegative((nArray10[n26] & 0xFFFF) - (nArray11[n27] & 0xFFFF));
                            n26 += n2;
                            n27 += n4;
                            n28 += n9;
                        }
                    }
                    ++n20;
                    n21 += this.s1bd;
                    n22 += this.s2bd;
                }
                break;
            }
            case 2: {
                int n29 = 0;
                int n30 = 0;
                int n31 = 0;
                while (n29 < n7) {
                    int[] nArray13 = nArray2[n30];
                    int[] nArray14 = nArray4[n31];
                    int[] nArray15 = nArray6[n29];
                    int n32 = nArray[n30];
                    int n33 = nArray3[n31];
                    int n34 = nArray5[n29];
                    for (int i = 0; i < n6; ++i) {
                        int n35 = n32;
                        int n36 = n33;
                        int n37 = n34;
                        n32 += n;
                        n33 += n3;
                        n34 += n8;
                        for (int j = 0; j < n5; ++j) {
                            nArray15[n37] = ImageUtil.clampShort(nArray13[n35] - nArray14[n36]);
                            n35 += n2;
                            n36 += n4;
                            n37 += n9;
                        }
                    }
                    ++n29;
                    n30 += this.s1bd;
                    n31 += this.s2bd;
                }
                break;
            }
            case 3: {
                int n38 = 0;
                int n39 = 0;
                int n40 = 0;
                while (n38 < n7) {
                    int[] nArray16 = nArray2[n39];
                    int[] nArray17 = nArray4[n40];
                    int[] nArray18 = nArray6[n38];
                    int n41 = nArray[n39];
                    int n42 = nArray3[n40];
                    int n43 = nArray5[n38];
                    for (int i = 0; i < n6; ++i) {
                        int n44 = n41;
                        int n45 = n42;
                        int n46 = n43;
                        n41 += n;
                        n42 += n3;
                        n43 += n8;
                        for (int j = 0; j < n5; ++j) {
                            nArray18[n46] = ImageUtil.clampInt((long)nArray16[n44] - (long)nArray17[n45]);
                            n44 += n2;
                            n45 += n4;
                            n46 += n9;
                        }
                    }
                    ++n38;
                    n39 += this.s1bd;
                    n40 += this.s2bd;
                }
                break;
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        float[][] fArray3 = rasterAccessor3.getFloatDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            float[] fArray4 = fArray[n11];
            float[] fArray5 = fArray2[n12];
            float[] fArray6 = fArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n6; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                for (int j = 0; j < n5; ++j) {
                    fArray6[n18] = fArray4[n16] - fArray5[n17];
                    n16 += n2;
                    n17 += n4;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        double[][] dArray3 = rasterAccessor3.getDoubleDataArrays();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n7) {
            double[] dArray4 = dArray[n11];
            double[] dArray5 = dArray2[n12];
            double[] dArray6 = dArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            for (int i = 0; i < n6; ++i) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                n13 += n;
                n14 += n3;
                n15 += n8;
                for (int j = 0; j < n5; ++j) {
                    dArray6[n18] = dArray4[n16] - dArray5[n17];
                    n16 += n2;
                    n17 += n4;
                    n18 += n9;
                }
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }
}

