/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.media.jai.DeferredData;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeEmitter;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceChangeEvent;
import javax.media.jai.RenderingChangeEvent;

public class DeferredProperty
extends DeferredData
implements PropertyChangeListener {
    protected transient PropertySource propertySource;
    protected String propertyName;

    public DeferredProperty(PropertySource propertySource, String string, Class clazz) {
        super(clazz);
        if (propertySource == null || string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("DeferredData0"));
        }
        String[] stringArray = propertySource.getPropertyNames();
        boolean bl = false;
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException(JaiI18N.getString("DeferredProperty0"));
        }
        if (propertySource instanceof PropertyChangeEmitter) {
            PropertyChangeEmitter propertyChangeEmitter = (PropertyChangeEmitter)((Object)propertySource);
            propertyChangeEmitter.addPropertyChangeListener(string, this);
        }
        this.propertySource = propertySource;
        this.propertyName = string;
    }

    public PropertySource getPropertySource() {
        return this.propertySource;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected Object computeData() {
        return this.propertySource.getProperty(this.propertyName);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DeferredProperty)) {
            return false;
        }
        DeferredProperty deferredProperty = (DeferredProperty)object;
        return this.propertyName.equalsIgnoreCase(deferredProperty.getPropertyName()) && this.propertySource.equals(deferredProperty.getPropertySource()) && (!this.isValid() || !deferredProperty.isValid() || this.data.equals(deferredProperty.getData()));
    }

    public int hashCode() {
        return this.propertySource.hashCode() ^ this.propertyName.toLowerCase().hashCode();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.propertySource) {
            if (propertyChangeEvent instanceof RenderingChangeEvent) {
                this.setData(null);
            } else if (propertyChangeEvent instanceof PropertySourceChangeEvent && this.propertyName.equalsIgnoreCase(propertyChangeEvent.getPropertyName())) {
                Object object = propertyChangeEvent.getNewValue();
                this.setData(object == Image.UndefinedProperty ? null : object);
            }
        }
    }
}

