/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

final class MlibGradientOpImage
extends AreaOpImage {
    protected KernelJAI kernel_h;
    protected KernelJAI kernel_v;
    private int kh;
    private int kw;
    private int kx;
    private int ky;
    float[] kernel_h_data;
    float[] kernel_v_data;
    double[] dbl_kh_data;
    double[] dbl_kv_data;

    public MlibGradientOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI, KernelJAI kernelJAI2) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel_h = kernelJAI;
        this.kernel_v = kernelJAI2;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = this.kw / 2;
        this.ky = this.kh / 2;
        this.kernel_h_data = kernelJAI.getKernelData();
        this.kernel_v_data = kernelJAI2.getKernelData();
        int n = this.kw * this.kh;
        this.dbl_kh_data = new double[n];
        this.dbl_kv_data = new double[n];
        for (int i = 0; i < n; ++i) {
            this.dbl_kh_data[i] = this.kernel_h_data[i];
            this.dbl_kv_data[i] = this.kernel_v_data[i];
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        int n2 = this.getSampleModel().getNumBands();
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        block4: for (int i = 0; i < mediaLibImageArray2.length; ++i) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    Image.GradientMxN((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.dbl_kh_data, (double[])this.dbl_kv_data, (int)this.kw, (int)this.kh, (int)this.kx, (int)this.ky, (int)((1 << n2) - 1), (int)0);
                    continue block4;
                }
                case 4: 
                case 5: {
                    Image.GradientMxN_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.dbl_kh_data, (double[])this.dbl_kv_data, (int)this.kw, (int)this.kh, (int)this.kx, (int)this.ky, (int)((1 << n2) - 1), (int)0);
                    continue block4;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

