/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;
import javax.media.jai.UnpackedImageData;

public class MeanOpImage
extends StatisticsOpImage {
    private boolean isInitialized = false;
    private double[] totalPixelValue;
    private int totalPixelCount;
    private PixelAccessor srcPA;
    private int srcSampleType;

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }

    public MeanOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4) {
        super(renderedImage, rOI, n, n2, n3, n4);
    }

    protected String[] getStatisticsNames() {
        return new String[]{"mean"};
    }

    protected Object createStatistics(String string) {
        Object object = string.equalsIgnoreCase("mean") ? (Object)new double[this.sampleModel.getNumBands()] : Image.UndefinedProperty;
        return object;
    }

    private final int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        if (n4 == 0) {
            return n;
        }
        return n + (n3 - n4);
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        int n;
        Object object2;
        LinkedList linkedList;
        if (!this.isInitialized) {
            this.srcPA = new PixelAccessor(this.getSourceImage(0));
            this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
            this.totalPixelValue = new double[this.srcPA.numBands];
            this.totalPixelCount = 0;
            this.isInitialized = true;
        }
        Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
        if (this.roi == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            object2 = rectangle.intersection((Rectangle)listIterator.next());
            n = ((Rectangle)object2).x;
            int n2 = ((Rectangle)object2).y;
            ((Rectangle)object2).x = this.startPosition(n, this.xStart, this.xPeriod);
            ((Rectangle)object2).y = this.startPosition(n2, this.yStart, this.yPeriod);
            ((Rectangle)object2).width = n + ((Rectangle)object2).width - ((Rectangle)object2).x;
            ((Rectangle)object2).height = n2 + ((Rectangle)object2).height - ((Rectangle)object2).y;
            if (((Rectangle)object2).isEmpty()) continue;
            UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, (Rectangle)object2, this.srcSampleType, false);
            switch (unpackedImageData.type) {
                case 0: {
                    this.accumulateStatisticsByte(unpackedImageData);
                    break;
                }
                case 1: {
                    this.accumulateStatisticsUShort(unpackedImageData);
                    break;
                }
                case 2: {
                    this.accumulateStatisticsShort(unpackedImageData);
                    break;
                }
                case 3: {
                    this.accumulateStatisticsInt(unpackedImageData);
                    break;
                }
                case 4: {
                    this.accumulateStatisticsFloat(unpackedImageData);
                    break;
                }
                case 5: {
                    this.accumulateStatisticsDouble(unpackedImageData);
                }
            }
        }
        if (string.equalsIgnoreCase("mean")) {
            object2 = (double[])object;
            if (this.totalPixelCount != 0) {
                for (n = 0; n < this.srcPA.numBands; ++n) {
                    object2[n] = this.totalPixelValue[n] / (double)this.totalPixelCount;
                }
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        for (int i = 0; i < this.srcPA.numBands; ++i) {
            byte[] byArray2 = byArray[i];
            int n5 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
            for (int j = unpackedImageData.bandOffsets[i]; j < n5; j += n3) {
                int n6 = j + rectangle.width * n2;
                for (int k = j; k < n6; k += n4) {
                    int n7 = i;
                    this.totalPixelValue[n7] = this.totalPixelValue[n7] + (double)(byArray2[k] & 0xFF);
                }
            }
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsUShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        for (int i = 0; i < this.srcPA.numBands; ++i) {
            short[] sArray2 = sArray[i];
            int n5 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
            for (int j = unpackedImageData.bandOffsets[i]; j < n5; j += n3) {
                int n6 = j + rectangle.width * n2;
                for (int k = j; k < n6; k += n4) {
                    int n7 = i;
                    this.totalPixelValue[n7] = this.totalPixelValue[n7] + (double)(sArray2[k] & 0xFFFF);
                }
            }
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        for (int i = 0; i < this.srcPA.numBands; ++i) {
            short[] sArray2 = sArray[i];
            int n5 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
            for (int j = unpackedImageData.bandOffsets[i]; j < n5; j += n3) {
                int n6 = j + rectangle.width * n2;
                for (int k = j; k < n6; k += n4) {
                    int n7 = i;
                    this.totalPixelValue[n7] = this.totalPixelValue[n7] + (double)sArray2[k];
                }
            }
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsInt(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        int[][] nArray = unpackedImageData.getIntData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        for (int i = 0; i < this.srcPA.numBands; ++i) {
            int[] nArray2 = nArray[i];
            int n5 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
            for (int j = unpackedImageData.bandOffsets[i]; j < n5; j += n3) {
                int n6 = j + rectangle.width * n2;
                for (int k = j; k < n6; k += n4) {
                    int n7 = i;
                    this.totalPixelValue[n7] = this.totalPixelValue[n7] + (double)nArray2[k];
                }
            }
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsFloat(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        float[][] fArray = unpackedImageData.getFloatData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        for (int i = 0; i < this.srcPA.numBands; ++i) {
            float[] fArray2 = fArray[i];
            int n5 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
            for (int j = unpackedImageData.bandOffsets[i]; j < n5; j += n3) {
                int n6 = j + rectangle.width * n2;
                for (int k = j; k < n6; k += n4) {
                    int n7 = i;
                    this.totalPixelValue[n7] = this.totalPixelValue[n7] + (double)fArray2[k];
                }
            }
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsDouble(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        double[][] dArray = unpackedImageData.getDoubleData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        for (int i = 0; i < this.srcPA.numBands; ++i) {
            double[] dArray2 = dArray[i];
            int n5 = unpackedImageData.bandOffsets[i] + rectangle.height * n;
            for (int j = unpackedImageData.bandOffsets[i]; j < n5; j += n3) {
                int n6 = j + rectangle.width * n2;
                for (int k = j; k < n6; k += n4) {
                    int n7 = i;
                    this.totalPixelValue[n7] = this.totalPixelValue[n7] + dArray2[k];
                }
            }
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }
}

