/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import com.sun.media.jai.tilecodec.JaiI18N;
import com.sun.media.jai.tilecodec.TileCodecUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderImpl;
import javax.media.jai.util.ImagingListener;

public class RawTileDecoder
extends TileDecoderImpl {
    public RawTileDecoder(InputStream inputStream, TileCodecParameterList tileCodecParameterList) {
        super("raw", inputStream, tileCodecParameterList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster decode() throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(this.inputStream);
        try {
            Object object = objectInputStream.readObject();
            Raster raster = TileCodecUtils.deserializeRaster(object);
            return raster;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
            imagingListener.errorOccurred(JaiI18N.getString("ClassNotFound"), classNotFoundException, this, false);
            Raster raster = null;
            return raster;
        }
        finally {
            objectInputStream.close();
        }
    }

    public Raster decode(Point point) throws IOException {
        return this.decode();
    }
}

