/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TIFFImageMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_tiff_image_1.0";
    public static final String nativeMetadataFormatClassName = "com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadataFormat";
    List tagSets;
    TIFFIFD rootIFD;
    private static final String[] colorSpaceNames = new String[]{"GRAY", "GRAY", "RGB", "RGB", "GRAY", "CMYK", "YCbCr", "Lab", "Lab"};
    private static final String[] orientationNames = new String[]{null, "Normal", "FlipH", "Rotate180", "FlipV", "FlipHRotate90", "Rotate270", "FlipVRotate90", "Rotate90"};

    public TIFFImageMetadata(List list) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.tagSets = list;
        this.rootIFD = new TIFFIFD(list);
    }

    public TIFFImageMetadata(TIFFIFD tIFFIFD) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.tagSets = tIFFIFD.getTagSetList();
        this.rootIFD = tIFFIFD;
    }

    public void initializeFromStream(ImageInputStream imageInputStream, boolean bl) throws IOException {
        this.rootIFD.initialize(imageInputStream, bl);
    }

    public void addShortOrLongField(int n, int n2) {
        TIFFField tIFFField = new TIFFField(this.rootIFD.getTag(n), n2);
        this.rootIFD.addTIFFField(tIFFField);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private Node getIFDAsTree(TIFFIFD tIFFIFD, String string, int n) {
        Object object;
        Iterator iterator;
        List list;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("TIFFIFD");
        if (n != 0) {
            iIOMetadataNode.setAttribute("parentTagNumber", Integer.toString(n));
        }
        if (string != null) {
            iIOMetadataNode.setAttribute("parentTagName", string);
        }
        if ((list = tIFFIFD.getTagSetList()).size() > 0) {
            iterator = list.iterator();
            object = "";
            while (iterator.hasNext()) {
                TIFFTagSet tIFFTagSet = (TIFFTagSet)iterator.next();
                object = (String)object + tIFFTagSet.getClass().getName();
                if (!iterator.hasNext()) continue;
                object = (String)object + ",";
            }
            iIOMetadataNode.setAttribute("tagSets", (String)object);
        }
        iterator = tIFFIFD.iterator();
        while (iterator.hasNext()) {
            object = (TIFFField)iterator.next();
            int n2 = ((TIFFField)object).getTagNumber();
            TIFFTag tIFFTag = TIFFIFD.getTag(n2, list);
            Node node = null;
            if (tIFFTag == null) {
                node = ((TIFFField)object).getAsNativeNode();
            } else if (tIFFTag.isIFDPointer()) {
                TIFFIFD tIFFIFD2 = (TIFFIFD)((TIFFField)object).getData();
                node = this.getIFDAsTree(tIFFIFD2, tIFFTag.getName(), tIFFTag.getNumber());
            } else {
                node = ((TIFFField)object).getAsNativeNode();
            }
            if (node == null) continue;
            iIOMetadataNode.appendChild(node);
        }
        return iIOMetadataNode;
    }

    @Override
    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        Node node = this.getIFDAsTree(this.rootIFD, null, 0);
        iIOMetadataNode.appendChild(node);
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        int n = -1;
        boolean bl = false;
        TIFFField tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            n = tIFFField.getAsInt(0);
            bl = n == 3;
        }
        int n2 = -1;
        if (bl) {
            n2 = 3;
        } else {
            tIFFField = this.getTIFFField(277);
            if (tIFFField != null) {
                n2 = tIFFField.getAsInt(0);
            } else {
                tIFFField = this.getTIFFField(258);
                if (tIFFField != null) {
                    n2 = tIFFField.getCount();
                }
            }
        }
        if (n != -1) {
            if (n >= 0 && n < colorSpaceNames.length) {
                iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
                String string = n == 5 && n2 == 3 ? "CMY" : colorSpaceNames[n];
                iIOMetadataNode2.setAttribute("name", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
            iIOMetadataNode2.setAttribute("value", n == 0 ? "FALSE" : "TRUE");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (n2 != -1) {
            iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
            iIOMetadataNode2.setAttribute("value", Integer.toString(n2));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if ((tIFFField = this.getTIFFField(320)) != null) {
            boolean bl2 = false;
            iIOMetadataNode2 = new IIOMetadataNode("Palette");
            int n3 = tIFFField.getCount() / 3;
            for (int i = 0; i < n3; ++i) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(i));
                int n4 = tIFFField.getAsInt(i) * 255 / 65535;
                int n5 = tIFFField.getAsInt(n3 + i) * 255 / 65535;
                int n6 = tIFFField.getAsInt(2 * n3 + i) * 255 / 65535;
                iIOMetadataNode3.setAttribute("red", Integer.toString(n4));
                iIOMetadataNode3.setAttribute("green", Integer.toString(n5));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(n6));
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = null;
        TIFFField tIFFField = this.getTIFFField(259);
        if (tIFFField != null) {
            String string = null;
            int n = tIFFField.getAsInt(0);
            boolean bl = true;
            if (n == 1) {
                string = "None";
                bl = true;
            } else {
                int[] nArray = TIFFImageReader.compressionNumbers;
                for (int i = 0; i < nArray.length; ++i) {
                    if (n != nArray[i]) continue;
                    string = TIFFImageReader.compressionTypes[i];
                    bl = TIFFImageReader.isCompressionLossless[i];
                    break;
                }
            }
            if (string != null) {
                iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
                iIOMetadataNode2 = new IIOMetadataNode("Lossless");
                iIOMetadataNode2.setAttribute("value", bl ? "TRUE" : "FALSE");
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        iIOMetadataNode2 = new IIOMetadataNode("NumProgressiveScans");
        iIOMetadataNode2.setAttribute("value", "1");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private String repeat(String string, int n) {
        if (n == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder((string.length() + 1) * n - 1);
        stringBuilder.append(string);
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public IIOMetadataNode getStandardDataNode() {
        int n;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = null;
        boolean bl = false;
        TIFFField tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            bl = tIFFField.getAsInt(0) == 3;
        }
        tIFFField = this.getTIFFField(284);
        String string = "PixelInterleaved";
        if (tIFFField != null && tIFFField.getAsInt(0) == 2) {
            string = "PlaneInterleaved";
        }
        iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            int n2 = tIFFField.getAsInt(0);
            String string2 = "UnsignedIntegral";
            if (n2 == 3) {
                string2 = "Index";
            } else {
                tIFFField = this.getTIFFField(339);
                if (tIFFField != null) {
                    n = tIFFField.getAsInt(0);
                    string2 = n == 2 ? "SignedIntegral" : (n == 1 ? "UnsignedIntegral" : (n == 3 ? "Real" : null));
                }
            }
            if (string2 != null) {
                iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
                iIOMetadataNode2.setAttribute("value", string2);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        tIFFField = this.getTIFFField(258);
        int[] nArray = null;
        if (tIFFField != null) {
            nArray = tIFFField.getAsInts();
        } else {
            int n3;
            tIFFField = this.getTIFFField(259);
            int n4 = n3 = tIFFField != null ? tIFFField.getAsInt(0) : 1;
            nArray = this.getTIFFField(34665) != null || n3 == 7 || n3 == 6 || this.getTIFFField(513) != null ? ((tIFFField = this.getTIFFField(262)) != null && (tIFFField.getAsInt(0) == 0 || tIFFField.getAsInt(0) == 1) ? new int[]{8} : new int[]{8, 8, 8}) : new int[]{1};
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < nArray.length; ++n) {
            if (n > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(Integer.toString(nArray[n]));
        }
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        if (bl) {
            iIOMetadataNode2.setAttribute("value", this.repeat(stringBuilder.toString(), 3));
        } else {
            iIOMetadataNode2.setAttribute("value", stringBuilder.toString());
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        tIFFField = this.getTIFFField(266);
        n = tIFFField != null ? tIFFField.getAsInt(0) : 1;
        stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            int n5 = nArray[i] == 1 ? 7 : nArray[i] - 1;
            int n6 = n == 1 ? n5 : 0;
            stringBuilder.append(Integer.toString(n6));
        }
        iIOMetadataNode2 = new IIOMetadataNode("SampleMSB");
        if (bl) {
            iIOMetadataNode2.setAttribute("value", this.repeat(stringBuilder.toString(), 3));
        } else {
            iIOMetadataNode2.setAttribute("value", stringBuilder.toString());
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        int n;
        float f2;
        int n2;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        long[] lArray = null;
        long[] lArray2 = null;
        TIFFField tIFFField = this.getTIFFField(282);
        if (tIFFField != null) {
            lArray = (long[])tIFFField.getAsRational(0).clone();
        }
        if ((tIFFField = this.getTIFFField(283)) != null) {
            lArray2 = (long[])tIFFField.getAsRational(0).clone();
        }
        if (lArray != null && lArray2 != null) {
            iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
            float f3 = (float)((double)lArray[1] * (double)lArray2[0]) / (float)(lArray[0] * lArray2[1]);
            iIOMetadataNode2.setAttribute("value", Float.toString(f3));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (lArray != null || lArray2 != null) {
            tIFFField = this.getTIFFField(296);
            int n3 = tIFFField != null ? tIFFField.getAsInt(0) : 2;
            int n4 = n2 = n3 != 1 ? 1 : 0;
            if (n3 == 2) {
                if (lArray != null) {
                    lArray[0] = lArray[0] * 100L;
                    lArray[1] = lArray[1] * 254L;
                }
                if (lArray2 != null) {
                    lArray2[0] = lArray2[0] * 100L;
                    lArray2[1] = lArray2[1] * 254L;
                }
            }
            if (n2 != 0) {
                if (lArray != null) {
                    f2 = (float)(10.0 * (double)lArray[1] / (double)lArray[0]);
                    iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
                    iIOMetadataNode2.setAttribute("value", Float.toString(f2));
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                }
                if (lArray2 != null) {
                    f2 = (float)(10.0 * (double)lArray2[1] / (double)lArray2[0]);
                    iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
                    iIOMetadataNode2.setAttribute("value", Float.toString(f2));
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                }
            }
        }
        int n5 = n = (tIFFField = this.getTIFFField(296)) != null ? tIFFField.getAsInt(0) : 2;
        if (n == 2 || n == 3) {
            tIFFField = this.getTIFFField(286);
            if (tIFFField != null) {
                long[] lArray3 = tIFFField.getAsRational(0);
                f2 = (float)lArray3[0] / (float)lArray3[1];
                f2 = n == 2 ? (f2 *= 254.0f) : (f2 *= 10.0f);
                iIOMetadataNode2 = new IIOMetadataNode("HorizontalPosition");
                iIOMetadataNode2.setAttribute("value", Float.toString(f2));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            if ((tIFFField = this.getTIFFField(287)) != null) {
                long[] lArray4 = tIFFField.getAsRational(0);
                f2 = (float)lArray4[0] / (float)lArray4[1];
                f2 = n == 2 ? (f2 *= 254.0f) : (f2 *= 10.0f);
                iIOMetadataNode2 = new IIOMetadataNode("VerticalPosition");
                iIOMetadataNode2.setAttribute("value", Float.toString(f2));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        if ((tIFFField = this.getTIFFField(274)) != null && (n2 = tIFFField.getAsInt(0)) >= 0 && n2 < orientationNames.length) {
            iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
            iIOMetadataNode2.setAttribute("value", orientationNames[n2]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDocumentNode() {
        String string;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode2.setAttribute("value", "6.0");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        TIFFField tIFFField = this.getTIFFField(254);
        if (tIFFField != null) {
            int n = tIFFField.getAsInt(0);
            String string2 = null;
            if ((n & 4) != 0) {
                string2 = "TransparencyMask";
            } else if ((n & 1) != 0) {
                string2 = "ReducedResolution";
            } else if ((n & 2) != 0) {
                string2 = "SinglePage";
            }
            if (string2 != null) {
                iIOMetadataNode2 = new IIOMetadataNode("SubimageInterpretation");
                iIOMetadataNode2.setAttribute("value", string2);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        if ((tIFFField = this.getTIFFField(306)) != null && (string = tIFFField.getAsString(0)).length() == 19) {
            boolean bl;
            iIOMetadataNode2 = new IIOMetadataNode("ImageCreationTime");
            try {
                iIOMetadataNode2.setAttribute("year", string.substring(0, 4));
                iIOMetadataNode2.setAttribute("month", string.substring(5, 7));
                iIOMetadataNode2.setAttribute("day", string.substring(8, 10));
                iIOMetadataNode2.setAttribute("hour", string.substring(11, 13));
                iIOMetadataNode2.setAttribute("minute", string.substring(14, 16));
                iIOMetadataNode2.setAttribute("second", string.substring(17, 19));
                bl = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                bl = false;
            }
            if (bl) {
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardTextNode() {
        int[] nArray;
        IIOMetadataNode iIOMetadataNode = null;
        IIOMetadataNode iIOMetadataNode2 = null;
        for (int n : nArray = new int[]{269, 270, 271, 272, 285, 305, 315, 316, 333, 33432}) {
            TIFFField tIFFField = this.getTIFFField(n);
            if (tIFFField == null) continue;
            String string = tIFFField.getAsString(0);
            if (iIOMetadataNode == null) {
                iIOMetadataNode = new IIOMetadataNode("Text");
            }
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", tIFFField.getTag().getName());
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        String string = "none";
        TIFFField tIFFField = this.getTIFFField(338);
        if (tIFFField != null) {
            int[] nArray;
            for (int n : nArray = tIFFField.getAsInts()) {
                if (n == 1) {
                    string = "premultiplied";
                    break;
                }
                if (n != 2) continue;
                string = "nonpremultiplied";
                break;
            }
        }
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private static void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    private int[] listToIntArray(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            Integer n = new Integer((String)object);
            arrayList.add(n);
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    private char[] listToCharArray(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            Integer n = new Integer((String)object);
            arrayList.add(n);
        }
        object = new char[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (char)((Integer)arrayList.get(i)).intValue();
        }
        return object;
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        TIFFField tIFFField;
        TIFFTag tIFFTag;
        Object object;
        Object object2;
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            TIFFImageMetadata.fatal(node2, "Root must be javax_imageio_1.0");
        }
        String string = null;
        Node node3 = this.getChildNode(node, "Data");
        boolean bl = false;
        if (node3 != null && (object2 = this.getChildNode(node3, "SampleFormat")) != null) {
            string = TIFFImageMetadata.getAttribute((Node)object2, "value");
            bl = string.equals("Index");
        }
        if (!bl && (object2 = this.getChildNode(node, "Chroma")) != null && this.getChildNode((Node)object2, "Palette") != null) {
            bl = true;
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            int n;
            Object object3;
            int n2;
            object2 = node2.getNodeName();
            if (((String)object2).equals("Chroma")) {
                Object object4;
                int n3;
                String string2 = null;
                object = null;
                n2 = 0;
                for (object3 = node2.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                    String string3 = object3.getNodeName();
                    if (string3.equals("ColorSpaceType")) {
                        string2 = TIFFImageMetadata.getAttribute((Node)object3, "name");
                        continue;
                    }
                    if (string3.equals("NumChannels")) {
                        tIFFTag = this.rootIFD.getTag(277);
                        n3 = bl ? 1 : Integer.parseInt(TIFFImageMetadata.getAttribute((Node)object3, "value"));
                        tIFFField = new TIFFField(tIFFTag, n3);
                        this.rootIFD.addTIFFField(tIFFField);
                        continue;
                    }
                    if (string3.equals("BlackIsZero")) {
                        object = TIFFImageMetadata.getAttribute((Node)object3, "value");
                        continue;
                    }
                    if (!string3.equals("Palette")) continue;
                    object4 = new HashMap();
                    int n4 = -1;
                    for (Node node4 = object3.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                        String string4 = node4.getNodeName();
                        if (!string4.equals("PaletteEntry")) continue;
                        String string5 = TIFFImageMetadata.getAttribute(node4, "index");
                        int n5 = Integer.parseInt(string5);
                        if (n5 > n4) {
                            n4 = n5;
                        }
                        char c2 = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node4, "red"));
                        char c3 = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node4, "green"));
                        char c4 = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node4, "blue"));
                        ((HashMap)object4).put(new Integer(n5), new char[]{c2, c3, c4});
                        n2 = 1;
                    }
                    if (n2 == 0) continue;
                    int n6 = n4 + 1;
                    int n7 = 3 * n6;
                    char[] cArray = new char[n7];
                    for (Integer n8 : ((HashMap)object4).keySet()) {
                        char[] cArray2 = (char[])((HashMap)object4).get(n8);
                        n = n8;
                        cArray[n] = (char)(cArray2[0] * 65535 / 255);
                        cArray[n6 + n] = (char)(cArray2[1] * 65535 / 255);
                        cArray[2 * n6 + n] = (char)(cArray2[2] * 65535 / 255);
                    }
                    tIFFTag = this.rootIFD.getTag(320);
                    tIFFField = new TIFFField(tIFFTag, 3, n7, cArray);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                int n9 = -1;
                if ((string2 == null || string2.equals("GRAY")) && object != null && ((String)object).equalsIgnoreCase("FALSE")) {
                    n9 = 0;
                } else if (string2 != null) {
                    if (string2.equals("GRAY")) {
                        Node node5;
                        String string6;
                        NodeList nodeList;
                        n3 = 0;
                        if (node instanceof IIOMetadataNode && (nodeList = ((IIOMetadataNode)(object4 = (IIOMetadataNode)node)).getElementsByTagName("SubimageInterpretation")).getLength() == 1 && (string6 = TIFFImageMetadata.getAttribute(node5 = nodeList.item(0), "value")).equals("TransparencyMask")) {
                            n3 = 1;
                        }
                        n9 = n3 != 0 ? 4 : 1;
                    } else if (string2.equals("RGB")) {
                        n9 = n2 != 0 ? 3 : 2;
                    } else if (string2.equals("YCbCr")) {
                        n9 = 6;
                    } else if (string2.equals("CMYK")) {
                        n9 = 5;
                    } else if (string2.equals("Lab")) {
                        n9 = 8;
                    }
                }
                if (n9 == -1) continue;
                tIFFTag = this.rootIFD.getTag(262);
                tIFFField = new TIFFField(tIFFTag, n9);
                this.rootIFD.addTIFFField(tIFFField);
                continue;
            }
            if (((String)object2).equals("Compression")) {
                for (Node node6 = node2.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                    object = node6.getNodeName();
                    if (!((String)object).equals("CompressionTypeName")) continue;
                    n2 = -1;
                    object3 = TIFFImageMetadata.getAttribute(node6, "value");
                    if (((String)object3).equalsIgnoreCase("None")) {
                        n2 = 1;
                    } else {
                        String[] stringArray = TIFFImageReader.compressionTypes;
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!stringArray[i].equalsIgnoreCase((String)object3)) continue;
                            n2 = TIFFImageReader.compressionNumbers[i];
                            break;
                        }
                    }
                    if (n2 == -1) continue;
                    tIFFTag = this.rootIFD.getTag(259);
                    tIFFField = new TIFFField(tIFFTag, n2);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                continue;
            }
            if (((String)object2).equals("Data")) {
                for (Node node7 = node2.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                    String string7;
                    object = node7.getNodeName();
                    if (((String)object).equals("PlanarConfiguration")) {
                        string7 = TIFFImageMetadata.getAttribute(node7, "value");
                        int n10 = -1;
                        if (string7.equals("PixelInterleaved")) {
                            n10 = 1;
                        } else if (string7.equals("PlaneInterleaved")) {
                            n10 = 2;
                        }
                        if (n10 == -1) continue;
                        tIFFTag = this.rootIFD.getTag(284);
                        tIFFField = new TIFFField(tIFFTag, n10);
                        this.rootIFD.addTIFFField(tIFFField);
                        continue;
                    }
                    if (((String)object).equals("BitsPerSample")) {
                        string7 = TIFFImageMetadata.getAttribute(node7, "value");
                        char[] cArray = this.listToCharArray(string7);
                        tIFFTag = this.rootIFD.getTag(258);
                        tIFFField = bl ? new TIFFField(tIFFTag, 3, 1, new char[]{cArray[0]}) : new TIFFField(tIFFTag, 3, cArray.length, cArray);
                        this.rootIFD.addTIFFField(tIFFField);
                        continue;
                    }
                    if (!((String)object).equals("SampleMSB")) continue;
                    string7 = TIFFImageMetadata.getAttribute(node7, "value");
                    int[] nArray = this.listToIntArray(string7);
                    boolean bl2 = true;
                    for (int n11 : nArray) {
                        if (n11 == 0) continue;
                        bl2 = false;
                        break;
                    }
                    int n12 = bl2 ? 2 : 1;
                    tIFFTag = this.rootIFD.getTag(266);
                    tIFFField = new TIFFField(tIFFTag, n12);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                continue;
            }
            if (((String)object2).equals("Dimension")) {
                Object object5;
                float f2 = -1.0f;
                boolean bl3 = false;
                float f3 = -1.0f;
                boolean bl4 = false;
                float f4 = -1.0f;
                boolean bl5 = false;
                boolean bl6 = false;
                float f5 = -1.0f;
                boolean bl7 = false;
                float f6 = -1.0f;
                boolean bl8 = false;
                block8: for (Node node8 = node2.getFirstChild(); node8 != null; node8 = node8.getNextSibling()) {
                    String string8 = node8.getNodeName();
                    if (string8.equals("PixelAspectRatio")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        f2 = Float.parseFloat((String)object5);
                        bl3 = true;
                        continue;
                    }
                    if (string8.equals("ImageOrientation")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        for (n = 0; n < orientationNames.length; ++n) {
                            if (!((String)object5).equals(orientationNames[n])) continue;
                            char[] cArray = new char[]{(char)n};
                            tIFFField = new TIFFField(this.rootIFD.getTag(274), 3, 1, cArray);
                            this.rootIFD.addTIFFField(tIFFField);
                            continue block8;
                        }
                        continue;
                    }
                    if (string8.equals("HorizontalPixelSize")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        f3 = Float.parseFloat((String)object5);
                        bl4 = true;
                        continue;
                    }
                    if (string8.equals("VerticalPixelSize")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        f4 = Float.parseFloat((String)object5);
                        bl5 = true;
                        continue;
                    }
                    if (string8.equals("HorizontalPosition")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        f5 = Float.parseFloat((String)object5);
                        bl7 = true;
                        continue;
                    }
                    if (!string8.equals("VerticalPosition")) continue;
                    object5 = TIFFImageMetadata.getAttribute(node8, "value");
                    f6 = Float.parseFloat((String)object5);
                    bl8 = true;
                }
                boolean bl9 = bl6 = bl4 || bl5;
                if (bl3) {
                    if (bl4 && !bl5) {
                        f4 = f3 / f2;
                        bl5 = true;
                    } else if (bl5 && !bl4) {
                        f3 = f4 * f2;
                        bl4 = true;
                    } else if (!bl4 && !bl5) {
                        f3 = f2;
                        f4 = 1.0f;
                        bl4 = true;
                        bl5 = true;
                    }
                }
                if (bl4) {
                    float f7 = (bl6 ? 10.0f : 1.0f) / f3;
                    object5 = new long[1][2];
                    object5[0] = new long[2];
                    object5[0][0] = (long)(f7 * 10000.0f);
                    object5[0][1] = 10000L;
                    tIFFField = new TIFFField(this.rootIFD.getTag(282), 5, 1, object5);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (bl5) {
                    float f8 = (bl6 ? 10.0f : 1.0f) / f4;
                    object5 = new long[1][2];
                    object5[0] = new long[2];
                    object5[0][0] = (long)(f8 * 10000.0f);
                    object5[0][1] = 10000L;
                    tIFFField = new TIFFField(this.rootIFD.getTag(283), 5, 1, object5);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                char[] cArray = new char[]{(char)(bl6 ? 3 : 1)};
                tIFFField = new TIFFField(this.rootIFD.getTag(296), 3, 1, cArray);
                this.rootIFD.addTIFFField(tIFFField);
                if (!bl6) continue;
                if (bl7) {
                    object5 = new long[1][2];
                    object5[0][0] = (long)(f5 * 10000.0f);
                    object5[0][1] = 100000L;
                    tIFFField = new TIFFField(this.rootIFD.getTag(286), 5, 1, object5);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (!bl8) continue;
                object5 = new long[1][2];
                object5[0][0] = (long)(f6 * 10000.0f);
                object5[0][1] = 100000L;
                tIFFField = new TIFFField(this.rootIFD.getTag(287), 5, 1, object5);
                this.rootIFD.addTIFFField(tIFFField);
                continue;
            }
            if (((String)object2).equals("Document")) {
                for (Node node9 = node2.getFirstChild(); node9 != null; node9 = node9.getNextSibling()) {
                    String string9;
                    object = node9.getNodeName();
                    if (((String)object).equals("SubimageInterpretation")) {
                        string9 = TIFFImageMetadata.getAttribute(node9, "value");
                        int n13 = -1;
                        if (string9.equals("TransparencyMask")) {
                            n13 = 4;
                        } else if (string9.equals("ReducedResolution")) {
                            n13 = 1;
                        } else if (string9.equals("SinglePage")) {
                            n13 = 2;
                        }
                        if (n13 != -1) {
                            tIFFTag = this.rootIFD.getTag(254);
                            tIFFField = new TIFFField(tIFFTag, n13);
                            this.rootIFD.addTIFFField(tIFFField);
                        }
                    }
                    if (!((String)object).equals("ImageCreationTime")) continue;
                    string9 = TIFFImageMetadata.getAttribute(node9, "year");
                    String string10 = TIFFImageMetadata.getAttribute(node9, "month");
                    String string11 = TIFFImageMetadata.getAttribute(node9, "day");
                    String string12 = TIFFImageMetadata.getAttribute(node9, "hour");
                    String string13 = TIFFImageMetadata.getAttribute(node9, "minute");
                    String string14 = TIFFImageMetadata.getAttribute(node9, "second");
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string9);
                    stringBuilder.append(":");
                    if (string10.length() == 1) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(string10);
                    stringBuilder.append(":");
                    if (string11.length() == 1) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(string11);
                    stringBuilder.append(" ");
                    if (string12.length() == 1) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(string12);
                    stringBuilder.append(":");
                    if (string13.length() == 1) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(string13);
                    stringBuilder.append(":");
                    if (string14.length() == 1) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(string14);
                    String[] stringArray = new String[]{stringBuilder.toString()};
                    tIFFField = new TIFFField(this.rootIFD.getTag(306), 2, 1, stringArray);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                continue;
            }
            if (((String)object2).equals("Text")) {
                object = null;
                String string15 = null;
                object3 = null;
                for (Node node10 = node2.getFirstChild(); node10 != null; node10 = node10.getNextSibling()) {
                    String string16 = node10.getNodeName();
                    if (!string16.equals("TextEntry")) continue;
                    int n14 = -1;
                    NamedNodeMap namedNodeMap = node10.getAttributes();
                    Node node11 = namedNodeMap.getNamedItem("keyword");
                    if (node11 == null) continue;
                    String string17 = node11.getNodeValue();
                    String string18 = TIFFImageMetadata.getAttribute(node10, "value");
                    if (string17.equals("") || string18.equals("")) continue;
                    if (string17.equalsIgnoreCase("DocumentName")) {
                        n14 = 269;
                    } else if (string17.equalsIgnoreCase("ImageDescription")) {
                        n14 = 270;
                    } else if (string17.equalsIgnoreCase("Make")) {
                        n14 = 271;
                    } else if (string17.equalsIgnoreCase("Model")) {
                        n14 = 272;
                    } else if (string17.equalsIgnoreCase("PageName")) {
                        n14 = 285;
                    } else if (string17.equalsIgnoreCase("Software")) {
                        n14 = 305;
                    } else if (string17.equalsIgnoreCase("Artist")) {
                        n14 = 315;
                    } else if (string17.equalsIgnoreCase("HostComputer")) {
                        n14 = 316;
                    } else if (string17.equalsIgnoreCase("InkNames")) {
                        n14 = 333;
                    } else if (string17.equalsIgnoreCase("Copyright")) {
                        n14 = 33432;
                    } else if (string17.equalsIgnoreCase("author")) {
                        object = string18;
                    } else if (string17.equalsIgnoreCase("description")) {
                        string15 = string18;
                    } else if (string17.equalsIgnoreCase("title")) {
                        object3 = string18;
                    }
                    if (n14 == -1) continue;
                    tIFFField = new TIFFField(this.rootIFD.getTag(n14), 2, 1, new String[]{string18});
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (object != null && this.getTIFFField(315) == null) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(315), 2, 1, new String[]{object});
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (string15 != null && this.getTIFFField(270) == null) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(270), 2, 1, new String[]{string15});
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (object3 == null || this.getTIFFField(269) != null) continue;
                tIFFField = new TIFFField(this.rootIFD.getTag(269), 2, 1, new String[]{object3});
                this.rootIFD.addTIFFField(tIFFField);
                continue;
            }
            if (!((String)object2).equals("Transparency")) continue;
            for (Node node12 = node2.getFirstChild(); node12 != null; node12 = node12.getNextSibling()) {
                object = node12.getNodeName();
                if (!((String)object).equals("Alpha")) continue;
                String string19 = TIFFImageMetadata.getAttribute(node12, "value");
                tIFFField = null;
                if (string19.equals("premultiplied")) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(338), 1);
                } else if (string19.equals("nonpremultiplied")) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(338), 2);
                }
                if (tIFFField == null) continue;
                this.rootIFD.addTIFFField(tIFFField);
            }
        }
        if (string != null) {
            int n = -1;
            if (string.equals("SignedIntegral")) {
                n = 2;
            } else if (string.equals("UnsignedIntegral")) {
                n = 1;
            } else if (string.equals("Real")) {
                n = 3;
            } else if (string.equals("Index")) {
                n = 1;
            }
            if (n != -1) {
                int n15 = 1;
                tIFFField = this.getTIFFField(277);
                if (tIFFField != null) {
                    n15 = tIFFField.getAsInt(0);
                } else {
                    tIFFField = this.getTIFFField(258);
                    if (tIFFField != null) {
                        n15 = tIFFField.getCount();
                    }
                }
                object = new char[n15];
                Arrays.fill((char[])object, (char)n);
                tIFFTag = this.rootIFD.getTag(339);
                tIFFField = new TIFFField(tIFFTag, 3, ((Object)object).length, object);
                this.rootIFD.addTIFFField(tIFFField);
            }
        }
    }

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 != null ? node2.getNodeValue() : null;
    }

    private Node getChildNode(Node node, String string) {
        Node node2 = null;
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                if (!node3.getNodeName().equals(string)) continue;
                node2 = node3;
                break;
            }
        }
        return node2;
    }

    /*
     * WARNING - void declaration
     */
    public static TIFFIFD parseIFD(Node node) throws IIOInvalidTreeException {
        Object object;
        Object object2;
        String string;
        Object object3;
        if (!node.getNodeName().equals("TIFFIFD")) {
            TIFFImageMetadata.fatal(node, "Expected \"TIFFIFD\" node");
        }
        String string2 = TIFFImageMetadata.getAttribute(node, "tagSets");
        ArrayList<TIFFTagSet> arrayList = new ArrayList<TIFFTagSet>(5);
        if (string2 != null) {
            object3 = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                string = ((StringTokenizer)object3).nextToken();
                object2 = null;
                try {
                    Class<?> clazz = Class.forName(string);
                    object = clazz.getMethod("getInstance", null);
                    object2 = ((Method)object).invoke(null, (Object[])null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                if (!(object2 instanceof TIFFTagSet)) {
                    TIFFImageMetadata.fatal(node, "Specified tag set class \"" + string + "\" is not an instance of TIFFTagSet");
                    continue;
                }
                arrayList.add((TIFFTagSet)object2);
            }
        }
        object3 = new TIFFIFD(arrayList);
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            string = node.getNodeName();
            object2 = null;
            if (string.equals("TIFFIFD")) {
                void var9_21;
                void var9_19;
                int n;
                TIFFIFD tIFFIFD = TIFFImageMetadata.parseIFD(node);
                object = TIFFImageMetadata.getAttribute(node, "parentTagName");
                String string3 = TIFFImageMetadata.getAttribute(node, "parentTagNumber");
                Object var9_16 = null;
                if (object != null) {
                    TIFFTag tIFFTag = TIFFIFD.getTag((String)object, arrayList);
                } else if (string3 != null) {
                    n = Integer.valueOf(string3);
                    TIFFTag tIFFTag = TIFFIFD.getTag(n, arrayList);
                }
                if (var9_19 == null) {
                    TIFFTag tIFFTag = new TIFFTag("unknown", 0, 0, null);
                }
                n = var9_21.isDataTypeOK(13) ? 13 : 4;
                object2 = new TIFFField((TIFFTag)var9_21, n, 1, tIFFIFD);
            } else if (string.equals("TIFFField")) {
                int n = Integer.parseInt(TIFFImageMetadata.getAttribute(node, "number"));
                object = null;
                for (TIFFTagSet tIFFTagSet : arrayList) {
                    if (tIFFTagSet.getTag(n) == null) continue;
                    object = tIFFTagSet;
                    break;
                }
                object2 = TIFFField.createFromMetadataNode((TIFFTagSet)object, node);
            } else {
                TIFFImageMetadata.fatal(node, "Expected either \"TIFFIFD\" or \"TIFFField\" node, got " + string);
            }
            ((TIFFDirectory)object3).addTIFFField((TIFFField)object2);
        }
        return object3;
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Object object2;
        Node node2 = node;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            TIFFImageMetadata.fatal(node2, "Root must be com_sun_media_imageio_plugins_tiff_image_1.0");
        }
        if ((node2 = node2.getFirstChild()) == null || !node2.getNodeName().equals("TIFFIFD")) {
            TIFFImageMetadata.fatal(node, "Root must have \"TIFFIFD\" child");
        }
        TIFFIFD tIFFIFD = TIFFImageMetadata.parseIFD(node2);
        List list = this.rootIFD.getTagSetList();
        for (Object object2 : tIFFIFD.getTagSetList()) {
            if (!(object2 instanceof TIFFTagSet) || list.contains(object2)) continue;
            this.rootIFD.addTagSet((TIFFTagSet)object2);
        }
        object2 = tIFFIFD.iterator();
        while (object2.hasNext()) {
            TIFFField tIFFField = (TIFFField)object2.next();
            this.rootIFD.addTIFFField(tIFFField);
        }
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    @Override
    public void reset() {
        this.rootIFD = new TIFFIFD(this.tagSets);
    }

    public TIFFIFD getRootIFD() {
        return this.rootIFD;
    }

    public TIFFField getTIFFField(int n) {
        return this.rootIFD.getTIFFField(n);
    }

    public void removeTIFFField(int n) {
        this.rootIFD.removeTIFFField(n);
    }

    public TIFFImageMetadata getShallowClone() {
        return new TIFFImageMetadata(this.rootIFD.getShallowClone());
    }
}

