/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2009 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 1.0.1
 */
 var _updatetimer;
 var uniqueID = false;
 var spin;
 var FSITouchZoom;
 var oldPWidth;
 var oldPHeight;
 var boPSC = false;
 var plugins = new Array();
 
if (!fsiparser) {
	fsiparser = new fsiParser(fsirooturl);
}
if (fsiparser.init) fsiparser.init();
else interfaceControl.showPublishMessage("Error","FSI Parser initialisation error");

var currentColor = Colors.ColorFromRGB(64,128,128);
CurrentPreviewWindow = false;
oldPreviewWindowWidth = oldPreviewWindowHeight = -1;
colorPickerVisible = false;
var query='';
var moreoptions = false;
var currentColor = Colors.ColorFromRGB(255,255,255);
var fsiparser;
var fsiparser_basepath = fsirooturl;
var relSectionPath = 'viewer3d_presets';
var fsiparser_presetpath = fsiparser_basepath+'config/viewer3d_presets';
var opt = document.settings;
var bPublishFromDirSelection = true;
/*
if (interfaceControl.isBasePath3DDirectories()) bPublishFromDirSelection = true; 			
else bPublishFromDirSelection = (interfaceControl.getThumbView().getSingleSelectedItemType() == "directory");
*/

function getDir() {

	var dir = new Array();
	dir[0] = 'options_Dir';
	try {
		var e = getFirstImage();
		if (e) dir[1] = getBasePathFromEntry(e);
		else dir[1] = interfaceControl.getBasePath(oPreviewEntry);
	} catch(e) { 
		
		dir[1] = interfaceControl.getBasePath();
	}

	var check = interfaceControl.isBasePath3D();
	if (typeof(check) != 'null' && check) dir[1] = interfaceControl.getBasePath3D();
	
	qdata["options_dir"] = decodeURIComponent(dir[1]);
	return dir;
	
}


function setMatrix(){
	var opt = document.settings;
	
	var Left = opt.lrgba_rr.value+","+opt.lrgba_rg.value+","+opt.lrgba_rb.value+",";
	Left += opt.lrgba_gr.value+","+opt.lrgba_gg.value+","+opt.lrgba_gb.value+",";
	Left += opt.lrgba_br.value+","+opt.lrgba_bg.value+","+opt.lrgba_bb.value;
	
	qdata["lefteffects"] = "RGBMatrix("+Left+")";
	if (Left == "1,0,0,0,1,0,0,0,1") delete qdata["lefteffects"];
	if(opt.leftextraeffect.value != "") {
		if (qdata["lefteffects"]) qdata["lefteffects"] = qdata["lefteffects"] + ",";
		qdata["lefteffects"] += opt.leftextraeffect.value;
	}
	
	var Right = opt.rrgba_rr.value+","+opt.rrgba_rg.value+","+opt.rrgba_rb.value+",";
	Right += opt.rrgba_gr.value+","+opt.rrgba_gg.value+","+opt.rrgba_gb.value+",";
	Right += opt.rrgba_br.value+","+opt.rrgba_bg.value+","+opt.rrgba_bb.value;
	
	qdata["righteffects"] = "RGBMatrix("+Right+")";
	if (Right == "1,0,0,0,1,0,0,0,1") delete qdata["righteffects"];
	if(opt.rightextraeffect.value != "") {
		if (qdata["righteffects"]) qdata["righteffects"] = qdata["righteffects"] + ",";
		qdata["righteffects"] += opt.rightextraeffect.value;
	}
	
	updateCode();
}



function scrollTextArea(from,to) {
	from.onscroll = function (evt) {
		to.scrollTop = this.scrollTop;
	}
}


function  initit() {
	loadJSFiles('viewer');
	loadJSFiles('touchzoom');
	
	var publishingsettings = "";
	if (typeof(interfaceControl.PublishData[build+'_PUBLISHING']) != "undefined") publishingsettings = interfaceControl.PublishData[build+'_PUBLISHING'].value;

	initGlobal();
	v = getDir();
	
	setDirImageValue(v[1]);

	initPluginButtons();
	
	cfg = interfaceControl.getPublishingView().getPresetFile();
	if (cfg != '' && typeof cfg != 'undefined') { 
		qdata['cfg'] = cfg;
	} else {
		qdata['cfg'] = ''; 
	}
	
	fsiparser.loadDefaultFSI(fsiparser_basepath, '_default.xml');
	
	if (qdata["cfg"] != "") {
		loadSelectedConfig(qdata["cfg"]);
	} else delete qdata["cfg"];
	
	preUpdateInterface(build);
	RestoreParameterValues(build);
	setInitialDimensions();
	fsiparser.getPublishOptions();
	
	addEvent(window,"resize",resizePreview);
	addEvent(window,"unload",removeResizePreview);
	
	toActive('1', 'false');
	enableRatio();
	//changeDimensionOnRatio();
	appendEffectNodes(); 
	//restorePublishingSettings(publishingsettings);
	getFirstDimensions();
	
}  
  
  
function loadVideoFile() {
	var browseOptions = {};
	browseOptions.filter = {"_configs":1};
	browseOptions.connectorTypeFilter = {"TRASH":1,"DOWNLOADS":1,"STORAGE":1,"MULTIRESOLUTION":1};
	
	var fileName = interfaceControl.browseForFileName('', false, _loadVideoFile, browseOptions);
}

function _loadVideoFile(fileName) {
	if(fileName.substring(fileName.length-4) == ".mp4") fileName = fileName.substring(0,fileName.length-4) 
	else if(fileName.substring(fileName.length-5) == ".webm") fileName = fileName.substring(0,fileName.length-5)
	else return;
	
	document.getElementById("video_videosource").value = "[static]"+fileName;
	qdata["video_videosource"] = "[static]"+fileName;
	updateCode();
}


function toActive(o,skipupdate) {

	/*if (typeof(forceupdate) == 'undefined') {
		var focEle = document.getElementById("updateFocus"); //Must be done before updateCode!
		if (focEle){
			focEle.focus();
		}
	} */
		
	if (o=='7' || o=='6') {
		document.body.className = "grey";
		updateCrop(true); 
		initCrop();
		bindCropHelper(true);
	}
	else {
		document.body.className = "";
		bindCropHelper(false);
	}

	if ( colorPickerVisible ) hideCP('false');
	if ( helpvisible ) closeHelp();
	
	var iframe = parent.document.getElementById("iFramePublish");
	var p = document.getElementById('preview');
	var px = document.layers ? "" : "px";
	
	if( document.settings.FSIunit.value=="pc" ) px="%";
	
	for (x=0; x<divs.length+1; x++) { // 8
		hide(divs[x]);
		hide('div' + x);
		changeImages(divs[x],'inactive');
	}

	show('div' + o);
	if (o=="5") updateEffectThumbs();
	if (o=='6' || o =='7') { //Preview

	
		if(document.settings.FSIunit.value=="pc") px="%";
		
		var new_w = preview_saved_width = save_width = document.settings.FSIwidth.value;
		var new_h = preview_saved_height = save_height = document.settings.FSIheight.value;
		var maxWidth = iframe.offsetWidth - 50;
		var maxHeight = iframe.offsetHeight - 70;

		//set current settings
		p.style.width=new_w+px;
		p.style.height=new_h+px;
		p.style.display="block";
		
		try {
			document.getElementById("size_notification").innerHTML = '';
		}catch(e){}
		
		//calc preview dimensions if custom dimension exceed viewport
		if (save_height > maxHeight) {
			try {		
				var entry = oPreviewEntry;
			
				var maxWidth = parseInt(interfaceControl.getPublishingView().getDimension().width) - 20;
				var aspectX = maxWidth / entry.width;
				var aspectY = maxHeight / entry.height;

				if (aspectX < aspectY){
					if (entry.width < maxWidth) new_w = entry.width;
					else new_w = maxWidth;
					new_h = Math.round(new_w * entry.height / entry.width);
				}
				else {
					if (entry.height < maxHeight) new_h = entry.height;
					else new_h = maxHeight;
					new_w = Math.round(new_h * entry.width / entry.height);
					if (build=="pages") new_w = Math.round(new_h * entry.width / entry.height);
				}
				if(build=="pages") new_w = parseInt(new_w*1.4);
			} catch (e) {
				new_w = 700;
				new_h = maxHeight - 30;
			}
			
			try {
				if (build != 'html') document.getElementById("size_notification").innerHTML = 'The preview size has been reduced to fit the current viewport.';			
			}catch(e){}
		}

		//exit if no change in dimensions && nochange in aktivediv
		if (!boPSC && oldPWidth == new_w && oldPHeight == new_h && aktiveDiv == o && typeof(forceupdate) == 'undefined') {
			show('div' + o);
			return;
		} 	

		if (p) { 
			if (px == "%") {
				new_h=Math.round(parseInt(interfaceControl.getPublishingView().getDimension().height)/100*new_h-100);
				new_w=Math.round(parseInt(interfaceControl.getPublishingView().getDimension().width)/100*new_w-20);
				p.style.width=new_w+"px";
			    p.style.height=new_h+"px";
			} else {
				p.style.width=new_w+px;
				p.style.height=new_h+px;
			}
			p.style.display="block";
			initPreview();
			writePreviewURL("preview_notification");
		}

			
	} else {
		p.style.width = 750 + px;
	}
	oldPWidth = new_w;
	oldPHeight = new_h;
	
	aktiveDiv = o;
	updateCode(true);

	if (o == '5'){
		if (typeof(resizeEffectsTable) == "function") resizeEffectsTable();
	}

	
	return true;

}


function checkJPEGType() {
	if (document.getElementById('image_format').value.toLowerCase() == 'jpeg' ||  document.getElementById('image_format').value.toLowerCase() == 'overlay') {
		if (document.getElementById('effects_compression').value.toLowerCase() == '0') {
			compressionslider.setMaximum(100);
			compressionslider.setValue(95);
			compressionslider.recalculate();
		}
	}
}


function toggleActivity(id) {
	
	for(x=0;x<aEffects.length;x++) {
					
		var currentEffect = aEffects[x].split("\",\"");

		var isAreaEffect = currentEffect[4].split("\":\"");
		isAreaEffect = isAreaEffect[1].replace(/"/,"");

		if(isAreaEffect == "true" && !showAreaEffects) continue;
		
		var name = currentEffect[0].split("\":\"");
		name = name[1].replace(/"/,"");
		
		var pa = document.getElementById('effect_'+name);
		el = pa.childNodes[0];
		el.className = "effectDialogTitleNonActive";
		
	}
	
	el = id.childNodes[0];
	
	if(el.className == "effectDialogTitleNonActive") {
		el.className="effectDialogTitleActive";
	}
	else
	if(el.className == "effectDialogTitleActive") {
		el.className="effectDialogTitleNonActive";
	}

}


function doResizePreview() {

	
	if (typeof(resizeEffectsTable) == "function") resizeEffectsTable();

	if (interfaceControl.getPublishingView().getDimension().height == -1) return;
	if (aktiveDiv == '5') { if (document.getElementById("effectsContainer").innerHTML == "") { appendEffectNodes(); }} //may vanish?!
	if (aktiveDiv == '6') toActive('6');
	if (aktiveDiv == '7') updateCrop(); 
	
}

function updateCode() {
	
	var opt=document.settings;
	
	var imgurl = getSSImage(opt.FSIwidth.value, opt.FSIheight.value, false, false, false);
	if(imgurl == false) return;
	
	imgtag = wrapinXHTML();
	
	try 
	{
		opt.htmldata.value = imgtag; 
		opt.dirvalue.value = imgurl;
		opt.previewdata.value = '<div id="'+getUniqueID()+'" style="width:'+opt.FSIwidth.value+'px;height:'+opt.FSIheight.value+'px"></div>\n';
		opt.renderingquery.value = getSSImage(opt.FSIwidth.value, opt.FSIheight.value, false, false, false, true);
	
	} catch (e){}
	
	interfaceControl.updatePreviewCode(wrapinXHTML(true));
	v = getDir();
	document.getElementById('dirvalue').value = v[1];
	StorePublishingSettings();
	return imgtag;
	
}

function updateSpinZoomOptions(elid) {
		
	var pname = elid.id;
	pname = pname.toLowerCase();
	qdata[pname] = elid.value; 
	updateCode();

}

function getSpinZoomOptions(asString,forPreview) {

	var opt=document.settings;
	if(typeof(qdata['options_backgroundColor']) != 'undefined' && qdata['options_backgroundColor'] != '') {
		var cval = qdata['options_backgroundcolor'];
		if ("#" != cval.substr(0, 1) )
			qdata['options_backgroundcolor'] = '#' + cval;
	}
	//Prepare
	renderingquery = getSSImage(opt.FSIwidth.value, opt.FSIheight.value, false, false, false, true, false);	
	if (renderingquery && renderingquery.length > 0) {
		delete(qdata['options_overlays']);
		delete(qdata['options_cropValues'])
		delete(qdata['options_imageServerTemplate']);
		delete(qdata['options_effects']);
		var parts = renderingquery.split("&");
		for (var x = 0; x<parts.length; x++) {
			var cparts = parts[x].split("=");
			if (cparts[0] == "effects") {
				qdata['options_effects'] = cparts[1]+",";	
			}
			if (cparts[0] == "overlays") {
				qdata['options_overlays'] = cparts[1];	
				qdata['options_imageServerTemplate'] = "overlay";
			}
		}
	} else { qdata['options_effects'] = ""; }


	if (qdata['options_effects'] && qdata['options_effects'].charAt(qdata['options_effects'].length - 1) == ',') {
 		 qdata['options_effects'] = qdata['options_effects'].substr(0, qdata['options_effects'].length - 1);
	}

	if (croprect && croprect.length > 0) {
		var parts = croprect.split("=");
		qdata["options_cropValues"] = parts[1];
	}
	delete(qdata['FSIunit']);
	
	//Build
	if(typeof(asString) != 'undefined' && asString != false) {
		var retstr = "";
			for (var option in qdata) {
				if (qdata[option] == "") continue;
				if (option.indexOf('effectsvalue') > -1) { delete(qdata[option]); continue; }
				var something = option.split("_");
				if (something[1] == 'FSIunit' || something[1] == 'fsiunit' || something[1] == 'width' || something[1] == 'height') continue;
				if (something[1] == "imagesources") retstr += "src=\""+encodeBrowsePath(qdata[option])+"\" ";
				else if (something[0] != "options" && something[0] != "camera" && something[0] != "hotspots" && something[0] != "hotspots3d" && something[0] != "virtualspace" && something[0] != "video") retstr += ""+option+"=\""+qdata[option]+"\" ";
				else retstr += ""+something[1]+"=\""+qdata[option]+"\" ";
			}
			if (plugins.length > 0 ) retstr += "plugins=\""
			for (var x=0;x<plugins.length;x++) {
				retstr += plugins[x]+",";
			}
			if (plugins.length > 0 ) retstr = retstr.substr(0,retstr.length-1) + "\"\"";
			if(typeof(forPreview) != "undefined" && forPreview) { 
				retstr += "usenc=\"true\" usencquery=\"&headers=webinterface\"";
				if (inArray("resize",plugins)) retstr += "plugins=\"resize\"";
			}
	}

	else {
		var retstr = new Object;
		for (var option in qdata) {
			if (qdata[option] == "") continue;
			if (option.indexOf('effectsvalue') > -1) { delete(qdata[option]); continue; }
			something = option.split("_");
			if (something[1] == 'FSIunit' || something[1] == 'fsiunit' || something[1] == 'width' || something[1] == 'height') continue;
			if (something[1] == "imagesources") retstr[something[1]] = encodeBrowsePath(qdata[option]);
			else if (something[0] != "options" && something[0] != "camera" && something[0] != "hotspots" && something[0] != "hotspots3d" && something[0] != "virtualspace" && something[0] != "video") retstr[option] = qdata[option];
			else retstr[something[1]] = qdata[option];
		}

		if(typeof(forPreview) != "undefined" && forPreview) {
			retstr["usenc"]= true;
			retstr["usencquery"] = "&headers=webinterface";
			if (!inArray("resize",plugins)) retstr["plugins"]= "resize";
		}
		
		var plstr = "";

		if (plugins.length > 0 ) {
			for (var x=0;x<plugins.length;x++) {
				plstr += plugins[x]+",";
			}
			plstr = plstr.substr(0,plstr.length-1); //last komma
		}
		if (plstr != "") retstr["plugins"] = plstr;	

		
	}
	return retstr;
}


function getSpinZoomHeaders(forPreview) {

	var retstr = "";

		if (!forPreview)var jsurl = interfaceControl.getUserProxyPagesMobileUrl(); //req HLK
		else var jsurl = interfaceControl.getUserLocalFSIViewerBase() + "applications/pagesmobile/";

		jsurl = jsurl.replace(/pagesmobile/g, "touchzoom");
		//retstr = '<script type="text/javascript" src="'+jsurl+'js/fsitouchzoom.js"><\/script>\n';
		jsurl = jsurl.replace(/touchzoom/g, "viewer");
		retstr += '<script type="text/javascript" src="'+jsurl+'js/fsiviewer.js"><\/script>\n';
		return retstr;
	
}

function initPreview() {
	
	if (spin && spin.inFullScreenMode) return;
	if (spin && spin.destroy) spin.destroy();
	/*if (FSITouchZoom == undefined) {
		FSITouchZoom = new $FSI.TouchZoom();
		FSITouchZoom.init();
	}*/
	var id = 'preview';
	if (typeof($FSI) != "undefined" && typeof($FSI.Viewer) != "undefined") {

		var opts = getSpinZoomOptions(false,true);
		
		var el = document.getElementById(id).style;
		spin = new $FSI.Viewer(id,opts);
		spin.start();
	} else {
		interfaceControl.showPublishMessage("Error","Error initializing preview. Scripts have not loaded yet.");
	}
}


function saveSelectedConfig(filename) {
	
	if (filename != null && filename != "" && fsiparser.isValid()) {

		if (filename.substring(filename.length-4) != ".xml") filename += ".xml"; //append suffix if missing.
			var jsparamquery = jsParamsToQuery();

			fsiparser.addQuery(jsparamquery);
			fsiparser.getPublishOptions(false);	
			
			if (fsiparser.isValid()){ 
			    var fsixml = fsiparser.getXML(true);
			    fsixml = fsiparser.wrapInXML(fsixml);
				if (fsixml){
					interfaceControl.lockInterface();
					var serviceurl = interfaceControl.getBaseServiceURL() + "postupload/_configs/";

					serviceurl += interfaceControl.getActivePublishingSet()+ "/";
					success = fsiparser.saveFSI(serviceurl, filename, fsixml);
					interfaceControl.unlockInterface();
					if (parseInt(success) == parseInt(200)) {
						//done
					}
					else {
						interfaceControl.showPublishMessage("Error","Settings have not been saved");
					}
				}
			}
	}

	var w = opt.options_width.value;
	var h = opt.options_height.value;
	document.settings.reset();
	opt.options_width.value = w;
	opt.options_height.value = h;
	
	var tmp = new Array();
	if (typeof(qdata['options_dir']) != "undefined") tmp['options_dir'] = qdata['options_dir'];
	if (typeof(qdata['options_imagesources']) != "undefined") tmp['options_imagesources'] = qdata['options_imagesources'];
	
	loadedConfig = document.getElementById("currentLoadedConfig").value = filename;
	var tmp = new Array();
	tmp['options_cfg'] = qdata['options_cfg'];
	tmp['options_dir'] = qdata['options_dir'];
	qdata = new Array();
	qdata = tmp;
	qdata['options_cfg'] = filename;
	plugins = new Array();
	loadSelectedConfig(filename);
	updateCode();
}
	

function getUniqueID() {
	
	if(uniqueID != false) return uniqueID;

    var length=12;
    var uid = "FSI_";

    var noPunction = true;

    for (i=0; i < length; i++) {

        numI = getRandomNum();
        if (noPunction) { while (checkPunc(numI)) { numI = getRandomNum(); } }

        uid = uid + String.fromCharCode(numI);
    }
	uniqueID = uid;
    return uid;
}

function getRandomNum() {

    // between 0 - 1
    var rndNum = Math.random()

    // rndNum from 0 - 1000
    rndNum = parseInt(rndNum * 1000);

    // rndNum from 33 - 127
    rndNum = (rndNum % 94) + 33;

    return rndNum;
}

function checkPunc(num) {

    if ((num >=33) && (num <=47)) { return true; }
    if ((num >=58) && (num <=64)) { return true; }
    if ((num >=91) && (num <=96)) { return true; }
    if ((num >=123) && (num <=126)) { return true; }

    return false;
}


function wrapinXHTML(forPreview) {
		
	var unit=document.settings.FSIunit.value;
	if (unit == "pc") unit = "%";
	if (unit == "px") unit = "px";

	htmlcode = '<!DOCTYPE HTML>\n';
	if(typeof(forPreview) != undefined && forPreview) htmlcode += interfaceControl.getPreviewWindowComment();
	htmlcode+='<html>\n';
	htmlcode+='<head>\n';
	htmlcode+='<meta http-equiv="content-type" content="text/html; charset=UTF-8">\n';
	htmlcode+='<meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1">\n';
	htmlcode+='<title>FSI Viewer JS 360</title>\n';

	if(unit == "%" || (typeof(forPreview) != undefined && forPreview))  {
		htmlcode += interfaceControl.getPreviewWindowStyle();
	}


	htmlcode+=getSpinZoomHeaders(forPreview);
	htmlcode+='</head>\n';
	htmlcode+='<body>\n';

	htmlcode+='<fsi-viewer width=\"'+document.settings.FSIwidth.value+unit+'\" height=\"'+document.settings.FSIheight.value+unit+'\" '+getSpinZoomOptions(true,forPreview)+'>'; 

	if(typeof(forPreview) != undefined && forPreview)  { var serverUrl = interfaceControl.getUserLocalFSIViewerBase(); serverUrl = serverUrl.replace(/viewer\//,"server"); }
	else var serverUrl = interfaceControl.getUserProxyServerUrl();
	var thefallbackimage = getPublishImageEntry();
	htmlcode+='\n<noscript>\n<img src="'+serverUrl+'?type=image&source='+thefallbackimage.fullsrc+'&width='+document.settings.FSIwidth.value+'&height='+document.settings.FSIheight.value+'" width="'+document.settings.FSIwidth.value+'" height="'+document.settings.FSIheight.value+'" alt="'+thefallbackimage.fullsrc+'">\n</noscript>';
	htmlcode+='\n</fsi-viewer>\n';

	htmlcode+='</body>\n';
	htmlcode+='</html>\n';
	
	return htmlcode;
	
}


function openImage() {
	
	w = document.settings.FSIwidth.value;
	h = document.settings.FSIheight.value
	var url = getSSImage(w,h, false, false, true);
	url = interfaceControl.appendQueryParameterToUrl(url, "disposition=true&save=true");
	
	if (browser.name == "IE" || browser.name == "Chrome") window.open(url, "_self");
	else window.open(url);

}

function getPublishImageEntry(){
	
	var entry = interfaceControl.getThumbView().getFirstSelectedThumb();
	var basePath = interfaceControl.getBasePath();
	
	
	if(entry && entry.type != 'file') {
		entry = entryFirstImage = interfaceControl.getThumbView().getFirstImageEntryForDir(decodeURIComponent(entry.fullsrc), interfaceControl.getBasePathType());
	} else {	
		entry = entryFirstImage = interfaceControl.getThumbView().getFirstImageEntryForDir(basePath, interfaceControl.getBasePathType());
	}
		
	if (entry) {
		oPreviewEntry = entry;
	}
	else entry = oPreviewEntry;
	
	return entry;
}

function onPublishingSourceChanged(){
	var oldPrevEntry = oPreviewEntry;
	var newPrevEntry = getPublishImageEntry();
	updateCrop(true); 
	if (typeof(oldPrevEntry) != "undefined" && oldPrevEntry.type != newPrevEntry.type) return;
	if (typeof(newPrevEntry) == 'undefined' ) return;
	if ( getBasePathFromEntry(oldPrevEntry) == getBasePathFromEntry(newPrevEntry) ) return;
	v = getDir();
	//changeDimensionOnRatio();
	setInitialDimensions();
	updateEffectThumbs();
	updateEffectPreview();
	updateCode();
	updateCrop(true);
	boPSC = true;
	if (aktiveDiv == '6') toActive('6');

	boPSC = false;
	
	checkRestrictions();
}


function loadSelectedConfig(fileName) {
	
	if (fileName.substring(fileName.length-4) != ".xml") fileName += ".xml"; //append suffix if missing.
	loadedConfig = fileName;

	var oldplugins = new Array();
	if (typeof(plugins) != 'undefined') {
		oldplugins = plugins;
		for (var p in oldplugins) {
			handlePlugins(oldplugins[p]); //Disable activated plugins in Interface
			fsiparser.removePlugin(p);
		}
	}
	plugins = new Array();
	
	//reset form
	var opt = document.settings;
	var w = opt.FSIwidth.value;
	var h = opt.FSIheight.value;
	if (opt) opt.reset();
	opt.FSIwidth.value = w;
	opt.FSIheight.value = h;
	
	qdata = new Array();

	document.getElementById("currentLoadedConfig").value=fileName;
	
	v = getDir();
	document.getElementById('dirvalue').value = v[1];
	
	qdata['options_cfg'] = fileName;

	// Load settings from file and set form:
	if(fileName != "") {
		fsiparser.loadFSI(fsirooturl+"config/", fileName);
	}

	if (fileName != "" && fsiparser.isValid()) { // !
		//RestoreParameterValues(build);
		preUpdateInterface(build);
	}

	updateCode();
}

