/*!
 * FSI Thumb Bar
 * Build: 18.07.06.1
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};k.getElementMargins=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.marginLeft);i.top=parseFloat(q.marginTop);i.right=parseFloat(q.marginRight);i.bottom=parseFloat(q.marginBottom)}catch(r){}return i};k.getElementBorders=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.borderLeftWidth);i.top=parseFloat(q.borderTopWidth);i.right=parseFloat(q.borderRightWidth);i.bottom=parseFloat(q.borderBottomWidth)}catch(r){}return i};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r===undefined)?"":strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2018",strBuild:"18.07.06.1"});this.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};this.cloneArray=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.urlDecode=function(str){if(!str){return str}var ret=str.replace(regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return window.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var f={};var e=false;var d=this.initCustomTags=function(){if(a.BrowserSupports.registerElement()){return false}for(var g in f){c(g)}return true};var c=this.initCustomTag=function(k){if(a.BrowserSupports.registerElement()){return false}var j=f[k];if(!j){return false}var g=document.getElementsByTagName(k);if(g.length>0){j.replaceTagInit()}if(g&&g.length>0){for(var h=0;h<g.length;h++){j.replaceTag(g[h])}}return true};this.register=function(h,g){if(f[h]===b){f[h]=new a.CustomTag(h,g);if(!e){e=true;if(!a.BrowserSupports.registerElement()){a.addEvent(window,"DOMContentLoaded",d)}}}return f[h]}};a.CustomTag=function(e,c){var k=this;var f;var j=function(){if(a.BrowserSupports.registerElement()){i()}};var d=function(m,n){var l=m.getAttribute(n);if(typeof(l)==="string"&&l.length>0){if(!l.match(/[^0-9\s]/)){l+="px"}m.style[n]=l}};var h=function(l){d(l,"width");d(l,"height")};var g=function(o){var l=a.utils.attributes2parameters(o);if(c.parameterAliases){var p=c.parameterAliases;for(var n in p){var m=p[n];if(l[n]!==b&&l[m]===b){l[m]=l[n]}}}if(l.src!==b&&l.imagesrc===b){l.imagesrc=l.src}return l};var i=function(){a.utils.addViewerClassCSSRule(e,c.viewerCSS);var l=Object.create(HTMLDivElement.prototype);l.createdCallback=function(){h(this);c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};l.attachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}this.init(this,g(this));if(this.start){this.start()}};l.detachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};document.registerElement(e,{prototype:l})};this.replaceTag=function(l){if(!l||(typeof(l.getInitDone)==="function"&&l.getInitDone())){return}h(l);c.constructorClass.prototype.constructor.call(l,l,g(l));if(l.start){l.start()}};this.replaceTagInit=function(){if(f){return}f=true;a.utils.addViewerClassCSSRule(e,c.viewerCSS)};j()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(ai,w,e){if(typeof(e)!=="object"){e={}}if(!w||typeof(w)!=="object"){w={}}var m=this;this.parameters=(ai&&typeof(ai)==="object")?ai:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Y=false;var N={};var A=0;var q;var ac={};var H=m.debug=new a.EmptyDebugger();var D=false;var x={};var an=false;var S={stickynotes:"bookmarks"};var f;var X=false;var s;var K;var ae;var c;var l;var u="token";var v;var o;if(a.isInternetExplorer&&a.versionInternetExplorer<10){o=function(ap){var ao;if(!a.utils.isCrossDomain(ap)){an=false;ao=new XMLHttpRequest()}else{an=true;ao=new XDomainRequest()}return ao}}else{if(typeof(XMLHttpRequest)!=="undefined"){o=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(aq){m.reset();s=(typeof(e.strSection)==="string")?e.strSection:"";K=s.toLowerCase();if(typeof(e.strTraceParam)==="string"){var ao=e.strTraceParam.toLowerCase();c={};c[ao]=true;if(ao.indexOf("_")>0&&ao.indexOf("pages")===0){ao=ao.split("_");ao.shift();ao=ao.join("_");c[ao]=true}var ap=m.getParameterAlias(ao);if(ap){c[ap]=true}}else{c=false}if(aq){if(m.parameters){m.parameters=a.utils.mergeObjects(m.parameters,aq)}else{m.parameters=aq}}ah(m.parameters);m.getQueryParameters();m.cloneParameters(m.cfgDefaults,m.cfg);m.cloneParameters(m.queryParameters,m.cfg);m.elevateToHTTPS();d();m.locationFSIViewer="";if(m.queryParameters.fsiviewerlocation!==b){m.locationFSIViewer=m.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());m.locationFSIViewer=a.getViewerLocation()}if(m.locationFSIViewer.charAt(m.locationFSIViewer.length-1)!=="/"){m.locationFSIViewer+="/"}m.nextConfigURL=m.getReloadPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.defaultcfg));m.checkDebug(false)};var ah=this.makeObjectPropertiesLowerCase=function(ao){for(var ap in ao){var aq=ap.toLowerCase();if(ap!==aq){if(ao[aq]===b){ao[aq]=ao[ap]}delete ao[ap]}}};this.getClassParameters=function(){return ae};this.setAccessToken=function(ao){v=ao};this.getParameterAlias=function(aq){var ao;if(m.cfgAliasNames[aq]){ao=m.cfgAliasNames[aq]}else{for(var ap in m.cfgAliasNames){if(m.cfgAliasNames[ap]===aq){ao=ap;break}}}return ao};var d=function(){Y=m.makeBool(m.cfg.usenc,false);if(m.cfg.usencquery!==b&&m.cfg.usencquery.length>0){D=m.cfg.usencquery;Y=true;m.queryToObject("?"+D,x)}};this.stopPendingRequests=function(){for(var ap in N){var ao=N[ap];if(ao){ao.FSIaborted=true;if(ao.abort){ao.abort()}}}};this.destroy=function(){m.stopPendingRequests()};this.reset=function(){ae={};m.parameters={};H=m.debug=new a.EmptyDebugger();m.stopPendingRequests();q=Math.random();m.nIncludedConfigs=0;m.completedConfigs={};m.plugins={};m.cfg={};m.queryParameters=b;m.arUnrecognizedConfigNodes=[];aj=0;m.arConditions=[];ac={}};this.getQueryParameters=function(){if(m.queryParameters!==b){return}m.queryParameters={};m.cloneParameters(m.parameters,m.queryParameters)};this.makeBool=function(ar,ao){if(typeof(ao)!=="boolean"){ao=false}var ap=ao;switch(typeof(ar)){case"string":var aq=a.makeBool(ar);if(aq!==b){ap=aq}break;case"number":ap=Boolean(ar);break;case"boolean":ap=ar;break}return ap};this.parsePositionParameter=function(ap){if(typeof(ap)!=="string"||ap.length<3){return b}ap=ap.split(",");if(ap.length<3){return b}for(var ao=0;ao<3;ao++){ap[ao]=parseFloat(ap[ao]);if(isNaN(ap[ao])){ap[ao]=0}}return{x:ap[0],y:ap[1],z:ap[2]}};this.logLoadFileFailed=function(ao){if(!H.on){return}if(ao&&ao.status!==b){var aq="HTTP "+ao.status;if(ao&&ao.statusText){aq+=", "+ao.statusText}var ap=(ao._url)?ao._url:"";H.error("Failed to load "+ap+" ("+aq+")")}else{H.error("Failed loading a file");if(ao&&ao._url){H.error(ao._url)}}};this.getAttributeValue=function(ap,ao){if(!ap){return}return ap.getAttribute(ao)};this.getImageURL=function(aq,ao){var ap;if(aq===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="image"}if(ao.renderer===b){ao.renderer="jpeg"}if(v){ao[u]=v}ao.source=aq;for(ap in ac){if(ac[ap]!==b&&ao[ap]===b){ao[ap]=ac[ap]}}for(ap in aa){if(ao[ap]){if(aa[ap]!==ap){if(!ao[aa[ap]]){ao[aa[ap]]=ao[ap]}ao[ap]=null}}}return m.requestBase+"?"+m.objectToQuery(ao)};this.getImageInfoURL=function(ap,ao){if(ap===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="info"}if(ao.tpl===b){if(m.cfg.fpxinfotemplate!==b){ao.tpl=m.cfg.fpxinfotemplate}else{ao.tpl="info.json"}}if(m.cfg.headers&&m.cfg.headers.length>0){ao.headers=m.cfg.headers}if(!ao.tpl.match(/.json$/)){ao.tpl+=".json"}ao.source=ap;if(v){ao[u]=v}return m.requestBase+"?"+m.objectToQuery(ao)};this.queryToObject=function(at,aq){if(aq===b){aq={}}var ar,av,au,ao,ap;ar=at.indexOf("?");if(ar!==-1){ap=at.slice(ar+1)}else{ap=""}ar=ap.indexOf("#");if(ar!==-1){ap=ap.substring(0,ar)}ap=ap.split("&");for(ar=0;ar<ap.length;ar++){av=ap[ar].split("=");au=a.utils.urlDecode(av[0]).toLowerCase();if(au.length>0){ao=a.utils.urlDecode(av[1]);aq[au]=ao}}return aq};this.parseSceneSets=function(ao,at){var aA={};if(at===b){at=true}var aF=[];var aD=0;var aB=0;var aq;var av,au,ar,az,ax,aE;var aw,ay,aC;var ap=m.cfg.scenesets;if(ao>1&&ap!==b&&typeof(ap)==="string"){ay=ap.split(";");for(av=0;av<ay.length;av++){aC=[];aw=ay[av].split(",");aB=0;for(au=0;au<aw.length;au++){aE=aw[au].split("-");az=ax=0;if(aE.length===1){az=parseInt(aE[0])}else{az=parseInt(aE[0]);if(isNaN(az)){az=1}aq=false;if(aE[1].charAt(0)===">"){aE[1]=aE[1].substr(1);if(!isNaN(parseInt(aE[1]))){aq=true}}ax=parseInt(aE[1]);if(isNaN(ax)){ax=ao}if(az>0&&ax>0&&az<=ao&&ax<=ao){if(aq===true||az!==ax){if(aq!==true){if(ax<az){for(ar=az;ar>=ax;ar--){aC[aB]=ar;aB++}}else{for(ar=az;ar<=ax;ar++){aC[aB]=ar;aB++}}}else{for(ar=az;ar<=ao;ar++){aC[aB]=ar;aB++}for(ar=1;ar<=ax;ar++){aC[aB]=ar;aB++}}}}}if(az>0&&az<=ao&&(ax===0||ax===az)){aC[aB]=az;aB++}}if(aB>0){aF[aD]={};aF[aD].arScenes=[];aF[aD].arScenes=aF[aD].arScenes.concat(aC);aD++}}}if(aD===0){aA.bDefault=true;if(at){aF[0]={};aF[0].arScenes=[];for(av=0;av<ao;av++){aF[0][av]=av}}}aA.nSceneSets=aD;aA.bHasMultipleSets=(aA.nSceneSets>1);aA.arSets=aF;aA.nCurrent=1;return aA};this.objectToQuery=function(ap){var ao=[];var at,aq;if(Y&&D!==false){for(at in x){ap[at]=x[at]}}for(at in ap){aq=ap[at];if(aq!==null){aq=encodeURIComponent(aq);ao.push(encodeURIComponent(at)+"="+aq)}}return ao.join("&")};this.loadImageInfo=function(ar,ao,aq){var ap=m.getImageInfoURL(ar);m.loadFile(ap,ao,b,aq)};this.loadFile=function(at,ar,aq,ax,aw,ap,au){if(!at||at.length<0){if(ar){setTimeout(function(){ar(null,"",ax)},0)}return}if(aw===b){aw="GET"}if(ap===b){ap=null}else{if(typeof(ap)==="object"){ap=m.objectToQuery(ap)}}if(aq===b){aq="application/json"}var av=o(at);if(aq&&av.overrideMimeType){av.overrideMimeType(aq)}av._url=at;var ao=A;N[A]=av;A++;if(an){av.onerror=function(){delete N[ao];if(ar===b||this.FSIaborted){return}m.logLoadFileFailed(this)};av.onload=function(){delete N[ao];if(ar===b||this.FSIaborted){return}var ay=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var az=new ActiveXObject("Microsoft.XMLDOM");az.async=false;az.loadXML(ay);ay=this.responseXML=az}catch(aA){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(at)}break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(aA){H.error("Failed parsing JSON from URL: "+at+" ("+aA.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}else{av.onreadystatechange=function(){var ay;if(av.readyState!==4){return}delete N[ao];if(this.FSIaborted||typeof(ar)!=="function"){return}if(this.status>299){m.logLoadFileFailed(this)}switch(aq){case"application/xml":case"text/xml":ay=this.responseXML;break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(az){H.error("Failed parsing JSON from URL: "+at+" ("+az.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}av.open(aw,at,true);if(au&&v){av.setRequestHeader("x-token",v)}if(ap){av.setRequestHeader("Content-type","application/x-www-form-urlencoded");av.send(ap)}else{av.send()}return av};this.loadConfigs=function(){ae=(s.length>0)?{}:false;f=true;m.loadNextConfig(true)};this.loadNextConfig=function(ap){if(m.nextConfigURL===b){W();return}var aq={};if(e.bPreventCaching||m.makeBool(m.cfg.debug)||(!ap&&!m.makeBool(m.cfg.configcaching,true)&&m.makeBool(m.cfg.enableconfigcachingparameter))){m.addNoCacheParams(aq)}m.finishRequestParams(aq);var ao=m.addURLParameters(m.nextConfigURL,aq);H.log("Loading config file: "+ao);m.loadFile(ao,E,"application/xml")};this.setDebugger=function(ao){H=m.debug=ao};this.checkDebug=function(aq){if(e.bNoDebug){return}var ap;var ao;if(m.parameters.debug!==b){ao=m.makeBool(m.parameters.debug)}else{ao=m.makeBool(m.cfg.debug)}if(ao){if(!H||!H.on){H=m.debug=new a.Debugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}else{if(!H||H.on===true){H=m.debug=new a.EmptyDebugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}return ap};var E=function(ao){var aq=ao.responseXML;l=m.nextConfigURL;m.parseConfig(aq);l=b;m.elevateToHTTPS();if(m.checkDebug(true)===true){return}d();if(f&&e.bCaptureDefaultCfg){f=false;m.cfgFromDefaultConfig=a.utils.cloneValue(m.cfg)}var ap;if(m.cfg.includeconfig!==b&&m.nIncludedConfigs<10){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.includeconfig));m.nIncludedConfigs++;m.cfg["_includeconfig("+m.nIncludedConfigs+")"]=m.cfg.includeconfig;m.cfg.includeconfig=b}else{if(m.cfg.cfg!==b){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.cfg))}}if(ap!==b&&!m.completedConfigs[ap]){m.completedConfigs[ap]=true;m.nextConfigURL=ap;m.loadNextConfig()}else{m.evaluateQuery(m.queryParameters,m.cfg);W()}};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!m.makeBool(m.cfg.autoelevatetohttps,true)){return}h("fpxbase");h("fpxserver")};var h=function(ao){if(m.cfg[ao]!==b&&m.cfg[ao].length>0&&m.cfg[ao].indexOf("http://")===0){m.cfg[ao]="https"+m.cfg[ao].substr(4)}};this.evaluateQuery=function(ap,ao){for(var aq in ap){m.setConfigParamByValue(ao,aq.toLowerCase(),ap[aq])}};this.parseConfig=function(ap,aq){var aA="";var au;var aw=false;if(ap!==b){if(aq===b){aq=ap.firstChild}if(aq&&aq.nodeName==="xml"){aq=aq.nextSibling}var az=aq.childNodes;for(var av=0;av<az.length;av++){var at=az[av];if(at.nodeType!==1){continue}var ax;if(at._myTagName!==b){ax=at._myTagName}else{ax=at.nodeName.toLowerCase()}aA=ax;var ar=at.childNodes;aw=false;switch(ax){case"licence":break;case"if":m.arConditions.push(at);break;case"plugins":for(au=0;au<ar.length;au++){m.parsePluginNode(ar[au])}break;case K:aw=true;case"info":case"options":aA=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(au=0;au<ar.length;au++){var ay=ar[au];if(ay.nodeType!==1){continue}if(ay.tagName==="if"){ay._myTagName=ax;m.arConditions.push(ay)}else{var ao=m.getValueFromXMLNode(ay,aA);if(aA===b&&ae){if(aw){m.setConfigParam(ae,ao,null,true);m.setConfigParam(m.cfg,ao,ay)}else{if(ae[ao.name]===b){m.setConfigParam(m.cfg,ao,ay)}}}else{m.setConfigParam(m.cfg,ao,ay)}}}break;default:m.arUnrecognizedConfigNodes.push(at)}}}};this.getData=function(){var ao={};ao.cfg={};for(var ap in m.cfg){ao.cfg[ap]=m.cfg[ap]}return ao};this.setData=function(ao){if(!ao||!ao.cfg){return}m.cfg={};this.setCfgValues(ao.cfg)};this.setCfgValues=function(ao){for(var ap in ao){m.cfg[ap]=ao[ap]}V()};this.getImagesNodeList=function(aq){var ao=[];if(aq===b){aq=m.getUnrecognizedConfigNode("images")}if(aq){var ar=aq.firstChild;while(ar){if(ar.nodeType===1){var ap={};ap.attributes={};M(ar,ap.attributes);ap.cfg={};m.parseConfigFragment(ar,ap.cfg);ao.push(ap)}ar=ar.nextSibling}}return ao};this.removeUnrecognizedConfigNodes=function(){m.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ar){var ao;ar=ar.toLowerCase();for(var ap=m.arUnrecognizedConfigNodes.length-1;ap>-1;ap--){var aq=m.arUnrecognizedConfigNodes[ap];if(aq&&aq.nodeName.toLowerCase()===ar){ao=aq;break}}return ao};this.parseConfigFragment=function(ap,aw,av){var aA="";if(ap!==b&&aw!==b){if(av===b){av=[]}var az=ap.childNodes;for(var au=0;au<az.length;au++){var ar=az[au];if(ar.nodeType!==1){continue}var ax=ar.nodeName.toLowerCase();aA=ax;var aq=ar.childNodes;switch(ax){case"info":case"options":aA=b;case"fpx":case"image":case"include":for(var at=0;at<aq.length;at++){var ay=aq[at];if(ay.nodeType!==1){continue}var ao=m.getValueFromXMLNode(ay,aA);m.setConfigParam(aw,ao,ay)}break;default:av.push(ar)}}}};this.findXMLNode=function(ap,ao){if(ap===b||ap.nodeType===b){return b}while(ap){if(ap.nodeName.toLowerCase()===ao){break}if(ap.firstChild){ap=ap.firstChild}else{if(ap.nextSibling){ap=ap.nextSibling}else{ap=ap.parentNode.nextSibling}}}return ap};this.getValueFromXMLNode=function(aq,ao){if(!aq||aq.nodeType!==1){return}var ap={};var ar=(ao)?ao:"";ap.name=ar+aq.nodeName.toLowerCase();var at=aq.getAttribute("value");if(at){ap.value=at;return ap}ap.value=m.XMLChildNodesToString(aq);ap.node=aq;return ap};this.getXMLNodeAttribute=function(ar,aq,ao){if(!ar||ar.nodeType!==1||!ar.getAttribute){return ao}var ap=ar.getAttribute(aq);if(ap===b||ap==null){ap=ao}return ap};this.XMLChildNodesToString=function(aq,ap){var ao="";if(!aq||!aq.firstChild){return ao}if(aq.childNodes.length===1&&aq.firstChild.nodeType===3){ao=aq.firstChild.nodeValue}else{ao=aq.innerHTML}if(ap!==b){ao=ao.replace(/[\x00-\x1f]/g,ap)}return ao};this.hasPlugin=function(ao){return(m.plugins&&m.plugins[ao]!==b)};this.getPluginParameter=function(av,ap,ao,au,aw){av=av.toLowerCase();ap=ap.toLowerCase();if(m.plugins[av]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+av+"."+ap);return ao}var at;var ar=av+"_"+ap;if(aw&&m.cfg[ar]===b){ar=ap}if(m.cfg[ar]!==b){at=m.cfg[ar]}else{if(ae&&ae[ap]!==b&&K==="pages"){at=ae[ap]}else{var aq=m.plugins[av].parameters;if(aq!==b&&aq[ap]!==b){at=aq[ap]}}}if(at===b){at=ao}if(au){at=m.makeBool(at,ao)}return at};var Q=this.getAllPluginParameters=function(ap){ap=ap.toLowerCase();var aq=a.utils.cloneObject(m.plugins[ap].parameters);var at=ap+"_";var ao=at.length;for(var au in m.cfg){if(au.toLowerCase().indexOf(at)===0){var ar=au.substr(ao);aq[ar]=m.cfg[au]}}return aq};this.getIntParameterMinMax=function(ap,aq,ao,ar){return Math.min(ar,Math.max(ao,m.getIntParameter(ap,aq)))};this.getIntParameter=function(ap,aq){var ao=parseInt(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};this.getStringParameter=function(ap,aq){var ao=m.cfg[ap.toLowerCase()];if(ao===b){ao=aq}return ao};this.getFloatParameter=function(ap,aq){var ao=parseFloat(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};var M=function(au,ap){if(!au||!au.attributes||!au.attributes.length||!ap){return false}var aq=au.attributes;for(var at=0;at<aq.length;at++){var ao=aq[at];var ar=ao.nodeName.toLowerCase();ap[ar]=ao.value}return true};this.parsePluginNode=function(aq){if(aq.nodeType!==1){return}var at={};M(aq,at);var ar=aq.childNodes;for(var ao=0;ao<ar.length;ao++){var au=ar[ao];if(au.nodeType!==1){continue}var ap=m.getValueFromXMLNode(au);if(ap.value!==b){at[ap.name]=ap.value;if(ap.node!==b){at[ap.name+".node"]=ap.node}}}this.addPluginFromString(at.src,at)};this.clone=function(){var ao=new a.Config(ai,w,e);ao.init();ao.cfg=a.utils.cloneObject(m.cfg);ao.plugins=a.utils.cloneObject(m.plugins);ao.arPlugins=a.utils.cloneArray(ao.arPlugins);ao.arUnrecognizedConfigNodes=a.utils.cloneArray(ao.arUnrecognizedConfigNodes);ao.setImageQueryParameters(ac);ao.arConditions=a.utils.cloneArray(m.arConditions);ao.hasImageParameterConditions=m.hasImageParameterConditions;return ao};this.setImageQueryParameters=function(ao){ac=a.utils.cloneObject(ao)};this.addPluginsFromString=function(aq){if(typeof(aq)!=="string"||aq.length<1){return}var ao=aq.split(",");for(var ap=0;ap<ao.length;ap++){var ar=a.trim(ao[ap]);m.addPluginFromString(ar)}};this.addPluginFromString=function(ar,at){if(typeof(ar)!=="string"||ar.length<1){H.error("PLUGIN without src parameter:");return}ar=ar.toLowerCase();if(S[ar]!==b){ar=S[ar]}if(at===b){at={}}var ap=m.plugins[ar]={};ap.name=ar;if(at.src===b){at.src=ar}ap.parameters=at;if(c){for(var au in c){if(au.indexOf(ar+"_")===0){var aq=ar+"_";var ao=au.substr(aq.length);if(typeof(ap.parameters[ao])!=="undefined"){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log(ap.parameters[ao]);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}else{if(au===ar){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log("(enabled)");m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ap,aq,ao){m.setConfigParam(ap,{name:aq.toLowerCase(),value:ao})};var U=function(ap){if(ap.nodeType!==1){return"<unknown>"}var ao=m.XMLSerializer.serializeToString(ap.cloneNode(false));ao=ao.replace(/\/>$/gi,">");return ao};this.setConfigParam=function(ar,ao,at,au){var aw=ao.name;var ay=ao.value;if(!aw){return}if(c){for(var ax in c){if(ax===aw&&!au){if(typeof(at)==="object"&&typeof(at.tagName)==="string"){var av;if(l){av=l}var aq=at.parentNode;var ap=[];while(aq){if(aq.tagName==="if"){av="Matched Condition"}ap.unshift(U(aq));aq=aq.parentNode}ap.shift();ap.shift();m.iTraceParameterDebug.group(av);m.iTraceParameterDebug.log(ap.join(" "));m.iTraceParameterDebug.log(at);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}else{m.iTraceParameterDebug.group("By Parameter/Attribute:");m.iTraceParameterDebug.log(ay);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}if(m.cfgAliasNames[aw]!==b){aw=m.cfgAliasNames[aw]}if(ar[aw]!==b&&(typeof(ay)==="string"&&a.utils.getBoolTable(ay.toLowerCase())===false)&&a.utils.getBoolTable(ar[aw])===b){delete ar[aw]}else{switch(aw){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ar[aw]!==b&&ar[aw].length>0&&ar[aw].indexOf(ay)===-1){ar[aw]+=","+ay}else{ar[aw]=ay}break;case"plugins":m.addPluginsFromString(ay);break;case"fpxpath":ar[aw]=ay;ar.fpxsrc=encodeURIComponent(ay);break;default:ar[aw]=ay;if(ao.node!==b){ar[aw+".node"]=ao.node}}}};var k={};k["="]=function(ap,ao){return(ap.toLowerCase()===ao.toLowerCase())};k["=="]=function(ap,ao){return(ap===ao)};k["!="]=function(ap,ao){return(ap.toLowerCase()!==ao.toLowerCase())};k["!=="]=function(ap,ao){return(ap!==ao)};k["<"]=function(ap,ao){return(ap<ao)};k["<="]=function(ap,ao){return(ap<=ao)};k[">"]=function(ap,ao){return(ap>ao)};k[">="]=function(ap,ao){return(ap>=ao)};k.match=function(ap,ao){var aq=false;var at="g";if(ao.charAt(0)==="/"&&ao.lastIndexOf("/")>0){var ar=ao.split("/");ar.shift();at=ar.pop();ao=ar.join("/")}try{var au=new RegExp(ao,at);aq=(ap.match(au)!==null)}catch(av){H.error("Invalid regex in condition: "+ao)}return aq};k.notmatch=function(ap,ao){return !k.match(ap,ao)};var r={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var t=function(ap,aq){if(m.cfgAliasNames[aq]){aq=m.cfgAliasNames[aq]}var ao=m.cfg[aq];if(ao===b){ao=""}if(!m.hasImageParameterConditions){m.hasImageParameterConditions=(aa[aq]!==b)}return G(ap,aq,ao)};var L=function(ar,at){var ao=false;var aq;var ap=ar.getAttribute("value");switch(at){case"@mobile":ap=m.makeBool(ap,true);aq=a.isMobileDevice;break;case"@devicepixelratio":aq=a.getDevicePixelRatio();break;case"@navigatoruseragent":aq=navigator.userAgent;break;case"@navigatorlanguage":aq=navigator.language;break;case"@navigatorplatform":aq=navigator.platform;break}if(aq!==b){if(typeof(ap)!=="string"){ap=""+ap}if(typeof(aq)!=="string"){aq=""+aq}ao=G(ar,at,aq,ap)}return ao};var G=function(ar,aq,au,at){var aw;var ap=ar.getAttribute("operator");if(typeof(ap)!=="string"){ap="="}ap=ap.toLowerCase();if(r[ap]){ap=r[ap]}if(k[ap]===b){ap="="}if(at===b){at=ar.getAttribute("value")}if(at===null){at=""}var ao=k[ap];if(ap.match(/[<,>]+/)){var ax=function(ay){ay=parseFloat(ay);if(isNaN(ay)){aw=false}return ay};au=ax(au);at=ax(at)}else{au=decodeURIComponent(au)}if(aw===b){aw=ao(au,at)}if(H.on){H.log("Evaluating condition: "+aq+": "+au+" "+ap+" "+at+" => "+aw)}if(aw===true){if(ar._myTagName!==b){var av={};av.nodeType=1;av.tagName=ar._myTagName;av.childNodes=[ar];ar=av}m.parseConfig(ar,ar)}return aw};var aa={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ab={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var Z;var T=function(){if(Z===b){Z={};for(var ao in aa){Z[aa[ao]]=ao}}return Z};var p=function(at,ar,aq){if(aq===b){aq=""}var av=aq+"left";if(at[av]===b){return}var au=aq+"top";var ap=aq+"right";var ao=aq+"bottom";if(ar==="pixelrange"){at[ap]=at[ap]-at[av];at[ao]=at[ao]-at[au]}at[ar]=at[av]+","+at[au]+","+at[ap]+","+at[ao];if(at[av]){delete at[av]}if(at[au]){delete at[au]}if(at[ap]){delete at[ap]}if(at[ao]){delete at[ao]}};var al=this.mapImageParametersToViewer=function(ao){p(ao,"rect");p(ao,"pixelrange","pixel");T();ag(ao,T())};var ak=this.mapImageParametersToServer=function(ao){ag(ao,aa)};var ag=function(ap,ao){for(var aq in ap){if(ao[aq]&&aq!==ao[aq]){ap[ao[aq]]=ap[aq];delete ap[aq]}}};this.reWriteImageURLByConditions=function(av){if(m.arConditions.length<1){return av}if(typeof(av)!=="string"||av.length<1){return av}var aq=av.indexOf("?");if(aq===-1){return av}var ap=m.clone();var at={};m.parseQuery(av,at);al(at);m.evaluateQuery(at,ap.cfg);var ao=ap.evaluateConditions();if(!ao){return av}var au;for(au in at){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}for(au in ab){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}ak(at);var ar=av.substr(0,aq);return ar+"?"+m.objectToQuery(at)};var n=this.applyConditions=function(){if(m.arConditions.length<1){return}if(m.cfgBeforeConditions===b){m.cfgBeforeConditions=a.utils.cloneObject(m.cfg)}m.cfg=m.cfgBeforeConditions;return g()};var aj=0;var g=this.evaluateConditions=function(){if(m.arConditions.length<1){return false}var ap=false;for(var aq=aj;aq<m.arConditions.length;aq++){var ar=m.arConditions[aq];if(ar.fsiConfigEvaluated){continue}aj++;var at=ar.getAttribute("parameter");if(typeof(at)==="string"){at=at.toLowerCase();var ao;if(at.charAt(0)==="@"){ao=L(ar,at)}else{ao=t(ar,at)}if(!ap&&ao){ap=ao}}}return ap};var V=function(){n();m.serverProfile=m.cfg.fpxservertemplate;m.serverProfileDoublePage=m.cfg.fpxservertemplatedoublepage;if(m.serverProfileDoublePage===b){m.serverProfileDoublePage="doublepage"}m.serverBase=m.cfg.fpxserver;if(m.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+m.locationFSIViewer+")");var ap;ap=m.locationFSIViewer.indexOf("/users/");if(ap!==-1){m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}else{ap=m.locationFSIViewer.indexOf("/viewer/");m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}H.log("Derived server location is: ["+m.serverBase+"]")}m.requestBase=m.serverBase;ac={};var ao=m.cfg;for(var aq in ab){if(ao[aq]!==b){ac[aq]=ao[aq]}}if(ac.fpxsrc!==b){ac.fpxsrc=decodeURIComponent(ac.fpxsrc)}ao=m.cfg.effects;if(ao!==b){m.cfg.effectsUnFiltered=ao;m.cfg.effects=ao=j(ao)}if(ao!==b){ac.effects=ao}ao=m.cfg.lefteffects;if(ao!==b){ac.lefteffects=ao}ao=m.cfg.righteffects;if(ao!==b){ac.righteffects=ao}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){m.setEffectsFilter(m.getAreaEffects())};this.setEffectsFilter=function(at){if(typeof(at)!=="string"||at.length<1){X=false;return}at=a.trim(at);var ap=at.split(",");for(var aq=0;aq<ap.length;aq++){ap[aq]=a.escapeRegEx(ap[aq])}var ao="(^|[=,]+)("+ap.join("|")+")\\([^)]*\\)";X=new RegExp(ao,"ig")};var j=function(ao){if(X===false){return ao}return ao.replace(X,"")};var i=function(){for(var ap in m.plugins){var aq=ap.toLowerCase();var ao=m.makeBool(m.cfg[aq],true);if(!ao){m.plugins[ap]=b}}};var W=function(){m.elevateToHTTPS();i();V();m.dumpConfig();if(w.onConfigsReady){w.onConfigsReady()}};this.dumpConfig=function(aq){if(!aq){aq=H}if(aq.on){if(m.cfg.fpxsrc!==b){m.cfg["fpxsrc (decoded)"]=decodeURIComponent(m.cfg.fpxsrc)}aq.info("Evaluated Configuration:",P(m.cfg));if(m.queryParameters){aq.info("Parameters:",P(m.queryParameters))}if(ae){aq.info("Class <"+s+"> Configuration:",P(ae))}var ap=m.getPluginsAndParameters();var ao=ap.data;if(ap.count===0){ao="No active plugins."}aq.info("Plugin Configuration:",P(ao))}};var P=function(aq){var ao="--- none ---";if(typeof(aq)!=="object"){return ao}for(var ap in aq){ao=aq;break}return ao};this.getPluginsAndParameters=function(){var ao={};var aq=0;for(var ap in m.plugins){if(m.hasPlugin(ap)){ao[ap]=Q(ap);aq++}}return{count:aq,data:ao}};var J=this.addQueryParameterToURL=function(ar,ao,aq){var ap=ar.lastIndexOf("?");if(ap===-1){ar+="?"}else{if(ap!==ar.length-1){ar+="&"}}return ar+encodeURIComponent(ao)+"="+encodeURIComponent(aq)};var am=m.finishURL=function(ao){if(v){ao=J(ao,u,v)}if(!Y||ao===b){return ao}var ap;if(D===false){ap="cache=0&cachernd="+q;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+="&"+ap}}else{ap=D;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+=ap}}return ao};this.addURLParameters=function(ap,aq){if(!ap||!aq){return ap}var ao=[];for(var at in aq){ao.push(encodeURIComponent(at)+"="+encodeURIComponent(aq[at]))}if(ao.length>0){if(ap.indexOf("?")===-1){ap+="?"}else{ap+="&"}ap+=ao.join("&")}return ap};this.finishRequestParams=function(ap){if(Y){if(D===false){ap.cache=0;ap.cachernd=q}else{for(var ao in x){ap[ao]=x[ao]}}}};this.addNoCacheParams=function(ao){ao.cache=0;ao.cachernd=q};this.parseQuery=function(ap,ao){if(typeof(ao)!=="object"||typeof(ap)!=="string"||ap.length<1){return}m.queryToObject(ap,ao);if(ao.ignorequeryparameters!==b){delete ao.ignorequeryparameters}if(ao.enableconfigcachingparameter!==b){delete ao.enableconfigcachingparameter}};this.cloneParameters=function(ao,ap){if(ao===b||ap===b){H.error("Cloning object failed: "+ao+" / "+ap)}for(var aq in ao){ap[aq]=ao[aq]}};this.getFSIPath=function(ao,ap){if(ap.indexOf("//")!==-1){return ap}if(m.cfg.fsibase!==b){ap=m.cfg.fsibase+ap}return m.getReloadPath(ao,ap)};this.expandFSIPath=function(ap){if(ap===b){return ap}var ao=a.utils.urlDecode(ap);if(ao.indexOf("?")!==-1||ao.indexOf(".xml")===(ao.length-4)){return ap}return ap+".xml"};this.getReloadPath=function(ar,au){var ap,av,ao,at;if(ar===b){ar=m.locationFSIViewer}if(typeof(au)!=="string"){au=""}var aq="/";if(au.indexOf("//")!==-1){return au}ap=ar;at=ap.lastIndexOf("?");if(at===-1){at=ap.length}av=ap.lastIndexOf("\\",at);ao=ap.lastIndexOf("/",at);av=Math.max(av,ao);if(av===-1){av=ap.length-1}ap=ap.slice(0,av);if(ap.length>0&&au.indexOf(aq)!==0){ap+=aq}return ap+au};var C=function(ao){var ap;if(!ao){return}if(ao.childNodes.length>0){ap=ao.innerHTML}else{ap=ao.getAttribute("value")}return ap};var I=function(aq,ar){var ap,ao;while(aq){if(aq.nodeName===ar){ao=aq;break}ap=aq.firstChild;if(!ap){ap=aq.nextSibling}if(!ap&&aq.parentNode){ap=aq.parentNode.nextSibling}aq=ap}return ao};var B=function(ap){var ao=I(ap,"images");if(!ao){ao=I(ap,"images3d")}return m.parseXMLImageListNode(ao)};var R=function(aq){var ap={};var au=ap.arImages=[];var at="";var aw="";var ax;if(!aq){return ap}var av;av=m.getAttributeValue(aq,"prefix");if(typeof(av)==="string"){at=av}av=m.getAttributeValue(aq,"suffix");if(typeof(av)==="string"){aw=av}aq=I(aq,"image");if(!aq){return ap}while(aq){if(aq.nodeType===1){ax=I(aq,"path");var ay=C(ax);if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"src"))}if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"file"))}if(ay!==b){if(ad===false){au.push(at+ay+aw)}else{var ao=at+ay+aw;if(ad(ao)){au.push(ao)}}}if(ap.width===b){ax=I(aq,"width");ax=C(ax);if(ax!==b){ap.width=parseInt(ax)}ax=I(aq,"height");ax=C(ax);if(ax!==b){ap.height=parseInt(ax)}}}aq=aq.nextSibling}return ap};this.getImageList=function(){var aq,av,ap;z();if(m.cfg&&m.cfg.fpxsources!==b){var au=m.cfg.fpxsources;if(typeof(au)==="string"||(typeof(au)==="object")&&typeof(au.push)==="function"){aq={};aq.oXML=null;if(typeof(au)==="string"){if(ad===false){aq.arImages=au.split(",");for(av=0;av<aq.arImages.length;av++){aq.arImages[av]=a.utils.urlDecode(aq.arImages[av])}}else{var ao=au.split(",");aq.arImages=[];for(av=0;av<ao.length;av++){ap=a.utils.urlDecode(ao[av]);if(ad(ap)){aq.arImages.push(ap)}}}}else{aq.arImages=au}}}if(!aq&&m.arUnrecognizedConfigNodes&&m.arUnrecognizedConfigNodes.length>0){var at=m.arUnrecognizedConfigNodes;for(av=0;av<at.length;av++){var aw=at[av];if(typeof(aw.nodeName)==="string"){var ax=aw.nodeName.toLowerCase();if(ax==="images"||ax==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aq=R(aw);aq.oXML=aw;break}}}}if(!aq&&m.cfg&&m.cfg.fpxsrc!==b){aq={};aq.oXML=null;if(ad===false){aq.arImages=[a.utils.urlDecode(m.cfg.fpxsrc)]}else{ap=a.utils.urlDecode(m.cfg.fpxsrc);if(ad()){aq.arImages=[ap]}}}return aq};this.getServerBase=function(){return m.serverBase};this.loadImageList=function(ar,at,av,au){if(!m.serverBase||!ar){at([],b,au);return false}z();var aq=m.serverBase+"?type=list";if(ar.indexOf("tpl")===-1){var ap=m.cfg.listtemplate;if(ap&&ap.length>0&&ap.indexOf(".json")===-1&&ap.indexOf(".xml")===-1){ap+=".json"}aq+="&tpl="+ap}if(m.cfg.headers&&m.cfg.headers.length>0&&x.headers===b){aq+="&headers="+m.cfg.headers}if(typeof(m.cfg.imagelistlimit)==="string"&&m.cfg.imagelistlimit.length>0){aq+="&limit="+encodeURIComponent(m.cfg.imagelistlimit)}aq+="&source="+encodeURIComponent(ar);if(av!==b){aq+=av}aq=am(aq);var ao=m.loadFile(aq,function(aw,aA){if(typeof(aA)==="object"&&typeof(aA.images)==="object"){aA.images.pop();var aB="";if(aA&&aA.imagesattributes&&aA.imagesattributes.dir){aB=aA.imagesattributes.dir}var ax,az;if(ad===false){ax=new Array(aA.images.length);for(az=0;az<aA.images.length;az++){ax[az]=aB+aA.images[az].src}}else{ax=[];for(az=aA.images.length-1;az>-1;az--){var ay=aB+aA.images[az].src;if(af(ay)){ax.push(ay)}else{aA.images.splice(az,1)}}ax.reverse()}at(ax,aA,au)}else{at([],aA,au)}},"application/json",au);return ao};var af=function(ap){if(typeof(ap)!=="string"){return 1}var ao=1;if(O!==b){if(!ap.match(O)){ao=0}}if(ao===1&&y!==b){if(ap.match(y)){ao=0}}return ao};var ad=true;var O,y;var F=function(at){var aq;var av=m.cfg[at.toLowerCase()];if(!av||typeof(av)!=="string"||av.length<1){return}var ao=/\/([^/]*)$/;try{var ar=av.match(ao);if(ar&&ar.length>1){var ap=ar[1];av=av.replace(ao,"");av=av.replace(/^\//,"")}aq=new RegExp(av,ap)}catch(au){H.error("Invalid Regular Expression "+av+" in parameter "+at);H.error(au.message);aq=b}return aq};var z=function(){O=F("ListFilterPositive");y=F("ListFilterNegative");if(O===b&&y===b){ad=false}else{ad=af}};this.traceConfigValue=function(ao,ar){if(typeof(ao)!=="string"){return false}ao=a.trim(ao);if(ao.length<1){return false}var ap=ao.toLowerCase();if(ap.indexOf(".")!==-1){ap=ap.split(".").join("")}if(ap.indexOf("/")!==-1){ap=ap.split("/").join("")}if(ap.indexOf(" ")!==-1){ap=ap.split(" ").join("")}var aq=new a.Debugger();aq.setPrefix("");aq.group('Tracing parameter "'+ao+'"');var at=function(){var au=ao;var az=m.getParameterAlias(ap);if(typeof(az)==="string"){au+=" (alias: "+az+")";if(typeof(m.cfgAliasNames[ap])==="string"){ap=m.cfgAliasNames[ap]}}var av=m.cfg[ap];var ay=true;if(ap.indexOf("_")!==-1){var ax=ap.split("_");var aw=ax.shift();var aA=ax.join("_");if(m.hasPlugin(aw)){av=m.getPluginParameter(aw,aA)}}else{if(m.hasPlugin(ap)){ay=false;av="is enabled."}}if(av===b){ay=false;av="is undefined (default value applies)"}if(ay){av='= "'+av+'"'}aq.group("RESULT:");aq.log(au+" "+av);aq.groupEnd();aq.groupEnd()};w={onConfigsReady:at};e.strTraceParam=ap;e.bNoDebug=true;m.iTraceParameterDebug=aq;m.init(ar);m.loadConfigs();return""};this.loadLanguageFile=function(ao,aA,at,aq){var au=arguments;var av,ay;if(typeof(aA)!=="string"||m.makeBool(aA,true)===false){return at.call(m,{},"")}var az=function(aB){try{a.utils.oLanguageMap=JSON.parse(aB.responseText)}catch(aC){a.utils.oLanguageMap={"default":"english"}}m.loadLanguageFile.apply(this,au)};var aw=function(aB,aE){ao.urlLanguageCurrentLoaded=av;var aD=ao.oLanguageData={};if(aE){var aC=m.findXMLNode(aE,"data");if(aC){aC=m.findXMLNode(aC,"tip")}while(aC){if(aC.nodeType===1){var aF=aC.getAttribute("id");aD[aF]=m.XMLChildNodesToString(aC)}aC=aC.nextSibling}}at.call(m,ao.oLanguageData,ay)};if(aA.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){m.loadFile(a.getViewerLocation()+"/languages/mapping.json",az,"application/json");return}if(a.utils.oLanguageMap._current!==b){aA=a.utils.oLanguageMap._current}else{aA=a.utils.oLanguageMap["default"];var ar=navigator.language;if(typeof(ar)==="string"){ar=ar.toLowerCase()}if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}else{if(ar.indexOf("-")!==-1){ar=ar.split("-")[0];if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}}}}if(aA===b){return at.call(m,{},"")}if(aq){aq.log('Automatically choosing language "'+aA+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aA}var ax=aA+".xml";var ap=a.getViewerLocation()+"/languages/"+ax;if(ap!==ao.urlLanguageCurrentLoaded){ay=aA;av=ap;if(aq){aq.log("Loading language file: "+ap)}m.loadFile(ap,aw,"application/xml")}else{at.call(m,ao.oLanguageData,ay)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){a.CustomEventListener;if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.utils.getNewEventElementID()}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!=c){if(q){j()}else{i()}}};var m=function(p){var q;var r=a.utils.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!=q){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewport")){return}a.utils.registerCustomEvent("FSIViewport",function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.utils.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!=b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!=b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!=d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!=b){return}w=setTimeout(K,N);K()};var K=function(){if(w!=b){clearTimeout(w);w=b}var e=false;var U=L();if(C!=U){C=U;e=true;f()}return e};var J=function(){n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.utils.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);h.left=a.utils.getTopWindow().pageXOffset;h.top=a.utils.getTopWindow().pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!=b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!=b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u==b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!=b){if(U==b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length==0){r()}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(n,aY,am,e,aO){var aF=this;var aM=false;var al=true;var p=false;var aU=false;var aL=false;var aC,F,j,ae;var aD,Z,aJ;var h=false;var af;var s;var a1={};var ar=[];var ad=0;var J=window;var aW;var t;var aV;var d;var a0=[];var aS={x:0,y:0};var w={x:0,y:0};var at=40;var o={};o.enabled=false;o.factor=5;o.fEndDiff=1;var az={};az.enabled=false;az.minFrames=14;az.factorAmount=23;az.factorAmountQuad=0;az.factorFrames=2.6;az.offsetFrames=5;var ac;var aA;var aI,x,l;var G;var au={};var Y;var aN=false;var A=false;var an={};an.name="none";var O;var X;var aP;var f=false;var aa={};if(!aY||typeof(aY)!="object"){aY={}}var ao=function(){var a7;if(aM){aF.destroy()}aV=B;t=b;if(a.utils.getTopWindow()!=window){t=a.utils.getTopWindow();try{var a6=a.getWindowOffset(window);if(a6.x!=b&&a6.y!=b){aV=aq}}catch(a5){aV=B;t=b}}else{t=b}G=aY.oPassTrough;aX(aY.panDirectionAllowed,true);if(aY.getPageCoords){s=aG}else{s=N}if(aY.afterTouch){for(a7 in aY.afterTouch){az[a7]=aY.afterTouch[a7]}}if(az.minDelta==b){az.minDelta=15}if(aY.nClickRadius){ac=aY.nClickRadius}else{ac=10}if(az.fnStartStopAfterTouch&&typeof(az.fnStartStopAfterTouch)!="function"){az.fnStartStopAfterTouch=b}if(az.fnStartStopAfterTouch){az.useAnimationFrame=b}if(typeof(az.modifyTarget)!="function"){az.modifyTarget=b}if(typeof(az.fnGetAfterTouchEnabled)=="function"){aA=az.fnGetAfterTouchEnabled}else{aA=b}if(aY.smoothing){for(a7 in aY.smoothing){o[a7]=aY.smoothing[a7]}}if(aY.detectClick==true){Y=true}if(aY.preventSelection!==false){aY.preventSelection=true}if(!n){return}if(typeof(n.join)!="function"){n=[n]}if(typeof(am)!="function"){am=B}if(typeof(e)!="function"){e=B}if(typeof(aO)!="function"){aO=B}if(typeof(aY.onPinchChange)=="function"){O=aY.onPinchChange}else{O=b}aN=aY.detectGestures;a0=[];ay(true,aN);for(var a4=0;a4<n.length;a4++){var a3=n[a4];if(a3&&typeof(a3.nodeName)!="undefined"){a7={};a7.element=a3;a0.push(a7);ap(a3,S);if(a.isTouch){try{if(a3.style!=b){if(a.BrowserSupports.cssTouchAction()){if(au.cssTouchAction!=b){r(a3,au.cssTouchAction)}}}}catch(a5){}}}}if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aE,false)}};var aX=this.setAllowedPanDirection=function(a4,a3){if(typeof(a4)=="string"){if(a4=="pan-x"||a4=="pan-y"||a4=="pan-x pan-y"){aW=a4+" "}else{aW=""}}else{aW=""}if(!a3){au.nCheck=b;ai(au.captureScroll,au.capturePinch)}};this.enable=function(a3){if(al==a3){return}if(!a3){R();ai(false,false)}else{ai(au.captureScrollUser,au.capturePinchUser)}al=a3};this.getEnabled=function(){return al};this.cancel=function(){Q();ah();aK();R()};var aK=function(){if(o.enabled){i()}C()};this.cancelAfterTouch=function(){C()};this.getInitialDownEvent=function(){return X};var R=function(){if(!p){return}aK();p=false;X=b;A=false;if(ad==0){aQ()}};var aQ=function(){f=false;c()};this.destroy=function(){if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aE,false)}if(aP){clearTimeout(aP)}aF.cancel();var a3;for(var a4=0;a4<a0.length;a4++){var a5=a0[a4];a3=a5.element;y(a3,S)}au={}};var r=function(a3,a4){if(!a.BrowserSupports.cssTouchAction()||!a3||!a3.style){return}a3.style.touchAction=a3.style.msTouchAction=a4};var U=function(a3){if(a3.preventDefault){a3.preventDefault()}};var m=function(a3){U(a3);return false};var ap=function(a4,a3){a.addEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{a.addEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a4,"touchstart",a3);a.addEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a4,"MSPointerDown",a3)}a.addEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var y=function(a4,a3){a.removeEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{a.removeEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a4,"touchstart",a3);a.removeEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a4,"MSPointerDown",a3)}a.removeEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var B=function(){return true};var aR=function(a3){if(aL){W(a3,a3.pointerId)}else{var a4=a3.changedTouches;for(var a5=0;a5<a4.length;a5++){W(a4[a5],a4[a5].identifier)}}};var W=function(a3,a5){if(a5==b||a1[a5]!=b){if(aY.debug){if(a5==b){a.console.error("doRegisterPointer: no pointerId")}if(a1[a5]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a5)}}return}ad++;var a4=a1[a5]={};a4.identifier=a5;s(a4,a3);ar.push(a4)};var ak=function(a3){var a5=false;if(aL){a5=L(a3.pointerId)}else{var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){a5=L(a4[a6].identifier)}}}if(a5){ar=new Array(ad);var a8=0;for(var a7 in a1){ar[a8++]=a1[a7]}}};var L=function(a3){if(a3==b||a1[a3]==b){if(aY.debug){if(a3==b){a.console.error("doUnregisterPointer: no pointerId")}if(a1[a3]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+a3)}}return false}delete a1[a3];ad--;return true};var I=function(){ad=0;a1={};ar=[]};var N=function(a4,a3){a4.x=a3.clientX;a4.y=a3.clientY};var aG=function(a4,a3){a4.x=a3.pageX;a4.y=a3.pageY};var v=function(a3){var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){var a5=a1[a4[a6].identifier];if(a5){s(a5,a4[a6])}}}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y}};var ax=function(a3){var a4=a1[a3.pointerId];if(a4){s(a4,a3)}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y;aV(a3,aS)}};var V=function(a3){s(aS,a3);aV(a3,aS)};this.getMousePositionFromMouseEvent=function(a3){V(a3);return aS};this.getMousePositionPage=function(a4){var a3={};aG(a3,a4);aV(a4,a3);return a3};this.getMousePositionClient=function(a4){var a3={};N(a3,a4);aV(a4,a3);return a3};var u=function(a3,a4){if(window!=a3.view){var a5=a.getWindowOffset(window);a4.x-=a5.x;a4.y-=a5.y}};var aq=function(a3){try{u(a3);aV=u}catch(a4){aV=B}};var aB=function(a3){if(!al){return}var a5=ad;if(A&&a5==0){A=false}var a6=a3.type;if(p||an.started){if(a6!=aC){if(an.started){Q();ah()}else{a3._FSI_Canceled=true;a2(a3,true)}}}aC=a6;d=false;var a4=true;switch(a6){case"touchstart":aU=true;aL=false;af=v;j="touchmove";F="touchend";ae="touchcancel";aI=false;break;case"MSPointerDown":af=ax;aU=true;aL=true;j="MSPointerDown";F="MSPointerUp";ae="MSPointerCancel";aI=false;d=true;break;case"pointerdown":af=ax;aU=true;aL=true;j="pointermove";F="pointerup";ae="pointercancel";aI=true;d=true;break;default:if(ad>0){I()}aU=false;aL=false;aI=(aY.preventSelection);a4=false;af=V;j="mousemove";F="mouseup";ae=b;d=true}if(aU&&a4){aR(a3)}af(a3);if(!aY.bAllowMouseDown&&aI){U(a3)}if(ad>1){aa.bClick=false}x=false;if(a4&&aj(a3)){if(a5==0){C();E()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ad};var S=function(a3){if(aY.bMouseOnly&&a3.type==="pointerdown"&&a3.pointerType!=="mouse"){return true}if(!aB(a3)){return}if(p||a3.which>1){return}g(a3)};this.getCurrentPos=function(){return w};var g=function(a3){aK();if(p){return}az.evtMove=b;if(o.enabled){w={x:aS.x,y:aS.y}}else{w=aS}aa.x=aS.x;aa.y=aS.y;var a4=X;X=a3;if(!am.call(J,a3,w,G)){X=a4;return false}p=f=true;if(Y&&!A){aa.bClick=true;aa.clickRadiusX=aa.clickRadiusY=0}else{aa.bClick=false}E();if(az.enabled){az.x=az.y=0;az.lastX=aS.x;az.lastY=aS.y;if(az.nInterval){clearInterval(az.nInterval)}az.nInterval=setInterval(ab,30)}return true};var c=function(){if(h&&Z!=b){var a3={passive:false,capture:false};var a5=(t==b)?a3:b;h=false;a.removeEvent(window,Z,ag,a5);a.removeEvent(window,aD,a2,a5);if(d&&t){try{a.removeEvent(t,Z,ag,a3);a.removeEvent(t,aD,a2,a3)}catch(a4){}}if(aJ!=b){a.removeEvent(window,aJ,av,a5)}Z=aD=aJ=b}};var aE=function(a3){};var E=function(){if(h){c()}h=true;var a3={passive:false,capture:false};var a5=(t==b)?a3:b;Z=j;aD=F;aJ=ae;a.addEvent(window,Z,ag,a5);a.addEvent(window,aD,a2,a5);if(d&&t){try{a.addEvent(t,Z,ag,a3);a.addEvent(t,aD,a2,a3)}catch(a4){}}if(ae!=b){a.addEvent(window,aJ,av,a5)}};var ag=function(a3){af(a3);a3.FSI_start_x=aa.x;a3.FSI_start_y=aa.y;if(az.enabled&&az.evtMove==b){az.evtMove=a3}if(p){if(aa.bClick){aa.clickRadiusX=Math.max(aa.clickRadiusX,Math.abs(aS.x-aa.x));if(aa.clickRadiusX>ac){aa.bClick=false}else{aa.clickRadiusY=Math.max(aa.clickRadiusY,Math.abs(aS.y-aa.y));if(aa.clickRadiusY>ac){aa.bClick=false}}}if(o.enabled){o.evt=a3;aZ()}else{e.call(J,a3,w,G)}}else{if(an.started){if(an.nType==1){aw(a3)}}}if(x&&!a3.FSI_allowEventDefault){U(a3)}};var aw=function(a3){var a4=k();if(!O){return}a3._FSI_PinchDeltaStart=an.nPinchDistance-an.pinchDistanceStart;a3._FSI_PinchDeltaRelative=an.nPinchDistance-an.pinchDistanceLast;a3._FSI_PinchScale=Math.max(at,an.pinchDistanceLast)/an.pinchDistanceStartMaxed;an.pinchDistanceLast=an.nPinchDistance;a3._FSI_PinchDistance=a4;O.call(J,a3,aS,G)};var av=function(a3){if(aU){ak(a3);if(ad<1){if(p){a3._FSI_Canceled=true;a2(a3,true);return}else{R();return}}}af(a3);aj(a3)};var a2=function(a4,a5){var a3=aa.bClick;aa.bClick=false;if(a5){a4._FSI_Canceled=true}if(aU){ak(a4)}if(ad==0){aQ()}af(a4);if(!a5&&aj(a4)){return}aK();if(!a5){if(!p||ad>0){return}}a4.FSI_start_x=aa.x;a4.FSI_start_y=aa.y;var a6=false;if(!a5&&az.enabled){if(aA==b||aA()){a6=T(a4)}}if(a6){R();z(a4)}else{if(Y){a4._FSI_Click=a3}aO.call(J,a4,w,G);if(a4.type=="touchend"){aP=setTimeout(q,1)}R()}U(a4)};var q=function(){R();I();aP=b};var H=function(a3){return ar};var aZ=function(){if(o.animationFrame!=b){return}aT()};var i=function(){if(o.animationFrame==b){return}cancelAnimationFrame(o.animationFrame);o.animationFrame=b};var aT=function(){var a3=Math.abs(w.x-aS.x)+Math.abs(w.y-aS.y);if(a3>o.fEndDiff){w.x+=(aS.x-w.x)/o.factor;w.y+=(aS.y-w.y)/o.factor;o.animationFrame=requestAnimationFrame(aT)}else{w.x=aS.x;w.y=aS.y;o.animationFrame=b}e.call(J,o.evt,w,G)};var T=function(a3){var a4;if(!az.enabled){return false}if(az.running){C()}az.pos=0;var a6=(a3.touches!=b)?1.8:1;if(az.factorAmountQuad){a4=(az.x>0)?1:-1;az.x=az.x+a4*az.x*az.x/az.factorAmountQuad;a4=(az.y>0)?1:-1;az.y=az.y+a4*az.y*az.y/az.factorAmountQuad}var a8=a6*az.factorAmount;az.startX=w.x;az.startY=w.y;var a7={};a7.x=az.startX+a8*az.x;a7.y=az.startY+a8*az.y;if(az.roundTargetPos){a7.x=Math.round(a7.x);a7.y=Math.round(a7.y)}if(az.modifyTarget){a7=az.modifyTarget.call(J,a7,G);if(a7===false){return false}}az.amountX=a7.x-az.startX;az.amountY=a7.y-az.startY;az.amountXABS=Math.abs(az.amountX);az.amountYABS=Math.abs(az.amountY);var a5=(az.amountXABS>az.minDelta||az.amountYABS>az.minDelta);if(a5){a8=az.factorFrames/100;az.frames=az.offsetFrames+Math.round(a8*az.amountXABS+a8*az.amountYABS)}else{if(typeof(aY.onAfterTouchCancel)=="function"){aY.onAfterTouchCancel.call(J,a3,w,G)}}return a5};this.isAfterTouchRunning=function(){return az.running};var z=function(a3){if(typeof(aY.onAfterTouchStart)=="function"){aY.onAfterTouchStart.call(J,a3,w,G)}az.running=true;az.evtUp=a3;if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,true,az.evtMove,G)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}else{az.intervalRun=setInterval(K,16)}}return true};var aH=function(a4,a3,a6,a5){return a6*((a4=a4/a5-1)*a4*a4+1)+a3};var K=this.runAfterTouch=function(){var a3=false;az.pos++;w.x=aH(az.pos,az.startX,az.amountX,az.frames);w.y=aH(az.pos,az.startY,az.amountY,az.frames);e.call(J,az.evtMove,w,G);if(az.pos===az.frames){C(true)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}a3=true}return a3};this.enableAfterTouch=function(a3){if(az.enabled==a3){return}if(!a3){C()}az.enabled=a3};var C=function(a3){if(!az.running){return}if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,false,az.evtMove,G)}else{if(az.useAnimationFrame){if(az.animationFrameRun){cancelAnimationFrame(az.animationFrameRun)}}else{if(az.intervalRun){clearInterval(az.intervalRun);az.intervalRun=b}}}if(typeof(aY.onAfterTouchEnd)=="function"){aY.onAfterTouchEnd.call(J,az.evtMove,G)}az.evtMove=b;az.running=false;az.evtUp._FSI_Canceled=(a3!==true);az.evtUp._FSI_fromAfterTouch=true;aO.call(J,az.evtUp,w,G)};var ab=function(){az.x=(2*az.x+aS.x-az.lastX)/5;az.y=(2*az.y+aS.y-az.lastY)/5;az.lastX=aS.x;az.lastY=aS.y};var ay=this.setCapture=function(a3,a5){var a4=ai(a3,a5);if(a4){au.captureScrollUser=a3;au.capturePinchUser=a5}return a4};var ai=function(a3,a5){var a4=0;if(a3){a4+=2}if(a5){a4+=4}if(a4==au.nCheck){return}au.nCheck=a4;au.captureScroll=a3;au.capturePinch=a5;if(a.BrowserSupports.cssTouchAction()){P(a3,a5)}return true};var P=function(a3,a7){if(aY.bMouseOnly){return}var a6;switch(au.nCheck){case 0:a6="auto";break;case 2:a6=aW+"pinch-zoom";break;case 4:a6="pan-x pan-y";break;default:a6=(aW.length>0)?aW:"none"}au.cssTouchAction=a6;for(var a5=0;a5<n.length;a5++){var a4=n[a5];r(a4,au.cssTouchAction)}};var k=function(){if(ar.length<1){return 0}var a4=Math.abs(ar[1].x-ar[0].x);var a3=Math.abs(ar[1].y-ar[0].y);return an.nPinchDistance=Math.sqrt(a4*a4+a3*a3)};var aj=function(a3){x=false;if(!al){return}var a4=ar.length;if(!aN){x=(a4==1&&au.captureScroll);return}if(an.pointerCount!=a4){Q(a3);if(a4>1){ah();an.nPointers=a4;switch(a4){case 2:an.started=true;an.name="pinch";an.nType=1;if(typeof(aY.onPinchStart)=="function"){M(a3);an.nPinchDistance=0;an.nPinchDistance=k();an.pinchDistanceStart=an.pinchDistanceLast=an.nPinchDistance;an.pinchDistanceStartMaxed=Math.max(at,an.pinchDistanceStart);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchStart.call(J,a3,aS,G)}break;default:an.started=true;an.name="unknown";an.nType=-1}if(an.started){A=true;if(p){aK();p=false;a3._FSI_Canceled=true;aO.call(J,a3,w,G)}if(typeof(aY.onGestureStart)=="function"){M(a3);aY.onGestureStart.call(J,a3,aS,G)}}}else{if(a4<1){ah()}}an.pointerCount=a4;x=false;if(a4==1){if(au.captureScroll){x=true}}else{if(au.capturePinch&&an.nType==1){x=true}}}return an.started};var ah=function(){if(!an.timeoutRestartDown){return}clearTimeout(an.timeoutRestartDown);an.timeoutRestartDown=b};var D=function(){if(ad!=1){return}g(X);ah()};var M=function(a3){a3._FSI_Gesture=an.name;a3._FSI_GestureType=an.nType;a3._FSI_PointerCount=an.nPointers};var Q=function(a3){if(!an.started){return}an.started=false;if(!a3){a3={}}if(an.nType==1&&typeof(aY.onPinchEnd)=="function"){M(a3);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchEnd.call(J,a3,aS,G)}if(typeof(aY.onGestureEnd)=="function"){M(a3);aY.onGestureEnd.call(J,a3,aS,G)}an.name="none";an.nType=0;if(a3&&ad==1){ah();an.timeoutRestartDown=setTimeout(D,20)}};ao()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.Thumbar!==b){return}a.utils.API.ThumbBar=function(d,e){var c=this;c.scriptMainFile="FSI.ThumbBar.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},assignFSIViewer:{a:"iFSIViewerInstance"},buttonDown:{a:"strCommand",r:"bSuccess"},buttonUp:{r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeDir:{a:"strDirectory",r:"bSuccess"},closeZoom:{a:"evt, bImmediate"},destroy:{},firstImage:{a:"nAnimationFrames"},focusImage:{a:"nImage"},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getImageCount:{r:"nImages"},getInitDone:{r:"bDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getScrollPos:{r:"fPosition"},getVersion:{r:"strVersion"},init:{a:"elementID, oParameters, bDebug"},isScrolling:{r:"bScrolling"},lastImage:{a:"nAnimationFrames"},nextImage:{a:"nAnimationFrames"},nextPage:{a:"nAnimationFrames"},previousImage:{a:"nAnimationFrames"},previousPage:{a:"nAnimationFrames"},printAPI:{},registerButton:{a:"DOMElement, strCommand",r:"bSuccess"},setScrollPos:{a:"fPosition, nAnimationFrames",r:"fPosition"},startAutoRotate:{a:"fSpeed"},stopAutoRotate:{},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unRegisterButton:{a:"DOMElement",r:"bSuccess"},zoomImage:{a:"nImage"}};c.oCallbacks={onClick:{a:"nIndex, oItem"},onConfigsReady:{a:"oConfigValues"},onDestroy:{},onFocus:{a:"nImageIndex, strImagePath"},onInit:{a:"oParameters)"},onMouseEnter:{a:"nIndex, oItem)"},onMouseLeave:{a:"nIndex, oItem)"},onScrollStart:{a:"fPosition"},onScrollEnd:{a:"fPosition"},onSetScrollRange:{a:"fTotalSize, fRange, bEndlessScrolling, nTotalImages"},onStart:{a:"strDirectory, nImages, arImagePaths"},onZoomEnd:{},onZoomReady:{a:"nImageIndex, strZoomedImageURL, elZoomedImage"},onZoomStart:{a:"nImageIndex, strImageURL"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ThumbBar!==b){return}a.ThumbBar=function(dL,cn){var d0={};var ab={strVersion:"2018",strBuild:"18.07.06.1",strConfigSection:"ThumbBar",bHasListeners:true};var bm=new a.utils.ClassDef(this,"FSI ThumbBar",ab);bm.oAPI=new a.utils.API.ThumbBar(this,d0);var az=bm.instance;a.utils.guessFSIViewerLocation("fsithumbbar.js",3);var bX=a.utils.getViewerInstanceID();this.getInstanceID=function(){return bX};this.getInstanceName=function(){return bm.strClassName+" ["+A+"]"};var cg=(cn)?a.utils.cloneParameters(cn):{};var dd;var cS;var aw;var cW;var dQ;var v;var A;var cd;var aX,aJ;var bN,df;var cY=0;var dN=false;var cN;var cx,b2,cf,R,P;var cM;var cy;var dq={};var ac;var dS=false;var S;var ao;var ca;var aC,aq,a2;var E;var cE={};var b6;var cQ;var aa;var d4=[];var cF,F;var Y;var ba,dU;var eb;var d;var bp;var dk=100;var aU;var ce=0;var bV={};var c4;var ck=0;var e;var d8=false;var du=0;var ch;var di;var T;var dZ={};var bG={};var cT={};var dy;var Q;var al;var y,ae;var dp;var aY;var bf;var cD;var bE={};var av;var b3,bQ;var dC;var an;var ay={};var G;var dR=false;var dI;var bi;var bk=false;var b1=false;var C;var b8,dA;var a1;var c0=false;var aM;var eh;var aP;var cH;var cv;var d6;var X,dg,a8;var c8=0;var aK=0;var aD;var da;var c9,bt;var bq=[];var a0;var W;var d7={};var cl;var be=(a.isMobileDevice)?" mobile":"";var aO={};var bg={};var b0,c5;var cG={};var ag;var cC;var dv=0;var dj;var h;var cz;var bM;var dT;var c1={};var dn;var ap;var a6;var bF={};var dh=0;var c7=0;var aW=512;var c3={ts:0,dist:0};var cX={passive:true,capture:false};var a7=/((\?)|&)(width|height)=[^&]*/ig;var bu=("filter" in document.body.style)?"filter":"webkitFilter";var u;var cV;var aE;var ci;var bR={};var V=0;var dx=(a.isMobileDevice)?8:16;var at=[];var aT=0;var ad;var dl="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";var ea=true;var dJ;var dY;var j;var o;var aL={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",format:"",headers:"cors",presentationType:"flat",elementWidth:"10%",elementSpacing:"0.25%",placeHolderImage:"default",placeHolderPadEffect:"Pad(CC,FFFFFF)"},booleans:{autoDestroy:true,autoResize:true,depthFadeout:true,enableZoom:true,ScrollBar:true,centerZoomedImage:true,endlessScrolling:false,useTouchZoom:true,vertical:false},floats:{autoRotateSpeed:0,Alignment:1,PerspectiveAlignment:1,zoomShaderStartOpacity:0,zoomShaderEndOpacity:0.8},integers:{initialImage:0,preloadCount:40,paddingTop:10,paddingBottom:0,garbageCollectionSize:-1}};var bP=new a.EmptyDebugger();var ef=function(ek,ej){if(ej&&!bP.on&&ek.on){if(dI){dI.stopPendingRequests()}az.destroy(true);az.init(dJ,cg,true);return true}bP=ek;if(bP.on){bP.setPrefix(az.getInstanceName())}};var bK=function(ek,ep,ej){var em;var el;dJ=ek;if(!ek){return}if(typeof(ek)==="object"){if(typeof(ek.id)==="string"){A=ek.id}}else{if(typeof(ek)==="string"){A=ek}}if(!A){A="fsi.thumbbar #"+bX}if(az._fsi_parameters){ep=az._fsi_parameters;delete az._fsi_parameters}if(typeof(ek)==="object"&&ek.tagName!==b){em=ek}else{em=document.getElementById(ek)}if(!em){return}if(dN){az.destroy()}em.setAttribute("x-fsi-id",A);cg=(ep)?a.utils.cloneParameters(ep):cg;var eq={};eq.onConfigsReady=b9;eq.onDebuggerChange=ef;dI=new a.Config(null,eq,{strSection:bm.strConfigSection});bi=d0.iCallbacks=new a.Callbacks(az,dI);if(bi.isset("onInit")){bi.runPersistent("onInit",[cg])}var eo=cg;if(ej){eo=a.utils.cloneObject(cg);eo.debug=true}dI.init(eo);bP.log(az.getVersion());ad=document.createElement("img");ad.crossOrigin="anonymous";cN=em;em.innerHTML="";cx=document.createElement("div");var en="fsi-thumbbar-root";if(a.isMobileDevice){en+=" mobile"}cx.className=en;el="position:relative;width:100%;height:100%;border:0 none;margin:0px;padding:0px;overflow:hidden;";a.utils.setStyleAttr(cx,el);b2=document.createElement("div");b2.className="fsi-thumbbar-container";el="position:absolute;z-index:1;width:100%;height:100%;border:0 none;margin:0px;padding:0px;";el+="text-align:left;vertical-align:top;";el+="perspective:100px;perspective-origin:50% 100%;pointer-events:none;";if(a.isInternetExplorer){el+="transform-style:preserve-3d;"}else{el+="transform-style:flat;"}a.utils.setStyleAttr(b2,el);cx.appendChild(b2);cN.appendChild(cx);aH();dN=true;dQ={};dI.loadConfigs()};this.getConfigValue=function(ej){if(dI&&typeof(ej)==="string"){return dI.cfg[a.trim(ej.toLowerCase())]}};this.getParameters=function(){return a.utils.cloneParameters(cg)};var dV=function(ej){if(cE.bImageDragging){return}if(a.now()-c3.ts<25&&c3.dist>10){return}c3.ts=0;cf.style.pointerEvents="none";b2.style.pointerEvents="all";var ek=document.elementFromPoint(ej.clientX,ej.clientY);if(ek&&ek.oSprite){bh(ek.oSprite)}cf.style.pointerEvents="all";b2.style.pointerEvents="none"};var bh=function(ej){if(bi.isset("onClick")){bi.run("onClick",[ej.nIndex,ej])}if(dQ.enableZoom){J(ej)}if(dQ.centerZoomedImage){a4(ej)}};var br=function(ej){if(ej===cf[E]){return}cf[E]=ej;cE.bIgnoreEvent=true;cE.bIgnoreEventPos=cf[E]};var dm=function(){if(cE.bIgnoreEvent){cE.bIgnoreEvent=false;var em=cE.bIgnoreEventPos;cE.bIgnoreEventPos=false;if(cf[E]===em){return}}if(cE.bImageDragging){if(!v.isAfterTouchRunning()){return}}var ek=(ca)?cf.offsetHeight:cf.offsetWidth;if(ek!==S){return}var ej=cf[E];var el=ch;if(T){el=by(ej,c8)}M(-ej,true,el,1)};var by=function(ej,em){var el;var ek=Math.abs(Math.round(ej+em));if(ek<20){el=0}else{el=Math.floor(Math.max(0,Math.min(20,ek/45)))}return el};var Z=function(){dK();c8=0};var dK=function(){at=[];ak();if(bf){bf.style.display="none"}for(var ej=0;ej<bq.length;ej++){bj(bq[ej])}Y={};bF={};dq={};at=[];bq=[];dh=0;cY=0;ck=0;b0=0;cY=0;return true};var b9=function(){dK();dy={};cv=b;d6=b;if(dI.cfg.viewerselector){az.assignFSIViewer(dI.cfg.viewerselector)}if(dI.cfg.viewerid){az.assignFSIViewer(dI.cfg.viewerid)}var ek=dI.cfg.dir;if(!ek||ek.length===0){var ej=dI.getImageList();if(ej){aQ(ej.arImages,ej)}}else{dI.loadImageList(dI.cfg.dir,aQ)}if(bi.isset("onConfigsReady")){bi.runPersistent("onConfigsReady",[a.utils.cloneObject(dI.cfg)])}};var cI=function(ej,ek){bi.run("onChangeConfig",[ej,ek]);if(bP.on){a.console.log("")}if(ek!==null&&typeof(ek)==="object"){cg=a.utils.cloneParameters(ek)}if(typeof(ej)==="string"){cg.cfg=ej}az.destroy(true);bP=new a.EmptyDebugger();az.init(dJ,cg)};var ed=function(ej){if(typeof(ej)!=="string"){return false}Z();dI.cfg.dir=ej;b9();return true};var aQ=function(ej,ek){if(!dN){return}if(!ej){ej=[]}cv=ek;d6=(cv&&cv.images&&cv.images[0]&&cv.images[0].width!==b&&cv.images[0].height!==b);d4=ej;du=ej.length;bP.log("Image list loaded ("+d4.length+" images)");cc();aI()};var cc=function(){bd(dQ)};var dH=function(ek,ej,en,el){for(var em in en){ej[em]=ek.getFloatParameter(el+em,en[em])}};var cj=function(ek,ej,en,el){for(var em in en){ej[em]=ek.getIntParameter(el+em,en[em])}};var bL=function(el,ek,ej,em){for(var en in ej){ek[en]=el.getStringParameter(em+en,ej[en])}};var p=function(ek,ej,em,el){for(var en in em){ej[en]=ek.makeBool(ek.getStringParameter(el+en),em[en])}};var bA=function(ek,ej,em,el){var en;if(em&&em.length>0){if(ej[em]===b){ej[em]={}}el=el[em];en=ej[em]}else{en=ej}if(el.strings){bL(ek,en,el.strings,em)}if(el.booleans){p(ek,en,el.booleans,em)}if(el.floats){dH(ek,en,el.floats,em)}if(el.integers){cj(ek,en,el.integers,em)}};var bd=function(ej){if(ej===b){ej={}}ej.serverBase=dI.serverBase;bA(dI,ej,"",aL);var em=/[\dabcdef]{3,6}/i;for(var en in aL.strings){if(en.indexOf("Color")!==-1){var el=dQ[en];if(el.indexOf("#")!==0){var ek=el.match(em);if(ek){if(ek[0].length===el.length&&(ek[0].length===3||ek[0].length===6)){dQ[en]="#"+ek[0]}}}}}};var ai=function(el){var ek,ej;if(typeof(el)==="string"){ej=el.indexOf("%");ek=parseFloat(el)}else{ej=-1;ek=el}if(ej!==-1){ek=Math.round(X.width*ek/100)}return{val:ek,bRelative:(ej!==-1)}};var db=function(){var ek,ej;ek=ai(dQ.elementWidth);if(isNaN(ek.val)){ek=ai(aL.strings.elementWidth)}ej=bE.width=Math.max(1,ek.val);if(ca){ci=ej}else{aP=ej}bE.widthRelative=ek.bRelative;ek=ai(dQ.elementSpacing);if(isNaN(ek.val)){ek=ai(aL.strings.elementSpacing)}cH=bE.spacing=ek.val;bE.spacingRelative=ek.bRelative};var w=function(){if(!cf){return}a.removeEvent(cf,"scroll",dm,cX);a.removeEvent(cf,"click",dV);if(j!==b){aV()}if(!a.isMobileDevice){a.removeEvent(cf,"mouseenter",I)}cx.removeChild(cf);cf=b};var aH=function(){cf=document.createElement("div");cf.className="fsi-thumbbar-scroll-bar";var ej="z-index:2;width:100%;height:100%;margin:0px;padding:0px;border:0 none;position:absolute;overflow:hidden;-webkit-overflow-scrolling:touch;";a.utils.setStyleAttr(cf,ej);P=document.createElement("div");a.utils.setStyleAttr(P,"width:1px;height:1px;visibility:hidden;");cf.appendChild(P);cx.appendChild(cf);a.addEvent(cf,"scroll",dm,cX);a.addEvent(cf,"click",dV);if(!a.isMobileDevice){a.addEvent(cf,"mouseenter",I)}};var d3=function(){if(!R){return}a.removeEvent(R,"scroll",U,cX);a.removeEvent(R,"mouseup",bs);a.removeEvent(R,"pointerup",bs);a.removeEvent(R,"touchend",bs);cx.removeChild(R);R=b};var q=function(){if(a.isInternetExplorer&&G>0){cf.style.display="";if(!R){bP.info("Using scroll bar optimization");R=document.createElement("div");R.className="fsi-thumbbar-scroll-bar fake";var ej="z-index:20;width:0px;height:0px;margin:0px;padding:0px;border:0 none;position:absolute;overflow:hidden;-webkit-overflow-scrolling:touch;";a.utils.setStyleAttr(R,ej);cx.appendChild(R);a.addEvent(R,"scroll",U,cX);a.addEvent(R,"mouseup",bs);a.addEvent(R,"pointerup",bs);a.addEvent(R,"touchend",bs)}R.style.overflowX=cf.style.overflowX;R.style.overflowY=cf.style.overflowY;while(R.firstChild){R.removeChild(R.firstChild)}R.appendChild(P.cloneNode(false));if(ca){R.style.width=G+"px";R.style.height="100%";if(ea){R.style.bottom="";if(!cC){R.style.right="0px"}else{R.style.right=-G+"px"}cf.style.width=(cf.offsetWidth+G)+"px"}}else{R.style.width="100%";R.style.height=G+"px";if(ea){if(!cC){R.style.bottom="0px"}else{R.style.bottom=-G+"px"}R.style.right="";cf.style.height=(cf.offsetHeight+G)+"px"}}aY=aj;bf=R;cM=true}else{d3();aY=a.fnDoNothing;bf=cf;cM=false;if(cC){cf.style.display="";if(ca){cf.style.width=(cf.offsetWidth+G)+"px"}else{cf.style.height=(cf.offsetHeight+G)+"px"}}}};var aj=function(ej){R[E]=ej;cE.bIgnoreFakeEvent=true;cE.bIgnoreFakeEventPos=R[E]};var bs=function(){br(-c8)};var U=function(){if(cE.bIgnoreFakeEvent){cE.bIgnoreFakeEvent=false;var em=cE.bIgnoreFakeEventPos;cE.bIgnoreFakeEventPos=false;if(R[E]===em){return}}var ek=(ca)?R.offsetHeight:R.offsetWidth;if(ek!==S){return}var ej=R[E];var el=ch;if(T){el=by(ej,c8)}M(-ej,true,el,2)};var aI=function(){dG();dU=dQ.initialImage;var ej={debug:false,useimagetiles:false,usedevicepixelratio:false,imgsrcattributename:"src",scanOnInit:false};if(dQ.useTouchZoom){if(typeof(a.TouchZoom)!=="function"){bP.error("FSI TouchZoom script missing")}else{dd=new a.TouchZoom(ej);dd.init(false,true);aw=setInterval(cm,500)}}else{if(dd){dd.destroy();dd=b}}ca=dQ.vertical;C=dQ.presentationType.toLowerCase();bk=dQ.endlessScrolling;s();b0=d4.length;X=a8=dg=cb();cV=dQ.autoRotateSpeed;db();cF=a.utils.cloneArray(d4);if(cv&&cv.images){F=a.utils.cloneArray(cv.images)}else{F=b}Y={};if(dQ.autoResize===true){if(eh===b){eh=a.addCustomEvent(cN,"FSIElementDimension",ax);a.setCustomEventListenerProperty(eh,"treshold",200)}}else{if(eh!==b){a.removeCustomEvent(cN,"FSIElementDimension",ax);eh=b}}ar()};var d2=function(){var el=bm.strClassName;if(!a.utils.cssClassExists(el)){var ej="div.fsi-thumbbar-container img{\n\tposition:absolute!important;\n\t-moz-backface-visibility: hidden;\n\t-ms-backface-visibility: hidden;\n\t-webkit-backface-visibility: hidden;\n\tbackface-visibility: hidden;\n\ttransform-origin: center;\n\tbox-sizing: content-box;\n}\n";ej+="div.fsi-thumbbar-container.stacks,\ndiv.fsi-thumbbar-container.ring {\n\t-webkit-transform: translate3d(0, 0, 0);;\n\ttransform: translate3d(0, 0, 0);\n}\n";ej+="div.fsi-thumbbar-container.custom,\ndiv.fsi-thumbbar-container.ring img{\n\twill-change: transform,filter;\n}\n";ej+="div.fsi-thumbbar-container.stacks img{\n\twill-change: transform;\n}\n";ej+="div.fsi-thumbbar-container img.placeholder.none{\n\tdisplay:none;\n}\n";ej+="div.fsi-thumbbar-container img.placeholder.blank{\n\tbackground-color:#eee;\n}\n";var ek="R0lGODlhFwAXAIABAMzMzAAAACH5BAEAAAEALAAAAAAXABcAAAI5jI+py30AYwyyoiophncDvXWh9z0eiIkpqVqsOZ7wKjt2m70Gq6Nu7csBecNTjxia/ZI7I/AGjSYKADs=";ej+="div.fsi-thumbbar-root div.fsi-thumbbar-container img.placeholder.default,\ndiv.fsi-thumbbar-root div.fsi-thumbbar-container img.placeholder.custom{\n\tbackground-color:#eee;\n\tbackground-repeat:no-repeat;\n\tbackground-position:bottom center;\n\tbackground-image:url(data:image/gif;base64,"+ek+");\n}\n";ej+="div.fsi-thumbbar-shader{\n\tposition:absolute;\n\tz-index:10000;\n\tbox-sizing:border-box;\n\tbackground-color:#FFF;\n\topacity:0;\n}\n";ej+="div.fsi-thumbbar-zoom-div{\n\tposition:absolute;\n\tz-index:10001;\n\tmargin:0px!important;\n\tbox-sizing:content-box;\n\tbackground-color:#FFF;\n\tline-height:0;\n}\n";a.utils.addCSSClass(el,ej)}};var aR=function(ek){var ej;if(d6&&cv.images[ek]){ej=cv.images[ek]}return ej};var aF=function(ek){var ej=typeof(ek);if(ej==="string"){ek=window[ek];ej=typeof(ek)}return(ej==="function")?ek:false};var ar=function(){dA=b;if(ca){E="scrollTop";aC=dD;aq=cP;a2=b4}else{E="scrollLeft";aC=t;aq=d1;a2=ds}aT++;b6=dQ.Alignment;cQ=dQ.PerspectiveAlignment;if(!dQ.depthFadeout){ao=false}else{ao=(!a.isInternetExplorer||a.versionInternetExplorer>11)}var ek=Q={};if(dQ.effects.length>0){ek.effects=dQ.effects;eb="&effects="+dQ.effects}else{eb=""}if(dQ.overlays.length>0){ek.overlays=dQ.overlays}if(dQ.quality.length>0){ek.quality=dQ.quality}if(dQ.format.length>0){ek.format=dQ.format}if(dQ.fpxservertemplate.length>0){ek.renderer=dQ.fpxservertemplate}d2();aA();dR=false;if(cF.length<1){return}cf.style.display="";if(ca){cf.style.width="100%";aa=-1;cf.style.overflowX="hidden";cf.style.overflowY="auto";P.style.height=2*X.width+"px";G=(cf.offsetWidth-cf.scrollWidth);S=cf.offsetHeight}else{cf.style.height="100%";aa=1;cf.style.overflowX="auto";cf.style.overflowY="hidden";P.style.width=2*X.width+"px";G=(cf.offsetHeight-cf.scrollHeight);S=cf.offsetWidth}cf.style.display="none";cC=!dQ.ScrollBar;ag=(d4.length<2);if(ag){cC=true}T=(G>0);ch=(G>0&&!a.isChrome)?1:0;av=0;ck=0;aT++;if(d4.length!==cF.length){d4=a.utils.cloneArray(cF);if(F&&cv){cv.images=a.utils.cloneArray(F)}}b0=d4.length;bv();e=false;c9=X.width/2;b1=false;var eo=C;cD=false;ae=false;switch(C){case"stacks":cy=de;break;case"flat":cD=true;cy=c;b1=!bk;dQ.zoomCenteredImageOnly=false;if(!bk){e=true;c9=da/2}break;case"custom":var el=aF(dI.cfg.custompresentationfunction);if(el){y=el}else{y=d5}el=aF(dI.cfg.custompresentationinitfunction);if(el){ae=el}cy=a9;break;default:eo="ring";dS=(C!=="innerring");cy=bD;C="carousel";break}a.addClass(b2,eo);if(ca){c9-=ci/2}else{c9-=aP/2}var ej=(ca)?ci:aP;bt=(X.width-ej)/2/Math.sin(1);if(C!=="stacks"){var en;if(dS){en=1}else{en=0.75}bt=Math.sin(1)*(en*X.width)}bt=Math.round(bt);ac=10*Math.ceil(X.width/ej);b2.style.perspective=bt+"px";dy.width=aP;dy.height=ci;cR();a3();if(!a.isMobileDevice){cJ()}if(aM!==b){var em=aM.offsetLeft/aM.nAdvance;c8=em*da;aM=b}c8=r(c8);bS();dR=true;if(ci<1){bP.error("Insufficient instance height. Resulting image height is "+ci+"px");return}b3=b5;bQ=aG;dc()};var bv=function(){var ek=X.height;if(!cC&&T){ek-=G}var ej=ek-dQ.paddingTop-dQ.paddingBottom;if(ca){aP=ej;da=ci+cH}else{ci=ej;da=aP+cH}};var bS=function(){var ej;if(ca){ej=dQ.paddingTop+cQ*aP;b2.style.perspectiveOrigin=ej+"px "+X.width/2+"px"}else{ej=dQ.paddingTop+cQ*ci;b2.style.perspectiveOrigin=X.width/2+"px "+ej+"px"}};var dc=function(){al=b;if(ca){dy.width=Math.min(dy.width,dy.height)}else{dy.height=Math.min(dy.width,dy.height)}if(dQ.placeHolderImage.length<1){dQ.placeHolderImage="none"}var ek=dQ.placeHolderImage.toLowerCase();switch(ek){case"blank":case"default":case"custom":ad.src=dl;df="placeholder "+ek+be;dy.nMode=1;m();break;case"none":df="placeholder none"+be;m();dy.nMode=1;break;default:df="placeholder image"+be;dy.nMode=2;var el=aR(0);if(el){dM(null,el)}else{var ej=dI.getImageInfoURL(d4[ba]);dI.loadFile(ej,dM)}}ad.className=df};var dM=function(el,ej){cr(dy,ej);var ek=aB(dy.maxWidth,dy.maxHeight,aP,ci);dy.width=ek.width;dy.height=ek.height;dy.bHasPadEffect=true;dy.objCropCurrent=false;ad.src=cK(dy,dQ.placeHolderImage,{effects:dQ.placeHolderPadEffect});m()};var m=function(){if(!b8&&dQ.enableZoom){if(!cW){cW=a.addCustomEvent(az,"FSIViewport",cU);a.setCustomEventListenerProperty(cW,"treshold",150);a.setCustomEventListenerProperty(cW,"fireTresholdEventOnly",true);a.triggerCustomEvent(cW)}}else{if(cW){a.removeCustomEvent(az,"FSIViewport",cU);cW=b}}d={scope:az,elementID:A,nMaxThumbWidth:da,totalWidth:X.width,totalHeight:X.height,nPerspective:bt,nHorizontalFactor:aa};if(ae){ae.apply(this,[d])}c6();if(bk){if(b0===1){d4.push(d4[0]);if(cv&&cv.images){cv.images=cv.images.concat(cv.images)}b0++}var ek=0;while(d4.length<=bq.length+2){ek++;d4=d4.concat(d4);if(d6){cv.images=cv.images.concat(cv.images)}b0=d4.length}}c5=b0-1;av=d4.length;a3();if(cl<=0){cC=true}bv();ba=Math.max(0,Math.min(b0-1,dU));c8=r(ba*-da);if(dQ.garbageCollectionSize<0){if(a.isMobileDevice){aU=2*(dQ.preloadCount+bq.length)}else{aU=Math.max(250,6*(dQ.preloadCount+bq.length))}}else{if(dQ.garbageCollectionSize===0){aU=b0}else{aU=Math.max(dQ.preloadCount+bq.length,dQ.garbageCollectionSize)}}var ej;if(e){ej=da*b0}else{ej=X.width+(da*b0);if(!bk){ej-=da}}bi.runPersistent("onSetScrollRange",[ej,ej-X.width,bk,b0]);if(ca){P.style.height=ej+"px";if(cD){b2.style.height=ej+"px"}}else{P.style.width=ej+"px";if(cD){b2.style.width=ej+"px"}}q();bf.style.display="";if(dQ.preloadCount>0){cG.bEnabled=true;cd=bT}else{cG.bEnabled=false;cd=a.fnDoNothing()}n();if(cV){cO()}bp=a.now();if(aU<b0){bP.info("Enabling garbage collection (max. "+aU+" images)")}else{bP.info("Garbage collection disabled");bU()}br(-c8);if(cM){aj(-c8)}b7()};var cU=function(ej){aX=ej.FSI_viewport_rect;aJ=ej.FSI_client_rect_body_top};var dG=function(){if(document.querySelectorAll===b){return}var ej=dI.cfg.cmdbuttonselector;if(typeof(ej)!=="string"){return false}var em=document.querySelectorAll(ej);for(var ek=0;ek<em.length;ek++){var el=em[ek].getAttribute("x-fsi-cmd");if(typeof(el)==="string"&&el.length>0){bP.log("Registering button from config for command: "+el);az.registerButton(em[ek],el)}}dI.cfg.cmdbuttonselector=b};var cR=function(){if(b0<1){dC=dO}else{if(b1){dC=ct}else{dC=c2}}};var b7=function(){if(bi.isset("onStart")){bi.runPersistent("onStart",[dQ.dir,d4.length,a.utils.cloneArray(d4)])}aN(0);bw()};var a3=function(){cl=b0*da;if(!bk){if(C==="flat"){cl-=X.width}else{cl-=da}}};var cJ=function(){if(!X||X.width<1||X.height<1){return false}if(a.isIETouch){cx.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}if(!v){var ej={};ej.bMouseOnly=true;ej.afterTouch={enabled:true};ej.afterTouch.factorAmount=25;ej.afterTouch.factorFrames=3;ej.afterTouch.minFrames=5;ej.afterTouch.offsetFrames=1;ej.afterTouch.useAnimationFrame=true;ej.detectGestures=false;v=new a.TouchHandler(cf,ej,cp,K,dr);v.setCapture(true,false)}};var B=function(ek,ej){return ek};var cp=function(ej,em,el){c3.ts=0;bg.x=em.x;bg.y=em.y;if(G>0){var ek=a.getBoundingClientRect(cf);if(ca){if(em.x-ek.left>ek.width-G){return false}}else{if(em.y-ek.top>ek.height-G){return false}}}ei();cV=0;cancelAnimationFrame(W);W=b;c8=r(c8);v.enableAfterTouch(true);cE.bImageDragging=true;aO.startX=bg.x;aO.startY=bg.y;aO.offsetLeft=c8;D();return true};var K=function(ej,em,ek){bg.x=em.x;bg.y=em.y;if(cE.bImageDragging){if(ca){aO.dy=bg.x-aO.startX;aO.dx=bg.y-aO.startY}else{aO.dx=bg.x-aO.startX;aO.dy=bg.y-aO.startY}if(!d8){dP(true)}var el=c8;c8=r(aO.offsetLeft+aO.dx);D();if(cM){aY(-c8)}else{br(-c8)}if(el===c8||Math.abs(aO.dy)>3*Math.abs(aO.dx)){ej.FSI_allowEventDefault=true}}};var dr=function(ek,eo,em){bg.x=eo.x;bg.y=eo.y;if(cE.bImageDragging){cE.bImageDragging=false;dP(false);if(cM){br(-c8)}}var el=eo.x-ek.FSI_start_x;var ej=eo.y-ek.FSI_start_y;var en=Math.sqrt(el*el+ej*ej);c3.ts=a.now();c3.dist=en;D()};var N=function(el,em){var ej=false;em=Math.ceil(em);if(isNaN(em)||em<0){em=0}if(isNaN(el)){return false}el=el%cl;var ek=M(-el,false,em);if(ek!==false){ej=d7.end}return ej};var dW=function(ej){cE.bSetIsScrolling=ej;if(di){clearTimeout(di)}di=setTimeout(O,100)};var O=function(){dP(cE.bSetIsScrolling);di=b;cG.nLoad=dQ.preloadCount;b3()};var dP=function(ej){if(di){clearTimeout(di);di=b}if(ej===d8){return}d8=ej;if(d8){bi.run("onScrollStart",[-c8])}else{bi.run("onScrollEnd",[-c8])}};var aN=function(ej){dv=ej;a6=b;if(bi.isset("onFocus")){var ek=Y[ej];if(ek){bi.runPersistent("onFocus",[ek.nIndex,d4[ek.nIndex]])}}};var bw=function(){if(!dN||!b8||a1||!Y||!Y[ba]){return}L(Y[ba]);a1=true;co(Y[ba])};var co=function(ej){if(!ej||!b8||typeof(b8.changeImage)!=="function"){return}if(dA===ej.nIndex){return}dA=ej.nIndex;var ek={};ek.fpxsrc=d4[ej.nIndex];ek.imageWidth=ej.sourceWidth;ek.imageHeight=ej.sourceHeight;ek.cropRect=dI.cfg.croprect;ek.cropValues=dI.cfg.cropvalues;ek.effects=dI.cfg.effects;b8.changeImage(ek)};var J=function(es){if(es.bError){return}L(es);if(b8!==b){co(es);return}dw(b,true);if(!es.bReady){return}var eD=document.body.scrollWidth;var ey=document.body.scrollHeight;var eG=a.utils.getDocumentScaleWithPixelRatio();var ev=aX.left-aJ.left;var em=aX.top-aJ.top;dj=document.createElement("div");h=document.createElement("div");h.style.willChange="opacity";bM=document.createElement("img");c1.alphaShader=0;dj.setAttribute("class","fsi-thumbbar-zoom-div");dT=es.nIndex;cz=es.img.cloneNode();cz.style.transform="";cz.style.position="static";cz.style[bu]="none";var ez=a.getBoundingClientRect(es.img);cz.style.width=cz.style.height="100%";dj.appendChild(cz);document.body.appendChild(dj);var el=a.getElementClientPos(document.body);var ex=-el.left;var ew=-el.top;var eq=a.getElementBorders(dj);var eo=a.utils.getElementPaddings(dj);c1.startX=ex+ez.left-eq.left;c1.startY=ew+ez.top-eq.top;c1.startWidth=ez.width;c1.startHeight=ez.height;dj.style.width=c1.startWidth+"px";dj.style.height=c1.startHeight+"px";dj.style.left=c1.startX+"px";dj.style.top=c1.startY+"px";dj.style.willChange="left,top,width,height";var eF=a.getViewportSize(window);a.addEvent(h,"mousedown",dw,false);a.addEvent(window,"touchstart",dw,false);a.addEvent(dj,"mousedown",dw,false);a.addEvent(window,"scroll",dw,false);var eC=Math.ceil(40/eG);var ek=eF.width-eC-eq.left-eq.right-eo.left-eo.right;var eE=eF.height-eC-eq.top-eq.bottom-eo.top-eo.bottom;var et=es.maxWidth;var eB=es.maxHeight;if(ek/et<eE/eB){et=ek;eB=Math.round(et*es.maxHeight/es.maxWidth)}else{eB=eE;et=Math.round(eB*es.maxWidth/es.maxHeight)}if(et>es.maxWidth||eB>es.maxHeight){et=es.maxWidth;eB=es.maxHeight}c1.endWidth=et;c1.enddHeight=eB;c1.dWidth=et-c1.startWidth;c1.dHeight=eB-c1.startHeight;c1.endX=ev+Math.round((eF.width-et-eq.left-eq.right-eo.left-eo.right)/2);c1.endY=em+Math.round((eF.height-eB-eq.top-eq.bottom-eo.top-eo.bottom)/2);c1.dx=c1.endX-c1.startX;c1.dy=c1.endY-c1.startY;var er="left:"+ev+"px;top:"+em+"px;";if(eG===1){er+="width:100%;height:100%"}else{var en=aX.width();var eu=aX.height();if(ev+en>eD){en-=ev+en-eD}if(em+eu>ey){eu-=em+eu-ey}er+="width:"+en+"px;height:"+eu+"px"}c1.bImageReady=false;var ep=es.img.src;ep=ep.replace(a7,"$1");var ej=Math.min(es.maxWidth,Math.round(eG*et));var eA=Math.min(es.maxHeight,Math.round(eG*eB));ep+="&width="+ej+"&height="+eA;aE=true;a.addEvent(bM,"load",bH,false);bM.style.width=c1.endWidth+"px";bM.style.height=c1.endHeight+"px";bM.setAttribute("crossorigin","anonymous");bM.src=ep;c1.pos=0;c1.frames=bC(32);a.utils.setStyleAttr(h,er);h.setAttribute("class","fsi-thumbbar-shader");document.body.appendChild(h);c1.alphaShader=dQ.zoomShaderStartOpacity;cancelAnimationFrame(dn);dn=requestAnimationFrame(aS);c1.posFader=0;c1.framesShader=bC(12);c1.startAlpha=c1.alphaShader;c1.endAlpha=dQ.zoomShaderEndOpacity;c1.dAlpha=c1.endAlpha-c1.startAlpha;c1.bRemoveOnEnd=false;ap=requestAnimationFrame(f);bi.run("onZoomStart",[es.nIndex,ep]);if(!a.isMobileDevice){a.addEvent(window,"resize",dw,false)}else{a.addEvent(window,"orientationchange",dw,false)}};var bl=a.Easing.easeOutCubic;var aS=function(){c1.pos++;if(c1.pos>c1.frames){dn=b;requestAnimationFrame(cA);return}var ej=bl(c1.pos,c1.frames,c1.startX,c1.dx);var em=bl(c1.pos,c1.frames,c1.startY,c1.dy);var ek=bl(c1.pos,c1.frames,c1.startWidth,c1.dWidth);var el=bl(c1.pos,c1.frames,c1.startHeight,c1.dHeight);dj.style.left=ej.toFixed(2)+"px";dj.style.top=em.toFixed(2)+"px";dj.style.width=ek.toFixed(2)+"px";dj.style.height=el.toFixed(2)+"px";dn=requestAnimationFrame(aS)};var cA=function(){if(!dj||!c1.bImageReady||dn!==b){return}dj.replaceChild(bM,dj.firstChild);dj.firstChild.style.width=bM.style.width;dj.firstChild.style.height=bM.style.height;dj.firstChild.src=bM.src;dj.style.width="";dj.style.height="";dj.style.willChange="auto";h.style.willChange="auto";bi.run("onZoomReady",[dT,bM.src,bM]);bM=b};var bH=function(){c1.bImageReady=true;a.removeEvent(bM,"load",bH,false);aE=false;cA()};var dw=this.closeZoom=function(ej,ek){if(!dj){return}L();a6=b;if(!a.isMobileDevice){a.removeEvent(window,"resize",dw,false)}else{a.removeEvent(window,"orientationchange",dw,false)}if(ap){cancelAnimationFrame(ap);ap=b}cancelAnimationFrame(dn);dn=b;a.removeEvent(h,"mousedown",dw,false);a.removeEvent(dj,"mousedown",dw,false);a.removeEvent(window,"touchstart",dw,false);a.removeEvent(window,"scroll",dw,false);if(aE){a.removeEvent(bM,"load",bH,false)}if(bM){bM=b}a.removeChild(dj.parentNode,dj);dj=b;if(ek===true){a.removeChild(h.parentNode,h);h=b}else{h.style.willChange="opacity";c1.posFader=0;c1.framesShader=10;c1.startAlpha=c1.alphaShader;c1.endAlpha=0;c1.dAlpha=c1.endAlpha-c1.startAlpha;c1.bRemoveOnEnd=true;ap=requestAnimationFrame(f)}bi.run("onZoomEnd");if(ej&&ej.touches&&ej.touches.length===1){ej.cancelBubble=true;if(ej.stopPropagation){ej.stopPropagation()}if(ej.preventDefault){ej.preventDefault()}}dT=b};var cs=function(ej){h.style.opacity=c1.alphaShader=ej};var f=function(){c1.posFader++;if(c1.posFader>c1.framesShader){if(c1.bRemoveOnEnd){a.removeChild(h.parentNode,h);h=b}ap=b;return}var ej=bl(c1.posFader,c1.framesShader,c1.startAlpha,c1.dAlpha,3);cs(ej);ap=requestAnimationFrame(f)};var a4=function(ek,ej){if(!ek){return false}aN(ek.nIndex);return M(-ek.nIndex*da,ej,30)};var r=function(ej){if(bk){ej=Math.round(ej)%cl;if(ej>0){ej-=cl}}else{ej=Math.min(0,Math.max(-cl,ej))}return ej};var bC=function(ej){if(a.isMobileDevice){ej=Math.ceil(ej/1.3)}return ej};var M=function(en,ek,em,ej){if(ag){return}if(em===b){em=40}if(em>0){em=bC(em)}ei();if(bk&&!ek){en=r(en);c8=r(c8);var el=en-c8;if(Math.abs(el)>cl/2){if(el>0){en=-cl+en}else{en=cl+en}}}if(en===c8||(W!==b&&en===d7.end)){return false}dP(true);cancelAnimationFrame(W);W=b;d7.frames=em;d7.pos=0;d7.nScrollBarID=ej;d7.start=c8;d7.end=en;if(!ej&&((bk&&ek)||!bk)){d7.end=r(d7.end)}d7.diff=d7.end-d7.start;if(em<1){l()}else{W=requestAnimationFrame(l)}return true};var l=function(){d7.pos++;if(d7.pos>=d7.frames){c8=d7.end;if(d7.bUpdateVisibleScrollBar){bf[E]=-c8}dW(false);W=b;n();bZ();if(cM&&d7.nScrollBarID!==2){aY(-c8)}if(!d7.nScrollBarID){br(-c8)}dX();return}c8=bl(d7.pos,d7.frames,d7.start,d7.diff,3);if(!bk){c8=r(c8)}if(cM&&d7.nScrollBarID!==2){aY(-c8)}else{if(!d7.nScrollBarID){br(-c8)}}n();bZ();W=requestAnimationFrame(l)};var cw=function(el){if(d6){var ek=aR(el.nIndex);dF(el,ek)}else{if(el.sourceWidth!==b){dF(el,{width:el.sourceWidth,height:el.sourceHeight})}else{el.bInfoLoading=true;var ej=dI.getImageInfoURL(d4[el.nIndex]);dI.loadFile(ej,k,b,el)}}};var k=function(ej,ek,el){ek.width=parseInt(ek.width);ek.height=parseInt(ek.height);if(isNaN(ek.width)){dB.call(el.img)}dF(el,ek)};var cr=function(el,ej){if(el.bImageInfoCalculated){return}el.bImageInfoCalculated=true;el.nThumbnailDimWidth=aP;el.nThumbnailDimHeight=ci;el.bInfoReady=true;el.sourceWidth=ej.width;el.sourceHeight=ej.height;if(bR.bLive){H(el)}var ek=(bR.bCrop&&!el.bNoCropping);if(ek){el.rectWidth=bR.rectWidth;el.rectHeight=bR.rectHeight}el.src=eb;a.utils.expandSourceDimensionForPadEffect(el,aP,ci);if(ek){el.objCropCurrent=(el.oCrop)?el.oCrop:bR;el.maxWidth=Math.round(el.objCropCurrent.rectWidth*el.sourceWidth);el.maxHeight=Math.round(el.objCropCurrent.rectHeight*el.sourceHeight)}else{el.maxWidth=el.sourceWidth;el.maxHeight=el.sourceHeight}if(dy.nMode===1){au(el,el.maxWidth,el.maxHeight)}};var dF=function(ek,ej){if(!dN){return}if(!ej||!ek||ek.nStartID!==aT){return}cr(ek,ej);ec(ek)};var bc=function(ej){if(ca){ej.offsetX=(ci-ej.height)/2;ej.offsetY=b6*(aP-ej.width)+dQ.paddingTop}else{ej.offsetX=(aP-ej.width)/2;ej.offsetY=b6*(ci-ej.height)+dQ.paddingTop}};var cK=function(em,el,ej){if(ej===b){ej={};for(var ek in Q){ej[ek]=Q[ek]}}ej.width=em.width;if(em.objCropCurrent){ej.rect=em.objCropCurrent.query}if(em.bHasPadEffect){ej.height=em.height}return dI.getImageURL(el,ej)};var aB=function(ej,ek,el,en){var em={};if(el/ej<en/ek){em.width=Math.min(el,ej);em.height=Math.round(em.width*ek/ej)}else{em.height=Math.min(en,ek);em.width=Math.round(em.height*ej/ek)}return em};var ec=function(el){if(!el.bInfoReady||el.bThumbLoadStarted){return false}el.tsRemovedFromDOM=bp;var ej=el.img;el.nThumbnailDimWidth=aP;el.nThumbnailDimHeight=ci;el.bThumbLoadStarted=true;el.nStartID=aT;if(el.width<1||el.height<1){dB.call(ej)}else{V++;var ek=cK(el,d4[el.nIndex]);ay[el.nIndex]=el;el.bHasEvents=true;a.addEvent(ej,"load",cu);a.addEvent(ej,"error",dB);if(dI.hasImageParameterConditions){ek=dI.reWriteImageURLByConditions(ek)}el.src=ej.src=ek}return true};var au=function(em,ej,ek){var el=aB(ej,ek,aP,ci);if(el.width!==em.width||el.height!==em.height){em.width=el.width;em.height=el.height;em.img.style.width=em.width+"px";em.img.style.height=em.height+"px";em.placedX=b;bc(em);if(em.bVisible){cy(em)}}};var bn=function(ej){return(ej.nThumbnailDimWidth===aP&&ej.nThumbnailDimHeight===ci)};var af=function(ej){return(ej&&ej.nStartID===aT)};var bo=function(ej){if(ej.bHasEvents===true){delete ay[ej.nIndex];a.removeEvent(ej.img,"load",cu);a.removeEvent(ej.img,"error",dB);ej.bHasEvents=false}};var dB=function(ej){var ek=this.oSprite;if(!ek){return}ek.bReady=false;ek.bError=true;if(isNaN(ek.sourceWidth)||isNaN(ek.sourceHeight)){ek.width=ek.sourceWidth=ek.maxWidth=dy.width;ek.height=ek.sourceHeight=ek.maxHeight=dy.height;bc(ek);au(ek,ek.width,ek.height)}ek.bLoadComplete=true;ek.bThumbLoading=false;ek.img.src=dl;ek.img.className="placeholder blank error";if(af(ek)&&ej){V--}bo(ek);b3()};var cu=function(ek){var en=this.oSprite;if(!en||!dN){return}bo(en);if(en.bLoadComplete||!af(en)){return}V--;if(!bn(en)){return}var ej,em;var el=en.img;if(el.naturalWidth){ej=el.naturalWidth;em=el.naturalHeight}else{ej=el.width;em=el.height}if(ej<2&&em<2){ej=en.width;em=en.height}en.bReady=true;en.bLoadComplete=true;en.placedX=b;en.img.style.width=en.img.style.height=b;a.removeClass(en.img,df);au(en,ej,em);if(en.bVisible){dE(en)}bZ();bF[en.nIndex]=en;dh++;if(bN&&bN.nIndex===en.nIndex){L(en)}b3();if(dh>=aU){bO()}};var dE=function(ej){if(!dd){return}cS=true;bG[ej.nIndex]=ej};var d9=function(ej){if(!dd){return}cS=true;cT[ej.nIndex]=ej;bG[ej.nIndex]=b;delete bG[ej.nIndex]};var cm=function(){if(!cS){return}cS=false;var ek,ej;for(ek in bG){if(bG[ek]){dd.addImage(bG[ek].img)}}ej=[];for(ek in cT){if(cT[ek]){ej.push(cT[ek].img)}}if(ej.length>0){dd.removeImages(ej)}bG={};cT={}};var bZ=function(){if(a6===b){return}var ej=x(a6);if(!ej.bReady||!ah(ej)){return}J(ej);a6=b};var I=function(ej){if(!bi.isset("onMouseEnter")&&!bi.isset("onMouseLeave")){return}j=ej;dY={};a.addEvent(cf,"mouseleave",aV);a.addEvent(cf,"mousemove",dt)};var aV=function(){a.removeEvent(cf,"mouseleave",aV);a.removeEvent(cf,"mousemove",dt);if(o!==b){clearTimeout(o)}o=b;if(dY.nIndex!==b){bi.run("onMouseLeave",[dY.nIndex,dY])}dY={};j=b};var dt=function(ej){j=ej;dX()};var dX=function(){if(!j){return}if(o===b){o=setTimeout(cL,100)}};var cL=function(){o=b;cf.style.pointerEvents="none";b2.style.pointerEvents="all";var ek=document.elementFromPoint(j.clientX,j.clientY);cf.style.pointerEvents="all";b2.style.pointerEvents="none";var ej;if(ek&&ek.oSprite){ej=ek.oSprite.nIndex}if(dY.nIndex!==ej){if(dY.nIndex!==b){bi.run("onMouseLeave",[dY.nIndex,dY])}if(ej===b){dY={}}else{dY=ek.oSprite;bi.run("onMouseEnter",[dY.nIndex,dY])}}};var x=function(ek,em){ek%=b0;if(ek<0){ek+=b0}var el=Y[ek];if(el===b){cY++;el=Y[ek]={};el.nStartID=aT;el.nIndex=ek;el.offsetX=0;el.offsetY=ci-el.height+dQ.paddingTop}if(!el.img){var ej=el.img=ad.cloneNode(false);ej.oSprite=el;if(el.bPurged){ej.style.width=el.width+"px";ej.style.height=el.height+"px";delete el.bPurged}else{if(dy.nMode===1&&d6){cr(el,cv.images[ek])}else{el.width=dy.width;el.height=dy.height;ej.style.width=dy.width+"px";ej.style.height=dy.height+"px";bc(el)}}}if(em&&!el.bImageLoadStarted){at.push(el)}return el};var aA=function(){b3=bQ=a.fnDoNothing;if(an){clearTimeout(an);an=b}};var b5=function(){if(!an){an=setTimeout(aG,25)}};var aG=function(){if(an){clearTimeout(an);an=b}cd();while(at.length>0&&V<dx){var ej=at.shift();if(!ej.bImageLoadStarted){ej.bImageLoadStarted=true;ck++;if(ck===b0&&aU>=b0){aA()}av--;cw(ej)}}};var bz=function(el,ej){if(!bk){if(el<0||el>=b0){return 0}}var ek;var em=x(el);if(ej!==em.position){em.position=ej;ek=cy(em);if(ek&&!em.bVisible){bb(em)}em.bVisible=em.calculatedRet=ek}else{ek=em.calculatedRet;if(ek&&!em.bVisible){bb(em)}em.bVisible=ek}if(em.bVisible){bq.push(em);if(!em.bImageLoadStarted){at.push(em)}}return em.bVisible};var bD=function(en){var el,em;el=en.position/bt;em=Math.cos(el);en.z=em;if(em<0.5){return 0}en.x=c9+en.offsetX+Math.sin(el)*bt;en.y=en.offsetY;var ek=en.img.style;if(dS){aq(en.img,en.x,en.y,-bt+bt*en.z,aa*el)}else{aq(en.img,en.x,en.y,bt-bt*en.z,-aa*el)}if(ao){var ej=(Math.round(120*em)-20)/100;if(ej<0.99){ek[bu]="brightness("+ej+")"}else{ek[bu]="none"}}return 1};var de=function(el){var ej=c9+el.position+el.offsetX;if(ej+3*da<=0||ej>=X.width+3*da){return 0}ej=Math.max(-bt,Math.min(el.position,bt));var ek=el.position/bt;el.z=Math.cos(ek);el.x=c9+el.offsetX+Math.sin(ej/bt)*bt;el.y=el.offsetY;aC(el.img,el.x,el.y);el.img.style.zIndex=ac+Math.round(ac*el.z);return 1};var c=function(ej){ej.x=c9+ej.position+ej.offsetX;if(ej.x+da<=0||ej.x>=X.width){return 0}ej.x=Math.round(ej.x-c8);ej.y=ej.offsetY;if(ej.x!==ej.placedX){ej.placedX=ej.x;if(ca){ej.img.style.left=ej.y+"px";ej.img.style.top=ej.x+"px"}else{ej.img.style.left=ej.x+"px";ej.img.style.top=ej.y+"px"}}return 1};var d5=function(ej){if(ej.x+da<=0||ej.x>=X.width){return 0}return 1};var a9=function(ek){ek.x=c9+ek.position+ek.offsetX;ek.y=ek.offsetY;ek.z=0;var ej=y.apply(d.scope,[d,ek]);if(ej){a2(ek)}return ej};var ah=function(ej){return(ej&&ej.bVisible)};var c6=function(){if(at.length>0){at=[]}bq=[];var em;var ek=r(c8);em=Math.floor(-ek/da);var ej=ek%da;bz(em,ej);var el=dC(em,ej);if(cG.bEnabled){cG.nLastLeftImage=em-el+1;cG.nLastRightImage=em+el-1;if(W===b&&!d8){cG.nLoad=dQ.preloadCount}else{cG.nLoad=0}}};var bb=function(ej){if(!ej.bAppended){dq[ej.nIndex]=ej;ej.bAppended=true;b2.appendChild(ej.img);dE(ej)}};var bj=function(ej){if(ej.bAppended){ej.bAppended=false;d9(ej);b2.removeChild(ej.img);ej.tsRemovedFromDOM=bp;delete dq[ej.nIndex]}};var dO=function(){return 0};var c2=function(em,ej){var en;var el=0;var ek=0;do{el+=da;ek++;en=bz(em-ek,ej-el);en+=bz(em+ek,ej+el)}while(en>0&&ek<aW);return ek};var ct=function(em,ej){var en;var el=0;var ek=0;do{el+=da;ek++;en=bz(em+ek,ej+el)}while(en>0&&ek<aW);return ek};var bT=function(){if(!cG.nLoad||at.length>2){return}var ej=at.length;var ek=1;while(ek>0&&at.length<6&&cG.nLoad>0){ek=0;if(bk||cG.nLastLeftImage>0){x(--cG.nLastLeftImage,true);cG.nLoad--;ek++}if(bk||cG.nLastRightImage<c5){x(++cG.nLastRightImage,true);cG.nLoad--;ek++}}};var bO=function(){if(dp){return}dp=setInterval(a5,dk);bp=a.now()};var bU=function(){if(!dp){return}clearInterval(dp);dp=b};var a5=function(){bp+=dk;if(dh>aU){bW()}else{bU()}};var bW=function(){if(cE.bImageDragging||dh<=aU){return}var el=new Array(dh);var em=0;var eo,ej;for(var en in bF){eo=bF[en];if(!eo.bAppended&&eo.bReady){el[em++]=bF[en]}}el=el.splice(0,em);el.sort(cq);var ek=Math.max(0,Math.min(dh-aU,Math.min(em,50)));for(em=0;em<ek;em++){eo=el[em];ej=eo.nIndex;delete eo.img;delete eo.placedX;eo.bPurged=true;eo.bThumbLoadStarted=eo.bLoadComplete=eo.bReady=eo.bImageLoadStarted=false;delete bF[ej]}c7+=ek;dh-=ek;ck-=ek};var cq=function(ek,ej){return ek.tsRemovedFromDOM-ej.tsRemovedFromDOM};var D=function(){if(aD!==b){return}aD=requestAnimationFrame(n)};var ak=function(){if(aD!==b){cancelAnimationFrame(aD);aD=b}};var n=function(){if(!dp){bp=a.now()}if(aD!==b){cancelAnimationFrame(aD);aD=b}for(var ej in dq){dq[ej].bVisible=false}c6();for(var ej in dq){if(!dq[ej].bVisible){bj(dq[ej])}}if(cD){aC(b2,c8,0)}b3()};var cO=function(ej){if(u!==b){return}c8=r(c8);cV=Math.sign(cV)*Math.min(Math.abs(cV),Math.abs(cl)/50);cE.nAutoRotateUpdateCount=0;a.addEvent(cf,"pointerdown",ei);if(ej!==b&&!isNaN(ej)){cV=ej}u=requestAnimationFrame(g);dP(true)};var g=function(){if(bk){c8=r(c8-cV)}else{c8-=cV;if(c8>0||c8<-cl){cV=-cV;c8-=cV}}if(cM){aY(-c8)}br(-c8);D();u=requestAnimationFrame(g);dX()};var ei=function(){if(u===b){return}a.removeEvent(cf,"pointerdown",ei);cancelAnimationFrame(u);u=b;dP(false);return false};var cb=function(){var ej=a.getElementDimension(cx);if(ej.width<1){ej.width=1}if(ej.height<1){ej.height=1}if(ca){var ek=ej.width;ej.width=ej.height;ej.height=ek}return ej};var ee=function(){X=dg=cb()};var ax=function(ej){if(!dR||cF.length<1){return}if(aM===b){dU=-c8/da;c0=true;aM={};aM.offsetLeft=c8;aM.nAdvance=da;aM.nCenter=c9;ak();ei();cancelAnimationFrame(W);v.cancel();v.enable(false)}if(ej.FSI_after_treshold!==b){c0=false;v.enable(true);aA();at=[];ee();if(X.width>1&&X.height>1){db();dK();ar()}}};var t=function(ek,ej,em){ek.style.transform="translate("+ej.toFixed(2)+"px,"+em.toFixed(2)+"px)"};var dD=function(ek,em,ej){ek.style.transform="translate("+ej.toFixed(2)+"px,"+em.toFixed(2)+"px)"};var d1=function(ek,ej,eo,en,em){ek.style.transform="translate3d("+ej.toFixed(2)+"px,"+eo.toFixed(2)+"px,"+en.toFixed(2)+"px) rotateY("+em.toFixed(6)+"rad)"};var cP=function(ek,eo,ej,en,em){ek.style.transform="translate3d("+ej.toFixed(2)+"px,"+eo.toFixed(2)+"px,"+en.toFixed(2)+"px) rotateX("+em.toFixed(6)+"rad)"};var ds=function(em){var el="translate3d("+em.x.toFixed(2)+"px,"+em.y.toFixed(2)+"px,"+em.z.toFixed(2)+"px)";if(em.rx){el+=" rotateX("+em.rx.toFixed(6)+"rad)"}if(em.ry){el+=" rotateY("+em.ry.toFixed(6)+"rad)"}if(em.rz){el+=" rotateZ("+em.rz.toFixed(6)+"rad)"}if(em.sx){el+=" scaleX("+em.sx.toFixed(2)+")"}if(em.sy){el+=" scaleY("+em.sy.toFixed(2)+")"}if(em.brightness!==b&&ao){var ej=em.brightness;var ek=em.img.style;if(ej<0.99){ek[bu]="brightness("+ej+")"}else{ek[bu]="none"}}if(em.bSetZIndex){em.img.style.zIndex=ac+Math.round(ac*em.z/bt)}em.img.style.transform=el};var b4=function(em){var el="translate3d("+em.y.toFixed(2)+"px,"+em.x.toFixed(2)+"px,"+em.z.toFixed(2)+"px)";if(em.rx){el+=" rotateY("+em.rx.toFixed(6)+"rad)"}if(em.ry){el+=" rotateX("+em.ry.toFixed(6)+"rad)"}if(em.rz){el+=" rotateZ("+em.rz.toFixed(6)+"rad)"}if(em.sx){el+=" scaleY("+em.sx.toFixed(2)+")"}if(em.sy){el+=" scaleX("+em.sy.toFixed(2)+")"}if(em.brightness!==b&&ao){var ej=em.brightness;var ek=em.img.style;if(ej<0.99){ek[bu]="brightness("+ej+")"}else{ek[bu]="none"}}if(em.bSetZIndex){em.img.style.zIndex=ac+Math.round(ac*em.z/bt)}em.img.style.transform=el};var H=function(ek){var ej=ek.oCrop={};cZ(ej,"rectLeft",ek.sourceWidth,0);cZ(ej,"rectTop",ek.sourceHeight,0);cZ(ej,"rectRight",ek.sourceWidth,1);cZ(ej,"rectBottom",ek.sourceHeight,1);ej.rectWidth=1-ej.rectRight-ej.rectLeft;ej.rectHeight=1-ej.rectBottom-ej.rectTop;ej.bCrop=true;ej.query=ej.rectLeft+","+ej.rectTop+","+ej.rectWidth+","+ej.rectHeight};var cZ=function(eo,el,em,ek){var en=bR[el];if(typeof(en)!=="string"){eo[el]=en;return}var ej=parseInt(en);if(isNaN(ej)){eo[el]=ek;return}ej=Math.max(0,Math.min(em,ej));eo[el]=ej/em};var aZ=function(el,ek){el=el.toLowerCase();var ej=ek;if(el.indexOf("px")!==-1){ej=parseInt(el);if(isNaN(ej)||ej<=0){ej=ek}else{ej=""+ej+"live";bR.bLive=true}}else{if(el.indexOf("%")!==-1){ej=Math.max(0,Math.min(100,parseFloat(el)));ej/=100;if(isNaN(ej)||ej<0){ej=ek}}else{ej=Math.max(0,Math.min(1,parseFloat(el)));if(isNaN(ej)||ej<0){ej=ek}}}return ej};var s=function(){var ek;var el=bR;el.rectWidth=el.rectHeight=1;el.rectLeft=el.rectTop=0;el.bCrop=bR.bLive=false;el.query="";if(dQ.cropValues&&dQ.cropValues.length>6){ek=dQ.cropValues.split(",");el.rectLeft=aZ(ek[0],0);el.rectTop=aZ(ek[1],0);el.rectRight=aZ(ek[2],0);el.rectBottom=aZ(ek[3],0);el.rectWidth=1-el.rectRight-el.rectLeft;el.rectHeight=1-el.rectBottom-el.rectTop;el.bCrop=true;if(!el.bLive){el.query=el.rectLeft+","+el.rectTop+","+el.rectWidth+","+el.rectHeight}}else{if(dQ.cropRect&&dQ.cropRect.length>6){ek=dQ.cropRect.split(",");if(ek.length>3){while(ek.length>4){ek.pop()}for(var ej=0;ej<ek.length;ej++){ek[ej]=parseFloat(ek[ej])}var em=ek[0]*ek[1]*ek[2]*ek[3];if(isNaN(em)){return}el.rectLeft=ek[0];el.rectTop=ek[1];el.rectRight=ek[2];el.rectBottom=ek[3];el.rectWidth=ek[2]-ek[0];el.rectHeight=ek[3]-ek[1];el.bCrop=true;el.query=el.rectLeft+","+el.rectTop+","+el.rectWidth+","+el.rectHeight}}}};var bx=function(el){if(ce>0){for(var em in bV){var ej=bV[em];for(var ek=0;ek<ej.length;ek++){if(!el||ej[ek].bByConfig){az.unRegisterButton(ej[ek].el)}}}}};var L=function(ej){if(bN&&bN.img){a.removeClass(bN.img,"fsi-selected-thumb")}if(ej){if(ej.img){a.addClass(ej.img,"fsi-selected-thumb")}bN=ej}else{bN=b}};var dz=function(ej){if(!dN){return}dN=false;L();if(cW!==b){a.removeCustomEvent(az,"FSIViewport",cU);cW=b}bx();bU();if(dI){dI.destroy()}if(dd!==b){clearInterval(aw);dd.destroy();dd=b}if(di){clearTimeout(di);di=b}w();d3();cN.removeAttribute("x-fsi-id");aA();for(var ek in ay){bo(ay[ek])}ay={};if(eh!==b){a.removeCustomEvent(cN,"FSIElementDimension",ax);eh=b}at=[];ei();a6=b;dw(b,true);dv=0;cancelAnimationFrame(dn);cancelAnimationFrame(aD);aD=b;cancelAnimationFrame(W);W=b;cancelAnimationFrame(ap);ap=b;bq=[];cG={};if(v){v.destroy();v=b}c8=aK=0;a0=b;d4=[];bR={};V=0;a.removeChild(cx.parentNode,cx);if(bi){bi.run("onDestroy");bi.destroy()}};var cB=function(){if(!W){return c8}else{return d7.end}};this.init=bK;this.destroy=dz;this.getInitDone=function(){return dN};this.addListener=function(em,ek,el){var ej=false;if(bi){ej=bi.addListener(em,ek,el)}return ej};this.changeDir=function(ej){return ed(ej)};this.removeListener=function(el,ek){var ej=false;if(bi){ej=bi.removeListener(el,ek)}return ej};this.getImageCount=function(){return du};this.setScrollPos=N;this.getScrollPos=function(){return -c8};this.isScrolling=function(){return d8};this.firstImage=function(ej){M(0,false,ej)};this.lastImage=function(ej){var ek=(bk)?-cl+da:-cl;M(ek,false,ej)};this.previousPage=function(ej){M(cB()+X.width,false,ej)};this.nextPage=function(ej){M(cB()-X.width,false,ej)};this.nextImage=function(ej){M(cB()-da,false,ej)};this.previousImage=function(ej){M(cB()+da,false,ej)};this.assignFSIViewer=function(ej){var ek=ej;if(ek&&typeof(ek)==="string"){if(ek.toLowerCase()==="auto"){var el=document.getElementsByTagName("fsi-viewer");if(el&&el.length>0){ej=el[0]}else{ej=b}}else{ej=document.querySelector(ek);if(!ej){ej=document.getElementById(ek)}}}if(!ej||typeof(ej.changeImage)!=="function"){b8=b}else{b8=ej}a1=false;bw()};this.focusImage=function(ej){if(ej<0||ej>=d4){return false}var ek=x(ej);a4(ek);return true};this.startAutoRotate=cO;this.stopAutoRotate=ei;this.zoomImage=function(ej){if(!dQ.enableZoom||!this.focusImage(ej)){return false}var ek=x(ej);a6=ek.nIndex;bZ()};this.destroyOnDetach=function(){if(dQ&&dQ.autoDestroy!==false){dz()}};var z={lastimage:{fn:this.lastImage,bSingleCommand:true},firstimage:{fn:this.firstImage,bSingleCommand:false},nextimage:{fn:this.nextImage},previousimage:{fn:this.previousImage},nextpage:{fn:this.nextPage,ntRepeat:350},previouspage:{fn:this.previousPage,ntRepeat:350}};var bB=this.buttonDown=function(ej){if(typeof(ej)!=="string"){return false}ej=ej.toLowerCase();if(!z[ej]){return false}if(dZ.cmd){if(ej===dZ.cmd){return false}am()}if(z[ej].ntRepeat){dZ.ntRepeat=z[ej].ntRepeat}else{dZ.ntRepeat=125}dZ.fn=z[ej].fn;dZ.bSingleCommand=z[ej].bSingleCommand;dZ.cmd=ej;dZ.repeat=0;dZ.nInterval=setInterval(eg,350);eg()};var eg=function(){dZ.fn.apply(az);dZ.repeat++;if(dZ.bSingleCommand){am()}else{if(dZ.repeat===2){clearInterval(dZ.nInterval);dZ.nInterval=setInterval(eg,dZ.ntRepeat)}}};var am=this.buttonUp=function(){if(dZ.nInterval){clearInterval(dZ.nInterval)}dZ.cmd=b};this.registerButton=function(ek,em,en){if(typeof(ek)==="string"){ek=document.getElementById(ek)}if(!ek||typeof(ek)!=="object"||typeof(ek.tagName)!=="string"){return false}em=em.toLowerCase();if(!z[em]){return false}if(!ek.x_fsi_thumbbar_cmd_count){ek.setAttribute("x-fsi-thumbbar-cmd",em);ek.x_fsi_thumbbar_cmd_count=1}else{ek.x_fsi_thumbbar_cmd_count++}a.addEvent(ek,"contextmenu",a.preventDefaultEvent);a.addEvent(ek,"mousedown",bY);if(a.isEventSupported("touchstart")){a.addEvent(ek,"touchstart",bY)}ce++;var ej=bV[em];if(ej===b){ej=bV[em]=[]}ej.push({el:ek,bByConfig:en});return true};this.changeConfig=cI;var bI=function(ej){a.addEvent(window,"mouseup",bJ);if(a.isEventSupported("touchstart")){a.addEvent(ej,"touchcancel",bJ);a.addEvent(ej,"touchend",bJ)}};var i=function(ej){a.removeEvent(window,"mouseup",bJ);if(a.isEventSupported("touchstart")){a.removeEvent(ej,"touchcancel",bJ);a.removeEvent(ej,"touchend",bJ)}};this.unRegisterButton=function(ej){if(typeof(ej)==="string"){ej=document.getElementById(ej)}if(!ej||typeof(ej)!=="object"||typeof(ej.tagName)!=="string"||!ej.x_fsi_thumbbar_cmd_count){return false}if(--ej.x_fsi_thumbbar_cmd_count===0){ej.x_fsi_thumbbar_cmd_count=b;ej.removeAttribute("x-fsi-thumbbar-cmd")}a.removeEvent(ej,"mousedown",bY);if(a.isEventSupported("touchstart")){a.removeEvent(ej,"touchstart",bY)}i(ej);ce--;return true};var bJ=function(){if(c4){a.removeClass(c4,"fsi-pressed")}am();i(c4);c4=b};var bY=function(ej){if(c4){bJ()}var ek=ej.target||ej.srcElement;if(!ek||!ek.getAttribute("x-fsi-thumbbar-cmd")){return}c4=ek;bI(ek);var em=ek.getAttribute("x-fsi-thumbbar-cmd");a.addClass(ek,"fsi-pressed");bB(em);a.preventDefaultEvent(ej);return true};if(typeof(cn)!=="object"||a.makeBool(cn.autoInit,true)){az.init(dL,cn)}};a.customTags.register("fsi-thumbbar",{constructorClass:a.ThumbBar,viewerCSS:"display:block;width:300px;height:300px;"});a.dispatchEvent("FSIThumbBarLoaded")}(window.$FSI=window.$FSI||{}));