/*!
 * FSI Image Flow
 * Build: 18.07.06.1
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};k.getElementMargins=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.marginLeft);i.top=parseFloat(q.marginTop);i.right=parseFloat(q.marginRight);i.bottom=parseFloat(q.marginBottom)}catch(r){}return i};k.getElementBorders=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.borderLeftWidth);i.top=parseFloat(q.borderTopWidth);i.right=parseFloat(q.borderRightWidth);i.bottom=parseFloat(q.borderBottomWidth)}catch(r){}return i};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r===undefined)?"":strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2018",strBuild:"18.07.06.1"});this.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};this.cloneArray=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.urlDecode=function(str){if(!str){return str}var ret=str.replace(regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return window.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var f={};var e=false;var d=this.initCustomTags=function(){if(a.BrowserSupports.registerElement()){return false}for(var g in f){c(g)}return true};var c=this.initCustomTag=function(k){if(a.BrowserSupports.registerElement()){return false}var j=f[k];if(!j){return false}var g=document.getElementsByTagName(k);if(g.length>0){j.replaceTagInit()}if(g&&g.length>0){for(var h=0;h<g.length;h++){j.replaceTag(g[h])}}return true};this.register=function(h,g){if(f[h]===b){f[h]=new a.CustomTag(h,g);if(!e){e=true;if(!a.BrowserSupports.registerElement()){a.addEvent(window,"DOMContentLoaded",d)}}}return f[h]}};a.CustomTag=function(e,c){var k=this;var f;var j=function(){if(a.BrowserSupports.registerElement()){i()}};var d=function(m,n){var l=m.getAttribute(n);if(typeof(l)==="string"&&l.length>0){if(!l.match(/[^0-9\s]/)){l+="px"}m.style[n]=l}};var h=function(l){d(l,"width");d(l,"height")};var g=function(o){var l=a.utils.attributes2parameters(o);if(c.parameterAliases){var p=c.parameterAliases;for(var n in p){var m=p[n];if(l[n]!==b&&l[m]===b){l[m]=l[n]}}}if(l.src!==b&&l.imagesrc===b){l.imagesrc=l.src}return l};var i=function(){a.utils.addViewerClassCSSRule(e,c.viewerCSS);var l=Object.create(HTMLDivElement.prototype);l.createdCallback=function(){h(this);c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};l.attachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}this.init(this,g(this));if(this.start){this.start()}};l.detachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};document.registerElement(e,{prototype:l})};this.replaceTag=function(l){if(!l||(typeof(l.getInitDone)==="function"&&l.getInitDone())){return}h(l);c.constructorClass.prototype.constructor.call(l,l,g(l));if(l.start){l.start()}};this.replaceTagInit=function(){if(f){return}f=true;a.utils.addViewerClassCSSRule(e,c.viewerCSS)};j()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(ai,w,e){if(typeof(e)!=="object"){e={}}if(!w||typeof(w)!=="object"){w={}}var m=this;this.parameters=(ai&&typeof(ai)==="object")?ai:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Y=false;var N={};var A=0;var q;var ac={};var H=m.debug=new a.EmptyDebugger();var D=false;var x={};var an=false;var S={stickynotes:"bookmarks"};var f;var X=false;var s;var K;var ae;var c;var l;var u="token";var v;var o;if(a.isInternetExplorer&&a.versionInternetExplorer<10){o=function(ap){var ao;if(!a.utils.isCrossDomain(ap)){an=false;ao=new XMLHttpRequest()}else{an=true;ao=new XDomainRequest()}return ao}}else{if(typeof(XMLHttpRequest)!=="undefined"){o=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(aq){m.reset();s=(typeof(e.strSection)==="string")?e.strSection:"";K=s.toLowerCase();if(typeof(e.strTraceParam)==="string"){var ao=e.strTraceParam.toLowerCase();c={};c[ao]=true;if(ao.indexOf("_")>0&&ao.indexOf("pages")===0){ao=ao.split("_");ao.shift();ao=ao.join("_");c[ao]=true}var ap=m.getParameterAlias(ao);if(ap){c[ap]=true}}else{c=false}if(aq){if(m.parameters){m.parameters=a.utils.mergeObjects(m.parameters,aq)}else{m.parameters=aq}}ah(m.parameters);m.getQueryParameters();m.cloneParameters(m.cfgDefaults,m.cfg);m.cloneParameters(m.queryParameters,m.cfg);m.elevateToHTTPS();d();m.locationFSIViewer="";if(m.queryParameters.fsiviewerlocation!==b){m.locationFSIViewer=m.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());m.locationFSIViewer=a.getViewerLocation()}if(m.locationFSIViewer.charAt(m.locationFSIViewer.length-1)!=="/"){m.locationFSIViewer+="/"}m.nextConfigURL=m.getReloadPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.defaultcfg));m.checkDebug(false)};var ah=this.makeObjectPropertiesLowerCase=function(ao){for(var ap in ao){var aq=ap.toLowerCase();if(ap!==aq){if(ao[aq]===b){ao[aq]=ao[ap]}delete ao[ap]}}};this.getClassParameters=function(){return ae};this.setAccessToken=function(ao){v=ao};this.getParameterAlias=function(aq){var ao;if(m.cfgAliasNames[aq]){ao=m.cfgAliasNames[aq]}else{for(var ap in m.cfgAliasNames){if(m.cfgAliasNames[ap]===aq){ao=ap;break}}}return ao};var d=function(){Y=m.makeBool(m.cfg.usenc,false);if(m.cfg.usencquery!==b&&m.cfg.usencquery.length>0){D=m.cfg.usencquery;Y=true;m.queryToObject("?"+D,x)}};this.stopPendingRequests=function(){for(var ap in N){var ao=N[ap];if(ao){ao.FSIaborted=true;if(ao.abort){ao.abort()}}}};this.destroy=function(){m.stopPendingRequests()};this.reset=function(){ae={};m.parameters={};H=m.debug=new a.EmptyDebugger();m.stopPendingRequests();q=Math.random();m.nIncludedConfigs=0;m.completedConfigs={};m.plugins={};m.cfg={};m.queryParameters=b;m.arUnrecognizedConfigNodes=[];aj=0;m.arConditions=[];ac={}};this.getQueryParameters=function(){if(m.queryParameters!==b){return}m.queryParameters={};m.cloneParameters(m.parameters,m.queryParameters)};this.makeBool=function(ar,ao){if(typeof(ao)!=="boolean"){ao=false}var ap=ao;switch(typeof(ar)){case"string":var aq=a.makeBool(ar);if(aq!==b){ap=aq}break;case"number":ap=Boolean(ar);break;case"boolean":ap=ar;break}return ap};this.parsePositionParameter=function(ap){if(typeof(ap)!=="string"||ap.length<3){return b}ap=ap.split(",");if(ap.length<3){return b}for(var ao=0;ao<3;ao++){ap[ao]=parseFloat(ap[ao]);if(isNaN(ap[ao])){ap[ao]=0}}return{x:ap[0],y:ap[1],z:ap[2]}};this.logLoadFileFailed=function(ao){if(!H.on){return}if(ao&&ao.status!==b){var aq="HTTP "+ao.status;if(ao&&ao.statusText){aq+=", "+ao.statusText}var ap=(ao._url)?ao._url:"";H.error("Failed to load "+ap+" ("+aq+")")}else{H.error("Failed loading a file");if(ao&&ao._url){H.error(ao._url)}}};this.getAttributeValue=function(ap,ao){if(!ap){return}return ap.getAttribute(ao)};this.getImageURL=function(aq,ao){var ap;if(aq===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="image"}if(ao.renderer===b){ao.renderer="jpeg"}if(v){ao[u]=v}ao.source=aq;for(ap in ac){if(ac[ap]!==b&&ao[ap]===b){ao[ap]=ac[ap]}}for(ap in aa){if(ao[ap]){if(aa[ap]!==ap){if(!ao[aa[ap]]){ao[aa[ap]]=ao[ap]}ao[ap]=null}}}return m.requestBase+"?"+m.objectToQuery(ao)};this.getImageInfoURL=function(ap,ao){if(ap===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="info"}if(ao.tpl===b){if(m.cfg.fpxinfotemplate!==b){ao.tpl=m.cfg.fpxinfotemplate}else{ao.tpl="info.json"}}if(m.cfg.headers&&m.cfg.headers.length>0){ao.headers=m.cfg.headers}if(!ao.tpl.match(/.json$/)){ao.tpl+=".json"}ao.source=ap;if(v){ao[u]=v}return m.requestBase+"?"+m.objectToQuery(ao)};this.queryToObject=function(at,aq){if(aq===b){aq={}}var ar,av,au,ao,ap;ar=at.indexOf("?");if(ar!==-1){ap=at.slice(ar+1)}else{ap=""}ar=ap.indexOf("#");if(ar!==-1){ap=ap.substring(0,ar)}ap=ap.split("&");for(ar=0;ar<ap.length;ar++){av=ap[ar].split("=");au=a.utils.urlDecode(av[0]).toLowerCase();if(au.length>0){ao=a.utils.urlDecode(av[1]);aq[au]=ao}}return aq};this.parseSceneSets=function(ao,at){var aA={};if(at===b){at=true}var aF=[];var aD=0;var aB=0;var aq;var av,au,ar,az,ax,aE;var aw,ay,aC;var ap=m.cfg.scenesets;if(ao>1&&ap!==b&&typeof(ap)==="string"){ay=ap.split(";");for(av=0;av<ay.length;av++){aC=[];aw=ay[av].split(",");aB=0;for(au=0;au<aw.length;au++){aE=aw[au].split("-");az=ax=0;if(aE.length===1){az=parseInt(aE[0])}else{az=parseInt(aE[0]);if(isNaN(az)){az=1}aq=false;if(aE[1].charAt(0)===">"){aE[1]=aE[1].substr(1);if(!isNaN(parseInt(aE[1]))){aq=true}}ax=parseInt(aE[1]);if(isNaN(ax)){ax=ao}if(az>0&&ax>0&&az<=ao&&ax<=ao){if(aq===true||az!==ax){if(aq!==true){if(ax<az){for(ar=az;ar>=ax;ar--){aC[aB]=ar;aB++}}else{for(ar=az;ar<=ax;ar++){aC[aB]=ar;aB++}}}else{for(ar=az;ar<=ao;ar++){aC[aB]=ar;aB++}for(ar=1;ar<=ax;ar++){aC[aB]=ar;aB++}}}}}if(az>0&&az<=ao&&(ax===0||ax===az)){aC[aB]=az;aB++}}if(aB>0){aF[aD]={};aF[aD].arScenes=[];aF[aD].arScenes=aF[aD].arScenes.concat(aC);aD++}}}if(aD===0){aA.bDefault=true;if(at){aF[0]={};aF[0].arScenes=[];for(av=0;av<ao;av++){aF[0][av]=av}}}aA.nSceneSets=aD;aA.bHasMultipleSets=(aA.nSceneSets>1);aA.arSets=aF;aA.nCurrent=1;return aA};this.objectToQuery=function(ap){var ao=[];var at,aq;if(Y&&D!==false){for(at in x){ap[at]=x[at]}}for(at in ap){aq=ap[at];if(aq!==null){aq=encodeURIComponent(aq);ao.push(encodeURIComponent(at)+"="+aq)}}return ao.join("&")};this.loadImageInfo=function(ar,ao,aq){var ap=m.getImageInfoURL(ar);m.loadFile(ap,ao,b,aq)};this.loadFile=function(at,ar,aq,ax,aw,ap,au){if(!at||at.length<0){if(ar){setTimeout(function(){ar(null,"",ax)},0)}return}if(aw===b){aw="GET"}if(ap===b){ap=null}else{if(typeof(ap)==="object"){ap=m.objectToQuery(ap)}}if(aq===b){aq="application/json"}var av=o(at);if(aq&&av.overrideMimeType){av.overrideMimeType(aq)}av._url=at;var ao=A;N[A]=av;A++;if(an){av.onerror=function(){delete N[ao];if(ar===b||this.FSIaborted){return}m.logLoadFileFailed(this)};av.onload=function(){delete N[ao];if(ar===b||this.FSIaborted){return}var ay=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var az=new ActiveXObject("Microsoft.XMLDOM");az.async=false;az.loadXML(ay);ay=this.responseXML=az}catch(aA){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(at)}break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(aA){H.error("Failed parsing JSON from URL: "+at+" ("+aA.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}else{av.onreadystatechange=function(){var ay;if(av.readyState!==4){return}delete N[ao];if(this.FSIaborted||typeof(ar)!=="function"){return}if(this.status>299){m.logLoadFileFailed(this)}switch(aq){case"application/xml":case"text/xml":ay=this.responseXML;break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(az){H.error("Failed parsing JSON from URL: "+at+" ("+az.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}av.open(aw,at,true);if(au&&v){av.setRequestHeader("x-token",v)}if(ap){av.setRequestHeader("Content-type","application/x-www-form-urlencoded");av.send(ap)}else{av.send()}return av};this.loadConfigs=function(){ae=(s.length>0)?{}:false;f=true;m.loadNextConfig(true)};this.loadNextConfig=function(ap){if(m.nextConfigURL===b){W();return}var aq={};if(e.bPreventCaching||m.makeBool(m.cfg.debug)||(!ap&&!m.makeBool(m.cfg.configcaching,true)&&m.makeBool(m.cfg.enableconfigcachingparameter))){m.addNoCacheParams(aq)}m.finishRequestParams(aq);var ao=m.addURLParameters(m.nextConfigURL,aq);H.log("Loading config file: "+ao);m.loadFile(ao,E,"application/xml")};this.setDebugger=function(ao){H=m.debug=ao};this.checkDebug=function(aq){if(e.bNoDebug){return}var ap;var ao;if(m.parameters.debug!==b){ao=m.makeBool(m.parameters.debug)}else{ao=m.makeBool(m.cfg.debug)}if(ao){if(!H||!H.on){H=m.debug=new a.Debugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}else{if(!H||H.on===true){H=m.debug=new a.EmptyDebugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}return ap};var E=function(ao){var aq=ao.responseXML;l=m.nextConfigURL;m.parseConfig(aq);l=b;m.elevateToHTTPS();if(m.checkDebug(true)===true){return}d();if(f&&e.bCaptureDefaultCfg){f=false;m.cfgFromDefaultConfig=a.utils.cloneValue(m.cfg)}var ap;if(m.cfg.includeconfig!==b&&m.nIncludedConfigs<10){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.includeconfig));m.nIncludedConfigs++;m.cfg["_includeconfig("+m.nIncludedConfigs+")"]=m.cfg.includeconfig;m.cfg.includeconfig=b}else{if(m.cfg.cfg!==b){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.cfg))}}if(ap!==b&&!m.completedConfigs[ap]){m.completedConfigs[ap]=true;m.nextConfigURL=ap;m.loadNextConfig()}else{m.evaluateQuery(m.queryParameters,m.cfg);W()}};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!m.makeBool(m.cfg.autoelevatetohttps,true)){return}h("fpxbase");h("fpxserver")};var h=function(ao){if(m.cfg[ao]!==b&&m.cfg[ao].length>0&&m.cfg[ao].indexOf("http://")===0){m.cfg[ao]="https"+m.cfg[ao].substr(4)}};this.evaluateQuery=function(ap,ao){for(var aq in ap){m.setConfigParamByValue(ao,aq.toLowerCase(),ap[aq])}};this.parseConfig=function(ap,aq){var aA="";var au;var aw=false;if(ap!==b){if(aq===b){aq=ap.firstChild}if(aq&&aq.nodeName==="xml"){aq=aq.nextSibling}var az=aq.childNodes;for(var av=0;av<az.length;av++){var at=az[av];if(at.nodeType!==1){continue}var ax;if(at._myTagName!==b){ax=at._myTagName}else{ax=at.nodeName.toLowerCase()}aA=ax;var ar=at.childNodes;aw=false;switch(ax){case"licence":break;case"if":m.arConditions.push(at);break;case"plugins":for(au=0;au<ar.length;au++){m.parsePluginNode(ar[au])}break;case K:aw=true;case"info":case"options":aA=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(au=0;au<ar.length;au++){var ay=ar[au];if(ay.nodeType!==1){continue}if(ay.tagName==="if"){ay._myTagName=ax;m.arConditions.push(ay)}else{var ao=m.getValueFromXMLNode(ay,aA);if(aA===b&&ae){if(aw){m.setConfigParam(ae,ao,null,true);m.setConfigParam(m.cfg,ao,ay)}else{if(ae[ao.name]===b){m.setConfigParam(m.cfg,ao,ay)}}}else{m.setConfigParam(m.cfg,ao,ay)}}}break;default:m.arUnrecognizedConfigNodes.push(at)}}}};this.getData=function(){var ao={};ao.cfg={};for(var ap in m.cfg){ao.cfg[ap]=m.cfg[ap]}return ao};this.setData=function(ao){if(!ao||!ao.cfg){return}m.cfg={};this.setCfgValues(ao.cfg)};this.setCfgValues=function(ao){for(var ap in ao){m.cfg[ap]=ao[ap]}V()};this.getImagesNodeList=function(aq){var ao=[];if(aq===b){aq=m.getUnrecognizedConfigNode("images")}if(aq){var ar=aq.firstChild;while(ar){if(ar.nodeType===1){var ap={};ap.attributes={};M(ar,ap.attributes);ap.cfg={};m.parseConfigFragment(ar,ap.cfg);ao.push(ap)}ar=ar.nextSibling}}return ao};this.removeUnrecognizedConfigNodes=function(){m.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ar){var ao;ar=ar.toLowerCase();for(var ap=m.arUnrecognizedConfigNodes.length-1;ap>-1;ap--){var aq=m.arUnrecognizedConfigNodes[ap];if(aq&&aq.nodeName.toLowerCase()===ar){ao=aq;break}}return ao};this.parseConfigFragment=function(ap,aw,av){var aA="";if(ap!==b&&aw!==b){if(av===b){av=[]}var az=ap.childNodes;for(var au=0;au<az.length;au++){var ar=az[au];if(ar.nodeType!==1){continue}var ax=ar.nodeName.toLowerCase();aA=ax;var aq=ar.childNodes;switch(ax){case"info":case"options":aA=b;case"fpx":case"image":case"include":for(var at=0;at<aq.length;at++){var ay=aq[at];if(ay.nodeType!==1){continue}var ao=m.getValueFromXMLNode(ay,aA);m.setConfigParam(aw,ao,ay)}break;default:av.push(ar)}}}};this.findXMLNode=function(ap,ao){if(ap===b||ap.nodeType===b){return b}while(ap){if(ap.nodeName.toLowerCase()===ao){break}if(ap.firstChild){ap=ap.firstChild}else{if(ap.nextSibling){ap=ap.nextSibling}else{ap=ap.parentNode.nextSibling}}}return ap};this.getValueFromXMLNode=function(aq,ao){if(!aq||aq.nodeType!==1){return}var ap={};var ar=(ao)?ao:"";ap.name=ar+aq.nodeName.toLowerCase();var at=aq.getAttribute("value");if(at){ap.value=at;return ap}ap.value=m.XMLChildNodesToString(aq);ap.node=aq;return ap};this.getXMLNodeAttribute=function(ar,aq,ao){if(!ar||ar.nodeType!==1||!ar.getAttribute){return ao}var ap=ar.getAttribute(aq);if(ap===b||ap==null){ap=ao}return ap};this.XMLChildNodesToString=function(aq,ap){var ao="";if(!aq||!aq.firstChild){return ao}if(aq.childNodes.length===1&&aq.firstChild.nodeType===3){ao=aq.firstChild.nodeValue}else{ao=aq.innerHTML}if(ap!==b){ao=ao.replace(/[\x00-\x1f]/g,ap)}return ao};this.hasPlugin=function(ao){return(m.plugins&&m.plugins[ao]!==b)};this.getPluginParameter=function(av,ap,ao,au,aw){av=av.toLowerCase();ap=ap.toLowerCase();if(m.plugins[av]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+av+"."+ap);return ao}var at;var ar=av+"_"+ap;if(aw&&m.cfg[ar]===b){ar=ap}if(m.cfg[ar]!==b){at=m.cfg[ar]}else{if(ae&&ae[ap]!==b&&K==="pages"){at=ae[ap]}else{var aq=m.plugins[av].parameters;if(aq!==b&&aq[ap]!==b){at=aq[ap]}}}if(at===b){at=ao}if(au){at=m.makeBool(at,ao)}return at};var Q=this.getAllPluginParameters=function(ap){ap=ap.toLowerCase();var aq=a.utils.cloneObject(m.plugins[ap].parameters);var at=ap+"_";var ao=at.length;for(var au in m.cfg){if(au.toLowerCase().indexOf(at)===0){var ar=au.substr(ao);aq[ar]=m.cfg[au]}}return aq};this.getIntParameterMinMax=function(ap,aq,ao,ar){return Math.min(ar,Math.max(ao,m.getIntParameter(ap,aq)))};this.getIntParameter=function(ap,aq){var ao=parseInt(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};this.getStringParameter=function(ap,aq){var ao=m.cfg[ap.toLowerCase()];if(ao===b){ao=aq}return ao};this.getFloatParameter=function(ap,aq){var ao=parseFloat(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};var M=function(au,ap){if(!au||!au.attributes||!au.attributes.length||!ap){return false}var aq=au.attributes;for(var at=0;at<aq.length;at++){var ao=aq[at];var ar=ao.nodeName.toLowerCase();ap[ar]=ao.value}return true};this.parsePluginNode=function(aq){if(aq.nodeType!==1){return}var at={};M(aq,at);var ar=aq.childNodes;for(var ao=0;ao<ar.length;ao++){var au=ar[ao];if(au.nodeType!==1){continue}var ap=m.getValueFromXMLNode(au);if(ap.value!==b){at[ap.name]=ap.value;if(ap.node!==b){at[ap.name+".node"]=ap.node}}}this.addPluginFromString(at.src,at)};this.clone=function(){var ao=new a.Config(ai,w,e);ao.init();ao.cfg=a.utils.cloneObject(m.cfg);ao.plugins=a.utils.cloneObject(m.plugins);ao.arPlugins=a.utils.cloneArray(ao.arPlugins);ao.arUnrecognizedConfigNodes=a.utils.cloneArray(ao.arUnrecognizedConfigNodes);ao.setImageQueryParameters(ac);ao.arConditions=a.utils.cloneArray(m.arConditions);ao.hasImageParameterConditions=m.hasImageParameterConditions;return ao};this.setImageQueryParameters=function(ao){ac=a.utils.cloneObject(ao)};this.addPluginsFromString=function(aq){if(typeof(aq)!=="string"||aq.length<1){return}var ao=aq.split(",");for(var ap=0;ap<ao.length;ap++){var ar=a.trim(ao[ap]);m.addPluginFromString(ar)}};this.addPluginFromString=function(ar,at){if(typeof(ar)!=="string"||ar.length<1){H.error("PLUGIN without src parameter:");return}ar=ar.toLowerCase();if(S[ar]!==b){ar=S[ar]}if(at===b){at={}}var ap=m.plugins[ar]={};ap.name=ar;if(at.src===b){at.src=ar}ap.parameters=at;if(c){for(var au in c){if(au.indexOf(ar+"_")===0){var aq=ar+"_";var ao=au.substr(aq.length);if(typeof(ap.parameters[ao])!=="undefined"){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log(ap.parameters[ao]);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}else{if(au===ar){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log("(enabled)");m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ap,aq,ao){m.setConfigParam(ap,{name:aq.toLowerCase(),value:ao})};var U=function(ap){if(ap.nodeType!==1){return"<unknown>"}var ao=m.XMLSerializer.serializeToString(ap.cloneNode(false));ao=ao.replace(/\/>$/gi,">");return ao};this.setConfigParam=function(ar,ao,at,au){var aw=ao.name;var ay=ao.value;if(!aw){return}if(c){for(var ax in c){if(ax===aw&&!au){if(typeof(at)==="object"&&typeof(at.tagName)==="string"){var av;if(l){av=l}var aq=at.parentNode;var ap=[];while(aq){if(aq.tagName==="if"){av="Matched Condition"}ap.unshift(U(aq));aq=aq.parentNode}ap.shift();ap.shift();m.iTraceParameterDebug.group(av);m.iTraceParameterDebug.log(ap.join(" "));m.iTraceParameterDebug.log(at);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}else{m.iTraceParameterDebug.group("By Parameter/Attribute:");m.iTraceParameterDebug.log(ay);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}if(m.cfgAliasNames[aw]!==b){aw=m.cfgAliasNames[aw]}if(ar[aw]!==b&&(typeof(ay)==="string"&&a.utils.getBoolTable(ay.toLowerCase())===false)&&a.utils.getBoolTable(ar[aw])===b){delete ar[aw]}else{switch(aw){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ar[aw]!==b&&ar[aw].length>0&&ar[aw].indexOf(ay)===-1){ar[aw]+=","+ay}else{ar[aw]=ay}break;case"plugins":m.addPluginsFromString(ay);break;case"fpxpath":ar[aw]=ay;ar.fpxsrc=encodeURIComponent(ay);break;default:ar[aw]=ay;if(ao.node!==b){ar[aw+".node"]=ao.node}}}};var k={};k["="]=function(ap,ao){return(ap.toLowerCase()===ao.toLowerCase())};k["=="]=function(ap,ao){return(ap===ao)};k["!="]=function(ap,ao){return(ap.toLowerCase()!==ao.toLowerCase())};k["!=="]=function(ap,ao){return(ap!==ao)};k["<"]=function(ap,ao){return(ap<ao)};k["<="]=function(ap,ao){return(ap<=ao)};k[">"]=function(ap,ao){return(ap>ao)};k[">="]=function(ap,ao){return(ap>=ao)};k.match=function(ap,ao){var aq=false;var at="g";if(ao.charAt(0)==="/"&&ao.lastIndexOf("/")>0){var ar=ao.split("/");ar.shift();at=ar.pop();ao=ar.join("/")}try{var au=new RegExp(ao,at);aq=(ap.match(au)!==null)}catch(av){H.error("Invalid regex in condition: "+ao)}return aq};k.notmatch=function(ap,ao){return !k.match(ap,ao)};var r={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var t=function(ap,aq){if(m.cfgAliasNames[aq]){aq=m.cfgAliasNames[aq]}var ao=m.cfg[aq];if(ao===b){ao=""}if(!m.hasImageParameterConditions){m.hasImageParameterConditions=(aa[aq]!==b)}return G(ap,aq,ao)};var L=function(ar,at){var ao=false;var aq;var ap=ar.getAttribute("value");switch(at){case"@mobile":ap=m.makeBool(ap,true);aq=a.isMobileDevice;break;case"@devicepixelratio":aq=a.getDevicePixelRatio();break;case"@navigatoruseragent":aq=navigator.userAgent;break;case"@navigatorlanguage":aq=navigator.language;break;case"@navigatorplatform":aq=navigator.platform;break}if(aq!==b){if(typeof(ap)!=="string"){ap=""+ap}if(typeof(aq)!=="string"){aq=""+aq}ao=G(ar,at,aq,ap)}return ao};var G=function(ar,aq,au,at){var aw;var ap=ar.getAttribute("operator");if(typeof(ap)!=="string"){ap="="}ap=ap.toLowerCase();if(r[ap]){ap=r[ap]}if(k[ap]===b){ap="="}if(at===b){at=ar.getAttribute("value")}if(at===null){at=""}var ao=k[ap];if(ap.match(/[<,>]+/)){var ax=function(ay){ay=parseFloat(ay);if(isNaN(ay)){aw=false}return ay};au=ax(au);at=ax(at)}else{au=decodeURIComponent(au)}if(aw===b){aw=ao(au,at)}if(H.on){H.log("Evaluating condition: "+aq+": "+au+" "+ap+" "+at+" => "+aw)}if(aw===true){if(ar._myTagName!==b){var av={};av.nodeType=1;av.tagName=ar._myTagName;av.childNodes=[ar];ar=av}m.parseConfig(ar,ar)}return aw};var aa={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ab={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var Z;var T=function(){if(Z===b){Z={};for(var ao in aa){Z[aa[ao]]=ao}}return Z};var p=function(at,ar,aq){if(aq===b){aq=""}var av=aq+"left";if(at[av]===b){return}var au=aq+"top";var ap=aq+"right";var ao=aq+"bottom";if(ar==="pixelrange"){at[ap]=at[ap]-at[av];at[ao]=at[ao]-at[au]}at[ar]=at[av]+","+at[au]+","+at[ap]+","+at[ao];if(at[av]){delete at[av]}if(at[au]){delete at[au]}if(at[ap]){delete at[ap]}if(at[ao]){delete at[ao]}};var al=this.mapImageParametersToViewer=function(ao){p(ao,"rect");p(ao,"pixelrange","pixel");T();ag(ao,T())};var ak=this.mapImageParametersToServer=function(ao){ag(ao,aa)};var ag=function(ap,ao){for(var aq in ap){if(ao[aq]&&aq!==ao[aq]){ap[ao[aq]]=ap[aq];delete ap[aq]}}};this.reWriteImageURLByConditions=function(av){if(m.arConditions.length<1){return av}if(typeof(av)!=="string"||av.length<1){return av}var aq=av.indexOf("?");if(aq===-1){return av}var ap=m.clone();var at={};m.parseQuery(av,at);al(at);m.evaluateQuery(at,ap.cfg);var ao=ap.evaluateConditions();if(!ao){return av}var au;for(au in at){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}for(au in ab){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}ak(at);var ar=av.substr(0,aq);return ar+"?"+m.objectToQuery(at)};var n=this.applyConditions=function(){if(m.arConditions.length<1){return}if(m.cfgBeforeConditions===b){m.cfgBeforeConditions=a.utils.cloneObject(m.cfg)}m.cfg=m.cfgBeforeConditions;return g()};var aj=0;var g=this.evaluateConditions=function(){if(m.arConditions.length<1){return false}var ap=false;for(var aq=aj;aq<m.arConditions.length;aq++){var ar=m.arConditions[aq];if(ar.fsiConfigEvaluated){continue}aj++;var at=ar.getAttribute("parameter");if(typeof(at)==="string"){at=at.toLowerCase();var ao;if(at.charAt(0)==="@"){ao=L(ar,at)}else{ao=t(ar,at)}if(!ap&&ao){ap=ao}}}return ap};var V=function(){n();m.serverProfile=m.cfg.fpxservertemplate;m.serverProfileDoublePage=m.cfg.fpxservertemplatedoublepage;if(m.serverProfileDoublePage===b){m.serverProfileDoublePage="doublepage"}m.serverBase=m.cfg.fpxserver;if(m.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+m.locationFSIViewer+")");var ap;ap=m.locationFSIViewer.indexOf("/users/");if(ap!==-1){m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}else{ap=m.locationFSIViewer.indexOf("/viewer/");m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}H.log("Derived server location is: ["+m.serverBase+"]")}m.requestBase=m.serverBase;ac={};var ao=m.cfg;for(var aq in ab){if(ao[aq]!==b){ac[aq]=ao[aq]}}if(ac.fpxsrc!==b){ac.fpxsrc=decodeURIComponent(ac.fpxsrc)}ao=m.cfg.effects;if(ao!==b){m.cfg.effectsUnFiltered=ao;m.cfg.effects=ao=j(ao)}if(ao!==b){ac.effects=ao}ao=m.cfg.lefteffects;if(ao!==b){ac.lefteffects=ao}ao=m.cfg.righteffects;if(ao!==b){ac.righteffects=ao}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){m.setEffectsFilter(m.getAreaEffects())};this.setEffectsFilter=function(at){if(typeof(at)!=="string"||at.length<1){X=false;return}at=a.trim(at);var ap=at.split(",");for(var aq=0;aq<ap.length;aq++){ap[aq]=a.escapeRegEx(ap[aq])}var ao="(^|[=,]+)("+ap.join("|")+")\\([^)]*\\)";X=new RegExp(ao,"ig")};var j=function(ao){if(X===false){return ao}return ao.replace(X,"")};var i=function(){for(var ap in m.plugins){var aq=ap.toLowerCase();var ao=m.makeBool(m.cfg[aq],true);if(!ao){m.plugins[ap]=b}}};var W=function(){m.elevateToHTTPS();i();V();m.dumpConfig();if(w.onConfigsReady){w.onConfigsReady()}};this.dumpConfig=function(aq){if(!aq){aq=H}if(aq.on){if(m.cfg.fpxsrc!==b){m.cfg["fpxsrc (decoded)"]=decodeURIComponent(m.cfg.fpxsrc)}aq.info("Evaluated Configuration:",P(m.cfg));if(m.queryParameters){aq.info("Parameters:",P(m.queryParameters))}if(ae){aq.info("Class <"+s+"> Configuration:",P(ae))}var ap=m.getPluginsAndParameters();var ao=ap.data;if(ap.count===0){ao="No active plugins."}aq.info("Plugin Configuration:",P(ao))}};var P=function(aq){var ao="--- none ---";if(typeof(aq)!=="object"){return ao}for(var ap in aq){ao=aq;break}return ao};this.getPluginsAndParameters=function(){var ao={};var aq=0;for(var ap in m.plugins){if(m.hasPlugin(ap)){ao[ap]=Q(ap);aq++}}return{count:aq,data:ao}};var J=this.addQueryParameterToURL=function(ar,ao,aq){var ap=ar.lastIndexOf("?");if(ap===-1){ar+="?"}else{if(ap!==ar.length-1){ar+="&"}}return ar+encodeURIComponent(ao)+"="+encodeURIComponent(aq)};var am=m.finishURL=function(ao){if(v){ao=J(ao,u,v)}if(!Y||ao===b){return ao}var ap;if(D===false){ap="cache=0&cachernd="+q;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+="&"+ap}}else{ap=D;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+=ap}}return ao};this.addURLParameters=function(ap,aq){if(!ap||!aq){return ap}var ao=[];for(var at in aq){ao.push(encodeURIComponent(at)+"="+encodeURIComponent(aq[at]))}if(ao.length>0){if(ap.indexOf("?")===-1){ap+="?"}else{ap+="&"}ap+=ao.join("&")}return ap};this.finishRequestParams=function(ap){if(Y){if(D===false){ap.cache=0;ap.cachernd=q}else{for(var ao in x){ap[ao]=x[ao]}}}};this.addNoCacheParams=function(ao){ao.cache=0;ao.cachernd=q};this.parseQuery=function(ap,ao){if(typeof(ao)!=="object"||typeof(ap)!=="string"||ap.length<1){return}m.queryToObject(ap,ao);if(ao.ignorequeryparameters!==b){delete ao.ignorequeryparameters}if(ao.enableconfigcachingparameter!==b){delete ao.enableconfigcachingparameter}};this.cloneParameters=function(ao,ap){if(ao===b||ap===b){H.error("Cloning object failed: "+ao+" / "+ap)}for(var aq in ao){ap[aq]=ao[aq]}};this.getFSIPath=function(ao,ap){if(ap.indexOf("//")!==-1){return ap}if(m.cfg.fsibase!==b){ap=m.cfg.fsibase+ap}return m.getReloadPath(ao,ap)};this.expandFSIPath=function(ap){if(ap===b){return ap}var ao=a.utils.urlDecode(ap);if(ao.indexOf("?")!==-1||ao.indexOf(".xml")===(ao.length-4)){return ap}return ap+".xml"};this.getReloadPath=function(ar,au){var ap,av,ao,at;if(ar===b){ar=m.locationFSIViewer}if(typeof(au)!=="string"){au=""}var aq="/";if(au.indexOf("//")!==-1){return au}ap=ar;at=ap.lastIndexOf("?");if(at===-1){at=ap.length}av=ap.lastIndexOf("\\",at);ao=ap.lastIndexOf("/",at);av=Math.max(av,ao);if(av===-1){av=ap.length-1}ap=ap.slice(0,av);if(ap.length>0&&au.indexOf(aq)!==0){ap+=aq}return ap+au};var C=function(ao){var ap;if(!ao){return}if(ao.childNodes.length>0){ap=ao.innerHTML}else{ap=ao.getAttribute("value")}return ap};var I=function(aq,ar){var ap,ao;while(aq){if(aq.nodeName===ar){ao=aq;break}ap=aq.firstChild;if(!ap){ap=aq.nextSibling}if(!ap&&aq.parentNode){ap=aq.parentNode.nextSibling}aq=ap}return ao};var B=function(ap){var ao=I(ap,"images");if(!ao){ao=I(ap,"images3d")}return m.parseXMLImageListNode(ao)};var R=function(aq){var ap={};var au=ap.arImages=[];var at="";var aw="";var ax;if(!aq){return ap}var av;av=m.getAttributeValue(aq,"prefix");if(typeof(av)==="string"){at=av}av=m.getAttributeValue(aq,"suffix");if(typeof(av)==="string"){aw=av}aq=I(aq,"image");if(!aq){return ap}while(aq){if(aq.nodeType===1){ax=I(aq,"path");var ay=C(ax);if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"src"))}if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"file"))}if(ay!==b){if(ad===false){au.push(at+ay+aw)}else{var ao=at+ay+aw;if(ad(ao)){au.push(ao)}}}if(ap.width===b){ax=I(aq,"width");ax=C(ax);if(ax!==b){ap.width=parseInt(ax)}ax=I(aq,"height");ax=C(ax);if(ax!==b){ap.height=parseInt(ax)}}}aq=aq.nextSibling}return ap};this.getImageList=function(){var aq,av,ap;z();if(m.cfg&&m.cfg.fpxsources!==b){var au=m.cfg.fpxsources;if(typeof(au)==="string"||(typeof(au)==="object")&&typeof(au.push)==="function"){aq={};aq.oXML=null;if(typeof(au)==="string"){if(ad===false){aq.arImages=au.split(",");for(av=0;av<aq.arImages.length;av++){aq.arImages[av]=a.utils.urlDecode(aq.arImages[av])}}else{var ao=au.split(",");aq.arImages=[];for(av=0;av<ao.length;av++){ap=a.utils.urlDecode(ao[av]);if(ad(ap)){aq.arImages.push(ap)}}}}else{aq.arImages=au}}}if(!aq&&m.arUnrecognizedConfigNodes&&m.arUnrecognizedConfigNodes.length>0){var at=m.arUnrecognizedConfigNodes;for(av=0;av<at.length;av++){var aw=at[av];if(typeof(aw.nodeName)==="string"){var ax=aw.nodeName.toLowerCase();if(ax==="images"||ax==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aq=R(aw);aq.oXML=aw;break}}}}if(!aq&&m.cfg&&m.cfg.fpxsrc!==b){aq={};aq.oXML=null;if(ad===false){aq.arImages=[a.utils.urlDecode(m.cfg.fpxsrc)]}else{ap=a.utils.urlDecode(m.cfg.fpxsrc);if(ad()){aq.arImages=[ap]}}}return aq};this.getServerBase=function(){return m.serverBase};this.loadImageList=function(ar,at,av,au){if(!m.serverBase||!ar){at([],b,au);return false}z();var aq=m.serverBase+"?type=list";if(ar.indexOf("tpl")===-1){var ap=m.cfg.listtemplate;if(ap&&ap.length>0&&ap.indexOf(".json")===-1&&ap.indexOf(".xml")===-1){ap+=".json"}aq+="&tpl="+ap}if(m.cfg.headers&&m.cfg.headers.length>0&&x.headers===b){aq+="&headers="+m.cfg.headers}if(typeof(m.cfg.imagelistlimit)==="string"&&m.cfg.imagelistlimit.length>0){aq+="&limit="+encodeURIComponent(m.cfg.imagelistlimit)}aq+="&source="+encodeURIComponent(ar);if(av!==b){aq+=av}aq=am(aq);var ao=m.loadFile(aq,function(aw,aA){if(typeof(aA)==="object"&&typeof(aA.images)==="object"){aA.images.pop();var aB="";if(aA&&aA.imagesattributes&&aA.imagesattributes.dir){aB=aA.imagesattributes.dir}var ax,az;if(ad===false){ax=new Array(aA.images.length);for(az=0;az<aA.images.length;az++){ax[az]=aB+aA.images[az].src}}else{ax=[];for(az=aA.images.length-1;az>-1;az--){var ay=aB+aA.images[az].src;if(af(ay)){ax.push(ay)}else{aA.images.splice(az,1)}}ax.reverse()}at(ax,aA,au)}else{at([],aA,au)}},"application/json",au);return ao};var af=function(ap){if(typeof(ap)!=="string"){return 1}var ao=1;if(O!==b){if(!ap.match(O)){ao=0}}if(ao===1&&y!==b){if(ap.match(y)){ao=0}}return ao};var ad=true;var O,y;var F=function(at){var aq;var av=m.cfg[at.toLowerCase()];if(!av||typeof(av)!=="string"||av.length<1){return}var ao=/\/([^/]*)$/;try{var ar=av.match(ao);if(ar&&ar.length>1){var ap=ar[1];av=av.replace(ao,"");av=av.replace(/^\//,"")}aq=new RegExp(av,ap)}catch(au){H.error("Invalid Regular Expression "+av+" in parameter "+at);H.error(au.message);aq=b}return aq};var z=function(){O=F("ListFilterPositive");y=F("ListFilterNegative");if(O===b&&y===b){ad=false}else{ad=af}};this.traceConfigValue=function(ao,ar){if(typeof(ao)!=="string"){return false}ao=a.trim(ao);if(ao.length<1){return false}var ap=ao.toLowerCase();if(ap.indexOf(".")!==-1){ap=ap.split(".").join("")}if(ap.indexOf("/")!==-1){ap=ap.split("/").join("")}if(ap.indexOf(" ")!==-1){ap=ap.split(" ").join("")}var aq=new a.Debugger();aq.setPrefix("");aq.group('Tracing parameter "'+ao+'"');var at=function(){var au=ao;var az=m.getParameterAlias(ap);if(typeof(az)==="string"){au+=" (alias: "+az+")";if(typeof(m.cfgAliasNames[ap])==="string"){ap=m.cfgAliasNames[ap]}}var av=m.cfg[ap];var ay=true;if(ap.indexOf("_")!==-1){var ax=ap.split("_");var aw=ax.shift();var aA=ax.join("_");if(m.hasPlugin(aw)){av=m.getPluginParameter(aw,aA)}}else{if(m.hasPlugin(ap)){ay=false;av="is enabled."}}if(av===b){ay=false;av="is undefined (default value applies)"}if(ay){av='= "'+av+'"'}aq.group("RESULT:");aq.log(au+" "+av);aq.groupEnd();aq.groupEnd()};w={onConfigsReady:at};e.strTraceParam=ap;e.bNoDebug=true;m.iTraceParameterDebug=aq;m.init(ar);m.loadConfigs();return""};this.loadLanguageFile=function(ao,aA,at,aq){var au=arguments;var av,ay;if(typeof(aA)!=="string"||m.makeBool(aA,true)===false){return at.call(m,{},"")}var az=function(aB){try{a.utils.oLanguageMap=JSON.parse(aB.responseText)}catch(aC){a.utils.oLanguageMap={"default":"english"}}m.loadLanguageFile.apply(this,au)};var aw=function(aB,aE){ao.urlLanguageCurrentLoaded=av;var aD=ao.oLanguageData={};if(aE){var aC=m.findXMLNode(aE,"data");if(aC){aC=m.findXMLNode(aC,"tip")}while(aC){if(aC.nodeType===1){var aF=aC.getAttribute("id");aD[aF]=m.XMLChildNodesToString(aC)}aC=aC.nextSibling}}at.call(m,ao.oLanguageData,ay)};if(aA.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){m.loadFile(a.getViewerLocation()+"/languages/mapping.json",az,"application/json");return}if(a.utils.oLanguageMap._current!==b){aA=a.utils.oLanguageMap._current}else{aA=a.utils.oLanguageMap["default"];var ar=navigator.language;if(typeof(ar)==="string"){ar=ar.toLowerCase()}if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}else{if(ar.indexOf("-")!==-1){ar=ar.split("-")[0];if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}}}}if(aA===b){return at.call(m,{},"")}if(aq){aq.log('Automatically choosing language "'+aA+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aA}var ax=aA+".xml";var ap=a.getViewerLocation()+"/languages/"+ax;if(ap!==ao.urlLanguageCurrentLoaded){ay=aA;av=ap;if(aq){aq.log("Loading language file: "+ap)}m.loadFile(ap,aw,"application/xml")}else{at.call(m,ao.oLanguageData,ay)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){a.CustomEventListener;if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.utils.getNewEventElementID()}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(n,aY,am,e,aO){var aF=this;var aM=false;var al=true;var p=false;var aU=false;var aL=false;var aC,F,j,ae;var aD,Z,aJ;var h=false;var af;var s;var a1={};var ar=[];var ad=0;var J=window;var aW;var t;var aV;var d;var a0=[];var aS={x:0,y:0};var w={x:0,y:0};var at=40;var o={};o.enabled=false;o.factor=5;o.fEndDiff=1;var az={};az.enabled=false;az.minFrames=14;az.factorAmount=23;az.factorAmountQuad=0;az.factorFrames=2.6;az.offsetFrames=5;var ac;var aA;var aI,x,l;var G;var au={};var Y;var aN=false;var A=false;var an={};an.name="none";var O;var X;var aP;var f=false;var aa={};if(!aY||typeof(aY)!="object"){aY={}}var ao=function(){var a7;if(aM){aF.destroy()}aV=B;t=b;if(a.utils.getTopWindow()!=window){t=a.utils.getTopWindow();try{var a6=a.getWindowOffset(window);if(a6.x!=b&&a6.y!=b){aV=aq}}catch(a5){aV=B;t=b}}else{t=b}G=aY.oPassTrough;aX(aY.panDirectionAllowed,true);if(aY.getPageCoords){s=aG}else{s=N}if(aY.afterTouch){for(a7 in aY.afterTouch){az[a7]=aY.afterTouch[a7]}}if(az.minDelta==b){az.minDelta=15}if(aY.nClickRadius){ac=aY.nClickRadius}else{ac=10}if(az.fnStartStopAfterTouch&&typeof(az.fnStartStopAfterTouch)!="function"){az.fnStartStopAfterTouch=b}if(az.fnStartStopAfterTouch){az.useAnimationFrame=b}if(typeof(az.modifyTarget)!="function"){az.modifyTarget=b}if(typeof(az.fnGetAfterTouchEnabled)=="function"){aA=az.fnGetAfterTouchEnabled}else{aA=b}if(aY.smoothing){for(a7 in aY.smoothing){o[a7]=aY.smoothing[a7]}}if(aY.detectClick==true){Y=true}if(aY.preventSelection!==false){aY.preventSelection=true}if(!n){return}if(typeof(n.join)!="function"){n=[n]}if(typeof(am)!="function"){am=B}if(typeof(e)!="function"){e=B}if(typeof(aO)!="function"){aO=B}if(typeof(aY.onPinchChange)=="function"){O=aY.onPinchChange}else{O=b}aN=aY.detectGestures;a0=[];ay(true,aN);for(var a4=0;a4<n.length;a4++){var a3=n[a4];if(a3&&typeof(a3.nodeName)!="undefined"){a7={};a7.element=a3;a0.push(a7);ap(a3,S);if(a.isTouch){try{if(a3.style!=b){if(a.BrowserSupports.cssTouchAction()){if(au.cssTouchAction!=b){r(a3,au.cssTouchAction)}}}}catch(a5){}}}}if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aE,false)}};var aX=this.setAllowedPanDirection=function(a4,a3){if(typeof(a4)=="string"){if(a4=="pan-x"||a4=="pan-y"||a4=="pan-x pan-y"){aW=a4+" "}else{aW=""}}else{aW=""}if(!a3){au.nCheck=b;ai(au.captureScroll,au.capturePinch)}};this.enable=function(a3){if(al==a3){return}if(!a3){R();ai(false,false)}else{ai(au.captureScrollUser,au.capturePinchUser)}al=a3};this.getEnabled=function(){return al};this.cancel=function(){Q();ah();aK();R()};var aK=function(){if(o.enabled){i()}C()};this.cancelAfterTouch=function(){C()};this.getInitialDownEvent=function(){return X};var R=function(){if(!p){return}aK();p=false;X=b;A=false;if(ad==0){aQ()}};var aQ=function(){f=false;c()};this.destroy=function(){if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aE,false)}if(aP){clearTimeout(aP)}aF.cancel();var a3;for(var a4=0;a4<a0.length;a4++){var a5=a0[a4];a3=a5.element;y(a3,S)}au={}};var r=function(a3,a4){if(!a.BrowserSupports.cssTouchAction()||!a3||!a3.style){return}a3.style.touchAction=a3.style.msTouchAction=a4};var U=function(a3){if(a3.preventDefault){a3.preventDefault()}};var m=function(a3){U(a3);return false};var ap=function(a4,a3){a.addEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{a.addEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a4,"touchstart",a3);a.addEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a4,"MSPointerDown",a3)}a.addEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var y=function(a4,a3){a.removeEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{a.removeEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a4,"touchstart",a3);a.removeEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a4,"MSPointerDown",a3)}a.removeEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var B=function(){return true};var aR=function(a3){if(aL){W(a3,a3.pointerId)}else{var a4=a3.changedTouches;for(var a5=0;a5<a4.length;a5++){W(a4[a5],a4[a5].identifier)}}};var W=function(a3,a5){if(a5==b||a1[a5]!=b){if(aY.debug){if(a5==b){a.console.error("doRegisterPointer: no pointerId")}if(a1[a5]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a5)}}return}ad++;var a4=a1[a5]={};a4.identifier=a5;s(a4,a3);ar.push(a4)};var ak=function(a3){var a5=false;if(aL){a5=L(a3.pointerId)}else{var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){a5=L(a4[a6].identifier)}}}if(a5){ar=new Array(ad);var a8=0;for(var a7 in a1){ar[a8++]=a1[a7]}}};var L=function(a3){if(a3==b||a1[a3]==b){if(aY.debug){if(a3==b){a.console.error("doUnregisterPointer: no pointerId")}if(a1[a3]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+a3)}}return false}delete a1[a3];ad--;return true};var I=function(){ad=0;a1={};ar=[]};var N=function(a4,a3){a4.x=a3.clientX;a4.y=a3.clientY};var aG=function(a4,a3){a4.x=a3.pageX;a4.y=a3.pageY};var v=function(a3){var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){var a5=a1[a4[a6].identifier];if(a5){s(a5,a4[a6])}}}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y}};var ax=function(a3){var a4=a1[a3.pointerId];if(a4){s(a4,a3)}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y;aV(a3,aS)}};var V=function(a3){s(aS,a3);aV(a3,aS)};this.getMousePositionFromMouseEvent=function(a3){V(a3);return aS};this.getMousePositionPage=function(a4){var a3={};aG(a3,a4);aV(a4,a3);return a3};this.getMousePositionClient=function(a4){var a3={};N(a3,a4);aV(a4,a3);return a3};var u=function(a3,a4){if(window!=a3.view){var a5=a.getWindowOffset(window);a4.x-=a5.x;a4.y-=a5.y}};var aq=function(a3){try{u(a3);aV=u}catch(a4){aV=B}};var aB=function(a3){if(!al){return}var a5=ad;if(A&&a5==0){A=false}var a6=a3.type;if(p||an.started){if(a6!=aC){if(an.started){Q();ah()}else{a3._FSI_Canceled=true;a2(a3,true)}}}aC=a6;d=false;var a4=true;switch(a6){case"touchstart":aU=true;aL=false;af=v;j="touchmove";F="touchend";ae="touchcancel";aI=false;break;case"MSPointerDown":af=ax;aU=true;aL=true;j="MSPointerDown";F="MSPointerUp";ae="MSPointerCancel";aI=false;d=true;break;case"pointerdown":af=ax;aU=true;aL=true;j="pointermove";F="pointerup";ae="pointercancel";aI=true;d=true;break;default:if(ad>0){I()}aU=false;aL=false;aI=(aY.preventSelection);a4=false;af=V;j="mousemove";F="mouseup";ae=b;d=true}if(aU&&a4){aR(a3)}af(a3);if(!aY.bAllowMouseDown&&aI){U(a3)}if(ad>1){aa.bClick=false}x=false;if(a4&&aj(a3)){if(a5==0){C();E()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ad};var S=function(a3){if(aY.bMouseOnly&&a3.type==="pointerdown"&&a3.pointerType!=="mouse"){return true}if(!aB(a3)){return}if(p||a3.which>1){return}g(a3)};this.getCurrentPos=function(){return w};var g=function(a3){aK();if(p){return}az.evtMove=b;if(o.enabled){w={x:aS.x,y:aS.y}}else{w=aS}aa.x=aS.x;aa.y=aS.y;var a4=X;X=a3;if(!am.call(J,a3,w,G)){X=a4;return false}p=f=true;if(Y&&!A){aa.bClick=true;aa.clickRadiusX=aa.clickRadiusY=0}else{aa.bClick=false}E();if(az.enabled){az.x=az.y=0;az.lastX=aS.x;az.lastY=aS.y;if(az.nInterval){clearInterval(az.nInterval)}az.nInterval=setInterval(ab,30)}return true};var c=function(){if(h&&Z!=b){var a3={passive:false,capture:false};var a5=(t==b)?a3:b;h=false;a.removeEvent(window,Z,ag,a5);a.removeEvent(window,aD,a2,a5);if(d&&t){try{a.removeEvent(t,Z,ag,a3);a.removeEvent(t,aD,a2,a3)}catch(a4){}}if(aJ!=b){a.removeEvent(window,aJ,av,a5)}Z=aD=aJ=b}};var aE=function(a3){};var E=function(){if(h){c()}h=true;var a3={passive:false,capture:false};var a5=(t==b)?a3:b;Z=j;aD=F;aJ=ae;a.addEvent(window,Z,ag,a5);a.addEvent(window,aD,a2,a5);if(d&&t){try{a.addEvent(t,Z,ag,a3);a.addEvent(t,aD,a2,a3)}catch(a4){}}if(ae!=b){a.addEvent(window,aJ,av,a5)}};var ag=function(a3){af(a3);a3.FSI_start_x=aa.x;a3.FSI_start_y=aa.y;if(az.enabled&&az.evtMove==b){az.evtMove=a3}if(p){if(aa.bClick){aa.clickRadiusX=Math.max(aa.clickRadiusX,Math.abs(aS.x-aa.x));if(aa.clickRadiusX>ac){aa.bClick=false}else{aa.clickRadiusY=Math.max(aa.clickRadiusY,Math.abs(aS.y-aa.y));if(aa.clickRadiusY>ac){aa.bClick=false}}}if(o.enabled){o.evt=a3;aZ()}else{e.call(J,a3,w,G)}}else{if(an.started){if(an.nType==1){aw(a3)}}}if(x&&!a3.FSI_allowEventDefault){U(a3)}};var aw=function(a3){var a4=k();if(!O){return}a3._FSI_PinchDeltaStart=an.nPinchDistance-an.pinchDistanceStart;a3._FSI_PinchDeltaRelative=an.nPinchDistance-an.pinchDistanceLast;a3._FSI_PinchScale=Math.max(at,an.pinchDistanceLast)/an.pinchDistanceStartMaxed;an.pinchDistanceLast=an.nPinchDistance;a3._FSI_PinchDistance=a4;O.call(J,a3,aS,G)};var av=function(a3){if(aU){ak(a3);if(ad<1){if(p){a3._FSI_Canceled=true;a2(a3,true);return}else{R();return}}}af(a3);aj(a3)};var a2=function(a4,a5){var a3=aa.bClick;aa.bClick=false;if(a5){a4._FSI_Canceled=true}if(aU){ak(a4)}if(ad==0){aQ()}af(a4);if(!a5&&aj(a4)){return}aK();if(!a5){if(!p||ad>0){return}}a4.FSI_start_x=aa.x;a4.FSI_start_y=aa.y;var a6=false;if(!a5&&az.enabled){if(aA==b||aA()){a6=T(a4)}}if(a6){R();z(a4)}else{if(Y){a4._FSI_Click=a3}aO.call(J,a4,w,G);if(a4.type=="touchend"){aP=setTimeout(q,1)}R()}U(a4)};var q=function(){R();I();aP=b};var H=function(a3){return ar};var aZ=function(){if(o.animationFrame!=b){return}aT()};var i=function(){if(o.animationFrame==b){return}cancelAnimationFrame(o.animationFrame);o.animationFrame=b};var aT=function(){var a3=Math.abs(w.x-aS.x)+Math.abs(w.y-aS.y);if(a3>o.fEndDiff){w.x+=(aS.x-w.x)/o.factor;w.y+=(aS.y-w.y)/o.factor;o.animationFrame=requestAnimationFrame(aT)}else{w.x=aS.x;w.y=aS.y;o.animationFrame=b}e.call(J,o.evt,w,G)};var T=function(a3){var a4;if(!az.enabled){return false}if(az.running){C()}az.pos=0;var a6=(a3.touches!=b)?1.8:1;if(az.factorAmountQuad){a4=(az.x>0)?1:-1;az.x=az.x+a4*az.x*az.x/az.factorAmountQuad;a4=(az.y>0)?1:-1;az.y=az.y+a4*az.y*az.y/az.factorAmountQuad}var a8=a6*az.factorAmount;az.startX=w.x;az.startY=w.y;var a7={};a7.x=az.startX+a8*az.x;a7.y=az.startY+a8*az.y;if(az.roundTargetPos){a7.x=Math.round(a7.x);a7.y=Math.round(a7.y)}if(az.modifyTarget){a7=az.modifyTarget.call(J,a7,G);if(a7===false){return false}}az.amountX=a7.x-az.startX;az.amountY=a7.y-az.startY;az.amountXABS=Math.abs(az.amountX);az.amountYABS=Math.abs(az.amountY);var a5=(az.amountXABS>az.minDelta||az.amountYABS>az.minDelta);if(a5){a8=az.factorFrames/100;az.frames=az.offsetFrames+Math.round(a8*az.amountXABS+a8*az.amountYABS)}else{if(typeof(aY.onAfterTouchCancel)=="function"){aY.onAfterTouchCancel.call(J,a3,w,G)}}return a5};this.isAfterTouchRunning=function(){return az.running};var z=function(a3){if(typeof(aY.onAfterTouchStart)=="function"){aY.onAfterTouchStart.call(J,a3,w,G)}az.running=true;az.evtUp=a3;if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,true,az.evtMove,G)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}else{az.intervalRun=setInterval(K,16)}}return true};var aH=function(a4,a3,a6,a5){return a6*((a4=a4/a5-1)*a4*a4+1)+a3};var K=this.runAfterTouch=function(){var a3=false;az.pos++;w.x=aH(az.pos,az.startX,az.amountX,az.frames);w.y=aH(az.pos,az.startY,az.amountY,az.frames);e.call(J,az.evtMove,w,G);if(az.pos===az.frames){C(true)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}a3=true}return a3};this.enableAfterTouch=function(a3){if(az.enabled==a3){return}if(!a3){C()}az.enabled=a3};var C=function(a3){if(!az.running){return}if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,false,az.evtMove,G)}else{if(az.useAnimationFrame){if(az.animationFrameRun){cancelAnimationFrame(az.animationFrameRun)}}else{if(az.intervalRun){clearInterval(az.intervalRun);az.intervalRun=b}}}if(typeof(aY.onAfterTouchEnd)=="function"){aY.onAfterTouchEnd.call(J,az.evtMove,G)}az.evtMove=b;az.running=false;az.evtUp._FSI_Canceled=(a3!==true);az.evtUp._FSI_fromAfterTouch=true;aO.call(J,az.evtUp,w,G)};var ab=function(){az.x=(2*az.x+aS.x-az.lastX)/5;az.y=(2*az.y+aS.y-az.lastY)/5;az.lastX=aS.x;az.lastY=aS.y};var ay=this.setCapture=function(a3,a5){var a4=ai(a3,a5);if(a4){au.captureScrollUser=a3;au.capturePinchUser=a5}return a4};var ai=function(a3,a5){var a4=0;if(a3){a4+=2}if(a5){a4+=4}if(a4==au.nCheck){return}au.nCheck=a4;au.captureScroll=a3;au.capturePinch=a5;if(a.BrowserSupports.cssTouchAction()){P(a3,a5)}return true};var P=function(a3,a7){if(aY.bMouseOnly){return}var a6;switch(au.nCheck){case 0:a6="auto";break;case 2:a6=aW+"pinch-zoom";break;case 4:a6="pan-x pan-y";break;default:a6=(aW.length>0)?aW:"none"}au.cssTouchAction=a6;for(var a5=0;a5<n.length;a5++){var a4=n[a5];r(a4,au.cssTouchAction)}};var k=function(){if(ar.length<1){return 0}var a4=Math.abs(ar[1].x-ar[0].x);var a3=Math.abs(ar[1].y-ar[0].y);return an.nPinchDistance=Math.sqrt(a4*a4+a3*a3)};var aj=function(a3){x=false;if(!al){return}var a4=ar.length;if(!aN){x=(a4==1&&au.captureScroll);return}if(an.pointerCount!=a4){Q(a3);if(a4>1){ah();an.nPointers=a4;switch(a4){case 2:an.started=true;an.name="pinch";an.nType=1;if(typeof(aY.onPinchStart)=="function"){M(a3);an.nPinchDistance=0;an.nPinchDistance=k();an.pinchDistanceStart=an.pinchDistanceLast=an.nPinchDistance;an.pinchDistanceStartMaxed=Math.max(at,an.pinchDistanceStart);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchStart.call(J,a3,aS,G)}break;default:an.started=true;an.name="unknown";an.nType=-1}if(an.started){A=true;if(p){aK();p=false;a3._FSI_Canceled=true;aO.call(J,a3,w,G)}if(typeof(aY.onGestureStart)=="function"){M(a3);aY.onGestureStart.call(J,a3,aS,G)}}}else{if(a4<1){ah()}}an.pointerCount=a4;x=false;if(a4==1){if(au.captureScroll){x=true}}else{if(au.capturePinch&&an.nType==1){x=true}}}return an.started};var ah=function(){if(!an.timeoutRestartDown){return}clearTimeout(an.timeoutRestartDown);an.timeoutRestartDown=b};var D=function(){if(ad!=1){return}g(X);ah()};var M=function(a3){a3._FSI_Gesture=an.name;a3._FSI_GestureType=an.nType;a3._FSI_PointerCount=an.nPointers};var Q=function(a3){if(!an.started){return}an.started=false;if(!a3){a3={}}if(an.nType==1&&typeof(aY.onPinchEnd)=="function"){M(a3);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchEnd.call(J,a3,aS,G)}if(typeof(aY.onGestureEnd)=="function"){M(a3);aY.onGestureEnd.call(J,a3,aS,G)}an.name="none";an.nType=0;if(a3&&ad==1){ah();an.timeoutRestartDown=setTimeout(D,20)}};ao()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.ImageFlow!==b){return}a.utils.API.ImageFlow=function(d,e){var c=this;c.scriptMainFile="FSI.ImageFlow.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},assignFSIViewer:{a:"iFSIViewerInstance"},closeZoom:{a:"evt, bImmediate"},destroy:{},focusImage:{a:"nImage"},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getInitDone:{r:"bDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getParameters:{r:"oParameters"},getVersion:{r:"strVersion"},init:{a:"elementID, oParameters, bDebug"},printAPI:{},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},zoomImage:{a:"nImage"}};c.oCallbacks={onClick:{a:"nImageIndex, strImagePath"},onConfigsReady:{a:"oConfigValues"},onDestroy:{},onFocus:{a:"nImageIndex, strImagePath"},onInit:{a:"oParameters)"},onStart:{a:"strDirectory, nImages, arImagePaths"},onZoomEnd:{},onZoomStart:{a:"nImageIndex, strImageURL"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageFlow!==b){return}a.ImageFlow=function(aH,d){var a0={};var bG={strVersion:"2018",strBuild:"18.07.06.1",strConfigSection:"ImageFlow",bHasListeners:true};var bE=new a.utils.ClassDef(this,"FSI ImageFlow",bG);bE.oAPI=new a.utils.API.ImageFlow(this,a0);var aN=bE.instance;a.utils.guessFSIViewerLocation("fsiimageflow.js",3);var bf=a.utils.getViewerInstanceID();this.getInstanceID=function(){return bf};this.getInstanceName=function(){return bE.strClassName+" ["+aB+"]"};var a7=(d)?a.utils.cloneParameters(d):{};var at;var aB;var ao;var bQ=false;var bh;var w;var bR=[];var cq;var aO;var a8;var W=0;var bz={};var bx;var am,aV;var bN;var bw;var aR={};var a4=false;var B;var by;var b1;var U;var aJ;var bk;var bU;var aI;var bZ;var c=4;var aL;var bP=false;var aT=false;var bJ;var z;var aK;var K=false;var cg;var l;var bc;var bM;var aS;var bl;var ck;var aF,aQ,y;var P=0;var bW=0;var q;var b2;var ae;var ba;var bD;var aj;var bt;var bb,bC;var V=[];var ac={};var a3;var be;var p={};var b0;var b4;var Q={};var az={};var ch;var S={};var Y;var co;var a2;var aD=0;var bT;var ci;var bX;var x;var bn={};var aU;var D;var aX=/((\?)|&)(width|height)=[^&]*/ig;var aP;var bS;var cr;var ce;var a5;var ap;var aq;var bd;var aM;var i;var b5={};var f=0;var ag=8;var g=[];var ca=true;var A=false;var cd=0;var ab;var bL={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",headers:"cors",scrollColor:"#999",placeHolderColor:"#EEEEEE",backgroundColor:"#FFF",zoomBorderStyle:"solid",zoomBorderColor:"#777",zoomBackgroundColor:"white",zoomFadeColor:"white",imageBorderColor:"none",presentationType:"carousel",elementWidth:"10%",elementSpacing:"0.25%"},booleans:{autoDestroy:true,autoResize:true,enableZoom:true,enableScrollBar:true,transparency:false,centerZoomedImage:true,zoomCenteredImageOnly:false,positionQuantization:false,endlessScrolling:false,duplicateImagesIfNeeded:false},floats:{mirrorHeight:0.5,mirrorStartOpacity:0.5,backgroundDarkness:0.3,depthFadeout:0.2,curveHeight:0.35,autoRotateSpeed:0,scrollAlphaNormal:0.35,scrollAlphaActive:1},integers:{zIndexZoom:1000,preloadCount:20,paddingTop:10,paddingBottom:0,zoomFadeOpacity:80,zoomBorderWidth:4,scrollPadding:0,scrollHeight:16}};var r=new a.EmptyDebugger();var ay=function(ct,cs){if(cs&&!r.on&&ct.on){if(by){by.stopPendingRequests()}aN.destroy();aN.init(ab,a7,true);return true}r=ct;if(r.on){r.setPrefix(aN.getInstanceName())}};this.init=function(ct,cw,cs){var cu;ab=ct;if(!a.BrowserSupports.canvas()){r.error("<canvas> element not supported.");return}if(!ct){return}if(typeof(ct)==="object"){if(typeof(ct.id)==="string"){aB=ct.id}}else{if(typeof(ct)==="string"){aB=ct}}if(!aB){aB="fsi.imageflow #"+bf}if(aN._fsi_parameters){cw=aN._fsi_parameters;delete aN._fsi_parameters}if(typeof(ct)==="object"&&ct.tagName!==b){cu=ct}else{cu=document.getElementById(ct)}if(!cu){return}if(bQ){aN.destroy()}cu.setAttribute("x-fsi-id",aB);cd++;bh=cu;cu.innerHTML="";w=document.createElement("div");a.utils.setStyleAttr(w,"width:100%;height:100%;border:0px;none;margin:0px;padding:0px;overflow:hidden");bh.appendChild(w);a7=(cw)?a.utils.cloneParameters(cw):a7;var cx={};cx.onConfigsReady=av;cx.onDebuggerChange=ay;by=new a.Config(null,cx,{strSection:bE.strConfigSection});b1=a0.iCallbacks=new a.Callbacks(aN,by);if(b1.isset("onInit")){b1.run("onInit",[a7])}var cv=a7;if(cs){cv=a.utils.cloneObject(a7);cv.debug=true}by.init(cv);r.log(aN.getVersion());ao={};by.loadConfigs();bQ=true};this.getConfigValue=function(cs){if(by&&typeof(cs)==="string"){return by.cfg[a.trim(cs.toLowerCase())]}};this.getParameters=function(){return a.utils.cloneParameters(a7)};this.getInitDone=function(){return bQ};var bF=function(ct){var cs=ct.oCrop={};bs(cs,"rectLeft",ct.sourceWidth,0);bs(cs,"rectTop",ct.sourceHeight,0);bs(cs,"rectRight",ct.sourceWidth,1);bs(cs,"rectBottom",ct.sourceHeight,1);cs.rectWidth=1-cs.rectRight-cs.rectLeft;cs.rectHeight=1-cs.rectBottom-cs.rectTop;cs.bCrop=true;cs.query=cs.rectLeft+","+cs.rectTop+","+cs.rectWidth+","+cs.rectHeight};var bs=function(cx,cu,cv,ct){var cw=b5[cu];if(typeof(cw)!=="string"){cx[cu]=cw;return}var cs=parseInt(cw);if(isNaN(cs)){cx[cu]=ct;return}cs=Math.max(0,Math.min(cv,cs));cx[cu]=cs/cv};var bA=function(cu,ct){cu=cu.toLowerCase();var cs=ct;if(cu.indexOf("px")!==-1){cs=parseInt(cu);if(isNaN(cs)||cs<=0){cs=ct}else{cs=""+cs+"live";b5.bLive=true}}else{if(cu.indexOf("%")!==-1){cs=Math.max(0,Math.min(100,parseFloat(cu)));cs/=100;if(isNaN(cs)||cs<0){cs=ct}}else{cs=Math.max(0,Math.min(1,parseFloat(cu)));if(isNaN(cs)||cs<0){cs=ct}}}return cs};var ad=function(){var ct;var cu=b5;cu.rectWidth=cu.rectHeight=1;cu.rectLeft=cu.rectTop=0;cu.bCrop=b5.bLive=false;cu.query="";if(ao.cropValues&&ao.cropValues.length>6){ct=ao.cropValues.split(",");cu.rectLeft=bA(ct[0],0);cu.rectTop=bA(ct[1],0);cu.rectRight=bA(ct[2],0);cu.rectBottom=bA(ct[3],0);cu.rectWidth=1-cu.rectRight-cu.rectLeft;cu.rectHeight=1-cu.rectBottom-cu.rectTop;cu.bCrop=true;if(!cu.bLive){cu.query=cu.rectLeft+","+cu.rectTop+","+cu.rectWidth+","+cu.rectHeight}}else{if(ao.cropRect&&ao.cropRect.length>6){ct=ao.cropRect.split(",");if(ct.length>3){while(ct.length>4){ct.pop()}for(var cs=0;cs<ct.length;cs++){ct[cs]=parseFloat(ct[cs])}var cv=ct[0]*ct[1]*ct[2]*ct[3];if(isNaN(cv)){return}cu.rectLeft=ct[0];cu.rectTop=ct[1];cu.rectRight=ct[2];cu.rectBottom=ct[3];cu.rectWidth=ct[2]-ct[0];cu.rectHeight=ct[3]-ct[1];cu.bCrop=true;cu.query=cu.rectLeft+","+cu.rectTop+","+cu.rectWidth+","+cu.rectHeight}}}};var av=function(){if(by.cfg.viewerid){aN.assignFSIViewer(by.cfg.viewerid)}var ct=by.cfg.dir;if(!ct||ct.length===0){var cs=by.getImageList();if(cs){ai(cs.arImages,cs)}}else{by.loadImageList(by.cfg.dir,ai)}if(b1.isset("onConfigsReady")){b1.run("onConfigsReady",[a.utils.cloneObject(by.cfg)])}};var ai=function(cs,ct){if(!bQ){return}Y=0;if(!cs){cs=[]}bR=cs;r.log("Image list loaded ("+bR.length+" images)");C();j()};var C=function(){s(ao)};var aZ=function(ct,cs,cw,cu){for(var cv in cw){cs[cv]=ct.getFloatParameter(cu+cv,cw[cv])}};var bo=function(ct,cs,cw,cu){for(var cv in cw){cs[cv]=ct.getIntParameter(cu+cv,cw[cv])}};var an=function(cu,ct,cs,cv){for(var cw in cs){ct[cw]=cu.getStringParameter(cv+cw,cs[cw])}};var ah=function(ct,cs,cv,cu){for(var cw in cv){cs[cw]=ct.makeBool(ct.getStringParameter(cu+cw),cv[cw])}};var t=function(ct,cs,cv,cu){var cw;if(cv&&cv.length>0){if(cs[cv]===b){cs[cv]={}}cu=cu[cv];cw=cs[cv]}else{cw=cs}if(cu.strings){an(ct,cw,cu.strings,cv)}if(cu.booleans){ah(ct,cw,cu.booleans,cv)}if(cu.floats){aZ(ct,cw,cu.floats,cv)}if(cu.integers){bo(ct,cw,cu.integers,cv)}};var s=function(cs){if(cs===b){cs={}}cs.serverBase=by.serverBase;t(by,cs,"",bL);var cv=/[\dabcdef]{3,6}/i;for(var cw in bL.strings){if(cw.indexOf("Color")!==-1){var cu=ao[cw];if(cu.indexOf("#")!==0){var ct=cu.match(cv);if(ct){if(ct[0].length===cu.length&&(ct[0].length===3||ct[0].length===6)){ao[cw]="#"+ct[0]}}}}}};var j=function(){var ct;bJ=ao.presentationType.toLowerCase();if(a.isMobileDevice){c=3}else{c=1}ce=ao.transparency;bP=ao.endlessScrolling;ad();ch=bR.length;ct=ao.placeHolderColor.toLowerCase();bS=(ct!=="none"&&ct!=="transparent");ct=ao.imageBorderColor.toLowerCase();i=(ct!=="none"&&ct!=="false");if(ao.zoomCenteredImageOnly){bM=true}else{bM=ao.positionQuantization}ct=bj();aF=y=aQ=ct;ap=-ao.autoRotateSpeed;cg="rgba(0,255,0,";ct=ao.backgroundColor.toLowerCase();if(ct==="false"||ct==="transparent"||ct==="none"){ao.backgroundColor=false;aL=br;w.style.backgroundColor="transparent"}else{if(!ce&&ao.backgroundDarkness===0){aL=J}else{aL=br}ct=ao.backgroundColor;if(ct.indexOf("#")===0){ct=ct.substr(1)}if(ct.length===3){ct=ct.charAt(0)+ct.charAt(0)+ct.charAt(1)+ct.charAt(1)+ct.charAt(2)+ct.charAt(2)}var cv=parseInt("0x"+ct.substr(0,2));if(isNaN(cv)){cv=0}var cu=parseInt("0x"+ct.substr(2,2));if(isNaN(cu)){cu=0}var cs=parseInt("0x"+ct.substr(4,2));if(isNaN(cs)){cs=0}cg="rgba("+cv+","+cu+","+cs+",";w.style.backgroundColor=ao.backgroundColor}cr=(aL===br);al();cq=a.utils.cloneArray(bR);aO={};if(ao.autoResize===true){if(bc===b){bc=a.addCustomEvent(bh,"FSIElementDimension",b7);a.setCustomEventListenerProperty(bc,"treshold",200)}}else{if(bc!==b){a.removeCustomEvent(bh,"FSIElementDimension",b7);bc=b}}bH();a1()};var bu=function(cu){var ct,cs;if(typeof(cu)==="string"){cs=cu.indexOf("%");ct=parseFloat(cu)}else{cs=-1;ct=cu}if(cs!==-1){ct=Math.round(aF.width*ct/100)}return{val:ct,bRelative:(cs!==-1)}};var al=function(){var cs;cs=bu(ao.elementWidth);if(isNaN(cs.val)){cs=bu(bL.strings.elementWidth)}aS=bz.width=Math.max(1,cs.val);bz.widthRelative=cs.bRelative;cs=bu(ao.elementSpacing);if(isNaN(cs.val)){cs=bu(bL.strings.elementSpacing)}bl=bz.spacing=cs.val;bz.spacingRelative=cs.bRelative};var bH=function(){a4=false;n();if(cq.length<1){return}bx=0;a8={};W=0;cd++;if(bR.length!==cq.length){bR=a.utils.cloneArray(cq)}ch=bR.length;a2=!ao.enableScrollBar;b2=aS+bl;aF=aQ;bb=aF.width/2;var cx=0;aT=false;switch(bJ){case"stacks":cx=2;A=false;ca=false;break;case"flat":aT=!bP;ao.zoomCenteredImageOnly=false;cx=1;if(!bP){bb=0}else{bb-=b2/2}ca=false;A=true;break;default:cx=2;bJ="carousel";A=false;ca=true;break}if(bJ==="stacks"){bC=aF.width/2-aS/2}else{bC=aF.width/2-aS/4}E();var cv=b0;if(bP){var cy=false;P=0;if(ch===1){cy=true;bR.push(bR[0]);ch++}aE();u();if(cy){bR.pop();ch=1}if(V.length+cx>ch){if(!ao.duplicateImagesIfNeeded){bP=false}else{var cu=(V.length+cx-ch);for(var ct=0;ct<cu;ct++){bR.push(bR[ct%ch])}ch=bR.length}}}aE();E();if(b0<=0){a2=true}b4={height:ao.scrollHeight,padding:ao.scrollPadding,alphaNormal:ao.scrollAlphaNormal,alphaActive:ao.scrollAlphaActive};b4.height=Math.max(3,b4.height);b4.padding=Math.max(0,b4.padding);b4.alpha=b4.alphaTarget=b4.alphaNormal;b4.width=Math.round(aF.width-2*b4.padding);b4.y=Math.round(aF.height-b4.height-b4.padding);if(!a2){var cs=Math.max(0,cv);b4.buttonWidth=Math.round(Math.max(20,b4.width*Math.min(1,aF.width/(aF.width+cs))))}else{b4.buttonWidth=20}b4.range=b4.width-b4.buttonWidth;if(!a2){a2=(b4.buttonWidth>=b4.width)}co=(ch<2);if(!a2){a2=co}if(!bP&&bJ==="flat"&&ch*b2<aF.width){bb=(aF.width-ch*b2)/2}var cz=ao.paddingBottom;if(!a2){cz=Math.max(b4.height,cz)}bd=aF.height-ao.paddingTop-cz;ae=0;ao.mirrorHeight=Math.max(0,Math.min(1,ao.mirrorHeight));if(ao.mirrorHeight>0){ae=Math.round(ao.mirrorHeight*bd/2);ba=(ae>0)}else{ba=false}bd-=ae;if(ca){aM=Math.round(ao.curveHeight*bd)}else{aM=0}aA();if(l!==b){var cw=l.offsetLeft/l.xAdvance;P=cw*b2;l=b}if(bM){P=Math.round(P/b2)*b2}P=aa(P);a4=true;if(bd<1){r.error("Insufficient instance height. Resulting image height is "+bd+"px");return}bx=bR.length;am=aW;aV=m;ar();if(ao.preloadCount>0){R()}if(ap!==0){Z()}};var aE=function(){if(ch<2){bN=o}else{if(aT){bN=h}else{bN=cl}}};var a1=function(){if(b1.isset("onStart")){b1.run("onStart",[ao.dir,bR.length,a.utils.cloneArray(bR)])}G(0);cb()};var E=function(){b0=ch*b2;if(!bP){if(bJ==="flat"){b0-=aF.width}else{b0-=b2}}};var aA=function(){if(!aF||aF.width<1||aF.height<1){return false}if(!B){B=document.createElement("canvas");B.setAttribute("draggable","false");B.style.width=B.style.height="100%";if(a.isIETouch){B.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}B.setAttribute("width",aF.width);B.setAttribute("height",aF.height);ck=B.getContext("2d");w.appendChild(B)}else{B.setAttribute("width",aF.width);B.setAttribute("height",aF.height)}if(ba&&!U){U=document.createElement("canvas");aJ=U.getContext("2d");aI=U.cloneNode();bZ=aI.getContext("2d");bk=U.cloneNode();bU=bk.getContext("2d")}if(ba){var cs=Math.ceil(aS);var cu=Math.ceil((bd+1));U.setAttribute("width",cs);U.setAttribute("height",cu);aI.setAttribute("width",cs);aI.setAttribute("height",cu);bk.setAttribute("width",cs);bk.setAttribute("height",cu);bD=aJ.createLinearGradient(0,0,0,ae);if(cr){bD.addColorStop(0,cg+ao.mirrorStartOpacity+")");bD.addColorStop(1,cg+"0)")}else{bD.addColorStop(0,cg+(1-ao.mirrorStartOpacity)+")");bD.addColorStop(1,cg+"1)")}aJ.strokeStyle=ao.imageBorderColor;aJ.fillStyle=bD;aJ.lineWidth=0;bU.strokeStyle=ao.imageBorderColor}if(ao.backgroundDarkness>0){aj=ck.createLinearGradient(0,0,aF.width,0);var ct="rgba(0,0,0,";aj.addColorStop(0,ct+ao.backgroundDarkness+")");aj.addColorStop(0.4,ct+"0)");aj.addColorStop(0.6,ct+"0)");aj.addColorStop(1,ct+ao.backgroundDarkness+")");bt=true}else{bt=false}if(!at){var cv={};cv.detectClick=true;cv.afterTouch={enabled:true};cv.afterTouch.modifyTarget=bv;cv.afterTouch.factorAmount=23;cv.afterTouch.factorFrames=3.7;cv.afterTouch.minFrames=5;cv.afterTouch.offsetFrames=3;cv.afterTouch.useAnimationFrame=true;cv.detectGestures=true;at=new a.TouchHandler(B,cv,bB,bK,a9);at.setCapture(true,false)}};var bv=function(cv,cs){if(bM){var cu=Q.offsetLeft-Q.x-Q.startX;var ct=Math.round((cv.x+cu)/b2)*b2;cv.x=ct-cu}return cv};var bY=function(){var cs=a.getElementClientPos(B);Q.x=cs.left;Q.y=cs.top};var bB=function(cs,cv,cu){bY();az.x=cv.x-Q.x;az.y=cv.y-Q.y;bO(b4.alphaActive);aw();ap=0;cancelAnimationFrame(be);be=b;P=aa(P);if(O(az.x,az.y)){at.enableAfterTouch(false);Q.scrollOffsetX=0;bO(b4.alphaActive);b4.bDragging=true;bK(cs,cv,cu);af();var ct=b4.padding+b4.x+b4.buttonWidth/2;Q.scrollOffsetX=(ct-az.x)}else{at.enableAfterTouch(true);b4.bImageDragging=true;Q.startX=az.x;Q.startY=az.y;Q.offsetLeft=P}ar();return true};var bK=function(ct,cw,cu){az.x=cw.x-Q.x;az.y=cw.y-Q.y;if(b4.bDragging){var cs=az.x+Q.scrollOffsetX-b4.padding-b4.buttonWidth/2;cs=Math.max(0,Math.min(b0-1,Math.round(cs*b0/b4.range)));P=aa(Math.min(0,Math.max(-cs,-b0)));ar()}else{if(b4.bImageDragging){Q.dx=az.x-Q.startX;Q.dy=az.y-Q.startY;var cv=P;P=aa(Q.offsetLeft+Q.dx);ar();if(cv===P||Math.abs(Q.dy)>3*Math.abs(Q.dx)){ct.FSI_allowEventDefault=true}}}};var a9=function(cA,cv,cB){var cy=cA._FSI_Click;az.x=cv.x-Q.x;az.y=cv.y-Q.y;bO(b4.alphaNormal);if(b4.bDragging){bO(b4.alphaNormal);b4.bDragging=false;if(bM){var cC=Math.round(P/b2)*b2;var cs=Math.round(-aa(cC)/b2);G(cs);bq(cC,true,55)}}else{if(b4.bImageDragging){b4.bImageDragging=false;if(cy){var cx=az.x;var cw=az.y;var cz=0;var ct;for(var cu=0;cu<V.length;cu++){ct=V[cu];if(cx>=ct.x&&cw>=ct.y&&cx<=ct.x+ct.drawWidth&&cw<=ct.y+ct.drawHeight){cz=1;if(b1.isset("onClick")){b1.run("onClick",[ct.nIndex,bR[ct.nIndex]])}if(!ao.zoomCenteredImageOnly||aD===ct.nIndex){if(ao.enableZoom){b9(ct)}}if(ao.centerZoomedImage){cf(ct)}break}}}else{cj()}}}ar()};var cj=function(){if(bM){var cs=Math.round(P/b2)*b2;if(Math.abs(cs-P)>0.5){var ct=Math.round(-aa(cs)/b2);G(ct);bq(cs,true,30)}}};var G=function(cs){aD=cs;aP=b;if(b1.isset("onFocus")){var ct=aO[cs];if(ct){b1.run("onFocus",[ct.nIndex,bR[ct.nIndex]])}}};this.assignFSIViewer=function(cs){if(cs&&typeof(cs)==="string"){if(cs.toLowerCase()==="auto"){var ct=document.getElementsByTagName("fsi-viewer");if(ct&&ct.length>0){cs=ct[0]}else{cs=b}}else{cs=document.getElementById(cs)}}if(!cs||typeof(cs.changeImage)!=="function"){z=b}else{z=cs}aK=false;cb()};var cb=function(){if(!bQ||!z||aK||bR.length<1){return}aK=true;var cs={};cs.path=bR[0];L(cs)};var L=function(cs){if(!cs||!z||typeof(z.changeImage)!=="function"){return}var ct={};ct.fpxsrc=cs.path;ct.imageWidth=cs.sourceWidth;ct.imageHeight=cs.sourceHeight;ct.cropRect=by.cfg.croprect;ct.cropValues=by.cfg.cropvalues;ct.effects=by.cfg.effects;z.changeImage(ct)};var b9=function(cy){if(z!==b){L(cy);return}I(b,true);if(!cy.bReady){return}bT=document.createElement("div");ci=document.createElement("div");x=document.createElement("img");bn.alphaShader=0;var cK=a.utils.getDocumentScale();var cL=ao.zoomBorderWidth/cK;var cD=ao.zIndexZoom;var cE="position:absolute;z-index:"+(cD+1)+";border:"+cL+"px "+ao.zoomBorderStyle+" "+ao.zoomBorderColor+";line-height:0px;box-sizing: content-box;";var cA=ao.zoomBackgroundColor.toLowerCase();if(cA!=="none"&&cA!=="transparent"){cE+="background-color:"+ao.zoomBackgroundColor}bT.setAttribute("style",cE);var cw="position:absolute;z-index:"+cD+";background-color:"+ao.zoomFadeColor+";opacity:0.0;filter:Alpha(opacity=0);";bX=cy.img.cloneNode();bX.style.width=bX.style.height="100%";bT.appendChild(bX);var cx=a.getElementClientPos(B);var cu=a.getElementClientPos(document.body);var cC=-cu.left;var cB=-cu.top;bn.startX=cC+cx.left+cy.x-cL;bn.startY=cB+cx.top+cy.y-cL;bn.startWidth=cy.width;bn.startHeight=cy.height;bT.style.width=bn.startWidth+"px";bT.style.height=bn.startHeight+"px";bT.style.left=bn.startX+"px";bT.style.top=bn.startY+"px";var cJ=a.getViewportSize(window);if(a.getDevicePixelRatio()!==1){cJ.width-=1;cJ.height-=1}a.addEvent(ci,"mousedown",I,false);a.addEvent(window,"touchstart",I,false);a.addEvent(bT,"mousedown",I,false);a.addEvent(window,"scroll",I,false);var cH=Math.ceil(40/cK);var ct=cJ.width-cH-2*cL;var cI=cJ.height-cH-2*cL;var cz=cy.maxWidth;var cG=cy.maxHeight;if(ct/cz<cI/cG){cz=ct;cG=Math.round(cz*cy.maxHeight/cy.maxWidth)}else{cG=cI;cz=Math.round(cG*cy.maxWidth/cy.maxHeight)}if(cz>cy.maxWidth||cG>cy.maxHeight){cz=cy.maxWidth;cG=cy.maxHeight}bn.endWidth=cz;bn.enddHeight=cG;bn.dWidth=cz-bn.startWidth;bn.dHeight=cG-bn.startHeight;bn.endX=window.pageXOffset+Math.round((cJ.width-cz)/2);bn.endY=window.pageYOffset+Math.round((cJ.height-cG)/2);bn.dx=bn.endX-bn.startX;bn.dy=bn.endY-bn.startY;cw+="left:"+window.pageXOffset+"px;top:"+window.pageYOffset+"px;width:"+(cJ.width)+"px;height:"+cJ.height+"px";bn.bImageReady=false;var cv=cy.img.src;cv=cv.replace(aX,"$1");var cs=Math.min(cy.maxWidth,Math.round(cK*cz));var cF=Math.min(cy.maxHeight,Math.round(cK*cG));cv+="&width="+cs+"&height="+cF;aq=true;a.addEvent(x,"load",cc,false);x.style.width=bn.endWidth+"px";x.style.height=bn.endHeight+"px";x.setAttribute("crossorigin","anonymous");x.src=cv;bn.pos=0;bn.frames=b8(20);ci.setAttribute("style",cw);document.body.appendChild(ci);document.body.appendChild(bT);bn.alphaShader=0;cancelAnimationFrame(aU);aU=requestAnimationFrame(au);bn.posFader=0;bn.framesShader=10;bn.startAlpha=bn.alphaShader;bn.endAlpha=ao.zoomFadeOpacity;bn.dAlpha=bn.endAlpha-bn.startAlpha;D=requestAnimationFrame(v);b1.run("onZoomStart",[cy.nIndex,cv]);if(!a.isMobileDevice){a.addEvent(window,"resize",I,false)}else{a.addEvent(window,"orientationchange",I,false)}};var cn=a.Easing.easeOutCubic;var au=function(){bn.pos++;if(bn.pos>bn.frames){aU=b;requestAnimationFrame(cp);return}var cs=cn(bn.pos,bn.frames,bn.startX,bn.dx);var cv=cn(bn.pos,bn.frames,bn.startY,bn.dy);var ct=cn(bn.pos,bn.frames,bn.startWidth,bn.dWidth);var cu=cn(bn.pos,bn.frames,bn.startHeight,bn.dHeight);bT.style.left=cs+"px";bT.style.top=cv+"px";bT.style.width=ct+"px";bT.style.height=cu+"px";aU=requestAnimationFrame(au)};var cp=function(){if(!bT||!bn.bImageReady||aU!==b){return}bT.firstChild.style.width=x.style.width;bT.firstChild.style.height=x.style.height;bT.firstChild.src=x.src;x=b;bT.style.width="";bT.style.height=""};var cc=function(cs){bn.bImageReady=true;a.removeEvent(x,"load",cc,false);aq=false;cp()};var I=this.closeZoom=function(cs,ct){if(!bT){return}aP=b;if(!a.isMobileDevice){a.removeEvent(window,"resize",I,false)}else{a.removeEvent(window,"orientationchange",I,false)}if(D){cancelAnimationFrame(D);D=b}cancelAnimationFrame(aU);aU=b;a.removeEvent(ci,"mousedown",I,false);a.removeEvent(bT,"mousedown",I,false);a.removeEvent(window,"touchstart",I,false);a.removeEvent(window,"scroll",I,false);if(aq){a.removeEvent(x,"load",cc,false)}if(x){x=b}a.removeChild(bT.parentNode,bT);bT=b;if(ct===true){a.removeChild(ci.parentNode,ci);ci=b}else{bn.posFader=0;bn.framesShader=10;bn.startAlpha=bn.alphaShader;bn.endAlpha=0;bn.dAlpha=bn.endAlpha-bn.startAlpha;D=requestAnimationFrame(v)}b1.run("onZoomEnd");if(cs&&cs.touches&&cs.touches.length===1){cs.cancelBubble=true;if(cs.stopPropagation){cs.stopPropagation()}if(cs.preventDefault){cs.preventDefault()}}};var T=function(cs){bn.alphaShader=cs;ci.style.opacity=cs/100;ci.style.filter="Alpha(opacity="+cs+")"};var v=function(){bn.posFader++;if(bn.posFader>bn.framesShader){if(bn.endAlpha===0){a.removeChild(ci.parentNode,ci);ci=b}D=b;return}var cs=cn(bn.posFader,bn.framesShader,bn.startAlpha,bn.dAlpha,3);T(cs);D=requestAnimationFrame(v)};var O=function(cs,ct){return(!a2&&cs>=b4.padding&&ct>=b4.y&&cs<=b4.padding+b4.width&&ct<=b4.y+b4.height)};this.focusImage=function(cs){if(cs<0||cs>=bR){return false}var ct=b6(cs);cf(ct);return true};this.zoomImage=function(cs){if(!ao.enableZoom||!this.focusImage(cs)){return false}var ct=b6(cs);aP=ct.nIndex;ax()};var cf=function(ct,cs){if(!ct){return false}G(ct.nIndex);return bq(-ct.nIndex*b2,cs,30)};var aa=function(cs){if(bP){cs=Math.round(cs)%b0;if(cs>0){cs-=b0}}else{cs=Math.min(0,Math.max(-b0,cs))}return cs};var b8=function(cs){if(a.isMobileDevice){cs=Math.ceil(cs/1.8)}return cs};var bq=function(cv,cs,cu){cu=b8(cu);aw();if(cu===b){cu=40}if(!cs&&bP){cv=aa(cv);P=aa(P);var ct=cv-P;if(Math.abs(ct)>b0/2){if(ct>0){cv=-b0+cv}else{cv=b0+cv}}}if(cv===P||(be!==b&&cv===p.end)){return false}cancelAnimationFrame(be);be=b;p.frames=cu;p.pos=0;p.start=P;p.end=cv;p.diff=p.end-p.start;be=requestAnimationFrame(bI);return true};var bI=function(){p.pos++;if(p.pos===p.frames){P=aa(p.end);be=b;bm();ax();return}P=cn(p.pos,p.frames,p.start,p.diff,3);if(!bP){P=aa(P)}bm();ax();be=requestAnimationFrame(bI)};var cm=function(ct,cv,cw){if(!bQ){return}if(!cv||!cw||cw.nInitID!==cd){return}f--;var cs,cu;cs=parseInt(cv.width);cu=parseInt(cv.height);if(isNaN(cs)&&isNaN(cu)){r.error("Failed to get image info.")}cw.nThumbnailDimWidth=aS;cw.nThumbnailDimHeight=bd;cw.bInfoReady=true;cw.bDrawPlaceHolder=bS;cw.sourceWidth=cs;cw.sourceHeight=cu;if(b5.bLive){bF(cw)}cw.src="&effects="+ao.effects;if(b5.bCrop){cw.rectWidth=b5.rectWidth;cw.rectHeight=b5.rectHeight}a.utils.expandSourceDimensionForPadEffect(cw,aS,bd);if(b5.bCrop){cw.objCropCurrent=(cw.oCrop)?cw.oCrop:b5;cw.maxWidth=Math.round(cw.objCropCurrent.rectWidth*cw.sourceWidth);cw.maxHeight=Math.round(cw.objCropCurrent.rectHeight*cw.sourceHeight)}else{cw.maxWidth=cw.sourceWidth;cw.maxHeight=cw.sourceHeight}aG(cw)};var aG=function(ct){var cz,cv;if(!ct.bInfoReady){return false}ct.nThumbnailDimWidth=aS;ct.nThumbnailDimHeight=bd;if(!ct.bThumbLoading){f++}ct.bThumbLoading=true;ct.bThumbLoadStarted=true;var cw=aS;var cy=bd;if(cw/ct.maxWidth<cy/ct.maxHeight){cz=cw;cv=Math.round(cz*ct.maxHeight/ct.maxWidth)}else{cv=cy;cz=Math.round(cv*ct.maxWidth/ct.maxHeight)}var cx=true;if(cz<1||cv<1){cz=cv=0;cx=false}ct.width=cz;ct.height=cv;ct.offsetX=(cw-cz)/2;ct.offsetY=cy-cv-aM+ao.paddingTop;var cA={width:cz};if(ct.bHasPadEffect){cA.height=cv}if(ct.objCropCurrent){cA.rect=ct.objCropCurrent.query}if(ao.effects.length>0){cA.effects=ao.effects}if(ao.overlays.length>0){cA.overlays=ao.overlays}if(ao.quality.length>0){cA.quality=ao.quality}if(ao.fpxservertemplate.length>0){cA.renderer=ao.fpxservertemplate}var cs=by.getImageURL(ct.path,cA);if(by.hasImageParameterConditions){cs=by.reWriteImageURLByConditions(cs)}var cu;if(ct.img===b){cu=ct.img=document.createElement("img");cu.oSprite=ct;cu.crossOrigin="anonymous"}else{cu=ct.img}ct.nInitID=cd;if(!ct.bHasEvents){aR[ct.nIndex]=ct;ct.bHasEvents=true;a.addEvent(cu,"load",H,false);a.addEvent(cu,"error",N,false)}if(ct.bDrawPlaceHolder){if(ct.myX!==b){b3(ct)}if(bg(ct)){ar()}}if(!cx){N.call(cu)}else{ct.src=cu.src=cs}return true};var bp=function(cs){return(cs.nThumbnailDimWidth===aS&&cs.nThumbnailDimHeight===bd)};var ak=function(cs){return(cs&&cs.nInitID===cd)};var a6=function(cs){if(cs.bHasEvents){delete aR[cs.nIndex];a.removeEvent(cs.img,"load",H,false);a.removeEvent(cs.img,"error",N,false);cs.bHasEvents=false}};var N=function(cs){var ct=this.oSprite;if(!ct){return}ct.bReady=false;ct.bDrawPlaceHolder=false;ct.bLoadComplete=true;ct.bThumbLoading=false;a6(ct);if(ak(ct)){f--}aV()};var H=function(cs){var ct=this.oSprite;if(!ct){return}a6(ct);if(!bQ){return}ct.bReady=true;ct.bLoadComplete=true;ct.bThumbLoading=false;ct.bDrawPlaceHolder=false;if(!ak(ct)){return}f--;if(!bp(ct)){return}F(ct);if(bg(ct)&&ct.myX!==b){b3(ct);ar()}ax();aV()};var ax=function(){if(aP===b){return}var cs=b6(aP);if(!cs.bReady||!bg(cs)){return}b9(cs);aP=b};var b6=function(cu,cx,cs){var cv;cu%=ch;if(cu<0){cu+=ch}if(a8[cu]!==b){return a8[cu]}var cw=aO[cu];if(cw===b){Y++;cw=aO[cu]={};cw.nIndex=cu;var ct=bd;cw.width=aS;cw.height=ct;cw.offsetX=0;cw.offsetY=ct-cw.height-aM+ao.paddingTop;cw.path=bR[cu];cv=true}else{if(cw.bThumbLoadStarted&&(cw.nThumbnailDimWidth!==aS||cw.nThumbnailDimHeight!==bd)){if(cw.bReady){cw.bReady=false;cw.oMirrorData=null;cw.bDrawPlaceHolder=false}cv=true}else{if(!cw.bLoadStarted){cv=true}}}if(cv){cw.bPreload=cx;g.push(cw);if(!cs){am()}}return cw};var k=function(){};var n=function(){am=aV=k;if(bw){clearTimeout(bw);bw=b}};var aW=function(){if(!bw){bw=setTimeout(m,50)}};var m=function(){if(bw){clearTimeout(bw);bw=b}while(g.length>0&&f<ag){var ct=g.shift();if(a8[ct.nIndex]===b&&(ct.bPreload||bg(ct))){a8[ct.nIndex]=ct;W++;if(W===ch){n()}bx--;ct.bLoadStarted=true;ct.nInitID=cd;if(!ct.bInfoLoading){f++;ct.bInfoLoading=true;var cs=by.getImageInfoURL(ct.path);by.loadFile(cs,cm,b,ct)}else{aG(ct)}}}};var aY=function(cu,cs){if(!bP&&(cu<0||cu>=ch)){return 0}var cv=b6(cu,false,true);cv.nImage=cu;cv.myX=cs;var ct=b3(cv);if(ct){V.push(cv)}return ct};var b3=function(cw){var cu,cv;if(A){var ct=bb+cw.myX;cv=(ct+b2>=0&&ct<=aF.width)?1:0;cw.z=1}else{cu=cw.myX/bC;cv=Math.cos(cu/1.3);if(ca){cw.z=cv}else{cw.z=1}}if(cv<ao.depthFadeout){ac[cw.nIndex]=false;return 0}cw.drawWidth=cw.z*cw.width;cw.drawHeight=cw.z*cw.height;ac[cw.nIndex]=true;if(A){cw.x=bb+cw.myX+Math.round((b2-cw.width)/2)}else{var cs=bC*Math.sin(cu);cw.x=bb+cs-cw.drawWidth/2}if(ca){cw.y=aM*cw.z+cw.offsetY+(cw.height-cw.drawHeight)}else{cw.y=cw.offsetY+(cw.height-cw.drawHeight)}return 1};var bg=function(cs){if(!cs){return false}return ac[cs.nIndex]};var u=function(){if(g.length>0){g=[]}V=[];ac={};var cv;var ct;if(A){ct=aa(P)}else{ct=P}if(ct>0){cv=Math.ceil(-ct/b2)}else{cv=Math.floor(-ct/b2)}var cs=ct%b2;aY(cv,cs);var cu=bN(cv,cs);if(S.interval!==b&&be===b){S.nLastLeftImage=cv-cu+1;S.nLastRightImage=cv+cu-1;S.nLoad=ao.preloadCount}};var o=function(){return 0};var cl=function(cv,cs){var cw;var cu=0;var ct=0;do{cu+=b2;ct++;cw=aY(cv-ct,cs-cu);cw+=aY(cv+ct,cs+cu)}while(cw>0&&ct<ch);return ct};var h=function(cv,cs){var cw;var cu=0;var ct=0;do{cu+=b2;ct++;cw=aY(cv+ct,cs+cu)}while(cw>0&&ct<ch);return ct};var R=function(){if(S.interval!==b){return}S.interval=setInterval(aC,100)};var bV=function(){clearInterval(S.interval);S.interval=b};var aC=function(){if(g.length>0||S.nLoad<=0){return}if(bx<1){bV();return}while(g.length<2&&S.nLoad>0){if(!aT){b6(--S.nLastLeftImage,true,true);S.nLoad--}b6(++S.nLastRightImage,true,true);S.nLoad--}aV()};var ar=function(){if(q!==b){return}q=requestAnimationFrame(bm)};var bm=function(){if(q!==b){cancelAnimationFrame(q);q=b}if(K){return}u();aL();am()};var br=function(){if(!bQ){return}ck.globalCompositeOperation="source-over";ck.globalAlpha=1;ck.clearRect(0,0,aF.width,aF.height);ck.strokeStyle=ao.imageBorderColor;ck.lineWidth=0;for(var cu=V.length-1;cu>-1;cu--){var cv=V[cu];if(cv.bReady){ck.drawImage(cv.img,cv.x,cv.y,cv.drawWidth,cv.drawHeight);if(i){ck.strokeRect(cv.x+0.5,cv.y+0.5,cv.drawWidth-1,cv.drawHeight-1)}}else{if(cv.bDrawPlaceHolder){ck.fillStyle=ao.placeHolderColor;ck.fillRect(cv.x,cv.y,cv.drawWidth,cv.drawHeight);if(i){ck.strokeRect(cv.x+0.5,cv.y+0.5,cv.drawWidth-1,cv.drawHeight-1)}}}if(cv.oMirrorData){var ct=cv.y+cv.drawHeight;var cw=Math.abs(cv.z)*cv.nMirrorWidthOut;var cs=Math.abs(cv.z)*cv.nMirrorHeightOut;if(!ce){ck.clearRect(cv.x,ct,cw,cs)}if(cv.bCorsFix){ck.drawImage(cv.mirrorCanvas,0,0,cv.nMirrorWidth,cv.nMirrorHeight,cv.x,ct,cw,cs)}else{bZ.clearRect(0,0,cv.nMirrorWidth,cv.nMirrorHeight);bZ.putImageData(cv.oMirrorData,0,0);ck.drawImage(aI,0,0,cv.nMirrorWidth,cv.nMirrorHeight,cv.x,ct,cw,cs)}}}if(bt){ck.globalCompositeOperation="source-atop";ck.fillStyle=aj;ck.fillRect(0,0,aF.width,aF.height)}e()};var J=function(){var cu,cv;if(!bQ){return}ck.globalCompositeOperation="source-over";ck.globalAlpha=1;ck.clearRect(0,0,aF.width,aF.height);ck.strokeStyle=ao.imageBorderColor;ck.lineWidth=0;for(cu=V.length-1;cu>-1;cu--){cv=V[cu];if(cv.bReady){ck.drawImage(cv.img,cv.x,cv.y,cv.drawWidth,cv.drawHeight);if(i){ck.strokeRect(cv.x+0.5,cv.y+0.5,cv.drawWidth-1,cv.drawHeight-1)}}else{if(cv.bDrawPlaceHolder){ck.fillStyle=ao.placeHolderColor;ck.fillRect(cv.x,cv.y,cv.drawWidth,cv.drawHeight);if(i){ck.strokeRect(cv.x+0.5,cv.y+0.5,cv.drawWidth-1,cv.drawHeight-1)}}}}if(bt){ck.globalCompositeOperation="source-atop";ck.fillStyle=aj;ck.fillRect(0,0,aF.width,aF.height)}ck.globalCompositeOperation="destination-over";for(cu=0;cu<V.length;cu++){cv=V[cu];if(cv.oMirrorData){var ct=cv.y+cv.drawHeight;var cw=Math.abs(cv.z)*cv.nMirrorWidthOut;var cs=Math.abs(cv.z)*cv.nMirrorHeightOut;if(cv.bCorsFix){ck.drawImage(cv.mirrorCanvas,0,0,cv.nMirrorWidth,cv.nMirrorHeight,cv.x,ct,cw,cs)}else{bZ.clearRect(0,0,cv.nMirrorWidth,cv.nMirrorHeight);bZ.putImageData(cv.oMirrorData,0,0);ck.drawImage(aI,0,0,cv.nMirrorWidth,cv.nMirrorHeight,cv.x,ct,cw,cs)}}}e()};var bO=function(cs){if(a2||b4.alphaTarget===cs){return}b4.alphaTarget=cs;ar()};var af=function(){var cs=aa(P);b4.x=Math.min(b4.range,-cs/b0*b4.range)};var e=function(){if(a2){return}af();ck.globalCompositeOperation="source-over";if(b4.alpha!==b4.alphaTarget){if(Math.abs(b4.alpha-b4.alphaTarget)>0.01){b4.alpha+=(b4.alphaTarget-b4.alpha)/10;ar()}else{b4.alpha=b4.alphaTarget}}ck.globalAlpha=b4.alpha;ck.fillStyle=ao.scrollColor;var cw=b4.y;var cu=cw+b4.height-1;var cv=cu-cw-1;ck.fillRect(b4.padding,cw,b4.width,1);ck.fillRect(b4.padding,cu,b4.width,1);cw++;ck.fillRect(b4.padding,cw,1,cv);ck.fillRect(b4.width-1,cw,1,cv);var cs=Math.max(1,Math.round(b4.x));var ct=Math.min(b4.buttonWidth,b4.width-1-cs);ck.fillRect(b4.padding+cs,b4.y+1,ct,b4.height-2)};var F=function(cw){if(!ba||!bQ){return}var cu=c;cu=Math.min(cu,Math.min(cw.img.width/20,cw.img.height/20));var cs=Math.min(U.width,cw.img.width/cu);var ct=Math.min(U.height,cw.img.height/cu);var cy=Math.min(ae/cu,Math.floor(ct*ao.mirrorHeight));var cx=ct-cy;aJ.save();aJ.globalCompositeOperation="source-over";if(!cr){aJ.clearRect(0,0,cs,cy);aJ.scale(1,-1);aJ.drawImage(cw.img,0,cx*cu,cs*cu,cy*cu,0,-cy,cs,cy);aJ.restore();aJ.save();if(i){aJ.strokeRect(0,0,cs,ct)}aJ.scale(1,cy/ae);aJ.fillRect(0,0,cs+1,ae+1)}else{aJ.clearRect(0,0,cs,cy);aJ.scale(1,cy/ae);aJ.fillRect(0,0,cs+1,ae+1);aJ.restore();aJ.save();aJ.globalCompositeOperation="source-in";aJ.scale(1,-1);if(i){bU.clearRect(0,0,cs,cy);bU.drawImage(cw.img,0,cx*cu,cs*cu,cy*cu,0,0,cs,cy);bU.strokeRect(0,0,cs,cw.height);aJ.drawImage(bk,0,0,cs,cy,0,-cy,cs,cy)}else{aJ.drawImage(cw.img,0,cx*cu,cs*cu,cy*cu,0,-cy,cs,cy)}}aJ.restore();try{cw.oMirrorData=aJ.getImageData(0,0,cs,cy)}catch(cv){cw.mirrorCanvas=U.cloneNode();cw.oMirrorData=cw.mirrorCanvas.getContext("2d");cw.oMirrorData.drawImage(U,0,0);cw.bCorsFix=true}cw.nMirrorWidth=cs;cw.nMirrorHeight=cy;cw.nMirrorWidthOut=cs*cu;cw.nMirrorHeightOut=cy*cu};var Z=function(){if(a5!==b){return}a5=requestAnimationFrame(X)};var X=function(){P=aa(P+ap);ar();a5=requestAnimationFrame(X)};var aw=function(){if(a5===b){return}cancelAnimationFrame(a5);a5=b};var bj=function(){var cs=a.getElementDimension(w);if(cs.width<1){cs.width=1}if(cs.height<1){cs.height=1}return cs};var bi=function(){aF=aQ=bj()};var b7=function(cs){if(!a4||cq.length<1){return}if(l===b){l={};l.offsetLeft=P;l.xAdvance=b2;l.nCenter=bb}if(cs.FSI_after_treshold!==b){aw();cancelAnimationFrame(be);K=false;at.enable(true);n();bV();g=[];bi();if(aF.width>1&&aF.height>1){if(B){B.style.display="block"}var ct=aF.height/y.height;aS=Math.round(bz.width*ct);bl=Math.round(bz.spacing*ct);bH()}else{}return}if(!K){K=true;at.cancel();at.enable(false);if(B){ck.clearRect(0,0,aF.width,aF.height)}}};this.destroyOnDetach=function(){if(ao&&ao.autoDestroy!==false){M()}};this.addListener=function(cv,ct,cu){var cs=false;if(b1){cs=b1.addListener(cv,ct,cu)}return cs};this.removeListener=function(cu,ct){var cs=false;if(b1){cs=b1.removeListener(cu,ct)}return cs};var M=this.destroy=function(){if(by){by.destroy()}if(!bQ){return}bQ=false;bh.removeAttribute("x-fsi-id");n();bV();for(var cs in aR){a6(aR[cs])}aR={};if(bc!==b){a.removeCustomEvent(bh,"FSIElementDimension",b7);bc=b}g=[];aw();aP=b;I(b,true);aD=0;cancelAnimationFrame(aU);cancelAnimationFrame(q);q=b;cancelAnimationFrame(be);be=b;cancelAnimationFrame(D);D=b;V=[];S={};Y=0;if(at){at.destroy();at=b}P=bW=0;a3=b;bR=[];if(B){a.removeChild(w,B);B=b}ck=b;aI=bZ=aJ=U=bU=bk=b;b5={};ac={};f=0;a.removeChild(w.parentNode,w);if(b1){b1.run("onDestroy");b1.destroy()}}};a.customTags.register("fsi-imageflow",{constructorClass:a.ImageFlow,viewerCSS:"display:block;width:300px;height:300px;"});a.dispatchEvent("FSIImageFlowLoaded")}(window.$FSI=window.$FSI||{}));