/*!
 * FSI Pages
 * Build: 18.07.06.1
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};k.getElementMargins=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.marginLeft);i.top=parseFloat(q.marginTop);i.right=parseFloat(q.marginRight);i.bottom=parseFloat(q.marginBottom)}catch(r){}return i};k.getElementBorders=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.borderLeftWidth);i.top=parseFloat(q.borderTopWidth);i.right=parseFloat(q.borderRightWidth);i.bottom=parseFloat(q.borderBottomWidth)}catch(r){}return i};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r===undefined)?"":strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2018",strBuild:"18.07.06.1"});this.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};this.cloneArray=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.urlDecode=function(str){if(!str){return str}var ret=str.replace(regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return window.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var f={};var e=false;var d=this.initCustomTags=function(){if(a.BrowserSupports.registerElement()){return false}for(var g in f){c(g)}return true};var c=this.initCustomTag=function(k){if(a.BrowserSupports.registerElement()){return false}var j=f[k];if(!j){return false}var g=document.getElementsByTagName(k);if(g.length>0){j.replaceTagInit()}if(g&&g.length>0){for(var h=0;h<g.length;h++){j.replaceTag(g[h])}}return true};this.register=function(h,g){if(f[h]===b){f[h]=new a.CustomTag(h,g);if(!e){e=true;if(!a.BrowserSupports.registerElement()){a.addEvent(window,"DOMContentLoaded",d)}}}return f[h]}};a.CustomTag=function(e,c){var k=this;var f;var j=function(){if(a.BrowserSupports.registerElement()){i()}};var d=function(m,n){var l=m.getAttribute(n);if(typeof(l)==="string"&&l.length>0){if(!l.match(/[^0-9\s]/)){l+="px"}m.style[n]=l}};var h=function(l){d(l,"width");d(l,"height")};var g=function(o){var l=a.utils.attributes2parameters(o);if(c.parameterAliases){var p=c.parameterAliases;for(var n in p){var m=p[n];if(l[n]!==b&&l[m]===b){l[m]=l[n]}}}if(l.src!==b&&l.imagesrc===b){l.imagesrc=l.src}return l};var i=function(){a.utils.addViewerClassCSSRule(e,c.viewerCSS);var l=Object.create(HTMLDivElement.prototype);l.createdCallback=function(){h(this);c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};l.attachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}this.init(this,g(this));if(this.start){this.start()}};l.detachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};document.registerElement(e,{prototype:l})};this.replaceTag=function(l){if(!l||(typeof(l.getInitDone)==="function"&&l.getInitDone())){return}h(l);c.constructorClass.prototype.constructor.call(l,l,g(l));if(l.start){l.start()}};this.replaceTagInit=function(){if(f){return}f=true;a.utils.addViewerClassCSSRule(e,c.viewerCSS)};j()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!=b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.utils.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m==b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m==b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(e){if(k.readyState!=4){return}delete c[n];if(m==b||this.FSIaborted){return}var r=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,r,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(ai,w,e){if(typeof(e)!=="object"){e={}}if(!w||typeof(w)!=="object"){w={}}var m=this;this.parameters=(ai&&typeof(ai)==="object")?ai:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Y=false;var N={};var A=0;var q;var ac={};var H=m.debug=new a.EmptyDebugger();var D=false;var x={};var an=false;var S={stickynotes:"bookmarks"};var f;var X=false;var s;var K;var ae;var c;var l;var u="token";var v;var o;if(a.isInternetExplorer&&a.versionInternetExplorer<10){o=function(ap){var ao;if(!a.utils.isCrossDomain(ap)){an=false;ao=new XMLHttpRequest()}else{an=true;ao=new XDomainRequest()}return ao}}else{if(typeof(XMLHttpRequest)!=="undefined"){o=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(aq){m.reset();s=(typeof(e.strSection)==="string")?e.strSection:"";K=s.toLowerCase();if(typeof(e.strTraceParam)==="string"){var ao=e.strTraceParam.toLowerCase();c={};c[ao]=true;if(ao.indexOf("_")>0&&ao.indexOf("pages")===0){ao=ao.split("_");ao.shift();ao=ao.join("_");c[ao]=true}var ap=m.getParameterAlias(ao);if(ap){c[ap]=true}}else{c=false}if(aq){if(m.parameters){m.parameters=a.utils.mergeObjects(m.parameters,aq)}else{m.parameters=aq}}ah(m.parameters);m.getQueryParameters();m.cloneParameters(m.cfgDefaults,m.cfg);m.cloneParameters(m.queryParameters,m.cfg);m.elevateToHTTPS();d();m.locationFSIViewer="";if(m.queryParameters.fsiviewerlocation!==b){m.locationFSIViewer=m.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());m.locationFSIViewer=a.getViewerLocation()}if(m.locationFSIViewer.charAt(m.locationFSIViewer.length-1)!=="/"){m.locationFSIViewer+="/"}m.nextConfigURL=m.getReloadPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.defaultcfg));m.checkDebug(false)};var ah=this.makeObjectPropertiesLowerCase=function(ao){for(var ap in ao){var aq=ap.toLowerCase();if(ap!==aq){if(ao[aq]===b){ao[aq]=ao[ap]}delete ao[ap]}}};this.getClassParameters=function(){return ae};this.setAccessToken=function(ao){v=ao};this.getParameterAlias=function(aq){var ao;if(m.cfgAliasNames[aq]){ao=m.cfgAliasNames[aq]}else{for(var ap in m.cfgAliasNames){if(m.cfgAliasNames[ap]===aq){ao=ap;break}}}return ao};var d=function(){Y=m.makeBool(m.cfg.usenc,false);if(m.cfg.usencquery!==b&&m.cfg.usencquery.length>0){D=m.cfg.usencquery;Y=true;m.queryToObject("?"+D,x)}};this.stopPendingRequests=function(){for(var ap in N){var ao=N[ap];if(ao){ao.FSIaborted=true;if(ao.abort){ao.abort()}}}};this.destroy=function(){m.stopPendingRequests()};this.reset=function(){ae={};m.parameters={};H=m.debug=new a.EmptyDebugger();m.stopPendingRequests();q=Math.random();m.nIncludedConfigs=0;m.completedConfigs={};m.plugins={};m.cfg={};m.queryParameters=b;m.arUnrecognizedConfigNodes=[];aj=0;m.arConditions=[];ac={}};this.getQueryParameters=function(){if(m.queryParameters!==b){return}m.queryParameters={};m.cloneParameters(m.parameters,m.queryParameters)};this.makeBool=function(ar,ao){if(typeof(ao)!=="boolean"){ao=false}var ap=ao;switch(typeof(ar)){case"string":var aq=a.makeBool(ar);if(aq!==b){ap=aq}break;case"number":ap=Boolean(ar);break;case"boolean":ap=ar;break}return ap};this.parsePositionParameter=function(ap){if(typeof(ap)!=="string"||ap.length<3){return b}ap=ap.split(",");if(ap.length<3){return b}for(var ao=0;ao<3;ao++){ap[ao]=parseFloat(ap[ao]);if(isNaN(ap[ao])){ap[ao]=0}}return{x:ap[0],y:ap[1],z:ap[2]}};this.logLoadFileFailed=function(ao){if(!H.on){return}if(ao&&ao.status!==b){var aq="HTTP "+ao.status;if(ao&&ao.statusText){aq+=", "+ao.statusText}var ap=(ao._url)?ao._url:"";H.error("Failed to load "+ap+" ("+aq+")")}else{H.error("Failed loading a file");if(ao&&ao._url){H.error(ao._url)}}};this.getAttributeValue=function(ap,ao){if(!ap){return}return ap.getAttribute(ao)};this.getImageURL=function(aq,ao){var ap;if(aq===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="image"}if(ao.renderer===b){ao.renderer="jpeg"}if(v){ao[u]=v}ao.source=aq;for(ap in ac){if(ac[ap]!==b&&ao[ap]===b){ao[ap]=ac[ap]}}for(ap in aa){if(ao[ap]){if(aa[ap]!==ap){if(!ao[aa[ap]]){ao[aa[ap]]=ao[ap]}ao[ap]=null}}}return m.requestBase+"?"+m.objectToQuery(ao)};this.getImageInfoURL=function(ap,ao){if(ap===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="info"}if(ao.tpl===b){if(m.cfg.fpxinfotemplate!==b){ao.tpl=m.cfg.fpxinfotemplate}else{ao.tpl="info.json"}}if(m.cfg.headers&&m.cfg.headers.length>0){ao.headers=m.cfg.headers}if(!ao.tpl.match(/.json$/)){ao.tpl+=".json"}ao.source=ap;if(v){ao[u]=v}return m.requestBase+"?"+m.objectToQuery(ao)};this.queryToObject=function(at,aq){if(aq===b){aq={}}var ar,av,au,ao,ap;ar=at.indexOf("?");if(ar!==-1){ap=at.slice(ar+1)}else{ap=""}ar=ap.indexOf("#");if(ar!==-1){ap=ap.substring(0,ar)}ap=ap.split("&");for(ar=0;ar<ap.length;ar++){av=ap[ar].split("=");au=a.utils.urlDecode(av[0]).toLowerCase();if(au.length>0){ao=a.utils.urlDecode(av[1]);aq[au]=ao}}return aq};this.parseSceneSets=function(ao,at){var aA={};if(at===b){at=true}var aF=[];var aD=0;var aB=0;var aq;var av,au,ar,az,ax,aE;var aw,ay,aC;var ap=m.cfg.scenesets;if(ao>1&&ap!==b&&typeof(ap)==="string"){ay=ap.split(";");for(av=0;av<ay.length;av++){aC=[];aw=ay[av].split(",");aB=0;for(au=0;au<aw.length;au++){aE=aw[au].split("-");az=ax=0;if(aE.length===1){az=parseInt(aE[0])}else{az=parseInt(aE[0]);if(isNaN(az)){az=1}aq=false;if(aE[1].charAt(0)===">"){aE[1]=aE[1].substr(1);if(!isNaN(parseInt(aE[1]))){aq=true}}ax=parseInt(aE[1]);if(isNaN(ax)){ax=ao}if(az>0&&ax>0&&az<=ao&&ax<=ao){if(aq===true||az!==ax){if(aq!==true){if(ax<az){for(ar=az;ar>=ax;ar--){aC[aB]=ar;aB++}}else{for(ar=az;ar<=ax;ar++){aC[aB]=ar;aB++}}}else{for(ar=az;ar<=ao;ar++){aC[aB]=ar;aB++}for(ar=1;ar<=ax;ar++){aC[aB]=ar;aB++}}}}}if(az>0&&az<=ao&&(ax===0||ax===az)){aC[aB]=az;aB++}}if(aB>0){aF[aD]={};aF[aD].arScenes=[];aF[aD].arScenes=aF[aD].arScenes.concat(aC);aD++}}}if(aD===0){aA.bDefault=true;if(at){aF[0]={};aF[0].arScenes=[];for(av=0;av<ao;av++){aF[0][av]=av}}}aA.nSceneSets=aD;aA.bHasMultipleSets=(aA.nSceneSets>1);aA.arSets=aF;aA.nCurrent=1;return aA};this.objectToQuery=function(ap){var ao=[];var at,aq;if(Y&&D!==false){for(at in x){ap[at]=x[at]}}for(at in ap){aq=ap[at];if(aq!==null){aq=encodeURIComponent(aq);ao.push(encodeURIComponent(at)+"="+aq)}}return ao.join("&")};this.loadImageInfo=function(ar,ao,aq){var ap=m.getImageInfoURL(ar);m.loadFile(ap,ao,b,aq)};this.loadFile=function(at,ar,aq,ax,aw,ap,au){if(!at||at.length<0){if(ar){setTimeout(function(){ar(null,"",ax)},0)}return}if(aw===b){aw="GET"}if(ap===b){ap=null}else{if(typeof(ap)==="object"){ap=m.objectToQuery(ap)}}if(aq===b){aq="application/json"}var av=o(at);if(aq&&av.overrideMimeType){av.overrideMimeType(aq)}av._url=at;var ao=A;N[A]=av;A++;if(an){av.onerror=function(){delete N[ao];if(ar===b||this.FSIaborted){return}m.logLoadFileFailed(this)};av.onload=function(){delete N[ao];if(ar===b||this.FSIaborted){return}var ay=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var az=new ActiveXObject("Microsoft.XMLDOM");az.async=false;az.loadXML(ay);ay=this.responseXML=az}catch(aA){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(at)}break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(aA){H.error("Failed parsing JSON from URL: "+at+" ("+aA.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}else{av.onreadystatechange=function(){var ay;if(av.readyState!==4){return}delete N[ao];if(this.FSIaborted||typeof(ar)!=="function"){return}if(this.status>299){m.logLoadFileFailed(this)}switch(aq){case"application/xml":case"text/xml":ay=this.responseXML;break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(az){H.error("Failed parsing JSON from URL: "+at+" ("+az.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}av.open(aw,at,true);if(au&&v){av.setRequestHeader("x-token",v)}if(ap){av.setRequestHeader("Content-type","application/x-www-form-urlencoded");av.send(ap)}else{av.send()}return av};this.loadConfigs=function(){ae=(s.length>0)?{}:false;f=true;m.loadNextConfig(true)};this.loadNextConfig=function(ap){if(m.nextConfigURL===b){W();return}var aq={};if(e.bPreventCaching||m.makeBool(m.cfg.debug)||(!ap&&!m.makeBool(m.cfg.configcaching,true)&&m.makeBool(m.cfg.enableconfigcachingparameter))){m.addNoCacheParams(aq)}m.finishRequestParams(aq);var ao=m.addURLParameters(m.nextConfigURL,aq);H.log("Loading config file: "+ao);m.loadFile(ao,E,"application/xml")};this.setDebugger=function(ao){H=m.debug=ao};this.checkDebug=function(aq){if(e.bNoDebug){return}var ap;var ao;if(m.parameters.debug!==b){ao=m.makeBool(m.parameters.debug)}else{ao=m.makeBool(m.cfg.debug)}if(ao){if(!H||!H.on){H=m.debug=new a.Debugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}else{if(!H||H.on===true){H=m.debug=new a.EmptyDebugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}return ap};var E=function(ao){var aq=ao.responseXML;l=m.nextConfigURL;m.parseConfig(aq);l=b;m.elevateToHTTPS();if(m.checkDebug(true)===true){return}d();if(f&&e.bCaptureDefaultCfg){f=false;m.cfgFromDefaultConfig=a.utils.cloneValue(m.cfg)}var ap;if(m.cfg.includeconfig!==b&&m.nIncludedConfigs<10){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.includeconfig));m.nIncludedConfigs++;m.cfg["_includeconfig("+m.nIncludedConfigs+")"]=m.cfg.includeconfig;m.cfg.includeconfig=b}else{if(m.cfg.cfg!==b){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.cfg))}}if(ap!==b&&!m.completedConfigs[ap]){m.completedConfigs[ap]=true;m.nextConfigURL=ap;m.loadNextConfig()}else{m.evaluateQuery(m.queryParameters,m.cfg);W()}};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!m.makeBool(m.cfg.autoelevatetohttps,true)){return}h("fpxbase");h("fpxserver")};var h=function(ao){if(m.cfg[ao]!==b&&m.cfg[ao].length>0&&m.cfg[ao].indexOf("http://")===0){m.cfg[ao]="https"+m.cfg[ao].substr(4)}};this.evaluateQuery=function(ap,ao){for(var aq in ap){m.setConfigParamByValue(ao,aq.toLowerCase(),ap[aq])}};this.parseConfig=function(ap,aq){var aA="";var au;var aw=false;if(ap!==b){if(aq===b){aq=ap.firstChild}if(aq&&aq.nodeName==="xml"){aq=aq.nextSibling}var az=aq.childNodes;for(var av=0;av<az.length;av++){var at=az[av];if(at.nodeType!==1){continue}var ax;if(at._myTagName!==b){ax=at._myTagName}else{ax=at.nodeName.toLowerCase()}aA=ax;var ar=at.childNodes;aw=false;switch(ax){case"licence":break;case"if":m.arConditions.push(at);break;case"plugins":for(au=0;au<ar.length;au++){m.parsePluginNode(ar[au])}break;case K:aw=true;case"info":case"options":aA=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(au=0;au<ar.length;au++){var ay=ar[au];if(ay.nodeType!==1){continue}if(ay.tagName==="if"){ay._myTagName=ax;m.arConditions.push(ay)}else{var ao=m.getValueFromXMLNode(ay,aA);if(aA===b&&ae){if(aw){m.setConfigParam(ae,ao,null,true);m.setConfigParam(m.cfg,ao,ay)}else{if(ae[ao.name]===b){m.setConfigParam(m.cfg,ao,ay)}}}else{m.setConfigParam(m.cfg,ao,ay)}}}break;default:m.arUnrecognizedConfigNodes.push(at)}}}};this.getData=function(){var ao={};ao.cfg={};for(var ap in m.cfg){ao.cfg[ap]=m.cfg[ap]}return ao};this.setData=function(ao){if(!ao||!ao.cfg){return}m.cfg={};this.setCfgValues(ao.cfg)};this.setCfgValues=function(ao){for(var ap in ao){m.cfg[ap]=ao[ap]}V()};this.getImagesNodeList=function(aq){var ao=[];if(aq===b){aq=m.getUnrecognizedConfigNode("images")}if(aq){var ar=aq.firstChild;while(ar){if(ar.nodeType===1){var ap={};ap.attributes={};M(ar,ap.attributes);ap.cfg={};m.parseConfigFragment(ar,ap.cfg);ao.push(ap)}ar=ar.nextSibling}}return ao};this.removeUnrecognizedConfigNodes=function(){m.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ar){var ao;ar=ar.toLowerCase();for(var ap=m.arUnrecognizedConfigNodes.length-1;ap>-1;ap--){var aq=m.arUnrecognizedConfigNodes[ap];if(aq&&aq.nodeName.toLowerCase()===ar){ao=aq;break}}return ao};this.parseConfigFragment=function(ap,aw,av){var aA="";if(ap!==b&&aw!==b){if(av===b){av=[]}var az=ap.childNodes;for(var au=0;au<az.length;au++){var ar=az[au];if(ar.nodeType!==1){continue}var ax=ar.nodeName.toLowerCase();aA=ax;var aq=ar.childNodes;switch(ax){case"info":case"options":aA=b;case"fpx":case"image":case"include":for(var at=0;at<aq.length;at++){var ay=aq[at];if(ay.nodeType!==1){continue}var ao=m.getValueFromXMLNode(ay,aA);m.setConfigParam(aw,ao,ay)}break;default:av.push(ar)}}}};this.findXMLNode=function(ap,ao){if(ap===b||ap.nodeType===b){return b}while(ap){if(ap.nodeName.toLowerCase()===ao){break}if(ap.firstChild){ap=ap.firstChild}else{if(ap.nextSibling){ap=ap.nextSibling}else{ap=ap.parentNode.nextSibling}}}return ap};this.getValueFromXMLNode=function(aq,ao){if(!aq||aq.nodeType!==1){return}var ap={};var ar=(ao)?ao:"";ap.name=ar+aq.nodeName.toLowerCase();var at=aq.getAttribute("value");if(at){ap.value=at;return ap}ap.value=m.XMLChildNodesToString(aq);ap.node=aq;return ap};this.getXMLNodeAttribute=function(ar,aq,ao){if(!ar||ar.nodeType!==1||!ar.getAttribute){return ao}var ap=ar.getAttribute(aq);if(ap===b||ap==null){ap=ao}return ap};this.XMLChildNodesToString=function(aq,ap){var ao="";if(!aq||!aq.firstChild){return ao}if(aq.childNodes.length===1&&aq.firstChild.nodeType===3){ao=aq.firstChild.nodeValue}else{ao=aq.innerHTML}if(ap!==b){ao=ao.replace(/[\x00-\x1f]/g,ap)}return ao};this.hasPlugin=function(ao){return(m.plugins&&m.plugins[ao]!==b)};this.getPluginParameter=function(av,ap,ao,au,aw){av=av.toLowerCase();ap=ap.toLowerCase();if(m.plugins[av]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+av+"."+ap);return ao}var at;var ar=av+"_"+ap;if(aw&&m.cfg[ar]===b){ar=ap}if(m.cfg[ar]!==b){at=m.cfg[ar]}else{if(ae&&ae[ap]!==b&&K==="pages"){at=ae[ap]}else{var aq=m.plugins[av].parameters;if(aq!==b&&aq[ap]!==b){at=aq[ap]}}}if(at===b){at=ao}if(au){at=m.makeBool(at,ao)}return at};var Q=this.getAllPluginParameters=function(ap){ap=ap.toLowerCase();var aq=a.utils.cloneObject(m.plugins[ap].parameters);var at=ap+"_";var ao=at.length;for(var au in m.cfg){if(au.toLowerCase().indexOf(at)===0){var ar=au.substr(ao);aq[ar]=m.cfg[au]}}return aq};this.getIntParameterMinMax=function(ap,aq,ao,ar){return Math.min(ar,Math.max(ao,m.getIntParameter(ap,aq)))};this.getIntParameter=function(ap,aq){var ao=parseInt(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};this.getStringParameter=function(ap,aq){var ao=m.cfg[ap.toLowerCase()];if(ao===b){ao=aq}return ao};this.getFloatParameter=function(ap,aq){var ao=parseFloat(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};var M=function(au,ap){if(!au||!au.attributes||!au.attributes.length||!ap){return false}var aq=au.attributes;for(var at=0;at<aq.length;at++){var ao=aq[at];var ar=ao.nodeName.toLowerCase();ap[ar]=ao.value}return true};this.parsePluginNode=function(aq){if(aq.nodeType!==1){return}var at={};M(aq,at);var ar=aq.childNodes;for(var ao=0;ao<ar.length;ao++){var au=ar[ao];if(au.nodeType!==1){continue}var ap=m.getValueFromXMLNode(au);if(ap.value!==b){at[ap.name]=ap.value;if(ap.node!==b){at[ap.name+".node"]=ap.node}}}this.addPluginFromString(at.src,at)};this.clone=function(){var ao=new a.Config(ai,w,e);ao.init();ao.cfg=a.utils.cloneObject(m.cfg);ao.plugins=a.utils.cloneObject(m.plugins);ao.arPlugins=a.utils.cloneArray(ao.arPlugins);ao.arUnrecognizedConfigNodes=a.utils.cloneArray(ao.arUnrecognizedConfigNodes);ao.setImageQueryParameters(ac);ao.arConditions=a.utils.cloneArray(m.arConditions);ao.hasImageParameterConditions=m.hasImageParameterConditions;return ao};this.setImageQueryParameters=function(ao){ac=a.utils.cloneObject(ao)};this.addPluginsFromString=function(aq){if(typeof(aq)!=="string"||aq.length<1){return}var ao=aq.split(",");for(var ap=0;ap<ao.length;ap++){var ar=a.trim(ao[ap]);m.addPluginFromString(ar)}};this.addPluginFromString=function(ar,at){if(typeof(ar)!=="string"||ar.length<1){H.error("PLUGIN without src parameter:");return}ar=ar.toLowerCase();if(S[ar]!==b){ar=S[ar]}if(at===b){at={}}var ap=m.plugins[ar]={};ap.name=ar;if(at.src===b){at.src=ar}ap.parameters=at;if(c){for(var au in c){if(au.indexOf(ar+"_")===0){var aq=ar+"_";var ao=au.substr(aq.length);if(typeof(ap.parameters[ao])!=="undefined"){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log(ap.parameters[ao]);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}else{if(au===ar){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log("(enabled)");m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ap,aq,ao){m.setConfigParam(ap,{name:aq.toLowerCase(),value:ao})};var U=function(ap){if(ap.nodeType!==1){return"<unknown>"}var ao=m.XMLSerializer.serializeToString(ap.cloneNode(false));ao=ao.replace(/\/>$/gi,">");return ao};this.setConfigParam=function(ar,ao,at,au){var aw=ao.name;var ay=ao.value;if(!aw){return}if(c){for(var ax in c){if(ax===aw&&!au){if(typeof(at)==="object"&&typeof(at.tagName)==="string"){var av;if(l){av=l}var aq=at.parentNode;var ap=[];while(aq){if(aq.tagName==="if"){av="Matched Condition"}ap.unshift(U(aq));aq=aq.parentNode}ap.shift();ap.shift();m.iTraceParameterDebug.group(av);m.iTraceParameterDebug.log(ap.join(" "));m.iTraceParameterDebug.log(at);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}else{m.iTraceParameterDebug.group("By Parameter/Attribute:");m.iTraceParameterDebug.log(ay);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}if(m.cfgAliasNames[aw]!==b){aw=m.cfgAliasNames[aw]}if(ar[aw]!==b&&(typeof(ay)==="string"&&a.utils.getBoolTable(ay.toLowerCase())===false)&&a.utils.getBoolTable(ar[aw])===b){delete ar[aw]}else{switch(aw){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ar[aw]!==b&&ar[aw].length>0&&ar[aw].indexOf(ay)===-1){ar[aw]+=","+ay}else{ar[aw]=ay}break;case"plugins":m.addPluginsFromString(ay);break;case"fpxpath":ar[aw]=ay;ar.fpxsrc=encodeURIComponent(ay);break;default:ar[aw]=ay;if(ao.node!==b){ar[aw+".node"]=ao.node}}}};var k={};k["="]=function(ap,ao){return(ap.toLowerCase()===ao.toLowerCase())};k["=="]=function(ap,ao){return(ap===ao)};k["!="]=function(ap,ao){return(ap.toLowerCase()!==ao.toLowerCase())};k["!=="]=function(ap,ao){return(ap!==ao)};k["<"]=function(ap,ao){return(ap<ao)};k["<="]=function(ap,ao){return(ap<=ao)};k[">"]=function(ap,ao){return(ap>ao)};k[">="]=function(ap,ao){return(ap>=ao)};k.match=function(ap,ao){var aq=false;var at="g";if(ao.charAt(0)==="/"&&ao.lastIndexOf("/")>0){var ar=ao.split("/");ar.shift();at=ar.pop();ao=ar.join("/")}try{var au=new RegExp(ao,at);aq=(ap.match(au)!==null)}catch(av){H.error("Invalid regex in condition: "+ao)}return aq};k.notmatch=function(ap,ao){return !k.match(ap,ao)};var r={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var t=function(ap,aq){if(m.cfgAliasNames[aq]){aq=m.cfgAliasNames[aq]}var ao=m.cfg[aq];if(ao===b){ao=""}if(!m.hasImageParameterConditions){m.hasImageParameterConditions=(aa[aq]!==b)}return G(ap,aq,ao)};var L=function(ar,at){var ao=false;var aq;var ap=ar.getAttribute("value");switch(at){case"@mobile":ap=m.makeBool(ap,true);aq=a.isMobileDevice;break;case"@devicepixelratio":aq=a.getDevicePixelRatio();break;case"@navigatoruseragent":aq=navigator.userAgent;break;case"@navigatorlanguage":aq=navigator.language;break;case"@navigatorplatform":aq=navigator.platform;break}if(aq!==b){if(typeof(ap)!=="string"){ap=""+ap}if(typeof(aq)!=="string"){aq=""+aq}ao=G(ar,at,aq,ap)}return ao};var G=function(ar,aq,au,at){var aw;var ap=ar.getAttribute("operator");if(typeof(ap)!=="string"){ap="="}ap=ap.toLowerCase();if(r[ap]){ap=r[ap]}if(k[ap]===b){ap="="}if(at===b){at=ar.getAttribute("value")}if(at===null){at=""}var ao=k[ap];if(ap.match(/[<,>]+/)){var ax=function(ay){ay=parseFloat(ay);if(isNaN(ay)){aw=false}return ay};au=ax(au);at=ax(at)}else{au=decodeURIComponent(au)}if(aw===b){aw=ao(au,at)}if(H.on){H.log("Evaluating condition: "+aq+": "+au+" "+ap+" "+at+" => "+aw)}if(aw===true){if(ar._myTagName!==b){var av={};av.nodeType=1;av.tagName=ar._myTagName;av.childNodes=[ar];ar=av}m.parseConfig(ar,ar)}return aw};var aa={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ab={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var Z;var T=function(){if(Z===b){Z={};for(var ao in aa){Z[aa[ao]]=ao}}return Z};var p=function(at,ar,aq){if(aq===b){aq=""}var av=aq+"left";if(at[av]===b){return}var au=aq+"top";var ap=aq+"right";var ao=aq+"bottom";if(ar==="pixelrange"){at[ap]=at[ap]-at[av];at[ao]=at[ao]-at[au]}at[ar]=at[av]+","+at[au]+","+at[ap]+","+at[ao];if(at[av]){delete at[av]}if(at[au]){delete at[au]}if(at[ap]){delete at[ap]}if(at[ao]){delete at[ao]}};var al=this.mapImageParametersToViewer=function(ao){p(ao,"rect");p(ao,"pixelrange","pixel");T();ag(ao,T())};var ak=this.mapImageParametersToServer=function(ao){ag(ao,aa)};var ag=function(ap,ao){for(var aq in ap){if(ao[aq]&&aq!==ao[aq]){ap[ao[aq]]=ap[aq];delete ap[aq]}}};this.reWriteImageURLByConditions=function(av){if(m.arConditions.length<1){return av}if(typeof(av)!=="string"||av.length<1){return av}var aq=av.indexOf("?");if(aq===-1){return av}var ap=m.clone();var at={};m.parseQuery(av,at);al(at);m.evaluateQuery(at,ap.cfg);var ao=ap.evaluateConditions();if(!ao){return av}var au;for(au in at){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}for(au in ab){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}ak(at);var ar=av.substr(0,aq);return ar+"?"+m.objectToQuery(at)};var n=this.applyConditions=function(){if(m.arConditions.length<1){return}if(m.cfgBeforeConditions===b){m.cfgBeforeConditions=a.utils.cloneObject(m.cfg)}m.cfg=m.cfgBeforeConditions;return g()};var aj=0;var g=this.evaluateConditions=function(){if(m.arConditions.length<1){return false}var ap=false;for(var aq=aj;aq<m.arConditions.length;aq++){var ar=m.arConditions[aq];if(ar.fsiConfigEvaluated){continue}aj++;var at=ar.getAttribute("parameter");if(typeof(at)==="string"){at=at.toLowerCase();var ao;if(at.charAt(0)==="@"){ao=L(ar,at)}else{ao=t(ar,at)}if(!ap&&ao){ap=ao}}}return ap};var V=function(){n();m.serverProfile=m.cfg.fpxservertemplate;m.serverProfileDoublePage=m.cfg.fpxservertemplatedoublepage;if(m.serverProfileDoublePage===b){m.serverProfileDoublePage="doublepage"}m.serverBase=m.cfg.fpxserver;if(m.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+m.locationFSIViewer+")");var ap;ap=m.locationFSIViewer.indexOf("/users/");if(ap!==-1){m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}else{ap=m.locationFSIViewer.indexOf("/viewer/");m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}H.log("Derived server location is: ["+m.serverBase+"]")}m.requestBase=m.serverBase;ac={};var ao=m.cfg;for(var aq in ab){if(ao[aq]!==b){ac[aq]=ao[aq]}}if(ac.fpxsrc!==b){ac.fpxsrc=decodeURIComponent(ac.fpxsrc)}ao=m.cfg.effects;if(ao!==b){m.cfg.effectsUnFiltered=ao;m.cfg.effects=ao=j(ao)}if(ao!==b){ac.effects=ao}ao=m.cfg.lefteffects;if(ao!==b){ac.lefteffects=ao}ao=m.cfg.righteffects;if(ao!==b){ac.righteffects=ao}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){m.setEffectsFilter(m.getAreaEffects())};this.setEffectsFilter=function(at){if(typeof(at)!=="string"||at.length<1){X=false;return}at=a.trim(at);var ap=at.split(",");for(var aq=0;aq<ap.length;aq++){ap[aq]=a.escapeRegEx(ap[aq])}var ao="(^|[=,]+)("+ap.join("|")+")\\([^)]*\\)";X=new RegExp(ao,"ig")};var j=function(ao){if(X===false){return ao}return ao.replace(X,"")};var i=function(){for(var ap in m.plugins){var aq=ap.toLowerCase();var ao=m.makeBool(m.cfg[aq],true);if(!ao){m.plugins[ap]=b}}};var W=function(){m.elevateToHTTPS();i();V();m.dumpConfig();if(w.onConfigsReady){w.onConfigsReady()}};this.dumpConfig=function(aq){if(!aq){aq=H}if(aq.on){if(m.cfg.fpxsrc!==b){m.cfg["fpxsrc (decoded)"]=decodeURIComponent(m.cfg.fpxsrc)}aq.info("Evaluated Configuration:",P(m.cfg));if(m.queryParameters){aq.info("Parameters:",P(m.queryParameters))}if(ae){aq.info("Class <"+s+"> Configuration:",P(ae))}var ap=m.getPluginsAndParameters();var ao=ap.data;if(ap.count===0){ao="No active plugins."}aq.info("Plugin Configuration:",P(ao))}};var P=function(aq){var ao="--- none ---";if(typeof(aq)!=="object"){return ao}for(var ap in aq){ao=aq;break}return ao};this.getPluginsAndParameters=function(){var ao={};var aq=0;for(var ap in m.plugins){if(m.hasPlugin(ap)){ao[ap]=Q(ap);aq++}}return{count:aq,data:ao}};var J=this.addQueryParameterToURL=function(ar,ao,aq){var ap=ar.lastIndexOf("?");if(ap===-1){ar+="?"}else{if(ap!==ar.length-1){ar+="&"}}return ar+encodeURIComponent(ao)+"="+encodeURIComponent(aq)};var am=m.finishURL=function(ao){if(v){ao=J(ao,u,v)}if(!Y||ao===b){return ao}var ap;if(D===false){ap="cache=0&cachernd="+q;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+="&"+ap}}else{ap=D;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+=ap}}return ao};this.addURLParameters=function(ap,aq){if(!ap||!aq){return ap}var ao=[];for(var at in aq){ao.push(encodeURIComponent(at)+"="+encodeURIComponent(aq[at]))}if(ao.length>0){if(ap.indexOf("?")===-1){ap+="?"}else{ap+="&"}ap+=ao.join("&")}return ap};this.finishRequestParams=function(ap){if(Y){if(D===false){ap.cache=0;ap.cachernd=q}else{for(var ao in x){ap[ao]=x[ao]}}}};this.addNoCacheParams=function(ao){ao.cache=0;ao.cachernd=q};this.parseQuery=function(ap,ao){if(typeof(ao)!=="object"||typeof(ap)!=="string"||ap.length<1){return}m.queryToObject(ap,ao);if(ao.ignorequeryparameters!==b){delete ao.ignorequeryparameters}if(ao.enableconfigcachingparameter!==b){delete ao.enableconfigcachingparameter}};this.cloneParameters=function(ao,ap){if(ao===b||ap===b){H.error("Cloning object failed: "+ao+" / "+ap)}for(var aq in ao){ap[aq]=ao[aq]}};this.getFSIPath=function(ao,ap){if(ap.indexOf("//")!==-1){return ap}if(m.cfg.fsibase!==b){ap=m.cfg.fsibase+ap}return m.getReloadPath(ao,ap)};this.expandFSIPath=function(ap){if(ap===b){return ap}var ao=a.utils.urlDecode(ap);if(ao.indexOf("?")!==-1||ao.indexOf(".xml")===(ao.length-4)){return ap}return ap+".xml"};this.getReloadPath=function(ar,au){var ap,av,ao,at;if(ar===b){ar=m.locationFSIViewer}if(typeof(au)!=="string"){au=""}var aq="/";if(au.indexOf("//")!==-1){return au}ap=ar;at=ap.lastIndexOf("?");if(at===-1){at=ap.length}av=ap.lastIndexOf("\\",at);ao=ap.lastIndexOf("/",at);av=Math.max(av,ao);if(av===-1){av=ap.length-1}ap=ap.slice(0,av);if(ap.length>0&&au.indexOf(aq)!==0){ap+=aq}return ap+au};var C=function(ao){var ap;if(!ao){return}if(ao.childNodes.length>0){ap=ao.innerHTML}else{ap=ao.getAttribute("value")}return ap};var I=function(aq,ar){var ap,ao;while(aq){if(aq.nodeName===ar){ao=aq;break}ap=aq.firstChild;if(!ap){ap=aq.nextSibling}if(!ap&&aq.parentNode){ap=aq.parentNode.nextSibling}aq=ap}return ao};var B=function(ap){var ao=I(ap,"images");if(!ao){ao=I(ap,"images3d")}return m.parseXMLImageListNode(ao)};var R=function(aq){var ap={};var au=ap.arImages=[];var at="";var aw="";var ax;if(!aq){return ap}var av;av=m.getAttributeValue(aq,"prefix");if(typeof(av)==="string"){at=av}av=m.getAttributeValue(aq,"suffix");if(typeof(av)==="string"){aw=av}aq=I(aq,"image");if(!aq){return ap}while(aq){if(aq.nodeType===1){ax=I(aq,"path");var ay=C(ax);if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"src"))}if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"file"))}if(ay!==b){if(ad===false){au.push(at+ay+aw)}else{var ao=at+ay+aw;if(ad(ao)){au.push(ao)}}}if(ap.width===b){ax=I(aq,"width");ax=C(ax);if(ax!==b){ap.width=parseInt(ax)}ax=I(aq,"height");ax=C(ax);if(ax!==b){ap.height=parseInt(ax)}}}aq=aq.nextSibling}return ap};this.getImageList=function(){var aq,av,ap;z();if(m.cfg&&m.cfg.fpxsources!==b){var au=m.cfg.fpxsources;if(typeof(au)==="string"||(typeof(au)==="object")&&typeof(au.push)==="function"){aq={};aq.oXML=null;if(typeof(au)==="string"){if(ad===false){aq.arImages=au.split(",");for(av=0;av<aq.arImages.length;av++){aq.arImages[av]=a.utils.urlDecode(aq.arImages[av])}}else{var ao=au.split(",");aq.arImages=[];for(av=0;av<ao.length;av++){ap=a.utils.urlDecode(ao[av]);if(ad(ap)){aq.arImages.push(ap)}}}}else{aq.arImages=au}}}if(!aq&&m.arUnrecognizedConfigNodes&&m.arUnrecognizedConfigNodes.length>0){var at=m.arUnrecognizedConfigNodes;for(av=0;av<at.length;av++){var aw=at[av];if(typeof(aw.nodeName)==="string"){var ax=aw.nodeName.toLowerCase();if(ax==="images"||ax==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aq=R(aw);aq.oXML=aw;break}}}}if(!aq&&m.cfg&&m.cfg.fpxsrc!==b){aq={};aq.oXML=null;if(ad===false){aq.arImages=[a.utils.urlDecode(m.cfg.fpxsrc)]}else{ap=a.utils.urlDecode(m.cfg.fpxsrc);if(ad()){aq.arImages=[ap]}}}return aq};this.getServerBase=function(){return m.serverBase};this.loadImageList=function(ar,at,av,au){if(!m.serverBase||!ar){at([],b,au);return false}z();var aq=m.serverBase+"?type=list";if(ar.indexOf("tpl")===-1){var ap=m.cfg.listtemplate;if(ap&&ap.length>0&&ap.indexOf(".json")===-1&&ap.indexOf(".xml")===-1){ap+=".json"}aq+="&tpl="+ap}if(m.cfg.headers&&m.cfg.headers.length>0&&x.headers===b){aq+="&headers="+m.cfg.headers}if(typeof(m.cfg.imagelistlimit)==="string"&&m.cfg.imagelistlimit.length>0){aq+="&limit="+encodeURIComponent(m.cfg.imagelistlimit)}aq+="&source="+encodeURIComponent(ar);if(av!==b){aq+=av}aq=am(aq);var ao=m.loadFile(aq,function(aw,aA){if(typeof(aA)==="object"&&typeof(aA.images)==="object"){aA.images.pop();var aB="";if(aA&&aA.imagesattributes&&aA.imagesattributes.dir){aB=aA.imagesattributes.dir}var ax,az;if(ad===false){ax=new Array(aA.images.length);for(az=0;az<aA.images.length;az++){ax[az]=aB+aA.images[az].src}}else{ax=[];for(az=aA.images.length-1;az>-1;az--){var ay=aB+aA.images[az].src;if(af(ay)){ax.push(ay)}else{aA.images.splice(az,1)}}ax.reverse()}at(ax,aA,au)}else{at([],aA,au)}},"application/json",au);return ao};var af=function(ap){if(typeof(ap)!=="string"){return 1}var ao=1;if(O!==b){if(!ap.match(O)){ao=0}}if(ao===1&&y!==b){if(ap.match(y)){ao=0}}return ao};var ad=true;var O,y;var F=function(at){var aq;var av=m.cfg[at.toLowerCase()];if(!av||typeof(av)!=="string"||av.length<1){return}var ao=/\/([^/]*)$/;try{var ar=av.match(ao);if(ar&&ar.length>1){var ap=ar[1];av=av.replace(ao,"");av=av.replace(/^\//,"")}aq=new RegExp(av,ap)}catch(au){H.error("Invalid Regular Expression "+av+" in parameter "+at);H.error(au.message);aq=b}return aq};var z=function(){O=F("ListFilterPositive");y=F("ListFilterNegative");if(O===b&&y===b){ad=false}else{ad=af}};this.traceConfigValue=function(ao,ar){if(typeof(ao)!=="string"){return false}ao=a.trim(ao);if(ao.length<1){return false}var ap=ao.toLowerCase();if(ap.indexOf(".")!==-1){ap=ap.split(".").join("")}if(ap.indexOf("/")!==-1){ap=ap.split("/").join("")}if(ap.indexOf(" ")!==-1){ap=ap.split(" ").join("")}var aq=new a.Debugger();aq.setPrefix("");aq.group('Tracing parameter "'+ao+'"');var at=function(){var au=ao;var az=m.getParameterAlias(ap);if(typeof(az)==="string"){au+=" (alias: "+az+")";if(typeof(m.cfgAliasNames[ap])==="string"){ap=m.cfgAliasNames[ap]}}var av=m.cfg[ap];var ay=true;if(ap.indexOf("_")!==-1){var ax=ap.split("_");var aw=ax.shift();var aA=ax.join("_");if(m.hasPlugin(aw)){av=m.getPluginParameter(aw,aA)}}else{if(m.hasPlugin(ap)){ay=false;av="is enabled."}}if(av===b){ay=false;av="is undefined (default value applies)"}if(ay){av='= "'+av+'"'}aq.group("RESULT:");aq.log(au+" "+av);aq.groupEnd();aq.groupEnd()};w={onConfigsReady:at};e.strTraceParam=ap;e.bNoDebug=true;m.iTraceParameterDebug=aq;m.init(ar);m.loadConfigs();return""};this.loadLanguageFile=function(ao,aA,at,aq){var au=arguments;var av,ay;if(typeof(aA)!=="string"||m.makeBool(aA,true)===false){return at.call(m,{},"")}var az=function(aB){try{a.utils.oLanguageMap=JSON.parse(aB.responseText)}catch(aC){a.utils.oLanguageMap={"default":"english"}}m.loadLanguageFile.apply(this,au)};var aw=function(aB,aE){ao.urlLanguageCurrentLoaded=av;var aD=ao.oLanguageData={};if(aE){var aC=m.findXMLNode(aE,"data");if(aC){aC=m.findXMLNode(aC,"tip")}while(aC){if(aC.nodeType===1){var aF=aC.getAttribute("id");aD[aF]=m.XMLChildNodesToString(aC)}aC=aC.nextSibling}}at.call(m,ao.oLanguageData,ay)};if(aA.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){m.loadFile(a.getViewerLocation()+"/languages/mapping.json",az,"application/json");return}if(a.utils.oLanguageMap._current!==b){aA=a.utils.oLanguageMap._current}else{aA=a.utils.oLanguageMap["default"];var ar=navigator.language;if(typeof(ar)==="string"){ar=ar.toLowerCase()}if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}else{if(ar.indexOf("-")!==-1){ar=ar.split("-")[0];if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}}}}if(aA===b){return at.call(m,{},"")}if(aq){aq.log('Automatically choosing language "'+aA+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aA}var ax=aA+".xml";var ap=a.getViewerLocation()+"/languages/"+ax;if(ap!==ao.urlLanguageCurrentLoaded){ay=aA;av=ap;if(aq){aq.log("Loading language file: "+ap)}m.loadFile(ap,aw,"application/xml")}else{at.call(m,ao.oLanguageData,ay)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!=b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!=b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!=b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!=0||u!=0||v!=0||q!=0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!=-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!=-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!=b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!=b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRectByRefWidth=function(q){};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r==b&&u==b){r=i.width();u=i.height();A=1}else{if(r!=b){A=i.width()/r;if(u==b){u=i.height()/A}}else{A=i.height()/u;if(r==b){r=i.width()/A}}}if(z==b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left==0&&v.top==0&&v.width()==v._refWidth&&v.height()==v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left==0&&r.top==0&&r.width()==r._refWidth&&r.height()==r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,A){var B=new a.CroppedImage();var C,v;if(typeof(y)!="string"||y.length!=2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var z=p.isCropped();var q,D;var x,E;if(z){x=(1-h.left-h.right);E=(1-h.top-h.bottom);q=Math.round(x*c.width);D=Math.round(E*c.height)}else{q=c.width;D=c.height}if(u/q<s/D){v=s;C=Math.round(q/D*s);t=C-u;switch(y.charAt(1)){case"l":r.setRect(0,0,C-t,v);break;case"r":r.setRect(t,0,C,v);break;default:r.setRect(t/2,0,C-t/2,v)}}else{C=u;v=Math.round(D/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,C,v-t);break;case"b":r.setRect(0,t,C,v);break;default:r.setRect(0,t/2,C,v-t/2)}}r.scaleRectXY(1/C,1/v);if(p.isCropped()){C/=x;v/=E;if(A){C=Math.min(C,c.width);v=Math.min(v,c.height)}B.setSourceDimension(C,v);r.scaleRectXY(x,E);r.offsetRect(h.left,h.top)}else{if(A){C=Math.min(C,c.width);v=Math.min(v,c.height)}B.setSourceDimension(C,v)}B.widthUncropped=C;B.heightUncropped=v;B.setCropRect(r.left,r.top,r.right,r.bottom);return B}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomSkinClass!==b){return}a.CustomSkinClass=function(i,m,f,j){var q=this;var l;var o;var g;var k;var n=f.getCallbacks();var d=this.paramCustomSkinClass=m;var c;var p=function(){l=f.getRootContainer();o=f.getParentElement();q.destroy();c=a.getViewerLocation()+"/skins/";if(typeof(m)==="string"){if(m.match(/\.js$/)){var r=a.getViewerLocation()+"/"+m;c=r;c=c.replace(/\/[^/]*$/,"/");a.loadJavascript(r,f.getInstanceID(),q,e)}else{if(typeof(window[m])==="function"){k=new window[m](i,o,h,q)}}}else{if(typeof(m)==="function"){k=new m(i,o,h,q)}}};this.getSkinPath=function(){return c};this.replacePaths=function(r){r=r.replace(/\[fsi-skin-path\]/g,c);r=r.replace(/\[fsi-viewer-path\]/g,a.getViewerLocation()+"/");return r};this.loadHTMLFragment=function(s,v,t,r){s=q.replacePaths(s);var u=function(y,w,x){w=q.replacePaths(w);if(v&&typeof(v)==="object"&&v.tagName){while(v.firstChild){v.removeChild(v.firstChild)}v.innerHTML=w}t(w,r)};i.loadFile(s,u,"text/plain; charset=utf-8")};var h=function(s){g=s;if(s&&typeof(s)==="object"&&s.tagName){s.appendChild(l)}if(n.isset("onResize")){var r=f.getElementSpace();n.run("onResize",[r.width,r.height,true,f.getIsFullScreen()])}if(i.onResize){i.onResize({FSI_after_treshold:true})}j.apply(i)};var e=function(){d=d.replace(/\.js$/,"");var r=d.lastIndexOf("/");if(r!==1){d=d.substr(r+1)}if(d.length>0&&typeof(window[d])==="function"){k=new window[d](i,o,h,q)}else{h()}};this.getCustomSkinInstance=function(){return k};this.destroy=function(){if(k&&typeof(k.destroy)==="function"){k.destroy(q);k=b}if(g!==b){g=b;while(o.firstChild){o.removeChild(o.firstChild)}o.appendChild(l)}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Sprite!=b){return}a.Sprite=function(k,i,t,o,s,m,f){var n=this;var c=0.075;var d;var e=true;var u;var j;var v=1;var l=n.margin={left:0,top:0,right:0,bottom:0};var r={};r.width=i;r.height=t;var p=(s)?"canvas":"div";d=n.element=document.createElement(p);d.setAttribute("draggable","false");if(f){d.className=f}var g="";switch(m){case"inline":break;default:g+="position:absolute;z-index:"+o}a.utils.setStyleAttr(d,g);if(s){n.canvas=n.element;n.canvas.setAttribute("crossorigin","anonymous");n.canvas.setAttribute("width",r.width);n.canvas.setAttribute("height",r.height);n.ctx=n.canvas.getContext("2d")}if(k){k.appendChild(d)}this.remove=function(){if(k){a.removeChild(k,d)}};this.setPos=function(h,w){n.x=h;n.y=w;d.style.marginLeft=h+"px";d.style.marginTop=w+"px"};this.isVisible=function(){return(v>0)};this.show=function(h,w){if(e==h){return}e=h;if(j!=b){cancelAnimationFrame(j);j=b}if(!w){v=d.style.opacity=(h)?1:0;d.style.display=(h)?"block":"none"}else{u=(h)?c:-c;if(h){d.style.display="block"}q()}};this.updateMargins=function(){l=n.margin=a.getElementMargins(d)};this.getClientDim=function(){return a.getElementClientDim(n.element)};this.updateDimension=function(){r=a.getElementClientDim(d)};this.width=function(){return r.width};this.height=function(){return r.height};var q=function(){v+=u;if(u>0){if(v>=1){v=1;j=b}else{j=requestAnimationFrame(q)}}else{if(v<=0){v=0;j=b;d.style.display="none"}else{j=requestAnimationFrame(q)}}d.style.opacity=v};if(!s){this.setSize=function(x,y){r.width=x;r.height=y;if(typeof(x)!="string"){x+="px"}if(typeof(y)!="string"){y+="px"}n.element.style.width=x;n.element.style.height=y};this.clear=function(){}}else{this.setSize=function(x,y){r.width=x;r.height=y;n.canvas.width=x;n.canvas.height=y};this.clear=function(){n.ctx.clearRect(0,0,r.width,r.height)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ToolTip!=b){return}a.ToolTip=function(c){var q=this;var n;var h;var d;var m,l;var j;var k=false;var e={};var g=false;var i;var p=function(){n=document.createElement("div");a.addClass(n,"fsi-ui-tool-tip-container fsi-ui-tool-tip-container-hidden");h=document.createElement("div");a.addClass(h,"fsi-ui-tool-tip");n.appendChild(h);d=document.createElement("div");a.addClass(d,"fsi-ui-tool-tip-arrow");n.appendChild(d)};this.destroy=function(){q.hide();clearTimeout(j)};this.setContent=function(r){i=r};this.show=function(t,s,r,z,v,u,w){if(!i){return}e.strTip=t;e.elSrc=s;e.x=r;e.y=z;e.bNoAutoBold=w;e.fnGetToolTipText=v;if(l!=b){clearTimeout(l);l=b}if(m!=b){clearTimeout(m)}if(u==b){u=(k)?100:1000}m=setTimeout(f,u)};this.setParentContainer=function(r){q.hide();c=r};var f=function(){if(m!=b){clearTimeout(m);m=b}var w=e.strTip;var C,D;if(e.fnGetToolTipText!=b){D=e.fnGetToolTipText(w,i);if(D==b){D=i[w]}}else{D=i[w]}if(D!=b){w=D}else{if(!e.bNoAutoBold){w="<b>"+w+"</b>"}}h.innerHTML=w;c.appendChild(n);d.style.left="0px";n.style.display="inline-block";n.style.width=c.offsetWidth+"px";C=a.getElementClientPos(h);n.style.display="block";n.style.width=C.width+"px";var G=e.x;if(G==b){G=0}var F=e.y;if(F==b){F=0}var v;var u=a.getElementClientPos(c);if(e.elSrc!=b){v=a.getElementClientPos(e.elSrc);G+=v.left-u.left+(v.right-v.left)/2;F+=v.top-u.top}C=a.getElementClientPos(n);G-=C.width/2;F-=C.height+2;var t=document.body;var z=4;var E=G;var s=t.clientWidth;if(a.isMobileDevice){s=Math.max(t.clientWidth,u.width+u.left)}G=Math.min(s-u.left-C.width-z,Math.max(-u.left+z,G));var B=E-G;var r=d.offsetWidth/2;if(B!=0){var A=Math.min(n.offsetWidth/2-r,Math.abs(B));if(B<0){B=-A}else{B=A}}d.style.left=(n.offsetWidth/2-r+B)+"px";n.style.left=G+"px";n.style.top=F+"px";g=true;k=true;clearTimeout(j);j=setTimeout(o,1000);a.removeClass(n,"fsi-ui-tool-tip-container-hidden");a.addClass(n,"fsi-ui-tool-tip-container-visible")};var o=function(){k=false};this.hideAfter=function(r){if(r==b||isNaN(r)||r<1){r=2500}if(l!=b){clearTimeout(l);l=b}l=setTimeout(q.hide,r)};this.hide=function(){if(m!=b){clearTimeout(m);m=b}if(l!=b){clearTimeout(l);l=b}if(g){a.removeClass(n,"fsi-ui-tool-tip-container-visible");a.addClass(n,"fsi-ui-tool-tip-container-hidden");a.removeChild(c,n);g=false}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FullScreen!==b){return}a.FullScreen={};a.FullScreen.__initDone=false;a.FullScreen._nIDChangeEvent=0;a.FullScreen._nIDErrorEvent=0;a.FullScreen._eventHandlers={};a.FullScreen.__init=function(){var d=a.FullScreen;if(d.__initDone){return}d.__initDone=true;var c=0;if(document.webkitExitFullscreen){c=3}else{if(document.msExitFullscreen){c=1}else{if(document.mozCancelFullScreen){c=2}else{if(document.exitFullscreen){c=0}}}}switch(c){case 1:d.requestFullscreen="msRequestFullscreen";d.exitFullscreen="msExitFullscreen";d.fullscreenPseudoClass=":-ms-fullscreen";d.fullscreenChange="MSFullscreenChange";d.fullscreenError="MSFullscreenError";d.fullScreen="msFullscreenElement";d.fullscreenElement="msFullscreenElement";break;case 2:d.requestFullscreen="mozRequestFullScreen";d.exitFullscreen="mozCancelFullScreen";d.fullscreenPseudoClass=":-moz-full-screen";d.fullscreenChange="mozfullscreenchange";d.fullscreenError="mozfullscreenerror";d.fullScreen="mozFullScreen";d.fullscreenElement="mozFullScreenElement";break;case 3:d.requestFullscreen="webkitRequestFullscreen";d.exitFullscreen="webkitExitFullscreen";d.fullscreenPseudoClass=":-webkit-full-screen";d.fullscreenChange="webkitfullscreenchange";d.fullscreenError="webkitfullscreenerror";d.fullScreen="webkitIsFullScreen";d.fullscreenElement="webkitFullscreenElement";break;default:d.requestFullscreen="requestFullscreen";d.exitFullscreen="exitFullscreen";d.fullscreenPseudoClass=":fullscreen";d.fullscreenChange="fullscreenChange";d.fullscreenError="fullscreenError";d.fullScreen="fullScreen";d.fullscreenElement="fullscreenElement"}if(typeof(document[d.exitFullscreen])!=="function"){a.FullScreen.bUseFakeFullScreen=true}d.nMode=c};a.FullScreen.start=function(c){a.FullScreen.__init();a.FullScreen.quit();if(!a.FullScreen.bUseFakeFullScreen){c[a.FullScreen.requestFullscreen]()}else{a.FullScreen._enterFakeFullScreen(c)}};a.FullScreen.quit=function(){a.FullScreen.__init();if(!a.FullScreen._exitFakeFullScreen()&&!a.FullScreen.bUseFakeFullScreen){document[a.FullScreen.exitFullscreen]()}};a.FullScreen._enterFakeFullScreen=function(c){if(!c){return}var f=a.FullScreen.oFake={};f.elParentOriginal=c.parentNode;f.elNextSibling=c.nextSibling;f.el=c;var e,d;e=document.documentElement;f.docScrollLeft=e.scrollLeft;f.docScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;e=document.body;f.bodyScrollLeft=e.scrollLeft;f.bodyScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;d=f.bodyStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box";if(document.documentElement){e=document.documentElement;d=f.documentStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box"}a.FullScreen.bChanging=true;document.body.appendChild(c);a.FullScreen.bChanging=false;a.addEvent(window,"keydown",a.FullScreen._keyDown);a.FullScreen.callHandlers()};a.FullScreen._keyDown=function(c){if(c&&c.keyCode===27){a.FullScreen.quit()}};a.FullScreen._exitFakeFullScreen=function(){if(!a.FullScreen.oFake){return false}var f=a.FullScreen.oFake;a.FullScreen.bChanging=true;if(f.elParentOriginal){if(f.elNextSibling){f.elParentOriginal.insertBefore(f.el,f.elNextSibling)}else{f.elParentOriginal.appendChild(f.el)}}var e=document.body;var d=f.bodyStyle;var c;for(c in d){e.style[c]=d[c]}e.scrollLeft=f.bodyScrollLeft;e.scrollTop=f.bodyScrollTop;if(document.documentElement){e=document.documentElement;d=f.documentStyle;for(c in d){e.style[c]=d[c]}e.scrollLeft=f.docScrollLeft;e.scrollTop=f.docScrollTop}a.FullScreen.bChanging=false;a.FullScreen.oFake=b;a.FullScreen.callHandlers();a.removeEvent(window,"keydown",a.FullScreen._keyDown);return true};a.FullScreen.toggle=function(c){if(a.FullScreen.getEnabled()){a.FullScreen.quit()}else{a.FullScreen.start(c)}};a.FullScreen.getFullscreenPseudoClass=function(){a.FullScreen.__init();return a.FullScreen.fullscreenPseudoClass};a.FullScreen.addChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();a.FullScreen._nIDChangeEvent++;if(typeof(e)==="function"){if(!e._FSIFullScreenEventID){a.FullScreen._eventHandlers[a.FullScreen._nIDChangeEvent]=e;e._FSIFullScreenEventID=a.FullScreen._nIDChangeEvent}a.addEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.addEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.callHandlers=function(){var c={type:"fullscreenchange",FSI_fake:true};for(var e in a.FullScreen._eventHandlers){var d=a.FullScreen._eventHandlers[e];d(c)}};a.FullScreen.removeChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)==="function"){if(e._FSIFullScreenEventID&&a.FullScreen._eventHandlers[e._FSIFullScreenEventID]){delete a.FullScreen._eventHandlers[e._FSIFullScreenEventID]}a.removeEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.removeEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.getAvailable=function(d){a.FullScreen.__init();var c=d[a.FullScreen.requestFullscreen];return(c)};a.FullScreen.getEnabled=function(){a.FullScreen.__init();var c=a.FullScreen.getElement();return(c!==b&&c!==null)};a.FullScreen.getElement=function(){a.FullScreen.__init();var c;if(a.FullScreen.bUseFakeFullScreen){if(a.FullScreen.oFake){c=a.FullScreen.oFake.el}}else{c=document[a.FullScreen.fullscreenElement]}return c}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderCSSSkin!=b){return}a.LoaderCSSSkin=function(){var e=this;var j=0;var h={};var c=0;var d=new a.CORSLoader();var f=function(l){var k=false;try{if(l.cssRules!=b){k=l.cssRules}else{k=l.rules}}catch(m){console.error(m.message)}return k};var i=function(n,m,v,l,t){var s=this;var u;var B=[];var o;var y=0;var r=false;var q=false;this.uniqueID=c++;this.bReleased=false;this.getSkinName=function(){return m.getSkinName()};this.callReady=function(D,E,G,F){if(this.bReleased){return}if(F){q=true}o=arguments;r=true;p()};var p=function(){if(!r||y>0){return}if(q){u=setTimeout(z,1)}else{z()}};var z=function(){k();v.apply(l,o)};var k=function(){if(u!=b){clearTimeout(u);u=b}};this.remove=function(){k();if(s.bReleased){return}m.removeWaiter(s.uniqueID);for(var D=0;D<B.length;D++){B[D].remove()}this.bReleased=true};var C=function(D,E,G,F){if(F){q=true}y--;p()};if(t&&typeof(t)=="object"&&t.length>0){for(var w=0;w<t.length;w++){var x=t[w];y++;var A=a.utils.loadSkinCSS(x.file,s,C,x.nPriority);B.push(A)}}};var g=function(k,w){var t=false;var l=0;var v={};var q=false;var r=false;var s;var p;var m;var o;m=k.match(/(.*)\/[^/]*$/);m=m[1]+"/";m=m.replace(/\/resources\/$/,"/");p=k.replace(/\.[^/]*$/,"");p=p.match(/([^/]*)$/);p=p[1].toLowerCase();this.removeWaiter=function(x){if(v[x]==b){return}delete v[x];l--};this.addWaiter=function(x){if(x.uniqueID==b||x.bReleased){return}if(q){x.callReady(r,o,"ALREADY LOADED",false)}else{if(v[x.uniqueID]==b){v[x.uniqueID]=x;l++;if(!t){u()}}}};this.getSkinName=function(){return p};var n=function(H,A,I,C){var F=false;if(C>299||typeof(A)!="string"){a.console.error("Failed to load Skin CSS (HTTP "+C+"): "+k)}else{F=true;A=A.replace(/\[fsi-skin-path\]/g,m);s=document.createElement("style");s.setAttribute("type","text/css");s.setAttribute("x-generated-by","FSI");s.setAttribute("x-fsi-skin",p);s.setAttribute("x-fsi-priority",w);s.appendChild(document.createTextNode(A));var E=document.head;if(!E){E=document.getElementsByTagName("head");if(E&&E.length>0){E=E[0]}}if(E&&E.firstChild){try{var z;var J=E.getElementsByTagName("style");for(var B=0;B<J.length;B++){var G=J[B];var y=parseInt(G.getAttribute("x-fsi-priority"));if(isNaN(y)||y>w){z=G;break}}if(z){E.insertBefore(s,z)}else{E.appendChild(s)}}catch(D){E.appendChild(s)}}else{E.appendChild(s)}o=s.sheet;r=F}q=true;for(var x in v){v[x].callReady(r,o,"onLoaded",true)}v={};l=0};var u=function(){t=true;if(typeof(k)!="string"||k.length<0){return false}d.load(k,n,"text/css");return true}};this.load=function(p,q,m,r,l){if(r==b){r=100}var o=false;if(a.versionInternetExplorer<9){o=true}if(o){a.console.error("Unable to load skin: unsupported browser version.");if(m){m.call(q,false)}return false}if(a.getViewerLocation()==b||typeof(p)!="string"||p.length<1){a.console.error("Unable to load skin:");if(a.getViewerLocation()==b){a.console.error("FSI Viewer path not known")}else{a.console.error("Invalid skin URL "+p)}if(m){m.call(q,false)}return false}var k=p;if(k.indexOf("http")!=0){k=a.getViewerLocation()+"/skins/"+k}if(!k.match(/\.css$/)){k+=".css"}var s;if(h[k]==b){j++;s=h[k]=new g(k,r)}else{s=h[k]}var n=new i(k,s,m,q,l);s.addWaiter(n);return n}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderJavascript!=b){return}a.LoaderJavascript=function(){var e={};this.load=function(h,l,n,j,m){var k=e[h];if(n==b){n=window}if(typeof(j)!="function"){return false}if(k==b){k=e[h]={};k.path=h;k.loaded=false;k.failed=false;f(k);if(!g(k)){k.failed=true;k.loaded=true;k.addNodeFailed=true}}else{if(k.oListeners[l]!=b){d(h,l)}}k.nListeners++;var i=k.oListeners[l]={};i.argScope=n;i.argFunction=j;i.oPassThrough=m;if(k.loaded==true){c(k)}return true};var d=this.release=function(h,j){var i=e[h];if(i==b){return}if(i.oListeners[j]!=b){delete i.oListeners[j];i.nListeners--}};var g=function(l){var h=false;try{var i=document.getElementsByTagName("head");if(i&&i.length>0){i=i[0];var j=l.node=document.createElement("script");var k=l.onLoad=function(n){if(n.type=="error"){l.failed=true;c(l)}else{l.failed=false;c(l)}l.loaded=true};a.addEvent(j,"load",k);l.onError=function(n){l.failed=true;c(l);l.loaded=true};a.addEvent(j,"error",k);i.appendChild(j);j.src=l.path;h=true}}catch(m){}return h};var c=function(j){var h=!j.failed;a.removeEvent(j.node,j.onLoad);a.removeEvent(j.node,j.onError);for(var k in j.oListeners){var i=j.oListeners[k];i.argFunction.call(i.argScope,h,j.path,i.oPassThrough)}f(j)};var f=function(h){h.oListeners={};h.nListeners=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CSSTransformMatrix!=b){return}a.CSSTransformMatrix=function(){var d=[];var e=[1,0,0,1,0,0];var c=a.utils.getCSSTransformStyleName();this.init=function(h){d[0]=e[0];d[1]=e[1];d[2]=e[2];d[3]=e[3];d[4]=e[4];d[5]=e[5]};this.rotate=function(h){e[0]=Math.cos(h);e[1]=Math.sin(h);e[2]=-1*Math.sin(h);e[3]=Math.cos(h);g();e[0]=1;e[1]=0;e[2]=0;e[3]=1};this.translate=function(h,i){e[4]=h;e[5]=i;g();e[4]=0;e[5]=0};this.scale=function(h,i){e[0]=h;e[3]=i;g();e[0]=1;e[3]=1};this.skew=function(h,i){e[1]=Math.tan(i);e[2]=Math.tan(h);g();e[1]=0;e[2]=0};var g=function(){var h=d[0];d[0]=e[0]*d[0]+e[2]*d[1];d[1]=e[1]*h+e[3]*d[1];h=d[2];d[2]=e[0]*d[2]+e[2]*d[3];d[3]=e[1]*h+e[3]*d[3];h=d[4];d[4]=e[0]*d[4]+e[2]*d[5]+e[4];d[5]=e[1]*h+e[3]*d[5]+e[5]};var f=this.outputString=function(){return d.join()};this.set=function(l,j,o,n,k,h){for(var m=0;m<arguments.length;m++){d[m]=arguments[m]}};this.applyTo=function(h){h.style[c]="matrix("+f()+")"};this.init()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(n,aY,am,e,aO){var aF=this;var aM=false;var al=true;var p=false;var aU=false;var aL=false;var aC,F,j,ae;var aD,Z,aJ;var h=false;var af;var s;var a1={};var ar=[];var ad=0;var J=window;var aW;var t;var aV;var d;var a0=[];var aS={x:0,y:0};var w={x:0,y:0};var at=40;var o={};o.enabled=false;o.factor=5;o.fEndDiff=1;var az={};az.enabled=false;az.minFrames=14;az.factorAmount=23;az.factorAmountQuad=0;az.factorFrames=2.6;az.offsetFrames=5;var ac;var aA;var aI,x,l;var G;var au={};var Y;var aN=false;var A=false;var an={};an.name="none";var O;var X;var aP;var f=false;var aa={};if(!aY||typeof(aY)!="object"){aY={}}var ao=function(){var a7;if(aM){aF.destroy()}aV=B;t=b;if(a.utils.getTopWindow()!=window){t=a.utils.getTopWindow();try{var a6=a.getWindowOffset(window);if(a6.x!=b&&a6.y!=b){aV=aq}}catch(a5){aV=B;t=b}}else{t=b}G=aY.oPassTrough;aX(aY.panDirectionAllowed,true);if(aY.getPageCoords){s=aG}else{s=N}if(aY.afterTouch){for(a7 in aY.afterTouch){az[a7]=aY.afterTouch[a7]}}if(az.minDelta==b){az.minDelta=15}if(aY.nClickRadius){ac=aY.nClickRadius}else{ac=10}if(az.fnStartStopAfterTouch&&typeof(az.fnStartStopAfterTouch)!="function"){az.fnStartStopAfterTouch=b}if(az.fnStartStopAfterTouch){az.useAnimationFrame=b}if(typeof(az.modifyTarget)!="function"){az.modifyTarget=b}if(typeof(az.fnGetAfterTouchEnabled)=="function"){aA=az.fnGetAfterTouchEnabled}else{aA=b}if(aY.smoothing){for(a7 in aY.smoothing){o[a7]=aY.smoothing[a7]}}if(aY.detectClick==true){Y=true}if(aY.preventSelection!==false){aY.preventSelection=true}if(!n){return}if(typeof(n.join)!="function"){n=[n]}if(typeof(am)!="function"){am=B}if(typeof(e)!="function"){e=B}if(typeof(aO)!="function"){aO=B}if(typeof(aY.onPinchChange)=="function"){O=aY.onPinchChange}else{O=b}aN=aY.detectGestures;a0=[];ay(true,aN);for(var a4=0;a4<n.length;a4++){var a3=n[a4];if(a3&&typeof(a3.nodeName)!="undefined"){a7={};a7.element=a3;a0.push(a7);ap(a3,S);if(a.isTouch){try{if(a3.style!=b){if(a.BrowserSupports.cssTouchAction()){if(au.cssTouchAction!=b){r(a3,au.cssTouchAction)}}}}catch(a5){}}}}if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aE,false)}};var aX=this.setAllowedPanDirection=function(a4,a3){if(typeof(a4)=="string"){if(a4=="pan-x"||a4=="pan-y"||a4=="pan-x pan-y"){aW=a4+" "}else{aW=""}}else{aW=""}if(!a3){au.nCheck=b;ai(au.captureScroll,au.capturePinch)}};this.enable=function(a3){if(al==a3){return}if(!a3){R();ai(false,false)}else{ai(au.captureScrollUser,au.capturePinchUser)}al=a3};this.getEnabled=function(){return al};this.cancel=function(){Q();ah();aK();R()};var aK=function(){if(o.enabled){i()}C()};this.cancelAfterTouch=function(){C()};this.getInitialDownEvent=function(){return X};var R=function(){if(!p){return}aK();p=false;X=b;A=false;if(ad==0){aQ()}};var aQ=function(){f=false;c()};this.destroy=function(){if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aE,false)}if(aP){clearTimeout(aP)}aF.cancel();var a3;for(var a4=0;a4<a0.length;a4++){var a5=a0[a4];a3=a5.element;y(a3,S)}au={}};var r=function(a3,a4){if(!a.BrowserSupports.cssTouchAction()||!a3||!a3.style){return}a3.style.touchAction=a3.style.msTouchAction=a4};var U=function(a3){if(a3.preventDefault){a3.preventDefault()}};var m=function(a3){U(a3);return false};var ap=function(a4,a3){a.addEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{a.addEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a4,"touchstart",a3);a.addEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a4,"MSPointerDown",a3)}a.addEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var y=function(a4,a3){a.removeEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{a.removeEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a4,"touchstart",a3);a.removeEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a4,"MSPointerDown",a3)}a.removeEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var B=function(){return true};var aR=function(a3){if(aL){W(a3,a3.pointerId)}else{var a4=a3.changedTouches;for(var a5=0;a5<a4.length;a5++){W(a4[a5],a4[a5].identifier)}}};var W=function(a3,a5){if(a5==b||a1[a5]!=b){if(aY.debug){if(a5==b){a.console.error("doRegisterPointer: no pointerId")}if(a1[a5]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a5)}}return}ad++;var a4=a1[a5]={};a4.identifier=a5;s(a4,a3);ar.push(a4)};var ak=function(a3){var a5=false;if(aL){a5=L(a3.pointerId)}else{var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){a5=L(a4[a6].identifier)}}}if(a5){ar=new Array(ad);var a8=0;for(var a7 in a1){ar[a8++]=a1[a7]}}};var L=function(a3){if(a3==b||a1[a3]==b){if(aY.debug){if(a3==b){a.console.error("doUnregisterPointer: no pointerId")}if(a1[a3]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+a3)}}return false}delete a1[a3];ad--;return true};var I=function(){ad=0;a1={};ar=[]};var N=function(a4,a3){a4.x=a3.clientX;a4.y=a3.clientY};var aG=function(a4,a3){a4.x=a3.pageX;a4.y=a3.pageY};var v=function(a3){var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){var a5=a1[a4[a6].identifier];if(a5){s(a5,a4[a6])}}}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y}};var ax=function(a3){var a4=a1[a3.pointerId];if(a4){s(a4,a3)}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y;aV(a3,aS)}};var V=function(a3){s(aS,a3);aV(a3,aS)};this.getMousePositionFromMouseEvent=function(a3){V(a3);return aS};this.getMousePositionPage=function(a4){var a3={};aG(a3,a4);aV(a4,a3);return a3};this.getMousePositionClient=function(a4){var a3={};N(a3,a4);aV(a4,a3);return a3};var u=function(a3,a4){if(window!=a3.view){var a5=a.getWindowOffset(window);a4.x-=a5.x;a4.y-=a5.y}};var aq=function(a3){try{u(a3);aV=u}catch(a4){aV=B}};var aB=function(a3){if(!al){return}var a5=ad;if(A&&a5==0){A=false}var a6=a3.type;if(p||an.started){if(a6!=aC){if(an.started){Q();ah()}else{a3._FSI_Canceled=true;a2(a3,true)}}}aC=a6;d=false;var a4=true;switch(a6){case"touchstart":aU=true;aL=false;af=v;j="touchmove";F="touchend";ae="touchcancel";aI=false;break;case"MSPointerDown":af=ax;aU=true;aL=true;j="MSPointerDown";F="MSPointerUp";ae="MSPointerCancel";aI=false;d=true;break;case"pointerdown":af=ax;aU=true;aL=true;j="pointermove";F="pointerup";ae="pointercancel";aI=true;d=true;break;default:if(ad>0){I()}aU=false;aL=false;aI=(aY.preventSelection);a4=false;af=V;j="mousemove";F="mouseup";ae=b;d=true}if(aU&&a4){aR(a3)}af(a3);if(!aY.bAllowMouseDown&&aI){U(a3)}if(ad>1){aa.bClick=false}x=false;if(a4&&aj(a3)){if(a5==0){C();E()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ad};var S=function(a3){if(aY.bMouseOnly&&a3.type==="pointerdown"&&a3.pointerType!=="mouse"){return true}if(!aB(a3)){return}if(p||a3.which>1){return}g(a3)};this.getCurrentPos=function(){return w};var g=function(a3){aK();if(p){return}az.evtMove=b;if(o.enabled){w={x:aS.x,y:aS.y}}else{w=aS}aa.x=aS.x;aa.y=aS.y;var a4=X;X=a3;if(!am.call(J,a3,w,G)){X=a4;return false}p=f=true;if(Y&&!A){aa.bClick=true;aa.clickRadiusX=aa.clickRadiusY=0}else{aa.bClick=false}E();if(az.enabled){az.x=az.y=0;az.lastX=aS.x;az.lastY=aS.y;if(az.nInterval){clearInterval(az.nInterval)}az.nInterval=setInterval(ab,30)}return true};var c=function(){if(h&&Z!=b){var a3={passive:false,capture:false};var a5=(t==b)?a3:b;h=false;a.removeEvent(window,Z,ag,a5);a.removeEvent(window,aD,a2,a5);if(d&&t){try{a.removeEvent(t,Z,ag,a3);a.removeEvent(t,aD,a2,a3)}catch(a4){}}if(aJ!=b){a.removeEvent(window,aJ,av,a5)}Z=aD=aJ=b}};var aE=function(a3){};var E=function(){if(h){c()}h=true;var a3={passive:false,capture:false};var a5=(t==b)?a3:b;Z=j;aD=F;aJ=ae;a.addEvent(window,Z,ag,a5);a.addEvent(window,aD,a2,a5);if(d&&t){try{a.addEvent(t,Z,ag,a3);a.addEvent(t,aD,a2,a3)}catch(a4){}}if(ae!=b){a.addEvent(window,aJ,av,a5)}};var ag=function(a3){af(a3);a3.FSI_start_x=aa.x;a3.FSI_start_y=aa.y;if(az.enabled&&az.evtMove==b){az.evtMove=a3}if(p){if(aa.bClick){aa.clickRadiusX=Math.max(aa.clickRadiusX,Math.abs(aS.x-aa.x));if(aa.clickRadiusX>ac){aa.bClick=false}else{aa.clickRadiusY=Math.max(aa.clickRadiusY,Math.abs(aS.y-aa.y));if(aa.clickRadiusY>ac){aa.bClick=false}}}if(o.enabled){o.evt=a3;aZ()}else{e.call(J,a3,w,G)}}else{if(an.started){if(an.nType==1){aw(a3)}}}if(x&&!a3.FSI_allowEventDefault){U(a3)}};var aw=function(a3){var a4=k();if(!O){return}a3._FSI_PinchDeltaStart=an.nPinchDistance-an.pinchDistanceStart;a3._FSI_PinchDeltaRelative=an.nPinchDistance-an.pinchDistanceLast;a3._FSI_PinchScale=Math.max(at,an.pinchDistanceLast)/an.pinchDistanceStartMaxed;an.pinchDistanceLast=an.nPinchDistance;a3._FSI_PinchDistance=a4;O.call(J,a3,aS,G)};var av=function(a3){if(aU){ak(a3);if(ad<1){if(p){a3._FSI_Canceled=true;a2(a3,true);return}else{R();return}}}af(a3);aj(a3)};var a2=function(a4,a5){var a3=aa.bClick;aa.bClick=false;if(a5){a4._FSI_Canceled=true}if(aU){ak(a4)}if(ad==0){aQ()}af(a4);if(!a5&&aj(a4)){return}aK();if(!a5){if(!p||ad>0){return}}a4.FSI_start_x=aa.x;a4.FSI_start_y=aa.y;var a6=false;if(!a5&&az.enabled){if(aA==b||aA()){a6=T(a4)}}if(a6){R();z(a4)}else{if(Y){a4._FSI_Click=a3}aO.call(J,a4,w,G);if(a4.type=="touchend"){aP=setTimeout(q,1)}R()}U(a4)};var q=function(){R();I();aP=b};var H=function(a3){return ar};var aZ=function(){if(o.animationFrame!=b){return}aT()};var i=function(){if(o.animationFrame==b){return}cancelAnimationFrame(o.animationFrame);o.animationFrame=b};var aT=function(){var a3=Math.abs(w.x-aS.x)+Math.abs(w.y-aS.y);if(a3>o.fEndDiff){w.x+=(aS.x-w.x)/o.factor;w.y+=(aS.y-w.y)/o.factor;o.animationFrame=requestAnimationFrame(aT)}else{w.x=aS.x;w.y=aS.y;o.animationFrame=b}e.call(J,o.evt,w,G)};var T=function(a3){var a4;if(!az.enabled){return false}if(az.running){C()}az.pos=0;var a6=(a3.touches!=b)?1.8:1;if(az.factorAmountQuad){a4=(az.x>0)?1:-1;az.x=az.x+a4*az.x*az.x/az.factorAmountQuad;a4=(az.y>0)?1:-1;az.y=az.y+a4*az.y*az.y/az.factorAmountQuad}var a8=a6*az.factorAmount;az.startX=w.x;az.startY=w.y;var a7={};a7.x=az.startX+a8*az.x;a7.y=az.startY+a8*az.y;if(az.roundTargetPos){a7.x=Math.round(a7.x);a7.y=Math.round(a7.y)}if(az.modifyTarget){a7=az.modifyTarget.call(J,a7,G);if(a7===false){return false}}az.amountX=a7.x-az.startX;az.amountY=a7.y-az.startY;az.amountXABS=Math.abs(az.amountX);az.amountYABS=Math.abs(az.amountY);var a5=(az.amountXABS>az.minDelta||az.amountYABS>az.minDelta);if(a5){a8=az.factorFrames/100;az.frames=az.offsetFrames+Math.round(a8*az.amountXABS+a8*az.amountYABS)}else{if(typeof(aY.onAfterTouchCancel)=="function"){aY.onAfterTouchCancel.call(J,a3,w,G)}}return a5};this.isAfterTouchRunning=function(){return az.running};var z=function(a3){if(typeof(aY.onAfterTouchStart)=="function"){aY.onAfterTouchStart.call(J,a3,w,G)}az.running=true;az.evtUp=a3;if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,true,az.evtMove,G)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}else{az.intervalRun=setInterval(K,16)}}return true};var aH=function(a4,a3,a6,a5){return a6*((a4=a4/a5-1)*a4*a4+1)+a3};var K=this.runAfterTouch=function(){var a3=false;az.pos++;w.x=aH(az.pos,az.startX,az.amountX,az.frames);w.y=aH(az.pos,az.startY,az.amountY,az.frames);e.call(J,az.evtMove,w,G);if(az.pos===az.frames){C(true)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}a3=true}return a3};this.enableAfterTouch=function(a3){if(az.enabled==a3){return}if(!a3){C()}az.enabled=a3};var C=function(a3){if(!az.running){return}if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,false,az.evtMove,G)}else{if(az.useAnimationFrame){if(az.animationFrameRun){cancelAnimationFrame(az.animationFrameRun)}}else{if(az.intervalRun){clearInterval(az.intervalRun);az.intervalRun=b}}}if(typeof(aY.onAfterTouchEnd)=="function"){aY.onAfterTouchEnd.call(J,az.evtMove,G)}az.evtMove=b;az.running=false;az.evtUp._FSI_Canceled=(a3!==true);az.evtUp._FSI_fromAfterTouch=true;aO.call(J,az.evtUp,w,G)};var ab=function(){az.x=(2*az.x+aS.x-az.lastX)/5;az.y=(2*az.y+aS.y-az.lastY)/5;az.lastX=aS.x;az.lastY=aS.y};var ay=this.setCapture=function(a3,a5){var a4=ai(a3,a5);if(a4){au.captureScrollUser=a3;au.capturePinchUser=a5}return a4};var ai=function(a3,a5){var a4=0;if(a3){a4+=2}if(a5){a4+=4}if(a4==au.nCheck){return}au.nCheck=a4;au.captureScroll=a3;au.capturePinch=a5;if(a.BrowserSupports.cssTouchAction()){P(a3,a5)}return true};var P=function(a3,a7){if(aY.bMouseOnly){return}var a6;switch(au.nCheck){case 0:a6="auto";break;case 2:a6=aW+"pinch-zoom";break;case 4:a6="pan-x pan-y";break;default:a6=(aW.length>0)?aW:"none"}au.cssTouchAction=a6;for(var a5=0;a5<n.length;a5++){var a4=n[a5];r(a4,au.cssTouchAction)}};var k=function(){if(ar.length<1){return 0}var a4=Math.abs(ar[1].x-ar[0].x);var a3=Math.abs(ar[1].y-ar[0].y);return an.nPinchDistance=Math.sqrt(a4*a4+a3*a3)};var aj=function(a3){x=false;if(!al){return}var a4=ar.length;if(!aN){x=(a4==1&&au.captureScroll);return}if(an.pointerCount!=a4){Q(a3);if(a4>1){ah();an.nPointers=a4;switch(a4){case 2:an.started=true;an.name="pinch";an.nType=1;if(typeof(aY.onPinchStart)=="function"){M(a3);an.nPinchDistance=0;an.nPinchDistance=k();an.pinchDistanceStart=an.pinchDistanceLast=an.nPinchDistance;an.pinchDistanceStartMaxed=Math.max(at,an.pinchDistanceStart);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchStart.call(J,a3,aS,G)}break;default:an.started=true;an.name="unknown";an.nType=-1}if(an.started){A=true;if(p){aK();p=false;a3._FSI_Canceled=true;aO.call(J,a3,w,G)}if(typeof(aY.onGestureStart)=="function"){M(a3);aY.onGestureStart.call(J,a3,aS,G)}}}else{if(a4<1){ah()}}an.pointerCount=a4;x=false;if(a4==1){if(au.captureScroll){x=true}}else{if(au.capturePinch&&an.nType==1){x=true}}}return an.started};var ah=function(){if(!an.timeoutRestartDown){return}clearTimeout(an.timeoutRestartDown);an.timeoutRestartDown=b};var D=function(){if(ad!=1){return}g(X);ah()};var M=function(a3){a3._FSI_Gesture=an.name;a3._FSI_GestureType=an.nType;a3._FSI_PointerCount=an.nPointers};var Q=function(a3){if(!an.started){return}an.started=false;if(!a3){a3={}}if(an.nType==1&&typeof(aY.onPinchEnd)=="function"){M(a3);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchEnd.call(J,a3,aS,G)}if(typeof(aY.onGestureEnd)=="function"){M(a3);aY.onGestureEnd.call(J,a3,aS,G)}an.name="none";an.nType=0;if(a3&&ad==1){ah();an.timeoutRestartDown=setTimeout(D,20)}};ao()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.VerticalScrollPanel!=b){return}a.VerticalScrollPanel=function(e){var d=this;var c;var f=function(){d.elContainer=document.createElement("div");c=d.elContainerInner=document.createElement("div");a.addClass(c,"fsi-v-scroll-panel-inner");d.elContainer.appendChild(c)};this.destroy=function(){if(d.elContainer.parentNode){a.removeChild(d.elContainer.parentNode,d.elContainer)}};this.setContent=function(g){c.innerHTML="";c.appendChild(g)};f()}}(window.$FSI=window.$FSI||{}));(function(a,b){a.CustomEventListener;if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.utils.getNewEventElementID()}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIMouseWheel")){return}a.utils.registerCustomEvent("FSIMouseWheel",function(){var c=this;var f=100000;var g;a.utils.CustomEventListener.prototype.constructor.call(c,"FSIMouseWheel");c._strClassName="$FSI.CustomEventListenerMouseWheel";this._onListenerAdd=function(h){h.callback=function(i){d(h,i)};a.addEvent(h.element,"mousewheel",h.callback);a.addEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerRemove=function(h){a.removeEvent(h.element,"mousewheel",h.callback);a.removeEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerCountChange=function(h){if(h<1){if(g!=b){clearInterval(g);g=b}}};this.setListenerProps=function(k,i,j){if(typeof(i)!=="string"){return false}var h=c.getListenerObjectByID(k);if(!h){return false}switch(i){case"acceleration":if(j){h.bAccelerate=true;h.acceleration=j;h._accelerate=1;if(h._accelerateMax==b){h._accelerateMax=10}}break;case"accelerationMax":h._accelerateMax=j;break}};var e=function(){var j=c.getListenersArray();var k=true;for(var l=0;l<j.length;l++){var h=j[l];if(h.bAccelerate&&h._accelerate>1){h._accelerate/=1.5*h.acceleration;if(h._accelerate>1.5){k=false}else{k=true;h._accelerate=1}}}if(k){clearInterval(g);g=b}};var d=function(h,i){var k=0;if(i.detail){k=i.detail}else{if(i.wheelDelta){k=-i.wheelDelta}}if(k!=0){i.FSI_normalized_delta=(k>0)?-1:1;f=Math.min(f,Math.abs(k))}else{i.FSI_normalized_delta=0}if(h.bAccelerate){if(g==b){g=setInterval(e,200)}h._accelerate*=h.acceleration;h._accelerate=Math.min(h._accelerateMax,h._accelerate);k=Math.round(h._accelerate*k)}else{h._accelerate=1}i.FSI_delta=-k;i.FSI_weighted_delta=i.FSI_delta/f;i.FSI_normalized_accelerated_delta=(k>0)?-h._accelerate:h._accelerate;var j=c.fireEvent(h,i);if(j===false){h._accelerate=1}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!=c){if(q){j()}else{i()}}};var m=function(p){var q;var r=a.utils.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!=q){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewport")){return}a.utils.registerCustomEvent("FSIViewport",function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.utils.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!=b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!=b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!=d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!=b){return}w=setTimeout(K,N);K()};var K=function(){if(w!=b){clearTimeout(w);w=b}var e=false;var U=L();if(C!=U){C=U;e=true;f()}return e};var J=function(){n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.utils.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);h.left=a.utils.getTopWindow().pageXOffset;h.top=a.utils.getTopWindow().pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!=b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!=b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u==b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!=b){if(U==b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length==0){r()}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.AboutWindow!=b){return}a.AboutWindow=function(d,k){var m=this;var e;var g;var h;var f;var i;var l=function(){e=document.createElement("div");a.utils.setStyleAttr(e,"position: absolute;z-index:1000;width:12em;");e.className="fsi-ui-info-window";h=document.createElement("div");h.className="fsi-ui-title";f=document.createElement("div");f.style.display="inline-block";f.innerHTML=k.title;h.appendChild(f);i=document.createElement("div");i.style.display="inline-block";i.style["float"]="right";i.style.cursor="pointer";i.innerHTML="X";h.appendChild(i);e.appendChild(h);g=document.createElement("div");g.className="fsi-ui-content";var o=k.strLongVersion;o="<h3>"+o.replace(/ build/,'</h3><span class="small">build')+"</span>";var n;if(k.strCopyright==b){n="<br/><br/>&copy; 2018 NeptuneLabs GmbH<br/>";n+='<hr/><a style="color:inherit;text-decoration:none" href="//www.neptunelabs.com/" target="_blank">www.neptunelabs.com</a><br/><br/><span class="small">FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany<br/></span>'}else{k.strCopy=k.strCopyright}o+="<br/>"+n;g.innerHTML=o;e.appendChild(g);d.appendChild(e);a.addEvent(e,"click",j);c()};var c=function(){var o=a.getElementPosition(d);o.width=(o.right-o.left);o.height=(o.bottom-o.top);var n=a.getElementPosition(e);n.width=(n.right-n.left);n.height=(n.bottom-n.top);e.style.left=Math.round((o.width-n.width)/2)+"px";e.style.top=Math.round((o.height-n.height)/2)+"px"};var j=this.destroy=function(){if(typeof(k.fnOnDestroy)=="function"){if(!k.fnOnDestroy.call(this)){return}}a.removeEvent(e,"click",j);a.removeChild(e.parentNode,e)};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MenuBar!==b){return}a.MenuBar=function(k,s,A,J,r){var i=this;var M=this.myViewer=k.iViewer;var B=k.getElementSpace();var h;var x;var u=0;var D=[];var m=b;if(r===b){r={}}this.bEnabled=b;var C={};var n={};var L={};var g=0;var j=0;var z="fsi-ui-button-icon";var q;var E;var o=1;var y=[];var d;var v,K;var p=this.setInterface=function(){v=k.getDebug();K=k.getToolTip()};var G=function(){i.oInterface=k;var N=k.iConfig;E=N.makeBool(N.cfg.menubuttontooltips,true,true);p(k);i.btnID=0;i.sprite=new a.Sprite(A,B.width,g,450,b,b,"fsi-ui-menu-bar");i.sprite.element.style.width="100%";i.sprite.element.style.top="auto";i.sprite.element.style.left="0px";i.sprite.element.style.right="auto";i.sprite.element.style.lineHeight="100%";i.sprite.element.style.bottom="0px";i.sprite.element.style.visibility="hidden";i.iconClassNamesNormal=z;m=setTimeout(f,0)};this.groupButtons=function(N){var Q;var O=[];for(Q=0;Q<N.length;Q++){var P=i.getButtonByCMD(N[Q]);if(P&&P.elButton){O.push(P.elButton)}}if(O.length>0){var S=document.createElement("span");S.className="fsi-ui-button-group-container";var R=O[0].parentNode;R.replaceChild(S,O[0]);for(Q=0;Q<N.length;Q++){S.appendChild(O[Q])}y.push(S)}};var f=function(){if(i.sprite.element.offsetHeight!==0||u++>200){m=b;l()}else{m=setTimeout(f,25)}};this.getButtonContainerWidth=function(){return x.element.offsetWidth};this.addButtonCSSClass=function(N,O){F(N,O,true)};this.removeButtonCSSClass=function(N,O){F(N,O,false)};var F=function(P,Q,O){var N=n[P];if(N===b){return}if(O){a.addClass(N.elButton,Q)}else{a.removeClass(N.elButton,Q)}i.setExternalButtonState(P,N.getState(),N.elButton.className)};this.getExternalButtonID=function(){return o++};var l=function(){var O=i.sprite.getClientDim();g=Math.round(O.height);i.sprite.setSize("100%",g);i.setEnabled(false);if(typeof(s.urlLogo)==="string"&&s.urlLogo.length>0&&s.urlLogo!=="none"){h=document.createElement("div");a.addClass(h,"fsi-ui-logo");a.utils.setStyleAttr(h,"position:absolute;display:none");var N=document.createElement("img");N.className="fsi-ui-logo-image";N.style.backgroundImage="none";N.src=s.urlLogo;h.appendChild(N);a.addEvent(N,"load",w);i.sprite.element.appendChild(h);a.addEvent(h,"click",M.showAboutWindow)}a.addEvent(i.sprite.element,"mouseup",e);a.addEvent(i.sprite.element,"contextmenu",H);i.sprite.element.style.visibility="";J()};this.show=function(N){if(d===N){return}d=N;i.sprite.show(N,false)};this.getVisible=function(){return d};this.destroy=function(){t("onMenuDestroy");if(m!==b){clearTimeout(m);m=b}if(h){a.removeEvent(h,"click",M.showAboutWindow)}a.removeEvent(i.sprite.element,"mouseup",e);a.removeEvent(i.sprite.element,"contextmenu",H);i.removeButtons();i.removeDomElement()};this.removeDomElement=function(){if(i.sprite.element.parentNode){a.removeChild(i.sprite.element.parentNode,i.sprite.element);g=0}};var e=function(N){if(N.which&&N.which===3){j=new Date().getTime()}};var H=function(O){if(j){var N=new Date().getTime()-j;if(N<300){return}}O.preventDefault&&O.preventDefault()};this.getHeight=function(){return g};this.pressButton=function(O){var N=n[O];if(N!==b){N.onMouseDown()}};this.releaseButton=function(O){var N=n[O];if(N!==b){N.onMouseUp()}};var c=function(N,P){var Q=b;if(!N||!P){return Q}if(N.indexOf("_")!==-1){var O=N.split("_");switch(O[0]){case"MouseMode":Q="";if(P.Mode){Q+="<b>"+P.Mode+"</b>"}if(P["Mode"+O[1]]){Q+=" "+P["Mode"+O[1]]}break}}return Q};this.showButtonToolTip=function(O,P){var N;if(P){N=P.getAttribute("fsi-tool-tip");if(k.iConfig.makeBool(N,true)===false){return}}if(N==b){N=O.getCMD()}if(typeof(r[N])==="string"){N=r[N]}i.showToolTip(N,P)};this.getButtonDomElement=function(O){var N=n[O];if(N){return N.elButton}};this.showToolTip=function(P,O,N,Q){if(!K||!E){return}K.show(P,O,N,Q,c)};this.hideToolTip=function(){if(!K||!E){return}K.hide()};this.setEnabled=function(N,O){if(i.bEnabled===N){return}i.bEnabled=N;if(O){return}if(N){a.removeClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}else{a.addClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}t("onMenuEnabled",[N])};this.getButtonEnabled=function(O){var N=n[O];if(N===b){return}return N.bEnabled};this.showButton=function(P,N){var O=n[P];if(O===b){return false}return O.show(N)};this.enableButton=function(P,N){var O=n[P];if(O===b){return false}return O.setEnabled(N)};this.getButtonPressed=function(O){var N=n[O];if(N===b){return false}return N.getPressed()};this.setButtonPressed=function(P,N){var O=n[P];if(O===b){return false}O.setPressed(N);return true};var I=function(O,P){var N;if(C[P]===b){N=C[P]={};N.arButtons=[]}else{N=C[P]}N.arButtons.push(O);O.oGroup=N;O.makeRadioButton()};this.removeButtons=function(){var N;i.unregisterExternalButtons();for(N=0;N<D.length;N++){D[N].destroy()}for(N=0;N<y.length;N++){if(y[N]&&y[N].parentNode){y[N].parentNode.removeChild(y[N])}}D=[];C={};n={}};this.unregisterExternalButtons=function(){for(var P in L){var N=L[P];for(var O=0;O<N.length;O++){N[O].destroy(true)}}L={}};this.addButtons=function(Y,ac){i.removeButtons();var Q;var Z=g-6;var S,ad;var R,aa,T;var O="";if(typeof(ac)==="string"&&ac.length>0){O=" (sorted by parameter MenuButtonOrder)";var N=ac.split(",");var W={};for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){W[Y[aa].cmd.toLowerCase()]=aa}}var V=[];var ab={};for(aa=0;aa<N.length;aa++){T=a.trim(N[aa].toLowerCase());if(W[T]!==b){if(ab[T]===b){ab[T]=true;V.push(Y[W[T]])}}}for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){T=Y[aa].cmd.toLowerCase();if(!ab[T]){V.push(Y[aa])}}}Y=V}else{O=" (default)"}if(!x){x=new a.Sprite(i.sprite.element,B.width,g,2);a.utils.setStyleAttr(x.element,"position:relative");a.addClass(x.element,"fsi-ui-button-container")}var ae;if(v.on){ae=[]}for(aa=0;aa<Y.length;aa++){Q=Y[aa];if(Q.cmd){if(v.on){ae.push(Q.cmd)}if(Q.width===b){S=Z}else{S=Q.width}if(Q.height===b){ad=Z}else{ad=Q.height}R=new a.MenuBarButton(i,x.element,Q,Q.bCheckButton);n[Q.cmd]=R;D.push(R);if(Q.groupID!==b){I(R,Q.groupID)}}if(typeof(Q.fnCreate)==="function"){Q.fnCreate.apply(Q.fnCreateInstance,[R,Q])}if(Q.enabled===false){i.enableButton(Q.cmd,false)}}if(v.on){v.log("Button sequence"+O+": "+ae.join(","))}w();var P=q.run("onRegisterExternalMenuButtons");if(P){i.registerExternalButtonsFromContainer(P)}var U=k.iConfig;if(typeof(U.cfg.externalbuttoncontainer)!=="undefined"){i.registerExternalButtonsFromContainer(U.cfg.externalbuttoncontainer)}t("onMenuReady",[i]);for(var X in C){C[X].arButtons[0].setPressed(true)}};this.createHiddenButton=function(O,Q){if(n[O]!==b){return n[O]}var N={cmd:O,bCheckButton:Q};var P=new a.MenuBarButton(i,b,N,N.bCheckButton);P.bUserButton=true;n[N.cmd]=P;D.push(P);return P};this.setCallbacks=function(N){q=N};var t=this.callListeners=function(O,N){if(q){q.run(O,N)}};this.setContainerSize=function(N){var O=i.sprite.element.style.display;i.sprite.element.style.display="block";var P=a.getElementClientDim(i.sprite.element);g=P.height;if(P.width==0&&P.height==0){return}i.sprite.updateDimension();B=N;i.sprite.setSize("100%",g);i.sprite.element.style.display=O;w();if(d){i.sprite.show(true)}};var w=function(){if(!h){return}h.style.display="";if(h.firstChild!==b&&h.firstChild.offsetWidth>0&&x!==b){var N=(i.sprite.element.offsetWidth-x.element.offsetWidth)/2;if(N-8<h.firstChild.offsetWidth){h.style.display="none"}}};this.setPressedExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setPressed(O)}}};this.enableExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setEnabled(O)}}};this.setExternalButtonState=function(Q,P,R){if(L[Q]!==b){var N=L[Q];for(var O=0;O<N.length;O++){N[O].setState(P,R)}}};this.removeExternalButton=function(P,Q){var N=L[P];if(N!==b){for(var O=0;O<N.length;O++){if(N[O].nExternalButtonID===Q){N.splice(O,1)}}}};M.getMenuButtonPresent=function(O){var N=i.getButtonByCMD(O);return(N!==b&&N.bUserButton!==true)};M.registerExternalMenuButtonsFromContainer=this.registerExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Registering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.registerExternalButton(Q[O],R)}}}v.groupEnd()};M.unregisterExternalMenuButtonsFromContainer=this.unregisterExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Unregistering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.unregisterExternalButton(Q[O],R)}}}v.groupEnd()};M.registerExternalMenuButton=this.registerExternalButton=function(O,R,N){var P=R;if(typeof(P)!=="string"||P.length<1){P="user_tool_tip_only"}if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b){return false}if(O.FSIExternalButton!==b){if(v.on){v.error("The dom element has already been registered as external button for command '"+O.FSIExternalButton.getCMD()+"'.")}return false}var Q=new a.MenuBarExternalButton(i,k,O,P);if(!Q.init()){v.error("The dom element could not be registered as external button for command '"+P+"'.",O);Q.destroy();return false}if(Q.bUserButton){v.log("Registering external button for user command: "+P,O)}else{v.log("Registering external button for command: "+P,O)}O.FSIExternalButton=Q;if(L[P]===b){L[P]=[]}L[P].push(Q);if(q.isset("onAfterRegisterExternalButton")){q.run("onAfterRegisterExternalButton",[O,R,(Q.bUserButton!==true)])}};M.unregisterExternalMenuButton=this.unregisterExternalButton=function(O){if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b||typeof(O.FSIExternalButton)!=="object"||typeof(O.FSIExternalButton.destroy)!=="function"){return false}var N=O.FSIExternalButton;if(v.on){v.log("Unregistering external button for command: "+N.getCMD(),O)}O.FSIExternalButton.destroy();O.FSIExternalButton=b;return true};this.getButtonByCMD=function(N){return n[N]};G()};a.MenuBarExternalButton=function(i,e,c,g){var k=this;var h=i;var f="";var j;var d;this.init=function(){if(c.style===b){return false}k.nExternalButtonID=i.getExternalButtonID();d=i.getButtonByCMD(g);if(d===b){d=h.createHiddenButton(g,e.iConfig.makeBool(c.getAttribute("fsi-check-button")))}if(d===b){return false}k.bUserButton=d.bUserButton;f=a.trim(c.className);if(f.length>0){f+=" "}d.addEvents(c);k.setState(d.getState(),d.getCSSClass());k.setEnabled(d.getEnabled());k.setPressed(d.getIsPressed());c.setAttribute("fsi-registered","true");return true};this.getCMD=function(){return g};this.setPressed=function(l){if(l){c.setAttribute("checked","checked")}else{c.removeAttribute("checked")}};this.setEnabled=function(l){if(l){c.removeAttribute("disabled");a.removeClass(c,"fsi-ui-button-disabled")}else{c.setAttribute("disabled","disabled");a.addClass(c,"fsi-ui-button-disabled")}};this.setState=function(l,m){j=l;c.className=f+m};this.destroy=function(l){if(c.FSIExternalButton){d.removeEvents(c);c.FSIExternalButton=b;c.removeAttribute("fsi-registered");if(d){c.className=a.trim(f)}if(!l){h.removeExternalButton(g,k.nExternalButtonID)}}}};a.MenuBarButton=function(u,f,i,h){var q=this;var v=i.cmd;var k=u;var C;this.bEnabled=true;this.id=k.btnID++;var m=false;var B;var c;var l="";var e=true;var d;var y;var x="";var A,r;var g;var j={passive:false,capture:false};var w=function(){B=q.elButton=document.createElement("div");a.addClass(B,"fsi-ui-button");c=document.createElement("div");a.addClass(c,k.iconClassNamesNormal);B.appendChild(c);if(f){f.appendChild(B)}if(v.length>0){l=v.replace(/#.*$/,"")}else{l=""}if(i.cssClass){if(l.length>0){l+=" "}l+=i.cssClass}B.className="fsi-ui-button "+l;if(!i.bNoMouseEvents){q.addEvents(B)}s(1)};var t=function(D){D.cancelBubble=true;if(D.stopPropagation){D.stopPropagation()}if(D.preventDefault){D.preventDefault()}return false};this.addEvents=function(D){a.addEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.addEvent(D,"mousedown",q.onMouseDown,j);a.addEvent(D,"mouseleave",q.onMouseOut,j);a.addEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.addEvent(D,"touchstart",q.onTouchDown,j);a.addEvent(D,"touchcancel",q.onTouchUp,j);a.addEvent(D,"touchend",q.onTouchUp,j)}};this.removeEvents=function(D){a.removeEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.removeEvent(D,"mousedown",q.onMouseDown,j);a.removeEvent(D,"mouseleave",q.onMouseOut,j);a.removeEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.removeEvent(D,"touchstart",q.onTouchDown,j);a.removeEvent(D,"touchcancel",q.onTouchUp,j);a.removeEvent(D,"touchend",q.onTouchUp,j)}};this.destroy=function(){if(!i.bNoMouseEvents){q.removeEvents(B)}if(B&&B.parentNode){a.removeChild(B.parentNode,B)}};this.getCMD=function(){return v};this.makeCheckButton=function(){h=true};this.makeRadioButton=function(){h=true;m=true};this.getState=function(){return C};this.getCSSClass=function(){return B.className};var s=this.setState=function(E){if(C===E){return}if(h){var D=(E>2);if(D!==y){y=D;z("onMenuButtonSetPressed",null,D)}}o(E)};var o=this.setState=function(F){if(F===C){return}C=F;var G="";if(!q.bEnabled){G="fsi-ui-button-disabled "}switch(C){case 2:G+="fsi-ui-button-hover";break;case 3:G+="fsi-ui-button-active";break;case 4:G+="fsi-ui-button-active";if(q.oGroup!==b){for(var E=0;E<q.oGroup.arButtons.length;E++){var D=q.oGroup.arButtons[E];if(D.id!==q.id){D.setPressed(false)}}}break;default:break}if(G!==x){if(x.length>0){a.removeClass(B,x)}if(G.length>0){a.addClass(B,G)}x=G}k.setExternalButtonState(v,C,B.className)};this.onMouseOver=function(D){A=true;var E=D.target;if(a.hasClass(E,"fsi-ui-button-icon")&&E.parentNode){E=E.parentNode}k.showButtonToolTip(q,E);if(!q.bEnabled||!k.bEnabled){return}if(C===1){s(2)}};this.onMouseOut=function(D){A=false;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}if(r){return}if(C!==1&&C!==4){s(1)}};this.onMouseDown=function(D){z("onMenuButtonMouseDown",D);if(D&&D.type==="mousedown"){if(D.preventDefault){D.preventDefault()}if(D.which!==1){return true}}r=true;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}a.addEvent(window,"mouseup",q.onMouseUp);g=true;if(h){if(C===4){if(!m){s(3)}}else{s(4)}}else{s(3)}p(D)};this.show=function(D){if(e===D){return}e=D;q.elButton.style.display=(D)?"":"none"};this.onTouchDown=function(D){if(A){q.onMouseOut(D)}if(r){q.onMouseUp(D)}q.onMouseDown(D)};this.onTouchUp=function(D){if(A){k.hideToolTip();A=false}q.onMouseUp(D);if(D.preventDefault){D.preventDefault()}};this.onMouseUp=function(E){if(g){a.removeEvent(window,"mouseup",q.onMouseUp);g=false}var F=(E&&E.type==="touchend");if(!F&&!r){return}r=false;if(!q.bEnabled||!k.bEnabled){return}if(!F&&!A&&h&&!m){if(C===4){s(1)}else{s(4)}}var D=(!A)?1:2;if(h){if(C===3){s(D)}}else{s(D)}n(E);if(F||A){u.oInterface.clickMenuButton(v,E);z("onMenuButtonClicked",E)}};this.getEnabled=function(){return q.bEnabled};this.setEnabled=function(D){if(q.bEnabled===D){return}if(!D&&d){n()}if(!D&&(C===1||!h)){q.setState(1)}if(D){a.removeClass(B,"fsi-ui-button-disabled")}else{a.addClass(B,"fsi-ui-button-disabled")}q.bEnabled=D;k.enableExternalButtons(v,D);z("onMenuButtonEnabled",null,D);return true};this.getPressed=function(){return(C>2)};this.getIsPressed=function(){return(h&&q.getPressed())};this.setPressed=function(D){if(!h){return}if(D){s(4)}else{s(1)}k.setPressedExternalButtons(v,D)};var p=function(D){d=true;z("onMenuButtonPressed",D);u.oInterface.pressMenuButton(v,D)};var n=function(D){d=false;z("onMenuButtonReleased",D);u.oInterface.releaseMenuButton(v,D)};var z=function(F,D){var E=[v,D];if(arguments.length>2){E=E.concat(Array.prototype.slice.call(arguments,2))}k.callListeners(F,E)};w()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FlipEffect!=b){return}a.FlipEffect=function(af,aC,aM,f){var aB=this;if(typeof(f)!="object"){f={}}var aD=false;var D;var s;var aH={};var X={};var E={};var L={};var t={};var aG,U;var aN,ar,aJ;var aq,q;var ad,ao;var aL,I;var Z;var O;var T=(a.isInternetExplorer);var R;var B;var M,K,ab,aP;var g,aF;var w,m;var i;var ai,ag;var H,G;var n={};var d={};var ay;var N={};var z;var aQ=false;var u;var k,W,ax;var ae,v;var ak=Math.PI;var aE=false;var e={};var aO;var Q=(!a.isInternetExplorer||a.versionInternetExplorer>11);var aj=(a.isInternetExplorer&&a.versionInternetExplorer<12);var az=a.Easing.easeInOutQuad;var au;var aI={x:0,y:0,offsetX:0,offsetY:0};var P=new a.CSSTransformMatrix();var aA="-webkit-perspective: 10000;perspective: 10000;will-change:transform;";var o=false;var F,h;var av=0;aB.bReverse=false;var al=function(){if(aD){return}aD=true;F=f.bDoublePages;h=(F)?2:1;at();if(f.svgTemplate){ae=f.svgTemplate;ae.setAttribute("style","position:absolute;left:0px;top:0px;")}Z.style.display="none";if(aj){a.addEvent(window,"scroll",an)}};var an=function(){var aS=window.scrollY||window.pageYOffset||document.body.scrollTop;aB.elFlipTop.style.marginTop=(-aS)+"px"};this.destroy=function(){if(!aD){return}aB.cancel();if(Z&&Z.parentNode){a.removeChild(Z.parentNode,Z)}aD=false;if(aj){a.removeEvent(window,"scroll",an)}};this.getContainerElement=function(){return Z};this.getCornerPos=function(){return{x:X.x,y:X.y}};this.setPreliminary=function(aS){o=aS};this.cancel=function(){if(!aE){return false}if(z!=b){cancelAnimationFrame(z);z=b}p();aQ=aE=false;return true};this.appendTo=function(aS){R=aS;aS.appendChild(Z)};this.setContentByString=function(aT,aS){aq.innerHTML=aT;q.innerHTML=aS};this.setContent=function(aS,aV,aT,aU){aB.removeContent();if(aS){aq.appendChild(aS)}if(aV){q.appendChild(aV)}if(aT){ao.appendChild(aT)}if(aU){I.appendChild(aU)}if(aj){an()}};this.setPageSize=function(aT,aU){if(H==aT&&G==aU){return false}H=aT;G=aU;aB.cancel();i=b;D=aT;s=aU;aN.style.width=aq.style.width=D+"px";aN.style.height=aq.style.height=s+"px";ar.style.width=q.style.width=D+"px";ar.style.height=q.style.height=s+"px";aJ.style.width=D+"px";aJ.style.height=s+"px";m=Math.sqrt(D*D+s*s);Z.style.width=2*D+"px";var aV=m-s;var aS=s+2*aV;Z.style.height=aS+"px";aI.offsetY=-aV;aJ.style.top=aV+"px";N.y=aV;O.style.width=D+"px";O.style.height=s+"px";ad.style.width=aL.style.width=aq.style.width=q.style.width=aT+"px";ad.style.height=aL.style.height=aq.style.height=q.style.height=aU+"px";aR();J();return true};this.removeContent=function(){j(aq);j(q);j(ao);j(I)};var j=function(aS){while(aS.firstChild){aS.removeChild(aS.firstChild)}};var y=function(aS){aS.preventDefault();aS.stopPropagation()};var at=function(){var aU;var aT="overflow:hidden;";var aS="position:absolute;left:0px;top:0px;font-size:0px;";Z=ap(aS+aT);Z.className="fsi-pages-flip-effect";if(f.bFixEdgeTransformFlicker){Z.style.transform="rotate(0.001deg)"}aJ=ap(aS,Z);aL=ap(aS+aT,aJ);aB.elBottomStaticContent=I=ap("position:relative",aL);ad=ap(aS+aT,aJ);aB.elTopStaticContent=ao=ap("position:relative",ad);O=ap(aS+aT+aA+"z-index:1;",aJ);B=ap(aS+aT+aA+"z-index:2;",aJ);if(T){aU="position:fixed;transform:rotate(0deg);overflow:hidden;"}else{aU=aS+aT+aA}aB.elFlipTop=aN=ap(aU,B);aB.elFlipTopContent=aq=ap("position:relative",aN);aB.elFlipBottom=ar=ap(aS+aT+aA,B);aB.elFlipBottomContent=q=ap("position:relative;",ar);ah(ar,"0px 0px")};var ap=function(aU,aS){var aT=document.createElement("div");aT.setAttribute("style",aU);if(aS){aS.appendChild(aT)}return aT};var A=function(){if(v){return}v=true;k=S(ae,"fsi_pages_gradient_flip_top");aN.appendChild(k);k.style.zIndex=2;W=S(ae,"fsi_pages_gradient_flip_back");W.style.zIndex=2;ar.appendChild(W);ax=S(ae,"fsi_pages_gradient_flip_shadow");O.appendChild(ax);aR()};var aR=function(){if(!k){return}aO=m+D;k.style.width=D+"px";k.style.height=aO+"px";k.style.left=k.style.top="0px";W.style.width=D+"px";W.style.height=m+"px";ax.style.height=m+D+"px";W.style.left=k.style.top="0px"};var S=function(aV,aT){var aW=false;var aS=aV.cloneNode(true);var aU=aS.getElementsByTagName("rect")[0];if(!aU){aW=true;Z.appendChild(aS);aU=aS.getElementsByTagName("rect")[0]}aU.removeAttribute("id");aS.removeAttribute("id");aU.setAttribute("fill","url(#"+aT+")");aS.setAttribute("style",aS.getAttribute("style")+aA);if(aW){Z.removeChild(aS)}return aS};this.setPosition=function(aS,aT){if(aI.x!=aS||aI.y!=aT){aI.x=aS;aI.y=aT;J()}};var J=function(aT){var aS=(aI.x+aI.offsetX);if(aT!=b){aS+=aT}Z.style.left=aS+"px";Z.style.top=(aI.y+aI.offsetY)+"px"};var ah=function(aS,aT){aS.style.transformOrigin=aS.style.webkitTransformOrigin=aT+" 0px"};var ac=function(aS){if(F){return aS}if(aS<2){aS+=2;aB.bReverse=true;B.style.opacity=""}else{aB.bReverse=false}return aS};var x=function(aT){aT=ac(aT);if(i==aT){return}i=aT;w=D;d.x=n.x=0;d.ofsAngle=0;switch(aT){case 0:X.x=0;X.y=0;d.x=n.x=D;ai=-D;ag=0;n.y=0;d.y=s;N.x=0;d.ofsAngle=ak;u=true;ah(ax,"0px 0px");ah(k,"0px 0px");d.nShadowRotateOffsetX=0;d.nShadowRotateOffsetY=0;d.nShadowTranslateX=-D;d.nShadowTranslateY=-aO;d.nShadowTranslateDir=-1;ah(W,"100% 0px");d.nBackShadowOffsetX=0;d.nBackShadowOffsetY=0;d.nBackShadowTranslateY=m;break;case 1:X.x=0;X.y=s;d.x=n.x=D;ai=-D;ag=-s;n.y=s;d.y=0;N.x=0;d.ofsAngle=ak;u=true;ah(ax,"0px 100%");ah(k,"0px 100%");d.nShadowRotateOffsetX=0;d.nShadowRotateOffsetY=-aO+s;d.nShadowTranslateX=-D;d.nShadowTranslateY=aO;d.nShadowTranslateDir=1;ah(W,"100% 100%");d.nBackShadowOffsetX=0;d.nBackShadowOffsetY=-m+s;d.nBackShadowTranslateY=-m;break;case 2:X.x=D;X.y=0;ai=0;ag=0;n.y=0;d.y=s;N.x=D;u=false;ah(ax,"100% 0px");ah(k,"100% 0px");d.nShadowRotateOffsetX=0;d.nShadowRotateOffsetY=0;d.nShadowTranslateX=0;d.nShadowTranslateY=0;d.nShadowTranslateDir=1;ah(W,"0px 0px");d.nBackShadowOffsetX=0;d.nBackShadowOffsetY=0;d.nBackShadowTranslateY=0;break;case 3:X.x=D;X.y=s;ai=0;ag=-s;n.y=s;d.y=0;N.x=D;u=false;ah(ax,"100% 100%");ah(k,"100% 100%");d.nShadowRotateOffsetX=0;d.nShadowRotateOffsetY=-aO+s;d.nShadowTranslateX=0;d.nShadowTranslateY=0;d.nShadowTranslateDir=-1;ah(W,"0px 100%");d.nBackShadowOffsetX=0;d.nBackShadowOffsetY=s-m;d.nBackShadowTranslateY=0;break}g=aF=2*m;B.style.width=g+"px";B.style.height=aF+"px";aJ.style.left=N.x+"px";if(u){ad.style.left=D+"px"}else{ad.style.left=-D+"px"}var aS=g+"px "+aF/2+"px";ah(B,aS);ah(aN,aS);if(!F){if(i>1){av=-D}else{av=0}J(av)}};var am=this.flip=function(aT,aV,aU){aB.bFlipFinishing=false;aB.bPointerFlip=false;if(!aV){aV=40}if(a.isMobileDevice){aV=Math.ceil(aV/1.5)}az=a.Easing.easeInOutQuad;aB.cancel();r();x(aT);ay=C();ay.angleRange=ak;ay.angleStart=0;ay.pos=1;ay.frames=aV;if(aB.bReverse){ay.startX+=ay.distX;ay.distX=-ay.distX;ay.angleRange=-ay.angleRange}aH.x=ay.startX;aH.y=ay.startY;aH.offset=0;var aS=Math.random()/3-0.25;if(aU){aS=-0.05}if(u){aS=-aS}ay.radius=(aS)*w;if(i%2!=0){ay.radius=-ay.radius}aQ=true;aw()};var r=function(){aE=true;Z.style.display="";if(!v){A()}};var l=function(aS){aH.clientX=aS.clientX;aH.clientY=aS.clientY};var c=function(aS){aH.clientX=aS.touches[0].clientX;aH.clientY=aS.touches[0].clientY};this.handlePointerDown=function(aT,aW){aB.bFlipFinishing=false;if(aT.touches){au=c}else{au=l}if(!aW){au(aT)}else{aH.clientX=aW.x;aH.clientY=aW.y}az=a.Easing.easeOutQuad;if(z!=b){cancelAnimationFrame(z);z=b}aQ=false;r();var aU=a.getBoundingClientRect(Z);var aS=av;aH.x=aH.clientX-aU.left+av;aH.y=aH.clientY-aU.top-N.y;var aV=0;if(aH.x>D/2){aV+=2}if(aH.y>s/2){aV++}x(aV);aH.fsiOffsetLeft=aU.left+N.x+av-aS;aH.fsiOffsetTop=aU.top+N.y;if(aB.bReverse){aH.fsiOffsetLeft+=Math.round(0.95*D)}aH.x=aH.clientX-aH.fsiOffsetLeft;aH.y=aH.clientY-aH.fsiOffsetTop;aH.offset=aH.y-n.y+1;if(Math.abs(aH.offset)<50){aH.offset=0}aT.preventDefault();aa();return true};this.getFlipCorner=function(){return i};this.handlePointerMove=function(aS,aT){if(!aT){au(aS)}else{aH.clientX=aT.x;aH.clientY=aT.y}aH.x=aH.clientX-aH.fsiOffsetLeft;aH.y=aH.clientY-aH.fsiOffsetTop;if(z==b){z=requestAnimationFrame(Y)}return true};this.handlePointerUp=function(aS){aB.bPointerFlip=true;aK()};var Y=function(){if(!aE){return}z=b;aa()};var C=function(){var aS={};aS.x=(u)?2*D:-D;aS.startX=(u)?0:D;aS.y=aS.startY=X.y;aS.distX=aS.x-aS.startX;aS.distY=aS.y-aS.startY;return aS};var aK=function(){if(!aE){return}var aS=aH.x;if(aB.bReverse){aS+=D}aH.offset=0;var aT=false;ay=C();if(o){aT=!aB.bReverse}else{if(u){if(aS+D/2<D){aT=true;ay.x=0}}else{if(aS>D/2){aT=true;ay.x=D}}}if(aT){ay.x=X.x}ay.angleStart=ay.angleRange=ak/2;ay.radius=E.y-ay.startY;var aU=E.y-ay.startY;if(i%2!=0){aU=-aU}if(aT&&aU<0){ay.angleRange=ak+ak/2}ay.startX=E.x;ay.distX=ay.x-ay.startX;ay.distY=ay.y-ay.startY;ay.pos=1;ay.frames=(a.isMobileDevice)?20:32;aQ=true;aw();if(aB.bReverse){aT=!aT}aB.bFlipAborted=aT;aB.bFlipFinishing=!aT};var aw=function(){aH.x=az(ay.pos,ay.frames,ay.startX,ay.distX);if(ay.radius!=b){var aS=ay.angleStart+(aH.x-ay.startX)/Math.abs(ay.distX)*ay.angleRange;aH.y=ay.startY+ay.radius*Math.sin(aS)}else{aH.y=az(ay.pos,ay.frames,ay.startY,ay.distY)}if(ay.pos==ay.frames){z=b;aQ=false;aH.x=ay.x;aH.y=ay.y;aE=false;aB.bFlipFinishing=false;if(f.onFlipFinish){f.onFlipFinish.apply(aB,[aB.bPointerFlip,aB.bFlipAborted])}else{p()}return true}else{aa();ay.pos++;z=requestAnimationFrame(aw)}};var V=function(aS){for(var aT=0;aT<aS.length;aT++){var aU=aS[aT];if(aU){aU.style.webkitTransform=aU.style.transform=""}}};var p=this.resetTransform=function(){Z.style.display="none";V([B,aN,ar,k,ax,W])};var aa=function(){var a0,aZ,a3,a7,aY,aX;E.x=aH.x;E.y=aH.y-aH.offset;a0=Math.abs(E.x-n.x);aZ=Math.abs(E.y-n.y);a3=Math.sqrt(a0*a0+aZ*aZ);if(a3>w){a7=Math.atan2(n.y-E.y,n.x-E.x);E.x=n.x-Math.cos(a7)*w;E.y=n.y-Math.sin(a7)*w}a0=Math.abs(E.x-d.x);aZ=Math.abs(E.y-d.y);a3=Math.sqrt(a0*a0+aZ*aZ);if(a3>m){a7=Math.atan2(d.y-E.y,d.x-E.x);E.x=d.x-Math.cos(a7)*m;E.y=d.y-Math.sin(a7)*m}L.x=E.x+0.5*(X.x-E.x);L.y=E.y+0.5*(X.y-E.y);L.angle=Math.atan2(X.y-L.y,X.x-L.x);L.tangent=L.x-Math.tan(L.angle)*(X.y-L.y);if(L.tangent<0){L.tangent=0}t.bottomX=L.tangent;t.bottomY=X.y;L.bottomX=L.x;L.bottomY=t.bottomY;U=Math.atan2(t.bottomY-E.y,t.bottomX-E.x)-d.ofsAngle;aG=Math.atan2(t.bottomY-L.y,t.bottomX-L.x);if(aG==0){aG=ak/2}else{if(aG<0){aG+=ak}}aG-=ak/2-d.ofsAngle;var a5=L.x-g;var a4=L.y-aF/2;P.init();P.rotate(aG);P.translate(a5,a4);P.applyTo(B);P.init();if(Q){aY=-a5;aX=-a4;P.translate(aY,aX);P.rotate(-aG);P.applyTo(aN)}else{P.rotate(0.0001);P.applyTo(aN)}aY=-g+E.x;aX=-aF/2+E.y;P.init();if(ai||ag){P.translate(ai,ag)}P.rotate(U);P.translate(aY-a5,aX-a4);P.rotate(-aG);P.translate(g,aF/2);P.applyTo(ar);e.y=n.y;if(L.x==0){e.x=a6=0}else{var a9=-aG+ak;var a6=(n.y-L.y)/Math.cos(a9);e.x=L.x+Math.sin(a9)*a6}var bc,bb,a2,a1,ba;a0=L.x-E.x;aZ=L.y-E.y;var aU=Math.sqrt(a0*a0+aZ*aZ);a0=2*D-Math.abs(X.x-E.x);aZ=Math.abs(X.y-E.y);var aV=Math.sqrt(a0*a0+aZ*aZ);var aW;if(L.y>0&&L.y<s){a0=L.x-e.x;aZ=L.y-e.y;aW=Math.sqrt(a0*a0+aZ*aZ)}else{aW=0}a0=X.x-L.x;aZ=X.y-L.y;var aS=Math.sqrt(a0*a0+aZ*aZ);a7=aG;a2=d.nShadowRotateOffsetX;a1=d.nShadowRotateOffsetY;ba=Math.abs((X.x-L.x)/D/2.7);bc=-aS+d.nShadowTranslateX;if(u){bc+=(D-ba*D)}bb=-a6+d.nShadowTranslateY-d.nShadowTranslateDir*Math.abs(a6);P.init();P.scale(ba,1);P.translate(bc,bb);P.rotate(a7);P.translate(a2,a1);P.applyTo(k);ba=aU/D;bc=-aS+d.nShadowTranslateX+D;if(!u){bc-=D-ba*D}P.init();P.scale(ba,1);P.translate(bc,bb);P.rotate(a7);P.translate(a2,a1);P.applyTo(ax);var aT=aV/(2*D);aT=Math.max(0,Math.min(1,aT));O.style.opacity=aT;if(!F&&!aB.bReverse){aT=aV/(D/4);aT=Math.max(0,Math.min(1,aT));B.style.opacity=aT}ba=aU/D;bc=0;bb=-d.nShadowTranslateDir*aW-d.nBackShadowTranslateY;if(u){bc+=ba*D}a2=d.nBackShadowOffsetX;a1=d.nBackShadowOffsetY;a7=aG-U;P.init();P.scale(ba,1);P.translate(bc,bb);P.rotate(a7);P.translate(a2,a1);P.applyTo(W);var a8=10*aT;W.style.opacity=Math.max(0,Math.min(1,a8))};al()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageInput!=b){return}a.PageInput=function(n,m,i){var o=this;var p=n.iConfig;var q=m.getDebug();var j;var v="";var u;var t;var e=true;var r=[];var s=function(){i.elButton.innerHTML="";j=document.createElement("input");j.setAttribute("type","text");i.elButton.appendChild(j);a.addEvent(j,"focus",f);a.addEvent(j,"blur",l);a.addEvent(j,"keydown",d);t=m.getMenu();k("onMenuButtonReleased",c);k("onMenuDestroy",g);k("onMenuReady",h)};this.destroy=function(){for(var w=0;w<r.length;w++){n.removeListener(r[w].event,r[w].fn)}if(!j){return}a.removeChild(j.parentNode,j)};var k=function(y,x){var w=n.addListener(y,x,o);if(w){r.push({event:y,fn:x})}};this.hide=function(){if(!e){return}e=false;i.elButton.style.display="none";if(t){t.showButton("PageInputEnter",false)}};this.show=function(){if(e){return}e=true;if(t){t.showButton("PageInputEnter",true)}i.elButton.style.display=""};var c=function(x){if(x=="PageInputEnter"&&j.value.length>0){var w=n.gotoPage(j.value,true);if(!w){j.focus()}}};var g=function(){t=b};var h=function(w){if(t){t=w;t.enableButton("PageInputEnter",false)}};var f=function(w){a.addClass(i.elButton,"fsi-input-focussed");m.onUserAction();j.value="";u=true;if(t){t.enableButton("PageInputEnter",true)}};var l=function(w){a.removeClass(i.elButton,"fsi-input-focussed");j.value=v;u=false;if(t){t.enableButton("PageInputEnter",false)}};this.blur=function(){if(u){j.blur()}};var d=function(w){m.onUserAction();switch(w.which){case 13:var x=n.gotoPage(j.value,true);if(x){j.blur()}break;case 27:j.blur();break}};this.onPageChange=function(x,w){v=x+" / "+w;if(!u){j.value=v}};s()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PrintImageList!=b){return}a.PrintImageList=function(n,f,k){var o=this;var h;var e;var g=a.mobileOS=="android";var m;var d,j;var l;this.destroy=function(){if(!h){return}c()};this.print=function(){if(!k){f.getDebug().error("PrintImageList: No print options");return}if(!k.imageList){f.getDebug().error("PrintImageList: Missing list of images");return}h=true;var y=("objectFit" in document.body.style);var q;if(!k.width||!k.height){q="portrait"}else{if(k.width>=k.height){q="landscape"}else{q="portrait"}}var p=function(){var A=[];for(var B=0;B<k.imageList.length;B++){A.push("<div>");A.push('<img alt="" src="'+k.imageList[B]+'" onload="ili()"/>');A.push("</div>")}return A.join("\r\n")};var v=function(A){if(A==false){return"document.execCommand('print', false, null);"}else{return"window.focus();window.print();"}};var r=function(A){if(A){return"div {height:100%;page-break-after: always;}\nimg {width:100%;height:100%;object-fit: contain;}"}else{return"div{width: 100%;height: 100%;text-align: center;page-break-after: always;}\nimg {height: auto;width: 100%;}"}};var u=function(A){if(A==false){return"<script>printMe();<\/script>"}};var x=["<!DOCTYPE>","<html>","<head>","<meta charset=utf-8>",'<meta http-equiv="X-UA-Compatible" content="IE=edge">','<style type="text/css" media="print">',"@page{size:auto;margin: 0mm;}","html{background-color: #fff; margin: 0px;}","body{height: 100%;border: 0;margin: 0mm 0mm 0mm 0mm;}",r(y),"</style>",'<style type="text/css">',"div.divProgress{margin:20px;width:500px;position:fixed;top:0px;left:0px;z-index:1;background-color:white;border:2px solid black;padding:12px;font-family:sans-serif;font-size:18px;color:black;}","</style>",'<script type="text/javascript">',"iFSIImageListPrint = (document.iFSIImageListPrint)?document.iFSIImageListPrint:parent.$FSI.oPrintImageListInstances["+k.idInstance+"];","var maxImages="+k.imageList.length+";","var curImages=0;","function printMe(){iFSIImageListPrint.onBeforePrint();"+v(y)+"iFSIImageListPrint.printFinisher()}","function ili(){curImages++;iFSIImageListPrint.printUpdater(curImages,maxImages)}","<\/script>","</head>",'<body onload="printMe();">',p(k),u(y),"</body>","</html>"];var z=function(){o.printFinisher();c()};if(g){m=window.open();l=m.document;var w=['<div id="divProgress" class="divProgress">',"Please wait. Downloading print data...<br/>","Close this browser window to cancel printing.<br/>",'<progress max="100" id="printProgress" style="width:100%;height:18px;margin-top:20px;" />',"</div>"];x=x.concat(w);a.addEvent(m,"beforeunload",z);a.addEvent(m,"unload",z)}else{var t=o.iframe=document.createElement("iframe");t.setAttribute("width","400");t.setAttribute("height","400");t.style.position="absolute";t.style.left=t.style.top="0px";t.style.display="none";document.body.appendChild(t);l=t.contentDocument||t.contentWindow.document}l.iFSIImageListPrint=o;var s=x.join("\r\n");l.open();l.write(s);l.close()};this.printUpdater=function(q,p){if(k.updateCallback){k.updateCallback.apply(n,arguments)}if(!d){d=l.getElementById("printProgress")}if(d){d.value=100*q/p}};this.onBeforePrint=function(){if(!j){j=l.getElementById("divProgress")}if(j!=b&&j.parentNode){j.parentNode.removeChild(j)}};this.printFinisher=function(){if(!h){return}if(k.finishCallback){k.finishCallback.apply(n,arguments)}};var c=this.finishPrinting=function(){if(!h){return}if(e!=b){clearTimeout(e)}if(a.mobileOS=="ios"){a.addEvent(window,"touchstart",i)}else{e=setTimeout(i,100)}};var i=function(){if(!h){return}if(a.mobileOS=="ios"){a.removeEvent(window,"touchstart",i)}if(e!=b){clearTimeout(e)}e=b;if(o.iframe&&o.iframe.parentNode){document.body.removeChild(o.iframe)}o.iframe=b;if(m){m.close()}m=b;h=false;if(k.onRemove){k.onRemove.apply(n,arguments)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesSearchDialog!=b){return}a.PagesSearchDialog=function(c,m,h){var k=this;var n;var Z;var C=m.iConfig;var Y=[];var T;if(typeof(h)!="object"){h={}}var G;var I={};var r=1;var A;var s,S,u,J;var Q;var R={};var l=false;var q;var W;var U;var K={};var v;var o;var O;var N;var Z=m.getRootContainer();var f=m.cfgString("SearchCustomURL",C.getServerBase());var L=m.cfgBool("SearchUseMethodGet");var d=(m.cfgString("SearchResultClickAction","flip")!="zoom");var g=m.cfgBool("SearchSortResults",false);var j=m.cfgString("SearchResultServerTemplate","pages_searchresult.json");var z=m.cfgString("SearchContext","iptc.fsi_search_data,iptc.caption,iptc.fsi_extra");var F=m.cfgString("SearchType","simplesearch");var aa={and:1,or:1,not:1};var x='+-&|!(){}[]^"~*?:\\';var t;var V=function(){if(n){return}n=true;var ae=a.trim(m.cfgString("SearchParameters",""));if(ae.length>0){if(ae.charAt(0)!="?"){ae="?"+ae}N={};C.parseQuery(ae,N)}if(h&&h.oMenu&&typeof(h.oMenu.sprite)=="object"){T=document.createElement("input");T.setAttribute("type","search");T.className="fsi-dialog-search-input";s=h.oMenu.sprite.element;if(m.cfgBool("SearchInput",true)){s.appendChild(T);T.parentNode.FSI_bMenuContainsSearchInput=true}T.style.top=((s.offsetHeight-T.offsetHeight)/2)+"px";if(a.isEventSupported){a.addEvent(T,"input",B)}else{a.addEvent(T,"keyup",B);a.addEvent(T,"change",B);a.addEvent(T,"paste",B)}a.addEvent(T,"focus",p)}m.iCallbacks.run("onSearchInit",[T]);X()};this.destroy=function(){if(!n){return}k.closeDialog();if(q){q.destroy();q=b}if(a.isEventSupported){a.removeEvent(T,"input",B)}else{a.removeEvent(T,"keyup",B);a.removeEvent(T,"change",B);a.removeEvent(T,"paste",B)}a.removeEvent(T,"focus",p);if(G&&G.parentNode){a.removeChild(G.parentNode,G)}if(T&&T.parentNode){a.removeChild(T.parentNode,T)}n=false};var p=function(){var ae=a.trim(T.value);if(ae.length>0&&G){H()}};var B=function(ae){if(Q!=b){clearTimeout(Q);Q=b}Q=setTimeout(y,500)};var y=function(){Q=b;k.search(T.value)};var E=function(){if(G!=b){return}var af;var ae=m.getMenuHeight();G=document.createElement("div");Z.appendChild(G);S=document.createElement("div");S.className="fsi-dialog-search-no-results";G.className="fsi-dialog fsi-dialog-search";G.style.bottom=ae+"px";J=document.createElement("div");J.className="fsi-dialog-close";G.appendChild(J);a.addEvent(J,"click",k.closeDialog);u=document.createElement("h1");G.appendChild(u);U=document.createElement("div");U.className="fsi-dialog-search-results";G.appendChild(U);k.onLanguageDataReady();a.addEvent(document,"keyup",e)};var X=function(){if(!T.parentNode||!T.parentNode.FSI_bMenuContainsSearchInput){return}var af=0;T.style.display="";var ah=m.getMenu();if(ah){af=ah.getButtonContainerWidth()}var ag=(Z.offsetWidth-af)/2;var ae=((ag-12)>T.offsetWidth);if(!ae){T.style.display="none"}O=ae};this.onResize=function(ae){if(ae&&ae.FSI_after_treshold){X()}if(!l){return}u.style.width=(U.offsetWidth-100)+"px";var af=a.utils.getElementPaddings(G);var ag=m.getMenuHeight();G.style.height=(Z.offsetHeight-ag)+"px";var ah=a.getElementMargins(u);U.style.height=(G.clientHeight-u.offsetHeight-ah.top-ah.bottom-af.top-af.bottom)+"px"};var H=function(){if(l){return}E();G.style.display="block";l=true;k.onResize();if(q!=b){q.show()}m.iCallbacks.run("onShowSearchDialog",[true])};var ab=function(){if(q){q.destroy();q=b}if(m.iCallbacks.isset("onSearchResults")){m.iCallbacks.run("onSearchResults",[a.utils.cloneArray(o),a.utils.cloneArray(R._arImages)])}var ae=ac("PagesSearchDialogResultsTitle").replace(/%%phrase%%/,v);u.innerText=ae.replace(/%%count%%/,R.images.length);if(R.images.length>0){if(S.parentNode){S.parentNode.removeChild(S)}var af={};af.initialPageIndex=1;af.imageOptions={};if(m.cfgString("effects")!=b){af.imageOptions.effects=m.cfgString("effects")}af.elContainer=U;af.pageOptions={bInteractive:false,bImageOnly:true,bGroupDoublePages:false,bPageNumbers:true};af.nScrollAnimationFrames=12;af.nCreateAhead=0.2;af.bScrollToCurrentTopPageAfterResize=true;af.name="SearchResults";af.bNoBendEffect=true;af.nConcurrentImageLoad=24;af.onPageClick=i;af.strContainerClass="fsi-pages-search-results fsi-pages-scrollbar";af.bCenterContent=true;var ag=m.cfgInt("searchThumbSize",320);af.thumbWidth=af.thumbHeight=ag;a.addClass(m.pageIndexContainer,"fsi-pages-search-results");q=new a.PageLayoutGrid(c,m,R,C,af);q.getCustomPageLayoutData=M;q.getPageNumberString=P;q.init();if(m.cfgBool("SearchAutoSelectFirstResult",false)){D(0)}}else{U.appendChild(S)}};var P=function(ae){return m.getPageNumberString(K[ae])};var i=function(af,ae){if(af!=b){D(af.nIndex);k.closeDialog()}};var D=function(ae){var af=K[ae];if(d){m.gotoPageByIndex(af,true)}else{c.gotoPageAndZoom(af)}};this.closeDialog=function(ae){if(!l){return}l=false;if(q!=b){q.hide()}G.style.display="none";if(!ae){T.blur()}m.iCallbacks.run("onShowSearchDialog",[false])};var ac=function(af,ae){if(I[af]!==b){return I[af]}else{if(ae===b){ae=""}return ae}};var e=function(ae){switch(ae.which){case 27:k.closeDialog();break}};var w=function(){A={};var ae=m.oImageList._arImages;for(var af=0;af<ae.length;af++){A[ae[af]]=af}};this.runSearch=function(ae){T.value=ae;k.search(ae)};this.search=function(aj){var ae=aj;aj=a.trim(aj);if(aj.length<2){k.closeDialog(true);return}if(!m.oImageList){W=aj;return}if(v==aj){H();return}v=aj;r++;W=b;if(m.cfgBool("SearchAutoWildCards",false)){for(var al in aa){if(aa[aj]){aj=aj.replace(al,al.toUpperCase())}}aj=aj.split(" ");for(var ai=0;ai<aj.length;ai++){var ak=a.trim(aj[ai]);var ah=ak.charAt(ak.length-1);if(aa[ak]===1){ak=ak.toUpperCase()}else{if(ak.length>0&&x.indexOf(ah)==-1){ak+="*"}else{if(ak==="*"){ak=""}}}aj[ai]=ak}for(ai=aj.length-1;ai>-1;ai--){if(aj[ai].length<1){aj.splice(ai,1)}}aj=aj.join(" ")}var af={query:aj,source:h.dir,context:z,tpl:j,type:F,limit:"0,"+m.maxPage};if(typeof(N)=="object"){a.utils.mergeObjects(af,N)}m.iCallbacks.run("onSearchStart",[aj,ae]);if(L){var ag=f;if(ag.indexOf("?")===-1){ag+="?"}ag+=C.objectToQuery(af);C.loadFile(ag,ad,b,r)}else{C.loadFile(f,ad,b,r,"POST",af)}};this.onDataComplete=function(){if(W!=b){T.value=W;k.search(W)}k.onLanguageDataReady()};this.onLanguageDataReady=function(){if(t){return}I=m.getLanguageData();if(!I){return}if(T){T.setAttribute("placeholder",ac("PagesSearchPlaceholder"))}if(!u){return}t=true;S.innerHTML=ac("PagesNoSearchResults");u.innerText=ac("PagesSearchDialogResultsTitle")};var M=function(ae){ae.nMinPage=1;ae.nMaxPage=R.images.length;ae.nImages=R.images.length};var ad=function(ai,ae,ah){if(typeof(ae)!="object"||typeof(ae.results)!="object"){return}var ag;if(ah!==r){return}k.closeDialog(true);m.getDebug().log((ae.results.length-1)+" results for phrase '"+v+"'");if(typeof(ae)=="object"&&typeof(ae.results)=="object"&&ae.results.length>0){R.images=[];R._arImages=[];o=[];if(A==b){w()}for(ag=0;ag<ae.results.length;ag++){var af=A[ae.results[ag]];if(af!=b){o.push(af)}}if(g){o.sort()}for(ag=0;ag<o.length;ag++){var af=o[ag];K[ag]=af;R.images.push(m.oImageList.images[af]);R._arImages.push(m.oImageList._arImages[af])}H();ab()}else{}};this.show=function(ae){if(!ae){k.closeDialog()}else{if(G){H()}}};V()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesPrintDialog!=b){return}a.PagesPrintDialog=function(c,j,E,f){var i=this;var k;var Q;var H;var m;var p=j.iConfig;var P=[];if(typeof(f)!="object"){f={}}var t;var J="FSIPagesPrintRadio_"+c.getInstanceID();var B=1;var o=j.getMinMaxRealPages();var u=j.getLanguageData();var r;var w=false;var I;var K,S;var U,F;var y=j.getCurrentPageRange();var g,L,v;var s=0;var n;var O=function(){if(k){return}k=true;var aa,ac;Q=j.getRootContainer();t=document.createElement("div");t.className="fsi-dialog fsi-dialog-print";t.style.bottom=j.getMenuHeight()+"px";v=document.createElement("div");v.className="fsi-dialog-close";t.appendChild(v);a.addEvent(v,"click",j.closePrintDialog);aa=document.createElement("h1");aa.innerHTML=T("PagesPrintDialogTitle");t.appendChild(aa);g=document.createElement("div");aa=document.createElement("span");aa.className="fsi-dialog-body-text";aa.innerHTML=T("PagesPrintDialogText");g.appendChild(aa);S=document.createElement("fieldset");ac=T("CurrentPage(s)","Current Page(s)");var Y=R(ac,"current",{checked:"checked"});S.appendChild(Y);S.appendChild(R(T("AllPages","All Pages"),"all"));ac=T("Page Range","Page Range (e.g. 1-5;12;20-25)");Y=R(ac,"defined");L=Y.FSIInput;S.appendChild(Y);var W=r=document.createElement("input");W.className="fsi-dialog-input-page-range";Y.appendChild(W);a.addEvent(r,"focus",l);I=document.createElement("div");I.className="fsi-dialog-error";Y.appendChild(I);g.appendChild(S);t.appendChild(g);F=document.createElement("div");F.style.display="none";var V=document.createElement("h3");V.innerHTML=T("WaitForPrintData","Please wait. Downloading print data...");F.appendChild(V);U=document.createElement("progress");U.setAttribute("max","100");U.style.width="100%";F.appendChild(U);t.appendChild(F);var Z;var X=document.createElement("span");X.className="fsi-dialog-main-button-group";Z=x(T("Cancel","Cancel"),j.closePrintDialog);X.appendChild(Z);Z=K=x(T("PagesPrintButton","Ok"),N);X.appendChild(Z);t.appendChild(X);Q.appendChild(t);var ab=a.getBoundingClientRect(t);if(window.innerWidth>0&&ab.width>window.innerWidth){t.style.width=window.innerWidth+"px"}t.style.left=(Q.offsetWidth-t.offsetWidth)/2+"px";z(null,"current");a.addEvent(document,"keyup",e)};this.destroy=function(){if(!k){return}a.removeEvent(r,"focus",l);if(a.oPrintImageListInstances!=b){delete a.oPrintImageListInstances[j.getInstanceID()]}a.removeEvent(document,"keyup",e);G();if(t&&t.parentNode){a.removeChild(t.parentNode,t)}k=false};var l=function(V){L.checked="checked";z(null,"defined")};var T=function(W,V){if(u[W]!=b){return u[W]}else{return V}};var x=function(X,W){var V=document.createElement("input");V.setAttribute("type","button");V.setAttribute("value",X);if(W!=b){a.addEvent(V,"click",W)}return V};var z=function(V,W){if(V&&V.target){W=V.target.getAttribute("value")}if(W=="defined"){r.removeAttribute("readonly");a.removeClass(r,"fsi-dialog-input-page-range-readonly");r.focus()}else{r.setAttribute("readonly","readonly");a.addClass(r,"fsi-dialog-input-page-range-readonly")}switch(W){case"current":r.value=y;break;case"all":r.value=p.getPageNumber(o.nMin)+"-"+p.getPageNumber(o.nMax);break}};var R=function(Z,ab,X){var ac=document.createElement("div");ac.className="fsi-dialog-option-element";var Y=document.createElement("input");var W=J+"_"+B;B++;Y.setAttribute("type","radio");Y.setAttribute("id",W);Y.setAttribute("name",J);Y.setAttribute("value",ab);ac.FSIInput=Y;a.addEvent(Y,"change",z);if(X){for(var aa in X){Y.setAttribute(aa,X[aa])}}var V=document.createElement("label");V.setAttribute("for",W);V.innerHTML=Z;ac.appendChild(Y);ac.appendChild(V);return ac};var A=function(Y,Z,X,aa,W){var V=T(Y);if(V!=b&&V.length>0){V=V.replace(/%%e1%%/,Z);if(X!=b){V=V.replace(/%%e2%%/,X)}V=V.replace(/%%min%%/,aa);V=V.replace(/%%max%%/,W)}return V};var D=function(af,ab,V){var ac,W,aa,ae,ad;w=false;var X=[];if(af.length>0){af=af.split(";");for(var Z=0;Z<af.length;Z++){ac=af[Z];if(ac.indexOf("-")!=-1){W=ac.split("-");if(W.length==2){ae=W[0];ad=W[1];W[0]=p.getPageIndex(parseInt(W[0]));W[1]=p.getPageIndex(parseInt(W[1]));if(!isNaN(W[0])&&W[0]>=ab&&W[0]<=V&&!isNaN(W[1])&&W[1]>=ab&&W[1]<=V){if(W[0]>W[1]){aa=W[0];W[0]=W[1];W[1]=aa}for(var Y=W[0];Y<=W[1];Y++){X.push(Y)}}else{w=A("InvalidPageRange",ae,ad,ab,V)}}}else{if(ac.length>0){ae=ac;ac=p.getPageIndex(parseInt(ac));if(!isNaN(ac)&&ac>=ab&&ac<=V){X.push(ac)}else{w=A("InvalidPageValue",ae,b,ab,V)}}}}}return X};var e=function(V){switch(V.which){case 27:j.closePrintDialog();break;case 13:N()}};var G=function(){s++;if(H){H.destroy();H=b}};var N=function(){G();m=r.value;P=D(m,o.nMin,o.nMax);if(w){I.innerText=w;I.style.display="block";r.focus();return}else{I.innerHTML=""}if(P.length<1){return false}K.style.display=g.style.display="none";F.style.display="";a.addClass(t,"fsi-pages-print-dialog-loading");if(!j.bListWithDimensionLoaded){M()}else{h()}return true};var q=function(X,V,W){if(W.nInfoJobID!=s){return}W.oImage.width=V.width;W.oImage.height=V.height;n++;if(n===P.length){h()}};var M=function(){s++;n=0;for(var W=0;W<P.length;W++){var Y=P[W];var V=E.images[Y];if(V.width===b){var X={nInfoJobID:s,oImage:V};p.loadImageInfo(E._arImages[Y],q,X)}else{n++}}if(n===P.length){h()}};var h=function(){var ai=j.cfgInt("PrintResolution",2000);var ah=j.cfgString("PrintEffects","");var X;if(ah.length>0){if(ah.indexOf("?")===-1){ah="?"+ah}X={};p.parseQuery(ah,X)}if(X===b){X={}}var ab=new a.CroppedImage();var ac=[];var aj=E._arImages;for(var ae=0;ae<P.length;ae++){var aa=P[ae];var Z=E.images[aa];var W=aj[aa];if(W!=null){var ad=Z.width;var ag=Z.height;if(ai<ad||ai<ag){var af=j.getImageDimFitInto(ad,ag,ai,ai);ad=af.width;ag=af.height}Y="";ab.setSourceDimension(ad,ag);ab.setCropFromConfig(p.cfg);if(ab.isCropped()){if(j.bAutoFlipCrop&&aa%2){ab.flipCropHorz()}var Y=ab.getPixelRangeParametersByCalculatedResult(ab.getPixelRangeRect())}if(!ab.isCropped()){X.width=ad}ac.push(p.getImageURL(W,X)+Y)}}var ak=j.getInstanceID();var V={imageList:ac,updateCallback:C,finishCallback:d,idInstance:ak};H=new a.PrintImageList(i,j,V);if(a.oPrintImageListInstances==b){a.oPrintImageListInstances={}}a.oPrintImageListInstances[ak]=H;j.iCallbacks.run("onPrintPages",[P,ac]);H.print()};var C=function(W,V){U.value=Math.floor(100*W/V)};var d=function(){j.closePrintDialog()};O()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesSaveDialog!=b){return}a.PagesSaveDialog=function(r,w,l){var x=this;var n;var G;var z=w.iConfig;var B;var t="FSIPagesSaveRadio_"+r.getInstanceID();var o=1;var u=w.getLanguageData();var k,e;var y,v;var f;var p;var E=function(){if(n){return}n=true;f=w.getLayout().getCurrentContainer();var L;G=w.getRootContainer();B=document.createElement("div");B.className="fsi-dialog fsi-dialog-save";B.style.bottom=w.getMenuHeight()+"px";v=document.createElement("div");v.className="fsi-dialog-close";B.appendChild(v);a.addEvent(v,"click",w.closeSaveDialog);L=document.createElement("h1");L.innerHTML=c("PagesSaveDialogTitle");B.appendChild(L);y=document.createElement("div");L=document.createElement("span");L.className="fsi-dialog-body-text";L.innerHTML=c("PagesSaveDialogText");y.appendChild(L);var O;var N=f.iPage1&&f.iPage1.bRealPage;var K=f.iPage2&&f.iPage2.bRealPage;if(N&&K){O={checked:"checked"}}else{O={disabled:"disabled"}}e=document.createElement("fieldset");e.appendChild(q(c("Both Pages","Both Pages"),"both",O));if(N){O=(!K)?{checked:"checked"}:b}else{O={disabled:"disabled"}}e.appendChild(q(c("Left Page","Left Page"),"left",O));if(K){O=(!N)?{checked:"checked"}:b}else{O={disabled:"disabled"}}e.appendChild(q(c("Right Page","Right Page"),"right",O));p=w.getConfigVal("savedocumentfile");if(typeof(p)==="string"&&p.length>0){e.appendChild(q(c("Entire Document","Entire Document"),"doc"))}y.appendChild(e);B.appendChild(y);var J;var I=document.createElement("span");I.className="fsi-dialog-main-button-group";J=D(c("Cancel","Cancel"),w.closeSaveDialog);I.appendChild(J);J=k=D(c("PagesSaveButton","Ok"),d);I.appendChild(J);B.appendChild(I);G.appendChild(B);var M=a.getBoundingClientRect(B);if(window.innerWidth>0&&M.width>window.innerWidth){B.style.width=window.innerWidth+"px"}B.style.left=(G.offsetWidth-B.offsetWidth)/2+"px";a.addEvent(document,"keyup",j)};this.destroy=function(){if(!n){return}a.removeEvent(document,"keyup",j);if(B&&B.parentNode){a.removeChild(B.parentNode,B)}n=false};var c=function(J,I){if(u[J]!=b){return u[J]}else{return I}};var D=function(K,J){var I=document.createElement("input");I.setAttribute("type","button");I.setAttribute("value",K);if(J!=b){a.addEvent(I,"click",J)}return I};var q=function(M,O,K){var P=document.createElement("div");P.className="fsi-dialog-option-element";var L=document.createElement("input");var J=t+"_"+o;o++;L.setAttribute("type","radio");L.setAttribute("id",J);L.setAttribute("name",t);L.setAttribute("value",O);P.FSIInput=L;if(K){for(var N in K){L.setAttribute(N,K[N])}}var I=document.createElement("label");I.setAttribute("for",J);I.innerHTML=M;P.appendChild(L);P.appendChild(I);return P};var j=function(I){switch(I.which){case 27:w.closeSaveDialog();break;case 13:d()}};var H,m;var A,i;var g=0;var s;var h=function(K,I,J){if(J.nInfoID!=g){return}if(J.bLeft){A=I}else{i=I}if(A&&i){C()}};var C=function(){var V=w.cfgInt("SaveResolution",2000);var W,L,I,J,Q;var U=w.cfgString("SaveEffects","");var K={};if(U.length>0){if(U.indexOf("?")==-1){U="?"+U}z.parseQuery(U,K)}K.save=1;if(A!==true){s.push(A)}if(i!==true){s.push(i)}if(s.length<1){return false}var N=new a.CroppedImage();if(s.length===1){for(var P=0;P<s.length;P++){var T=s[P];I=T.src;if(I!=null){var O=T.width;var S=T.height;if(V<O||V<S){Q=w.getImageDimFitInto(O,S,V,V);O=Q.width;S=Q.height}N.setSourceDimension(O,S);N.setCropFromConfig(z.cfg);if(N.isCropped()){if(i!==true&&w.bAutoFlipCrop){N.flipCropHorz()}L=N.getPixelRangeParametersByCalculatedResult(N.getPixelRangeRect())}else{L=""}if(!N.isCropped()){K.width=O}W=z.getImageURL(I,K)+L}}}else{I=s[0].src+","+s[1].src;K.renderer="doublepage";K.backgroundcolor="FFFFFF";N.setSourceDimension(s[0].width,s[0].height);N.setCropFromConfig(z.cfg);if(N.isCropped()){J=N.getFloatRect();J.right=J.width();J.bottom=J.height();K.leftimagecrop=J.toString()}var R=w.getImageDimFitInto(s[0].width,s[0].height,V,V,N);N.setSourceDimension(s[1].width,s[1].height);N.setCropFromConfig(z.cfg);if(N.isCropped()){if(w.bAutoFlipCrop){N.flipCropHorz()}J=N.getFloatRect();J.right=J.width();J.bottom=J.height();K.rightimagecrop=J.toString()}var M=w.getImageDimFitInto(s[1].width,s[1].height,V,V,N);K.width=R.width+M.width;W=z.getImageURL(I,K)}if(W){window.open(W,"_self")}};var F=function(J,K){var L=l._arImages[J];if(l.images&&l.images[J]&&l.images[J].width&&l.images[J].height){var I={src:L,width:l.images[J].width,height:l.images[J].height};h(null,I,K)}else{z.loadImageInfo(L,h,K)}};var d=function(){g++;A=i=b;H=m=b;s=[];if(f.iPage1){H=f.iPage1.nIndex}if(f.iPage2){m=f.iPage2.nIndex}var I=document.querySelector('input[name="'+t+'"]:checked').value;switch(I){case"doc":window.open(p,"_blank");break;case"left":i=true;F(H,{bLeft:true,nInfoID:g});break;case"right":A=true;F(m,{bLeft:false,nInfoID:g});break;default:F(H,{bLeft:true,nInfoID:g});F(m,{bLeft:false,nInfoID:g})}w.closeSaveDialog();return true};E()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesChapters!=b){return}a.PagesChapters=function(x,v,E){var y=this;if(typeof(E)!="object"){E={}}var l=false;var z=v.iConfig;var G=[];var I={};var A=v.getDebug();var e,f,n,d,r;var H=0;var g=false;y.bVisible=false;var B,u,k;var o=[];var p;var i;var c=true;this.init=function(){if(l){return}l=true;e=(!h("useFirstPageNumber",true,true))?0:z.firstPageNum-1;f=h("usePageNameAliases",false,true);n=h("PageNumbers",true,true);if(n){d=h("PageNumberPrefix","");r=h("PageNumberSuffix","")}var M=h("indexdata.node");var K=w(M);if(!K){var L=h("indexdatafile","");if(L.length>0){j(L)}else{D(false)}}p=parseFloat(h("width"));if(isNaN(p)){p=b}};this.destroy=function(){if(!l){return}l=false;if(B){if(i!=b){clearTimeout(i);i=b}y.show(false);a.removeEvent(B.elContainerInner,"click",C);B.destroy()}};var h=function(L,K,M){return z.getPluginParameter("chapters",L,K,M)};var j=function(O){var L;if(O.toLowerCase()=="auto"){var M=z.requestBase+"?source=";var K=v.cfgString("dir");L=M+encodeURIComponent(K)+"&type=info&tpl=chapters.xml"}else{L=z.getFSIPath(z.locationFSIViewer,"pages_xml/"+z.expandFSIPath(O))}A.log("Loading chapters data: "+L);var N={};z.finishRequestParams(N);L=z.addURLParameters(L,N);z.loadFile(L,q,"application/xml")};var q=function(N,L,M){var K=false;if(typeof(L)=="object"&&L!==null){K=w(L.firstChild)}if(!K){D(false)}};var J=function(M,N,K,L,Q){H++;var P={};P.label=M;P.page=N;P.color=K;P.downloadfile=L;P.level=Q;if(Q==0){G.push(P)}else{var O=I[Q-1];if(O!=b){if(O.items==b){O.items=[]}O.items.push(P)}}I[Q]=P};var w=function(K){if(!K||!K.firstChild){return false}var S=0;var L=K.firstChild;var O;while(L&&S>-1){if(L.nodeType===1){var R=decodeURIComponent(z.getXMLNodeAttribute(L,"label",""));var Q=z.getXMLNodeAttribute(L,"page","");var N=z.getXMLNodeAttribute(L,"color",b);var M=z.getXMLNodeAttribute(L,"file",b);if(R.length>0){J(R,Q,N,M,S)}}O=L.firstChild;if(!O){O=L.nextSibling;if(!O){O=L.parentNode.nextSibling;S--}}else{S++}L=O}var P=false;if(G.length>0){P=true;D(true)}return P};var D=function(K){if(H<1){A.error("No items for plugin chapters.")}else{A.log("Initializing chapters with "+H+" items.")}if(v.iCallbacks.isset("onShowChaptersData")){v.iCallbacks.run("onShowChaptersData",[a.utils.cloneArray(G)])}if(typeof(E.onReady)=="function"){E.onReady.apply(x,[K])}};var m=function(){if(g){return}g=true;var L=false;var K=function(X,T){if(T>0){L=true}var Y,U,W,Z,V,aa;var ab=S.cloneNode(true);a.addClass(ab,"fsi-pages-chapters-level-"+T);for(Y=0;Y<X.length;Y++){U=X[Y];W=R.cloneNode(true);U.domElement=W;W._FSIChaptersElement=U;if(U.cssClass){a.addClass(W,U.cssClass)}W.firstChild.innerHTML=U.label;Z=U.page;if(f){Z=z.getPageNumberFromString(Z)}else{Z=parseInt(Z)}U.nPage=Z;if(!isNaN(Z)){o.push(U);V=d+z.getPageNumberString(Z+e)+r}else{V=""}W.firstChild.nextSibling.innerHTML=V;ab.appendChild(W);if(U.items){aa=K(U.items,U.level+1);W=N.cloneNode(true);W.firstChild.style.paddingLeft=(T+1)*12+"px";W.firstChild.appendChild(aa);ab.appendChild(W)}}return ab};B=new a.VerticalScrollPanel();B.elContainer.style.display="none";a.addClass(B.elContainer,"fsi-pages-chapters");E.elContainer.appendChild(B.elContainer);var S=document.createElement("table");S.setAttribute("cellpadding","0");S.setAttribute("cellspacing","0");a.addClass(S,"fsi-pages-chapters");var R=document.createElement("tr");a.addClass(R,"fsi-pages-chapters-row");var O=document.createElement("td");a.addClass(O,"fsi-pages-chapters-td1");R.appendChild(O);var M=document.createElement("td");a.addClass(M,"fsi-pages-chapters-td2");R.appendChild(M);var N=document.createElement("tr");var P=document.createElement("td");P.setAttribute("colspan","2");a.addClass(P,"fsi-pages-chapters-tdt");N.appendChild(P);var Q=K(G,0);if(L){a.addClass(B.elContainer,"fsi-pages-chapters-multilevel")}u="fsi-pages-table-of-contents-"+x.getInstanceID();Q.setAttribute("id",u);B.setContent(Q);a.addEvent(B.elContainerInner,"click",C);o.sort(v.sortNumeric)};var C=function(K){var M=K.target;while(M&&M._FSIChaptersElement==b&&M.id!=u){M=M.parentNode}if(M._FSIChaptersElement){var L=M._FSIChaptersElement.nPage;if(!isNaN(L)){if(x.gotoPageNumeric(L,true)){y.show(false)}}}};this.toggle=function(){y.show(!y.bVisible)};var t=function(M){if(o.length>0){if(k){a.removeClass(k,"fsi-pages-chapters-current")}var K;for(var L=0;L<o.length;L++){if(o[L].nPage>M){K=o[Math.max(0,L-1)];break}}if(K==b){K=o[o.length-1]}var N=a.getBoundingClientRect(K.domElement);k=K.domElement;a.addClass(k,"fsi-pages-chapters-current");B.elContainerInner.scrollTop=B.elContainerInner.scrollTop+N.top-B.elContainerInner.offsetHeight/2}};var s=function(K){if(K&&K.pointerType==="touch"){return}y.show(false)};var F=function(){a.addEvent(document,"click",s);i=b};this.onResize=function(){y.show(false);c=true};this.show=function(O){if(y.bVisible==O){return}y.bVisible=O;v.iCallbacks.run("onShowChapters",[O]);m();var L=v.getMenu();if(L){L.setButtonPressed("ToggleTableOfContents",O)}if(O){B.elContainer.style.opacity=1;if(c){c=false;var N=E.elContainer.offsetWidth;if(p!=b){var K=Math.min(N,p);B.elContainer.style.width=K+"px";B.elContainer.style.left=Math.round((N-K)/2)+"px"}var M=(!L)?0:L.getHeight();var R,Q;Q=v.getRootContainer().offsetHeight-M;B.elContainerInner.style.height="";B.elContainer.style.display="";R=Math.min(Q,B.elContainerInner.offsetHeight);if(R<60){y.show(false);return}B.elContainerInner.style.height="100%";B.elContainer.style.height=R+"px";if(B.elContainerInner.clientHeight<B.elContainerInner.scrollHeight){R+=B.elContainerInner.scrollHeight-B.elContainerInner.clientHeight;R=Math.min(Q,R);B.elContainer.style.height=R+"px"}B.elContainer.style.top=(Q-R)+"px"}else{B.elContainer.style.display=""}var P=v.getCurrentPageNumberNumeric();t(P);i=setTimeout(F,50)}else{B.elContainer.style.opacity=0;if(i!=b){clearTimeout(i);i=b}a.removeEvent(document,"click",s);B.elContainer.style.display="none"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesBookmarks!=b){return}a.PagesBookmarks=function(d,m,z,g){var j=this;if(typeof(g)!="object"){g={}}var o=false;var v=m.iConfig;var r;var e=false;var J={};var y={};var E={};var n=g.bDoublePages;var O,U;var T=m.getFrontCoverIndex();var q=m.getContentID()+"_stickynotes";var Q=q+"_time";var N;var h;var M=0;var l,K;var u;var i,p;var S=function(){var X;if(o){return}o=true;u=v.getPluginParameter("bookmarks","PageNumbers",true,true);i=v.getPluginParameter("bookmarks","PersistentStorage",true,true);p=parseInt(v.getPluginParameter("bookmarks","PersistentStorageExpiresAfter"));if(isNaN(p)||p<1){p=b}h=document.createElement("div");h.className="fsi-ui-button-icon fsi-pages-remove-bookmark-icon";if(T==b){T=-1}O=0;U=z.images.length;J.images=[];J._arImages=[];var W=L();if(typeof(W)=="string"&&W.length>0){var V=W.split(",");for(X=0;X<V.length;X++){j.addPage(V[X],true)}}k()};this.destroy=function(){if(!o){return}o=false;if(r){r.destroy()}};var C=function(){return new Date().getTime()};var R=function(){var V=m.getMenu();V.enableButton("ToggleBookmarkList",M>0)};var L=function(){if(!i||window.localStorage==b){return false}if(p){var W=parseInt(localStorage.getItem(Q));if(!isNaN(W)&&((C()-W)/1000)>p){localStorage.removeItem(Q);localStorage.removeItem(q);return false}else{localStorage.setItem(Q,C())}}var V=localStorage.getItem(q);m.iCallbacks.run("onBookmarksLoaded",[V]);return V};var s=function(){var V;var W="";if(!i||window.localStorage==b){return false}if(N.length<1){localStorage.removeItem(Q);localStorage.removeItem(q)}else{if(p){localStorage.setItem(Q,C())}W=N.join(",");V=localStorage.setItem(q,W)}m.iCallbacks.run("onBookmarksSaved",[W]);return V};var A=function(W){var V=U;if(n){V=V-V%2;W=W-W%2;W=Math.max(O,Math.min(V,W))}else{W=Math.max(O,Math.min(U,W))}return W};var H=function(X){var V="";var W=J.images[X];if(W&&W.nBookmarkPageNumber!=b){V=m.getPageNumberString(W.nBookmarkPageNumber)}return V};this.toggleBookmark=function(X){var W=false;if(j.addPage(X)){m.iCallbacks.run("onBookmarkAdded",[X]);W=true}else{var V=j.removePage(X);if(V){m.iCallbacks.run("onBookmarkRemoved",[X])}}return W};this.isPageBookmarked=function(V){return y[V]};this.removePage=function(W,X){var V=false;W=A(W);if(y[W]){V=true;if(n){t(W+1)}t(W);if(!X){k();s()}}return V};var t=function(W){var V=E[W];if(V==b){return}y[W]=b;delete y[W];E[W]=b;delete y[W];delete J.images[V].srcBookmark;J.images.splice(V,1);m.showBookmarkIconOnPage(W,false)};this.addPage=function(X,Y){if(isNaN(X)){return false}var W;var V=false;X=A(X);if(!y[X]){W=z.images[X];if(W!=b){V=true;D(X,W);if(n){W=z.images[X+1];if(W!=b){D(X+1,W)}}if(!Y){k();s()}}}return V};var D=function(W,V){y[W]=true;V.nBookmarkPageNumber=W;V.srcBookmark=z._arImages[W];J.images.push(V);J._arImages.push(z._arImages[W]);m.showBookmarkIconOnPage(W,true)};var f=function(W,V){return W.nBookmarkPageNumber-V.nBookmarkPageNumber};var k=function(){J.images.sort(f);M=J.images.length;N=new Array(M);J._arImages=new Array(M);E={};var Y=J.images;var W=J._arImages;for(var V=0;V<Y.length;V++){var X=Y[V].nBookmarkPageNumber;E[X]=V;N[V]=X;W[V]=Y[V].srcBookmark}R();m.updateAddBookmarkButton()};this.getVisible=function(){return e};var P=function(X,V){if(V.target&&a.hasClass(V.target,"fsi-pages-remove-bookmark-icon")){x(V);return}var W=J.images[X.nIndex];if(W!=b){m.gotoPageByIndex(W.nBookmarkPageNumber,true)}};var x=function(V){var X=r.getPageInstanceFromChildElement(V.target);if(X&&X.oImage.nBookmarkPageNumber){var W=j.removePage(X.oImage.nBookmarkPageNumber);if(W){m.iCallbacks.run("onBookmarkRemoved",[X.oImage.nBookmarkPageNumber])}if(M>0){G(X.oContainer);r.removeContainerFromLayout(X.oContainer)}else{m.hideBookmarks()}}};var G=function(V){if(V){if(V.iPage1){w(V.iPage1)}if(V.iPage2){w(V.iPage2)}}};var w=function(V){if(V&&V.elRemoveBookmark){a.removeEvent(V.elRemoveBookmark,"mouseenter",I);a.removeEvent(V.elRemoveBookmark,"mouseleave",c)}};var I=function(V){m.getToolTip().show("RemoveThisBookmark",V.target)};var c=function(V){m.getToolTip().hide()};var B=function(){if(M<1){return}m.iCallbacks.run("onRemoveAllBookmarks");for(var V=0;V<N.length;V++){m.showBookmarkIconOnPage(N[V],false)}J.images=[];J._arImages=[];y={};E={};M=0;N=[];s();m.hideBookmarks()};this.show=function(V){if(V==e){return}e=V;m.iCallbacks.run("onShowBookmarkList",[V]);if(V){var W={};W.initialPageIndex=1;W.imageOptions={};if(m.cfgString("effects")!=b){W.imageOptions.effects=m.cfgString("effects")}W.elContainer=m.pageIndexContainer;W.pageOptions={bInteractive:false,bImageOnly:true,bGroupDoublePages:n,bPageNumbers:u};W.nScrollAnimationFrames=12;W.nCreateAhead=0.2;W.bScrollToCurrentTopPageAfterResize=true;W.name="Bookmarks";W.nConcurrentImageLoad=24;W.onPageClick=P;W.strContainerClass="fsi-pages-bookmarks fsi-pages-scrollbar";W.bCenterContent=true;var X=parseInt(v.getPluginParameter("bookmarks","ThumbSize"));if(isNaN(X)||X<20){X=200}W.thumbWidth=W.thumbHeight=X;a.addClass(m.pageIndexContainer,"fsi-pages-bookmarks");r=new a.PageLayoutGrid(d,m,J,v,W);r.getCustomPageLayoutData=F;r.onFinishPage=function(Y,Z){if(n){if(!Y.bOddPage&&Y.iSiblingPage&&Y.iSiblingPage.bRealPage){return}}Y.elRemoveBookmark=h.cloneNode(false);Z.appendChild(Y.elRemoveBookmark);a.addEvent(Y.elRemoveBookmark,"mouseenter",I);a.addEvent(Y.elRemoveBookmark,"mouseleave",c)};r.getPageNumberString=H;r.init();K=document.createElement("div");K.className="fsi-pages-remove-all-bookmarks-container";l=document.createElement("span");l.className="fsi-pages-remove-all-bookmarks";l.innerHTML=m.getLanguageString("RemoveAllBookmarks","Remove all bookmarks");K.appendChild(l);m.pageIndexContainer.appendChild(K);a.addEvent(l,"click",B)}else{c();R();m.updateAddBookmarkButton();a.removeEvent(l,"click",B);a.removeClass(m.pageIndexContainer,"fsi-pages-bookmarks");m.pageIndexContainer.removeChild(K);r.destroy()}};var F=function(V){if(J.images.length>0){V.nMinPage=1;V.nMaxPage=J.images.length;V.nImages=J.images.length}else{V.nMinPage=1;V.nMaxPage=1;V.nImages=0}};S()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PagesConfig!=b){return}a.PagesConfig=function(d,h,g,f,e){a.Config.prototype.constructor.call(this,g,f,e);var c=this;this.getPagesParameter=function(j,i,k){return c.getPluginParameter("pages",j,i,k)};this.getUnescapedParameter=function(l,k,j){var i=h.cfgString(l,k);if(i==b&&j!=b){i=h.cfgString(j,k)}if(i!=b){i=a.utils.urlDecode(i)}return i};this.initPagesParameters=function(){var j;if(!c.hasPlugin("pages")){return}c.LinkTemplates=h.cfgString("LinkTemplates","").split(",");for(j=0;j<c.LinkTemplates.length;j++){c.LinkTemplates[j]=decodeURIComponent(c.LinkTemplates[j])}c.LinkTemplateData=h.cfgString("LinkTemplateData","").split(",");for(j=0;j<c.LinkTemplateData.length;j++){c.LinkTemplateData[j]=decodeURIComponent(c.LinkTemplateData[j])}c.LinkTemplateCount=Math.max(c.LinkTemplates.length,c.LinkTemplateData.length);c.ParamForceLinkTarget=c.getUnescapedParameter("ForceLinkTarget",b,"LinkTarget");c.ParamForceJavascriptTarget=c.getUnescapedParameter("ForceJavascriptTarget",b);c.ParamForceLinkURLPrefix=c.getUnescapedParameter("ForceLinkUrlPrefix",b,"UrlPrefix");c.ParamForceLinkURLSuffix=c.getUnescapedParameter("ForceLinkUrlSuffix",b,"UrlSuffix");c.ParamForceLinkURL=c.getUnescapedParameter("ForceLinkUrl",b);c.ParamForceLinkTip=c.getUnescapedParameter("ForceLinkTip",b);c.ParamDefaultLinkTarget=c.getUnescapedParameter("DefaultLinkTarget",b);c.ParamDefaultJavascriptTarget=c.getUnescapedParameter("DefaultJavascriptTarget","_self");c.ParamDefaultLinkURLPrefix=c.getUnescapedParameter("DefaultLinkUrlPrefix",b);c.ParamDefaultLinkURLSuffix=c.getUnescapedParameter("DefaultLinkUrlSuffix",b);c.ParamDefaultLinkURL=c.getUnescapedParameter("DefaultLinkUrl",b);c.ParamDefaultLinkTip=c.getUnescapedParameter("DefaultLinkTip",b);c.bFollowLinks=h.cfgBool("FollowLinks",true);c.bRTL=h.cfgBool("PageOrderRTL",false);c.bUseNamedPageNumbersExternal=h.cfgBool("externalPageNumbersAreAliases",false);c.firstPageNum=c.getIntParameter("firstPageNumber",1);if(!h.cfgBool("frontcover",true)){c.firstPageNum++}c.nMaxRomanPageNumber=h.cfgInt("UseRomanPageNumbersToPage",0);if(isNaN(c.nMaxRomanPageNumber)){c.nMaxRomanPageNumber=0}c.nRomanPageNumberOffset=h.cfgInt("RomanPageNumbersOffset",0);if(isNaN(c.nRomanPageNumberOffset)){c.nRomanPageNumberOffset=0}};this.getSuperseedingParam=function(l,k,j,i){if(l!=b&&l.length>0){return l}if(k!=b&&k.length>0){return k}if(j!=b&&j.length>0){return j}return i};this.getAbsoluteURL=function(j,k,l){if(j==b){return""}if(k==b){k=""}if(l==b){l=""}if(j.indexOf(":")!=-1){var m=j.indexOf("://");if((m!=-1&&m<7)||j.indexOf("javascript:")==0||j.indexOf("mailto:")==0){return j}}if(j.charAt(0)=="#"){var i=j.toLowerCase();if(i.indexOf("#page=")==0){return j}if(i.indexOf("#zoomonpage=")==0){return j}if(i.indexOf("#zoom")==0){return j}if(i.indexOf("#zoomarea")==0){return j}if(i.indexOf("#showimage")==0){return j}if(i.indexOf("#none")==0){return""}}return k+j+l};this.getHotSpotUrl=function(m,o){var l=o;var k=m.oLinkAttributes;var n=c.getSuperseedingParam(c.ParamForceLinkURL,l.url,k.DefaultURL,c.ParamDefaultLinkURL);var i=c.getSuperseedingParam(c.ParamForceLinkURLPrefix,b,k.UrlPrefix,c.ParamDefaultLinkURLPrefix);var j=c.getSuperseedingParam(c.ParamForceLinkURLSuffix,b,k.UrlSuffix,c.ParamDefaultLinkURLSuffix);return c.getAbsoluteURL(n,i,j)};this.getHotSpotTarget=function(m,o,n){var k;var l=o;var j=m.oLinkAttributes;var i=n.toLowerCase();if(i.indexOf("mailto:")==0){k=c.getSuperseedingParam(b,l.target,"_self","_self")}else{if(i.indexOf("javascript:")==0){k=c.getSuperseedingParam(c.ParamForceJavascriptTarget,l.target,j.URLTargetJavascript,c.ParamDefaultJavascriptTarget)}else{k=c.getSuperseedingParam(c.ParamForceLinkTarget,l.target,j.DefaultTarget,c.ParamDefaultLinkTarget)}}if(k==b){k="_self"}return k};this.Replace_CurrentPage=function(k,j){var i=c.strReplace(k,"_FSI_CURRENTPAGE_",j);i=c.strReplace(i,"_FSI_CURRENTDOUBLEPAGE_",1+Math.floor(j/2));return i};this.strReplace=function(k,j,i){if(k==b||k.length<1||k.indexOf(j)==-1){return k}return k.split(j).join(i)};this.ReplaceLinkTemplates=function(k){if(c.LinkTemplateCount<0){return k}for(var j=0;j<c.LinkTemplateCount;j++){k=c.replaceLinkTemplate(k,j)}return k};this.replaceLinkTemplate=function(m,k){var j=c.LinkTemplates[k];var l;switch(j){case"_FSI_CURRENTPAGE_":case"_FSI_CURRENTDOUBLEPAGE_":return c.Replace_CurrentPage(m,h.getCurrentPageNumberNumeric());break;default:l=c.LinkTemplateData[k]}c.debug.log("REPLACE: ["+j+"] with ["+l+"]");return c.strReplace(m,j,l)};this.readCustomPageNumbers=function(){var j=h.cfgString("CustomPageNumbersFile","");if(j.length>1){var i=c.getFSIPath(c.locationFSIViewer,j);if(i!=j){i=c.getFSIPath(c.locationFSIViewer,"pages_xml/"+j)}var l={};c.finishRequestParams(l);if(i.indexOf(".xml")==-1){i+=".xml"}c.loadFile(i,c.onCustomPageNumbersLoaded,"application/xml")}else{var k=h.cfgString("CustomPageNumbers","");if(k.length>0){c.parseCustomPageNumbers(k)}h.onCustomPageNumbersDone()}};c.onCustomPageNumbersLoaded=function(j,l){var m=(typeof(l)=="object"&&l!=null);if(m){var k=c.findXMLNode(l,"pagenumbers");var i=c.getValueFromXMLNode(k);if(i.value){i=i.value}else{i=""}c.parseCustomPageNumbers(i);c.debug.log("External page numbers loaded, "+c.pageNumberArrayString.length+" entries found.")}else{c.debug.error("Loading external page numbers failed.")}h.onCustomPageNumbersDone()};c.parseCustomPageNumbers=function(l){if(l.length<1){return}c.pageNumberArrayString=l.split(",");c.pageNumberArrayNum={};for(var k=0;k<c.pageNumberArrayString.length;k++){var j=c.pageNumberArrayString[k];if(c.pageNumberArrayNum[j]==b){c.pageNumberArrayNum[j]=k}}c.bUseNamedPageNumbersExternal=h.cfgBool("externalPageNumbersAreAliases",false)};this.getPageNumberString=function(k){var j;if(c.pageNumberArrayString!=b){j=c.pageNumberArrayString[k-1];if(j!=b){if(j.indexOf("_")==0){j="---"}return j}}k=c.getPageNumber(k);j=k-c.nMaxRomanPageNumber;if(j>0){return String(k)}var i=c.firstPageNum;return c.int2roman(-(i-c.nMaxRomanPageNumber-j)+1+c.nRomanPageNumberOffset)};this.getPageNumber=function(i){return(c.bRTL)?c.firstPageNum+c.maxpage-i:c.firstPageNum-1+i};this.getPageIndex=function(i){return(c.bRTL)?-i+c.firstPageNum+c.maxpage:i-c.firstPageNum+1};this.getPageNumberFromString=function(k){var j;if(c.pageNumberArrayNum!=b){j=c.pageNumberArrayNum[k];if(j!=b){return j+c.firstPageNum}}j=parseInt(k);if(isNaN(j)){var i=c.firstPageNum;if(k=="---"){return i}j=c.roman2int(k)-c.nMaxRomanPageNumber-c.nRomanPageNumberOffset;if(j-1<=-i){j=j+i-1+c.nMaxRomanPageNumber}else{j=j+c.nMaxRomanPageNumber+i-1}}return j};this.int2roman=function(i){var j="";if(i<=0||isNaN(i)){return"---"}while(i/5000>=1){j+="A";i-=5000}while(i/1000>=1){j+="M";i-=1000}if(i/900>=1){j+="CM";i-=900}if(i/500>=1){j+="D";i-=500}if(i/400>=1){j+="CD";i-=400}while(i/100>=1){j+="C";i-=100}if(i/90>=1){j+="XC";i-=90}if(i/50>=1){j+="L";i-=50}if(i/40>=1){j+="XL";i-=40}while(i/10>=1){j+="X";i-=10}if(i/9>=1){j+="IX";i-=9}if(i/5>=1){j+="V";i-=5}if(i/4>=1){j+="IV";i-=4}while(i>=1){j+="I";i-=1}return j};this.oRomanToIntMap={I:1,V:5,X:10,L:50,C:100,D:500,M:1000,A:5000};this.roman2int=function(j){if(!j||typeof(j)!="string"){return 0}j=j.toUpperCase();var l=0;for(var m=j.length-1;m>-1;m--){var k=c.oRomanToIntMap[j.charAt(m)];var n=c.oRomanToIntMap[j.charAt(m-1)];l+=k;while(m>0&&n!=b&&n<k){l-=n;m--;n=c.oRomanToIntMap[j.charAt(m-1)]}}return l}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageLayout!=b){return}a.PageLayout=function(c,q,T,z,f){var k=this;k._strClassName="PageLayout";q.registerLayout(k);f=k.oOptions=(typeof(f)=="object")?f:{};if(f.name==b){k.name=k._strClassName+"_"+this.nLayoutID}else{k.name=f.name}var C=k.debug=q.getDebug();k.elemSpace={};k.elContainer={};k.pageContainer={};var S={};k.oPageDef={};k.arPages=[];k.oPageOptions={};k.bGroupDoublePages=(f.pageOptions.bGroupDoublePages!==false);k.elDoublePageContainer=false;k.oPageDefs={};var j={};var H={};var Q=q.oCropCacheSource;var V;var D;var t=false;var s={};var O,I;var J=k.oVisibleRange={start:-10000,end:-10000,nVisible:0};this.arContainers=[];this.bVisible=k.bLayoutVisible=true;this.bFlipping=false;k.nContainerLoadedWidth=0;k.nContainerLoadedScale=k.nDocumentScale=k.nDocumentScalePixelRatio=1;k.bZoomed=false;var r=k.oZoomAnimation={scale:1};var e;var L=26;var l=(a.mobileOS=="ios"&&(a.osVersion.length>0&&a.osVersion[0]<6));var x=a.Easing.easeOutCubic;var i=new a.CSSTransformMatrix();this.dimImage={};this.dimContainer={};k.bVertical=(f.bHorizontal!==true);k.strLayoutClass="fsi-pages_layout-"+this.nLayoutID;var m=q.getBaseCSSSelector()+" div.fsi-pages-page-layout."+k.strLayoutClass;k.bDefinesPageSizeByCSS=true;k.nFakePagesStart=q.getFakePagesStart();var p=k.bAutoPageSize=(f.thumbWidth=="auto");var K={};var d=4;var o=(a.isMobileDevice)?350:100;var U=(a.isMobileDevice)?50:10;var F=(a.mobileOS=="ios");k.bLoadContentWhileScrolling=!F;var A=0;k.strPageContainerClass="fsi-pages-scroll";var w,v,h;k.bOnePageInView=f.bOnePageInView;k.nShowNeighbourPages=0;k.nOuterMargin=0;this.getClassName=function(){return k._strClassName};this.init=function(){if(!T||!T.images||T.images.length<1){return}if(!k.bFlipLayout){if(f.ScrollItemMinimumSpacing>0){k.nOuterMargin=f.ScrollItemMinimumSpacing}if(f.ShowNeighbourPages>0){k.nShowNeighbourPages=f.ShowNeighbourPages}w=((k.bOnePageInView==true&&k.bVertical==false)||(k.bVertical==true&&f.bSingleColumn==true));v=(k.bOnePageInView==true&&k.bVertical==true);h=(k.nOuterMargin!=0||w||v)}k.nFrontCoverContainerIndex=k.getContainerIndexFromPage(q.getFrontCoverIndex());k.nBackCoverContainerIndex=k.getContainerIndexFromPage(q.getBackCoverIndex());k.nDocumentScale=q.roundDocumentScale(q.nDocumentScale);k.nContainerLoadedScale=k.nDocumentScalePixelRatio=q.roundDocumentScale(q.nDocumentScalePixelRatio);k.elemSpace=a.getElementDimension(k.elContainer);if(f.nConcurrentImageLoad){d=f.nConcurrentImageLoad}if(a.isMobileDevice){d=Math.max(1,Math.ceil(d/3))}var X=T.images[0];k.bFakePageOnStart=(X&&X.src==b&&X.type==b);X=T.images[T.images.length-1];k.bFakePageOnEnd=(X&&X.src==b&&X.type==b);if(k.getCustomPageLayoutData!=b){k.getCustomPageLayoutData(j)}else{j.nMinPage=k.nFakePagesStart;j.nMaxPage=q.getRealPages()-1+j.nMinPage;j.nImages=q.getRealPages()}k.nMinPage=j.nMinPage;k.nMaxPage=j.nMaxPage;j.bDoublePages=k.bGroupDoublePages;if(f.bMainLayout&&q.iCallbacks.isset("onPageLayoutChanged")){q.iCallbacks.run("onPageLayoutChanged",[k.getPageLayoutData()])}k.bHasSingleLastPage=(!k.bGroupDoublePages||(k.nMaxPage+k.nFakePagesStart)%2!=0);k.arPages=new Array(T.images.length);if(k.bGroupDoublePages){k.nContainers=Math.ceil((T._arImages.length-1)/2)}else{k.nContainers=Math.ceil(T._arImages.length)}k.setLayoutContainers();k.arContainers=new Array(k.nContainers);k.nMinPageIndex=0;k.nMaxPageIndex=T.images.length-1;N();W();k.elDoublePageContainer=document.createElement("div");k.elDoublePageContainer.setAttribute("class","fsi-pages-page-container fsi-pages-page-border");k.oPageDef.iConfig=z;if(typeof(f.imageOptions)==="object"){k.oPageDef.imageOptions=f.imageOptions}else{k.oPageDef.imageOptions={}}k.oImageOptionsUncropped=a.utils.cloneObject(k.oPageDef.imageOptions);k.oImageOptionsCropped=a.utils.cloneObject(k.oPageDef.imageOptions);k.oImageOptionsCropped.width=k.oImageOptionsCropped.height=null;if(f.pageOptions){k.oPageOptions=f.pageOptions}else{k.oPageOptions={bInteractive:false,bImageOnly:true}}k.oPageDef.hasLinks=k.bHasLinks=(!f.pageOptions.bImageOnly&&f.pageOptions.bInteractive);k.oPageOptions.bBendEffect=(!f.bNoBendEffect&&q.cfgString("BendEffect","glossy").toLowerCase()!="none");k.elPageNumberTemplate=document.createElement("div");k.elPageNumberTemplate.setAttribute("style","position:absolute;z-index:10");a.addClass(k.elPageNumberTemplate,"fsi-page-number");if(f.elContainer==b){C.error("oOptions.elContainer missing for "+k._strClassName)}k.elContainer=f.elContainer;k.pageContainer=document.createElement("div");a.addClass(k.pageContainer,"fsi-pages-page-layout "+k.strLayoutClass);k.pageContainer.style.visibility="hidden";if(typeof(f.strContainerClass)=="string"){k.bHasScrollBar=(f.strContainerClass.indexOf("fsi-pages-scrollbar")!=-1);a.addClass(k.pageContainer,f.strContainerClass)}else{k.bHasScrollBar=false}a.addClass(k.pageContainer,k.strPageContainerClass);if(f.enableZoom){a.addClass(k.pageContainer,"fsi-pages-zoom")}k.elContainer.appendChild(k.pageContainer);P();k.initLayout();if(k.onAfterInit){k.onAfterInit()}if(k.centerContent){k.centerContent()}if(f.bOneClickZoom){a.addClass(k.pageContainerInner,"fsi-pages-one-click-zoom")}u()};this.setLayoutContainers=function(){k.nLayoutContainers=k.nContainers};this.destroy=function(){q.unregisterLayout(k);k.stopLoading();for(var Y=0;Y<k.arContainers.length;Y++){var X=k.arContainers[Y];if(X){X.destroy()}}if(k.pageContainer.parentNode){a.removeChild(k.pageContainer.parentNode,k.pageContainer)}a.utils.deleteInstanceCSSRules(k)};this.getPageNumberString=function(X){return q.getPageNumberString(X)};this.getPageLayoutData=function(){return a.utils.cloneObject(j)};this.showBookmarkIconOnPage=function(Z,X,Y){var aa=k.arPages[Z];if(aa==b){return}if(X==aa.bBookmarkIconVisible||!aa.bRealPage){return}aa.bBookmarkIconVisible=X;var ab=aa.getContainer();if(X){if(!aa.elBookMark){aa.elBookMark=Y.cloneNode(true);if(aa.bOddPage){a.addClass(aa.elBookMark,"fsi-pages-bookmark-icon-odd")}else{a.addClass(aa.elBookMark,"fsi-pages-bookmark-icon-even")}}ab.appendChild(aa.elBookMark);a.addClass(aa.oContainer.elContainer,"fsi-pages-bookmarked")}else{ab.removeChild(aa.elBookMark);a.removeClass(aa.oContainer.elContainer,"fsi-pages-bookmarked")}};this.removeContainerFromLayout=function(Y){k.resetLoadContent();k.removeAllContainers();if(Y.bCloned){Y.unCloneDomElements()}if(Y.iPage1){k.removePageFromLayout(Y.iPage1)}if(Y.iPage2){k.removePageFromLayout(Y.iPage2)}k.arContainers.splice(Y.nIndex,1);k.nContainers--;k.setLayoutContainers();for(var X=Y.nIndex;X<k.nContainers;X++){if(k.arContainers[X]){k.arContainers[X].nIndex--}}Y.destroy();k.updateVisiblePageRange(true);k.updateContainerDim()};this.removePageFromLayout=function(Z){var X=k.arPages.length;k.arPages.splice(Z.nIndex,1);Z.destroy();for(var Y=Z.nIndex;Y<X;Y++){if(k.arPages[Y]){k.arPages[Y].nIndex--}}j.nMaxPage=k.nMaxPage=k.nMaxPage-1};this.getShowState=function(){var X={};X.bVisible=k.bVisible;X.bLayoutVisible=k.bLayoutVisible;X.nLockShow=A;return X};this.restoreShowState=function(X){if(X.bLayoutVisible){k.show()}else{k.hide()}k.bVisible=X.bVisible;A=X.nLockShow};this.unlockShow=function(X){A--;if(A==0){k.bLayoutVisible=true;if(k.bVisible){k.bVisible=false;k.show()}}};this.lockShow=function(X){if(A==0){k.bLayoutVisible=false;k.hide(true)}A++};this.hide=function(X){if(!k.bVisible){return false}k.cancelScrolling(false);if(!X){k.bVisible=false}k.bLayoutVisible=false;k.pageContainer.style.display="none";if(f.onShowHide){f.onShowHide()}return true};this.show=function(){if(A||k.bVisible){return false}k.bLayoutVisible=true;k.bVisible=true;k.pageContainer.style.display="block";if(k.resizeOnShow){P({FSI_after_treshold:true})}if(f.onShowHide){f.onShowHide()}return true};var N=function(){V=document.createElement("img");V.setAttribute("draggable","false")};this.initLayout=function(){};this.onActivateLink=function(Y,X,Z){g();K.bActive=true;K.iPage=Y;K.iLinks=X;K.oArea=Z};var g=k.disableActiveLink=function(){if(!K.oArea){return}K.iLinks.setLinkNormal(K.oArea)};this.getPage=function(X){if(k.arPages[X]==b){return k.createPage(X)}return k.arPages[X]};this.createPage=function(Z){var aa,Y;k.oPageOptions.bOddPage=(Z%2);var X=(k.oPageDefs[Z]!=b)?k.oPageDefs[Z]:k.oPageDef;Y=T.images[Z];if(Y){Y.fullImagePath=T._arImages[Z]}if(!Y||Y.src==b){k.oPageOptions.bRealPage=(Y&&Y.type!=b)}else{k.oPageOptions.bRealPage=true}aa=k.arPages[Z]=new a.Page(c,q,k,Z,X,Y,k.oPageOptions);return aa};this.getContainerForPage=function(X){if(k.arPages[X]&&k.arPages[X].oContainer){return k.arPages[X].oContainer}return k.createPageContainerForPage(X)};this.createPageContainerForPage=function(aa){var Z;var ac;var ae;var Y,X;var ad=k.getPage(aa);if(k.bGroupDoublePages){ac=k.elDoublePageContainer.cloneNode();var ab;if(ad.bOddPage){ab=aa-1;ae=Math.floor(aa/2)}else{ab=aa+1;ae=Math.floor(ab/2)}X=k.getPage(ab);if(ad.bOddPage){Y=X;X=ad}else{Y=ad}Y.iSiblingPage=X;Y.attachTo(ac);k.onAfterPageAdd(Y);Y.setOuterContainer(ac);if(X){X.iSiblingPage=Y;X.attachTo(ac);k.onAfterPageAdd(X);X.setOuterContainer(ac)}if(!Y.bRealPage||!X.bRealPage){a.removeClass(ac,"fsi-pages-page-border");if(Y.bRealPage){a.addClass(Y.getContainer(),"fsi-pages-page-border")}else{a.addClass(X.getContainer(),"fsi-pages-page-border")}}}else{ae=aa;Y=ad;ad.init();k.onAfterPageAdd(ad);ac=ad.getContainer();a.addClass(ac,"fsi-pages-page-container fsi-pages-page-border");ad.setOuterContainer(ac)}Z=new a.PageContainer(c,q,k,ac,ae,Y,X);k.arContainers[ae]=Z;return Z};k.onAfterPageAdd=function(X){};k.getCurrentContainerIndex=function(Z){var X;var Y=k.getCurrentPage(Z);if(k.bGroupDoublePages){X=Math.floor(Y/2)}else{X=Y}return X};k.getContainerIndexFromPage=function(X){return(k.bGroupDoublePages)?Math.floor(X/2):X};k.getPageIndexFromContainerIndex=function(X){return(k.bGroupDoublePages)?2*X:X};k.getCurrentContainer=function(X){return k.arContainers[k.getCurrentContainerIndex(X)]};this.gotoPage=function(X){X=Math.max(k.minPage,k.maxPage);if(k.nCurrentPage==X){return false}k.nCurrentPage=X;if(k.onAfterGotoPageResize){k.onAfterGotoPage(X)}return true};this.onStartDocumentZoom=function(X){};this.onAfterDocumentZoom=function(X){u(X.FSI_scale)};var u=function(Y){if(!q.bIsIOS){return}if(Y==b){Y=a.utils.getDocumentScale()}var X=(Y>1.1);if(X!=k.biOSScaled){k.biOSScaled=X;if(X){a.addClass(k.pageContainerInner,"fsi-pages-layout-ios-zoomed")}else{a.removeClass(k.pageContainerInner,"fsi-pages-layout-ios-zoomed")}}};this.getImageNode=function(){return V.cloneNode()};this.resetCropCache=function(){H={}};this.getPageImageURL=function(ab,ad){var Z=Math.round(k.nDocumentScalePixelRatio*k.dimImage.width);var X=Math.round(k.nDocumentScalePixelRatio*k.dimImage.height);var ac=(!q.iLinkEditor);var Y;if(typeof(ab)!=="object"||typeof(ab.fullImagePath)!=="string"){return false}var aa=ab.width+"_"+ab.height;if(q.bAutoFlipCrop){aa+="_"+ad}if(H[aa]!=b){Y=H[aa]}else{Y={};if(Q[aa]==b){Q[aa]=Y.oCroppedImageSource=new a.CroppedImage();Y.oCroppedImageSource.setSourceDimension(ab.width,ab.height);if(ac){Y.oCroppedImageSource.setCropFromConfig(z.cfg)}}else{Y.oCroppedImageSource=Q[aa]}if(ac){Y.oCroppedImage=Y.oCroppedImageSource.getCropToFill(Z,X,"cc",true)}else{Y.oCroppedImage=Y.oCroppedImageSource}if(Y.oCroppedImage.isCropped()){if(q.bAutoFlipCrop&&ad){Y.oCroppedImage.flipCropHorz()}Y.oImageOptions=k.oImageOptionsCropped;Y.strCrop=Y.oCroppedImage.getPixelRangeParameters()}else{Y.strCrop="";Y.oImageOptions=k.oImageOptionsUncropped;Y.oImageOptions.width=Math.floor(Z)}H[aa]=Y}return Y};var G=function(Z,Y){var X=parseFloat(Z);if(isNaN(X)){X=Y}return X};this.parseViewString=function(Y){if(typeof(Y)!="string"){return[1,1,0,0,1,1,0]}var X=Y.split(",");X[0]=G(X[0],1);X[1]=G(X[1],1);X[2]=G(X[2],0);X[3]=G(X[3],0);X[4]=G(X[4],1);X[5]=G(X[5],1);X[6]=G(X[6],0);return X};var W=function(){D=q.getPageAspectRatio()};this.getMaxPageDimForContainer=function(Y){if(Y==b){Y={width:0,height:0}}var X=k.getCurrentContainer();if(X){if(X.iPage1&&X.iPage1.oImage&&X.iPage1.oImage.width){Y.width=Math.floor(Math.max(Y.width,X.iPage1.oImage.width));Y.height=Math.floor(Math.max(Y.height,X.iPage1.oImage.height))}else{if(X.iPage2&&X.iPage2.oImage&&X.iPage2.oImage.width){Y.width=Math.floor(Math.max(Y.width,X.iPage2.oImage.width));Y.height=Math.floor(Math.max(Y.height,X.iPage2.oImage.height))}}}return Y};this.getAutoDoublePageMode=function(){var Z=k.getMaxPageDim(1);Z.width=Math.max(0,Z.width);Z.height=Math.max(0,Z.height);var ac=k.getMaxPageDim(2);ac.width=Math.max(0,ac.width);ac.height=Math.max(0,ac.height);var ab=q.getImageDimFitInto(D.width,D.height,Z.width,Z.height);var Y=q.getImageDimFitInto(D.width,D.height,ac.width,ac.height);var aa=(1.5*Y.width+Y.height);var X=ab.width+ab.height;return(aa>=X)};this.calcPageDim=function(){var Y=false;var X;X=k.getMaxPageDim();if(k.bZoomed){X=k.getMaxPageDimForContainer(X);X.width=Math.round(f.fMaxZoom*X.width);X.height=Math.round(f.fMaxZoom*X.height)}if(X.width<1||X.height<1){C.error("Insufficient element dimension");X.width=X.height=10}if(D.width==b||D.height==b){C.error("Missing image dimension.")}else{Y=q.getImageDimFitInto(D.width,D.height,X.width,X.height,b,k.bZoomed)}return Y};k.updateImagesOfVisiblePages=function(){k.dimImageScaledWidth=Math.ceil(k.nDocumentScalePixelRatio*k.dimImage.width);if(k.nContainerLoadedScale==k.nDocumentScalePixelRatio){if(!p||k.nContainerLoadedWidth==k.dimImageScaledWidth){return}}k.resetLoadContent();k.startLoadingContent(J.start,J.end)};this.resetLoadContent=function(){k.stopLoading();s.start=s.end=b};this.stopLoading=function(){if(!k.bLoadingContent){return}k.bLoadingContent=false;if(O==b&&I==b){return}if(I){clearTimeout(I);I=b}if(O){clearInterval(O);O=b}};var n=this.loadContainerContent=function(Y){var X=false;if(!Y.bContentLoaded){Y.bContentLoaded=true;Y.contentImageWidth=k.dimImageScaledWidth;if(Y.iPage1){Y.iPage1.initContent()}if(Y.iPage2){Y.iPage2.initContent()}X=true}else{if(Y.contentImageWidth!=k.dimImageScaledWidth){Y.contentImageWidth=k.dimImageScaledWidth;if(Y.iPage1){Y.iPage1.updateImage()}if(Y.iPage2){Y.iPage2.updateImage()}X=true}}return X};var E=function(){if(k.bFlipping&&!k.bLoadContentWhileScrolling){return}var aa=d;if(k.bFlipping&&a.isMobileDevice){aa=Math.ceil(aa/2)}var Z=Math.min(s.end,s.start+100);for(var Y=s.start;Y<=Z;Y++){var X=n(k.arContainers[k.oLoadIndex[Y]]);if(X&&--aa==0){break}}s.start=Y+1;if(s.start>s.end){k.stopLoading()}};this.startLoadingContent=function(X,Y){k.nContainerLoadedWidth=k.dimImageScaledWidth;k.nContainerLoadedScale=k.nDocumentScalePixelRatio;s.start=X;s.end=Y;if(I){clearTimeout(I)}I=setTimeout(y,U)};var y=function(){I=b;s.current=s.start+Math.round((s.end-s.start)/2);var ab=k.oLoadIndex={};var aa=s.current;var Z=aa-1;var Y=aa+1;ab[s.start]=aa;var ac=s.start+1;for(var X=s.start+1;X<=s.end+1;X++){if(X%2==0&&Z>=s.start){ab[ac]=Z;Z--;ac++}else{if(Y<=s.end){ab[ac]=Y;Y++;ac++}}}k.stopLoading();k.bLoadingContent=true;E();if(k.bLoadingContent){O=setInterval(E,o)}};this.getTargetPage=function(Y){var X=k.nMaxPage;if(k.bGroupDoublePages){X=X-X%2;Y=Y-Y%2;Y=Math.max(k.nMinPage,Math.min(X,Y))}else{Y=Math.max(k.nMinPage,Math.min(k.nMaxPage,Y))}return Y};this.updatePageSize=function(ai){if(!k.bLayoutVisible){return}k.dimImage=k.calcPageDim();k.dimImage.width=Math.floor(k.dimImage.width);k.dimImage.height=Math.floor(k.dimImage.height);a.utils.deleteInstanceCSSRules(k);var aa="width:"+k.dimImage.width+"px;height:"+k.dimImage.height+"px;";a.utils.addInstanceCSSRule(k,m+" div.fsi-pages-page",aa);var ab=false;if(k.dimContainer.width!=b&&k.containerMargins.left!=b){aa="";var af,Z,ae,X,ac,ag;var ah=false;var ad=function(){Z=c.getPageContainerDim();k.updateContainerDim();af={left:k.containerMarginsInitial.left,top:k.containerMarginsInitial.top,right:k.containerMarginsInitial.right,bottom:k.containerMarginsInitial.bottom};if(ah){return}ah=true};if(!k.bZoomed&&h){ad();if(v){ae=Math.abs(af.top-af.bottom);X=af.top+af.bottom;ac=Math.ceil((Z.height-k.dimContainer.height)-2*X)+ae-2*k.nShowNeighbourPages;af.top+=ac/4;af.bottom+=ac/4}if(w){ae=Math.abs(af.left-af.right);X=af.left+af.right;ac=Math.ceil((Z.width-k.dimContainer.width)-2*X)+ae-2*k.nShowNeighbourPages;af.left+=ac/4;af.right+=ac/4}if(k.nOuterMargin>0){if(k.bVertical){X=af.top+af.bottom;if(X<k.nOuterMargin){ag=(k.nOuterMargin-X)/2;af.top+=ag;af.bottom+=ag}}else{X=af.left+af.right;if(X<k.nOuterMargin){ag=(k.nOuterMargin-X)/2;af.left+=ag;af.right+=ag}}}for(var Y in af){af[Y]=Math.max(0,af[Y]);aa+="margin-"+Y+":"+Math.ceil(af[Y])+"px;"}if(aa.length>0){a.utils.addInstanceCSSRule(k,m+".fsi-pages-main-view .fsi-pages-page-container",aa);k.updateContainerDim()}}}if(f.bMainLayout){q.iCallbacks.run("onPageSizeChanged",[k.dimImage.width,k.dimImage.height])}return true};this.getPageInstanceFromChildElement=function(Y){var X=k.pageContainer;while(Y&&!Y._fsiPage&&Y!=X){Y=Y.parentNode}if(Y){return Y._fsiPage}};var P=this.onResize=function(X){k.resizeOnShow=!k.bLayoutVisible;if(!k.bLayoutVisible){return}if(k.onBeforeResize){k.onBeforeResize(X)}k.bResizing=(X&&!X.FSI_after_treshold);k.elemSpace=a.getElementDimension(k.elContainer);t=false;if(X&&X.FSI_after_treshold){k.updatePageSize()}if(k.dimImage.width>0&&k.dimImage.height>0){t=true}if(k.onAfterResize){k.onAfterResize(X)}};this.isFlipping=function(){return k.bFlipping};this.deactivateActiveLink=function(){if(!K.oArea){return}K.iLinks.setLinkNormal(K.oArea,true)};k.restoreActiveLinkState=function(){if(!K.oArea||K.oArea._state==0){return}var X=k.getCurrentContainer();var Y=K.iPage.nIndex;if(K.iPage.isVisible()&&X&&((X.iPage1&&X.iPage1.nIndex==Y)||(X.iPage2&&X.iPage2.nIndex==Y))){K.iLinks.updateLinkVisualState(K.oArea,K.evt,K.oArea._state)}else{k.deactivateActiveLink()}};this.setActiveLinkArea=function(Z,Y,aa,X){if(aa){if(K.iPage!=b&&K.iPage.nIndex!=Z.nIndex){if(K.oArea){K.iLinks.setLinkNormal(null)}}}K.iPage=Z;K.iLinks=Y;K.oArea=aa;K.evt=X};this.nextPage=function(){};this.previousPage=function(){};this.firstPage=function(){};this.lastPage=function(){};this.setOption=function(X,Y){if(S[X]==b){S[X]=f[X]}f[X]=Y};this.resetOption=function(X){f[X]=S[X]};this.updateVisiblePageRange=this.stopScrolling=function(){};var R=function(X){if(l){X=false}var aa=r;aa.stopWidth=k.wItem-k.containerMargins.left-k.containerMargins.right;var Z=aa.startWidth/aa.stopWidth;k.pageContainer.scrollLeft+=aa.focusX;k.pageContainer.scrollTop+=aa.focusY;if(!X){if(!k.bZoomed){a.removeClass(k.pageContainer,"fsi-pages-zoomed")}return}aa.rcEnd=a.getBoundingClientRect(aa.container.elContainer);var Y=a.getBoundingClientRect(k.pageContainerOuter);aa.endX=aa.rcEnd.left;aa.endY=aa.rcEnd.top;aa.deltaX=aa.startX-aa.endX;aa.deltaY=aa.startY-aa.endY;aa.orgLeft=aa.endX-Y.left;aa.orgTop=aa.endY-Y.top;aa.aniDeltaX=aa.deltaX;aa.aniDeltaY=aa.deltaY;aa.aniDeltaScale=1-Z;aa.aniPos=0;if(aa.aniFrames==b){aa.aniFrames=L}k.pageContainerInner.style.webkitTransformOrigin=k.pageContainerInner.style.transformOrigin=r.orgLeft+"px "+r.orgTop+"px";B()};var B=function(){var Y=x(r.aniPos,r.aniFrames,1,-1);var X=r.scale=1-Y*r.aniDeltaScale;r.x=Y*r.aniDeltaX;r.y=Y*r.aniDeltaY;if(r.aniPos<r.aniFrames){i.init();i.scale(X,X);i.translate(r.x,r.y);i.applyTo(k.pageContainerInner);r.aniPos++;e=requestAnimationFrame(B)}else{M()}};var M=this.stopInPlaceZoomAnimation=function(){if(e!=b){if(!k.bZoomed){a.removeClass(k.pageContainer,"fsi-pages-zoomed")}cancelAnimationFrame(e);e=b;k.pageContainerInner.style.webkitTransformOrigin=k.pageContainerInner.style.transformOrigin="";k.pageContainerInner.style.transform=k.pageContainerInner.style.webkitTransform="";r.aniFrames=L}};this.onPageDoubleClick=function(X){if(f.bOneClickZoom){return}k.clickZoomPage(X)};this.clickZoomPage=function(ad){if(k.bFlipping){return}var Z;var ac;var af=ad.target;if(!k.bZoomed){while(af){if(af._fsiPage!=b){ac=af._fsiPage;break}af=af.parentNode}if(ac){Z={};var ae=ac.oContainer;var Y=ae.elContainer;var X=a.getBoundingClientRect(Y);var ab,aa;if(ad.FSI_start_x!==b){ab=ad.FSI_start_x;aa=ad.FSI_start_y}else{ab=ad.clientX;aa=ad.clientY}Z.left=ab-X.left;Z.top=aa-X.top;Z.left/=k.dimContainer.width;Z.top/=k.dimContainer.height}k.zoom(true,true,Z)}else{k.zoom(false,true)}};this.toggleZoom=function(X){if(!k.bVisible){return}k.zoom(!k.bZoomed,X)};this.canZoomPage=function(){if(!f.enableZoom){return false}var X=k.getMaxPageDimForContainer();X.width=Math.round(f.fMaxZoom*X.width);X.height=Math.round(f.fMaxZoom*X.height);return(X.width-50>k.dimImage.width)};this.zoom=function(Z,X,aa){if(!f.enableZoom||k.bZoomed==Z){return false}if(k.bFlippEffect){return}if(Z&&!k.canZoomPage()){return}if(Z){a.addClass(k.pageContainer,"fsi-pages-zoomed")}q.showThumbBar(!Z);k.disableActiveLink();if(!k.bVisible){X=false}if(!X){M()}if(Z){f.bQuantizeOrg=f.bQuantize;f.bQuantize=b}else{f.bQuantize=f.bQuantizeOrg}k.bZoomed=Z;q.getMenu().setButtonPressed("ZoomPage",Z);k.stopScrolling();if(e!=b){k.pageContainerInner.style.transform="";r.startX=r.endX+r.x;r.startY=r.endY+r.y;r.startWidth=r.stopWidth*r.scale;r.aniFrames=r.aniPos}else{r.container=k.getCurrentContainer(true);if(r.container){var Y=a.getBoundingClientRect(r.container.elContainer);r.startX=Y.left;r.startY=Y.top;r.startWidth=k.wItem-k.containerMargins.left-k.containerMargins.right}}if(!Z){if(k.touchHandler&&!a.isInternetExplorer){k.touchHandler.setAllowedPanDirection(k.touchOptions.panDirectionAllowed)}if(k.bVertical){k.pageContainer.scrollLeft=0;k.pageContainerOuter.style.width="100%"}else{k.pageContainer.scrollTop=0;k.pageContainerOuter.style.height="100%"}}else{if(k.touchHandler&&!a.isInternetExplorer){k.touchHandler.setAllowedPanDirection("")}}k.updatePageSize();k.centerContent();k.centerCurrentPage(false);if(k.updateFlipContainerPos){k.updateFlipContainerPos()}if(Z&&aa!=b){r.focusX=aa.left*k.dimContainer.width-k.pageContainer.offsetWidth/2+k.containerMargins.left;r.focusY=aa.top*k.dimContainer.height-k.pageContainer.offsetHeight/2+k.containerMargins.top;r.focusX=Math.max(k.containerMargins.left,Math.min(k.dimContainer.width-k.pageContainer.offsetWidth+k.containerMargins.left,r.focusX));r.focusY=Math.max(+k.containerMargins.top,Math.min(k.dimContainer.height-k.pageContainer.offsetHeight+k.containerMargins.top,r.focusY))}else{if(Z){r.focusX=k.containerMargins.left;if(k.bGroupDoublePages&&k.nCurrentPage==q.getFrontCoverIndex()){r.focusX+=k.wItem/2}r.focusY=k.containerMargins.top}else{r.focusX=r.focusY=0}}if(Z){q.iCallbacks.run("onPageZoomed",[k.nCurrentPage])}R(X);if(k.showDropShadow&&k.bGroupDoublePages){if(!Z){k.repositionDropShadow()}k.showDropShadow(!Z)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageLayoutGrid!=b){return}a.PageLayoutGrid=function(ac,ay,V,aD,g){a.PageLayout.prototype.constructor.call(this,ac,ay,V,aD,g);var ax=this;ax._strClassName="FSI.PageLayoutGrid";var t=ax.debug;var aC,ak;var aH,d;var F={};var f,o;var R;var p;var au;var N;var ar;var aa;var J=0;var C;var aB={};var av=a.Easing.easeOutCubic;var an;var B=ax.bVertical;var af;var M;var j=0;var W;ax.containerPaddingX=ax.containerPaddingY=0;var al,ah;var q;var Y={x:0,y:0};var i=false;var l;var ab=ax.oVisibleRange;var E={};var A=-1;var n=(ax.bGroupDoublePages)?2:1;var U=0;var Q=0;var z=false;var v=ax.bAutoPageSize;ax.containerMargins={};var K=(g.nScrollAnimationFrames!=b)?g.nScrollAnimationFrames:30;var am=(g.nCreateAhead!=b)?g.nCreateAhead+1:2;var aM=am-1;var ao,H;var h;var at=g.trackCurrentPageWhileScrolling;var aj=g.bAutoSelectCurrentPage;var aO;var Z=0;var aK=(a.isMobileDevice)?1:2;var k=false;var aI=false;var aA;ax.bUseAfterTouch=true;ax.bScrollEventHandler=true;var aQ;if(a.isMobileDevice){K=Math.max(1,Math.ceil(K/2))}if(!v){if(typeof(g.thumbWidth)!="number"||g.thumbWidth<1){g.thumbWidth=120}if(typeof(g.thumbHeight)!="number"||g.thumbHeight<1){g.thumbHeight=120}}var ap=this.destroy;this.destroy=function(){if(l!=b){clearTimeout(l)}ay.getMenu().setButtonPressed("ZoomPage",false);if(g.bMainLayout&&g.enableZoom){a.removeEvent(ax.pageContainer,"dblclick",ax.onPageDoubleClick)}if(aQ!=b){a.removeCustomEvent(ax.pageContainer,"FSIMouseWheel",ax.onMouseWheel);aQ=b}if(ax.bScrollEventHandler&&ax.pageContainer.style!=b){a.removeEvent(ax.pageContainer,"scroll",aG)}if(q){q.destroy();q=b}c();ap.apply(ax,arguments)};if(typeof(g.onCurrentPageChange)=="function"){al=g.onCurrentPageChange}else{al=false}if(typeof(g.onSelectedPageChange)=="function"){ah=g.onSelectedPageChange}else{ah=false}this.getMaxPageDim=function(aR){var aZ,aW,aX;if(aR===b){aR=n}else{aX=true}if(v){var aV=ac.getPageContainerDim();if(aR==2&&ax.divDropShadow){ax.containerPaddingX=ax.fDropSchadowDistance*0.027*aV.width;ax.containerPaddingY=ax.fDropSchadowDistance*0.025*aV.height}else{ax.containerPaddingX=ax.containerPaddingY=0}var aU=aV.width-ax.containerPaddingX;var aY=aV.height-1.7*ax.containerPaddingY;if(aR==2){aZ=aU/2}else{aZ=aU}aW=aY;if(ax.containerMarginsInitial!=b){aZ-=Math.floor((ax.dimContainer.width-ax.clientDimContainer.width)/aR);aW-=Math.floor(ax.dimContainer.height-ax.clientDimContainer.height);var aT=ax.containerMarginsInitial.left+ax.containerMarginsInitial.right;var aS=ax.containerMarginsInitial.top+ax.containerMarginsInitial.bottom;if(ax.nShowNeighbourPages>0){if(ax.bVertical){aS=Math.max(ax.nOuterMargin,aS)}else{aT=Math.max(ax.nOuterMargin,aT)}}aZ-=Math.floor(aT/aR);aW-=Math.floor(aS);if(ax.nShowNeighbourPages){if(B){aW-=2*ax.nShowNeighbourPages+ax.containerMarginsInitial.top+ax.containerMarginsInitial.bottom;aW-=aS}else{aZ-=2*ax.nShowNeighbourPages;aZ-=aT}}}if(ax.dimContainer.width>0){if(!aX){aJ()}}}else{aZ=g.thumbWidth;aW=g.thumbHeight;if(!aX){aJ()}}return{width:Math.floor(aZ),height:Math.floor(aW)}};this.handlePointerDown=function(aR,aS){if(ay.iChapters){ay.iChapters.show(false)}ay.onUserAction();if(aA){aA=b}i=true;ax.stopInPlaceZoomAnimation();c();Y.x=ax.pageContainer.scrollLeft;Y.y=ax.pageContainer.scrollTop;Y.xTouch=aS.x;Y.yTouch=aS.y;return true};this.handlePointerUp=function(aR,aS){if(ax.isFlipping()){return}ay.onUserAction();if(aR._FSI_Click&&aR.type!="touchstart"&&aR.type!="mousedown"){aE(aR)}i=false};var ag=function(aR){if(g.bQuantize){aR=Math.round(aR/aC)*aC}return aR};var ae=function(aR){if(g.bQuantize){aR=Math.round(aR/ak)*ak}return aR};var w=function(aR){if(C==b){ax.bFlipping=false}if(!ax.bZoomed&&aR!=0){e(ax.getCurrentPage(true),(aR>5))}};this.onAfterTouchEnd=function(){ax.bFlipping=false};this.modifyAfterTouchTarget=function(aV,aR){var aU;if(B){aU=aV.y-Y.yTouch;if(!ax.bZoomed&&Math.abs(aU)<15){w(Math.abs(aU));return false}var aS=Y.y-aU-Q;aS=ae(aS)+Q;aS=s(aS,1);aV.y=Y.y-aS+Y.yTouch}else{aU=aV.x-Y.xTouch;if(!ax.bZoomed&&Math.abs(aU)<15){w(Math.abs(aU));return false}var aT=Y.x-aU-Q;aT=ag(aT)+Q;aT=T(aT,1);aV.x=Y.x-aT+Y.xTouch}return aV};this.handlePointerMove=function(aS,aU){if(k||!aS){if(aS){aS.FSI_allowEventDefault=true}return}var aT=Math.abs(aU.x-aS.FSI_start_x);var aR=Math.abs(aU.y-aS.FSI_start_y);if(!ax.bZoomed){if(B){if(1.5*aR<aT){aS.FSI_allowEventDefault=true}}else{if(1.5*aT<aR){aS.FSI_allowEventDefault=true}}if(aS&&ax.bScrollEventHandler){if(B){Y.yTarget=Y.y+aS.FSI_start_y-aU.y}else{Y.xTarget=Y.x+aS.FSI_start_x-aU.x}ax.bFlipping=true;if(!C){C=requestAnimationFrame(aP)}}}else{Y.yTarget=Y.y+aS.FSI_start_y-aU.y;Y.xTarget=Y.x+aS.FSI_start_x-aU.x;if(!C){C=requestAnimationFrame(aq)}}};var aq=function(){ax.pageContainer.scrollTop=Y.yTarget;ax.pageContainer.scrollLeft=Y.xTarget;C=b};var aP=function(){if(B){ax.pageContainer.scrollTop=Y.yTarget}else{ax.pageContainer.scrollLeft=Y.xTarget}C=b};this.updateVisiblePages=function(){};this.initLayout=function(){aO=(B)?"scrollTop":"scrollLeft";ax.pageContainerOuter=document.createElement("div");a.addClass(ax.pageContainerOuter,"fsi-pages-page-container-outer");ax.pageContainer.appendChild(ax.pageContainerOuter);if(B){ax.pageContainerOuter.style.width="100%"}else{ax.pageContainerOuter.style.height="100%"}ax.pageContainerInner=document.createElement("div");a.addClass(ax.pageContainerInner,"fsi-pages-page-container-inner");ax.pageContainerOuter.appendChild(ax.pageContainerInner);if(B){a.addClass(ax.pageContainer,"fsi-pages-layout-grid-vert");af=ax.getFirstItemVert}else{a.addClass(ax.pageContainer,"fsi-pages-layout-grid-horz");af=ax.getFirstItemHorz}an=ax.touchOptions={};an.detectGestures=false;an.bAllowMouseDown=true;an.afterTouch={enabled:true};if(g.bMainLayout){an.afterTouch.factorAmount=10;an.afterTouch.factorAmountQuad=20;an.afterTouch.factorFrames=(a.isMobileDevice)?0.4:1.1;an.afterTouch.minDelta=0}else{an.afterTouch.factorAmount=13;an.afterTouch.factorAmountQuad=30;an.afterTouch.factorFrames=1.25;an.afterTouch.minDelta=0}an.afterTouch.minFrames=0;an.afterTouch.useAnimationFrame=true;an.afterTouch.modifyTarget=ax.modifyAfterTouchTarget;an.onAfterTouchEnd=ax.onAfterTouchEnd;an.nClickRadius=30;an.detectClick=true;if(!a.isInternetExplorer){if(B&&!ax.bFlipLayout){an.panDirectionAllowed="pan-x"}else{an.panDirectionAllowed="pan-y"}}q=ax.touchHandler=new a.TouchHandler(ax.pageContainerOuter,an,ax.handlePointerDown,ax.handlePointerMove,ax.handlePointerUp);aw();if(ay.cfgBool("mousewheelnavigation",true)){var aU=aQ=a.addCustomEvent(ax.pageContainer,"FSIMouseWheel",ax.onMouseWheel);a.setCustomEventListenerProperty(aU,"acceleration",1.22);a.setCustomEventListenerProperty(aU,"accelerationMax",25)}var aV=Math.max(ax.nMinPageIndex,Math.min(ax.nMaxPageIndex,g.initialPageIndex));if(isNaN(aV)){aV=ax.nMinPage}var aT=ax.createPageContainerForPage(aV);if(!aT){return}aT.show();ab.start=aT.nIndex;ab.end=aT.nIndex;ab.nVisible=1;ax.updateContainerDim();ax.containerMarginsInitial=a.utils.cloneObject(ax.containerMargins);if(!v){var aS=ax.containerMargins.left+ax.containerMargins.right+ax.dimContainer.width;var aR=ax.containerMargins.top+ax.containerMargins.bottom+ax.dimContainer.height;g.thumbWidth=Math.max(2,Math.min(g.thumbWidth,Math.floor(g.elContainer.clientWidth/n)-aS));g.thumbHeight=Math.max(2,Math.min(g.thumbHeight,Math.floor(g.elContainer.clientHeight)-aR))}ax.updatePageSize(true);ax.onResize();if(ax.bScrollEventHandler){a.addEvent(ax.pageContainer,"scroll",aG)}if(g.bMainLayout&&g.enableZoom){a.addEvent(ax.pageContainer,"dblclick",ax.onPageDoubleClick)}ax.bHasPages=true;G();if(g.bSelectFirstPage){y(aV)}var aW=aV;if(B){aW-=Math.floor(p/2)}r(aW,false,true);ax.pageContainer.style.visibility="true";az(true)};var aw=function(){k=(ax.nDocumentScale>=1.5);q.setCapture(!k,false)};this.onStartDocumentZoom=function(aR){aI=true;u(true);ax.disableActiveLink();q.enable(false);k=true;P(false,false)};var ad=this.onAfterDocumentZoom;this.onAfterDocumentZoom=function(aR){if(q.getPointerCount()>1){return}aI=false;var aS=(ay.bUseDevicePixelRatio)?aR.FSI_scale_with_pixel_ratio:aR.FSI_scale;aS=ay.roundDocumentScale(aS);if(aS!=ax.nDocumentScalePixelRatio){ax.nDocumentScalePixelRatio=aS;ax.nDocumentScale=ay.roundDocumentScale(aR.FSI_scale);ax.resetCropCache();ax.updateImagesOfVisiblePages()}q.enable(true);aw();P(false,false);u(true);ad.apply(ax,arguments)};var T=function(aS,aR){return Math.max(aR*Q,Math.min(Math.round(ax.pageContainer.scrollWidth-F.width-aR*Q),aS))};var s=function(aS,aR){return Math.max(aR*Q,Math.min(Math.round(ax.pageContainer.scrollHeight-F.height-aR*Q),aS))};this.getScrollTarget=function(aR){var aS;if(B){aS=Math.floor(Math.floor(aR/R)*ak+Q);aS=s(aS,1)}else{aS=Math.floor(Math.floor(aR/R)*aC+Q);aS=T(aS,1)}return aS};this.getCurrentPage=function(aT){if(!aT||!ax.bLayoutVisible){return ax.nCurrentPage}var aS,aR;var aU;if(B){aU=Math.min(0,F.height-ak)/2;aR=Math.round((ax.pageContainer.scrollTop-Q+aU)/ak)*R}else{aU=Math.min(0,F.width-aC)/2;aR=Math.round((ax.pageContainer.scrollLeft-Q+aU)/aC)*R}if(ax.bGroupDoublePages){aS=2*aR}else{aS=aR}aS=Math.max(ax.nMinPage,Math.min(ax.nMaxPage,aS));return aS};var y=this.setSelectedPage=function(aR){var aS=ax.getContainerIndexFromPage(aR);if(W!=aS){if(W!=b){a.removeClass(ax.arContainers[W].elContainer,"selected")}if(ax.arContainers[aS]==b){x(aS)}a.addClass(ax.arContainers[aS].elContainer,"selected");W=aS}if(ah){ah.apply(ax,[aR])}};var r=this.gotoPage=function(aR,aS,aT){if(aS&&ax.bPreventAnimation){aS=false}if(aA){aA=b}if(ax.bZoomed){ax.zoom(false,true)}aR=Math.max(ax.nMinPage,Math.min(ax.nMaxPage,aR));ax.setCurrentPage(aR,"gotoPage");ax.scrollToContainer(ax.getContainerIndexFromPage(aR),aS,aT)};var aL=function(aR){if(aa!=aR){aa=aR;if(al){al.apply(ax,[aR,true])}}};this.setCurrentPage=function(aS,aR){var aT=false;if(ax.nCurrentPage!=aS){aT=true;ax.nCurrentPage=aa=aS;if(aj){y(aS)}if(al){al.apply(ax,[aS])}if(g.bMainLayout){if(l!=b){clearTimeout(l)}l=setTimeout(D,350)}}return aT};var D=function(){l=b;if(g.enableZoom&&!ax.bZoomed){ay.getMenu().enableButton("ZoomPage",ax.canZoomPage())}};ax.isPageInCurrentContainer=function(aT){var aS=false;var aR=ax.getCurrentContainer();if(aR){if(aR.iPage1&&aR.iPage1.nIndex==aT){aS=aR.iPage1}else{if(aR.iPage2&&aR.iPage2.nIndex==aT){aS=aR.iPage2}}}return aS};this.gotoPageAndZoom=function(aT,aS){var aV=ax.isPageInCurrentContainer(aT);if(aV){var aR=ax.parseViewString(aS);var aU=new a.Rect(aR[2],aR[3],aR[4],aR[5]);aU.normalizeRect();if(aV&&aV.iSiblingPage){aU.scaleRectXY(0.5,1);if(aV.iSiblingPage.nIndex<aV.nIndex){aU.offsetRect(0.5,0)}}var aW={};aW.left=aU.left+aU.width()/2;aW.top=aU.top+aU.height()/2;if(ax.bZoomed){ax.zoom(false,true)}ax.zoom(true,true,aW)}else{r(aT,true);aA=arguments}};this.scrollToContainer=function(aR,aU,aW){var aT=ax.getScrollTarget(aR);if(g.bLazyScroll&&!aW){if(B){}else{var aS=aC*aR;var aV=ax.pageContainer.scrollLeft-ax.scrollOffsetStart;if(aS<aV||aS+aC>aV+F.width){if(aS<ax.pageContainer.scrollLeft){aT=aS-F.width+aC}else{aT=aS}aT=ag(aT+Z)-Z+ax.scrollOffsetStart;aT=T(aT,1)}else{return}}}aT=Math.floor(aT);if(aT!=ax.pageContainer[aO]){u();if(!aU){if(B){ax.pageContainer.scrollTop=aT}else{ax.pageContainer.scrollLeft=aT}}else{ai(aT)}}};var e=ax.scrollToPage=function(aR,aT,aU){aR=Math.max(ax.nMinPage,Math.min(ax.nMaxPage,aR));var aS=ax.getContainerIndexFromPage(aR);ax.scrollToContainer(aS,aT,aU)};var c=function(aR){if(C){cancelAnimationFrame(C);C=b;ax.bFlipping=false;if(aR){if(B){ax.pageContainer.scrollTop=aB.end}else{ax.pageContainer.scrollLeft=aB.end}}}};var ai=function(aS,aR){c(aR);aS=Math.floor(aS);aB.prop=(B)?"scrollTop":"scrollLeft";var aT=aS-ax.pageContainer[aB.prop];if(B){if(aS==ax.pageContainer.scrollTop){return}if(Math.abs(aT)>aK*ak){if(aT>0){ax.pageContainer.scrollTop=aS-aK*ak}else{ax.pageContainer.scrollTop=aS+aK*ak}}}else{if(aS==ax.pageContainer.scrollLeft){return}if(Math.abs(aT)>aK*aC){if(aT>0){ax.pageContainer.scrollLeft=aS-aK*aC}else{ax.pageContainer.scrollLeft=aS+aK*aC}}}aB.pos=1;aB.frames=K;aB.start=ax.pageContainer[aB.prop];aB.end=aS;aB.delta=aS-aB.start;if(aB.end!=aB.start){at=false;I(true);C=requestAnimationFrame(X);ax.bFlipping=true}};var X=function(){ax.pageContainer[aB.prop]=av(aB.pos++,aB.frames,aB.start,aB.delta);if(aB.pos<=aB.frames){C=requestAnimationFrame(X)}else{C=b;ax.bFlipping=false;ax.doAfterGotoPageFinished()}};var aF=function(aR){return ax.getTargetPage(ax.nCurrentPage+aR)};var L=function(aS){if(!aS){return}var aR=aF(aS);var aT=!(aR==ax.nCurrentPage);r(aR,true,true);return aT};this.nextPage=function(){var aR=(ax.bGroupDoublePages)?2*R:R;L(aR)};this.previousPage=function(){var aR=(ax.bGroupDoublePages)?2*R:R;L(-aR)};this.firstPage=function(){L(-ax.nMaxPage)};this.lastPage=function(){L(ax.nMaxPage)};var aE=function(aR){if(ax.bZoomed){if(g.bOneClickZoom){var aT=ax.getPageInstanceFromChildElement(aR.target);if(aT){var aS=aT.getLinksInstance();if(!aS||aS.noActiveArea()){ax.toggleZoom(true)}}}return}if(typeof(g.onPageClick)!="function"){return}var aT=ax.getPageInstanceFromChildElement(aR.target);if(aT&&aT.bRealPage){g.onPageClick.apply(ac,[aT,aR])}};this.doAfterGotoPageFinished=function(){if(aA){ax.gotoPageAndZoom.apply(ax,aA);aA=b}};var u=this.stopScrolling=function(aR){c(aR);if(q){q.cancelAfterTouch()}i=false;ax.cancelScrollEndCheck()};this.cancelScrolling=function(aR){u();ax.setCurrentPage(ax.getCurrentPage(true),"cancelScrolling");P(aR)};this.onBeforeResize=function(aR){if(ax.bResizing){return}if(!ax.bResizing){ax.stopInPlaceZoomAnimation();u()}};this.onAfterResize=function(aR){if(aR&&!aR.FSI_after_treshold){return}if(ax.bHasPages){u();ax.updateContainerDim();if(h!=b){e(h,false,true,false)}else{P(false)}ax.centerContent();az();if(ax.repositionDropShadow){ax.repositionDropShadow()}}};var O=this.show;this.show=function(aR){O.apply(ax,arguments);if(!aR){az()}};var m=this.updatePageSize;this.updatePageSize=function(aS){var aT=m.apply(ax,arguments);if(!ax.bHasPages){return aT}if(aT){ax.resetCropCache();if(!ax.bDefinesPageSizeByCSS){for(var aR=ax.nMinPageIndex;aR<ax.nMaxPageIndex;aR++){ax.arPages[aR].setSize(ax.dimImage.width,ax.dimImage.height)}}F={};ax.updateContainerDim();ax.updateImagesOfVisiblePages()}return aT};this.resetCenterContent=function(){if(g.bCenterContent){if(ax.bVertical){ax.pageContainer.style.paddingRight=ax.pageContainer.style.paddingLeft="0px"}else{ax.pageContainer.style.paddingBottom=ax.pageContainer.style.paddingTop="0px"}}};this.centerContent=function(){var aT;var aS;if(g.bCenterContent){if(ax.bVertical){aS=aC*ax.nColumnsPerRow;aT=Math.max(0,Math.round((ax.pageContainerInner.offsetWidth-aS)/2));ax.pageContainerOuter.style.paddingRight="0";ax.pageContainerOuter.style.paddingLeft=aT+"px"}else{aS=ak*ax.nColumnsPerRow;aT=Math.max(0,Math.round((ax.pageContainerInner.offsetHeight-aS)/2));if(g.bMainLayout){ax.pageContainerOuter.style.paddingTop="0";var aR=a.getBoundingClientRect(ax.pageContainerOuter);if(aR.height>ax.pageContainerInner.offsetHeight){aT+=Math.floor((aR.height-ax.pageContainerInner.offsetHeight)/2)}}ax.pageContainerOuterStylePaddingTop=aT;ax.pageContainerOuter.style.paddingBottom="0";ax.pageContainerOuter.style.paddingTop=aT+"px"}}};var G=function(){F={};ax.updateContainerDim()};var aJ=function(){if(z){return}z=true;ax.pageContainer.style.visibility="visible"};this.updateContainerDim=function(){var a0,aY,aT,aS;var aZ=ax.arContainers[ab.start];if(!aZ){t.error("ERROR updateContainerDim container undefined");return}var aU=aZ.elContainer;if(!aU){t.error("ERROR updateContainerDim container element undefined");return}if(!aU.parentNode){t.error("ERROR updateContainerDim container not in DOM");return}var aR=aZ.nIndex;var aV=((aR==ax.nFrontCoverContainerIndex||aR==ax.nBackCoverContainerIndex)&&!a.hasClass(aU,"fsi-pages-page-border"));if(aV){a.addClass(aU,"fsi-pages-page-border");if(aZ.iPage1){aT=aZ.iPage1.getContainer();a0=aT.className;a.removeClass(aT,"fsi-pages-page-border")}if(aZ.iPage2){aS=aZ.iPage2.getContainer();aY=aS.className;a.removeClass(aS,"fsi-pages-page-border")}}ax.containerMargins=a.getElementMargins(aU);ax.dimContainer={width:aU.offsetWidth,height:aU.offsetHeight};ax.clientDimContainer={width:aU.clientWidth,height:aU.clientHeight};var aW=ax.containerMargins;aC=ax.wItem=ax.dimContainer.width+aW.left+aW.right;ak=ax.hItem=ax.dimContainer.height+aW.top+aW.bottom;F.width=ax.pageContainer.clientWidth;F.height=ax.pageContainer.clientHeight;N=a.utils.getElementPaddings(ax.pageContainer);f=N.top;o=N.left;aH=ax.pageContainer.clientWidth-N.left-N.right;d=ax.pageContainer.clientHeight-N.top-N.bottom;ax.nScrollOver=0;ax.scrollOffsetStart=ax.scrollOffsetEnd=0;ax.calcColumnsAndRows(B);if(B){A=-n*R;if(!ax.bZoomed&&g.alignMode==1){ax.scrollOffsetStart=Math.round((d-ak)/2)}}else{A=-n*R;if(!ax.bZoomed&&g.alignMode==1){ax.scrollOffsetStart=Math.round((aH-aC)/2)}}ax.scrollOffsetEnd=ax.scrollOffsetStart;Q=Math.ceil(ax.nScrollOver);ax.scrollOffsetStart+=Q;ax.scrollOffsetEnd+=Q;U=ax.scrollOffsetStart+ax.scrollOffsetEnd;switch(g.alignMode){case 1:Z=aH/2+aC/2;break;default:Z=0}ar=b;var aX;if(B){aX=Math.ceil(ax.nLayoutContainers/R)*ak;if(!ax.bFlipLayout&&U!=0){aX=Math.max(ax.pageContainer.clientHeight,aX)}ax.pageContainerOuter.style.height=(U+aX)+"px"}else{aX=Math.ceil(ax.nLayoutContainers/R)*aC;if(!ax.bFlipLayout&&U!=0){aX=Math.max(ax.pageContainer.clientWidth,aX)}ax.pageContainerOuter.style.width=(U+aX)+"px"}ax.updateScrollOffset(ab.start,ab.end);if(ax.bZoomed){if(B){ax.pageContainerOuter.style.width=(aW.left+aW.right+ax.dimContainer.width)+"px"}else{ax.pageContainerOuter.style.height=(aW.top+aW.bottom+ax.dimContainer.height)+"px"}}if(aV){if(aT){aT.className=a0}if(aS){aS.className=aY}a.removeClass(aU,"fsi-pages-page-border")}return true};this.calcColumnsAndRows=function(aR){if(aR){ax.nScrollOver=Math.round(ak/2);R=ax.nColumnsPerRow=Math.max(1,Math.floor(aH/aC));au=Math.max(1,Math.ceil(F.height/ak));p=(au+1)*R}else{ax.nScrollOver=Math.round(aC/2/n);R=ax.nColumnsPerRow=1;au=Math.max(1,Math.ceil(F.width/aC));p=au*R}ao=Math.ceil(aM*p);ao-=ao%R;H=Math.floor(am*p);H-=H%R+1};this.setColumnsAndRows=function(aV,aS,aT,aU,aR){R=ax.nColumnsPerRow=aV;au=aS;p=aT;ao=aU;H=aR};this.updateScrollOffset=function(aR,aS){if(B){ax.pageContainerInner.style.paddingTop=(ax.scrollOffsetStart+Math.floor(aR/R)*ak)+"px"}else{ax.pageContainerInner.style.paddingLeft=(ax.scrollOffsetStart+Math.floor(aR/R)*aC)+"px"}};this.getFirstItemVert=function(){var aR=ax.pageContainer.scrollTop-Q;return Math.max(0,Math.floor(aR/ak))*R};this.getFirstItemHorz=function(){var aR=ax.pageContainer.scrollLeft-Q;return Math.max(0,Math.floor(aR/aC))*R};var x=function(aS){var aR=(ax.bGroupDoublePages)?ax.createPageContainerForPage(2*aS):ax.createPageContainerForPage(aS);if(!aR){t.error("FAILED TO CREATE CONTAINER: "+aS)}return aR};var S=function(aS,aT){var aR=ax.arContainers[aS];if(aR==b){aR=x(aS)}aR.show(aT)};this.removeAllContainers=function(){for(var aR=ab.start;aR<=ab.end;aR++){ax.arContainers[aR].hide()}ab.start=ab.end=-1};var az=this.updateVisiblePageRange=function(aS){if(!ax.bLayoutVisible||ax.bResizing){return}var aR;var aT;var aU=af();if(ar==aU&&!aS){return}ar=aU;E.start=ab.start;E.end=ab.end;ab.start=Math.max(0,aU-ao);ab.end=Math.min(ax.nContainers-1,aU+H);if(ab.start==E.start&&ab.end==E.end&&!aS){return}ab.nVisible=ab.end-ab.start+1;ax.resetLoadContent();if(ab.start>E.end||ab.end<E.start){if(E.start>-1){for(aR=E.start;aR<=E.end;aR++){ax.arContainers[aR].hide()}}for(aR=ab.start;aR<=ab.end;aR++){S(aR)}}else{if(ab.start!=E.start){if(ab.start>E.start){for(aR=E.start;aR<ab.start;aR++){ax.arContainers[aR].hide()}}else{aT=ax.arContainers[E.start];for(aR=ab.start;aR<E.start;aR++){S(aR,aT)}}}if(ab.end!=E.end){if(ab.end<E.end){for(aR=ab.end+1;aR<=E.end;aR++){ax.arContainers[aR].hide()}}else{for(aR=E.end+1;aR<=ab.end;aR++){S(aR)}}}}ax.updateScrollOffset(ab.start,ab.end);ax.startLoadingContent(ab.start,ab.end)};var P=this.centerCurrentPage=function(aR,aT){var aS=ax.getCurrentPage(aT);if(ax.bVisible&&C===b){e(aS,aR,true)}};this.onMouseWheel=function(aR){ay.onUserAction();var aS=(a.isMac)?aR.FSI_normalized_delta:aR.FSI_normalized_accelerated_delta;if(a.isChrome){setTimeout(function(){L(Math.round(aS*A))},0)}else{L(Math.round(aS*A))}if(aR.preventDefault){aR.preventDefault()}};this.cancelScrollEndCheck=function(){if(M){clearInterval(M);M=b}if(ax.bScrolling){ax.bScrolling=false;ax.restoreActiveLinkState()}};this.saveScrollPos=function(){ax.nStoredScrollPosX=ax.pageContainer.scrollLeft;ax.nStoredScrollPosY=ax.pageContainer.scrollTop};this.restoreScrollPos=function(){ax.pageContainer.scrollLeft=ax.nStoredScrollPosX;ax.pageContainer.scrollTop=ax.nStoredScrollPosY};var aN=function(){J++;az();if(at&&J%4==0){aL(ax.getCurrentPage(true))}if(C!==b||i||j++<1){return}ax.setCurrentPage(ax.getCurrentPage(true),"scrollEnd");at=g.trackCurrentPageWhileScrolling;if(g.bScrollToCurrentTopPageAfterResize){h=ax.getCurrentPage(true)}ax.cancelScrollEndCheck();if(ax.bHasScrollBar==true){var aS=ax.pageContainer.scrollTop;var aR;if(B){aR=s(aS,1)}else{if(B){aR=T(aS,1)}}if(aS!=aR){ai(aR)}}};var I=function(aR){if(aI){return}if(!ax.bScrolling){if(!M){J=0;ax.deactivateActiveLink();M=setInterval(aN,150)}ax.bScrolling=true}};var aG=function(aR){if(aI){return}if(!ax.bScrolling){I()}j=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageLayoutFlip!=b){return}a.PageLayoutFlip=function(d,s,ac,D,i){i=this.oOptions=(typeof(i)=="object")?i:{};i.bHorizontal=true;i.bOnePageInView=false;a.PageLayoutGrid.prototype.constructor.call(this,d,s,ac,D,i);var o=this;o._strClassName="FSI.PageLayoutFlip";var f;var x;var K;var J=true;var w,af,B;var u,ad;o.bUseAfterTouch=false;o.bScrollEventHandler=false;o.bFlipLayout=true;var N=0;var h;var y;var O;var T,G;var ab;var Z={};o.strPageContainerClass="fsi-pages-flip";var Y;var t=o.bGroupDoublePages;var E;var aj,p,l;var M;var H=false;var F=this.init;this.init=function(){M=d.getConfigInt("NoEdgeFlipBelowWidth",0);a.addEvent(s.getRootContainer(),"contextmenu",I);Y=(t)?2:1;var am={};am.onFlipFinish=o.onFlipFinish;am.svgTemplate=s.svgTemplateWithRect.cloneNode(true);am.bDoublePages=t;if(a.isInternetExplorer&&s.cfgBool("FixEdgeTransformFlicker",true)){am.bFixEdgeTransformFlicker=true}var ak=(i.bMainLayout&&i.dropShadow);if(ak){o.divDropShadow=aj=document.createElement("div");if(!isNaN(i.dropShadowOpacity)){aj.style.opacity=i.dropShadowOpacity}aj.bVisible=true;if(!isNaN(i.dropShadowDistance)){o.fDropSchadowDistance=2*i.dropShadowDistance}else{o.fDropSchadowDistance=1}aj.className="fsi-pages-drop-shadow-container";p=document.createElement("div");p.bVisible=true;p.className="fsi-pages-drop-shadow fsi-pages-drop-shadow-left";aj.appendChild(p);l=p.cloneNode(false);l.bVisible=true;l.className="fsi-pages-drop-shadow fsi-pages-drop-shadow-right";aj.appendChild(l)}f=new a.FlipEffect(d,s,o,am);F.apply(o,arguments);if(ak){o.pageContainer.insertBefore(aj,o.pageContainer.firstChild);S();e()}else{if(aj){aj.parentNode.removeChild(aj)}o.divDropShadow=aj=b}f.appendTo(o.pageContainerInner);var al=f.getContainerElement();al.style.position="absolute";al.style.zIndex="3";o.updateFlipContainerPos();a.addEvent(o.pageContainerInner,"mousemove",j);ah()};var v=this.initLayout;this.initLayout=function(){v.apply(o,arguments);if(!t){o.loadContainerContent(o.getContainerForPage(-1))}};var W=this.destroy;this.destroy=function(){a.removeEvent(s.getRootContainer(),"contextmenu",I);aa();n();X();W.apply(o,arguments);f.destroy();a.removeEvent(o.pageContainerInner,"mousemove",j)};this.setLayoutContainers=function(){o.nLayoutContainers=1};this.cancelScrollEndCheck=function(){};var k=this.hide;this.hide=function(ak){if(!k.apply(o,arguments)){return}R()};this.calcColumnsAndRows=function(ak){o.setColumnsAndRows(1,1,1,0,0)};this.updateScrollOffset=function(ak,al){if(o.bVertical){o.pageContainerInner.style.paddingTop=o.scrollOffsetStart+"px"}else{o.pageContainerInner.style.paddingLeft=o.scrollOffsetStart+"px"}};var V=this.setCurrentPage;this.setCurrentPage=function(al,ak){x=o.nCurrentPage;V.apply(o,arguments);h=o.getCurrentContainer();e();c()};this.getCurrentPage=function(ak){return o.nCurrentPage};this.getFirstItemHorz=this.getFirstItemVert=function(){return o.getContainerIndexFromPage(o.nCurrentPage)};this.scrollToContainer=function(ak,al,ap){if(o.bResizing){return}n();X();if(x!=o.nCurrentPage){R();o.updateVisiblePageRange();if(al){var am=L(x,o.nCurrentPage);if(am!==b){var aq;var an=s.getCommandRepeatCount();var ao=false;if(an||N){ao=true;aq=14}ab=true;if(am){f.flip(2,aq,ao)}else{f.flip(0,aq,ao)}}}}};var r=this.onBeforeResize;this.onBeforeResize=function(){var ak=r.apply(o,arguments);if(!o.bResizing){R()}return ak};var q=this.onResize;this.onResize=function(al){var ak=q.apply(o,arguments);J=true;if(al&&al.FSI_after_treshold){o.updateFlipContainerPos();ah()}return ak};var ah=function(){if(M<1){return}H=(K<M)};o.showDropShadow=function(ak){if(!aj||ak===aj.bVisible){return}aj.bVisible=ak;if(ak){aj.style.display=""}else{aj.style.display="none"}};var e=function(am,ak){if(!aj||!t){return}if(!am){am=h}var an,al;if(t){an=(am&&am.iPage1&&am.iPage1.bRealPage);al=(am&&am.iPage2&&am.iPage2.bRealPage);if(ak){am=ak;an=(an&&am&&am.iPage1&&am.iPage1.bRealPage);al=(al&&am&&am.iPage2&&am.iPage2.bRealPage)}}if(an!==p.bVisible){p.bVisible=an;p.style.display=(an)?"":"none"}if(al!==l.bVisible){l.bVisible=al;l.style.display=(al)?"":"none"}};var S=o.repositionDropShadow=function(){if(o.bZoomed||!aj){return}if(!t){return o.showDropShadow(false)}aj.style.width=(o.containerPaddingX+o.dimContainer.width)+"px";aj.style.height=(0.7*o.containerPaddingY+o.dimContainer.height)+"px";aj.style.left=(o.containerMargins.left+o.scrollOffsetStart-o.containerPaddingX/2)+"px";aj.style.top=(o.containerMargins.top+o.pageContainerOuterStylePaddingTop+0.3*o.containerPaddingY)+"px"};var g=this.updateContainerDim;this.updateContainerDim=function(){var ak=g.apply(o,arguments);if(ak){J=true;K=(o.bGroupDoublePages)?o.dimContainer.width/2:o.dimContainer.width;f.setPageSize(K,o.dimContainer.height)}return ak};this.onFlipFinish=function(al,ak){N=0;X();Q();R();if(al&&!ak){o.setCurrentPage(o.flipPointerTargetPage,"AfterMouseFlip");o.updateVisiblePageRange()}o.doAfterGotoPageFinished()};var U=function(ak){if(ak.bCloned){ak.unCloneDomElements()}ak.elContainer.style.visibility=""};var P=function(ak){ak.elContainer.style.visibility="hidden";o.loadContainerContent(ak)};var R=function(){if(!o.bFlipping){return}a.removeClass(o.pageContainer,"fsi-pages-flipping");ab=false;o.bFlipEffectDrag=false;f.cancel();o.bFlipping=false;o.pageContainer.parentNode.style.zIndex="";o.pageContainer.parentNode.style.position="";var ak;ak=w;if(ak){U(ak);w=b}ak=af;if(ak){U(ak);af=b}if(B){U(B);B=b}f.removeContent();f.resetTransform();e()};var L=function(ak,aq){if(ak==b){return}if(o.bFlipping){R()}o.bFlipping=true;o.deactivateActiveLink();a.addClass(o.pageContainer,"fsi-pages-flipping");if(o.bGroupDoublePages){ak=o.getTargetPage(ak);aq=o.getTargetPage(aq)}if(ak==aq){return}o.updateFlipContainerPos();var ao=(ak<aq);o.pageContainer.parentNode.style.zIndex=800;o.pageContainer.parentNode.style.position="absolute";if(t){w=o.getContainerForPage(ak);u=w.cloneDomElements();var an=w.cloneDomElements();P(w);af=o.getContainerForPage(aq);ad=af.cloneDomElements();var am=af.cloneDomElements();P(af);if(ao){f.elFlipTopContent.style.left=(-K)+"px";f.elFlipBottomContent.style.left="0px";f.elTopStaticContent.style.left="0px";f.elBottomStaticContent.style.left=(-K)+"px"}else{f.elFlipTopContent.style.left="0px";f.elFlipBottomContent.style.left=(-K)+"px";f.elTopStaticContent.style.left=(-K)+"px";f.elBottomStaticContent.style.left="0px"}f.setContent(an,am,u,ad)}else{f.elFlipTopContent.style.left="0px";f.elFlipBottomContent.style.left="0px";f.elBottomStaticContent.style.left="0px";var al,ar,ap;af=o.getContainerForPage(-1);if(ao){w=o.getContainerForPage(ak);B=o.getContainerForPage(aq)}else{w=o.getContainerForPage(aq);B=o.getContainerForPage(ak)}al=w.cloneDomElements();ar=af.cloneDomElements();ap=B.cloneDomElements();P(af);P(w);P(B);f.setContent(al,ar,null,ap)}if(!G){e(af,w)}return ao};var I=function(ak){if(o.bFlipping){ak.cancelBubble=true;if(ak.stopPropagation){ak.stopPropagation()}if(ak.preventDefault){ak.preventDefault()}return false}};o.updateFlipContainerPos=function(){if(h){f.setPosition(h.elContainer.offsetLeft,h.elContainer.offsetTop,ad)}};var ag=function(an,ar,aq){if(!h||o.bZoomed||H){return false}var ao=a.getBoundingClientRect(h.elContainer);if(ar==b){if(!an){return}ar={x:an.clientX,y:an.clientY}}var am=ar.x-ao.left;var ap=ar.y-ao.top;var al=(am>=0&&ap>=0&&am<=h.elContainer.offsetWidth&&ap<=h.elContainer.offsetHeight);var ak=(an.type=="touchstart"||(an.pointerType&&an.pointerType!="mouse"))?80:50;if(al){al=(am<ak||am>h.elContainer.offsetWidth-ak)}if(al){if(am<h.elContainer.offsetWidth/2){if(o.nCurrentPage<2){al=false}}else{if(o.nCurrentPage+2>o.nMaxPageIndex){al=false}}}if(al&&aq){if(ap>ak&&ap<h.elContainer.offsetHeight-ak){al=false}}return al};var A=this.handlePointerDown;this.handlePointerDown=function(ak,am){A.apply(o,arguments);if(ab){return}if(f.bFlipFinishing&&o.bFlipping&&f.bPointerFlip){o.onFlipFinish(true,false)}n();X();R();if(!ag(ak,am)){return true}o.bFlipEffectDrag=true;var al=ae(ak,am);o.flipPointerTargetPage=al.nPageTarget;return true};var ae=function(ak,an,am){var al={};f.handlePointerDown(ak,an);al.nCorner=f.getFlipCorner();al.nPageCurrent=o.getTargetPage(o.nCurrentPage);al.nPageTarget=(al.nCorner>1&&!f.bReverse)?al.nPageCurrent+Y:al.nPageCurrent-Y;L(al.nPageCurrent,al.nPageTarget);return al};var ai=this.handlePointerMove;this.handlePointerMove=function(ak,al){if(o.bFlipEffectDrag){f.handlePointerMove(ak,al)}else{ai.apply(o,arguments);if(ak&&!o.bZoomed){ak.FSI_allowEventDefault=true}}};var m=this.handlePointerUp;this.handlePointerUp=function(ak,al){if(o.bFlipEffectDrag){f.handlePointerUp(ak);if(ak._FSI_Click&&ag(ak,al,true)){if(f.getFlipCorner()>1&&!f.bReverse){o.nextPage()}else{o.previousPage()}return}}o.bFlipEffectDrag=false;m.apply(o,arguments)};this.modifyAfterTouchTarget=function(al,ak){if(!o.bZoomed){al=false}return al};var z=this.onMouseWheel;this.onMouseWheel=function(ak){var al=z.apply(o,arguments);if(al){N++}return al};var n=function(){if(y){clearTimeout(y);y=b}};var j=function(ak){O=ak;if(!o.bFlipEffectDrag&&!ab&&!f.bFlipFinishing){if(T){f.handlePointerMove(O);Q()}else{if(!y){y=setTimeout(Q,200)}}}};var Q=function(){y=b;var am=ag(O,b,true);if(T!=am){if(am){G=true;a.removeEvent(o.pageContainerInner,"mousemove",j);a.addEvent(window,"mousemove",j);R();ae(O);f.setPreliminary(true)}else{X()}T=am}var al=(T||ag(O,b,false));if(al!==E){E=al;var ak=(E)?a.addClass:a.removeClass;ak(o.pageContainerInner,"fsi-pages-page-curl")}};var X=function(){if(!T){return}T=G=false;a.addEvent(o.pageContainerInner,"mousemove",j);a.removeEvent(window,"mousemove",j);f.handlePointerUp(O);f.setPreliminary(false)};var c=function(){if(Z.nInterval==b){Z.nInterval=setInterval(C,250)}Z.count=0;Z.left=Z.right=o.getTargetPage(o.nCurrentPage)};var C=function(){Z.left-=Y;Z.right+=Y;if(Z.left>0){o.loadContainerContent(o.getContainerForPage(Z.left))}if(Z.right<=o.nMaxPageIndex){o.loadContainerContent(o.getContainerForPage(Z.right))}Z.count++;if(Z.count>3){aa()}};var aa=function(){if(Z.nInterval!=b){clearInterval(Z.nInterval);Z.nInterval=b}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageToolTip!=b){return}a.PageToolTip=function(h,e,j){var m=this;var c;var f=false;var k;var i=a.utils.getCustomEventListenerInstance("FSIViewport");var d=new a.Rect();var n=new a.Rect();var g=new a.Rect();this.destroy=function(){if(!k){return}if(c.parentNode){a.removeChild(c.parentNode,c)}k=false};var l=function(){if(k){return}k=true;c=document.createElement("div");a.addClass(c,"fsi-pages-tooltip");c.style.display="none";c.style.transformOrigin=c.style.webkitTransformOrigin="0px 0px";h.appendChild(c)};this.hide=function(){if(!f){return}f=false;a.addClass(c,"fsi-pages-tooltip-hide");a.removeClass(c,"fsi-pages-tooltip-show");c.innerHTML="";c.style.display="none"};this.setParentContainer=function(o){h=o;h.appendChild(c)};this.show=function(r,J,o,L){if(!L||typeof(J)!=="object"||typeof(r)!=="string"){this.hide()}else{var B=e.nDocumentScale;f=true;c.style.width="";var N=4/B;var D=i.getVisibleRect();g.copyRect(D);g.left+=2/B;g.top+=2/B;g.right-=24/B;g.bottom-=24/B;var p=i.getScrollRect();var q=e.getDoublePageMode();var y=J.nPage;a.addClass(c,"fsi-pages-tooltip-show");a.removeClass(c,"fsi-pages-tooltip-hide");var G=a.getElementPosition(h);var R=Math.max(100,g.width());c.innerHTML=r;c.style.display="block";var P=a.getElementPosition(o);var w=(P.right-P.left);var x=(P.bottom-P.top);var F=1/B;if(F!=1){c.style.transform=c.style.webkitTransform="scale("+F+","+F+")";R/=F}else{c.style.transform=c.style.webkitTransform="none"}var O=a.getBoundingClientRect(c);if(O.height>g.height()||O.width>R){c.style.width=R+"px";O=a.getBoundingClientRect(c);if(O.width>g.width()||O.height>g.height()){var u=O.width*O.height;var s=g.width()*g.height();var S=1.02*Math.sqrt(u/s);F/=S;R*=S;c.style.width=R+"px";c.style.transform=c.style.webkitTransform="scale("+F+","+F+")";O=a.getBoundingClientRect(c)}}var v,K;var A=P.top-p.top;var I=P.left-p.left;var z=g.top;var M=g.left;var Q=g.right-O.width;var V=g.bottom-O.height;var H=-G.left+p.left;var E=-G.top+p.top;K=A;if(K>V){K=K+x-O.height}var C=I-O.width-N;var U=I+w+N;if(q){var T=(y%2===0);if(T){v=U;if(v>Q){v=C}}else{v=C;if(v<M){v=U}}}else{v=U;if(v>Q){v=C}}v=Math.max(M,Math.min(Q,v));K=Math.max(z,Math.min(V,K));c.style.left=(v+H)+"px";c.style.top=(K+E)+"px";O=a.getBoundingClientRect(c);d.copyRect(O);n.copyRect(P);d.interSectRectValidate(n);if(d.width()>0&&d.height()>0){c.style.width=R+"px";O=a.getBoundingClientRect(c);Q=g.right-O.width;V=g.bottom-O.height;v=(I+(w-O.width)/2);v=Math.max(M,Math.min(Q,v));c.style.left=(v+H)+"px";K=A+x+N;if(K>V){K=A-O.height-N}K=Math.max(z,Math.min(V,K));c.style.top=(K+E)+"px"}}};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageData!=b){return}a.PageData=function(g,f,l,j){var n=this;var i=l.iConfig;n.arAreas=[];var c=f.getDebug();var h=0;this.nPage=l.nIndex;this.global={};var m=function(){if(l.oImage&&typeof(l.oImage.fullImagePath)==="string"){var p={type:"info",renderer:null,tpl:f.cfgString("PageDataTemplate")};var o=i.getImageURL(l.oImage.fullImagePath,p);i.loadFile(o,k,"application/xml")}else{k()}};var k=function(q,o,p){if(o!=b){e(o)}j.apply(l)};var e=function(q){if(!q){n.bNoLinks=true;n.bReady=true;return}var p;var o=q.firstChild;var r=false;while(o){r=false;if(o.nodeType==1){var s=o.nodeName.toLowerCase();if(!n.bHasData&&s=="pages"){n.bHasData=true}switch(s){case"page":d(o,n.global);break;case"links":n.oLinkAttributes={};d(o,n.oLinkAttributes);break;case"image":r=true;break;case"area":r=true;n.addAreaFromXML(o);break}}p=o.firstChild;if(!p||r){p=o.nextSibling;if(!p){p=o.parentNode.nextSibling}}o=p}if(!n.global.version){n.global.version=0}else{n.global.version=parseFloat(n.global.version)}if(n.arAreas.length>0){n.bNoLinks=false}n.bReady=true};this.addAreaFromXML=function(o){var r=o;if(r.firstChild==b){return}var t;var s={};s.nIndex=h++;if(s.type===b){s.type=0}d(r,s);s._arShapes=[];r=r.firstChild;while(r){if(r.nodeType==1){var u=r.nodeName.toLowerCase();switch(u){case"shape":t={};d(r,t);if(t.coords){t.parsedCoords=t.coords.split(",");if(t.parsedCoords.length>3){s._arShapes.push(t)}}break;case"text":var p="";p=i.XMLChildNodesToString(r);if(p.length>0){s.tip=p}break;default:var q=r;while(q&&(q.nodeType!==1||!q.getAttribute("class"))){q=q.nextSibling}if(q){t={svg:q};d(r,t);s._arShapes.push(t)}}}r=r.nextSibling}if(s._arShapes.length>0){n.arAreas.push(s)}};var d=function(q,r){for(var p=0;p<q.attributes.length;p++){var o=q.attributes[p];r[o.nodeName.toLowerCase()]=o.nodeValue}};m()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Page!==b){return}a.Page=function(x,v,u,d,w,q,C){var z=this;z.iLayout=u;var B=v.getDebug();z.oImage=q;var A=z.iConfig=w.iConfig;z.bDoublePage=C.bDoublePage;z.bOddPage=C.bOddPage;z.bRealPage=C.bRealPage;z.nIndex=d;var t;var c;var j;var I;var m;var h=true;var k,E;var y;var H;var n;var f;var s=false;var D=this.init=function(){if(k){return}k=true;t=document.createElement("div");if(!z.bRealPage){t.style.visibility="hidden"}var J="fsi-pages-page";if(q.cssClass){J+=" "+q.cssClass}a.addClass(t,J);t._fsiPage=z;if(typeof(C.pageCSS)==="string"){z.setStyle(C.pageCSS)}if(!u.bDefinesPageSizeByCSS){F(w.width,w.height)}};this.destroy=function(){if(!k){return}o();if(t.parentNode){a.removeChild(t.parentNode,t);t=b}k=false};this.getSVG=function(){if(!f){f=v.svgTemplate.cloneNode(true);var J="fsi-pages-linkcontainer";if(C.bInteractive){J+=" fsi-pages-linkcontainer-interactive"}f.setAttribute("class",J);var K=z.elSVGRect=(f.children)?f.children["bend-effect"]:f.getElementById("bend-effect");if(K){K.removeAttribute("id")}if(C.bBendEffect&&!q.bNoBendEffect){if(K){if(q.cssClass){K.setAttribute("fill","url(#fsi_pages_gradient_page_"+q.cssClass+")")}else{if(!z.bOddPage){K.setAttribute("fill","url(#fsi_pages_gradient_page_even)")}}}}t.appendChild(f)}return f};this.getContainer=function(){return t};this.setOuterContainer=function(J){c=J};var o=z.removeContent=function(){if(!E){return}E=false;p();if(f){a.removeChild(f.parentNode,f);f=b}if(j){j.destroy();j=b}if(H){a.removeChild(H.parentNode,H);H=b}if(I){a.removeChild(I.parentNode,I);I=b}};var l=function(){if(q.width===b||q.height===b){var J=A.getImageInfoURL(q.fullImagePath);A.loadFile(J,i)}else{e()}};var e=function(){if(!k){return}z.updateImage();if(y){I=u.getImageNode();if(!v.iLinkEditor){I.src=y.urlCurrent}t.appendChild(I)}else{I=b}if(j){j.createLinkShapes();j.updateSVGStyle();if(h){j.show()}}};var i=function(K,J){q.width=parseInt(J.width);q.height=parseInt(J.height);e()};this.updateImage=function(){y=u.getPageImageURL(q,z.bOddPage);z.oCroppedImageCurrent=y.oCroppedImage;if(y){y.urlCurrent=A.getImageURL(q.fullImagePath,y.oImageOptions)+y.strCrop;if(A.hasImageParameterConditions){y.urlCurrent=A.reWriteImageURLByConditions(y.urlCurrent)}if(I){I.src=y.urlCurrent}if(j){j.updateSVGStyle()}}};this.initContent=function(){if(!k){return}if(E){return}E=true;z.show();if(typeof(q)==="object"){if(typeof(q.fullImagePath)==="string"){l()}else{if(q.htmlContent!==b&&u.oOptions.bMainLayout){t.innerHTML=q.htmlContent;t.style.visibility="";if(z.nIndex===0){a.addClass(t,"fsi-pages-intro-content")}}}}if(C.bPageNumbers&&u.elPageNumberTemplate&&z.strCoverClass===b&&z.bRealPage&&!q.bImageOnly){H=u.elPageNumberTemplate.cloneNode(true);if(z.bOddPage){a.addClass(H,"fsi-page-number-odd")}H.innerText=u.getPageNumberString(z.nIndex);t.appendChild(H)}if(!C.bImageOnly&&q&&!q.bImageOnly){if(q.pageData===b){m=q.pageData=new a.PageData(x,v,z,r)}else{m=q.pageData;r()}}else{g()}};this.getImageData=function(){return q};this.getFinished=function(){return s};var g=function(){s=true;if(!z.bRealPage){}else{if(C.bBendEffect){z.getSVG()}}if(u.onFinishPage){u.onFinishPage(z,t)}if(h){G(true)}if(z.onUpdateClone!==b){z.onUpdateClone(z)}};var F=z.setSize=function(J,K){t.style.width=J+"px";t.style.height=K+"px"};var r=function(){if(!E){return}var J=(v.iLinkEditor||(m&&m.arAreas&&m.arAreas.length>0));if(w.hasLinks&&J){j=new a.PageLinks(x,v,u,z,t,m,C)}g()};this.getLinksInstance=function(){return j};this.hasLinks=function(){return(j!==b)};var G=this.show=function(J){if((!J&&h)||!k){return}h=true;if(j){j.show()}c.style.display=""};var p=this.hide=function(){if(!h||!k){return}h=false;if(j){j.hide()}c.style.display="none"};this.isVisible=function(){return h};this.attachTo=function(J){n=J;if(!k){D()}n.appendChild(t)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageContainer!=b){return}a.PageContainer=function(h,g,k,i,f,e,c){var n=this;var d=g.getDebug();n.nIndex=f;n.elContainer=i;n.iPage1=e;n.iPage2=c;n.bVisible=false;n.bContentLoaded=false;n.bCloned=false;var m=function(){if(e){e.oContainer=n}if(c){c.oContainer=n}i.setAttribute("fsi-index",f)};this.destroy=function(){n.hide();if(e){e.destroy()}if(c){c.destroy()}};this.show=function(o){if(n.bVisible){return}n.bVisible=true;if(o){k.pageContainerInner.insertBefore(i,o.elContainer)}else{k.pageContainerInner.appendChild(i)}};this.unCloneDomElements=function(){if(!n.bCloned){console.error("container "+n.nIndex+" has not been cloned")}else{n.bCloned=false;if(n.iPage1){if(n.iPage1){n.iPage1.elClonedContent=b;n.iPage1.onUpdateClone=b}if(n.iPage2){n.iPage2.elClonedContent=b;n.iPage2.onUpdateClone=b}}}};var j=function(q,o){if(!q){return}if(q.elClonedContent==b){q.onUpdateClone=l;q.elClonedContent=[]}var p=q.getContainer().cloneNode(true);q.elClonedContent.push(p);o.appendChild(p)};this.cloneDomElements=function(){n.bCloned=true;if(n.iPage1){var o=n.elContainer.cloneNode();if(!k.bGroupDoublePages){o.className=""}j(n.iPage1,o);j(n.iPage2,o)}return o};var l=function(q){if(q.elClonedContent!=b){var p=q.getContainer();for(var o=0;o<q.elClonedContent.length;o++){if(q.elClonedContent[o].parentNode){q.elClonedContent[o].parentNode.setAttribute("x-updated","yes");var r=p.cloneNode(true);q.elClonedContent[o].parentNode.replaceChild(r,q.elClonedContent[o]);q.elClonedContent[o]=r}}}};this.hide=function(){if(!n.bVisible){return}n.bVisible=false;k.pageContainerInner.removeChild(i)};m()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PageLinks!=b){return}a.PageLinks=function(c,r,y,k,I,O,f){var j=this;var C=r.getDebug();var F;var o,e;var E;var L=a.utils.getSVGNameSpaceURL();var B=r.getConfig();var R=1;var U=0;var H;var q;var v,i;var n;var S=function(){G()};this.destroy=function(){if(F){j.hide()}};this.getLinkContainer=function(){return F};var A={"0":"fsi-pages-link-auto-color","2":"fsi-pages-link-icon"};var G=this.createLinkShapes=function(){if(q){return}var aa=function(ay,ax){var au=ax.svg;var aC;if(!au.outerHTML){var at=0;var av=au.cloneNode(true);var az={};var aB;while(av){if(av.nodeType===1){aB=document.createElementNS(L,av.nodeName);for(var aw=0;aw<av.attributes.length;aw++){var aA=av.attributes[aw];aB.setAttribute(aA.name,aA.value)}az[at+1]=aB;if(at>0){az[at].appendChild(aB)}else{aC=aB}}if(av.firstChild){at++;av=av.firstChild}else{if(av.nextSibling){av=av.nextSibling}else{av=av.parentNode;at--;while(av&&!av.nextSibling){at--;av=av.parentNode}if(av){av=av.nextSibling}}}}}else{if(!ah){ah=document.createElementNS(L,"g")}ah.innerHTML=au.outerHTML;aC=ah.firstChild}if(aC){ax.el=aC;ax.el._FSIShape=ax;ay.appendChild(aC)}};if(!k.oCroppedImageCurrent){return}if(!r.svgTemplate){return}F=k.getSVG();if(!F){return}v=parseInt(k.oImage.width);i=parseInt(k.oImage.height);q=true;F._FSI_PAGE_INDEX=k.nIndex;if(k.oCroppedImageCurrent.isCropped()){F.setAttribute("preserveAspectRatio","xMinYMin");k.oCroppedImageCurrent.setSourceDimension(v,i);var al=k.oCroppedImageCurrent.getPixelRangeRect();F.setAttribute("viewBox",al.left+","+al.top+","+al.right+","+al.bottom);var Z=k.elSVGRect;if(Z){Z.setAttribute("x",al.left);Z.setAttribute("y",al.top);Z.setAttribute("width",al.right+al.left);Z.setAttribute("height",al.bottom+al.top)}}else{F.setAttribute("viewBox","0,0,"+v+","+i)}var ac=O.global.version;var ae="fsi-pages-link fsi-pages-link-v"+ac;var W=document.createElementNS(L,"g");W.setAttribute("class","fsi-pages-links");var ad=document.createElementNS(L,"g");if(ac){ad.setAttribute("class",ae)}else{ad.setAttribute("class",ae+" fsi-pages-link-auto-color")}var V=document.createElementNS(L,"polygon");V.setAttribute("class","fsi-pages-link-shape");var ah;var ab=O.arAreas;for(var ao=0;ao<ab.length;ao++){var ai=ab[ao];if(ai._arShapes&&ai._arShapes){var ak=ai._arShapes;var ap=ad.cloneNode(false);if(ac){if(A[ai.type]){ap.setAttribute("class",ae+" "+A[ai.type])}}W.appendChild(ap);ap._FSIArea=ai;ai.DOMElement=ap;ai.nPage=O.nPage;for(var am=0;am<ak.length;am++){var ar=ak[am];if(ar.svg){aa(ap,ar)}else{var an=ar.parsedCoords;if(an.length%2!=0){an.push(0)}var Y="";var aj=0;for(var aq=0;aq<an.length/2;aq++){var ag=parseFloat(an[aj]);var af=parseFloat(an[aj+1]);Y+=Math.round(v*ag)+","+Math.round(i*af)+" ";aj+=2}var X=ar.el=V.cloneNode(false);X.setAttribute("points",Y);X._FSIShape=ar;ap.appendChild(X)}}}}F.appendChild(W);g()};var h=function(V){if(!V||!V.tagName){return}while(!V._FSIArea&&V.parentNode&&V.tagName!=="svg"){V=V.parentNode}return V._FSIArea};var u=function(V){if(!V||!V.tagName){return}while(!V._FSIShape&&V.parentNode&&V.tagName!=="svg"){V=V.parentNode}return V._FSIShape};var P=function(V){if(!V.strCSSClass){V.strCSSClass=V.DOMElement.getAttribute("class")}return V.strCSSClass};var K=this.updateLinkVisualState=function(Z,V,Y){if(!Z){return}var W=Y;if(W==b){W=Z._state}if(Z._visualState==W){return}var X=(V&&V.target)?V.target:null;switch(W){case 0:Z.DOMElement.setAttribute("class",P(Z));if(Z._visualState){p(false,Z,X,false)}break;case 1:if(Y&&!U){U++}Z.DOMElement.setAttribute("class",P(Z)+" hover");if(!Z._visualState){p(w(Z),Z,X,true)}break;case 2:if(Y&&!U){U++}if(!Z._visualState){p(w(Z),Z,X,true)}Z.DOMElement.setAttribute("class",P(Z)+" active");break}Z._visualState=W};var x=this.setLinkNormal=function(V,W){if(o==b||o._state==0){return}if(!W){y.setActiveLinkArea(k,j,b)}U=0;r.iCallbacks.run("onLinkHover",[o,false]);o._state=0;K(o,V);o=e=b;n=a.now()};var s=function(V){var W=h(V.target);if(!W||W._state==1){return}if(o&&o.nIndex!=W.nIndex){x()}o=W;y.setActiveLinkArea(k,j,o,V);o._state=1;r.iCallbacks.run("onLinkHover",[o,true]);if(y.isFlipping()){return}K(W,V)};this.getActiveArea=function(){return o};this.noActiveArea=function(){return(!o&&(n===b||(a.now()-n)>150))};var z=function(V){if(!o||o._state==2){return}o._state=2;if(y.isFlipping()){return}K(o,V)};var T=function(V){V.pointerType="touch";H=true;if(V.touches.length>1){N(V)}else{l(V);J(V)}};var N=function(V){V.pointerType="touch";if(H&&V.touches.length==0){t(V)}H=false};var J=function(V){if(!V.pointerType||V.pointerType=="mouse"){z(V)}else{var W=h(V.target);if(!W){y.deactivateActiveLink();return}if(U>0){z(V)}}};var t=function(V){var W=h(V.target);if(!W){return}if(!V.pointerType||V.pointerType=="mouse"){s(V)}else{if(U>0){m(V)}U++;s(V)}};var l=function(V){if(y.bFlipEffectDrag){return}s(V)};var D=function(W){if(!W.pointerType||W.pointerType==="mouse"){if(o&&!W.target._FSIShape){var X=document.elementFromPoint(W.clientX,W.clientY);var V=h(X);if(V&&V.nIndex==o.nIndex){return}}U=0;x(W)}};var Q=function(V){if(V.pointerType&&V.pointerType!=="mouse"){return}m(V)};var m=function(ae){if(y.isFlipping()){return}var ad=h(ae.target);if(!ad){return}var ac=ad.nPage;var af,Z;var W=B.getHotSpotUrl(O,ad);W=B.ReplaceLinkTemplates(W);var Y=B.getHotSpotTarget(O,ad,W);if(r.iCallbacks.isset("onOpenPageLink")){var aa=r.iCallbacks.run("onOpenPageLink",[ad.nIndex,W,Y]);if(aa===false){return}if(typeof(aa)=="object"){if(typeof(aa.strURL)=="string"){W=aa.strURL}if(typeof(aa.strTarget)=="string"){Y=aa.strTarget}}}C.log("Final Hyperlink URL: ("+Y+") "+W);if(W.charAt(0)=="#"){var ab=W.toLowerCase();if(ab.indexOf("#page=")==0){af=W.split("=");if(B.bUseNamedPageNumbersExternal){af=B.getPageNumberFromString(af[1])}else{af=Math.max(0,Math.min(r.maxPage,parseInt(af[1])))}if(!isNaN(af)){c.gotoPage(af,true);return true}}if(ab.indexOf("#zoomonpage=")==0){af=W.split("=");af=af[1].split(";");if(B.bUseNamedPageNumbersExternal){Z=B.getPageNumberFromString(af[0])}else{Z=parseInt(af[0])}if(Z<0||Z>r.maxPage){return true}if(!isNaN(Z)){y.gotoPageAndZoom(Z,af[1]);return true}}if(ab=="#zoom"||ab.indexOf("#zoom=")==0||ab=="#zoomarea"){af=W.split("=");if(af.length>1){af=af[1];if(af==b||af.length<10){af="1,1,0.5,0.5,0.5,0.5"}}else{var X=u(ae.target);if(X){var V=M(X);af="1,1,"+V.xMin+","+V.yMin+","+V.xMax+","+V.yMax}else{af="1,1,0.5,0.5,0.5,0.5"}}y.gotoPageAndZoom(ac,af);return true}if(ab.indexOf("#showimage=")==0){C.error("#showimage not implemented");return false}}if(r.cfgBool("DebugLinks")){alert("Open Link #"+ad.nIndex+"\r\nTarget: "+Y+"\r\nURL "+W+"\r\nTouchClick: "+U+"\r\nEvent: "+ae.type)}if(W.length>1&&B.bFollowLinks){if(C.on){C.log("Open Link: ("+Y+") URL +"+W)}if(W.indexOf("javascript:")==0&&Y.toLowerCase()=="_self"){document.location=W}else{window.open(W,Y)}}};var M=function(X){var W=X.el.getBBox();var V={};V.xMin=W.x/v;V.yMin=W.y/i;V.xMax=V.xMin+W.width/v;V.yMax=V.yMin+W.height/i;return V};var w=function(W){var V;if(B.ParamForceLinkTip!=b){V=B.ParamForceLinkTip}else{V=W.tip;if(V==b){V=B.ParamDefaultLinkTip;if(V==b){V=false}}else{V=V.replace(/\+/g," ");V=decodeURIComponent(V)}}return V};var g=this.updateSVGStyle=function(X,Y){if(F){R=k.oImage.width/k.oCroppedImageCurrent.widthUncropped;if(X===b){X=R}if(a.isInternetExplorer||Y){var W=Math.round(10*r.nLinkStrokeWidth*X)/10;F.style.strokeWidth=W/2+"px";if(r.bLinkAntLine){var V=Math.ceil(r.nLinkStrokeDashLength*X);F.style.strokeDasharray=V+"px"}}}};var p=function(X,Y,V,W){r.showPageToolTip.apply(c,[X,Y,V,W])};j.show=function(){if(!E&&F&&f.bInteractive){if(!E){E=true;d(a.addEvent)}}if(F){F.style.display=""}};j.hide=function(){if(E&&F&&f.bInteractive){if(E){E=false;d(a.removeEvent)}}if(F){F.style.display="none"}};var d=this.addRemoveEvents=function(W,X){var V=F;if(X){V=X}if(!V){return}if(!a.isMobileDevice&&!a.isEventSupported("pointerdown")){W(V,"mouseover",l);W(V,"mouseout",D);W(V,"mousedown",J);W(window,"mouseup",t)}if(a.isEventSupported("pointerdown")){W(V,"pointerover",l);W(V,"pointerout",D);W(V,"pointerdown",J);W(V,"pointerup",t)}else{W(F,"touchstart",T);W(window,"touchend",N)}if(!a.isMobileDevice){W(V,"click",Q)}};S()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.Pages!=b){return}a.utils.API.Pages=function(d,e){var c=this;c.scriptMainFile="FSI.Pages.js";c.getActiveMenuButtons=function(){if(e.arMenuButtons==b){return b}var f={};for(var g=0;g<e.arMenuButtons.length;g++){var h=e.arMenuButtons[g].cmd;if(h!=b){f[h]=true}}return f};c.oMenuCommands={SavePage:"Save Page",PrintPage:"Print Page",FirstPage:"First Page",PreviousPage:"Previous Page",PageInputEnter:"Show Specified Page",NextPage:"Next Page",LastPage:"Last Page",ToggleBookmarkList:"Show Bookmarks",ToggleBookmark:"Add Bookmark",ToggleTableOfContents:"Table of Contents",TogglePageIndex:"Show / Hide Page Index",ToggleFullScreen:"FullScreen"};c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},clickMenuButton:{a:"strButtonID"},debugEnabled:{r:"bEnabled"},debugError:{a:"mixed"},debugLog:{a:"mixed"},debugWarn:{a:"mixed"},destroy:{},firstPage:{},getBuild:{r:"strBuild"},getConfigBoolean:{a:"strParameterName, bDefault",r:"bResult"},getConfigFloat:{a:"strParameterName, fDefault",r:"fResult"},getConfigInt:{a:"strParameterName, nDefault",r:"nResult"},getConfigString:{a:"strParameterName, strDefault",r:"strResult"},getConfigValue:{a:"strName",r:"mixed"},getContentID:{r:"strContentID"},getCurrentPageNumber:{r:"strPageNumber"},getInitDone:{r:"bInitDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getMenuButtonPresent:{a:"strButtonID",r:"bPresent"},getPageContainerDim:{r:"oDimension"},getPageLayoutData:{r:"oPageLayoutData"},getPageNumberString:{a:"nPage",r:"strPageNumber"},getParameters:{r:"oCurrentParameters"},getPluginParameter:{a:"strPluginName, strParameterName, defaultValue, bMakeBoolean",r:"mixed"},getSkinClassName:{r:"strClassName"},getTargetPage:{a:"nPage",r:"nPage"},getVersion:{r:"strVersion"},gotoPage:{a:"strPage, bAnimate"},gotoPageAndZoom:{a:"strPage, strViewstring"},gotoPageNumeric:{a:"nPage, bAnimate"},hideMenuToolTip:{},init:{a:"domElement, oParameters, bDebug"},lastPage:{},makeBoolean:{a:"mixedConvert, bDefaultValue",r:"bResult"},nextPage:{},pressMenuButton:{a:"strButtonID"},previousPage:{},printAPI:{},registerExternalMenuButton:{a:"elButton, strButtonID, strTip"},registerExternalMenuButtonsFromContainer:{a:"elContainer"},releaseMenuButton:{a:"strButtonID"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},searchForString:{a:"strKeyWords",r:"bSuccess"},setFullScreenElement:{a:"elFullScreenContainer",r:"bSuccess"},showAboutWindow:{},showMenuToolTip:{a:"strTip, elSrc, x, y"},showSearchDialog:{a:"bShow",r:"bSuccess"},start:{},testAPIListenersStart:{},testAPIListenersStop:{},togglePageIndex:{},traceConfigValue:{a:"strName"},unregisterExternalMenuButton:{a:"elButton"},unregisterExternalMenuButtonsFromContainer:{a:"elContainer"}};c.oProperties={};c.oCallbacks={onAfterRegisterExternalButton:{a:"elButton, strButtonID, bButtonPresentInViewer"},onAutoPageLayoutChange:{a:"bDoublePage"},onBookmarkAdded:{a:"nPage"},onBookmarkRemoved:{a:"nPage"},onBookmarksLoaded:{a:"strLoaded"},onBookmarksSaved:{a:"strStored"},onChangeConfig:{a:"strCfgFileName, oParameters"},onClickDemoMode:{a:"url, targetFrame"},onDestroy:{},onEnterDemoMode:{},onExitDemoMode:{},onFullScreen:{a:"bSet"},onInitFailed:{a:"strReason"},onLinkHover:{a:"oLinkData, bHover"},onMenuButtonEnabled:{a:"strButtonID, null, bEnable"},onMenuButtonPressed:{a:"strButtonID, evt"},onMenuButtonReleased:{a:"strButtonID, evt"},onMenuButtonClicked:{a:"strButtonID, evt"},onMenuButtonSetPressed:{a:"bPressed"},onMenuDestroy:{},onMenuEnabled:{a:"bEnabled"},onMenuReady:{},onOpenPageLink:{a:"nLinkAreaIndex, strURL, strTarget",r:'false or {strURL:"foo", strTarget:"foo"}'},onPageChanged:{a:"nPage, strPage, strMaxPage"},onPageLayoutChanged:{a:"oPageLayoutData"},onPageSizeChanged:{a:"nWidth, nHeight"},onPageToolTip:{a:"nLinkAreaIndex, strURL, strTipContent",r:"strModifiedToolTipContent"},onPageZoomed:{a:"nPage"},onPrintPages:{a:"arPageIndices, arImageURLs"},onReady:{},onRegisterExternalMenuButtons:{},onRemoveAllBookmarks:{},onResize:{a:"nWidth, bHheight, bResizeDone, bFullscreen"},onSearchInit:{a:"elInput"},onSearchResults:{a:"arPageNumbers, arImages"},onSearchStart:{a:"strKeyWords, strInput"},onShowBookmarkList:{a:"bShow"},onShowChapters:{a:"bShow"},onShowChaptersData:{a:"arIndexItems"},onShowPageIndex:{a:"bShow"},onShowPrintDialog:{a:"bShow"},onShowSearchDialog:{a:"bShow"},onSkinChanged:{a:"strClassName, strClassNameBefore"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Pages!==b){return}a.Pages=function(aE,d){var aW={};var bQ={strVersion:"2018",strBuild:"18.07.06.1",strConfigSection:"Pages",oTraceConfigParameters:d,bHasListeners:true};var bM=new a.utils.ClassDef(this,"FSI Pages",bQ);bM.oAPI=new a.utils.API.Pages(this,aW);var aN=bM.instance;a.utils.guessFSIViewerLocation("fsipages.js",3);var a6=a.utils.getViewerInstanceID();this.getInstanceID=aW.getInstanceID=function(){return a6};this.getInstanceName=function(){return bM.strClassName+" ["+az+"]"};var a3={};var q=new a.EmptyDebugger();var aw=function(cs,o){if(o&&!q.on&&cs.on){bF.stopPendingRequests();aN.destroy(true);aN.init(T,a3,true);aN.start();return true}q=aW.debug=cs;if(b9){b9.setDebug(q)}if(q.on){q.setPrefix(aN.getInstanceName())}};var bW=false;var S;var T;var az;var bF;var a9=0;var bG="";var be;var ck;var cg;var aq;var cq;var bd;var F;var bL;var ap,b8;var b9;var b3;var f={};aW.oCropCacheSource={};var z={};var s={};var E;var bt;var U=false;var b7;var at={};at.cursors={};var bs;var l;var ak={};var ar,K,br,bJ;var bf;var bD;var aC;var Q={};var cm,v,y;var bg;var bS;var bY,c;var ac=false;var bl;var V;var g;var cf=0;var bT={};var bv=false;var bK=0;var x;var cj,bV;var aH;var aB=false;var bZ;var a1=0;var b2=0;var Z,bB;var O;var cl;var D;var a5;var aU;var cb;var aY,bR;var m={};var cc={};var bI;var bO,aP;var a4;var bj={};var a2,ca;var aA;var W;var bN,ay;aW.bIsIOS=(a.mobileOS==="ios");this.init=function(cs,cu,o){T=cs;if(bW){aN.destroy()}if(typeof(cs)==="object"){if(typeof(cs.id)==="string"){az=cs.id}}else{if(typeof(cs)==="string"){az=cs}}if(!az){az="fsi.pages #"+a6}if(aN._fsi_parameters){cu=aN._fsi_parameters;delete aN._fsi_parameters;aN._fsi_parameters=b}if(typeof(cs)==="object"&&cs.tagName!==b){cg=cs}else{cg=document.getElementById(cs)}if(typeof(cu)==="object"&&typeof(window[cu.oninit])==="function"){window[cu.oninit](aN,az,cu)}bY=cg;a3=(cu&&typeof(cu)==="object")?a.utils.cloneParameters(cu):{};N();bE();aC=a.getElementDimension(aq);aL(true);var ct=a3;if(o){ct=a.utils.cloneObject(a3);ct.debug=true}bF.init(ct);if(q.on){q.log(aN.getVersion())}bW=true};this.getInitDone=function(){return bW};this.start=function(){bF.loadConfigs()};var aQ=function(o){if(o&&typeof(o.destroy)==="function"){o.destroy()}return b};var bA=function(){if(W!==b){W.destroy();W=b}a.FullScreen.removeChangeEvents(window,bC,aO);aW.bBookmarkIconsOnPages=aA=false;if(bJ){bJ.unregisterExternalButtons()}bo();b5();if(a4){a4.destroy();a4=aW.iChapters=b}if(bF){bF.reset()}if(b9){b9.removeConfigListeners()}cp();au();if(y!==b){a.removeCustomEvent(aq,"FSIDocumentZoomChange",ce)}if(cm!==b){a.removeCustomEvent(aq,"FSIElementDimension",cd)}cm=b;v=false;if(aP!==b){clearTimeout(aP);aP=b}a.utils.deleteInstanceCSSRules(s);for(var cs in bT){bT[cs].destroy()}g=bS=V=b;bT={};if(E){E.remove();E=b}if(bt){bt.remove();bt=b}bl=aQ(bl);bg=aQ(bg);bL=aQ(bL);bf=aQ(bf);bZ=aQ(bZ);aY=bR=b;ak={}};this.destroyOnDetach=function(){if(ak&&ak.autoDestroy!==false){I()}};var I=this.destroy=function(o){if(ck){ck.destroy()}if(bF){bF.destroy()}if(!o){cb=b}bA();bJ=aQ(bJ);if(aq){a.removeChild(aq.parentNode,aq)}aq=b;bW=false;if(b9){b9.run("onDestroy");b9.destroy()}bF.reset();ak={};if(bd){a.removeChild(bd.parentNode,bd);bd=aW.pageIndexContainer=b}};this.getContentID=aW.getContentID=function(){return bG};aW.getLayout=function(){return bS};this.getPageLayoutData=function(){if(!bS){return null}return bS.getPageLayoutData()};this.getTargetPage=function(o){return(bS)?bS.getTargetPage(o):null};this.addListener=function(cu,cs,ct){var o=false;if(b9){o=b9.addListener(cu,cs,ct)}return o};this.removeListener=function(ct,cs){var o=false;if(b9){o=b9.removeListener(ct,cs)}return o};var bE=function(){if(cb===b){cb=bF.findXMLNode(cg,"fsi-pages-intro-content")}cg.innerHTML="";aq=document.createElement("div");aq.setAttribute("draggable","false");aq.setAttribute("style","width:100%;height:100%;");cq=document.createElement("div");a.addClass(cq,"fsi-pages-content");aq.appendChild(cq);cg.appendChild(aq)};var N=function(){var o={};o.onConfigsReady=av;o.onDebuggerChange=aw;bF=aW.iConfig=new a.PagesConfig(aN,aW,null,o,{strSection:bM.strConfigSection});bF.setEffectsFilterArea();aN.loadFile=bF.loadFile;bF.cfgDefaults.listtemplate=b;if(!b9){b9=aW.iCallbacks=new a.Callbacks(aN,bF)}else{b9.setConfig(bF)}};aN.loadHTMLFragment=function(){};aW.getConfig=function(){return bF};var av=function(){if(!bF.hasPlugin("pages")){bF.addPluginFromString("pages",{})}bF.initPagesParameters();aW.bUseDevicePixelRatio=aN.getConfigBoolean("usedevicepixelratio",true);aW.nDocumentScale=a.utils.getDocumentScale();if(aW.bUseDevicePixelRatio){aW.nDocumentScalePixelRatio=a.utils.getDocumentScaleWithPixelRatio()}else{aW.nDocumentScalePixelRatio=aW.nDocumentScale}ak.pagedatatemplate=al("PageDataTemplate","catalog_page.xml");if(ak.pagedatatemplate.indexOf(".xml")===-1){ak.pagedatatemplate+=".xml"}bF.cfg.listtemplate=al("ListTemplate","image_list.json");if(bF.hasPlugin("fullscreen")&&!bF.hasPlugin("resize")){bF.addPluginFromString("resize")}S=(typeof(d.iLinkEditor)==="object");aW.iLinkEditor=d.iLinkEditor;ab()};var ab=function(){var cs=bF.readCustomPageNumbers;var o=k("customskinclass");if(ck&&ck.paramCustomSkinClass!==o){ck.destroy()}if(o!==b){if(!ck||ck.paramCustomSkinClass!==o){ck=new a.CustomSkinClass(aN,o,aW,cs)}}else{cs()}};aW.onCustomPageNumbersDone=function(){P()};var P=function(){var cs;aB=bF.hasPlugin("pagesthumbbar");y=a.addCustomEvent(aq,"FSIDocumentZoomChange",ce);a.setCustomEventListenerProperty(y,"treshold",250);if(bF.hasPlugin("resize")){if(!v){aq.style.width=aq.style.height="100%";cs=cm=a.addCustomEvent(aq,"FSIElementDimension",cd);a.setCustomEventListenerProperty(cs,"treshold",250);v=true}}else{aq.style.width=aq.offsetWidth+"px";aq.style.height=aq.offsetHeight+"px";if(v){a.removeCustomEvent(aq,"FSIElementDimension",cd);v=false}}if(aW.svgTemplate===b){var o=bF.getReloadPath(bF.locationFSIViewer,"/skins/resources/svg/fsi-pages-core.svg");bF.loadFile(o,aF,"text/html; charset=utf-8")}else{aF()}};var aF=function(cy){if(cy&&(cy.responseText||cy.response)){var cs=(cy.responseText)?cy.responseText:cy.response;var cw;var o=document.createElement("div");o.innerHTML=cs;var cu=o.firstChild;if(cu){aq.appendChild(cu);var cv=aW.svgTemplate=cu.cloneNode(true);aq.appendChild(cv);o=cv.getElementById("gradients");cv.removeChild(o);aW.svgTemplateWithRect=aW.svgTemplate.cloneNode(true);if(al("BendEffect","glossy").toLowerCase()==="none"){cw=cv.getElementById("bend-effect");if(cw){cv.removeChild(cw)}}aq.removeChild(cv);cu.setAttribute("style","position:absolute;width:0px;height:0px;visibility:hidden:z-index:-1");cw=cu.getElementById("bend-effect");if(cw){cu.removeChild(cw)}}}var cz=al("skin","black");if(b7!==cz){U=false;b7=cz}q.log("Loading skin: "+cz+".css");if(E){E.remove();E=b}if(!U){var cx=at.className;at.name=cz;at.className="fsi-skin-"+at.name;ap=".fsi-pages-root.fsi-pages-instance-"+a6;b8="fsi-root fsi-pages-root fsi-pages-instance-"+a6;if(a.isMobileDevice){b8+=" fsi-mobile"}b4();aq.className=b8+" "+at.className;var ct=[{file:"resources/fsi-core.css",nPriority:1},{file:"resources/fsi-pages-core.css",nPriority:5}];E=a.utils.loadSkinCSS(cz,aN,M,10,ct);if(cx!==at.className){b9.runPersistent("onSkinChanged",[at.className,cx])}}else{b4();M(U)}};this.getSkinClassName=function(){return at.className};aW.getBaseCSSSelector=function(){return ap};aW.getBaseCSSClass=function(){return b8};var bi=aW.getCurrentPageNumberNumeric=function(){return bS.getCurrentPage()+a1};var aI=aW.getCurrentPageNumber=this.getCurrentPageNumber=function(){return bF.getPageNumberString(bS.getCurrentPage())};var M=function(o,ct){cc.hideUI=false;if(al("DemoURL","").length>0){cc.hideUI=aR("hideuiindemomode",true);aj()}else{au()}E=b;if(o){q.log("Skin loaded successfully. ")}else{l={hMenuBar:0};q.error("Failed to load skin.")}if(ct){G(ct)}else{at._nameParsedLast=b}if(bF.hasPlugin("chapters")){var cs={};cs.onReady=J;cs.elContainer=aq;a4=aW.iChapters=new a.PagesChapters(aN,aW,cs);a4.init()}else{bn()}};var J=function(o){if(!o){a4.destroy();a4=aW.iChapters=b}bn()};var a0=function(cw,o,cs){var cu,ct;cu=al(cw);if(cu!==b){cu=a.utils.rgbaHexToDecimal(cu);ct="stroke:rgba("+cu.strRGBA+");";if(cs>0){ct+="fill:rgba("+cu.strRGBA+");fill-opacity:"+cs+";"}var cv=ap+" .fsi-pages-linkcontainer .fsi-pages-link"+o+".fsi-pages-link-auto-color";cv=cv+", "+cv+" *";a.utils.addInstanceCSSRule(s,cv,ct)}};var b4=function(){a.utils.deleteInstanceCSSRules(s);var o=aN.getConfigInt("linkFillAlpha",0)/100;a0("LinkRGBANormal","",o);a0("LinkRGBAHover",".hover",o);a0("LinkRGBAActive",".active",o)};var G=function(cs){if(at._nameParsedLast!==at.name){at._nameParsedLast=at.name;var cz=document.createElement("div");cz.style.position="absolute";cz.style.top="0px";cz.style.left="0px";cz.style.width="1px";cz.style.height="1px";cz.style.overflow="hidden";cz.style.visibility="hidden";var ct=document.createElement("div");cz.appendChild(ct);aq.appendChild(cz);var cB={};var cw=function(cJ,cG,cE,cD,cF){var cC,cI;if(cB[cJ]===b){ct.className=cJ;cI=cB[cJ]=getComputedStyle(ct,cF)}else{cI=cB[cJ]}cC=cI.getPropertyValue(cG);if(cD){cC=cC.replace(/^[^{]*/g,"");cC=cC.replace(/[^}]*$/g,"");cC=cC.replace(/\\"/g,'"');if(cC.length>0){try{cC=JSON.parse(cC)}catch(cH){a.console.error("ERROR parsing JSON from CSS selector '"+cJ+"' property '"+cG+"'.");a.console.error(cH.message)}}else{cC={}}}if(cC===b){cC=cE}return cC};l=cw("fsi-ui-info","content",b,true,":before");l.hMenuBar=cw("fsi-ui-menu-bar","height");at.urlLogo=cw("fsi-ui-logo-image","background-image");if(typeof(at.urlLogo)==="string"){var cy=/url\(\s*["']?([^"')]*)["']?\s*\)/;var o=cy.exec(at.urlLogo);if(o&&o.length>0){at.urlLogo=o[1]}}var cA=16;var cv=8;if(l){if(!isNaN(l.baseSize)&&l.baseSize>0){cA=l.baseSize}if(!isNaN(l.baseEnlargement)&&l.baseEnlargement>0){cv=l.baseEnlargement}}else{l={}}if(aR("LinkAntLineAnimation",true)){cz.className="fsi-pages-linkcontainer-interactive";var cu=cw("fsi-pages-link hover","animation");if(typeof(cu)!=="string"||cu.length<1){cu=cw("fsi-pages-link hover","-webkit-animation")}if(typeof(cu)!=="string"||cu.length<1){cu=cw("fsi-pages-link hover","animationName")}if(typeof(cu)!=="string"){cu=""}aW.bLinkAntLine=(cu.indexOf("fsipagesbaseLinkAnimation")===0)}aW.nLinkStrokeWidth=parseFloat(cw("fsi-pages-link","stroke-width"));if(isNaN(aW.nLinkStrokeWidth)){aW.nLinkStrokeWidth=2}aW.nLinkStrokeDashLength=parseFloat(cw("fsi-pages-link","stroke-dasharray"));if(isNaN(aW.nLinkStrokeDashLength)){aW.nLinkStrokeDashLength=6}var cx=1;if(a.isMobileDevice&&ak.adaptiveUISize===true){cx=a.getDevicePixelRatio()}bs=Math.round(cA+cv*cx);l._baseSkinSize=bs;aq.removeChild(cz)}aq.style.fontSize=bs+"px"};aW.roundDocumentScale=function(o){if(o>0.9&&o<1.2){o=1}return Math.ceil(2*o)/2};var bn=function(){if(typeof(l.hMenuBar)!=="string"||l.hMenuBar.length<1||isNaN(parseFloat(l.hMenuBar))){ar=false}else{ar=(aR("HideUI")!==true)}b1()};var bh=function(){if(bf!==b){bF.loadLanguageFile(f,al("language"),bX,q)}};var bX=function(cs,o){bD=cs;bf.setContent(bD);if(W){W.onLanguageDataReady()}};var b1=function(){if(bf===b){if(a.getViewerLocation()!==b){bf=new a.ToolTip(aq)}}bh();if(bJ===b||!U){bJ=aQ(bJ);bJ=new a.MenuBar(aW,at,aq,ax,bM.oAPI.oMenuCommands);bJ.setCallbacks(b9)}else{if(U&&bJ){bJ.setInterface(aW)}ax()}};var ax=function(){if(!ar){bJ.removeDomElement()}K=bJ.getHeight();if(cc.bEnabled&&cc.hideUI){bJ.show(false)}aD(K);cn();n()};var aD=function(o){if(cc.hideUI&&cc.bEnabled){br=0}else{if(l&&l.bFloatingMenuBar){br=0}else{br=o}}ba()};this.getParameters=function(){return a.utils.cloneParameters(a3)};this.getConfigValue=function(o){if(bF&&typeof(o)==="string"){return bF.cfg[a.trim(o.toLowerCase())]}};this.makeBoolean=function(cs,o){if(bF){return bF.makeBool(cs,o)}};this.getPluginParameter=function(cu,ct,cs,o){if(bF){return bF.getPluginParameter(cu,ct,cs,o)}};this.changeConfig=function(o,cs){b9.runPersistent("onChangeConfig",[o,cs]);if(q.on){a.console.log("")}U=true;bA();if(cs!==null&&typeof(cs)==="object"){a3=a.utils.cloneParameters(cs)}if(typeof(o)==="string"){a3.cfg=o}N();bF.init(a3);aN.start()};this.getPageContainerDim=function(){var ct=br;if(g&&g.bLayoutVisible){ct+=ai()}var o=cq.clientWidth;var cs=cq.clientHeight;return{width:o,height:cs-ct}};var w=function(){var o=false;if(a.FullScreen){o=a.FullScreen.getElement()}return(o&&o!==c)};aW.registerLayout=function(o){if(o.nLayoutID!==b){q.error("Layout already registered");return}o.nLayoutID=++a9;bT[o.nLayoutID]=o};aW.unregisterLayout=function(o){if(o.nLayoutID===b){q.error("Failed to unregister Layout: "+o.name);return}bT[o.nLayoutID]=b;delete (bT[o.nLayoutID]);o.nLayoutID=b};var ce=function(cs){if(aP===b){for(var ct in bT){bT[ct].onStartDocumentZoom(cs)}}else{clearTimeout(aP)}aP=setTimeout(aX,250);bO=cs;aW.nDocumentScale=cs.FSI_scale;aW.nDocumentScalePixelRatio=(aW.bUseDevicePixelRatio)?cs.FSI_scale_with_pixel_ratio:cs.FSI_scale};var aX=function(){aP=b;for(var cs in bT){bT[cs].onAfterDocumentZoom(bO)}};var cd=this.onResize=function(cs){if(w()){return}aC=a.getElementDimension(aq);if(!D){bp();if(a4){a4.onResize()}}D=(cs&&!cs.FSI_after_treshold);if(!D){e()}if(W){W.onResize(cs)}for(var ct in bT){bT[ct].onResize(cs)}aL(cs.FSI_after_treshold)};var aL=function(o){b9.runPersistent("onResize",[aC.width,aC.height,(o!==b),ac])};var bz=function(){if(g&&bF.getPluginParameter("pagesthumbbar","autohide",true,true)){var o=((cc.bEnabled&&cc.hideUI)||aq.offsetHeight<600);if(o!==bv){bv=o;if(o){g.lockShow("autoShowHideThumbbar")}else{g.unlockShow("autoShowHideThumbbar")}}}};var e=function(){bz();if(bZ){if(aq.offsetWidth<500){bZ.hide()}else{bZ.show()}}if(bJ){bJ.setContainerSize(aC)}if(a5&&!D&&bS&&aq.offsetWidth>100){var o=bb();if(cl.pageOptions.bGroupDoublePages!==o){cj=cl.pageOptions.bGroupDoublePages=o;cl.initialPageIndex=bS.getCurrentPage();var cs=bS.getShowState();bS.destroy();u();bS.restoreShowState(cs);b9.runPersistent("onAutoPageLayoutChange",[o])}}};aW.getDoublePageModeConfig=function(){return bV};aW.getDoublePageMode=function(){if(!bS){return true}return cl.pageOptions.bGroupDoublePages};var bb=function(){if(bS){return bS.getAutoDoublePageMode()}return true};var aS=this.getPageNumberString=function(o){return bF.getPageNumberString(o)};var ao=function(cs,o){if(!o){if(g){g.setSelectedPage(cs);g.gotoPage(cs,true)}if(!bN!==b){localStorage.setItem(bN,cs);if(ay!==b){localStorage.setItem(ay,L())}}bq()}if(bZ){bZ.blur();if(cl.pageOptions.bGroupDoublePages){cs=Math.max(a1,cs-cs%2)}bZ.onPageChange(aS(cs),aS(O+a1-1))}if(bl){aW.updateAddBookmarkButton(cs)}b9.runPersistent("onPageChanged",[cs,aS(cs),aS(O+a1-1)])};var bq=function(){var cs=bS.getCurrentPage();var ct=1;if(cj){cs-=cs%2;ct=2}var o=(cs<2);if(o!==aY){aY=o;Y("FirstPage",!o);Y("PreviousPage",!o)}o=(cs>=O+a1-ct);if(o!==bR){bR=o;Y("LastPage",!o);Y("NextPage",!o)}};aW.updateAddBookmarkButton=function(o){if(!bS){return}if(o===b){o=bS.getCurrentPage()}var cs=bl.isPageBookmarked(o);if(cs!==bl.bCurrentPageIsBookmarked){bl.bCurrentPageIsBookmarked=cs;if(cs){bJ.addButtonCSSClass("ToggleBookmark","remove-bookmark")}else{bJ.removeButtonCSSClass("ToggleBookmark","remove-bookmark")}}};this.showMenuToolTip=function(ct,cs,o,cu){if(bJ){bJ.showToolTip(ct,cs,o,cu)}};this.hideMenuToolTip=function(){if(bJ){bJ.hideToolTip()}};var a7=function(o){g.setOption("bLazyScroll",false);j(o.nIndex,true);g.resetOption("bLazyScroll")};var ai=function(){if(!g||!g.bLayoutVisible){return 0}return g._totalHeight};aW.showThumbBar=function(o){if(g){if(o){g.unlockShow("Zoom")}else{g.lockShow("Zoom")}}};var t=function(o){if(!aB){return}var ct={};var cs=bF.getPluginParameter("pagesthumbbar","height",80);cs=parseInt(cs);if(isNaN(cs)||cs<10){cs=80}ct.imageOptions={};if(al("effects")!==b){ct.imageOptions.effects=al("effects")}ct.elContainer=aq;ct.pageOptions={bInteractive:false,bImageOnly:true,bGroupDoublePages:bV,bPageNumbers:bF.getPluginParameter("pagesthumbbar","PageNumbers",true,true)};ct.alignMode=1;ct.bQuantize=true;ct.nConcurrentImageLoad=12;ct.name="ThumbnailBar";ct.bLazyScroll=true;ct.onPageClick=a7;ct.bSelectFirstPage=true;ct.strContainerClass="fsi-pages-thumbbar";ct.bHorizontal=true;ct.initialPageIndex=o;ct.thumbWidth=aq.clientWidth;ct.thumbHeight=cs;ct.onShowHide=ba;g=new a.PageLayoutGrid(aN,aW,b3,bF,ct);if(aA){g.onFinishPage=bx}g.init();g.dimMargins=a.getElementMargins(g.pageContainer);g._height=g.hItem;g._totalHeight=g.dimMargins.top+g.dimMargins.bottom+g._height;g.pageContainer.style.top="auto";g.pageContainer.style.bottom=cf+"px";g.pageContainer.style.height=g._height+"px";bz()};var n=function(){var ct=bF.getImageList();aW.bListWithDimensionLoaded=false;if(typeof(ct)==="object"&&typeof(ct.arImages)==="object"&&ct.arImages.length>0){if(!ct.images){ct.images=[];for(var cs=0;cs<ct.arImages.length;cs++){ct.images[cs]={src:ct.arImages[cs],fullImagePath:ct.arImages[cs],file:"[src]"}}}aa(ct.arImages,ct)}else{var o=al("dir");if(o!==b){aW.bListWithDimensionLoaded=true;bF.loadImageList(o,aa)}}};aW.getImageDimFitInto=function(cs,cB,cA,cz,ct,cy){var cw={};var cv=cs;var cu=cB;if(!cy){cA=Math.min(cs,cA);cz=Math.min(cB,cz)}var cx=ct&&ct.isCropped();if(cx){ct.setSourceDimension(cs,cB);var o=ct.getPixelRangeRect();cs=o.right;cB=o.bottom}if(cs/cA>cB/cz){cw.width=cA;cw.height=Math.round(cB/cs*cA)}else{cw.height=cz;cw.width=Math.round(cs/cB*cz)}if(cx){cw.widthUncropped=Math.round(cw.width*cv/cs);cw.heightUncropped=Math.round(cw.height*cu/cB)}else{cw.widthUncropped=cw.width;cw.heightUncropped=cw.height}return cw};var am=function(ct,o){if(ct.oContainer.nIndex!==bS.getCurrentContainerIndex()){j(ct.nIndex,true)}else{if(cl.bOneClickZoom){if(!bS.bFlipping&&!bS.bZoomed){var cs=ct.getLinksInstance();if(!cs||cs.noActiveArea()){bS.clickZoomPage(o)}}}}};var ba=function(){cf=br+ai();cq.style.paddingBottom=cf+"px";if(g){g.pageContainer.style.bottom=br+"px"}};var L=function(){return new Date().getTime()};var aZ=function(){var cu;var ct;if(typeof(window.localStorage)!=="undefined"&&aR("RememberLastViewedPage",false)){var cs=bu("RememberLastViewedPageExpireAfter",0);if(cs<0){cs=0}bN=aW.getContentID()+"_initialPage";ay=b;ct=parseInt(localStorage.getItem(bN));if(!isNaN(ct)){cu=ct;if(cs>0){ay=bN+"_time";ct=parseInt(localStorage.getItem(ay));if(!isNaN(ct)&&((L()-ct)/1000)>cs){cu=b;localStorage.removeItem(bN);localStorage.removeItem(ay)}}}}if(cu===b){cu=bu("initialPage",1)}var cw={};cf=br;t(cu);ba();if(!bd){bd=aW.pageIndexContainer=document.createElement("div");a.addClass(bd,"fsi-pages-page-index-container");bd.style.paddingBottom=br+"px";aq.appendChild(bd)}cw.imageOptions={};if(al("effects")!==b){cw.imageOptions.effects=al("effects")}if(a5){cj=bb()}cw.elContainer=cq;ct=bF.cfg.listtemplate;var o=(typeof(ct)==="string"&&ct.indexOf("image_list")!==0);o=aR("Links",o);cw.pageOptions={bInteractive:true,bImageOnly:!o,bGroupDoublePages:cj,bPageNumbers:aR("PageNumbers",false)};cw.bHorizontal=!aR("VerticalLayout",false);cw.bCenterContent=true;cw.bOnePageInView=aR("OnePageInView",true);cw.bOneClickZoom=aR("OneClickZoom",false);cw.ShowNeighbourPages=bu("ShowNeighbourPages",0);cw.ScrollItemMinimumSpacing=bu("ScrollItemMinimumSpacing",12);cw.onCurrentPageChange=ao;cw.trackCurrentPageWhileScrolling=true;cw.thumbWidth=cw.thumbHeight="auto";cw.initialPageIndex=cu+a1-1;cw.strContainerClass="fsi-pages-main-view";cw.bFocusCurrentPage=false;cw.onPageClick=am;cw.bMainLayout=true;cw.alignMode=1;cw.bSingleColumn=true;cw.bQuantize=true;cw.dropShadow=aR("dropShadow",true);if(cw.dropShadow){cw.dropShadowOpacity=r("dropShadowOpacity");cw.dropShadowDistance=r("dropShadowDistance",50)/100}cw.enableZoom=aR("zoom",true);if(cw.enableZoom){var cx=r("maxZoom",100)/100;if(isNaN(cx)||cx<=0){cx=1}cw.fMaxZoom=cx}cw.nCreateAhead=(a.isMobileDevice)?1:1.5;cw.bAutoSelectCurrentPage=true;cl=cw;aW.maxPage=b3.images.length;if(a1>0&&b3.images.length>0){var cv=bF.getUnrecognizedConfigNode("FSIPagesIntroContent");if(cv===b&&cb){cv=cb}if(cv&&typeof(cv)==="object"){cv=a.trim(cv.innerHTML);if(cv.length>0){b3.images[0].htmlContent=cv}}}u();e();bJ.setEnabled(true)};var u=function(){cl.name="Main";bS=new a[x](aN,aW,b3,bF,cl);if(S){bS.onFinishPage=d.iLinkEditor.onPageReady}else{if(aA){bS.onFinishPage=bx}}bS.init();F=bS.pageContainer};var bx=function(o){if(!aA||!bl.isPageBookmarked(o.nIndex)||!o.bRealPage){return}o.iLayout.showBookmarkIconOnPage(o.nIndex,true,bI)};var X=aW.showBookmarkIconOnPage=function(cs,o){if(!aA){return}if(bS){bS.showBookmarkIconOnPage(cs,o,bI)}if(g){g.showBookmarkIconOnPage(cs,o,bI)}};this.gotoPageAndZoom=function(o,cs){if(bS){bS.gotoPageAndZoom(o,cs)}};this.gotoPage=function(ct,cs){var o=bF.getPageNumberFromString(ct);return R(o,cs)};var j=aW.gotoPageByIndex=function(o,cs){b0();bS.gotoPage(o,cs)};var R=this.gotoPageNumeric=function(o,cs){if(isNaN(o)){return false}return j(o-1+a1,cs)};aW.getFrontCoverIndex=function(){return Z};aW.getBackCoverIndex=function(){return bB};aW.getFakePagesStart=function(){return a1};aW.getFakePagesEnd=function(){return b2};aW.getRealPages=function(){return O};var bw=aW.sortNumeric=function(cs,o){return cs.nPage-o.nPage};var bk=function(o){b9.runPersistent("onInitFailed",[o])};var aa=function(cw,cy,cA){var cH,cv,cs,cB;a1=b2=0;if(cy.images===b){cy.images=[]}if(cy.images.length<1){bk("image list is empty")}b3=cy;b3._arImages=cw;bG=al("UniqueID","");if(bG.length<1){if(b3._arImages.length>0){bG=bF.getImageURL(b3._arImages[0])}}var cx=al("removepages","");if(cx.length>0){cx=cx.split(",")}if(cx.length>0){cx.sort(bw);for(cB=cx.length-1;cB>-1;cB--){cH=cx[cB]-1;if(cH>-1&&cH<b3.images.length){b3.images.splice(cH,1);cw.splice(cH,1)}}}var cD=al("emptyimages","");if(cD.length>0){cD=cD.split(",")}if(cD.length>0){cD.sort(bw);for(cB=0;cB<cD.length;cB++){cH=cD[cB]-1;if(cH>-1&&cH<b3.images.length){b3.images.splice(cH,0,{type:"blank"});cw.splice(cH,0,null)}}}var cC=aR("FrontCover",true);var cE=aR("BackCover",true);var cG=false;cs=al("FrontCoverImage","");if(cs.length>0){cv={src:cs,fullImagePath:cs};b3.images.unshift(cv);b3._arImages.unshift(cs)}else{cG=aR("BlankFrontCover")}var cI=false;cs=al("BackCoverImage","");if(cs.length>0){cv={src:cs,fullImagePath:cs};b3.images.push(cv);b3._arImages.push(cs)}else{cI=aR("BlankBackCover")}O=b3.images.length;Z=bB=b;if(cC){Z=1;if(cG){b3.images.unshift({type:"blank"});b3._arImages.unshift(null);O++}b3.images.unshift({});b3._arImages.unshift(null);a1++}if(cE){if(cI){b3.images.push({type:"blank"});b3._arImages.push(null);O++}if((O+a1)%2===0){b3.images.push({type:"blank"});b3._arImages.push(null);O++}bB=b3.images.length-1;if((O+a1)%2!==0){b3.images.push({});b3._arImages.push(null);b2++}}else{if((O+a1)%2===1){b3.images.push({type:"blank"});b3._arImages.push(null);O++}}if(O<1){q.error("No images to display.");return}if(Z!==b){b3.images[Z].cssClass="frontcover"}if(bB!==b){b3.images[bB].cssClass="backcover"}bK=b;for(cB=0;cB<b3.images.length;cB++){if(b3.images[cB].src!==b){if(bK!==b){bK=cB;break}else{bK=cB}}}cj=bV=aR("DoublePageMode",true);a5=(cj&&aR("AutoDoublePageMode",true));x="PageLayoutGrid";var cz=al("PageLayout","flip").toLowerCase();if(cz==="flip"){x="PageLayoutFlip";var cF=al("PageBackFaceImage","");bj={bImageOnly:true,bNoBendEffect:true,cssClass:"fsi-pages-page-back-face"};if(cF.length>0){bj.src=bj.fullImagePath=cF}else{bj.type="blank"}}if(x==="PageLayoutFlip"){b3.images[-1]=bj;b3._arImages[-1]=bj.fullImagePath}aT();if(isNaN(aU.width)||isNaN(aU.height)){aU=b;if(bK===b){q.error("No image to measure aspect ratio of pages.")}else{var cu=b3.images[bK];var ct=bF.getImageInfoURL(cu.fullImagePath);bF.loadFile(ct,ae)}}else{H()}};var ae=function(ct,o){var cs=b3.images[bK];cs.width=parseInt(o.width);cs.height=parseInt(o.height);aT();if(isNaN(aU.width)||isNaN(aU.height)){q.error("Failed to measure page aspect ratio.")}else{H()}};var H=function(){if(bF.hasPlugin("bookmarks")){bP()}aZ();bL=new a.PageToolTip(aq,aW);aW.oImageList=b3;h();cc.bRestore=false};var aj=function(){if(cc.bEnabled){return}cc.bEnabled=true;if(bS){bS.zoom(false,false)}aN.hideMenuToolTip();bp();if(bJ&&cc.hideUI){bJ.show(false);aD(0)}a.addClass(aq,"fsi-demo-mode");a.addEvent(cg,"click",ch);var o=bF.cfg.demotooltip;if(!a.isMobileDevice&&typeof(o)==="string"&&o.length>0){cc.bToolTip=true;cc.strTip=o;a.addEvent(cg,"mousemove",aG);a.addEvent(cg,"mouseout",ag)}else{cc.strTip="";cc.bToolTip=false}b9.runPersistent("onEnterDemoMode")};var aG=function(o){if(!cc.oToolTip){if(aW.getToolTip()){cc.oToolTip=aW.getToolTip();cc.bDestroyToolTip=false}else{cc.oToolTip=new a.ToolTip(aq);cc.oToolTip.setContent({});cc.bDestroyToolTip=true}}var cs=a.getElementClientPos(aq);cc.oToolTip.show(cc.strTip,null,o.clientX-cs.left,o.clientY-cs.top,b,100,true)};var ag=function(){if(cc.oToolTip){cc.oToolTip.hide()}};var au=function(){if(!cc.bEnabled){return}cc.bEnabled=false;aW.onUserAction();if(bJ&&cc.hideUI){bJ.show(true);aD(K)}a.removeClass(aq,"fsi-demo-mode");a.removeEvent(cg,"click",ch);if(cc.bToolTip){a.removeEvent(cg,"mousemove",aG);a.removeEvent(cg,"mouseout",ag);cc.oToolTip.hide();if(cc.bDestroyToolTip){cc.oToolTip.destroy();cc.oToolTip=b}}b9.runPersistent("onExitDemoMode")};var ch=function(){if(!cc.bEnabled){return}var cs=al("DemoURL");var ct=al("DemoURLTarget","_self");var o=b9.run("onClickDemoMode",[cs,ct]);if(o===false){return}if(cs==="no action"){return}if(cs==="enter fullscreen"){cc.bRestore=true;if(bF.hasPlugin("fullscreen")){aW.clickMenuButton("ToggleFullScreen",b,true)}}else{window.open(cs,ct)}};var h=function(){be=aW.bAutoFlipCrop=aR("AutoFlipCropRect",true);if(typeof(bF.cfg.fullscreenelement)!=="undefined"){bY=bF.cfg.fullscreenelement}else{bY=cg}bJ.setEnabled(true,true);aV();b9.runPersistent("onReady");if(W){W.onDataComplete()}if(S){d.iLinkEditor.onPagesReady(aN,aW,b8)}};var aV=function(){if(aR("IdleAutoTurn",false)){var o=bS.getTargetPage(bS.nMaxPageIndex);var ct=bu("IdleAutoTurnMaxPage",o);m.nMaxPage=Math.min(o,ct);ct=bu("IdleAutoTurnMinPage",1);m.nMinPage=Math.max(1,ct);if(m.nMinPage>m.nMaxPage){ct=m.nMinPage;m.nMinPage=m.nMaxPage;m.nMaxPage=ct}var cs=r("IdleAutoTurnDelay",1.5);var cu=Math.ceil(cs*1000);if(!isNaN(cu)&&cu>0){m.bForward=(bS.getTargetPage(bS.nCurrentPage)<m.nMaxPage);m.nInterval=setInterval(A,cu)}}};aW.onUserAction=function(){cp()};var cp=function(){if(m.nInterval===b){return}clearInterval(m.nInterval);m.nInterval=b};var A=function(){var o=bS.getTargetPage(bS.nCurrentPage);if(o<=m.nMinPage||o>=m.nMaxPage){m.bForward=(o<m.nMaxPage)}if(m.bForward){aN.nextPage()}else{aN.previousPage()}};z.onPageToolTip=function(cs,o){o[2]=cs;return cs};var aJ=aW.showPageToolTip=function(cu,cv,o,cs){if(typeof(cu)==="string"&&cu.length<1){cu=false}if(bL){if(b9.isset("onPageToolTip")){if(cu===false){b9.run("onPageToolTip",[false])}else{var ct=b9.run("onPageToolTip",[cv.nIndex,cv.url,cu]);if(typeof(ct)==="string"){cu=ct}}}bL.show(cu,cv,o,cs)}};var bp=aW.hideToolTip=function(){if(bL){bL.hide();b9.runPersistent("onPageToolTip",[false])}};var p=aW.getMeasurePageIndex=function(){return bK};var aT=aW.getPageAspectRatio=function(){if(aU){return aU}aU={};var cx=al("Ratio","auto");var cs=true;if(typeof(cx)==="string"&&cx.toLowerCase()!=="auto"){cx=cx.split(":");if(cx.length===2){cx[0]=parseFloat(cx[0]);cx[1]=parseFloat(cx[1]);if(!isNaN(cx[0])&&cx[0]>0&&!isNaN(cx[1])&&cx[1]>0){cs=false;aU.width=100000*cx[0];aU.height=100000*cx[1]}}}if(cs){var o,cw;var cv=p();var cu=b3.images[cv];if(cu){o=cu.width;cw=cu.height}bU(cv-a1,o,cw);var ct=new a.CroppedImage();ct.setSourceDimension(o,cw);ct.setCropFromConfig(bF.cfg);if(ct.isCropped()){var cy=ct.getPixelRangeRect();o=cy.right;cw=cy.bottom}aU.width=o;aU.height=cw}return aU};var bU=function(ct,o,cs){if(aH||o===b){return}aH=true;q.log("auto page aspect ratio from image #"+(ct+1)+": "+o+" : "+cs)};this.showAboutWindow=function(){if(bg){bg.destroy();bg=b;return}var o={};o.title="About FSI Pages";o.fnOnDestroy=b6;o.strLongVersion=aN.getVersion();bg=new a.AboutWindow(aq,o)};var b6=function(){if(bg){bg=b}return true};this.setFullScreenElement=function(o){if(ac){aM();a.FullScreen.quit()}bF.cfg.fullscreenelement=o};var aO=function(){q.error("ERROR entering FullScreen")};var bC=function(o){aM()};var aM=function(o){var cs=a.FullScreen.getEnabled();if(cs&&w()){return}if(cs===ac){return}a.setCustomEventListenerProperty(cm,"skiptreshold",true);if(bJ){bJ.setButtonPressed("ToggleFullScreen",cs)}b9.runPersistent("onFullScreen",[cs]);ac=cs;if(bg){aN.showAboutWindow()}if(cs===true){a.addClass(c,"fsi-fullscreen-element")}else{a.removeClass(c,"fsi-fullscreen-element")}if(!cs){c=b}if(cs){au()}else{if(cc.bRestore){aj();aV()}}};var aK=function(o){j(o.nIndex,true)};aW.getCurrentPageRange=function(){var o=aN.getTargetPage(bS.nCurrentPage);var cs=bF.getPageNumber(o);if(cl.pageOptions.bGroupDoublePages&&o!==Z&&o+1<bS.nMaxPageIndex){cs=cs+"-"+(cs+1)}return""+cs};aW.getMinMaxRealPages=function(){return{nMin:a1,nMax:bS.nMaxPageIndex}};var bP=function(){bI=document.createElement("div");bI.className="fsi-pages-bookmark-icon";var o={bDoublePages:bV};bl=new a.PagesBookmarks(aN,aW,b3,o);aW.bBookmarkIconsOnPages=aA=bl&&bF.getPluginParameter("bookmarks","showIconsOnPages",true,true)};aW.getLanguageString=function(cs,o){if(bD&&bD[cs]){return bD[cs]}else{return o}};var ad=aW.hideBookmarks=function(){if(bl&&bl.getVisible()){a8()}};var bm=function(o){if(!bl){return}var cw=bS.getCurrentPage(false);var ct=bl.toggleBookmark(cw);var cv=bS.getCurrentContainer();if(cv.iPage1){X(cv.iPage1,ct)}if(cv.iPage2){X(cv.iPage2,ct)}var cs=(ct)?"Bookmark added":"Bookmark removed";var cu;if(o===b){cu=bJ.getButtonDomElement("ToggleBookmark")}else{cu=o.target;while(cu.parentNode&&!a.hasClass(cu,"fsi-ui-button")&&!a.hasClass(cu,"fsi-root")){cu=cu.parentNode}}bf.show(cs,cu,b,b,b,0);bf.hideAfter();aW.updateAddBookmarkButton(cw)};var a8=function(){if(bl===b){return}var o=!bl.getVisible();if(o){b0();if(g){g.lockShow("PageIndex")}bS.lockShow("PageIndex")}else{if(g){g.unlockShow("PageIndex")}bS.unlockShow("PageIndex")}ah(!o);bl.show(o);bJ.setButtonPressed("ToggleBookmarkList",o);bJ.enableButton("ToggleBookmark",!o)};var bc=function(){if(a2!==b){bo();bJ.setButtonPressed("PrintPage",false)}else{b5();a2=new a.PagesPrintDialog(aN,aW,b3);b9.runPersistent("onShowPrintDialog",[true])}};var bo=aW.closePrintDialog=function(){if(a2!==b){bJ.setButtonPressed("PrintPage",false);a2.destroy();a2=b;b9.runPersistent("onShowPrintDialog",[false])}};var i=function(){if(ca!==b){b5();bJ.setButtonPressed("SavePage",false)}else{bo();ca=new a.PagesSaveDialog(aN,aW,b3);b9.runPersistent("onShowSaveDialog",[true])}};var b5=aW.closeSaveDialog=function(){if(ca!==b){bJ.setButtonPressed("SavePage",false);ca.destroy();ca=b;b9.runPersistent("onShowSaveDialog",[false])}};var co=function(){ad();if(V){C()}if(a4){a4.toggle()}};var ah=function(o){bJ.enableButton("ZoomPage",o);bJ.setButtonPressed("ZoomPage",bS.bZoomed)};var C=aN.togglePageIndex=function(){var o;if(V){if(g){g.unlockShow("PageIndex")}bS.unlockShow("PageIndex");o=false;V.destroy();V=b;ah(true);b9.runPersistent("onShowPageIndex",[false])}else{ad();ah(false);bS.cancelScrolling();bS.disableActiveLink();o=true;var cs={};cs.initialPageIndex=bS.getCurrentPage();if(g){g.lockShow("PageIndex")}bS.lockShow("PageIndex");cs.imageOptions={};if(al("effects")!==b){cs.imageOptions.effects=al("effects")}cs.elContainer=bd;cs.pageOptions={bInteractive:false,bImageOnly:true,bGroupDoublePages:bV,bPageNumbers:true};cs.bSelectFirstPage=true;cs.nScrollAnimationFrames=12;cs.nCreateAhead=0.2;cs.bScrollToCurrentTopPageAfterResize=true;cs.name="Index";cs.nConcurrentImageLoad=24;cs.onPageClick=aK;cs.strContainerClass="fsi-pages-thumbindex fsi-pages-scrollbar";cs.bCenterContent=true;var ct=bu("ThumbSize",160);cs.thumbWidth=cs.thumbHeight=Math.max(80,ct);V=new a.PageLayoutGrid(aN,aW,b3,bF,cs);if(aA){V.onFinishPage=bx}V.init();b9.runPersistent("onShowPageIndex",[true])}bJ.setButtonPressed("TogglePageIndex",o)};var k=aW.getConfigVal=function(cu,ct,o){cu=cu.toLowerCase();if(ak[cu]!==b){return ak[cu]}var cs=bF.cfg[cu];if(cs===b){cs=bF.getPagesParameter(cu);if(cs===b){cs=ct}}switch(o){case 1:cs=bF.makeBool(cs,ct);break;case 2:cs=parseInt(cs);if(isNaN(cs)){cs=ct}break;case 3:cs=parseFloat(cs);if(isNaN(cs)){cs=ct}break}ak[cu]=cs;return cs};this.debugLog=function(){q.log.apply(q,arguments)};this.debugWarn=function(){q.warn.apply(q,arguments)};this.debugError=function(){q.error.apply(q,arguments)};this.debugEnabled=function(){return q.on};var al=aW.cfgString=this.getConfigString=function(cs,o){return k(cs,o,0)};var aR=aW.cfgBool=this.getConfigBoolean=function(cs,o){return k(cs,o,1)};var bu=aW.cfgInt=this.getConfigInt=function(cs,o){return k(cs,o,2)};var r=aW.cfgFloat=this.getConfigFloat=function(cs,o){return k(cs,o,3)};var cr=function(cs,o){bZ=new a.PageInput(aN,aW,cs)};var an=function(){var cs={dir:al("dir"),oMenu:bJ};if(W){W.destroy()}W=new a.PagesSearchDialog(aN,aW,cs);var o=a.trim(al("SearchTextOnStart",""));if(o.length>0){W.search(o)}};this.searchForString=function(o){if(!W){q.error("search is not enabled");return false}if(typeof(o)!=="string"){q.error("searchForString expects string argument");return false}o=a.trim(o);if(o.length<1){return false}W.runSearch(o)};this.showSearchDialog=function(o){if(!W){return false}W.show(o)};var cn=function(){if(!bJ){return}var cs=aW.arMenuButtons=[];if(aR("zoom",true)){cs.push({x:1,cmd:"ZoomPage",bCheckButton:1})}if(aR("print",true)){cs.push({cmd:"PrintPage",bCheckButton:1})}if(aR("save",false)){cs.push({cmd:"SavePage",bCheckButton:1})}var o=aR("ButtonsFirstLastPage",true);if(o){cs.push({cmd:"FirstPage"})}cs.push({cmd:"PreviousPage"});if(aR("PageInput",true)){cs.push({cmd:"PageInput",bNoMouseEvents:true,fnCreateInstance:aN,fnCreate:cr});if(aR("PageInputEnterButton",true)){cs.push({cmd:"PageInputEnter"})}}cs.push({cmd:"NextPage"});if(o){cs.push({cmd:"LastPage"})}if(bF.hasPlugin("bookmarks")){cs.push({cmd:"ToggleBookmarkList",bCheckButton:1});cs.push({cmd:"ToggleBookmark"})}if(a4!==b){cs.push({cmd:"ToggleTableOfContents",bCheckButton:1})}if(aR("Index",true)){cs.push({cmd:"TogglePageIndex",bCheckButton:1})}if(bF.hasPlugin("fullscreen")){a.FullScreen.removeChangeEvents(window,bC,aO);a.FullScreen.addChangeEvents(window,bC,aO);cs.push({cmd:"ToggleFullScreen",bCheckButton:1})}bJ.addButtons(cs,al("MenuButtonOrder"));if(aR("Search",false)===true){an()}};aW.getCommandRepeatCount=function(){return Q.nRepeatCount};var ci=function(o){if(o===b){o=Q.cmd;Q.nRepeatCount++}switch(o){case"NextPage":bS.nextPage();break;case"PreviousPage":bS.previousPage();break}if(Q.nRepeatCount===1){if(Q.intervalTimeFirst!==Q.intervalTimeRepeat){clearInterval(Q.interval);Q.interval=setInterval(ci,Q.intervalTimeRepeat)}}};var af=function(ct,o,cs){bH();Q={};Q.bRunning=true;if(o===b){o=500}Q.intervalTimeFirst=o;if(cs===b){Q.intervalTimeRepeat=o}else{Q.intervalTimeRepeat=cs}Q.nRepeatCount=0;Q.cmd=ct;Q.interval=setInterval(ci,Q.intervalTimeFirst);ci(ct)};var bH=function(){if(!Q.bRunning){return}clearInterval(Q.interval);switch(Q.cmd){case"NextPage":case"PreviousPage":break}Q={}};var Y=function(cs,o){return bJ.enableButton(cs,o)};var b0=aW.exitIndexAndZoom=function(){ad();if(V){C()}if(a4){a4.show(false)}};var B=this.clickMenuButton=function(o){aW.pressMenuButton(o,b,true);aW.releaseMenuButton(o,b,true);aW.clickMenuButton(o,b,true)};this.pressMenuButton=function(o){bJ.pressButton(o)};this.releaseMenuButton=function(o){bJ.releaseButton(o)};this.nextPage=function(){B("NextPage")};this.previousPage=function(){B("PreviousPage")};this.firstPage=function(){B("FirstPage")};this.lastPage=function(){B("LastPage")};aW.pressMenuButton=function(ct,o,cv){if(W){W.closeDialog()}if(!cv){aW.onUserAction()}bH();var cs,cu;if(ct.indexOf("_")!==-1){cs=ct.split("_");ct=cs[0];cu=cs[1]}switch(ct){case"NextPage":case"PreviousPage":b0();af(ct,500,200);break}};aW.releaseMenuButton=function(cs,o,ct){if(!ct){aW.onUserAction()}bH()};aW.clickMenuButton=function(cu,o,cw){var cs,cv;if(typeof(cu)==="string"&&cu.indexOf("_")!==-1){cs=cu.split("_");cu=cs[0];cv=cs[1]}switch(cu){case"ToggleTableOfContents":co();break;case"TogglePageIndex":if(a4){a4.show(false)}C();break;case"ToggleFullScreen":if(a.FullScreen.getEnabled()){aM();a.FullScreen.quit()}else{var ct=bY;if(typeof(ct)==="string"){ct=document.getElementById(ct);if(ct===b){ct=cg}}c=ct;a.addClass(ct,"fsi-viewer");a.FullScreen.start(ct);aM()}break;case"ZoomPage":bS.toggleZoom(true);break;case"PrintPage":bc();break;case"SavePage":i();break;case"ToggleBookmarkList":a8();break;case"ToggleBookmark":bm(o);break;case"FirstPage":b0();bS.firstPage();break;case"LastPage":b0();bS.lastPage();break}};var by=aW;by.iViewer=aN;by.getDebug=function(){return q};by.getToolTip=function(){return bf};by.getLanguageData=function(){return bD};by.getElementSpace=function(){return aC};by.getRootContainer=function(){return aq};by.getParentElement=function(){return cg};by.getCallbacks=function(){return b9};by.getIsFullScreen=function(){return ac};by.gotoPage=function(o){bS.gotoPage(o,bAnimate)};by.getMenu=function(){return bJ};by.getMenuHeight=function(){var o=0;if(bJ){o=bJ.getHeight()}return o};by.getPageToolTip=function(){return bL};by.getPageNumberString=aS;if(typeof(d)!=="object"||a.makeBool(d.autoInit,true)){aN.init(aE,d)}};a.customTags.register("fsi-pages",{constructorClass:a.Pages,viewerCSS:"display:block;width:300px;height:300px;"});a.dispatchEvent("FSIPagesLoaded")}(window.$FSI=window.$FSI||{}));