/*!
 * FSI Quick Zoom
 * Build: 18.07.06.1
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};k.getElementMargins=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.marginLeft);i.top=parseFloat(q.marginTop);i.right=parseFloat(q.marginRight);i.bottom=parseFloat(q.marginBottom)}catch(r){}return i};k.getElementBorders=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.borderLeftWidth);i.top=parseFloat(q.borderTopWidth);i.right=parseFloat(q.borderRightWidth);i.bottom=parseFloat(q.borderBottomWidth)}catch(r){}return i};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r===undefined)?"":strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2018",strBuild:"18.07.06.1"});this.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};this.cloneArray=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.urlDecode=function(str){if(!str){return str}var ret=str.replace(regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return window.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!=b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.utils.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m==b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m==b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(e){if(k.readyState!=4){return}delete c[n];if(m==b||this.FSIaborted){return}var r=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,r,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(ai,w,e){if(typeof(e)!=="object"){e={}}if(!w||typeof(w)!=="object"){w={}}var m=this;this.parameters=(ai&&typeof(ai)==="object")?ai:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Y=false;var N={};var A=0;var q;var ac={};var H=m.debug=new a.EmptyDebugger();var D=false;var x={};var an=false;var S={stickynotes:"bookmarks"};var f;var X=false;var s;var K;var ae;var c;var l;var u="token";var v;var o;if(a.isInternetExplorer&&a.versionInternetExplorer<10){o=function(ap){var ao;if(!a.utils.isCrossDomain(ap)){an=false;ao=new XMLHttpRequest()}else{an=true;ao=new XDomainRequest()}return ao}}else{if(typeof(XMLHttpRequest)!=="undefined"){o=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(aq){m.reset();s=(typeof(e.strSection)==="string")?e.strSection:"";K=s.toLowerCase();if(typeof(e.strTraceParam)==="string"){var ao=e.strTraceParam.toLowerCase();c={};c[ao]=true;if(ao.indexOf("_")>0&&ao.indexOf("pages")===0){ao=ao.split("_");ao.shift();ao=ao.join("_");c[ao]=true}var ap=m.getParameterAlias(ao);if(ap){c[ap]=true}}else{c=false}if(aq){if(m.parameters){m.parameters=a.utils.mergeObjects(m.parameters,aq)}else{m.parameters=aq}}ah(m.parameters);m.getQueryParameters();m.cloneParameters(m.cfgDefaults,m.cfg);m.cloneParameters(m.queryParameters,m.cfg);m.elevateToHTTPS();d();m.locationFSIViewer="";if(m.queryParameters.fsiviewerlocation!==b){m.locationFSIViewer=m.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());m.locationFSIViewer=a.getViewerLocation()}if(m.locationFSIViewer.charAt(m.locationFSIViewer.length-1)!=="/"){m.locationFSIViewer+="/"}m.nextConfigURL=m.getReloadPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.defaultcfg));m.checkDebug(false)};var ah=this.makeObjectPropertiesLowerCase=function(ao){for(var ap in ao){var aq=ap.toLowerCase();if(ap!==aq){if(ao[aq]===b){ao[aq]=ao[ap]}delete ao[ap]}}};this.getClassParameters=function(){return ae};this.setAccessToken=function(ao){v=ao};this.getParameterAlias=function(aq){var ao;if(m.cfgAliasNames[aq]){ao=m.cfgAliasNames[aq]}else{for(var ap in m.cfgAliasNames){if(m.cfgAliasNames[ap]===aq){ao=ap;break}}}return ao};var d=function(){Y=m.makeBool(m.cfg.usenc,false);if(m.cfg.usencquery!==b&&m.cfg.usencquery.length>0){D=m.cfg.usencquery;Y=true;m.queryToObject("?"+D,x)}};this.stopPendingRequests=function(){for(var ap in N){var ao=N[ap];if(ao){ao.FSIaborted=true;if(ao.abort){ao.abort()}}}};this.destroy=function(){m.stopPendingRequests()};this.reset=function(){ae={};m.parameters={};H=m.debug=new a.EmptyDebugger();m.stopPendingRequests();q=Math.random();m.nIncludedConfigs=0;m.completedConfigs={};m.plugins={};m.cfg={};m.queryParameters=b;m.arUnrecognizedConfigNodes=[];aj=0;m.arConditions=[];ac={}};this.getQueryParameters=function(){if(m.queryParameters!==b){return}m.queryParameters={};m.cloneParameters(m.parameters,m.queryParameters)};this.makeBool=function(ar,ao){if(typeof(ao)!=="boolean"){ao=false}var ap=ao;switch(typeof(ar)){case"string":var aq=a.makeBool(ar);if(aq!==b){ap=aq}break;case"number":ap=Boolean(ar);break;case"boolean":ap=ar;break}return ap};this.parsePositionParameter=function(ap){if(typeof(ap)!=="string"||ap.length<3){return b}ap=ap.split(",");if(ap.length<3){return b}for(var ao=0;ao<3;ao++){ap[ao]=parseFloat(ap[ao]);if(isNaN(ap[ao])){ap[ao]=0}}return{x:ap[0],y:ap[1],z:ap[2]}};this.logLoadFileFailed=function(ao){if(!H.on){return}if(ao&&ao.status!==b){var aq="HTTP "+ao.status;if(ao&&ao.statusText){aq+=", "+ao.statusText}var ap=(ao._url)?ao._url:"";H.error("Failed to load "+ap+" ("+aq+")")}else{H.error("Failed loading a file");if(ao&&ao._url){H.error(ao._url)}}};this.getAttributeValue=function(ap,ao){if(!ap){return}return ap.getAttribute(ao)};this.getImageURL=function(aq,ao){var ap;if(aq===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="image"}if(ao.renderer===b){ao.renderer="jpeg"}if(v){ao[u]=v}ao.source=aq;for(ap in ac){if(ac[ap]!==b&&ao[ap]===b){ao[ap]=ac[ap]}}for(ap in aa){if(ao[ap]){if(aa[ap]!==ap){if(!ao[aa[ap]]){ao[aa[ap]]=ao[ap]}ao[ap]=null}}}return m.requestBase+"?"+m.objectToQuery(ao)};this.getImageInfoURL=function(ap,ao){if(ap===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="info"}if(ao.tpl===b){if(m.cfg.fpxinfotemplate!==b){ao.tpl=m.cfg.fpxinfotemplate}else{ao.tpl="info.json"}}if(m.cfg.headers&&m.cfg.headers.length>0){ao.headers=m.cfg.headers}if(!ao.tpl.match(/.json$/)){ao.tpl+=".json"}ao.source=ap;if(v){ao[u]=v}return m.requestBase+"?"+m.objectToQuery(ao)};this.queryToObject=function(at,aq){if(aq===b){aq={}}var ar,av,au,ao,ap;ar=at.indexOf("?");if(ar!==-1){ap=at.slice(ar+1)}else{ap=""}ar=ap.indexOf("#");if(ar!==-1){ap=ap.substring(0,ar)}ap=ap.split("&");for(ar=0;ar<ap.length;ar++){av=ap[ar].split("=");au=a.utils.urlDecode(av[0]).toLowerCase();if(au.length>0){ao=a.utils.urlDecode(av[1]);aq[au]=ao}}return aq};this.parseSceneSets=function(ao,at){var aA={};if(at===b){at=true}var aF=[];var aD=0;var aB=0;var aq;var av,au,ar,az,ax,aE;var aw,ay,aC;var ap=m.cfg.scenesets;if(ao>1&&ap!==b&&typeof(ap)==="string"){ay=ap.split(";");for(av=0;av<ay.length;av++){aC=[];aw=ay[av].split(",");aB=0;for(au=0;au<aw.length;au++){aE=aw[au].split("-");az=ax=0;if(aE.length===1){az=parseInt(aE[0])}else{az=parseInt(aE[0]);if(isNaN(az)){az=1}aq=false;if(aE[1].charAt(0)===">"){aE[1]=aE[1].substr(1);if(!isNaN(parseInt(aE[1]))){aq=true}}ax=parseInt(aE[1]);if(isNaN(ax)){ax=ao}if(az>0&&ax>0&&az<=ao&&ax<=ao){if(aq===true||az!==ax){if(aq!==true){if(ax<az){for(ar=az;ar>=ax;ar--){aC[aB]=ar;aB++}}else{for(ar=az;ar<=ax;ar++){aC[aB]=ar;aB++}}}else{for(ar=az;ar<=ao;ar++){aC[aB]=ar;aB++}for(ar=1;ar<=ax;ar++){aC[aB]=ar;aB++}}}}}if(az>0&&az<=ao&&(ax===0||ax===az)){aC[aB]=az;aB++}}if(aB>0){aF[aD]={};aF[aD].arScenes=[];aF[aD].arScenes=aF[aD].arScenes.concat(aC);aD++}}}if(aD===0){aA.bDefault=true;if(at){aF[0]={};aF[0].arScenes=[];for(av=0;av<ao;av++){aF[0][av]=av}}}aA.nSceneSets=aD;aA.bHasMultipleSets=(aA.nSceneSets>1);aA.arSets=aF;aA.nCurrent=1;return aA};this.objectToQuery=function(ap){var ao=[];var at,aq;if(Y&&D!==false){for(at in x){ap[at]=x[at]}}for(at in ap){aq=ap[at];if(aq!==null){aq=encodeURIComponent(aq);ao.push(encodeURIComponent(at)+"="+aq)}}return ao.join("&")};this.loadImageInfo=function(ar,ao,aq){var ap=m.getImageInfoURL(ar);m.loadFile(ap,ao,b,aq)};this.loadFile=function(at,ar,aq,ax,aw,ap,au){if(!at||at.length<0){if(ar){setTimeout(function(){ar(null,"",ax)},0)}return}if(aw===b){aw="GET"}if(ap===b){ap=null}else{if(typeof(ap)==="object"){ap=m.objectToQuery(ap)}}if(aq===b){aq="application/json"}var av=o(at);if(aq&&av.overrideMimeType){av.overrideMimeType(aq)}av._url=at;var ao=A;N[A]=av;A++;if(an){av.onerror=function(){delete N[ao];if(ar===b||this.FSIaborted){return}m.logLoadFileFailed(this)};av.onload=function(){delete N[ao];if(ar===b||this.FSIaborted){return}var ay=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var az=new ActiveXObject("Microsoft.XMLDOM");az.async=false;az.loadXML(ay);ay=this.responseXML=az}catch(aA){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(at)}break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(aA){H.error("Failed parsing JSON from URL: "+at+" ("+aA.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}else{av.onreadystatechange=function(){var ay;if(av.readyState!==4){return}delete N[ao];if(this.FSIaborted||typeof(ar)!=="function"){return}if(this.status>299){m.logLoadFileFailed(this)}switch(aq){case"application/xml":case"text/xml":ay=this.responseXML;break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(az){H.error("Failed parsing JSON from URL: "+at+" ("+az.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}av.open(aw,at,true);if(au&&v){av.setRequestHeader("x-token",v)}if(ap){av.setRequestHeader("Content-type","application/x-www-form-urlencoded");av.send(ap)}else{av.send()}return av};this.loadConfigs=function(){ae=(s.length>0)?{}:false;f=true;m.loadNextConfig(true)};this.loadNextConfig=function(ap){if(m.nextConfigURL===b){W();return}var aq={};if(e.bPreventCaching||m.makeBool(m.cfg.debug)||(!ap&&!m.makeBool(m.cfg.configcaching,true)&&m.makeBool(m.cfg.enableconfigcachingparameter))){m.addNoCacheParams(aq)}m.finishRequestParams(aq);var ao=m.addURLParameters(m.nextConfigURL,aq);H.log("Loading config file: "+ao);m.loadFile(ao,E,"application/xml")};this.setDebugger=function(ao){H=m.debug=ao};this.checkDebug=function(aq){if(e.bNoDebug){return}var ap;var ao;if(m.parameters.debug!==b){ao=m.makeBool(m.parameters.debug)}else{ao=m.makeBool(m.cfg.debug)}if(ao){if(!H||!H.on){H=m.debug=new a.Debugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}else{if(!H||H.on===true){H=m.debug=new a.EmptyDebugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}return ap};var E=function(ao){var aq=ao.responseXML;l=m.nextConfigURL;m.parseConfig(aq);l=b;m.elevateToHTTPS();if(m.checkDebug(true)===true){return}d();if(f&&e.bCaptureDefaultCfg){f=false;m.cfgFromDefaultConfig=a.utils.cloneValue(m.cfg)}var ap;if(m.cfg.includeconfig!==b&&m.nIncludedConfigs<10){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.includeconfig));m.nIncludedConfigs++;m.cfg["_includeconfig("+m.nIncludedConfigs+")"]=m.cfg.includeconfig;m.cfg.includeconfig=b}else{if(m.cfg.cfg!==b){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.cfg))}}if(ap!==b&&!m.completedConfigs[ap]){m.completedConfigs[ap]=true;m.nextConfigURL=ap;m.loadNextConfig()}else{m.evaluateQuery(m.queryParameters,m.cfg);W()}};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!m.makeBool(m.cfg.autoelevatetohttps,true)){return}h("fpxbase");h("fpxserver")};var h=function(ao){if(m.cfg[ao]!==b&&m.cfg[ao].length>0&&m.cfg[ao].indexOf("http://")===0){m.cfg[ao]="https"+m.cfg[ao].substr(4)}};this.evaluateQuery=function(ap,ao){for(var aq in ap){m.setConfigParamByValue(ao,aq.toLowerCase(),ap[aq])}};this.parseConfig=function(ap,aq){var aA="";var au;var aw=false;if(ap!==b){if(aq===b){aq=ap.firstChild}if(aq&&aq.nodeName==="xml"){aq=aq.nextSibling}var az=aq.childNodes;for(var av=0;av<az.length;av++){var at=az[av];if(at.nodeType!==1){continue}var ax;if(at._myTagName!==b){ax=at._myTagName}else{ax=at.nodeName.toLowerCase()}aA=ax;var ar=at.childNodes;aw=false;switch(ax){case"licence":break;case"if":m.arConditions.push(at);break;case"plugins":for(au=0;au<ar.length;au++){m.parsePluginNode(ar[au])}break;case K:aw=true;case"info":case"options":aA=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(au=0;au<ar.length;au++){var ay=ar[au];if(ay.nodeType!==1){continue}if(ay.tagName==="if"){ay._myTagName=ax;m.arConditions.push(ay)}else{var ao=m.getValueFromXMLNode(ay,aA);if(aA===b&&ae){if(aw){m.setConfigParam(ae,ao,null,true);m.setConfigParam(m.cfg,ao,ay)}else{if(ae[ao.name]===b){m.setConfigParam(m.cfg,ao,ay)}}}else{m.setConfigParam(m.cfg,ao,ay)}}}break;default:m.arUnrecognizedConfigNodes.push(at)}}}};this.getData=function(){var ao={};ao.cfg={};for(var ap in m.cfg){ao.cfg[ap]=m.cfg[ap]}return ao};this.setData=function(ao){if(!ao||!ao.cfg){return}m.cfg={};this.setCfgValues(ao.cfg)};this.setCfgValues=function(ao){for(var ap in ao){m.cfg[ap]=ao[ap]}V()};this.getImagesNodeList=function(aq){var ao=[];if(aq===b){aq=m.getUnrecognizedConfigNode("images")}if(aq){var ar=aq.firstChild;while(ar){if(ar.nodeType===1){var ap={};ap.attributes={};M(ar,ap.attributes);ap.cfg={};m.parseConfigFragment(ar,ap.cfg);ao.push(ap)}ar=ar.nextSibling}}return ao};this.removeUnrecognizedConfigNodes=function(){m.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ar){var ao;ar=ar.toLowerCase();for(var ap=m.arUnrecognizedConfigNodes.length-1;ap>-1;ap--){var aq=m.arUnrecognizedConfigNodes[ap];if(aq&&aq.nodeName.toLowerCase()===ar){ao=aq;break}}return ao};this.parseConfigFragment=function(ap,aw,av){var aA="";if(ap!==b&&aw!==b){if(av===b){av=[]}var az=ap.childNodes;for(var au=0;au<az.length;au++){var ar=az[au];if(ar.nodeType!==1){continue}var ax=ar.nodeName.toLowerCase();aA=ax;var aq=ar.childNodes;switch(ax){case"info":case"options":aA=b;case"fpx":case"image":case"include":for(var at=0;at<aq.length;at++){var ay=aq[at];if(ay.nodeType!==1){continue}var ao=m.getValueFromXMLNode(ay,aA);m.setConfigParam(aw,ao,ay)}break;default:av.push(ar)}}}};this.findXMLNode=function(ap,ao){if(ap===b||ap.nodeType===b){return b}while(ap){if(ap.nodeName.toLowerCase()===ao){break}if(ap.firstChild){ap=ap.firstChild}else{if(ap.nextSibling){ap=ap.nextSibling}else{ap=ap.parentNode.nextSibling}}}return ap};this.getValueFromXMLNode=function(aq,ao){if(!aq||aq.nodeType!==1){return}var ap={};var ar=(ao)?ao:"";ap.name=ar+aq.nodeName.toLowerCase();var at=aq.getAttribute("value");if(at){ap.value=at;return ap}ap.value=m.XMLChildNodesToString(aq);ap.node=aq;return ap};this.getXMLNodeAttribute=function(ar,aq,ao){if(!ar||ar.nodeType!==1||!ar.getAttribute){return ao}var ap=ar.getAttribute(aq);if(ap===b||ap==null){ap=ao}return ap};this.XMLChildNodesToString=function(aq,ap){var ao="";if(!aq||!aq.firstChild){return ao}if(aq.childNodes.length===1&&aq.firstChild.nodeType===3){ao=aq.firstChild.nodeValue}else{ao=aq.innerHTML}if(ap!==b){ao=ao.replace(/[\x00-\x1f]/g,ap)}return ao};this.hasPlugin=function(ao){return(m.plugins&&m.plugins[ao]!==b)};this.getPluginParameter=function(av,ap,ao,au,aw){av=av.toLowerCase();ap=ap.toLowerCase();if(m.plugins[av]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+av+"."+ap);return ao}var at;var ar=av+"_"+ap;if(aw&&m.cfg[ar]===b){ar=ap}if(m.cfg[ar]!==b){at=m.cfg[ar]}else{if(ae&&ae[ap]!==b&&K==="pages"){at=ae[ap]}else{var aq=m.plugins[av].parameters;if(aq!==b&&aq[ap]!==b){at=aq[ap]}}}if(at===b){at=ao}if(au){at=m.makeBool(at,ao)}return at};var Q=this.getAllPluginParameters=function(ap){ap=ap.toLowerCase();var aq=a.utils.cloneObject(m.plugins[ap].parameters);var at=ap+"_";var ao=at.length;for(var au in m.cfg){if(au.toLowerCase().indexOf(at)===0){var ar=au.substr(ao);aq[ar]=m.cfg[au]}}return aq};this.getIntParameterMinMax=function(ap,aq,ao,ar){return Math.min(ar,Math.max(ao,m.getIntParameter(ap,aq)))};this.getIntParameter=function(ap,aq){var ao=parseInt(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};this.getStringParameter=function(ap,aq){var ao=m.cfg[ap.toLowerCase()];if(ao===b){ao=aq}return ao};this.getFloatParameter=function(ap,aq){var ao=parseFloat(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};var M=function(au,ap){if(!au||!au.attributes||!au.attributes.length||!ap){return false}var aq=au.attributes;for(var at=0;at<aq.length;at++){var ao=aq[at];var ar=ao.nodeName.toLowerCase();ap[ar]=ao.value}return true};this.parsePluginNode=function(aq){if(aq.nodeType!==1){return}var at={};M(aq,at);var ar=aq.childNodes;for(var ao=0;ao<ar.length;ao++){var au=ar[ao];if(au.nodeType!==1){continue}var ap=m.getValueFromXMLNode(au);if(ap.value!==b){at[ap.name]=ap.value;if(ap.node!==b){at[ap.name+".node"]=ap.node}}}this.addPluginFromString(at.src,at)};this.clone=function(){var ao=new a.Config(ai,w,e);ao.init();ao.cfg=a.utils.cloneObject(m.cfg);ao.plugins=a.utils.cloneObject(m.plugins);ao.arPlugins=a.utils.cloneArray(ao.arPlugins);ao.arUnrecognizedConfigNodes=a.utils.cloneArray(ao.arUnrecognizedConfigNodes);ao.setImageQueryParameters(ac);ao.arConditions=a.utils.cloneArray(m.arConditions);ao.hasImageParameterConditions=m.hasImageParameterConditions;return ao};this.setImageQueryParameters=function(ao){ac=a.utils.cloneObject(ao)};this.addPluginsFromString=function(aq){if(typeof(aq)!=="string"||aq.length<1){return}var ao=aq.split(",");for(var ap=0;ap<ao.length;ap++){var ar=a.trim(ao[ap]);m.addPluginFromString(ar)}};this.addPluginFromString=function(ar,at){if(typeof(ar)!=="string"||ar.length<1){H.error("PLUGIN without src parameter:");return}ar=ar.toLowerCase();if(S[ar]!==b){ar=S[ar]}if(at===b){at={}}var ap=m.plugins[ar]={};ap.name=ar;if(at.src===b){at.src=ar}ap.parameters=at;if(c){for(var au in c){if(au.indexOf(ar+"_")===0){var aq=ar+"_";var ao=au.substr(aq.length);if(typeof(ap.parameters[ao])!=="undefined"){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log(ap.parameters[ao]);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}else{if(au===ar){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log("(enabled)");m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ap,aq,ao){m.setConfigParam(ap,{name:aq.toLowerCase(),value:ao})};var U=function(ap){if(ap.nodeType!==1){return"<unknown>"}var ao=m.XMLSerializer.serializeToString(ap.cloneNode(false));ao=ao.replace(/\/>$/gi,">");return ao};this.setConfigParam=function(ar,ao,at,au){var aw=ao.name;var ay=ao.value;if(!aw){return}if(c){for(var ax in c){if(ax===aw&&!au){if(typeof(at)==="object"&&typeof(at.tagName)==="string"){var av;if(l){av=l}var aq=at.parentNode;var ap=[];while(aq){if(aq.tagName==="if"){av="Matched Condition"}ap.unshift(U(aq));aq=aq.parentNode}ap.shift();ap.shift();m.iTraceParameterDebug.group(av);m.iTraceParameterDebug.log(ap.join(" "));m.iTraceParameterDebug.log(at);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}else{m.iTraceParameterDebug.group("By Parameter/Attribute:");m.iTraceParameterDebug.log(ay);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}if(m.cfgAliasNames[aw]!==b){aw=m.cfgAliasNames[aw]}if(ar[aw]!==b&&(typeof(ay)==="string"&&a.utils.getBoolTable(ay.toLowerCase())===false)&&a.utils.getBoolTable(ar[aw])===b){delete ar[aw]}else{switch(aw){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ar[aw]!==b&&ar[aw].length>0&&ar[aw].indexOf(ay)===-1){ar[aw]+=","+ay}else{ar[aw]=ay}break;case"plugins":m.addPluginsFromString(ay);break;case"fpxpath":ar[aw]=ay;ar.fpxsrc=encodeURIComponent(ay);break;default:ar[aw]=ay;if(ao.node!==b){ar[aw+".node"]=ao.node}}}};var k={};k["="]=function(ap,ao){return(ap.toLowerCase()===ao.toLowerCase())};k["=="]=function(ap,ao){return(ap===ao)};k["!="]=function(ap,ao){return(ap.toLowerCase()!==ao.toLowerCase())};k["!=="]=function(ap,ao){return(ap!==ao)};k["<"]=function(ap,ao){return(ap<ao)};k["<="]=function(ap,ao){return(ap<=ao)};k[">"]=function(ap,ao){return(ap>ao)};k[">="]=function(ap,ao){return(ap>=ao)};k.match=function(ap,ao){var aq=false;var at="g";if(ao.charAt(0)==="/"&&ao.lastIndexOf("/")>0){var ar=ao.split("/");ar.shift();at=ar.pop();ao=ar.join("/")}try{var au=new RegExp(ao,at);aq=(ap.match(au)!==null)}catch(av){H.error("Invalid regex in condition: "+ao)}return aq};k.notmatch=function(ap,ao){return !k.match(ap,ao)};var r={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var t=function(ap,aq){if(m.cfgAliasNames[aq]){aq=m.cfgAliasNames[aq]}var ao=m.cfg[aq];if(ao===b){ao=""}if(!m.hasImageParameterConditions){m.hasImageParameterConditions=(aa[aq]!==b)}return G(ap,aq,ao)};var L=function(ar,at){var ao=false;var aq;var ap=ar.getAttribute("value");switch(at){case"@mobile":ap=m.makeBool(ap,true);aq=a.isMobileDevice;break;case"@devicepixelratio":aq=a.getDevicePixelRatio();break;case"@navigatoruseragent":aq=navigator.userAgent;break;case"@navigatorlanguage":aq=navigator.language;break;case"@navigatorplatform":aq=navigator.platform;break}if(aq!==b){if(typeof(ap)!=="string"){ap=""+ap}if(typeof(aq)!=="string"){aq=""+aq}ao=G(ar,at,aq,ap)}return ao};var G=function(ar,aq,au,at){var aw;var ap=ar.getAttribute("operator");if(typeof(ap)!=="string"){ap="="}ap=ap.toLowerCase();if(r[ap]){ap=r[ap]}if(k[ap]===b){ap="="}if(at===b){at=ar.getAttribute("value")}if(at===null){at=""}var ao=k[ap];if(ap.match(/[<,>]+/)){var ax=function(ay){ay=parseFloat(ay);if(isNaN(ay)){aw=false}return ay};au=ax(au);at=ax(at)}else{au=decodeURIComponent(au)}if(aw===b){aw=ao(au,at)}if(H.on){H.log("Evaluating condition: "+aq+": "+au+" "+ap+" "+at+" => "+aw)}if(aw===true){if(ar._myTagName!==b){var av={};av.nodeType=1;av.tagName=ar._myTagName;av.childNodes=[ar];ar=av}m.parseConfig(ar,ar)}return aw};var aa={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ab={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var Z;var T=function(){if(Z===b){Z={};for(var ao in aa){Z[aa[ao]]=ao}}return Z};var p=function(at,ar,aq){if(aq===b){aq=""}var av=aq+"left";if(at[av]===b){return}var au=aq+"top";var ap=aq+"right";var ao=aq+"bottom";if(ar==="pixelrange"){at[ap]=at[ap]-at[av];at[ao]=at[ao]-at[au]}at[ar]=at[av]+","+at[au]+","+at[ap]+","+at[ao];if(at[av]){delete at[av]}if(at[au]){delete at[au]}if(at[ap]){delete at[ap]}if(at[ao]){delete at[ao]}};var al=this.mapImageParametersToViewer=function(ao){p(ao,"rect");p(ao,"pixelrange","pixel");T();ag(ao,T())};var ak=this.mapImageParametersToServer=function(ao){ag(ao,aa)};var ag=function(ap,ao){for(var aq in ap){if(ao[aq]&&aq!==ao[aq]){ap[ao[aq]]=ap[aq];delete ap[aq]}}};this.reWriteImageURLByConditions=function(av){if(m.arConditions.length<1){return av}if(typeof(av)!=="string"||av.length<1){return av}var aq=av.indexOf("?");if(aq===-1){return av}var ap=m.clone();var at={};m.parseQuery(av,at);al(at);m.evaluateQuery(at,ap.cfg);var ao=ap.evaluateConditions();if(!ao){return av}var au;for(au in at){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}for(au in ab){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}ak(at);var ar=av.substr(0,aq);return ar+"?"+m.objectToQuery(at)};var n=this.applyConditions=function(){if(m.arConditions.length<1){return}if(m.cfgBeforeConditions===b){m.cfgBeforeConditions=a.utils.cloneObject(m.cfg)}m.cfg=m.cfgBeforeConditions;return g()};var aj=0;var g=this.evaluateConditions=function(){if(m.arConditions.length<1){return false}var ap=false;for(var aq=aj;aq<m.arConditions.length;aq++){var ar=m.arConditions[aq];if(ar.fsiConfigEvaluated){continue}aj++;var at=ar.getAttribute("parameter");if(typeof(at)==="string"){at=at.toLowerCase();var ao;if(at.charAt(0)==="@"){ao=L(ar,at)}else{ao=t(ar,at)}if(!ap&&ao){ap=ao}}}return ap};var V=function(){n();m.serverProfile=m.cfg.fpxservertemplate;m.serverProfileDoublePage=m.cfg.fpxservertemplatedoublepage;if(m.serverProfileDoublePage===b){m.serverProfileDoublePage="doublepage"}m.serverBase=m.cfg.fpxserver;if(m.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+m.locationFSIViewer+")");var ap;ap=m.locationFSIViewer.indexOf("/users/");if(ap!==-1){m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}else{ap=m.locationFSIViewer.indexOf("/viewer/");m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}H.log("Derived server location is: ["+m.serverBase+"]")}m.requestBase=m.serverBase;ac={};var ao=m.cfg;for(var aq in ab){if(ao[aq]!==b){ac[aq]=ao[aq]}}if(ac.fpxsrc!==b){ac.fpxsrc=decodeURIComponent(ac.fpxsrc)}ao=m.cfg.effects;if(ao!==b){m.cfg.effectsUnFiltered=ao;m.cfg.effects=ao=j(ao)}if(ao!==b){ac.effects=ao}ao=m.cfg.lefteffects;if(ao!==b){ac.lefteffects=ao}ao=m.cfg.righteffects;if(ao!==b){ac.righteffects=ao}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){m.setEffectsFilter(m.getAreaEffects())};this.setEffectsFilter=function(at){if(typeof(at)!=="string"||at.length<1){X=false;return}at=a.trim(at);var ap=at.split(",");for(var aq=0;aq<ap.length;aq++){ap[aq]=a.escapeRegEx(ap[aq])}var ao="(^|[=,]+)("+ap.join("|")+")\\([^)]*\\)";X=new RegExp(ao,"ig")};var j=function(ao){if(X===false){return ao}return ao.replace(X,"")};var i=function(){for(var ap in m.plugins){var aq=ap.toLowerCase();var ao=m.makeBool(m.cfg[aq],true);if(!ao){m.plugins[ap]=b}}};var W=function(){m.elevateToHTTPS();i();V();m.dumpConfig();if(w.onConfigsReady){w.onConfigsReady()}};this.dumpConfig=function(aq){if(!aq){aq=H}if(aq.on){if(m.cfg.fpxsrc!==b){m.cfg["fpxsrc (decoded)"]=decodeURIComponent(m.cfg.fpxsrc)}aq.info("Evaluated Configuration:",P(m.cfg));if(m.queryParameters){aq.info("Parameters:",P(m.queryParameters))}if(ae){aq.info("Class <"+s+"> Configuration:",P(ae))}var ap=m.getPluginsAndParameters();var ao=ap.data;if(ap.count===0){ao="No active plugins."}aq.info("Plugin Configuration:",P(ao))}};var P=function(aq){var ao="--- none ---";if(typeof(aq)!=="object"){return ao}for(var ap in aq){ao=aq;break}return ao};this.getPluginsAndParameters=function(){var ao={};var aq=0;for(var ap in m.plugins){if(m.hasPlugin(ap)){ao[ap]=Q(ap);aq++}}return{count:aq,data:ao}};var J=this.addQueryParameterToURL=function(ar,ao,aq){var ap=ar.lastIndexOf("?");if(ap===-1){ar+="?"}else{if(ap!==ar.length-1){ar+="&"}}return ar+encodeURIComponent(ao)+"="+encodeURIComponent(aq)};var am=m.finishURL=function(ao){if(v){ao=J(ao,u,v)}if(!Y||ao===b){return ao}var ap;if(D===false){ap="cache=0&cachernd="+q;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+="&"+ap}}else{ap=D;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+=ap}}return ao};this.addURLParameters=function(ap,aq){if(!ap||!aq){return ap}var ao=[];for(var at in aq){ao.push(encodeURIComponent(at)+"="+encodeURIComponent(aq[at]))}if(ao.length>0){if(ap.indexOf("?")===-1){ap+="?"}else{ap+="&"}ap+=ao.join("&")}return ap};this.finishRequestParams=function(ap){if(Y){if(D===false){ap.cache=0;ap.cachernd=q}else{for(var ao in x){ap[ao]=x[ao]}}}};this.addNoCacheParams=function(ao){ao.cache=0;ao.cachernd=q};this.parseQuery=function(ap,ao){if(typeof(ao)!=="object"||typeof(ap)!=="string"||ap.length<1){return}m.queryToObject(ap,ao);if(ao.ignorequeryparameters!==b){delete ao.ignorequeryparameters}if(ao.enableconfigcachingparameter!==b){delete ao.enableconfigcachingparameter}};this.cloneParameters=function(ao,ap){if(ao===b||ap===b){H.error("Cloning object failed: "+ao+" / "+ap)}for(var aq in ao){ap[aq]=ao[aq]}};this.getFSIPath=function(ao,ap){if(ap.indexOf("//")!==-1){return ap}if(m.cfg.fsibase!==b){ap=m.cfg.fsibase+ap}return m.getReloadPath(ao,ap)};this.expandFSIPath=function(ap){if(ap===b){return ap}var ao=a.utils.urlDecode(ap);if(ao.indexOf("?")!==-1||ao.indexOf(".xml")===(ao.length-4)){return ap}return ap+".xml"};this.getReloadPath=function(ar,au){var ap,av,ao,at;if(ar===b){ar=m.locationFSIViewer}if(typeof(au)!=="string"){au=""}var aq="/";if(au.indexOf("//")!==-1){return au}ap=ar;at=ap.lastIndexOf("?");if(at===-1){at=ap.length}av=ap.lastIndexOf("\\",at);ao=ap.lastIndexOf("/",at);av=Math.max(av,ao);if(av===-1){av=ap.length-1}ap=ap.slice(0,av);if(ap.length>0&&au.indexOf(aq)!==0){ap+=aq}return ap+au};var C=function(ao){var ap;if(!ao){return}if(ao.childNodes.length>0){ap=ao.innerHTML}else{ap=ao.getAttribute("value")}return ap};var I=function(aq,ar){var ap,ao;while(aq){if(aq.nodeName===ar){ao=aq;break}ap=aq.firstChild;if(!ap){ap=aq.nextSibling}if(!ap&&aq.parentNode){ap=aq.parentNode.nextSibling}aq=ap}return ao};var B=function(ap){var ao=I(ap,"images");if(!ao){ao=I(ap,"images3d")}return m.parseXMLImageListNode(ao)};var R=function(aq){var ap={};var au=ap.arImages=[];var at="";var aw="";var ax;if(!aq){return ap}var av;av=m.getAttributeValue(aq,"prefix");if(typeof(av)==="string"){at=av}av=m.getAttributeValue(aq,"suffix");if(typeof(av)==="string"){aw=av}aq=I(aq,"image");if(!aq){return ap}while(aq){if(aq.nodeType===1){ax=I(aq,"path");var ay=C(ax);if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"src"))}if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"file"))}if(ay!==b){if(ad===false){au.push(at+ay+aw)}else{var ao=at+ay+aw;if(ad(ao)){au.push(ao)}}}if(ap.width===b){ax=I(aq,"width");ax=C(ax);if(ax!==b){ap.width=parseInt(ax)}ax=I(aq,"height");ax=C(ax);if(ax!==b){ap.height=parseInt(ax)}}}aq=aq.nextSibling}return ap};this.getImageList=function(){var aq,av,ap;z();if(m.cfg&&m.cfg.fpxsources!==b){var au=m.cfg.fpxsources;if(typeof(au)==="string"||(typeof(au)==="object")&&typeof(au.push)==="function"){aq={};aq.oXML=null;if(typeof(au)==="string"){if(ad===false){aq.arImages=au.split(",");for(av=0;av<aq.arImages.length;av++){aq.arImages[av]=a.utils.urlDecode(aq.arImages[av])}}else{var ao=au.split(",");aq.arImages=[];for(av=0;av<ao.length;av++){ap=a.utils.urlDecode(ao[av]);if(ad(ap)){aq.arImages.push(ap)}}}}else{aq.arImages=au}}}if(!aq&&m.arUnrecognizedConfigNodes&&m.arUnrecognizedConfigNodes.length>0){var at=m.arUnrecognizedConfigNodes;for(av=0;av<at.length;av++){var aw=at[av];if(typeof(aw.nodeName)==="string"){var ax=aw.nodeName.toLowerCase();if(ax==="images"||ax==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aq=R(aw);aq.oXML=aw;break}}}}if(!aq&&m.cfg&&m.cfg.fpxsrc!==b){aq={};aq.oXML=null;if(ad===false){aq.arImages=[a.utils.urlDecode(m.cfg.fpxsrc)]}else{ap=a.utils.urlDecode(m.cfg.fpxsrc);if(ad()){aq.arImages=[ap]}}}return aq};this.getServerBase=function(){return m.serverBase};this.loadImageList=function(ar,at,av,au){if(!m.serverBase||!ar){at([],b,au);return false}z();var aq=m.serverBase+"?type=list";if(ar.indexOf("tpl")===-1){var ap=m.cfg.listtemplate;if(ap&&ap.length>0&&ap.indexOf(".json")===-1&&ap.indexOf(".xml")===-1){ap+=".json"}aq+="&tpl="+ap}if(m.cfg.headers&&m.cfg.headers.length>0&&x.headers===b){aq+="&headers="+m.cfg.headers}if(typeof(m.cfg.imagelistlimit)==="string"&&m.cfg.imagelistlimit.length>0){aq+="&limit="+encodeURIComponent(m.cfg.imagelistlimit)}aq+="&source="+encodeURIComponent(ar);if(av!==b){aq+=av}aq=am(aq);var ao=m.loadFile(aq,function(aw,aA){if(typeof(aA)==="object"&&typeof(aA.images)==="object"){aA.images.pop();var aB="";if(aA&&aA.imagesattributes&&aA.imagesattributes.dir){aB=aA.imagesattributes.dir}var ax,az;if(ad===false){ax=new Array(aA.images.length);for(az=0;az<aA.images.length;az++){ax[az]=aB+aA.images[az].src}}else{ax=[];for(az=aA.images.length-1;az>-1;az--){var ay=aB+aA.images[az].src;if(af(ay)){ax.push(ay)}else{aA.images.splice(az,1)}}ax.reverse()}at(ax,aA,au)}else{at([],aA,au)}},"application/json",au);return ao};var af=function(ap){if(typeof(ap)!=="string"){return 1}var ao=1;if(O!==b){if(!ap.match(O)){ao=0}}if(ao===1&&y!==b){if(ap.match(y)){ao=0}}return ao};var ad=true;var O,y;var F=function(at){var aq;var av=m.cfg[at.toLowerCase()];if(!av||typeof(av)!=="string"||av.length<1){return}var ao=/\/([^/]*)$/;try{var ar=av.match(ao);if(ar&&ar.length>1){var ap=ar[1];av=av.replace(ao,"");av=av.replace(/^\//,"")}aq=new RegExp(av,ap)}catch(au){H.error("Invalid Regular Expression "+av+" in parameter "+at);H.error(au.message);aq=b}return aq};var z=function(){O=F("ListFilterPositive");y=F("ListFilterNegative");if(O===b&&y===b){ad=false}else{ad=af}};this.traceConfigValue=function(ao,ar){if(typeof(ao)!=="string"){return false}ao=a.trim(ao);if(ao.length<1){return false}var ap=ao.toLowerCase();if(ap.indexOf(".")!==-1){ap=ap.split(".").join("")}if(ap.indexOf("/")!==-1){ap=ap.split("/").join("")}if(ap.indexOf(" ")!==-1){ap=ap.split(" ").join("")}var aq=new a.Debugger();aq.setPrefix("");aq.group('Tracing parameter "'+ao+'"');var at=function(){var au=ao;var az=m.getParameterAlias(ap);if(typeof(az)==="string"){au+=" (alias: "+az+")";if(typeof(m.cfgAliasNames[ap])==="string"){ap=m.cfgAliasNames[ap]}}var av=m.cfg[ap];var ay=true;if(ap.indexOf("_")!==-1){var ax=ap.split("_");var aw=ax.shift();var aA=ax.join("_");if(m.hasPlugin(aw)){av=m.getPluginParameter(aw,aA)}}else{if(m.hasPlugin(ap)){ay=false;av="is enabled."}}if(av===b){ay=false;av="is undefined (default value applies)"}if(ay){av='= "'+av+'"'}aq.group("RESULT:");aq.log(au+" "+av);aq.groupEnd();aq.groupEnd()};w={onConfigsReady:at};e.strTraceParam=ap;e.bNoDebug=true;m.iTraceParameterDebug=aq;m.init(ar);m.loadConfigs();return""};this.loadLanguageFile=function(ao,aA,at,aq){var au=arguments;var av,ay;if(typeof(aA)!=="string"||m.makeBool(aA,true)===false){return at.call(m,{},"")}var az=function(aB){try{a.utils.oLanguageMap=JSON.parse(aB.responseText)}catch(aC){a.utils.oLanguageMap={"default":"english"}}m.loadLanguageFile.apply(this,au)};var aw=function(aB,aE){ao.urlLanguageCurrentLoaded=av;var aD=ao.oLanguageData={};if(aE){var aC=m.findXMLNode(aE,"data");if(aC){aC=m.findXMLNode(aC,"tip")}while(aC){if(aC.nodeType===1){var aF=aC.getAttribute("id");aD[aF]=m.XMLChildNodesToString(aC)}aC=aC.nextSibling}}at.call(m,ao.oLanguageData,ay)};if(aA.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){m.loadFile(a.getViewerLocation()+"/languages/mapping.json",az,"application/json");return}if(a.utils.oLanguageMap._current!==b){aA=a.utils.oLanguageMap._current}else{aA=a.utils.oLanguageMap["default"];var ar=navigator.language;if(typeof(ar)==="string"){ar=ar.toLowerCase()}if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}else{if(ar.indexOf("-")!==-1){ar=ar.split("-")[0];if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}}}}if(aA===b){return at.call(m,{},"")}if(aq){aq.log('Automatically choosing language "'+aA+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aA}var ax=aA+".xml";var ap=a.getViewerLocation()+"/languages/"+ax;if(ap!==ao.urlLanguageCurrentLoaded){ay=aA;av=ap;if(aq){aq.log("Loading language file: "+ap)}m.loadFile(ap,aw,"application/xml")}else{at.call(m,ao.oLanguageData,ay)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ObjectCollection!=b){return}a.ObjectCollection=function(){var d=this;var f;var h;var c=0;var g;var e;this.reset=function(){c=0;d.empty()};this.empty=function(){f=[];h={};g=0;e=false};this.getCount=function(){return g};this.add=function(j){if(!j){return}c++;h[c]=j;j.__id=c;j.__arrayPos=f.length;f.push(j);g++;return c};this.deleteObject=function(j){if(!j||!j.__id){return}return d.deleteObjectById(j.__id)};this.deleteObjectById=function(j){if(!h[j]){console.error("ObjectCollection deleteObjectById "+j+" failed.");return}g--;delete h[j];e=true;return true};this.replace=function(j,k){if(!j||!k){return}return d.replaceById(j.__id,k)};this.replaceById=function(l,k){if(h[l]==b||k==b){return}var j=h[l].__arrayPos;delete h[l];c++;k.__id=c;k.__arrayPos=j;f[j]=k;h[c]=k;return true};var i=function(){if(!e){return}f=new Array(g);var l=0;for(var k in h){var j=h[k];j.__arrayPos=l;f[l]=j;l++}e=false};this.getById=function(j){return h[j]};this.getArray=function(){if(e){i()}return f};this.getObjects=function(){return h};d.empty()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageTagCollection!=b){return}a.ImageTagCollection=function(c,p){a.ObjectCollection.prototype.constructor.apply(this,arguments);var r=this;var q=false;var k=false;var o=false;var s;var i;var d;var e,g;this.init=function(){if(typeof(p.imgsrcattributename)==="string"&&p.imgsrcattributename.length>0){i=p.imgsrcattributename}else{i="src"}d=(i==="src");if(typeof(c.NameID)=="string"){s=c.NameID}else{s="$FSI_ImageTagID"}if(typeof(p.fnfilterimagesource)=="function"){k=p.fnfilterimagesource}if(typeof(p.addcssclass)=="string"){o=p.addcssclass}if(typeof(p.enablebycssclass)=="string"&&p.enablebycssclass.length>0){g={};var v=p.enablebycssclass.split(",");for(var u=0;u<v.length;u++){g[v[u]]=true}}if(typeof(p.disablebycssclass)=="string"&&p.disablebycssclass.length>0){e={};var v=p.disablebycssclass.split(",");for(var u=0;u<v.length;u++){e[v[u]]=true}}q=(e!=b||g!=b)};var n=this.isValidFSIImageServerImageSource=function(t){if(typeof(t)!=="string"){return false}return !(t.length<1||t.search(/[?,&]type=image/i)===-1||t.search(/[?,&]source=/i)===-1)};var j=this.createObjectForImageTag=function(u,y){var t=false;var v=y;if(y==b){v=y=l(u)}if(k!==false){var x=y;y=k(y,u);t=(y!==x)}if(!n(y)){return}if(!f(u)){return}if(o){a.addClass(u,o)}var w={};w.img=u;w.src=y;w.orgSrc=v;w.orgSrcDisplay=u.src;if(t){w.bIgnoreSourceChange=true}return w};var l=this.getSrc=function(t){var u=null;if(typeof(t)==="object"&&t.nodeName==="IMG"){if(d){u=t.src}else{u=t.getAttribute(i);if(typeof(u)!=="string"||u.length<1){u=null}}}return u};this.addBaseMethod=this.add;this.add=function(t){if(t[s]!==b){return}var v=l(t);if(v===null){return}var u=j(t,v);if(u){this.addBaseMethod(u);t[s]=u.__id}return u};this.replaceBaseMethod=this.replace;this.replace=function(t,u){if(r.replaceBaseMethod(t,u)){u.img[s]=u.__id}};var m=this.releaseImage=function(u){if(!u||!u.img){return false}var t=u.img;if(!t[s]==b||t[s]!=u.__id){return}if(o){a.removeClass(t,o)}return true};var h=this.remove=function(t){if(!this.deleteObject(t)){return false}m(t);return true};var f=this.isImageEnabledByCSSClass=function(t){if(!q){return true}var u=false;var w=t.className;if(typeof(w)!="string"){w=[]}else{w=w.split(" ")}if(e){u=true;for(var v=0;v<w.length;v++){if(e[w[v]]){u=false;break}}}if(g){for(var v=0;v<w.length;v++){if(g[w[v]]){u=true;break}}}return u}}}(window.$FSI=window.$FSI||{}));(function(a,b){a.CustomEventListener;if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.utils.getNewEventElementID()}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!=c){if(q){j()}else{i()}}};var m=function(p){var q;var r=a.utils.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!=q){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.QuickZoom!=b){return}a.utils.API.QuickZoom=function(d,e){var c=this;c.scriptMainFile="FSI.QuickZoom.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,__FSI:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},addImage:{a:"elImg"},destroy:{},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getVersion:{r:"strVersion"},init:{},printAPI:{},removeImages:{a:"arImageDOMElements"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},scanForNewImages:{}};c.oCallbacks={onConfigsReady:{a:"oConfigValues"},onDestroy:{},onInit:{},onModifyPositionAndSize:{a:"oModify, oInfo"},onStart:{a:"nImagesPrepared, arImageDOMElements"},onZoomEnd:{},onZoomStart:{a:"elImage, strZoomImage"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.QuickZoom!==b){return}a.utils.addViewerClassCSSRule("div.FSIQuickZoom","position:absolute!important;z-index:10000;box-sizing:content-box!important;overflow:hidden!important;padding:0px 0px 0px 0px;cursor: crosshair;background-color:white;border:0px none;");a.QuickZoom=function(Z){var t={};var R={strVersion:"2018",strBuild:"18.07.06.1",strConfigSection:"QuickZoom",bHasListeners:true};var ah=new a.utils.ClassDef(this,"FSI QuickZoom",R);ah.oAPI=new a.utils.API.QuickZoom(this,t);var n=ah.instance;a.utils.guessFSIViewerLocation("fsiquickzoom.js",3);var r=a.utils.getViewerInstanceID();var K=new a.EmptyDebugger();var m=function(am,al){if(al&&!K.on&&am.on){if(H){H.stopPendingRequests()}n.destroy();n.init(true);return true}K=am;if(K.on){K.setPrefix(n.getInstanceName())}};this.getInstanceID=function(){return r};this.getInstanceName=function(){return ah.strClassName+" [#"+r+"]"};var af=(Z)?a.utils.cloneParameters(Z):{};var G;var aj;var w=false;var H;var C;var I=false;var d=true;var N=/((\?)|&)effects=([^&]*)/ig;var ai=/((\?)|&)rect=([^&]*)/ig;var ac=/[=,]+Pad\([^)]*/ig;var l=/((\?)|&)(width|height)=[^&]*/ig;var i;var v={};var ak={};var ag=3;var D=false;var U={x:0,y:0};var o={x:10000000,y:10000000};var M;var A;var j;var ab,J;var y;var q=1;var L=true;var aa=false;var g=true;var f=true;var T;K.log(n.getVersion());this.init=function(al){if(w){return}if(al!==b){af.debug=al}if(a.isMobileDevice&&a.BrowserSupports.documentZoom()){return false}aj=new a.CORSLoader();if(a.getDocumentScroll===b||!aj.getSupported()){K.error("Unsupported browser. "+aj.getSupported()+" => "+navigator.userAgent);return}var am={};am.onConfigsReady=V;am.onDebuggerChange=m;H=new a.Config(null,am,{strSection:ah.strConfigSection});H.init(af);H.loadConfigs();C=t.iCallbacks=new a.Callbacks(n,H);if(C.isset("onInit")){C.runPersistent("onInit",[af])}return true};this.getConfigValue=function(al){if(H&&typeof(al)==="string"){return H.cfg[a.trim(al.toLowerCase())]}};this.getParameters=function(){return a.utils.cloneParameters(af)};this.destroy=function(){if(H){H.destroy();H=b}if(C){C.run("onDestroy");C.destroy();C=b}if(y!==b){a.removeCustomEvent(n,"FSIDocumentZoomChange",h);y=b}P();if(G){var al=G.getArray();for(var am=0;am<al-length;am++){k(img)}G.empty()}w=false};var V=function(){var at;if(n.bAutoInitialized){K.log("Start (auto initialized)")}else{K.log("Start")}if(C.isset("onConfigsReady")){C.runPersistent("onConfigsReady",[a.utils.cloneObject(H.cfg)])}T=H.makeBool(H.cfg.usedevicepixelratio,true);I=H.makeBool(H.cfg.inplacezoom,false);if(I){d=false}else{d=H.makeBool(H.cfg.autozoomdimension,true)}L=H.makeBool(H.cfg.moverangecentercorners,!I);if(a.BrowserSupports.documentZoom()){y=a.addCustomEvent(n,"FSIDocumentZoomChange",h);aa=(a.utils.getDocumentScale()>1)}if(!G){var al={NameID:"$FSIQuickZoom_TagID"};G=new a.ImageTagCollection(al,H.cfg);G.init()}a._FSIQuickZoomInstance=n;if(H.cfg.headers===b){H.cfg.headers="cors"}if(H.cfg.length>0){i="&headers="+H.cfg.headers}else{i=""}ag=F("magnification",2);ag=Math.max(1,ag);o.x=F("maxZoomWindowWidth",o.x);o.y=F("maxZoomWindowHeight",o.y);ab=F("minZoomWindowWidth",100);J=F("minZoomWindowHeight",100);U.x=F("skipImageWidth",0);U.y=F("skipImageHeight",0);M=F("pageMargin",18);A=F("zoomImageBorderWidth",-1);j=F("zoomImageOffset",0);if(A<0){try{var an=document.createElement("div");an.style.display="none";a.addClass(an,"FSIQuickZoom");document.body.appendChild(an);var am=window.getComputedStyle(an,null);var ao=0;ao=Math.max(ao,parseFloat(am.borderLeftWidth));ao=Math.max(ao,parseFloat(am.borderRightWidth));ao=Math.max(ao,parseFloat(am.borderTopWidth));ao=Math.max(ao,parseFloat(am.borderBottomWidth));A=ao;a.removeChild(document.body,an)}catch(au){}}var av=document.getElementsByTagName("img");K.log("Preparing images (total images: "+av.length+")");for(at=0;at<av.length;at++){ae(av[at])}K.log(G.getCount()+" images have been prepared for FSI QuickZoom");if(C.isset("onStart")){var aq=G.getArray();var ap=new Array(aq.length);for(at=0;at<aq.length;at++){ap[at]=aq[at].tag}C.runPersistent("onStart",[ap.length,ap])}w=true};this.addListener=function(ao,am,an){var al=false;if(C){al=C.addListener(ao,am,an)}return al};this.removeListener=function(an,am){var al=false;if(C){al=C.removeListener(an,am)}return al};var h=function(al){var am=(al.FSI_scale>1);if(aa===am){return}aa=am;if(am){P()}};var F=function(am,an){var al=parseFloat(H.cfg[am]);if(isNaN(al)){al=an}return al};this.removeImages=function(al){if(al===b){return}if(al.join===b){al=[al]}var am=G.getCount();for(var ao=0;ao<al.length;ao++){k(al[ao])}var an=G.getCount();var ap=am-an;K.log("removeImages: "+ap+" images have been removed, total zoom images now: "+an+" images.");return ap};var u=function(al){if(!al){return}var am=G.getById(al.$FSIQuickZoom_TagID);a.removeEvent(al,"load",z,false);a.removeEvent(al,"error",W,false);a.removeEvent(al,"mouseover",E,false);if(typeof(ak)==="object"&&ak.id===am.__id){P()}return am};var k=function(al){var am=u(al);G.remove(am);am.img.$FSIQuickZoom_TagID=b;delete am.img.$FSIQuickZoom_TagID};this.addImage=function(al){if(!al||al.$FSIQuickZoom_TagID!==b){return}var am=ae(al);return(am!==b)};var ae=function(al){if(!G){return}var am=G.add(al);if(!am){return}am.srcCurrent=am.src;am.tag=al;a.addEvent(al,"load",z,false);a.addEvent(al,"error",W,false);a.addEvent(al,"mouseover",E,false);return am};var Y=function(am){if(!am||!am.img||am.bPrepared===true){return}var al=am.img;am.src=X(am.src);if(al.width!==b&&al.width>0){am.width=al.width}if(al.height!==b&&al.height>0){am.height=al.height}if(am.width>0&&am.height>0){p(am)}else{am.bFinishOnLoad=true}am.bPrepared=true;return am};var p=function(ap){ap.ready=true;ap.wOrg=ap.width;ap.hOrg=ap.height;ap.src=H.reWriteImageURLByConditions(ap.src);var an;an=ap.src.match(N);if(an&&typeof(an)==="object"&&typeof(an[0])==="string"){an[0]=decodeURIComponent(an[0]);if(an[0].match(ac)){ap.bHasPadEffect=true}}if(!ap.bHasPadEffect){an=ap.src.match(ai);if(an&&an[0]){var am=an[0].split("=");if(am.length>0){am=decodeURIComponent(am[1]).split(",");if(am.length>3){var al=parseFloat(am[2]);var ao=parseFloat(am[3]);if(al>0&&al<=1&&ao>0&&ao<=1){ap.cropRectWidth=al;ap.cropRectHeight=ao}}}}}};var X=function(al){return al.replace(l,"$2")};var W=function(){var al=(!a.isInternetExplorer)?this:window.event.srcElement;var am=G.getById(al.$FSIQuickZoom_TagID);if(am.bLoading){am.ready=false;am.bLoading=false}};var z=function(){var am=(!a.isInternetExplorer)?this:window.event.srcElement;var ao=G.getById(am.$FSIQuickZoom_TagID);var al=G.getSrc(am);if(!ao.bLoading&&ao.orgSrc!==al){var an=false;if(typeof(ak)==="object"&&ak.idVisible===ao.__id){an=true}if(an){P()}ao.bPrepared=ao.ready=false;ao.bInfo=b;X(ao.src);ao.srcCurrent=ao.orgSrc=al;ao.sourceWidth=ao.sourceHeight=b;ao.src=X(ao.orgSrc);Y(ao);ad(ao);if(an){ak.id=ao.__id}}if(ao.bFinishOnLoad){delete ao.bFinishOnLoad;ao.width=am.width;ao.height=am.height;p(ao)}else{if(ao.bLoading){ao.bLoading=false}}};var B=function(al){v.x=al.clientX;v.y=al.clientY};var P=function(){var al=ak.el;var am=ak.elDiv;if(ak.id!==b){a.removeEvent(al,"mousemove",c,false);a.removeEvent(al,"mouseout",e,false);ak.id=ak.img=b;ak.src=ak.idVisible=b}if(!am){return}a.removeEvent(ak.elImageFinalZoom,"load",s,false);a.removeChild(am.parentNode,am);ak.elDiv=b;a.removeClass(al,"FSIQuickZoom");C.run("onZoomEnd")};var x=function(au,aR){if(aa){return}var ax=au.img;if(T){q=Math.max(1,a.getDevicePixelRatio())}else{q=1}var ao=A;var aX=j;if(typeof(ak)==="object"&&ak.idVisible===au.__id){return}if(!au.bInfo){return}g=f=false;var aA=a.getViewportSize(window);var ba=M;var aG=aA.width-M-2*ao;var aE=M;var a6=aA.height-M-2*ao;var aF=a.getDocumentScroll(window);var ap=a.getElementPosition(ax);var aZ=O(ax);var aK;var az,aO,bc,aq;if(!d){aK=a.utils.getElementPaddings(ax);az=ap.right-ap.left;aO=ap.bottom-ap.top;bc=az+aK.left+aK.right;aq=aO+aK.top+aK.bottom}else{bc=Math.max(o.x,au.wOrg);aq=Math.max(o.y,au.hOrg)}if(!I){var am;var aY;var aH=aA.width-2*M-2*ao;var aV=aA.height-2*M-2*ao;var a8,a7;if(aH-bc>aV-aq){aY=aV;var aT=ap.left-M-aZ.left-aX-2*ao;var aS=aA.width-ap.right-M-aZ.right-aX-2*ao;a7=0;if(aS>aT){am=aS;a8=1}else{am=aT;a8=-1}}else{am=aH;var aQ=ap.top-M-aZ.top-aX-2*ao;var aP=aA.height-ap.bottom-M-aZ.bottom-aX-2*ao;a8=0;if(aP>aQ){aY=aP;a7=1}else{aY=aQ;a7=-1}}bc=Math.min(am,bc);aq=Math.min(aY,aq)}var aL=false;if(typeof(au.tag.getAttribute)==="function"){var a2=au.tag.getAttribute("FSIQuickZoomMagnification")||au.tag.getAttribute("data-fsi-quickzoom-magnification");if(typeof(a2)==="string"){a2=parseFloat(a2);if(!isNaN(a2)&&a2>1){aL=a2}}}if(!aL){aL=ag}a.utils.expandSourceDimensionForPadEffect(au,au.wOrg,au.hOrg);var aw=au.sourceWidth;var a5=au.sourceHeight;var aJ=Math.round(aw/q);var a3=Math.min(aJ,Math.round(aL*au.wOrg));aJ=Math.round(a5/q);var aW=Math.min(aJ,Math.round(aL*au.hOrg));var at;if(au.cropRectWidth){at=a.getFSIServerImageDim(au.cropRectWidth*aw,au.cropRectHeight*a5,a3,aW,b,!au.bHasPadEffect)}else{at=a.getFSIServerImageDim(aw,a5,a3,aW,b,!au.bHasPadEffect)}a3=at.width;aW=at.height;var aD=Math.min(aw,Math.round(a3*q));var a1=Math.min(a5,Math.round(aW*q));var aN=a3/aD;if(d){g=(a3<=bc);f=(aW<=aq);if(g){bc=a3}if(f){aq=aW}}var ay=au.src+"&width="+aD+"&height="+a1;if(ak.src===ay){return}var ar,av,aC,aB,be,bd;if(I){ar=-ao-aK.left;av=-ao-aK.top}else{if(a8===0){ar=(ap.right-ap.left)/2-bc/2-ao}else{if(a8>0){ar=ap.right-ap.left+aZ.right+aX}else{ar=-aZ.left-bc-2*ao-aX}}aC=ap.left+ar;aB=aC+bc;if(aC<ba){ar+=ba-aC}if(aB>aG){ar-=aB-aG}if(a7===0){av=(ap.bottom-ap.top)/2-aq/2-ao}else{if(a7>0){av=ap.bottom-ap.top+aZ.bottom+aX}else{av=-aZ.top-aq-2*ao-aX}}be=ap.top+av;bd=be+aq;if(be<aE){av+=aE-be}if(bd>a6){av-=bd-a6}}if(C.isset("onModifyPositionAndSize")){var a4={};var bb={};bb.left=ar;bb.top=av;bb.width=bc;bb.height=aq;bb.srcZoomImage=ay;a4.sourceElement=ax;a4.imageWidth=a3;a4.imageHeight=aW;a4.imageWidthDPR=aD;a4.imageHeightDPR=a1;a4.sourceImageWidth=aw;a4.sourceImageHeight=a5;a4.borderWidth=ao;a4.imageMargin=aX;a4.minZoomWidth=ab;a4.minZoomHeight=J;a4.maxZoomWidth=o.x;a4.maxZoomHeight=o.y;a4.elementPosition=a.utils.cloneObject(ap);a4.imgPaddings=a.utils.cloneObject(aZ);a4.scrollPos=a.utils.cloneObject(aF);a4.event=aR;C.run("onModifyPositionAndSize",[bb,a4]);ar=bb.left;av=bb.top;bc=bb.width;aq=bb.height;ay=bb.srcZoomImage;g=(a3<=bc);f=(aW<=aq)}if(bc<ab||aq<J){return}a.addClass(ax,"FSIQuickZoom");if(ak.elDiv!==b){P()}ak.id=ak.idVisible=au.__id;ak.el=ax;ak.width=ax.offsetWidth;ak.height=ax.offsetHeight;ak.oImage=au;ak.elOffsetX=-ap.left-aF.x;ak.elOffsetY=-ap.top-aF.y;var al=ak.elImageZoom=document.createElement("img");al.setAttribute("width",String(aD));al.setAttribute("height",String(a1));var aU="position:relative;border:0px none; padding:0px; margin:0px;";aU+="max-width:none;max-height:none;min-width:none;min-height:none;";aU+="width:"+aD+"px;height:"+a1+"px";a.utils.setStyleAttr(al,aU);if(aN!==1){al.style.width=a3+"px";al.style.height=aW+"px"}var a9=document.createElement("div");a.utils.setStyleAttr(a9,"margin-left:0px;margin-top:0px;");a9.setAttribute("class","FSIQuickZoom");a9.style.width=bc+"px";a9.style.height=aq+"px";a9.style.left=Math.round(aF.x+ap.left+ar)+"px";a9.style.top=Math.round(aF.y+ap.top+av)+"px";ak.src=ay;ak.elDiv=a9;ak.elImageFinalZoom=al;ak.elImageZoom=ak.elImagePreviewZoom=al.cloneNode(false);ak.elImagePreviewZoom.src=au.orgSrcDisplay;a.addEvent(ak.elImageFinalZoom,"load",s,false);al.src=ay;ak.scaleX=a3/au.wOrg;ak.scaleY=aW/au.hOrg;ak.centerX=ak.elOffsetX-au.wOrg/2;ak.centerY=ak.elOffsetY-au.hOrg/2;if(L){ak.moveFactorX=a3/au.wOrg;ak.moveFactorY=aW/au.hOrg;ak.moveOffsetX=Math.round(bc/2);ak.moveOffsetY=Math.round(aq/2)}else{ak.moveFactorX=(a3-au.wOrg)/au.wOrg;ak.moveFactorY=(aW-au.hOrg)/au.hOrg;ak.moveOffsetX=0;ak.moveOffsetY=0}a9.style.pointerEvents="none";a9.appendChild(ak.elImagePreviewZoom);document.body.appendChild(a9);var aM=new a.Rect();var aI=new a.Rect();var an=a.getElementClientPos(ax);aM.copyRect(an);var a0=a.getElementClientPos(a9);aI.copyRect(a0);aI.interSectRectValidate(aM);D=(aI.width()>0&&aI.height()>0);c();C.run("onZoomStart",[au.tag,ay])};var s=function(){var al=this;a.removeEvent(al,"load",s,false);var am=ak.elImagePreviewZoom;setTimeout(function(){am.src=al.src},25)};var O=function(am){var al={left:0,top:0,right:0,bottom:0};try{var an=window.getComputedStyle(am,null);al.left+=parseFloat(an.paddingLeft);al.right+=parseFloat(an.paddingRight);al.top+=parseFloat(an.paddingTop);al.bottom+=parseFloat(an.paddingBottom);al.left+=parseFloat(an.borderLeftWidth);al.right+=parseFloat(an.borderRightWidth);al.top+=parseFloat(an.borderTopWidth);al.bottom+=parseFloat(an.borderBottomWidth)}catch(ao){}return al};var c=function(am){if(am){B(am)}if(!ak||!ak.elDiv){return}var ap=a.getDocumentScroll(window);var al,ao;if(g){v.x=-ak.centerX-ap.x}if(f){v.y=-ak.centerY-ap.y}al=v.x+ak.elOffsetX+ap.x;ao=v.y+ak.elOffsetY+ap.y;al=al*ak.moveFactorX-ak.moveOffsetX;ao=ao*ak.moveFactorY-ak.moveOffsetY;var an=ak.elImageZoom;an.style.left=-Math.round(al*q)/q+"px";an.style.top=-Math.round(ao*q)/q+"px"};var E=function(al){B(al);var am=(!a.isInternetExplorer)?this:window.event.srcElement;var an=G.getById(am.$FSIQuickZoom_TagID);if(!an){return}if(ak.id!==an.__id){if(ak.id){P()}a.addEvent(am,"mousemove",c,false);a.addEvent(am,"mouseout",e,false);ak.id=an.__id;ak.img=am}Y(an);ad(an);x(an,al)};var e=function(){P()};this.scanForNewImages=function(){var al=document.getElementsByTagName("img");var am=0;K.log("...scanning for new images: "+al.length+" image(s) in total");for(var an=0;an<al.length;an++){if(al[an].$FSIQuickZoom_ID===b){if(ae(al[an])){am++}}}K.log(am+" new QuickZoom image(s) added")};var ad=function(ao){if(!ao||ao.bInfo!==b){return}ao.bInfo=false;var al=ao.src;var am=al.match(/.*[?]/);var an=al.match(/[?&]source=[^&]*/);al=am+"type=info&tpl=info.json"+i+an;aj.load(al,Q,b,ao)};var Q=function(am,ao,aq){var an;try{an=JSON.parse(ao)}catch(ap){K.error("Failed to get image info for "+aq.src);an=a.getFSIServerImageDim(aq.wOrg,aq.hOrg,4000,4000,b,true)}aq.sourceWidth=an.width;aq.sourceHeight=an.height;S(aq);var al=false;if(U.x>0&&aq.wOrg<U.x){al=true}if(U.y>0&&aq.hOrg<U.y){al=true}if(al){k(aq.img)}else{if(ak.id===aq.__id){x(aq)}}};var S=function(al){if(!al.sourceWidth||!al.sourceHeight){al.ready=false;return}if(al.rectWidth){al.maxWidth=Math.round(al.rectWidth*al.sourceWidth);al.maxHeight=Math.round(al.rectHeight*al.sourceHeight)}else{al.maxWidth=al.sourceWidth;al.maxHeight=al.sourceHeight}al.bInfo=true}};a.addEvent(window,"DOMContentLoaded",function(){if(typeof(a.quickZoomParameters)!=="object"||a.makeBool(a.quickZoomParameters.autoInit,true)){if(typeof(a.quickZoom)==="object"&&typeof(a.quickZoom.destroy)==="function"){a.quickZoom.destroy()}var c;if(typeof(a.quickZoomParameters)==="object"){c=a.quickZoomParameters}a.quickZoom=new a.QuickZoom(c);a.quickZoom.bAutoInitialized=true;a.quickZoom.init()}});a.dispatchEvent("FSIQuickZoomLoaded")}(window.$FSI=window.$FSI||{}));