/*!
 * FSI Viewer (tm)
 * Build: 18.07.06.1
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};k.getElementMargins=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.marginLeft);i.top=parseFloat(q.marginTop);i.right=parseFloat(q.marginRight);i.bottom=parseFloat(q.marginBottom)}catch(r){}return i};k.getElementBorders=function(p){var i={left:0,top:0,right:0,bottom:0};try{var q=window.getComputedStyle(p,null);i.left=parseFloat(q.borderLeftWidth);i.top=parseFloat(q.borderTopWidth);i.right=parseFloat(q.borderRightWidth);i.bottom=parseFloat(q.borderBottomWidth)}catch(r){}return i};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r===undefined)?"":strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2018",strBuild:"18.07.06.1"});this.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};this.cloneArray=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)===undefined||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.urlDecode=function(str){if(!str){return str}var ret=str.replace(regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return window.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var f={};var e=false;var d=this.initCustomTags=function(){if(a.BrowserSupports.registerElement()){return false}for(var g in f){c(g)}return true};var c=this.initCustomTag=function(k){if(a.BrowserSupports.registerElement()){return false}var j=f[k];if(!j){return false}var g=document.getElementsByTagName(k);if(g.length>0){j.replaceTagInit()}if(g&&g.length>0){for(var h=0;h<g.length;h++){j.replaceTag(g[h])}}return true};this.register=function(h,g){if(f[h]===b){f[h]=new a.CustomTag(h,g);if(!e){e=true;if(!a.BrowserSupports.registerElement()){a.addEvent(window,"DOMContentLoaded",d)}}}return f[h]}};a.CustomTag=function(e,c){var k=this;var f;var j=function(){if(a.BrowserSupports.registerElement()){i()}};var d=function(m,n){var l=m.getAttribute(n);if(typeof(l)==="string"&&l.length>0){if(!l.match(/[^0-9\s]/)){l+="px"}m.style[n]=l}};var h=function(l){d(l,"width");d(l,"height")};var g=function(o){var l=a.utils.attributes2parameters(o);if(c.parameterAliases){var p=c.parameterAliases;for(var n in p){var m=p[n];if(l[n]!==b&&l[m]===b){l[m]=l[n]}}}if(l.src!==b&&l.imagesrc===b){l.imagesrc=l.src}return l};var i=function(){a.utils.addViewerClassCSSRule(e,c.viewerCSS);var l=Object.create(HTMLDivElement.prototype);l.createdCallback=function(){h(this);c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};l.attachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}this.init(this,g(this));if(this.start){this.start()}};l.detachedCallback=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};document.registerElement(e,{prototype:l})};this.replaceTag=function(l){if(!l||(typeof(l.getInitDone)==="function"&&l.getInitDone())){return}h(l);c.constructorClass.prototype.constructor.call(l,l,g(l));if(l.start){l.start()}};this.replaceTagInit=function(){if(f){return}f=true;a.utils.addViewerClassCSSRule(e,c.viewerCSS)};j()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!=b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.utils.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m==b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m==b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(e){if(k.readyState!=4){return}delete c[n];if(m==b||this.FSIaborted){return}var r=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,r,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CanvasProgressBar!=b){return}a.CanvasProgressBar=function(s,m,j,d,q,e){var r=this;if(!e){e={}}if(typeof(e.border)!="string"){e.frame="#58a8ff"}if(typeof(e.color)!="string"){e.color="#58a8ff"}if(typeof(e.background)!="string"){e.background="rgba(255,255,255,0.5)"}if(typeof(e.text)!="string"){e.text="#FFFFFF"}var p=m;var o=j;var g=q;var l=d;var h=0;var k=(q>10&&d>40);this.draw=function(t){var u=l/100*t;i(p,o,l,g,h);c(p,o,u,g,h,l);if(k){f(p,o,u,g,h,l)}};this.setCtx=function(t){s=t};this.setPos=function(t,u){p=t;o=u};var i=function(v,z,w,u,t){s.save();s.fillStyle=e.border;n(v-1,z-1,w+2,1,t);n(v-1,z+u,w+2,1,t);n(v-1,z-1,1,u+2,t);n(v+w,z-1,1,u+2,t);s.fillStyle=e.background;n(v,z,w,u,t);s.restore()};var c=function(w,A,z,v,u,t){s.fillStyle=e.color;n(w,A,z,v,u)};var n=function(v,z,w,u,t){s.fillRect(v,z,w,u)};var f=function(B,z,t,D,w,A){s.save();s.font="10px Arial";s.textAlign="start";s.textBaseline="alphabetic";s.fillStyle=e.text;var C=Math.floor(t/A*100)+"%";var u=s.measureText(C).width;var v=B+t-u-w/2-4;if(t<=w+u){v=B+w/2}s.fillText(C,v,z+D/2+3.25);s.restore()}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(ai,w,e){if(typeof(e)!=="object"){e={}}if(!w||typeof(w)!=="object"){w={}}var m=this;this.parameters=(ai&&typeof(ai)==="object")?ai:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Y=false;var N={};var A=0;var q;var ac={};var H=m.debug=new a.EmptyDebugger();var D=false;var x={};var an=false;var S={stickynotes:"bookmarks"};var f;var X=false;var s;var K;var ae;var c;var l;var u="token";var v;var o;if(a.isInternetExplorer&&a.versionInternetExplorer<10){o=function(ap){var ao;if(!a.utils.isCrossDomain(ap)){an=false;ao=new XMLHttpRequest()}else{an=true;ao=new XDomainRequest()}return ao}}else{if(typeof(XMLHttpRequest)!=="undefined"){o=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(aq){m.reset();s=(typeof(e.strSection)==="string")?e.strSection:"";K=s.toLowerCase();if(typeof(e.strTraceParam)==="string"){var ao=e.strTraceParam.toLowerCase();c={};c[ao]=true;if(ao.indexOf("_")>0&&ao.indexOf("pages")===0){ao=ao.split("_");ao.shift();ao=ao.join("_");c[ao]=true}var ap=m.getParameterAlias(ao);if(ap){c[ap]=true}}else{c=false}if(aq){if(m.parameters){m.parameters=a.utils.mergeObjects(m.parameters,aq)}else{m.parameters=aq}}ah(m.parameters);m.getQueryParameters();m.cloneParameters(m.cfgDefaults,m.cfg);m.cloneParameters(m.queryParameters,m.cfg);m.elevateToHTTPS();d();m.locationFSIViewer="";if(m.queryParameters.fsiviewerlocation!==b){m.locationFSIViewer=m.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());m.locationFSIViewer=a.getViewerLocation()}if(m.locationFSIViewer.charAt(m.locationFSIViewer.length-1)!=="/"){m.locationFSIViewer+="/"}m.nextConfigURL=m.getReloadPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.defaultcfg));m.checkDebug(false)};var ah=this.makeObjectPropertiesLowerCase=function(ao){for(var ap in ao){var aq=ap.toLowerCase();if(ap!==aq){if(ao[aq]===b){ao[aq]=ao[ap]}delete ao[ap]}}};this.getClassParameters=function(){return ae};this.setAccessToken=function(ao){v=ao};this.getParameterAlias=function(aq){var ao;if(m.cfgAliasNames[aq]){ao=m.cfgAliasNames[aq]}else{for(var ap in m.cfgAliasNames){if(m.cfgAliasNames[ap]===aq){ao=ap;break}}}return ao};var d=function(){Y=m.makeBool(m.cfg.usenc,false);if(m.cfg.usencquery!==b&&m.cfg.usencquery.length>0){D=m.cfg.usencquery;Y=true;m.queryToObject("?"+D,x)}};this.stopPendingRequests=function(){for(var ap in N){var ao=N[ap];if(ao){ao.FSIaborted=true;if(ao.abort){ao.abort()}}}};this.destroy=function(){m.stopPendingRequests()};this.reset=function(){ae={};m.parameters={};H=m.debug=new a.EmptyDebugger();m.stopPendingRequests();q=Math.random();m.nIncludedConfigs=0;m.completedConfigs={};m.plugins={};m.cfg={};m.queryParameters=b;m.arUnrecognizedConfigNodes=[];aj=0;m.arConditions=[];ac={}};this.getQueryParameters=function(){if(m.queryParameters!==b){return}m.queryParameters={};m.cloneParameters(m.parameters,m.queryParameters)};this.makeBool=function(ar,ao){if(typeof(ao)!=="boolean"){ao=false}var ap=ao;switch(typeof(ar)){case"string":var aq=a.makeBool(ar);if(aq!==b){ap=aq}break;case"number":ap=Boolean(ar);break;case"boolean":ap=ar;break}return ap};this.parsePositionParameter=function(ap){if(typeof(ap)!=="string"||ap.length<3){return b}ap=ap.split(",");if(ap.length<3){return b}for(var ao=0;ao<3;ao++){ap[ao]=parseFloat(ap[ao]);if(isNaN(ap[ao])){ap[ao]=0}}return{x:ap[0],y:ap[1],z:ap[2]}};this.logLoadFileFailed=function(ao){if(!H.on){return}if(ao&&ao.status!==b){var aq="HTTP "+ao.status;if(ao&&ao.statusText){aq+=", "+ao.statusText}var ap=(ao._url)?ao._url:"";H.error("Failed to load "+ap+" ("+aq+")")}else{H.error("Failed loading a file");if(ao&&ao._url){H.error(ao._url)}}};this.getAttributeValue=function(ap,ao){if(!ap){return}return ap.getAttribute(ao)};this.getImageURL=function(aq,ao){var ap;if(aq===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="image"}if(ao.renderer===b){ao.renderer="jpeg"}if(v){ao[u]=v}ao.source=aq;for(ap in ac){if(ac[ap]!==b&&ao[ap]===b){ao[ap]=ac[ap]}}for(ap in aa){if(ao[ap]){if(aa[ap]!==ap){if(!ao[aa[ap]]){ao[aa[ap]]=ao[ap]}ao[ap]=null}}}return m.requestBase+"?"+m.objectToQuery(ao)};this.getImageInfoURL=function(ap,ao){if(ap===b){return""}if(ao===b){ao={}}if(ao.type===b){ao.type="info"}if(ao.tpl===b){if(m.cfg.fpxinfotemplate!==b){ao.tpl=m.cfg.fpxinfotemplate}else{ao.tpl="info.json"}}if(m.cfg.headers&&m.cfg.headers.length>0){ao.headers=m.cfg.headers}if(!ao.tpl.match(/.json$/)){ao.tpl+=".json"}ao.source=ap;if(v){ao[u]=v}return m.requestBase+"?"+m.objectToQuery(ao)};this.queryToObject=function(at,aq){if(aq===b){aq={}}var ar,av,au,ao,ap;ar=at.indexOf("?");if(ar!==-1){ap=at.slice(ar+1)}else{ap=""}ar=ap.indexOf("#");if(ar!==-1){ap=ap.substring(0,ar)}ap=ap.split("&");for(ar=0;ar<ap.length;ar++){av=ap[ar].split("=");au=a.utils.urlDecode(av[0]).toLowerCase();if(au.length>0){ao=a.utils.urlDecode(av[1]);aq[au]=ao}}return aq};this.parseSceneSets=function(ao,at){var aA={};if(at===b){at=true}var aF=[];var aD=0;var aB=0;var aq;var av,au,ar,az,ax,aE;var aw,ay,aC;var ap=m.cfg.scenesets;if(ao>1&&ap!==b&&typeof(ap)==="string"){ay=ap.split(";");for(av=0;av<ay.length;av++){aC=[];aw=ay[av].split(",");aB=0;for(au=0;au<aw.length;au++){aE=aw[au].split("-");az=ax=0;if(aE.length===1){az=parseInt(aE[0])}else{az=parseInt(aE[0]);if(isNaN(az)){az=1}aq=false;if(aE[1].charAt(0)===">"){aE[1]=aE[1].substr(1);if(!isNaN(parseInt(aE[1]))){aq=true}}ax=parseInt(aE[1]);if(isNaN(ax)){ax=ao}if(az>0&&ax>0&&az<=ao&&ax<=ao){if(aq===true||az!==ax){if(aq!==true){if(ax<az){for(ar=az;ar>=ax;ar--){aC[aB]=ar;aB++}}else{for(ar=az;ar<=ax;ar++){aC[aB]=ar;aB++}}}else{for(ar=az;ar<=ao;ar++){aC[aB]=ar;aB++}for(ar=1;ar<=ax;ar++){aC[aB]=ar;aB++}}}}}if(az>0&&az<=ao&&(ax===0||ax===az)){aC[aB]=az;aB++}}if(aB>0){aF[aD]={};aF[aD].arScenes=[];aF[aD].arScenes=aF[aD].arScenes.concat(aC);aD++}}}if(aD===0){aA.bDefault=true;if(at){aF[0]={};aF[0].arScenes=[];for(av=0;av<ao;av++){aF[0][av]=av}}}aA.nSceneSets=aD;aA.bHasMultipleSets=(aA.nSceneSets>1);aA.arSets=aF;aA.nCurrent=1;return aA};this.objectToQuery=function(ap){var ao=[];var at,aq;if(Y&&D!==false){for(at in x){ap[at]=x[at]}}for(at in ap){aq=ap[at];if(aq!==null){aq=encodeURIComponent(aq);ao.push(encodeURIComponent(at)+"="+aq)}}return ao.join("&")};this.loadImageInfo=function(ar,ao,aq){var ap=m.getImageInfoURL(ar);m.loadFile(ap,ao,b,aq)};this.loadFile=function(at,ar,aq,ax,aw,ap,au){if(!at||at.length<0){if(ar){setTimeout(function(){ar(null,"",ax)},0)}return}if(aw===b){aw="GET"}if(ap===b){ap=null}else{if(typeof(ap)==="object"){ap=m.objectToQuery(ap)}}if(aq===b){aq="application/json"}var av=o(at);if(aq&&av.overrideMimeType){av.overrideMimeType(aq)}av._url=at;var ao=A;N[A]=av;A++;if(an){av.onerror=function(){delete N[ao];if(ar===b||this.FSIaborted){return}m.logLoadFileFailed(this)};av.onload=function(){delete N[ao];if(ar===b||this.FSIaborted){return}var ay=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var az=new ActiveXObject("Microsoft.XMLDOM");az.async=false;az.loadXML(ay);ay=this.responseXML=az}catch(aA){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(at)}break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(aA){H.error("Failed parsing JSON from URL: "+at+" ("+aA.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}else{av.onreadystatechange=function(){var ay;if(av.readyState!==4){return}delete N[ao];if(this.FSIaborted||typeof(ar)!=="function"){return}if(this.status>299){m.logLoadFileFailed(this)}switch(aq){case"application/xml":case"text/xml":ay=this.responseXML;break;case"application/json":ay={};try{ay=JSON.parse(this.responseText)}catch(az){H.error("Failed parsing JSON from URL: "+at+" ("+az.message+")")}break;default:ay=this.responseText}ar(this,ay,ax)}}av.open(aw,at,true);if(au&&v){av.setRequestHeader("x-token",v)}if(ap){av.setRequestHeader("Content-type","application/x-www-form-urlencoded");av.send(ap)}else{av.send()}return av};this.loadConfigs=function(){ae=(s.length>0)?{}:false;f=true;m.loadNextConfig(true)};this.loadNextConfig=function(ap){if(m.nextConfigURL===b){W();return}var aq={};if(e.bPreventCaching||m.makeBool(m.cfg.debug)||(!ap&&!m.makeBool(m.cfg.configcaching,true)&&m.makeBool(m.cfg.enableconfigcachingparameter))){m.addNoCacheParams(aq)}m.finishRequestParams(aq);var ao=m.addURLParameters(m.nextConfigURL,aq);H.log("Loading config file: "+ao);m.loadFile(ao,E,"application/xml")};this.setDebugger=function(ao){H=m.debug=ao};this.checkDebug=function(aq){if(e.bNoDebug){return}var ap;var ao;if(m.parameters.debug!==b){ao=m.makeBool(m.parameters.debug)}else{ao=m.makeBool(m.cfg.debug)}if(ao){if(!H||!H.on){H=m.debug=new a.Debugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}else{if(!H||H.on===true){H=m.debug=new a.EmptyDebugger();if(w.onDebuggerChange){ap=w.onDebuggerChange(H,aq)}}}return ap};var E=function(ao){var aq=ao.responseXML;l=m.nextConfigURL;m.parseConfig(aq);l=b;m.elevateToHTTPS();if(m.checkDebug(true)===true){return}d();if(f&&e.bCaptureDefaultCfg){f=false;m.cfgFromDefaultConfig=a.utils.cloneValue(m.cfg)}var ap;if(m.cfg.includeconfig!==b&&m.nIncludedConfigs<10){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.includeconfig));m.nIncludedConfigs++;m.cfg["_includeconfig("+m.nIncludedConfigs+")"]=m.cfg.includeconfig;m.cfg.includeconfig=b}else{if(m.cfg.cfg!==b){ap=m.getFSIPath(m.locationFSIViewer,m.expandFSIPath(m.cfg.cfg))}}if(ap!==b&&!m.completedConfigs[ap]){m.completedConfigs[ap]=true;m.nextConfigURL=ap;m.loadNextConfig()}else{m.evaluateQuery(m.queryParameters,m.cfg);W()}};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!m.makeBool(m.cfg.autoelevatetohttps,true)){return}h("fpxbase");h("fpxserver")};var h=function(ao){if(m.cfg[ao]!==b&&m.cfg[ao].length>0&&m.cfg[ao].indexOf("http://")===0){m.cfg[ao]="https"+m.cfg[ao].substr(4)}};this.evaluateQuery=function(ap,ao){for(var aq in ap){m.setConfigParamByValue(ao,aq.toLowerCase(),ap[aq])}};this.parseConfig=function(ap,aq){var aA="";var au;var aw=false;if(ap!==b){if(aq===b){aq=ap.firstChild}if(aq&&aq.nodeName==="xml"){aq=aq.nextSibling}var az=aq.childNodes;for(var av=0;av<az.length;av++){var at=az[av];if(at.nodeType!==1){continue}var ax;if(at._myTagName!==b){ax=at._myTagName}else{ax=at.nodeName.toLowerCase()}aA=ax;var ar=at.childNodes;aw=false;switch(ax){case"licence":break;case"if":m.arConditions.push(at);break;case"plugins":for(au=0;au<ar.length;au++){m.parsePluginNode(ar[au])}break;case K:aw=true;case"info":case"options":aA=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(au=0;au<ar.length;au++){var ay=ar[au];if(ay.nodeType!==1){continue}if(ay.tagName==="if"){ay._myTagName=ax;m.arConditions.push(ay)}else{var ao=m.getValueFromXMLNode(ay,aA);if(aA===b&&ae){if(aw){m.setConfigParam(ae,ao,null,true);m.setConfigParam(m.cfg,ao,ay)}else{if(ae[ao.name]===b){m.setConfigParam(m.cfg,ao,ay)}}}else{m.setConfigParam(m.cfg,ao,ay)}}}break;default:m.arUnrecognizedConfigNodes.push(at)}}}};this.getData=function(){var ao={};ao.cfg={};for(var ap in m.cfg){ao.cfg[ap]=m.cfg[ap]}return ao};this.setData=function(ao){if(!ao||!ao.cfg){return}m.cfg={};this.setCfgValues(ao.cfg)};this.setCfgValues=function(ao){for(var ap in ao){m.cfg[ap]=ao[ap]}V()};this.getImagesNodeList=function(aq){var ao=[];if(aq===b){aq=m.getUnrecognizedConfigNode("images")}if(aq){var ar=aq.firstChild;while(ar){if(ar.nodeType===1){var ap={};ap.attributes={};M(ar,ap.attributes);ap.cfg={};m.parseConfigFragment(ar,ap.cfg);ao.push(ap)}ar=ar.nextSibling}}return ao};this.removeUnrecognizedConfigNodes=function(){m.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ar){var ao;ar=ar.toLowerCase();for(var ap=m.arUnrecognizedConfigNodes.length-1;ap>-1;ap--){var aq=m.arUnrecognizedConfigNodes[ap];if(aq&&aq.nodeName.toLowerCase()===ar){ao=aq;break}}return ao};this.parseConfigFragment=function(ap,aw,av){var aA="";if(ap!==b&&aw!==b){if(av===b){av=[]}var az=ap.childNodes;for(var au=0;au<az.length;au++){var ar=az[au];if(ar.nodeType!==1){continue}var ax=ar.nodeName.toLowerCase();aA=ax;var aq=ar.childNodes;switch(ax){case"info":case"options":aA=b;case"fpx":case"image":case"include":for(var at=0;at<aq.length;at++){var ay=aq[at];if(ay.nodeType!==1){continue}var ao=m.getValueFromXMLNode(ay,aA);m.setConfigParam(aw,ao,ay)}break;default:av.push(ar)}}}};this.findXMLNode=function(ap,ao){if(ap===b||ap.nodeType===b){return b}while(ap){if(ap.nodeName.toLowerCase()===ao){break}if(ap.firstChild){ap=ap.firstChild}else{if(ap.nextSibling){ap=ap.nextSibling}else{ap=ap.parentNode.nextSibling}}}return ap};this.getValueFromXMLNode=function(aq,ao){if(!aq||aq.nodeType!==1){return}var ap={};var ar=(ao)?ao:"";ap.name=ar+aq.nodeName.toLowerCase();var at=aq.getAttribute("value");if(at){ap.value=at;return ap}ap.value=m.XMLChildNodesToString(aq);ap.node=aq;return ap};this.getXMLNodeAttribute=function(ar,aq,ao){if(!ar||ar.nodeType!==1||!ar.getAttribute){return ao}var ap=ar.getAttribute(aq);if(ap===b||ap==null){ap=ao}return ap};this.XMLChildNodesToString=function(aq,ap){var ao="";if(!aq||!aq.firstChild){return ao}if(aq.childNodes.length===1&&aq.firstChild.nodeType===3){ao=aq.firstChild.nodeValue}else{ao=aq.innerHTML}if(ap!==b){ao=ao.replace(/[\x00-\x1f]/g,ap)}return ao};this.hasPlugin=function(ao){return(m.plugins&&m.plugins[ao]!==b)};this.getPluginParameter=function(av,ap,ao,au,aw){av=av.toLowerCase();ap=ap.toLowerCase();if(m.plugins[av]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+av+"."+ap);return ao}var at;var ar=av+"_"+ap;if(aw&&m.cfg[ar]===b){ar=ap}if(m.cfg[ar]!==b){at=m.cfg[ar]}else{if(ae&&ae[ap]!==b&&K==="pages"){at=ae[ap]}else{var aq=m.plugins[av].parameters;if(aq!==b&&aq[ap]!==b){at=aq[ap]}}}if(at===b){at=ao}if(au){at=m.makeBool(at,ao)}return at};var Q=this.getAllPluginParameters=function(ap){ap=ap.toLowerCase();var aq=a.utils.cloneObject(m.plugins[ap].parameters);var at=ap+"_";var ao=at.length;for(var au in m.cfg){if(au.toLowerCase().indexOf(at)===0){var ar=au.substr(ao);aq[ar]=m.cfg[au]}}return aq};this.getIntParameterMinMax=function(ap,aq,ao,ar){return Math.min(ar,Math.max(ao,m.getIntParameter(ap,aq)))};this.getIntParameter=function(ap,aq){var ao=parseInt(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};this.getStringParameter=function(ap,aq){var ao=m.cfg[ap.toLowerCase()];if(ao===b){ao=aq}return ao};this.getFloatParameter=function(ap,aq){var ao=parseFloat(m.cfg[ap.toLowerCase()]);if(isNaN(ao)){ao=aq}return ao};var M=function(au,ap){if(!au||!au.attributes||!au.attributes.length||!ap){return false}var aq=au.attributes;for(var at=0;at<aq.length;at++){var ao=aq[at];var ar=ao.nodeName.toLowerCase();ap[ar]=ao.value}return true};this.parsePluginNode=function(aq){if(aq.nodeType!==1){return}var at={};M(aq,at);var ar=aq.childNodes;for(var ao=0;ao<ar.length;ao++){var au=ar[ao];if(au.nodeType!==1){continue}var ap=m.getValueFromXMLNode(au);if(ap.value!==b){at[ap.name]=ap.value;if(ap.node!==b){at[ap.name+".node"]=ap.node}}}this.addPluginFromString(at.src,at)};this.clone=function(){var ao=new a.Config(ai,w,e);ao.init();ao.cfg=a.utils.cloneObject(m.cfg);ao.plugins=a.utils.cloneObject(m.plugins);ao.arPlugins=a.utils.cloneArray(ao.arPlugins);ao.arUnrecognizedConfigNodes=a.utils.cloneArray(ao.arUnrecognizedConfigNodes);ao.setImageQueryParameters(ac);ao.arConditions=a.utils.cloneArray(m.arConditions);ao.hasImageParameterConditions=m.hasImageParameterConditions;return ao};this.setImageQueryParameters=function(ao){ac=a.utils.cloneObject(ao)};this.addPluginsFromString=function(aq){if(typeof(aq)!=="string"||aq.length<1){return}var ao=aq.split(",");for(var ap=0;ap<ao.length;ap++){var ar=a.trim(ao[ap]);m.addPluginFromString(ar)}};this.addPluginFromString=function(ar,at){if(typeof(ar)!=="string"||ar.length<1){H.error("PLUGIN without src parameter:");return}ar=ar.toLowerCase();if(S[ar]!==b){ar=S[ar]}if(at===b){at={}}var ap=m.plugins[ar]={};ap.name=ar;if(at.src===b){at.src=ar}ap.parameters=at;if(c){for(var au in c){if(au.indexOf(ar+"_")===0){var aq=ar+"_";var ao=au.substr(aq.length);if(typeof(ap.parameters[ao])!=="undefined"){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log(ap.parameters[ao]);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}else{if(au===ar){m.iTraceParameterDebug.group(l);m.iTraceParameterDebug.log('<Plugin src="'+ar+'">');m.iTraceParameterDebug.log("(enabled)");m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ap,aq,ao){m.setConfigParam(ap,{name:aq.toLowerCase(),value:ao})};var U=function(ap){if(ap.nodeType!==1){return"<unknown>"}var ao=m.XMLSerializer.serializeToString(ap.cloneNode(false));ao=ao.replace(/\/>$/gi,">");return ao};this.setConfigParam=function(ar,ao,at,au){var aw=ao.name;var ay=ao.value;if(!aw){return}if(c){for(var ax in c){if(ax===aw&&!au){if(typeof(at)==="object"&&typeof(at.tagName)==="string"){var av;if(l){av=l}var aq=at.parentNode;var ap=[];while(aq){if(aq.tagName==="if"){av="Matched Condition"}ap.unshift(U(aq));aq=aq.parentNode}ap.shift();ap.shift();m.iTraceParameterDebug.group(av);m.iTraceParameterDebug.log(ap.join(" "));m.iTraceParameterDebug.log(at);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}else{m.iTraceParameterDebug.group("By Parameter/Attribute:");m.iTraceParameterDebug.log(ay);m.iTraceParameterDebug.log("");m.iTraceParameterDebug.groupEnd()}}}}if(m.cfgAliasNames[aw]!==b){aw=m.cfgAliasNames[aw]}if(ar[aw]!==b&&(typeof(ay)==="string"&&a.utils.getBoolTable(ay.toLowerCase())===false)&&a.utils.getBoolTable(ar[aw])===b){delete ar[aw]}else{switch(aw){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ar[aw]!==b&&ar[aw].length>0&&ar[aw].indexOf(ay)===-1){ar[aw]+=","+ay}else{ar[aw]=ay}break;case"plugins":m.addPluginsFromString(ay);break;case"fpxpath":ar[aw]=ay;ar.fpxsrc=encodeURIComponent(ay);break;default:ar[aw]=ay;if(ao.node!==b){ar[aw+".node"]=ao.node}}}};var k={};k["="]=function(ap,ao){return(ap.toLowerCase()===ao.toLowerCase())};k["=="]=function(ap,ao){return(ap===ao)};k["!="]=function(ap,ao){return(ap.toLowerCase()!==ao.toLowerCase())};k["!=="]=function(ap,ao){return(ap!==ao)};k["<"]=function(ap,ao){return(ap<ao)};k["<="]=function(ap,ao){return(ap<=ao)};k[">"]=function(ap,ao){return(ap>ao)};k[">="]=function(ap,ao){return(ap>=ao)};k.match=function(ap,ao){var aq=false;var at="g";if(ao.charAt(0)==="/"&&ao.lastIndexOf("/")>0){var ar=ao.split("/");ar.shift();at=ar.pop();ao=ar.join("/")}try{var au=new RegExp(ao,at);aq=(ap.match(au)!==null)}catch(av){H.error("Invalid regex in condition: "+ao)}return aq};k.notmatch=function(ap,ao){return !k.match(ap,ao)};var r={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var t=function(ap,aq){if(m.cfgAliasNames[aq]){aq=m.cfgAliasNames[aq]}var ao=m.cfg[aq];if(ao===b){ao=""}if(!m.hasImageParameterConditions){m.hasImageParameterConditions=(aa[aq]!==b)}return G(ap,aq,ao)};var L=function(ar,at){var ao=false;var aq;var ap=ar.getAttribute("value");switch(at){case"@mobile":ap=m.makeBool(ap,true);aq=a.isMobileDevice;break;case"@devicepixelratio":aq=a.getDevicePixelRatio();break;case"@navigatoruseragent":aq=navigator.userAgent;break;case"@navigatorlanguage":aq=navigator.language;break;case"@navigatorplatform":aq=navigator.platform;break}if(aq!==b){if(typeof(ap)!=="string"){ap=""+ap}if(typeof(aq)!=="string"){aq=""+aq}ao=G(ar,at,aq,ap)}return ao};var G=function(ar,aq,au,at){var aw;var ap=ar.getAttribute("operator");if(typeof(ap)!=="string"){ap="="}ap=ap.toLowerCase();if(r[ap]){ap=r[ap]}if(k[ap]===b){ap="="}if(at===b){at=ar.getAttribute("value")}if(at===null){at=""}var ao=k[ap];if(ap.match(/[<,>]+/)){var ax=function(ay){ay=parseFloat(ay);if(isNaN(ay)){aw=false}return ay};au=ax(au);at=ax(at)}else{au=decodeURIComponent(au)}if(aw===b){aw=ao(au,at)}if(H.on){H.log("Evaluating condition: "+aq+": "+au+" "+ap+" "+at+" => "+aw)}if(aw===true){if(ar._myTagName!==b){var av={};av.nodeType=1;av.tagName=ar._myTagName;av.childNodes=[ar];ar=av}m.parseConfig(ar,ar)}return aw};var aa={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ab={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var Z;var T=function(){if(Z===b){Z={};for(var ao in aa){Z[aa[ao]]=ao}}return Z};var p=function(at,ar,aq){if(aq===b){aq=""}var av=aq+"left";if(at[av]===b){return}var au=aq+"top";var ap=aq+"right";var ao=aq+"bottom";if(ar==="pixelrange"){at[ap]=at[ap]-at[av];at[ao]=at[ao]-at[au]}at[ar]=at[av]+","+at[au]+","+at[ap]+","+at[ao];if(at[av]){delete at[av]}if(at[au]){delete at[au]}if(at[ap]){delete at[ap]}if(at[ao]){delete at[ao]}};var al=this.mapImageParametersToViewer=function(ao){p(ao,"rect");p(ao,"pixelrange","pixel");T();ag(ao,T())};var ak=this.mapImageParametersToServer=function(ao){ag(ao,aa)};var ag=function(ap,ao){for(var aq in ap){if(ao[aq]&&aq!==ao[aq]){ap[ao[aq]]=ap[aq];delete ap[aq]}}};this.reWriteImageURLByConditions=function(av){if(m.arConditions.length<1){return av}if(typeof(av)!=="string"||av.length<1){return av}var aq=av.indexOf("?");if(aq===-1){return av}var ap=m.clone();var at={};m.parseQuery(av,at);al(at);m.evaluateQuery(at,ap.cfg);var ao=ap.evaluateConditions();if(!ao){return av}var au;for(au in at){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}for(au in ab){if(ap.cfg[au]!==b){at[au]=decodeURIComponent(ap.cfg[au])}}ak(at);var ar=av.substr(0,aq);return ar+"?"+m.objectToQuery(at)};var n=this.applyConditions=function(){if(m.arConditions.length<1){return}if(m.cfgBeforeConditions===b){m.cfgBeforeConditions=a.utils.cloneObject(m.cfg)}m.cfg=m.cfgBeforeConditions;return g()};var aj=0;var g=this.evaluateConditions=function(){if(m.arConditions.length<1){return false}var ap=false;for(var aq=aj;aq<m.arConditions.length;aq++){var ar=m.arConditions[aq];if(ar.fsiConfigEvaluated){continue}aj++;var at=ar.getAttribute("parameter");if(typeof(at)==="string"){at=at.toLowerCase();var ao;if(at.charAt(0)==="@"){ao=L(ar,at)}else{ao=t(ar,at)}if(!ap&&ao){ap=ao}}}return ap};var V=function(){n();m.serverProfile=m.cfg.fpxservertemplate;m.serverProfileDoublePage=m.cfg.fpxservertemplatedoublepage;if(m.serverProfileDoublePage===b){m.serverProfileDoublePage="doublepage"}m.serverBase=m.cfg.fpxserver;if(m.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+m.locationFSIViewer+")");var ap;ap=m.locationFSIViewer.indexOf("/users/");if(ap!==-1){m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}else{ap=m.locationFSIViewer.indexOf("/viewer/");m.serverBase=m.locationFSIViewer.substring(0,ap)+"/server"}H.log("Derived server location is: ["+m.serverBase+"]")}m.requestBase=m.serverBase;ac={};var ao=m.cfg;for(var aq in ab){if(ao[aq]!==b){ac[aq]=ao[aq]}}if(ac.fpxsrc!==b){ac.fpxsrc=decodeURIComponent(ac.fpxsrc)}ao=m.cfg.effects;if(ao!==b){m.cfg.effectsUnFiltered=ao;m.cfg.effects=ao=j(ao)}if(ao!==b){ac.effects=ao}ao=m.cfg.lefteffects;if(ao!==b){ac.lefteffects=ao}ao=m.cfg.righteffects;if(ao!==b){ac.righteffects=ao}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){m.setEffectsFilter(m.getAreaEffects())};this.setEffectsFilter=function(at){if(typeof(at)!=="string"||at.length<1){X=false;return}at=a.trim(at);var ap=at.split(",");for(var aq=0;aq<ap.length;aq++){ap[aq]=a.escapeRegEx(ap[aq])}var ao="(^|[=,]+)("+ap.join("|")+")\\([^)]*\\)";X=new RegExp(ao,"ig")};var j=function(ao){if(X===false){return ao}return ao.replace(X,"")};var i=function(){for(var ap in m.plugins){var aq=ap.toLowerCase();var ao=m.makeBool(m.cfg[aq],true);if(!ao){m.plugins[ap]=b}}};var W=function(){m.elevateToHTTPS();i();V();m.dumpConfig();if(w.onConfigsReady){w.onConfigsReady()}};this.dumpConfig=function(aq){if(!aq){aq=H}if(aq.on){if(m.cfg.fpxsrc!==b){m.cfg["fpxsrc (decoded)"]=decodeURIComponent(m.cfg.fpxsrc)}aq.info("Evaluated Configuration:",P(m.cfg));if(m.queryParameters){aq.info("Parameters:",P(m.queryParameters))}if(ae){aq.info("Class <"+s+"> Configuration:",P(ae))}var ap=m.getPluginsAndParameters();var ao=ap.data;if(ap.count===0){ao="No active plugins."}aq.info("Plugin Configuration:",P(ao))}};var P=function(aq){var ao="--- none ---";if(typeof(aq)!=="object"){return ao}for(var ap in aq){ao=aq;break}return ao};this.getPluginsAndParameters=function(){var ao={};var aq=0;for(var ap in m.plugins){if(m.hasPlugin(ap)){ao[ap]=Q(ap);aq++}}return{count:aq,data:ao}};var J=this.addQueryParameterToURL=function(ar,ao,aq){var ap=ar.lastIndexOf("?");if(ap===-1){ar+="?"}else{if(ap!==ar.length-1){ar+="&"}}return ar+encodeURIComponent(ao)+"="+encodeURIComponent(aq)};var am=m.finishURL=function(ao){if(v){ao=J(ao,u,v)}if(!Y||ao===b){return ao}var ap;if(D===false){ap="cache=0&cachernd="+q;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+="&"+ap}}else{ap=D;if(ao.indexOf("?")===-1){ao+="?"+ap}else{ao+=ap}}return ao};this.addURLParameters=function(ap,aq){if(!ap||!aq){return ap}var ao=[];for(var at in aq){ao.push(encodeURIComponent(at)+"="+encodeURIComponent(aq[at]))}if(ao.length>0){if(ap.indexOf("?")===-1){ap+="?"}else{ap+="&"}ap+=ao.join("&")}return ap};this.finishRequestParams=function(ap){if(Y){if(D===false){ap.cache=0;ap.cachernd=q}else{for(var ao in x){ap[ao]=x[ao]}}}};this.addNoCacheParams=function(ao){ao.cache=0;ao.cachernd=q};this.parseQuery=function(ap,ao){if(typeof(ao)!=="object"||typeof(ap)!=="string"||ap.length<1){return}m.queryToObject(ap,ao);if(ao.ignorequeryparameters!==b){delete ao.ignorequeryparameters}if(ao.enableconfigcachingparameter!==b){delete ao.enableconfigcachingparameter}};this.cloneParameters=function(ao,ap){if(ao===b||ap===b){H.error("Cloning object failed: "+ao+" / "+ap)}for(var aq in ao){ap[aq]=ao[aq]}};this.getFSIPath=function(ao,ap){if(ap.indexOf("//")!==-1){return ap}if(m.cfg.fsibase!==b){ap=m.cfg.fsibase+ap}return m.getReloadPath(ao,ap)};this.expandFSIPath=function(ap){if(ap===b){return ap}var ao=a.utils.urlDecode(ap);if(ao.indexOf("?")!==-1||ao.indexOf(".xml")===(ao.length-4)){return ap}return ap+".xml"};this.getReloadPath=function(ar,au){var ap,av,ao,at;if(ar===b){ar=m.locationFSIViewer}if(typeof(au)!=="string"){au=""}var aq="/";if(au.indexOf("//")!==-1){return au}ap=ar;at=ap.lastIndexOf("?");if(at===-1){at=ap.length}av=ap.lastIndexOf("\\",at);ao=ap.lastIndexOf("/",at);av=Math.max(av,ao);if(av===-1){av=ap.length-1}ap=ap.slice(0,av);if(ap.length>0&&au.indexOf(aq)!==0){ap+=aq}return ap+au};var C=function(ao){var ap;if(!ao){return}if(ao.childNodes.length>0){ap=ao.innerHTML}else{ap=ao.getAttribute("value")}return ap};var I=function(aq,ar){var ap,ao;while(aq){if(aq.nodeName===ar){ao=aq;break}ap=aq.firstChild;if(!ap){ap=aq.nextSibling}if(!ap&&aq.parentNode){ap=aq.parentNode.nextSibling}aq=ap}return ao};var B=function(ap){var ao=I(ap,"images");if(!ao){ao=I(ap,"images3d")}return m.parseXMLImageListNode(ao)};var R=function(aq){var ap={};var au=ap.arImages=[];var at="";var aw="";var ax;if(!aq){return ap}var av;av=m.getAttributeValue(aq,"prefix");if(typeof(av)==="string"){at=av}av=m.getAttributeValue(aq,"suffix");if(typeof(av)==="string"){aw=av}aq=I(aq,"image");if(!aq){return ap}while(aq){if(aq.nodeType===1){ax=I(aq,"path");var ay=C(ax);if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"src"))}if(!ay){ay=a.utils.urlDecode(m.getAttributeValue(aq,"file"))}if(ay!==b){if(ad===false){au.push(at+ay+aw)}else{var ao=at+ay+aw;if(ad(ao)){au.push(ao)}}}if(ap.width===b){ax=I(aq,"width");ax=C(ax);if(ax!==b){ap.width=parseInt(ax)}ax=I(aq,"height");ax=C(ax);if(ax!==b){ap.height=parseInt(ax)}}}aq=aq.nextSibling}return ap};this.getImageList=function(){var aq,av,ap;z();if(m.cfg&&m.cfg.fpxsources!==b){var au=m.cfg.fpxsources;if(typeof(au)==="string"||(typeof(au)==="object")&&typeof(au.push)==="function"){aq={};aq.oXML=null;if(typeof(au)==="string"){if(ad===false){aq.arImages=au.split(",");for(av=0;av<aq.arImages.length;av++){aq.arImages[av]=a.utils.urlDecode(aq.arImages[av])}}else{var ao=au.split(",");aq.arImages=[];for(av=0;av<ao.length;av++){ap=a.utils.urlDecode(ao[av]);if(ad(ap)){aq.arImages.push(ap)}}}}else{aq.arImages=au}}}if(!aq&&m.arUnrecognizedConfigNodes&&m.arUnrecognizedConfigNodes.length>0){var at=m.arUnrecognizedConfigNodes;for(av=0;av<at.length;av++){var aw=at[av];if(typeof(aw.nodeName)==="string"){var ax=aw.nodeName.toLowerCase();if(ax==="images"||ax==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aq=R(aw);aq.oXML=aw;break}}}}if(!aq&&m.cfg&&m.cfg.fpxsrc!==b){aq={};aq.oXML=null;if(ad===false){aq.arImages=[a.utils.urlDecode(m.cfg.fpxsrc)]}else{ap=a.utils.urlDecode(m.cfg.fpxsrc);if(ad()){aq.arImages=[ap]}}}return aq};this.getServerBase=function(){return m.serverBase};this.loadImageList=function(ar,at,av,au){if(!m.serverBase||!ar){at([],b,au);return false}z();var aq=m.serverBase+"?type=list";if(ar.indexOf("tpl")===-1){var ap=m.cfg.listtemplate;if(ap&&ap.length>0&&ap.indexOf(".json")===-1&&ap.indexOf(".xml")===-1){ap+=".json"}aq+="&tpl="+ap}if(m.cfg.headers&&m.cfg.headers.length>0&&x.headers===b){aq+="&headers="+m.cfg.headers}if(typeof(m.cfg.imagelistlimit)==="string"&&m.cfg.imagelistlimit.length>0){aq+="&limit="+encodeURIComponent(m.cfg.imagelistlimit)}aq+="&source="+encodeURIComponent(ar);if(av!==b){aq+=av}aq=am(aq);var ao=m.loadFile(aq,function(aw,aA){if(typeof(aA)==="object"&&typeof(aA.images)==="object"){aA.images.pop();var aB="";if(aA&&aA.imagesattributes&&aA.imagesattributes.dir){aB=aA.imagesattributes.dir}var ax,az;if(ad===false){ax=new Array(aA.images.length);for(az=0;az<aA.images.length;az++){ax[az]=aB+aA.images[az].src}}else{ax=[];for(az=aA.images.length-1;az>-1;az--){var ay=aB+aA.images[az].src;if(af(ay)){ax.push(ay)}else{aA.images.splice(az,1)}}ax.reverse()}at(ax,aA,au)}else{at([],aA,au)}},"application/json",au);return ao};var af=function(ap){if(typeof(ap)!=="string"){return 1}var ao=1;if(O!==b){if(!ap.match(O)){ao=0}}if(ao===1&&y!==b){if(ap.match(y)){ao=0}}return ao};var ad=true;var O,y;var F=function(at){var aq;var av=m.cfg[at.toLowerCase()];if(!av||typeof(av)!=="string"||av.length<1){return}var ao=/\/([^/]*)$/;try{var ar=av.match(ao);if(ar&&ar.length>1){var ap=ar[1];av=av.replace(ao,"");av=av.replace(/^\//,"")}aq=new RegExp(av,ap)}catch(au){H.error("Invalid Regular Expression "+av+" in parameter "+at);H.error(au.message);aq=b}return aq};var z=function(){O=F("ListFilterPositive");y=F("ListFilterNegative");if(O===b&&y===b){ad=false}else{ad=af}};this.traceConfigValue=function(ao,ar){if(typeof(ao)!=="string"){return false}ao=a.trim(ao);if(ao.length<1){return false}var ap=ao.toLowerCase();if(ap.indexOf(".")!==-1){ap=ap.split(".").join("")}if(ap.indexOf("/")!==-1){ap=ap.split("/").join("")}if(ap.indexOf(" ")!==-1){ap=ap.split(" ").join("")}var aq=new a.Debugger();aq.setPrefix("");aq.group('Tracing parameter "'+ao+'"');var at=function(){var au=ao;var az=m.getParameterAlias(ap);if(typeof(az)==="string"){au+=" (alias: "+az+")";if(typeof(m.cfgAliasNames[ap])==="string"){ap=m.cfgAliasNames[ap]}}var av=m.cfg[ap];var ay=true;if(ap.indexOf("_")!==-1){var ax=ap.split("_");var aw=ax.shift();var aA=ax.join("_");if(m.hasPlugin(aw)){av=m.getPluginParameter(aw,aA)}}else{if(m.hasPlugin(ap)){ay=false;av="is enabled."}}if(av===b){ay=false;av="is undefined (default value applies)"}if(ay){av='= "'+av+'"'}aq.group("RESULT:");aq.log(au+" "+av);aq.groupEnd();aq.groupEnd()};w={onConfigsReady:at};e.strTraceParam=ap;e.bNoDebug=true;m.iTraceParameterDebug=aq;m.init(ar);m.loadConfigs();return""};this.loadLanguageFile=function(ao,aA,at,aq){var au=arguments;var av,ay;if(typeof(aA)!=="string"||m.makeBool(aA,true)===false){return at.call(m,{},"")}var az=function(aB){try{a.utils.oLanguageMap=JSON.parse(aB.responseText)}catch(aC){a.utils.oLanguageMap={"default":"english"}}m.loadLanguageFile.apply(this,au)};var aw=function(aB,aE){ao.urlLanguageCurrentLoaded=av;var aD=ao.oLanguageData={};if(aE){var aC=m.findXMLNode(aE,"data");if(aC){aC=m.findXMLNode(aC,"tip")}while(aC){if(aC.nodeType===1){var aF=aC.getAttribute("id");aD[aF]=m.XMLChildNodesToString(aC)}aC=aC.nextSibling}}at.call(m,ao.oLanguageData,ay)};if(aA.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){m.loadFile(a.getViewerLocation()+"/languages/mapping.json",az,"application/json");return}if(a.utils.oLanguageMap._current!==b){aA=a.utils.oLanguageMap._current}else{aA=a.utils.oLanguageMap["default"];var ar=navigator.language;if(typeof(ar)==="string"){ar=ar.toLowerCase()}if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}else{if(ar.indexOf("-")!==-1){ar=ar.split("-")[0];if(a.utils.oLanguageMap[ar]!==b){aA=a.utils.oLanguageMap[ar]}}}}if(aA===b){return at.call(m,{},"")}if(aq){aq.log('Automatically choosing language "'+aA+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aA}var ax=aA+".xml";var ap=a.getViewerLocation()+"/languages/"+ax;if(ap!==ao.urlLanguageCurrentLoaded){ay=aA;av=ap;if(aq){aq.log("Loading language file: "+ap)}m.loadFile(ap,aw,"application/xml")}else{at.call(m,ao.oLanguageData,ay)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){p.run(r,q);j[r]=[q]};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!=b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!=b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!=b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!=0||u!=0||v!=0||q!=0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!=-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!=-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!=b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!=b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRectByRefWidth=function(q){};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r==b&&u==b){r=i.width();u=i.height();A=1}else{if(r!=b){A=i.width()/r;if(u==b){u=i.height()/A}}else{A=i.height()/u;if(r==b){r=i.width()/A}}}if(z==b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left==0&&v.top==0&&v.width()==v._refWidth&&v.height()==v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left==0&&r.top==0&&r.width()==r._refWidth&&r.height()==r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,A){var B=new a.CroppedImage();var C,v;if(typeof(y)!="string"||y.length!=2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var z=p.isCropped();var q,D;var x,E;if(z){x=(1-h.left-h.right);E=(1-h.top-h.bottom);q=Math.round(x*c.width);D=Math.round(E*c.height)}else{q=c.width;D=c.height}if(u/q<s/D){v=s;C=Math.round(q/D*s);t=C-u;switch(y.charAt(1)){case"l":r.setRect(0,0,C-t,v);break;case"r":r.setRect(t,0,C,v);break;default:r.setRect(t/2,0,C-t/2,v)}}else{C=u;v=Math.round(D/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,C,v-t);break;case"b":r.setRect(0,t,C,v);break;default:r.setRect(0,t/2,C,v-t/2)}}r.scaleRectXY(1/C,1/v);if(p.isCropped()){C/=x;v/=E;if(A){C=Math.min(C,c.width);v=Math.min(v,c.height)}B.setSourceDimension(C,v);r.scaleRectXY(x,E);r.offsetRect(h.left,h.top)}else{if(A){C=Math.min(C,c.width);v=Math.min(v,c.height)}B.setSourceDimension(C,v)}B.widthUncropped=C;B.heightUncropped=v;B.setCropRect(r.left,r.top,r.right,r.bottom);return B}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomSkinClass!==b){return}a.CustomSkinClass=function(i,m,f,j){var q=this;var l;var o;var g;var k;var n=f.getCallbacks();var d=this.paramCustomSkinClass=m;var c;var p=function(){l=f.getRootContainer();o=f.getParentElement();q.destroy();c=a.getViewerLocation()+"/skins/";if(typeof(m)==="string"){if(m.match(/\.js$/)){var r=a.getViewerLocation()+"/"+m;c=r;c=c.replace(/\/[^/]*$/,"/");a.loadJavascript(r,f.getInstanceID(),q,e)}else{if(typeof(window[m])==="function"){k=new window[m](i,o,h,q)}}}else{if(typeof(m)==="function"){k=new m(i,o,h,q)}}};this.getSkinPath=function(){return c};this.replacePaths=function(r){r=r.replace(/\[fsi-skin-path\]/g,c);r=r.replace(/\[fsi-viewer-path\]/g,a.getViewerLocation()+"/");return r};this.loadHTMLFragment=function(s,v,t,r){s=q.replacePaths(s);var u=function(y,w,x){w=q.replacePaths(w);if(v&&typeof(v)==="object"&&v.tagName){while(v.firstChild){v.removeChild(v.firstChild)}v.innerHTML=w}t(w,r)};i.loadFile(s,u,"text/plain; charset=utf-8")};var h=function(s){g=s;if(s&&typeof(s)==="object"&&s.tagName){s.appendChild(l)}if(n.isset("onResize")){var r=f.getElementSpace();n.run("onResize",[r.width,r.height,true,f.getIsFullScreen()])}if(i.onResize){i.onResize({FSI_after_treshold:true})}j.apply(i)};var e=function(){d=d.replace(/\.js$/,"");var r=d.lastIndexOf("/");if(r!==1){d=d.substr(r+1)}if(d.length>0&&typeof(window[d])==="function"){k=new window[d](i,o,h,q)}else{h()}};this.getCustomSkinInstance=function(){return k};this.destroy=function(){if(k&&typeof(k.destroy)==="function"){k.destroy(q);k=b}if(g!==b){g=b;while(o.firstChild){o.removeChild(o.firstChild)}o.appendChild(l)}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Sprite!=b){return}a.Sprite=function(k,i,t,o,s,m,f){var n=this;var c=0.075;var d;var e=true;var u;var j;var v=1;var l=n.margin={left:0,top:0,right:0,bottom:0};var r={};r.width=i;r.height=t;var p=(s)?"canvas":"div";d=n.element=document.createElement(p);d.setAttribute("draggable","false");if(f){d.className=f}var g="";switch(m){case"inline":break;default:g+="position:absolute;z-index:"+o}a.utils.setStyleAttr(d,g);if(s){n.canvas=n.element;n.canvas.setAttribute("crossorigin","anonymous");n.canvas.setAttribute("width",r.width);n.canvas.setAttribute("height",r.height);n.ctx=n.canvas.getContext("2d")}if(k){k.appendChild(d)}this.remove=function(){if(k){a.removeChild(k,d)}};this.setPos=function(h,w){n.x=h;n.y=w;d.style.marginLeft=h+"px";d.style.marginTop=w+"px"};this.isVisible=function(){return(v>0)};this.show=function(h,w){if(e==h){return}e=h;if(j!=b){cancelAnimationFrame(j);j=b}if(!w){v=d.style.opacity=(h)?1:0;d.style.display=(h)?"block":"none"}else{u=(h)?c:-c;if(h){d.style.display="block"}q()}};this.updateMargins=function(){l=n.margin=a.getElementMargins(d)};this.getClientDim=function(){return a.getElementClientDim(n.element)};this.updateDimension=function(){r=a.getElementClientDim(d)};this.width=function(){return r.width};this.height=function(){return r.height};var q=function(){v+=u;if(u>0){if(v>=1){v=1;j=b}else{j=requestAnimationFrame(q)}}else{if(v<=0){v=0;j=b;d.style.display="none"}else{j=requestAnimationFrame(q)}}d.style.opacity=v};if(!s){this.setSize=function(x,y){r.width=x;r.height=y;if(typeof(x)!="string"){x+="px"}if(typeof(y)!="string"){y+="px"}n.element.style.width=x;n.element.style.height=y};this.clear=function(){}}else{this.setSize=function(x,y){r.width=x;r.height=y;n.canvas.width=x;n.canvas.height=y};this.clear=function(){n.ctx.clearRect(0,0,r.width,r.height)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ToolTip!=b){return}a.ToolTip=function(c){var q=this;var n;var h;var d;var m,l;var j;var k=false;var e={};var g=false;var i;var p=function(){n=document.createElement("div");a.addClass(n,"fsi-ui-tool-tip-container fsi-ui-tool-tip-container-hidden");h=document.createElement("div");a.addClass(h,"fsi-ui-tool-tip");n.appendChild(h);d=document.createElement("div");a.addClass(d,"fsi-ui-tool-tip-arrow");n.appendChild(d)};this.destroy=function(){q.hide();clearTimeout(j)};this.setContent=function(r){i=r};this.show=function(t,s,r,z,v,u,w){if(!i){return}e.strTip=t;e.elSrc=s;e.x=r;e.y=z;e.bNoAutoBold=w;e.fnGetToolTipText=v;if(l!=b){clearTimeout(l);l=b}if(m!=b){clearTimeout(m)}if(u==b){u=(k)?100:1000}m=setTimeout(f,u)};this.setParentContainer=function(r){q.hide();c=r};var f=function(){if(m!=b){clearTimeout(m);m=b}var w=e.strTip;var C,D;if(e.fnGetToolTipText!=b){D=e.fnGetToolTipText(w,i);if(D==b){D=i[w]}}else{D=i[w]}if(D!=b){w=D}else{if(!e.bNoAutoBold){w="<b>"+w+"</b>"}}h.innerHTML=w;c.appendChild(n);d.style.left="0px";n.style.display="inline-block";n.style.width=c.offsetWidth+"px";C=a.getElementClientPos(h);n.style.display="block";n.style.width=C.width+"px";var G=e.x;if(G==b){G=0}var F=e.y;if(F==b){F=0}var v;var u=a.getElementClientPos(c);if(e.elSrc!=b){v=a.getElementClientPos(e.elSrc);G+=v.left-u.left+(v.right-v.left)/2;F+=v.top-u.top}C=a.getElementClientPos(n);G-=C.width/2;F-=C.height+2;var t=document.body;var z=4;var E=G;var s=t.clientWidth;if(a.isMobileDevice){s=Math.max(t.clientWidth,u.width+u.left)}G=Math.min(s-u.left-C.width-z,Math.max(-u.left+z,G));var B=E-G;var r=d.offsetWidth/2;if(B!=0){var A=Math.min(n.offsetWidth/2-r,Math.abs(B));if(B<0){B=-A}else{B=A}}d.style.left=(n.offsetWidth/2-r+B)+"px";n.style.left=G+"px";n.style.top=F+"px";g=true;k=true;clearTimeout(j);j=setTimeout(o,1000);a.removeClass(n,"fsi-ui-tool-tip-container-hidden");a.addClass(n,"fsi-ui-tool-tip-container-visible")};var o=function(){k=false};this.hideAfter=function(r){if(r==b||isNaN(r)||r<1){r=2500}if(l!=b){clearTimeout(l);l=b}l=setTimeout(q.hide,r)};this.hide=function(){if(m!=b){clearTimeout(m);m=b}if(l!=b){clearTimeout(l);l=b}if(g){a.removeClass(n,"fsi-ui-tool-tip-container-visible");a.addClass(n,"fsi-ui-tool-tip-container-hidden");a.removeChild(c,n);g=false}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FullScreen!==b){return}a.FullScreen={};a.FullScreen.__initDone=false;a.FullScreen._nIDChangeEvent=0;a.FullScreen._nIDErrorEvent=0;a.FullScreen._eventHandlers={};a.FullScreen.__init=function(){var d=a.FullScreen;if(d.__initDone){return}d.__initDone=true;var c=0;if(document.webkitExitFullscreen){c=3}else{if(document.msExitFullscreen){c=1}else{if(document.mozCancelFullScreen){c=2}else{if(document.exitFullscreen){c=0}}}}switch(c){case 1:d.requestFullscreen="msRequestFullscreen";d.exitFullscreen="msExitFullscreen";d.fullscreenPseudoClass=":-ms-fullscreen";d.fullscreenChange="MSFullscreenChange";d.fullscreenError="MSFullscreenError";d.fullScreen="msFullscreenElement";d.fullscreenElement="msFullscreenElement";break;case 2:d.requestFullscreen="mozRequestFullScreen";d.exitFullscreen="mozCancelFullScreen";d.fullscreenPseudoClass=":-moz-full-screen";d.fullscreenChange="mozfullscreenchange";d.fullscreenError="mozfullscreenerror";d.fullScreen="mozFullScreen";d.fullscreenElement="mozFullScreenElement";break;case 3:d.requestFullscreen="webkitRequestFullscreen";d.exitFullscreen="webkitExitFullscreen";d.fullscreenPseudoClass=":-webkit-full-screen";d.fullscreenChange="webkitfullscreenchange";d.fullscreenError="webkitfullscreenerror";d.fullScreen="webkitIsFullScreen";d.fullscreenElement="webkitFullscreenElement";break;default:d.requestFullscreen="requestFullscreen";d.exitFullscreen="exitFullscreen";d.fullscreenPseudoClass=":fullscreen";d.fullscreenChange="fullscreenChange";d.fullscreenError="fullscreenError";d.fullScreen="fullScreen";d.fullscreenElement="fullscreenElement"}if(typeof(document[d.exitFullscreen])!=="function"){a.FullScreen.bUseFakeFullScreen=true}d.nMode=c};a.FullScreen.start=function(c){a.FullScreen.__init();a.FullScreen.quit();if(!a.FullScreen.bUseFakeFullScreen){c[a.FullScreen.requestFullscreen]()}else{a.FullScreen._enterFakeFullScreen(c)}};a.FullScreen.quit=function(){a.FullScreen.__init();if(!a.FullScreen._exitFakeFullScreen()&&!a.FullScreen.bUseFakeFullScreen){document[a.FullScreen.exitFullscreen]()}};a.FullScreen._enterFakeFullScreen=function(c){if(!c){return}var f=a.FullScreen.oFake={};f.elParentOriginal=c.parentNode;f.elNextSibling=c.nextSibling;f.el=c;var e,d;e=document.documentElement;f.docScrollLeft=e.scrollLeft;f.docScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;e=document.body;f.bodyScrollLeft=e.scrollLeft;f.bodyScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;d=f.bodyStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box";if(document.documentElement){e=document.documentElement;d=f.documentStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box"}a.FullScreen.bChanging=true;document.body.appendChild(c);a.FullScreen.bChanging=false;a.addEvent(window,"keydown",a.FullScreen._keyDown);a.FullScreen.callHandlers()};a.FullScreen._keyDown=function(c){if(c&&c.keyCode===27){a.FullScreen.quit()}};a.FullScreen._exitFakeFullScreen=function(){if(!a.FullScreen.oFake){return false}var f=a.FullScreen.oFake;a.FullScreen.bChanging=true;if(f.elParentOriginal){if(f.elNextSibling){f.elParentOriginal.insertBefore(f.el,f.elNextSibling)}else{f.elParentOriginal.appendChild(f.el)}}var e=document.body;var d=f.bodyStyle;var c;for(c in d){e.style[c]=d[c]}e.scrollLeft=f.bodyScrollLeft;e.scrollTop=f.bodyScrollTop;if(document.documentElement){e=document.documentElement;d=f.documentStyle;for(c in d){e.style[c]=d[c]}e.scrollLeft=f.docScrollLeft;e.scrollTop=f.docScrollTop}a.FullScreen.bChanging=false;a.FullScreen.oFake=b;a.FullScreen.callHandlers();a.removeEvent(window,"keydown",a.FullScreen._keyDown);return true};a.FullScreen.toggle=function(c){if(a.FullScreen.getEnabled()){a.FullScreen.quit()}else{a.FullScreen.start(c)}};a.FullScreen.getFullscreenPseudoClass=function(){a.FullScreen.__init();return a.FullScreen.fullscreenPseudoClass};a.FullScreen.addChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();a.FullScreen._nIDChangeEvent++;if(typeof(e)==="function"){if(!e._FSIFullScreenEventID){a.FullScreen._eventHandlers[a.FullScreen._nIDChangeEvent]=e;e._FSIFullScreenEventID=a.FullScreen._nIDChangeEvent}a.addEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.addEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.callHandlers=function(){var c={type:"fullscreenchange",FSI_fake:true};for(var e in a.FullScreen._eventHandlers){var d=a.FullScreen._eventHandlers[e];d(c)}};a.FullScreen.removeChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)==="function"){if(e._FSIFullScreenEventID&&a.FullScreen._eventHandlers[e._FSIFullScreenEventID]){delete a.FullScreen._eventHandlers[e._FSIFullScreenEventID]}a.removeEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.removeEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.getAvailable=function(d){a.FullScreen.__init();var c=d[a.FullScreen.requestFullscreen];return(c)};a.FullScreen.getEnabled=function(){a.FullScreen.__init();var c=a.FullScreen.getElement();return(c!==b&&c!==null)};a.FullScreen.getElement=function(){a.FullScreen.__init();var c;if(a.FullScreen.bUseFakeFullScreen){if(a.FullScreen.oFake){c=a.FullScreen.oFake.el}}else{c=document[a.FullScreen.fullscreenElement]}return c}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(n,aY,am,e,aO){var aF=this;var aM=false;var al=true;var p=false;var aU=false;var aL=false;var aC,F,j,ae;var aD,Z,aJ;var h=false;var af;var s;var a1={};var ar=[];var ad=0;var J=window;var aW;var t;var aV;var d;var a0=[];var aS={x:0,y:0};var w={x:0,y:0};var at=40;var o={};o.enabled=false;o.factor=5;o.fEndDiff=1;var az={};az.enabled=false;az.minFrames=14;az.factorAmount=23;az.factorAmountQuad=0;az.factorFrames=2.6;az.offsetFrames=5;var ac;var aA;var aI,x,l;var G;var au={};var Y;var aN=false;var A=false;var an={};an.name="none";var O;var X;var aP;var f=false;var aa={};if(!aY||typeof(aY)!="object"){aY={}}var ao=function(){var a7;if(aM){aF.destroy()}aV=B;t=b;if(a.utils.getTopWindow()!=window){t=a.utils.getTopWindow();try{var a6=a.getWindowOffset(window);if(a6.x!=b&&a6.y!=b){aV=aq}}catch(a5){aV=B;t=b}}else{t=b}G=aY.oPassTrough;aX(aY.panDirectionAllowed,true);if(aY.getPageCoords){s=aG}else{s=N}if(aY.afterTouch){for(a7 in aY.afterTouch){az[a7]=aY.afterTouch[a7]}}if(az.minDelta==b){az.minDelta=15}if(aY.nClickRadius){ac=aY.nClickRadius}else{ac=10}if(az.fnStartStopAfterTouch&&typeof(az.fnStartStopAfterTouch)!="function"){az.fnStartStopAfterTouch=b}if(az.fnStartStopAfterTouch){az.useAnimationFrame=b}if(typeof(az.modifyTarget)!="function"){az.modifyTarget=b}if(typeof(az.fnGetAfterTouchEnabled)=="function"){aA=az.fnGetAfterTouchEnabled}else{aA=b}if(aY.smoothing){for(a7 in aY.smoothing){o[a7]=aY.smoothing[a7]}}if(aY.detectClick==true){Y=true}if(aY.preventSelection!==false){aY.preventSelection=true}if(!n){return}if(typeof(n.join)!="function"){n=[n]}if(typeof(am)!="function"){am=B}if(typeof(e)!="function"){e=B}if(typeof(aO)!="function"){aO=B}if(typeof(aY.onPinchChange)=="function"){O=aY.onPinchChange}else{O=b}aN=aY.detectGestures;a0=[];ay(true,aN);for(var a4=0;a4<n.length;a4++){var a3=n[a4];if(a3&&typeof(a3.nodeName)!="undefined"){a7={};a7.element=a3;a0.push(a7);ap(a3,S);if(a.isTouch){try{if(a3.style!=b){if(a.BrowserSupports.cssTouchAction()){if(au.cssTouchAction!=b){r(a3,au.cssTouchAction)}}}}catch(a5){}}}}if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aE,false)}};var aX=this.setAllowedPanDirection=function(a4,a3){if(typeof(a4)=="string"){if(a4=="pan-x"||a4=="pan-y"||a4=="pan-x pan-y"){aW=a4+" "}else{aW=""}}else{aW=""}if(!a3){au.nCheck=b;ai(au.captureScroll,au.capturePinch)}};this.enable=function(a3){if(al==a3){return}if(!a3){R();ai(false,false)}else{ai(au.captureScrollUser,au.capturePinchUser)}al=a3};this.getEnabled=function(){return al};this.cancel=function(){Q();ah();aK();R()};var aK=function(){if(o.enabled){i()}C()};this.cancelAfterTouch=function(){C()};this.getInitialDownEvent=function(){return X};var R=function(){if(!p){return}aK();p=false;X=b;A=false;if(ad==0){aQ()}};var aQ=function(){f=false;c()};this.destroy=function(){if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aE,false)}if(aP){clearTimeout(aP)}aF.cancel();var a3;for(var a4=0;a4<a0.length;a4++){var a5=a0[a4];a3=a5.element;y(a3,S)}au={}};var r=function(a3,a4){if(!a.BrowserSupports.cssTouchAction()||!a3||!a3.style){return}a3.style.touchAction=a3.style.msTouchAction=a4};var U=function(a3){if(a3.preventDefault){a3.preventDefault()}};var m=function(a3){U(a3);return false};var ap=function(a4,a3){a.addEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{a.addEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a4,"touchstart",a3);a.addEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a4,"MSPointerDown",a3)}a.addEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var y=function(a4,a3){a.removeEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{a.removeEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a4,"touchstart",a3);a.removeEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a4,"MSPointerDown",a3)}a.removeEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var B=function(){return true};var aR=function(a3){if(aL){W(a3,a3.pointerId)}else{var a4=a3.changedTouches;for(var a5=0;a5<a4.length;a5++){W(a4[a5],a4[a5].identifier)}}};var W=function(a3,a5){if(a5==b||a1[a5]!=b){if(aY.debug){if(a5==b){a.console.error("doRegisterPointer: no pointerId")}if(a1[a5]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a5)}}return}ad++;var a4=a1[a5]={};a4.identifier=a5;s(a4,a3);ar.push(a4)};var ak=function(a3){var a5=false;if(aL){a5=L(a3.pointerId)}else{var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){a5=L(a4[a6].identifier)}}}if(a5){ar=new Array(ad);var a8=0;for(var a7 in a1){ar[a8++]=a1[a7]}}};var L=function(a3){if(a3==b||a1[a3]==b){if(aY.debug){if(a3==b){a.console.error("doUnregisterPointer: no pointerId")}if(a1[a3]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+a3)}}return false}delete a1[a3];ad--;return true};var I=function(){ad=0;a1={};ar=[]};var N=function(a4,a3){a4.x=a3.clientX;a4.y=a3.clientY};var aG=function(a4,a3){a4.x=a3.pageX;a4.y=a3.pageY};var v=function(a3){var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){var a5=a1[a4[a6].identifier];if(a5){s(a5,a4[a6])}}}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y}};var ax=function(a3){var a4=a1[a3.pointerId];if(a4){s(a4,a3)}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y;aV(a3,aS)}};var V=function(a3){s(aS,a3);aV(a3,aS)};this.getMousePositionFromMouseEvent=function(a3){V(a3);return aS};this.getMousePositionPage=function(a4){var a3={};aG(a3,a4);aV(a4,a3);return a3};this.getMousePositionClient=function(a4){var a3={};N(a3,a4);aV(a4,a3);return a3};var u=function(a3,a4){if(window!=a3.view){var a5=a.getWindowOffset(window);a4.x-=a5.x;a4.y-=a5.y}};var aq=function(a3){try{u(a3);aV=u}catch(a4){aV=B}};var aB=function(a3){if(!al){return}var a5=ad;if(A&&a5==0){A=false}var a6=a3.type;if(p||an.started){if(a6!=aC){if(an.started){Q();ah()}else{a3._FSI_Canceled=true;a2(a3,true)}}}aC=a6;d=false;var a4=true;switch(a6){case"touchstart":aU=true;aL=false;af=v;j="touchmove";F="touchend";ae="touchcancel";aI=false;break;case"MSPointerDown":af=ax;aU=true;aL=true;j="MSPointerDown";F="MSPointerUp";ae="MSPointerCancel";aI=false;d=true;break;case"pointerdown":af=ax;aU=true;aL=true;j="pointermove";F="pointerup";ae="pointercancel";aI=true;d=true;break;default:if(ad>0){I()}aU=false;aL=false;aI=(aY.preventSelection);a4=false;af=V;j="mousemove";F="mouseup";ae=b;d=true}if(aU&&a4){aR(a3)}af(a3);if(!aY.bAllowMouseDown&&aI){U(a3)}if(ad>1){aa.bClick=false}x=false;if(a4&&aj(a3)){if(a5==0){C();E()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ad};var S=function(a3){if(aY.bMouseOnly&&a3.type==="pointerdown"&&a3.pointerType!=="mouse"){return true}if(!aB(a3)){return}if(p||a3.which>1){return}g(a3)};this.getCurrentPos=function(){return w};var g=function(a3){aK();if(p){return}az.evtMove=b;if(o.enabled){w={x:aS.x,y:aS.y}}else{w=aS}aa.x=aS.x;aa.y=aS.y;var a4=X;X=a3;if(!am.call(J,a3,w,G)){X=a4;return false}p=f=true;if(Y&&!A){aa.bClick=true;aa.clickRadiusX=aa.clickRadiusY=0}else{aa.bClick=false}E();if(az.enabled){az.x=az.y=0;az.lastX=aS.x;az.lastY=aS.y;if(az.nInterval){clearInterval(az.nInterval)}az.nInterval=setInterval(ab,30)}return true};var c=function(){if(h&&Z!=b){var a3={passive:false,capture:false};var a5=(t==b)?a3:b;h=false;a.removeEvent(window,Z,ag,a5);a.removeEvent(window,aD,a2,a5);if(d&&t){try{a.removeEvent(t,Z,ag,a3);a.removeEvent(t,aD,a2,a3)}catch(a4){}}if(aJ!=b){a.removeEvent(window,aJ,av,a5)}Z=aD=aJ=b}};var aE=function(a3){};var E=function(){if(h){c()}h=true;var a3={passive:false,capture:false};var a5=(t==b)?a3:b;Z=j;aD=F;aJ=ae;a.addEvent(window,Z,ag,a5);a.addEvent(window,aD,a2,a5);if(d&&t){try{a.addEvent(t,Z,ag,a3);a.addEvent(t,aD,a2,a3)}catch(a4){}}if(ae!=b){a.addEvent(window,aJ,av,a5)}};var ag=function(a3){af(a3);a3.FSI_start_x=aa.x;a3.FSI_start_y=aa.y;if(az.enabled&&az.evtMove==b){az.evtMove=a3}if(p){if(aa.bClick){aa.clickRadiusX=Math.max(aa.clickRadiusX,Math.abs(aS.x-aa.x));if(aa.clickRadiusX>ac){aa.bClick=false}else{aa.clickRadiusY=Math.max(aa.clickRadiusY,Math.abs(aS.y-aa.y));if(aa.clickRadiusY>ac){aa.bClick=false}}}if(o.enabled){o.evt=a3;aZ()}else{e.call(J,a3,w,G)}}else{if(an.started){if(an.nType==1){aw(a3)}}}if(x&&!a3.FSI_allowEventDefault){U(a3)}};var aw=function(a3){var a4=k();if(!O){return}a3._FSI_PinchDeltaStart=an.nPinchDistance-an.pinchDistanceStart;a3._FSI_PinchDeltaRelative=an.nPinchDistance-an.pinchDistanceLast;a3._FSI_PinchScale=Math.max(at,an.pinchDistanceLast)/an.pinchDistanceStartMaxed;an.pinchDistanceLast=an.nPinchDistance;a3._FSI_PinchDistance=a4;O.call(J,a3,aS,G)};var av=function(a3){if(aU){ak(a3);if(ad<1){if(p){a3._FSI_Canceled=true;a2(a3,true);return}else{R();return}}}af(a3);aj(a3)};var a2=function(a4,a5){var a3=aa.bClick;aa.bClick=false;if(a5){a4._FSI_Canceled=true}if(aU){ak(a4)}if(ad==0){aQ()}af(a4);if(!a5&&aj(a4)){return}aK();if(!a5){if(!p||ad>0){return}}a4.FSI_start_x=aa.x;a4.FSI_start_y=aa.y;var a6=false;if(!a5&&az.enabled){if(aA==b||aA()){a6=T(a4)}}if(a6){R();z(a4)}else{if(Y){a4._FSI_Click=a3}aO.call(J,a4,w,G);if(a4.type=="touchend"){aP=setTimeout(q,1)}R()}U(a4)};var q=function(){R();I();aP=b};var H=function(a3){return ar};var aZ=function(){if(o.animationFrame!=b){return}aT()};var i=function(){if(o.animationFrame==b){return}cancelAnimationFrame(o.animationFrame);o.animationFrame=b};var aT=function(){var a3=Math.abs(w.x-aS.x)+Math.abs(w.y-aS.y);if(a3>o.fEndDiff){w.x+=(aS.x-w.x)/o.factor;w.y+=(aS.y-w.y)/o.factor;o.animationFrame=requestAnimationFrame(aT)}else{w.x=aS.x;w.y=aS.y;o.animationFrame=b}e.call(J,o.evt,w,G)};var T=function(a3){var a4;if(!az.enabled){return false}if(az.running){C()}az.pos=0;var a6=(a3.touches!=b)?1.8:1;if(az.factorAmountQuad){a4=(az.x>0)?1:-1;az.x=az.x+a4*az.x*az.x/az.factorAmountQuad;a4=(az.y>0)?1:-1;az.y=az.y+a4*az.y*az.y/az.factorAmountQuad}var a8=a6*az.factorAmount;az.startX=w.x;az.startY=w.y;var a7={};a7.x=az.startX+a8*az.x;a7.y=az.startY+a8*az.y;if(az.roundTargetPos){a7.x=Math.round(a7.x);a7.y=Math.round(a7.y)}if(az.modifyTarget){a7=az.modifyTarget.call(J,a7,G);if(a7===false){return false}}az.amountX=a7.x-az.startX;az.amountY=a7.y-az.startY;az.amountXABS=Math.abs(az.amountX);az.amountYABS=Math.abs(az.amountY);var a5=(az.amountXABS>az.minDelta||az.amountYABS>az.minDelta);if(a5){a8=az.factorFrames/100;az.frames=az.offsetFrames+Math.round(a8*az.amountXABS+a8*az.amountYABS)}else{if(typeof(aY.onAfterTouchCancel)=="function"){aY.onAfterTouchCancel.call(J,a3,w,G)}}return a5};this.isAfterTouchRunning=function(){return az.running};var z=function(a3){if(typeof(aY.onAfterTouchStart)=="function"){aY.onAfterTouchStart.call(J,a3,w,G)}az.running=true;az.evtUp=a3;if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,true,az.evtMove,G)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}else{az.intervalRun=setInterval(K,16)}}return true};var aH=function(a4,a3,a6,a5){return a6*((a4=a4/a5-1)*a4*a4+1)+a3};var K=this.runAfterTouch=function(){var a3=false;az.pos++;w.x=aH(az.pos,az.startX,az.amountX,az.frames);w.y=aH(az.pos,az.startY,az.amountY,az.frames);e.call(J,az.evtMove,w,G);if(az.pos===az.frames){C(true)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}a3=true}return a3};this.enableAfterTouch=function(a3){if(az.enabled==a3){return}if(!a3){C()}az.enabled=a3};var C=function(a3){if(!az.running){return}if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,false,az.evtMove,G)}else{if(az.useAnimationFrame){if(az.animationFrameRun){cancelAnimationFrame(az.animationFrameRun)}}else{if(az.intervalRun){clearInterval(az.intervalRun);az.intervalRun=b}}}if(typeof(aY.onAfterTouchEnd)=="function"){aY.onAfterTouchEnd.call(J,az.evtMove,G)}az.evtMove=b;az.running=false;az.evtUp._FSI_Canceled=(a3!==true);az.evtUp._FSI_fromAfterTouch=true;aO.call(J,az.evtUp,w,G)};var ab=function(){az.x=(2*az.x+aS.x-az.lastX)/5;az.y=(2*az.y+aS.y-az.lastY)/5;az.lastX=aS.x;az.lastY=aS.y};var ay=this.setCapture=function(a3,a5){var a4=ai(a3,a5);if(a4){au.captureScrollUser=a3;au.capturePinchUser=a5}return a4};var ai=function(a3,a5){var a4=0;if(a3){a4+=2}if(a5){a4+=4}if(a4==au.nCheck){return}au.nCheck=a4;au.captureScroll=a3;au.capturePinch=a5;if(a.BrowserSupports.cssTouchAction()){P(a3,a5)}return true};var P=function(a3,a7){if(aY.bMouseOnly){return}var a6;switch(au.nCheck){case 0:a6="auto";break;case 2:a6=aW+"pinch-zoom";break;case 4:a6="pan-x pan-y";break;default:a6=(aW.length>0)?aW:"none"}au.cssTouchAction=a6;for(var a5=0;a5<n.length;a5++){var a4=n[a5];r(a4,au.cssTouchAction)}};var k=function(){if(ar.length<1){return 0}var a4=Math.abs(ar[1].x-ar[0].x);var a3=Math.abs(ar[1].y-ar[0].y);return an.nPinchDistance=Math.sqrt(a4*a4+a3*a3)};var aj=function(a3){x=false;if(!al){return}var a4=ar.length;if(!aN){x=(a4==1&&au.captureScroll);return}if(an.pointerCount!=a4){Q(a3);if(a4>1){ah();an.nPointers=a4;switch(a4){case 2:an.started=true;an.name="pinch";an.nType=1;if(typeof(aY.onPinchStart)=="function"){M(a3);an.nPinchDistance=0;an.nPinchDistance=k();an.pinchDistanceStart=an.pinchDistanceLast=an.nPinchDistance;an.pinchDistanceStartMaxed=Math.max(at,an.pinchDistanceStart);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchStart.call(J,a3,aS,G)}break;default:an.started=true;an.name="unknown";an.nType=-1}if(an.started){A=true;if(p){aK();p=false;a3._FSI_Canceled=true;aO.call(J,a3,w,G)}if(typeof(aY.onGestureStart)=="function"){M(a3);aY.onGestureStart.call(J,a3,aS,G)}}}else{if(a4<1){ah()}}an.pointerCount=a4;x=false;if(a4==1){if(au.captureScroll){x=true}}else{if(au.capturePinch&&an.nType==1){x=true}}}return an.started};var ah=function(){if(!an.timeoutRestartDown){return}clearTimeout(an.timeoutRestartDown);an.timeoutRestartDown=b};var D=function(){if(ad!=1){return}g(X);ah()};var M=function(a3){a3._FSI_Gesture=an.name;a3._FSI_GestureType=an.nType;a3._FSI_PointerCount=an.nPointers};var Q=function(a3){if(!an.started){return}an.started=false;if(!a3){a3={}}if(an.nType==1&&typeof(aY.onPinchEnd)=="function"){M(a3);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchEnd.call(J,a3,aS,G)}if(typeof(aY.onGestureEnd)=="function"){M(a3);aY.onGestureEnd.call(J,a3,aS,G)}an.name="none";an.nType=0;if(a3&&ad==1){ah();an.timeoutRestartDown=setTimeout(D,20)}};ao()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.IMGLoadingEngine!==b){return}a.IMGLoadingEngine=function(q,h){var p=this;var n=0;var w=0;var l=(typeof(h)==="function")?h:a.fnDoNothing;var j={};var c=1;var s;var g,d;var v;this.destroy=function(){e();p.abortAll();c=1;u()};this.getCountLoading=function(){return n};this.load=function(x,z,B,y,C){var A=(!v||v[B]===b);if(typeof(C)!=="object"){C={}}if(typeof(x)!=="object"){return C}if(typeof(B)!=="string"||B.length<1){B="default"}if(j[B]===b){j[B]={__count:0}}j[B][c]=x;j[B].__count++;n++;if(A){if(w===0){m(1)}w++}a.addEvent(x,"load",r);a.addEvent(x,"error",f);x.FSIIMGLoadingEngineData=C;C.uid=c;C.url=z;C.strPurpose=B;C.bLoading=true;C.bVisual=A;if(typeof(y)==="function"){C.fnLoad=y}a.utils.loadImageCors(x,z);c++};this.setNotVisualPurposes=function(x){if(typeof(x)&&x!==null&&typeof(x.concat)==="function"){if(x.length>0){v={};for(var y=0;y<x.length;y++){v[x[y]]=true}}else{v=b}}};var m=function(x){if(!l||x===g){return}g=x;e();s=setTimeout(i,50)};var i=function(){if(g===d){return}d=g;e();l.call(q,d)};var e=function(){if(s!==b){clearTimeout(s);s=b}};var u=this.reset=function(){if(n>0){for(var y in j){var z=y[j];for(var x in z){t(z[x])}}}n=w=0;j={}};var k=function(x){return(typeof(x)==="object"&&typeof(x.FSIIMGLoadingEngineData)==="object")};var t=function(x){if(!k(x)){return false}var y=x.FSIIMGLoadingEngineData;if(!y.bLoaded){y.bAborted=true}n--;if(x.FSIIMGLoadingEngineData.bVisual){w--;if(w===0){m(0)}}if(j[y.strPurpose]!=b){if(j[y.strPurpose][y.uid]===b){a.console.error("IMGLoadingEngine: failed to remove item with purpose '"+y.strPurpose+" and uid "+y.uid)}else{j[y.strPurpose][y.uid]=b;delete j[y.strPurpose][y.uid];delete x.FSIIMGLoadingEngineData}j[y.strPurpose].__count--;if(j[y.strPurpose].__count===0){delete j[y.strPurpose]}}return true};this.abortAll=function(){if(n>0){for(var y in j){var z=j[y];for(var x in z){o(z[x]);if(!z[x]){break}}}}};var o=this.abortItem=function(x){if(!k(x)){return false}if(x.FSIIMGLoadingEngineData.bAborted){return true}x.FSIIMGLoadingEngineData.bAborted=true;if(x.FSIIMGLoadingEngineData.bLoaded){t(x)}return true};this.abortPurpose=function(y){if(n<1){return false}if(typeof(j[y])!=="object"||j[y].__count<1){return false}for(var x in j[y]){o(j[y][x]);if(!j[y]){break}}return true};var f=function(x){var y=this.FSIIMGLoadingEngineData;y.bError=true;r.apply(this,[x])};var r=function(x){var y=this;a.removeEvent(y,"load",r);a.removeEvent(y,"error",f);var z=y.FSIIMGLoadingEngineData;z.bLoading=false;z.bLoaded=true;if(!z.bError&&!z.bAborted){z.bSuccess=true}t(y);if(!z.bAborted&&z.fnLoad){z.fnLoad.apply(y,[x,z])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderCSSSkin!=b){return}a.LoaderCSSSkin=function(){var e=this;var j=0;var h={};var c=0;var d=new a.CORSLoader();var f=function(l){var k=false;try{if(l.cssRules!=b){k=l.cssRules}else{k=l.rules}}catch(m){console.error(m.message)}return k};var i=function(n,m,v,l,t){var s=this;var u;var B=[];var o;var y=0;var r=false;var q=false;this.uniqueID=c++;this.bReleased=false;this.getSkinName=function(){return m.getSkinName()};this.callReady=function(D,E,G,F){if(this.bReleased){return}if(F){q=true}o=arguments;r=true;p()};var p=function(){if(!r||y>0){return}if(q){u=setTimeout(z,1)}else{z()}};var z=function(){k();v.apply(l,o)};var k=function(){if(u!=b){clearTimeout(u);u=b}};this.remove=function(){k();if(s.bReleased){return}m.removeWaiter(s.uniqueID);for(var D=0;D<B.length;D++){B[D].remove()}this.bReleased=true};var C=function(D,E,G,F){if(F){q=true}y--;p()};if(t&&typeof(t)=="object"&&t.length>0){for(var w=0;w<t.length;w++){var x=t[w];y++;var A=a.utils.loadSkinCSS(x.file,s,C,x.nPriority);B.push(A)}}};var g=function(k,w){var t=false;var l=0;var v={};var q=false;var r=false;var s;var p;var m;var o;m=k.match(/(.*)\/[^/]*$/);m=m[1]+"/";m=m.replace(/\/resources\/$/,"/");p=k.replace(/\.[^/]*$/,"");p=p.match(/([^/]*)$/);p=p[1].toLowerCase();this.removeWaiter=function(x){if(v[x]==b){return}delete v[x];l--};this.addWaiter=function(x){if(x.uniqueID==b||x.bReleased){return}if(q){x.callReady(r,o,"ALREADY LOADED",false)}else{if(v[x.uniqueID]==b){v[x.uniqueID]=x;l++;if(!t){u()}}}};this.getSkinName=function(){return p};var n=function(H,A,I,C){var F=false;if(C>299||typeof(A)!="string"){a.console.error("Failed to load Skin CSS (HTTP "+C+"): "+k)}else{F=true;A=A.replace(/\[fsi-skin-path\]/g,m);s=document.createElement("style");s.setAttribute("type","text/css");s.setAttribute("x-generated-by","FSI");s.setAttribute("x-fsi-skin",p);s.setAttribute("x-fsi-priority",w);s.appendChild(document.createTextNode(A));var E=document.head;if(!E){E=document.getElementsByTagName("head");if(E&&E.length>0){E=E[0]}}if(E&&E.firstChild){try{var z;var J=E.getElementsByTagName("style");for(var B=0;B<J.length;B++){var G=J[B];var y=parseInt(G.getAttribute("x-fsi-priority"));if(isNaN(y)||y>w){z=G;break}}if(z){E.insertBefore(s,z)}else{E.appendChild(s)}}catch(D){E.appendChild(s)}}else{E.appendChild(s)}o=s.sheet;r=F}q=true;for(var x in v){v[x].callReady(r,o,"onLoaded",true)}v={};l=0};var u=function(){t=true;if(typeof(k)!="string"||k.length<0){return false}d.load(k,n,"text/css");return true}};this.load=function(p,q,m,r,l){if(r==b){r=100}var o=false;if(a.versionInternetExplorer<9){o=true}if(o){a.console.error("Unable to load skin: unsupported browser version.");if(m){m.call(q,false)}return false}if(a.getViewerLocation()==b||typeof(p)!="string"||p.length<1){a.console.error("Unable to load skin:");if(a.getViewerLocation()==b){a.console.error("FSI Viewer path not known")}else{a.console.error("Invalid skin URL "+p)}if(m){m.call(q,false)}return false}var k=p;if(k.indexOf("http")!=0){k=a.getViewerLocation()+"/skins/"+k}if(!k.match(/\.css$/)){k+=".css"}var s;if(h[k]==b){j++;s=h[k]=new g(k,r)}else{s=h[k]}var n=new i(k,s,m,q,l);s.addWaiter(n);return n}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderJavascript!=b){return}a.LoaderJavascript=function(){var e={};this.load=function(h,l,n,j,m){var k=e[h];if(n==b){n=window}if(typeof(j)!="function"){return false}if(k==b){k=e[h]={};k.path=h;k.loaded=false;k.failed=false;f(k);if(!g(k)){k.failed=true;k.loaded=true;k.addNodeFailed=true}}else{if(k.oListeners[l]!=b){d(h,l)}}k.nListeners++;var i=k.oListeners[l]={};i.argScope=n;i.argFunction=j;i.oPassThrough=m;if(k.loaded==true){c(k)}return true};var d=this.release=function(h,j){var i=e[h];if(i==b){return}if(i.oListeners[j]!=b){delete i.oListeners[j];i.nListeners--}};var g=function(l){var h=false;try{var i=document.getElementsByTagName("head");if(i&&i.length>0){i=i[0];var j=l.node=document.createElement("script");var k=l.onLoad=function(n){if(n.type=="error"){l.failed=true;c(l)}else{l.failed=false;c(l)}l.loaded=true};a.addEvent(j,"load",k);l.onError=function(n){l.failed=true;c(l);l.loaded=true};a.addEvent(j,"error",k);i.appendChild(j);j.src=l.path;h=true}}catch(m){}return h};var c=function(j){var h=!j.failed;a.removeEvent(j.node,j.onLoad);a.removeEvent(j.node,j.onError);for(var k in j.oListeners){var i=j.oListeners[k];i.argFunction.call(i.argScope,h,j.path,i.oPassThrough)}f(j)};var f=function(h){h.oListeners={};h.nListeners=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.AboutWindow!=b){return}a.AboutWindow=function(d,k){var m=this;var e;var g;var h;var f;var i;var l=function(){e=document.createElement("div");a.utils.setStyleAttr(e,"position: absolute;z-index:1000;width:12em;");e.className="fsi-ui-info-window";h=document.createElement("div");h.className="fsi-ui-title";f=document.createElement("div");f.style.display="inline-block";f.innerHTML=k.title;h.appendChild(f);i=document.createElement("div");i.style.display="inline-block";i.style["float"]="right";i.style.cursor="pointer";i.innerHTML="X";h.appendChild(i);e.appendChild(h);g=document.createElement("div");g.className="fsi-ui-content";var o=k.strLongVersion;o="<h3>"+o.replace(/ build/,'</h3><span class="small">build')+"</span>";var n;if(k.strCopyright==b){n="<br/><br/>&copy; 2018 NeptuneLabs GmbH<br/>";n+='<hr/><a style="color:inherit;text-decoration:none" href="//www.neptunelabs.com/" target="_blank">www.neptunelabs.com</a><br/><br/><span class="small">FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany<br/></span>'}else{k.strCopy=k.strCopyright}o+="<br/>"+n;g.innerHTML=o;e.appendChild(g);d.appendChild(e);a.addEvent(e,"click",j);c()};var c=function(){var o=a.getElementPosition(d);o.width=(o.right-o.left);o.height=(o.bottom-o.top);var n=a.getElementPosition(e);n.width=(n.right-n.left);n.height=(n.bottom-n.top);e.style.left=Math.round((o.width-n.width)/2)+"px";e.style.top=Math.round((o.height-n.height)/2)+"px"};var j=this.destroy=function(){if(typeof(k.fnOnDestroy)=="function"){if(!k.fnOnDestroy.call(this)){return}}a.removeEvent(e,"click",j);a.removeChild(e.parentNode,e)};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){a.CustomEventListener;if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.utils.getNewEventElementID()}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!=c){if(q){j()}else{i()}}};var m=function(p){var q;var r=a.utils.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!=q){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewport")){return}a.utils.registerCustomEvent("FSIViewport",function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.utils.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!=b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!=b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!=d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!=b){return}w=setTimeout(K,N);K()};var K=function(){if(w!=b){clearTimeout(w);w=b}var e=false;var U=L();if(C!=U){C=U;e=true;f()}return e};var J=function(){n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.utils.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);h.left=a.utils.getTopWindow().pageXOffset;h.top=a.utils.getTopWindow().pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!=b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!=b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u==b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!=b){if(U==b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length==0){r()}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIMouseWheel")){return}a.utils.registerCustomEvent("FSIMouseWheel",function(){var c=this;var f=100000;var g;a.utils.CustomEventListener.prototype.constructor.call(c,"FSIMouseWheel");c._strClassName="$FSI.CustomEventListenerMouseWheel";this._onListenerAdd=function(h){h.callback=function(i){d(h,i)};a.addEvent(h.element,"mousewheel",h.callback);a.addEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerRemove=function(h){a.removeEvent(h.element,"mousewheel",h.callback);a.removeEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerCountChange=function(h){if(h<1){if(g!=b){clearInterval(g);g=b}}};this.setListenerProps=function(k,i,j){if(typeof(i)!=="string"){return false}var h=c.getListenerObjectByID(k);if(!h){return false}switch(i){case"acceleration":if(j){h.bAccelerate=true;h.acceleration=j;h._accelerate=1;if(h._accelerateMax==b){h._accelerateMax=10}}break;case"accelerationMax":h._accelerateMax=j;break}};var e=function(){var j=c.getListenersArray();var k=true;for(var l=0;l<j.length;l++){var h=j[l];if(h.bAccelerate&&h._accelerate>1){h._accelerate/=1.5*h.acceleration;if(h._accelerate>1.5){k=false}else{k=true;h._accelerate=1}}}if(k){clearInterval(g);g=b}};var d=function(h,i){var k=0;if(i.detail){k=i.detail}else{if(i.wheelDelta){k=-i.wheelDelta}}if(k!=0){i.FSI_normalized_delta=(k>0)?-1:1;f=Math.min(f,Math.abs(k))}else{i.FSI_normalized_delta=0}if(h.bAccelerate){if(g==b){g=setInterval(e,200)}h._accelerate*=h.acceleration;h._accelerate=Math.min(h._accelerateMax,h._accelerate);k=Math.round(h._accelerate*k)}else{h._accelerate=1}i.FSI_delta=-k;i.FSI_weighted_delta=i.FSI_delta/f;i.FSI_normalized_accelerated_delta=(k>0)?-h._accelerate:h._accelerate;var j=c.fireEvent(h,i);if(j===false){h._accelerate=1}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.NavigatorWindow!=b){return}a.NavigatorWindow=function(q,A,w,J,E){var j=this;var af=q.iViewer;var t;var aa=0;var m;var p,C;var h;var F,r;var i,f;var u=false;var x=false;var M=q.getElementSpace();var N=q.getinPlaceZoom();var g=af.getImageIsTransparent();var U=q.getDrawRatio();var s=af.getSrcDim();var ad=q.getdrawRatioUnZoomed();var G=q.getdrawRatioUnResized();var W=q.viewport;var I;var V;var c={x:2,y:2};var d;var ae;var O=false;var Y;var Q;var ac={};var H;var B=false;var z;var K;var v=false;var e=true;var o;var Z=function(){u=A.result.autoHideNav;m=[];aa=4;h=16;o=A.makeBool(A.cfg.autohidenaviftoosmall,true);var aj=l(A.result.navWidth,W.width,120);var ap=l(A.result.navHeight,W.height,120);var am=Math.min(M.width-2*aa,aj);var an=Math.min(M.height-2*aa-20,ap);am=Math.max(60,am);an=Math.max(40,an);var al,ah;al=am;ah=al/ad.imageWidth*ad.imageHeight;if(ah>an){ah=an;al=ah/ad.imageHeight*ad.imageWidth}p=Math.max(10,Math.round(al));C=Math.max(10,Math.round(ah));var ao=p+2*aa;var ak=C+2*aa+h;F=ao;r=ak;j.sprite=new a.Sprite(J,ao,ak,500);a.addClass(j.sprite.element,"fsi-ui-nav-window");j.sprite.element.style.width=j.sprite.element.style.height="auto";if(w){d=w.navFrameBorderColor;ae=w.navFrameBackgroundColor}else{d="red";ae="rgba(255,255,255,0.5)"}j.canvasSprite=new a.Sprite(j.sprite.element,p,C,2,true,"inline");j.canvasSprite.element.style.clear="both";a.addClass(j.canvasSprite.element,"fsi-ui-nav-window-image");if(A.hasPlugin("zoommeter")){I=document.createElement("div");a.addClass(I,"fsi-ui-nav-window-zoom-text");j.sprite.element.appendChild(I);V=document.createTextNode("100 %");I.appendChild(V);var ai=A.getPluginParameter("zoommeter","color");if(ai){I.style.color="#"+ai}O=A.getPluginParameter("zoommeter","srcrelative",false,true)}j.sprite.updateMargins();j.sprite.updateDimension();var ag={};ag.smoothing={enabled:true,factor:7,fEndDiff:0.03};z=new a.TouchHandler(j.canvasSprite.canvas,ag,S,X,T);Q=j.canvasSprite.ctx;L();n();if(u){R(false,false)}};this.destroy=function(){if(z){z.destroy();z=b}a.removeChild(J,j.sprite.element)};this.enable=function(ag,ah){z.enable(ag);if(j.sprite&&j.sprite.element){if(ah){j.sprite.element.style.visibility="hidden"}else{j.sprite.element.style.visibility=""}}};var l=function(aj,ah,ai){var ag=parseInt(aj);if(typeof(aj)=="string"&&aj.indexOf("%")!=-1){ag=Math.max(0,Math.min(100,ag));ag=Math.round(ag*ah/100)}else{ag=parseInt(aj)}if(isNaN(ag)){ag=ai}return ag};this.isDragging=function(){return x};var S=function(ah,ak){q.onUserAction();q.stopAutoSpin();var ai=a.getElementPosition(j.canvasSprite.element);i=-ai.left;f=-ai.top;var ag=ak.x+i;var aj=ak.y+f;if(ag<0||aj<0||ag>p||aj>C){return false}x=true;q.stopDesktopAnimation();q.stopAfterTouch();y(ak,true);q.autoShowHideHotSpots(false);q.iCallbacks.run("onStartDragging",[true]);return true};var X=function(ag,ah){y(ah,true)};var T=function(ag,ah){q.onUserAction();x=false;y(ah,false);q.onAfterinPlaceZoomChanged();q.autoShowHideHotSpots(true);q.iCallbacks.run("onStopDragging",[true])};var y=function(aj,ah){var ag=aj.x+i-p/2;var ai=aj.y+f-C/2;N.panPos.left=K*-ag;N.panPos.top=K*-ai;q.updateInPlaceZoom(ah)};var P=function(ao,ax,ap,av,aq){var am,ak,aj,ai,an,aw,au;aw=ax;au=ap;ax=Math.max(1,Math.round(ax/2));if(ax<av){ax=av}ap=Math.max(1,Math.round(ap/2));if(ap<aq){ap=aq}ak=ai=document.createElement("canvas");ai.setAttribute("crossorigin","anonymous");ai.width=ax;ai.height=ap;an=ai.getContext("2d");an.drawImage(ao,0,0,aw,au,0,0,ax,ap);var ah=document.createElement("canvas");ah.setAttribute("crossorigin","anonymous");var al=ah.getContext("2d");var ag=false;while(ax>av||ap>aq){am=ak;aw=ax;au=ap;if(ag){ak=ai;aj=an;ag=false}else{ak=ah;aj=al;ag=true}ax=Math.round(ax/2);if(ax<av){ax=av}ap=Math.round(ap/2);if(ap<aq){ap=aq}ak.width=ax;ak.height=ap;aj.drawImage(am,0,0,aw,au,0,0,ax,ap)}var at;try{at=aj.getImageData(0,0,ax,ap);Y=D}catch(ar){at=ak;Y=k}return at};var D=function(ah,ag,ai){Q.putImageData(ah,ag,ai)};var k=function(ah,ag,ai){Q.drawImage(ah,ag,ai)};var L=function(){switch(c.x){case 2:j.sprite.element.style.left="auto";j.sprite.element.style.right=j.sprite.margin.right+"px";break;default:j.sprite.element.style.right="auto";j.sprite.element.style.left=j.sprite.margin.left+"px";break}switch(c.y){case 2:j.sprite.element.style.top="auto";j.sprite.element.style.bottom=j.sprite.margin.bottom+af.getMenuHeight("navWindow")+"px";break;default:j.sprite.element.style.bottom="auto";j.sprite.element.style.top=j.sprite.margin.top+"px";break}};this.setContainerSize=function(ag,aj,ai){var ah=j.sprite.element.style.display;j.sprite.element.style.display="block";j.sprite.updateDimension();U=aj;ad=ai;M=ag;j.sprite.element.style.display=ah;n()};var R=function(ag,ah){if(ag==b){ag=(!B&&v)}if(e==ag){return}e=ag;j.sprite.show(ag,ah)};var n=function(){if(!o){return}B=(M.width<4*j.sprite.width()||M.height<4*j.sprite.height());R(b,false)};var ab=this.autoShowHide=function(ag){if(!u){return}if(v!=(N.scale>1.05)){v=!v;R(b,ag)}};this.setPreviewImageSize=function(ag,ah){if(ag==b){H=b}else{ac.width=ag;ac.height=ah;H=ac}};this.update=function(aA,al){ab(true);if(!j.sprite.isVisible()){return}K=U.imageWidth/p;var aq=Q;if(m[aA]==b){var au=q.getPreviewImage(aA);var aw=(H)?H:au;m[aA]=P(au,aw.width,aw.height,p,C)}aq.lineWidth=0;var an=0;var am=0;if(I&&t!=al){t=al;var av,ag;if(O){av=al*G.imageWidth/s.width}else{av=U.imageWidth/ad.imageWidth}av=Math.round(100*10*av)/10;ag=""+av;if(ag.indexOf(".")==-1){ag+=".0"}ag+=" %";V.nodeValue=ag}Y(m[aA],an,am);var az=N.scale;if(az>1.05){var ap=p/G.imageWidth/az;var aj=ap*W.width;var ar=ap*W.height;var ax=p/U.imageWidth;var ao=(p-aj)/2-N.panPos.left*ax;var ay=(C-ar)/2-N.panPos.top*ax;var ai=an+ao;var ah=am+ay;var ak=an;var at=am;if(aj<4||ar<4){ai+=aj/2;ah+=ar/2;aq.strokeStyle=d;aq.strokeRect(ai,ah-3,1,7);aq.strokeRect(ai-3,ah,7,1)}else{aq.save();aq.fillStyle=ae;aq.beginPath();aq.rect(ak,at,p,ah-at);aq.rect(ak,ah,ai-ak,ar);aq.rect(ai+aj,ah,p-ao-aj,ar);aq.rect(ak,ah+ar,p,C-ay-ar);aq.closePath();aq.clip();aq.fillRect(an,am,p,C);aq.restore();aq.save();aq.strokeStyle=d;aq.beginPath();aq.rect(an,am,p,C);aq.clip();aq.strokeRect(ai,ah,aj,ar);aq.restore()}}};this.reverseImageSequence=function(){m.reverse();m.unshift(m.pop())};Z()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MenuBar!==b){return}a.MenuBar=function(k,s,A,J,r){var i=this;var M=this.myViewer=k.iViewer;var B=k.getElementSpace();var h;var x;var u=0;var D=[];var m=b;if(r===b){r={}}this.bEnabled=b;var C={};var n={};var L={};var g=0;var j=0;var z="fsi-ui-button-icon";var q;var E;var o=1;var y=[];var d;var v,K;var p=this.setInterface=function(){v=k.getDebug();K=k.getToolTip()};var G=function(){i.oInterface=k;var N=k.iConfig;E=N.makeBool(N.cfg.menubuttontooltips,true,true);p(k);i.btnID=0;i.sprite=new a.Sprite(A,B.width,g,450,b,b,"fsi-ui-menu-bar");i.sprite.element.style.width="100%";i.sprite.element.style.top="auto";i.sprite.element.style.left="0px";i.sprite.element.style.right="auto";i.sprite.element.style.lineHeight="100%";i.sprite.element.style.bottom="0px";i.sprite.element.style.visibility="hidden";i.iconClassNamesNormal=z;m=setTimeout(f,0)};this.groupButtons=function(N){var Q;var O=[];for(Q=0;Q<N.length;Q++){var P=i.getButtonByCMD(N[Q]);if(P&&P.elButton){O.push(P.elButton)}}if(O.length>0){var S=document.createElement("span");S.className="fsi-ui-button-group-container";var R=O[0].parentNode;R.replaceChild(S,O[0]);for(Q=0;Q<N.length;Q++){S.appendChild(O[Q])}y.push(S)}};var f=function(){if(i.sprite.element.offsetHeight!==0||u++>200){m=b;l()}else{m=setTimeout(f,25)}};this.getButtonContainerWidth=function(){return x.element.offsetWidth};this.addButtonCSSClass=function(N,O){F(N,O,true)};this.removeButtonCSSClass=function(N,O){F(N,O,false)};var F=function(P,Q,O){var N=n[P];if(N===b){return}if(O){a.addClass(N.elButton,Q)}else{a.removeClass(N.elButton,Q)}i.setExternalButtonState(P,N.getState(),N.elButton.className)};this.getExternalButtonID=function(){return o++};var l=function(){var O=i.sprite.getClientDim();g=Math.round(O.height);i.sprite.setSize("100%",g);i.setEnabled(false);if(typeof(s.urlLogo)==="string"&&s.urlLogo.length>0&&s.urlLogo!=="none"){h=document.createElement("div");a.addClass(h,"fsi-ui-logo");a.utils.setStyleAttr(h,"position:absolute;display:none");var N=document.createElement("img");N.className="fsi-ui-logo-image";N.style.backgroundImage="none";N.src=s.urlLogo;h.appendChild(N);a.addEvent(N,"load",w);i.sprite.element.appendChild(h);a.addEvent(h,"click",M.showAboutWindow)}a.addEvent(i.sprite.element,"mouseup",e);a.addEvent(i.sprite.element,"contextmenu",H);i.sprite.element.style.visibility="";J()};this.show=function(N){if(d===N){return}d=N;i.sprite.show(N,false)};this.getVisible=function(){return d};this.destroy=function(){t("onMenuDestroy");if(m!==b){clearTimeout(m);m=b}if(h){a.removeEvent(h,"click",M.showAboutWindow)}a.removeEvent(i.sprite.element,"mouseup",e);a.removeEvent(i.sprite.element,"contextmenu",H);i.removeButtons();i.removeDomElement()};this.removeDomElement=function(){if(i.sprite.element.parentNode){a.removeChild(i.sprite.element.parentNode,i.sprite.element);g=0}};var e=function(N){if(N.which&&N.which===3){j=new Date().getTime()}};var H=function(O){if(j){var N=new Date().getTime()-j;if(N<300){return}}O.preventDefault&&O.preventDefault()};this.getHeight=function(){return g};this.pressButton=function(O){var N=n[O];if(N!==b){N.onMouseDown()}};this.releaseButton=function(O){var N=n[O];if(N!==b){N.onMouseUp()}};var c=function(N,P){var Q=b;if(!N||!P){return Q}if(N.indexOf("_")!==-1){var O=N.split("_");switch(O[0]){case"MouseMode":Q="";if(P.Mode){Q+="<b>"+P.Mode+"</b>"}if(P["Mode"+O[1]]){Q+=" "+P["Mode"+O[1]]}break}}return Q};this.showButtonToolTip=function(O,P){var N;if(P){N=P.getAttribute("fsi-tool-tip");if(k.iConfig.makeBool(N,true)===false){return}}if(N==b){N=O.getCMD()}if(typeof(r[N])==="string"){N=r[N]}i.showToolTip(N,P)};this.getButtonDomElement=function(O){var N=n[O];if(N){return N.elButton}};this.showToolTip=function(P,O,N,Q){if(!K||!E){return}K.show(P,O,N,Q,c)};this.hideToolTip=function(){if(!K||!E){return}K.hide()};this.setEnabled=function(N,O){if(i.bEnabled===N){return}i.bEnabled=N;if(O){return}if(N){a.removeClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}else{a.addClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}t("onMenuEnabled",[N])};this.getButtonEnabled=function(O){var N=n[O];if(N===b){return}return N.bEnabled};this.showButton=function(P,N){var O=n[P];if(O===b){return false}return O.show(N)};this.enableButton=function(P,N){var O=n[P];if(O===b){return false}return O.setEnabled(N)};this.getButtonPressed=function(O){var N=n[O];if(N===b){return false}return N.getPressed()};this.setButtonPressed=function(P,N){var O=n[P];if(O===b){return false}O.setPressed(N);return true};var I=function(O,P){var N;if(C[P]===b){N=C[P]={};N.arButtons=[]}else{N=C[P]}N.arButtons.push(O);O.oGroup=N;O.makeRadioButton()};this.removeButtons=function(){var N;i.unregisterExternalButtons();for(N=0;N<D.length;N++){D[N].destroy()}for(N=0;N<y.length;N++){if(y[N]&&y[N].parentNode){y[N].parentNode.removeChild(y[N])}}D=[];C={};n={}};this.unregisterExternalButtons=function(){for(var P in L){var N=L[P];for(var O=0;O<N.length;O++){N[O].destroy(true)}}L={}};this.addButtons=function(Y,ac){i.removeButtons();var Q;var Z=g-6;var S,ad;var R,aa,T;var O="";if(typeof(ac)==="string"&&ac.length>0){O=" (sorted by parameter MenuButtonOrder)";var N=ac.split(",");var W={};for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){W[Y[aa].cmd.toLowerCase()]=aa}}var V=[];var ab={};for(aa=0;aa<N.length;aa++){T=a.trim(N[aa].toLowerCase());if(W[T]!==b){if(ab[T]===b){ab[T]=true;V.push(Y[W[T]])}}}for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){T=Y[aa].cmd.toLowerCase();if(!ab[T]){V.push(Y[aa])}}}Y=V}else{O=" (default)"}if(!x){x=new a.Sprite(i.sprite.element,B.width,g,2);a.utils.setStyleAttr(x.element,"position:relative");a.addClass(x.element,"fsi-ui-button-container")}var ae;if(v.on){ae=[]}for(aa=0;aa<Y.length;aa++){Q=Y[aa];if(Q.cmd){if(v.on){ae.push(Q.cmd)}if(Q.width===b){S=Z}else{S=Q.width}if(Q.height===b){ad=Z}else{ad=Q.height}R=new a.MenuBarButton(i,x.element,Q,Q.bCheckButton);n[Q.cmd]=R;D.push(R);if(Q.groupID!==b){I(R,Q.groupID)}}if(typeof(Q.fnCreate)==="function"){Q.fnCreate.apply(Q.fnCreateInstance,[R,Q])}if(Q.enabled===false){i.enableButton(Q.cmd,false)}}if(v.on){v.log("Button sequence"+O+": "+ae.join(","))}w();var P=q.run("onRegisterExternalMenuButtons");if(P){i.registerExternalButtonsFromContainer(P)}var U=k.iConfig;if(typeof(U.cfg.externalbuttoncontainer)!=="undefined"){i.registerExternalButtonsFromContainer(U.cfg.externalbuttoncontainer)}t("onMenuReady",[i]);for(var X in C){C[X].arButtons[0].setPressed(true)}};this.createHiddenButton=function(O,Q){if(n[O]!==b){return n[O]}var N={cmd:O,bCheckButton:Q};var P=new a.MenuBarButton(i,b,N,N.bCheckButton);P.bUserButton=true;n[N.cmd]=P;D.push(P);return P};this.setCallbacks=function(N){q=N};var t=this.callListeners=function(O,N){if(q){q.run(O,N)}};this.setContainerSize=function(N){var O=i.sprite.element.style.display;i.sprite.element.style.display="block";var P=a.getElementClientDim(i.sprite.element);g=P.height;if(P.width==0&&P.height==0){return}i.sprite.updateDimension();B=N;i.sprite.setSize("100%",g);i.sprite.element.style.display=O;w();if(d){i.sprite.show(true)}};var w=function(){if(!h){return}h.style.display="";if(h.firstChild!==b&&h.firstChild.offsetWidth>0&&x!==b){var N=(i.sprite.element.offsetWidth-x.element.offsetWidth)/2;if(N-8<h.firstChild.offsetWidth){h.style.display="none"}}};this.setPressedExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setPressed(O)}}};this.enableExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setEnabled(O)}}};this.setExternalButtonState=function(Q,P,R){if(L[Q]!==b){var N=L[Q];for(var O=0;O<N.length;O++){N[O].setState(P,R)}}};this.removeExternalButton=function(P,Q){var N=L[P];if(N!==b){for(var O=0;O<N.length;O++){if(N[O].nExternalButtonID===Q){N.splice(O,1)}}}};M.getMenuButtonPresent=function(O){var N=i.getButtonByCMD(O);return(N!==b&&N.bUserButton!==true)};M.registerExternalMenuButtonsFromContainer=this.registerExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Registering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.registerExternalButton(Q[O],R)}}}v.groupEnd()};M.unregisterExternalMenuButtonsFromContainer=this.unregisterExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Unregistering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.unregisterExternalButton(Q[O],R)}}}v.groupEnd()};M.registerExternalMenuButton=this.registerExternalButton=function(O,R,N){var P=R;if(typeof(P)!=="string"||P.length<1){P="user_tool_tip_only"}if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b){return false}if(O.FSIExternalButton!==b){if(v.on){v.error("The dom element has already been registered as external button for command '"+O.FSIExternalButton.getCMD()+"'.")}return false}var Q=new a.MenuBarExternalButton(i,k,O,P);if(!Q.init()){v.error("The dom element could not be registered as external button for command '"+P+"'.",O);Q.destroy();return false}if(Q.bUserButton){v.log("Registering external button for user command: "+P,O)}else{v.log("Registering external button for command: "+P,O)}O.FSIExternalButton=Q;if(L[P]===b){L[P]=[]}L[P].push(Q);if(q.isset("onAfterRegisterExternalButton")){q.run("onAfterRegisterExternalButton",[O,R,(Q.bUserButton!==true)])}};M.unregisterExternalMenuButton=this.unregisterExternalButton=function(O){if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b||typeof(O.FSIExternalButton)!=="object"||typeof(O.FSIExternalButton.destroy)!=="function"){return false}var N=O.FSIExternalButton;if(v.on){v.log("Unregistering external button for command: "+N.getCMD(),O)}O.FSIExternalButton.destroy();O.FSIExternalButton=b;return true};this.getButtonByCMD=function(N){return n[N]};G()};a.MenuBarExternalButton=function(i,e,c,g){var k=this;var h=i;var f="";var j;var d;this.init=function(){if(c.style===b){return false}k.nExternalButtonID=i.getExternalButtonID();d=i.getButtonByCMD(g);if(d===b){d=h.createHiddenButton(g,e.iConfig.makeBool(c.getAttribute("fsi-check-button")))}if(d===b){return false}k.bUserButton=d.bUserButton;f=a.trim(c.className);if(f.length>0){f+=" "}d.addEvents(c);k.setState(d.getState(),d.getCSSClass());k.setEnabled(d.getEnabled());k.setPressed(d.getIsPressed());c.setAttribute("fsi-registered","true");return true};this.getCMD=function(){return g};this.setPressed=function(l){if(l){c.setAttribute("checked","checked")}else{c.removeAttribute("checked")}};this.setEnabled=function(l){if(l){c.removeAttribute("disabled");a.removeClass(c,"fsi-ui-button-disabled")}else{c.setAttribute("disabled","disabled");a.addClass(c,"fsi-ui-button-disabled")}};this.setState=function(l,m){j=l;c.className=f+m};this.destroy=function(l){if(c.FSIExternalButton){d.removeEvents(c);c.FSIExternalButton=b;c.removeAttribute("fsi-registered");if(d){c.className=a.trim(f)}if(!l){h.removeExternalButton(g,k.nExternalButtonID)}}}};a.MenuBarButton=function(u,f,i,h){var q=this;var v=i.cmd;var k=u;var C;this.bEnabled=true;this.id=k.btnID++;var m=false;var B;var c;var l="";var e=true;var d;var y;var x="";var A,r;var g;var j={passive:false,capture:false};var w=function(){B=q.elButton=document.createElement("div");a.addClass(B,"fsi-ui-button");c=document.createElement("div");a.addClass(c,k.iconClassNamesNormal);B.appendChild(c);if(f){f.appendChild(B)}if(v.length>0){l=v.replace(/#.*$/,"")}else{l=""}if(i.cssClass){if(l.length>0){l+=" "}l+=i.cssClass}B.className="fsi-ui-button "+l;if(!i.bNoMouseEvents){q.addEvents(B)}s(1)};var t=function(D){D.cancelBubble=true;if(D.stopPropagation){D.stopPropagation()}if(D.preventDefault){D.preventDefault()}return false};this.addEvents=function(D){a.addEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.addEvent(D,"mousedown",q.onMouseDown,j);a.addEvent(D,"mouseleave",q.onMouseOut,j);a.addEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.addEvent(D,"touchstart",q.onTouchDown,j);a.addEvent(D,"touchcancel",q.onTouchUp,j);a.addEvent(D,"touchend",q.onTouchUp,j)}};this.removeEvents=function(D){a.removeEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.removeEvent(D,"mousedown",q.onMouseDown,j);a.removeEvent(D,"mouseleave",q.onMouseOut,j);a.removeEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.removeEvent(D,"touchstart",q.onTouchDown,j);a.removeEvent(D,"touchcancel",q.onTouchUp,j);a.removeEvent(D,"touchend",q.onTouchUp,j)}};this.destroy=function(){if(!i.bNoMouseEvents){q.removeEvents(B)}if(B&&B.parentNode){a.removeChild(B.parentNode,B)}};this.getCMD=function(){return v};this.makeCheckButton=function(){h=true};this.makeRadioButton=function(){h=true;m=true};this.getState=function(){return C};this.getCSSClass=function(){return B.className};var s=this.setState=function(E){if(C===E){return}if(h){var D=(E>2);if(D!==y){y=D;z("onMenuButtonSetPressed",null,D)}}o(E)};var o=this.setState=function(F){if(F===C){return}C=F;var G="";if(!q.bEnabled){G="fsi-ui-button-disabled "}switch(C){case 2:G+="fsi-ui-button-hover";break;case 3:G+="fsi-ui-button-active";break;case 4:G+="fsi-ui-button-active";if(q.oGroup!==b){for(var E=0;E<q.oGroup.arButtons.length;E++){var D=q.oGroup.arButtons[E];if(D.id!==q.id){D.setPressed(false)}}}break;default:break}if(G!==x){if(x.length>0){a.removeClass(B,x)}if(G.length>0){a.addClass(B,G)}x=G}k.setExternalButtonState(v,C,B.className)};this.onMouseOver=function(D){A=true;var E=D.target;if(a.hasClass(E,"fsi-ui-button-icon")&&E.parentNode){E=E.parentNode}k.showButtonToolTip(q,E);if(!q.bEnabled||!k.bEnabled){return}if(C===1){s(2)}};this.onMouseOut=function(D){A=false;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}if(r){return}if(C!==1&&C!==4){s(1)}};this.onMouseDown=function(D){z("onMenuButtonMouseDown",D);if(D&&D.type==="mousedown"){if(D.preventDefault){D.preventDefault()}if(D.which!==1){return true}}r=true;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}a.addEvent(window,"mouseup",q.onMouseUp);g=true;if(h){if(C===4){if(!m){s(3)}}else{s(4)}}else{s(3)}p(D)};this.show=function(D){if(e===D){return}e=D;q.elButton.style.display=(D)?"":"none"};this.onTouchDown=function(D){if(A){q.onMouseOut(D)}if(r){q.onMouseUp(D)}q.onMouseDown(D)};this.onTouchUp=function(D){if(A){k.hideToolTip();A=false}q.onMouseUp(D);if(D.preventDefault){D.preventDefault()}};this.onMouseUp=function(E){if(g){a.removeEvent(window,"mouseup",q.onMouseUp);g=false}var F=(E&&E.type==="touchend");if(!F&&!r){return}r=false;if(!q.bEnabled||!k.bEnabled){return}if(!F&&!A&&h&&!m){if(C===4){s(1)}else{s(4)}}var D=(!A)?1:2;if(h){if(C===3){s(D)}}else{s(D)}n(E);if(F||A){u.oInterface.clickMenuButton(v,E);z("onMenuButtonClicked",E)}};this.getEnabled=function(){return q.bEnabled};this.setEnabled=function(D){if(q.bEnabled===D){return}if(!D&&d){n()}if(!D&&(C===1||!h)){q.setState(1)}if(D){a.removeClass(B,"fsi-ui-button-disabled")}else{a.addClass(B,"fsi-ui-button-disabled")}q.bEnabled=D;k.enableExternalButtons(v,D);z("onMenuButtonEnabled",null,D);return true};this.getPressed=function(){return(C>2)};this.getIsPressed=function(){return(h&&q.getPressed())};this.setPressed=function(D){if(!h){return}if(D){s(4)}else{s(1)}k.setPressedExternalButtons(v,D)};var p=function(D){d=true;z("onMenuButtonPressed",D);u.oInterface.pressMenuButton(v,D)};var n=function(D){d=false;z("onMenuButtonReleased",D);u.oInterface.releaseMenuButton(v,D)};var z=function(F,D){var E=[v,D];if(arguments.length>2){E=E.concat(Array.prototype.slice.call(arguments,2))}k.callListeners(F,E)};w()}}(window.$FSI=window.$FSI||{}));$FSI.PluginMeasure=function(w,o){var n=this;this.name="measure";var H;var f;var j,Y,t;var i,X,s;var k,v,g;var B;var ab=1;var U;var ac;var aa=0;var r;var M;var T=1;var E;var C=0;var J,I;var c=true;var N,A,W,h;var u=o.getCallbacks();var G=$FSI.utils.makeNiceNumber;var L;var b={};var R;var P=$FSI.utils.getSVGNameSpaceURL();var Z=function(){var ag=function(aj){var ak=e(aj);if(ak){ak=$FSI.utils.getCSSColor(ak)}return ak};L=$FSI.utils.getNumberSeperators(o.iConfig);R=e("showInAllMouseModes",false,true);M=e("showAngle",false,true);h=e("showText",true,true);U=parseFloat(e("imageWidth","100"));if(isNaN(U)){U=100}A=e("prefix","");N=e("suffix","mm");N=" "+N;W=parseInt(e("decimals","1"));if(isNaN(W)||W<0){W=1}r=o.getRootContainer();H=document.createElement("div");H.setAttribute("style","position:absolute;width:100%;height:100%;overflow:hidden;z-index:101;");H.className="fsi-plugin-measure";f=document.createElementNS(P,"svg");f.setAttribute("style","width:100%;height:100%");f.className.baseVal="fsi-plugin-measure";k=document.createElementNS(P,"g");g=k.cloneNode(false);j=document.createElementNS(P,"line");j.setAttribute("x1",0);j.setAttribute("x2",0);j.setAttribute("y1",-8);j.setAttribute("y2",8);j.setAttribute("class","stroke:rgb(255,0,0);stroke-width:2");j.className.baseVal="fsi-plugin-measure-start-line";g.appendChild(j);Y=j.cloneNode(false);Y.className.baseVal="fsi-plugin-measure-end-line";Y.setAttribute("x1","100");Y.setAttribute("x2","100");g.appendChild(Y);t=j.cloneNode(false);t.className.baseVal="fsi-plugin-measure-main-line";t.setAttribute("x1","0");t.setAttribute("x2","100");t.setAttribute("y1","0");t.setAttribute("y2","0");g.appendChild(t);g.className.baseVal="fsi-plugin-measure-group-back";k.appendChild(g);v=g.cloneNode(true);v.className.baseVal="fsi-plugin-measure-group-front";k.appendChild(v);i=v.childNodes[0];X=v.childNodes[1];s=v.childNodes[2];f.appendChild(k);H.appendChild(f);if(h){var ae=e("textSize","");var ai=ag("BGColor");var af=ag("TextColor");var ad=ag("TextBorder");var ah=ag("lineColor");B=document.createElement("span");B.className="fsi-plugin-measure-label";H.appendChild(B);if(ae){B.style.fontSize=ae+"px"}if(ai){B.style.background=ai}if(af){B.style.color=af}if(ad){B.style.borderColor=ad}if(ah){i.style.stroke=X.style.stroke=s.style.stroke=ah}}r.appendChild(H);o.addDrawListener("FSI.PluginMeasure",x);o.registerPointerHandlers(100,D,O,a);w.addListener("onMouseModeChanged",p);w.addListener("onResize",S);w.addListener("onAfterReady",V);K(false);y()};var e=function(ae,af,ad){return o.iConfig.getPluginParameter("measure",ae,af,ad)};var y=function(ad){var ae=o.getdrawRatioUnZoomed();if(!ae||!ae.imageWidth){return}b.imageWidth=ae.imageWidth;b.imageHeight=ae.imageHeight;b.imageX=ae.imageX;b.imageY=ae.imageY;ab=U/ae.imageWidth;if(!ad){d(0)}u.run("onMeasureUpdateRatio",[ab,U,ae.imageWidth])};var V=function(){y();var ad=e("initial");if(ad&&ad.length>0){ad=$FSI.trim(ad);ad=ad.split(",");if(ad.length===4){var ae={};ae.x=parseFloat(ad[0])*b.imageWidth+b.imageX;ae.y=parseFloat(ad[1])*b.imageHeight+b.imageY;F(ae);ae.x=parseFloat(ad[2])*b.imageWidth+b.imageX;ae.y=parseFloat(ad[3])*b.imageHeight+b.imageY;q(ae,false);K((R||w.getMouseMode()===100),true)}}};var S=function(ad,af,ag){if(!ag||aa===0){return}var ae=c;var ai=$FSI.utils.cloneObject(b);y(true);var ah=b.imageWidth/ai.imageWidth;b.x1=(ai.x1-ai.imageX)*ah+b.imageX;b.y1=(ai.y1-ai.imageY)*ah+b.imageY;b.x2=(ai.x2-ai.imageX)*ah+b.imageX;b.y2=(ai.y2-ai.imageY)*ah+b.imageY;F({x:b.x1,y:b.y1});q({x:b.x2,y:b.y2},b.bShift);l();if(!ae){K(false)}};var p=function(ae){var ad=R;if(ae===100){if(aa!==0){ad=true}o.setCursor("crosshair")}K(ad,true)};var K=function(ad,ae){if(ad===c){return}c=ad;if(c){H.style.display=""}else{H.style.display="none"}u.run("onMeasureShow",[c]);if(ae&&c){z();l()}};var d=function(ad){if(ad===aa){return}Y.setAttribute("x1",ad);Y.setAttribute("x2",ad);X.setAttribute("x1",ad);X.setAttribute("x2",ad);t.setAttribute("x2",ad);s.setAttribute("x2",ad);if(aa!==ad){K(ad!==0);aa=ad}z()};var z=function(){if(!c){return}var af=ab*aa/T;var ae=A+G(af,W,L)+N;if(M){ae+=", "+G(C,W,L)+"°"}var ad=u.run("onMeasureChange",[af,C,ae]);if(typeof(ad)==="string"){ae=ad}b.label=ae;if(h){B.innerText=ae;if(E){l()}}E=undefined};var F=function(ad){b.x1=J=ad.x;b.y1=I=ad.y};var l=function(){if(!c){return}k.setAttribute("transform","translate("+J+" "+I+") rotate("+C+")");if(!h){return}var ak=J;var aj=I;var ad=C%360;var am=Math.floor(ad/90);var al=B.offsetWidth;var ag=B.offsetHeight;var ai=16;switch(am){case 0:case 1:ak+=ai;aj-=ai+ag;break;case 2:case 3:ak+=ai;aj+=ai;break}var ah=w.getMenuHeight();var af=r.offsetWidth-al;var ae=r.offsetHeight-ah-ag;if(aj>ae){aj=ae;if(am===3){ak=J-al-ai}}else{if(aj<0){aj=0;if(am===0){ak=J-al-ai}}}if(ak>af){ak=af;if(aj===0||aj===ae){ak=Math.max(0,ak-al)}}if(ak<0){ak=0;if(aj===0||aj===ae){ak=Math.min(af,ak+al)}}B.style.left=ak+"px";B.style.top=aj+"px"};var Q=function(ad){return{x:ad.x-ac.left,y:ad.y-ac.top}};var m=function(af,ah,ae,ag){var ad=ae-af;var ai=ag-ah;if(ai==0){ai=1e-8}if(ad==0){ad=1e-8}return Math.atan(ai/ad)+(-0.5*(ai/Math.abs(ai))-0.5*(ai/Math.abs(ai))*(ad/Math.abs(ad))+1)*Math.PI};var D=function(ad,af){ac=$FSI.getElementPosition(r);F(Q(af));d(0);l();var ae=ab*aa/T;u.run("onMeasureStart",[ae,C,b.label])};var O=function(ad,ae){q(Q(ae),ad.shiftKey)};var a=function(){if(u.isset("onMeasureEnd")){var ad=[];ad.push((b.x1-b.imageX)/b.imageWidth);ad.push((b.y1-b.imageY)/b.imageHeight);ad.push((b.x2-b.imageX)/b.imageWidth);ad.push((b.y2-b.imageY)/b.imageHeight);var ae=ab*aa/T;u.run("onMeasureEnd",[ae,C,b.label,ad])}};var q=function(ai,ah){b.x2=ai.x;b.y2=ai.y;b.bShift=ah;var ae=m(J,I,ai.x,ai.y);C=ae*180/Math.PI;if(ah){C=45*Math.round(C/45)}var ag=ai.x-J;var af=ai.y-I;var ad=Math.sqrt(ag*ag+af*af);d(ad);l()};this.destroy=function(){w.removeListener("onMouseModeChanged",p);w.removeListener("onResize",S);w.removeListener("onAfterReady",V);if(E){clearTimeout(E);E=undefined}o.unregisterPointerHandlers(100);o.removeDrawListener("FSI.PluginMeasure");r.removeChild(H)};var x=function(af,ae,ad){if(c){if(E===undefined&&T!==ad.scale){E=setTimeout(z,25)}T=ad.scale}};Z()};(function(a,b){if(a.utils.API.Viewer!=b){return}a.utils.API.Viewer=function(d,e){var c=this;c.scriptMainFile="FSI.Viewer.js";c.getActiveMenuButtons=function(){if(e.arMenuButtons==b){return b}var f={};for(var g=0;g<e.arMenuButtons.length;g++){var h=e.arMenuButtons[g].cmd;if(h!=b){f[h]=true}}return f};c.oMenuCommands={Reset:1,ZoomOut:1,ZoomIn:1,MouseMode_0:1,MouseMode_1:1,MouseMode_2:1,MouseMode_100:1,MaxZoom:1,HotSpots:"Hotspots",ToggleAutoSpin:"autospin-button-toggle",ToggleFullScreen:"FullScreen"};c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeImage:{a:"oParameters, strViewString",r:"bSuccess"},clickMenuButton:{a:"strButtonID"},debugEnabled:{r:"bEnabled"},debugError:{a:"mixed"},debugLog:{a:"mixed"},debugWarn:{a:"mixed"},destroy:{},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getHotspotViewString:{a:"nHotspotID",r:"strViewString"},getImageIsTransparent:{r:"bTransparent"},getInFullScreenMode:{r:"bFullScreen"},getInitDone:{r:"bInitDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getMenuButtonPresent:{a:"strButtonID",r:"bPresent"},getMenuHeight:{a:"strPurpose",r:"nHeight"},getMouseMode:{r:"nMouseMode"},getParameters:{r:"oParameters"},getPluginParameter:{a:"strPluginName, strParameterName, defaultValue, bMakeBoolean",r:"mixed"},getSkinClassName:{r:"strClassName"},getSpinFrames:{r:"nFrames"},getSrcDim:{r:"oDimension"},getVersion:{r:"strVersion"},getViewString:{r:"strViewString"},getZoom:{r:"fZoomInPercent"},gotoHotspot:{a:"FSIHotspotID, bAnimate",r:"bSuccess"},gotoViewString:{a:"strView, bAnimated",r:"bSuccess"},hideMenuToolTip:{},init:{a:"elementID, oParameters, bDebug"},makeBoolean:{a:"value, bDefaultValue",r:"bResult"},pressMenuButton:{a:"strButtonID"},printAPI:{},registerExternalMenuButton:{a:"elButton, strButtonID, strTip"},registerExternalMenuButtonsFromContainer:{a:"elContainer"},releaseMenuButton:{a:"strButtonID"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},resetView:{},setFullScreenElement:{a:"elFullScreenContainer",r:"bSuccess"},setMouseMode:{a:"nMode"},setZoom:{a:"fZoomPercent, bPreliminary, bAnimate"},showAboutWindow:{},showMenuButton:{a:"strButtonID, bShow"},showMenuToolTip:{a:"strTip, elSrc, x, y"},spinToDegree:{a:"fDegree"},spinToTarget:{a:"nTargetFrame, nStopSceneSet, nFrames"},start:{},startAutoSpin:{r:"bSuccess"},stopAutoSpin:{r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unregisterExternalMenuButton:{a:"elButton"},unregisterExternalMenuButtonsFromContainer:{a:"elContainer"},updateSize:{}};c.oProperties={};c.oCallbacks={onAfterRegisterExternalButton:{a:"elButton, strButtonID, bButtonPresentInViewer"},onAnimationComplete:{},onAnimationStart:{},onChangeConfig:{a:"strCfgFileName, oParameters"},onChangeImage:{a:"oParameters, strView"},onClickDemoMode:{a:"url, targetFrame"},onConfigsReady:{a:"oConfigValues"},onDataComplete:{},onDestroy:{},onEnterDemoMode:{},onExitDemoMode:{},onFullScreen:{a:"bSet"},onHotspotEvent:{a:"strAction, nHotspotID, strHotspotAttributeID, strContent"},onInit:{a:"oParameters)"},onInitFailed:{a:"strReason"},onInitMenu:{},onMeasureChange:{a:"fLength, fRotation, strLabel",r:"strModifiedLabel"},onMeasureEnd:{a:"fLength, fRotation, strLabel, arCoords"},onMeasureShow:{a:"bShow"},onMeasureStart:{a:"fLength, fRotation, strLabel"},onMeasureUpdateRatio:{a:"fLengthFactor, fImageRealWidth, fImageWidth"},onMenuButtonEnabled:{a:"strButtonID, null, bEnable"},onMenuButtonPressed:{a:"strButtonID, evt"},onMenuButtonReleased:{a:"strButtonID, evt"},onMenuButtonClicked:{a:"strButtonID, evt"},onMenuButtonSetPressed:{a:"bPressed"},onMenuDestroy:{},onMenuEnabled:{a:"bEnabled"},onMenuReady:{},onMouseModeChanged:{a:"nMouseMode"},onProgress:{a:"fPercent"},onReady:{},onRegisterExternalMenuButtons:{},onReset:{},onResize:{a:"nWidth, nHeight, bResizeDone, bFullscreen"},onSkinChanged:{a:"strCurrentSkinClass, strCurrentSkinClassBefore"},onStartDragging:{a:"bInNavWindow"},onStopDragging:{a:"bInNavWindow"},onViewChanged:{a:"strViewString"},onZoomChanged:{a:"fScale, fScaleMax"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Viewer!=b){return}a.Viewer=function(gn,ek){var gR={};var az={strVersion:"2018",strBuild:"18.07.06.1",strConfigSection:"Viewer",oTraceConfigParameters:ek,bHasListeners:true};var cG=new a.utils.ClassDef(this,"FSI Viewer",az);cG.oAPI=new a.utils.API.Viewer(this,gR);var bc=cG.instance;a.utils.guessFSIViewerLocation("fsiviewer.js",3);var dS=a.utils.getViewerInstanceID();this.getInstanceID=gR.getInstanceID=function(){return dS};this.getInstanceName=function(){return cG.strClassName+" ["+N+"]"};this.debugLog=function(){dx.log.apply(dx,arguments)};this.debugWarn=function(){dx.warn.apply(dx,arguments)};this.debugError=function(){dx.error.apply(dx,arguments)};this.debugEnabled=function(){return dx.on};var gT;var f8,db,b6;var ao;var m;var c8;var er;var h;var gw={};var U;var dA;var B;var eY;var bz;var dk=false;var G;var dE=0;var fB=0;var aC={};var dD,dT;var eC;var bN;var b8;var cD;var bH,a4;var dF=false;var g6;var I;var aV;var bq={};var fH={};var O,eO;var gO={};var aM;var aK;var eQ=8;var hq=1;var ae;var d=false;var g8=false;var f5;var cc;var bu;var c4;var e6;var hf,cV;var e5;var bA=true;var gD=100;var b7=true;var eE;var bW;var aA;var c2;var g7;var dw;var eL;var s;var bp;var dP=false;var fr=new a.CroppedImage();var fq=new a.Rect();var aH=a.Easing.easeOutCubic;var eT;var eU={width:0,height:0};var bK;var V;var av;var gS;var bx;var aR={};var cF=10000;var hl=cF;var e4;var bs;var S;var dh;var aZ={x:0,y:0,z:0};var gV;var gL;var ad;var a3=new a.Rect(0,0,-1,-1);var dL=new a.Rect(0,0,-1,-1);var fw=new a.Rect(0,0,-1,-1);var fO=new a.Rect(0,0,-1,-1);var f1=new a.Rect(0,0,-1,-1);var aL=new a.Rect(0,0,0,0);var gH=new a.Rect(0,0,0,0);var ay=false;var T=true;var hh=!(a.isChrome);var d5=false;var bJ=false;var bM=false;var c3=true;var dM=false;var A;var fh=false;var hb;var de=false;var gF=true;var g4=false;var fX=false;var fs;var b3=new a.Rect(0,0,0,0);var ey=0;var dm;var cO=0;var bB=0;var af=0;var aT;var eo=0;var ee=0;var cw=0;var dC={x:0,y:0};var Y={};var bf={};var w={};var eA="auto";var eD;var ft=1;var at;var bn;var gx=true;var aW={};var cM,cL;var fA=b;var f;var c7;var ho=false;var eG=false;var dY=true;var dj=true;var gp=false;var cn=false;var e9=false;var fF;var cb;var gX;var bt=false;var gI;var eB;var bg;var fe={};var ct;var dl;var ge;var cu;var d0;var d8,dQ;var aa;var ec;var em;var dt;var hk;var e=[];var g2=[];var dG;var dN={};var cy={};var gi;var ea=false;var hj;var bC,dq;var dR;var e8={};var N;var dH;var X;var g9={};var aj;var be=gR.viewport={};var dB=a.utils.getSVGNameSpaceURL();var fS="1.1";var bw;var g3;var aq;var ch=1;var bd=1;var aF;var cj;var e7;var fv=0;var e3=1;var ap=2;var f7=fv;var gm;var i=false;var a1;var bV;var fW;var hc;var aI=false;var fM=false;var go;var eN=1;var b4={};var F=false;var L;var ga;var gz;var n;var fz;var cU={width:0,height:0};var b5=false;var aG=false;var d9;var ck="&limit=0,360";var eZ;var gU=false;var gN;var x;var f3={};var fu=false;var bZ;var cp="&effects=Matte(FFFFFF)";var c;var an;var aw;var c0={};var bo=true;var gc;var cS;var fQ;var dK;var bE=0;var cx=0;var bG={};var cP=false;var eX=true;var H;var fm={};var am=0;var aY={};var cQ={};var gj;var ed={};var dx=new a.EmptyDebugger();var he=function(hr,o){if(o&&!dx.on&&hr.on){gi.stopPendingRequests();bc.destroy(true);bc.init(gj,ed,true);bc.start();return true}dx=hr;if(cD){cD.setDebug(dx)}if(dx.on){dx.setPrefix(bc.getInstanceName())}};var gd=gR;gd.iViewer=bc;gd.getDebug=function(){return dx};gd.getToolTip=function(){return fQ};gd.getElementSpace=function(){return aj};gd.getDrawRatio=function(){return Y};gd.getdrawRatioUnZoomed=function(){return bf};gd.getdrawRatioUnResized=function(){return w};gd.getinPlaceZoom=function(){return b4};gd.getRootContainer=function(){return gT};gd.getParentElement=function(){return ao};gd.getCallbacks=function(){return cD};gd.getIsFullScreen=function(){return ea};gd.getImageArray=function(){return g2};gd.getCurrentSkin=function(){return aW};this.init=function(hr,hu,o){if(gp){bc.destroy()}gj=hr;if(typeof(hr)=="object"){if(typeof(hr.id)=="string"){N=hr.id}}else{if(typeof(hr)=="string"){N=hr}}if(!N){N="fsi.viewer #"+dS}if(bc._fsi_parameters){hu=bc._fsi_parameters;delete bc._fsi_parameters;bc._fsi_parameters=b}if(a.isMobileDevice){gm=5000000}else{gm=8000000}aM=new a.IMGLoadingEngine(bc,e1);var hs;if(typeof(hr)=="object"&&hr.tagName!=b){hs=hr}else{hs=document.getElementById(hr)}if(typeof(hu)=="object"&&typeof(window[hu.oninit])=="function"){window[hu.oninit](bc,N,hu)}ed=(hu&&typeof(hu)=="object")?a.utils.cloneParameters(hu):{};gu();var ht=ed;if(o){ht=a.utils.cloneObject(ed);ht.debug=true}gi.init(ht);if(dx.on){dx.log(bc.getVersion())}z();if(!hs){dx.error("A DOM element with the id '"+hr+"' could not be found. Aborting.");return}bw="1.5px";if(a.isSmallMobileDevice){dx.log("Small mobile Device detected.");b5="fsi-ui-hotspot-mobile fsi-ui-hotspot-mobile-small";bw="4px"}else{if(a.isMobileDevice){dx.log("Mobile Device detected.");b5="fsi-ui-hotspot-mobile"}}if(hs.firstChild!=b){hs.innerHTML=""}ao=hs;if(ao.tagName.toLowerCase()!="fsi-viewer"){a.addClass(ao,"fsi-viewer")}ao.setAttribute("x-fsi-id",N);e7=(a.isMobileDevice)?0.2:0.15;if(!gT){gT=document.createElement("div");gT.className="fsi-root fsi-viewer-root";a.utils.setStyleAttr(gT,"position:relative;left:0px;top:0px;padding:0px;margin:0px;border:0px none;z-index:0;width:100%;height:100%;text-align:left;vertical-align:top;");hs.appendChild(gT)}ah();dv(true);if(dx.on){dx.log("Container element: "+aj.width+" x "+aj.height+" ("+hs.nodeName+")")}gp=true;bp=a.utils.getCSSTransformStyleName();eE=false};var gu=function(){var o={};o.onConfigsReady=d2;o.onDebuggerChange=he;gi=gR.iConfig=new a.Config(null,o,{strSection:cG.strConfigSection});gi.setEffectsFilterArea();bc.loadFile=gi.loadFile;if(aV){gi.setAccessToken(aV)}if(!cD){cD=gR.iCallbacks=new a.Callbacks(bc,gi)}else{cD.setConfig(gi)}};this.getInitDone=function(){return gp};gR.getViewportSize=function(){return be};var ah=function(){var o=a.getBoundingClientRect(gT);aj={width:o.width,height:o.height};var hr=(gw&&gw.minInstanceSize>1)?gw.minInstanceSize:60;if(aj.width<hr||aj.height-cx<hr){aj.visible=false;aj.width=hr;aj.height=hr+cx}else{aj.visible=true}be.width=aj.width;be.height=aj.height-cx};var bY=gR.setCursor=function(o){if(bZ==o){return}if(hc){if(bZ!=b){a.removeClass(hc,"fsi-ui-cursor-"+bZ)}if(o!=b){a.addClass(hc,"fsi-ui-cursor-"+o)}}bZ=o};var fG=function(hx,hw,hz,hv,o){var ht=be.width*av.scale;var hr=be.height*av.scale;if(hx==b){hx=ht/2}if(hw==b){hw=hr/2}var hs;if(hz!=b){hs=Math.max(1,Math.min(b4.maxScale,b4.scale+hz))}else{hs=b4.defaultZoom}var hy=hs/b4.scale;hx=hy*(b4.panPos.left-(hx-ht/2));hw=hy*(b4.panPos.top-(hw-hr/2));var hu=(hv)?0:o;eP(hx,hw,hs,hu)};var gq=function(o,hu,hs,hr){if(!b4.enabled){return}if(b4.panPos.left==0&&b4.panPos.top==0&&(g3<=1||(S&&b4.targetZoom==1))){return}var ht=(hs)?0:hr;eP(0,0,1,ht)};var eH=function(o){if(av.scale>1){o.scaleRect(1/av.scale)}var hA=o.width();var hv=o.height();if(hA<1||hv<1){return}var hw=hA/hv;var hu=be.width/be.height;if(hw>hu){hv=hA*be.height/be.width;o.inflateRect(0,hv-o.height())}else{if(hw<hu){hA=hv*be.width/be.height;o.inflateRect(hA-o.width(),0)}}var hr=g3*be.width/hA;hr=Math.max(1,Math.min(b4.maxScale,hr));var hz=hr/g3;var ht=o.left+o.width()/2;var hs=o.top+o.height()/2;var hy=(b4.panPos.left-ht+be.width/2)*hz;var hx=(b4.panPos.top-hs+be.height/2)*hz;eP(hy*av.scale,hx*av.scale,hr)};var eP=function(o,hu,ht,hr){ht=Math.max(1,Math.min(b4.maxScale,ht));ew();b4.pos=0;b4.frames=(hr!=b)?hr:28;if(b4.frames<1){b4.frames=1}b4.sourceZoom=b4.scale;b4.sourceX=b4.panPos.left;b4.sourceY=b4.panPos.top;if(o==b){o=b4.sourceX}if(hu==b){hu=b4.sourceY}var hs=g1(o,hu,ht);b4.targetX=hs.x;b4.targetY=hs.y;b4.targetZoom=ht;b4.dX=hs.x-b4.sourceX;b4.dY=hs.y-b4.sourceY;b4.dZoom=ht-b4.sourceZoom;bh()};var y=gR.stopAfterTouch=function(){if(H){H.cancelAfterTouch()}};var aO=gR.autoShowHideHotSpots=function(o){if(dj==o){return}dj=o;if(!eG||!a.isMobileDevice){return}dY=o;f2(o);dJ();if(o){ha()}};var bh=function(){if(S){return}dq=false;b4.lockPanAnimation=false;F=true;aO(false);S=true;cD.run("onAnimationStart");ha()};var ew=gR.stopDesktopAnimation=function(){if(S){aO(true);F=false;S=false;b4.pos=b4.frames=0;b4.targetZoom=b;b2();dV();fR();cX()}};var cg=function(){if(S||ho){return}cD.run("onAnimationComplete")};var fx=function(){b4.pos++;f4(aH(b4.pos,b4.frames,b4.sourceZoom,b4.dZoom,3));if(!b4.lockPanAnimation){b4.panPos.left=aH(b4.pos,b4.frames,b4.sourceX,b4.dX,3);b4.panPos.top=aH(b4.pos,b4.frames,b4.sourceY,b4.dY,3)}b2();if(b4.pos===b4.frames){ew();cg();if(dq){fE()}return false}return true};var eS=gR.onAfterinPlaceZoomChanged=function(){b2();dV();fR()};this.getMouseMode=function(){return eD};var fc=this.setMouseMode=function(o){if(H){H.cancel()}eA=o;switch(o){case"auto":if(x){o=(b4.bZoomedIn)?1:0}else{o=(b4.bAutoMouseModePan)?1:2}break;case 0:case 1:break;case 2:if(x){o=(b4.bZoomedIn)?1:0}else{o=2}break}cN(o)};var cN=function(o){eD=o;switch(eD){case 0:bY("zoom");break;case 1:bY("pan");break;case 2:if(aY.nSceneSets>1){bY("rotate3d")}else{bY("rotate")}break}cD.runPersistent("onMouseModeChanged",[eD]);if(cS){cS.setButtonPressed("MouseMode_"+eD,true)}};var fR=function(){if(!b4.enabled||eA!="auto"){return}var o=(b4.scale>1);if(b4.bZoomedIn==o){return}b4.bZoomedIn=o;if(o){b4.bAutoMouseModePan=true;cN(1)}else{b4.bAutoMouseModePan=false;if(x){cN(0)}else{cN(2)}}};var g1=function(o,hx,hw){var hu={x:o,y:hx};var hv=Math.round(bf.imageWidth*hw);var hs=Math.round(bf.imageHeight*hw);var ht=Math.max(0,(hv-Y.maxPanReferenceWidth)/2);var hr=Math.max(0,(hs-Y.maxPanReferenceHeight)/2);hu.x=Math.max(-ht,Math.min(ht,o));hu.y=Math.max(-hr,Math.min(hr,hx));return hu};this.getZoom=function(){return g3/b4.maxScale*100};this.setZoom=function(hs,o,hr){if(!cn||!b4.enabled){return false}aB(true);ew();hs=hs*b4.maxScale/100;if(hr){eP(b,b,hs);return}else{f4(hs)}b2(o);if(!o){dV();fR()}return true};this.gotoHotspot=function(hs,hr){if(!cn){return false}aB();if(hr!==false){hr=true}var o=bc.getHotspotViewString(hs);if(o===false){return false}gY(o,hr);return true};this.getHotspotViewString=function(o){if(!cn||eC[o]==b){return false}return fi(eC[o],true,true)};var fi=function(hA,hJ,hz){if(typeof(hA)!="object"){return false}if(hz==b){hz=hA.rotateOnFocus}if(hJ==b){hJ=hA.zoomOnFocus}var hS;var hB;var o=(aY.nCurrent==b)?0:aY.nCurrent;var hG=o+1;var hL=Math.round(ey/(eo/bB));var hQ=1+hL;var hE=false;var hK=false;var hT=false;var hx=ee;var hF;var hy=false;if(hz){if(hA._focusSceneSet!=b){hy=true;if(hA._focusSceneSet!==false){hG=hA._focusSceneSet}}else{if(aY.nSceneSets==b||aY.nSceneSets<2||hA.perimeterAngleX==b){hA._focusSceneSet=false}else{var hR=cH();var hM=hR.angle;var hv=Math.abs(hR.stepAngle);hF=(hA.focusAngleX!=b)?hA.focusAngleX:hA.perimeterAngleX;if(typeof(hF)=="number"){var hU=hF-hM;if(!isNaN(hU)){while(hU<0){hU+=360}while(hU>360){hU-=360}var hu=Math.round(hU/hv);hu=Math.max(0,Math.min(aY.nSceneSets,hu))+1;if(hu!=hG){hG=hu;if(hJ){hK=ey;hT=hE=true;fP(hG-1)}}}hA._focusSceneSet=false}else{hA._focusSceneSet=false}hA._focusSceneSet=hG}}if(hA._focusScene!=b){hy=true;if(hA._focusScene!==false){hQ=hA._focusScene}}else{hF=(hA.focusAngleY!=b)?hA.focusAngleY:hA.perimeterAngleY;if(typeof(hF)=="number"){var hH=hj(Math.round(hF/360*bB))+1;hK=hj(Math.round(hF/360*eo));if(!isNaN(hH)){if(hJ){if(hK!=ey){hE=true}}hA._focusScene=hQ=hH;hA._focusSpinPos=hK}else{hA._focusScene=false}}else{hA._focusScene=false}}}var hD=(hz&&typeof(hA._focusScene)=="number"&&typeof(hA._focusSceneSet)=="number");if(hJ&&hz&&hy&&!hD){if(hA._focusSceneSet!==false&&hA._focusSceneSet!=hG){hK=ey;hT=hE=true;fP(hA._focusSceneSet-1)}if(hA._focusScene!==false&&hA._focusScene!=hL){hK=hA._focusSpinPos;hE=true}}if(hE){cd(hK);et()}if(hJ==true){if(hD&&hA._focusZoom!=b){hB=hA._focusZoom}else{var hC=new THREE.Vector3();dN.camera.setViewOffset(be.width,be.height,0,0,be.width,be.height);if(hE){dN.renderer.render(dN.scene,dN.camera)}hC.setFromMatrixPosition(hA.object.matrixWorld);hC.project(dN.camera);var hP=0.5;var hr=0.5;var hO=bf.imageWidth/be.width;var hN=bf.imageHeight/be.height;var ht=hC.x/hO*hP+hP;var hs=hr-hC.y/hN*hr;g4=true;var hI=new a.Rect(ht,hs,ht,hs);if(typeof(hA.focusRadius)=="number"&&hA.focusRadius>0){hI.inflateRect(hA.focusRadius,hA.focusRadius)}hB=hI.toString();if(hD){hA._focusZoom=hB}}}if(hT){fP(o)}if(hE){cd(hx);et();ha()}hS=hG+","+hQ;if(hB!=b){hS+=","+hB}return hS};var cv=this.getViewString=function(){if(!aw){return b}var ht=[];var hx=aY.nCurrent+1;var hu=1+Math.round(ey/(eo/bB));if(isNaN(hu)){hu=1}var hv=Y.imageWidth;var hs=hv/aw.width*aw.height;var hy=hq/g3;var hw=0.5-b4.panPos.left/hv-hy/2;var hr=0.5-b4.panPos.top/hs-hy/2;var o=new a.Rect(hw,hr,hw+hy,hr+hy);o.round();ht.push(hx);ht.push(hu);ht.push(o.toString());ht.push(0);return ht.join(",")};var eJ=function(hs,hr){var o=parseFloat(hs);if(isNaN(o)){o=hr}return o};var cJ=function(hs){if(typeof(hs)!="string"){hs=""}var o=[1,1,0,0,1,1,0];hs=hs.split(",");for(var hr=hs.length;hr<7;hr++){hs.push(o[hr])}return hs.join(",")};var es=function(hw){var hv={SceneSet:0,scene:0,frame:0};if(hw==b||typeof(hw)!="string"||hw.length<3){return hv}var hy=hw.split(",");if(hy.length<2){return hv}if(aY.nSceneSets<2){hv.SceneSet=0}else{hv.SceneSet=parseInt(hy[0])-1;if(isNaN(hv.SceneSet)){hv.SceneSet=b}}hv.scene=parseInt(hy[1]);if(isNaN(hv.scene)){hv.scene=1}hv.scene=hv.scene%bB-1;if(hv.scene<0){hv.scene+=bB}hv.frame=hv.scene*eo/bB;if(hy.length>5){var hB=eJ(hy[2],0);var hs=eJ(hy[3],0);var hA=eJ(hy[4],1);var ht=eJ(hy[5],1);var hr=hv.rc=new a.Rect(hB,hs,hA,ht);hr.normalizeRect();var hu=hr.width();var hC=hr.height();var hD=1/Math.max(hu,hC);hv.zoom=hD=Math.max(1,Math.min(b4.maxScale,hD));var hz=bf.imageWidth;var hE=bf.imageWidth/aw.width*aw.height;hv.x=-hz*hD*((hr.left+hr.width()/2)-0.5);hv.y=-hE*hD*((hr.top+hr.height()/2)-0.5);var hx=g1(hv.x,hv.y,hv.zoom);hv.x=hx.x;hv.y=hx.y}return hv};var gY=this.gotoViewString=function(hs,ht){if(!cn){return false}aB();var o=(ht)?30:0;var hr=es(hs);if(hr.scene==b){return false}var hu=es(cv());if(hr.SceneSet==hu.SceneSet&&hr.scene==hu.scene&&Math.abs(hr.x-hu.x)<1&&Math.abs(hr.y-hu.y)<1&&Math.abs(hr.zoom-hu.zoom)<0.000001){if(dq){fE()}return true}if(hr.SceneSet!=hu.SceneSet||hr.scene!=hu.scene){bc.spinToTarget(hr.frame,hr.SceneSet,o)}if(b4.enabled&&hr.rc!=b){eP(hr.x,hr.y,hr.zoom,o)}return true};this.changeImage=function(ht,hu){cD.run("onChangeImage",[ht,hu]);gi.makeObjectPropertiesLowerCase(ht);if(!e9){fF=arguments;return false}an=cv();if(dx.on){a.console.log("")}dx.log("--- changeImage() called ---");gi.stopPendingRequests();var hw=false;if(ht!=b){if(ht.fpxsrc!=b||ht.imagepath!=b){hw=true}if(ht.dir!=b){hw=true}}if(!hw){return bc.gotoViewString(hu,true)}if(ht.imagepath!=b){ht.fpxsrc=ht.imagepath;ht.imagepath=b}ht.fpxsrc=encodeURIComponent(ht.fpxsrc);var o=["imagesrc","imagepath","imagesources","imagewidth","imageheight","imagetilesx","imagetilesy","imagetransparency","images3durl"];var hs=gi.cfgAliasNames;var hr=gi.cfg;for(var hv=0;hv<o.length;hv++){var hx=o[hv];delete hr[hx];if(hs[hx]){delete hr[hs[hx]]}}gi.setCfgValues(ht);z();c=hu;br();gi.dumpConfig();fK();return true};var gb=function(){var o=bK;if(g3<=1){e6=1;o=aF}else{var hs=g3*w.imageWidth;var hu=Math.round(aw.width/eU.width*hs);var ht;for(var hr=0;hr<bu.length;hr++){if(bu[hr]>=hu){ht=V=bu[hr];break}}if(!ht){if(bu.length>0){ht=bu[bu.length-1]}if(ht<=1.1*w.imageWidth){ht=b}}if(ht){o=Math.round(ht*fr.getImageRect().width()/aw.width)}e6=o/aF}return o};var f4=function(o){o=Math.max(1,Math.min(b4.maxScale,o));b4.scale=o;g3=b4.scale*av.scale;aq=Math.min(b4.maxScaleInitial,ch*b4.scale);c4=b4.scale*ch};var fN=function(){var o=Math.min(b4.maxScaleInitial,ch);if(o*b4.scale>b4.maxScaleInitial){b4.scale=b4.maxScaleInitial/o}aq=Math.min(b4.maxScaleInitial,ch*b4.scale);return o};var ab=function(o){av.scale=o;g3=av.scale*b4.scale;aq=Math.min(b4.maxScaleInitial,ch*b4.scale);b4.scale=Math.max(1,aq/ch);c4=ch*b4.scale};var b2=gR.updateInPlaceZoom=function(hs){if(S){hs=true}var ht=false;if(hs){if(b4.nLastScalePreliminary!=g3){b4.nLastScalePreliminary=g3;ht=true}}else{if(b4.nLastScaleFinal!=g3){b4.nLastScaleFinal=g3;ht=true}}if(ht){if(!hs&&cL){cD.runPersistent("onZoomChanged",[g3,b4.maxScaleInitial])}if(hs&&dl&&g3-dl.renderScale<-1){fp()}Y.imageWidth=g9.testWidth=Math.round(w.imageWidth*g3);Y.imageHeight=Math.round(w.imageHeight*g3);Y.imageX=Math.round(bf.imageX-(Y.imageWidth-bf.imageWidth)/2);Y.imageY=Math.round(bf.imageY-(Y.imageHeight-bf.imageHeight)/2);Y.maxImageOffsetX=Math.floor(Math.max(0,(Y.imageWidth-Y.maxPanReferenceWidth)/2-0.01));Y.maxImageOffsetY=Math.floor(Math.max(0,(Y.imageHeight-Y.maxPanReferenceHeight)/2-0.01));if(gX){Y.videoWidth=Math.round(w.videoWidth*g3);Y.videoHeight=Math.round(w.videoHeight*g3);Y.videoX=bf.videoX-(Y.videoWidth-bf.videoWidth)/2;Y.videoY=bf.videoY-(Y.videoHeight-bf.videoHeight)/2}if(!hs){var o;o=(b4.scale>1);cz("ZoomOut",o);if(f7<ap){cz("MouseMode_1",o)}o=(b4.scale<b4.maxScale);var hr=cz("ZoomIn",o);cz("MaxZoom",eU.width!=Y.imageWidth);bK=gb();cD.run("onAnimationComplete")}}if(!S){b4.panPos.left=Math.max(-Y.maxImageOffsetX,Math.min(Y.maxImageOffsetX,b4.panPos.left));b4.panPos.top=Math.max(-Y.maxImageOffsetY,Math.min(Y.maxImageOffsetY,b4.panPos.top))}if(!hs){b4.panPos.left=Math.floor(b4.panPos.left);b4.panPos.top=Math.floor(b4.panPos.top)}g4=true;dJ();A=true;ha();if(!hs){ai()}};var ai=function(){if(!cD.isset("onViewChanged")){return}if(bH!=b){clearTimeout(bH)}bH=setTimeout(bF,250)};var bF=function(){bH=b;var o=cv();if(o==a4){return}a4=o;cD.runPersistent("onViewChanged",[o])};var dV=function(){if(!c7&&!ho){fj()}};var ci=function(){var o=a.getElementClientPos(e5);a3.copyRect(b3);f1.copyRect(o);a3.interSectRectValidate(f1);a3.offsetRect(-f1.left,-f1.top);var hr=(a3.width()>0&&a3.height()>0);var hs=(hr!=av.visible);av.visible=hr;return hs};var cm=function(o){fO.copyRect(o);fO.offsetRect(-w.imageX,-w.imageY);if(bA&&fO.width()>0&&fO.height()>0){fO.inflateRect(gD/g3,gD/g3)}fO.scaleRect(e6)};var k=function(){var hr;var o;hr=(a3.left+a3.width()/2)-av.widthUnScaled/2;if(av.leftLast!=hr){av.leftLast=hr;if(hr<0){hr=0}if(hr>av.maxLeft){hr=av.maxLeft}av.left=hr}av.drawOffsetX=av.scale*-av.left;o=(a3.top+a3.height()/2)-av.heightUnScaled/2;if(av.topLast!=o){av.topLast=o;if(o<0){o=0}if(o>av.maxTop){o=av.maxTop}av.top=o}av.drawOffsetY=av.scale*-av.top;if(d5){dI(av.totalWidth,av.totalHeight);g4=true;dJ()}};var dI=function(hs,hu){if(dN.renderer.setSizeNeLa){dN.renderer.setSizeNeLa(hs,hu)}else{var o=ge.style.width;var ht=ge.style.height;var hv=ge.width;var hr=ge.height;dN.renderer.setSize(hs,hu);ge.style.width=o;ge.style.height=ht;ge.width=hv;ge.height=hr}};var t=function(hr,ht){if(e4){return}var hA=ch;if(!i){l(Y.widthForRatio,Y.heightForRatio,true);ha();return}var hv=false;var hs=fN();c4=b4.scale*ch;var hx=ci();if(hx){hr=true}else{if(!av.visible){return}}if(!hr&&dl){if((hx&&!av.visible)||(av.widthUnScaled<a3.width()||av.heightUnScaled<a3.height()-cx)||(Math.abs(hs-av.scale)>1)){if(hA>1){hA=1;hr=true}}}if(!hr){var hu=av.left;var hE=av.top;k();dh=(hu!=av.left||hE!=av.top);A=true;ha();return}if(ht||av.lastScale!=hs){av.lastScale=hs;ab(hs);var hw=Math.ceil(be.width*hs);var o=Math.ceil(be.height*hs);var hD,hC;var hB=0;if(bA){hB=gD}var hy=a.getViewportSize();av.maxWidth=Math.round((hy.width*ch+hB)*hs/hA);av.maxHeight=Math.round((hy.height*ch+hB)*hs/hA);if(hw>av.maxWidth){hD=av.maxWidth}else{hD=hw}if(o>av.maxHeight){hC=av.maxHeight}else{hC=o}av.width=hD;av.height=hC;av.widthUnScaled=Math.ceil(hD/hs);av.heightUnScaled=Math.ceil(hC/hs);av.totalWidth=hw;av.totalHeight=o;hv=(ht||ge.width!=hD||ge.height!=hC)}av.maxLeft=(av.totalWidth-av.width)/av.scale;av.maxTop=(av.totalHeight-av.height)/av.scale;if(eE){if(av.scale!=1){var hz=1/av.scale;if(b7){av.strTransformScale=" scale3d("+hz+","+hz+","+hz+")"}else{av.strTransformScale=" scale("+hz+","+hz+")"}}else{av.strTransformScale=""}}else{av.strTransformScale=""}k();if(hv){if(b7){g(ge,"translate3d("+av.left+"px,"+av.top+"px,0px)"+av.strTransformScale)}else{g(ge,"translate("+av.left+"px,"+av.top+"px)"+av.strTransformScale)}if(!eE){ge.style.width=hD/hs+"px";ge.style.height=hC/hs+"px"}ge.width=hD;ge.height=hC;cu=ge.getContext("2d");hf=hw;cV=o;l(Y.widthForRatio,Y.heightForRatio,true);bK=gb();if(b4.enabled){c1();b2()}}else{if(b7){g(ge,"translate3d("+av.left+"px,"+av.top+"px,0px)"+av.strTransformScale)}else{g(ge,"translate("+av.left+"px,"+av.top+"px)"+av.strTransformScale)}if(!eE){ge.style.width=ge.width/hs+"px";ge.style.height=ge.height/hs+"px"}}if(!cb){fj();A=true;ha()}else{cK()}};var g=function(o,hr){o.style[bp]=hr};this.showAboutWindow=function(){if(m){m.destroy();m=b;return}var o={};o.title="About FSI Viewer";o.fnOnDestroy=hn;o.strLongVersion=bc.getVersion();m=new a.AboutWindow(gT,o)};var hn=function(){m=b;return true};this.getParameters=function(){return a.utils.cloneParameters(ed)};this.getConfigValue=function(o){if(gi&&typeof(o)==="string"){return gi.cfg[a.trim(o.toLowerCase())]}};this.makeBoolean=function(hr,o){if(gi){return gi.makeBool(hr,o)}};this.getPluginParameter=function(ht,hs,hr,o){if(gi){return gi.getPluginParameter(ht,hs,hr,o)}};this.changeConfig=function(o,hr){cD.run("onChangeConfig",[o,hr]);if(dx.on){a.console.log("")}an=cv();gl();if(hr!=null&&typeof(hr)=="object"){ed=a.utils.cloneParameters(hr)}if(typeof(o)=="string"){ed.cfg=o}gu();dF=true;gl();bc.start()};var ff=function(o,hr){if(!o){return}if(!hr){if(o.FSI_prevDisplayState==b){o.FSI_prevDisplayState=o.style.display}o.style.display="none"}else{if(o.FSI_prevDisplayState!=b){o.style.display=o.FSI_prevDisplayState}o.FSI_prevDisplayState=b}};var f2=function(o){if(!dk){o=false}ff(X,o)};var a6=this.onResize=function(o){if(eK()){return}if(!e4){e4=true;hg();bs=cv();if(H){H.cancel()}ff(hc,false);f2(false);if(fQ){fQ.hide()}}if(o.FSI_after_treshold!=b){bX()}dv(o.FSI_after_treshold)};var dv=function(o){var hr=a.getElementDimension(gT);cD.runPersistent("onResize",[hr.width,hr.height,(o!=b),ea])};this.updatePosition=function(){ci();A=true;ha()};this.updateSize=function(){dz();gV=setTimeout(hi,0)};var dz=function(){if(gV===b){return}clearTimeout(gV);gV=b};var hi=function(){dz();bc.updatePosition();bX()};var bX=function(hr){var ht={};ht.width=be.width;ht.height=be.height;var o;if(gw.keepViewOnResize){if(!bs){bs=cv()}o=bs}bs=false;e4=false;ah();ff(hc,true);f2(true);if(!hr&&ht.width===be.width&&ht.height===be.height){return}hg();eu();if(ge==b||be.width<1||be.height<1){return}var hs=c2;hf=be.width;cV=be.height;l(Y.widthForRatio,Y.heightForRatio);l(Y.widthForRatio,Y.heightForRatio,true);fD();A=true;if(d5){dI(be.width,be.height);cf();dJ();g4=true}eL=c2=b;fp();aJ();if(gc){gc.setContainerSize(aj,Y,bf)}if(cS){cS.setContainerSize(aj)}fa();b2();eR(hs);if(o&&!fH.bEnabled){gY(o)}t(true)};var gl=function(){if(n){n.destroy();n=b}if(e8.nInterval!==b){clearInterval(e8.nInterval);e8.nInterval=b}dz();a.FullScreen.removeChangeEvents(window,cR,aX);cD.run("onReset");if(cS){cS.unregisterExternalButtons()}if(bH){clearTimeout(bH);bH=b}a4=b;cD.removeConfigListeners();g5();if(gI){gI.remove();gI=b}hg();aC={};d1();aR={};dx=new a.EmptyDebugger();z();if(gi){gi.reset();gi.init(ed)}gw={}};var gK=function(){if(eT&&bV){eT.lockImageSourceDimension(bV,false);eT.lockImage(bV,false);eT.removeImages(bV,false)}};var c1=function(){b4.nLastScalePreliminary=b;b4.nLastScaleFinal=b};var aJ=function(){c1();bK=V=b;fs=b};var gE=function(){g9={}};var eu=function(){av=gR.oDynamicCanvas={};av.lastScale=b;ab(1);var o,hr;if(ge){o=ge.width;hr=ge.height}av.leftLast=av.topLast=b;av.width=av.widthUnScaled=av.totalWidth=o;av.height=av.heightUnScaled=av.totalHeight=hr;av.left=av.top=0;av.drawOffsetX=av.drawOffsetY=0};var z=function(){dz();hg();aM.abortAll();dE=0;gF=true;bD();if(H){H.cancel()}aB();bR();ew();fp();ak();el();b4.panPos={left:0,top:0};b4.maxScale=b4.maxScaleInitial=1;b4.scaleToSourceImage=1;b4.scale=1;b4.pos=b4.frames=0;b4.sourceX=b4.sourceY=0;b4.targetX=b4.targetY=0;b4.sourceZoom=b4.targetZoom=1;b4.dX=b4.dY=b4.dZoom=0;b4.lockPanAnimation=false;eu();f4(1);ch=eN=1;gE();bx=b;eU={width:0,height:0};am++;aJ();dY=true;f2(false);aA=b;c2=b;eL=b;ho=false;c3=true;bM=false;if(cS){cS.setEnabled(false,true)}bt=false;c=b;cn=false;if(!i&&bV){a.removeEvent(bV,"load",dr)}cU={width:0,height:0};gK();hl=cF;fR();if(ga){clearTimeout(ga);ga=b}if(d9){clearTimeout(d9);d9=b}en("image",true);gy();e=[];if(eG){if(bN!=b){a.removeChild(X,bN);bN=b}for(var o=0;o<gw.hotspots.points.length;o++){var hr=gw.hotspots.points[o];if(hr&&hr.tooltip){if(hr.interactive){a.removeEvent(hr.tooltip,"mouseover",fk);a.removeEvent(hr.tooltip,"mouseout",fk)}a.removeChild(hr.tooltip.parentNode,hr.tooltip);a.removeChild(hr.marker.parentNode,hr.marker)}}}cb=false;eG=false;eo=b;bg="";dG=0;a1=b;g2=[];el();if(ct){ct=b}fe={};ec=b};var el=function(){if(dR){fC(dR);if(dR.parentNode){a.removeChild(dR.parentNode,dR)}dR=b}};var fC=function(hs){try{if(hs&&hs.FSIEvents){for(var hu in hs.FSIEvents){var hr=hs.FSIEvents[hu];a.removeEvent(hs,hu,hr.fn,hr.phase)}}}catch(ht){}};this.addListener=function(ht,hr,hs){var o=false;if(cD){o=cD.addListener(ht,hr,hs);ce()}return o};this.removeListener=function(hs,hr){var o=false;if(cD){o=cD.removeListener(hs,hr);ce()}return o};var ce=function(){cM=cD.isset("onProgress");cL=cD.isset("onZoomChanged")};gR.registerPointerHandlers=function(o,hs,ht,hr){if(gO[o]){return}gO[o]={fnDown:hs,fnMove:ht,fnUp:hr}};gR.unregisterPointerHandlers=function(o){if(gO[o]===b){return}delete gO[o]};var eq=function(o,ht){gR.onUserAction();if(!cn||eD<0){return false}dd("mousedown");b8=(f3.interval!=b);aB();hg();bR();if(b4.enabled){var hs=false;if(c0&&c0.timeStamp!=b&&(o.timeStamp-c0.timeStamp)<300){if(Math.abs(c0._posx-ht.x)<50&&Math.abs(c0._posy-ht.y)<50){hs=true}}if(!hs){var hr=(S)?b4.targetZoom:b4.scale;eX=(hr<=1)}c0=o;c0._posx=ht.x;c0._posy=ht.y;ew()}c7=true;cD.run("onStartDragging",[false]);if(eT&&eD==2&&!x){eT.lockImageSourceDimension(bV,true);eT.lockImage(bV,true)}ge.lastOffsetX=ht.x;ge.lastOffsetY=ht.y;cw=ee;dC.x=ht.x;dC.y=ht.y;switch(eD){case 0:if(b4.enabled){aL.clientOffset=a.getElementPosition(hc);aL.setRect(ht.x,ht.y,ht.x,ht.y);fX=true;ha()}break;case 2:e8.bEnabled=(g3>1);e8.bEnabled=true;e8.bSuspended=false;if(e8.bEnabled){e8.nTimeLastMove=e8.nTime=a.now();e8.nInterval=setInterval(fo,200)}dC.SceneSetStart=dC.SceneSetLast=aY.nCurrent;aL.clientOffset=a.getElementPosition(hc);b0("mouseDown");break}if(gO[eD]&&gO[eD].fnDown){gO[eD].fnDown.apply(bc,[o,ht])}return true};var W=function(hx,hw){if(bd>1.2){hx.FSI_allowEventDefault=true;return}var hr=ge.lastOffsetX-hw.x;var o=ge.lastOffsetY-hw.y;switch(eD){case 0:if(b4.enabled){aL.setRect(aL.left,aL.top,hw.x,hw.y);ha()}break;case 2:if(e8.bSuspended){e8.nTimeLastMove=e8.nTime=a.now();e8.nInterval=setInterval(fo,200);b0("mouseDown");e8.bSuspended=false}if(aY.nSceneSets<2){if(Math.abs(o)>3*Math.abs(hr)){hx.FSI_allowEventDefault=true}}else{var hy=hw.y-dC.y;var hv=dC.SceneSetStart-Math.round(hy*aY.nSceneSets/be.height);hv=Z(hv);if(hv!==dC.SceneSetLast){fP(hv);dC.SceneSetLast=hv}}g0(cw-(hw.x-hx.FSI_start_x)/ft);dG=(hr<0)?-1:1;e8.nTimeLastMove=e8.nTime;break;default:if(eD<100){var hs=false;if(b4.enabled){var hu=b4.panPos.left;var ht=b4.panPos.top;b4.panPos.left-=hr*av.scale;b4.panPos.top-=o*av.scale;b2();hs=(hu!=b4.panPos.left||ht!=b4.panPos.top);if(!hs){aO(true);hx.FSI_allowEventDefault=true}else{aO(false);ha()}}else{hx.FSI_allowEventDefault=true}}}ge.lastOffsetX=hw.x;ge.lastOffsetY=hw.y;if(gO[eD]&&gO[eD].fnMove){gO[eD].fnMove.apply(bc,[hx,hw])}};var fo=function(){e8.nTime+=200;if(e8.nTime-e8.nTimeLastMove>400){cI()}};var cI=function(){if(e8.nInterval!==b){clearInterval(e8.nInterval);e8.nInterval=b}e8.bSuspended=true;gk()};var fL=function(hr,hv,hu){gR.onUserAction();if(!fm.bActive){aO(true)}var o=hr._FSI_Canceled;var hs=hr._FSI_Click;if(hs&&h){if(h.onClick(hr,hv)){hs=false}}cD.run("onStopDragging",[false]);c7=false;fX=false;dd("mouseup");if(o){if(eD==2){gk("pointer up - canceled")}return}switch(eD){case 0:if(b4.enabled){gs();if(!hs&&b4.maxScale>1){eH(gH)}ha()}break;case 1:if(f7==ap&&g3<=1){gq(0,0)}break;case 2:if(e8.nInterval){clearInterval(e8.nInterval);e8.nInterval=b}if(!hr._FSI_fromAfterTouch){eI(b,false)}else{var ht=di(ee,false);eh(ht,ht,1,1);gk("pointer up")}break}fR();if(hs){bU(hr,hv,hu)}if(gO[eD]&&gO[eD].fnUp){gO[eD].fnUp.apply(bc,[hr,hv])}};var bj=function(){return(eD==2||(eD==1&&g3>1))};var P=function(hv){if(eD==2){var hs=eo/bB;var hr=hv.x-dC.x;var o=-hr/ft+cw;var hu=Math.round(o/hs)*hs;var ht=-(hu-cw)*ft;hv.x=ht+dC.x}return hv};var bU=function(hr,hu){if(b8&&gi.getPluginParameter("autospin","preventClickZoomWhileSpinning",false,true)){return}if(dd("click")===true){return}if(eD==0||(gw.clickZoomInAllMouseModes&&eD<100)){if(!eX){gq(0,0)}else{if(b4.maxScale>1){var hs=a.getElementPosition(hc);var o=hu.x-hs.left;var ht=hu.y-hs.top;fG(o*av.scale,ht*av.scale)}}}};var dd=function(hr){var hs=H.getInitialDownEvent();if(!hs||!hs.target||hs.target==hc){return false}var o=hs.target;while(o!=b&&o!=gT&&o.FSIHotspot==b){o=o.parentNode}if(o&&o.FSIHotspot){return fT(hr,o)}return false};var gf=function(hs,hr,hv,ht){for(var hu in hv){hr[hu]=hs.getFloatParameter(ht+hu,hv[hu])}};var ej=function(hs,hr,hv,ht){for(var hu in hv){hr[hu]=hs.getIntParameter(ht+hu,hv[hu])}};var dn=function(ht,hs,hr,hu){for(var hv in hr){hs[hv]=ht.getStringParameter(hu+hv,hr[hv])}},v=function(hs,hr,hu,ht){for(var hv in hu){hr[hv]=hs.makeBool(hs.getStringParameter(ht+hv),hu[hv])}};var da=function(hr,o,ht,hs){var hu;if(ht&&ht.length>0){if(o[ht]==b){o[ht]={}}hs=hs[ht];hu=o[ht]}else{hu=o}if(hs.strings){dn(hr,hu,hs.strings,ht)}if(hs.booleans){v(hr,hu,hs.booleans,ht)}if(hs.floats){gf(hr,hu,hs.floats,ht)}if(hs.integers){ej(hr,hu,hs.integers,ht)}};var cq=function(hr){var hs={strings:{dir:"",skin:"black",language:"english",backgroundColor:"#FFF",hotspotLineColor1:"#000000",hotspotLineColor2:"#FFFFFF",hotspotDotColor1:"#58a8ff",hotspotDotColor2:"#FFFFFF",hotspotCallbackFunction:b,headers:"cors",fpxservertemplate:b,imagemattecolor:"FFFFFF",initialview:"",initialMouseMode:"auto",navWidth:"120",navHeight:"120",panLimits:"strict",inPlaceZoom:"true",documentZoom:"auto",hideUI:"false",spinDirectionImage:"right",progressBarVAlign:"bottom",progressBarHAlign:"center",MenuButtonOrder:b,urlLoadingAnimation:"/skins/resources/loading.svg"},booleans:{menubar:true,keepViewOnResize:true,useDevicePixelRatio:true,adaptiveUISize:true,drawCube:false,drawTable:false,drawGroundPlate:false,pellets:true,enableHotspots:true,decodeHTMLEntitiesInHotSpotTexts:false,enableZoom:true,noCanvas:false,useMaskedJPEGs:true,noNav:false,autoHideNav:true,autoDisablePointerActions:true,loadExactPreviewImagesAfterResize:false,preventImageTransparency:false,noSetLoop:false,noSceneLoop:false,initialViewPersistent:false,showPreviewWhileLoading:true,spinPreviewWhileLoading:true,showProgressbar:true,reverseSceneSets:false,autoDestroy:true,clickZoomInAllMouseModes:true},floats:{pelletsOpacity:0.15,fMouseSensitivity:1,desktopClickZoomScale:3,autoSpinSpeed:0,autoSpinInterval:0,tableDiameter:950,maxZoom:100,progressBarWidth:35,progressBarHeight:14},integers:{hotspotDotRadius:4,zoomPrecision:1,minInstanceSize:60,quality:-1},video:{strings:{skin:"black",base:"videos/",source:"",spinDirection:"right",sceneSet:0},integers:{captureFrames:120,frameOffset:0},floats:{captureOffsetStart:0,captureOffsetEnd:0,widthCorrectionFactor:1,heightCorrectionFactor:1,xCorrectionFactor:0,yCorrectionFactor:0}},camera:{strings:{position:"",targetPosition:"",armJointPosition:""},floats:{digitalCropFactor:1,focalLength:50,distanceToTableCenter:1500,heightAboveTable:500,heightTable:b,heightCamera:b,targetHeightOffset:0,targetWidthOffset:0,shiftX:0,armLength:0,armAngleMeasureSetup:0,armAngleStart:0,armAngleEnd:0}},virtualSpace:{strings:{position:""},floats:{cubeSizeX:100,cubeSizeY:100,cubeSizeZ:100,cubeLineWidth:1,baseRotationX:0,rotationXRange:180,rotationXSets:0,baseRotationY:0,rotationYRange:360,rotationYScenes:0,baseRotationZ:0,shiftX:0,shiftZ:0,shiftY:0}}};if(hr==b){hr={}}hr.serverBase=gi.serverBase;da(gi,hr,"",hs);da(gi,hr,"camera",hs);da(gi,hr,"virtualSpace",hs);da(gi,hr,"video",hs);if(gw.enableHotspots){var o=gi.getUnrecognizedConfigNode("hotspots3d");c9(o)}cp="&effects=Matte("+encodeURIComponent(gw.imagemattecolor)+")"};var c9=function(ht){var hB={strings:{id:"",normalClass:"",hoverClass:"",activeClass:"",text:"",actionParameter:b,url:b,urlTarget:"_self",cssStyle:"",cssClass:""},booleans:{interactive:false,rotateOnFocus:true,zoomOnFocus:true,focusOnClick:true},floats:{perimeterZoom:1,perimeterImageWidth:0,perimeterAngle:b,perimeterAngleRange:30,perimeterAngleFadeOut:10,perimeterAngleX:b,perimeterAngleXRange:30,perimeterAngleXFadeOut:10,perimeterAngleY:b,perimeterAngleYRange:30,perimeterAngleYFadeOut:10,verticalMarkerSize:100,horizontalMarkerSize:30,markerAngle:45,horizontalMarkerPosition:0,verticalMarkerPosition:0.5,perimeterDistance:b,perimeterTerminator:b,x:0,y:0,z:0,focusRadius:0.25,focusAngleX:b,focusAngleY:b}};var hv=[];var hu;var hz=new a.Config();var hs,hy,hA;var hx,hr,hC;if(gi.cfg.hotspots!=b&&gi.cfg.hotspots.length>0&&typeof(gi.cfg.hotspots.join)=="function"){dx.log("Using HotSpots from JS parameters");gw.hotspots={};gw.hotspots.defaults={};gw.hotspots.points=new Array(gi.cfg.hotspots.length);hs=gi.cfg.hotspotsdefaults;if(hs==b){hs=gi.cfg.hotspotdefaults}if(hs!=b){hz.makeObjectPropertiesLowerCase(hs);hz.cfg=hs;hu={};da(hz,hu,"",hB);for(hr in hB){hy=hB[hr];for(hC in hy){if(hu[hC]!=b){hy[hC]=hu[hC]}}}hs=hu;hu={};for(hr in hs){if(hs[hr]!=b){hu[hr]=hs[hr]}}gw.hotspots.defaults=hu}for(hx=0;hx<gi.cfg.hotspots.length;hx++){hA=gi.cfg.hotspots[hx];hz.makeObjectPropertiesLowerCase(hA);hz.cfg=hA;hA={};da(hz,hA,"",hB);gw.hotspots.points[hx]=hA}}else{if(!ht){return}ht=ht.firstChild;while(ht){if(ht.nodeType!=1){ht=ht.nextSibling;continue}var hw=ht.nodeName.toLowerCase();switch(hw){case"hotspot":hv.push(ht);break;case"defaults":hu=ez(hz,ht,hB);break}ht=ht.nextSibling}if(hu!=b){for(hr in hB){hy=hB[hr];for(hC in hy){if(hu[hC]!=b){hy[hC]=hu[hC]}}}hs=hu;hu={};for(hr in hs){if(hs[hr]!=b){hu[hr]=hs[hr]}}}if(hv.length>0){for(hx=0;hx<hv.length;hx++){hv[hx]=ez(hz,hv[hx],hB)}gw.hotspots={};gw.hotspots.points=hv;gw.hotspots.defaults=hu}}if(gw.hotspots&&gw.hotspots.points){dx.log("HotSpots parsed: "+gw.hotspots.points.length);eG=(gw.hotspots.points.length>0)}else{eG=false}};var ez=function(hr,hu,ht){var o=a.utils.attributes2parameters(hu);hu=hu.firstChild;while(hu){if(hu.nodeType!=1){hu=hu.nextSibling;continue}var hs=hr.getValueFromXMLNode(hu,"");o[hs.name]=hs.value;hu=hu.nextSibling}hr.cfg=o;var hv={};da(hr,hv,"",ht);return hv};var d4=function(){cq(gw);gi.result=gw;var o=Math.PI/180;gw.virtualSpace.baseRotationXRad=gw.virtualSpace.baseRotationX*o;gw.virtualSpace.baseRotationYRad=gw.virtualSpace.baseRotationY*o;gw.virtualSpace.baseRotationZRad=gw.virtualSpace.baseRotationZ*o};var gG=function(o,hA){dx.log("Video Dimension: "+o+" x "+hA+"px");var hw=fr.isCropped();var hx=false;var hr=fr.getCropMargins();var hu=aw.width;var hz=hu/o;var hy=hA*hz;var hv=Math.round((aw.height-hy)/2);if(hv>hr.top){hx=true;hr.top=hv}if(hv>hr.bottom){hx=true;hr.bottom=hv}if(hx){dx.log("Cropping images to match video dimension ("+hv+"px)");fr.setCropValues(hr.left+"px",hr.top+"px",hr.right+"px",hr.bottom+"px");q()}if(hw){hr=fr.getCropMargins();hr.scaleRectInt(1/hz);hv=Math.round(hv/hz);fq.left=hr.left;fq.right=hr.right;fq.top=hr.top-hv;fq.bottom=hr.bottom-hv}else{fq.setRect(0,0,0,0)}bx=b;bO();var hs=o-fq.left-fq.right;var ht=hA-fq.top-fq.bottom;cU={width:o,height:hA,croppedWidth:hs,croppedHeight:ht};l(hs,ht);dW();if(cu&&gw.pellets&&gw.pelletsOpacity>0){cs()}};var l=function(hB,hQ,hE){if(!gw||!gw.video||aw===b||!gw.video.widthCorrectionFactor){return}var hI,hL;var hC;var hA;var hD,hN,hK,hv;if(!i){hK=be.width;hv=be.height}else{hK=hf;hv=cV}var hR=hB/hQ;var hz=hK/hv;var hy,o;if(hR>hz){hy=hK}else{o=hv}bO();hI=fr.getFloatRect();var hF=hI.getRange();var hH=a.getFSIServerImageDim(aw.width,aw.height,hy,o,hF,true);hD=hH.width;hN=hH.height;if(hD>eU.width||hN>eU.height){hD=eU.width;hN=eU.height}bK=Math.min(hl,Math.round(hD));hC=Math.round((hK-hD)/2);hA=Math.round((hv-hN)/2);Y.widthForRatio=hB;Y.heightForRatio=hQ;Y.imageWidth=hD;Y.imageHeight=hN;Y.imageX=hC;Y.imageY=hA;if(av.scale===1){Y.imageWidthAbsolute=Y.imageWidth;Y.imageHeightAbsolute=Y.imageHeight;Y.imageXAbsolute=(av.drawOffsetX+Y.imageX-(Y.imageWidth*av.scale-Y.imageWidth)/2)/av.scale;Y.imageYAbsolute=(av.drawOffsetY+Y.imageY-(Y.imageHeight*av.scale-Y.imageHeight)/2)/av.scale}Y.videoWidth=hD*gw.video.widthCorrectionFactor;Y.videoHeight=hN*gw.video.heightCorrectionFactor;Y.videoX=hC+hD*gw.video.xCorrectionFactor-(hD*gw.video.widthCorrectionFactor-hD)/2;Y.videoY=hA+hN*gw.video.yCorrectionFactor-(hN*gw.video.heightCorrectionFactor-hN)/2;if(!hE){aF=bK;ex(w)}ex(bf);if(!hE){hI=fr.getImageRect();var hJ;if(hI.width()>0){hJ=aw.width/hI.width()}else{hJ=0}var hw=Math.ceil(hJ*w.imageWidth);if(aw.__levelsCalculatedFor!=hw){aw.__levelsCalculatedFor=hw;dx.log("Calculating image levels for image base width: "+hw+" px");dx.log("Source image dimension: "+aw.width+" x "+aw.height);var hG=Math.ceil(1.1*hw);bu=[];if(hw>0){if(aw.levels&&aw.levels.length>0){var hP=[];for(hL=0;hL<aw.levels.length;hL++){var hu=parseInt(aw.levels[hL].width);if(!isNaN(hu)){if(hu>hG){hP.push(hu)}else{break}}}if(dx.on){dx.log("Matching server side image levels: "+hP.join(", "))}if(hP.length>0){hP.push(hw);var ht=hP[0];bu.push(ht);for(hL=1;hL<hP.length;hL++){var hM=hP[hL];var hx=ht/hM;while(hx>2.5){ht/=2;hx=ht/hM;if(ht>hG){bu.push(Math.round(ht))}}bu.push(hM);ht=hM}bu.pop();hP.pop();bu.reverse()}if(dx.on){var hO=(bu.length-hP.length);if(hO==0){dx.log("Using server side image levels only.")}else{dx.log("Using "+hO+" additional virtual image levels.")}}}else{dx.log("No image level information from server. Using virtual image levels.");var hr=aw.width;var hS=aw.height;if(hG>0){while(hr>hG&&hS>0){bu.push(hr);hr=Math.round(hr/2);hS=Math.round(hS/2)}}bu.reverse()}}if(dx.on){dx.log("Using image levels: "+bu.join(", "))}}bk()}switch(f7){case fv:Y.maxPanReferenceWidth=be.width*av.scale;Y.maxPanReferenceHeight=be.height*av.scale;break;case ap:Y.maxPanReferenceWidth=0;Y.maxPanReferenceHeight=0;break;default:Y.maxPanReferenceWidth=bf.imageWidth;Y.maxPanReferenceHeight=bf.imageHeight;break}};var ex=function(hr){for(var hs in Y){hr[hs]=Y[hs]}};var ar=function(){var o=gw.video.source;if(o&&o.indexOf("[static]")==0&&gw.serverBase!=b){var hr=gw.serverBase;hr=hr.split("/");hr.pop();hr=hr.join("/");o=o.replace(/\[static\]\/*/,hr+"/static/")}return o};this.start=function(){c8=a.now();fB=0;ei();if(cS&&!dF){cS.destroy();cS=b}if(!gp){return}ev()};var ev=function(){gw={};gi.loadConfigs()};var d2=function(){d4();ah();ce();var hr=[];if(typeof(gi.cfg.invisibleloadingpurposes)==="string"){hr=gi.cfg.invisibleloadingpurposes.split(",")}aM.setNotVisualPurposes(hr);if(gi.hasPlugin("autospin")){var hv=gi.getPluginParameter("autospin","speed",4);if(hv!=b){hv=parseFloat(hv);if(!isNaN(hv)){gw.autoSpinSpeed=hv}}var o=gi.getPluginParameter("autospin","interval");if(o!=b){o=parseInt(o);if(!isNaN(o)){gw.autoSpinInterval=o}}}if(gi.hasPlugin("fullscreen")&&!gi.hasPlugin("resize")){gi.addPluginFromString("resize")}var hx=gw.enableZoom;i=(a.BrowserSupports.canvas());b4.enabled=false;s=false;if(hx&&a.BrowserSupports.canvas()){var ht=""+gw.inPlaceZoom;switch(ht.toLowerCase()){case"auto":b4.enabled=(!a.isMobileDevice);break;default:b4.enabled=gi.makeBool(ht,true);break}ht=""+gw.documentZoom;switch(ht.toLowerCase()){case"auto":s=(a.isTouch);break;default:s=gi.makeBool(ht,true);break}}d=false;ht=""+gw.hideUI;ht=ht.toLowerCase();if((a.isMobileDevice&&ht=="onmobiledevices")||(!b4.enabled&&ht=="ifnoinplacezoom")||gi.makeBool(gw.hideUI)==true){d=true}bo=(!gw.noNav&&!d&&b4.enabled);g8=!gi.makeBool(gw.menubar,true);if(i){eT=b}else{eT=a._FSITouchZoomInstance}if(i&&gi.hasPlugin("resize")){if(!gU){var hs=gN=a.addCustomEvent(gT,"FSIElementDimension",a6);a.setCustomEventListenerProperty(hs,"treshold",100);gU=true}}else{if(gU){a.removeCustomEvent(gT,"FSIElementDimension",a6);gU=false}}if(gw.noCanvas){i=false}var hw=a2;var hu=gi.cfg.customskinclass;if(I&&I.paramCustomSkinClass!==hu){I.destroy()}if(hu!==b){if(!I||I.paramCustomSkinClass!==hu){I=new a.CustomSkinClass(bc,hu,gR,hw)}}else{hw()}};var a2=function(hr){if(gi.makeBool(gw.urlLoadingAnimation,true)&&b6!==gw.urlLoadingAnimation){b6=gw.urlLoadingAnimation;var o=gi.getReloadPath(gi.locationFSIViewer,gw.urlLoadingAnimation);gi.loadFile(o,gh,"text/html; charset=utf-8")}else{u()}};var gh=function(o){var hr=o.responseText;if(f8){f8=b}if(typeof(hr)==="string"&&hr.length>0){a.utils.addViewerClassCSSRule(".fsi-viewer-loading-animation","position:absolute;padding:15px;z-index:10;left:100%;top:0%;transform:translate(-100%,0%);pointer-events:none;");f8=document.createElement("div");a.addClass(f8,"fsi-viewer-loading-animation");f8.innerHTML=hr}u()};var eV=function(){if(!f8||aK){return}db=f8;if(db){aK=true;gT.appendChild(db)}};var g5=function(){if(aK&&db&&db.parentNode){a.removeChild(db.parentNode,db);db=b}aK=false};var d7=function(){var o="/linkeditor/js/fsilinkeditor.js";var hr="fsiviewer.js";var hs=a.utils.getScriptPath(hr,2);dx.log("Loading LLoading language fileinkEditor: "+hs+o);a.loadJavascript(hs+o,dS,bc,gt,hs)};var gt=function(o,hs,hr){h=new a.LinkEditor(bc,gR,gT,{});h.init(dS,hr,u)};var u=function(){if(gi.hasPlugin("linkeditor")&&!h){d7();return}eV();var hr=gw.skin;if(g6!=hr){dF=false;g6=hr}dx.log("Loading skin: "+hr+".css");if(gI){gI.remove();gI=b}if(!dF){var hs=aW.className;aW.name=hr;aW.className="fsi-skin-"+aW.name;gT.className="fsi-root fsi-viewer-root "+aW.className;var o=[{file:"resources/fsi-core.css",nPriority:1},{file:"resources/fsi-viewer-core.css",nPriority:5}];gI=a.utils.loadSkinCSS(hr,bc,c6,10,o);if(hs!=aW.className){cD.runPersistent("onSkinChanged",[aW.className,hs])}}else{c6(dF)}};this.getSkinClassName=function(){return aW.className};var f6=function(){if(fH.bEnabled){return}fH.bEnabled=true;bs=b;if(typeof(gw.initialview)==="string"&&gw.initialview.length>0){var hr=gw.initialViewPersistent;gw.initialViewPersistent=true;bc.resetView(false);gw.initialViewPersistent=hr}else{bc.resetView(false)}fH.hideUI=gi.makeBool(gi.cfg.hideuiindemomode,true);a.addClass(gT,"fsi-demo-mode");a.addEvent(ao,"click",ba,true);if(fH.hideUI){if(cS){cS.show(false);cx=0}if(gc){gc.enable(false,true)}}var o=gi.cfg.demotooltip;if(!a.isMobileDevice&&typeof(o)==="string"&&o.length>0){fH.bToolTip=true;fH.strTip=o;a.addEvent(ao,"mousemove",hd);a.addEvent(ao,"mouseout",fJ)}else{fH.strTip="";fH.bToolTip=false}cD.runPersistent("onEnterDemoMode")};var hd=function(o){if(!fH.oToolTip){if(gR.getToolTip()){fH.oToolTip=gR.getToolTip();fH.bDestroyToolTip=false}else{fH.oToolTip=new a.ToolTip(gT);fH.oToolTip.setContent({});fH.bDestroyToolTip=true}}var hr=a.getElementClientPos(gT);fH.oToolTip.show(fH.strTip,null,o.clientX-hr.left,o.clientY-hr.top,b,100,true)};var fJ=function(){if(fH.oToolTip){fH.oToolTip.hide()}};var cC=function(){if(!fH.bEnabled){return}a.removeClass(gT,"fsi-demo-mode");a.removeEvent(ao,"click",ba);if(fH.hideUI){if(cS){cS.show(true);cx=bE}if(gc){gc.enable(true,false)}}if(fH.bToolTip){a.removeEvent(ao,"mousemove",hd);a.removeEvent(ao,"mouseout",fJ);fH.oToolTip.hide();if(fH.bDestroyToolTip){fH.oToolTip.destroy();fH.oToolTip=b}}fH.bEnabled=false;fH.hideUI=false;cD.runPersistent("onExitDemoMode")};var ba=function(){if(!fH.bEnabled){return}var hr=gi.cfg.demourl;var hs=gi.cfg.demourltarget;if(!hs){hs="_self"}var o=cD.run("onClickDemoMode",[hr,hs]);if(o===false){return}if(hr==="no action"){return}if(hr==="enter fullscreen"){fH.bRestore=true;if(gi.hasPlugin("fullscreen")){gR.clickMenuButton("ToggleFullScreen",b,true)}}else{window.open(hr,hs)}};var c6=function(o){if(gi.cfg.demourl){f6()}else{cC()}gI=b;if(o){dx.log("Skin loaded successfully. ");cT()}else{dx.error("Failed to load skin.");eB={hMenuBar:0};aW._nameParsedLast=b}ef()};this.showMenuButton=function(hr,o){if(cS){cS.showButton(hr,o)}};this.getMenuHeight=function(hr){var o=bE;if(hr!=b){switch(hr){case"navWindow":if(eB.bFloatingNavWindow){o=0}break}}return o};var cT=function(){if(aW._nameParsedLast!=aW.name){aW._nameParsedLast=aW.name;var hw=document.createElement("div");hw.style.position="absolute";hw.style.top="0px";hw.style.left="0px";hw.style.width="1px";hw.style.height="1px";hw.style.overflow="hidden";hw.style.visibility="hidden";var hr=document.createElement("div");hw.appendChild(hr);gT.appendChild(hw);var hy={};var ht=function(hG,hD,hB,hA,hC){var hz,hF;if(hy[hG]==b){hr.className=hG;hF=hy[hG]=getComputedStyle(hr,hC)}else{hF=hy[hG]}hz=hF.getPropertyValue(hD);if(hA){hz=hz.replace(/^[^{]*/g,"");hz=hz.replace(/[^}]*$/g,"");hz=hz.replace(/\\"/g,'"');if(hz.length>0){try{hz=JSON.parse(hz)}catch(hE){a.console.error("ERROR parsing JSON from CSS selector '"+hG+"' property '"+hD+"'.");a.console.error(hE.message)}}else{hz={}}}if(hz==b){hz=hB}return hz};eB=ht("fsi-ui-info","content",b,true,":before");eB.bFloatingMenuBar=gi.makeBool(eB.floatingMenuBar);eB.bFloatingNavWindow=gi.makeBool(eB.floatingNavWindow);eB.hMenuBar=ht("fsi-ui-menu-bar","height");aW.urlLogo=ht("fsi-ui-logo-image","background-image");if(typeof(aW.urlLogo)=="string"){var hv=/url\(\s*["']?([^"')]*)["']?\s*\)/;var o=hv.exec(aW.urlLogo);if(o&&o.length>0){aW.urlLogo=o[1]}}aW.navFrameBorderColor=ht("fsi-ui-nav-frame","border-left-color","red");aW.navFrameBackgroundColor=ht("fsi-ui-nav-frame","background-color","rgba(255,255,255,0.5)");at=ht("fsi-ui-select-frame","border-left-color","red");bn=ht("fsi-ui-select-frame","background-color","rgba(255,255,255,0.25)");aW.oProgressBarStyle={};aW.oProgressBarStyle.color=ht("fsi-ui-progressbar","color","#CCC");aW.oProgressBarStyle.background=ht("fsi-ui-progressbar","background-color","#FFF");aW.oProgressBarStyle.border=ht("fsi-ui-progressbar","border-left-color","#CCC");aW.oProgressBarStyle.text=ht("fsi-ui-progressbar-text","color","#555");var hx=16;var hs=8;if(eB){if(!isNaN(eB.baseSize)&&eB.baseSize>0){hx=eB.baseSize}if(!isNaN(eB.baseEnlargement)&&eB.baseEnlargement>0){hs=eB.baseEnlargement}}else{eB={}}var hu=1;if(a.isMobileDevice&&gw.adaptiveUISize==true){hu=a.getDevicePixelRatio()}ad=Math.round(hx+hs*hu);eB._baseSkinSize=ad;gT.removeChild(hw)}gT.style.fontSize=ad+"px"};var ef=function(){if(typeof(eB.hMenuBar)!="string"||eB.hMenuBar.length<1||isNaN(parseFloat(eB.hMenuBar))){cP=false}else{cP=(d!=true&&!g8)}j()};var d3=function(){if(!cP){cS.removeDomElement()}bE=cS.getHeight();if(eB&&eB.bFloatingMenuBar){cx=0}else{cx=bE}if(fH.bEnabled&&fH.hideUI){cS.show(false);cx=0}ah();br()};this.showMenuToolTip=function(hs,hr,o,ht){if(cS){cS.showToolTip(hs,hr,o,ht)}};this.hideMenuToolTip=function(){if(cS){cS.hideToolTip()}};var j=function(){if(fQ==b){if(a.getViewerLocation()!=b){fQ=new a.ToolTip(gT)}}fK();if(cS==b||!dF){if(cS){cS.destroy()}cS=new a.MenuBar(gR,aW,gT,d3,cG.oAPI.oMenuCommands);cS.setCallbacks(cD)}else{if(dF&&cS){cS.setInterface(gR)}d3()}};var fK=function(){if(fQ!=b&&gw){gi.loadLanguageFile(bq,gw.language,f9,dx)}};var f9=function(hr,o){dK=hr;cD.runPersistent("onLanguageData",[dK]);fQ.setContent(dK)};var eM=function(){if(!cS){return}var hw;var ht=gR.arMenuButtons=[];ht.push({cmd:"Reset"});if(b4.enabled==true){ht.push({cmd:"ZoomOut",enabled:false});ht.push({cmd:"ZoomIn"})}if(gi.hasPlugin("mousemodes")||gi.hasPlugin("mousemodeselect")){var hr=[0,1];if(g2.length>1){hr.push(2)}if(gi.hasPlugin("measure")){hr.push(100)}var hy={};for(hw=0;hw<hr.length;hw++){hy[hr[hw]]=true}hr=hr.join(",");var hu=gi.getPluginParameter("mousemodes","sequence",hr);var hv=(hu!==hr);hu=hu.split(",");if(hv){var hA={};for(hw=0;hw<hu.length;hw++){hA[hu[hw]]=true}for(var hz in hy){if(!hA[hz]){hu.push(hz)}}}var hx={};for(hw=0;hw<hu.length;hw++){hx[hu[hw]]=gi.getPluginParameter("mousemodes","mode"+hu[hw],true,true)}if(!b4.enabled){hx[0]=hx[1]=false}var hs=function(hB){if(!hy[hB]||!hx[hB]){return}var hC=true;if(hB==1){hC=(f7>e3)}ht.push({cmd:"MouseMode_"+hB,groupID:"MouseMode",enabled:hC})};for(hw=0;hw<hu.length;hw++){hs(parseInt(hu[hw]))}}if(gi.hasPlugin("maxzoom")&&b4.enabled){ht.push({cmd:"MaxZoom"})}if(eG){if(!gi.hasPlugin("hotspots")){gi.addPluginFromString("hotspots")}if(gi.getPluginParameter("hotspots","button","true",true)){ht.push({cmd:"HotSpots",bCheckButton:true})}dk=gi.getPluginParameter("hotspots","visible","true",true)}if(gw.autoSpinSpeed!=0&&gi.hasPlugin("autospin")&&gi.getPluginParameter("autospin","button",true,true)){ht.push({cmd:"ToggleAutoSpin",bCheckButton:true})}var o=false;if(gi.hasPlugin("fullscreen")){o=true;a.FullScreen.addChangeEvents(window,cR,aX);ht.push({cmd:"ToggleFullScreen",bCheckButton:1})}cS.addButtons(ht,gw.MenuButtonOrder);cD.run("onInitMenu");if(o&&ea){cS.setButtonPressed("ToggleFullScreen",true)}if(eG&&dk){cS.setButtonPressed("HotSpots",true)}};var fD=function(){var o;if(!s){o=Math.round(Math.max(1,hq)*Math.max(be.width,be.height))}else{o=Math.round(Math.max(1,hq)*Math.max(screen.width,screen.height))}fz=Math.min(1024,Math.max(2,Math.ceil(o/3/128))*128)};var br=function(){if(typeof(gw.virtualSpace)!="object"){return}var hu=gi.parsePositionParameter(gw.virtualSpace.position);if(hu!=b){gw.virtualSpace.shiftX=hu.x;gw.virtualSpace.shiftY=hu.y;gw.virtualSpace.shiftZ=hu.z}if(gi.cfg.cameraarmanglestart!=b){gw.virtualSpace.baseRotationX=gw.camera.armAngleStart;if(gi.cfg.cameraarmangleend!=b){gw.virtualSpace.rotationXRange=gw.camera.armAngleEnd-gw.camera.armAngleStart}}if(gw.useDevicePixelRatio){hq=a.getDevicePixelRatio()}else{hq=1}gR.devicePixelRatio=hq;fD();fr=new a.CroppedImage();fr.setCropFromConfig(gi.cfg);switch(gw.panLimits){case"loose":f7=ap;break;case"medium":f7=e3;break;default:f7=fv;break}p();e9=true;if(gw.noSceneLoop){hj=a0}else{hj=e0}G=gw.virtualSpace.rotationYRange*-Math.PI/180;aY.rotXRange=gw.virtualSpace.rotationXRange;var o=(gw.virtualSpace.rotationXSets>0)?gw.virtualSpace.rotationXSets:aY.nSceneSets-1;aY.rotXGradPerSet=(aY.rotXRange/(aY.nSceneSets-1))*Math.PI/180;if(fF!==b){var ht=fF;fF=b;bc.changeImage.apply(bc,ht);return}var hs=gw.dir;if(hs===b||hs.length===0){hs=gi.cfg.images3durl}if(!hs||hs.length===0){var hr=gi.getImageList();if(hr){bP(hr.arImages,hr.oXML,hr)}else{return dc("failed to load image list")}}else{hr=gi.loadImageList(hs,bP,ck);if(dx.on&&typeof(hr._url)=="string"){dx.log("Loading image list: "+hr._url)}}};var bP=function(hr,hs){if(!hr||hr.length<1){dx.error("Failed to load image list.");return dc("image list is empty")}d1();g2=hr;bB=af=hr.length;aY=gi.parseSceneSets(g2.length,false);dx.log("Image list ready ("+g2.length+" images)");if(g2.length>0){if(gi.cfg.fpxwidth!==b&&gi.cfg.fpxheight!==b){var o={};o.width=parseInt(gi.cfg.fpxwidth);o.height=parseInt(gi.cfg.fpxheight);bT(null,o)}else{gi.loadImageInfo(g2[0],bT)}}else{bv()}};var cH=function(){var o={};o.angle=gw.virtualSpace.baseRotationX;o.stepAngle=gw.virtualSpace.rotationXRange/(aY.nSceneSets-1);return o};var eW=function(){if(!d5||aY.nSceneSets<1){return}if(aY.bSetCameraPosition){return}aY.bSetCameraPosition=true;var hx=new THREE.Vector3();var hr=new THREE.Vector3();var hC=new THREE.Vector3();var hA=new THREE.Object3D();var hs=new THREE.Object3D();hA.add(hs);var hD=new THREE.Object3D();hs.add(hD);var hw=180/Math.PI;var hH;var hI=dN.targetObj.position;hs.rotation.set(0,0,0);hC.set(0,hI.y,hI.z);if(gi.cfg.cameraarmlength==b){hH=dN.camera.position.distanceTo(hI)}else{hH=gw.camera.armLength}var hz=gi.parsePositionParameter(gw.camera.armJointPosition);if(hz==b){hs.position.set(hI.x,hI.y,hI.z)}else{hs.position.set(hz.x,hz.y,hz.z)}hs.rotation.x=gw.camera.armAngleMeasureSetup/hw;hA.rotation.set(0,0,0);hD.rotation.set(0,0,0);hD.position.set(0,0,hH);hA.updateMatrixWorld();hr.setFromMatrixPosition(hD.matrixWorld);var hG=cH();var hF=hG.angle;var hy=hG.stepAngle;if(gw.reverseSceneSets){hF+=gw.virtualSpace.rotationXRange;hy=-hy}dx.log("Calculated Camera Positions:");dx.log("----------------------------");var o=180/Math.PI;for(var hB=0;hB<aY.nSceneSets;hB++){var ht=aY.arSets[hB];ht.cameraArmAngle=hF;hs.rotation.x=hF/hw;hA.updateMatrixWorld();hx.setFromMatrixPosition(hD.matrixWorld);ht.posCamera=new THREE.Vector3(dN.camera.position.x+hx.x-hr.x,dN.camera.position.y+hx.y-hr.y,dN.camera.position.z+hx.z-hr.z);hx.x=0;ht.xAngleToTarget=hC.angleTo(hx)-Math.PI/2;ht.xAngleToTargetDeg=ht.xAngleToTarget*o;if(dx.on){dx.log("SceneSet "+(hB+1)+", arm angle "+hF+"°, angle to target: "+ht.xAngleToTargetDeg+"°, position (x,y,z): "+ht.posCamera.x+", "+ht.posCamera.y+", "+ht.posCamera.z)}if(eG){ht.visibleHotSpots={};for(var hE=0;hE<gw.hotspots.points.length;hE++){var hu=gw.hotspots.points[hE];var hv=1;if(hu.perimeterAngleX!=b){var hJ=Math.abs(hu.perimeterAngleX-ht.xAngleToTargetDeg);if(hJ>180){hJ=Math.abs(360-hJ)}if(hJ<hu.perimeterAngleXRange){if(hJ>hu.perimeterAngleXRange-hu.perimeterAngleXFadeOut){hv=(hu.perimeterAngleXRange-hJ)/hu.perimeterAngleXFadeOut}}else{hv=0}ht.visibleHotSpots[hu.FSIHotspotID]=hv}else{ht.visibleHotSpots[hu.FSIHotspotID]=1}}}hF+=hy}};var dO=function(){if(aY.bDefault){return}var hu=100000000;var hz=0;var hv,ht,hy;var hB;if(dx.on){hB=a.utils.cloneObject(aY.arSets)}var hA={};for(hv=0;hv<aY.arSets.length;hv++){hy=aY.arSets[hv].arScenes;for(ht=0;ht<hy.length;ht++){var hw=hy[ht]=hy[ht]-1;hA[hw]=g2[hw]}}var hx=[];var hs=e.length;for(var hr in hA){hx.push(hA[hr]);hA[hr]=hs;hs++}for(hv=0;hv<aY.arSets.length;hv++){hy=aY.arSets[hv].arScenes;for(ht=0;ht<hy.length;ht++){hy[ht]=hA[hy[ht]]}hu=Math.min(hu,hy.length);hz=Math.max(hz,hy.length)}if(aY.arSets[0].arScenes.length>0){aY.bDefault=false;aY.quantizeMin=hu;aY.quantizeMax=aY.quantizeMaxImages=hz;if(dx.on){dx.log('Using SceneSets Parameter: "'+gi.cfg.scenesets+'"');dx.log("Parsed SceneSets:");for(hv=0;hv<hB.length;hv++){dx.log("Scene "+(hv+1)+": "+hB[hv].arScenes.join(", "))}}g2=hx;if(aY.arSets.length>1){if(hu!=hz){aY.bQuantize=true}if(dE!=b&&dE>0){aY.quantizeMax=Math.max(aY.quantizeMax,dE);if(hz!=aY.quantizeMax){aY.bQuantize=true}}}}else{aY.bDefault=true;aY.bHasMultipleSets=false;dx.error('Invalid SecenSet definition: "'+gi.cfg.scenesets+'"')}};var a9=function(){var ht=100000000;var o=0;for(var hs=0;hs<aY.arSets.length;hs++){var hr=aY.arSets[hs].arScenes;ht=Math.min(ht,hr.length);o=Math.max(o,hr.length)}return{min:ht,max:o}};var fY=function(){var hu,hx;var hr=aY.quantizeMax;for(var hw=0;hw<aY.arSets.length;hw++){if(hw==aY.nVideoSet){continue}var hv=aY.arSets[hw].arScenes;if(hv.length<hr){var o=hv.length;aY.arSets[hw].fQuantizeFactor=hr/o;var hs=o-1;var ht=new Array(hr);for(hu=0;hu<hr;hu++){hx=(hu*hs/(hr-1));ht[hu]=hv[Math.round(hx)]}aY.arSets[hw].arScenes=ht}else{aY.arSets[hw].oSpinPositions=false}}};var a5=function(){var hv,hu,hw,ht,hA;if(aY.bDefault){return}var hs=gw.virtualSpace.rotationYScenes;for(hv=0;hv<aY.arSets.length;hv++){if(hv===aY.nVideoSet){continue}var hB=aY.arSets[hv];var hz=hB.arScenes;var hy=hz.length;hA=ht=b;for(hu=0;hu<hy;hu++){hw=hz[hu];if(ht===b||ht>hw){ht=hw}if(hA===b||hA<hw){hA=hw}}hB.minScene=ht;hB.maxScene=hA;hB.sceneRange=hA-ht;var hr=(hs>0)?hs:hB.sceneRange+1;var o=hB.oSpinPositions={};var hx=o.arPositions={};for(hu=0;hu<hy;hu++){hw=hz[hu];hx[hw]=(hw-ht)/hr}}};var dc=function(o){g5();bY("default");if(cS){cS.setEnabled(false)}cD.run("onInitFailed",[o])};var bT=function(hr,o){if(!o||o.width==b||isNaN(o.width)){return dc("Failed to load image info")}aw=o;aw.transparency=gi.makeBool(aw.alpha);aw.width=parseInt(aw.width);aw.height=parseInt(aw.height);if(gw.fpxservertemplate!=b){fe.renderer=gw.fpxservertemplate}if(gw.headers!=b){fe.headers=gw.headers}dP=(aw.transparency&&!gw.preventImageTransparency);if(dP){if(i){bt=gw.useMaskedJPEGs}else{var hs=gi.cfg.fpxservertemplate;if((gw.video==b||!gw.video.source.length)&&(hs==b||hs=="jpeg")){fe.renderer="png"}}}hb=(!dP||!bt);if(typeof(aw.levels)=="object"&&typeof(aw.levels.sort)=="function"){aw.levels.sort(aN)}else{aw.levels=b}fr.setSourceDimension(aw.width,aw.height);q();l(eU.width,eU.height);dW();bv()};var aN=function(hr,o){return o.width-hr.width};var dW=function(){if(fr.isCropped()){var hr=fr.getImageRect();var o=hr.width()/Y.imageWidth;aR.cropScaleX=aw.width/hr.width();aR.cropScaleY=aw.height/hr.height();aR.x=(hr.left+hr.width()/2-aw.width/2)/o;aR.y=(hr.top+hr.height()/2-aw.height/2)/o}else{aR.cropScaleX=1;aR.cropScaleY=1;aR.x=0;aR.y=0}};var q=function(){var o;if(fr.isCropped()){o=fr.getPixelRangeRect();eU.width=o.right;eU.height=o.bottom}else{eU.width=aw.width;eU.height=aw.height}};var bv=function(){if(typeof(gi.cfg.fullscreenelement)!="undefined"){dD=gi.cfg.fullscreenelement}else{dD=ao}gE();d5=false;bJ=false;var o=true;if(a.BrowserSupports.canvas()){if(gw.drawCube||gw.drawGroundPlate||gw.drawTable){bJ=d5=true}if(!d5&&gw.enableHotspots){if(gw.hotspots&&gw.hotspots.points&&gw.hotspots.points.length>0){d5=true}}var hr="js/three_custom_min.js";if(a.getViewerLocation()!=b){hr=a.getViewerLocation()+"/applications/viewer/"+hr}o=false;if(d5){if(typeof(window.THREE)=="object"){o=true}else{if(!a.loadJavascript(hr,dS,bc,e2)){o=true;d5=false}}}else{a.releaseLoadJavascript(hr,dS);o=true}}if(!d5){bJ=false}if(o){dy()}};var e2=function(o,hs,hr){if(typeof(window.THREE)!="object"){d5=false}if(!d5){bJ=false}dy()};var dy=function(){if(gw.video.spinDirection&&gw.video.spinDirection.toLowerCase()=="left"){gw._reverseVideoDirection=true}if(gw.spinDirectionImage!=b){if(gw.spinDirectionImage.toLowerCase()=="left"){gw._reverseImageDirection=true}}else{gw._reverseImageDirection=gw._reverseVideoDirection}if(!aY.bDefault){if(gw._reverseImageDirection){for(var o=0;o<aY.arSets.length;o++){aY.arSets[o].arScenes.reverse()}gw._reverseImageDirection=false}if(gw.reverseSceneSets){aY.arSets.reverse()}}if(gw._reverseImageDirection){g2.reverse();g2.unshift(g2.pop())}f=ar();cW();eM();if(eG){f2(true)}else{f2(false)}if(ge){hm();fU()}cD.run("onDataComplete")};var cA=function(){if(eD!=b&&cS){cS.setButtonPressed("MouseMode_"+eD,true)}if(bo){cY()}};var cW=function(){if(eU.width){hl=Math.min(cF,eU.width)}else{hl=cF}bk()};var bk=function(){b4.scaleToSourceImage=Math.max(1,eU.width/bf.imageWidth);b4.maxScale=b4.maxScaleInitial=gw.maxZoom/100*b4.scaleToSourceImage;b4.defaultZoom=Math.min(gw.desktopClickZoomScale,b4.maxScale)};this.destroyOnDetach=function(){if(gw&&gw.autoDestroy!=false){f0()}};var f0=this.destroy=function(o){cC();if(h){h=h.destroy()}if(I){I.destroy()}aM.destroy();hg();if(gi){gi.destroy()}if(ao){ao.removeAttribute("x-fsi-id");a.removeClass(ao,"fsi-viewer")}if(m){m.destroy()}if(gI){gI.remove();gI=b}if(bz!=b){a.removeCustomEvent(gT,"FSIMouseWheel",fI);bz=b}if(B!=b){a.removeCustomEvent(hc,"FSIDocumentZoomChange",dZ);B=b}if(eY!=b){a.removeCustomEvent(e5,"FSIViewport",bb);eY=b}if(gU){a.removeCustomEvent(gT,"FSIElementDimension",a6);gU=false}if(d9){clearTimeout(d9);d9=b}Q();if(fQ){fQ.destroy();fQ=b}ei();if(H){H.destroy();H=b}gp=false;gl();if(cS){cS.destroy();cS=b}if(gT){if(ge){a.removeChild(e5,ge);a.removeChild(gT,e5);ge=b}if(gT.parentNode==ao){a.removeChild(ao,gT)}gT=b}if(X){a.removeChild(X.parentNode,X);X=b}if(hc){if(!a.isMobileDevice){a.removeEvent(hc,"keydown",cZ);a.removeEvent(hc,"keyup",cl)}a.removeChild(hc.parentNode,hc);hc=b}if(!o&&cD){cD.run("onDestroy");cD.destroy()}};var p=function(){if(!be||be.width<10||be.height<10){return false}if(hc==b){gR.eventOverlay=hc=document.createElement("div");hc.className="fsi-event-overlay";var hr="position:absolute;z-index:300;width:100%;height:100%;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;";if(a.isInternetExplorer){a.utils.setStyleAttr(hc,hr+";background-color:rgba(0,0,0,0)")}else{a.utils.setStyleAttr(hc,hr)}bY("wait");if(!a.isMobileDevice){hc.setAttribute("tabIndex","0")}gT.appendChild(hc);if(!H){var hs={};hs.detectGestures=true;hs.afterTouch={enabled:true};hs.afterTouch.modifyTarget=P;hs.afterTouch.fnGetAfterTouchEnabled=bj;hs.afterTouch.fnStartStopAfterTouch=J;if(b4.enabled){hs.detectClick=true;hs.onPinchStart=r;hs.onPinchChange=dX;hs.onPinchEnd=gQ}H=new a.TouchHandler(hc,hs,eq,W,fL)}if(!a.isMobileDevice){a.addEvent(hc,"keydown",cZ);a.addEvent(hc,"keyup",cl)}if(b4.enabled){bz=a.addCustomEvent(gT,"FSIMouseWheel",fI);a.setCustomEventListenerProperty(bz,"acceleration",1.7);a.setCustomEventListenerProperty(bz,"accelerationMax",30)}else{if(bz!=b){a.removeCustomEvent(gT,"FSIMouseWheel",fI);bz=b}}if(b4.enabled){if(B==b){B=a.addCustomEvent(hc,"FSIDocumentZoomChange",dZ);a.triggerCustomEvent(B)}}else{if(B){a.removeCustomEvent(hc,"FSIDocumentZoomChange",dZ);B=b}if(H){H.enable(true)}}}if(X==b&&eG){X=document.createElement("div");a.addClass(X,"fsi-ui-hotspot-container");a.utils.setStyleAttr(X,"position:absolute;z-index:4;");hc.appendChild(X)}if(X){ff(X,false)}if(ge==b||ge.FSIisCanvas!=i){if(ge!=b&&ge.FSIisCanvas!=i){a.removeChild(gT,ge);fW=ge=bV=b}e5=document.createElement("div");e5.setAttribute("draggable","false");a.utils.setStyleAttr(e5,"position:absolute;overflow:hidden;width:100%;height:100%;");if(i){ge=document.createElement("canvas")}else{ge=document.createElement("div")}e5.appendChild(ge);gT.appendChild(e5);var o="z-index:1;position:absolute;transform-origin:0px 0px;	-webkit-transform-origin:0px 0px;	-ms-transform-origin:0px 0px;";o+="backface-visibility: hidden;-webkit-backface-visibility: hidden;";a.utils.setStyleAttr(ge,o);if(i){cu=ge.getContext("2d");dA=cu.webkitBackingStorePixelRatio||cu.mozBackingStorePixelRatio||cu.msBackingStorePixelRatio||cu.oBackingStorePixelRatio||cu.backingStorePixelRatio||1;if(!eE){ge.style.width=ge.style.height=""}}else{ge.style.textAlign="left"}ge.FSIisCanvas=i}if(typeof(gw.backgroundColor)=="string"&&gw.backgroundColor.toLowerCase()=="none"){gw.backgroundColor="transparent"}gT.style.backgroundColor=gw.backgroundColor;if(!i){if(fW==b){fW=bV;bV=b}if(bV!=b){a.removeChild(bV.parentNode,bV)}bV=document.createElement("img");if(fW!=b){bV.style.display="none"}ge.appendChild(bV)}if(i){if(eY==b){eY=a.addCustomEvent(e5,"FSIViewport",bb);a.setCustomEventListenerProperty(eY,"treshold",250)}}else{if(eY!=b){a.removeCustomEvent(e5,"FSIViewport",bb);eY=b}a3.setRect(0,0,be.width,be.height)}hf=ge.width=Math.ceil(be.width*av.scale);cV=ge.height=Math.ceil(be.height*av.scale);ge.lastOffsetX=ge.lastOffsetY=0;if((a.BrowserSupports.documentZoom()&&!a.isMobileDevice)||(a.isMobileDevice&&!i)){fM=true}eu();return true};var r=function(o,ht,hs){if(b4.maxScale<=1){fm.bActive=false;return}fm.bActive=true;fm.lastX=ht.x;fm.lastY=ht.y;fm.distanceStart=o._FSI_PinchDistance;var hr=a.getElementPosition(hc);fm.offsetX=-hr.left-be.width/2;fm.offsetY=-hr.top-be.height/2;fm.startZoom=b4.scale;aO(false)};var dX=function(hw,hu,hx){if(!fm.bActive){return}if(bd>1.2){hw.FSI_allowEventDefault=true;return}var hs=hu.x-fm.lastX;var o=hu.y-fm.lastY;fm.lastX=hu.x;fm.lastY=hu.y;var hz=fm.startZoom*hw._FSI_PinchScale;hz=Math.max(1,Math.min(b4.maxScale,hz));var hy=hz*100/b4.maxScale;var hv=hu.x+fm.offsetX;var ht=hu.y+fm.offsetY;var hr=hz/b4.scale;b4.panPos.left-=hv;b4.panPos.top-=ht;b4.panPos.left*=hr;b4.panPos.top*=hr;b4.panPos.left+=hv;b4.panPos.top+=ht;b4.panPos.left+=hs;b4.panPos.top+=o;bc.setZoom(hy,true,false)};var gQ=function(o,ht,hs){if(!fm.bActive){return}fm.bActive=false;aO(true);var hr=b4.scale*100/b4.maxScale;bc.setZoom(hr,false,false)};var K=function(hs){bd=hs;var hr=hq;if(hr<1||gw.useDevicePixelRatio){hs=hr*hs}if(fs!=hs){fs=hs;b4.maxScale=Math.max(1,b4.maxScaleInitial/hs);dJ();ch=hs;if(eG){var o=ch;if(!a.isMobileDevice&&hq!==1){o/=hq}if(eN!==o){eN=o;dM=true}if(!cb){ha()}}}};var eK=function(){var o=false;if(a.FullScreen){o=a.FullScreen.getElement()}return(o&&o!=dT)};var bb=function(o){if(eK()){return}b3=o.FSI_viewport_rect;K(o.FSI_scale);if(!cn){return}t(o.FSI_after_treshold)};var dZ=function(){fa()};var fa=function(){if(gw.autoDisablePointerActions){var hr=a.getViewportSize();var o=(bc.getInFullScreenMode()||(aj.width<=hr.width&&aj.height<=hr.height));if(o!==gx){gx=o;H.enable(o);if(gc){gc.enable(o)}}}};var aQ=function(){return(c7&&(!H||!H.isAfterTouchRunning()))};var fI=function(hy){gR.onUserAction();if(fH.bEnabled||hy.FSI_delta==0){return}aB(false);if(hy.preventDefault){hy.preventDefault()}y();bQ();var hz=aQ();if(cb||hz){return}if(b4.maxScale<=1){return}var hx=0.45*hy.FSI_normalized_accelerated_delta;cy=H.getMousePositionClient(hy);var hw=a.getElementPosition(hc);var hs=1+Math.abs(hx)/6;if(hx<0){hs=1/hs}var hA=Math.max(1,Math.min(b4.maxScale,b4.scale*hs));var hv=cy.x*av.scale-hw.left-be.width*av.scale/2;var hu=cy.y*av.scale-hw.top-be.height*av.scale/2;var o=hA/b4.scale;var ht=b4.panPos.left-hv;var hr=b4.panPos.top-hu;ht*=o;hr*=o;ht+=hv;hr+=hu;eP(ht,hr,hA,13);if(gc&&gc.isDragging()){b4.lockPanAnimation=true}hy.cancelBubble=true};var J=function(o){gL=o;if(o){ha()}};var gy=function(){if(!d0){return}ay=false;if(d0._timeOutDraw){clearTimeout(d0._timeOutDraw)}d0=b};var eF=function(){if(!gw.showProgressbar){return}if(g2.length<2){gy();return}if(!i){return}var o=0;switch(gw.progressBarHAlign){case"left":case"right":o=8;break}d8=Math.max(10,(be.width*(Math.max(0,Math.min(100,gw.progressBarWidth/100)))-2*o))*av.scale;dQ=Math.max(1,Math.min(be.height,gw.progressBarHeight))*av.scale;d0=new a.CanvasProgressBar(cu,0,0,d8,dQ,aW.oProgressBarStyle);cK();d0._timeOutDraw=setTimeout(by,100)};var by=function(){if(d0){ay=true}};var cK=function(){if(!d0){return}var o,hr;switch(gw.progressBarHAlign){case"left":o=av.scale*8;break;case"right":o=av.scale*(be.width-d8-8);break;default:o=av.scale*((be.width-d8)/2)}switch(gw.progressBarVAlign){case"middle":case"center":hr=av.scale*(be.height/2-dQ/2);break;case"top":hr=av.scale*4;break;default:hr=av.scale*(be.height-4-dQ)}d0.setPos(o,hr)};var fU=function(){var hD;cB(0);var hv=false;aG=(!a.isMobileDevice&&(a.isOpera||a.isInternetExplorer));eF();bY("wait");var hx="";if(f.indexOf("//")==-1){hx=gw.video.base}if(!i||a.isMobileDevice||!f){dx.log("Using image sequence w/o video.");return dg()}var hB=gw.video.captureOffsetStart;if(hB==b||isNaN(hB)){hB=0}var ht=gw.video.captureOffsetEnd;if(ht==b||isNaN(ht)){ht=0}var hw;hD=gw.video.captureFrames;if(hD==b||isNaN(hD)){gw.video.captureFrames=120}if(aY.nSceneSets>1){var hy=a9();gw.video.captureFrames=Math.max(gw.video.captureFrames,hy.max)}else{gw.video.captureFrames-=gw.video.captureFrames%g2.length;gw.video.captureFrames=Math.max(gw.video.captureFrames,g2.length)}var hC=document.createElement("canvas");hC.setAttribute("webkit-playsinline","");var hz=hC.getContext("2d");if(!dt){dt=document.createElement("canvas");hk=dt.getContext("2d")}hD=hx+f;if(a.isInternetExplorer&&a.versionInternetExplorer<10&&a.utils.isCrossDomain(hD)){dx.error("CROSS DOMAIN VIDEO ACCESS not possible with this browser.");dx.log("Falling back to using image sequence.");return dg()}dx.log("Capture "+gw.video.captureFrames+" video frames");dR=document.createElement("video");dR.setAttribute("muted","muted");dR.setAttribute("preload","auto");dR.setAttribute("webkit-playsinline","");dR.setAttribute("crossorigin","anonymous");a.utils.setStyleAttr(dR,"position:absolute;z-index:10000;width:1px;height:1px");if(a.isSafari){dR.style.display="none"}dR.style.marginLeft=be.width/2+"px";dR.style.marginTop=be.height/2+"px";if(!a.isSafari&&!a.isInternetExplorer){var hs=document.createElement("source");hs.setAttribute("src",hx+f+".webm");dR.appendChild(hs)}var hr=document.createElement("source");hr.setAttribute("src",hx+f+".mp4");dR.appendChild(hr);if(!a.isSafari&&!a.isInternetExplorer){var o=document.createElement("source");o.setAttribute("src",hx+f+".ogv");dR.appendChild(hr)}gT.appendChild(dR);dR.FSIEvents={};var hA=function(hF,hG,hE){dR.FSIEvents[hF]={fn:hG,phase:hE};a.addEvent(dR,hF,hG,hE)};hA("error",function(hE){if(dR.networkState==dR.NETWORK_NO_SOURCE){dx.error('Failed loading the video: "'+f+'"');dx.log("Falling back to using image sequence w/o video.");dg()}},true);hA("loadedmetadata",function(hF){cb=true;en("video");var hG=dR.videoWidth;var hE=dR.videoHeight;dR.setAttribute("width",hG);dR.setAttribute("height",hE);hw=(dR.duration-hB-ht)/gw.video.captureFrames;gG(hG,hE);hC.setAttribute("width",cU.croppedWidth);hC.setAttribute("height",cU.croppedHeight);dt.setAttribute("width",cU.croppedWidth);dt.setAttribute("height",cU.croppedHeight);cA();gZ()},true);hA("canplaythrough",function(hE){if(!hv){if(a.isSafari){dR.style.display=""}hv=true;this.currentTime=Math.max(0,hB)}},true);var hu=0;hA("seeked",function(hE){if(!cb){return}var hF=dR.duration;if(a.isInternetExplorer){hF-=0.3}if(e.length<gw.video.captureFrames){try{hz.drawImage(hE.target,0,0,cU.width,cU.height,-fq.left,-fq.top,cU.width,cU.height);var hH=hz.getImageData(0,0,hC.width,hC.height);e.push(hH)}catch(hG){dx.error('Failed capturing the video: "'+f+'"');dx.log("REASON: "+hG.message);dx.log("Falling back to using image sequence w/o video.");cb=false;dg();return}cB(100*e.length/gw.video.captureFrames);cd(e.length-1);ha();hu=Math.min(hF,hw*e.length+hB);if(aG){d9=setTimeout(function(hI){dR.currentTime=hu},1)}else{dR.currentTime=hu}}else{c5()}},true)};var fE=this.startAutoSpin=function(){if(!cn||!f3.bEnabledByConfig){return false}if(f3.interval){return true}if(cS){cS.setButtonPressed("ToggleAutoSpin",true)}y();bR();b0("autoSpin");f3.enabled=true;ew();f3.interval=setInterval(fV,f3.nIntervalTime);return true};var gC=function(){if(!cn||!f3.bEnabledByConfig){return false}if(!f3.enabled){fE()}else{aB(true)}};this.stopAutoSpin=function(){return aB()};var aB=gR.stopAutoSpin=function(o){if(!cn||!f3.bEnabledByConfig){return false}if(!f3.interval){return true}if(cS){cS.setButtonPressed("ToggleAutoSpin",false)}f3.enabled=false;gk("autoSpin");clearInterval(f3.interval);f3.interval=b;if(o){eI()}return true};var fV=function(){if(!ho){b0("autoSpin")}var o=ey+f3.nDirection;if(o>=eo){o-=eo}else{if(o<0){o+=eo}}g0(o);ha()};var aS=function(hr){eo=hr;var o=1;if(typeof(gw.fMouseSensitivity)!="undefined"){o=parseFloat(gw.fMouseSensitivity);if(isNaN(o)||o==0){o=1}}ft=160/eo*4/o;dH=eo/120};var gr=function(){var o;if(!aY.bDefault&&aY.nSceneSets>1){o=Math.max(1,Math.min(aY.nSceneSets,gw.video.sceneSet))-1;if(gw.reverseSceneSets){o=(-(o+1)+aY.nSceneSets)%aY.nSceneSets}}return o};var c5=function(){if(gw._reverseVideoDirection){e.reverse();e.unshift(e.pop())}bu.unshift(w.imageWidth);fB=e.length;if(e.length>0){aY.nVideoSet=gr()}else{aY.nVideoSet=b}if(aY.nVideoSet!=b){var o=gX;dg();gX=o}else{dO();b1()}};var fd=function(){if(n){n.destroy()}if(gi.hasPlugin("measure")){n=new a.PluginMeasure(bc,gR)}};var b1=function(){var hr;cB(100);g5();if(cc!=b){f5=cc}fd();a5();if(aY.bQuantize){fY()}cd(0);ay=false;bM=d5;ct=b;if(gw._reverseImageDirection&&gc){gc.reverseImageSequence()}if(eT){ha()}el();gy();bl();bC=false;f3.bEnabledByConfig=false;if(eo>1||aY.nSceneSets>1){x=false;if(a.isIETouch){if(aY.nSceneSets>1){hc.style.msTouchAction="pinch-zoom double-tap-zoom"}else{hc.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}}if(gw.autoSpinSpeed!=0||gw.autoSpinInterval!=0){if(gw.autoSpinInterval!=0){hr=gw.autoSpinInterval;f3.nDirection=(hr>0)?1:-1;hr=Math.abs(hr)}else{if(gw.autoSpinSpeed<0){gw.autoSpinSpeed=-gw.autoSpinSpeed;f3.nDirection=-1}else{f3.nDirection=1}hr=gw.autoSpinSpeed*1000/eo;if(hr==0){hr=1}while(hr<20&&Math.abs(f3.nDirection)<eo/2){hr*=2;f3.nDirection*=2}hr=Math.max(20,Math.ceil(hr))}f3.nIntervalTime=hr;f3.bEnabledByConfig=true;if(!gi.hasPlugin("autospin")||gi.getPluginParameter("autospin","enabled",true,true)){bC=gi.getPluginParameter("autospin","restartonreset",false,true);cn=true;fE();cn=false}}}else{x=true;if(a.isIETouch){hc.style.msTouchAction=b}if(!b4.enabled){bY("default")}}hr=gw.initialMouseMode;if(hr!="auto"){hr=parseInt(hr)}fc(hr);cb=false;var o=b;if(gw.video.frameOffset&&gX){o=ey+gw.video.frameOffset;o=hj(eo+o);cd(o)}ca();cn=true;if(cS){cS.setEnabled(true)}if(c!=b){gY(c,(g2.length>1));c=b}else{if(an!=b&&gi.makeBool(gi.cfg.keepcurrentviewafterconfigchange,false)){gw.initialview=an}if(gw){if(typeof(gw.initialview)==="string"&&gw.initialview.length>0){if(!gY(gw.initialview,false)){gw.initialview=b}else{gw.initialview=cJ(gw.initialview)}}else{gw.initialview=b}}}an=b;if(dx.on){dx.log("Startup time: "+(a.now()-c8)+"ms")}cD.run("onReady");ai();cg();if(b4.enabled){b2()}if(!b4.enabled){if(x){H.setCapture(false,false)}else{H.setCapture(true,false)}}if(eY){a.triggerCustomEvent(eY);t(true)}cD.runPersistent("onAfterReady")};var dg=function(){hg();dE=e.length;en("image");gZ();dO();el();l(eU.width,eU.height);cA();fn()};var dr=function(){a.removeEvent(bV,"load",dr);if(fW!=b&&fW.parentNode!=b){a.removeChild(fW.parentNode,fW);fW=b}bV.style.display="inline";ge.style.paddingLeft=Y.imageX+"px";ge.style.paddingTop=Y.imageY+"px"};var fn=function(){cb=true;if(!i){bV.width=Y.imageWidth;bV.height=Y.imageHeight;a.addEvent(bV,"load",dr,true);if(fW==b){try{ge.style.paddingLeft=ge.style.paddingRight="auto";ge.style.paddingTop=ge.style.paddingRight="auto"}catch(o){}}}if(dt){dt.setAttribute("width",Y.imageWidth);dt.setAttribute("height",Y.imageHeight)}fb()};var e1=function(o){if(o){eV()}else{g5()}};var fZ=function(o,hs,ht,hr){var hu;o.FSI_image_context=o;if(bt){hu={};hu.argsJPEG=Array.prototype.slice.call(arguments);hr=ds;hs=a.utils.changeRendererInURL(hs,"png.alpha");o=hu.argsJPEG[0]._FSI_alpha_mask=new Image()}aM.load(o,hs,ht,hr,hu)};var ds=function(o,hr){aM.load.apply(this,hr.argsJPEG)};var cr=function(hs){if(!hs){return}if(hs.FSI_alpha_channel){var hr=hs.width;var hu=hs.height;var ht=hs.FSI_image_context=document.createElement("canvas");ht.setAttribute("width",hr);ht.setAttribute("height",hu);ht.setAttribute("crossorigin","anonymous");var o=ht.getContext("2d");o.drawImage(hs.FSI_alpha_channel,0,0,hr,hu);o.globalCompositeOperation="xor";o.drawImage(hs,0,0,hr,hu);hs.FSI_alpha_channel=b}};var cB=function(o){aa=o;if(cM){cD.runPersistent("onProgress",[o])}};var fb=function(){er={};er.oImages={};er.nPendingImages=0;er.nNext=0;er.nCurrentIndex=-1;er.nLoaded=0;if(!i){er.img=new Image()}var hr=Math.min(6,g2.length);for(var o=0;o<hr;o++){D()}};var gB=function(o){er.nLoaded++;cB(100*er.nLoaded/g2.length);if(er.nNext!==this.FSI_nImage){er.oImages[this.FSI_nImage]=this;er.nPendingImages++}else{bS(this);dU()}D()};var dU=function(){if(er&&er.nPendingImages>0){while(er&&er.oImages[er.nNext]){var hr=er.nNext;var o=er.oImages[hr];er.oImages[hr]=b;er.nPendingImages--;bS(o)}}};var bS=function(o){er.nNext++;cr(o);if(i){e.push(o)}else{e.push(o.src)}cd(e.length-1);ha();if(er.nLoaded>=g2.length){dU();ak();if(eT){eT.addImage(bV)}b1()}};var D=function(){if(!er||++er.nCurrentIndex>=g2.length){return}var o;if(i){o=eZ=new Image();o.FSI_nImage=er.nCurrentIndex}else{o=er.img}fZ(o,gP(er.nCurrentIndex).fullURL,"sequence",gB)};var ak=function(){if(er===b){return}aM.abortPurpose("sequence");er=b};var g0=function(o){var hr=hj(Math.round(o));if(hr!=hj(ey)){dJ();cd(hr);ha();if(cn&&fA==b&&f3.interval==b){ai()}}ee=o};var b0=function(o){if(ho){return}T=true;ho=true;Q();c3=false;A=false};var gk=function(o){if(!ho){return}cd(hj(ey));ho=false;c3=true;A=true;if(!dl||ey!=dl.spinPos){if(dl){fp()}fj()}else{cX(50)}};var cd=function(o){ey=ee=o;if(!aT){dm=ey}else{dm=aT[ey]}};var cs=function(){var o,hw,hs;ec=document.createElement("canvas");ec.setAttribute("width",cU.croppedWidth);ec.setAttribute("height",cU.croppedHeight);em=ec.getContext("2d");var hu=ec.width;var hr=ec.height;var ht=em.createImageData(hu,hr);var hv=ht.data;for(hw=0;hw<hr;hw++){if(hw%4==0){for(o=0;o<hu;o++){if(o%4!=0){hs=hw*hu*4+o*4;hv[hs]=0;hv[hs+1]=0;hv[hs+2]=0;hv[hs+3]=255}}}else{if(hw%4==1||hw%4==2){for(o=1;o<hu;o+=4){hs=hw*hu*4+o*4;hv[hs]=0;hv[hs+1]=0;hv[hs+2]=0;hv[hs+3]=255}}}}em.putImageData(ht,0,0)};var ha=function(){if(L!=b||e4){return}L=requestAnimationFrame(au)};var hg=function(){if(L==b){return}cancelAnimationFrame(L);L=b};var au=function(){L=b;var hr=false;if(gL&&H.runAfterTouch()){hr=true}if(!i){if(a1!=dm){bV.src=e[dm];a1=dm}}else{if(S&&fx()){hr=true}cu.globalAlpha=1;cu.clearRect(0,0,hf,cV);f5();if(c3&&dl){if(hp()){hr=true}}}if(bM){if(g4){var hw=g3*be.width;var ht=g3*be.height;g4=false;var hu=-av.drawOffsetX+(hw-be.width*av.scale)/2-b4.panPos.left+aR.x*b4.scale;var hs=-av.drawOffsetY+(ht-be.height*av.scale)/2-b4.panPos.top+aR.y*b4.scale;dN.camera.setViewOffset(hw,ht,hu,hs,av.totalWidth,av.totalHeight)}if(de){et()}if(bJ){dN.renderer.render(dN.scene,dN.camera)}if(de){de=false;if(eG&&dY){if(!bJ){dN.renderer.render(dN.scene,dN.camera)}bL()}}}if(gF){gF=false;if(gc){gc.update(dm,aq)}}if(fX){gs();cu.fillStyle=bn;cu.fillRect(gH.left+1,gH.top+1,gH.width()-1,gH.height()-1);cu.fillStyle=at;cu.fillRect(gH.left,gH.top,gH.width(),1);cu.fillRect(gH.left,gH.bottom,gH.width(),1);cu.fillRect(gH.left,gH.top,1,gH.height());cu.fillRect(gH.right,gH.top,1,gH.height())}if(ay){d0.draw(aa)}if(dh){if(b7){g(ge,"translate3d("+av.left+"px,"+av.top+"px,0px)"+av.strTransformScale)}else{g(ge,"translate("+av.left+"px,"+av.top+"px)"+av.strTransformScale)}}if(hr){ha()}if(eO){var hv=[av,g3,b4];for(var hx in O){O[hx].apply(bc,hv)}}};gR.addDrawListener=function(hr,o){if(!hr||typeof(o)!=="function"){return false}if(O&&O[hr]){return false}if(!O){O={}}O[hr]=o;eO=true;return true};gR.removeDrawListener=function(hr){if(!hr){return false}if(!O||!O[hr]){return false}delete O[hr];var ht=0;for(var hs in O){ht++}if(ht===0){O=b;eO=false}return true};var et=function(){var o;if(cQ.oSpinPositions){o=cQ.oSpinPositions.arPositions[dm]}else{o=ey/eo}fl(0,o*G,0)};var gs=function(){gH.copyRect(aL);gH.offsetRect(-aL.clientOffset.left,-aL.clientOffset.top);gH.normalizeRect();if(av.scale!=1){gH.scaleRect(av.scale)}};var dJ=function(){de=gF=true};var ep=function(){return false};var M=function(o){cu.drawImage(o.img.FSI_image_context,o.x,o.y,o.width,o.height);return false};gR.getAccessToken=function(){return aV};this.setAccessToken=function(o){aV=o;if(gi){gi.setAccessToken(aV)}};var gM=function(hr){var o;hr.alpha+=e7;if(hr.alpha>=1){hr.fnDraw=M;hr.alpha=1;o=false}else{o=true}cu.globalAlpha=hr.alpha;M(hr);cu.globalAlpha=1;return o};var hp=function(){var o=false;if(A){gW()}if(dl.nVisibleTiles>0){var hv=av.drawOffsetX+Y.imageX+b4.panPos.left;var hu=av.drawOffsetY+Y.imageY+b4.panPos.top;var ht=Y.imageWidth/dl.width;cu.save();cu.translate(hv,hu);cu.scale(ht,ht);var hr=dl.arVisibleTiles;for(var hs=0;hs<dl.nVisibleTiles;hs++){if(hr[hs].fnDraw(hr[hs])){o=true}}cu.restore()}dl.bTilesFading=o;if(!hh&&T&&!o&&dl.bFilesArePreparedForLoading){if(ct.nTilesLoading==0&&dl.arTilesToLoad.length==0){T=false}}return o};var en=function(o,hr){fh=(o=="video");if(fh){eL=b;dw=dt;bW=gR.getPreviewImage=aE;f5=co}else{bW=gR.getPreviewImage=cE;f5=gv}if(!hr){gX=fh;if(gw){if(g2.length>1){if(!gw.showPreviewWhileLoading){cc=f5;f5=a.fnDoNothing}else{if(!gw.spinPreviewWhileLoading){cc=f5;if(!aC.bSetup){aC.bStillPreview=true;f5=a.fnDoNothing}else{if(aC.imgDraw){f5=gg}else{f5=a.fnDoNothing}}}else{cc=b}}}aC.bSetup=true}}};var gZ=function(){if(!aC.bStillPreview||aC.bStillPreviewDone){return}gA()};var gA=function(){aC.bStillPreviewDone=true;var ht=cn;cn=true;var hu;var hv=es(gw.initialview);var o;if(aY.bDefault){hu=hv.scene}else{var hs=aY.arSets[hv.SceneSet];hu=hs.arScenes[hv.scene]-1}bO();var hr=gP(hu).fullURL;aC.img=new Image();fZ(aC.img,hr,"stillPreview",C);cn=ht;bx=b};var C=function(){cr(this);aC.imgDraw=this.FSI_image_context;f5=gg};var gg=function(){ax(aC.imgDraw,Y.imageX,Y.imageY,g3)};var aE=function(o){if(eL==o){return dw}eL=o;hk.putImageData(e[o],0,0);dw=dt;return dw};var cE=function(o){if(eL==o){return dw}eL=o;if(!c2){c2=w.imageWidth;if(hb){aA=document.createElement("canvas");aA.setAttribute("width",w.imageWidth);aA.setAttribute("height",w.imageHeight);g7=aA.getContext("2d")}}if(!hb){dw=e[o].FSI_image_context}else{g7.drawImage(e[o].FSI_image_context,0,0,w.imageWidth,w.imageHeight);dw=aA}return dw};var co=function(){cu.globalAlpha=1;var o=g3*w.videoWidth/cU.croppedWidth;ax(aE(dm),Y.videoX,Y.videoY,o);if(T&&gw.pellets&&!F){cu.globalAlpha=gw.pelletsOpacity;cu.globalCompositeOperation="xor";ax(ec,Y.videoX,Y.videoY,o);cu.globalAlpha=1;cu.globalCompositeOperation="source-over"}};var gv=function(){ax(cE(dm),Y.imageX,Y.imageY,g3)};var ax=function(ht,hA,hx,hr){if(!ht){return}var hz=0;var hy=0;var hu=av.drawOffsetX+hA+b4.panPos.left;var hs=av.drawOffsetY+hx+b4.panPos.top;if(hu<0){hz=-hu/hr;hu=0}if(hs<0){hy=-hs/hr;hs=0}var hB=ht.width-hz;var hw=ht.height-hy;var hv=hB*hr;var o=hw*hr;cu.drawImage(ht,hz,hy,hB,hw,hu,hs,hv,o)};gR.getImagePos=function(ht){var hs,o,hr,hu;if(ht){hs=bf.imageXAbsolute;o=bf.imageYAbsolute;hr=bf.imageWidthAbsolute;hu=bf.imageHeightAbsolute}else{hs=av.drawOffsetX+(Y.imageX+b4.panPos.left)/av.scale;o=av.drawOffsetY+(Y.imageY+b4.panPos.top)/av.scale;hr=Y.imageWidth/av.scale;hu=Y.imageHeight/av.scale}return{x:hs,y:o,width:hr,height:hu}};var cY=function(){if(gc!=b){ei()}if(b4.enabled&&i){gc=new a.NavigatorWindow(gR,gi,aW,gT);if(fH.hideUI){gc.enable(false,true)}}};var ei=function(){if(gc==b){return}gc.destroy();gc=b};var cf=function(){if(!d5||!dN.targetObj){return}var ht=be.width*av.scale;var hx=be.height*av.scale;dN.sceneWidth=bf.imageWidth*aR.cropScaleX;dN.sceneHeight=bf.imageHeight*aR.cropScaleY;var hu=dN.sceneWidth;var o=hu/1.5;var hw=o/hx;var hv=gw.camera.digitalCropFactor*gw.camera.focalLength*hw;var hr=2*THREE.Math.radToDeg(Math.atan(24/hv/2));dN.camera=new THREE.PerspectiveCamera(hr,dN.sceneWidth/dN.sceneHeight,0.1,10000);var hs=gi.parsePositionParameter(gw.camera.position);if(hs!=b){aZ.x=hs.x;aZ.y=hs.y;aZ.z=hs.z}else{if(gw.camera.heightTable!=b&&gw.camera.heightCamera!=b){gw.camera.heightAboveTable=gw.camera.heightCamera-gw.camera.heightTable}if(gw.camera.shiftX==b){gw.camera.shiftX=0}aZ.x=gw.camera.shiftX;aZ.y=gw.camera.heightAboveTable;aZ.z=gw.camera.distanceToTableCenter}dN.camera.position.x=aZ.x;dN.camera.position.y=aZ.y;dN.camera.position.z=aZ.z;eW();dN.camera.lookAt(dN.targetObj.position);dN.camera.rotation.z=0;fg();dN.camera.setViewOffset(ht,hx,-av.drawOffsetX+aR.x,-av.drawOffsetY+aR.y,ht,hx)};var hm=function(){if(!d5){return}var hS;hS=window.THREE;if(a.BrowserSupports.canvas()&&typeof hS!=="undefined"){if(i){dN.renderer=new hS.CanvasRenderer({canvas:ge,clearColor:0,clearAlpha:0,devicePixelRatio:1});dN.renderer.autoClear=false;dI(be.width*av.scale,be.height*av.scale)}else{dN.renderer=new hS.CanvasRenderer({clearColor:0,clearAlpha:0});dN.renderer.autoClear=false;dI(be.width,be.height)}dN.scene=new hS.Scene();dN.objects=new hS.Object3D();var hB=new hS.Object3D();var hR=gi.parsePositionParameter(gw.camera.targetPosition);if(hR==b){hB.position.x=gw.camera.targetWidthOffset;hB.position.y=gw.camera.targetHeightOffset;hB.position.z=0}else{hB.position.x=hR.x;hB.position.y=hR.y;hB.position.z=hR.z}dN.scene.add(hB);dN.targetObj=hB;var hA;if(gw.virtualSpace.cubeLineWidth>0&&gw.drawCube){var hP,hs;if(gw.virtualSpace.cubeSizeX){hP=new hS.CubeGeometry(gw.virtualSpace.cubeSizeX,gw.virtualSpace.cubeSizeY,gw.virtualSpace.cubeSizeZ);hA=gw.virtualSpace.cubeSizeY/2}else{hP=new hS.CubeGeometry(gw.virtualSpace.cubeSize,gw.virtualSpace.cubeSize,gw.virtualSpace.cubeSize);hA=gw.virtualSpace.cubeSize/2}hs=new hS.MeshBasicMaterial({color:65280,wireframe:true,wireframeLinewidth:gw.virtualSpace.cubeLineWidth});var hw=new hS.Mesh(hP,hs);if(gw.virtualSpace.shiftY==b){gw.virtualSpace.shiftY=0}hw.position.x=gw.virtualSpace.shiftX;hw.position.y=hA+gw.virtualSpace.shiftY;hw.position.z=gw.virtualSpace.shiftZ;dN.cube=hw;dN.objects.add(hw)}if(gw.drawGroundPlate){var hH=new hS.PlaneGeometry(500,500,10,10);var hC=new hS.MeshBasicMaterial({color:15626314,wireframe:true});var ht=new hS.Mesh(hH,hC);ht.rotation.x=-Math.PI/2;ht.position.y=0;dN.objects.add(ht);dN.plane=ht}if(gw.drawTable){var o=gw.tableDiameter/2;var hL=50;var hr=new hS.Geometry();var hT;hT=Math.PI*2/360;var hI=0;var hx=function(hX,hW){var hZ=0;var h0=0;var h4=0;var hY=0;for(var h1=0;h1<=36;h1++,hI+=4){var hV=Math.sin(hT*h1)*hX;var h3=Math.cos(hT*h1)*hX;var hU=Math.sin(hT*h1)*hW;var h2=Math.cos(hT*h1)*hW;hr.vertices.push(new hS.Vector3(hU,h2,0));hr.vertices.push(new hS.Vector3(h4,hY,0));hr.vertices.push(new hS.Vector3(hZ,h0,0));hr.vertices.push(new hS.Vector3(hV,h3,0));hr.faces.push(new hS.Face3(hI,hI+1,hI+2));hZ=hV;h0=h3;h4=hU;hY=h2}};var hy=0;var hv=0;for(var hQ=0;hQ<=4;hQ++,hI+=3){var hF=Math.sin(hT*hQ*90)*hL;var hE=Math.cos(hT*hQ*90)*hL;hr.vertices.push(new hS.Vector3(0,0,0));hr.vertices.push(new hS.Vector3(hF,hE,0));hr.vertices.push(new hS.Vector3(hy,hv,0));hr.faces.push(new hS.Face3(hI,hI+1,hI+2));hy=hF;hv=hE}hT=Math.PI*2/36;var hK=0;var hJ=hL;while(hJ<o){hK+=hL;hJ=hK+hL;if(hJ>o){hJ=o}hx(hK,hJ)}var hO=new hS.Mesh(hr,new hS.MeshBasicMaterial({color:5810431,wireframe:true}));hO.rotation.x=-Math.PI/2;dN.disk=hO;dN.objects.add(hO)}if(gw.hotspots&&gw.hotspots.points){aU();go=gw.hotspotCallbackFunction;if(typeof(go)=="string"){try{go=window[go]}catch(hN){}}else{if(typeof(go)!="function"){go=b}}var hG=1;eC={};for(var hM=0;hM<gw.hotspots.points.length;hM++,hG++){var hz=gw.hotspots.points[hM];hz.FSIHotspotID=hG;eC[hG]=hz;if(hz.perimeterAngle!=b&&hz.perimeterAngleY==b){hz.perimeterAngleY=hz.perimeterAngle;hz.perimeterAngleYRange=hz.perimeterAngleRange;hz.perimeterAngleYFadeOut=hz.perimeterAngleFadeOut}if(hz.perimeterAngleY&&hz.perimeterAngleY<0){hz.perimeterAngleY=360+hz.perimeterAngleY}hz.perimeterAngleYFadeOut=Math.min(hz.perimeterAngleYRange,hz.perimeterAngleYFadeOut);if(hz.perimeterAngleX!=b&&hz.perimeterAngleX<0){hz.perimeterAngleX=360+hz.perimeterAngleX}hz.perimeterAngleXFadeOut=Math.min(hz.perimeterAngleXRange,hz.perimeterAngleXFadeOut);var hD=new hS.Object3D();hD.position.x=hz.x+gw.virtualSpace.shiftX;hD.position.y=hz.y+gw.virtualSpace.shiftY;hD.position.z=hz.z+gw.virtualSpace.shiftZ;hz.object=hD;dN.objects.add(hD);if(gw.hotspots.defaults){for(var hu in gw.hotspots.defaults){if(hz[hu]==b){hz[hu]=gw.hotspots.defaults[hu]}}}dp(hz)}dx.log(hM+" HotSpots created.")}dN.scene.add(dN.objects);cf()}};var fk=function(o){var hr=o.type;fT(hr,this)};var fT=function(hu,hs){var hw=false;var o=hs.FSIHotspot;if(!o||!hu){return false}switch(hu){case"mouseover":a.addClass(hs,o.hoverClass);o._bMouseOver=true;o.marker.style.zIndex=o.tooltip.style.zIndex=5000000;break;case"mousedown":a.addClass(hs,o.activeClass);break;case"mouseout":o._bMouseOver=false;a.removeClass(hs,o.hoverClass);o.marker.style.zIndex=o.tooltip.style.zIndex=o.zIndex;break;default:a.removeClass(hs,o.activeClass)}if(go){var hv=o.FSIHotspotID;var ht=o.tooltip;var hy=o.actionParameter;var hx=go(hu,bc,N,hv,ht,hy,o.perimeterAngleY,o.perimeterAngleX);if(hx===true){hw=true}}if(hu=="click"){if(o.url!=b){window.open(o.url,o.urlTarget);hw=true}if(hw==false&&o.focusOnClick==true){var hr=fi(o);gY(hr,true);hw=true}}cD.run("onHotspotEvent",[hu,o.FSIHotspotID,o.id,o.text]);return hw};var fl=function(hs,hr,o){dN.objects.rotation.x=hs;dN.objects.rotation.y=hr+gw.virtualSpace.baseRotationYRad;dN.objects.rotation.z=o};var bL=function(){var hI,hJ;var hD=new THREE.Vector3();if(dM){dM=false;var hs=1/eN;g9.testWidth=g3*w.imageWidth;X.style.webkitTransform="scale("+hs+")";X.style.transform="scale("+hs+","+hs+")"}var hL=eN*av.left;var hK=eN*av.top;var hM=eN*be.width/2;var hu=eN*be.height/2;var hz,hB;var hH=false;var hA;var hO=be.width*eN;var hN=be.height*eN;if(g9.spinFrame!=dm){g9.spinFrame=dm;if(g9.arSpotsAtFrame==b){g9.arSpotsAtFrame=new Array(eo)}var hG=g9.hotSpotsAtThisFrame;g9.hotSpotsAtThisFrame=g9.arSpotsAtFrame[dm];if(g9.hotSpotsAtThisFrame==b){var hy;if(cQ.oSpinPositions){hy=gw.virtualSpace.rotationYRange*cQ.oSpinPositions.arPositions[dm]}else{hy=gw.virtualSpace.rotationYRange*hj(ey)/eo}g9.hotSpotsAtThisFrame=g9.arSpotsAtFrame[dm]=[];for(hJ=0;hJ<gw.hotspots.points.length;hJ++){hA=gw.hotspots.points[hJ];hB=1;if(hA.perimeterAngleY!=b){var hP=Math.abs(hA.perimeterAngleY-hy);if(hP>180){hP=Math.abs(360-hP)}if(hP<hA.perimeterAngleYRange){if(hP>hA.perimeterAngleYRange-hA.perimeterAngleYFadeOut){hB=(hA.perimeterAngleYRange-hP)/hA.perimeterAngleYFadeOut}}else{hB=0}}if(hB!=0){var hF={};hF.index=hJ;hF.hotspot=hA;hF.op=hB;g9.hotSpotsAtThisFrame.push(hF);hD.setFromMatrixPosition(hA.object.matrixWorld);hA.zIndex=hF.zIndex=Math.round(hD.z);if(!hA._bMouseOver){hA.marker.style.zIndex=hA.tooltip.style.zIndex=hA.zIndex}}}}if(hG&&hG.length>0){var hE={};for(hI=0;hI<g9.hotSpotsAtThisFrame.length;hI++){var hr=g9.hotSpotsAtThisFrame[hI];hA=hr.hotspot;if(!hA._bMouseOver){hA.marker.style.zIndex=hA.tooltip.style.zIndex=hA.zIndex}hE[hr.index]=hA.bVisible}for(hI=0;hI<hG.length;hI++){if(!hE[hG[hI].index]){bI(hG[hI].hotspot,false)}}}}if(g9.scale!=eN){g9.scale=eN;hH=true}for(hJ=0;hJ<g9.hotSpotsAtThisFrame.length;hJ++){var ht=g9.hotSpotsAtThisFrame[hJ];hA=ht.hotspot;hB=1;if(cQ.visibleHotSpots){hB=cQ.visibleHotSpots[hA.FSIHotspotID]}hB=hB*ht.op;if(!hH&&hA._opScale!=b){if(hA._opScale==0){hB=0}}else{hA._opScale=1;if(gw.enableZoom&&hA.perimeterZoom!=b){if(g3<hA.perimeterZoom){hB=hA._opScale=0}}if(hB!=0&&hA.perimeterImageWidth!=b){if(g9.testWidth<hA.perimeterImageWidth){hB=hA._opScale=0}}}if(hB!=0){hD.setFromMatrixPosition(hA.object.matrixWorld);hD.project(dN.camera);var hx=Math.round(hL+hD.x*hM+hM);var hv=Math.round(hK+hu-hD.y*hu);if(b4.enabled){if(hx<0||hv<0||hx>hO||hv>hN){hB=0}}}if(hB!=0){bI(hA,true);if(hA._opacity!=hB){hA._opacity=hB;hA.marker.style.opacity=hA.tooltip.style.opacity=hB}var hC=hA.oSvg;hA.tooltip.style.left=hx+hC.endX+(hA.tooltip.offsetWidth*hC.xAlign)+"px";hA.tooltip.style.top=hv+hC.endY+(hA.tooltip.offsetHeight*hC.yAlign)+"px";hA.marker.style.left=hx+hC.startX+"px";hA.marker.style.top=hv+hC.startY+"px"}else{bI(hA,false)}}};var aP=function(ht,hy,hr,hx,o,hw,hu,hs,hv){if(hs==b){hs=bw}if(hv==b){hv=1}var hz=document.createElementNS(dB,"polyline");hz.setAttribute("points",ht+","+hy+" "+hr+","+hx+" "+o+" , "+hw+" "+hr+","+hx+" "+ht+","+hy);hz.setAttribute("stroke",hu);hz.setAttribute("stroke-width",hs);hz.setAttribute("stroke-opacity",hv);hz.setAttribute("stroke-linecap","square");return hz};var aU=function(){var hr=aI=document.createElementNS(dB,"svg");try{if(!hr.style){aI=b;dx.log("ERROR: SVG Gradient not supported");return false}}catch(ht){aI=b;dx.log("ERROR: SVG Gradient not supported");return false}var hw=a.utils.getSVGID();var hs=gw.hotspotDotRadius;hr.setAttribute("xmlns",dB);hr.setAttribute("version",fS);hr.setAttribute("baseProfile","tiny");var o=bN=hr.cloneNode(true);try{var hy=document.createElementNS(dB,"radialGradient");hy.setAttribute("id",hw);hy.setAttribute("cx","0.5");hy.setAttribute("cy","0.5");hy.setAttribute("r","0.5");var hx=document.createElementNS(dB,"stop");hx.setAttribute("stop-color",gw.hotspotDotColor1);hx.setAttribute("offset","0.5");var hv=document.createElementNS(dB,"stop");hv.setAttribute("stop-color",gw.hotspotDotColor2);hv.setAttribute("offset","1");hy.appendChild(hx);hy.appendChild(hv);o.appendChild(hy);o.style.position="absolute";o.style.width="0px";o.style.height="0px";o.style.left="0";o.style.top="0";o.style.zIndex=-500000;o.style.visibility="hidden";X.appendChild(o)}catch(ht){dx.log("ERROR: SVG Gradient not supported")}var hu=document.createElementNS(dB,"circle");hu.setAttribute("r",hs);hu.setAttribute("stroke",gw.hotspotLineColor2);hu.setAttribute("stroke-width","1px");hu.setAttribute("stroke-opacity","0.85");hu.setAttribute("fill","url(#"+hw+")");hu.setAttribute("fill-opacity","0.5");hr.appendChild(hu);return true};var a7=function(hw){var hA=hw.horizontalMarkerSize;var hE=Math.abs(hw.verticalMarkerSize);var hI;if(!aI){return{width:0,height:0,startX:0,startY:0,endX:0,endY:0,xAlign:0,yAlign:0}}var hy=hw.markerAngle*Math.PI/180;var hF,hu,hD,ht,hB,hs;var hK={};var hv=hK.radius=gw.hotspotDotRadius+1;hI=Math.max(0,Math.min(1,hw.horizontalMarkerPosition));if(hI>0.5){hA=-hA}hK.xAlign=-hI;hI=Math.max(0,Math.min(1,hw.verticalMarkerPosition));hK.yAlign=-hI;hF=0;hu=0;hD=hF+Math.sin(hy)*hE;ht=hu-Math.cos(hy)*hE;hB=hD+hA;var hG=Math.min(hF-hv,hD);var o=Math.min(hu-hv,ht);hG=Math.min(hG,hB);hF-=hG;hD-=hG;hB-=hG;hu-=o;ht-=o;hs=ht;hK.startX=-hF;hK.startY=-hu;hK.endX=hK.startX+hB;hK.endY=hK.startY+hs;var hJ=Math.max(hF+hv,hD);hJ=Math.max(hJ,hB);var hr=Math.max(hu+hv,ht);var hz=hK.svg=aI.cloneNode(true);var hx=hK.width=hJ;var hC=hK.height=hr;hz.setAttribute("width",hx);hz.setAttribute("height",hC);hz.setAttribute("viewBox","0 0 "+hx+" "+hC);hz.setAttribute("class","fsi-ui-hotspot-line");var hH=hz.firstChild;hH.setAttribute("cx",hF);hH.setAttribute("cy",hu);hF+=Math.sin(hy)*hv;hu-=Math.cos(hy)*hv;hz.appendChild(aP(hF,hu,hD,ht,hB,hs,gw.hotspotLineColor1,"5px","0.25"));hz.appendChild(aP(hF,hu,hD,ht,hB,hs,gw.hotspotLineColor2,"1px"));return hK};var bI=function(hr,o){if(hr.bVisible==o){return}hr.bVisible=o;if(o){hr._opacity=b;hr.marker.style.display=hr.tooltip.style.display="block"}else{hr.marker.style.display=hr.tooltip.style.display="none";hr._opacity=0;hr.marker.style.opacity=hr.tooltip.style.opacity=0}};var dp=function(hv){var hr=document.createElement("div");var hs="fsi-ui-hotspot";if(b5){hs+=" "+b5}if(hv.cssClass!=b&&hv.cssClass.length>0){hs+=" "+hv.cssClass}if(hv.normalClass.length>0){hv.normalClass=hs+" "+hv.normalClass}else{hv.normalClass=hs}if(hv.hoverClass.length>0){hv.hoverClass="fsi-ui-hotspot-hover "+hv.hoverClass}else{hv.hoverClass="fsi-ui-hotspot-hover"}if(hv.activeClass.length>0){hv.activeClass="fsi-ui-hotspot-active "+hv.activeClass}else{hv.activeClass="fsi-ui-hotspot-active"}hr.className=hv.normalClass;var ht="position:absolute;left:0px;top:0px;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;"+hv.cssStyle;a.utils.setStyleAttr(hr,ht);hr.innerHTML=hv.text;if(gw.decodeHTMLEntitiesInHotSpotTexts){hr.innerHTML=hr.innerText}var hu=a7(hv);var o;if(hu&&hu.svg){o=hu.svg;o.style.position="absolute";X.appendChild(o)}else{o={style:{}}}if(hv.interactive){hr.FSIHotspot=hv;X.appendChild(hr);a.addEvent(hr,"mouseover",fk);a.addEvent(hr,"mouseout",fk)}else{hr.style.zIndex="1";X.appendChild(hr)}hv.bVisible=false;hv.tooltip=hr;hv.marker=o;hv.oSvg=hu;hr.style.display="none";o.style.display="none"};var cZ=function(o){aB();var hr=true;var hs=(eo&&!c7);fu=o.shiftKey;switch(o.keyCode){case 37:if(hs){bR();dG=1;g0(ee+dH)}hr=false;break;case 39:if(hs){bR();dG=-1;g0(ee-dH)}hr=false;break;case 32:hr=false;break}if(!hr&&o.preventDefault){o.preventDefault()}return hr};var cl=function(o){fu=o.shiftKey;if(dx&&dx.on){if(!fu){bY(bZ)}}var hr=true;var hs=(eo&&!c7);switch(o.keyCode){case 37:if(hs){eI(ey,true)}hr=false;break;case 39:if(hs){eI(ey,true)}hr=false;break;case 32:bc.resetView();hr=false;break}if(!hr){o.cancelBubble=true;if(o.stopPropagation){o.stopPropagation()}if(o.preventDefault){o.preventDefault()}}return hr};this.resetView=function(o){if(o===b){o=true}aB(false);ew();dq=bC;if(gw.initialview&&gw.initialViewPersistent){gY(gw.initialview,o)}else{gY("1,1,0,0,1,1",o)}dq=bC};this.spinToDegree=function(o){if(!cn){return}var hr=hj(Math.round(o/360*eo));bc.spinToTarget(hr)};this.spinToTarget=function(ht,hw,hu){if(!cn){return}ht=di(ht);var hz=hj(ey);var hv=ht-hz;var o=(hw!=b&&!isNaN(hw)&&hw!=aY.nCurrent);if(hv==0&&!o){eh(ht,ht,0,0);return true}var hy;if(hv!=0){dG=(hv>0)?1:-1;hy=hz;if(!gw.noSceneLoop){if(Math.abs(hv)>eo/2){if(dG>0){ht-=eo}else{hy-=eo}dG=-dG;hv=Math.abs(ht-hy)}}}else{hy=ht}var hr=aY.nCurrent;var hx;if(o&&!gw.noSetLoop&&aY.nSceneSets>1){hx=hw-aY.nCurrent;if(Math.abs(hx)>aY.nSceneSets/2){if(hx>0){hw-=aY.nSceneSets}else{hr-=aY.nSceneSets}}}bR();if(hu==b||isNaN(hu)){hu=4;if(hv!=0){hu=Math.ceil(0.2*360/eo*Math.abs(hv))}if(o){hx=Math.abs(hw-hr);var hs=Math.ceil(0.1*360/aY.nSceneSets*hx);hu=Math.max(hu,hs)}}eh(hy,ht,0,hu,hr,hw);return true};var Z=function(o){if(aY.nSceneSets<2){return 0}if(gw.noSetLoop){o=Math.max(0,Math.min(aY.nSceneSets-1,o))}else{o=o%aY.nSceneSets;if(o<0){o=aY.nSceneSets+o}}return o};var d1=function(){cQ={};aY.bSetCameraPosition=false;aY.initialScene=aY.initialSceneSet=aY.nCurrent=0;aY.arCurrentSetIndex=false;bB=af=g2.length;cO=(e.length>0)?e.length:bB;aS(cO);aT=false};var bl=function(){if(aY.bHasMultipleSets||!aY.bDefault){aS(aY.quantizeMax);af=aY.quantizeMax;aY.nCurrent=b;fP(0)}else{d1()}};var fP=function(hs){hs=Z(hs);if(hs==aY.nCurrent){return}aY.nCurrent=hs;cQ=aY.arSets[hs];var hr=aY.arCurrentSetIndex=aY.arSets[hs].arScenes;aT=hr;bB=aY.quantizeMaxImages;cO=bB;if(aY.nVideoSet!=b){if(aY.nVideoSet==hs){af=bB=hr.length;cO=dE;if(gc){gc.setPreviewImageSize(cU.croppedWidth,cU.croppedHeight)}if(!fh){en("video",true)}aT=b}else{if(gc){gc.setPreviewImageSize()}af=aY.quantizeMax;if(fh){en("image",true)}}}fg();dJ();var o=ey;eL=ey=b;if(dl){dl.spinPos=b}cd(o);ha();return hs};var fg=function(){if(!aY.bSetCameraPosition||!cQ.posCamera){return}var o=cQ.posCamera;dN.camera.position.set(o.x,o.y,o.z);dN.camera.lookAt(dN.targetObj.position);dN.camera.rotation.z=0};var a0=function(o){o=Math.max(0,Math.min(eo-1,o));return o};var e0=function(o){o%=eo;if(o<0){o=eo+o}return o};var di=function(hr,hu){if(!gX){return hr}var ht;var o=eo/bB;var hs=Math.round(hr/o)*o;if(!hu||hr==hs){ht=hs}else{if(dG==1){ht=Math.round(hs+o)}else{ht=Math.round(hs-o)}}ht=hj(ht);return ht};var eI=function(o,ht){var hr=(o!=b)?o:ey;var hs=di(hr,ht);bc.spinToTarget(hs)};var eh=function(o,hu,hv,ht,hs,hr){o=Math.round(o);hu=Math.round(hu);bR();if(hr!=b&&!isNaN(hr)&&hr!=aY.nCurrent){if(hs==b){hs=aY.nCurrent}}else{hs=b}if(o!=hu||hs!=hr){if(bm(o,hu,hv,ht,hs,hr)){b0("spinToFrame")}else{gk("doSpinToFrame")}}else{gk("doSpinToFrame")}};var bR=function(){if(fA==b){return}cancelAnimationFrame(fA);fA=b;gk("cancelSpinToFrame")};var bm=function(hu,hA,hz,hv,hr,hx){var hy=hA-hu;var hw;if(hy==0){hw=hA}else{hw=aH(hz,hv,hu,hy)}var ht;if(hr!=b){var hs=hx-hr;ht=Math.round(aH(hz,hv,hr,hs))}if(hz!=hv){if(eT){eT.lockImageSourceDimension(bV,true);eT.lockImage(bV,true)}var o=Math.round(hw);if(o<0){o=eo+o}else{if(o==eo){o=0}}fA=requestAnimationFrame(function(){if(hr!=b){fP(ht)}if(o!=ey){dJ();cd(o);ha()}bm(hu,hA,++hz,hv,hr,hx)});return true}else{fA=b;if(eT){eT.lockImage(bV,false)}cd(hj(hA));if(hx!=b){fP(hx)}ca();cg();gk("doSpinToFrame")}};var ca=function(){cd(hj(ey));ha();if(i){fj()}};var gP=function(hr){var o={};o.baseURL=gi.getImageURL(g2[hr],fe);o.fullURL=o.baseURL+gS;return o};var fp=function(){if(!dl){return}cj=b;dl=b;bg=b;T=true;Q();eb()};var eb=function(){aM.abortPurpose("tile")};var bO=function(){if(bx==bK){return}bx=bK;var o=fr.getPixelRangeRect(bK);gS=fr.getPixelRangeParametersByCalculatedResult(o)};var aD=function(o){if(o==b){o=Math.round(ey/(eo/af))}if(isNaN(o)||o<0||o>=af){dx.error("invalid image index in loadHDImage "+o);return}if(aY.arCurrentSetIndex){o=aY.arCurrentSetIndex[o]}o-=dE;return o};var fj=function(hD){if(i&&!fh&&g3<=1){fp();return}if(e4||cj==bK){return}cj=bK;hD=aD(hD);bO();var o=gP(hD);if(bg==o.fullURL){return}if(dl&&o.fullURL==dl.src){return}ct={};ct.img=new Image();ct.nImage=hD;ct.renderScale=g3;var hr=eo/bB;ct.spinPos=di(hD*hr);ct.img.crossOrigin="anonymous";ct.img.FSI_ImageObject=ct;bg=ct.src=o.fullURL;if(i){T=true;ct.bTilesFading=false;ct.bFillsViewport=false;var hy=eU.width;var hx=eU.height;var hw=bK;var hu=Math.round(hw/hy*hx);eb();ct.width=hw;ct.height=hu;var hE=fz;ct.tiles=[];var hB=0;var hz=0;var hC=hE;var hA=hE;hC=Math.min(hC,hw);hA=Math.min(hA,hu);var ht;var hs=false;while(hz<hu){ht={};ht.fnDraw=ep;ht.FSI_ImageObject=ct;ht.x=hB;ht.y=hz;if(hB+hC>=hw){ht.width=hw-hB;hC=Math.min(hE,hw-hB);hs=true}ht.width=hC;ht.height=hA;var hv=fr.getPixelRangeParameters(hw,hu,hB,hz,hC,hA);ht.url=o.baseURL+hv;if(hs){hs=false;hz+=hE;hB=0;hC=hE;if(hz+hE>hu){hA=Math.min(hE,hu-hz)}}else{hB+=hE}ct.tiles.push(ht)}ct.nTiles=ct.tiles.length;ct.arVisibleTiles=new Array(ct.nTiles);ct.nVisibleTiles=0;ct.nTilesLoading=0;ct.nTilesLoaded=0;ct.nTilesRequested=0;ct.nTileColumns=Math.ceil(hw/hE);ct.nTileRows=Math.ceil(hu/hE);A=true;R(null,ct)}};var eg=function(o){o.bLoading=true;o.img=new Image();o.img.oTile=o;fZ(o.img,o.url,"tile",a8)};var a8=function(){a.removeEvent(this,"load",a8);var hr=this.oTile;hr.bLoading=false;hr.bLoaded=true;var o=hr.FSI_ImageObject;if(o.nTilesLoaded===o.nTiles){o.bComplete=true;o.bFillsViewport=true}if(o.src!==bg){return}hr.alpha=0;hr.fnDraw=gM;o.nTilesLoading--;o.nTilesLoaded++;R(null,o);cr(this);ha();cX(25)};var b9=function(hr,o){return o.distance-hr.distance};var gW=function(){A=false;if(!dl){return}var hx=dl;var hH,hG,hs,o;var hw;if(b4.enabled){fw.setRect(0,0,be.width,be.height);fw.scaleRect(1/b4.scale);fw.offsetRect(-b4.panPos.left/g3,-b4.panPos.top/g3);fw.offsetRect((be.width-fw.width())/2,(be.height-fw.height())/2);dL.copyRect(a3);dL.scaleRect(1/b4.scale);dL.offsetRect(fw.left,fw.top);hw=dL}else{hw=a3}cm(hw);hH=fO.left;hG=fO.top;hs=fO.right;o=fO.bottom;var hD=Math.max(0,Math.floor(hH/fz));var ht=Math.min(hx.nTileColumns-1,Math.floor(hs/fz));var hC=Math.max(0,Math.floor(hG/fz));var hr=Math.min(hx.nTileRows-1,Math.floor(o/fz));var hu=ht-hD+1;var hy=hr-hC+1;var hz=Math.max(0,hy)*hu;if(hx.nFirstTileXLastGetVisible===hD&&hx.nFirstTileYLastGetVisible===hC&&hx.nTilesLastGetVisible===hz){return}hx.nFirstTileXLastGetVisible=hD;hx.nFirstTileYLastGetVisible=hC;hx.nTilesLastGetVisible=hz;var hJ=hx.tiles;var hI=hx.arVisibleTiles;var hA=hC*hx.nTileColumns;var hv=hD;var hB;var hF=hh;for(var hE=0;hE<hz;hE++){hB=hI[hE]=hJ[hA+hv];if(!hF&&hB.alpha!==1){hF=true}if(++hv>ht){hv=hD;hA+=hx.nTileColumns}}hx.nVisibleTiles=hz;hx.bFilesArePreparedForLoading=false;if(hF&&!T){cu.globalAlpha=1;f5()}if(hF){T=hF}cX(50)};var Q=function(){if(gz){clearTimeout(gz);gz=b}};var cX=function(o){if(gz!==b){return}if(!dl||dl.bRequestsComplete){return}gz=setTimeout(gJ,o)};var gJ=function(){Q();E()};var E=function(){if(S){return}var hu=dl;if(hu.nTilesLoading>=eQ){return}var hx,hs,hr,ht,hw;if(!hu.bFilesArePreparedForLoading){hu.bFilesArePreparedForLoading=true;if(!hu.arTilesToLoad||hu.arTilesToLoad.length!=0){hu.arTilesToLoad=[]}hx=hu.arTilesToLoad;var hv=hu.arVisibleTiles;for(ht=0;ht<hu.nVisibleTiles;ht++){if(!hv[ht].bLoaded&&!hv[ht].bLoading){hx.push(hv[ht])}}if(hx.length>1){b4.centerX=fO.left+fO.width()/2;b4.centerY=fO.top+fO.height()/2;for(ht=0;ht<hx.length;ht++){hw=hx[ht];hs=hw.x-b4.centerX+hw.width/2;hr=hw.y-b4.centerY+hw.height/2;hw.distance=Math.abs(hs)+Math.abs(hr)}hx.sort(b9)}}var o=0;hx=hu.arTilesToLoad;while(hu.nTilesLoading<eQ&&hx.length>0){hw=hx.pop();eg(hw);o++;hu.nTilesLoading++}hu.nTilesRequested+=o;if(hu.nTilesRequested==hu.nTiles){hu.bRequestsComplete=true}};var R=function(o,hr){if(hr==b){a.removeEvent(this,"load",R);hr=this.FSI_ImageObject;hr.width=this.width;hr.height=this.height}if(hr.src!=bg){return}cr(this);dl=hr;if(ho){return}if(gp){ha()}};var bi=this.clickMenuButton=function(o){gR.pressMenuButton(o,b,true);gR.releaseMenuButton(o,b,true);gR.clickMenuButton(o,b,true)};this.pressMenuButton=function(o){cS.pressButton(o)};this.releaseMenuButton=function(o){cS.releaseButton(o)};gR.onUserAction=function(){};gR.pressMenuButton=function(hs,o,hu){if(!hu){gR.onUserAction()}if(hs!="ToggleAutoSpin"&&hs!="ToggleFullScreen"){aB()}ew();bQ();var hr,ht;if(hs.indexOf("_")!=-1){hr=hs.split("_");hs=hr[0];ht=hr[1]}switch(hs){case"Reset":bc.resetView();break;case"ZoomOut":case"ZoomIn":ac(hs,150,10);break;case"MouseMode":fc(parseInt(ht));break;case"MaxZoom":fG(b,b,b4.scaleToSourceImage-g3,false,30);break}};var cz=function(hr,o){if(!cS){return false}return cS.enableButton(hr,o)};gR.releaseMenuButton=function(hr,o,hs){if(!hs){gR.onUserAction()}bQ()};gR.clickMenuButton=function(ht,o,hv){var hr,hu;if(typeof(ht)==="string"&&ht.indexOf("_")!==-1){hr=ht.split("_");ht=hr[0];hu=hr[1]}switch(ht){case"ToggleFullScreen":if(a.FullScreen.getEnabled()){a.FullScreen.quit();du()}else{var hs=dD;if(typeof(hs)==="string"){hs=document.getElementById(hs);if(hs==b){hs=ao}}dT=hs;a.FullScreen.start(hs);du()}break;case"HotSpots":dk=cS.getButtonPressed("HotSpots");f2(dk);break;case"ToggleAutoSpin":gC();break}};var ag=function(hr){if(!b4.enabled){return}var o=g3;f4(hr);b4.panPos.left*=g3/o;b4.panPos.top*=g3/o;b2(true)};var fy=function(hr){var o;if(hr==b){hr=bG.cmd;bG.nRepeatCount++}switch(hr){case"ZoomOut":o=(bG.nRepeatCount<1)?1.01:1.035;ag(b4.scale/o);break;case"ZoomIn":o=(bG.nRepeatCount<1)?1.01:1.035;ag(b4.scale*o);break}if(bG.nRepeatCount==1){if(bG.intervalTimeFirst!=bG.intervalTimeRepeat){clearInterval(bG.interval);bG.interval=setInterval(fy,bG.intervalTimeRepeat)}}};var ac=function(hs,o,hr){aO(false);bQ();bG={};bG.bRunning=true;if(o==b){o=500}bG.intervalTimeFirst=o;if(hr==b){bG.intervalTimeRepeat=o}else{bG.intervalTimeRepeat=hr}bG.nRepeatCount=0;bG.cmd=hs;bG.interval=setInterval(fy,bG.intervalTimeFirst);fy(hs)};var bQ=function(){if(!bG.bRunning){return}aO(true);clearInterval(bG.interval);switch(bG.cmd){case"ZoomOut":case"ZoomIn":eS();break}bG={}};var eR=function(o){if(U!=b){if(U.width!=bf.imageWidth){bD()}else{return}}if(fB>0&&e.length==fB){return}bD();aM.abortPurpose("asyncResize");U={};U.width=bf.imageWidth;U.previewImageCanvasWidthBeforeResize=o;U.uniqueInstanceID=am;U.nTimeout=setTimeout(d6,50)};var d6=function(){if(!cn){U.nTimeout=setTimeout(d6,250);return}U.nTimeout=b;U.img=new Image();a.addEvent(U.img,"load",al);a.addEvent(U.img,"error",al);var hs=0;var hr=dm;U.pos=0;U.arIndex=new Array(g2.length);if(hr>=fB){U.arIndex[0]=hr;hs+=1}for(var o=fB;o<e.length;o++){if(o!=dm){U.arIndex[hs++]=o}}al()};var al=function(o){if(o!=b){if(!U||U.uniqueInstanceID!=am){return}a.removeEvent(U.img,"load",al);cr(U.img);e[U.indexCurrent]=U.img;if(U.indexCurrent==dm){aA=b;c2=b;eL=b;bW(U.indexCurrent);ha()}U.img=new Image();a.addEvent(U.img,"load",al)}U.indexCurrent=U.arIndex[U.pos];U.pos++;if(U.pos>g2.length){bD()}else{var hr=bK;bK=aF;bO();U.url=gP(U.indexCurrent-dE).fullURL;bK=hr;bO();U.nTimeout=setTimeout(df,25)}};var df=function(){fZ(U.img,U.url,"asyncResize")};var bD=function(){if(U==b){return}if(U.nTimeout){clearTimeout(U.nTimeout);U.nTimeout=b}a.removeEvent(U.img,"load",al);a.removeEvent(U.img,"error",al);U=b};var cR=function(){du()};var aX=function(){dx.error("ERROR entering FullScreen")};this.setFullScreenElement=function(o){if(ea){du();a.FullScreen.quit()}dD=gi.cfg.fullscreenelement=o};var du=function(o){var hr=a.FullScreen.getEnabled();if(hr&&eK()){return}if(hr==ea){return}if(cS){cS.setButtonPressed("ToggleFullScreen",hr)}cD.runPersistent("onFullScreen",[hr]);ea=hr;a.setCustomEventListenerProperty(gN,"skiptreshold",true);if(m){bc.showAboutWindow()}if(hr==true){a.addClass(dT,"fsi-fullscreen-element")}else{a.removeClass(dT,"fsi-fullscreen-element")}if(!hr){dT=b}if(hr){cC()}else{if(fH.bRestore){f6();if(f3.bEnabledByConfig){setTimeout(fE,0)}}}};this.getInFullScreenMode=function(){return ea};this.getSpinFrames=function(){return eo};this.getImageIsTransparent=function(){return dP};this.getSrcDim=function(){return eU};if(typeof(ek)!=="object"||a.makeBool(ek.autoInit,true)){bc.init(gn,ek)}};a.customTags.register("fsi-viewer",{constructorClass:a.Viewer,viewerCSS:"display:block;width:300px;height:300px;",parameterAliases:{src:"imagesrc"}});a.dispatchEvent("FSIViewerLoaded")}(window.$FSI=window.$FSI||{}));