/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.solr;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.neptunelabs.fsiserver.framework.if.J;
import com.neptunelabs.fsiserver.search.solr.oOOO;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

@Obfuscation
public class SearchDatabaseSolr {
    private final String name;
    private PoolingHttpClientConnectionManager connectionManager;
    private String solrServerURI;
    private String solrCore;
    private int maxConnections;
    static final String CONSTANT_ASSETURLPATH = "asset.fullpath";
    static final String CONSTANT_CONNECTOR = "file.connector";
    static final String CONSTANT_PATH = "file.path";
    static final String CONSTANT_FILENAME = "file.name";
    static final String CONSTANT_FILEPREFIX = "file.prefix";
    static final String CONSTANT_FILESUFFIX = "file.suffix";
    private final Pattern charsetPattern = Pattern.compile("charset=(.+)[; ]*", 2);
    private HttpHost targetHost = null;
    private HttpHost proxy = null;
    private CredentialsProvider proxyProvider = null;
    private CredentialsProvider authenticationProvider = null;
    private AuthCache authenticationCache = null;
    private HttpClientContext localContext = null;
    private volatile boolean initiated;
    CloseableHttpClient httpClient;

    public SearchDatabaseSolr(String string) {
        this.name = string;
    }

    public void init() {
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setMaxTotal(this.maxConnections);
        this.connectionManager.setDefaultMaxPerRoute(this.maxConnections);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (this.proxy != null) {
            httpClientBuilder.setProxy(this.proxy);
        }
        if (this.proxyProvider != null) {
            httpClientBuilder.setDefaultCredentialsProvider(this.proxyProvider);
        }
        httpClientBuilder.setUserAgent(this.name);
        if (this.authenticationCache != null) {
            this.localContext = HttpClientContext.create();
            this.localContext.setAuthCache(this.authenticationCache);
            if (this.authenticationProvider != null) {
                httpClientBuilder.setDefaultCredentialsProvider(this.authenticationProvider);
            }
        }
        this.httpClient = httpClientBuilder.build();
        this.initiated = true;
    }

    public boolean isInitiated() {
        return this.initiated;
    }

    public void setConnection(String string, String string2, int n) throws IllegalArgumentException {
        this.solrServerURI = string.endsWith("/") ? string : string + "/";
        URI uRI = URI.create(string);
        int n2 = uRI.getPort();
        if (n2 <= 0) {
            n2 = 80;
        }
        this.targetHost = new HttpHost(uRI.getHost(), n2, uRI.getScheme());
        this.solrCore = string2;
        this.maxConnections = n;
    }

    public String getSolrServerURI() {
        return this.solrServerURI;
    }

    public String getSolrCore() {
        return this.solrCore;
    }

    public void setProxy(boolean bl, String string, int n, boolean bl2, boolean bl3, String string2, String string3) throws IllegalArgumentException {
        if (!bl) {
            if (n == 0) {
                n = 8080;
            }
            String string4 = bl2 ? "http" : "https";
            this.proxy = new HttpHost(string, n, string4);
            if (bl3) {
                this.proxyProvider = new BasicCredentialsProvider();
                this.proxyProvider.setCredentials(new AuthScope(string, n), (Credentials)new UsernamePasswordCredentials(string2, string3));
            }
        } else {
            this.proxyProvider = null;
        }
    }

    public void setAuthentication(boolean bl, String string, String string2, String string3) throws IllegalArgumentException {
        if (bl) {
            if (string.equalsIgnoreCase("digest")) {
                DigestScheme digestScheme = new DigestScheme();
                this.authenticationCache.put(this.targetHost, (AuthScheme)digestScheme);
            } else {
                BasicScheme basicScheme = new BasicScheme();
                this.authenticationCache.put(this.targetHost, (AuthScheme)basicScheme);
            }
            if (string2 != null && string2.length() > 0) {
                this.authenticationProvider = new BasicCredentialsProvider();
                this.authenticationProvider.setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(string2, string3));
            }
        } else {
            this.authenticationCache = null;
        }
    }

    public void halt() {
        this.initiated = false;
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.connectionManager != null) {
            this.connectionManager.close();
        }
    }

    private URI buildAdminURI(String string) throws URISyntaxException {
        URIBuilder uRIBuilder = new URIBuilder(this.solrServerURI + "admin/" + string);
        URI uRI = uRIBuilder.build();
        return uRI;
    }

    URI buildURI(String string) throws URISyntaxException {
        URIBuilder uRIBuilder = new URIBuilder(this.solrServerURI + this.solrCore + string);
        URI uRI = uRIBuilder.build();
        return uRI;
    }

    /*
     * Exception decompiling
     */
    private oOOO executeAdminRequest(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public oOOO getSystemStatusJSON() {
        return this.executeAdminRequest("system?wt=json");
    }

    public oOOO getCoreStatusJSON() {
        return this.executeAdminRequest("cores?wt=json&action=status&core=" + this.solrCore);
    }

    public Set<String> getCoreAssetList(int n, int n2) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        String string = "q=*:*&sort=asset.fullpath+asc&fl=asset.fullpath&start=" + n + "&rows=" + n2;
        oOOO oOOO2 = this.searchJSON(string);
        if (oOOO2.\u00d300000 == 200) {
            try {
                String string2 = new String(oOOO2.o00000, oOOO2.String);
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(string2);
                JsonNode jsonNode2 = jsonNode.get("response");
                int n3 = n2;
                int n4 = jsonNode2.get("numFound").asInt();
                if (n4 - n < n2) {
                    n3 = n4 - n;
                }
                JsonNode jsonNode3 = jsonNode2.get("docs");
                for (int i = 0; i < n3; ++i) {
                    String string3 = jsonNode3.get(i).get(CONSTANT_ASSETURLPATH).asText();
                    hashSet.add(string3);
                }
            }
            catch (JsonParseException jsonParseException) {
                throw new IOException("Invalid response from Solr Server: " + jsonParseException.getLocalizedMessage());
            }
        } else {
            if (oOOO2.\u00d300000 == 0) {
                throw new IOException("Invalid response from Solr Server: " + oOOO2.\u00d200000);
            }
            throw new IOException("Invalid response from Solr Server: " + oOOO2.\u00d300000);
        }
        return hashSet;
    }

    private Charset getEncodingFromHeaders(Header[] headerArray) {
        String string;
        Matcher matcher;
        Charset charset = J.\u00d500000;
        if (headerArray != null && (matcher = this.charsetPattern.matcher(string = headerArray[0].getValue())).find()) {
            try {
                charset = Charset.forName(matcher.group(1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return charset;
    }

    /*
     * Exception decompiling
     */
    oOOO searchJSON(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

