/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

class BandMergeOpImage
extends PointOpImage {
    ColorModel[] colorModels;

    public BandMergeOpImage(Vector vector, Map map, ImageLayout imageLayout) {
        super(vector, BandMergeOpImage.layoutHelper(vector, imageLayout), map, true);
        this.permitInPlaceOperation();
        int n = vector.size();
        this.colorModels = new ColorModel[n];
        for (int i = 0; i < n; ++i) {
            this.colorModels[i] = ((RenderedImage)vector.get(i)).getColorModel();
        }
    }

    private static int totalNumBands(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            RenderedImage renderedImage = (RenderedImage)vector.get(i);
            if (renderedImage.getColorModel() instanceof IndexColorModel) {
                n += renderedImage.getColorModel().getNumComponents();
                continue;
            }
            n += renderedImage.getSampleModel().getNumBands();
        }
        return n;
    }

    private static ImageLayout layoutHelper(Vector vector, ImageLayout imageLayout) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n = vector.size();
        int n2 = BandMergeOpImage.totalNumBands(vector);
        int n3 = 0;
        RenderedImage renderedImage = (RenderedImage)vector.get(0);
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        for (int i = 0; i < n; ++i) {
            renderedImage = (RenderedImage)vector.get(i);
            rectangle = rectangle.intersection(new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()));
            int n4 = renderedImage.getSampleModel().getTransferType();
            n3 = n4 > n3 ? n4 : n3;
        }
        SampleModel sampleModel = imageLayout2.getSampleModel((RenderedImage)vector.get(0));
        if (sampleModel.getNumBands() < n2) {
            int n5;
            int[] nArray = new int[n2];
            for (n5 = 0; n5 < n2; ++n5) {
                nArray[n5] = n5;
            }
            n5 = sampleModel.getWidth();
            int n6 = sampleModel.getHeight();
            if (imageLayout2.isValid(64)) {
                n5 = imageLayout2.getTileWidth((RenderedImage)vector.get(0));
            }
            if (imageLayout2.isValid(128)) {
                n6 = imageLayout2.getTileHeight((RenderedImage)vector.get(0));
            }
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n3, n5, n6, n2);
            imageLayout2.setSampleModel(sampleModel);
        }
        if ((colorModel = imageLayout2.getColorModel(null)) != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.unsetValid(512);
        }
        return imageLayout2;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = writableRaster.getTransferType();
        switch (n) {
            case 0: {
                this.byteLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 4: {
                this.floatLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 5: {
                this.doubleLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void byteLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        for (n = 0; n < n2; ++n) {
            pixelAccessorArray[n] = new PixelAccessor(rasterArray[n].getSampleModel(), this.colorModels[n]);
            nArray[n] = this.colorModels[n] instanceof IndexColorModel ? this.colorModels[n].getNumComponents() : rasterArray[n].getNumBands();
        }
        n = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        byte[][] byArray = (byte[][])unpackedImageData.data;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            UnpackedImageData unpackedImageData2 = this.colorModels[i] instanceof IndexColorModel ? pixelAccessorArray[i].getComponents(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType()) : pixelAccessorArray[i].getPixels(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType(), false);
            int n5 = unpackedImageData2.pixelStride;
            int n6 = unpackedImageData2.lineStride;
            int n7 = unpackedImageData.pixelStride;
            int n8 = unpackedImageData.lineStride;
            int n9 = rectangle.width;
            for (int j = 0; j < nArray[i] && n4 < n; ++j, ++n4) {
                byte[] byArray2 = byArray[n4];
                byte[][] byArray3 = (byte[][])unpackedImageData2.data;
                byte[] byArray4 = byArray3[j];
                int n10 = unpackedImageData2.bandOffsets[j];
                int n11 = unpackedImageData.bandOffsets[n4];
                int n12 = 0;
                while (n12 < rectangle.height) {
                    int n13 = 0;
                    int n14 = n10;
                    int n15 = n11;
                    while (n13 < n9) {
                        byArray2[n15] = byArray4[n14];
                        ++n13;
                        n14 += n5;
                        n15 += n7;
                    }
                    ++n12;
                    n10 += n6;
                    n11 += n8;
                }
            }
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void shortLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        for (n = 0; n < n2; ++n) {
            pixelAccessorArray[n] = new PixelAccessor(rasterArray[n].getSampleModel(), this.colorModels[n]);
            nArray[n] = this.colorModels[n] instanceof IndexColorModel ? this.colorModels[n].getNumComponents() : rasterArray[n].getNumBands();
        }
        n = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        short[][] sArray = (short[][])unpackedImageData.data;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            UnpackedImageData unpackedImageData2 = this.colorModels[i] instanceof IndexColorModel ? pixelAccessorArray[i].getComponents(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType()) : pixelAccessorArray[i].getPixels(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType(), false);
            int n5 = unpackedImageData2.pixelStride;
            int n6 = unpackedImageData2.lineStride;
            int n7 = unpackedImageData.pixelStride;
            int n8 = unpackedImageData.lineStride;
            int n9 = rectangle.width;
            int n10 = 0;
            while (n10 < nArray[i]) {
                if (n4 < n) {
                    short[][] sArray2 = (short[][])unpackedImageData2.data;
                    int n11 = unpackedImageData2.bandOffsets[n10];
                    int n12 = unpackedImageData.bandOffsets[n4];
                    int n13 = 0;
                    while (n13 < rectangle.height) {
                        int n14 = 0;
                        int n15 = n11;
                        int n16 = n12;
                        while (n14 < n9) {
                            sArray[n4][n16] = sArray2[n10][n15];
                            ++n14;
                            n15 += n5;
                            n16 += n7;
                        }
                        ++n13;
                        n11 += n6;
                        n12 += n8;
                    }
                }
                ++n10;
                ++n4;
            }
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void intLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        for (n = 0; n < n2; ++n) {
            pixelAccessorArray[n] = new PixelAccessor(rasterArray[n].getSampleModel(), this.colorModels[n]);
            nArray[n] = this.colorModels[n] instanceof IndexColorModel ? this.colorModels[n].getNumComponents() : rasterArray[n].getNumBands();
        }
        n = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        int[][] nArray2 = (int[][])unpackedImageData.data;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            UnpackedImageData unpackedImageData2 = this.colorModels[i] instanceof IndexColorModel ? pixelAccessorArray[i].getComponents(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType()) : pixelAccessorArray[i].getPixels(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType(), false);
            int n5 = unpackedImageData2.pixelStride;
            int n6 = unpackedImageData2.lineStride;
            int n7 = unpackedImageData.pixelStride;
            int n8 = unpackedImageData.lineStride;
            int n9 = rectangle.width;
            int n10 = 0;
            while (n10 < nArray[i]) {
                if (n4 < n) {
                    int[][] nArray3 = (int[][])unpackedImageData2.data;
                    int n11 = unpackedImageData2.bandOffsets[n10];
                    int n12 = unpackedImageData.bandOffsets[n4];
                    int n13 = 0;
                    while (n13 < rectangle.height) {
                        int n14 = 0;
                        int n15 = n11;
                        int n16 = n12;
                        while (n14 < n9) {
                            nArray2[n4][n16] = nArray3[n10][n15];
                            ++n14;
                            n15 += n5;
                            n16 += n7;
                        }
                        ++n13;
                        n11 += n6;
                        n12 += n8;
                    }
                }
                ++n10;
                ++n4;
            }
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void floatLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        for (n = 0; n < n2; ++n) {
            pixelAccessorArray[n] = new PixelAccessor(rasterArray[n].getSampleModel(), this.colorModels[n]);
            nArray[n] = this.colorModels[n] instanceof IndexColorModel ? this.colorModels[n].getNumComponents() : rasterArray[n].getNumBands();
        }
        n = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        float[][] fArray = (float[][])unpackedImageData.data;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            UnpackedImageData unpackedImageData2 = this.colorModels[i] instanceof IndexColorModel ? pixelAccessorArray[i].getComponents(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType()) : pixelAccessorArray[i].getPixels(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType(), false);
            int n5 = unpackedImageData2.pixelStride;
            int n6 = unpackedImageData2.lineStride;
            int n7 = unpackedImageData.pixelStride;
            int n8 = unpackedImageData.lineStride;
            int n9 = rectangle.width;
            int n10 = 0;
            while (n10 < nArray[i]) {
                if (n4 < n) {
                    float[][] fArray2 = (float[][])unpackedImageData2.data;
                    int n11 = unpackedImageData2.bandOffsets[n10];
                    int n12 = unpackedImageData.bandOffsets[n4];
                    int n13 = 0;
                    while (n13 < rectangle.height) {
                        int n14 = 0;
                        int n15 = n11;
                        int n16 = n12;
                        while (n14 < n9) {
                            fArray[n4][n16] = fArray2[n10][n15];
                            ++n14;
                            n15 += n5;
                            n16 += n7;
                        }
                        ++n13;
                        n11 += n6;
                        n12 += n8;
                    }
                }
                ++n10;
                ++n4;
            }
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void doubleLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2 = rasterArray.length;
        int[] nArray = new int[n2];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n2];
        for (n = 0; n < n2; ++n) {
            pixelAccessorArray[n] = new PixelAccessor(rasterArray[n].getSampleModel(), this.colorModels[n]);
            nArray[n] = this.colorModels[n] instanceof IndexColorModel ? this.colorModels[n].getNumComponents() : rasterArray[n].getNumBands();
        }
        n = writableRaster.getNumBands();
        int n3 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n3, true);
        double[][] dArray = (double[][])unpackedImageData.data;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            UnpackedImageData unpackedImageData2 = this.colorModels[i] instanceof IndexColorModel ? pixelAccessorArray[i].getComponents(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType()) : pixelAccessorArray[i].getPixels(rasterArray[i], rectangle, rasterArray[i].getSampleModel().getTransferType(), false);
            int n5 = unpackedImageData2.pixelStride;
            int n6 = unpackedImageData2.lineStride;
            int n7 = unpackedImageData.pixelStride;
            int n8 = unpackedImageData.lineStride;
            int n9 = rectangle.width;
            int n10 = 0;
            while (n10 < nArray[i]) {
                if (n4 < n) {
                    double[][] dArray2 = (double[][])unpackedImageData2.data;
                    int n11 = unpackedImageData2.bandOffsets[n10];
                    int n12 = unpackedImageData.bandOffsets[n4];
                    int n13 = 0;
                    while (n13 < rectangle.height) {
                        int n14 = 0;
                        int n15 = n11;
                        int n16 = n12;
                        while (n14 < n9) {
                            dArray[n4][n16] = dArray2[n10][n15];
                            ++n14;
                            n15 += n5;
                            n16 += n7;
                        }
                        ++n13;
                        n11 += n6;
                        n12 += n8;
                    }
                }
                ++n10;
                ++n4;
            }
        }
        pixelAccessor.setPixels(unpackedImageData);
    }
}

