/*!
 * FSI Viewer JS
 * Build: 18.03.23.1
 * 
 * Copyright (c) 2018 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function($FSI,undefined){if($FSI.defined!=undefined){return}$FSI.defined=true;$FSI.bDebugEvents=false;if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing;$FSI.console.info=$FSI.fnDoNothing}else{$FSI.console=console}$FSI.oSupportedViewers={};try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){var itm=obj[o];if(typeof(itm)!="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,o,arOut,strResult,strType,itm;var out="";var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){arOut=[];if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{out+="\r\n"+strTitle+" of "+strVersionString+line}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a==undefined){ar[i].a="void"}args="( "+ar[i].a+" )"}strResult=(ar[i].r==undefined)?"":strReturn+ar[i].r;strType=(ar[i].t==undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]==undefined){nNotAvailable++;itm+=" [x]"}arOut.push(itm)}out+=arOut.join("\r\n");if(nNotAvailable>0){out+="\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options"}$FSI.console.log(out);if(fnGroup!=undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)=="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)=="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!=undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)=="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!=undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var oClassOptions={strVersion:"2018",strBuild:"18.03.23.1"};var classDef=new $FSI.ClassDef($FSI,"FSI Core",oClassOptions);$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t=="boolean"){ret=value}else{if(t=="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof($FSI.iLoaderCSSSkin)!="object"){if(typeof($FSI.LoaderCSSSkin)!="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.setAttribute("x-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!=undefined&&ar.length>0){for(var i=0;i<ar.length;i++){$FSI.deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};$FSI.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors==undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);$FSI.addCSSRule(strSelector,strRule,0)};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.deleteCSSRule=function(selector){var ret=false;if($FSI.oInsertedCSS!=undefined){try{var arDelete=[];var ar=$FSI.oInsertedCSS.sheet.cssRules;for(var i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText==selector){arDelete.push(i)}}if(arDelete.length>0){for(var i=arDelete.length-1;i>-1;i--){$FSI.oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
		 @if (@_jscript_version < 9)
		 el.style.setAttribute('cssText', strStyle);
		 @else @*/
el.setAttribute("style",strStyle);
/*@end
		 @*/
};$FSI.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!=0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWidth=window.innerWidth;$FSI.bElementPosRespectsScroll=true;$FSI.oSupportedEvents={};$FSI.isEventSupported=function(eventName){if($FSI.oSupportedEvents[eventName]!=undefined){return $FSI.oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]=="function"}el=null;$FSI.oSupportedEvents[eventName]=isSupported;return isSupported};var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}$FSI.userAgent=navigator.userAgent.toLowerCase();var uagent=$FSI.userAgent;var result,t,i;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!=-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;$FSI.versionInternetExplorer=0;$FSI.isIETouch=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("chrome")!=-1&&uagent.search("edge")==-1){$FSI.isChrome=true}else{if(uagent.search("safari")!=-1){$FSI.isSafari=true}else{if(uagent.search("firefox")!=-1){$FSI.isFirefox=true}else{if(uagent.search("opera")!=-1){$FSI.isOpera=true}}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)=="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.getCachedScrollBarWidth=function(el,oReg,w){var cst;var cssOverflowY="";try{cst=top.window.getComputedStyle(el);cssOverflowY=cst["overflow-y"]}catch(e){return 0}if(cssOverflowY=="scroll"||el.scrollHeight>top.window.innerHeight){var styleID=el.style.overflowY;styleID="S_"+styleID;if(1==1||oReg[styleID]==undefined){el.style.overflowY="hidden";var w2=$FSI.___elementScaleCheck.offsetWidth;if(w2-w>1){oReg[styleID]=w2-w}}}if(!isNaN(oReg[styleID])){ret=oReg[styleID]}else{ret=-1}return ret};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(nam,unit){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){$FSI.documentScaleMethod="visualViewport API";$FSI.getDocumentScale=function(){return window.visualViewport.scale};return $FSI.getDocumentScale()}if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){$FSI.documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";$FSI.getDocumentScale=function(){if(screen.width!=$FSI.topWindow.outerWidth){return($FSI.topWindow.outerWidth-192)/$FSI.topWindow.innerWidth}return($FSI.topWindow.outerWidth-83)/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth iOS";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180==0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.documentScaleMethod="fallback";$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getVisualViewportSize=function(){var ret={};if(window.visualViewport){ret.width=window.visualViewport.width;ret.height=window.visualViewport.height}else{ret.width=window.innerWidth;ret.height=window.innerHeight}return ret};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){var ret;if($FSI.BrowserSupports.visualViewportAPI()){ret={width:wnd.visualViewport.width,height:wnd.visualViewport.height}}else{ret={width:wnd.innerWidth,height:wnd.innerHeight}}return ret};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneArrayRecursive=function(ar){if(ar==undefined||ar.length==undefined){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=$FSI.cloneValue(ar[i])}return ret};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)=="function"){ret=val}else{if(val!=null&&typeof(val.push)=="function"){ret=$FSI.cloneArrayRecursive(val)}else{ret=$FSI.cloneObject(val)}}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){if(obj==null){return null}var ret={};if(typeof(obj)=="object"&&typeof(obj.push)=="function"){ret=$FSI.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.replaceChild=function(parent,existingChild,newChild){try{var elNext=existingChild.nextSibling;if(elNext){parent.removeChild(existingChild);parent.insertBefore(newChild,elNext)}else{parent.appendChild(newChild)}}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(existingChild);$FSI.console.log(newChild)}};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.callbackFunctionID=0;$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])=="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)=="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var t="/"+strScriptName;var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!="object"){if(typeof($FSI.LoaderJavascript)!="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)=="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!="string"){return false}var t=typeof(parameters);if(t!="object"&&t!="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)=="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!="string"||strClass.length<1){return}if(typeof(strRule)!="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.hasClass=function(el,strClass){if(typeof(strClass)!="string"){return false}strClass=$FSI.trim(strClass);if(strClass.length<1){return false}var str=el.className;if(typeof(str)!="string"||str.length<1){return false}strClass=strClass.replace(/\s+/," ");var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");return(str.match(regex)!=null)};$FSI.urlDecode=function(str){if(!str){return str}var ret=str.replace($FSI.regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.regExEffects=/((\?)|&)effects=([^&]*)/ig;$FSI.regExPadEffect=/[=,]+Pad\([^)]*/ig;$FSI.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match($FSI.regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match($FSI.regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=scale.y=targetDimension.width/(sourceDimension.width*range.width)}else{scale.x=scale.y=targetDimension.height/(sourceDimension.height*range.height)}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)=="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.visualViewportAPI=function(){var res=false;try{if(typeof(window.visualViewport)!="undefined"){res=true}}catch(e){}$FSI.BrowserSupports.visualViewportAPI=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)=="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)=="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret]}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!=b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=console||{};var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!=b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m==b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m==b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(e){if(k.readyState!=4){return}delete c[n];if(m==b||this.FSIaborted){return}var r=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,r,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CanvasProgressBar!=b){return}a.CanvasProgressBar=function(s,m,j,d,q,e){var r=this;if(!e){e={}}if(typeof(e.border)!="string"){e.frame="#58a8ff"}if(typeof(e.color)!="string"){e.color="#58a8ff"}if(typeof(e.background)!="string"){e.background="rgba(255,255,255,0.5)"}if(typeof(e.text)!="string"){e.text="#FFFFFF"}var p=m;var o=j;var g=q;var l=d;var h=0;var k=(q>10&&d>40);this.draw=function(t){var u=l/100*t;i(p,o,l,g,h);c(p,o,u,g,h,l);if(k){f(p,o,u,g,h,l)}};this.setCtx=function(t){s=t};this.setPos=function(t,u){p=t;o=u};var i=function(v,z,w,u,t){s.save();s.fillStyle=e.border;n(v-1,z-1,w+2,1,t);n(v-1,z+u,w+2,1,t);n(v-1,z-1,1,u+2,t);n(v+w,z-1,1,u+2,t);s.fillStyle=e.background;n(v,z,w,u,t);s.restore()};var c=function(w,A,z,v,u,t){s.fillStyle=e.color;n(w,A,z,v,u)};var n=function(v,z,w,u,t){s.fillRect(v,z,w,u)};var f=function(B,z,t,D,w,A){s.save();s.font="10px Arial";s.textAlign="start";s.textBaseline="alphabetic";s.fillStyle=e.text;var C=Math.floor(t/A*100)+"%";var u=s.measureText(C).width;var v=B+t-u-w/2-4;if(t<=w+u){v=B+w/2}s.fillText(C,v,z+D/2+3.25);s.restore()}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!=b){return}a.Config=function(Z,z,g){if(typeof(g)!=="object"){g={}}if(!z||typeof(z)!=="object"){z={}}var p=this;this.parameters=(Z&&typeof(Z)==="object")?Z:{};this.queryParameters=b;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():b}catch(ab){}this.plugins={};this.arPlugins=[];this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=[];this.arConditions=[];this.locales={};this.locales.tips={};var R=false;this.strListFilePrefix="";this.strListFileSuffix="";var J={};var B=0;var t;var V={};var d="FSI> ";var E=p.debug=new a.EmptyDebugger();var C=false;var A={};var af=false;var M={stickynotes:"bookmarks"};var h;var Q=false;var v;var G;var W;var c;var o;var x="token";var y;this.strConfigFileExtension=".xml";p.strTemplateSuffix=".json";var r;var i=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){r=function(ag){var e;if(!a.isCrossDomain(ag)){af=false;e=new XMLHttpRequest()}else{af=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){r=function(){return new XMLHttpRequest()}}}if(!r){try{i=new ActiveXObject("Msxml2.XMLHTTP");r=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(ab){try{i=new ActiveXObject("Microsoft.XMLHTTP");r=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(ab){i=null;r=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters={};this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(ai){p.reset();v=(typeof(g.strSection)==="string")?g.strSection:"";G=v.toLowerCase();if(typeof(g.strTraceParam)==="string"){var ag=g.strTraceParam.toLowerCase();c={};c[ag]=true;if(ag.indexOf("_")>0&&ag.indexOf("pages")===0){ag=ag.split("_");ag.shift();ag=ag.join("_");c[ag]=true}var ah=p.getParameterAlias(ag);if(ah){c[ah]=true}}else{c=false}if(ai){if(p.parameters){p.parameters=a.mergeObjects(p.parameters,ai)}else{p.parameters=ai}}Y(p.parameters);p.getQueryParameters();p.cloneParameters(p.cfgDefaults,p.cfg);p.cloneParameters(p.queryParameters,p.cfg);p.elevateToHTTPS();f();p.BaseURL=p.getBaseURL();if(p.bForceVersion5==true){}var e=p.queryParameters.fsiviewerversion;if(p.bForceVersion5==true){e="5"}if(e!=b){if(parseInt(e)<6){p.strConfigFileExtension=".fsi"}}var aj=p.queryParameters.fsiserverversion;if(p.bForceVersion5==true){aj="2"}if(aj!=b){if(parseInt(aj)<3){p.strTemplateSuffix="_json"}}p.locationFSIViewer="";if(p.queryParameters.fsiviewerlocation!=b){p.locationFSIViewer=p.queryParameters.fsiviewerlocation}else{if(a!=b&&a._FSIViewerLocation!=b){E.log("FSI Viewer location guessed based on script location: "+a._FSIViewerLocation);p.locationFSIViewer=a._FSIViewerLocation}else{p.locationFSIViewer=p.BaseURL.split("/");if(p.locationFSIViewer.length>4){p.locationFSIViewer.splice(p.locationFSIViewer.length-3,2);p.locationFSIViewer=p.locationFSIViewer.join("/")}}}if(p.locationFSIViewer.charAt(p.locationFSIViewer.length-1)!="/"){p.locationFSIViewer+="/"}p.nextConfigURL=p.getReloadPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.defaultcfg));p.checkDebug(false)};var Y=this.makeObjectPropertiesLowerCase=function(e){for(var ag in e){var ah=ag.toLowerCase();if(ag!=ah){if(e[ah]==b){e[ah]=e[ag]}delete e[ag]}}};this.getClassParameters=function(){return W};this.setAccessToken=function(e){y=e};this.getParameterAlias=function(ah){var e;if(p.cfgAliasNames[ah]){e=p.cfgAliasNames[ah]}else{for(var ag in p.cfgAliasNames){if(p.cfgAliasNames[ag]===ah){e=ag;break}}}return e};var f=function(){R=p.makeBool(p.cfg.usenc,false);if(p.cfg.usencquery!=b&&p.cfg.usencquery.length>0){C=p.cfg.usencquery;R=true;p.queryToObject("?"+C,A)}};this.stopPendingRequests=function(){for(var ag in J){var e=J[ag];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){p.stopPendingRequests()};this.getBaseURL=function(){var ah;var ag=document.getElementsByTagName("base");if(ag&&ag.length>0){ah=ag[ag.length-1].href;if(ah&&ah.charAt(ah.length-1)!="/"){ah+="/"}}else{ah=document.location.href;var e=ah.indexOf("?");if(e!=-1){ah=ah.slice(0,e)}e=ah.indexOf("#");if(e!=-1){ah=ah.substring(0,e)}e=ah.lastIndexOf("/");if(e!=-1){ah=ah.slice(0,e+1)}}return ah};this.reset=function(){W={};p.parameters={};E=p.debug=new a.EmptyDebugger();p.stopPendingRequests();t=Math.random();p.nIncludedConfigs=0;p.completedConfigs={};p.plugins={};p.cfg={};p.queryParameters=b;p.arUnrecognizedConfigNodes=[];aa=0;p.arConditions=[];V={}};this.getQueryParameters=function(){if(p.queryParameters!=b){return}p.queryParameters={};p.cloneParameters(p.parameters,p.queryParameters)};this.makeBool=function(ai,e){if(typeof(e)!="boolean"){e=false}var ag=e;switch(typeof(ai)){case"string":var ah=a.makeBool(ai);if(ah!=b){ag=ah}break;case"number":ag=Boolean(ai);break;case"boolean":ag=ai;break}return ag};this.parsePositionParameter=function(ag){if(typeof(ag)!="string"||ag.length<3){return b}ag=ag.split(",");if(ag.length<3){return b}for(var e=0;e<3;e++){ag[e]=parseFloat(ag[e]);if(isNaN(ag[e])){ag[e]=0}}return{x:ag[0],y:ag[1],z:ag[2]}};this.logLoadFileFailed=function(e){if(!E.on){return}if(e&&e.status!=b){var ah="HTTP "+e.status;if(e&&e.statusText){ah+=", "+e.statusText}var ag=(e._url)?e._url:"";E.error("Failed to load "+ag+" ("+ah+")")}else{E.error("Failed loading a file");if(e&&e._url){E.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(aj){if(!aj||!aj.firstChild){return false}var e=aj.firstChild.childNodes;var ak,ah,ai;for(var ag=0;ag<e.length;ag++){ah=e[ag];ak=p.getAttributeValue(ah,"id");if(ak==b){continue}ak=ak.toLowerCase();if(ah.childNodes.length>0){ai=p.XMLChildNodesToString(ah)}else{ai=p.getAttributeValue(ah,"txt")}p.locales.tips[ak]=ai}return true};this.getAttributeValue=function(ag,e){if(!ag){return}return ag.getAttribute(e)};this.onLanguageLoaded=function(ag,e){E.log("Language loaded");if(ag){p.parseLanguage(e.responseXML)}if(z.onConfigReady){z.onConfigReady()}};this.onConfigReadyDone=function(){if(!p.readCustomPageNumbers()){p.loadImageList()}};this.swapParameters=function(ah,e){ah=ah.toLowerCase();e=e.toLowerCase();var ag=p.plugins.pages.parameters;if(ag==b){return}p.swapValues(ag,ah,e);p.swapValues(p.cfg,"pages_"+ah,"pages_"+e)};this.swapValues=function(ai,ah,ag){var e=ai[ah];ai[ah]=ai[ag];ai[ag]=e};this.getTranslation=function(ag){var e=p.locales.tips[ag.toLowerCase()];if(e==b){e=ag}return e};this.getImageURL=function(ah,e){if(ah==b){return""}if(e===b){e={}}if(e.type===b){e.type="image"}if(e.renderer===b){e.renderer="jpeg"}if(y){e[x]=y}e.source=ah;for(var ag in V){if(V[ag]!==b&&e[ag]===b){e[ag]=V[ag]}}for(var ag in T){if(e[ag]){if(T[ag]!==ag){if(!e[T[ag]]){e[T[ag]]=e[ag]}e[ag]=null}}}return p.requestBase+"?"+p.objectToQuery(e)};this.getImageInfoURL=function(ag,e){if(ag==b){return""}if(e==b){e={}}if(e.type==b){e.type="info"}if(e.tpl==b){if(p.cfg.fpxinfotemplate!=b){e.tpl=p.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(p.cfg.headers&&p.cfg.headers.length>0){e.headers=p.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=ag;if(y){e[x]=y}return p.requestBase+"?"+p.objectToQuery(e)};this.queryToObject=function(aj,ah){if(ah==b){ah={}}var ai,al,ak,e,ag;ai=aj.indexOf("?");if(ai!=-1){ag=aj.slice(ai+1)}else{ag=""}ai=ag.indexOf("#");if(ai!=-1){ag=ag.substring(0,ai)}ag=ag.split("&");for(ai=0;ai<ag.length;ai++){al=ag[ai].split("=");ak=a.urlDecode(al[0]).toLowerCase();if(ak.length>0){e=a.urlDecode(al[1]);ah[ak]=e}}return ah};this.parseSceneSets=function(e,aj){var aq={};if(aj==b){aj=true}var aw=[];var au=0;var ar=0;var ah;var al,ak,ai,ap,an,av;var am,ao,at;var ag=p.cfg.scenesets;if(e>1&&ag!=b&&typeof(ag)=="string"){ao=ag.split(";");for(al=0;al<ao.length;al++){at=[];am=ao[al].split(",");ar=0;for(ak=0;ak<am.length;ak++){av=am[ak].split("-");ap=an=0;if(av.length==1){ap=parseInt(av[0])}else{ap=parseInt(av[0]);if(isNaN(ap)){ap=1}ah=false;if(av[1].charAt(0)==">"){av[1]=av[1].substr(1);if(!isNaN(parseInt(av[1]))){ah=true}}an=parseInt(av[1]);if(isNaN(an)){an=e}if(ap>0&&an>0&&ap<=e&&an<=e){if(ah==true||ap!=an){if(ah!=true){if(an<ap){for(ai=ap;ai>=an;ai--){at[ar]=ai;ar++}}else{for(ai=ap;ai<=an;ai++){at[ar]=ai;ar++}}}else{for(ai=ap;ai<=e;ai++){at[ar]=ai;ar++}for(ai=1;ai<=an;ai++){at[ar]=ai;ar++}}}}}if(ap>0&&ap<=e&&(an==0||an==ap)){at[ar]=ap;ar++}}if(ar>0){aw[au]={};aw[au].arScenes=[];aw[au].arScenes=aw[au].arScenes.concat(at);au++}}}if(au==0){aq.bDefault=true;if(aj){aw[0]={};aw[0].arScenes=[];for(al=0;al<e;al++){aw[0][al]=al}}}aq.nSceneSets=au;aq.bHasMultipleSets=(aq.nSceneSets>1);aq.arSets=aw;aq.nCurrent=1;return aq};this.objectToQuery=function(ag){var e=[];var ai,ah;if(R&&C!==false){for(ai in A){ag[ai]=A[ai]}}for(ai in ag){ah=ag[ai];if(ah!==null){ah=encodeURIComponent(ah);e.push(encodeURIComponent(ai)+"="+ah)}}return e.join("&")};this.loadConfigs=function(){W=(v.length>0)?{}:false;h=true;p.loadNextConfig(true)};this.loadImageInfo=function(ai,e,ah){var ag=p.getImageInfoURL(ai);p.loadFile(ag,e,b,ah)};this.loadFile=function(aj,ai,ah,an,am,ag,ak){if(!aj||aj.length<0){if(ai){ai(this,"",an)}return}if(am==b){am="GET"}if(ag==b){ag=null}else{if(typeof(ag)=="object"){ag=p.objectToQuery(ag)}}if(ah==b){ah="application/json"}var al=r(aj);if(!al){return}if(ah&&al.overrideMimeType){al.overrideMimeType(ah)}al._url=aj;var e=B;J[B]=al;B++;if(af){al.onerror=function(){delete J[e];if(ai==b||this.FSIaborted){return}p.logLoadFileFailed(this)};al.onload=function(){delete J[e];if(ai==b||this.FSIaborted){return}var ao=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var ap=new ActiveXObject("Microsoft.XMLDOM");ap.async=false;ap.loadXML(ao);ao=this.responseXML=ap}catch(aq){E.log("Failed parsing XML using Microsoft.XMLDOM");E.log(aj)}break;case"application/json":ao={};try{ao=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ao=this.responseText}ai(this,ao,an)}}else{al.onreadystatechange=function(ao){var ap;if(al.readyState!=4){return}delete J[e];if(ai==b||this.FSIaborted){return}if(this.status>299){p.logLoadFileFailed(this)}switch(ah){case"application/xml":case"text/xml":ap=this.responseXML;break;case"application/json":ap={};try{ap=a.JSON.parse(this.responseText)}catch(aq){E.error("Failed parsing JSON from URL: "+aj+" ("+aq.message+")")}break;default:ap=this.responseText}ai(this,ap,an)}}al.open(am,aj,true);if(ak&&y){al.setRequestHeader("x-token",y)}al.send(ag);return al};this.onConfigXMLLoaded=function(e,ag){p.logXMLResponseOK(e.response);p.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(ag){if(p.nextConfigURL==b){p.finalCheck();return}var ah={};if(g.bPreventCaching||p.makeBool(p.cfg.debug)||(!ag&&!p.makeBool(p.cfg.configcaching,true)&&p.makeBool(p.cfg.enableconfigcachingparameter))){p.addNoCacheParams(ah)}p.finishRequestParams(ah);var e=p.addURLParameters(p.nextConfigURL,ah);E.log("Loading config file: "+e);p.loadFile(e,p.onConfigXMLLoaded,"application/xml")};this.parseFloatPercentDef=function(ai,ah,ag,e){if(ai==b||ai.length<1){return ag}return Math.max(e,p.parseFloatPercent(ai,ah))};this.parsePercentDef=function(ah,e){if(ah==b||ah.length<1){return e}var ag=parseFloat(ah);if(isNaN(ag)){ag=0}else{if(ah.indexOf("%")!=-1){ag/=100}}return ag};this.parseFloatPercent=function(ah,ag){var e=parseFloat(ah);if(isNaN(e)||e<0){e=0}else{if(ah.indexOf("%")!=-1){e=Math.round(e*ag/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){d=e+"> "};this.setDebugger=function(e){E=p.debug=e};this.checkDebug=function(ah){if(g.bNoDebug){return}var ag;var e;if(p.parameters.debug!=b){e=p.makeBool(p.parameters.debug)}else{e=p.makeBool(p.cfg.debug)}if(e){if(!E||!E.on){E=p.debug=new a.Debugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}else{if(!E||E.on===true){E=p.debug=new a.EmptyDebugger();if(z.onDebuggerChange){ag=z.onDebuggerChange(E,ah)}}}return ag};this.onConfigLoaded=function(ag){o=p.nextConfigURL;p.parseConfig(ag);o=b;p.elevateToHTTPS();if(p.checkDebug(true)==true){return}f();if(h&&g.bCaptureDefaultCfg){h=false;p.cfgFromDefaultConfig=a.cloneValue(p.cfg)}var e;if(p.cfg.includeconfig!=b&&p.nIncludedConfigs<10){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.includeconfig));p.nIncludedConfigs++;p.cfg["_includeconfig("+p.nIncludedConfigs+")"]=p.cfg.includeconfig;p.cfg.includeconfig=b}else{if(p.cfg.cfg!=b){e=p.getFSIPath(p.locationFSIViewer,p.expandFSIPath(p.cfg.cfg))}}if(e!=b&&!p.completedConfigs[e]){p.completedConfigs[e]=true;p.nextConfigURL=e;p.loadNextConfig()}else{p.evaluateQuery(p.queryParameters,p.cfg);p.finalCheck()}};this.elevateToHTTPS=function(){if(!a.bHTTPS){return}if(!p.makeBool(p.cfg.autoelevatetohttps,true)){return}k("fpxbase");k("fpxserver")};var k=function(e){if(p.cfg[e]!=b&&p.cfg[e].length>0&&p.cfg[e].indexOf("http://")==0){p.cfg[e]="https"+p.cfg[e].substr(4)}};this.evaluateQuery=function(ag,e){for(var ah in ag){p.setConfigParamByValue(e,ah.toLowerCase(),ag[ah])}};this.parseConfig=function(ag,ah){var aq="";var ak;var am=false;if(ag!=b){if(ah===b){ah=ag.firstChild}if(ah&&ah.nodeName=="xml"){ah=ah.nextSibling}var ap=ah.childNodes;for(var al=0;al<ap.length;al++){var aj=ap[al];if(aj.nodeType!=1){continue}var an;if(aj._myTagName!==b){an=aj._myTagName}else{an=aj.nodeName.toLowerCase()}aq=an;var ai=aj.childNodes;am=false;switch(an){case"licence":break;case"if":p.arConditions.push(aj);break;case"plugins":for(ak=0;ak<ai.length;ak++){p.parsePluginNode(ai[ak])}break;case G:am=true;case"info":case"options":aq=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ak=0;ak<ai.length;ak++){var ao=ai[ak];if(ao.nodeType!=1){continue}if(ao.tagName==="if"){ao._myTagName=an;p.arConditions.push(ao)}else{var e=p.getValueFromXMLNode(ao,aq);if(aq===b&&W){if(am){p.setConfigParam(W,e,null,true);p.setConfigParam(p.cfg,e,ao)}else{if(W[e.name]===b){p.setConfigParam(p.cfg,e,ao)}}}else{p.setConfigParam(p.cfg,e,ao)}}}break;default:p.arUnrecognizedConfigNodes.push(aj)}}}};this.getData=function(){var e={};e.cfg={};for(var ag in p.cfg){e.cfg[ag]=p.cfg[ag]}return e};this.setData=function(e){if(!e||!e.cfg){return}p.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var ag in e){p.cfg[ag]=e[ag]}P()};this.getImagesNodeList=function(ah){var e=[];if(ah==b){ah=p.getUnrecognizedConfigNode("images")}if(ah){var ai=ah.firstChild;while(ai){if(ai.nodeType==1){var ag={};ag.attributes={};I(ai,ag.attributes);ag.cfg={};p.parseConfigFragment(ai,ag.cfg);e.push(ag)}ai=ai.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){p.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(ai){var e;ai=ai.toLowerCase();for(var ag=p.arUnrecognizedConfigNodes.length-1;ag>-1;ag--){var ah=p.arUnrecognizedConfigNodes[ag];if(ah&&ah.nodeName.toLowerCase()==ai){e=ah;break}}return e};this.parseConfigFragment=function(ag,am,al){var aq="";if(ag!=b&&am!=b){if(al==b){al=[]}var ap=ag.childNodes;for(var ak=0;ak<ap.length;ak++){var ai=ap[ak];if(ai.nodeType!=1){continue}var an=ai.nodeName.toLowerCase();aq=an;var ah=ai.childNodes;switch(an){case"info":case"options":aq=b;case"fpx":case"image":case"include":for(var aj=0;aj<ah.length;aj++){var ao=ah[aj];if(ao.nodeType!=1){continue}var e=p.getValueFromXMLNode(ao,aq);p.setConfigParam(am,e,ao)}break;default:al.push(ai)}}}};this.findXMLNode=function(ag,e){if(ag==b||ag.nodeType==b){return b}while(ag){if(ag.nodeName.toLowerCase()==e){break}if(ag.firstChild!=b){ag=ag.firstChild}else{if(ag.nextSibling!=b){ag=ag.nextSibling}else{ag=ag.parentNode.nextSibling}}}return ag};this.getValueFromXMLNode=function(ah,e){if(!ah||ah.nodeType!=1){return}var ag={};var ai=(e)?e:"";ag.name=ai+ah.nodeName.toLowerCase();var aj=ah.getAttribute("value");if(aj){ag.value=aj;return ag}ag.value=p.XMLChildNodesToString(ah);ag.node=ah;return ag};this.getXMLNodeAttribute=function(ai,ah,e){if(!ai||ai.nodeType!=1||!ai.getAttribute){return e}var ag=ai.getAttribute(ah);if(ag==b||ag==null){ag=e}return ag};this.XMLChildNodesToString=function(ag){if(!ag||!ag.firstChild){return""}var e="";if(ag.childNodes.length==1&&ag.firstChild.nodeType==3){e=ag.firstChild.nodeValue}else{e=p._XMLChildNodesToString(ag)}return e};this.hasPlugin=function(e){return(p.plugins&&p.plugins[e]!=b)};this.getPluginParameter=function(al,ag,e,ak,am){al=al.toLowerCase();ag=ag.toLowerCase();if(p.plugins[al]==b){E.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+al+"."+ag);return e}var aj;var ai=al+"_"+ag;if(am&&p.cfg[ai]==b){ai=ag}if(p.cfg[ai]!=b){aj=p.cfg[ai]}else{if(W&&W[ag]!==b&&G==="pages"){aj=W[ag]}else{var ah=p.plugins[al].parameters;if(ah!=b&&ah[ag]!=b){aj=ah[ag]}}}if(aj==b){aj=e}if(ak){aj=p.makeBool(aj,e)}return aj};var L=this.getAllPluginParameters=function(ag){ag=ag.toLowerCase();var ah=a.cloneObject(p.plugins[ag].parameters);var aj=ag+"_";var e=aj.length;for(var ak in p.cfg){if(ak.toLowerCase().indexOf(aj)==0){var ai=ak.substr(e);ah[ai]=p.cfg[ak]}}return ah};this.getIntParameterMinMax=function(ag,ah,e,ai){return Math.min(ai,Math.max(e,p.getIntParameter(ag,ah)))};this.getIntParameter=function(ag,ah){var e=parseInt(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getStringParameter=function(ag,ah){var e=p.cfg[ag.toLowerCase()];if(e==b){e=ah}return e};this.getFloatParameter=function(ag,ah){var e=parseFloat(p.cfg[ag.toLowerCase()]);if(isNaN(e)){e=ah}return e};this.getRGBAValue=function(ag){var e={};if(ag==b){ag=""}if(ag.charAt(0)=="#"){ag=ag.substr(1)}if(ag.length>8){ag=ag.substr(0,8)}if(ag.length>5){e.webColor="#"+ag.substr(0,6);e.red=parseInt(ag.substr(0,2),16);e.green=parseInt(ag.substr(2,2),16);e.blue=parseInt(ag.substr(4,2),16);if(ag.length<7){e.alpha=255}else{e.alpha=parseInt(ag.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};var I=function(ak,ag){if(!ak||!ak.attributes||!ak.attributes.length||!ag){return false}var ah=ak.attributes;for(var aj=0;aj<ah.length;aj++){var e=ah[aj];var ai=e.nodeName.toLowerCase();ag[ai]=e.value}return true};this.parsePluginNode=function(ah){if(ah.nodeType!=1){return}var aj={};I(ah,aj);var ai=ah.childNodes;for(var e=0;e<ai.length;e++){var ak=ai[e];if(ak.nodeType!=1){continue}var ag=p.getValueFromXMLNode(ak);if(ag.value!=b){aj[ag.name]=ag.value;if(ag.node!=b){aj[ag.name+".node"]=ag.node}}}this.addPluginFromString(aj.src,aj)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.clone=function(){var e=new a.Config(Z,z,g);e.init();e.cfg=a.cloneObject(p.cfg);e.plugins=a.cloneObject(p.plugins);e.arPlugins=a.cloneArray(e.arPlugins);e.arUnrecognizedConfigNodes=a.cloneArray(e.arUnrecognizedConfigNodes);e.setImageQueryParameters(V);e.locales=a.cloneObject(p.locales);e.arConditions=a.cloneArray(p.arConditions);e.hasImageParameterConditions=p.hasImageParameterConditions;return e};this.setImageQueryParameters=function(e){V=a.cloneObject(e)};this.addPluginsFromString=function(ah){if(ah==b||ah.split==b||ah.length<1){return}var e=ah.split(",");for(var ag=0;ag<e.length;ag++){var ai=p.trimString(e[ag]);p.addPluginFromString(ai)}};this.addPluginFromString=function(ai,aj){if(ai==b||ai.length<1){E.error("PLUGIN without src parameter:");return}ai=ai.toLowerCase();if(M[ai]!=b){ai=M[ai]}if(aj==b){aj={}}var ag=p.plugins[ai]={};ag.name=ai;if(aj.src===b){aj.src=ai}if(p.pluginDefaultParameters[ai]!=b){ag.parameters={};p.cloneParameters(p.pluginDefaultParameters[ai],ag.parameters);p.cloneParameters(aj,ag.parameters)}else{ag.parameters=aj}if(c){for(var ak in c){if(ak.indexOf(ai+"_")===0){var ah=ai+"_";var e=ak.substr(ah.length);if(typeof(ag.parameters[e])!=="undefined"){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log(ag.parameters[e]);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}else{if(ak===ai){p.iTraceParameterDebug.group(o);p.iTraceParameterDebug.log('<Plugin src="'+ai+'">');p.iTraceParameterDebug.log("(enabled)");p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}};this.setConfigParamByValue=function(ag,ah,e){p.setConfigParam(ag,{name:ah.toLowerCase(),value:e})};var O=function(ag){if(ag.nodeType!==1){return"<unknown>"}var e=p.XMLSerializer.serializeToString(ag.cloneNode(false));e=e.replace(/\/>$/gi,">");return e};this.setConfigParam=function(ai,e,aj,ak){var am=e.name;var ao=e.value;if(am==b){return}if(c){for(var an in c){if(an===am&&!ak){if(typeof(aj)==="object"&&typeof(aj.tagName)==="string"){var al;if(o){al=o}var ah=aj.parentNode;var ag=[];while(ah){if(ah.tagName==="if"){al="Matched Condition"}ag.unshift(O(ah));ah=ah.parentNode}ag.shift();ag.shift();p.iTraceParameterDebug.group(al);p.iTraceParameterDebug.log(ag.join(" "));p.iTraceParameterDebug.log(aj);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}else{p.iTraceParameterDebug.group("By Parameter/Attribute:");p.iTraceParameterDebug.log(ao);p.iTraceParameterDebug.log("");p.iTraceParameterDebug.groupEnd()}}}}if(p.cfgAliasNames[am]!=b){am=p.cfgAliasNames[am]}if(ai[am]!=b&&(typeof(ao)=="string"&&a.BoolTable[ao.toLowerCase()]==false)&&a.BoolTable[ai[am]]==b){delete ai[am]}else{switch(am){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(ai[am]!=b&&ai[am].length>0&&ai[am].indexOf(ao)==-1){ai[am]+=","+ao}else{ai[am]=ao}break;case"plugins":p.addPluginsFromString(ao);break;case"fpxpath":ai[am]=ao;ai.fpxsrc=encodeURIComponent(ao);break;default:ai[am]=ao;if(e.node!=b){ai[am+".node"]=e.node}}}};var n={};n["="]=function(ag,e){return(ag.toLowerCase()==e.toLowerCase())};n["=="]=function(ag,e){return(ag==e)};n["!="]=function(ag,e){return(ag.toLowerCase()!=e.toLowerCase())};n["!=="]=function(ag,e){return(ag!=e)};n["<"]=function(ag,e){return(ag<e)};n["<="]=function(ag,e){return(ag<=e)};n[">"]=function(ag,e){return(ag>e)};n[">="]=function(ag,e){return(ag>=e)};n.match=function(ah,ag){var ai=false;var ak="g";if(ag.charAt(0)==="/"&&ag.lastIndexOf("/")>0){var aj=ag.split("/");aj.shift();ak=aj.pop();ag=aj.join("/")}try{var al=new RegExp(ag,ak);ai=(ah.match(al)!==null)}catch(am){E.error("Invalid regex in condition: "+ag)}return ai};n.notmatch=function(ag,e){return !n.match(ag,e)};var u={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var w=function(ag,ah){if(p.cfgAliasNames[ah]){ah=p.cfgAliasNames[ah]}var e=p.cfg[ah];if(e==b){e=""}if(!p.hasImageParameterConditions){p.hasImageParameterConditions=(T[ah]!==b)}return D(ag,ah,e)};var H=function(ai,aj){var e=false;var ah;var ag=ai.getAttribute("value");switch(aj){case"@mobile":ag=p.makeBool(ag,true);ah=a.isMobileDevice;break;case"@devicepixelratio":ah=a.getDevicePixelRatio();break;case"@navigatoruseragent":ah=navigator.userAgent;break;case"@navigatorlanguage":ah=navigator.language;break;case"@navigatorplatform":ah=navigator.platform;break}if(ah!==b){if(typeof(ag)!=="string"){ag=""+ag}if(typeof(ah)!=="string"){ah=""+ah}e=D(ai,aj,ah,ag)}return e};var D=function(ai,ah,ak,aj){var am;var ag=ai.getAttribute("operator");if(typeof(ag)!=="string"){ag="="}ag=ag.toLowerCase();if(u[ag]){ag=u[ag]}if(n[ag]===b){ag="="}if(aj===b){aj=ai.getAttribute("value")}if(aj===null){aj=""}var e=n[ag];if(ag.match(/[<,>]+/)){var an=function(ao){ao=parseFloat(ao);if(isNaN(ao)){am=false}return ao};ak=an(ak);aj=an(aj)}else{ak=decodeURIComponent(ak)}if(am===b){am=e(ak,aj)}if(E.on){E.log("Evaluating condition: "+ah+": "+ak+" "+ag+" "+aj+" => "+am)}if(am===true){if(ai._myTagName!==b){var al={};al.nodeType=1;al.tagName=ai._myTagName;al.childNodes=[ai];ai=al}p.parseConfig(ai,ai)}return am};var T={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var U={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi"};var S;var N=function(){if(S===b){S={};for(var e in T){S[T[e]]=e}}return S};var s=function(aj,ai,ah){if(ah===b){ah=""}var al=ah+"left";if(aj[al]===b){return}var ak=ah+"top";var ag=ah+"right";var e=ah+"bottom";if(ai==="pixelrange"){aj[ag]=aj[ag]-aj[al];aj[e]=aj[e]-aj[ak]}aj[ai]=aj[al]+","+aj[ak]+","+aj[ag]+","+aj[e];if(aj[al]){delete aj[al]}if(aj[ak]){delete aj[ak]}if(aj[ag]){delete aj[ag]}if(aj[e]){delete aj[e]}};var ad=this.mapImageParametersToViewer=function(e){s(e,"rect");s(e,"pixelrange","pixel");var ag=N();e=X(e,N())};var ac=this.mapImageParametersToServer=function(e){X(e,T)};var X=function(ag,e){for(var ah in ag){if(e[ah]&&ah!==e[ah]){ag[e[ah]]=ag[ah];delete ag[ah]}}};this.reWriteImageURLByConditions=function(am){if(p.arConditions.length<1){return am}if(typeof(am)!=="string"||am.length<1){return am}var ah=am.indexOf("?");if(ah===-1){return am}var ag=p.clone();var aj={};p.parseQuery(am,aj);ad(aj);p.evaluateQuery(aj,ag.cfg);var e=ag.evaluateConditions();if(!e){return am}var al;for(al in aj){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}for(al in U){if(ag.cfg[al]!==b){aj[al]=decodeURIComponent(ag.cfg[al])}}ac(aj);var ai=am.substr(0,ah);var ak=ai+"?"+p.objectToQuery(aj);return ak};var q=this.applyConditions=function(){if(p.arConditions.length<1){return}if(p.cfgBeforeConditions===b){p.cfgBeforeConditions=a.cloneObject(p.cfg)}p.cfg=p.cfgBeforeConditions;return j()};var aa=0;var j=this.evaluateConditions=function(){if(p.arConditions.length<1){return false}var ag=false;for(var ah=aa;ah<p.arConditions.length;ah++){var ai=p.arConditions[ah];if(ai.fsiConfigEvaluated){continue}aa++;var aj=ai.getAttribute("parameter");if(typeof(aj)==="string"){aj=aj.toLowerCase();var e;if(aj.charAt(0)==="@"){e=H(ai,aj)}else{e=w(ai,aj)}if(!ag&&e){ag=e}}}return ag};var P=function(){q();p.serverProfile=p.cfg.fpxservertemplate;p.serverProfileDoublePage=p.cfg.fpxservertemplatedoublepage;if(p.serverProfileDoublePage==b){p.serverProfileDoublePage="doublepage"}p.serverBase=p.cfg.fpxserver;if(p.serverBase==b){E.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+p.locationFSIViewer+")");var ag;ag=p.locationFSIViewer.indexOf("/users/");if(ag!=-1){p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}else{ag=p.locationFSIViewer.indexOf("/viewer/");p.serverBase=p.locationFSIViewer.substring(0,ag)+"/server"}E.log("Derived server location is: ["+p.serverBase+"]")}p.requestBase=p.serverBase;V={};var e=p.cfg;for(var ah in U){if(e[ah]!==b){V[ah]=e[ah]}}if(V.fpxsrc!==b){V.fpxsrc=decodeURIComponent(V.fpxsrc)}e=p.cfg.effects;if(e!=b){p.cfg.effectsUnFiltered=e;p.cfg.effects=e=m(e)}if(e!=b){V.effects=e}e=p.cfg.lefteffects;if(e!=b){V.lefteffects=e}e=p.cfg.righteffects;if(e!=b){V.righteffects=e}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){p.setEffectsFilter(p.getAreaEffects())};this.setEffectsFilter=function(ai){if(typeof(ai)!=="string"||ai.length<1){Q=false;return}ai=a.trim(ai);var ag=ai.split(",");for(var ah=0;ah<ag.length;ah++){ag[ah]=a.escapeRegEx(ag[ah])}var e="(^|[=,]+)("+ag.join("|")+")\\([^)]*\\)";Q=new RegExp(e,"ig")};var m=function(e){if(Q===false){return e}return e.replace(Q,"")};var l=function(){for(var ag in p.plugins){var ah=ag.toLowerCase();var e=p.makeBool(p.cfg[ah],true);if(!e){p.plugins[ag]=b}}};this.finalCheck=function(){p.elevateToHTTPS();l();P();p.dumpConfig();if(z.onConfigsReady){z.onConfigsReady()}};this.dumpConfig=function(ah){if(!ah){ah=E}if(ah.on){if(p.cfg.fpxsrc!==b){p.cfg["fpxsrc (decoded)"]=decodeURIComponent(p.cfg.fpxsrc)}ah.info("Evaluated Configuration:",K(p.cfg));if(p.queryParameters){ah.info("Parameters:",K(p.queryParameters))}if(W){ah.info("Class <"+v+"> Configuration:",K(W))}var ag=p.getPluginsAndParameters();var e=ag.data;if(ag.count===0){e="No active plugins."}ah.info("Plugin Configuration:",K(e))}};var K=function(ah){var e="--- none ---";if(typeof(ah)!=="object"){return e}for(var ag in ah){e=ah;break}return e};this.getPluginsAndParameters=function(){var e={};var ah=0;for(var ag in p.plugins){if(p.hasPlugin(ag)){e[ag]=L(ag);ah++}}return{count:ah,data:e}};var F=this.addQueryParameterToURL=function(ai,e,ah){var ag=ai.lastIndexOf("?");if(ag===-1){ai+="?"}else{if(ag!==ai.length-1){ai+="&"}}return ai+encodeURIComponent(e)+"="+encodeURIComponent(ah)};var ae=p.finishURL=function(e){if(y){e=F(e,x,y)}if(!R||e==b){return e}var ag;if(C===false){ag="cache=0&cachernd="+t;if(e.indexOf("?")==-1){e+="?"+ag}else{e+="&"+ag}}else{ag=C;if(e.indexOf("?")==-1){e+="?"+ag}else{e+=ag}}return e};this.addURLParameters=function(ag,ah){if(!ag||!ah){return ag}var e=[];for(var ai in ah){e.push(encodeURIComponent(ai)+"="+encodeURIComponent(ah[ai]))}if(e.length>0){if(ag.indexOf("?")==-1){ag+="?"}else{ag+="&"}ag+=e.join("&")}return ag};this.finishRequestParams=function(ag){if(R){if(C===false){ag.cache=0;ag.cachernd=t}else{for(var e in A){ag[e]=A[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=t};this.parseQuery=function(ag,e){if(e==b||ag==b||ag.length<1){return}p.queryToObject(ag,e);if(e.ignorequeryparameters!=b){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=b){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,ag){if(e==b||ag==b){E.error("Cloning object failed: "+e+" / "+ag)}for(var ah in e){ag[ah]=e[ah]}};this.getFSIPath=function(e,ag){if(ag.indexOf("//")!=-1){return ag}if(p.cfg.fsibase!=b){ag=p.cfg.fsibase+ag}return p.getReloadPath(e,ag)};this.expandFSIPath=function(ag){if(ag==b){return ag}var e=a.urlDecode(ag);if(e.indexOf("?")!=-1||e.indexOf(p.strConfigFileExtension)==(e.length-4)){return ag}return ag+p.strConfigFileExtension};this.getReloadPath=function(ai,ak){var ag,al,e,aj;if(ai==b){ai=p.locationFSIViewer}if(ak==b){ak=""}var ah="/";if(ak.indexOf("//")!=-1){return ak}ag=ai;aj=ag.lastIndexOf("?");if(aj==-1){aj=ag.length}al=ag.lastIndexOf("\\",aj);e=ag.lastIndexOf("/",aj);al=Math.max(al,e);if(al==-1){al=ag.length-1}ag=ag.slice(0,al);if(ag.length>0&&ak.indexOf(ah)!=0){ag+=ah}return ag+ak};this.cloneValueObject=function(ag){var e={};for(var ah in ag){e[ah]=ag[ah]}return e};this._getXMLConfigValue=function(e){var ag;if(!e){return}if(e.childNodes.length>0){ag=p._XMLChildNodesToString(e)}else{ag=e.getAttribute("value")}return ag};this._XMLChildNodesToString=function(ai){if(!ai||!ai.firstChild){return""}var ag="";var ah;try{if(ai.xml!=b){for(ah=0;ah<ai.childNodes.length;ah++){ag+=ai.childNodes[ah].xml}}else{for(ah=0;ah<ai.childNodes.length;ah++){ag+=p.XMLSerializer.serializeToString(ai.childNodes[ah])}}}catch(aj){}return ag};this._findFirstXMLNode=function(ah,ai){var ag,e;while(ah){if(ah.nodeName==ai){e=ah;break}ag=ah.firstChild;if(!ag){ag=ah.nextSibling}if(!ag&&ah.parentNode){ag=ah.parentNode.nextSibling}ah=ag}return e};this._parseXMLImageList=function(ag){var e=p._findFirstXMLNode(ag,"images");if(!e){e=p._findFirstXMLNode(ag,"images3d")}return p.parseXMLImageListNode(e)};this._parseXMLImageListNode=function(aj){var am={};var e=am.arImages=[];var ai="";var ak="";var ah;if(!aj){return am}var ag;ag=p.getAttributeValue(aj,"prefix");if(typeof(ag)=="string"){ai=ag}ag=p.getAttributeValue(aj,"suffix");if(typeof(ag)=="string"){ak=ag}aj=p._findFirstXMLNode(aj,"image");if(!aj){return am}while(aj){if(aj.nodeType==1){ah=p._findFirstXMLNode(aj,"path");var al=p._getXMLConfigValue(ah);if(!al){al=a.urlDecode(p.getAttributeValue(aj,"src"))}if(!al){al=a.urlDecode(p.getAttributeValue(aj,"file"))}if(al!=b){e.push(ai+al+ak)}if(am.width==b){ah=p._findFirstXMLNode(aj,"width");ah=p._getXMLConfigValue(ah);if(ah!=b){am.width=parseInt(ah)}ah=p._findFirstXMLNode(aj,"height");ah=p._getXMLConfigValue(ah);if(ah!=b){am.height=parseInt(ah)}}}aj=aj.nextSibling}return am};this.getImageList=function(){var e,ai;if(p.cfg&&p.cfg.fpxsources!=b){var ah=p.cfg.fpxsources;if(typeof(ah)=="string"||(typeof(ah)=="object")&&typeof(ah.push)=="function"){e={};e.oXML=null;if(typeof(ah)=="string"){e.arImages=ah.split(",");for(ai=0;ai<e.arImages.length;ai++){e.arImages[ai]=a.urlDecode(e.arImages[ai])}}else{e.arImages=ah}return e}}if(p.arUnrecognizedConfigNodes&&p.arUnrecognizedConfigNodes.length>0){var ag=p.arUnrecognizedConfigNodes;for(ai=0;ai<ag.length;ai++){var aj=ag[ai];if(typeof(aj.nodeName)=="string"){var ak=aj.nodeName.toLowerCase();if(ak=="images"||ak=="images3d"){if(E.on){E.log("Reading image list from XML node: <"+aj.nodeName+">")}e=p._parseXMLImageListNode(aj);e.oXML=aj;break}}}}if(p.cfg&&p.cfg.fpxsrc!=b){e={};e.oXML=null;e.arImages=[];e.arImages.push(a.urlDecode(p.cfg.fpxsrc));return e}return e};this.getServerBase=function(){return p.serverBase};this.loadImageList=function(ai,aj,al,ak){if(!p.serverBase||!ai){aj([],b,ak);return false}var ah=p.serverBase+"?type=list";if(ai.indexOf("tpl")==-1){var ag=p.cfg.listtemplate;if(ag&&ag.length>0&&ag.indexOf(".json")==-1&&ag.indexOf(".xml")==-1){ag+=".json"}ah+="&tpl="+ag}if(p.cfg.headers&&p.cfg.headers.length>0&&A.headers==b){ah+="&headers="+p.cfg.headers}ah+="&source="+encodeURIComponent(ai);if(al!=b){ah+=al}ah=ae(ah);var e=p.loadFile(ah,function(am,ap){if(typeof(ap)=="object"&&typeof(ap.images)=="object"){ap.images.pop();var aq="";if(ap&&ap.imagesattributes&&ap.imagesattributes.dir){aq=ap.imagesattributes.dir}var an=new Array(ap.images.length);for(var ao=0;ao<ap.images.length;ao++){an[ao]=aq+ap.images[ao].src}aj(an,ap,ak)}else{aj([],ap,ak)}},"application/json",ak);return e};this.traceConfigValue=function(e,ai){if(typeof(e)!=="string"){return false}e=a.trim(e);if(e.length<1){return false}var ag=e.toLowerCase();if(ag.indexOf(".")!==-1){ag=ag.split(".").join("")}if(ag.indexOf("/")!==-1){ag=ag.split("/").join("")}if(ag.indexOf(" ")!==-1){ag=ag.split(" ").join("")}var ah=new a.Debugger();ah.setPrefix("");ah.group('Tracing parameter "'+e+'"');var aj=function(){var ak=e;var ap=p.getParameterAlias(ag);if(typeof(ap)==="string"){ak+=" (alias: "+ap+")";if(typeof(p.cfgAliasNames[ag])==="string"){ag=p.cfgAliasNames[ag]}}var al=p.cfg[ag];var ao=true;if(ag.indexOf("_")!==-1){var an=ag.split("_");var am=an.shift();var aq=an.join("_");if(p.hasPlugin(am)){al=p.getPluginParameter(am,aq)}}else{if(p.hasPlugin(ag)){ao=false;al="is enabled."}}if(al===b){ao=false;al="is undefined (default value applies)"}if(ao){al='= "'+al+'"'}ah.group("RESULT:");ah.log(ak+" "+al);ah.groupEnd();ah.groupEnd()};z={onConfigsReady:aj};g.strTraceParam=ag;g.bNoDebug=true;p.iTraceParameterDebug=ah;p.init(ai);p.loadConfigs();return""};this.loadLanguageFile=function(e,aq,aj,ah){var ak=arguments;var al,ao;if(typeof(aq)!=="string"||p.makeBool(aq,true)==false){return aj.call(p,{},"")}var ap=function(ar){try{a.oLanguageMap=JSON.parse(ar.responseText)}catch(at){a.oLanguageMap={"default":"english"}}p.loadLanguageFile.apply(this,ak)};var am=function(ar,av){e.urlLanguageCurrentLoaded=al;var au=e.oLanguageData={};if(av){var at=p.findXMLNode(av,"data");if(at){at=p.findXMLNode(at,"tip")}while(at){if(at.nodeType===1){var aw=at.getAttribute("id");au[aw]=p.XMLChildNodesToString(at)}at=at.nextSibling}}aj.call(p,e.oLanguageData,ao)};if(aq.toLowerCase()==="auto"){if(!a.oLanguageMap){p.loadFile(a._FSIViewerLocation+"/languages/mapping.json",ap,"application/json");return}if(a.oLanguageMap._current!==b){aq=a.oLanguageMap._current}else{aq=a.oLanguageMap["default"];var ai=navigator.language;if(typeof(ai)==="string"){ai=ai.toLowerCase()}if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}else{if(ai.indexOf("-")!=-1){ai=ai.split("-")[0];if(a.oLanguageMap[ai]!=b){aq=a.oLanguageMap[ai]}}}}if(aq==b){return aj.call(p,{},"")}if(ah){ah.log('Automatically choosing language "'+aq+'" from navigator.language "'+navigator.language+'"')}a.oLanguageMap._current=aq}var an=aq+".xml";var ag=a._FSIViewerLocation+"/languages/"+an;if(ag!==e.urlLanguageCurrentLoaded){ao=aq;al=ag;if(ah){ah.log("Loading language file: "+ag)}p.loadFile(ag,am,"application/xml")}else{aj.call(p,e.oLanguageData,ao)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!=b){return}a.Callbacks=function(o,g,d){if(g==b){g={cfg:{}}}if(typeof(d)!="object"){d={}}var p=this;var f={};var n={};var l=0;var k={count:0};var e=new a.EmptyDebugger();var j={};this.destroy=function(){if(e.on){this.removeConfigListeners();if(k.count>0){e.error("WARNING: "+k.count+" listener(s) have not been removed:");for(var q in k){if(q!="count"){e.error("- "+q+" ("+k[q].count+" listener)")}}}}};this.removeConfigListeners=function(){for(var q in n){var r=n[q];if(r!==false){i(r.evt,r.fn)}}n={}};this.setDebug=function(q){e=q};this.setConfig=function(q){p.removeConfigListeners();g=q};var m=function(s){if(n[s]!=b){return f[s]}var r=false;var q=s.toLowerCase();if(typeof(g.cfg[q])=="string"&&typeof(window[g.cfg[q]])=="function"){r=window[g.cfg[q]]}else{if(typeof(g.cfg[q])=="function"){r=g.cfg[q]}}if(r!=false&&c(s,r,o)){n[s]={evt:s,fn:r}}else{n[s]=false}return f[s]};var c=this.addListener=function(s,q,r){if(typeof(q)!="function"){e.error("Failed to add listener for "+s+". The function argument is not a function.");return false}if(r==b){r=o}if(q.__FSICallbackFunctionID==b){q.__FSICallbackFunctionID=a.callbackFunctionID++}if(k[s]==b){k[s]={count:0}}if(k[s][q.__FSICallbackFunctionID]==b){k[s][q.__FSICallbackFunctionID]=[]}k.count++;k[s].count++;k[s][q.__FSICallbackFunctionID].push(l);if(e.on){var w=k[s][q.__FSICallbackFunctionID].length;if(w>1){var v="";try{v=" "+q.name+"()"}catch(t){}e.error(w+" listeners for "+s+" have been added for the same function"+v+". Did you forget to remove a listener?")}if(k[s].count>20){e.error(w+" listeners for "+s+" have been added for this instance. Did you forget to remove a listener?")}}var u=f[s];if(u==b){u=f[s]={};u.reg={};u.nam=s}u.reg[l]={fn:q,scope:r};u.bNeedsArrayRebuild=true;if(typeof(d[s])=="function"){u.handleCallbackResult=d[s]}if(j[s]!==b){q.apply(r,j[s][0])}l++;return true};var i=this.removeListener=function(s,r){if(k[s]==b||typeof(r)!="function"||r.__FSICallbackFunctionID==b){e.error("Unable to remove listener: no callback for "+s+" registered");return false}var q=k[s][r.__FSICallbackFunctionID];if(q==b){if(e.on){var w="this function";try{w="the function "+r.name}catch(t){}e.error("Unable to remove listener: no callback for "+s+" registered for "+w)}return false}var v=q.pop();k.count--;k[s].count--;if(q.length==0){k[s][r.__FSICallbackFunctionID]=b;delete k[s][r.__FSICallbackFunctionID]}if(k[s].count<1){k[s]=b;delete k[s]}var u=f[s];if(u!=b){u.bNeedsArrayRebuild=true;u.reg[v]=b;delete u.reg[v]}return true};var h=function(q){q.ar=[];for(var r in q.reg){if(typeof(q.reg[r].fn)=="function"){q.ar.push(q.reg[r])}}q.bNeedsArrayRebuild=false};this.isset=function(q){return(m(q)!=b)};this.runPersistent=function(r,q){j[r]=[q];p.run(r,q)};this.run=function(v,s){var r;var x=m(v);if(x!==b){if(x.bNeedsArrayRebuild){h(x)}var q=x.ar;for(var u=0;u<q.length;u++){var w=q[u];var t=w.fn.apply(w.scope,s);if(t!=b){r=t;if(x.handleCallbackResult){r=x.handleCallbackResult(r,s)}}}}return r}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!=b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.scaleRect=function(h){if(h==1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h==1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left==h.left&&e.top==h.top&&e.right==h.right&&e.bottom==h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!=b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!=b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!=b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!=0||u!=0||v!=0||q!=0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!=-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!=-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!=b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!=b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRectByRefWidth=function(q){};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r==b&&u==b){r=i.width();u=i.height();A=1}else{if(r!=b){A=i.width()/r;if(u==b){u=i.height()/A}}else{A=i.height()/u;if(r==b){r=i.width()/A}}}if(z==b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left==0&&v.top==0&&v.width()==v._refWidth&&v.height()==v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left==0&&r.top==0&&r.width()==r._refWidth&&r.height()==r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,A){var B=new a.CroppedImage();var C,v;if(typeof(y)!="string"||y.length!=2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var z=p.isCropped();var q,D;var x,E;if(z){x=(1-h.left-h.right);E=(1-h.top-h.bottom);q=Math.round(x*c.width);D=Math.round(E*c.height)}else{q=c.width;D=c.height}if(u/q<s/D){v=s;C=Math.round(q/D*s);t=C-u;switch(y.charAt(1)){case"l":r.setRect(0,0,C-t,v);break;case"r":r.setRect(t,0,C,v);break;default:r.setRect(t/2,0,C-t/2,v)}}else{C=u;v=Math.round(D/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,C,v-t);break;case"b":r.setRect(0,t,C,v);break;default:r.setRect(0,t/2,C,v-t/2)}}r.scaleRectXY(1/C,1/v);if(p.isCropped()){C/=x;v/=E;if(A){C=Math.min(C,c.width);v=Math.min(v,c.height)}B.setSourceDimension(C,v);r.scaleRectXY(x,E);r.offsetRect(h.left,h.top)}else{if(A){C=Math.min(C,c.width);v=Math.min(v,c.height)}B.setSourceDimension(C,v)}B.widthUncropped=C;B.heightUncropped=v;B.setCropRect(r.left,r.top,r.right,r.bottom);return B}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomSkinClass!==b){return}a.CustomSkinClass=function(h,l,e,i){var p=this;var k;var n;var f;var j;var m=e.getCallbacks();var c=this.paramCustomSkinClass=l;var o=function(){k=e.getRootContainer();n=e.getParentElement();p.destroy();if(typeof(l)==="string"){if(l.match(/\.js$/)){var q=a._FSIViewerLocation+"/"+l;a.loadJavascript(q,e.getInstanceID(),p,d)}else{if(typeof(window[l])==="function"){j=new window[l](h,n,g)}}}else{if(typeof(l)==="function"){j=new l(h,n,g)}}};var g=function(r){f=r;if(r&&typeof(r)==="object"&&r.tagName){r.appendChild(k)}if(m.isset("onResize")){var q=e.getElementSpace();m.run("onResize",[q.width,q.height,true,e.getIsFullScreen()])}if(h.onResize){h.onResize({FSI_after_treshold:true})}i.apply(h)};var d=function(){c=c.replace(/\.js$/,"");var q=c.lastIndexOf("/");if(q!==1){c=c.substr(q+1)}if(c.length>0&&typeof(window[c])==="function"){j=new window[c](h,n,g)}else{g()}};this.getCustomSkinInstance=function(){return j};this.destroy=function(){if(j&&typeof(j.destroy)==="function"){j.destroy(p);j=b}if(f!==b){f=b;while(n.firstChild){n.removeChild(n.firstChild)}n.appendChild(k)}};o()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Sprite!=b){return}a.Sprite=function(k,i,t,o,s,m,f){var n=this;var c=0.075;var d;var e=true;var u;var j;var v=1;var l=n.margin={left:0,top:0,right:0,bottom:0};var r={};r.width=i;r.height=t;var p=(s)?"canvas":"div";d=n.element=document.createElement(p);d.setAttribute("draggable","false");if(f){d.className=f}var g="";switch(m){case"inline":break;default:g+="position:absolute;z-index:"+o}a.setStyleAttr(d,g);if(s){n.canvas=n.element;n.canvas.setAttribute("crossorigin","anonymous");n.canvas.setAttribute("width",r.width);n.canvas.setAttribute("height",r.height);n.ctx=n.canvas.getContext("2d")}if(k){k.appendChild(d)}this.remove=function(){if(k){a.removeChild(k,d)}};this.setPos=function(h,w){n.x=h;n.y=w;d.style.marginLeft=h+"px";d.style.marginTop=w+"px"};this.isVisible=function(){return(v>0)};this.show=function(h,w){if(e==h){return}e=h;if(j!=b){cancelAnimationFrame(j);j=b}if(!w){v=d.style.opacity=(h)?1:0;d.style.display=(h)?"block":"none"}else{u=(h)?c:-c;if(h){d.style.display="block"}q()}};this.updateMargins=function(){l=n.margin=a.getElementMargins(d)};this.getClientDim=function(){return a.getElementClientDim(n.element)};this.updateDimension=function(){r=a.getElementClientDim(d)};this.width=function(){return r.width};this.height=function(){return r.height};var q=function(){v+=u;if(u>0){if(v>=1){v=1;j=b}else{j=requestAnimationFrame(q)}}else{if(v<=0){v=0;j=b;d.style.display="none"}else{j=requestAnimationFrame(q)}}d.style.opacity=v};if(!s){this.setSize=function(x,y){r.width=x;r.height=y;if(typeof(x)!="string"){x+="px"}if(typeof(y)!="string"){y+="px"}n.element.style.width=x;n.element.style.height=y};this.clear=function(){}}else{this.setSize=function(x,y){r.width=x;r.height=y;n.canvas.width=x;n.canvas.height=y};this.clear=function(){n.ctx.clearRect(0,0,r.width,r.height)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ToolTip!=b){return}a.ToolTip=function(c){var q=this;var n;var h;var d;var m,l;var j;var k=false;var e={};var g=false;var i;var p=function(){n=document.createElement("div");a.addClass(n,"fsi-ui-tool-tip-container fsi-ui-tool-tip-container-hidden");h=document.createElement("div");a.addClass(h,"fsi-ui-tool-tip");n.appendChild(h);d=document.createElement("div");a.addClass(d,"fsi-ui-tool-tip-arrow");n.appendChild(d)};this.destroy=function(){q.hide();clearTimeout(j)};this.setContent=function(r){i=r};this.show=function(t,s,r,w,v,u){if(!i){return}e.strTip=t;e.elSrc=s;e.x=r;e.y=w;e.fnGetToolTipText=v;if(l!=b){clearTimeout(l);l=b}if(m!=b){clearTimeout(m)}if(u==b){u=(k)?100:1000}m=setTimeout(f,u)};var f=function(){if(m!=b){clearTimeout(m);m=b}var w=e.strTip;var C,D;if(e.fnGetToolTipText!=b){D=e.fnGetToolTipText(w,i);if(D==b){D=i[w]}}else{D=i[w]}if(D!=b){w=D}else{w="<b>"+w+"</b>"}h.innerHTML=w;c.appendChild(n);d.style.left="0px";n.style.display="inline-block";n.style.width=c.offsetWidth+"px";C=a.getElementClientPos(h);n.style.display="block";n.style.width=C.width+"px";var G=e.x;if(G==b){G=0}var F=e.y;if(F==b){F=0}if(e.elSrc!=b){var u=a.getElementClientPos(c);var v=a.getElementClientPos(e.elSrc);G+=v.left-u.left+(v.right-v.left)/2;F+=v.top-u.top}C=a.getElementClientPos(n);G-=C.width/2;F-=C.height+2;var t=document.body;var z=4;var E=G;var s=t.clientWidth;if(a.isMobileDevice){s=Math.max(t.clientWidth,u.width+u.left)}G=Math.min(s-u.left-C.width-z,Math.max(-u.left+z,G));var B=E-G;var r=d.offsetWidth/2;if(B!=0){var A=Math.min(n.offsetWidth/2-r,Math.abs(B));if(B<0){B=-A}else{B=A}}d.style.left=(n.offsetWidth/2-r+B)+"px";n.style.left=G+"px";n.style.top=F+"px";g=true;k=true;clearTimeout(j);j=setTimeout(o,1000);a.removeClass(n,"fsi-ui-tool-tip-container-hidden");a.addClass(n,"fsi-ui-tool-tip-container-visible")};var o=function(){k=false};this.hideAfter=function(r){if(r==b||isNaN(r)||r<1){r=2500}if(l!=b){clearTimeout(l);l=b}l=setTimeout(q.hide,r)};this.hide=function(){if(m!=b){clearTimeout(m);m=b}if(l!=b){clearTimeout(l);l=b}if(g){a.removeClass(n,"fsi-ui-tool-tip-container-visible");a.addClass(n,"fsi-ui-tool-tip-container-hidden");a.removeChild(c,n);g=false}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FullScreen!=b){return}a.FullScreen={};a.FullScreen.__initDone=false;a.FullScreen.__init=function(){var d=a.FullScreen;if(d.__initDone){return}d.__initDone=true;var c=0;if(document.webkitExitFullscreen){c=3}else{if(document.msExitFullscreen){c=1}else{if(document.mozCancelFullScreen){c=2}else{if(document.exitFullscreen){c=0}}}}switch(c){case 1:d.requestFullscreen="msRequestFullscreen";d.exitFullscreen="msExitFullscreen";d.fullscreenPseudoClass=":-ms-fullscreen";d.fullscreenChange="MSFullscreenChange";d.fullscreenError="MSFullscreenError";d.fullScreen="msFullscreenElement";d.fullscreenElement="msFullscreenElement";break;case 2:d.requestFullscreen="mozRequestFullScreen";d.exitFullscreen="mozCancelFullScreen";d.fullscreenPseudoClass=":-moz-full-screen";d.fullscreenChange="mozfullscreenchange";d.fullscreenError="mozfullscreenerror";d.fullScreen="mozFullScreen";d.fullscreenElement="mozFullScreenElement";break;case 3:d.requestFullscreen="webkitRequestFullscreen";d.exitFullscreen="webkitExitFullscreen";d.fullscreenPseudoClass=":-webkit-full-screen";d.fullscreenChange="webkitfullscreenchange";d.fullscreenError="webkitfullscreenerror";d.fullScreen="webkitIsFullScreen";d.fullscreenElement="webkitFullscreenElement";break;default:d.requestFullscreen="requestFullscreen";d.exitFullscreen="exitFullscreen";d.fullscreenPseudoClass=":fullscreen";d.fullscreenChange="fullscreenChange";d.fullscreenError="fullscreenError";d.fullScreen="fullScreen";d.fullscreenElement="fullscreenElement"}d.nMode=c};a.FullScreen.start=function(c){a.FullScreen.__init();a.FullScreen.quit();c[a.FullScreen.requestFullscreen]()};a.FullScreen.quit=function(){a.FullScreen.__init();document[a.FullScreen.exitFullscreen]()};a.FullScreen.toggle=function(c){if(a.FullScreen.getEnabled()){a.FullScreen.quit()}else{a.FullScreen.start(c)}};a.FullScreen.getFullscreenPseudoClass=function(){a.FullScreen.__init();return a.FullScreen.fullscreenPseudoClass};a.FullScreen.addChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)=="function"){a.addEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)=="function"){a.addEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.removeChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)=="function"){a.removeEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)=="function"){a.removeEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.getAvailable=function(d){a.FullScreen.__init();var c=d[a.FullScreen.requestFullscreen];return(c)};a.FullScreen.getEnabled=function(){a.FullScreen.__init();var c=a.FullScreen.getElement();return(c!=b)};a.FullScreen.getElement=function(){a.FullScreen.__init();return document[a.FullScreen.fullscreenElement]}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!=b){return}a.Easing={easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f==0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f==g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f==0){return e}if(f==g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g==b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!=b){return}a.TouchHandler=function(n,aY,am,e,aO){var aF=this;var aM=false;var al=true;var p=false;var aU=false;var aL=false;var aC,F,j,ae;var aD,Z,aJ;var h=false;var af;var s;var a1={};var ar=[];var ad=0;var J=window;var aW;var t;var aV;var d;var a0=[];var aS={x:0,y:0};var w={x:0,y:0};var at=40;var o={};o.enabled=false;o.factor=5;o.fEndDiff=1;var az={};az.enabled=false;az.minFrames=14;az.factorAmount=23;az.factorAmountQuad=0;az.factorFrames=2.6;az.offsetFrames=5;var ac;var aA;var aI,x,l;var G;var au={};var Y;var aN=false;var A=false;var an={};an.name="none";var O;var X;var aP;var f=false;var aa={};if(!aY||typeof(aY)!="object"){aY={}}var ao=function(){var a7;if(aM){aF.destroy()}aV=B;t=b;if(a.topWindow!=window){t=a.topWindow;try{var a6=a.getWindowOffset(window);if(a6.x!=b&&a6.y!=b){aV=aq}}catch(a5){aV=B;t=b}}else{t=b}G=aY.oPassTrough;aX(aY.panDirectionAllowed,true);if(aY.getPageCoords){s=aG}else{s=N}if(aY.afterTouch){for(a7 in aY.afterTouch){az[a7]=aY.afterTouch[a7]}}if(az.minDelta==b){az.minDelta=15}if(aY.nClickRadius){ac=aY.nClickRadius}else{ac=10}if(az.fnStartStopAfterTouch&&typeof(az.fnStartStopAfterTouch)!="function"){az.fnStartStopAfterTouch=b}if(az.fnStartStopAfterTouch){az.useAnimationFrame=b}if(typeof(az.modifyTarget)!="function"){az.modifyTarget=b}if(typeof(az.fnGetAfterTouchEnabled)=="function"){aA=az.fnGetAfterTouchEnabled}else{aA=b}if(aY.smoothing){for(a7 in aY.smoothing){o[a7]=aY.smoothing[a7]}}if(aY.detectClick==true){Y=true}if(aY.preventSelection!==false){aY.preventSelection=true}if(!n){return}if(typeof(n.join)!="function"){n=[n]}if(typeof(am)!="function"){am=B}if(typeof(e)!="function"){e=B}if(typeof(aO)!="function"){aO=B}if(typeof(aY.onPinchChange)=="function"){O=aY.onPinchChange}else{O=b}aN=aY.detectGestures;a0=[];ay(true,aN);for(var a4=0;a4<n.length;a4++){var a3=n[a4];if(a3&&typeof(a3.nodeName)!="undefined"){a7={};a7.element=a3;a0.push(a7);ap(a3,S);if(a.isTouch){try{if(a3.style!=b){if(a.BrowserSupports.cssTouchAction()){if(au.cssTouchAction!=b){r(a3,au.cssTouchAction)}}}}catch(a5){}}}}if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aE,false)}};var aX=this.setAllowedPanDirection=function(a4,a3){if(typeof(a4)=="string"){if(a4=="pan-x"||a4=="pan-y"||a4=="pan-x pan-y"){aW=a4+" "}else{aW=""}}else{aW=""}if(!a3){au.nCheck=b;ai(au.captureScroll,au.capturePinch)}};this.enable=function(a3){if(al==a3){return}if(!a3){R();ai(false,false)}else{ai(au.captureScrollUser,au.capturePinchUser)}al=a3};this.getEnabled=function(){return al};this.cancel=function(){Q();ah();aK();R()};var aK=function(){if(o.enabled){i()}C()};this.cancelAfterTouch=function(){C()};this.getInitialDownEvent=function(){return X};var R=function(){if(!p){return}aK();p=false;X=b;A=false;if(ad==0){aQ()}};var aQ=function(){f=false;c()};this.destroy=function(){if(a.mobileOS=="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aE,false)}if(aP){clearTimeout(aP)}aF.cancel();var a3;for(var a4=0;a4<a0.length;a4++){var a5=a0[a4];a3=a5.element;y(a3,S)}au={}};var r=function(a3,a4){if(!a.BrowserSupports.cssTouchAction()||!a3||!a3.style){return}a3.style.touchAction=a3.style.msTouchAction=a4};var U=function(a3){if(a3.preventDefault){a3.preventDefault()}};var m=function(a3){U(a3);return false};var ap=function(a4,a3){a.addEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{a.addEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a4,"touchstart",a3);a.addEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a4,"MSPointerDown",a3)}a.addEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var y=function(a4,a3){a.removeEvent(a4,"dragstart",m);if(aY.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{a.removeEvent(a4,"mousedown",a3)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a4,"touchstart",a3);a.removeEvent(a4,"mousedown",a3)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a4,"pointerdown",a3)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a4,"MSPointerDown",a3)}a.removeEvent(a4,"mousedown",a3)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a4,"MSHoldVisual",a.preventDefaultEvent)}};var B=function(){return true};var aR=function(a3){if(aL){W(a3,a3.pointerId)}else{var a4=a3.changedTouches;for(var a5=0;a5<a4.length;a5++){W(a4[a5],a4[a5].identifier)}}};var W=function(a3,a5){if(a5==b||a1[a5]!=b){if(aY.debug){if(a5==b){a.console.error("doRegisterPointer: no pointerId")}if(a1[a5]!=b){a.console.error("doRegisterPointer: pointerId already registered: "+a5)}}return}ad++;var a4=a1[a5]={};a4.identifier=a5;s(a4,a3);ar.push(a4)};var ak=function(a3){var a5=false;if(aL){a5=L(a3.pointerId)}else{var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){a5=L(a4[a6].identifier)}}}if(a5){ar=new Array(ad);var a8=0;for(var a7 in a1){ar[a8++]=a1[a7]}}};var L=function(a3){if(a3==b||a1[a3]==b){if(aY.debug){if(a3==b){a.console.error("doUnregisterPointer: no pointerId")}if(a1[a3]==b){a.console.error("doUnregisterPointer: pointerId not registered: "+a3)}}return false}delete a1[a3];ad--;return true};var I=function(){ad=0;a1={};ar=[]};var N=function(a4,a3){a4.x=a3.clientX;a4.y=a3.clientY};var aG=function(a4,a3){a4.x=a3.pageX;a4.y=a3.pageY};var v=function(a3){var a4=a3.changedTouches;if(a4){for(var a6=0;a6<a4.length;a6++){var a5=a1[a4[a6].identifier];if(a5){s(a5,a4[a6])}}}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y}};var ax=function(a3){var a4=a1[a3.pointerId];if(a4){s(a4,a3)}if(ar.length>0){aS.x=ar[0].x;aS.y=ar[0].y;aV(a3,aS)}};var V=function(a3){s(aS,a3);aV(a3,aS)};this.getMousePositionFromMouseEvent=function(a3){V(a3);return aS};this.getMousePositionPage=function(a4){var a3={};aG(a3,a4);aV(a4,a3);return a3};this.getMousePositionClient=function(a4){var a3={};N(a3,a4);aV(a4,a3);return a3};var u=function(a3,a4){if(window!=a3.view){var a5=a.getWindowOffset(window);a4.x-=a5.x;a4.y-=a5.y}};var aq=function(a3){try{u(a3);aV=u}catch(a4){aV=B}};var aB=function(a3){if(!al){return}var a5=ad;if(A&&a5==0){A=false}var a6=a3.type;if(p||an.started){if(a6!=aC){if(an.started){Q();ah()}else{a3._FSI_Canceled=true;a2(a3,true)}}}aC=a6;d=false;var a4=true;switch(a6){case"touchstart":aU=true;aL=false;af=v;j="touchmove";F="touchend";ae="touchcancel";aI=false;break;case"MSPointerDown":af=ax;aU=true;aL=true;j="MSPointerDown";F="MSPointerUp";ae="MSPointerCancel";aI=false;d=true;break;case"pointerdown":af=ax;aU=true;aL=true;j="pointermove";F="pointerup";ae="pointercancel";aI=true;d=true;break;default:if(ad>0){I()}aU=false;aL=false;aI=(aY.preventSelection);a4=false;af=V;j="mousemove";F="mouseup";ae=b;d=true}if(aU&&a4){aR(a3)}af(a3);if(!aY.bAllowMouseDown&&aI){U(a3)}if(ad>1){aa.bClick=false}x=false;if(a4&&aj(a3)){if(a5==0){C();E()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ad};var S=function(a3){if(aY.bMouseOnly&&a3.type==="pointerdown"&&a3.pointerType!=="mouse"){return true}if(!aB(a3)){return}if(p||a3.which>1){return}g(a3)};this.getCurrentPos=function(){return w};var g=function(a3){aK();if(p){return}az.evtMove=b;if(o.enabled){w={x:aS.x,y:aS.y}}else{w=aS}aa.x=aS.x;aa.y=aS.y;var a4=X;X=a3;if(!am.call(J,a3,w,G)){X=a4;return false}p=f=true;if(Y&&!A){aa.bClick=true;aa.clickRadiusX=aa.clickRadiusY=0}else{aa.bClick=false}E();if(az.enabled){az.x=az.y=0;az.lastX=aS.x;az.lastY=aS.y;if(az.nInterval){clearInterval(az.nInterval)}az.nInterval=setInterval(ab,30)}return true};var c=function(){if(h&&Z!=b){var a3={passive:false,capture:false};var a5=(t==b)?a3:b;h=false;a.removeEvent(window,Z,ag,a5);a.removeEvent(window,aD,a2,a5);if(d&&t){try{a.removeEvent(t,Z,ag,a3);a.removeEvent(t,aD,a2,a3)}catch(a4){}}if(aJ!=b){a.removeEvent(window,aJ,av,a5)}Z=aD=aJ=b}};var aE=function(a3){};var E=function(){if(h){c()}h=true;var a3={passive:false,capture:false};var a5=(t==b)?a3:b;Z=j;aD=F;aJ=ae;a.addEvent(window,Z,ag,a5);a.addEvent(window,aD,a2,a5);if(d&&t){try{a.addEvent(t,Z,ag,a3);a.addEvent(t,aD,a2,a3)}catch(a4){}}if(ae!=b){a.addEvent(window,aJ,av,a5)}};var ag=function(a3){af(a3);a3.FSI_start_x=aa.x;a3.FSI_start_y=aa.y;if(az.enabled&&az.evtMove==b){az.evtMove=a3}if(p){if(aa.bClick){aa.clickRadiusX=Math.max(aa.clickRadiusX,Math.abs(aS.x-aa.x));if(aa.clickRadiusX>ac){aa.bClick=false}else{aa.clickRadiusY=Math.max(aa.clickRadiusY,Math.abs(aS.y-aa.y));if(aa.clickRadiusY>ac){aa.bClick=false}}}if(o.enabled){o.evt=a3;aZ()}else{e.call(J,a3,w,G)}}else{if(an.started){if(an.nType==1){aw(a3)}}}if(x&&!a3.FSI_allowEventDefault){U(a3)}};var aw=function(a3){var a4=k();if(!O){return}a3._FSI_PinchDeltaStart=an.nPinchDistance-an.pinchDistanceStart;a3._FSI_PinchDeltaRelative=an.nPinchDistance-an.pinchDistanceLast;a3._FSI_PinchScale=Math.max(at,an.pinchDistanceLast)/an.pinchDistanceStartMaxed;an.pinchDistanceLast=an.nPinchDistance;a3._FSI_PinchDistance=a4;O.call(J,a3,aS,G)};var av=function(a3){if(aU){ak(a3);if(ad<1){if(p){a3._FSI_Canceled=true;a2(a3,true);return}else{R();return}}}af(a3);aj(a3)};var a2=function(a4,a5){var a3=aa.bClick;aa.bClick=false;if(a5){a4._FSI_Canceled=true}if(aU){ak(a4)}if(ad==0){aQ()}af(a4);if(!a5&&aj(a4)){return}aK();if(!a5){if(!p||ad>0){return}}a4.FSI_start_x=aa.x;a4.FSI_start_y=aa.y;var a6=false;if(!a5&&az.enabled){if(aA==b||aA()){a6=T(a4)}}if(a6){R();z(a4)}else{if(Y){a4._FSI_Click=a3}aO.call(J,a4,w,G);if(a4.type=="touchend"){aP=setTimeout(q,1)}R()}U(a4)};var q=function(){R();I();aP=b};var H=function(a3){return ar};var aZ=function(){if(o.animationFrame!=b){return}aT()};var i=function(){if(o.animationFrame==b){return}cancelAnimationFrame(o.animationFrame);o.animationFrame=b};var aT=function(){var a3=Math.abs(w.x-aS.x)+Math.abs(w.y-aS.y);if(a3>o.fEndDiff){w.x+=(aS.x-w.x)/o.factor;w.y+=(aS.y-w.y)/o.factor;o.animationFrame=requestAnimationFrame(aT)}else{w.x=aS.x;w.y=aS.y;o.animationFrame=b}e.call(J,o.evt,w,G)};var T=function(a3){var a4;if(!az.enabled){return false}if(az.running){C()}az.pos=0;var a6=(a3.touches!=b)?1.8:1;if(az.factorAmountQuad){a4=(az.x>0)?1:-1;az.x=az.x+a4*az.x*az.x/az.factorAmountQuad;a4=(az.y>0)?1:-1;az.y=az.y+a4*az.y*az.y/az.factorAmountQuad}var a8=a6*az.factorAmount;az.startX=w.x;az.startY=w.y;var a7={};a7.x=az.startX+a8*az.x;a7.y=az.startY+a8*az.y;if(az.roundTargetPos){a7.x=Math.round(a7.x);a7.y=Math.round(a7.y)}if(az.modifyTarget){a7=az.modifyTarget.call(J,a7,G);if(a7===false){return false}}az.amountX=a7.x-az.startX;az.amountY=a7.y-az.startY;az.amountXABS=Math.abs(az.amountX);az.amountYABS=Math.abs(az.amountY);var a5=(az.amountXABS>az.minDelta||az.amountYABS>az.minDelta);if(a5){a8=az.factorFrames/100;az.frames=az.offsetFrames+Math.round(a8*az.amountXABS+a8*az.amountYABS)}else{if(typeof(aY.onAfterTouchCancel)=="function"){aY.onAfterTouchCancel.call(J,a3,w,G)}}return a5};this.isAfterTouchRunning=function(){return az.running};var z=function(a3){if(typeof(aY.onAfterTouchStart)=="function"){aY.onAfterTouchStart.call(J,a3,w,G)}az.running=true;az.evtUp=a3;if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,true,az.evtMove,G)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}else{az.intervalRun=setInterval(K,16)}}return true};var aH=function(a4,a3,a6,a5){return a6*((a4=a4/a5-1)*a4*a4+1)+a3};var K=this.runAfterTouch=function(){var a3=false;az.pos++;w.x=aH(az.pos,az.startX,az.amountX,az.frames);w.y=aH(az.pos,az.startY,az.amountY,az.frames);e.call(J,az.evtMove,w,G);if(az.pos===az.frames){C(true)}else{if(az.useAnimationFrame){az.animationFrameRun=requestAnimationFrame(K)}a3=true}return a3};this.enableAfterTouch=function(a3){if(az.enabled==a3){return}if(!a3){C()}az.enabled=a3};var C=function(a3){if(!az.running){return}if(az.fnStartStopAfterTouch){az.fnStartStopAfterTouch.call(J,false,az.evtMove,G)}else{if(az.useAnimationFrame){if(az.animationFrameRun){cancelAnimationFrame(az.animationFrameRun)}}else{if(az.intervalRun){clearInterval(az.intervalRun);az.intervalRun=b}}}if(typeof(aY.onAfterTouchEnd)=="function"){aY.onAfterTouchEnd.call(J,az.evtMove,G)}az.evtMove=b;az.running=false;az.evtUp._FSI_Canceled=(a3!==true);az.evtUp._FSI_fromAfterTouch=true;aO.call(J,az.evtUp,w,G)};var ab=function(){az.x=(2*az.x+aS.x-az.lastX)/5;az.y=(2*az.y+aS.y-az.lastY)/5;az.lastX=aS.x;az.lastY=aS.y};var ay=this.setCapture=function(a3,a5){var a4=ai(a3,a5);if(a4){au.captureScrollUser=a3;au.capturePinchUser=a5}return a4};var ai=function(a3,a5){var a4=0;if(a3){a4+=2}if(a5){a4+=4}if(a4==au.nCheck){return}au.nCheck=a4;au.captureScroll=a3;au.capturePinch=a5;if(a.BrowserSupports.cssTouchAction()){P(a3,a5)}return true};var P=function(a3,a7){if(aY.bMouseOnly){return}var a6;switch(au.nCheck){case 0:a6="auto";break;case 2:a6=aW+"pinch-zoom";break;case 4:a6="pan-x pan-y";break;default:a6=(aW.length>0)?aW:"none"}au.cssTouchAction=a6;for(var a5=0;a5<n.length;a5++){var a4=n[a5];r(a4,au.cssTouchAction)}};var k=function(){if(ar.length<1){return 0}var a4=Math.abs(ar[1].x-ar[0].x);var a3=Math.abs(ar[1].y-ar[0].y);return an.nPinchDistance=Math.sqrt(a4*a4+a3*a3)};var aj=function(a3){x=false;if(!al){return}var a4=ar.length;if(!aN){x=(a4==1&&au.captureScroll);return}if(an.pointerCount!=a4){Q(a3);if(a4>1){ah();an.nPointers=a4;switch(a4){case 2:an.started=true;an.name="pinch";an.nType=1;if(typeof(aY.onPinchStart)=="function"){M(a3);an.nPinchDistance=0;an.nPinchDistance=k();an.pinchDistanceStart=an.pinchDistanceLast=an.nPinchDistance;an.pinchDistanceStartMaxed=Math.max(at,an.pinchDistanceStart);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchStart.call(J,a3,aS,G)}break;default:an.started=true;an.name="unknown";an.nType=-1}if(an.started){A=true;if(p){aK();p=false;a3._FSI_Canceled=true;aO.call(J,a3,w,G)}if(typeof(aY.onGestureStart)=="function"){M(a3);aY.onGestureStart.call(J,a3,aS,G)}}}else{if(a4<1){ah()}}an.pointerCount=a4;x=false;if(a4==1){if(au.captureScroll){x=true}}else{if(au.capturePinch&&an.nType==1){x=true}}}return an.started};var ah=function(){if(!an.timeoutRestartDown){return}clearTimeout(an.timeoutRestartDown);an.timeoutRestartDown=b};var D=function(){if(ad!=1){return}g(X);ah()};var M=function(a3){a3._FSI_Gesture=an.name;a3._FSI_GestureType=an.nType;a3._FSI_PointerCount=an.nPointers};var Q=function(a3){if(!an.started){return}an.started=false;if(!a3){a3={}}if(an.nType==1&&typeof(aY.onPinchEnd)=="function"){M(a3);a3._FSI_PinchDistance=an.nPinchDistance;aY.onPinchEnd.call(J,a3,aS,G)}if(typeof(aY.onGestureEnd)=="function"){M(a3);aY.onGestureEnd.call(J,a3,aS,G)}an.name="none";an.nType=0;if(a3&&ad==1){ah();an.timeoutRestartDown=setTimeout(D,20)}};ao()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.IMGLoadingEngine!==b){return}a.IMGLoadingEngine=function(q,h){var p=this;var n=0;var w=0;var l=(typeof(h)==="function")?h:a.fnDoNothing;var j={};var c=1;var s;var g,d;var v;this.destroy=function(){e();p.abortAll();c=1;u()};this.getCountLoading=function(){return n};this.load=function(x,z,B,y,C){var A=(!v||v[B]===b);if(typeof(C)!=="object"){C={}}if(typeof(x)!=="object"){return C}if(typeof(B)!=="string"||B.length<1){B="default"}if(j[B]===b){j[B]={__count:0}}j[B][c]=x;j[B].__count++;n++;if(A){if(w===0){m(1)}w++}a.addEvent(x,"load",r);a.addEvent(x,"error",f);x.FSIIMGLoadingEngineData=C;C.uid=c;C.url=z;C.strPurpose=B;C.bLoading=true;C.bVisual=A;if(typeof(y)==="function"){C.fnLoad=y}a.loadImageCors(x,z);c++};this.setNotVisualPurposes=function(x){if(typeof(x)&&x!==null&&typeof(x.concat)==="function"){if(x.length>0){v={};for(var y=0;y<x.length;y++){v[x[y]]=true}}else{v=b}}};var m=function(x){if(!l||x===g){return}g=x;e();s=setTimeout(i,50)};var i=function(){if(g===d){return}d=g;e();l.call(q,d)};var e=function(){if(s!==b){clearTimeout(s);s=b}};var u=this.reset=function(){if(n>0){for(var y in j){var z=y[j];for(var x in z){t(z[x])}}}n=w=0;j={}};var k=function(x){return(typeof(x)==="object"&&typeof(x.FSIIMGLoadingEngineData)==="object")};var t=function(x){if(!k(x)){return false}var y=x.FSIIMGLoadingEngineData;if(!y.bLoaded){y.bAborted=true}n--;if(x.FSIIMGLoadingEngineData.bVisual){w--;if(w===0){m(0)}}if(j[y.strPurpose]!=b){if(j[y.strPurpose][y.uid]===b){a.console.error("IMGLoadingEngine: failed to remove item with purpose '"+y.strPurpose+" and uid "+y.uid)}else{j[y.strPurpose][y.uid]=b;delete j[y.strPurpose][y.uid];delete x.FSIIMGLoadingEngineData}j[y.strPurpose].__count--;if(j[y.strPurpose].__count===0){delete j[y.strPurpose]}}return true};this.abortAll=function(){if(n>0){for(var y in j){var z=j[y];for(var x in z){o(z[x]);if(!z[x]){break}}}}};var o=this.abortItem=function(x){if(!k(x)){return false}if(x.FSIIMGLoadingEngineData.bAborted){return true}x.FSIIMGLoadingEngineData.bAborted=true;if(x.FSIIMGLoadingEngineData.bLoaded){t(x)}return true};this.abortPurpose=function(y){if(n<1){return false}if(typeof(j[y])!=="object"||j[y].__count<1){return false}for(var x in j[y]){o(j[y][x]);if(!j[y]){break}}return true};var f=function(x){var y=this.FSIIMGLoadingEngineData;y.bError=true;r.apply(this,[x])};var r=function(x){var y=this;a.removeEvent(y,"load",r);a.removeEvent(y,"error",f);var z=y.FSIIMGLoadingEngineData;z.bLoading=false;z.bLoaded=true;if(!z.bError&&!z.bAborted){z.bSuccess=true}t(y);if(!z.bAborted&&z.fnLoad){z.fnLoad.apply(y,[x,z])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderCSSSkin!=b){return}a.LoaderCSSSkin=function(){var e=this;var j=0;var h={};var c=0;var d=new a.CORSLoader();var f=function(l){var k=false;try{if(l.cssRules!=b){k=l.cssRules}else{k=l.rules}}catch(m){console.error(m.message)}return k};var i=function(n,m,v,l,t){var s=this;var u;var B=[];var o;var y=0;var r=false;var q=false;this.uniqueID=c++;this.bReleased=false;this.getSkinName=function(){return m.getSkinName()};this.callReady=function(D,E,G,F){if(this.bReleased){return}if(F){q=true}o=arguments;r=true;p()};var p=function(){if(!r||y>0){return}if(q){u=setTimeout(z,1)}else{z()}};var z=function(){k();v.apply(l,o)};var k=function(){if(u!=b){clearTimeout(u);u=b}};this.remove=function(){k();if(s.bReleased){return}m.removeWaiter(s.uniqueID);for(var D=0;D<B.length;D++){B[D].remove()}this.bReleased=true};var C=function(D,E,G,F){if(F){q=true}y--;p()};if(t&&typeof(t)=="object"&&t.length>0){for(var w=0;w<t.length;w++){var x=t[w];y++;var A=a.loadSkinCSS(x.file,s,C,x.nPriority);B.push(A)}}};var g=function(k,w){var t=false;var l=0;var v={};var q=false;var r=false;var s;var p;var m;var o;m=k.match(/(.*)\/[^/]*$/);m=m[1]+"/";m=m.replace(/\/resources\/$/,"/");p=k.replace(/\.[^/]*$/,"");p=p.match(/([^/]*)$/);p=p[1].toLowerCase();this.removeWaiter=function(x){if(v[x]==b){return}delete v[x];l--};this.addWaiter=function(x){if(x.uniqueID==b||x.bReleased){return}if(q){x.callReady(r,o,"ALREADY LOADED",false)}else{if(v[x.uniqueID]==b){v[x.uniqueID]=x;l++;if(!t){u()}}}};this.getSkinName=function(){return p};var n=function(H,A,I,C){var F=false;if(C>299||typeof(A)!="string"){a.console.error("Failed to load Skin CSS (HTTP "+C+"): "+k)}else{F=true;A=A.replace(/\[fsi-skin-path\]/g,m);s=document.createElement("style");s.setAttribute("type","text/css");s.setAttribute("x-generated-by","FSI");s.setAttribute("x-fsi-skin",p);s.setAttribute("x-fsi-priority",w);s.appendChild(document.createTextNode(A));var E=document.head;if(!E){E=document.getElementsByTagName("head");if(E&&E.length>0){E=E[0]}}if(E&&E.firstChild){try{var z;var J=E.getElementsByTagName("style");for(var B=0;B<J.length;B++){var G=J[B];var y=parseInt(G.getAttribute("x-fsi-priority"));if(isNaN(y)||y>w){z=G;break}}if(z){E.insertBefore(s,z)}else{E.appendChild(s)}}catch(D){E.appendChild(s)}}else{E.appendChild(s)}o=s.sheet;r=F}q=true;for(var x in v){v[x].callReady(r,o,"onLoaded",true)}v={};l=0};var u=function(){t=true;if(typeof(k)!="string"||k.length<0){return false}d.load(k,n,"text/css");return true}};this.load=function(p,q,m,r,l){if(r==b){r=100}var o=false;if(a.versionInternetExplorer<9){o=true}if(o){a.console.error("Unable to load skin: unsupported browser version.");if(m){m.call(q,false)}return false}if(a._FSIViewerLocation==b||typeof(p)!="string"||p.length<1){a.console.error("Unable to load skin:");if(a._FSIViewerLocation==b){a.console.error("FSI Viewer path not known")}else{a.console.error("Invalid skin URL "+p)}if(m){m.call(q,false)}return false}var k=p;if(k.indexOf("http")!=0){k=a._FSIViewerLocation+"/skins/"+k}if(!k.match(/\.css$/)){k+=".css"}var s;if(h[k]==b){j++;s=h[k]=new g(k,r)}else{s=h[k]}var n=new i(k,s,m,q,l);s.addWaiter(n);return n}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderJavascript!=b){return}a.LoaderJavascript=function(){var e={};this.load=function(h,l,n,j,m){var k=e[h];if(n==b){n=window}if(typeof(j)!="function"){return false}if(k==b){k=e[h]={};k.path=h;k.loaded=false;k.failed=false;f(k);if(!g(k)){k.failed=true;k.loaded=true;k.addNodeFailed=true}}else{if(k.oListeners[l]!=b){d(h,l)}}k.nListeners++;var i=k.oListeners[l]={};i.argScope=n;i.argFunction=j;i.oPassThrough=m;if(k.loaded==true){c(k)}return true};var d=this.release=function(h,j){var i=e[h];if(i==b){return}if(i.oListeners[j]!=b){delete i.oListeners[j];i.nListeners--}};var g=function(l){var h=false;try{var i=document.getElementsByTagName("head");if(i&&i.length>0){i=i[0];var j=l.node=document.createElement("script");var k=l.onLoad=function(n){if(n.type=="error"){l.failed=true;c(l)}else{l.failed=false;c(l)}l.loaded=true};a.addEvent(j,"load",k);l.onError=function(n){l.failed=true;c(l);l.loaded=true};a.addEvent(j,"error",k);i.appendChild(j);j.src=l.path;h=true}}catch(m){}return h};var c=function(j){var h=!j.failed;a.removeEvent(j.node,j.onLoad);a.removeEvent(j.node,j.onError);for(var k in j.oListeners){var i=j.oListeners[k];i.argFunction.call(i.argScope,h,j.path,i.oPassThrough)}f(j)};var f=function(h){h.oListeners={};h.nListeners=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.AboutWindow!=b){return}a.AboutWindow=function(d,k){var m=this;var e;var g;var h;var f;var i;var l=function(){e=document.createElement("div");a.setStyleAttr(e,"position: absolute;z-index:1000;width:12em;");e.className="fsi-ui-info-window";h=document.createElement("div");h.className="fsi-ui-title";f=document.createElement("div");f.style.display="inline-block";f.innerHTML=k.title;h.appendChild(f);i=document.createElement("div");i.style.display="inline-block";i.style["float"]="right";i.style.cursor="pointer";i.innerHTML="X";h.appendChild(i);e.appendChild(h);g=document.createElement("div");g.className="fsi-ui-content";var o=k.strLongVersion;o="<h3>"+o.replace(/ build/,'</h3><span class="small">build')+"</span>";var n;if(k.strCopyright==b){n="<br/><br/>&copy; 2018 NeptuneLabs GmbH<br/>";n+='<hr/><a style="color:inherit;text-decoration:none" href="//www.neptunelabs.com/" target="_blank">www.neptunelabs.com</a><br/><br/><span class="small">FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany<br/></span>'}else{k.strCopy=k.strCopyright}o+="<br/>"+n;g.innerHTML=o;e.appendChild(g);d.appendChild(e);a.addEvent(e,"click",j);c()};var c=function(){var o=a.getElementPosition(d);o.width=(o.right-o.left);o.height=(o.bottom-o.top);var n=a.getElementPosition(e);n.width=(n.right-n.left);n.height=(n.bottom-n.top);e.style.left=Math.round((o.width-n.width)/2)+"px";e.style.top=Math.round((o.height-n.height)/2)+"px"};var j=this.destroy=function(){if(typeof(k.fnOnDestroy)=="function"){if(!k.fnOnDestroy.call(this)){return}}a.removeEvent(e,"click",j);a.removeChild(e.parentNode,e)};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListener!=b){return}a.CustomEventListener=function(j){var l=this;var d=[];var g={};var h={};var i=0;l._strClassName="$FSI.CustomEventListener";var k=function(){if(a.eventFunctionID==b){a.eventFunctionID=0}if(a.eventElementID==b){a.eventElementID=0}};this.destroy=function(){for(var m=0;m<d.length;m++){var n=d[m];f(n.element,n.fn)}d=[];g={};h={};l.onDestroy()};this.fireEvent=function(m,n){if(!m||!m.enabled){return false}if(typeof(n)!="object"){n={}}if(m.paused){n.FSI_paused=true}n.FSI_custom_event=true;n.FSI_type=j;n.FSI_target=m.element;return m.fn.call(m.element,n)};this.fireEvents=function(n){if(typeof(n)!="object"){n={}}n.FSI_custom_event=true;n.FSI_type=j;for(var o=0;o<d.length;o++){var m=d[o];if(m.enabled){if(m.paused){n.FSI_paused=true}else{if(n.FSI_paused){delete n.FSI_paused}}n.FSI_target=m.element;m.fn.call(m.element,n)}}};var c=this.addListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for addListener");return}if(q.__FSI==b){q.__FSI={}}if(q.__FSI.eventElementID==b){q.__FSI.eventElementListenerCount=1;q.__FSI.eventElementID=a.eventElementID++}else{q.__FSI.eventElementListenerCount++}if(p.__FSIEventFunctionID==b){p.__FSIEventFunctionListenerCount=1;p.__FSIEventFunctionID=a.eventFunctionID++}else{p.__FSIEventFunctionListenerCount++}var n=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(g[n]==b){var m=g[n]={};m.nFunction=0;m.oFunctions={}}if(g[n].oFunctions[o]==b){g[n].nFunction++;g[n].oFunctions[o]=[]}else{a.console.warn(l._strClassName+": There is already a listener for this exact element and function");a.console.log(q);a.console.log(p)}var r={};r.element=q;r.elementID=n;r.fn=p;r.fnID=o;r.instanceListener=l;r.enabled=true;r.paused=false;r.uniqueID=i++;g[n].oFunctions[o].push(r);d.push(r);h[r.uniqueID]=r;l._onListenerAdd(r);l._onListenerCountChange(d.length);return r};this.setListenerProps=function(p,n,o){var m=h[p];if(!m){return false}if(m.props==b){m.props={}}m.props[n]=o;return true};this.enableListener=function(o,n){var m=h[o];if(m==b||m.enabled==n){return}m.enabled=n};this.pauseListener=function(o,n){var m=h[o];if(m==b||m.paused==n){return}m.paused=n};var f=this.removeListener=function(q,p){if(typeof(q)!="object"||typeof(p)!="function"){a.console.error(l._strClassName+": Invalid parameters for removeListener");return}if(q.__FSI==b||q.__FSI.eventElementID==b||p.__FSIEventFunctionID==b){if(p.__FSIEventFunctionID==b){a.console.error(l._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(l._strClassName+": Element not registered for listener in removeListener")}return}var m=q.__FSI.eventElementID;var o=p.__FSIEventFunctionID;if(!g[m]){a.console.error(l._strClassName+": No registered listener for this element in removeListener");return}var n=g[m].oFunctions[o];if(n==b||typeof(n.pop)!="function"){a.console.error(l._strClassName+": No registered listener for this function in removeListener");return}var r=n.pop();r.fn.__FSIEventFunctionListenerCount--;r.element.__FSI.eventElementListenerCount--;if(r.element.__FSI.eventElementListenerCount==0){delete r.element.__FSI.eventElementListenerCount;delete r.element.__FSI.eventElementID}if(r.fn.__FSIEventFunctionListenerCount==0){delete r.fn.__FSIEventFunctionListenerCount;delete r.fn.__FSIEventFunctionID}if(n.length==0){delete g[m].oFunctions[o];g[m].nFunction--;if(g[m].nFunction==0){delete g[m]}}delete h[r.uniqueID];e();l._onListenerRemove(r);l._onListenerCountChange(d.length);return r};this.getEventListenerByID=function(m){return h[m]};this.getListenerObjectByID=function(m){return h[m]};this.getListenersArray=function(){return d};this.getListenerCount=function(){return d.length};var e=function(){d=[];for(var n in g){var p=g[n].oFunctions;for(var o in p){var m=p[o];d=d.concat(m)}}};this.dump=function(){a.console.dir(g);a.console.dir(d)};this._onListenerCountChange=function(m){};this._onListenerAdd=function(n,m){};this._onListenerRemove=function(n,m){};this.triggerEvent=function(m){};this.triggerEvents=function(){};this.setListenerProps=function(o,m,n){};this.onDestroy=function(){};k()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerDocumentZoom!=b){return}a.CustomEventListenerDocumentZoom=a.oCustomEventListenerClasses.FSIDocumentZoomChange=function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!=c){if(q){j()}else{i()}}};var m=function(p){var q;var r=a.getDocumentScaleWithPixelRatio();if(g!=r){g=r;k(r);q=true}else{q=false}return q};var d=function(){var p;var q=a.getDocumentScaleWithPixelRatio();if(g!=q){if(f==false){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l==20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l==40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l==50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerViewport!=b){return}a.CustomEventListenerViewport=a.oCustomEventListenerClasses.FSIViewport=function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!=b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!=b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!=d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!=b){return}w=setTimeout(K,N);K()};var K=function(){if(w!=b){clearTimeout(w);w=b}var e=false;var U=L();if(C!=U){C=U;e=true;f()}return e};var J=function(){n=a.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.topWindow);T=a.getBoundingClientRect(a.topWindow.document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.topWindow);T=a.getBoundingClientRect(a.topWindow.document.documentElement);h.left=a.topWindow.pageXOffset;h.top=a.topWindow.pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!=b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!=b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u==b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!=b){if(U==b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length==0){r()}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerElementDimension!=b){return}a.CustomEventListenerElementDimension=a.oCustomEventListenerClasses.FSIElementDimension=function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)=="function";a.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e==b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!=b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(g==b){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!=p.element.offsetWidth||p.__elementHeight!=p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!=b){h(s)}}}}};var h=function(p){if(p==k||e==b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomEventListenerMouseWheel!=b){return}a.CustomEventListenerMouseWheel=a.oCustomEventListenerClasses.FSIMouseWheel=function(){var c=this;var f=100000;var h=false;var g;a.CustomEventListener.prototype.constructor.call(c,"FSIMouseWheel");c._strClassName="$FSI.CustomEventListenerMouseWheel";var i=this.destroy;this._onListenerAdd=function(j){j.callback=function(k){d(j,k)};a.addEvent(j.element,"mousewheel",j.callback);a.addEvent(j.element,"DOMMouseScroll",j.callback)};this._onListenerRemove=function(j){a.removeEvent(j.element,"mousewheel",j.callback);a.removeEvent(j.element,"DOMMouseScroll",j.callback)};this._onListenerCountChange=function(j){if(j<1){if(g!=b){clearInterval(g);g=b}}};this.setListenerProps=function(m,k,l){if(typeof(k)!="string"){return false}var j=c.getListenerObjectByID(m);if(!j){return false}switch(k){case"acceleration":if(l){j.bAccelerate=true;j.acceleration=l;j._accelerate=1;if(j._accelerateMax==b){j._accelerateMax=10}}break;case"accelerationMax":j._accelerateMax=l;break}};var e=function(){var k=c.getListenersArray();var l=true;for(var m=0;m<k.length;m++){var j=k[m];if(j.bAccelerate&&j._accelerate>1){j._accelerate/=1.5*j.acceleration;if(j._accelerate>1.5){l=false}else{l=true;j._accelerate=1}}}if(l){clearInterval(g);g=b}};var d=function(j,k){var n=false;var o=false;var m=0;if(k.detail){m=k.detail}else{if(k.wheelDelta){m=-k.wheelDelta}}if(m!=0){k.FSI_normalized_delta=(m>0)?-1:1;f=Math.min(f,Math.abs(m))}else{k.FSI_normalized_delta=0}if(j.bAccelerate){if(g==b){g=setInterval(e,200);n=true}j._accelerate*=j.acceleration;j._accelerate=Math.min(j._accelerateMax,j._accelerate);m=Math.round(j._accelerate*m)}else{j._accelerate=1}k.FSI_delta=-m;k.FSI_weighted_delta=k.FSI_delta/f;k.FSI_normalized_accelerated_delta=(m>0)?-j._accelerate:j._accelerate;var l=c.fireEvent(j,k);if(l===false){j._accelerate=1}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.NavigatorWindow!=b){return}a.NavigatorWindow=function(q,A,w,J,E){var j=this;var af=q.iViewer;var t;var aa=0;var m;var p,C;var h;var F,r;var i,f;var u=false;var x=false;var M=q.getElementSpace();var N=q.getinPlaceZoom();var g=af.getImageIsTransparent();var U=q.getDrawRatio();var s=af.getSrcDim();var ad=q.getdrawRatioUnZoomed();var G=q.getdrawRatioUnResized();var W=q.viewport;var I;var V;var c={x:2,y:2};var d;var ae;var O=false;var Y;var Q;var ac={};var H;var B=false;var z;var K;var v=false;var e=true;var o;var Z=function(){u=A.result.autoHideNav;m=[];aa=4;h=16;o=A.makeBool(A.cfg.autohidenaviftoosmall,true);var aj=l(A.result.navWidth,W.width,120);var ap=l(A.result.navHeight,W.height,120);var am=Math.min(M.width-2*aa,aj);var an=Math.min(M.height-2*aa-20,ap);am=Math.max(60,am);an=Math.max(40,an);var al,ah;al=am;ah=al/ad.imageWidth*ad.imageHeight;if(ah>an){ah=an;al=ah/ad.imageHeight*ad.imageWidth}p=Math.max(10,Math.round(al));C=Math.max(10,Math.round(ah));var ao=p+2*aa;var ak=C+2*aa+h;F=ao;r=ak;j.sprite=new a.Sprite(J,ao,ak,500);a.addClass(j.sprite.element,"fsi-ui-nav-window");j.sprite.element.style.width=j.sprite.element.style.height="auto";if(w){d=w.navFrameBorderColor;ae=w.navFrameBackgroundColor}else{d="red";ae="rgba(255,255,255,0.5)"}j.canvasSprite=new a.Sprite(j.sprite.element,p,C,2,true,"inline");j.canvasSprite.element.style.clear="both";a.addClass(j.canvasSprite.element,"fsi-ui-nav-window-image");if(A.hasPlugin("zoommeter")){I=document.createElement("div");a.addClass(I,"fsi-ui-nav-window-zoom-text");j.sprite.element.appendChild(I);V=document.createTextNode("100 %");I.appendChild(V);var ai=A.getPluginParameter("zoommeter","color");if(ai){I.style.color="#"+ai}O=A.getPluginParameter("zoommeter","srcrelative",false,true)}j.sprite.updateMargins();j.sprite.updateDimension();var ag={};ag.smoothing={enabled:true,factor:7,fEndDiff:0.03};z=new a.TouchHandler(j.canvasSprite.canvas,ag,S,X,T);Q=j.canvasSprite.ctx;L();n();if(u){R(false,false)}};this.destroy=function(){if(z){z.destroy();z=b}a.removeChild(J,j.sprite.element)};this.enable=function(ag){z.enable(ag)};var l=function(aj,ah,ai){var ag=parseInt(aj);if(typeof(aj)=="string"&&aj.indexOf("%")!=-1){ag=Math.max(0,Math.min(100,ag));ag=Math.round(ag*ah/100)}else{ag=parseInt(aj)}if(isNaN(ag)){ag=ai}return ag};this.isDragging=function(){return x};var S=function(ah,ak){q.onUserAction();q.stopAutoSpin();var ai=a.getElementPosition(j.canvasSprite.element);i=-ai.left;f=-ai.top;var ag=ak.x+i;var aj=ak.y+f;if(ag<0||aj<0||ag>p||aj>C){return false}x=true;q.stopDesktopAnimation();q.stopAfterTouch();y(ak,true);q.autoShowHideHotSpots(false);q.iCallbacks.run("onStartDragging",[true]);return true};var X=function(ag,ah){y(ah,true)};var T=function(ag,ah){q.onUserAction();x=false;y(ah,false);q.onAfterinPlaceZoomChanged();q.autoShowHideHotSpots(true);q.iCallbacks.run("onStopDragging",[true])};var y=function(aj,ah){var ag=aj.x+i-p/2;var ai=aj.y+f-C/2;N.panPos.left=K*-ag;N.panPos.top=K*-ai;q.updateInPlaceZoom(ah)};var P=function(ao,ax,ap,av,aq){var am,ak,aj,ai,an,aw,au;aw=ax;au=ap;ax=Math.max(1,Math.round(ax/2));if(ax<av){ax=av}ap=Math.max(1,Math.round(ap/2));if(ap<aq){ap=aq}ak=ai=document.createElement("canvas");ai.setAttribute("crossorigin","anonymous");ai.width=ax;ai.height=ap;an=ai.getContext("2d");an.drawImage(ao,0,0,aw,au,0,0,ax,ap);var ah=document.createElement("canvas");ah.setAttribute("crossorigin","anonymous");var al=ah.getContext("2d");var ag=false;while(ax>av||ap>aq){am=ak;aw=ax;au=ap;if(ag){ak=ai;aj=an;ag=false}else{ak=ah;aj=al;ag=true}ax=Math.round(ax/2);if(ax<av){ax=av}ap=Math.round(ap/2);if(ap<aq){ap=aq}ak.width=ax;ak.height=ap;aj.drawImage(am,0,0,aw,au,0,0,ax,ap)}var at;try{at=aj.getImageData(0,0,ax,ap);Y=D}catch(ar){at=ak;Y=k}return at};var D=function(ah,ag,ai){Q.putImageData(ah,ag,ai)};var k=function(ah,ag,ai){Q.drawImage(ah,ag,ai)};var L=function(){switch(c.x){case 2:j.sprite.element.style.left="auto";j.sprite.element.style.right=j.sprite.margin.right+"px";break;default:j.sprite.element.style.right="auto";j.sprite.element.style.left=j.sprite.margin.left+"px";break}switch(c.y){case 2:j.sprite.element.style.top="auto";j.sprite.element.style.bottom=j.sprite.margin.bottom+af.getMenuHeight("navWindow")+"px";break;default:j.sprite.element.style.bottom="auto";j.sprite.element.style.top=j.sprite.margin.top+"px";break}};this.setContainerSize=function(ag,aj,ai){var ah=j.sprite.element.style.display;j.sprite.element.style.display="block";j.sprite.updateDimension();U=aj;ad=ai;M=ag;j.sprite.element.style.display=ah;n()};var R=function(ag,ah){if(ag==b){ag=(!B&&v)}if(e==ag){return}e=ag;j.sprite.show(ag,ah)};var n=function(){if(!o){return}B=(M.width<4*j.sprite.width()||M.height<4*j.sprite.height());R(b,false)};var ab=this.autoShowHide=function(ag){if(!u){return}if(v!=(N.scale>1.05)){v=!v;R(b,ag)}};this.setPreviewImageSize=function(ag,ah){if(ag==b){H=b}else{ac.width=ag;ac.height=ah;H=ac}};this.update=function(aA,al){ab(true);if(!j.sprite.isVisible()){return}K=U.imageWidth/p;var aq=Q;if(m[aA]==b){var au=q.getPreviewImage(aA);var aw=(H)?H:au;m[aA]=P(au,aw.width,aw.height,p,C)}aq.lineWidth=0;var an=0;var am=0;if(I&&t!=al){t=al;var av,ag;if(O){av=al*G.imageWidth/s.width}else{av=U.imageWidth/ad.imageWidth}av=Math.round(100*10*av)/10;ag=""+av;if(ag.indexOf(".")==-1){ag+=".0"}ag+=" %";V.nodeValue=ag}Y(m[aA],an,am);var az=N.scale;if(az>1.05){var ap=p/G.imageWidth/az;var aj=ap*W.width;var ar=ap*W.height;var ax=p/U.imageWidth;var ao=(p-aj)/2-N.panPos.left*ax;var ay=(C-ar)/2-N.panPos.top*ax;var ai=an+ao;var ah=am+ay;var ak=an;var at=am;if(aj<4||ar<4){ai+=aj/2;ah+=ar/2;aq.strokeStyle=d;aq.strokeRect(ai,ah-3,1,7);aq.strokeRect(ai-3,ah,7,1)}else{aq.save();aq.fillStyle=ae;aq.beginPath();aq.rect(ak,at,p,ah-at);aq.rect(ak,ah,ai-ak,ar);aq.rect(ai+aj,ah,p-ao-aj,ar);aq.rect(ak,ah+ar,p,C-ay-ar);aq.closePath();aq.clip();aq.fillRect(an,am,p,C);aq.restore();aq.save();aq.strokeStyle=d;aq.beginPath();aq.rect(an,am,p,C);aq.clip();aq.strokeRect(ai,ah,aj,ar);aq.restore()}}};this.reverseImageSequence=function(){m.reverse();m.unshift(m.pop())};Z()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MenuBar!==b){return}a.MenuBar=function(j,s,z,I,r){var h=this;var L=this.myViewer=j.iViewer;var A=j.getElementSpace();var g;var x;var u=0;var C=[];var l=b;if(r===b){r={}}this.bEnabled=b;var o=false;var B={};var m={};var K={};var f=0;var i=0;var y="fsi-ui-button-icon";var q;var D;var n=1;var v,J;var p=this.setInterface=function(){v=j.getDebug();J=j.getToolTip()};var F=function(){h.oInterface=j;var M=j.iConfig;D=M.makeBool(M.cfg.menubuttontooltips,true,true);p(j);h.btnID=0;h.sprite=new a.Sprite(z,A.width,f,450,b,b,"fsi-ui-menu-bar");h.sprite.element.style.width="100%";h.sprite.element.style.top="auto";h.sprite.element.style.left="0px";h.sprite.element.style.right="auto";h.sprite.element.style.lineHeight="100%";h.sprite.element.style.bottom="0px";h.sprite.element.style.visibility="hidden";h.iconClassNamesNormal=y;l=setTimeout(e,0)};var e=function(){if(h.sprite.element.offsetHeight!==0||u++>200){l=b;k()}else{l=setTimeout(e,25)}};this.getButtonContainerWidth=function(){return x.element.offsetWidth};this.addButtonCSSClass=function(M,N){E(M,N,true)};this.removeButtonCSSClass=function(M,N){E(M,N,false)};var E=function(O,P,N){var M=m[O];if(M===b){return}if(N){a.addClass(M.elButton,P)}else{a.removeClass(M.elButton,P)}h.setExternalButtonState(O,M.getState(),M.elButton.className)};this.getExternalButtonID=function(){return n++};var k=function(){var N=h.sprite.getClientDim();f=Math.round(N.height);h.sprite.setSize("100%",f);h.setEnabled(false);if(typeof(s.urlLogo)==="string"&&s.urlLogo.length>0&&s.urlLogo!=="none"){g=document.createElement("div");a.addClass(g,"fsi-ui-logo");a.setStyleAttr(g,"position:absolute;display:none");var M=document.createElement("img");M.className="fsi-ui-logo-image";M.style.backgroundImage="none";M.src=s.urlLogo;g.appendChild(M);a.addEvent(M,"load",w);h.sprite.element.appendChild(g);a.addEvent(g,"click",L.showAboutWindow)}a.addEvent(h.sprite.element,"mouseup",d);a.addEvent(h.sprite.element,"contextmenu",G);if(o){h.sprite.show(false,false)}h.sprite.element.style.visibility="";I()};this.destroy=function(){t("onMenuDestroy");if(l!==b){clearTimeout(l);l=b}if(g){a.removeEvent(g,"click",L.showAboutWindow)}a.removeEvent(h.sprite.element,"mouseup",d);a.removeEvent(h.sprite.element,"contextmenu",G);h.removeButtons();h.removeDomElement()};this.removeDomElement=function(){if(h.sprite.element.parentNode){a.removeChild(h.sprite.element.parentNode,h.sprite.element);f=0}};var d=function(M){if(M.which&&M.which===3){i=new Date().getTime()}};var G=function(N){if(i){var M=new Date().getTime()-i;if(M<300){return}}N.preventDefault&&N.preventDefault()};this.getHeight=function(){return f};this.pressButton=function(N){var M=m[N];if(M!==b){M.onMouseDown()}};this.releaseButton=function(N){var M=m[N];if(M!==b){M.onMouseUp()}};var c=function(M,O){var P=b;if(!M||!O){return P}if(M.indexOf("_")!==-1){var N=M.split("_");switch(N[0]){case"MouseMode":P="";if(O.Mode){P+="<b>"+O.Mode+"</b>"}if(O["Mode"+N[1]]){P+=" "+O["Mode"+N[1]]}break}}return P};this.showButtonToolTip=function(N,O){var M;if(O){M=O.getAttribute("fsi-tool-tip");if(j.iConfig.makeBool(M,true)===false){return}}if(M==b){M=N.getCMD()}if(typeof(r[M])==="string"){M=r[M]}h.showToolTip(M,O)};this.getButtonDomElement=function(N){var M=m[N];if(M){return M.elButton}};this.showToolTip=function(O,N,M,P){if(!J||!D){return}J.show(O,N,M,P,c)};this.hideToolTip=function(){if(!J||!D){return}J.hide()};this.setEnabled=function(M,N){if(h.bEnabled===M){return}h.bEnabled=M;if(N){return}if(M){a.removeClass(h.sprite.element,"fsi-ui-menu-bar-disabled")}else{a.addClass(h.sprite.element,"fsi-ui-menu-bar-disabled")}t("onMenuEnabled",[M])};this.getButtonEnabled=function(N){var M=m[N];if(M===b){return}return M.bEnabled};this.showButton=function(O,M){var N=m[O];if(N===b){return false}return N.show(M)};this.enableButton=function(O,M){var N=m[O];if(N===b){return false}return N.setEnabled(M)};this.getButtonPressed=function(N){var M=m[N];if(M===b){return false}return M.getPressed()};this.setButtonPressed=function(O,M){var N=m[O];if(N===b){return false}N.setPressed(M);return true};var H=function(N,O){var M;if(B[O]===b){M=B[O]={};M.arButtons=[]}else{M=B[O]}M.arButtons.push(N);N.oGroup=M;N.makeRadioButton()};this.removeButtons=function(){var M;h.unregisterExternalButtons();for(M=0;M<C.length;M++){C[M].destroy()}C=[];B={};m={}};this.unregisterExternalButtons=function(){for(var O in K){var M=K[O];for(var N=0;N<M.length;N++){M[N].destroy(true)}}K={}};this.addButtons=function(X,ab){h.removeButtons();var P;var Y=f-6;var R,ac;var Q,Z,S;var N="";if(typeof(ab)==="string"&&ab.length>0){N=" (sorted by parameter MenuButtonOrder)";var M=ab.split(",");var V={};for(Z=0;Z<X.length;Z++){if(typeof(X[Z].cmd)==="string"){V[X[Z].cmd.toLowerCase()]=Z}}var U=[];var aa={};for(Z=0;Z<M.length;Z++){S=a.trim(M[Z].toLowerCase());if(V[S]!==b){if(aa[S]===b){aa[S]=true;U.push(X[V[S]])}}}for(Z=0;Z<X.length;Z++){if(typeof(X[Z].cmd)==="string"){S=X[Z].cmd.toLowerCase();if(!aa[S]){U.push(X[Z])}}}X=U}else{N=" (default)"}if(!x){x=new a.Sprite(h.sprite.element,A.width,f,2);a.setStyleAttr(x.element,"position:relative");a.addClass(x.element,"fsi-ui-button-container")}var ad;if(v.on){ad=[]}for(Z=0;Z<X.length;Z++){P=X[Z];if(P.cmd){if(v.on){ad.push(P.cmd)}if(P.width===b){R=Y}else{R=P.width}if(P.height===b){ac=Y}else{ac=P.height}Q=new a.MenuBarButton(h,x.element,P,P.bCheckButton);m[P.cmd]=Q;C.push(Q);if(P.groupID!==b){H(Q,P.groupID)}}if(typeof(P.fnCreate)==="function"){P.fnCreate.apply(P.fnCreateInstance,[Q,P])}if(P.enabled===false){h.enableButton(P.cmd,false)}}if(v.on){v.log("Button sequence"+N+": "+ad.join(","))}w();var O=q.run("onRegisterExternalMenuButtons");if(O){h.registerExternalButtonsFromContainer(O)}var T=j.iConfig;if(typeof(T.cfg.externalbuttoncontainer)!=="undefined"){h.registerExternalButtonsFromContainer(T.cfg.externalbuttoncontainer)}t("onMenuReady",[h]);for(var W in B){B[W].arButtons[0].setPressed(true)}};this.createHiddenButton=function(N,P){if(m[N]!==b){return m[N]}var M={cmd:N,bCheckButton:P};var O=new a.MenuBarButton(h,b,M,M.bCheckButton);O.bUserButton=true;m[M.cmd]=O;C.push(O);return O};this.setCallbacks=function(M){q=M};var t=this.callListeners=function(N,M){if(q){q.run(N,M)}};this.setContainerSize=function(M){var N=h.sprite.element.style.display;h.sprite.element.style.display="block";var O=a.getElementClientDim(h.sprite.element);f=O.height;h.sprite.updateDimension();A=M;h.sprite.setSize("100%",f);h.sprite.element.style.display=N;w();h.sprite.show(true)};var w=function(){if(!g){return}g.style.display="";if(g.firstChild!==b&&g.firstChild.offsetWidth>0&&x!==b){var M=(h.sprite.element.offsetWidth-x.element.offsetWidth)/2;if(M-8<g.firstChild.offsetWidth){g.style.display="none"}}};this.setPressedExternalButtons=function(P,N){if(K[P]!==b){var M=K[P];for(var O=0;O<M.length;O++){M[O].setPressed(N)}}};this.enableExternalButtons=function(P,N){if(K[P]!==b){var M=K[P];for(var O=0;O<M.length;O++){M[O].setEnabled(N)}}};this.setExternalButtonState=function(P,O,Q){if(K[P]!==b){var M=K[P];for(var N=0;N<M.length;N++){M[N].setState(O,Q)}}};this.removeExternalButton=function(O,P){var M=K[O];if(M!==b){for(var N=0;N<M.length;N++){if(M[N].nExternalButtonID===P){M.splice(N,1)}}}};L.getMenuButtonPresent=function(N){var M=h.getButtonByCMD(N);return(M!==b&&M.bUserButton!==true)};L.registerExternalMenuButtonsFromContainer=this.registerExternalButtonsFromContainer=function(R){if(typeof(R)==="string"){R=document.getElementById(R)}v.groupCollapsed("Registering external buttons from container: ");v.log(R);if(R&&typeof(R.querySelectorAll)==="function"){var P=R.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var N=0;N<P.length;N++){var O=P[N];var Q=O.getAttribute("fsi-cmd");var M=O.getAttribute("fsi-tool-tip");if((Q&&Q.length>0)||M&&M.length>0){h.registerExternalButton(P[N],Q)}}}v.groupEnd()};L.unregisterExternalMenuButtonsFromContainer=this.unregisterExternalButtonsFromContainer=function(R){if(typeof(R)==="string"){R=document.getElementById(R)}v.groupCollapsed("Unregistering external buttons from container: ");v.log(R);if(R&&typeof(R.querySelectorAll)==="function"){var P=R.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var N=0;N<P.length;N++){var O=P[N];var Q=O.getAttribute("fsi-cmd");var M=O.getAttribute("fsi-tool-tip");if((Q&&Q.length>0)||M&&M.length>0){h.unregisterExternalButton(P[N],Q)}}}v.groupEnd()};L.registerExternalMenuButton=this.registerExternalButton=function(N,Q,M){var O=Q;if(typeof(O)!=="string"||O.length<1){O="user_tool_tip_only"}if(typeof(N)==="string"){N=document.getElementById(N)}if(!N||N.style===b){return false}if(N.FSIExternalButton!==b){if(v.on){v.error("The dom element has already been registered as external button for command '"+N.FSIExternalButton.getCMD()+"'.")}return false}var P=new a.MenuBarExternalButton(h,j,N,O);if(!P.init()){v.error("The dom element could not be registered as external button for command '"+O+"'.",N);P.destroy();return false}if(P.bUserButton){v.log("Registering external button for user command: "+O,N)}else{v.log("Registering external button for command: "+O,N)}N.FSIExternalButton=P;if(K[O]===b){K[O]=[]}K[O].push(P);if(q.isset("onAfterRegisterExternalButton")){q.run("onAfterRegisterExternalButton",[N,Q,(P.bUserButton!==true)])}};L.unregisterExternalMenuButton=this.unregisterExternalButton=function(N){if(typeof(N)==="string"){N=document.getElementById(N)}if(!N||N.style===b||typeof(N.FSIExternalButton)!=="object"||typeof(N.FSIExternalButton.destroy)!=="function"){return false}var M=N.FSIExternalButton;if(v.on){v.log("Unregistering external button for command: "+M.getCMD(),N)}N.FSIExternalButton.destroy();N.FSIExternalButton=b;return true};this.getButtonByCMD=function(M){return m[M]};F()};a.MenuBarExternalButton=function(i,e,c,g){var k=this;var h=i;var f="";var j;var d;this.init=function(){if(c.style===b){return false}k.nExternalButtonID=i.getExternalButtonID();d=i.getButtonByCMD(g);if(d===b){d=h.createHiddenButton(g,e.iConfig.makeBool(c.getAttribute("fsi-check-button")))}if(d===b){return false}k.bUserButton=d.bUserButton;f=a.trim(c.className);if(f.length>0){f+=" "}d.addEvents(c);k.setState(d.getState(),d.getCSSClass());k.setEnabled(d.getEnabled());k.setPressed(d.getIsPressed());c.setAttribute("fsi-registered","true");return true};this.getCMD=function(){return g};this.setPressed=function(l){if(l){c.setAttribute("checked","checked")}else{c.removeAttribute("checked")}};this.setEnabled=function(l){if(l){c.removeAttribute("disabled");a.removeClass(c,"fsi-ui-button-disabled")}else{c.setAttribute("disabled","disabled");a.addClass(c,"fsi-ui-button-disabled")}};this.setState=function(l,m){j=l;c.className=f+m};this.destroy=function(l){if(c.FSIExternalButton){d.removeEvents(c);c.FSIExternalButton=b;c.removeAttribute("fsi-registered");if(d){c.className=a.trim(f)}if(!l){h.removeExternalButton(g,k.nExternalButtonID)}}}};a.MenuBarButton=function(u,f,i,h){var q=this;var v=i.cmd;var k=u;var C;this.bEnabled=true;this.id=k.btnID++;var m=false;var B;var c;var l="";var e=true;var d;var y;var x="";var A,r;var g;var j={passive:false,capture:false};var w=function(){B=q.elButton=document.createElement("div");a.addClass(B,"fsi-ui-button");c=document.createElement("div");a.addClass(c,k.iconClassNamesNormal);B.appendChild(c);if(f){f.appendChild(B)}if(v.length>0){l=v.replace(/#.*$/,"")}else{l=""}B.className="fsi-ui-button "+l;if(!i.bNoMouseEvents){q.addEvents(B)}s(1)};var t=function(D){D.cancelBubble=true;if(D.stopPropagation){D.stopPropagation()}if(D.preventDefault){D.preventDefault()}return false};this.addEvents=function(D){a.addEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.addEvent(D,"mousedown",q.onMouseDown,j);a.addEvent(D,"mouseleave",q.onMouseOut,j);a.addEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.addEvent(D,"touchstart",q.onTouchDown,j);a.addEvent(D,"touchcancel",q.onTouchUp,j);a.addEvent(D,"touchend",q.onTouchUp,j)}};this.removeEvents=function(D){a.removeEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.removeEvent(D,"mousedown",q.onMouseDown,j);a.removeEvent(D,"mouseleave",q.onMouseOut,j);a.removeEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.removeEvent(D,"touchstart",q.onTouchDown,j);a.removeEvent(D,"touchcancel",q.onTouchUp,j);a.removeEvent(D,"touchend",q.onTouchUp,j)}};this.destroy=function(){if(!i.bNoMouseEvents){q.removeEvents(B)}if(f){a.removeChild(f,B)}};this.getCMD=function(){return v};this.makeCheckButton=function(){h=true};this.makeRadioButton=function(){h=true;m=true};this.getState=function(){return C};this.getCSSClass=function(){return B.className};var s=this.setState=function(E){if(C===E){return}if(h){var D=(E>2);if(D!==y){y=D;z("onMenuButtonSetPressed",null,D)}}o(E)};var o=this.setState=function(F){if(F===C){return}C=F;var G="";if(!q.bEnabled){G="fsi-ui-button-disabled "}switch(C){case 2:G+="fsi-ui-button-hover";break;case 3:G+="fsi-ui-button-active";break;case 4:G+="fsi-ui-button-active";if(q.oGroup!==b){for(var E=0;E<q.oGroup.arButtons.length;E++){var D=q.oGroup.arButtons[E];if(D.id!==q.id){D.setPressed(false)}}}break;default:break}if(G!==x){if(x.length>0){a.removeClass(B,x)}if(G.length>0){a.addClass(B,G)}x=G}k.setExternalButtonState(v,C,B.className)};this.onMouseOver=function(D){A=true;var E=D.target;if(a.hasClass(E,"fsi-ui-button-icon")&&E.parentNode){E=E.parentNode}k.showButtonToolTip(q,E);if(!q.bEnabled||!k.bEnabled){return}if(C===1){s(2)}};this.onMouseOut=function(D){A=false;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}if(r){return}if(C!==1&&C!==4){s(1)}};this.onMouseDown=function(D){if(D&&D.type==="mousedown"){if(D.preventDefault){D.preventDefault()}if(D.which!==1){return true}}r=true;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}a.addEvent(window,"mouseup",q.onMouseUp);g=true;if(h){if(C===4){if(!m){s(3)}}else{s(4)}}else{s(3)}p(D)};this.show=function(D){if(e===D){return}e=D;q.elButton.style.display=(D)?"":"none"};this.onTouchDown=function(D){if(A){q.onMouseOut(D)}if(r){q.onMouseUp(D)}q.onMouseDown(D)};this.onTouchUp=function(D){if(A){k.hideToolTip();A=false}q.onMouseUp(D);if(D.preventDefault){D.preventDefault()}};this.onMouseUp=function(E){if(g){a.removeEvent(window,"mouseup",q.onMouseUp);g=false}var F=(E&&E.type==="touchend");if(!F&&!r){return}r=false;if(!q.bEnabled||!k.bEnabled){return}if(!F&&!A&&h&&!m){if(C===4){s(1)}else{s(4)}}var D=(!A)?1:2;if(h){if(C===3){s(D)}}else{s(D)}n(E);if(F||A){u.oInterface.clickMenuButton(v,E);z("onMenuButtonClicked",E)}};this.getEnabled=function(){return q.bEnabled};this.setEnabled=function(D){if(q.bEnabled===D){return}if(!D&&d){n()}if(!D&&(C===1||!h)){q.setState(1)}if(D){a.removeClass(B,"fsi-ui-button-disabled")}else{a.addClass(B,"fsi-ui-button-disabled")}q.bEnabled=D;k.enableExternalButtons(v,D);z("onMenuButtonEnabled",null,D);return true};this.getPressed=function(){return(C>2)};this.getIsPressed=function(){return(h&&q.getPressed())};this.setPressed=function(D){if(!h){return}if(D){s(4)}else{s(1)}k.setPressedExternalButtons(v,D)};var p=function(D){d=true;z("onMenuButtonPressed",D);u.oInterface.pressMenuButton(v,D)};var n=function(D){d=false;z("onMenuButtonReleased",D);u.oInterface.releaseMenuButton(v,D)};var z=function(F,D){var E=[v,D];if(arguments.length>2){E=E.concat(Array.prototype.slice.call(arguments,2))}k.callListeners(F,E)};w()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a._API_Viewer!=b){return}a._API_Viewer=function(d,e){var c=this;c.scriptMainFile="FSI.Viewer.js";c.getActiveMenuButtons=function(){if(e.arMenuButtons==b){return b}var f={};for(var g=0;g<e.arMenuButtons.length;g++){var h=e.arMenuButtons[g].cmd;if(h!=b){f[h]=true}}return f};c.oMenuCommands={Reset:1,ZoomOut:1,ZoomIn:1,MouseMode_0:"MouseMode_0",MouseMode_1:"MouseMode_1",MouseMode_2:"MouseMode_2",MaxZoom:1,HotSpots:"Hotspots",ToggleAutoSpin:"autospin-button-toggle",ToggleFullScreen:"FullScreen"};c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeImage:{a:"oParameters, strViewString",r:"bSuccess"},clickMenuButton:{a:"strButtonID"},debugEnabled:{r:"bEnabled"},debugError:{a:"mixed"},debugLog:{a:"mixed"},debugWarn:{a:"mixed"},destroy:{},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getHotspotViewString:{a:"nHotspotID",r:"strViewString"},getImageIsTransparent:{r:"bTransparent"},getInFullScreenMode:{r:"bFullScreen"},getInitDone:{r:"bInitDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getMenuButtonPresent:{a:"strButtonID",r:"bPresent"},getMenuHeight:{a:"strPurpose",r:"nHeight"},getMouseMode:{r:"nMouseMode"},getParameters:{r:"oParameters"},getPluginParameter:{a:"strPluginName, strParameterName, defaultValue, bMakeBoolean",r:"mixed"},getSkinClassName:{r:"strClassName"},getSpinFrames:{r:"nFrames"},getSrcDim:{r:"oDimension"},getVersion:{r:"strVersion"},getViewString:{r:"strViewString"},getZoom:{r:"fZoomInPercent"},gotoHotspot:{a:"FSIHotspotID, bAnimate",r:"bSuccess"},gotoViewString:{a:"strView, bAnimated",r:"bSuccess"},hideMenuToolTip:{},init:{a:"elementID, oParameters, bDebug"},makeBoolean:{a:"value, bDefaultValue",r:"bResult"},pressMenuButton:{a:"strButtonID"},printAPI:{},registerExternalMenuButton:{a:"elButton, strButtonID, strTip"},registerExternalMenuButtonsFromContainer:{a:"elContainer"},releaseMenuButton:{a:"strButtonID"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},resetView:{},setFullScreenElement:{a:"elFullScreenContainer",r:"bSuccess"},setMouseMode:{a:"nMode"},setZoom:{a:"fZoomPercent, bPreliminary, bAnimate"},showAboutWindow:{},showMenuButton:{a:"strButtonID, bShow"},showMenuToolTip:{a:"strTip, elSrc, x, y"},spinToDegree:{a:"fDegree"},spinToTarget:{a:"nTargetFrame, nStopSceneSet, nFrames"},start:{},startAutoSpin:{r:"bSuccess"},stopAutoSpin:{r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unregisterExternalMenuButton:{a:"elButton"},unregisterExternalMenuButtonsFromContainer:{a:"elContainer"},updateSize:{}};c.oProperties={};c.oCallbacks={onAfterRegisterExternalButton:{a:"elButton, strButtonID, bButtonPresentInViewer"},onAnimationComplete:{},onAnimationStart:{},onChangeConfig:{a:"strCfgFileName, oParameters"},onChangeImage:{a:"oParameters, strView"},onConfigsReady:{a:"oConfigValues"},onDataComplete:{},onDestroy:{},onFullScreen:{a:"bSet"},onHotspotEvent:{a:"strAction, nHotspotID, strHotspotAttributeID, strContent"},onInit:{a:"oParameters)"},onInitFailed:{a:"strReason"},onInitMenu:{},onMenuButtonEnabled:{a:"strButtonID, null, bEnable"},onMenuButtonPressed:{a:"strButtonID, evt"},onMenuButtonReleased:{a:"strButtonID, evt"},onMenuButtonClicked:{a:"strButtonID, evt"},onMenuButtonSetPressed:{a:"bPressed"},onMenuDestroy:{},onMenuEnabled:{a:"bEnabled"},onMenuReady:{},onMouseModeChanged:{a:"nMouseMode"},onProgress:{a:"fPercent"},onReady:{},onRegisterExternalMenuButtons:{},onReset:{},onResize:{a:"nWidth, nHeight, bResizeDone, bFullscreen"},onSkinChanged:{a:"strCurrentSkinClass, strCurrentSkinClassBefore"},onStartDragging:{a:"bInNavWindow"},onStopDragging:{a:"bInNavWindow"},onViewChanged:{a:"strViewString"},onZoomChanged:{a:"fScale, fScaleMax"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Viewer!=b){return}a.Viewer=function(gd,ef){var gG={};var ax={strVersion:"2018",strBuild:"18.03.23.1",strConfigSection:"Viewer",oTraceConfigParameters:ef,bHasListeners:true};var cB=new a.ClassDef(this,"FSI Viewer",ax);cB.oAPI=new a._API_Viewer(this,gG);var a9=cB.instance;a.guessFSIViewerLocation("fsiviewer.js",3);var dN=a.getViewerInstanceID();this.getInstanceID=gG.getInstanceID=function(){return dN};this.getInstanceName=function(){return cB.strClassName+" ["+M+"]"};this.debugLog=function(){ds.log.apply(ds,arguments)};this.debugWarn=function(){ds.warn.apply(ds,arguments)};this.debugError=function(){ds.error.apply(ds,arguments)};this.debugEnabled=function(){return ds.on};var gI;var fY,c6,b2;var am;var m;var c3;var em;var h;var gm={};var S;var dv;var A;var eS;var bv;var df=false;var F;var dz=0;var fu=0;var aA={};var dy,dO;var ex;var bJ;var b4;var cy;var bD,a2;var dA=false;var gV;var H;var aT;var bm={};var aK;var aI;var eK=8;var hd=1;var ac;var d=false;var fW;var b8;var bq;var cZ;var e0;var g2,cQ;var eZ;var bw=true;var gt=100;var b3=true;var ez;var bS;var ay;var cX;var gW;var dr;var eG;var r;var bl;var dK=false;var fk=new a.CroppedImage();var fj=new a.Rect();var aF=a.Easing.easeOutCubic;var eN;var eO={width:0,height:0};var bG;var T;var at={};var gH;var bt;var aP={};var cA=10000;var g8=cA;var eY;var bo;var Q;var dc;var aX={x:0,y:0,z:0};var gK;var gB;var ab;var a1=new a.Rect(0,0,-1,-1);var dG=new a.Rect(0,0,-1,-1);var fp=new a.Rect(0,0,-1,-1);var fF=new a.Rect(0,0,-1,-1);var fS=new a.Rect(0,0,-1,-1);var aJ=new a.Rect(0,0,0,0);var gx=new a.Rect(0,0,0,0);var aw=false;var R=true;var g4=!(a.isChrome);var d0=false;var bF=false;var bI=false;var cY=true;var dH=false;var z;var fa=false;var gZ;var c9=false;var gv=true;var gT=false;var fO=false;var fl;var bZ=new a.Rect(0,0,0,0);var et=0;var dh;var cJ=0;var bx=0;var ad=0;var aR;var ej=0;var d9=0;var cs=0;var dx={x:0,y:0};var W={};var bb={};var v={};var ev="auto";var ey;var fm=1;var aq;var bj;var gn=true;var aU={};var cH,cG;var ft=b;var f;var c2;var hb=false;var eB=false;var dT=true;var de=true;var gf=false;var cj=false;var e3=false;var fy;var b7;var gM;var bp=false;var gy;var ew;var bc;var e7={};var cp;var dg;var f4;var cq;var dV;var d3,dL;var Y;var d7;var eh;var dn;var g7;var e=[];var gR=[];var dB;var dI={};var cu={};var f8;var d5=false;var g6;var by,dk;var dM;var e2={};var M;var dC;var V;var gX={};var ah;var ba=gG.viewport={};var dw=a.SVGNameSpaceURL;var fJ="1.1";var bs;var gS;var ao;var cd=1;var aD;var cf;var e1;var fo=0;var eX=1;var an=2;var fX=fo;var gc;var i=false;var aZ;var bR;var fN;var g0;var aG=false;var fD=false;var ge;var eI=1;var b0={};var E=false;var K;var f0;var gp;var fs;var cP={width:0,height:0};var b1=false;var aE=false;var d4;var cg="&limit=0,360";var eT;var gJ=false;var gD;var w;var fU={};var fn=false;var bV;var cl="&effects=Matte(FFFFFF)";var c;var al;var au;var cV={};var bk=true;var f2;var cN;var fH;var dF;var bA=0;var ct=0;var bC={};var cK=false;var eR=true;var G;var ff={};var ak=0;var aW={};var cL={};var f9;var d8={};var ds=new a.EmptyDebugger();var g1=function(he,o){if(o&&!ds.on&&he.on){f8.stopPendingRequests();a9.destroy(true);a9.init(f9,d8,true);a9.start();return true}ds=he;if(cy){cy.setDebug(ds)}if(ds.on){ds.setPrefix(a9.getInstanceName())}};var f3=gG;f3.iViewer=a9;f3.getDebug=function(){return ds};f3.getToolTip=function(){return fH};f3.getElementSpace=function(){return ah};f3.getDrawRatio=function(){return W};f3.getdrawRatioUnZoomed=function(){return bb};f3.getdrawRatioUnResized=function(){return v};f3.getinPlaceZoom=function(){return b0};f3.getRootContainer=function(){return gI};f3.getParentElement=function(){return am};f3.getCallbacks=function(){return cy};f3.getIsFullScreen=function(){return d5};f3.getImageArray=function(){return gR};this.init=function(he,hh,o){if(gf){a9.destroy()}f9=he;if(typeof(he)=="object"){if(typeof(he.id)=="string"){M=he.id}}else{if(typeof(he)=="string"){M=he}}if(!M){M="fsi.viewer #"+dN}if(a9._fsi_parameters){hh=a9._fsi_parameters;delete a9._fsi_parameters;a9._fsi_parameters=b}if(a.isMobileDevice){gc=5000000}else{gc=8000000}aK=new a.IMGLoadingEngine(a9,eV);var hf;if(typeof(he)=="object"&&he.tagName!=b){hf=he}else{hf=document.getElementById(he)}if(typeof(hh)=="object"&&typeof(window[hh.oninit])=="function"){window[hh.oninit](a9,M,hh)}d8=(hh&&typeof(hh)=="object")?a.cloneParameters(hh):{};gk();var hg=d8;if(o){hg=a.cloneObject(d8);hg.debug=true}f8.init(hg);if(ds.on){ds.log(a9.getVersion())}y();if(!hf){ds.error("A DOM element with the id '"+he+"' could not be found. Aborting.");return}bs="1.5px";if(a.isSmallMobileDevice){ds.log("Small mobile Device detected.");b1="fsi-ui-hotspot-mobile fsi-ui-hotspot-mobile-small";bs="4px"}else{if(a.isMobileDevice){ds.log("Mobile Device detected.");b1="fsi-ui-hotspot-mobile"}}if(hf.firstChild!=b){hf.innerHTML=""}am=hf;if(am.tagName.toLowerCase()!="fsi-viewer"){a.addClass(am,"fsi-viewer")}am.setAttribute("x-fsi-id",M);e1=(a.isMobileDevice)?0.2:0.15;if(!gI){gI=document.createElement("div");gI.className="fsi-root fsi-viewer-root";a.setStyleAttr(gI,"position:relative;left:0px;top:0px;padding:0px;margin:0px;border:0px none;z-index:0;width:100%;height:100%;text-align:left;vertical-align:top;");hf.appendChild(gI)}af();dq(true);if(ds.on){ds.log("Container element: "+ah.width+" x "+ah.height+" ("+hf.nodeName+")")}gf=true;bl=a.getCSSTransformStyleName();ez=false};var gk=function(){var o={};o.onConfigsReady=dX;o.onDebuggerChange=g1;f8=gG.iConfig=new a.Config(null,o,{strSection:cB.strConfigSection});f8.setEffectsFilterArea();a9.loadFile=f8.loadFile;if(aT){f8.setAccessToken(aT)}if(!cy){cy=gG.iCallbacks=new a.Callbacks(a9,f8)}else{cy.setConfig(f8)}};this.getInitDone=function(){return gf};gG.getViewportSize=function(){return ba};var af=function(){var o=a.getBoundingClientRect(gI);ah={width:o.width,height:o.height};var he=(gm&&gm.minInstanceSize>1)?gm.minInstanceSize:60;if(ah.width<he||ah.height-ct<he){ah.visible=false;ah.width=he;ah.height=he+ct}else{ah.visible=true}ba.width=ah.width;ba.height=ah.height-ct};var bU=function(o){if(bV==o){return}if(g0){if(bV!=b){a.removeClass(g0,"fsi-ui-cursor-"+bV)}if(o!=b){a.addClass(g0,"fsi-ui-cursor-"+o)}}bV=o};var fz=function(hk,hj,hm,hi,o){var hg=ba.width*at.scale;var he=ba.height*at.scale;if(hk==b){hk=hg/2}if(hj==b){hj=he/2}var hf;if(hm!=b){hf=Math.max(1,Math.min(b0.maxScale,b0.scale+hm))}else{hf=b0.defaultZoom}var hl=hf/b0.scale;hk=hl*(b0.panPos.left-(hk-hg/2));hj=hl*(b0.panPos.top-(hj-he/2));var hh=(hi)?0:o;eJ(hk,hj,hf,hh)};var gg=function(o,hh,hf,he){if(!b0.enabled){return}if(b0.panPos.left==0&&b0.panPos.top==0&&(gS<=1||(Q&&b0.targetZoom==1))){return}var hg=(hf)?0:he;eJ(0,0,1,hg)};var eC=function(o){if(at.scale>1){o.scaleRect(1/at.scale)}var hn=o.width();var hi=o.height();if(hn<1||hi<1){return}var hj=hn/hi;var hh=ba.width/ba.height;if(hj>hh){hi=hn*ba.height/ba.width;o.inflateRect(0,hi-o.height())}else{if(hj<hh){hn=hi*ba.width/ba.height;o.inflateRect(hn-o.width(),0)}}var he=gS*ba.width/hn;he=Math.max(1,Math.min(b0.maxScale,he));var hm=he/gS;var hg=o.left+o.width()/2;var hf=o.top+o.height()/2;var hl=(b0.panPos.left-hg+ba.width/2)*hm;var hk=(b0.panPos.top-hf+ba.height/2)*hm;eJ(hl*at.scale,hk*at.scale,he)};var eJ=function(o,hh,hg,he){hg=Math.max(1,Math.min(b0.maxScale,hg));er();b0.pos=0;b0.frames=(he!=b)?he:28;if(b0.frames<1){b0.frames=1}b0.sourceZoom=b0.scale;b0.sourceX=b0.panPos.left;b0.sourceY=b0.panPos.top;if(o==b){o=b0.sourceX}if(hh==b){hh=b0.sourceY}var hf=gQ(o,hh,hg);b0.targetX=hf.x;b0.targetY=hf.y;b0.targetZoom=hg;b0.dX=hf.x-b0.sourceX;b0.dY=hf.y-b0.sourceY;b0.dZoom=hg-b0.sourceZoom;bd()};var x=gG.stopAfterTouch=function(){if(G){G.cancelAfterTouch()}};var aM=gG.autoShowHideHotSpots=function(o){if(de==o){return}de=o;if(!eB||!a.isMobileDevice){return}dT=o;fT(o);dE();if(o){gY()}};var bd=function(){if(Q){return}dk=false;b0.lockPanAnimation=false;E=true;aM(false);Q=true;cy.run("onAnimationStart");gY()};var er=gG.stopDesktopAnimation=function(){if(Q){aM(true);E=false;Q=false;b0.pos=b0.frames=0;b0.targetZoom=b;bY();dQ();fI();cS()}};var cc=function(){if(Q||hb){return}cy.run("onAnimationComplete")};var fq=function(){b0.pos++;fV(aF(b0.pos,b0.frames,b0.sourceZoom,b0.dZoom,3));if(!b0.lockPanAnimation){b0.panPos.left=aF(b0.pos,b0.frames,b0.sourceX,b0.dX,3);b0.panPos.top=aF(b0.pos,b0.frames,b0.sourceY,b0.dY,3)}bY();if(b0.pos===b0.frames){er();cc();if(dk){fx()}return false}return true};var eM=gG.onAfterinPlaceZoomChanged=function(){bY();dQ();fI()};this.getMouseMode=function(){return ev};var e6=this.setMouseMode=function(o){if(G){G.cancel()}ev=o;switch(o){case"auto":if(w){o=(b0.bZoomedIn)?1:0}else{o=(b0.bAutoMouseModePan)?1:2}break;case 0:case 1:break;case 2:if(w){o=(b0.bZoomedIn)?1:0}else{o=2}break}cI(o)};var cI=function(o){ey=o;switch(ey){case 0:bU("zoom");break;case 1:bU("pan");break;case 2:if(aW.nSceneSets>1){bU("rotate3d")}else{bU("rotate")}break}cy.runPersistent("onMouseModeChanged",[ey]);if(cN){cN.setButtonPressed("MouseMode_"+ey,true)}};var fI=function(){if(!b0.enabled||ev!="auto"){return}var o=(b0.scale>1);if(b0.bZoomedIn==o){return}b0.bZoomedIn=o;if(o){b0.bAutoMouseModePan=true;cI(1)}else{b0.bAutoMouseModePan=false;if(w){cI(0)}else{cI(2)}}};var gQ=function(o,hk,hj){var hh={x:o,y:hk};var hi=Math.round(bb.imageWidth*hj);var hf=Math.round(bb.imageHeight*hj);var hg=Math.max(0,(hi-W.maxPanReferenceWidth)/2);var he=Math.max(0,(hf-W.maxPanReferenceHeight)/2);hh.x=Math.max(-hg,Math.min(hg,o));hh.y=Math.max(-he,Math.min(he,hk));return hh};this.getZoom=function(){return gS/b0.maxScale*100};this.setZoom=function(hf,o,he){if(!cj||!b0.enabled){return false}az(true);er();hf=hf*b0.maxScale/100;if(he){eJ(b,b,hf);return}else{fV(hf)}bY(o);if(!o){dQ();fI()}return true};this.gotoHotspot=function(hf,he){if(!cj){return false}az();if(he!==false){he=true}var o=a9.getHotspotViewString(hf);if(o===false){return false}gN(o,he);return true};this.getHotspotViewString=function(o){if(!cj||ex[o]==b){return false}return fb(ex[o],true,true)};var fb=function(hn,hx,hm){if(typeof(hn)!="object"){return false}if(hm==b){hm=hn.rotateOnFocus}if(hx==b){hx=hn.zoomOnFocus}var hG;var ho;var o=(aW.nCurrent==b)?0:aW.nCurrent;var ht=o+1;var hz=Math.round(et/(ej/bx));var hE=1+hz;var hr=false;var hy=false;var hH=false;var hk=d9;var hs;var hl=false;if(hm){if(hn._focusSceneSet!=b){hl=true;if(hn._focusSceneSet!==false){ht=hn._focusSceneSet}}else{if(aW.nSceneSets==b||aW.nSceneSets<2||hn.perimeterAngleX==b){hn._focusSceneSet=false}else{var hF=cC();var hA=hF.angle;var hj=Math.abs(hF.stepAngle);hs=(hn.focusAngleX!=b)?hn.focusAngleX:hn.perimeterAngleX;if(typeof(hs)=="number"){var hI=hs-hA;if(!isNaN(hI)){while(hI<0){hI+=360}while(hI>360){hI-=360}var hi=Math.round(hI/hj);hi=Math.max(0,Math.min(aW.nSceneSets,hi))+1;if(hi!=ht){ht=hi;if(hx){hy=et;hH=hr=true;fG(ht-1)}}}hn._focusSceneSet=false}else{hn._focusSceneSet=false}hn._focusSceneSet=ht}}if(hn._focusScene!=b){hl=true;if(hn._focusScene!==false){hE=hn._focusScene}}else{hs=(hn.focusAngleY!=b)?hn.focusAngleY:hn.perimeterAngleY;if(typeof(hs)=="number"){var hu=g6(Math.round(hs/360*bx))+1;hy=g6(Math.round(hs/360*ej));if(!isNaN(hu)){if(hx){if(hy!=et){hr=true}}hn._focusScene=hE=hu;hn._focusSpinPos=hy}else{hn._focusScene=false}}else{hn._focusScene=false}}}var hq=(hm&&typeof(hn._focusScene)=="number"&&typeof(hn._focusSceneSet)=="number");if(hx&&hm&&hl&&!hq){if(hn._focusSceneSet!==false&&hn._focusSceneSet!=ht){hy=et;hH=hr=true;fG(hn._focusSceneSet-1)}if(hn._focusScene!==false&&hn._focusScene!=hz){hy=hn._focusSpinPos;hr=true}}if(hr){b9(hy);eo()}if(hx==true){if(hq&&hn._focusZoom!=b){ho=hn._focusZoom}else{var hp=new THREE.Vector3();dI.camera.setViewOffset(ba.width,ba.height,0,0,ba.width,ba.height);if(hr){dI.renderer.render(dI.scene,dI.camera)}hp.setFromMatrixPosition(hn.object.matrixWorld);hp.project(dI.camera);var hD=0.5;var he=0.5;var hC=bb.imageWidth/ba.width;var hB=bb.imageHeight/ba.height;var hg=hp.x/hC*hD+hD;var hf=he-hp.y/hB*he;gT=true;var hv=new a.Rect(hg,hf,hg,hf);if(typeof(hn.focusRadius)=="number"&&hn.focusRadius>0){hv.inflateRect(hn.focusRadius,hn.focusRadius)}ho=hv.toString();if(hq){hn._focusZoom=ho}}}if(hH){fG(o)}if(hr){b9(hk);eo();gY()}hG=ht+","+hE;if(ho!=b){hG+=","+ho}return hG};var cr=this.getViewString=function(){if(!au){return b}var hg=[];var hk=aW.nCurrent+1;var hh=1+Math.round(et/(ej/bx));if(isNaN(hh)){hh=1}var hi=W.imageWidth;var hf=hi/au.width*au.height;var hl=hd/gS;var hj=0.5-b0.panPos.left/hi-hl/2;var he=0.5-b0.panPos.top/hf-hl/2;var o=new a.Rect(hj,he,hj+hl,he+hl);o.round();hg.push(hk);hg.push(hh);hg.push(o.toString());hg.push(0);return hg.join(",")};var eE=function(hf,he){var o=parseFloat(hf);if(isNaN(o)){o=he}return o};var cE=function(hf){if(typeof(hf)!="string"){hf=""}var o=[1,1,0,0,1,1,0];hf=hf.split(",");for(var he=hf.length;he<7;he++){hf.push(o[he])}return hf.join(",")};var en=function(hj){var hi={SceneSet:0,scene:0,frame:0};if(hj==b||typeof(hj)!="string"||hj.length<3){return hi}var hl=hj.split(",");if(hl.length<2){return hi}if(aW.nSceneSets<2){hi.SceneSet=0}else{hi.SceneSet=parseInt(hl[0])-1;if(isNaN(hi.SceneSet)){hi.SceneSet=b}}hi.scene=parseInt(hl[1]);if(isNaN(hi.scene)){hi.scene=1}hi.scene=hi.scene%bx-1;if(hi.scene<0){hi.scene+=bx}hi.frame=hi.scene*ej/bx;if(hl.length>5){var ho=eE(hl[2],0);var hf=eE(hl[3],0);var hn=eE(hl[4],1);var hg=eE(hl[5],1);var he=hi.rc=new a.Rect(ho,hf,hn,hg);he.normalizeRect();var hh=he.width();var hp=he.height();var hq=1/Math.max(hh,hp);hi.zoom=hq=Math.max(1,Math.min(b0.maxScale,hq));var hm=bb.imageWidth;var hr=bb.imageWidth/au.width*au.height;hi.x=-hm*hq*((he.left+he.width()/2)-0.5);hi.y=-hr*hq*((he.top+he.height()/2)-0.5);var hk=gQ(hi.x,hi.y,hi.zoom);hi.x=hk.x;hi.y=hk.y}return hi};var gN=this.gotoViewString=function(hf,hg){if(!cj){return false}az();var o=(hg)?30:0;var he=en(hf);if(he.scene==b){return false}var hh=en(cr());if(he.SceneSet==hh.SceneSet&&he.scene==hh.scene&&Math.abs(he.x-hh.x)<1&&Math.abs(he.y-hh.y)<1&&Math.abs(he.zoom-hh.zoom)<0.000001){if(dk){fx()}return true}if(he.SceneSet!=hh.SceneSet||he.scene!=hh.scene){a9.spinToTarget(he.frame,he.SceneSet,o)}if(b0.enabled&&he.rc!=b){eJ(he.x,he.y,he.zoom,o)}return true};this.changeImage=function(hg,hh){cy.run("onChangeImage",[hg,hh]);f8.makeObjectPropertiesLowerCase(hg);if(!e3){fy=arguments;return false}al=cr();if(ds.on){a.console.log("")}ds.log("--- changeImage() called ---");f8.stopPendingRequests();var hj=false;if(hg!=b){if(hg.fpxsrc!=b||hg.imagepath!=b){hj=true}if(hg.dir!=b){hj=true}}if(!hj){return a9.gotoViewString(hh,true)}if(hg.imagepath!=b){hg.fpxsrc=hg.imagepath;hg.imagepath=b}hg.fpxsrc=encodeURIComponent(hg.fpxsrc);var o=["imagesrc","imagepath","imagesources","imagewidth","imageheight","imagetilesx","imagetilesy","imagetransparency","images3durl"];var hf=f8.cfgAliasNames;var he=f8.cfg;for(var hi=0;hi<o.length;hi++){var hk=o[hi];delete he[hk];if(hf[hk]){delete he[hf[hk]]}}f8.setCfgValues(hg);y();c=hh;bn();f8.dumpConfig();fB();return true};var f1=function(){var o=bG;if(gS<=1){e0=1;o=aD}else{var hf=gS*v.imageWidth;var hh=Math.round(au.width/eO.width*hf);var hg;for(var he=0;he<bq.length;he++){if(bq[he]>=hh){hg=T=bq[he];break}}if(!hg){if(bq.length>0){hg=bq[bq.length-1]}if(hg<=1.1*v.imageWidth){hg=b}}if(hg){o=Math.round(hg*fk.getImageRect().width()/au.width)}e0=o/aD}return o};var fV=function(o){o=Math.max(1,Math.min(b0.maxScale,o));b0.scale=o;gS=b0.scale*at.scale;ao=Math.min(b0.maxScaleInitial,cd*b0.scale);cZ=b0.scale*cd};var fE=function(){var o=Math.min(b0.maxScaleInitial,cd);if(o*b0.scale>b0.maxScaleInitial){b0.scale=b0.maxScaleInitial/o}ao=Math.min(b0.maxScaleInitial,cd*b0.scale);return o};var Z=function(o){at.scale=o;gS=at.scale*b0.scale;ao=Math.min(b0.maxScaleInitial,cd*b0.scale);b0.scale=Math.max(1,ao/cd);cZ=cd*b0.scale};var bY=gG.updateInPlaceZoom=function(hf){if(Q){hf=true}var hg=false;if(hf){if(b0.nLastScalePreliminary!=gS){b0.nLastScalePreliminary=gS;hg=true}}else{if(b0.nLastScaleFinal!=gS){b0.nLastScaleFinal=gS;hg=true}}if(hg){if(!hf&&cG){cy.runPersistent("onZoomChanged",[gS,b0.maxScaleInitial])}if(hf&&dg&&gS-dg.renderScale<-1){fi()}W.imageWidth=gX.testWidth=Math.round(v.imageWidth*gS);W.imageHeight=Math.round(v.imageHeight*gS);W.imageX=Math.round(bb.imageX-(W.imageWidth-bb.imageWidth)/2);W.imageY=Math.round(bb.imageY-(W.imageHeight-bb.imageHeight)/2);W.maxImageOffsetX=Math.floor(Math.max(0,(W.imageWidth-W.maxPanReferenceWidth)/2-0.01));W.maxImageOffsetY=Math.floor(Math.max(0,(W.imageHeight-W.maxPanReferenceHeight)/2-0.01));if(gM){W.videoWidth=Math.round(v.videoWidth*gS);W.videoHeight=Math.round(v.videoHeight*gS);W.videoX=bb.videoX-(W.videoWidth-bb.videoWidth)/2;W.videoY=bb.videoY-(W.videoHeight-bb.videoHeight)/2}if(!hf){var o;o=(b0.scale>1);cv("ZoomOut",o);if(fX<an){cv("MouseMode_1",o)}o=(b0.scale<b0.maxScale);var he=cv("ZoomIn",o);cv("MaxZoom",eO.width!=W.imageWidth);bG=f1();cy.run("onAnimationComplete")}}if(!Q){b0.panPos.left=Math.max(-W.maxImageOffsetX,Math.min(W.maxImageOffsetX,b0.panPos.left));b0.panPos.top=Math.max(-W.maxImageOffsetY,Math.min(W.maxImageOffsetY,b0.panPos.top))}if(!hf){b0.panPos.left=Math.floor(b0.panPos.left);b0.panPos.top=Math.floor(b0.panPos.top)}gT=true;dE();z=true;gY();if(!hf){ag()}};var ag=function(){if(!cy.isset("onViewChanged")){return}if(bD!=b){clearTimeout(bD)}bD=setTimeout(bB,250)};var bB=function(){bD=b;var o=cr();if(o==a2){return}a2=o;cy.runPersistent("onViewChanged",[o])};var dQ=function(){if(!c2&&!hb){fc()}};var ce=function(){var o=a.getElementClientPos(eZ);a1.copyRect(bZ);fS.copyRect(o);a1.interSectRectValidate(fS);a1.offsetRect(-fS.left,-fS.top);var he=(a1.width()>0&&a1.height()>0);var hf=(he!=at.visible);at.visible=he;return hf};var ci=function(o){fF.copyRect(o);fF.offsetRect(-v.imageX,-v.imageY);if(bw&&fF.width()>0&&fF.height()>0){fF.inflateRect(gt/gS,gt/gS)}fF.scaleRect(e0)};var k=function(){var he;var o;he=(a1.left+a1.width()/2)-at.widthUnScaled/2;if(at.leftLast!=he){at.leftLast=he;if(he<0){he=0}if(he>at.maxLeft){he=at.maxLeft}at.left=he}at.drawOffsetX=at.scale*-at.left;o=(a1.top+a1.height()/2)-at.heightUnScaled/2;if(at.topLast!=o){at.topLast=o;if(o<0){o=0}if(o>at.maxTop){o=at.maxTop}at.top=o}at.drawOffsetY=at.scale*-at.top;if(d0){dD(at.totalWidth,at.totalHeight);gT=true;dE()}};var dD=function(hf,hh){if(dI.renderer.setSizeNeLa){dI.renderer.setSizeNeLa(hf,hh)}else{var o=f4.style.width;var hg=f4.style.height;var hi=f4.width;var he=f4.height;dI.renderer.setSize(hf,hh);f4.style.width=o;f4.style.height=hg;f4.width=hi;f4.height=he}};var s=function(he,hg){if(eY){return}var hn=cd;if(!i){l(W.widthForRatio,W.heightForRatio,true);gY();return}var hi=false;var hf=fE();cZ=b0.scale*cd;var hk=ce();if(hk){he=true}else{if(!at.visible){return}}if(!he&&dg){if((hk&&!at.visible)||(at.widthUnScaled<a1.width()||at.heightUnScaled<a1.height()-ct)||(Math.abs(hf-at.scale)>1)){if(hn>1){hn=1;he=true}}}if(!he){var hh=at.left;var hr=at.top;k();dc=(hh!=at.left||hr!=at.top);z=true;gY();return}if(hg||at.lastScale!=hf){at.lastScale=hf;Z(hf);var hj=Math.ceil(ba.width*hf);var o=Math.ceil(ba.height*hf);var hq,hp;var ho=0;if(bw){ho=gt}var hl=a.getVisualViewportSize();at.maxWidth=Math.round((hl.width*cd+ho)*hf/hn);at.maxHeight=Math.round((hl.height*cd+ho)*hf/hn);if(hj>at.maxWidth){hq=at.maxWidth}else{hq=hj}if(o>at.maxHeight){hp=at.maxHeight}else{hp=o}at.width=hq;at.height=hp;at.widthUnScaled=Math.ceil(hq/hf);at.heightUnScaled=Math.ceil(hp/hf);at.totalWidth=hj;at.totalHeight=o;hi=(hg||f4.width!=hq||f4.height!=hp)}at.maxLeft=(at.totalWidth-at.width)/at.scale;at.maxTop=(at.totalHeight-at.height)/at.scale;if(ez){if(at.scale!=1){var hm=1/at.scale;if(b3){at.strTransformScale=" scale3d("+hm+","+hm+","+hm+")"}else{at.strTransformScale=" scale("+hm+","+hm+")"}}else{at.strTransformScale=""}}else{at.strTransformScale=""}k();if(hi){if(b3){g(f4,"translate3d("+at.left+"px,"+at.top+"px,0px)"+at.strTransformScale)}else{g(f4,"translate("+at.left+"px,"+at.top+"px)"+at.strTransformScale)}if(!ez){f4.style.width=hq/hf+"px";f4.style.height=hp/hf+"px"}f4.width=hq;f4.height=hp;cq=f4.getContext("2d");g2=hj;cQ=o;l(W.widthForRatio,W.heightForRatio,true);bG=f1();if(b0.enabled){cW();bY()}}else{if(b3){g(f4,"translate3d("+at.left+"px,"+at.top+"px,0px)"+at.strTransformScale)}else{g(f4,"translate("+at.left+"px,"+at.top+"px)"+at.strTransformScale)}if(!ez){f4.style.width=f4.width/hf+"px";f4.style.height=f4.height/hf+"px"}}if(!b7){fc();z=true;gY()}else{cF()}};var g=function(o,he){o.style[bl]=he};this.showAboutWindow=function(){if(m){m.destroy();m=b;return}var o={};o.title="About FSI Viewer";o.fnOnDestroy=ha;o.strLongVersion=a9.getVersion();m=new a.AboutWindow(gI,o)};var ha=function(){m=b;return true};this.getParameters=function(){return a.cloneParameters(d8)};this.getConfigValue=function(o){if(f8&&typeof(o)==="string"){return f8.cfg[a.trim(o.toLowerCase())]}};this.makeBoolean=function(he,o){if(f8){return f8.makeBool(he,o)}};this.getPluginParameter=function(hg,hf,he,o){if(f8){return f8.getPluginParameter(hg,hf,he,o)}};this.changeConfig=function(o,he){cy.run("onChangeConfig",[o,he]);if(ds.on){a.console.log("")}al=cr();gb();if(he!=null&&typeof(he)=="object"){d8=a.cloneParameters(he)}if(typeof(o)=="string"){d8.cfg=o}gk();dA=true;gb();a9.start()};var e8=function(o,he){if(!o){return}if(!he){if(o.FSI_prevDisplayState==b){o.FSI_prevDisplayState=o.style.display}o.style.display="none"}else{if(o.FSI_prevDisplayState!=b){o.style.display=o.FSI_prevDisplayState}o.FSI_prevDisplayState=b}};var fT=function(o){if(!df){o=false}e8(V,o)};var a4=function(o){if(eF()){return}if(!eY){eY=true;g3();bo=cr();if(G){G.cancel()}e8(g0,false);fT(false);if(fH){fH.hide()}}if(o.FSI_after_treshold!=b){bT()}dq(o.FSI_after_treshold)};var dq=function(o){var he=a.getElementDimension(gI);cy.runPersistent("onResize",[he.width,he.height,(o!=b),d5])};this.updatePosition=function(){ce();z=true;gY()};this.updateSize=function(){du();gK=setTimeout(g5,0)};var du=function(){if(gK===b){return}clearTimeout(gK);gK=b};var g5=function(){du();a9.updatePosition();bT()};var bT=function(he){var hg={};hg.width=ba.width;hg.height=ba.height;var o;if(gm.keepViewOnResize){if(!bo){bo=cr()}o=bo}bo=false;eY=false;af();e8(g0,true);fT(true);if(!he&&hg.width===ba.width&&hg.height===ba.height){return}g3();ep();if(f4==b||ba.width<1||ba.height<1){return}var hf=cX;g2=ba.width;cQ=ba.height;l(W.widthForRatio,W.heightForRatio);l(W.widthForRatio,W.heightForRatio,true);fw();z=true;if(d0){dD(ba.width,ba.height);cb();dE();gT=true}eG=cX=b;fi();aH();if(f2){f2.setContainerSize(ah,W,bb)}if(cN){cN.setContainerSize(ah)}e4();bY();eL(hf);if(o){gN(o)}s(true)};var gb=function(){if(e2.nInterval!==b){clearInterval(e2.nInterval);e2.nInterval=b}du();a.FullScreen.removeChangeEvents(window,cM,aV);cy.run("onReset");if(cN){cN.unregisterExternalButtons()}if(bD){clearTimeout(bD);bD=b}a2=b;cy.removeConfigListeners();gU();if(gy){gy.remove();gy=b}g3();aA={};dW();aP={};ds=new a.EmptyDebugger();y();if(f8){f8.reset();f8.init(d8)}gm={}};var gA=function(){if(eN&&bR){eN.lockImageSourceDimension(bR,false);eN.lockImage(bR,false);eN.removeImages(bR,false)}};var cW=function(){b0.nLastScalePreliminary=b;b0.nLastScaleFinal=b};var aH=function(){cW();bG=T=b;fl=b};var gu=function(){gX={}};var ep=function(){at={};at.lastScale=b;Z(1);var o,he;if(f4){o=f4.width;he=f4.height}at.leftLast=at.topLast=b;at.width=at.widthUnScaled=at.totalWidth=o;at.height=at.heightUnScaled=at.totalHeight=he;at.left=at.top=0;at.drawOffsetX=at.drawOffsetY=0};var y=function(){du();g3();aK.abortAll();dz=0;gv=true;bz();if(G){G.cancel()}az();bN();er();fi();ai();eg();b0.panPos={left:0,top:0};b0.maxScale=b0.maxScaleInitial=1;b0.scaleToSourceImage=1;b0.scale=1;b0.pos=b0.frames=0;b0.sourceX=b0.sourceY=0;b0.targetX=b0.targetY=0;b0.sourceZoom=b0.targetZoom=1;b0.dX=b0.dY=b0.dZoom=0;b0.lockPanAnimation=false;ep();fV(1);cd=eI=1;gu();bt=b;eO={width:0,height:0};ak++;aH();dT=true;fT(false);ay=b;cX=b;eG=b;hb=false;cY=true;bI=false;if(cN){cN.setEnabled(false,true)}bp=false;c=b;cj=false;if(!i&&bR){a.removeEvent(bR,"load",dl)}cP={width:0,height:0};gA();g8=cA;fI();if(f0){clearTimeout(f0);f0=b}if(d4){clearTimeout(d4);d4=b}ei("image",true);go();e=[];if(eB){if(bJ!=b){a.removeChild(V,bJ);bJ=b}for(var o=0;o<gm.hotspots.points.length;o++){var he=gm.hotspots.points[o];if(he&&he.tooltip){if(he.interactive){a.removeEvent(he.tooltip,"mouseover",fd);a.removeEvent(he.tooltip,"mouseout",fd)}a.removeChild(he.tooltip.parentNode,he.tooltip);a.removeChild(he.marker.parentNode,he.marker)}}}b7=false;eB=false;ej=b;bc="";dB=0;aZ=b;gR=[];eg();if(cp){cp=b}e7={};d7=b};var eg=function(){if(dM){fv(dM);if(dM.parentNode){a.removeChild(dM.parentNode,dM)}dM=b}};var fv=function(hf){try{if(hf&&hf.FSIEvents){for(var hh in hf.FSIEvents){var he=hf.FSIEvents[hh];a.removeEvent(hf,hh,he.fn,he.phase)}}}catch(hg){}};this.addListener=function(hg,he,hf){var o=false;if(cy){o=cy.addListener(hg,he,hf);ca()}return o};this.removeListener=function(hf,he){var o=false;if(cy){o=cy.removeListener(hf,he);ca()}return o};var ca=function(){cH=cy.isset("onProgress");cG=cy.isset("onZoomChanged")};var el=function(o,hg){gG.onUserAction();if(!cj){return false}c8("mousedown");b4=(fU.interval!=b);az();g3();bN();if(b0.enabled){var hf=false;if(cV.timeStamp!=b&&(o.timeStamp-cV.timeStamp)<300){if(Math.abs(cV._posx-hg.x)<50&&Math.abs(cV._posy-hg.y)<50){hf=true}}if(!hf){var he=(Q)?b0.targetZoom:b0.scale;eR=(he<=1)}cV=o;cV._posx=hg.x;cV._posy=hg.y;er()}c2=true;cy.run("onStartDragging",[false]);if(eN&&ey==2&&!w){eN.lockImageSourceDimension(bR,true);eN.lockImage(bR,true)}f4.lastOffsetX=hg.x;f4.lastOffsetY=hg.y;cs=d9;dx.x=hg.x;dx.y=hg.y;switch(ey){case 0:if(b0.enabled){aJ.clientOffset=a.getElementPosition(g0);aJ.setRect(hg.x,hg.y,hg.x,hg.y);fO=true;gY()}break;case 2:e2.bEnabled=(gS>1);e2.bEnabled=true;e2.bSuspended=false;if(e2.bEnabled){e2.nTimeLastMove=e2.nTime=a.now();e2.nInterval=setInterval(fh,200)}dx.SceneSetStart=dx.SceneSetLast=aW.nCurrent;aJ.clientOffset=a.getElementPosition(g0);bW("mouseDown");break}return true};var U=function(hk,hj){var he=f4.lastOffsetX-hj.x;var o=f4.lastOffsetY-hj.y;switch(ey){case 0:if(b0.enabled){aJ.setRect(aJ.left,aJ.top,hj.x,hj.y);gY()}break;case 2:if(e2.bSuspended){e2.nTimeLastMove=e2.nTime=a.now();e2.nInterval=setInterval(fh,200);bW("mouseDown");e2.bSuspended=false}if(aW.nSceneSets<2){if(Math.abs(o)>3*Math.abs(he)){hk.FSI_allowEventDefault=true}}else{var hl=hj.y-dx.y;var hi=dx.SceneSetStart-Math.round(hl*aW.nSceneSets/ba.height);hi=X(hi);if(hi!==dx.SceneSetLast){fG(hi);dx.SceneSetLast=hi}}gP(cs-(hj.x-hk.FSI_start_x)/fm);dB=(he<0)?-1:1;e2.nTimeLastMove=e2.nTime;break;default:var hf=false;if(b0.enabled){var hh=b0.panPos.left;var hg=b0.panPos.top;b0.panPos.left-=he*at.scale;b0.panPos.top-=o*at.scale;bY();hf=(hh!=b0.panPos.left||hg!=b0.panPos.top);if(!hf){aM(true);hk.FSI_allowEventDefault=true}else{aM(false);gY()}}else{hk.FSI_allowEventDefault=true}}f4.lastOffsetX=hj.x;f4.lastOffsetY=hj.y};var fh=function(){e2.nTime+=200;if(e2.nTime-e2.nTimeLastMove>400){cD()}};var cD=function(){if(e2.nInterval!==b){clearInterval(e2.nInterval);e2.nInterval=b}e2.bSuspended=true;ga()};var fC=function(he,hi,hh){gG.onUserAction();if(!ff.bActive){aM(true)}var o=he._FSI_Canceled;var hf=he._FSI_Click;if(h){if(h.onClick(he,hi)){hf=false}}cy.run("onStopDragging",[false]);c2=false;fO=false;c8("mouseup");if(o){if(ey==2){ga("pointer up - canceled")}return}switch(ey){case 0:if(b0.enabled){gi();if(!hf&&b0.maxScale>1){eC(gx)}gY()}break;case 1:if(fX==an&&gS<=1){gg(0,0)}break;case 2:if(e2.nInterval){clearInterval(e2.nInterval);e2.nInterval=b}if(!he._FSI_fromAfterTouch){eD(b,false)}else{var hg=dd(d9,false);ec(hg,hg,1,1);ga("pointer up")}break}fI();if(hf){bQ(he,hi,hh)}};var bf=function(){return(ey==2||(ey==1&&gS>1))};var N=function(hi){if(ey==2){var hf=ej/bx;var he=hi.x-dx.x;var o=-he/fm+cs;var hh=Math.round(o/hf)*hf;var hg=-(hh-cs)*fm;hi.x=hg+dx.x}return hi};var bQ=function(he,hh){if(b4&&f8.getPluginParameter("autospin","preventClickZoomWhileSpinning",false,true)){return}if(c8("click")===true){return}if(gm.clickZoomInAllMouseModes||ey==0){if(!eR){gg(0,0)}else{if(b0.maxScale>1){var hf=a.getElementPosition(g0);var o=hh.x-hf.left;var hg=hh.y-hf.top;fz(o*at.scale,hg*at.scale)}}}};var c8=function(he){var hf=G.getInitialDownEvent();if(!hf||!hf.target||hf.target==g0){return false}var o=hf.target;while(o!=b&&o!=gI&&o.FSIHotspot==b){o=o.parentNode}if(o&&o.FSIHotspot){return fK(he,o)}return false};var f5=function(hf,he,hi,hg){for(var hh in hi){he[hh]=hf.getFloatParameter(hg+hh,hi[hh])}};var ee=function(hf,he,hi,hg){for(var hh in hi){he[hh]=hf.getIntParameter(hg+hh,hi[hh])}};var di=function(hg,hf,he,hh){for(var hi in he){hf[hi]=hg.getStringParameter(hh+hi,he[hi])}},u=function(hf,he,hh,hg){for(var hi in hh){he[hi]=hf.makeBool(hf.getStringParameter(hg+hi),hh[hi])}};var c5=function(he,o,hg,hf){var hh;if(hg&&hg.length>0){if(o[hg]==b){o[hg]={}}hf=hf[hg];hh=o[hg]}else{hh=o}if(hf.strings){di(he,hh,hf.strings,hg)}if(hf.booleans){u(he,hh,hf.booleans,hg)}if(hf.floats){f5(he,hh,hf.floats,hg)}if(hf.integers){ee(he,hh,hf.integers,hg)}};var cm=function(he){var hf={strings:{dir:"",skin:"black",language:"english",backgroundColor:"#FFF",hotspotLineColor1:"#000000",hotspotLineColor2:"#FFFFFF",hotspotDotColor1:"#58a8ff",hotspotDotColor2:"#FFFFFF",hotspotCallbackFunction:b,headers:"cors",fpxservertemplate:b,imagemattecolor:"FFFFFF",initialview:"",initialMouseMode:"auto",navWidth:"120",navHeight:"120",panLimits:"strict",inPlaceZoom:"true",documentZoom:"auto",hideUI:"false",spinDirectionImage:"right",progressBarVAlign:"bottom",progressBarHAlign:"center",MenuButtonOrder:b,urlLoadingAnimation:"/skins/resources/loading.svg"},booleans:{keepViewOnResize:true,useDevicePixelRatio:true,adaptiveUISize:true,drawCube:false,drawTable:false,drawGroundPlate:false,pellets:true,enableHotspots:true,decodeHTMLEntitiesInHotSpotTexts:false,enableZoom:true,noCanvas:false,useMaskedJPEGs:true,noNav:false,autoHideNav:true,autoDisablePointerActions:true,loadExactPreviewImagesAfterResize:false,preventImageTransparency:false,noSetLoop:false,noSceneLoop:false,initialViewPersistent:false,showPreviewWhileLoading:true,spinPreviewWhileLoading:true,showProgressbar:true,reverseSceneSets:false,autoDestroy:true,clickZoomInAllMouseModes:true},floats:{pelletsOpacity:0.15,fMouseSensitivity:1,desktopClickZoomScale:3,autoSpinSpeed:0,autoSpinInterval:0,tableDiameter:950,maxZoom:100,progressBarWidth:35,progressBarHeight:14},integers:{hotspotDotRadius:4,zoomPrecision:1,minInstanceSize:60,quality:-1},video:{strings:{skin:"black",base:"videos/",source:"",spinDirection:"right",sceneSet:0},integers:{captureFrames:120,frameOffset:0},floats:{captureOffsetStart:0,captureOffsetEnd:0,widthCorrectionFactor:1,heightCorrectionFactor:1,xCorrectionFactor:0,yCorrectionFactor:0}},camera:{strings:{position:"",targetPosition:"",armJointPosition:""},floats:{digitalCropFactor:1,focalLength:50,distanceToTableCenter:1500,heightAboveTable:500,heightTable:b,heightCamera:b,targetHeightOffset:0,targetWidthOffset:0,shiftX:0,armLength:0,armAngleMeasureSetup:0,armAngleStart:0,armAngleEnd:0}},virtualSpace:{strings:{position:""},floats:{cubeSizeX:100,cubeSizeY:100,cubeSizeZ:100,cubeLineWidth:1,baseRotationX:0,rotationXRange:180,rotationXSets:0,baseRotationY:0,rotationYRange:360,rotationYScenes:0,baseRotationZ:0,shiftX:0,shiftZ:0,shiftY:0}}};if(he==b){he={}}he.serverBase=f8.serverBase;c5(f8,he,"",hf);c5(f8,he,"camera",hf);c5(f8,he,"virtualSpace",hf);c5(f8,he,"video",hf);if(gm.enableHotspots){var o=f8.getUnrecognizedConfigNode("hotspots3d");c4(o)}cl="&effects=Matte("+encodeURIComponent(gm.imagemattecolor)+")"};var c4=function(hg){var ho={strings:{id:"",normalClass:"",hoverClass:"",activeClass:"",text:"",actionParameter:b,url:b,urlTarget:"_self",cssStyle:"",cssClass:""},booleans:{interactive:false,rotateOnFocus:true,zoomOnFocus:true,focusOnClick:true},floats:{perimeterZoom:1,perimeterImageWidth:0,perimeterAngle:b,perimeterAngleRange:30,perimeterAngleFadeOut:10,perimeterAngleX:b,perimeterAngleXRange:30,perimeterAngleXFadeOut:10,perimeterAngleY:b,perimeterAngleYRange:30,perimeterAngleYFadeOut:10,verticalMarkerSize:100,horizontalMarkerSize:30,markerAngle:45,horizontalMarkerPosition:0,verticalMarkerPosition:0.5,perimeterDistance:b,perimeterTerminator:b,x:0,y:0,z:0,focusRadius:0.25,focusAngleX:b,focusAngleY:b}};var hi=[];var hh;var hm=new a.Config();var hf,hl,hn;var hk,he,hp;if(f8.cfg.hotspots!=b&&f8.cfg.hotspots.length>0&&typeof(f8.cfg.hotspots.join)=="function"){ds.log("Using HotSpots from JS parameters");gm.hotspots={};gm.hotspots.defaults={};gm.hotspots.points=new Array(f8.cfg.hotspots.length);hf=f8.cfg.hotspotsdefaults;if(hf==b){hf=f8.cfg.hotspotdefaults}if(hf!=b){hm.makeObjectPropertiesLowerCase(hf);hm.cfg=hf;hh={};c5(hm,hh,"",ho);for(he in ho){hl=ho[he];for(hp in hl){if(hh[hp]!=b){hl[hp]=hh[hp]}}}hf=hh;hh={};for(he in hf){if(hf[he]!=b){hh[he]=hf[he]}}gm.hotspots.defaults=hh}for(hk=0;hk<f8.cfg.hotspots.length;hk++){hn=f8.cfg.hotspots[hk];hm.makeObjectPropertiesLowerCase(hn);hm.cfg=hn;hn={};c5(hm,hn,"",ho);gm.hotspots.points[hk]=hn}}else{if(!hg){return}hg=hg.firstChild;while(hg){if(hg.nodeType!=1){hg=hg.nextSibling;continue}var hj=hg.nodeName.toLowerCase();switch(hj){case"hotspot":hi.push(hg);break;case"defaults":hh=eu(hm,hg,ho);break}hg=hg.nextSibling}if(hh!=b){for(he in ho){hl=ho[he];for(hp in hl){if(hh[hp]!=b){hl[hp]=hh[hp]}}}hf=hh;hh={};for(he in hf){if(hf[he]!=b){hh[he]=hf[he]}}}if(hi.length>0){for(hk=0;hk<hi.length;hk++){hi[hk]=eu(hm,hi[hk],ho)}gm.hotspots={};gm.hotspots.points=hi;gm.hotspots.defaults=hh}}if(gm.hotspots&&gm.hotspots.points){ds.log("HotSpots parsed: "+gm.hotspots.points.length);eB=(gm.hotspots.points.length>0)}else{eB=false}};var eu=function(he,hh,hg){var o=a.attributes2parameters(hh);hh=hh.firstChild;while(hh){if(hh.nodeType!=1){hh=hh.nextSibling;continue}var hf=he.getValueFromXMLNode(hh,"");o[hf.name]=hf.value;hh=hh.nextSibling}he.cfg=o;var hi={};c5(he,hi,"",hg);return hi};var dZ=function(){cm(gm);f8.result=gm;var o=Math.PI/180;gm.virtualSpace.baseRotationXRad=gm.virtualSpace.baseRotationX*o;gm.virtualSpace.baseRotationYRad=gm.virtualSpace.baseRotationY*o;gm.virtualSpace.baseRotationZRad=gm.virtualSpace.baseRotationZ*o};var gw=function(o,hn){ds.log("Video Dimension: "+o+" x "+hn+"px");var hj=fk.isCropped();var hk=false;var he=fk.getCropMargins();var hh=au.width;var hm=hh/o;var hl=hn*hm;var hi=Math.round((au.height-hl)/2);if(hi>he.top){hk=true;he.top=hi}if(hi>he.bottom){hk=true;he.bottom=hi}if(hk){ds.log("Cropping images to match video dimension ("+hi+"px)");fk.setCropValues(he.left+"px",he.top+"px",he.right+"px",he.bottom+"px");p()}if(hj){he=fk.getCropMargins();he.scaleRectInt(1/hm);hi=Math.round(hi/hm);fj.left=he.left;fj.right=he.right;fj.top=he.top-hi;fj.bottom=he.bottom-hi}else{fj.setRect(0,0,0,0)}bt=b;bK();var hf=o-fj.left-fj.right;var hg=hn-fj.top-fj.bottom;cP={width:o,height:hn,croppedWidth:hf,croppedHeight:hg};l(hf,hg);dR();if(cq&&gm.pellets&&gm.pelletsOpacity>0){co()}};var l=function(hn,hD,hq){if(!gm||!gm.video||au===b||!gm.video.widthCorrectionFactor){return}var hv,hy;var ho;var hm;var hp,hA,hx,hh;if(!i){hx=ba.width;hh=ba.height}else{hx=g2;hh=cQ}var hE=hn/hD;var hl=hx/hh;var hk,o;if(hE>hl){hk=hx}else{o=hh}bK();hv=fk.getFloatRect();var hr=hv.getRange();var hu=a.getFSIServerImageDim(au.width,au.height,hk,o,hr,true);hp=hu.width;hA=hu.height;if(hp>eO.width||hA>eO.height){hp=eO.width;hA=eO.height}bG=Math.min(g8,Math.round(hp));ho=Math.round((hx-hp)/2);hm=Math.round((hh-hA)/2);W.widthForRatio=hn;W.heightForRatio=hD;W.imageWidth=hp;W.imageHeight=hA;W.imageX=ho;W.imageY=hm;W.videoWidth=hp*gm.video.widthCorrectionFactor;W.videoHeight=hA*gm.video.heightCorrectionFactor;W.videoX=ho+hp*gm.video.xCorrectionFactor-(hp*gm.video.widthCorrectionFactor-hp)/2;W.videoY=hm+hA*gm.video.yCorrectionFactor-(hA*gm.video.heightCorrectionFactor-hA)/2;if(!hq){aD=bG;es(v)}es(bb);if(!hq){hv=fk.getImageRect();var hw;if(hv.width()>0){hw=au.width/hv.width()}else{hw=0}var hi=Math.ceil(hw*v.imageWidth);if(au.__levelsCalculatedFor!=hi){au.__levelsCalculatedFor=hi;ds.log("Calculating image levels for image base width: "+hi+" px");ds.log("Source image dimension: "+au.width+" x "+au.height);var ht=Math.ceil(1.1*hi);bq=[];if(hi>0){if(au.levels&&au.levels.length>0){var hC=[];for(hy=0;hy<au.levels.length;hy++){var hg=parseInt(au.levels[hy].width);if(!isNaN(hg)){if(hg>ht){hC.push(hg)}else{break}}}if(ds.on){ds.log("Matching server side image levels: "+hC.join(", "))}if(hC.length>0){hC.push(hi);var hf=hC[0];bq.push(hf);for(hy=1;hy<hC.length;hy++){var hz=hC[hy];var hj=hf/hz;while(hj>2.5){hf/=2;hj=hf/hz;if(hf>ht){bq.push(Math.round(hf))}}bq.push(hz);hf=hz}bq.pop();hC.pop();bq.reverse()}if(ds.on){var hB=(bq.length-hC.length);if(hB==0){ds.log("Using server side image levels only.")}else{ds.log("Using "+hB+" additional virtual image levels.")}}}else{ds.log("No image level information from server. Using virtual image levels.");var he=au.width;var hF=au.height;if(ht>0){while(he>ht&&hF>0){bq.push(he);he=Math.round(he/2);hF=Math.round(hF/2)}}bq.reverse()}}if(ds.on){ds.log("Using image levels: "+bq.join(", "))}}bg()}switch(fX){case fo:W.maxPanReferenceWidth=ba.width*at.scale;W.maxPanReferenceHeight=ba.height*at.scale;break;case an:W.maxPanReferenceWidth=0;W.maxPanReferenceHeight=0;break;default:W.maxPanReferenceWidth=bb.imageWidth;W.maxPanReferenceHeight=bb.imageHeight;break}};var es=function(he){for(var hf in W){he[hf]=W[hf]}};var ap=function(){var o=gm.video.source;if(o&&o.indexOf("[static]")==0&&gm.serverBase!=b){var he=gm.serverBase;he=he.split("/");he.pop();he=he.join("/");o=o.replace(/\[static\]\/*/,he+"/static/")}return o};this.start=function(){c3=a.now();fu=0;ed();if(cN&&!dA){cN.destroy();cN=b}if(!gf){return}eq()};var eq=function(){gm={};f8.loadConfigs()};var dX=function(){if(a.oSupportedViewers[cB.strClassName]==b){var hk=false;try{hk=(!a.isInternetExplorer||a.versionInternetExplorer>8)}catch(hi){}a.oSupportedViewers[cB.strClassName]=hk}dZ();af();ca();var hh=[];if(typeof(f8.cfg.invisibleloadingpurposes)==="string"){hh=f8.cfg.invisibleloadingpurposes.split(",")}aK.setNotVisualPurposes(hh);if(f8.hasPlugin("autospin")){var hg=f8.getPluginParameter("autospin","speed",4);if(hg!=b){hg=parseFloat(hg);if(!isNaN(hg)){gm.autoSpinSpeed=hg}}var o=f8.getPluginParameter("autospin","interval");if(o!=b){o=parseInt(o);if(!isNaN(o)){gm.autoSpinInterval=o}}}if(f8.hasPlugin("fullscreen")&&!f8.hasPlugin("resize")){f8.addPluginFromString("resize")}var hm=gm.enableZoom;i=(a.BrowserSupports.canvas());b0.enabled=false;r=false;if(hm&&a.BrowserSupports.canvas()){var he=""+gm.inPlaceZoom;switch(he.toLowerCase()){case"auto":b0.enabled=(!a.isMobileDevice);break;default:b0.enabled=f8.makeBool(he,true);break}he=""+gm.documentZoom;switch(he.toLowerCase()){case"auto":r=(a.isTouch);break;default:r=f8.makeBool(he,true);break}}d=false;he=""+gm.hideUI;he=he.toLowerCase();if((a.isMobileDevice&&he=="onmobiledevices")||(!b0.enabled&&he=="ifnoinplacezoom")||f8.makeBool(gm.hideUI)==true){d=true}bk=(!gm.noNav&&!d&&b0.enabled);if(i){eN=b}else{eN=a._FSITouchZoomInstance}if(i&&f8.hasPlugin("resize")){if(!gJ){var hj=gD=a.addCustomEvent(gI,"FSIElementDimension",a4);a.setCustomEventListenerProperty(hj,"treshold",100);gJ=true}}else{if(gJ){a.removeCustomEvent(gI,"FSIElementDimension",a4);gJ=false}}if(gm.noCanvas){i=false}var hf=a0;var hl=f8.cfg.customskinclass;if(H&&H.paramCustomSkinClass!==hl){H.destroy()}if(hl!==b){if(!H||H.paramCustomSkinClass!==hl){H=new a.CustomSkinClass(a9,hl,gG,hf)}}else{hf()}};var a0=function(){if(f8.makeBool(gm.urlLoadingAnimation,true)&&b2!==gm.urlLoadingAnimation){b2=gm.urlLoadingAnimation;var o=f8.getReloadPath(f8.locationFSIViewer,gm.urlLoadingAnimation);f8.loadFile(o,f7,"text/html; charset=utf-8")}else{t()}};var f7=function(o){var he=o.responseText;if(fY){fY=b}if(typeof(he)=="string"&&he.length>0){if(!a.bViewerLoadingAnimationCSSClassAdded){a.bViewerLoadingAnimationCSSClassAdded=true;a.addViewerClassCSSRule(".fsi-viewer-loading-animation","position:absolute;padding:15px;z-index:10;left:100%;top:0%;transform:translate(-100%,0%);pointer-events:none;")}fY=document.createElement("div");a.addClass(fY,"fsi-viewer-loading-animation");fY.innerHTML=he}t()};var eP=function(){if(!fY||aI){return}c6=fY;if(c6){aI=true;gI.appendChild(c6)}};var gU=function(){if(aI&&c6&&c6.parentNode){a.removeChild(c6.parentNode,c6);c6=b}aI=false};var d2=function(){var he="/fsipages/fsipages.js";var o="/fsilinkeditor/fsilinkeditor.js";var hf="fsiviewer.js";var hg=a.getScriptPath(hf,2);a.loadJavascript(hg+o,dN,a9,gj,hg)};var gj=function(he,hg,hf){h=new a.LinkEditor(a9,gG,gI,{});h.init(dN,hf,t);var o=ar;ar=function(){o.apply(a9,arguments);h.drawScene(at,gS)}};var t=function(){eP();var he=gm.skin;if(gV!=he){dA=false;gV=he}ds.log("Loading skin: "+he+".css");if(gy){gy.remove();gy=b}if(!dA&&a.oSupportedViewers[cB.strClassName]==true){var hf=aU.className;aU.name=he;aU.className="fsi-skin-"+aU.name;gI.className="fsi-root fsi-viewer-root "+aU.className;var o=[{file:"resources/fsi-core.css",nPriority:1},{file:"resources/fsi-viewer-core.css",nPriority:5}];gy=a.loadSkinCSS(he,a9,c1,10,o);if(hf!=aU.className){cy.runPersistent("onSkinChanged",[aU.className,hf])}}else{c1(dA)}};this.getSkinClassName=function(){return aU.className};var c1=function(o){gy=b;if(o){ds.log("Skin loaded successfully. ");cO()}else{ds.error("Failed to load skin.");ew={hMenuBar:0};aU._nameParsedLast=b}ea()};this.showMenuButton=function(he,o){if(cN){cN.showButton(he,o)}};this.getMenuHeight=function(he){var o=bA;if(he!=b){switch(he){case"navWindow":if(ew.bFloatingNavWindow){o=0}break}}return o};var cO=function(){if(aU._nameParsedLast!=aU.name){aU._nameParsedLast=aU.name;var hj=document.createElement("div");hj.style.position="absolute";hj.style.top="0px";hj.style.left="0px";hj.style.width="1px";hj.style.height="1px";hj.style.overflow="hidden";hj.style.visibility="hidden";var he=document.createElement("div");hj.appendChild(he);gI.appendChild(hj);var hl={};var hg=function(ht,hq,ho,hn,hp){var hm,hs;if(hl[ht]==b){he.className=ht;hs=hl[ht]=getComputedStyle(he,hp)}else{hs=hl[ht]}hm=hs.getPropertyValue(hq);if(hn){hm=hm.replace(/^[^{]*/g,"");hm=hm.replace(/[^}]*$/g,"");hm=hm.replace(/\\"/g,'"');if(hm.length>0){try{hm=a.JSON.parse(hm)}catch(hr){a.console.error("ERROR parsing JSON from CSS selector '"+ht+"' property '"+hq+"'.");a.console.error(hr.message)}}else{hm={}}}if(hm==b){hm=ho}return hm};ew=hg("fsi-ui-info","content",b,true,":before");ew.bFloatingMenuBar=f8.makeBool(ew.floatingMenuBar);ew.bFloatingNavWindow=f8.makeBool(ew.floatingNavWindow);ew.hMenuBar=hg("fsi-ui-menu-bar","height");aU.urlLogo=hg("fsi-ui-logo-image","background-image");if(typeof(aU.urlLogo)=="string"){var hi=/url\(\s*["']?([^"')]*)["']?\s*\)/;var o=hi.exec(aU.urlLogo);if(o&&o.length>0){aU.urlLogo=o[1]}}aU.navFrameBorderColor=hg("fsi-ui-nav-frame","border-left-color","red");aU.navFrameBackgroundColor=hg("fsi-ui-nav-frame","background-color","rgba(255,255,255,0.5)");aq=hg("fsi-ui-select-frame","border-left-color","red");bj=hg("fsi-ui-select-frame","background-color","rgba(255,255,255,0.25)");aU.oProgressBarStyle={};aU.oProgressBarStyle.color=hg("fsi-ui-progressbar","color","#CCC");aU.oProgressBarStyle.background=hg("fsi-ui-progressbar","background-color","#FFF");aU.oProgressBarStyle.border=hg("fsi-ui-progressbar","border-left-color","#CCC");aU.oProgressBarStyle.text=hg("fsi-ui-progressbar-text","color","#555");var hk=16;var hf=8;if(ew){if(!isNaN(ew.baseSize)&&ew.baseSize>0){hk=ew.baseSize}if(!isNaN(ew.baseEnlargement)&&ew.baseEnlargement>0){hf=ew.baseEnlargement}}else{ew={}}var hh=1;if(a.isMobileDevice&&gm.adaptiveUISize==true){hh=a.getDevicePixelRatio()}ab=Math.round(hk+hf*hh);ew._baseSkinSize=ab;gI.removeChild(hj)}gI.style.fontSize=ab+"px"};var ea=function(){if(typeof(ew.hMenuBar)!="string"||ew.hMenuBar.length<1||isNaN(parseFloat(ew.hMenuBar))){cK=false}else{cK=(a.oSupportedViewers[cB.strClassName]==true&&d!=true)}j()};var dY=function(){if(!cK){cN.removeDomElement()}bA=cN.getHeight();if(ew&&ew.bFloatingMenuBar){ct=0}else{ct=bA}af();bn()};this.showMenuToolTip=function(hf,he,o,hg){if(cN){cN.showToolTip(hf,he,o,hg)}};this.hideMenuToolTip=function(){if(cN){cN.hideToolTip()}};var j=function(){if(fH==b){if(a._FSIViewerLocation!=b){fH=new a.ToolTip(gI)}}fB();if(cN==b||!dA){if(cN){cN.destroy()}cN=new a.MenuBar(gG,aU,gI,dY,cB.oAPI.oMenuCommands);cN.setCallbacks(cy)}else{if(dA&&cN){cN.setInterface(gG)}dY()}};var fB=function(){if(fH!=b&&gm){f8.loadLanguageFile(bm,gm.language,fZ,ds)}};var fZ=function(he,o){dF=he;fH.setContent(dF)};var eH=function(){if(!cN){return}var hf;var he=gG.arMenuButtons=[];he.push({cmd:"Reset"});if(b0.enabled==true){he.push({cmd:"ZoomOut",enabled:false});he.push({cmd:"ZoomIn"})}if(f8.hasPlugin("mousemodes")||f8.hasPlugin("mousemodeselect")){var hi=f8.getPluginParameter("mousemodes","sequence","0,1,3,2");hi=hi.split(",");var hg=[];for(hf=0;hf<4;hf++){hg[hf]=f8.getPluginParameter("mousemodes","mode"+hf,true,true)}if(!b0.enabled){hg[0]=hg[1]=false}var hh=function(hj){if(isNaN(hj)||hj<0||hj>2){return}if(!hg[hj]){return}if(hj==2&&gR.length<2){return}var hk=true;if(hj==1){hk=(fX>eX)}he.push({cmd:"MouseMode_"+hj,groupID:"MouseMode",enabled:hk})};for(hf=0;hf<hi.length;hf++){hh(parseInt(hi[hf]))}}if(f8.hasPlugin("maxzoom")&&b0.enabled){he.push({cmd:"MaxZoom"})}if(eB){if(!f8.hasPlugin("hotspots")){f8.addPluginFromString("hotspots")}if(f8.getPluginParameter("hotspots","button","true",true)){he.push({cmd:"HotSpots",bCheckButton:true})}df=f8.getPluginParameter("hotspots","visible","true",true)}if(gm.autoSpinSpeed!=0&&f8.hasPlugin("autospin")&&f8.getPluginParameter("autospin","button",true,true)){he.push({cmd:"ToggleAutoSpin",bCheckButton:true})}var o=false;if(a.FullScreen.getAvailable(am)&&f8.hasPlugin("fullscreen")){o=true;a.FullScreen.addChangeEvents(window,cM,aV);he.push({cmd:"ToggleFullScreen",bCheckButton:1})}cN.addButtons(he,gm.MenuButtonOrder);cy.run("onInitMenu");if(o&&d5){cN.setButtonPressed("ToggleFullScreen",true)}if(eB&&df){cN.setButtonPressed("HotSpots",true)}};var fw=function(){var o;if(!r){o=Math.round(Math.max(1,hd)*Math.max(ba.width,ba.height))}else{o=Math.round(Math.max(1,hd)*Math.max(screen.width,screen.height))}fs=Math.min(1024,Math.max(2,Math.ceil(o/3/128))*128)};var bn=function(){if(typeof(gm.virtualSpace)!="object"){return}var hh=f8.parsePositionParameter(gm.virtualSpace.position);if(hh!=b){gm.virtualSpace.shiftX=hh.x;gm.virtualSpace.shiftY=hh.y;gm.virtualSpace.shiftZ=hh.z}if(f8.cfg.cameraarmanglestart!=b){gm.virtualSpace.baseRotationX=gm.camera.armAngleStart;if(f8.cfg.cameraarmangleend!=b){gm.virtualSpace.rotationXRange=gm.camera.armAngleEnd-gm.camera.armAngleStart}}if(gm.useDevicePixelRatio){hd=a.getDevicePixelRatio()}else{hd=1}fw();fk=new a.CroppedImage();fk.setCropFromConfig(f8.cfg);switch(gm.panLimits){case"loose":fX=an;break;case"medium":fX=eX;break;default:fX=fo;break}n();e3=true;if(gm.noSceneLoop){g6=aY}else{g6=eU}F=gm.virtualSpace.rotationYRange*-Math.PI/180;aW.rotXRange=gm.virtualSpace.rotationXRange;var o=(gm.virtualSpace.rotationXSets>0)?gm.virtualSpace.rotationXSets:aW.nSceneSets-1;aW.rotXGradPerSet=(aW.rotXRange/(aW.nSceneSets-1))*Math.PI/180;if(fy!==b){var hg=fy;fy=b;a9.changeImage.apply(a9,hg);return}var hf=gm.dir;if(hf===b||hf.length===0){hf=f8.cfg.images3durl}if(!hf||hf.length===0){var he=f8.getImageList();if(he){bL(he.arImages,he.oXML,he)}else{return c7("failed to load image list")}}else{he=f8.loadImageList(hf,bL,cg);if(ds.on&&typeof(he._url)=="string"){ds.log("Loading image list: "+he._url)}}};var bL=function(he,hf){if(!he||he.length<1){ds.error("Failed to load image list.");return c7("image list is empty")}dW();gR=he;bx=ad=he.length;aW=f8.parseSceneSets(gR.length,false);ds.log("Image list ready ("+gR.length+" images)");if(gR.length>0){if(f8.cfg.fpxwidth!==b&&f8.cfg.fpxheight!==b){var o={};o.width=parseInt(f8.cfg.fpxwidth);o.height=parseInt(f8.cfg.fpxheight);bP(null,o)}else{f8.loadImageInfo(gR[0],bP)}}else{br()}};var cC=function(){var o={};o.angle=gm.virtualSpace.baseRotationX;o.stepAngle=gm.virtualSpace.rotationXRange/(aW.nSceneSets-1);return o};var eQ=function(){if(!d0||aW.nSceneSets<1){return}if(aW.bSetCameraPosition){return}aW.bSetCameraPosition=true;var hk=new THREE.Vector3();var he=new THREE.Vector3();var hp=new THREE.Vector3();var hn=new THREE.Object3D();var hf=new THREE.Object3D();hn.add(hf);var hq=new THREE.Object3D();hf.add(hq);var hj=180/Math.PI;var hu;var hv=dI.targetObj.position;hf.rotation.set(0,0,0);hp.set(0,hv.y,hv.z);if(f8.cfg.cameraarmlength==b){hu=dI.camera.position.distanceTo(hv)}else{hu=gm.camera.armLength}var hm=f8.parsePositionParameter(gm.camera.armJointPosition);if(hm==b){hf.position.set(hv.x,hv.y,hv.z)}else{hf.position.set(hm.x,hm.y,hm.z)}hf.rotation.x=gm.camera.armAngleMeasureSetup/hj;hn.rotation.set(0,0,0);hq.rotation.set(0,0,0);hq.position.set(0,0,hu);hn.updateMatrixWorld();he.setFromMatrixPosition(hq.matrixWorld);var ht=cC();var hs=ht.angle;var hl=ht.stepAngle;if(gm.reverseSceneSets){hs+=gm.virtualSpace.rotationXRange;hl=-hl}ds.log("Calculated Camera Positions:");ds.log("----------------------------");var o=180/Math.PI;for(var ho=0;ho<aW.nSceneSets;ho++){var hg=aW.arSets[ho];hg.cameraArmAngle=hs;hf.rotation.x=hs/hj;hn.updateMatrixWorld();hk.setFromMatrixPosition(hq.matrixWorld);hg.posCamera=new THREE.Vector3(dI.camera.position.x+hk.x-he.x,dI.camera.position.y+hk.y-he.y,dI.camera.position.z+hk.z-he.z);hk.x=0;hg.xAngleToTarget=hp.angleTo(hk)-Math.PI/2;hg.xAngleToTargetDeg=hg.xAngleToTarget*o;if(ds.on){ds.log("SceneSet "+(ho+1)+", arm angle "+hs+"°, angle to target: "+hg.xAngleToTargetDeg+"°, position (x,y,z): "+hg.posCamera.x+", "+hg.posCamera.y+", "+hg.posCamera.z)}if(eB){hg.visibleHotSpots={};for(var hr=0;hr<gm.hotspots.points.length;hr++){var hh=gm.hotspots.points[hr];var hi=1;if(hh.perimeterAngleX!=b){var hw=Math.abs(hh.perimeterAngleX-hg.xAngleToTargetDeg);if(hw>180){hw=Math.abs(360-hw)}if(hw<hh.perimeterAngleXRange){if(hw>hh.perimeterAngleXRange-hh.perimeterAngleXFadeOut){hi=(hh.perimeterAngleXRange-hw)/hh.perimeterAngleXFadeOut}}else{hi=0}hg.visibleHotSpots[hh.FSIHotspotID]=hi}else{hg.visibleHotSpots[hh.FSIHotspotID]=1}}}hs+=hl}};var dJ=function(){if(aW.bDefault){return}var hh=100000000;var hm=0;var hi,hg,hl;var ho;if(ds.on){ho=a.cloneObject(aW.arSets)}var hn={};for(hi=0;hi<aW.arSets.length;hi++){hl=aW.arSets[hi].arScenes;for(hg=0;hg<hl.length;hg++){var hj=hl[hg]=hl[hg]-1;hn[hj]=gR[hj]}}var hk=[];var hf=e.length;for(var he in hn){hk.push(hn[he]);hn[he]=hf;hf++}for(hi=0;hi<aW.arSets.length;hi++){hl=aW.arSets[hi].arScenes;for(hg=0;hg<hl.length;hg++){hl[hg]=hn[hl[hg]]}hh=Math.min(hh,hl.length);hm=Math.max(hm,hl.length)}if(aW.arSets[0].arScenes.length>0){aW.bDefault=false;aW.quantizeMin=hh;aW.quantizeMax=aW.quantizeMaxImages=hm;if(ds.on){ds.log('Using SceneSets Parameter: "'+f8.cfg.scenesets+'"');ds.log("Parsed SceneSets:");for(hi=0;hi<ho.length;hi++){ds.log("Scene "+(hi+1)+": "+ho[hi].arScenes.join(", "))}}gR=hk;if(aW.arSets.length>1){if(hh!=hm){aW.bQuantize=true}if(dz!=b&&dz>0){aW.quantizeMax=Math.max(aW.quantizeMax,dz);if(hm!=aW.quantizeMax){aW.bQuantize=true}}}}else{aW.bDefault=true;aW.bHasMultipleSets=false;ds.error('Invalid SecenSet definition: "'+f8.cfg.scenesets+'"')}};var a7=function(){var hg=100000000;var o=0;for(var hf=0;hf<aW.arSets.length;hf++){var he=aW.arSets[hf].arScenes;hg=Math.min(hg,he.length);o=Math.max(o,he.length)}return{min:hg,max:o}};var fP=function(){var hh,hk;var he=aW.quantizeMax;for(var hj=0;hj<aW.arSets.length;hj++){if(hj==aW.nVideoSet){continue}var hi=aW.arSets[hj].arScenes;if(hi.length<he){var o=hi.length;aW.arSets[hj].fQuantizeFactor=he/o;var hf=o-1;var hg=new Array(he);for(hh=0;hh<he;hh++){hk=(hh*hf/(he-1));hg[hh]=hi[Math.round(hk)]}aW.arSets[hj].arScenes=hg}else{aW.arSets[hj].oSpinPositions=false}}};var a3=function(){var hi,hh,hj,hg,hn;if(aW.bDefault){return}var hf=gm.virtualSpace.rotationYScenes;for(hi=0;hi<aW.arSets.length;hi++){if(hi===aW.nVideoSet){continue}var ho=aW.arSets[hi];var hm=ho.arScenes;var hl=hm.length;hn=hg=b;for(hh=0;hh<hl;hh++){hj=hm[hh];if(hg===b||hg>hj){hg=hj}if(hn===b||hn<hj){hn=hj}}ho.minScene=hg;ho.maxScene=hn;ho.sceneRange=hn-hg;var he=(hf>0)?hf:ho.sceneRange+1;var o=ho.oSpinPositions={};var hk=o.arPositions={};for(hh=0;hh<hl;hh++){hj=hm[hh];hk[hj]=(hj-hg)/he}}};var c7=function(o){gU();bU("default");if(cN){cN.setEnabled(false)}cy.run("onInitFailed",[o])};var bP=function(he,o){if(!o||o.width==b||isNaN(o.width)){return c7("Failed to load image info")}au=o;au.transparency=f8.makeBool(au.alpha);au.width=parseInt(au.width);au.height=parseInt(au.height);if(gm.fpxservertemplate!=b){e7.renderer=gm.fpxservertemplate}if(gm.headers!=b){e7.headers=gm.headers}dK=(au.transparency&&!gm.preventImageTransparency);if(dK){if(i){bp=gm.useMaskedJPEGs}else{var hf=f8.cfg.fpxservertemplate;if((gm.video==b||!gm.video.source.length)&&(hf==b||hf=="jpeg")){e7.renderer="png"}}}gZ=(!dK||!bp);if(typeof(au.levels)=="object"&&typeof(au.levels.sort)=="function"){au.levels.sort(aL)}else{au.levels=b}fk.setSourceDimension(au.width,au.height);p();l(eO.width,eO.height);dR();br()};var aL=function(he,o){return o.width-he.width};var dR=function(){if(fk.isCropped()){var he=fk.getImageRect();var o=he.width()/W.imageWidth;aP.cropScaleX=au.width/he.width();aP.cropScaleY=au.height/he.height();aP.x=(he.left+he.width()/2-au.width/2)/o;aP.y=(he.top+he.height()/2-au.height/2)/o}else{aP.cropScaleX=1;aP.cropScaleY=1;aP.x=0;aP.y=0}};var p=function(){var o;if(fk.isCropped()){o=fk.getPixelRangeRect();eO.width=o.right;eO.height=o.bottom}else{eO.width=au.width;eO.height=au.height}};var br=function(){if(typeof(f8.cfg.fullscreenelement)!="undefined"){dy=f8.cfg.fullscreenelement}else{dy=am}gu();d0=false;bF=false;var o=true;if(a.BrowserSupports.canvas()){if(gm.drawCube||gm.drawGroundPlate||gm.drawTable){bF=d0=true}if(!d0&&gm.enableHotspots){if(gm.hotspots&&gm.hotspots.points&&gm.hotspots.points.length>0){d0=true}}var he="js/three_custom_min.js";if(a._FSIViewerLocation!=b){he=a._FSIViewerLocation+"/applications/viewer/"+he}o=false;if(d0){if(typeof(window.THREE)=="object"){o=true}else{if(!a.loadJavascript(he,dN,a9,eW)){o=true;d0=false}}}else{a.releaseLoadJavascript(he,dN);o=true}}if(!d0){bF=false}if(o){dt()}};var eW=function(o,hf,he){if(typeof(window.THREE)!="object"){d0=false}if(!d0){bF=false}dt()};var dt=function(){if(gm.video.spinDirection&&gm.video.spinDirection.toLowerCase()=="left"){gm._reverseVideoDirection=true}if(gm.spinDirectionImage!=b){if(gm.spinDirectionImage.toLowerCase()=="left"){gm._reverseImageDirection=true}}else{gm._reverseImageDirection=gm._reverseVideoDirection}if(!aW.bDefault){if(gm._reverseImageDirection){for(var o=0;o<aW.arSets.length;o++){aW.arSets[o].arScenes.reverse()}gm._reverseImageDirection=false}if(gm.reverseSceneSets){aW.arSets.reverse()}}if(gm._reverseImageDirection){gR.reverse();gR.unshift(gR.pop())}f=ap();cR();eH();if(eB){fT(true)}else{fT(false)}if(f4){g9();fL()}cy.run("onDataComplete")};var cw=function(){if(ey!=b&&cN){cN.setButtonPressed("MouseMode_"+ey,true)}if(bk){cT()}};var cR=function(){if(eO.width){g8=Math.min(cA,eO.width)}else{g8=cA}bg()};var bg=function(){b0.scaleToSourceImage=Math.max(1,eO.width/bb.imageWidth);b0.maxScale=b0.maxScaleInitial=gm.maxZoom/100*b0.scaleToSourceImage;b0.defaultZoom=Math.min(gm.desktopClickZoomScale,b0.maxScale)};this.destroyOnDetach=function(){if(gm&&gm.autoDestroy!=false){fR()}};var fR=this.destroy=function(o){if(h){h=h.destroy()}if(H){H.destroy()}aK.destroy();g3();if(f8){f8.destroy()}if(am){am.removeAttribute("x-fsi-id");a.removeClass(am,"fsi-viewer")}if(m){m.destroy()}if(gy){gy.remove();gy=b}if(bv!=b){a.removeCustomEvent(gI,"FSIMouseWheel",fA);bv=b}if(A!=b){a.removeCustomEvent(g0,"FSIDocumentZoomChange",dU);A=b}if(eS!=b){a.removeCustomEvent(eZ,"FSIViewport",a8);eS=b}if(gJ){a.removeCustomEvent(gI,"FSIElementDimension",a4);gJ=false}if(d4){clearTimeout(d4);d4=b}O();if(fH){fH.destroy();fH=b}ed();if(G){G.destroy();G=b}gf=false;gb();if(cN){cN.destroy();cN=b}if(gI){if(f4){a.removeChild(eZ,f4);a.removeChild(gI,eZ);f4=b}if(gI.parentNode==am){a.removeChild(am,gI)}gI=b}if(V){a.removeChild(V.parentNode,V);V=b}if(g0){if(!a.isMobileDevice){a.removeEvent(g0,"keydown",cU);a.removeEvent(g0,"keyup",ch)}a.removeChild(g0.parentNode,g0);g0=b}if(!o&&cy){cy.run("onDestroy");cy.destroy()}};var n=function(){if(!ba||ba.width<10||ba.height<10){return false}if(g0==b){gG.eventOverlay=g0=document.createElement("div");g0.className="fsi-event-overlay";var he="position:absolute;z-index:300;width:100%;height:100%;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;";if(a.isInternetExplorer){a.setStyleAttr(g0,he+";background-color:rgba(0,0,0,0)")}else{a.setStyleAttr(g0,he)}bU("wait");if(!a.isMobileDevice){g0.setAttribute("tabIndex","0")}gI.appendChild(g0);if(!G){var hf={};hf.detectGestures=true;hf.afterTouch={enabled:true};hf.afterTouch.modifyTarget=N;hf.afterTouch.fnGetAfterTouchEnabled=bf;hf.afterTouch.fnStartStopAfterTouch=I;if(b0.enabled){hf.detectClick=true;hf.onPinchStart=q;hf.onPinchChange=dS;hf.onPinchEnd=gF}G=new a.TouchHandler(g0,hf,el,U,fC)}if(!a.isMobileDevice){a.addEvent(g0,"keydown",cU);a.addEvent(g0,"keyup",ch)}if(b0.enabled){bv=a.addCustomEvent(gI,"FSIMouseWheel",fA);a.setCustomEventListenerProperty(bv,"acceleration",1.7);a.setCustomEventListenerProperty(bv,"accelerationMax",30)}else{if(bv!=b){a.removeCustomEvent(gI,"FSIMouseWheel",fA);bv=b}}if(b0.enabled){if(A==b){A=a.addCustomEvent(g0,"FSIDocumentZoomChange",dU);a.triggerCustomEvent(A)}}else{if(A){a.removeCustomEvent(g0,"FSIDocumentZoomChange",dU);A=b}if(G){G.enable(true)}}}if(V==b&&eB){V=document.createElement("div");a.addClass(V,"fsi-ui-hotspot-container");a.setStyleAttr(V,"position:absolute;z-index:4;");g0.appendChild(V)}if(V){e8(V,false)}if(f4==b||f4.FSIisCanvas!=i){if(f4!=b&&f4.FSIisCanvas!=i){a.removeChild(gI,f4);fN=f4=bR=b}eZ=document.createElement("div");eZ.setAttribute("draggable","false");a.setStyleAttr(eZ,"overflow:hidden;width:100%;height:100%;position:absolute;overflow:hidden;width:100%;height:100%;overflow:hidden");if(i){f4=document.createElement("canvas")}else{f4=document.createElement("div")}eZ.appendChild(f4);gI.appendChild(eZ);var o="z-index:1;position:absolute;transform-origin:0px 0px;	-webkit-transform-origin:0px 0px;	-ms-transform-origin:0px 0px;";o+="backface-visibility: hidden;-webkit-backface-visibility: hidden;";a.setStyleAttr(f4,o);if(i){cq=f4.getContext("2d");dv=cq.webkitBackingStorePixelRatio||cq.mozBackingStorePixelRatio||cq.msBackingStorePixelRatio||cq.oBackingStorePixelRatio||cq.backingStorePixelRatio||1;if(!ez){f4.style.width=f4.style.height=""}}else{f4.style.textAlign="left"}f4.FSIisCanvas=i}if(typeof(gm.backgroundColor)=="string"&&gm.backgroundColor.toLowerCase()=="none"){gm.backgroundColor="transparent"}gI.style.backgroundColor=gm.backgroundColor;if(!i){if(fN==b){fN=bR;bR=b}if(bR!=b){a.removeChild(bR.parentNode,bR)}bR=document.createElement("img");if(fN!=b){bR.style.display="none"}f4.appendChild(bR)}if(i){if(eS==b){eS=a.addCustomEvent(eZ,"FSIViewport",a8);a.setCustomEventListenerProperty(eS,"treshold",250)}}else{if(eS!=b){a.removeCustomEvent(eZ,"FSIViewport",a8);eS=b}a1.setRect(0,0,ba.width,ba.height)}g2=f4.width=Math.ceil(ba.width*at.scale);cQ=f4.height=Math.ceil(ba.height*at.scale);f4.lastOffsetX=f4.lastOffsetY=0;if((a.BrowserSupports.documentZoom()&&!a.isMobileDevice)||(a.isMobileDevice&&!i)){fD=true}ep();return true};var q=function(o,hg,hf){if(b0.maxScale<=1){ff.bActive=false;return}ff.bActive=true;ff.lastX=hg.x;ff.lastY=hg.y;ff.distanceStart=o._FSI_PinchDistance;var he=a.getElementPosition(g0);ff.offsetX=-he.left-ba.width/2;ff.offsetY=-he.top-ba.height/2;ff.startZoom=b0.scale;aM(false)};var dS=function(hj,hh,hk){if(!ff.bActive){return}var hf=hh.x-ff.lastX;var o=hh.y-ff.lastY;ff.lastX=hh.x;ff.lastY=hh.y;var hm=ff.startZoom*hj._FSI_PinchScale;hm=Math.max(1,Math.min(b0.maxScale,hm));var hl=hm*100/b0.maxScale;var hi=hh.x+ff.offsetX;var hg=hh.y+ff.offsetY;var he=hm/b0.scale;b0.panPos.left-=hi;b0.panPos.top-=hg;b0.panPos.left*=he;b0.panPos.top*=he;b0.panPos.left+=hi;b0.panPos.top+=hg;b0.panPos.left+=hf;b0.panPos.top+=o;a9.setZoom(hl,true,false)};var gF=function(o,hg,hf){if(!ff.bActive){return}ff.bActive=false;aM(true);var he=b0.scale*100/b0.maxScale;a9.setZoom(he,false,false)};var J=function(hf){var he=hd;if(he<1||gm.useDevicePixelRatio){hf=he*hf}if(fl!=hf){fl=hf;b0.maxScale=Math.max(1,b0.maxScaleInitial/hf);dE();cd=hf;if(eB){var o=cd;if(!a.isMobileDevice&&hd!==1){o/=hd}if(eI!==o){eI=o;dH=true}if(!b7){gY()}}}};var eF=function(){var o=false;if(a.FullScreen){o=a.FullScreen.getElement()}return(o&&o!=dO)};var a8=function(o){if(eF()){return}bZ=o.FSI_viewport_rect;J(o.FSI_scale);if(!cj){return}s(o.FSI_after_treshold)};var dU=function(){e4()};var e4=function(){if(gm.autoDisablePointerActions){var he=a.getVisualViewportSize();var o=(a9.getInFullScreenMode()||(ah.width<=he.width&&ah.height<=he.height));if(o!==gn){gn=o;G.enable(o);if(f2){f2.enable(o)}}}};var aO=function(){return(c2&&(!G||!G.isAfterTouchRunning()))};var fA=function(hl){gG.onUserAction();if(hl.FSI_delta==0){return}az(false);if(hl.preventDefault){hl.preventDefault()}x();bM();var hm=aO();if(b7||hm){return}if(b0.maxScale<=1){return}var hk=0.45*hl.FSI_normalized_accelerated_delta;cu=G.getMousePositionClient(hl);var hj=a.getElementPosition(g0);var hf=1+Math.abs(hk)/6;if(hk<0){hf=1/hf}var hn=Math.max(1,Math.min(b0.maxScale,b0.scale*hf));var hi=cu.x*at.scale-hj.left-ba.width*at.scale/2;var hh=cu.y*at.scale-hj.top-ba.height*at.scale/2;var o=hn/b0.scale;var hg=b0.panPos.left-hi;var he=b0.panPos.top-hh;hg*=o;he*=o;hg+=hi;he+=hh;eJ(hg,he,hn,13);if(f2&&f2.isDragging()){b0.lockPanAnimation=true}hl.cancelBubble=true};var I=function(o){gB=o;if(o){gY()}};var go=function(){if(!dV){return}aw=false;if(dV._timeOutDraw){clearTimeout(dV._timeOutDraw)}dV=b};var eA=function(){if(!gm.showProgressbar){return}if(gR.length<2){go();return}if(!i){return}var o=0;switch(gm.progressBarHAlign){case"left":case"right":o=8;break}d3=Math.max(10,(ba.width*(Math.max(0,Math.min(100,gm.progressBarWidth/100)))-2*o))*at.scale;dL=Math.max(1,Math.min(ba.height,gm.progressBarHeight))*at.scale;dV=new a.CanvasProgressBar(cq,0,0,d3,dL,aU.oProgressBarStyle);cF();dV._timeOutDraw=setTimeout(bu,100)};var bu=function(){if(dV){aw=true}};var cF=function(){if(!dV){return}var o,he;switch(gm.progressBarHAlign){case"left":o=at.scale*8;break;case"right":o=at.scale*(ba.width-d3-8);break;default:o=at.scale*((ba.width-d3)/2)}switch(gm.progressBarVAlign){case"middle":case"center":he=at.scale*(ba.height/2-dL/2);break;case"top":he=at.scale*4;break;default:he=at.scale*(ba.height-4-dL)}dV.setPos(o,he)};var fL=function(){var hq;cx(0);var hi=false;aE=(!a.isMobileDevice&&(a.isOpera||a.isInternetExplorer));eA();bU("wait");var hk="";if(f.indexOf("//")==-1){hk=gm.video.base}if(!i||a.isMobileDevice||!f){ds.log("Using image sequence w/o video.");return db()}var ho=gm.video.captureOffsetStart;if(ho==b||isNaN(ho)){ho=0}var hg=gm.video.captureOffsetEnd;if(hg==b||isNaN(hg)){hg=0}var hj;hq=gm.video.captureFrames;if(hq==b||isNaN(hq)){gm.video.captureFrames=120}if(aW.nSceneSets>1){var hl=a7();gm.video.captureFrames=Math.max(gm.video.captureFrames,hl.max)}else{gm.video.captureFrames-=gm.video.captureFrames%gR.length;gm.video.captureFrames=Math.max(gm.video.captureFrames,gR.length)}var hp=document.createElement("canvas");hp.setAttribute("webkit-playsinline","");var hm=hp.getContext("2d");if(!dn){dn=document.createElement("canvas");g7=dn.getContext("2d")}hq=hk+f;if(a.isInternetExplorer&&a.versionInternetExplorer<10&&a.isCrossDomain(hq)){ds.error("CROSS DOMAIN VIDEO ACCESS not possible with this browser.");ds.log("Falling back to using image sequence.");return db()}ds.log("Capture "+gm.video.captureFrames+" video frames");dM=document.createElement("video");dM.setAttribute("muted","muted");dM.setAttribute("preload","auto");dM.setAttribute("webkit-playsinline","");dM.setAttribute("crossorigin","anonymous");a.setStyleAttr(dM,"position:absolute;z-index:10000;width:1px;height:1px");if(a.isSafari){dM.style.display="none"}dM.style.marginLeft=ba.width/2+"px";dM.style.marginTop=ba.height/2+"px";if(!a.isSafari&&!a.isInternetExplorer){var hf=document.createElement("source");hf.setAttribute("src",hk+f+".webm");dM.appendChild(hf)}var he=document.createElement("source");he.setAttribute("src",hk+f+".mp4");dM.appendChild(he);if(!a.isSafari&&!a.isInternetExplorer){var o=document.createElement("source");o.setAttribute("src",hk+f+".ogv");dM.appendChild(he)}gI.appendChild(dM);dM.FSIEvents={};var hn=function(hs,ht,hr){dM.FSIEvents[hs]={fn:ht,phase:hr};a.addEvent(dM,hs,ht,hr)};hn("error",function(hr){if(dM.networkState==dM.NETWORK_NO_SOURCE){ds.error('Failed loading the video: "'+f+'"');ds.log("Falling back to using image sequence w/o video.");db()}},true);hn("loadedmetadata",function(hs){b7=true;ei("video");var ht=dM.videoWidth;var hr=dM.videoHeight;dM.setAttribute("width",ht);dM.setAttribute("height",hr);hj=(dM.duration-ho-hg)/gm.video.captureFrames;gw(ht,hr);hp.setAttribute("width",cP.croppedWidth);hp.setAttribute("height",cP.croppedHeight);dn.setAttribute("width",cP.croppedWidth);dn.setAttribute("height",cP.croppedHeight);cw();gO()},true);hn("canplaythrough",function(hr){if(!hi){if(a.isSafari){dM.style.display=""}hi=true;this.currentTime=Math.max(0,ho)}},true);var hh=0;hn("seeked",function(hr){if(!b7){return}var hs=dM.duration;if(a.isInternetExplorer){hs-=0.3}if(e.length<gm.video.captureFrames){try{hm.drawImage(hr.target,0,0,cP.width,cP.height,-fj.left,-fj.top,cP.width,cP.height);var hu=hm.getImageData(0,0,hp.width,hp.height);e.push(hu)}catch(ht){ds.error('Failed capturing the video: "'+f+'"');ds.log("REASON: "+ht.message);ds.log("Falling back to using image sequence w/o video.");b7=false;db();return}cx(100*e.length/gm.video.captureFrames);b9(e.length-1);gY();hh=Math.min(hs,hj*e.length+ho);if(aE){d4=setTimeout(function(hv){dM.currentTime=hh},1)}else{dM.currentTime=hh}}else{c0()}},true)};var fx=this.startAutoSpin=function(){if(!cj||!fU.bEnabledByConfig){return false}if(fU.interval){return true}if(cN){cN.setButtonPressed("ToggleAutoSpin",true)}x();bN();bW("autoSpin");fU.enabled=true;er();fU.interval=setInterval(fM,fU.nIntervalTime);return true};var gs=function(){if(!cj||!fU.bEnabledByConfig){return false}if(!fU.enabled){fx()}else{az(true)}};this.stopAutoSpin=function(){return az()};var az=gG.stopAutoSpin=function(o){if(!cj||!fU.bEnabledByConfig){return false}if(!fU.interval){return true}if(cN){cN.setButtonPressed("ToggleAutoSpin",false)}fU.enabled=false;ga("autoSpin");clearInterval(fU.interval);fU.interval=b;if(o){eD()}return true};var fM=function(){if(!hb){bW("autoSpin")}var o=et+fU.nDirection;if(o>=ej){o-=ej}else{if(o<0){o+=ej}}gP(o);gY()};var aQ=function(he){ej=he;var o=1;if(typeof(gm.fMouseSensitivity)!="undefined"){o=parseFloat(gm.fMouseSensitivity);if(isNaN(o)||o==0){o=1}}fm=160/ej*4/o;dC=ej/120};var gh=function(){var o;if(!aW.bDefault&&aW.nSceneSets>1){o=Math.max(1,Math.min(aW.nSceneSets,gm.video.sceneSet))-1;if(gm.reverseSceneSets){o=(-(o+1)+aW.nSceneSets)%aW.nSceneSets}}return o};var c0=function(){if(gm._reverseVideoDirection){e.reverse();e.unshift(e.pop())}bq.unshift(v.imageWidth);fu=e.length;if(e.length>0){aW.nVideoSet=gh()}else{aW.nVideoSet=b}if(aW.nVideoSet!=b){var o=gM;db();gM=o}else{dJ();bX()}};var bX=function(){var he;cx(100);gU();if(b8!=b){fW=b8}a3();if(aW.bQuantize){fP()}b9(0);aw=false;bI=d0;cp=b;if(gm._reverseImageDirection&&f2){f2.reverseImageSequence()}if(eN){gY()}eg();go();bh();by=false;fU.bEnabledByConfig=false;if(ej>1||aW.nSceneSets>1){w=false;if(a.isIETouch){if(aW.nSceneSets>1){g0.style.msTouchAction="pinch-zoom double-tap-zoom"}else{g0.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}}if(gm.autoSpinSpeed!=0||gm.autoSpinInterval!=0){if(gm.autoSpinInterval!=0){he=gm.autoSpinInterval;fU.nDirection=(he>0)?1:-1;he=Math.abs(he)}else{if(gm.autoSpinSpeed<0){gm.autoSpinSpeed=-gm.autoSpinSpeed;fU.nDirection=-1}else{fU.nDirection=1}he=gm.autoSpinSpeed*1000/ej;if(he==0){he=1}while(he<20&&Math.abs(fU.nDirection)<ej/2){he*=2;fU.nDirection*=2}he=Math.max(20,Math.ceil(he))}fU.nIntervalTime=he;fU.bEnabledByConfig=true;if(!f8.hasPlugin("autospin")||f8.getPluginParameter("autospin","enabled",true,true)){by=f8.getPluginParameter("autospin","restartonreset",false,true);cj=true;fx();cj=false}}}else{w=true;if(a.isIETouch){g0.style.msTouchAction=b}if(!b0.enabled){bU("default")}}he=gm.initialMouseMode;if(he!="auto"){he=parseInt(he)}e6(he);b7=false;var o=b;if(gm.video.frameOffset&&gM){o=et+gm.video.frameOffset;o=g6(ej+o);b9(o)}b6();cj=true;if(cN){cN.setEnabled(true)}if(c!=b){gN(c,(gR.length>1));c=b}else{if(al!=b&&f8.makeBool(f8.cfg.keepcurrentviewafterconfigchange,false)){gm.initialview=al}if(gm){if(gm.initialview!=b&&gm.initialview.length>0){if(!gN(gm.initialview,false)){gm.initialview=b}else{gm.initialview=cE(gm.initialview)}}else{gm.initialview=b}}}al=b;if(ds.on){ds.log("Startup time: "+(a.now()-c3)+"ms")}cy.run("onReady");ag();cc();if(b0.enabled){bY()}if(!b0.enabled){if(w){G.setCapture(false,false)}else{G.setCapture(true,false)}}if(eS){a.triggerCustomEvent(eS);s(true)}if(h){h.start()}};var db=function(){g3();dz=e.length;ei("image");gO();dJ();eg();l(eO.width,eO.height);cw();fg()};var dl=function(){a.removeEvent(bR,"load",dl);if(fN!=b&&fN.parentNode!=b){a.removeChild(fN.parentNode,fN);fN=b}bR.style.display="inline";f4.style.paddingLeft=W.imageX+"px";f4.style.paddingTop=W.imageY+"px"};var fg=function(){b7=true;if(!i){bR.width=W.imageWidth;bR.height=W.imageHeight;a.addEvent(bR,"load",dl,true);if(fN==b){try{f4.style.paddingLeft=f4.style.paddingRight="auto";f4.style.paddingTop=f4.style.paddingRight="auto"}catch(o){}}}if(dn){dn.setAttribute("width",W.imageWidth);dn.setAttribute("height",W.imageHeight)}e5()};var eV=function(o){if(o){eP()}else{gU()}};var fQ=function(o,hf,hg,he){var hh;o.FSI_image_context=o;if(bp){hh={};hh.argsJPEG=Array.prototype.slice.call(arguments);he=dm;hf=a.changeRendererInURL(hf,"png.alpha");o=hh.argsJPEG[0]._FSI_alpha_mask=new Image()}aK.load(o,hf,hg,he,hh)};var dm=function(o,he){aK.load.apply(this,he.argsJPEG)};var cn=function(hf){if(!hf){return}if(hf.FSI_alpha_channel){var he=hf.width;var hh=hf.height;var hg=hf.FSI_image_context=document.createElement("canvas");hg.setAttribute("width",he);hg.setAttribute("height",hh);hg.setAttribute("crossorigin","anonymous");var o=hg.getContext("2d");o.drawImage(hf.FSI_alpha_channel,0,0,he,hh);o.globalCompositeOperation="xor";o.drawImage(hf,0,0,he,hh);hf.FSI_alpha_channel=b}};var cx=function(o){Y=o;if(cH){cy.runPersistent("onProgress",[o])}};var e5=function(){em={};em.oImages={};em.nPendingImages=0;em.nNext=0;em.nCurrentIndex=-1;em.nLoaded=0;if(!i){em.img=new Image()}var he=Math.min(6,gR.length);for(var o=0;o<he;o++){C()}};var gr=function(o){em.nLoaded++;cx(100*em.nLoaded/gR.length);if(em.nNext!==this.FSI_nImage){em.oImages[this.FSI_nImage]=this;em.nPendingImages++}else{bO(this);dP()}C()};var dP=function(){if(em&&em.nPendingImages>0){while(em&&em.oImages[em.nNext]){var he=em.nNext;var o=em.oImages[he];em.oImages[he]=b;em.nPendingImages--;bO(o)}}};var bO=function(o){em.nNext++;cn(o);if(i){e.push(o)}else{e.push(o.src)}b9(e.length-1);gY();if(em.nLoaded>=gR.length){dP();ai();if(eN){eN.addImage(bR)}bX()}};var C=function(){if(!em||++em.nCurrentIndex>=gR.length){return}var o;if(i){o=eT=new Image();o.FSI_nImage=em.nCurrentIndex}else{o=em.img}fQ(o,gE(em.nCurrentIndex).fullURL,"sequence",gr)};var ai=function(){if(em===b){return}aK.abortPurpose("sequence");em=b};var gP=function(o){var he=g6(Math.round(o));if(he!=g6(et)){dE();b9(he);gY();if(cj&&ft==b&&fU.interval==b){ag()}}d9=o};var bW=function(o){if(hb){return}R=true;hb=true;O();cY=false;z=false};var ga=function(o){if(!hb){return}b9(g6(et));hb=false;cY=true;z=true;if(!dg||et!=dg.spinPos){if(dg){fi()}fc()}else{cS(50)}};var b9=function(o){et=d9=o;if(!aR){dh=et}else{dh=aR[et]}};var co=function(){var o,hj,hf;d7=document.createElement("canvas");d7.setAttribute("width",cP.croppedWidth);d7.setAttribute("height",cP.croppedHeight);eh=d7.getContext("2d");var hh=d7.width;var he=d7.height;var hg=eh.createImageData(hh,he);var hi=hg.data;for(hj=0;hj<he;hj++){if(hj%4==0){for(o=0;o<hh;o++){if(o%4!=0){hf=hj*hh*4+o*4;hi[hf]=0;hi[hf+1]=0;hi[hf+2]=0;hi[hf+3]=255}}}else{if(hj%4==1||hj%4==2){for(o=1;o<hh;o+=4){hf=hj*hh*4+o*4;hi[hf]=0;hi[hf+1]=0;hi[hf+2]=0;hi[hf+3]=255}}}}eh.putImageData(hg,0,0)};var gY=function(){if(K!=b||eY){return}K=requestAnimationFrame(ar)};var g3=function(){if(K==b){return}cancelAnimationFrame(K);K=b};var ar=function(){K=b;var o=false;if(gB&&G.runAfterTouch()){o=true}if(!i){if(aZ!=dh){bR.src=e[dh];aZ=dh}}else{if(Q&&fq()){o=true}cq.globalAlpha=1;cq.clearRect(0,0,g2,cQ);fW();if(cY&&dg){if(hc()){o=true}}}if(bI){if(gT){var hh=gS*ba.width;var hf=gS*ba.height;gT=false;var hg=-at.drawOffsetX+(hh-ba.width*at.scale)/2-b0.panPos.left+aP.x*b0.scale;var he=-at.drawOffsetY+(hf-ba.height*at.scale)/2-b0.panPos.top+aP.y*b0.scale;dI.camera.setViewOffset(hh,hf,hg,he,at.totalWidth,at.totalHeight)}if(c9){eo()}if(bF){dI.renderer.render(dI.scene,dI.camera)}if(c9){c9=false;if(eB&&dT){if(!bF){dI.renderer.render(dI.scene,dI.camera)}bH()}}}if(gv){gv=false;if(f2){f2.update(dh,ao)}}if(fO){gi();cq.fillStyle=bj;cq.fillRect(gx.left+1,gx.top+1,gx.width()-1,gx.height()-1);cq.fillStyle=aq;cq.fillRect(gx.left,gx.top,gx.width(),1);cq.fillRect(gx.left,gx.bottom,gx.width(),1);cq.fillRect(gx.left,gx.top,1,gx.height());cq.fillRect(gx.right,gx.top,1,gx.height())}if(aw){dV.draw(Y)}if(dc){if(b3){g(f4,"translate3d("+at.left+"px,"+at.top+"px,0px)"+at.strTransformScale)}else{g(f4,"translate("+at.left+"px,"+at.top+"px)"+at.strTransformScale)}}if(o){gY()}};var eo=function(){var o;if(cL.oSpinPositions){o=cL.oSpinPositions.arPositions[dh]}else{o=et/ej}fe(0,o*F,0)};var gi=function(){gx.copyRect(aJ);gx.offsetRect(-aJ.clientOffset.left,-aJ.clientOffset.top);gx.normalizeRect();if(at.scale!=1){gx.scaleRect(at.scale)}};var dE=function(){c9=gv=true};var ek=function(){return false};var L=function(o){cq.drawImage(o.img.FSI_image_context,o.x,o.y,o.width,o.height);return false};gG.getAccessToken=function(){return aT};this.setAccessToken=function(o){aT=o;if(f8){f8.setAccessToken(aT)}};var gC=function(he){var o;he.alpha+=e1;if(he.alpha>=1){he.fnDraw=L;he.alpha=1;o=false}else{o=true}cq.globalAlpha=he.alpha;L(he);cq.globalAlpha=1;return o};var hc=function(){var o=false;if(z){gL()}if(dg.nVisibleTiles>0){var hi=at.drawOffsetX+W.imageX+b0.panPos.left;var hh=at.drawOffsetY+W.imageY+b0.panPos.top;var hg=W.imageWidth/dg.width;cq.save();cq.translate(hi,hh);cq.scale(hg,hg);var he=dg.arVisibleTiles;for(var hf=0;hf<dg.nVisibleTiles;hf++){if(he[hf].fnDraw(he[hf])){o=true}}cq.restore()}dg.bTilesFading=o;if(!g4&&R&&!o&&dg.bFilesArePreparedForLoading){if(cp.nTilesLoading==0&&dg.arTilesToLoad.length==0){R=false}}return o};var ei=function(o,he){fa=(o=="video");if(fa){eG=b;dr=dn;bS=gG.getPreviewImage=aC;fW=ck}else{bS=gG.getPreviewImage=cz;fW=gl}if(!he){gM=fa;if(gm){if(gR.length>1){if(!gm.showPreviewWhileLoading){b8=fW;fW=a.fnDoNothing}else{if(!gm.spinPreviewWhileLoading){b8=fW;if(!aA.bSetup){aA.bStillPreview=true;fW=a.fnDoNothing}else{if(aA.imgDraw){fW=f6}else{fW=a.fnDoNothing}}}else{b8=b}}}aA.bSetup=true}}};var gO=function(){if(!aA.bStillPreview||aA.bStillPreviewDone){return}gq()};var gq=function(){aA.bStillPreviewDone=true;var hg=cj;cj=true;var hh;var hi=en(gm.initialview);var o;if(aW.bDefault){hh=hi.scene}else{var hf=aW.arSets[hi.SceneSet];hh=hf.arScenes[hi.scene]-1}bK();var he=gE(hh).fullURL;aA.img=new Image();fQ(aA.img,he,"stillPreview",B);cj=hg;bt=b};var B=function(){cn(this);aA.imgDraw=this.FSI_image_context;fW=f6};var f6=function(){av(aA.imgDraw,W.imageX,W.imageY,gS)};var aC=function(o){if(eG==o){return dr}eG=o;g7.putImageData(e[o],0,0);dr=dn;return dr};var cz=function(o){if(eG==o){return dr}eG=o;if(!cX){cX=v.imageWidth;if(gZ){ay=document.createElement("canvas");ay.setAttribute("width",v.imageWidth);ay.setAttribute("height",v.imageHeight);gW=ay.getContext("2d")}}if(!gZ){dr=e[o].FSI_image_context}else{gW.drawImage(e[o].FSI_image_context,0,0,v.imageWidth,v.imageHeight);dr=ay}return dr};var ck=function(){cq.globalAlpha=1;var o=gS*v.videoWidth/cP.croppedWidth;av(aC(dh),W.videoX,W.videoY,o);if(R&&gm.pellets&&!E){cq.globalAlpha=gm.pelletsOpacity;cq.globalCompositeOperation="xor";av(d7,W.videoX,W.videoY,o);cq.globalAlpha=1;cq.globalCompositeOperation="source-over"}};var gl=function(){av(cz(dh),W.imageX,W.imageY,gS)};var av=function(hg,hn,hk,he){var hm=0;var hl=0;var hh=at.drawOffsetX+hn+b0.panPos.left;var hf=at.drawOffsetY+hk+b0.panPos.top;if(hh<0){hm=-hh/he;hh=0}if(hf<0){hl=-hf/he;hf=0}var ho=hg.width-hm;var hj=hg.height-hl;var hi=ho*he;var o=hj*he;cq.drawImage(hg,hm,hl,ho,hj,hh,hf,hi,o)};var cT=function(){if(f2!=b){ed()}if(b0.enabled&&i){f2=new a.NavigatorWindow(gG,f8,aU,gI)}};var ed=function(){if(f2==b){return}f2.destroy();f2=b};var cb=function(){if(!d0||!dI.targetObj){return}var hg=ba.width*at.scale;var hk=ba.height*at.scale;dI.sceneWidth=bb.imageWidth*aP.cropScaleX;dI.sceneHeight=bb.imageHeight*aP.cropScaleY;var hh=dI.sceneWidth;var o=hh/1.5;var hj=o/hk;var hi=gm.camera.digitalCropFactor*gm.camera.focalLength*hj;var he=2*THREE.Math.radToDeg(Math.atan(24/hi/2));dI.camera=new THREE.PerspectiveCamera(he,dI.sceneWidth/dI.sceneHeight,0.1,10000);var hf=f8.parsePositionParameter(gm.camera.position);if(hf!=b){aX.x=hf.x;aX.y=hf.y;aX.z=hf.z}else{if(gm.camera.heightTable!=b&&gm.camera.heightCamera!=b){gm.camera.heightAboveTable=gm.camera.heightCamera-gm.camera.heightTable}if(gm.camera.shiftX==b){gm.camera.shiftX=0}aX.x=gm.camera.shiftX;aX.y=gm.camera.heightAboveTable;aX.z=gm.camera.distanceToTableCenter}dI.camera.position.x=aX.x;dI.camera.position.y=aX.y;dI.camera.position.z=aX.z;eQ();dI.camera.lookAt(dI.targetObj.position);dI.camera.rotation.z=0;e9();dI.camera.setViewOffset(hg,hk,-at.drawOffsetX+aP.x,-at.drawOffsetY+aP.y,hg,hk)};var g9=function(){if(!d0){return}var hF;hF=window.THREE;if(a.BrowserSupports.canvas()&&typeof hF!=="undefined"){if(i){dI.renderer=new hF.CanvasRenderer({canvas:f4,clearColor:0,clearAlpha:0,devicePixelRatio:1});dI.renderer.autoClear=false;dD(ba.width*at.scale,ba.height*at.scale)}else{dI.renderer=new hF.CanvasRenderer({clearColor:0,clearAlpha:0});dI.renderer.autoClear=false;dD(ba.width,ba.height)}dI.scene=new hF.Scene();dI.objects=new hF.Object3D();var ho=new hF.Object3D();var hE=f8.parsePositionParameter(gm.camera.targetPosition);if(hE==b){ho.position.x=gm.camera.targetWidthOffset;ho.position.y=gm.camera.targetHeightOffset;ho.position.z=0}else{ho.position.x=hE.x;ho.position.y=hE.y;ho.position.z=hE.z}dI.scene.add(ho);dI.targetObj=ho;var hn;if(gm.virtualSpace.cubeLineWidth>0&&gm.drawCube){var hC,hf;if(gm.virtualSpace.cubeSizeX){hC=new hF.CubeGeometry(gm.virtualSpace.cubeSizeX,gm.virtualSpace.cubeSizeY,gm.virtualSpace.cubeSizeZ);hn=gm.virtualSpace.cubeSizeY/2}else{hC=new hF.CubeGeometry(gm.virtualSpace.cubeSize,gm.virtualSpace.cubeSize,gm.virtualSpace.cubeSize);hn=gm.virtualSpace.cubeSize/2}hf=new hF.MeshBasicMaterial({color:65280,wireframe:true,wireframeLinewidth:gm.virtualSpace.cubeLineWidth});var hj=new hF.Mesh(hC,hf);if(gm.virtualSpace.shiftY==b){gm.virtualSpace.shiftY=0}hj.position.x=gm.virtualSpace.shiftX;hj.position.y=hn+gm.virtualSpace.shiftY;hj.position.z=gm.virtualSpace.shiftZ;dI.cube=hj;dI.objects.add(hj)}if(gm.drawGroundPlate){var hu=new hF.PlaneGeometry(500,500,10,10);var hp=new hF.MeshBasicMaterial({color:15626314,wireframe:true});var hg=new hF.Mesh(hu,hp);hg.rotation.x=-Math.PI/2;hg.position.y=0;dI.objects.add(hg);dI.plane=hg}if(gm.drawTable){var o=gm.tableDiameter/2;var hy=50;var he=new hF.Geometry();var hG;hG=Math.PI*2/360;var hv=0;var hk=function(hK,hJ){var hM=0;var hN=0;var hR=0;var hL=0;for(var hO=0;hO<=36;hO++,hv+=4){var hI=Math.sin(hG*hO)*hK;var hQ=Math.cos(hG*hO)*hK;var hH=Math.sin(hG*hO)*hJ;var hP=Math.cos(hG*hO)*hJ;he.vertices.push(new hF.Vector3(hH,hP,0));he.vertices.push(new hF.Vector3(hR,hL,0));he.vertices.push(new hF.Vector3(hM,hN,0));he.vertices.push(new hF.Vector3(hI,hQ,0));he.faces.push(new hF.Face3(hv,hv+1,hv+2));hM=hI;hN=hQ;hR=hH;hL=hP}};var hl=0;var hi=0;for(var hD=0;hD<=4;hD++,hv+=3){var hs=Math.sin(hG*hD*90)*hy;var hr=Math.cos(hG*hD*90)*hy;he.vertices.push(new hF.Vector3(0,0,0));he.vertices.push(new hF.Vector3(hs,hr,0));he.vertices.push(new hF.Vector3(hl,hi,0));he.faces.push(new hF.Face3(hv,hv+1,hv+2));hl=hs;hi=hr}hG=Math.PI*2/36;var hx=0;var hw=hy;while(hw<o){hx+=hy;hw=hx+hy;if(hw>o){hw=o}hk(hx,hw)}var hB=new hF.Mesh(he,new hF.MeshBasicMaterial({color:5810431,wireframe:true}));hB.rotation.x=-Math.PI/2;dI.disk=hB;dI.objects.add(hB)}if(gm.hotspots&&gm.hotspots.points){aS();ge=gm.hotspotCallbackFunction;if(typeof(ge)=="string"){try{ge=window[ge]}catch(hA){}}else{if(typeof(ge)!="function"){ge=b}}var ht=1;ex={};for(var hz=0;hz<gm.hotspots.points.length;hz++,ht++){var hm=gm.hotspots.points[hz];hm.FSIHotspotID=ht;ex[ht]=hm;if(hm.perimeterAngle!=b&&hm.perimeterAngleY==b){hm.perimeterAngleY=hm.perimeterAngle;hm.perimeterAngleYRange=hm.perimeterAngleRange;hm.perimeterAngleYFadeOut=hm.perimeterAngleFadeOut}if(hm.perimeterAngleY&&hm.perimeterAngleY<0){hm.perimeterAngleY=360+hm.perimeterAngleY}hm.perimeterAngleYFadeOut=Math.min(hm.perimeterAngleYRange,hm.perimeterAngleYFadeOut);if(hm.perimeterAngleX!=b&&hm.perimeterAngleX<0){hm.perimeterAngleX=360+hm.perimeterAngleX}hm.perimeterAngleXFadeOut=Math.min(hm.perimeterAngleXRange,hm.perimeterAngleXFadeOut);var hq=new hF.Object3D();hq.position.x=hm.x+gm.virtualSpace.shiftX;hq.position.y=hm.y+gm.virtualSpace.shiftY;hq.position.z=hm.z+gm.virtualSpace.shiftZ;hm.object=hq;dI.objects.add(hq);if(gm.hotspots.defaults){for(var hh in gm.hotspots.defaults){if(hm[hh]==b){hm[hh]=gm.hotspots.defaults[hh]}}}dj(hm)}ds.log(hz+" HotSpots created.")}dI.scene.add(dI.objects);cb()}};var fd=function(o){var he=o.type;fK(he,this)};var fK=function(hh,hf){var hj=false;var o=hf.FSIHotspot;if(!o||!hh){return false}switch(hh){case"mouseover":a.addClass(hf,o.hoverClass);o._bMouseOver=true;o.marker.style.zIndex=o.tooltip.style.zIndex=5000000;break;case"mousedown":a.addClass(hf,o.activeClass);break;case"mouseout":o._bMouseOver=false;a.removeClass(hf,o.hoverClass);o.marker.style.zIndex=o.tooltip.style.zIndex=o.zIndex;break;default:a.removeClass(hf,o.activeClass)}if(ge){var hi=o.FSIHotspotID;var hg=o.tooltip;var hl=o.actionParameter;var hk=ge(hh,a9,M,hi,hg,hl,o.perimeterAngleY,o.perimeterAngleX);if(hk===true){hj=true}}if(hh=="click"){if(o.url!=b){window.open(o.url,o.urlTarget);hj=true}if(hj==false&&o.focusOnClick==true){var he=fb(o);gN(he,true);hj=true}}cy.run("onHotspotEvent",[hh,o.FSIHotspotID,o.id,o.text]);return hj};var fe=function(hf,he,o){dI.objects.rotation.x=hf;dI.objects.rotation.y=he+gm.virtualSpace.baseRotationYRad;dI.objects.rotation.z=o};var bH=function(){var hv,hx;var hq=new THREE.Vector3();if(dH){dH=false;var hf=1/eI;gX.testWidth=gS*v.imageWidth;V.style.webkitTransform="scale("+hf+")";V.style.transform="scale("+hf+","+hf+")"}var hz=eI*at.left;var hy=eI*at.top;var hA=eI*ba.width/2;var hi=eI*ba.height/2;var hm,ho;var hu=false;var hn;var hC=ba.width*eI;var hB=ba.height*eI;if(gX.spinFrame!=dh){gX.spinFrame=dh;if(gX.arSpotsAtFrame==b){gX.arSpotsAtFrame=new Array(ej)}var ht=gX.hotSpotsAtThisFrame;gX.hotSpotsAtThisFrame=gX.arSpotsAtFrame[dh];if(gX.hotSpotsAtThisFrame==b){var hl;if(cL.oSpinPositions){hl=gm.virtualSpace.rotationYRange*cL.oSpinPositions.arPositions[dh]}else{hl=gm.virtualSpace.rotationYRange*g6(et)/ej}gX.hotSpotsAtThisFrame=gX.arSpotsAtFrame[dh]=[];for(hx=0;hx<gm.hotspots.points.length;hx++){hn=gm.hotspots.points[hx];ho=1;if(hn.perimeterAngleY!=b){var hD=Math.abs(hn.perimeterAngleY-hl);if(hD>180){hD=Math.abs(360-hD)}if(hD<hn.perimeterAngleYRange){if(hD>hn.perimeterAngleYRange-hn.perimeterAngleYFadeOut){ho=(hn.perimeterAngleYRange-hD)/hn.perimeterAngleYFadeOut}}else{ho=0}}if(ho!=0){var hs={};hs.index=hx;hs.hotspot=hn;hs.op=ho;gX.hotSpotsAtThisFrame.push(hs);hq.setFromMatrixPosition(hn.object.matrixWorld);hn.zIndex=hs.zIndex=Math.round(hq.z);if(!hn._bMouseOver){hn.marker.style.zIndex=hn.tooltip.style.zIndex=hn.zIndex}}}}if(ht&&ht.length>0){var hr={};for(hv=0;hv<gX.hotSpotsAtThisFrame.length;hv++){var he=gX.hotSpotsAtThisFrame[hv];hn=he.hotspot;if(!hn._bMouseOver){hn.marker.style.zIndex=hn.tooltip.style.zIndex=hn.zIndex}hr[he.index]=hn.bVisible}for(hv=0;hv<ht.length;hv++){if(!hr[ht[hv].index]){bE(ht[hv].hotspot,false)}}}}if(gX.scale!=eI){gX.scale=eI;hu=true}for(hx=0;hx<gX.hotSpotsAtThisFrame.length;hx++){var hg=gX.hotSpotsAtThisFrame[hx];hn=hg.hotspot;ho=1;if(cL.visibleHotSpots){ho=cL.visibleHotSpots[hn.FSIHotspotID]}ho=ho*hg.op;if(!hu&&hn._opScale!=b){if(hn._opScale==0){ho=0}}else{hn._opScale=1;if(gm.enableZoom&&hn.perimeterZoom!=b){if(gS<hn.perimeterZoom){ho=hn._opScale=0}}if(ho!=0&&hn.perimeterImageWidth!=b){if(gX.testWidth<hn.perimeterImageWidth){ho=hn._opScale=0}}}if(ho!=0){hq.setFromMatrixPosition(hn.object.matrixWorld);hq.project(dI.camera);var hk=Math.round(hz+hq.x*hA+hA);var hj=Math.round(hy+hi-hq.y*hi);if(b0.enabled){if(hk<0||hj<0||hk>hC||hj>hB){ho=0}}}if(ho!=0){bE(hn,true);if(hn._opacity!=ho){hn._opacity=ho;hn.marker.style.opacity=hn.tooltip.style.opacity=ho}var hp=hn.oSvg;hn.tooltip.style.left=hk+hp.endX+(hn.tooltip.offsetWidth*hp.xAlign)+"px";hn.tooltip.style.top=hj+hp.endY+(hn.tooltip.offsetHeight*hp.yAlign)+"px";hn.marker.style.left=hk+hp.startX+"px";hn.marker.style.top=hj+hp.startY+"px"}else{bE(hn,false)}}};var aN=function(hg,hl,he,hk,o,hj,hh,hf,hi){if(hf==b){hf=bs}if(hi==b){hi=1}var hm=document.createElementNS(dw,"polyline");hm.setAttribute("points",hg+","+hl+" "+he+","+hk+" "+o+" , "+hj+" "+he+","+hk+" "+hg+","+hl);hm.setAttribute("stroke",hh);hm.setAttribute("stroke-width",hf);hm.setAttribute("stroke-opacity",hi);hm.setAttribute("stroke-linecap","square");return hm};var aS=function(){var he=aG=document.createElementNS(dw,"svg");try{if(!he.style){aG=b;ds.log("ERROR: SVG Gradient not supported");return false}}catch(hg){aG=b;ds.log("ERROR: SVG Gradient not supported");return false}var hj=a.getSVGID();var hf=gm.hotspotDotRadius;he.setAttribute("xmlns",dw);he.setAttribute("version",fJ);he.setAttribute("baseProfile","tiny");var o=bJ=he.cloneNode(true);try{var hl=document.createElementNS(dw,"radialGradient");hl.setAttribute("id",hj);hl.setAttribute("cx","0.5");hl.setAttribute("cy","0.5");hl.setAttribute("r","0.5");var hk=document.createElementNS(dw,"stop");hk.setAttribute("stop-color",gm.hotspotDotColor1);hk.setAttribute("offset","0.5");var hi=document.createElementNS(dw,"stop");hi.setAttribute("stop-color",gm.hotspotDotColor2);hi.setAttribute("offset","1");hl.appendChild(hk);hl.appendChild(hi);o.appendChild(hl);o.style.position="absolute";o.style.width="0px";o.style.height="0px";o.style.left="0";o.style.top="0";o.style.zIndex=-500000;o.style.visibility="hidden";V.appendChild(o)}catch(hg){ds.log("ERROR: SVG Gradient not supported")}var hh=document.createElementNS(dw,"circle");hh.setAttribute("r",hf);hh.setAttribute("stroke",gm.hotspotLineColor2);hh.setAttribute("stroke-width","1px");hh.setAttribute("stroke-opacity","0.85");hh.setAttribute("fill","url(#"+hj+")");hh.setAttribute("fill-opacity","0.5");he.appendChild(hh);return true};var a5=function(hj){var hn=hj.horizontalMarkerSize;var hr=Math.abs(hj.verticalMarkerSize);var hv;if(!aG){return{width:0,height:0,startX:0,startY:0,endX:0,endY:0,xAlign:0,yAlign:0}}var hl=hj.markerAngle*Math.PI/180;var hs,hh,hq,hg,ho,hf;var hx={};var hi=hx.radius=gm.hotspotDotRadius+1;hv=Math.max(0,Math.min(1,hj.horizontalMarkerPosition));if(hv>0.5){hn=-hn}hx.xAlign=-hv;hv=Math.max(0,Math.min(1,hj.verticalMarkerPosition));hx.yAlign=-hv;hs=0;hh=0;hq=hs+Math.sin(hl)*hr;hg=hh-Math.cos(hl)*hr;ho=hq+hn;var ht=Math.min(hs-hi,hq);var o=Math.min(hh-hi,hg);ht=Math.min(ht,ho);hs-=ht;hq-=ht;ho-=ht;hh-=o;hg-=o;hf=hg;hx.startX=-hs;hx.startY=-hh;hx.endX=hx.startX+ho;hx.endY=hx.startY+hf;var hw=Math.max(hs+hi,hq);hw=Math.max(hw,ho);var he=Math.max(hh+hi,hg);var hm=hx.svg=aG.cloneNode(true);var hk=hx.width=hw;var hp=hx.height=he;hm.setAttribute("width",hk);hm.setAttribute("height",hp);hm.setAttribute("viewBox","0 0 "+hk+" "+hp);hm.setAttribute("class","fsi-ui-hotspot-line");var hu=hm.firstChild;hu.setAttribute("cx",hs);hu.setAttribute("cy",hh);hs+=Math.sin(hl)*hi;hh-=Math.cos(hl)*hi;hm.appendChild(aN(hs,hh,hq,hg,ho,hf,gm.hotspotLineColor1,"5px","0.25"));hm.appendChild(aN(hs,hh,hq,hg,ho,hf,gm.hotspotLineColor2,"1px"));return hx};var bE=function(he,o){if(he.bVisible==o){return}he.bVisible=o;if(o){he._opacity=b;he.marker.style.display=he.tooltip.style.display="block"}else{he.marker.style.display=he.tooltip.style.display="none";he._opacity=0;he.marker.style.opacity=he.tooltip.style.opacity=0}};var dj=function(hi){var he=document.createElement("div");var hf="fsi-ui-hotspot";if(b1){hf+=" "+b1}if(hi.cssClass!=b&&hi.cssClass.length>0){hf+=" "+hi.cssClass}if(hi.normalClass.length>0){hi.normalClass=hf+" "+hi.normalClass}else{hi.normalClass=hf}if(hi.hoverClass.length>0){hi.hoverClass="fsi-ui-hotspot-hover "+hi.hoverClass}else{hi.hoverClass="fsi-ui-hotspot-hover"}if(hi.activeClass.length>0){hi.activeClass="fsi-ui-hotspot-active "+hi.activeClass}else{hi.activeClass="fsi-ui-hotspot-active"}he.className=hi.normalClass;var hg="position:absolute;left:0px;top:0px;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;"+hi.cssStyle;a.setStyleAttr(he,hg);he.innerHTML=hi.text;if(gm.decodeHTMLEntitiesInHotSpotTexts){he.innerHTML=he.innerText}var hh=a5(hi);var o;if(hh&&hh.svg){o=hh.svg;o.style.position="absolute";V.appendChild(o)}else{o={style:{}}}if(hi.interactive){he.FSIHotspot=hi;V.appendChild(he);a.addEvent(he,"mouseover",fd);a.addEvent(he,"mouseout",fd)}else{he.style.zIndex="1";V.appendChild(he)}hi.bVisible=false;hi.tooltip=he;hi.marker=o;hi.oSvg=hh;he.style.display="none";o.style.display="none"};var cU=function(o){az();var he=true;var hf=(ej&&!c2);fn=o.shiftKey;switch(o.keyCode){case 37:if(hf){bN();dB=1;gP(d9+dC)}he=false;break;case 39:if(hf){bN();dB=-1;gP(d9-dC)}he=false;break;case 32:he=false;break}if(!he&&o.preventDefault){o.preventDefault()}return he};var ch=function(o){fn=o.shiftKey;if(ds&&ds.on){if(!fn){bU(bV)}}var he=true;var hf=(ej&&!c2);switch(o.keyCode){case 37:if(hf){eD(et,true)}he=false;break;case 39:if(hf){eD(et,true)}he=false;break;case 32:a9.resetView();he=false;break}if(!he){o.cancelBubble=true;if(o.stopPropagation){o.stopPropagation()}if(o.preventDefault){o.preventDefault()}}return he};this.resetView=function(){az(false);er();dk=by;if(gm.initialview&&gm.initialViewPersistent){gN(gm.initialview,true)}else{gN("1,1,0,0,1,1",true)}dk=by};this.spinToDegree=function(o){if(!cj){return}var he=g6(Math.round(o/360*ej));a9.spinToTarget(he)};this.spinToTarget=function(hg,hj,hh){if(!cj){return}hg=dd(hg);var hm=g6(et);var hi=hg-hm;var o=(hj!=b&&!isNaN(hj)&&hj!=aW.nCurrent);if(hi==0&&!o){ec(hg,hg,0,0);return true}var hl;if(hi!=0){dB=(hi>0)?1:-1;hl=hm;if(!gm.noSceneLoop){if(Math.abs(hi)>ej/2){if(dB>0){hg-=ej}else{hl-=ej}dB=-dB;hi=Math.abs(hg-hl)}}}else{hl=hg}var he=aW.nCurrent;var hk;if(o&&!gm.noSetLoop&&aW.nSceneSets>1){hk=hj-aW.nCurrent;if(Math.abs(hk)>aW.nSceneSets/2){if(hk>0){hj-=aW.nSceneSets}else{he-=aW.nSceneSets}}}bN();if(hh==b||isNaN(hh)){hh=4;if(hi!=0){hh=Math.ceil(0.2*360/ej*Math.abs(hi))}if(o){hk=Math.abs(hj-he);var hf=Math.ceil(0.1*360/aW.nSceneSets*hk);hh=Math.max(hh,hf)}}ec(hl,hg,0,hh,he,hj);return true};var X=function(o){if(aW.nSceneSets<2){return 0}if(gm.noSetLoop){o=Math.max(0,Math.min(aW.nSceneSets-1,o))}else{o=o%aW.nSceneSets;if(o<0){o=aW.nSceneSets+o}}return o};var dW=function(){cL={};aW.bSetCameraPosition=false;aW.initialScene=aW.initialSceneSet=aW.nCurrent=0;aW.arCurrentSetIndex=false;bx=ad=gR.length;cJ=(e.length>0)?e.length:bx;aQ(cJ);aR=false};var bh=function(){if(aW.bHasMultipleSets||!aW.bDefault){aQ(aW.quantizeMax);ad=aW.quantizeMax;aW.nCurrent=b;fG(0)}else{dW()}};var fG=function(hf){hf=X(hf);if(hf==aW.nCurrent){return}aW.nCurrent=hf;cL=aW.arSets[hf];var he=aW.arCurrentSetIndex=aW.arSets[hf].arScenes;aR=he;bx=aW.quantizeMaxImages;cJ=bx;if(aW.nVideoSet!=b){if(aW.nVideoSet==hf){ad=bx=he.length;cJ=dz;if(f2){f2.setPreviewImageSize(cP.croppedWidth,cP.croppedHeight)}if(!fa){ei("video",true)}aR=b}else{if(f2){f2.setPreviewImageSize()}ad=aW.quantizeMax;if(fa){ei("image",true)}}}e9();dE();var o=et;eG=et=b;if(dg){dg.spinPos=b}b9(o);gY();return hf};var e9=function(){if(!aW.bSetCameraPosition||!cL.posCamera){return}var o=cL.posCamera;dI.camera.position.set(o.x,o.y,o.z);dI.camera.lookAt(dI.targetObj.position);dI.camera.rotation.z=0};var aY=function(o){o=Math.max(0,Math.min(ej-1,o));return o};var eU=function(o){o%=ej;if(o<0){o=ej+o}return o};var dd=function(he,hh){if(!gM){return he}var hg;var o=ej/bx;var hf=Math.round(he/o)*o;if(!hh||he==hf){hg=hf}else{if(dB==1){hg=Math.round(hf+o)}else{hg=Math.round(hf-o)}}hg=g6(hg);return hg};var eD=function(o,hg){var he=(o!=b)?o:et;var hf=dd(he,hg);a9.spinToTarget(hf)};var ec=function(o,hh,hi,hg,hf,he){o=Math.round(o);hh=Math.round(hh);bN();if(he!=b&&!isNaN(he)&&he!=aW.nCurrent){if(hf==b){hf=aW.nCurrent}}else{hf=b}if(o!=hh||hf!=he){if(bi(o,hh,hi,hg,hf,he)){bW("spinToFrame")}else{ga("doSpinToFrame")}}else{ga("doSpinToFrame")}};var bN=function(){if(ft==b){return}cancelAnimationFrame(ft);ft=b;ga("cancelSpinToFrame")};var bi=function(hh,hn,hm,hi,he,hk){var hl=hn-hh;var hj;if(hl==0){hj=hn}else{hj=aF(hm,hi,hh,hl)}var hg;if(he!=b){var hf=hk-he;hg=Math.round(aF(hm,hi,he,hf))}if(hm!=hi){if(eN){eN.lockImageSourceDimension(bR,true);eN.lockImage(bR,true)}var o=Math.round(hj);if(o<0){o=ej+o}else{if(o==ej){o=0}}ft=requestAnimationFrame(function(){if(he!=b){fG(hg)}if(o!=et){dE();b9(o);gY()}bi(hh,hn,++hm,hi,he,hk)});return true}else{ft=b;if(eN){eN.lockImage(bR,false)}b9(g6(hn));if(hk!=b){fG(hk)}b6();cc();ga("doSpinToFrame")}};var b6=function(){b9(g6(et));gY();if(i){fc()}};var gE=function(he){var o={};o.baseURL=f8.getImageURL(gR[he],e7);o.fullURL=o.baseURL+gH;return o};var fi=function(){if(!dg){return}cf=b;dg=b;bc=b;R=true;O();d6()};var d6=function(){aK.abortPurpose("tile")};var bK=function(){if(bt==bG){return}bt=bG;var o=fk.getPixelRangeRect(bG);gH=fk.getPixelRangeParametersByCalculatedResult(o)};var aB=function(o){if(o==b){o=Math.round(et/(ej/ad))}if(isNaN(o)||o<0||o>=ad){ds.error("invalid image index in loadHDImage "+o);return}if(aW.arCurrentSetIndex){o=aW.arCurrentSetIndex[o]}o-=dz;return o};var fc=function(hq){if(i&&!fa&&gS<=1){fi();return}if(eY||cf==bG){return}cf=bG;hq=aB(hq);bK();var o=gE(hq);if(bc==o.fullURL){return}if(dg&&o.fullURL==dg.src){return}cp={};cp.img=new Image();cp.nImage=hq;cp.renderScale=gS;var he=ej/bx;cp.spinPos=dd(hq*he);cp.img.crossOrigin="anonymous";cp.img.FSI_ImageObject=cp;bc=cp.src=o.fullURL;if(i){R=true;cp.bTilesFading=false;cp.bFillsViewport=false;var hl=eO.width;var hk=eO.height;var hj=bG;var hh=Math.round(hj/hl*hk);d6();cp.width=hj;cp.height=hh;var hr=fs;cp.tiles=[];var ho=0;var hm=0;var hp=hr;var hn=hr;hp=Math.min(hp,hj);hn=Math.min(hn,hh);var hg;var hf=false;while(hm<hh){hg={};hg.fnDraw=ek;hg.FSI_ImageObject=cp;hg.x=ho;hg.y=hm;if(ho+hp>=hj){hg.width=hj-ho;hp=Math.min(hr,hj-ho);hf=true}hg.width=hp;hg.height=hn;var hi=fk.getPixelRangeParameters(hj,hh,ho,hm,hp,hn);hg.url=o.baseURL+hi;if(hf){hf=false;hm+=hr;ho=0;hp=hr;if(hm+hr>hh){hn=Math.min(hr,hh-hm)}}else{ho+=hr}cp.tiles.push(hg)}cp.nTiles=cp.tiles.length;cp.arVisibleTiles=new Array(cp.nTiles);cp.nVisibleTiles=0;cp.nTilesLoading=0;cp.nTilesLoaded=0;cp.nTilesRequested=0;cp.nTileColumns=Math.ceil(hj/hr);cp.nTileRows=Math.ceil(hh/hr);z=true;P(null,cp)}};var eb=function(o){o.bLoading=true;o.img=new Image();o.img.oTile=o;fQ(o.img,o.url,"tile",a6)};var a6=function(){a.removeEvent(this,"load",a6);var he=this.oTile;he.bLoading=false;he.bLoaded=true;var o=he.FSI_ImageObject;if(o.nTilesLoaded===o.nTiles){o.bComplete=true;o.bFillsViewport=true}if(o.src!==bc){return}he.alpha=0;he.fnDraw=gC;o.nTilesLoading--;o.nTilesLoaded++;P(null,o);cn(this);gY();cS(25)};var b5=function(he,o){return o.distance-he.distance};var gL=function(){z=false;if(!dg){return}var hk=dg;var hu,ht,hf,o;var hj;if(b0.enabled){fp.setRect(0,0,ba.width,ba.height);fp.scaleRect(1/b0.scale);fp.offsetRect(-b0.panPos.left/gS,-b0.panPos.top/gS);fp.offsetRect((ba.width-fp.width())/2,(ba.height-fp.height())/2);dG.copyRect(a1);dG.scaleRect(1/b0.scale);dG.offsetRect(fp.left,fp.top);hj=dG}else{hj=a1}ci(hj);hu=fF.left;ht=fF.top;hf=fF.right;o=fF.bottom;var hq=Math.max(0,Math.floor(hu/fs));var hg=Math.min(hk.nTileColumns-1,Math.floor(hf/fs));var hp=Math.max(0,Math.floor(ht/fs));var he=Math.min(hk.nTileRows-1,Math.floor(o/fs));var hh=hg-hq+1;var hl=he-hp+1;var hm=Math.max(0,hl)*hh;if(hk.nFirstTileXLastGetVisible===hq&&hk.nFirstTileYLastGetVisible===hp&&hk.nTilesLastGetVisible===hm){return}hk.nFirstTileXLastGetVisible=hq;hk.nFirstTileYLastGetVisible=hp;hk.nTilesLastGetVisible=hm;var hw=hk.tiles;var hv=hk.arVisibleTiles;var hn=hp*hk.nTileColumns;var hi=hq;var ho;var hs=g4;for(var hr=0;hr<hm;hr++){ho=hv[hr]=hw[hn+hi];if(!hs&&ho.alpha!==1){hs=true}if(++hi>hg){hi=hq;hn+=hk.nTileColumns}}hk.nVisibleTiles=hm;hk.bFilesArePreparedForLoading=false;if(hs&&!R){cq.globalAlpha=1;fW()}if(hs){R=hs}cS(50)};var O=function(){if(gp){clearTimeout(gp);gp=b}};var cS=function(o){if(gp!==b){return}if(!dg||dg.bRequestsComplete){return}gp=setTimeout(gz,o)};var gz=function(){O();D()};var D=function(){if(Q){return}var hh=dg;if(hh.nTilesLoading>=eK){return}var hk,hf,he,hg,hj;if(!hh.bFilesArePreparedForLoading){hh.bFilesArePreparedForLoading=true;if(!hh.arTilesToLoad||hh.arTilesToLoad.length!=0){hh.arTilesToLoad=[]}hk=hh.arTilesToLoad;var hi=hh.arVisibleTiles;for(hg=0;hg<hh.nVisibleTiles;hg++){if(!hi[hg].bLoaded&&!hi[hg].bLoading){hk.push(hi[hg])}}if(hk.length>1){b0.centerX=fF.left+fF.width()/2;b0.centerY=fF.top+fF.height()/2;for(hg=0;hg<hk.length;hg++){hj=hk[hg];hf=hj.x-b0.centerX+hj.width/2;he=hj.y-b0.centerY+hj.height/2;hj.distance=Math.abs(hf)+Math.abs(he)}hk.sort(b5)}}var o=0;hk=hh.arTilesToLoad;while(hh.nTilesLoading<eK&&hk.length>0){hj=hk.pop();eb(hj);o++;hh.nTilesLoading++}hh.nTilesRequested+=o;if(hh.nTilesRequested==hh.nTiles){hh.bRequestsComplete=true}};var P=function(o,he){if(he==b){a.removeEvent(this,"load",P);he=this.FSI_ImageObject;he.width=this.width;he.height=this.height}if(he.src!=bc){return}cn(this);dg=he;if(hb){return}if(gf){gY()}};var be=this.clickMenuButton=function(o){gG.pressMenuButton(o,b,true);gG.releaseMenuButton(o,b,true);gG.clickMenuButton(o,b,true)};this.pressMenuButton=function(o){cN.pressButton(o)};this.releaseMenuButton=function(o){cN.releaseButton(o)};gG.onUserAction=function(){};gG.pressMenuButton=function(hf,o,hh){if(!hh){gG.onUserAction()}if(hf!="ToggleAutoSpin"&&hf!="ToggleFullScreen"){az()}er();bM();var he,hg;if(hf.indexOf("_")!=-1){he=hf.split("_");hf=he[0];hg=he[1]}switch(hf){case"Reset":a9.resetView();break;case"ZoomOut":case"ZoomIn":aa(hf,150,10);break;case"MouseMode":e6(parseInt(hg));break;case"MaxZoom":fz(b,b,b0.scaleToSourceImage-gS,false,30);break}};var cv=function(he,o){if(!cN){return false}return cN.enableButton(he,o)};gG.releaseMenuButton=function(he,o,hf){if(!hf){gG.onUserAction()}bM()};gG.clickMenuButton=function(hg,o,hi){var he,hh;if(typeof(hg)=="string"&&hg.indexOf("_")!=-1){he=hg.split("_");hg=he[0];hh=he[1]}switch(hg){case"ToggleFullScreen":if(a.FullScreen.getEnabled()){a.FullScreen.quit();dp()}else{var hf=dy;if(typeof(hf)=="string"){hf=document.getElementById(hf);if(hf==b){hf=am}}dO=hf;a.FullScreen.start(hf);dp()}break;case"HotSpots":df=cN.getButtonPressed("HotSpots");fT(df);break;case"ToggleAutoSpin":gs();break}};var ae=function(he){if(!b0.enabled){return}var o=gS;fV(he);b0.panPos.left*=gS/o;b0.panPos.top*=gS/o;bY(true)};var fr=function(he){var o;if(he==b){he=bC.cmd;bC.nRepeatCount++}switch(he){case"ZoomOut":o=(bC.nRepeatCount<1)?1.01:1.035;ae(b0.scale/o);break;case"ZoomIn":o=(bC.nRepeatCount<1)?1.01:1.035;ae(b0.scale*o);break}if(bC.nRepeatCount==1){if(bC.intervalTimeFirst!=bC.intervalTimeRepeat){clearInterval(bC.interval);bC.interval=setInterval(fr,bC.intervalTimeRepeat)}}};var aa=function(hf,o,he){aM(false);bM();bC={};bC.bRunning=true;if(o==b){o=500}bC.intervalTimeFirst=o;if(he==b){bC.intervalTimeRepeat=o}else{bC.intervalTimeRepeat=he}bC.nRepeatCount=0;bC.cmd=hf;bC.interval=setInterval(fr,bC.intervalTimeFirst);fr(hf)};var bM=function(){if(!bC.bRunning){return}aM(true);clearInterval(bC.interval);switch(bC.cmd){case"ZoomOut":case"ZoomIn":eM();break}bC={}};var eL=function(o){if(S!=b){if(S.width!=bb.imageWidth){bz()}else{return}}if(fu>0&&e.length==fu){return}bz();aK.abortPurpose("asyncResize");S={};S.width=bb.imageWidth;S.previewImageCanvasWidthBeforeResize=o;S.uniqueInstanceID=ak;S.nTimeout=setTimeout(d1,50)};var d1=function(){if(!cj){S.nTimeout=setTimeout(d1,250);return}S.nTimeout=b;S.img=new Image();a.addEvent(S.img,"load",aj);a.addEvent(S.img,"error",aj);var hf=0;var he=dh;S.pos=0;S.arIndex=new Array(gR.length);if(he>=fu){S.arIndex[0]=he;hf+=1}for(var o=fu;o<e.length;o++){if(o!=dh){S.arIndex[hf++]=o}}aj()};var aj=function(o){if(o!=b){if(!S||S.uniqueInstanceID!=ak){return}a.removeEvent(S.img,"load",aj);cn(S.img);e[S.indexCurrent]=S.img;if(S.indexCurrent==dh){ay=b;cX=b;eG=b;bS(S.indexCurrent);gY()}S.img=new Image();a.addEvent(S.img,"load",aj)}S.indexCurrent=S.arIndex[S.pos];S.pos++;if(S.pos>gR.length){bz()}else{var he=bG;bG=aD;bK();S.url=gE(S.indexCurrent-dz).fullURL;bG=he;bK();S.nTimeout=setTimeout(da,25)}};var da=function(){fQ(S.img,S.url,"asyncResize")};var bz=function(){if(S==b){return}if(S.nTimeout){clearTimeout(S.nTimeout);S.nTimeout=b}a.removeEvent(S.img,"load",aj);a.removeEvent(S.img,"error",aj);S=b};var cM=function(){dp()};var aV=function(){ds.error("ERROR entering FullScreen")};this.setFullScreenElement=function(o){f8.cfg.fullscreenelement=o};var dp=function(o){var he=a.FullScreen.getEnabled();if(he==d5){return}if(cN){cN.setButtonPressed("ToggleFullScreen",he)}cy.runPersistent("onFullScreen",[he]);d5=he;a.setCustomEventListenerProperty(gD,"skiptreshold",true);if(m){a9.showAboutWindow()}if(he==true){a.addClass(dO,"fsi-fullscreen-element")}else{a.removeClass(dO,"fsi-fullscreen-element")}if(!he){dO=b}};this.getInFullScreenMode=function(){return d5};this.getSpinFrames=function(){return ej};this.getImageIsTransparent=function(){return dK};this.getSrcDim=function(){return eO};if(typeof(ef)!=="object"||a.makeBool(ef.autoInit,true)){a9.init(gd,ef)}};(function(){var d="fsi-viewer";var e="display:block;width:300px;height:300px;";var g=a.customTags[d];if(g){return}var c=function(i){var h=a.attributes2parameters(i);if(h.src!==b&&h.imagesrc===b){h.imagesrc=h.src}return h};var f={};f.registerElement=function(){a.addViewerClassCSSRule(d,e);var h=Object.create(HTMLDivElement.prototype);h.createdCallback=function(){a.customTagDimFromAttributes(this);a.Viewer.prototype.constructor.call(this,this,{autoInit:false})};h.attachedCallback=function(){if(this.getInitDone()){return}this.init(this,c(this));this.start()};h.detachedCallback=function(){this.destroyOnDetach()};document.registerElement(d,{prototype:h})};f.replaceTagInit=function(h){a.addViewerClassCSSRule(d,e)};f.replaceTag=function(h){if(!h||(typeof(h.getInitDone)==="function"&&h.getInitDone())){return}a.customTagDimFromAttributes(h);a.Viewer.prototype.constructor.call(h,h,c(h));h.start()};a.registerCustomTag(d,f)}())}(window.$FSI=window.$FSI||{}));