/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MinFilterShape;

abstract class MinFilterOpImage
extends AreaOpImage {
    protected MinFilterShape maskType;
    protected int maskSize;

    public MinFilterOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, MinFilterShape minFilterShape, int n) {
        super(renderedImage, imageLayout, map, true, borderExtender, (n - 1) / 2, (n - 1) / 2, n / 2, n / 2);
        this.maskType = minFilterShape;
        this.maskSize = n;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, this.maskSize);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, this.maskSize);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    protected abstract void byteLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void shortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void ushortLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void intLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void floatLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    protected abstract void doubleLoop(RasterAccessor var1, RasterAccessor var2, int var3);

    static int minFilter(int[] nArray) {
        if (nArray.length == 3) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            if (n < n2) {
                return n < n3 ? n : n3;
            }
            return n2 < n3 ? n2 : n3;
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    static float minFilterFloat(float[] fArray) {
        if (fArray.length == 3) {
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (f < f2) {
                return f < f3 ? f : f3;
            }
            return f2 < f3 ? f2 : f3;
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            f = fArray[i];
        }
        return f;
    }

    static double minFilterDouble(double[] dArray) {
        if (dArray.length == 3) {
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            if (d < d2) {
                return d < d3 ? d : d3;
            }
            return d2 < d3 ? d2 : d3;
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }
}

