/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleGeneralOpImage
extends ScaleOpImage {
    private int subsampleBits;
    private int one;
    Rational half = new Rational(1L, 2L);
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.interp_width = interpolation.getWidth();
        this.interp_height = interpolation.getHeight();
        this.interp_left = interpolation.getLeftPadding();
        this.interp_top = interpolation.getTopPadding();
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n];
        int[] nArray3 = null;
        int[] nArray4 = null;
        float[] fArray = null;
        float[] fArray2 = null;
        switch (rasterAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                nArray4 = new int[n2];
                nArray3 = new int[n];
                this.preComputePositionsInt(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: 
            case 5: {
                fArray2 = new float[n2];
                fArray = new float[n];
                this.preComputePositionsFloat(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        long l = n9;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n10 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n8;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n11 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = (n11 - n) * n3;
            nArray3[n5] = (int)((float)l8 / (float)l9 * (float)this.one);
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l8 += l10) < l9) continue;
            ++n11;
            l8 -= l9;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            nArray2[n5] = (n10 - n2) * n4;
            nArray4[n5] = (int)((float)l3 / (float)l4 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l3 += l5) < l4) continue;
            ++n10;
            l3 -= l4;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n5;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        long l = n9;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n10 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n8;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n11 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = (n11 - n) * n3;
            fArray[n5] = (float)l8 / (float)l9;
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l8 += l10) < l9) continue;
            ++n11;
            l8 -= l9;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            nArray2[n5] = (n10 - n2) * n4;
            fArray2[n5] = (float)l3 / (float)l4;
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l3 += l5) < l4) continue;
            ++n10;
            l3 -= l4;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        for (int i = 0; i < n5; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray5[i];
            int n9 = nArray6[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                for (int k = 0; k < n3; ++k) {
                    int n13 = nArray3[k];
                    int n14 = nArray[k];
                    int n15 = this.interp_left * n + this.interp_top * n2;
                    n15 = n14 + n12 - n15;
                    int n16 = 0;
                    int n17 = 0;
                    for (int i2 = 0; i2 < this.interp_height; ++i2) {
                        int n18 = n15;
                        for (int i3 = 0; i3 < this.interp_width; ++i3) {
                            nArray7[n17][n16++] = byArray4[n15] & 0xFF;
                            n15 += n;
                        }
                        ++n17;
                        n16 = 0;
                        n15 = n18 + n2;
                    }
                    int n19 = this.interp.interpolate(nArray7, n13, n11);
                    if (n19 > 255) {
                        n19 = 255;
                    } else if (n19 < 0) {
                        n19 = 0;
                    }
                    byArray3[n10] = (byte)(n19 & 0xFF);
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        for (int i = 0; i < n5; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray5[i];
            int n9 = nArray6[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                for (int k = 0; k < n3; ++k) {
                    int n13 = nArray3[k];
                    int n14 = nArray[k];
                    int n15 = this.interp_left * n + this.interp_top * n2;
                    n15 = n14 + n12 - n15;
                    int n16 = 0;
                    int n17 = 0;
                    for (int i2 = 0; i2 < this.interp_height; ++i2) {
                        int n18 = n15;
                        for (int i3 = 0; i3 < this.interp_width; ++i3) {
                            nArray7[n17][n16++] = sArray4[n15];
                            n15 += n;
                        }
                        ++n17;
                        n16 = 0;
                        n15 = n18 + n2;
                    }
                    int n19 = this.interp.interpolate(nArray7, n13, n11);
                    if (n19 > Short.MAX_VALUE) {
                        n19 = Short.MAX_VALUE;
                    } else if (n19 < Short.MIN_VALUE) {
                        n19 = Short.MIN_VALUE;
                    }
                    sArray3[n10] = (short)n19;
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        for (int i = 0; i < n5; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray5[i];
            int n9 = nArray6[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                for (int k = 0; k < n3; ++k) {
                    int n13 = nArray3[k];
                    int n14 = nArray[k];
                    int n15 = this.interp_left * n + this.interp_top * n2;
                    n15 = n14 + n12 - n15;
                    int n16 = 0;
                    int n17 = 0;
                    for (int i2 = 0; i2 < this.interp_height; ++i2) {
                        int n18 = n15;
                        for (int i3 = 0; i3 < this.interp_width; ++i3) {
                            nArray7[n17][n16++] = sArray4[n15] & 0xFFFF;
                            n15 += n;
                        }
                        ++n17;
                        n16 = 0;
                        n15 = n18 + n2;
                    }
                    int n19 = this.interp.interpolate(nArray7, n13, n11);
                    if (n19 > 65536) {
                        n19 = 65536;
                    } else if (n19 < 0) {
                        n19 = 0;
                    }
                    sArray3[n10] = (short)(n19 & 0xFFFF);
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int[][] nArray9 = new int[this.interp_height][this.interp_width];
        for (int i = 0; i < n5; ++i) {
            int[] nArray10 = nArray5[i];
            int[] nArray11 = nArray7[i];
            int n8 = nArray6[i];
            int n9 = nArray8[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = nArray4[j];
                int n12 = nArray2[j] + n9;
                for (int k = 0; k < n3; ++k) {
                    int n13;
                    int n14 = nArray3[k];
                    int n15 = nArray[k];
                    int n16 = this.interp_left * n + this.interp_top * n2;
                    n16 = n15 + n12 - n16;
                    int n17 = 0;
                    int n18 = 0;
                    for (int i2 = 0; i2 < this.interp_height; ++i2) {
                        int n19 = n16;
                        for (int i3 = 0; i3 < this.interp_width; ++i3) {
                            nArray9[n18][n17++] = nArray11[n16];
                            n16 += n;
                        }
                        ++n18;
                        n17 = 0;
                        n16 = n19 + n2;
                    }
                    nArray10[n10] = n13 = this.interp.interpolate(nArray9, n14, n11);
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        float[][] fArray5 = new float[this.interp_height][this.interp_width];
        for (int i = 0; i < n5; ++i) {
            float[] fArray6 = fArray3[i];
            float[] fArray7 = fArray4[i];
            int n8 = nArray3[i];
            int n9 = nArray4[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                float f = fArray2[j];
                int n11 = nArray2[j] + n9;
                for (int k = 0; k < n3; ++k) {
                    float f2 = fArray[k];
                    int n12 = nArray[k];
                    int n13 = this.interp_left * n + this.interp_top * n2;
                    n13 = n12 + n11 - n13;
                    int n14 = 0;
                    int n15 = 0;
                    for (int i2 = 0; i2 < this.interp_height; ++i2) {
                        int n16 = n13;
                        for (int i3 = 0; i3 < this.interp_width; ++i3) {
                            fArray5[n15][n14++] = fArray7[n13];
                            n13 += n;
                        }
                        ++n15;
                        n14 = 0;
                        n13 = n16 + n2;
                    }
                    float f3 = this.interp.interpolate(fArray5, f2, f);
                    if (f3 > Float.MAX_VALUE) {
                        f3 = Float.MAX_VALUE;
                    } else if (f3 < -3.4028235E38f) {
                        f3 = -3.4028235E38f;
                    }
                    fArray6[n10] = f3;
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        double[][] dArray3 = new double[this.interp_height][this.interp_width];
        for (int i = 0; i < n5; ++i) {
            double[] dArray4 = dArray[i];
            double[] dArray5 = dArray2[i];
            int n8 = nArray3[i];
            int n9 = nArray4[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                float f = fArray2[j];
                int n11 = nArray2[j] + n9;
                for (int k = 0; k < n3; ++k) {
                    double d;
                    float f2 = fArray[k];
                    int n12 = nArray[k];
                    int n13 = this.interp_left * n + this.interp_top * n2;
                    n13 = n12 + n11 - n13;
                    int n14 = 0;
                    int n15 = 0;
                    for (int i2 = 0; i2 < this.interp_height; ++i2) {
                        int n16 = n13;
                        for (int i3 = 0; i3 < this.interp_width; ++i3) {
                            dArray3[n15][n14++] = dArray5[n13];
                            n13 += n;
                        }
                        ++n15;
                        n14 = 0;
                        n13 = n16 + n2;
                    }
                    dArray4[n10] = d = this.interp.interpolate(dArray3, f2, f);
                    n10 += n6;
                }
                n8 += n7;
            }
        }
    }
}

