/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BreakOrContinueException;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ListElseContainer;
import freemarker.core.LocalContext;
import freemarker.core.LocalContextStack;
import freemarker.core.NonExtendedHashException;
import freemarker.core.NonSequenceOrCollectionException;
import freemarker.core.NonStringException;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateElements;
import freemarker.core._CoreStringUtils;
import freemarker.core._DelayedAOrAn;
import freemarker.core._DelayedFTLTypeDescription;
import freemarker.core._DelayedShortClassName;
import freemarker.core._ErrorDescriptionBuilder;
import freemarker.core._MiscTemplateException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateHashModelEx2;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Constants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

final class IteratorBlock
extends TemplateElement {
    private final Expression listedExp;
    private final String loopVarName;
    private final String loopVar2Name;
    private final boolean hashListing;
    private final boolean forEach;

    IteratorBlock(Expression listedExp, String loopVarName, String loopVar2Name, TemplateElements childrenBeforeElse, boolean hashListing, boolean forEach) {
        this.listedExp = listedExp;
        this.loopVarName = loopVarName;
        this.loopVar2Name = loopVar2Name;
        this.setChildren(childrenBeforeElse);
        this.hashListing = hashListing;
        this.forEach = forEach;
    }

    boolean isHashListing() {
        return this.hashListing;
    }

    TemplateElement[] accept(Environment env) throws TemplateException, IOException {
        this.acceptWithResult(env);
        return null;
    }

    boolean acceptWithResult(Environment env) throws TemplateException, IOException {
        TemplateModel listedValue = this.listedExp.eval(env);
        if (listedValue == null) {
            if (env.isClassicCompatible()) {
                listedValue = Constants.EMPTY_SEQUENCE;
            } else {
                this.listedExp.assertNonNull(null, env);
            }
        }
        return env.visitIteratorBlock(new IterationContext(listedValue, this.loopVarName, this.loopVar2Name));
    }

    static IterationContext findEnclosingIterationContext(Environment env, String loopVariableName) throws _MiscTemplateException {
        LocalContextStack ctxStack = env.getLocalContextStack();
        if (ctxStack != null) {
            for (int i = ctxStack.size() - 1; i >= 0; --i) {
                LocalContext ctx = ctxStack.get(i);
                if (!(ctx instanceof IterationContext) || loopVariableName != null && !loopVariableName.equals(((IterationContext)ctx).getLoopVariableName()) && !loopVariableName.equals(((IterationContext)ctx).getLoopVariable2Name())) continue;
                return (IterationContext)ctx;
            }
        }
        return null;
    }

    protected String dump(boolean canonical) {
        StringBuilder buf = new StringBuilder();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        if (this.forEach) {
            buf.append(_CoreStringUtils.toFTLTopLevelIdentifierReference(this.loopVarName));
            buf.append(" in ");
            buf.append(this.listedExp.getCanonicalForm());
        } else {
            buf.append(this.listedExp.getCanonicalForm());
            if (this.loopVarName != null) {
                buf.append(" as ");
                buf.append(_CoreStringUtils.toFTLTopLevelIdentifierReference(this.loopVarName));
                if (this.loopVar2Name != null) {
                    buf.append(", ");
                    buf.append(_CoreStringUtils.toFTLTopLevelIdentifierReference(this.loopVar2Name));
                }
            }
        }
        if (canonical) {
            buf.append(">");
            buf.append(this.getChildrenCanonicalForm());
            if (!(this.getParentElement() instanceof ListElseContainer)) {
                buf.append("</");
                buf.append(this.getNodeTypeSymbol());
                buf.append('>');
            }
        }
        return buf.toString();
    }

    int getParameterCount() {
        return 1 + (this.loopVarName != null ? 1 : 0) + (this.loopVar2Name != null ? 1 : 0);
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.listedExp;
            }
            case 1: {
                if (this.loopVarName == null) {
                    throw new IndexOutOfBoundsException();
                }
                return this.loopVarName;
            }
            case 2: {
                if (this.loopVar2Name == null) {
                    throw new IndexOutOfBoundsException();
                }
                return this.loopVar2Name;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.LIST_SOURCE;
            }
            case 1: {
                if (this.loopVarName == null) {
                    throw new IndexOutOfBoundsException();
                }
                return ParameterRole.TARGET_LOOP_VARIABLE;
            }
            case 2: {
                if (this.loopVar2Name == null) {
                    throw new IndexOutOfBoundsException();
                }
                return ParameterRole.TARGET_LOOP_VARIABLE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    String getNodeTypeSymbol() {
        return this.forEach ? "#foreach" : "#list";
    }

    boolean isNestedBlockRepeater() {
        return this.loopVarName != null;
    }

    class IterationContext
    implements LocalContext {
        private static final String LOOP_STATE_HAS_NEXT = "_has_next";
        private static final String LOOP_STATE_INDEX = "_index";
        private Object openedIterator;
        private boolean hasNext;
        private TemplateModel loopVar;
        private TemplateModel loopVar2;
        private int index;
        private boolean alreadyEntered;
        private Collection localVarNames = null;
        private String loopVarName;
        private String loopVar2Name;
        private final TemplateModel listedValue;

        public IterationContext(TemplateModel listedValue, String loopVarName, String loopVar2Name) {
            this.listedValue = listedValue;
            this.loopVarName = loopVarName;
            this.loopVar2Name = loopVar2Name;
        }

        boolean accept(Environment env) throws TemplateException, IOException {
            return this.executeNestedContent(env, IteratorBlock.this.getChildBuffer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loopForItemsElement(Environment env, TemplateElement[] childBuffer, String loopVarName, String loopVar2Name) throws NonSequenceOrCollectionException, TemplateModelException, InvalidReferenceException, TemplateException, IOException {
            try {
                if (this.alreadyEntered) {
                    throw new _MiscTemplateException(env, "The #items directive was already entered earlier for this listing.");
                }
                this.alreadyEntered = true;
                this.loopVarName = loopVarName;
                this.loopVar2Name = loopVar2Name;
                this.executeNestedContent(env, childBuffer);
            }
            finally {
                this.loopVarName = null;
                this.loopVar2Name = null;
            }
        }

        private boolean executeNestedContent(Environment env, TemplateElement[] childBuffer) throws TemplateModelException, TemplateException, IOException, NonSequenceOrCollectionException, InvalidReferenceException {
            return !IteratorBlock.this.hashListing ? this.executedNestedContentForCollOrSeqListing(env, childBuffer) : this.executedNestedContentForHashListing(env, childBuffer);
        }

        private boolean executedNestedContentForCollOrSeqListing(Environment env, TemplateElement[] childBuffer) throws TemplateModelException, IOException, TemplateException, NonSequenceOrCollectionException, InvalidReferenceException {
            boolean listNotEmpty;
            if (this.listedValue instanceof TemplateCollectionModel) {
                TemplateCollectionModel collModel = (TemplateCollectionModel)this.listedValue;
                TemplateModelIterator iterModel = this.openedIterator == null ? collModel.iterator() : (TemplateModelIterator)this.openedIterator;
                listNotEmpty = iterModel.hasNext();
                if (listNotEmpty) {
                    if (this.loopVarName != null) {
                        do {
                            this.loopVar = iterModel.next();
                            this.hasNext = iterModel.hasNext();
                            try {
                                env.visit(childBuffer);
                            }
                            catch (BreakOrContinueException br) {
                                if (br == BreakOrContinueException.BREAK_INSTANCE) break;
                            }
                            ++this.index;
                        } while (this.hasNext);
                        this.openedIterator = null;
                    } else {
                        this.openedIterator = iterModel;
                        env.visit(childBuffer);
                    }
                }
            } else if (this.listedValue instanceof TemplateSequenceModel) {
                TemplateSequenceModel seqModel = (TemplateSequenceModel)this.listedValue;
                int size = seqModel.size();
                boolean bl = listNotEmpty = size != 0;
                if (listNotEmpty) {
                    if (this.loopVarName != null) {
                        this.index = 0;
                        while (this.index < size) {
                            this.loopVar = seqModel.get(this.index);
                            this.hasNext = size > this.index + 1;
                            try {
                                env.visit(childBuffer);
                            }
                            catch (BreakOrContinueException br) {
                                if (br == BreakOrContinueException.BREAK_INSTANCE) break;
                            }
                            ++this.index;
                        }
                    } else {
                        env.visit(childBuffer);
                    }
                }
            } else if (env.isClassicCompatible()) {
                listNotEmpty = true;
                if (this.loopVarName != null) {
                    this.loopVar = this.listedValue;
                    this.hasNext = false;
                }
                try {
                    env.visit(childBuffer);
                }
                catch (BreakOrContinueException breakOrContinueException) {}
            } else {
                if (this.listedValue instanceof TemplateHashModelEx && !NonSequenceOrCollectionException.isWrappedIterable(this.listedValue)) {
                    throw new NonSequenceOrCollectionException(env, new _ErrorDescriptionBuilder("The value you try to list is ", new _DelayedAOrAn(new _DelayedFTLTypeDescription(this.listedValue)), ", thus you must specify two loop variables after the \"as\"; one for the key, and another for the value, like ", "<#... as k, v>", ")."));
                }
                throw new NonSequenceOrCollectionException(IteratorBlock.this.listedExp, this.listedValue, env);
            }
            return listNotEmpty;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean executedNestedContentForHashListing(Environment env, TemplateElement[] childBuffer) throws TemplateModelException, IOException, TemplateException {
            if (this.listedValue instanceof TemplateHashModelEx) {
                boolean hashNotEmpty;
                TemplateHashModelEx listedHash = (TemplateHashModelEx)this.listedValue;
                if (listedHash instanceof TemplateHashModelEx2) {
                    TemplateHashModelEx2.KeyValuePairIterator kvpIter = this.openedIterator == null ? ((TemplateHashModelEx2)listedHash).keyValuePairIterator() : (TemplateHashModelEx2.KeyValuePairIterator)this.openedIterator;
                    hashNotEmpty = kvpIter.hasNext();
                    if (!hashNotEmpty) return hashNotEmpty;
                    if (this.loopVarName != null) {
                        do {
                            TemplateHashModelEx2.KeyValuePair kvp = kvpIter.next();
                            this.loopVar = kvp.getKey();
                            this.loopVar2 = kvp.getValue();
                            this.hasNext = kvpIter.hasNext();
                            try {
                                env.visit(childBuffer);
                            }
                            catch (BreakOrContinueException br) {
                                if (br == BreakOrContinueException.BREAK_INSTANCE) break;
                            }
                            ++this.index;
                        } while (this.hasNext);
                        this.openedIterator = null;
                        return hashNotEmpty;
                    }
                    this.openedIterator = kvpIter;
                    env.visit(childBuffer);
                    return hashNotEmpty;
                }
                TemplateModelIterator keysIter = listedHash.keys().iterator();
                hashNotEmpty = keysIter.hasNext();
                if (!hashNotEmpty) return hashNotEmpty;
                if (this.loopVarName != null) {
                    do {
                        this.loopVar = keysIter.next();
                        if (!(this.loopVar instanceof TemplateScalarModel)) {
                            throw new NonStringException(env, new _ErrorDescriptionBuilder("When listing key-value pairs of traditional hash implementations, all keys must be strings, but one of them was ", new _DelayedAOrAn(new _DelayedFTLTypeDescription(this.loopVar)), ".").tip("The listed value's TemplateModel class was ", new _DelayedShortClassName(this.listedValue.getClass()), ", which doesn't implement ", new _DelayedShortClassName(TemplateHashModelEx2.class), ", which leads to this restriction."));
                        }
                        this.loopVar2 = listedHash.get(((TemplateScalarModel)this.loopVar).getAsString());
                        this.hasNext = keysIter.hasNext();
                        try {
                            env.visit(childBuffer);
                        }
                        catch (BreakOrContinueException br) {
                            if (br == BreakOrContinueException.BREAK_INSTANCE) return hashNotEmpty;
                        }
                        ++this.index;
                    } while (this.hasNext);
                    return hashNotEmpty;
                }
                env.visit(childBuffer);
                return hashNotEmpty;
            }
            if (!(this.listedValue instanceof TemplateCollectionModel) && !(this.listedValue instanceof TemplateSequenceModel)) throw new NonExtendedHashException(IteratorBlock.this.listedExp, this.listedValue, env);
            throw new NonSequenceOrCollectionException(env, new _ErrorDescriptionBuilder("The value you try to list is ", new _DelayedAOrAn(new _DelayedFTLTypeDescription(this.listedValue)), ", thus you must specify only one loop variable after the \"as\" (there's no separate key and value)."));
        }

        String getLoopVariableName() {
            return this.loopVarName;
        }

        String getLoopVariable2Name() {
            return this.loopVar2Name;
        }

        public TemplateModel getLocalVariable(String name) {
            String loopVariableName = this.loopVarName;
            if (loopVariableName != null && name.startsWith(loopVariableName)) {
                switch (name.length() - loopVariableName.length()) {
                    case 0: {
                        return this.loopVar;
                    }
                    case 6: {
                        if (!name.endsWith(LOOP_STATE_INDEX)) break;
                        return new SimpleNumber(this.index);
                    }
                    case 9: {
                        if (!name.endsWith(LOOP_STATE_HAS_NEXT)) break;
                        return this.hasNext ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                    }
                }
            }
            if (name.equals(this.loopVar2Name)) {
                return this.loopVar2;
            }
            return null;
        }

        public Collection getLocalVariableNames() {
            String loopVariableName = this.loopVarName;
            if (loopVariableName != null) {
                if (this.localVarNames == null) {
                    this.localVarNames = new ArrayList(3);
                    this.localVarNames.add(loopVariableName);
                    this.localVarNames.add(loopVariableName + LOOP_STATE_INDEX);
                    this.localVarNames.add(loopVariableName + LOOP_STATE_HAS_NEXT);
                }
                return this.localVarNames;
            }
            return Collections.EMPTY_LIST;
        }

        boolean hasNext() {
            return this.hasNext;
        }

        int getIndex() {
            return this.index;
        }
    }
}

