/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.L;

import com.neptunelabs.fsiserver.framework.if.J;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignedObject;

public class OoOO {
    private final FSILogger o00000;

    public OoOO(FSILogger fSILogger) {
        this.o00000 = fSILogger;
    }

    public final void \u00d500000(String string) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
            keyPairGenerator.initialize(1024);
            keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            Path path = Paths.get(string, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            J.\u00f600000(path.resolve("publicKey"), publicKey);
            J.\u00f600000(path.resolve("privateKey"), privateKey);
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            this.o00000.log(1024, exception.getClass().getName() + ": " + exception.getLocalizedMessage());
        }
    }

    public final SignedObject \u00d200000(Serializable serializable, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(privateKey.getAlgorithm());
            return new SignedObject(serializable, privateKey, signature);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException exception) {
            this.o00000.log(1025, exception.getClass().getName() + ": " + exception.getLocalizedMessage());
            return null;
        }
    }

    public final boolean o00000(SignedObject signedObject, PublicKey publicKey) {
        try {
            Signature signature = Signature.getInstance(publicKey.getAlgorithm());
            return signedObject.verify(publicKey, signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            this.o00000.log(1026, generalSecurityException.getClass().getName() + ": " + generalSecurityException.getLocalizedMessage());
            return false;
        }
    }

    private String Object(ByteBuffer byteBuffer) {
        String string = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byteBuffer.duplicate());
            byteBuffer.clear();
            byte[] byArray = messageDigest.digest();
            string = String.format("%0" + byArray.length * 2 + "x", new BigInteger(1, byArray)).trim();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.o00000.log(1027, noSuchAlgorithmException.getClass().getName() + ": " + noSuchAlgorithmException.getLocalizedMessage());
        }
        return string;
    }

    public final String \u00d400000(Path path) {
        String string = null;
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, new OpenOption[0]);){
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)seekableByteChannel.size());
            seekableByteChannel.read(byteBuffer);
            string = this.Object(byteBuffer);
        }
        catch (IOException iOException) {
            this.o00000.log(1027, iOException.getClass().getName() + ": " + iOException.getLocalizedMessage());
        }
        return string;
    }
}

