/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.bmp;

import com.neptunelabs.fsiserver.framework.O0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.OooO;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.bmp.BMPConstants;
import com.sun.media.imageioimpl.plugins.bmp.BMPImageReader;
import com.sun.media.imageioimpl.plugins.bmp.I18N;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class BMPMetadata
extends IIOMetadata
implements Cloneable,
BMPConstants {
    public static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_bmp_image_1.0";
    public String bmpVersion;
    public int width;
    public int height;
    public short bitsPerPixel;
    public int compression;
    public int imageSize;
    public int xPixelsPerMeter;
    public int yPixelsPerMeter;
    public int colorsUsed;
    public int colorsImportant;
    public int redMask;
    public int greenMask;
    public int blueMask;
    public int alphaMask;
    public int colorSpace;
    public double redX;
    public double redY;
    public double redZ;
    public double greenX;
    public double greenY;
    public double greenZ;
    public double blueX;
    public double blueY;
    public double blueZ;
    public int gammaRed;
    public int gammaGreen;
    public int gammaBlue;
    public int intent;
    public byte[] palette = null;
    public int paletteSize;
    public int red;
    public int green;
    public int blue;
    public List comments = null;

    public BMPMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.bmp.BMPMetadataFormat", null, null);
    }

    public BMPMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        this();
        if (iIOMetadata != null) {
            List<String> list = Arrays.asList(iIOMetadata.getMetadataFormatNames());
            if (list.contains(nativeMetadataFormatName)) {
                this.setFromTree(nativeMetadataFormatName, iIOMetadata.getAsTree(nativeMetadataFormatName));
            } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
                String string = "javax_imageio_1.0";
                this.setFromTree(string, iIOMetadata.getAsTree(string));
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Object clone() {
        BMPMetadata bMPMetadata;
        try {
            bMPMetadata = (BMPMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        return bMPMetadata;
    }

    @Override
    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("BMPMetadata0"));
    }

    private Node getNativeTree() {
        int n;
        IIOMetadataNode iIOMetadataNode;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(nativeMetadataFormatName);
        this.addChildNode(iIOMetadataNode2, "BMPVersion", this.bmpVersion);
        this.addChildNode(iIOMetadataNode2, "Width", new Integer(this.width));
        this.addChildNode(iIOMetadataNode2, "Height", new Integer(this.height));
        this.addChildNode(iIOMetadataNode2, "BitsPerPixel", new Short(this.bitsPerPixel));
        this.addChildNode(iIOMetadataNode2, "Compression", new Integer(this.compression));
        this.addChildNode(iIOMetadataNode2, "ImageSize", new Integer(this.imageSize));
        if (this.xPixelsPerMeter > 0 && this.yPixelsPerMeter > 0) {
            iIOMetadataNode = this.addChildNode(iIOMetadataNode2, "PixelsPerMeter", null);
            this.addChildNode(iIOMetadataNode, "X", new Integer(this.xPixelsPerMeter));
            this.addChildNode(iIOMetadataNode, "Y", new Integer(this.yPixelsPerMeter));
        }
        this.addChildNode(iIOMetadataNode2, "ColorsUsed", new Integer(this.colorsUsed));
        this.addChildNode(iIOMetadataNode2, "ColorsImportant", new Integer(this.colorsImportant));
        int n2 = 0;
        for (n = 0; n < this.bmpVersion.length(); ++n) {
            if (!Character.isDigit(this.bmpVersion.charAt(n))) continue;
            n2 = this.bmpVersion.charAt(n) - 48;
        }
        if (n2 >= 4) {
            iIOMetadataNode = this.addChildNode(iIOMetadataNode2, "Mask", null);
            this.addChildNode(iIOMetadataNode, "Red", new Integer(this.redMask));
            this.addChildNode(iIOMetadataNode, "Green", new Integer(this.greenMask));
            this.addChildNode(iIOMetadataNode, "Blue", new Integer(this.blueMask));
            this.addChildNode(iIOMetadataNode, "Alpha", new Integer(this.alphaMask));
            this.addChildNode(iIOMetadataNode2, "ColorSpaceType", new Integer(this.colorSpace));
            iIOMetadataNode = this.addChildNode(iIOMetadataNode2, "CIEXYZEndpoints", null);
            this.addXYZPoints(iIOMetadataNode, "Red", this.redX, this.redY, this.redZ);
            this.addXYZPoints(iIOMetadataNode, "Green", this.greenX, this.greenY, this.greenZ);
            this.addXYZPoints(iIOMetadataNode, "Blue", this.blueX, this.blueY, this.blueZ);
            iIOMetadataNode = this.addChildNode(iIOMetadataNode2, "Gamma", null);
            this.addChildNode(iIOMetadataNode, "Red", new Integer(this.gammaRed));
            this.addChildNode(iIOMetadataNode, "Green", new Integer(this.gammaGreen));
            this.addChildNode(iIOMetadataNode, "Blue", new Integer(this.gammaBlue));
            iIOMetadataNode = this.addChildNode(iIOMetadataNode2, "Intent", new Integer(this.intent));
        }
        if (this.palette != null && this.paletteSize > 0) {
            iIOMetadataNode = this.addChildNode(iIOMetadataNode2, "Palette", null);
            n = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x") ? 1 : 0;
            int n3 = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                IIOMetadataNode iIOMetadataNode3 = this.addChildNode(iIOMetadataNode, "PaletteEntry", null);
                this.blue = this.palette[n3++] & 0xFF;
                this.green = this.palette[n3++] & 0xFF;
                this.red = this.palette[n3++] & 0xFF;
                this.addChildNode(iIOMetadataNode3, "Red", new Integer(this.red));
                this.addChildNode(iIOMetadataNode3, "Green", new Integer(this.green));
                this.addChildNode(iIOMetadataNode3, "Blue", new Integer(this.blue));
                if (n != 0) continue;
                ++n3;
            }
        }
        return iIOMetadataNode2;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        String string = this.palette != null && this.paletteSize > 0 || this.redMask != 0 || this.greenMask != 0 || this.blueMask != 0 || this.bitsPerPixel > 8 ? "RGB" : "GRAY";
        iIOMetadataNode2.setAttribute("name", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
        String string2 = this.palette != null && this.paletteSize > 0 || this.redMask != 0 || this.greenMask != 0 || this.blueMask != 0 || this.bitsPerPixel > 8 ? (this.alphaMask != 0 ? "4" : "3") : "1";
        iIOMetadataNode2.setAttribute("value", string2);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.gammaRed != 0 && this.gammaGreen != 0 && this.gammaBlue != 0) {
            iIOMetadataNode2 = new IIOMetadataNode("Gamma");
            Double d2 = new Double((double)(this.gammaRed + this.gammaGreen + this.gammaBlue) / 3.0);
            iIOMetadataNode2.setAttribute("value", d2.toString());
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (string2.equals("1") && (this.palette == null || this.paletteSize == 0)) {
            iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
            iIOMetadataNode2.setAttribute("value", "TRUE");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (this.palette != null && this.paletteSize > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("Palette");
            boolean bl = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            int n = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", "" + i);
                iIOMetadataNode3.setAttribute("blue", "" + (this.palette[n++] & 0xFF));
                iIOMetadataNode3.setAttribute("green", "" + (this.palette[n++] & 0xFF));
                iIOMetadataNode3.setAttribute("red", "" + (this.palette[n++] & 0xFF));
                if (!bl) {
                    ++n;
                }
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", compressionTypeNames[this.compression]);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Lossless");
        iIOMetadataNode2.setAttribute("value", this.compression == 4 ? "FALSE" : "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        String string = this.palette != null && this.paletteSize > 0 ? "Index" : "UnsignedIntegral";
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        String string2 = "";
        if (this.redMask != 0 || this.greenMask != 0 || this.blueMask != 0) {
            string2 = this.countBits(this.redMask) + " " + this.countBits(this.greenMask) + " " + this.countBits(this.blueMask);
            if (this.alphaMask != 0) {
                string2 = string2 + " " + this.countBits(this.alphaMask);
            }
        } else if (this.palette != null && this.paletteSize > 0) {
            for (int i = 1; i <= 3; ++i) {
                string2 = string2 + this.bitsPerPixel;
                if (i == 3) continue;
                string2 = string2 + " ";
            }
        } else if (this.bitsPerPixel == 1) {
            string2 = "1";
        } else if (this.bitsPerPixel == 4) {
            string2 = "4";
        } else if (this.bitsPerPixel == 8) {
            string2 = "8";
        } else if (this.bitsPerPixel == 16) {
            string2 = "5 6 5";
        } else if (this.bitsPerPixel == 24) {
            string2 = "8 8 8";
        } else if (this.bitsPerPixel == 32) {
            string2 = "8 8 8 8";
        }
        if (!string2.equals("")) {
            iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
            iIOMetadataNode2.setAttribute("value", string2);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        if (this.yPixelsPerMeter > 0 && this.xPixelsPerMeter > 0) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
            float f2 = (float)this.yPixelsPerMeter / (float)this.xPixelsPerMeter;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
            iIOMetadataNode2.setAttribute("value", "" + f2);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.setAttribute("value", "" + 1000.0f / (float)this.xPixelsPerMeter);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.setAttribute("value", "" + 1000.0f / (float)this.yPixelsPerMeter);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPhysicalPixelSpacing");
            iIOMetadataNode2.setAttribute("value", "" + 1000.0f / (float)this.xPixelsPerMeter);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPhysicalPixelSpacing");
            iIOMetadataNode2.setAttribute("value", "" + 1000.0f / (float)this.yPixelsPerMeter);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardDocumentNode() {
        if (this.bmpVersion != null) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
            iIOMetadataNode2.setAttribute("value", this.bmpVersion);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        if (this.comments != null) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
            for (String string : this.comments) {
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode2.setAttribute("keyword", "comment");
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            return iIOMetadataNode;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        String string = this.alphaMask != 0 ? "nonpremultiplied" : "none";
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    private int getIntAttribute(Node node, String string, int n, boolean bl) throws IIOInvalidTreeException {
        String string2 = this.getAttribute(node, string, null, bl);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    private double getDoubleAttribute(Node node, String string, double d2, boolean bl) throws IIOInvalidTreeException {
        String string2 = this.getAttribute(node, string, null, bl);
        if (string2 == null) {
            return d2;
        }
        return OooO.OO0000(string2);
    }

    private int getIntAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getIntAttribute(node, string, -1, true);
    }

    private double getDoubleAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getDoubleAttribute(node, string, -1.0, true);
    }

    private String getAttribute(Node node, String string, String string2, boolean bl) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return string2;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
            return null;
        }
        return node2.getNodeValue();
    }

    private String getAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getAttribute(node, string, null, true);
    }

    void initialize(ColorModel colorModel, SampleModel sampleModel, ImageWriteParam imageWriteParam) {
        Object object;
        if (imageWriteParam != null) {
            this.bmpVersion = "BMP v. 3.x";
            if (imageWriteParam.getCompressionMode() == 2) {
                object = imageWriteParam.getCompressionType();
                this.compression = BMPImageReader.getCompressionType((String)object);
            }
        } else {
            this.bmpVersion = "BMP v. 3.x";
            this.compression = BMPImageReader.getPreferredCompressionType(colorModel, sampleModel);
        }
        this.width = sampleModel.getWidth();
        this.height = sampleModel.getHeight();
        this.bitsPerPixel = (short)colorModel.getPixelSize();
        if (colorModel instanceof DirectColorModel) {
            object = (DirectColorModel)colorModel;
            this.redMask = ((DirectColorModel)object).getRedMask();
            this.greenMask = ((DirectColorModel)object).getGreenMask();
            this.blueMask = ((DirectColorModel)object).getBlueMask();
            this.alphaMask = ((DirectColorModel)object).getAlphaMask();
        }
        if (colorModel instanceof IndexColorModel) {
            object = (IndexColorModel)colorModel;
            this.paletteSize = ((IndexColorModel)object).getMapSize();
            byte[] byArray = new byte[this.paletteSize];
            byte[] byArray2 = new byte[this.paletteSize];
            byte[] byArray3 = new byte[this.paletteSize];
            ((IndexColorModel)object).getReds(byArray);
            ((IndexColorModel)object).getGreens(byArray2);
            ((IndexColorModel)object).getBlues(byArray3);
            boolean bl = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            this.palette = new byte[(bl ? 3 : 4) * this.paletteSize];
            int n = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                this.palette[n++] = byArray3[i];
                this.palette[n++] = byArray2[i];
                this.palette[n++] = byArray[i];
                if (bl) continue;
                ++n;
            }
        }
    }

    @Override
    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            this.fatal(node2, "Root must be com_sun_media_imageio_plugins_bmp_image_1.0");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n = -1;
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            Object object2;
            Object object3;
            String string = node2.getNodeName();
            if (string.equals("BMPVersion")) {
                object3 = this.getStringValue(node2);
                if (object3 == null) continue;
                this.bmpVersion = object3;
                continue;
            }
            if (string.equals("Width")) {
                object3 = this.getIntegerValue(node2);
                if (object3 == null) continue;
                this.width = (Integer)object3;
                continue;
            }
            if (string.equals("Height")) {
                object3 = this.getIntegerValue(node2);
                if (object3 == null) continue;
                this.height = (Integer)object3;
                continue;
            }
            if (string.equals("BitsPerPixel")) {
                object3 = this.getShortValue(node2);
                if (object3 == null) continue;
                this.bitsPerPixel = (Short)object3;
                continue;
            }
            if (string.equals("Compression")) {
                object3 = this.getIntegerValue(node2);
                if (object3 == null) continue;
                this.compression = (Integer)object3;
                continue;
            }
            if (string.equals("ImageSize")) {
                object3 = this.getIntegerValue(node2);
                if (object3 == null) continue;
                this.imageSize = (Integer)object3;
                continue;
            }
            if (string.equals("PixelsPerMeter")) {
                for (object3 = node2.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                    Integer n2;
                    String string2 = object3.getNodeName();
                    if (string2.equals("X")) {
                        n2 = this.getIntegerValue((Node)object3);
                        if (n2 == null) continue;
                        this.xPixelsPerMeter = n2;
                        continue;
                    }
                    if (!string2.equals("Y") || (n2 = this.getIntegerValue((Node)object3)) == null) continue;
                    this.yPixelsPerMeter = n2;
                }
                continue;
            }
            if (string.equals("ColorsUsed")) {
                object3 = this.getIntegerValue(node2);
                if (object3 == null) continue;
                this.colorsUsed = (Integer)object3;
                continue;
            }
            if (string.equals("ColorsImportant")) {
                object3 = this.getIntegerValue(node2);
                if (object3 == null) continue;
                this.colorsImportant = (Integer)object3;
                continue;
            }
            if (string.equals("Mask")) {
                for (object3 = node2.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                    Integer n3;
                    String string3 = object3.getNodeName();
                    if (string3.equals("Red")) {
                        n3 = this.getIntegerValue((Node)object3);
                        if (n3 == null) continue;
                        this.redMask = n3;
                        continue;
                    }
                    if (string3.equals("Green")) {
                        n3 = this.getIntegerValue((Node)object3);
                        if (n3 == null) continue;
                        this.greenMask = n3;
                        continue;
                    }
                    if (string3.equals("Blue")) {
                        n3 = this.getIntegerValue((Node)object3);
                        if (n3 == null) continue;
                        this.blueMask = n3;
                        continue;
                    }
                    if (!string3.equals("Alpha") || (n3 = this.getIntegerValue((Node)object3)) == null) continue;
                    this.alphaMask = n3;
                }
                continue;
            }
            if (string.equals("ColorSpace")) {
                object3 = this.getIntegerValue(node2);
                if (object3 == null) continue;
                this.colorSpace = (Integer)object3;
                continue;
            }
            if (string.equals("CIEXYZEndpoints")) {
                for (object3 = node2.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                    Node node3;
                    String string4 = object3.getNodeName();
                    if (string4.equals("Red")) {
                        for (node3 = object3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                            object2 = node3.getNodeName();
                            if (((String)object2).equals("X")) {
                                object = this.getDoubleValue(node3);
                                if (object == null) continue;
                                this.redX = (Double)object;
                                continue;
                            }
                            if (((String)object2).equals("Y")) {
                                object = this.getDoubleValue(node3);
                                if (object == null) continue;
                                this.redY = (Double)object;
                                continue;
                            }
                            if (!((String)object2).equals("Z") || (object = this.getDoubleValue(node3)) == null) continue;
                            this.redZ = (Double)object;
                        }
                        continue;
                    }
                    if (string4.equals("Green")) {
                        for (node3 = object3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                            object2 = node3.getNodeName();
                            if (((String)object2).equals("X")) {
                                object = this.getDoubleValue(node3);
                                if (object == null) continue;
                                this.greenX = (Double)object;
                                continue;
                            }
                            if (((String)object2).equals("Y")) {
                                object = this.getDoubleValue(node3);
                                if (object == null) continue;
                                this.greenY = (Double)object;
                                continue;
                            }
                            if (!((String)object2).equals("Z") || (object = this.getDoubleValue(node3)) == null) continue;
                            this.greenZ = (Double)object;
                        }
                        continue;
                    }
                    if (!string4.equals("Blue")) continue;
                    for (node3 = object3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        object2 = node3.getNodeName();
                        if (((String)object2).equals("X")) {
                            object = this.getDoubleValue(node3);
                            if (object == null) continue;
                            this.blueX = (Double)object;
                            continue;
                        }
                        if (((String)object2).equals("Y")) {
                            object = this.getDoubleValue(node3);
                            if (object == null) continue;
                            this.blueY = (Double)object;
                            continue;
                        }
                        if (!((String)object2).equals("Z") || (object = this.getDoubleValue(node3)) == null) continue;
                        this.blueZ = (Double)object;
                    }
                }
                continue;
            }
            if (string.equals("Gamma")) {
                for (object3 = node2.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                    Integer n4;
                    String string5 = object3.getNodeName();
                    if (string5.equals("Red")) {
                        n4 = this.getIntegerValue((Node)object3);
                        if (n4 == null) continue;
                        this.gammaRed = n4;
                        continue;
                    }
                    if (string5.equals("Green")) {
                        n4 = this.getIntegerValue((Node)object3);
                        if (n4 == null) continue;
                        this.gammaGreen = n4;
                        continue;
                    }
                    if (!string5.equals("Blue") || (n4 = this.getIntegerValue((Node)object3)) == null) continue;
                    this.gammaBlue = n4;
                }
                continue;
            }
            if (string.equals("Intent")) {
                object3 = this.getIntegerValue(node2);
                if (object3 == null) continue;
                this.intent = (Integer)object3;
                continue;
            }
            if (string.equals("Palette")) {
                this.paletteSize = this.getIntAttribute(node2, "sizeOfPalette");
                byArray = new byte[this.paletteSize];
                byArray2 = new byte[this.paletteSize];
                byArray3 = new byte[this.paletteSize];
                n = -1;
                object3 = node2.getFirstChild();
                if (object3 == null) {
                    this.fatal(node2, "Palette has no entries!");
                }
                int n5 = 0;
                while (object3 != null) {
                    if (!object3.getNodeName().equals("PaletteEntry")) {
                        this.fatal(node2, "Only a PaletteEntry may be a child of a Palette!");
                    }
                    int n6 = -1;
                    for (object2 = object3.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                        Integer n7;
                        object = object2.getNodeName();
                        if (((String)object).equals("Index")) {
                            n7 = this.getIntegerValue((Node)object2);
                            if (n7 != null) {
                                n6 = n7;
                            }
                            if (n6 >= 0 && n6 <= this.paletteSize - 1) continue;
                            this.fatal(node2, "Bad value for PaletteEntry attribute index!");
                            continue;
                        }
                        if (((String)object).equals("Red")) {
                            n7 = this.getIntegerValue((Node)object2);
                            if (n7 == null) continue;
                            this.red = n7;
                            continue;
                        }
                        if (((String)object).equals("Green")) {
                            n7 = this.getIntegerValue((Node)object2);
                            if (n7 == null) continue;
                            this.green = n7;
                            continue;
                        }
                        if (!((String)object).equals("Blue") || (n7 = this.getIntegerValue((Node)object2)) == null) continue;
                        this.blue = n7;
                    }
                    if (n6 == -1) {
                        n6 = n5;
                    }
                    if (n6 > n) {
                        n = n6;
                    }
                    byArray[n6] = (byte)this.red;
                    byArray2[n6] = (byte)this.green;
                    byArray3[n6] = (byte)this.blue;
                    ++n5;
                    object3 = object3.getNextSibling();
                }
                continue;
            }
            if (string.equals("CommentExtensions")) {
                object3 = node2.getFirstChild();
                if (object3 == null) {
                    this.fatal(node2, "CommentExtensions has no entries!");
                }
                if (this.comments == null) {
                    this.comments = new ArrayList();
                }
                while (object3 != null) {
                    if (!object3.getNodeName().equals("CommentExtension")) {
                        this.fatal(node2, "Only a CommentExtension may be a child of a CommentExtensions!");
                    }
                    this.comments.add(this.getAttribute((Node)object3, "value"));
                    object3 = object3.getNextSibling();
                }
                continue;
            }
            this.fatal(node2, "Unknown child of root node!");
        }
        if (byArray != null && byArray2 != null && byArray3 != null) {
            boolean bl = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            int n8 = n + 1;
            this.palette = new byte[(bl ? 3 : 4) * n8];
            int n9 = 0;
            for (int i = 0; i < n8; ++i) {
                this.palette[n9++] = byArray3[i];
                this.palette[n9++] = byArray2[i];
                this.palette[n9++] = byArray[i];
                if (bl) continue;
                ++n9;
            }
        }
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            this.fatal(node2, "Root must be javax_imageio_1.0");
        }
        String string = null;
        int n = 0;
        int[] nArray = null;
        boolean bl = false;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n2 = -1;
        block0: for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string2 = node2.getNodeName();
            if (string2.equals("Chroma")) {
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    String string3 = node3.getNodeName();
                    if (string3.equals("ColorSpaceType")) {
                        string = this.getAttribute(node3, "name");
                        continue;
                    }
                    if (string3.equals("NumChannels")) {
                        n = this.getIntAttribute(node3, "value");
                        continue;
                    }
                    if (string3.equals("Gamma")) {
                        this.gammaGreen = this.gammaBlue = (int)(this.getDoubleAttribute(node3, "value") + 0.5);
                        this.gammaRed = this.gammaBlue;
                        continue;
                    }
                    if (!string3.equals("Palette")) continue;
                    byArray = new byte[256];
                    byArray2 = new byte[256];
                    byArray3 = new byte[256];
                    n2 = -1;
                    Node node4 = node3.getFirstChild();
                    if (node4 == null) {
                        this.fatal(node2, "Palette has no entries!");
                    }
                    while (node4 != null) {
                        int n3;
                        if (!node4.getNodeName().equals("PaletteEntry")) {
                            this.fatal(node2, "Only a PaletteEntry may be a child of a Palette!");
                        }
                        if ((n3 = this.getIntAttribute(node4, "index")) < 0 || n3 > 255) {
                            this.fatal(node2, "Bad value for PaletteEntry attribute index!");
                        }
                        if (n3 > n2) {
                            n2 = n3;
                        }
                        byArray[n3] = (byte)this.getIntAttribute(node4, "red");
                        byArray2[n3] = (byte)this.getIntAttribute(node4, "green");
                        byArray3[n3] = (byte)this.getIntAttribute(node4, "blue");
                        node4 = node4.getNextSibling();
                    }
                }
                continue;
            }
            if (string2.equals("Compression")) {
                for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    String string4 = node5.getNodeName();
                    if (!string4.equals("CompressionTypeName")) continue;
                    String string5 = this.getAttribute(node5, "value");
                    this.compression = BMPImageReader.getCompressionType(string5);
                }
                continue;
            }
            if (string2.equals("Data")) {
                for (Node node6 = node2.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                    String string6 = node6.getNodeName();
                    if (!string6.equals("BitsPerSample")) continue;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
                    String string7 = this.getAttribute(node6, "value");
                    StringTokenizer stringTokenizer = new StringTokenizer(string7);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(Integer.valueOf(stringTokenizer.nextToken()));
                    }
                    nArray = new int[arrayList.size()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = (Integer)arrayList.get(i);
                    }
                    continue block0;
                }
                continue;
            }
            if (string2.equals("Dimension")) {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                double d2 = -1.0;
                double d3 = -1.0;
                double d4 = -1.0;
                double d5 = -1.0;
                double d6 = -1.0;
                for (Node node7 = node2.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                    String string8 = node7.getNodeName();
                    if (string8.equals("PixelAspectRatio")) {
                        d4 = this.getDoubleAttribute(node7, "value");
                        bl4 = true;
                        continue;
                    }
                    if (string8.equals("HorizontalPixelSize")) {
                        d2 = this.getDoubleAttribute(node7, "value");
                        bl2 = true;
                        continue;
                    }
                    if (string8.equals("VerticalPixelSize")) {
                        d3 = this.getDoubleAttribute(node7, "value");
                        bl3 = true;
                        continue;
                    }
                    if (string8.equals("HorizontalPhysicalPixelSpacing")) {
                        d5 = this.getDoubleAttribute(node7, "value");
                        bl5 = true;
                        continue;
                    }
                    if (!string8.equals("VerticalPhysicalPixelSpacing")) continue;
                    d6 = this.getDoubleAttribute(node7, "value");
                    bl6 = true;
                }
                if (!bl2 && !bl3 && (bl5 || bl6)) {
                    d2 = d5;
                    bl2 = bl5;
                    d3 = d6;
                    bl3 = bl6;
                }
                if (bl2 && bl3) {
                    this.xPixelsPerMeter = (int)(1000.0 / d2 + 0.5);
                    this.yPixelsPerMeter = (int)(1000.0 / d3 + 0.5);
                    continue;
                }
                if (!bl4 || d4 == 0.0) continue;
                if (bl2) {
                    this.xPixelsPerMeter = (int)(1000.0 / d2 + 0.5);
                    this.yPixelsPerMeter = (int)(d4 * (1000.0 / d2) + 0.5);
                    continue;
                }
                if (!bl3) continue;
                this.xPixelsPerMeter = (int)(1000.0 / d3 / d4 + 0.5);
                this.yPixelsPerMeter = (int)(1000.0 / d3 + 0.5);
                continue;
            }
            if (string2.equals("Document")) {
                for (Node node8 = node2.getFirstChild(); node8 != null; node8 = node8.getNextSibling()) {
                    String string9 = node8.getNodeName();
                    if (!string9.equals("FormatVersion")) continue;
                    this.bmpVersion = this.getAttribute(node8, "value");
                    continue block0;
                }
                continue;
            }
            if (string2.equals("Text")) {
                for (Node node9 = node2.getFirstChild(); node9 != null; node9 = node9.getNextSibling()) {
                    String string10 = node9.getNodeName();
                    if (!string10.equals("TextEntry")) continue;
                    if (this.comments == null) {
                        this.comments = new ArrayList();
                    }
                    this.comments.add(this.getAttribute(node9, "value"));
                }
                continue;
            }
            if (!string2.equals("Transparency")) continue;
            for (Node node10 = node2.getFirstChild(); node10 != null; node10 = node10.getNextSibling()) {
                String string11 = node10.getNodeName();
                if (!string11.equals("Alpha")) continue;
                bl = !this.getAttribute(node10, "value").equals("none");
                continue block0;
            }
        }
        if (nArray != null) {
            if (this.palette != null && this.paletteSize > 0) {
                this.bitsPerPixel = (short)nArray[0];
            } else {
                this.bitsPerPixel = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    this.bitsPerPixel = (short)(this.bitsPerPixel + nArray[i]);
                }
            }
        } else if (this.palette != null) {
            this.bitsPerPixel = (short)8;
        } else if (n == 1) {
            this.bitsPerPixel = (short)8;
        } else if (n == 3) {
            this.bitsPerPixel = (short)24;
        } else if (n == 4) {
            this.bitsPerPixel = (short)32;
        } else if (string != null && string.equals("GRAY")) {
            this.bitsPerPixel = (short)8;
        } else if (string != null && string.equals("RGB")) {
            this.bitsPerPixel = (short)(bl ? 32 : 24);
        }
        if (nArray != null && nArray.length == 4 || this.bitsPerPixel >= 24) {
            this.redMask = 0xFF0000;
            this.greenMask = 65280;
            this.blueMask = 255;
        }
        if (nArray != null && nArray.length == 4 || this.bitsPerPixel > 24) {
            this.alphaMask = -16777216;
        }
        if (byArray != null && byArray2 != null && byArray3 != null) {
            boolean bl7 = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            this.paletteSize = n2 + 1;
            this.palette = new byte[(bl7 ? 3 : 4) * this.paletteSize];
            int n4 = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                this.palette[n4++] = byArray3[i];
                this.palette[n4++] = byArray2[i];
                this.palette[n4++] = byArray[i];
                if (bl7) continue;
                ++n4;
            }
        }
    }

    @Override
    public void reset() {
        this.bmpVersion = null;
        this.width = 0;
        this.height = 0;
        this.bitsPerPixel = 0;
        this.compression = 0;
        this.imageSize = 0;
        this.xPixelsPerMeter = 0;
        this.yPixelsPerMeter = 0;
        this.colorsUsed = 0;
        this.colorsImportant = 0;
        this.redMask = 0;
        this.greenMask = 0;
        this.blueMask = 0;
        this.alphaMask = 0;
        this.colorSpace = 0;
        this.redX = 0.0;
        this.redY = 0.0;
        this.redZ = 0.0;
        this.greenX = 0.0;
        this.greenY = 0.0;
        this.greenZ = 0.0;
        this.blueX = 0.0;
        this.blueY = 0.0;
        this.blueZ = 0.0;
        this.gammaRed = 0;
        this.gammaGreen = 0;
        this.gammaBlue = 0;
        this.intent = 0;
        this.palette = null;
        this.paletteSize = 0;
        this.red = 0;
        this.green = 0;
        this.blue = 0;
        this.comments = null;
    }

    private String countBits(int n) {
        int n2 = 0;
        while (n != 0) {
            if ((n & 1) == 1) {
                ++n2;
            }
            n >>>= 1;
        }
        return n2 == 0 ? "0" : "" + n2;
    }

    private void addXYZPoints(IIOMetadataNode iIOMetadataNode, String string, double d2, double d3, double d4) {
        IIOMetadataNode iIOMetadataNode2 = this.addChildNode(iIOMetadataNode, string, null);
        this.addChildNode(iIOMetadataNode2, "X", new Double(d2));
        this.addChildNode(iIOMetadataNode2, "Y", new Double(d3));
        this.addChildNode(iIOMetadataNode2, "Z", new Double(d4));
    }

    private IIOMetadataNode addChildNode(IIOMetadataNode iIOMetadataNode, String string, Object object) {
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(string);
        if (object != null) {
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(object));
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode2;
    }

    private Object getObjectValue(Node node) {
        Object object = node.getNodeValue();
        if (object == null && node instanceof IIOMetadataNode) {
            object = ((IIOMetadataNode)node).getUserObject();
        }
        return object;
    }

    private String getStringValue(Node node) {
        Object object = this.getObjectValue(node);
        return object instanceof String ? (String)object : null;
    }

    private Byte getByteValue(Node node) {
        Object object = this.getObjectValue(node);
        Byte by = null;
        if (object instanceof String) {
            by = Byte.valueOf((String)object);
        } else if (object instanceof Byte) {
            by = (Byte)object;
        }
        return by;
    }

    private Short getShortValue(Node node) {
        Object object = this.getObjectValue(node);
        Short s = null;
        if (object instanceof String) {
            s = Short.valueOf((String)object);
        } else if (object instanceof Short) {
            s = (Short)object;
        }
        return s;
    }

    private Integer getIntegerValue(Node node) {
        Object object = this.getObjectValue(node);
        Integer n = null;
        if (object instanceof String) {
            n = Integer.valueOf((String)object);
        } else if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof Byte) {
            n = new Integer((int)((Byte)object & 0xFF));
        }
        return n;
    }

    private Double getDoubleValue(Node node) {
        Object object = this.getObjectValue(node);
        Double d2 = null;
        if (object instanceof String) {
            d2 = OooO.super((String)object);
        } else if (object instanceof Double) {
            d2 = (Double)object;
        }
        return d2;
    }
}

