/*!
 * FSI Server Interface
 * http://www.fsi-viewer.com
 *
 * Copyright (C) 2000-2017 NeptuneLabs GmbH - All rights reserved.
 *
 * Version: 1.0.1
 */

			if (!fsiparser) {
				fsiparser = new fsiParser(serviceurl);
			}
			if (fsiparser.init) fsiparser.init();
			else interfaceControl.showPublishMessage("Error","FSI Parser initialisation error");

			var currentColor = Colors.ColorFromRGB(255,255,255);
			CurrentPreviewWindow = false;
			oldPreviewWindowWidth = oldPreviewWindowHeight = -1;
			colorPickerVisible = false;
			var query='';
			var plugins = new Array();
			var moreoptions = false;
			
			
			bPublishFromDirSelection = (interfaceControl.getThumbView().getSingleSelectedItemType() == "directory");

			for (var option in plugins) {
				plugins[option] = '';
			}
		
			function getDir() {
				var dir = new Array();
				dir[0] = 'pages_dir';
				try {
				 var e = oPreviewEntry;
				 if (e.type=="directory") {
					dir[1] = decodeURIComponent(e.fullsrc);
				 }
				 else {
					 dir[1] = getBasePathFromEntry(e);
				 }
				} catch(e) { dir[1] = encodeBrowsePath(interfaceControl.getBasePath()); }
				return dir; 
			}
			
			v = getDir();

			function scrollTextArea(from,to) {
				from.onscroll = function (evt) {
					to.scrollTop = this.scrollTop;
				}
			}

			var currentColor = Colors.ColorFromRGB(255,255,255);
			var fsiparser; // = new fsiParser;
			var fsiparser_basepath = fsirooturl;
			var relSectionPath = 'pages_presets';
			var fsiparser_presetpath = fsiparser_basepath+'config/pages_presets';
			var opt = document.settings;


			function getChaptersFullURI(chapfileName){
				return interfaceControl.getUserProxyServerUrl()+'/?src='+chapfileName+'&cmd=getv&charset=utf-8&headers=webinterface'; //&r='+Math.random();
			}

			function  initit() {
				
				var publishingsettings = "";
				if (typeof(interfaceControl.PublishData[build+'_PUBLISHING']) != "undefined") publishingsettings = interfaceControl.PublishData[build+'_PUBLISHING'].value;

				initGlobal();
				initPluginButtons();
				v = getDir();
				
				document.getElementById('dirvalue').value = interfaceControl.getBasePath();
				cfg = interfaceControl.getPublishingView().getPresetFile();
				if (cfg != '' && cfg != 'undefined') { 
					qdata['cfg'] = cfg;
				} else {
					qdata['cfg'] = ''; 
				}

				setInitialDimensions();

				document.getElementById('dirvalue').value = v[1];
				document.getElementById('notepad_uniqueid').value =  'fsi' + Date.parse(new Date());
				getVars('Notepad',document.getElementById('notepad_uniqueid'),'string');

				fsiparser.loadDefaultFSI(fsiparser_basepath, '_default.xml');
				
				var userinfo = new Object();
				userinfo = interfaceControl.getPublishingView().getPublishingUserPermissions(); //can save chapters?!
				if(!userinfo.write.extendedMetadata) document.getElementById('btn_save_chapters').disabled = true;
				if(!userinfo.write.extendedMetadata) document.getElementById('btn_del_chapters').disabled = true;

				var publicinfo = new Object();
				publicinfo = interfaceControl.getPublishingView().getPublishingPublicPermissions();
				if(!publicinfo.write.extendedMetadata) document.getElementById('btn_save_chapters').disabled = true;
				if(!publicinfo.write.extendedMetadata) document.getElementById('btn_del_chapters').disabled = true;

				if (qdata["cfg"] != "") {
					loadSelectedConfig(qdata["cfg"]);
				}

				
				loadChapters();
				preUpdateInterface();
				
				setInitialDimensions();
				addEvent(window,"resize",resizePreview);
				addEvent(window,"unload",removeResizePreview);
				document.getElementById('options_width').value = '800';
				document.getElementById('options_height').value = '600';
				RestoreParameterValues(build);
				restorePublishingSettings(publishingsettings);

				toActive('1', 'false');
				bInitDone = true;

			}


