/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibConvolveNxNOpImage;
import com.sun.media.jai.mlib.MlibConvolveOpImage;
import com.sun.media.jai.mlib.MlibSeparableConvolveOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

public class MlibConvolveRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        KernelJAI kernelJAI = (KernelJAI)parameterBlock.getObjectParameter(0);
        KernelJAI kernelJAI2 = kernelJAI.getRotatedKernel();
        int n = kernelJAI2.getWidth();
        int n2 = kernelJAI2.getHeight();
        if (n < 2 || n2 < 2) {
            return null;
        }
        if (kernelJAI2.isSeparable() && n == n2 && (n == 3 || n == 5 || n == 7)) {
            return new MlibSeparableConvolveOpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
        }
        if (n == n2 && (n == 2 || n == 3 || n == 4 || n == 5 || n == 7)) {
            return new MlibConvolveNxNOpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
        }
        return new MlibConvolveOpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
    }
}

