/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.formats.jpeg.segments.Segment;

public class DhtSegment
extends Segment {
    public final List<HuffmanTable> huffmanTables = new ArrayList<HuffmanTable>();

    public DhtSegment(int marker, byte[] segmentData) throws IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public DhtSegment(int marker, int length, InputStream is) throws IOException {
        super(marker, length);
        while (length > 0) {
            int tableClassAndDestinationId = 0xFF & this.readByte("TableClassAndDestinationId", is, "Not a Valid JPEG File");
            --length;
            int tableClass = tableClassAndDestinationId >> 4 & 0xF;
            int destinationIdentifier = tableClassAndDestinationId & 0xF;
            int[] bits = new int[17];
            int bitsSum = 0;
            for (int i = 1; i < bits.length; ++i) {
                bits[i] = 0xFF & this.readByte("Li", is, "Not a Valid JPEG File");
                --length;
                bitsSum += bits[i];
            }
            int[] huffVal = new int[bitsSum];
            for (int i = 0; i < bitsSum; ++i) {
                huffVal[i] = 0xFF & this.readByte("Vij", is, "Not a Valid JPEG File");
                --length;
            }
            this.huffmanTables.add(new HuffmanTable(tableClass, destinationIdentifier, bits, huffVal));
        }
    }

    public String getDescription() {
        return "DHT (" + this.getSegmentType() + ")";
    }

    public static class HuffmanTable {
        public final int tableClass;
        public final int destinationIdentifier;
        public final int[] bits;
        public final int[] huffVal;
        public final int[] huffSize = new int[4096];
        public final int[] huffCode;
        public final int[] minCode = new int[17];
        public final int[] maxCode = new int[17];
        public final int[] valPtr = new int[17];

        public HuffmanTable(int tableClass, int destinationIdentifier, int[] bits, int[] huffVal) {
            this.tableClass = tableClass;
            this.destinationIdentifier = destinationIdentifier;
            this.bits = bits;
            this.huffVal = huffVal;
            int k = 0;
            int i = 1;
            int j = 1;
            int lastK = -1;
            while (true) {
                if (j > bits[i]) {
                    j = 1;
                    if (++i <= 16) continue;
                    break;
                }
                this.huffSize[k] = i;
                ++k;
                ++j;
            }
            this.huffSize[k] = 0;
            lastK = k;
            k = 0;
            int code = 0;
            int si = this.huffSize[0];
            this.huffCode = new int[lastK];
            while (true) {
                this.huffCode[k] = code++;
                if (this.huffSize[++k] == si) continue;
                if (this.huffSize[k] == 0) break;
                do {
                    code <<= 1;
                } while (this.huffSize[k] != ++si);
            }
            i = 0;
            j = 0;
            while (++i <= 16) {
                if (bits[i] == 0) {
                    this.maxCode[i] = -1;
                    continue;
                }
                this.valPtr[i] = j;
                this.minCode[i] = this.huffCode[j];
                this.maxCode[i] = this.huffCode[j += bits[i] - 1];
                ++j;
            }
        }
    }
}

