<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Edit Publishing Set" />

  <#if show_form?? >

    <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="editpublishingset">
      <input type="hidden" name="name" value="${publishingset.name}">
      <input type="hidden" name="save" value="1">
      
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
        <td class="pad1" colspan="3">
         <#if message??>
          <span style="color: red">${message}</span>
         <#else>
          Enter the publishing set properties in the form below and press the save button at the end of the page. 
          The publishing sets will then be re-read for the changes to take effect.
         </#if>
        </td>
      </tr>
	  
      <#-- Viewer Location -->
      
      <tr>
	    <td class="sectionheader" colspan="3">Viewer Location</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="sectionheader">Parameter</td>
        <td class="sectionheader">Protected</td>
        <td class="sectionheader">Value</td>
      </tr>
	  <tr>
        <td class="pad1">Viewer Path</td>
        <td class="pad1" align="right"><@formcheckbox objid="viewerPath_protected" preselect=publishingset.viewerpath_protected?string helpid="renderer_format" />
        <td class="pad1" align="right"><input type="text" class="inwhite" name="viewerPath" <#if publishingset.viewerpath?? >value="${publishingset.viewerpath}"</#if> help="<@appID/>:publishingsets_name" /> 
        </td>
      </tr>
      
      <#-- Proxy Settings -->
      
      <tr>
	    <td class="sectionheader" colspan="3">Proxy Settings</td>
	  </tr>
	  <tr><td colspan="3"><hr size="1" class="hr1"/></td></tr>
	  <tr>
        <td class="sectionheader">Parameter</td>
        <td class="sectionheader">Protected</td>
        <td class="sectionheader">Value</td>
      </tr>
	  <tr>
        <td class="pad1">Proxy URL</td>
        <td class="pad1" align="right"><@formcheckbox objid="proxyURL_protected" preselect=publishingset.proxyURL_protected?string helpid="renderer_format" />
        <td class="pad1" align="right"><input type="text" class="inwhite" name="proxyURL" <#if publishingset.proxyURL?? >value="${publishingset.proxyURL}"</#if> help="<@appID/>:publishingsets_name" /> 
        </td>
      </tr>
	  <tr>
        <td class="pad1">Proxy Server Pattern</td>
        <td class="pad1" align="right"><@formcheckbox objid="proxyServerPattern_protected" preselect=publishingset.proxyServerPattern_protected?string helpid="renderer_format" />
        <td class="pad1" align="right"><input type="text" class="inwhite" name="proxyServerPattern" <#if publishingset.proxyServerPattern?? >value="${publishingset.proxyServerPattern}"</#if> help="<@appID/>:publishingsets_name" /> 
        </td>
      </tr>
      <tr>
        <td class="pad1">Proxy Static Pattern</td>
        <td class="pad1" align="right"><@formcheckbox objid="proxyStaticPattern_protected" preselect=publishingset.proxyStaticPattern_protected?string helpid="renderer_format" />
        <td class="pad1" align="right"><input type="text" class="inwhite" name="proxyStaticPattern" <#if publishingset.proxyStaticPattern?? >value="${publishingset.proxyStaticPattern}"</#if> help="<@appID/>:publishingsets_name" /> 
        </td>
      </tr>
      <tr>
        <td class="pad1">Proxy JS Path</td>
        <td class="pad1" align="right"><@formcheckbox objid="proxyJSPath_protected" preselect=publishingset.proxyJSPath_protected?string helpid="renderer_format" />
        <td class="pad1" align="right"><input type="text" class="inwhite" name="proxyJSPath" <#if publishingset.proxyJSPath?? >value="${publishingset.proxyJSPath}"</#if> help="<@appID/>:publishingsets_name" /> 
        </td>
      </tr>
      <tr>
        <td class="pad1">Proxy User Viewer Base</td>
        <td class="pad1" align="right"><@formcheckbox objid="proxyUserViewerBase_protected" preselect=publishingset.proxyUserViewerBase_protected?string helpid="renderer_format" />
        <td class="pad1" align="right"><input type="text" class="inwhite" name="proxyUserViewerBase" <#if publishingset.proxyUserViewerBase?? >value="${publishingset.proxyUserViewerBase}"</#if> help="<@appID/>:publishingsets_name" /> 
        </td>
      </tr>
      <tr>
        <td class="pad1">Proxy Viewer Path</td>
        <td class="pad1" align="right"><@formcheckbox objid="proxyViewerPath_protected" preselect=publishingset.proxyViewerPath_protected?string helpid="renderer_format" />
        <td class="pad1" align="right"><input type="text" class="inwhite" name="proxyViewerPath" <#if publishingset.proxyViewerPath?? >value="${publishingset.proxyViewerPath}"</#if> help="<@appID/>:publishingsets_name" /> 
        </td>
      </tr>
      
      <tr>
        <td class="pad1" style="padding-top: 20px;" colspan="3" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listpublishingsets" />
          <@formsubmit value="Save" helpid="publishingsets_save" />	
        </td>
      </tr>
      </table>
    </form>

  <#elseif show_confirmation?? >
    
    <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
	    <td class="sectionheader">Permission set saved</td>
	  </tr>
	  <tr><td><hr size="1" class="hr1"/></td></tr>
	  <tr>
	   <td class="pad1">
    	Please wait while the publishing sets are re-read for the changes to take effect.
       </td>
      </tr>
    </table>
    <#assign timeout="5" />
    <#assign postprogresslocation="action=listpublishingsets">
    <#include "/sub/progressbar.ftl">
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">