/*!
 * FSI ImageFlow
 * Copyright (c) 2000-2015 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 *
 * VERSION: 1.1.0
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

if(typeof($FSI)=="undefined"){$FSI={};$FSI.init=function(){$FSI.oSupportedViewers={};if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing}else{$FSI.console=console}try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,version,build){var self=this;this.instance=instance;this.strClassName=strClassName;this.version=version;this.build=build;var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var classDef=new $FSI.ClassDef($FSI,"FSI Core","1.1.2","16.02.08");$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t=="boolean"){ret=value}else{if(t=="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady){if(typeof($FSI.iLoaderCSSSkin)!="object"){if(typeof($FSI.LoaderCSSSkin)!="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create <style> node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
			@if (@_jscript_version < 9)
				el.style.setAttribute('cssText', strStyle);
			@else @*/
el.setAttribute("style",strStyle);
/*@end
			@*/
};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!=0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWith=window.innerWidth;$FSI.bElementPosRespectsScroll=true;var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}var uagent=$FSI.userAgent=navigator.userAgent.toLowerCase();var result;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!=-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("safari")>-1&&uagent.search("chrome")<1){$FSI.isSafari=true}else{if(uagent.search("firefox")>-1){$FSI.isFirefox=true}else{if(uagent.search("opera")>-1){$FSI.isOpera=true}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)=="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.getCachedScrollBarWidth=function(el,oReg,w){var cst;var cssOverflowY="";try{cst=top.window.getComputedStyle(el);cssOverflowY=cst["overflow-y"]}catch(e){return 0}if(cssOverflowY=="scroll"||el.scrollHeight>top.window.innerHeight){var orgStyle=el.style.overflowY;var styleID=orgStyle;styleID="S_"+styleID;if(1==1||oReg[styleID]==undefined){el.style.overflowY="hidden";var w2=$FSI.___elementScaleCheck.offsetWidth;if(w2-w>1){oReg[styleID]=w2-w}}}if(!isNaN(oReg[styleID])){ret=oReg[styleID]}else{ret=-1}return ret};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(step){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180==0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=window.outerWidth;return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){return{width:wnd.innerWidth,height:wnd.innerHeight}};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.push)=="function"){ret=$FSI.cloneArray(val)}else{ret=$FSI.cloneObject(val)}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){var ret={};for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])=="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag;if(typeof(document.querySelector)=="function"){var strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector)}else{var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"s*$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){depth++;var ret="";var scripts=document.getElementsByTagName("script");var t="/"+strScriptName;var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!="object"){if(typeof($FSI.LoaderJavascript)!="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)=="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!="string"){return false}var t=typeof(parameters);if(t!="object"&&t!="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)=="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!="string"||strClass.length<1){return}if(typeof(strRule)!="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var node=element;var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.urlDecode=function(str){str=str.replace($FSI.regexPlusToSpace," ");return decodeURIComponent(str)};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=scale.x}else{scale.y=targetDimension.height/(sourceDimension.height*range.height);scale.x=scale.y}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)=="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)=="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)=="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret];return true}()}$FSI.EmptyDebugger=function(){this.log=this.error=this.dir=this.setPrefix=function(){};this.on=false};$FSI.Debugger=function(){var a="FSI";this.on=true;this.doNothing=function(){};this.log=this.doNothing;this.error=this.doNothing;this.dir=this.doNothing;try{if(console&&console.log){this.log=function(c){console.log(a+c)}}if(console&&console.error){this.error=function(c){console.error(a+c)}}if(console&&console.dir){this.dir=function(c){console.dir(c)}}}catch(b){}this.setPrefix=function(c){a=c+"> "}};$FSI.Config=function(j,s){if(!s||typeof(s)!="object"){s={}}this.parameters=(j)?j:{};this.queryParameters=undefined;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():undefined}catch(y){}this.plugins=new Object();this.arPlugins=new Array();this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=new Array();this.locales=new Object();this.locales.tips=new Object();var c=false;var l=this;this.strListFilePrefix="";this.strListFileSuffix="";var k={};var v=0;var u=false;var g;var w={};var p="FSI> ";var m=new $FSI.EmptyDebugger();var o=false;var d={};var z;var t;var q=false;this.strConfigFileExtension=".xml";l.strTemplateSuffix=".json";var r;var f=null;if($FSI.isInternetExplorer&&$FSI.versionInternetExplorer<10){r=function(B){var e;if(!$FSI.isCrossDomain(B)){q=false;e=new XMLHttpRequest()}else{q=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){r=function(){return new XMLHttpRequest()}}}if(!r){try{f=new ActiveXObject("Msxml2.XMLHTTP");r=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(y){try{f=new ActiveXObject("Microsoft.XMLHTTP");r=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(y){f=null;r=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters=new Object();this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfgAliasNamesSecondLevel={renderer:"fpxservertemplate"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(B){l.reset();if(B){if(l.parameters){l.parameters=$FSI.mergeObjects(l.parameters,B)}else{l.parameters=B}}i(l.parameters);l.getQueryParameters();l.cloneParameters(l.cfgDefaults,l.cfg);l.cloneParameters(l.queryParameters,l.cfg);l.elevateToHTTPS();n();l.BaseURL=l.getBaseURL();if(l.bForceVersion5==true){}var e=l.queryParameters.fsiviewerversion;if(l.bForceVersion5==true){e="5"}if(e!=undefined){if(parseInt(e)<6){l.strConfigFileExtension=".fsi"}}var C=l.queryParameters.fsiserverversion;if(l.bForceVersion5==true){C="2"}if(C!=undefined){if(parseInt(C)<3){l.strTemplateSuffix="_json"}}if(l.queryParameters.fsiviewerlocation!=undefined){l.locationFSIViewer=l.queryParameters.fsiviewerlocation}else{if($FSI!=undefined&&$FSI._FSIViewerLocation!=undefined){m.log("FSI Viewer location gussed based on script location: "+$FSI._FSIViewerLocation);l.locationFSIViewer=$FSI._FSIViewerLocation}else{l.locationFSIViewer=l.BaseURL.split("/");if(l.locationFSIViewer.length>4){l.locationFSIViewer.splice(l.locationFSIViewer.length-3,2);l.locationFSIViewer=l.locationFSIViewer.join("/")}}}if(l.locationFSIViewer.charAt(l.locationFSIViewer.length-1)!="/"){l.locationFSIViewer+="/"}l.nextConfigURL=l.getReloadPath(l.locationFSIViewer,l.expandFSIPath(l.cfg.defaultcfg));l.checkDebug(false)};var i=this.makeObjectPropertiesLowerCase=function(e){for(var B in e){var C=B.toLowerCase();if(B!=C){if(e[C]==undefined){e[C]=e[B]}delete e[B]}}};var n=function(){c=l.makeBool(l.cfg.usenc,false);if(l.cfg.usencquery!=undefined&&l.cfg.usencquery.length>0){o=l.cfg.usencquery;c=true;l.queryToObject("?"+o,d)}};this.stopPendingRequests=function(){for(var B in k){var e=k[B];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){l.stopPendingRequests()};this.getBaseURL=function(){var C;var B=document.getElementsByTagName("base");if(B&&B.length>0){C=B[B.length-1].href;if(C&&C.charAt(C.length-1)!="/"){C+="/"}}else{C=document.location.href;var e=C.indexOf("?");if(e!=-1){C=C.slice(0,e)}e=C.indexOf("#");if(e!=-1){C=C.substring(0,e)}e=C.lastIndexOf("/");if(e!=-1){C=C.slice(0,e+1)}}return C};this.reset=function(){m=new $FSI.EmptyDebugger();l.stopPendingRequests();g=Math.random();l.nIncludedConfigs=0;l.completedConfigs=new Object();l.plugins=new Object();l.cfg=new Object();l.queryParameters=undefined;l.arUnrecognizedConfigNodes=[]};this.getQueryParameters=function(){if(l.queryParameters!=undefined){return}l.queryParameters=new Object();l.cloneParameters(l.parameters,l.queryParameters)};this.makeBool=function(D,e){if(typeof(e)!="boolean"){e=false}var B=e;switch(typeof(D)){case"string":var C=$FSI.makeBool(D);if(C!=undefined){B=C}break;case"number":B=Boolean(D);break;case"boolean":B=D;break}return B};this.loadLanguageFile=function(){var B=l.cfg.language;if(B==undefined){B="english"}var e=l.locationFSIViewer+"/languages/"+B+".xml";var C={};l.finishRequestParams(C);Ext.Ajax.request({url:e,overrideMimeType:"application/xml",params:C,method:"GET",scope:l,success:function(D,E){l.logXMLResponseOK(D);l.onLanguageLoaded(true,D)},failure:function(D,E){l.logLoadFileFailed(D,E);l.onLanguageLoaded(false,D)}})};this.logLoadFileFailed=function(e,D){if(!m.on){return}if(e&&e.status!=undefined){var C="HTTP "+e.status;if(e&&e.statusText){C+=", "+e.statusText}var B=(e._url)?e._url:"";m.error("Failed to load "+B+" ("+C+")")}else{m.error("Failed loading a file");if(e&&e._url){m.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(E){if(!E||!E.firstChild){return false}var e=E.firstChild.childNodes;var F,C,D;for(var B=0;B<e.length;B++){C=e[B];F=l.getAttributeValue(C,"id");if(F==undefined){continue}F=F.toLowerCase();if(C.childNodes.length>0){D=l.XMLChildNodesToString(C)}else{D=l.getAttributeValue(C,"txt")}l.locales.tips[F]=D}return true};this.getAttributeValue=function(B,e){if(!B){return}return B.getAttribute(e)};this.onLanguageLoaded=function(B,e){m.log("Language loaded");if(B){l.parseLanguage(e.responseXML)}l.initPagesParameters();if(s.onConfigReady){s.onConfigReady()}};this.onConfigReadyDone=function(){if(!l.readCustomPageNumbers()){l.loadImageList()}};this.swapParameters=function(C,e){C=C.toLowerCase();e=e.toLowerCase();var B=l.plugins.pages.parameters;if(B==undefined){return}l.swapValues(B,C,e);l.swapValues(l.cfg,"pages_"+C,"pages_"+e)};this.swapValues=function(D,C,B){var e=D[C];D[C]=D[B];D[B]=e};this.initPagesParameters=function(){l.LinkTemplates=l.getPagesParameter("LinkTemplates","").split(",");for(var e=0;e<l.LinkTemplates.length;e++){l.LinkTemplates[e]=$FSI.urlDecode(l.LinkTemplates[e])}l.LinkTemplateData=l.getPagesParameter("LinkTemplateData","").split(",");for(var e=0;e<l.LinkTemplateData.length;e++){l.LinkTemplateData[e]=$FSI.urlDecode(l.LinkTemplateData[e])}l.LinkTemplateCount=Math.max(l.LinkTemplates.length,l.LinkTemplateData.length)};this.getTranslation=function(B){var e=l.locales.tips[B.toLowerCase()];if(e==undefined){e=B}return e};this.getImageURL=function(C,e){if(C==undefined){return""}if(e==undefined){e={}}if(e.type==undefined){e.type="image"}if(e.renderer==undefined){e.renderer="jpeg"}e.source=C;for(var B in w){if(e[B]==undefined){e[B]=w[B]}}return l.requestBase+"?"+l.objectToQuery(e)};this.getImageInfoURL=function(B,e){if(B==undefined){return""}if(e==undefined){e={}}if(e.type==undefined){e.type="info"}if(e.tpl==undefined){if(l.cfg.fpxinfotemplate!=undefined){e.tpl=l.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(l.cfg.headers&&l.cfg.headers.length>0){e.headers=l.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=B;return l.requestBase+"?"+l.objectToQuery(e)};this.queryToObject=function(E,C){if(C==undefined){C={}}var D,G,F,e,B;D=E.indexOf("?");if(D!=-1){B=E.slice(D+1)}else{B=""}D=B.indexOf("#");if(D!=-1){B=B.substring(0,D)}B=B.split("&");for(D=0;D<B.length;D++){G=B[D].split("=");F=$FSI.urlDecode(G[0]).toLowerCase();if(F.length>0){e=$FSI.urlDecode(G[1]);C[F]=e}}return C};this.objectToQuery=function(B){var e=[];if(c&&o!==false){for(var D in d){B[D]=d[D]}}for(var D in B){var C=encodeURIComponent(B[D]);e.push(encodeURIComponent(D)+"="+C)}return e.join("&")};this.loadConfigs=function(){l.loadNextConfig(true)};this.loadFile=function(B,C,E,F){if(!B||B.length<0){if(C){C(this,"",F)}return}if(E==undefined){E="application/json"}var e=r(B);if(!e){return}if(E&&e.overrideMimeType){e.overrideMimeType(E)}e._url=B;var D=v;k[v]=e;v++;if(q){e.onerror=function(){delete k[D];if(C==undefined||this.FSIaborted){return}l.logLoadFileFailed(this)};e.onload=function(){delete k[D];if(C==undefined||this.FSIaborted){return}var G=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var H=new ActiveXObject("Microsoft.XMLDOM");H.async=false;H.loadXML(G);G=this.responseXML=H}catch(I){m.log("Failed parsing XML using Microsoft.XMLDOM");m.log(B)}break;case"application/json":G={};try{G=$FSI.JSON.parse(this.responseText)}catch(I){m.error("Failed parsing JSON from URL: "+B+" ("+I.message+")")}break}C(this,G,F)}}else{e.onreadystatechange=function(G){var H;if(e.readyState!=4){return}delete k[D];if(C==undefined||this.FSIaborted){return}if(this.status>299){l.logLoadFileFailed(this)}switch(E){case"application/xml":case"text/xml":H=this.responseXML;break;case"application/json":H={};try{H=$FSI.JSON.parse(this.responseText)}catch(I){m.error("Failed parsing JSON from URL: "+B+" ("+I.message+")")}break}C(this,H,F)}}e.open("GET",B,true);e.send(null);return e};this.onConfigXMLLoaded=function(e,B){l.logXMLResponseOK(e.response);l.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(C){if(l.nextConfigURL==undefined){l.finalCheck();return}var e=!l.makeBool(l.cfg.ConfigCaching,true);var D={};if(l.makeBool(l.cfg.debug)||(!C&&!l.makeBool(l.cfg.configcaching,true)&&l.makeBool(l.cfg.enableconfigcachingparameter))){l.addNoCacheParams(D)}l.finishRequestParams(D);var B=l.addURLParameters(l.nextConfigURL,D);m.log("LOAD CONFIG: "+B);l.loadFile(B,l.onConfigXMLLoaded,"application/xml")};this.parseMargins=function(C,B,e,D){if(e==undefined){e=_root._FSI.StageWidth}if(D==undefined){D=_root._FSI.StageHeight}C[B+"Left"]=l.getFloatParameterPercent(B+"Left",0,e);C[B+"Top"]=l.getFloatParameterPercent(B+"Top",0,D);C[B+"Right"]=l.getFloatParameterPercent(B+"Right",0,e);C[B+"Bottom"]=l.getFloatParameterPercent(B+"Bottom",0,D);C[B+"Inner"]=l.getFloatParameterPercent(B+"Inner",0,e);C[B+"Outer"]=l.getFloatParameterPercent(B+"Outer",0,e)};this.getFloatParameterPercent=function(e,B,C){return l.parseFloatPercentDef(l.getPagesParameter(e),C,B,-1000000)};this.parseFloatPercentDef=function(D,C,B,e){if(D==undefined||D.length<1){return B}return Math.max(e,l.parseFloatPercent(D,C))};this.parsePercentDef=function(C,e){if(C==undefined||C.length<1){return e}var B=parseFloat(C);if(isNaN(B)){B=0}else{if(C.indexOf("%")!=-1){B/=100}}return B};this.parseFloatPercent=function(C,B){var e=parseFloat(C);if(isNaN(e)||e<0){e=0}else{if(C.indexOf("%")!=-1){e=Math.round(e*B/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){p=e+"> "};this.setDebugger=function(e){m=e};this.checkDebug=function(B){var e;if(l.makeBool(l.cfg.debug)){if(!m||!m.on){m=new $FSI.Debugger();if(s.onDebuggerChange){e=s.onDebuggerChange(m,B)}}}else{if(!m||m.on===true){m=new $FSI.EmptyDebugger();if(s.onDebuggerChange){e=s.onDebuggerChange(m,B)}}}return e};this.onConfigLoaded=function(B){l.parseConfig(B);l.elevateToHTTPS();if(l.checkDebug(true)==true){return}n();var e;if(l.cfg.includeconfig!=undefined&&l.nIncludedConfigs<10){e=l.getFSIPath(l.locationFSIViewer,l.expandFSIPath(l.cfg.includeconfig));l.nIncludedConfigs++;l.cfg["includeconfig("+l.nIncludedConfigs+")"]=l.cfg.includeconfig;l.cfg.includeconfig=undefined}else{if(l.cfg.cfg!=undefined){e=l.getFSIPath(l.locationFSIViewer,l.expandFSIPath(l.cfg.cfg))}}if(e!=undefined&&!l.completedConfigs[e]){l.completedConfigs[e]=true;l.nextConfigURL=e;l.loadNextConfig()}else{l.evaluateQuery(l.queryParameters,l.cfg);l.finalCheck()}};this.elevateToHTTPS=function(){if(!$FSI.bHTTPS){return}if(!l.makeBool(l.cfg.autoelevatetohttps,true)){return}b("fpxbase");b("fpxserver")};var b=function(e){if(l.cfg[e]!=undefined&&l.cfg[e].length>0&&l.cfg[e].indexOf("http://")==0){l.cfg[e]="https"+l.cfg[e].substr(4)}};this.evaluateQuery=function(B,e){for(var C in B){l.setConfigParamByValue(e,C.toLowerCase(),B[C])}};this.parseConfig=function(B){var K="";if(B!=undefined){var C=B.firstChild;if(C&&C.nodeName=="xml"){C=C.nextSibling}var J=C.childNodes;for(var G=0;G<J.length;G++){var E=J[G];if(E.nodeType!=1){continue}var H=E.nodeName.toLowerCase();K=H;var D=E.childNodes;switch(H){case"licence":break;case"plugins":for(var F=0;F<D.length;F++){l.parsePluginNode(D[F])}break;case"info":case"options":K=undefined;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(var F=0;F<D.length;F++){var I=D[F];if(I.nodeType!=1){continue}var e=l.getValueFromXMLNode(I,K);l.setConfigParam(l.cfg,e)}break;default:l.arUnrecognizedConfigNodes.push(E)}}}};this.getData=function(){var e={};e.cfg={};for(var B in l.cfg){e.cfg[B]=l.cfg[B]}return e};this.setData=function(e){if(!e||!e.cfg){return}l.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var B in e){l.cfg[B]=e[B]}a()};this.getImagesNodeList=function(C){var e=[];if(C==undefined){C=l.getUnrecognizedConfigNode("images")}if(C){var D=C.firstChild;while(D){if(D.nodeType==1){var B={};B.attributes={};h(D,B.attributes);B.cfg={};l.parseConfigFragment(D,B.cfg);e.push(B)}D=D.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){l.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(D){var e;D=D.toLowerCase();for(var B=l.arUnrecognizedConfigNodes.length-1;B>-1;B--){var C=l.arUnrecognizedConfigNodes[B];if(C&&C.nodeName.toLowerCase()==D){e=C;break}}return e};this.parseConfigFragment=function(D,H,G){var L="";if(D!=undefined&&H!=undefined){if(G==undefined){G=[]}var B=D;var K=B.childNodes;for(var F=0;F<K.length;F++){var D=K[F];if(D.nodeType!=1){continue}var I=D.nodeName.toLowerCase();L=I;var C=D.childNodes;switch(I){case"info":case"options":L=undefined;case"fpx":case"image":case"include":for(var E=0;E<C.length;E++){var J=C[E];if(J.nodeType!=1){continue}var e=l.getValueFromXMLNode(J,L);l.setConfigParam(H,e)}break;default:G.push(D)}}}};this.findXMLNode=function(B,e){if(B==undefined||B.nodeType==undefined){return undefined}while(B){if(B.nodeName.toLowerCase()==e){break}if(B.firstChild!=undefined){B=B.firstChild}else{if(B.nextSibling!=undefined){B=B.nextSibling}else{B=B.parentNode.nextSibling}}}return B};this.getValueFromXMLNode=function(C,e){if(!C||C.nodeType!=1){return}var B=new Object();var D=(e)?e:"";B.name=D+C.nodeName.toLowerCase();var E=C.getAttribute("value");if(E){B.value=E;return B}B.value=l.XMLChildNodesToString(C);B.node=C;return B};this.getXMLNodeAttribute=function(D,C,e){if(!D||D.nodeType!=1||!D.getAttribute){return e}var B=D.getAttribute(C);if(B==undefined||B==null){B=e}return B};this.XMLChildNodesToString=function(B){if(!B||!B.firstChild){return""}var e="";if(B.childNodes.length==1&&B.firstChild.nodeType==3){e=B.firstChild.nodeValue}else{e=l._XMLChildNodesToString(B)}return e};this.hasPlugin=function(e){return(l.plugins&&l.plugins[e]!=undefined)};this.getPluginParameter=function(G,B,e,F){G=G.toLowerCase();B=B.toLowerCase();if(l.plugins[G]==undefined){m.error("CANNOT GET PLUGIN PARAMETER, because plugin not defined: "+G+"."+B);return e}var E;var D=G+"_"+B;if(l.cfg[D]!=undefined){E=l.cfg[D]}else{var C=l.plugins[G].parameters;if(C!=undefined&&C[B]!=undefined){E=C[B]}}if(E==undefined){E=e}if(F){E=l.makeBool(E,e)}return E};this.getUnescapedPagesParameter=function(D,C,B){var e=l.getPagesParameter(D,C);if(e==undefined&&B!=undefined){e=l.getPagesParameter(B,C)}if(e!=undefined){e=$FSI.urlDecode(e)}return e};this.getIntParameterMinMax=function(B,C,e,D){return Math.min(D,Math.max(e,l.getIntParameter(B,C)))};this.getIntParameter=function(B,C){var e=parseInt(l.cfg[B.toLowerCase()]);if(isNaN(e)){e=C}return e};this.getStringParameter=function(B,C){var e=l.cfg[B.toLowerCase()];if(e==undefined){e=C}return e};this.getFloatParameter=function(B,C){var e=parseFloat(l.cfg[B.toLowerCase()]);if(isNaN(e)){e=C}return e};this.getRGBAValue=function(B){var e=new Object();if(B==undefined){B=""}if(B.charAt(0)=="#"){B=B.substr(1)}if(B.length>8){B=B.substr(0,8)}if(B.length>5){e.webColor="#"+B.substr(0,6);e.red=parseInt(B.substr(0,2),16);e.green=parseInt(B.substr(2,2),16);e.blue=parseInt(B.substr(4,2),16);if(B.length<7){e.alpha=255}else{e.alpha=parseInt(B.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};this.getPagesParameter=function(B,e,C){return l.getPluginParameter("pages",B,e,C)};var h=function(F,B){if(!F||!F.attributes||!F.attributes.length||!B){return false}var C=F.attributes;for(var E=0;E<C.length;E++){var e=C[E];var D=e.nodeName.toLowerCase();B[D]=e.value}return true};this.parsePluginNode=function(C){if(C.nodeType!=1){return}var E=new Object();h(C,E);var D=C.childNodes;for(var e=0;e<D.length;e++){var F=D[e];if(F.nodeType!=1){continue}var B=l.getValueFromXMLNode(F);if(B.value!=undefined){E[B.name]=B.value;if(B.node!=undefined){E[B.name+".node"]=B.node}}}this.addPluginFromString(E.src,E)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.addPluginsFromString=function(C){if(C==undefined||C.split==undefined||C.length<1){return}var e=C.split(",");for(var B=0;B<e.length;B++){var D=l.trimString(e[B]);l.addPluginFromString(D)}};this.addPluginFromString=function(B,C){if(B==undefined||B.length<1){m.error("PLUGIN without src parameter:");return}B=B.toLowerCase();if(C==undefined){C=new Object()}var e=l.plugins[B]=new Object();e.name=B;if(l.pluginDefaultParameters[B]!=undefined){e.parameters=new Object();l.cloneParameters(l.pluginDefaultParameters[B],e.parameters);l.cloneParameters(C,e.parameters)}else{e.parameters=C}};this.setConfigParamByValue=function(B,C,e){l.setConfigParam(B,{name:C.toLowerCase(),value:e})};this.setConfigParam=function(B,C){var D=C.name;var e=C.value;if(D==undefined){return}if(l.cfgAliasNames[D]!=undefined){D=l.cfgAliasNames[D]}if(B[D]!=undefined&&(typeof(e)=="string"&&$FSI.BoolTable[e.toLowerCase()]==false)&&$FSI.BoolTable[B[D]]==undefined){delete B[D]}else{switch(D){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(B[D]!=undefined&&B[D].length>0&&B[D].indexOf(e)==-1){B[D]+=","+e}else{B[D]=e}break;case"plugins":l.addPluginsFromString(e);break;case"fpxpath":B[D]=e;B.fpxsrc=encodeURIComponent(e);break;default:B[D]=e;if(C.node!=undefined){B[D+".node"]=C.node}}}};var a=function(){l.serverProfile=l.cfg.fpxservertemplate;l.serverProfileDoublePage=l.cfg.fpxservertemplatedoublepage;if(l.serverProfileDoublePage==undefined){l.serverProfileDoublePage="doublepage"}l.serverBase=l.cfg.fpxserver;if(l.serverBase==undefined){m.log("Note:",true);m.log("Parameter 'imageserver' undefined, guess from ["+l.locationFSIViewer+"]",true);var B;B=l.locationFSIViewer.indexOf("/users/");if(B!=-1){l.serverBase=l.locationFSIViewer.substring(0,B)+"/server"}else{B=l.locationFSIViewer.indexOf("/viewer/");l.serverBase=l.locationFSIViewer.substring(0,B)+"/server"}m.log("guessed location is: ["+l.serverBase+"]",true)}l.requestBase=l.serverBase;w={};var e=l.cfg.effects;if(e!=undefined){w.effects=e}e=l.cfg.lefteffects;if(e!=undefined){w.lefteffects=e}e=l.cfg.righteffects;if(e!=undefined){w.righteffects=e}e=l.cfg.quality;if(e!=undefined){w.quality=e}};this.finalCheck=function(){l.elevateToHTTPS();a();if(s.onConfigsReady){s.onConfigsReady()}m.log("Evaluated Configuration:");m.dir(l.cfg)};var A=l.finishURL=function(e){if(!c||e==undefined){return e}var B;if(o===false){B="cache=0&cachernd="+g;if(e.indexOf("?")==-1){e+="?"+B}else{e+="&"+B}}else{B=o;if(e.indexOf("?")==-1){e+="?"+B}else{e+=B}}return e};this.addURLParameters=function(B,C){if(!B||!C){return B}var e=[];for(var D in C){e.push(encodeURIComponent(D)+"="+encodeURIComponent(C[D]))}if(e.length>0){if(B.indexOf("?")==-1){B+="?"}else{B+="&"}B+=e.join("&")}return B};this.finishRequestParams=function(B){if(c){if(o===false){B.cache=0;B.cachernd=g}else{for(var e in d){B[e]=d[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=g};this.parseQuery=function(B,e){if(e==undefined||B==undefined||B.length<1){return}l.queryToObject(B,e);if(e.ignorequeryparameters!=undefined){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=undefined){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,B){if(e==undefined||B==undefined){m.error("Cloning object failed: "+e+" / "+B)}for(var C in e){B[C]=e[C]}};this.getFSIPath=function(B,C){if(C.indexOf("://")!=-1){return C}if(l.cfg.fsibase!=undefined){C=l.cfg.fsibase+C}var e=l.getReloadPath(B,C);return e};this.expandFSIPath=function(B){var e=$FSI.urlDecode(B);if(e.indexOf("?")!=-1||e.indexOf(l.strConfigFileExtension)==(e.length-4)){return B}return B+l.strConfigFileExtension};this.getReloadPath=function(D,F){var B,G,e,E;if(D==undefined){D=l.locationFSIViewer}if(F==undefined){F=""}var C="/";if(F.indexOf("://")!=-1){return F}B=D;E=B.lastIndexOf("?");if(E==-1){E=B.length}G=B.lastIndexOf("\\",E);e=B.lastIndexOf("/",E);G=Math.max(G,e);if(G==-1){G=B.length-1}B=B.slice(0,G);if(B.length>0&&F.indexOf(C)!=0){B+=C}return B+F};this.cloneValueObject=function(B){var e=new Object();for(var C in B){e[C]=B[C]}return e};this._getXMLConfigValue=function(e){var B;if(!e){return}if(e.childNodes.length>0){B=l._XMLChildNodesToString(e)}else{B=e.getAttribute("value")}return B};this._XMLChildNodesToString=function(D){if(!D||!D.firstChild){return""}var B="";try{if(D.xml!=undefined){for(var C=0;C<D.childNodes.length;C++){B+=D.childNodes[C].xml}}else{for(var C=0;C<D.childNodes.length;C++){B+=l.XMLSerializer.serializeToString(D.childNodes[C])}}}catch(E){}return B};this._findFirstXMLNode=function(C,D){var B,e;while(C){if(C.nodeName==D){e=C;break}B=C.firstChild;if(!B){B=C.nextSibling}if(!B&&C.parentNode){B=C.parentNode.nextSibling}C=B}return e};this._parseXMLImageList=function(E){var F={};var e=F.arImages=[];var B;if(!E){return e}var C=l._findFirstXMLNode(E,"images");if(!C){return e}var C=l._findFirstXMLNode(C,"image");if(!C){return e}while(C){if(C.nodeType==1){B=l._findFirstXMLNode(C,"path");var D=l._getXMLConfigValue(B);if(!D){D=$FSI.urlDecode(l.getAttributeValue(C,"file"))}if(D!=undefined){e.push(D)}if(F.width==undefined){B=l._findFirstXMLNode(C,"width");B=l._getXMLConfigValue(B);if(B!=undefined){F.width=parseInt(B)}B=l._findFirstXMLNode(C,"height");B=l._getXMLConfigValue(B);if(B!=undefined){F.height=parseInt(B)}}}C=C.nextSibling}return F};this.getImageList=function(){var e;if(l.cfg&&l.cfg.fpxsources!=undefined){e={};e.oXML=null;e.arImages=l.cfg.fpxsources.split(",");for(var C=0;C<e.arImages.length;C++){e.arImages[C]=$FSI.urlDecode(e.arImages[C])}return e}if(l.arUnrecognizedConfigNodes&&l.arUnrecognizedConfigNodes.length>0){var B=l.arUnrecognizedConfigNodes;for(var C=0;C<B.length;C++){var D=B[C];if(D&&D.nodeName.toLowerCase()=="images"){e=l._parseXMLImageList(D);e.oXML=D}}}if(l.cfg&&l.cfg.fpxsrc!=undefined){e={};e.oXML=null;e.arImages=[];e.arImages.push($FSI.urlDecode(l.cfg.fpxsrc));return e}return e};this.loadImageList=function(D,E,G,F){if(!l.serverBase||!D){return false}var C=l.serverBase+"?type=list";if(D.indexOf("tpl")==-1){var B=l.cfg.listtemplate;if(B&&B.length>0&&B.indexOf(".json")==-1&&B.indexOf(".xml")==-1){B+=".json"}C+="&tpl="+B}if(l.cfg.headers&&l.cfg.headers.length>0&&d.headers==undefined){C+="&headers="+l.cfg.headers}C+="&source="+encodeURIComponent(D);if(G!=undefined){C+=G}C=A(C);var e=l.loadFile(C,function(H,K){if(typeof(K)=="object"&&typeof(K.images)=="object"){K.images.pop();var L="";if(K&&K.imagesattributes&&K.imagesattributes.dir){L=K.imagesattributes.dir}var I=new Array(K.images.length);for(var J=0;J<K.images.length;J++){I[J]=L+K.images[J].src}E(I,K,F)}else{E([],K,F)}},"application/json",F);return e}};$FSI.CustomEventListener=function(i){var k=this;var b=[];var e={};var f={};var g=0;k._strClassName="$FSI.CustomEventListener";var j=function(){if($FSI.eventFunctionID==undefined){$FSI.eventFunctionID=0}if($FSI.eventElementID==undefined){$FSI.eventElementID=0}};var h=this.destroy=function(){for(var l=0;l<b.length;l++){var m=b[l];d(m.element,m.fn)}b=[];e={};f={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;l.fn.call(l.element,m);return true};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<b.length;n++){var l=b[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};var a=this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){$FSI.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI==undefined){p.__FSI={}}if(p.__FSI.eventElementID==undefined){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=$FSI.eventElementID++}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID==undefined){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=$FSI.eventFunctionID++}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(e[m]==undefined){var l=e[m]={};l.nFunction=0;l.oFunctions={}}if(e[m].oFunctions[n]==undefined){e[m].nFunction++;e[m].oFunctions[n]=[]}else{$FSI.console.warn(k._strClassName+": There is already a listener for this exact element and function");$FSI.console.log(p);$FSI.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=g++;e[m].oFunctions[n].push(q);b.push(q);f[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(b.length);return q};this.setListenerProps=function(o,m,n){var l=f[o];if(!l){return false}if(l.props==undefined){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=f[n];if(l==undefined||l.enabled==m){return}l.enabled=m};this.pauseListener=function(n,m){var l=f[n];if(l==undefined||l.paused==m){return}l.paused=m};var d=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){$FSI.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(p.__FSI==undefined||p.__FSI.eventElementID==undefined||o.__FSIEventFunctionID==undefined){if(o.__FSIEventFunctionID==undefined){$FSI.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{$FSI.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!e[l]){$FSI.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=e[l].oFunctions[n];if(m==undefined||typeof(m.pop)!="function"){$FSI.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount==0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount==0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length==0){delete e[l].oFunctions[n];e[l].nFunction--;if(e[l].nFunction==0){delete e[l]}}delete f[q.uniqueID];c();k._onListenerRemove(q);k._onListenerCountChange(b.length);return q};this.getEventListenerByID=function(l){return f[l]};this.getListenerObjectByID=function(l){return f[l]};this.getListenersArray=function(){return b};this.getListenerCount=function(){return b.length};var c=function(){b=[];for(var m in e){var o=e[m].oFunctions;for(var n in o){var l=o[n];b=b.concat(l)}}};this.dump=function(){$FSI.console.dir(e);$FSI.console.dir(b)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()};$FSI.CustomEventListenerElementDimension=$FSI.oCustomEventListenerClasses.FSIElementDimension=function(){var k=this;var a=false;var g=25;var d;var b=0;var e={};e[0]=25;e[25]=50;e[50]=100;e[75]=250;var h=76;var c=-1;$FSI.CustomEventListener.prototype.constructor.call(k,"FSIElementDimension");k._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(l){if(l<1){clearInterval(d);d=undefined}else{if(d==undefined){d=setInterval(j,e[0])}}};this._onListenerAdd=function(l){l.__elementWidth=l.element.offsetWidth;l.__elementHeight=l.element.offsetHeight};this.setListenerProps=function(o,m,n){if(typeof(m)!="string"){return false}var l=k.getListenerObjectByID(o);if(!l){return false}switch(m){case"treshold":if(n&&n>0){l.tresholdEnd=n}break;case"fireTresholdEventOnly":l.fireTresholdEventOnly=n;break}};var j=function(){var m=k.getListenersArray();var p=false;for(var o=0;o<m.length;o++){var l=m[o];if(l.__elementWidth!=l.element.offsetWidth||l.__elementHeight!=l.element.offsetHeight){p=true;if(l.tresholdEnd){l.treshold=g}i(l,false)}else{if(l.treshold>0){l.treshold+=g;if(l.treshold>=l.tresholdEnd){i(l,true);l.treshold=0}}}}if(p){b=0;f(e[0])}else{if(b<h){b++;var n=e[b];if(n!=undefined){f(n)}}}};var f=function(l){if(l==g||d==undefined){return}g=l;clearInterval(d);d=setInterval(j,g)};var i=function(l,n){var m={};if(n){m.FSI_after_treshold=l.treshold}m.FSI_target=l.element;m.FSI_dimension_old={width:l.__elementWidth,height:l.__elementHeight};l.__elementWidth=l.element.offsetWidth;l.__elementHeight=l.element.offsetHeight;m.FSI_dimension={width:l.__elementWidth,height:l.__elementHeight};if(n||!l.fireTresholdEventOnly){k.fireEvent(l,m)}};this.triggerEvent=function(m){var l=k.getEventListenerByID(m);if(!l){return}if(l.tresholdEnd){l.treshold=1}i(l)};this.triggerEvents=function(){var l=k.getListenersArray();for(var m=0;m<l.length;m++){if(l[m].tresholdEnd){l[m].treshold=1}i(l[m])}}};$FSI.Easing={easeInQuad:function(e,f,a,g){return g*(e/=f)*e+a},easeOutQuad:function(e,f,a,g){return -g*(e/=f)*(e-2)+a},easeInOutQuad:function(e,f,a,g){if((e/=f/2)<1){return g/2*e*e+a}return -g/2*((--e)*(e-2)-1)+a},easeInCubic:function(e,f,a,g){return g*(e/=f)*e*e+a},easeOutCubic:function(e,f,a,g){return g*((e=e/f-1)*e*e+1)+a},easeInOutCubic:function(e,f,a,g){if((e/=f/2)<1){return g/2*e*e*e+a}return g/2*((e-=2)*e*e+2)+a},easeInQuart:function(e,f,a,g){return g*(e/=f)*e*e*e+a},easeOutQuart:function(e,f,a,g){return -g*((e=e/f-1)*e*e*e-1)+a},easeInOutQuart:function(e,f,a,g){if((e/=f/2)<1){return g/2*e*e*e*e+a}return -g/2*((e-=2)*e*e*e-2)+a},easeInQuint:function(e,f,a,g){return g*(e/=f)*e*e*e*e+a},easeOutQuint:function(e,f,a,g){return g*((e=e/f-1)*e*e*e*e+1)+a},easeInOutQuint:function(e,f,a,g){if((e/=f/2)<1){return g/2*e*e*e*e*e+a}return g/2*((e-=2)*e*e*e*e+2)+a},easeInSine:function(e,f,a,g){return -g*Math.cos(e/f*(Math.PI/2))+g+a},easeOutSine:function(e,f,a,g){return g*Math.sin(e/f*(Math.PI/2))+a},easeInOutSine:function(e,f,a,g){return -g/2*(Math.cos(Math.PI*e/f)-1)+a},easeInExpo:function(e,f,a,g){return(e==0)?a:g*Math.pow(2,10*(e/f-1))+a},easeOutExpo:function(e,f,a,g){return(e==f)?a+g:g*(-Math.pow(2,-10*e/f)+1)+a},easeInOutExpo:function(e,f,a,g){if(e==0){return a}if(e==f){return a+g}if((e/=f/2)<1){return g/2*Math.pow(2,10*(e-1))+a}return g/2*(-Math.pow(2,-10*--e)+2)+a},easeInCirc:function(e,f,a,g){return -g*(Math.sqrt(1-(e/=f)*e)-1)+a},easeOutCirc:function(e,f,a,g){return g*Math.sqrt(1-(e=e/f-1)*e)+a},easeInOutCirc:function(e,f,a,g){if((e/=f/2)<1){return -g/2*(Math.sqrt(1-e*e)-1)+a}return g/2*(Math.sqrt(1-(e-=2)*e)+1)+a},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(e,g,a,h,f){if(f==undefined){f=1.70158}return h*(e/=g)*e*((f+1)*e-f)+a},easeOutBack:function(e,g,a,h,f){if(f==undefined){f=1.70158}return h*((e=e/g-1)*e*((f+1)*e+f)+1)+a},easeInOutBack:function(e,g,a,h,f){if(f==undefined){f=1.70158}if((e/=g/2)<1){return h/2*(e*e*(((f*=(1.525))+1)*e-f))+a}return h/2*((e-=2)*e*(((f*=(1.525))+1)*e+f)+2)+a},easeInBounce:function(e,f,a,g){return g-jQuery.easing.easeOutBounce(x,f-e,0,g,f)+a},easeOutBounce:function(e,f,a,g){if((e/=f)<(1/2.75)){return g*(7.5625*e*e)+a}else{if(e<(2/2.75)){return g*(7.5625*(e-=(1.5/2.75))*e+0.75)+a}else{if(e<(2.5/2.75)){return g*(7.5625*(e-=(2.25/2.75))*e+0.9375)+a}else{return g*(7.5625*(e-=(2.625/2.75))*e+0.984375)+a}}}},easeInOutBounce:function(e,f,a,g){if(e<f/2){return jQuery.easing.easeInBounce(x,e*2,0,g,f)*0.5+a}return jQuery.easing.easeOutBounce(x,e*2-f,0,g,f)*0.5+g*0.5+a}};$FSI.TouchHandler=function(j,aR,ah,c,aL){var aB=this;var aI=false;var ag=true;var l=false;var aP=false;var aH=false;var az,B,g,Z;var aA,V,aF;var e=false;var aa;var n;var aU={};var an=[];var Y=0;var F=window;var o;var aQ;var b;var aT=[];var aN={x:0,y:0};var r={x:0,y:0};var ao=40;var k={};k.enabled=false;k.factor=5;k.fEndDiff=1;var av={};av.enabled=false;av.minFrames=14;av.factorAmount=23;av.factorFrames=2.6;av.offsetFrames=5;var aw;var aE,s,i;var C;var ap={};var U;var aK=false;var v=false;var ai={};ai.name="none";var K;var T;var W={};if(!aR||typeof(aR)!="object"){aR={}}var ak=function(){if(aI){aB.destroy()}aQ=w;o=undefined;if($FSI.topWindow!=window){o=$FSI.topWindow;try{var aZ=$FSI.getWindowOffset(window);if(aZ.x!=undefined&&aZ.y!=undefined){aQ=am}}catch(aY){aQ=w;o=undefined}}else{o=undefined}C=aR.oPassTrough;if(aR.getPageCoords){n=aC}else{n=J}if(aR.afterTouch){for(var a0 in aR.afterTouch){av[a0]=aR.afterTouch[a0]}}if(av.fnStartStopAfterTouch&&typeof(av.fnStartStopAfterTouch)!="function"){av.fnStartStopAfterTouch=undefined}if(av.fnStartStopAfterTouch){av.useAnimationFrame=undefined}if(typeof(av.modifyTarget)!="function"){av.modifyTarget=undefined}if(typeof(av.fnGetAfterTouchEnabled)=="function"){aw=av.fnGetAfterTouchEnabled}else{aw=undefined}if(aR.smoothing){for(var a0 in aR.smoothing){k[a0]=aR.smoothing[a0]}}if(aR.detectClick==true){U=true}if(aR.preventSelection!==false){aR.preventSelection=true}if(!j){return}if(typeof(j.join)!="function"){j=[j]}if(typeof(ah)!="function"){ah=w}if(typeof(c)!="function"){c=w}if(typeof(aL)!="function"){aL=w}if(typeof(aR.onPinchChange)=="function"){K=aR.onPinchChange}else{K=undefined}aK=aR.detectGestures;aT=[];au(true,aK);for(var aX=0;aX<j.length;aX++){var aW=j[aX];if(aW&&typeof(aW.nodeName)!="undefined"){var a0={};a0.element=aW;aT.push(a0);$FSI.addEvent(aW,"mousedown",O);if($FSI.isTouch){al(aW,O);try{if(aW.style!=undefined){if($FSI.BrowserSupports.cssTouchAction()){if(ap.cssTouchAction!=undefined){m(aW,ap.cssTouchAction)}}}}catch(aY){}}}}};var P=this.enable=function(aW){if(ag==aW){return}if(!aW){N();ad(false,false)}else{ad(ap.captureScrollUser,ap.capturePinchUser)}ag=aW};this.getEnabled=function(){return ag};this.cancel=function(){M();ac();aG();N()};var aG=function(){if(k.enabled){f()}y()};this.cancelAfterTouch=function(){y()};this.getInitialDownEvent=function(){return T};var N=function(){if(!l){return}aG();l=false;T=undefined;v=false;a();aU={};an=[];Y=0};this.destroy=function(){aB.cancel();var aW;for(var aX=0;aX<aT.length;aX++){var aY=aT[aX];aW=aY.element;$FSI.removeEvent(aW,"mousedown",O);t(aW,O)}ap={}};var ay=function(aX){if(!aX||!aX.style){return}var aW=aX.style.touchAction;if(aW==undefined){aW=aX.style.msTouchAction}return aW};var m=function(aW,aX){if(!$FSI.BrowserSupports.cssTouchAction()||!aW||!aW.style){return}aW.style.touchAction=aW.style.msTouchAction=aX};var aj=function(aX){for(var aW=0;aW<aT.length;aW++){al(aT[aW].element,aX)}};var D=function(aX){for(var aW=0;aW<aT.length;aW++){t(aT[aW].element,aX)}};var al=function(aX,aW){$FSI.addEvent(aX,"touchstart",aW);$FSI.addEvent(aX,"MSPointerDown",aW);$FSI.addEvent(aX,"pointerdown",aW);$FSI.addEvent(aX,"MSHoldVisual",$FSI.preventDefaultEvent)};var t=function(aX,aW){$FSI.removeEvent(aX,"touchstart",aW);$FSI.removeEvent(aX,"MSPointerDown",aW);$FSI.removeEvent(aX,"pointerdown",aW);$FSI.removeEvent(aX,"MSHoldVisual",$FSI.preventDefaultEvent)};var w=function(){return true};var aM=function(aW){if(aH){S(aW,aW.pointerId)}else{var aX=aW.changedTouches;for(var aY=0;aY<aX.length;aY++){S(aX[aY],aX[aY].identifier)}}};var S=function(aW,aY){if(aY==undefined||aU[aY]!=undefined){if(aR.debug){if(aY==undefined){$FSI.console.error("doRegisterPointer: no pointerId")}if(aU[aY]!=undefined){$FSI.console.error("doRegisterPointer: pointerId already registered: "+aY)}}return}Y++;var aX=aU[aY]={};aX.identifier=aY;n(aX,aW);an.push(aX)};var af=function(aW){var aY=false;if(aH){aY=H(aW.pointerId)}else{var aX=aW.changedTouches;if(aX){for(var aZ=0;aZ<aX.length;aZ++){aY=H(aX[aZ].identifier)}}}if(aY){an=new Array(Y);var a1=0;for(var a0 in aU){an[a1++]=aU[a0]}}};var H=function(aW){if(aW==undefined||aU[aW]==undefined){if(aR.debug){if(aW==undefined){$FSI.console.error("doUnregisterPointer: no pointerId")}if(aU[aW]==undefined){$FSI.console.error("doUnregisterPointer: pointerId not registered: "+aW)}}return false}delete aU[aW];Y--;return true};var J=function(aX,aW){aX.x=aW.clientX;aX.y=aW.clientY};var aC=function(aX,aW){aX.x=aW.pageX;aX.y=aW.pageY};var p=function(aW){var aX=aW.changedTouches;if(aX){for(var aZ=0;aZ<aX.length;aZ++){var aY=aU[aX[aZ].identifier];if(aY){n(aY,aX[aZ])}}}if(an.length>0){aN.x=an[0].x;aN.y=an[0].y}};var at=function(aW){var aX=aU[aW.pointerId];if(aX){n(aX,aW)}if(an.length>0){aN.x=an[0].x;aN.y=an[0].y;aQ(aW,aN)}};var R=function(aW){n(aN,aW);aQ(aW,aN)};this.getMousePositionPage=function(aX){var aW={};aC(aW,aX);aQ(aX,aW);return aW};this.getMousePositionClient=function(aX){var aW={};J(aW,aX);aQ(aX,aW);return aW};var q=function(aW,aX){if(window!=aW.view){var aY=$FSI.getWindowOffset(window);aX.x-=aY.x;aX.y-=aY.y}};var am=function(aW){try{q(aW);aQ=q}catch(aX){aQ=w}};var ax=function(aW){if(!ag){return}var aY=Y;if(v&&aY==0){v=false}var aZ=aW.type;if(l||ai.started){if(aZ!=az){if(ai.started){M();ac()}else{aW._FSI_Canceled=true;aV(aW,true)}}}az=aZ;b=false;var aX=true;switch(aZ){case"touchstart":aP=true;aH=false;aa=p;g="touchmove";B="touchend";Z="touchcancel";aE=false;break;case"MSPointerDown":aa=at;aP=true;aH=true;g="MSPointerDown";B="MSPointerUp";Z="MSPointerCancel";aE=false;b=true;break;case"pointerdown":aa=at;aP=true;aH=true;g="pointermove";B="pointerup";Z="pointercancel";aE=true;b=true;break;default:aP=false;aH=false;if(aR.preventSelection){aE=true}else{aE=false}aX=false;aa=R;g="mousemove";B="mouseup";Z=undefined;b=true}if(aP&&aX){aM(aW)}aa(aW);if(aE&&aW.preventDefault){aW.preventDefault()}if(Y>1){W.bClick=false}s=false;if(aX&&ae(aW)){if(aY==0){y();A()}return false}return true};var O=function(aW){if(!ax(aW)){return}if(l||aW.which>1){return}d(aW)};this.getCurrentPos=function(){return r};var d=function(aW){aG();if(l){return}av.evtMove=undefined;if(k.enabled){r={x:aN.x,y:aN.y}}else{r=aN}W.x=aN.x;W.y=aN.y;var aX=T;T=aW;if(!ah.call(F,aW,r,C)){T=aX;return false}l=true;if(U&&!v){W.bClick=true;W.clickRadiusX=W.clickRadiusY=0}else{W.bClick=false}A();if(av.enabled){av.x=av.y=0;av.lastX=aN.x;av.lastY=aN.y;if(av.nInterval){clearInterval(av.nInterval)}av.nInterval=setInterval(X,30)}return true};var a=function(){if(e&&V!=undefined){e=false;$FSI.removeEvent(window,V,ab);$FSI.removeEvent(window,aA,aV);if(b&&o){try{$FSI.removeEvent(o,V,ab);$FSI.removeEvent(o,aA,aV)}catch(aW){}}if(aF!=undefined){$FSI.removeEvent(window,aF,aq)}V=aA=aF=undefined}};var A=function(){if(e){a()}e=true;V=g;aA=B;aF=Z;$FSI.addEvent(window,V,ab);$FSI.addEvent(window,aA,aV);if(b&&o){try{$FSI.addEvent(o,V,ab);$FSI.addEvent(o,aA,aV)}catch(aW){}}if(Z!=undefined){$FSI.addEvent(window,aF,aq)}};var ab=function(aW){aa(aW);aW.FSI_start_x=W.x;aW.FSI_start_y=W.y;if(av.enabled&&av.evtMove==undefined){av.evtMove=aW}if(l){if(W.bClick){W.clickRadiusX=Math.max(W.clickRadiusX,Math.abs(aN.x-W.x));if(W.clickRadiusX>10){W.bClick=false}else{W.clickRadiusY=Math.max(W.clickRadiusY,Math.abs(aN.y-W.y));if(W.clickRadiusY>10){W.bClick=false}}}if(k.enabled){k.evt=aW;aS()}else{c.call(F,aW,r,C)}}else{if(ai.started){if(ai.nType==1){ar(aW)}}}if(s&&!aW.FSI_allowEventDefault){aW.preventDefault()}};var ar=function(aW){var aX=h();if(!K){return}aW._FSI_PinchDeltaStart=ai.nPinchDistance-ai.pinchDistanceStart;aW._FSI_PinchDeltaRelative=ai.nPinchDistance-ai.pinchDistanceLast;aW._FSI_PinchScale=Math.max(ao,ai.pinchDistanceLast)/ai.pinchDistanceStartMaxed;ai.pinchDistanceLast=ai.nPinchDistance;aW._FSI_PinchDistance=aX;K.call(F,aW,aN,C)};var aq=function(aW){if(aP){af(aW);if(Y<1){if(l){aW._FSI_Canceled=true;aV(aW,true);return}else{N();return}}}aa(aW);ae(aW)};var aV=function(aW,aX){if(aX){aW._FSI_Canceled=true}if(aP){af(aW)}aa(aW);if(!aX&&ae(aW)){return}aG();if(!aX){if(!l||Y>0){return}}aW.FSI_start_x=W.x;aW.FSI_start_y=W.y;var aY=false;if(!aX&&av.enabled){if(aw==undefined||aw()){aY=Q(aW)}}if(aY){N();u(aW)}else{if(U){aW._FSI_Click=W.bClick}aL.call(F,aW,r,C);N()}if(aW.preventDefault){aW.preventDefault()}};var aJ=function(aW){return Y};var E=function(aW){return an};var aS=function(){if(k.animationFrame!=undefined){return}aO()};var f=function(){if(k.animationFrame==undefined){return}cancelAnimationFrame(k.animationFrame);k.animationFrame=undefined};var aO=function(){var aW=Math.abs(r.x-aN.x)+Math.abs(r.y-aN.y);if(aW>k.fEndDiff){r.x+=(aN.x-r.x)/k.factor;r.y+=(aN.y-r.y)/k.factor;k.animationFrame=requestAnimationFrame(aO)}else{r.x=aN.x;r.y=aN.y;k.animationFrame=undefined}c.call(F,k.evt,r,C)};var Q=function(aW){if(!av.enabled){return false}if(av.running){y()}av.pos=0;var aY=av.factorAmount;av.startX=r.x;av.startY=r.y;var aX={};aX.x=av.startX+aY*av.x;aX.y=av.startY+aY*av.y;if(av.roundTargetPos){aX.x=Math.round(aX.x);aX.y=Math.round(aX.y)}if(av.modifyTarget){aX=av.modifyTarget.call(F,aX,C)}av.amountX=aX.x-av.startX;av.amountY=aX.y-av.startY;aY=av.factorFrames/100;av.frames=av.offsetFrames+Math.round(aY*Math.abs(av.amountX)+aY*Math.abs(av.amountY));if(av.frames<av.minFrames){return false}return true};this.isAfterTouchRunning=function(){return av.running};var u=function(aW){if(typeof(aR.onAfterTouchStart)=="function"){aR.onAfterTouchStart.call(F,aW,r,C)}av.running=true;av.evtUp=aW;if(av.fnStartStopAfterTouch){av.fnStartStopAfterTouch.call(F,true,av.evtMove,C)}else{if(av.useAnimationFrame){av.animationFrameRun=requestAnimationFrame(G)}else{av.intervalRun=setInterval(G,16)}}return true};var aD=function(aX,aW,aZ,aY){return aZ*((aX=aX/aY-1)*aX*aX+1)+aW};var G=this.runAfterTouch=function(){var aW=false;av.pos++;r.x=aD(av.pos,av.startX,av.amountX,av.frames);r.y=aD(av.pos,av.startY,av.amountY,av.frames);c.call(F,av.evtMove,r,C);if(av.pos==av.frames){y(true)}else{if(av.useAnimationFrame){av.animationFrameRun=requestAnimationFrame(G)}aW=true}return aW};this.enableAfterTouch=function(aW){if(av.enabled==aW){return}if(!aW){y()}av.enabled=aW};var y=function(aW){if(!av.running){return}if(av.fnStartStopAfterTouch){av.fnStartStopAfterTouch.call(F,false,av.evtMove,C)}else{if(av.useAnimationFrame){if(av.animationFrameRun){cancelAnimationFrame(av.animationFrameRun)}}else{if(av.intervalRun){clearInterval(av.intervalRun);av.intervalRun=undefined}}}if(typeof(av.onAfterTouchEnd)=="function"){av.onAfterTouchEnd.call(F,av.evtMove,C)}av.evtMove=undefined;av.running=false;av.evtUp._FSI_Canceled=(aW!==true);av.evtUp._FSI_fromAfterTouch=true;aL.call(F,av.evtUp,r,C)};var X=function(){av.x=(2*av.x+aN.x-av.lastX)/5;av.y=(2*av.y+aN.y-av.lastY)/5;av.lastX=aN.x;av.lastY=aN.y};var au=this.setCapture=function(aW,aY){var aX=ad(aW,aY);if(aX){ap.captureScrollUser=aW;ap.capturePinchUser=aY}return aX};var ad=function(aW,aY){var aX=0;if(aW){aX+=2}if(aY){aX+=4}if(aX==ap.nCheck){return}ap.nCheck=aX;ap.captureScroll=aW;ap.capturePinch=aY;if($FSI.BrowserSupports.cssTouchAction()){L(aW,aY)}return true};var L=function(aW,a0){var aZ;switch(ap.nCheck){case 0:aZ="auto";break;case 2:aZ="pinch-zoom double-tap-zoom ";break;case 4:aZ="pan-x pan-y double-tap-zoom";break;default:aZ="double-tap-zoom"}ap.cssTouchAction=aZ;for(var aY=0;aY<j.length;aY++){var aX=j[aY];m(aX,ap.cssTouchAction)}};var h=function(){if(an.length<1){return 0}var aX=Math.abs(an[1].x-an[0].x);var aW=Math.abs(an[1].y-an[0].y);var aY=ai.nPinchDistance=Math.sqrt(aX*aX+aW*aW);return aY};var ae=function(aW){s=false;if(!ag){return}var aX=an.length;if(!aK){s=(aX==1&&ap.captureScroll);return}if(ai.pointerCount!=aX){M(aW);if(aX>1){ac();ai.nPointers=aX;switch(aX){case 2:ai.started=true;ai.name="pinch";ai.nType=1;if(typeof(aR.onPinchStart)=="function"){I(aW);ai.nPinchDistance=0;ai.nPinchDistance=h();ai.pinchDistanceStart=ai.pinchDistanceLast=ai.nPinchDistance;ai.pinchDistanceStartMaxed=Math.max(ao,ai.pinchDistanceStart);aW._FSI_PinchDistance=ai.nPinchDistance;aR.onPinchStart.call(F,aW,aN,C)}break;default:ai.started=true;ai.name="unknown";ai.nType=-1}if(ai.started){v=true;if(l){aG();l=false;aW._FSI_Canceled=true;aL.call(F,aW,r,C)}if(typeof(aR.onGestureStart)=="function"){I(aW);aR.onGestureStart.call(F,aW,aN,C)}}}else{if(aX<1){ac()}}ai.pointerCount=aX;s=false;if(aX==1){if(ap.captureScroll){s=true}}else{if(ap.capturePinch&&ai.nType==1){s=true}}}return ai.started};var ac=function(){if(!ai.timeoutRestartDown){return}clearTimeout(ai.timeoutRestartDown);ai.timeoutRestartDown=undefined};var z=function(){if(Y!=1){return}d(T);ac()};var I=function(aW){aW._FSI_Gesture=ai.name;aW._FSI_GestureType=ai.nType;aW._FSI_PointerCount=ai.nPointers};var M=function(aW){if(!ai.started){return}ai.started=false;if(!aW){aW={}}if(ai.nType==1&&typeof(aR.onPinchEnd)=="function"){I(aW);aW._FSI_PinchDistance=ai.nPinchDistance;aR.onPinchEnd.call(F,aW,aN,C)}if(typeof(aR.onGestureEnd)=="function"){I(aW);aR.onGestureEnd.call(F,aW,aN,C)}ai.name="none";ai.nType=0;if(aW&&Y==1){ac();ai.timeoutRestartDown=setTimeout(z,20)}};ak()};$FSI.ImageFlow=function(b){var bH=new $FSI.ClassDef(this,"FSI ImageFlow","1.1.2","16.02.08");var aO=bH.instance;$FSI.guessFSIViewerLocation("fsiimageflow.js",3);if(!$FSI._FSIViewerLocation){$FSI.guessFSIViewerLocation("FSI.ImageFlow.js",3)}var bg=$FSI.getViewerInstanceID();var a9=(b)?$FSI.cloneParameters(b):{};a9.debug=true;var au;var p;var ao;var aC;var u;var ap;var bS=false;var bi;var v;var bT=[];var cs;var aP;var ba;var X=0;var bC={};var bz;var am,aY;var bP;var by;var aS={};var a6=false;var B;var bB;var V;var aJ;var bl;var bW;var aI;var b2;var a=4;var aL;var bR=false;var aU=false;var bL;var z;var aK;var K=false;var ci;var j;var be;var bO;var aT;var bm;var cm;var aG,aR,y;var O=0;var bY=0;var o;var b4;var ae;var bc;var bG;var aj;var bu;var bd,bF;var W=[];var ac={};var a5;var bf;var n={};var b3;var b6;var Q={};var aA={};var cj;var S={};var Z;var U;var cq;var a4;var aE=0;var bV;var ck;var bZ;var w;var bo={};var aW;var D;var a0=/((\?)|&)(width|height)=[^&]*/ig;var b0,aM,P,aV,aX;var aQ;var bU;var ct;var cg;var a7;var aq;var ar;var bA;var aN;var g;var b7={};var d=0;var ag=8;var e=[];var cc=true;var A=false;var cf=0;var bN={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",headers:"cors",scrollColor:"#999",placeHolderColor:"#EEEEEE",backgroundColor:"#FFF",zoomBorderStyle:"solid",zoomBorderColor:"#777",zoomBackgroundColor:"white",zoomFadeColor:"white",imageBorderColor:"none",callBackFocus:"",callBackClick:"",callBackZoomStart:"",callBackZoomEnd:"",callBackStart:"",presentationType:"carousel",elementWidth:"10%",elementSpacing:"0.25%"},booleans:{autoResize:true,enableZoom:true,enableScrollBar:true,transparency:false,centerZoomedImage:true,zoomCenteredImageOnly:false,positionQuantization:false,endlessScrolling:false,duplicateImagesIfNeeded:false},floats:{mirrorHeight:0.5,mirrorStartOpacity:0.5,backgroundDarkness:0.3,depthFadeout:0.2,curveHeight:0.35,autoRotateSpeed:0,scrollAlphaNormal:0.35,scrollAlphaActive:1},integers:{zIndexZoom:1000,preloadCount:20,paddingTop:10,paddingBottom:0,zoomFadeOpacity:80,zoomBorderWidth:4,scrollPadding:0,scrollHeight:16}};if($FSI.isMobileDevice){U=25}else{U=10}var p=new $FSI.EmptyDebugger();var az=function(cv,cu){if(cu&&!p.on&&cv.on){if(bB){bB.stopPendingRequests()}aO.destroy();aO.init(aC,a9,true);return true}p=cv;if(p.on){p.setPrefix(bH.strClassName+" ["+aC+"]")}};this.init=function(cv,cy,cu){if(!$FSI.BrowserSupports.canvas()){p.error("<canvas> element not supported.");return}if(!cv){return}if(typeof(cv)=="object"){if(typeof(cv.id)=="string"){aC=cv.id}}else{if(typeof(cv)=="string"){aC=cv}}if(!aC){aC="fsi.imageflow #"+bg}if(aO._fsi_parameters){cy=aO._fsi_parameters;delete aO._fsi_parameters}if(typeof(cv)=="object"&&cv.tagName!=undefined){element=cv}else{element=document.getElementById(cv)}if(typeof(cy)=="object"&&typeof(window[cy.oninit])=="function"){var cw=window[cy.oninit](aO,aC,cy)}if(!element){return}if(bS){aO.destroy()}element.setAttribute("x-fsi-id",aC);cf++;bi=element;element.innerHTML="";v=document.createElement("div");$FSI.setStyleAttr(v,"width:100%;height:100%;border:0px;none;margin:0px;padding:0px;overflow:hidden");bi.appendChild(v);a9=(cy)?$FSI.cloneParameters(cy):a9;var cz={};cz.onConfigsReady=aw;cz.onDebuggerChange=az;bB=new $FSI.Config(null,cz);var cx=a9;if(cu){cx=$FSI.cloneObject(a9);cx.debug=true}bB.init(cx);p.log(aO.getVersion());ap={};bB.loadConfigs();bS=true};this.getInitDone=function(){return bS};var bI=function(cv){var cu=cv.oCrop={};bt(cu,"rectLeft",cv.sourceWidth,0);bt(cu,"rectTop",cv.sourceHeight,0);bt(cu,"rectRight",cv.sourceWidth,1);bt(cu,"rectBottom",cv.sourceHeight,1);cu.rectWidth=1-cu.rectRight-cu.rectLeft;cu.rectHeight=1-cu.rectBottom-cu.rectTop;cu.bCrop=true;cu.query=cu.rectLeft+","+cu.rectTop+","+cu.rectWidth+","+cu.rectHeight};var bt=function(cz,cw,cx,cv){var cy=b7[cw];if(typeof(cy)!="string"){cz[cw]=cy;return}var cu=parseInt(cy);if(isNaN(cu)){cz[cw]=cv;return}cu=Math.max(0,Math.min(cx,cu));cz[cw]=cu/cx};var bD=function(cw,cv){cw=cw.toLowerCase();var cu=cv;if(cw.indexOf("px")!=-1){cu=parseInt(cw);if(isNaN(cu)||cu<=0){cu=cv}else{cu=""+cu+"live";b7.bLive=true}}else{if(cw.indexOf("%")!=-1){cu=Math.max(0,Math.min(100,parseFloat(cw)));cu/=100;if(isNaN(cu)||cu<0){cu=cv}}else{cu=Math.max(0,Math.min(1,parseFloat(cw)));if(isNaN(cu)||cu<0){cu=cv}}}return cu};var ad=function(){var cw=b7;cw.rectWidth=cw.rectHeight=1;cw.rectLeft=cw.rectTop=0;cw.bCrop=b7.bLive=false;cw.query="";if(ap.cropValues&&ap.cropValues.length>6){var cv=ap.cropValues.split(",");cw.rectLeft=bD(cv[0],0);cw.rectTop=bD(cv[1],0);cw.rectRight=bD(cv[2],0);cw.rectBottom=bD(cv[3],0);cw.rectWidth=1-cw.rectRight-cw.rectLeft;cw.rectHeight=1-cw.rectBottom-cw.rectTop;cw.bCrop=true;if(!cw.bLive){cw.query=cw.rectLeft+","+cw.rectTop+","+cw.rectWidth+","+cw.rectHeight}}else{if(ap.cropRect&&ap.cropRect.length>6){var cv=ap.cropRect.split(",");if(cv.length>3){while(cv.length>4){cv.pop()}for(var cu=0;cu<cv.length;cu++){cv[cu]=parseFloat(cv[cu])}var cx=cv[0]*cv[1]*cv[2]*cv[3];if(isNaN(cx)){return}cw.rectLeft=cv[0];cw.rectTop=cv[1];cw.rectRight=cv[0];cw.rectBottom=cv[1];cw.rectWidth=cv[2]-cv[0];cw.rectHeight=cv[3]-cv[1];cw.bCrop=true;cw.query=cw.rectLeft+","+cw.rectTop+","+cw.rectWidth+","+cw.rectHeight}}}};var bx=function(cw){var cv=ap[cw];var cu;if(typeof(cv)=="string"&&cv.length>0){try{cu=window[cv]}catch(cx){}}else{if(typeof(cv)!="function"){cu=undefined}cu=cv}return cu};var aw=function(){if(bB.cfg.viewerid){aO.assignFSIViewer(bB.cfg.viewerid)}var cv=bB.cfg.dir;if(!cv||cv.length==0){var cu=bB.getImageList();if(cu){ai(cu.arImages,cu)}}else{bB.loadImageList(bB.cfg.dir,ai)}};var ai=function(cu,cv){if(!bS){return}Z=0;if(!cu){cu=[]}bT=cu;p.log("Image list loaded ("+bT.length+" images)");C();h()};var C=function(){q(ap)};var a2=function(cv,cu,cy,cw){for(var cx in cy){cu[cx]=cv.getFloatParameter(cw+cx,cy[cx])}};var bp=function(cv,cu,cy,cw){for(var cx in cy){cu[cx]=cv.getIntParameter(cw+cx,cy[cx])}};var an=function(cw,cv,cu,cx){for(var cy in cu){cv[cy]=cw.getStringParameter(cx+cy,cu[cy])}};var ah=function(cv,cu,cx,cw){for(var cy in cx){cu[cy]=cv.makeBool(cv.getStringParameter(cw+cy),cx[cy])}};var r=function(cv,cu,cx,cw){var cy;if(cx&&cx.length>0){if(cu[cx]==undefined){cu[cx]={}}cw=cw[cx];cy=cu[cx]}else{cy=cu}if(cw.strings){an(cv,cy,cw.strings,cx)}if(cw.booleans){ah(cv,cy,cw.booleans,cx)}if(cw.floats){a2(cv,cy,cw.floats,cx)}if(cw.integers){bp(cv,cy,cw.integers,cx)}};var q=function(cu){if(cu==undefined){cu={}}cu.serverBase=bB.serverBase;r(bB,cu,"",bN);var cx=/[\dabcdef]{3,6}/i;for(var cy in bN.strings){if(cy.indexOf("Color")!=-1){var cw=ap[cy];if(cw.indexOf("#")!=0){var cv=cw.match(cx);if(cv){if(cv[0].length==cw.length&&(cv[0].length==3||cv[0].length==6)){ap[cy]="#"+cv[0]}}}}}};var h=function(){bL=ap.presentationType.toLowerCase();if($FSI.isMobileDevice){a=3}else{a=1}cg=ap.transparency;bR=ap.endlessScrolling;b0=bx("callBackFocus");aM=bx("callBackClick");P=bx("callBackZoomStart");aV=bx("callBackZoomEnd");aX=bx("callBackStart");ad();cj=bT.length;var cv=ap.placeHolderColor.toLowerCase();bU=(cv!="none"&&cv!="transparent");var cv=ap.imageBorderColor.toLowerCase();g=(cv!="none"&&cv!="false");if(ap.zoomCenteredImageOnly){bO=true}else{bO=ap.positionQuantization}var cv=bk();aG=y=aR=cv;aq=-ap.autoRotateSpeed;ci="rgba(0,255,0,";var cv=ap.backgroundColor.toLowerCase();if(cv=="false"||cv=="transparent"||cv=="none"){ap.backgroundColor=false;aL=bs;v.style.backgroundColor="transparent"}else{if(!cg&&ap.backgroundDarkness==0){aL=J}else{aL=bs}var cv=ap.backgroundColor;if(cv.indexOf("#")==0){cv=cv.substr(1)}if(cv.length==3){cv=cv.charAt(0)+cv.charAt(0)+cv.charAt(1)+cv.charAt(1)+cv.charAt(2)+cv.charAt(2)}var cx=parseInt("0x"+cv.substr(0,2));if(isNaN(cx)){cx=0}var cw=parseInt("0x"+cv.substr(2,2));if(isNaN(cw)){cw=0}var cu=parseInt("0x"+cv.substr(4,2));if(isNaN(cu)){cu=0}ci="rgba("+cx+","+cw+","+cu+",";v.style.backgroundColor=ap.backgroundColor}ct=(aL==bs);al();cs=$FSI.cloneArray(bT);aP={};if(ap.autoResize==true){if(be==undefined){be=$FSI.addCustomEvent(bi,"FSIElementDimension",b9);$FSI.setCustomEventListenerProperty(be,"treshold",200)}}else{if(be!=undefined){$FSI.removeCustomEvent(bi,"FSIElementDimension",b9);be=undefined}}bJ();a3()};var bv=function(cw){var cv,cu;if(typeof(cw)=="string"){cu=cw.indexOf("%");cv=parseFloat(cw)}else{cu=-1;cv=cw}if(cu!=-1){cv=Math.round(aG.width*cv/100)}return{val:cv,bRelative:(cu!=-1)}};var al=function(){var cu;cu=bv(ap.elementWidth);if(isNaN(cu.val)){cu=bv(bN.strings.elementWidth)}aT=bC.width=Math.max(1,cu.val);bC.widthRelative=cu.bRelative;cu=bv(ap.elementSpacing);if(isNaN(cu.val)){cu=bv(bN.strings.elementSpacing)}bm=bC.spacing=cu.val;bC.spacingRelative=cu.bRelative};var bJ=function(){a6=false;l();if(cs.length<1){return}bz=0;ba={};X=0;cf++;if(bT.length!=cs.length){bT=$FSI.cloneArray(cs)}cj=bT.length;a4=!ap.enableScrollBar;b4=aT+bm;aG=aR;bd=aG.width/2;var cz=0;aU=false;switch(bL){case"stacks":cz=2;A=false;cc=false;break;case"flat":aU=!bR;ap.zoomCenteredImageOnly=false;cz=1;if(!bR){bd=0}else{bd-=b4/2}cc=false;A=true;break;default:cz=2;bL="carousel";A=false;cc=true;break}if(bL=="stacks"){bF=aG.width/2-aT/2}else{bF=aG.width/2-aT/4}E();var cx=b3;if(bR){var cA=false;O=0;if(cj==1){cA=true;bT.push(bT[0]);cj++}aF();s();if(cA){bT.pop();cj=1}if(W.length+cz>cj){if(!ap.duplicateImagesIfNeeded){bR=false}else{var cw=(W.length+cz-cj);for(var cv=0;cv<cw;cv++){bT.push(bT[cv%cj])}cj=bT.length}}}aF();E();if(b3<=0){a4=true}b6={height:ap.scrollHeight,padding:ap.scrollPadding,alphaNormal:ap.scrollAlphaNormal,alphaActive:ap.scrollAlphaActive};b6.height=Math.max(3,b6.height);b6.padding=Math.max(0,b6.padding);b6.alpha=b6.alphaTarget=b6.alphaNormal;b6.width=Math.round(aG.width-2*b6.padding);b6.y=Math.round(aG.height-b6.height-b6.padding);if(!a4){var cu=Math.max(0,cx);b6.buttonWidth=Math.round(Math.max(20,b6.width*Math.min(1,aG.width/(aG.width+cu))))}else{b6.buttonWidth=20}b6.range=b6.width-b6.buttonWidth;if(!a4){a4=(b6.buttonWidth>=b6.width)}cq=(cj<2);if(!a4){a4=cq}if(!bR&&bL=="flat"&&cj*b4<aG.width){bd=(aG.width-cj*b4)/2}var cB=ap.paddingBottom;if(!a4){cB=Math.max(b6.height,cB)}bA=aG.height-ap.paddingTop-cB;ae=0;ap.mirrorHeight=Math.max(0,Math.min(1,ap.mirrorHeight));if(ap.mirrorHeight>0){ae=Math.round(ap.mirrorHeight*bA/2);bc=(ae>0)}else{bc=false}bA-=ae;if(cc){aN=Math.round(ap.curveHeight*bA)}else{aN=0}aB();if(j!=undefined){var cy=j.offsetLeft/j.xAdvance;O=cy*b4;j=undefined}if(bO){O=Math.round(O/b4)*b4}O=ab(O);a6=true;if(bA<1){p.error("Insufficient instance height. Resulting image height is "+bA+"px");return}bz=bT.length;am=aZ;aY=k;at();if(ap.preloadCount>0){R()}if(aq!=0){aa()}};var aF=function(){if(cj<2){bP=m}else{if(aU){bP=f}else{bP=cn}}};var a3=function(){if(aX){aX(aO,aC,ap.dir,bT.length)}G(0);cd()};var E=function(){b3=cj*b4;if(!bR){if(bL=="flat"){b3-=aG.width}else{b3-=b4}}};var aB=function(){if(!aG||aG.width<1||aG.height<1){return false}if(!B){B=document.createElement("canvas");B.setAttribute("draggable","false");B.style.width=B.style.height="100%";if($FSI.isIETouch){B.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}B.setAttribute("width",aG.width);B.setAttribute("height",aG.height);cm=B.getContext("2d");v.appendChild(B)}else{B.setAttribute("width",aG.width);B.setAttribute("height",aG.height)}if(bc&&!V){V=document.createElement("canvas");aJ=V.getContext("2d");aI=V.cloneNode();b2=aI.getContext("2d");bl=V.cloneNode();bW=bl.getContext("2d")}if(bc){var cu=Math.ceil(aT);var cx=Math.ceil((bA+1));V.setAttribute("width",cu);V.setAttribute("height",cx);aI.setAttribute("width",cu);aI.setAttribute("height",cx);bl.setAttribute("width",cu);bl.setAttribute("height",cx);bG=aJ.createLinearGradient(0,0,0,ae);if(ct){bG.addColorStop(0,ci+ap.mirrorStartOpacity+")");bG.addColorStop(1,ci+"0)")}else{bG.addColorStop(0,ci+(1-ap.mirrorStartOpacity)+")");bG.addColorStop(1,ci+"1)")}aJ.strokeStyle=ap.imageBorderColor;aJ.fillStyle=bG;aJ.lineWidth=0;bW.strokeStyle=ap.imageBorderColor}if(ap.backgroundDarkness>0){aj=cm.createLinearGradient(0,0,aG.width,0);var cv="rgba(0,0,0,";aj.addColorStop(0,cv+ap.backgroundDarkness+")");aj.addColorStop(0.4,cv+"0)");aj.addColorStop(0.6,cv+"0)");aj.addColorStop(1,cv+ap.backgroundDarkness+")");bu=true}else{bu=false}if(!au){var cy={};cy.detectClick=true;cy.afterTouch={enabled:true};cy.afterTouch.modifyTarget=bw;cy.afterTouch.factorAmount=23;cy.afterTouch.factorFrames=3.7;cy.afterTouch.minFrames=5;cy.afterTouch.offsetFrames=3;cy.detectGestures=true;au=new $FSI.TouchHandler(B,cy,bE,bM,bb);au.setCapture(true,false)}};var bw=function(cx,cu){if(bO){var cw=Q.offsetLeft-Q.x-Q.startX;var cv=Math.round((cx.x+cw)/b4)*b4;cx.x=cv-cw}return cx};var b1=function(){var cu=$FSI.getElementClientPos(B);Q.x=cu.left;Q.y=cu.top};var bE=function(cu,cx,cw){b1();aA.x=cx.x-Q.x;aA.y=cx.y-Q.y;bQ(b6.alphaActive);ax();aq=0;cancelAnimationFrame(bf);bf=undefined;O=ab(O);if(N(aA.x,aA.y)){au.enableAfterTouch(false);Q.scrollOffsetX=0;bQ(b6.alphaActive);b6.bDragging=true;bM(cu,cx,cw);af();var cv=b6.padding+b6.x+b6.buttonWidth/2;Q.scrollOffsetX=(cv-aA.x)}else{au.enableAfterTouch(true);b6.bImageDragging=true;Q.startX=aA.x;Q.startY=aA.y;Q.offsetLeft=O}at();return true};var bM=function(cv,cy,cw){aA.x=cy.x-Q.x;aA.y=cy.y-Q.y;if(b6.bDragging){var cu=aA.x+Q.scrollOffsetX-b6.padding-b6.buttonWidth/2;cu=Math.max(0,Math.min(b3-1,Math.round(cu*b3/b6.range)));O=ab(Math.min(0,Math.max(-cu,-b3)));at()}else{if(b6.bImageDragging){Q.dx=aA.x-Q.startX;Q.dy=aA.y-Q.startY;var cx=O;O=ab(Q.offsetLeft+Q.dx);at();if(cx==O||Math.abs(Q.dy)>3*Math.abs(Q.dx)){cv.FSI_allowEventDefault=true}}}};var bb=function(cD,cy,cE){var cB=cD._FSI_Click;aA.x=cy.x-Q.x;aA.y=cy.y-Q.y;bQ(b6.alphaNormal);if(b6.bDragging){bQ(b6.alphaNormal);b6.bDragging=false;if(bO){var cF=Math.round(O/b4)*b4;var cv=Math.round(-ab(cF)/b4);G(cv);br(cF,true,55)}}else{if(b6.bImageDragging){b6.bImageDragging=false;if(cB){var cA=aA.x;var cz=aA.y;var cu;var cC=0;var cw=W[W.length-1];for(var cx=0;cx<W.length;cx++){var cw=W[cx];if(cA>=cw.x&&cz>=cw.y&&cA<=cw.x+cw.drawWidth&&cz<=cw.y+cw.drawHeight){cC=1;if(aM){aM(aO,aC,cw.nIndex,bT[cw.nIndex])}if(!ap.zoomCenteredImageOnly||aE==cw.nIndex){if(ap.enableZoom){cb(cw)}}if(ap.centerZoomedImage){ch(cw)}break}}}else{cl()}}}at()};var cl=function(){if(bO){var cu=Math.round(O/b4)*b4;if(Math.abs(cu-O)>0.5){var cv=Math.round(-ab(cu)/b4);G(cv);br(cu,true,30)}}};var G=function(cu){aE=cu;aQ=undefined;if(b0){var cv=aP[cu];if(cv){b0(aO,aC,cv.nIndex,bT[cv.nIndex])}}};this.assignFSIViewer=function(cu){if(cu&&typeof(cu)=="string"){if(cu.toLowerCase()=="auto"){var cv=document.getElementsByTagName("fsi-viewer");if(cv&&cv.length>0){cu=cv[0]}else{cu=undefined}}else{cu=document.getElementById(cu)}}if(!cu||typeof(cu.changeImage)!="function"){z=undefined}else{z=cu}aK=false;cd()};var cd=function(){if(!bS||!z||aK||bT.length<1){return}aK=true;var cu={};cu.path=bT[0];L(cu)};var L=function(cu){if(!cu||!z||typeof(z.changeImage)!="function"){return}var cv={};cv.fpxsrc=cu.path;cv.imageWidth=cu.sourceWidth;cv.imageHeight=cu.sourceHeight;cv.cropRect=bB.cfg.croprect;cv.cropValues=bB.cfg.cropvalues;cv.effects=bB.cfg.effects;z.changeImage(cv)};var cb=function(cA){if(z!=undefined){L(cA);return}I(undefined,true);if(!cA.bReady){return}bV=document.createElement("div");ck=document.createElement("div");w=document.createElement("img");bo.alphaShader=0;var cQ=$FSI.getDocumentScale();var cR=ap.zoomBorderWidth/cQ;var cI=ap.zIndexZoom;var cJ="position:absolute;z-index:"+(cI+1)+";border:"+cR+"px "+ap.zoomBorderStyle+" "+ap.zoomBorderColor+";line-height:0px;box-sizing: content-box;";var cF=ap.zoomBackgroundColor.toLowerCase();if(cF!="none"&&cF!="transparent"){cJ+="background-color:"+ap.zoomBackgroundColor}bV.setAttribute("style",cJ);var cy="position:absolute;z-index:"+cI+";background-color:"+ap.zoomFadeColor+";opacity:0.0;filter:Alpha(opacity=0);";bZ=cA.img.cloneNode();bZ.style.width=bZ.style.height="100%";bV.appendChild(bZ);var cz=$FSI.getElementClientPos(B);var cw=$FSI.getElementClientPos(document.body);var cH=-cw.left;var cG=-cw.top;bo.startX=cH+cz.left+cA.x-cR;bo.startY=cG+cz.top+cA.y-cR;bo.startWidth=cA.width;bo.startHeight=cA.height;bV.style.width=bo.startWidth+"px";bV.style.height=bo.startHeight+"px";bV.style.left=bo.startX+"px";bV.style.top=bo.startY+"px";var cP=$FSI.getViewportSize(window);if($FSI.getDevicePixelRatio()!=1){cP.width-=1;cP.height-=1}$FSI.addEvent(ck,"mousedown",I,false);$FSI.addEvent(window,"touchstart",I,false);$FSI.addEvent(bV,"mousedown",I,false);$FSI.addEvent(window,"scroll",I,false);var cN=Math.ceil(40/cQ);var cv=cP.width-cN-2*cR;var cO=cP.height-cN-2*cR;var cC=cA.maxWidth;var cL=cA.maxHeight;if(cv/cC<cO/cL){cC=cv;cL=Math.round(cC*cA.maxHeight/cA.maxWidth)}else{cL=cO;cC=Math.round(cL*cA.maxWidth/cA.maxHeight)}if(cC>cA.maxWidth||cL>cA.maxHeight){cC=cA.maxWidth;cL=cA.maxHeight}bo.endWidth=cC;bo.enddHeight=cL;bo.dWidth=cC-bo.startWidth;bo.dHeight=cL-bo.startHeight;bo.endX=window.pageXOffset+Math.round((cP.width-cC)/2);bo.endY=window.pageYOffset+Math.round((cP.height-cL)/2);bo.dx=bo.endX-bo.startX;bo.dy=bo.endY-bo.startY;cy+="left:"+window.pageXOffset+"px;top:"+window.pageYOffset+"px;width:"+(cP.width)+"px;height:"+cP.height+"px";bo.bImageReady=false;var cx=cA.img.src;cx=cx.replace(a0,"$1");var cu=Math.min(cA.maxWidth,Math.round(cQ*cC));var cK=Math.min(cA.maxHeight,Math.round(cQ*cL));cx+="&width="+cu+"&height="+cK;ar=true;$FSI.addEvent(w,"load",ce,false);w.style.width=bo.endWidth+"px";w.style.height=bo.endHeight+"px";w.src=cx;bo.pos=0;var cD=bo.startX-bo.endX;var cB=bo.startY-bo.endY;var cE=bo.startWidth-bo.endWidth;var cM=bo.startHeight-bo.endHeight;bo.frames=ca(20);ck.setAttribute("style",cy);document.body.appendChild(ck);document.body.appendChild(bV);bo.alphaShader=0;cancelAnimationFrame(aW);aW=requestAnimationFrame(av);bo.posFader=0;bo.framesShader=10;bo.startAlpha=bo.alphaShader;bo.endAlpha=ap.zoomFadeOpacity;bo.dAlpha=bo.endAlpha-bo.startAlpha;D=requestAnimationFrame(t);if(P){P(aO,aC,cA.nIndex,cx)}if(!$FSI.isMobileDevice){$FSI.addEvent(window,"resize",I,false)}else{$FSI.addEvent(window,"orientationchange",I,false)}};var cp=$FSI.Easing.easeOutCubic;var av=function(){bo.pos++;if(bo.pos>bo.frames){aW=undefined;requestAnimationFrame(cr);return}var cu=cp(bo.pos,bo.frames,bo.startX,bo.dx);var cx=cp(bo.pos,bo.frames,bo.startY,bo.dy);var cv=cp(bo.pos,bo.frames,bo.startWidth,bo.dWidth);var cw=cp(bo.pos,bo.frames,bo.startHeight,bo.dHeight);bV.style.left=cu+"px";bV.style.top=cx+"px";bV.style.width=cv+"px";bV.style.height=cw+"px";aW=requestAnimationFrame(av)};var cr=function(){if(!bV||!bo.bImageReady||aW!=undefined){return}bV.firstChild.style.width=w.style.width;bV.firstChild.style.height=w.style.height;bV.firstChild.src=w.src;delete w;w=undefined;bV.style.width="";bV.style.height=""};var ce=function(cu){bo.bImageReady=true;$FSI.removeEvent(w,"load",ce,false);ar=false;cr()};var I=this.closeZoom=function(cu,cv){if(!bV){return}aQ=undefined;if(!$FSI.isMobileDevice){$FSI.removeEvent(window,"resize",I,false)}else{$FSI.removeEvent(window,"orientationchange",I,false)}if(D){cancelAnimationFrame(D);D=undefined}cancelAnimationFrame(aW);aW=undefined;$FSI.removeEvent(ck,"mousedown",I,false);$FSI.removeEvent(bV,"mousedown",I,false);$FSI.removeEvent(window,"touchstart",I,false);$FSI.removeEvent(window,"scroll",I,false);if(ar){$FSI.removeEvent(w,"load",ce,false)}if(w){delete w;w=undefined}$FSI.removeChild(bV.parentNode,bV);delete bV;bV=undefined;if(cv===true){$FSI.removeChild(ck.parentNode,ck);ck=undefined}else{bo.posFader=0;bo.framesShader=10;bo.startAlpha=bo.alphaShader;bo.endAlpha=0;bo.dAlpha=bo.endAlpha-bo.startAlpha;D=requestAnimationFrame(t)}if(aV){aV(aO,aC)}if(cu&&cu.touches&&cu.touches.length==1){cu.cancelBubble=true;if(cu.stopPropagation){cu.stopPropagation()}if(cu.preventDefault){cu.preventDefault()}}};var T=function(cu){bo.alphaShader=cu;ck.style.opacity=cu/100;ck.style.filter="Alpha(opacity="+cu+")"};var t=function(){bo.posFader++;if(bo.posFader>bo.framesShader){if(bo.endAlpha==0){$FSI.removeChild(ck.parentNode,ck);ck=undefined}D=undefined;return}var cu=cp(bo.posFader,bo.framesShader,bo.startAlpha,bo.dAlpha,3);T(cu);D=requestAnimationFrame(t)};var N=function(cu,cv){return(!a4&&cu>=b6.padding&&cv>=b6.y&&cu<=b6.padding+b6.width&&cv<=b6.y+b6.height)};this.focusImage=function(cu){if(cu<0||cu>=bT){return false}var cv=b8(cu);ch(cv);return true};this.zoomImage=function(cu){if(!ap.enableZoom||!this.focusImage(cu)){return false}var cv=b8(cu);aQ=cv.nIndex;ay()};var ch=function(cv,cu){if(!cv){return false}G(cv.nIndex);return br(-cv.nIndex*b4,cu,30)};var ab=function(cu){if(bR){cu=Math.round(cu)%b3;if(cu>0){cu-=b3}}else{cu=Math.min(0,Math.max(-b3,cu))}return cu};var ca=function(cu){if($FSI.isMobileDevice){cu=Math.ceil(cu/1.8)}return cu};var br=function(cx,cu,cw){cw=ca(cw);ax();if(cw==undefined){cw=40}if(!cu&&bR){cx=ab(cx);O=ab(O);var cv=cx-O;if(Math.abs(cv)>b3/2){if(cv>0){cx=-b3+cx}else{cx=b3+cx}}}if(cx==O||(bf!=undefined&&cx==n.end)){return false}cancelAnimationFrame(bf);bf=undefined;n.frames=cw;n.pos=0;n.start=O;n.end=cx;n.diff=n.end-n.start;bf=requestAnimationFrame(bK);return true};var bK=function(){n.pos++;if(n.pos==n.frames){O=ab(n.end);bf=undefined;bn();ay();return}O=cp(n.pos,n.frames,n.start,n.diff,3);if(!bR){O=ab(O)}bn();ay();bf=requestAnimationFrame(bK)};var co=function(cv,cx,cy){if(!bS){return}if(!cx||!cy||cy.nInitID!=cf){return}d--;var cu,cw;cu=parseInt(cx.width);cw=parseInt(cx.height);if(isNaN(cu)&&isNaN(cw)){p.error("Failed to get image info.")}cy.nThumbnailDimWidth=aT;cy.nThumbnailDimHeight=bA;cy.bInfoReady=true;cy.bDrawPlaceHolder=bU;cy.sourceWidth=cu;cy.sourceHeight=cw;if(b7.bLive){bI(cy)}if(b7.bCrop){cy.objCropCurrent=(cy.oCrop)?cy.oCrop:b7;cy.maxWidth=Math.round(cy.objCropCurrent.rectWidth*cu);cy.maxHeight=Math.round(cy.objCropCurrent.rectHeight*cw)}else{cy.maxWidth=cu;cy.maxHeight=cw}aH(cy)};var aH=function(cv){var cB,cx;if(!cv.bInfoReady){return false}cv.nThumbnailDimWidth=aT;cv.nThumbnailDimHeight=bA;if(!cv.bThumbLoading){d++}cv.bThumbLoading=true;cv.bThumbLoadStarted=true;var cy=aT;var cA=bA;if(cy/cv.maxWidth<cA/cv.maxHeight){cB=cy;cx=Math.round(cB*cv.maxHeight/cv.maxWidth)}else{cx=cA;cB=Math.round(cx*cv.maxWidth/cv.maxHeight)}var cz=true;if(cB<1||cx<1){cB=cx=0;cz=false}cv.width=cB;cv.height=cx;cv.offsetX=(cy-cB)/2;cv.offsetY=cA-cx-aN+ap.paddingTop;var cC={width:cB,headers:"cors"};if(cv.objCropCurrent){cC.rect=cv.objCropCurrent.query}if(ap.effects.length>0){cC.effects=ap.effects}if(ap.overlays.length>0){cC.overlays=ap.overlays}if(ap.quality.length>0){cC.quality=ap.quality}if(ap.fpxservertemplate.length>0){cC.renderer=ap.fpxservertemplate}var cu=bB.getImageURL(cv.path,cC);var cw;if(cv.img==undefined){cw=cv.img=document.createElement("img");cw.oSprite=cv;cw.crossOrigin=""}else{cw=cv.img}cv.nInitID=cf;if(!cv.bHasEvents){aS[cv.nIndex]=cv;cv.bHasEvents=true;$FSI.addEvent(cw,"load",H,false);$FSI.addEvent(cw,"error",M,false)}if(cv.bDrawPlaceHolder){if(cv.myX!=undefined){b5(cv)}if(bh(cv)){at()}}if(!cz){M.call(cw)}else{cv.src=cw.src=cu}return true};var bq=function(cu){if(cu.nThumbnailDimWidth!=aT||cu.nThumbnailDimHeight!=bA){return false}return true};var ak=function(cu){if(!cu||cu.nInitID!=cf){return false}return true};var a8=function(cu){if(cu.bHasEvents){delete aS[cu.nIndex];$FSI.removeEvent(cu.img,"load",H,false);$FSI.removeEvent(cu.img,"error",M,false);cu.bHasEvents=false}};var M=function(cu){var cv=this.oSprite;if(!cv){return}cv.bReady=false;cv.bDrawPlaceHolder=false;cv.bLoadComplete=true;cv.bThumbLoading=false;a8(cv);if(ak(cv)){d--}aY()};var H=function(cu){var cv=this.oSprite;if(!cv){return}a8(cv);if(!bS){return}cv.bReady=true;cv.bLoadComplete=true;cv.bThumbLoading=false;cv.bDrawPlaceHolder=false;if(!ak(cv)){return}d--;if(!bq(cv)){return}F(cv);if(bh(cv)&&cv.myX!=undefined){b5(cv);at()}ay();aY()};var ay=function(){if(aQ==undefined){return}var cu=b8(aQ);if(!cu.bReady||!bh(cu)){return}cb(cu);aQ=undefined};var b8=function(cw,cz,cu){var cx;cw%=cj;if(cw<0){cw+=cj}if(ba[cw]!=undefined){return ba[cw]}var cy=aP[cw];if(cy==undefined){Z++;cy=aP[cw]={};cy.nIndex=cw;var cv=bA;cy.width=aT;cy.height=cv;cy.offsetX=0;cy.offsetY=cv-cy.height-aN+ap.paddingTop;cy.path=bT[cw];cx=true}else{if(cy.bThumbLoadStarted&&(cy.nThumbnailDimWidth!=aT||cy.nThumbnailDimHeight!=bA)){if(cy.bReady){cy.bReady=false;cy.oMirrorData=null;cy.bDrawPlaceHolder=false}cx=true}else{if(!cy.bLoadStarted){cx=true}}}if(cx){cy.bPreload=cz;e.push(cy);if(!cu){am()}}return cy};var i=function(){};var l=function(){am=aY=i;if(by){clearTimeout(by);by=undefined}};var aZ=function(){if(!by){by=setTimeout(k,50)}};var k=function(){if(by){clearTimeout(by);by=undefined}while(e.length>0&&d<ag){var cv=e.shift();if(ba[cv.nIndex]==undefined&&(cv.bPreload||bh(cv))){ba[cv.nIndex]=cv;X++;if(X==cj){l()}bz--;cv.bLoadStarted=true;cv.nInitID=cf;if(!cv.bInfoLoading){d++;cv.bInfoLoading=true;var cu=bB.getImageInfoURL(cv.path);bB.loadFile(cu,co,undefined,cv)}else{aH(cv)}}}};var a1=function(cw,cu){if(!bR&&(cw<0||cw>=cj)){return 0}var cx=b8(cw,false,true);cx.nImage=cw;cx.myX=cu;var cv=b5(cx);if(cv){W.push(cx)}return cv};var b5=function(cy){var cw,cx;if(A){var cv=bd+cy.myX;cx=(cv+b4>=0&&cv<=aG.width)?1:0;cy.z=1}else{cw=cy.myX/bF;cx=Math.cos(cw/1.3);if(cc){cy.z=cx}else{cy.z=1}}if(cx<ap.depthFadeout){ac[cy.nIndex]=false;return 0}cy.drawWidth=cy.z*cy.width;cy.drawHeight=cy.z*cy.height;ac[cy.nIndex]=true;if(A){cy.x=bd+cy.myX+Math.round((b4-cy.width)/2)}else{var cu=bF*Math.sin(cw);cy.x=bd+cu-cy.drawWidth/2}if(cc){cy.y=aN*cy.z+cy.offsetY+(cy.height-cy.drawHeight)}else{cy.y=cy.offsetY+(cy.height-cy.drawHeight)}return 1};var bh=function(cu){if(!cu){return false}return ac[cu.nIndex]};var s=function(){if(e.length>0){e=[]}W=[];ac={};var cx;var cv;if(A){cv=ab(O)}else{cv=O}if(cv>0){cx=Math.ceil(-cv/b4)}else{cx=Math.floor(-cv/b4)}var cu=cv%b4;a1(cx,cu);var cw=bP(cx,cu);if(S.interval!=undefined&&bf==undefined){S.nLastLeftImage=cx-cw+1;S.nLastRightImage=cx+cw-1;S.nLoad=ap.preloadCount}};var m=function(){return 0};var cn=function(cx,cu){var cy;var cw=0;var cv=0;do{cw+=b4;cv++;cy=a1(cx-cv,cu-cw);cy+=a1(cx+cv,cu+cw)}while(cy>0&&cv<cj);return cv};var f=function(cx,cu){var cy;var cw=0;var cv=0;do{cw+=b4;cv++;cy=a1(cx+cv,cu+cw)}while(cy>0&&cv<cj);return cv};var R=function(){if(S.interval!=undefined){return}S.interval=setInterval(aD,100)};var bX=function(){clearInterval(S.interval);S.interval=undefined};var aD=function(){if(e.length>0||S.nLoad<=0){return}if(bz<1){bX();return}while(e.length<2&&S.nLoad>0){if(!aU){b8(--S.nLastLeftImage,true,true);S.nLoad--}b8(++S.nLastRightImage,true,true);S.nLoad--}aY()};var at=function(){if(o!=undefined){return}o=requestAnimationFrame(bn)};var bn=function(){if(o!=undefined){cancelAnimationFrame(o);o=undefined}if(K){return}s();aL();am()};var bs=function(){if(!bS){return}cm.globalCompositeOperation="source-over";cm.globalAlpha=1;cm.clearRect(0,0,aG.width,aG.height);cm.strokeStyle=ap.imageBorderColor;cm.lineWidth=0;for(var cw=W.length-1;cw>-1;cw--){var cx=W[cw];if(cx.bReady){cm.drawImage(cx.img,cx.x,cx.y,cx.drawWidth,cx.drawHeight);if(g){cm.strokeRect(cx.x+0.5,cx.y+0.5,cx.drawWidth-1,cx.drawHeight-1)}}else{if(cx.bDrawPlaceHolder){cm.fillStyle=ap.placeHolderColor;cm.fillRect(cx.x,cx.y,cx.drawWidth,cx.drawHeight);if(g){cm.strokeRect(cx.x+0.5,cx.y+0.5,cx.drawWidth-1,cx.drawHeight-1)}}}if(cx.oMirrorData){var cv=cx.y+cx.drawHeight;var cy=Math.abs(cx.z)*cx.nMirrorWidthOut;var cu=Math.abs(cx.z)*cx.nMirrorHeightOut;if(!cg){cm.clearRect(cx.x,cv,cy,cu)}if(cx.bCorsFix){cm.drawImage(cx.mirrorCanvas,0,0,cx.nMirrorWidth,cx.nMirrorHeight,cx.x,cv,cy,cu)}else{b2.clearRect(0,0,cx.nMirrorWidth,cx.nMirrorHeight);b2.putImageData(cx.oMirrorData,0,0);cm.drawImage(aI,0,0,cx.nMirrorWidth,cx.nMirrorHeight,cx.x,cv,cy,cu)}}}if(bu){cm.globalCompositeOperation="source-atop";cm.fillStyle=aj;cm.fillRect(0,0,aG.width,aG.height)}c()};var J=function(){if(!bS){return}cm.globalCompositeOperation="source-over";cm.globalAlpha=1;cm.clearRect(0,0,aG.width,aG.height);cm.strokeStyle=ap.imageBorderColor;cm.lineWidth=0;for(var cw=W.length-1;cw>-1;cw--){var cx=W[cw];if(cx.bReady){cm.drawImage(cx.img,cx.x,cx.y,cx.drawWidth,cx.drawHeight);if(g){cm.strokeRect(cx.x+0.5,cx.y+0.5,cx.drawWidth-1,cx.drawHeight-1)}}else{if(cx.bDrawPlaceHolder){cm.fillStyle=ap.placeHolderColor;cm.fillRect(cx.x,cx.y,cx.drawWidth,cx.drawHeight);if(g){cm.strokeRect(cx.x+0.5,cx.y+0.5,cx.drawWidth-1,cx.drawHeight-1)}}}}if(bu){cm.globalCompositeOperation="source-atop";cm.fillStyle=aj;cm.fillRect(0,0,aG.width,aG.height)}cm.globalCompositeOperation="destination-over";for(var cw=0;cw<W.length;cw++){var cx=W[cw];if(cx.oMirrorData){var cv=cx.y+cx.drawHeight;var cy=Math.abs(cx.z)*cx.nMirrorWidthOut;var cu=Math.abs(cx.z)*cx.nMirrorHeightOut;if(cx.bCorsFix){cm.drawImage(cx.mirrorCanvas,0,0,cx.nMirrorWidth,cx.nMirrorHeight,cx.x,cv,cy,cu)}else{b2.clearRect(0,0,cx.nMirrorWidth,cx.nMirrorHeight);b2.putImageData(cx.oMirrorData,0,0);cm.drawImage(aI,0,0,cx.nMirrorWidth,cx.nMirrorHeight,cx.x,cv,cy,cu)}}}c()};var bQ=function(cu){if(a4||b6.alphaTarget==cu){return}b6.alphaTarget=cu;at()};var af=function(){var cu=ab(O);b6.x=Math.min(b6.range,-cu/b3*b6.range)};var c=function(){if(a4){return}af();cm.globalCompositeOperation="source-over";if(b6.alpha!=b6.alphaTarget){if(Math.abs(b6.alpha-b6.alphaTarget)>0.01){b6.alpha+=(b6.alphaTarget-b6.alpha)/10;at()}else{b6.alpha=b6.alphaTarget}}cm.globalAlpha=b6.alpha;cm.fillStyle=ap.scrollColor;var cy=b6.y;var cw=cy+b6.height-1;var cx=cw-cy-1;cm.fillRect(b6.padding,cy,b6.width,1);cm.fillRect(b6.padding,cw,b6.width,1);cy++;cm.fillRect(b6.padding,cy,1,cx);cm.fillRect(b6.width-1,cy,1,cx);var cu=Math.max(1,Math.round(b6.x));var cv=Math.min(b6.buttonWidth,b6.width-1-cu);cm.fillRect(b6.padding+cu,b6.y+1,cv,b6.height-2)};var F=function(cy){if(!bc||!bS){return}var cw=a;cw=Math.min(cw,Math.min(cy.img.width/20,cy.img.height/20));var cu=Math.min(V.width,cy.img.width/cw);var cv=Math.min(V.height,cy.img.height/cw);var cA=Math.min(ae/cw,Math.floor(cv*ap.mirrorHeight));var cz=cv-cA;aJ.save();aJ.globalCompositeOperation="source-over";if(!ct){aJ.clearRect(0,0,cu,cA);aJ.scale(1,-1);aJ.drawImage(cy.img,0,cz*cw,cu*cw,cA*cw,0,-cA,cu,cA);aJ.restore();aJ.save();if(g){aJ.strokeRect(0,0,cu,cv)}aJ.scale(1,cA/ae);aJ.fillRect(0,0,cu+1,ae+1)}else{aJ.clearRect(0,0,cu,cA);aJ.scale(1,cA/ae);aJ.fillRect(0,0,cu+1,ae+1);aJ.restore();aJ.save();aJ.globalCompositeOperation="source-in";aJ.scale(1,-1);if(g){bW.clearRect(0,0,cu,cA);bW.drawImage(cy.img,0,cz*cw,cu*cw,cA*cw,0,0,cu,cA);bW.strokeRect(0,0,cu,cy.height);aJ.drawImage(bl,0,0,cu,cA,0,-cA,cu,cA)}else{aJ.drawImage(cy.img,0,cz*cw,cu*cw,cA*cw,0,-cA,cu,cA)}}aJ.restore();try{cy.oMirrorData=aJ.getImageData(0,0,cu,cA)}catch(cx){cy.mirrorCanvas=V.cloneNode();cy.oMirrorData=cy.mirrorCanvas.getContext("2d");cy.oMirrorData.drawImage(V,0,0);cy.bCorsFix=true}cy.nMirrorWidth=cu;cy.nMirrorHeight=cA;cy.nMirrorWidthOut=cu*cw;cy.nMirrorHeightOut=cA*cw};var aa=function(){if(a7!=undefined){return}a7=requestAnimationFrame(Y)};var Y=function(){O=ab(O+aq);at();a7=requestAnimationFrame(Y)};var ax=function(){if(a7==undefined){return}cancelAnimationFrame(a7);a7=undefined};var bk=function(){var cu=$FSI.getElementDimension(v);if(cu.width<1){cu.width=1}if(cu.height<1){cu.height=1}return cu};var bj=function(){aG=aR=bk()};var b9=function(cu){if(!a6||cs.length<1){return}if(j==undefined){j={};j.offsetLeft=O;j.xAdvance=b4;j.nCenter=bd}if(cu.FSI_after_treshold!=undefined){ax();cancelAnimationFrame(bf);K=false;au.enable(true);l();bX();e=[];bj();if(aG.width>1&&aG.height>1){if(B){B.style.display="block"}var cv=aG.height/y.height;aT=Math.round(bC.width*cv);bm=Math.round(bC.spacing*cv);bJ()}else{}return}if(!K){K=true;au.cancel();au.enable(false);if(B){cm.clearRect(0,0,aG.width,aG.height)}}};this.destroy=function(){if(!bS){return}bS=false;bi.removeAttribute("x-fsi-id");l();bX();for(var cu in aS){a8(aS[cu])}aS={};if(be!=undefined){$FSI.removeCustomEvent(bi,"FSIElementDimension",b9);be=undefined}z=undefined;aK=false;e=[];ax();aQ=undefined;I(undefined,true);aE=0;cancelAnimationFrame(aW);cancelAnimationFrame(o);o=undefined;cancelAnimationFrame(bf);bf=undefined;cancelAnimationFrame(D);D=undefined;W=[];S={};Z=0;if(au){au.destroy();au=undefined}O=bY=0;a5=undefined;bT=[];if(B){$FSI.removeChild(v,B);B=undefined}cm=undefined;aI=b2=aJ=V=bW=bl=undefined;b7={};b0=aM=P=aV=aX=undefined;ac={};d=0;$FSI.removeChild(v.parentNode,v)}};$FSI.InitCustomTagsImageFlow=function(){var b="fsi-imageflow";var c="display:block;width:300px;height:100px;";var e=$FSI.customTags[b];if(e){return}var a=function(g){var f=$FSI.attributes2parameters(g);if(f.src!=undefined&&f.dir==undefined){f.dir=f.src}return f};var d={};d.registerElement=function(){$FSI.addViewerClassCSSRule(b,c);var f=Object.create(HTMLDivElement.prototype);f.createdCallback=function(){$FSI.customTagDimFromAttributes(this);$FSI.ImageFlow.prototype.constructor.call(this)};f.attachedCallback=function(){if(this.getInitDone()){return}this.init(this,a(this))};document.registerElement(b,{prototype:f})};d.replaceTagInit=function(f){$FSI.addViewerClassCSSRule(b,c)};d.replaceTag=function(f){if(!f||(typeof(f.getInitDone)=="function"&&f.getInitDone())){return}$FSI.customTagDimFromAttributes(f);$FSI.ImageFlow.prototype.constructor.call(f);f.init(f,a(f))};e=$FSI.registerCustomTag(b,d)}();delete $FSI.InitCustomTagsImageFlow;