/*!
 * FSI Viewer JS
 * Copyright (c) 2000-2015 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 *
 * VERSION: 1.1.0
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

if(typeof($FSI)=="undefined"){$FSI={};$FSI.init=function(){$FSI.oSupportedViewers={};if(typeof(console.error)!="function"){$FSI.console={};$FSI.console.log=$FSI.fnDoNothing;$FSI.console.warn=$FSI.fnDoNothing;$FSI.console.error=$FSI.fnDoNothing;$FSI.console.dir=$FSI.fnDoNothing}else{$FSI.console=console}try{if(typeof(top.window.alert)=="function"){$FSI.topWindow=top.window}else{$FSI.topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");$FSI.topWindow=window}$FSI.oInstanceCreated={};$FSI.ClassDef=function(instance,strClassName,version,build){var self=this;this.instance=instance;this.strClassName=strClassName;this.version=version;this.build=build;var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!$FSI.oInstanceCreated[strClassName]){$FSI.oInstanceCreated[strClassName]=true;if(instance.getBuild()!=$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};var classDef=new $FSI.ClassDef($FSI,"FSI Core","1.1.2","16.02.08");$FSI.SVGNameSpaceURL="http://www.w3.org/2000/svg";$FSI.regexPlusToSpace=/\+/g;$FSI.regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;$FSI.nViewerInstanceID=0;$FSI.bHTTPS=(document.location.protocol=="https:");$FSI.getViewerInstanceID=function(){return ++$FSI.nViewerInstanceID};$FSI.BoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t=="boolean"){ret=value}else{if(t=="string"){value=value.toLowerCase()}ret=$FSI.BoolTable[value];if(ret==undefined){ret=def}}return ret};$FSI.changeRendererInURL=function(url,strRenderer){url=url.replace($FSI.regExServerRenderer,"$1renderer="+strRenderer);return url};$FSI.loadSkinCSS=function(skinName,scope,fnReady){if(typeof($FSI.iLoaderCSSSkin)!="object"){if(typeof($FSI.LoaderCSSSkin)!="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}$FSI.iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return $FSI.iLoaderCSSSkin.load(skinName,scope,fnReady)};$FSI.addedCSSBlocks={};$FSI.cssClassExists=function(cssID){return(typeof($FSI.addedCSSBlocks[cssID])!="undefined")};$FSI.addCSSClass=function(cssID,strCode){if($FSI.cssClassExists(cssID)){return false}var node=$FSI.addCSSNode(cssID);if(node){try{node.innerHTML=strCode;$FSI.addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};$FSI.addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("x-generated-by","FSI");node.setAttribute("x-generated-for",cssID);node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create <style> node for "+cssID);$FSI.console.error(e.message)}return node};$FSI.addCSSRule=function(selector,rules,index){if($FSI.oInsertedCSS==undefined){$FSI.oInsertedCSS=$FSI.addCSSNode("FSI.Core")}if($FSI.oInsertedCSS!=undefined){try{if($FSI.oInsertedCSS&&$FSI.oInsertedCSS.sheet){if("insertRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in $FSI.oInsertedCSS.sheet){$FSI.oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};$FSI.setStyleAttr=function(el,strStyle){
/*@cc_on
			@if (@_jscript_version < 9)
				el.style.setAttribute('cssText', strStyle);
			@else @*/
el.setAttribute("style",strStyle);
/*@end
			@*/
};$FSI.documentDomain=document.location.hostname;$FSI.regCors=new RegExp("//"+$FSI.documentDomain+"[:/]");$FSI.isCrossDomain=function(url){if(!url||url.indexOf("http")!=0){return false}return url.match($FSI.regCors)==null};$FSI.loadImageCors=function(img,url){if($FSI.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};$FSI.getSVGID=function(){return"$FSI.SVGID_"+$FSI.SVGID++};$FSI.BrowserSupports={};$FSI.BrowserSupports[false]=function(){return false};$FSI.BrowserSupports[true]=function(){return true};$FSI.osVersion=[0,0,0];$FSI.SVGID=0;$FSI.initialWindowWith=window.innerWidth;$FSI.bElementPosRespectsScroll=true;var lastTime=0;var vendors=["ms","moz","webkit","o"];for(var x=0;x<vendors.length&&!window.requestAnimationFrame;++x){window.requestAnimationFrame=window[vendors[x]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[vendors[x]+"CancelAnimationFrame"]||window[vendors[x]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(callback,element){var currTime=new Date().getTime();var timeToCall=Math.max(0,16-(currTime-lastTime));var id=window.setTimeout(function(){callback(currTime+timeToCall)},timeToCall);lastTime=currTime+timeToCall;return id};window.cancelAnimationFrame=function(id){clearTimeout(id)}}var uagent=$FSI.userAgent=navigator.userAgent.toLowerCase();var result;if(uagent.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){result=true;if(uagent.search("android")>-1){$FSI.mobileOS="android";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/android (\S*)/);if(t&&t.length>1){t=t[1].split(".");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}else{if(uagent.indexOf("mac os")!=-1){$FSI.mobileOS="ios";$FSI.isTouch=true;$FSI.noMouse=true;var t=uagent.match(/ os (\S*)/);if(t&&t.length>1){t=t[1].split("_");for(var i=0;i<t.length;i++){t[i]=parseInt(t[i])}$FSI.osVersion=[].concat(t)}}}}else{result=false}$FSI.isMobileDevice=result;$FSI.isSmallMobileDevice=(uagent.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);$FSI.isInternetExplorer=false;if(uagent.search("msie")>-1){$FSI.isInternetExplorer=true;var t=uagent.match(/msie ([^;]*)/);if(t&&t.length>1){$FSI.versionInternetExplorer=parseFloat(t[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){$FSI.isInternetExplorer=true;$FSI.versionInternetExplorer=parseFloat(RegExp.$1)}else{$FSI.isInternetExplorer=(typeof(window.onmsgestureend)!="undefined");$FSI.versionInternetExplorer=12}}if(window.navigator.msPointerEnabled){$FSI.isIETouch=(window.navigator.msMaxTouchPoints>1)}if($FSI.isIETouch){$FSI.bElementPosRespectsScroll=false}if(!$FSI.isTouch){$FSI.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(uagent.search("safari")>-1&&uagent.search("chrome")<1){$FSI.isSafari=true}else{if(uagent.search("firefox")>-1){$FSI.isFirefox=true}else{if(uagent.search("opera")>-1){$FSI.isOpera=true}}}if(uagent.search("mac os")>-1){$FSI.isMac=true}if(typeof(window.pageYOffset)=="number"){$FSI.getDocumentScroll=function(wnd){return{x:wnd.pageXOffset,y:wnd.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.body.scrollLeft,y:wnd.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){$FSI.getDocumentScroll=function(wnd){return{x:wnd.document.documentElement.scrollLeft,y:wnd.document.documentElement.scrollTop}}}}}$FSI.getDocumentScaleNone=function(){return 1};$FSI.getCachedScrollBarWidth=function(el,oReg,w){var cst;var cssOverflowY="";try{cst=top.window.getComputedStyle(el);cssOverflowY=cst["overflow-y"]}catch(e){return 0}if(cssOverflowY=="scroll"||el.scrollHeight>top.window.innerHeight){var orgStyle=el.style.overflowY;var styleID=orgStyle;styleID="S_"+styleID;if(1==1||oReg[styleID]==undefined){el.style.overflowY="hidden";var w2=$FSI.___elementScaleCheck.offsetWidth;if(w2-w>1){oReg[styleID]=w2-w}}}if(!isNaN(oReg[styleID])){ret=oReg[styleID]}else{ret=-1}return ret};$FSI.__getMediaMinScreenWidthCount=0;$FSI.__getMediaMinScreenWidthLoopCount=0;$FSI.oMatchMedia=$FSI.topWindow.matchMedia||$FSI.topWindow.msMatchMedia;$FSI.getMediaMinScreenWidth=function(step){var init=$FSI.topWindow.document.documentElement.clientWidth;if($FSI.__LastGetMediaMinScreenWidth==$FSI.topWindow.document.documentElement.clientWidth){return $FSI.__LastGetMediaMinScreenWidthResult}$FSI.__LastGetMediaMinScreenWidth=$FSI.topWindow.document.documentElement.clientWidth;$FSI.__getMediaMinScreenWidthCount++;var step=10;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while($FSI.oMatchMedia.call(window,"(min-width:"+(init+=step)+"px)")["matches"]){$FSI.__getMediaMinScreenWidthLoopCount++}$FSI.__LastGetMediaMinScreenWidthResult=$FSI.__getDocumentScaleReferenceWidth=init-step;return $FSI.__LastGetMediaMinScreenWidthResult};$FSI.getDocumentScaleInit=function(){$FSI.getDocumentScale=$FSI.getDocumentScaleNone;if($FSI.topWindow.innerWidth==undefined){$FSI.documentScaleMethod="none";return $FSI.getDocumentScale()}if(window.orientation!=undefined){if(!window.outerWidth){$FSI.documentScaleMethod="screen.width / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=(window.orientation%180==0)?screen.width:screen.height;return $FSI.__getDocumentScaleReferenceWidth/window.innerWidth};return $FSI.getDocumentScale()}$FSI.documentScaleMethod="window.outerWidth / window.innerWidth";$FSI.getDocumentScale=function(){$FSI.__getDocumentScaleReferenceWidth=window.outerWidth;return window.outerWidth/window.innerWidth};return $FSI.getDocumentScale()}if($FSI.oMatchMedia&&$FSI.topWindow.document.documentElement.clientWidth>0){var w=$FSI.getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){$FSI.documentScaleMethod="CSS Media Query";$FSI.getDocumentScale=function(){var res=$FSI.getMediaMinScreenWidth("min-width","px")/$FSI.topWindow.innerWidth;if(isNaN(res)){res=1}return res};return $FSI.getDocumentScale()}}$FSI.getDocumentScale=function(){return $FSI.topWindow.outerWidth/$FSI.topWindow.innerWidth};return $FSI.getDocumentScale()};$FSI.getDocumentScale=$FSI.getDocumentScaleInit;if(typeof(window.devicePixelRatio)!="undefined"){$FSI.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{$FSI.getDevicePixelRatio=function(){return 1}}$FSI.getDocumentScaleWithPixelRatio=function(){return $FSI.getDocumentScale()*$FSI.getDevicePixelRatio()};$FSI.fnDoNothing=function(){};$FSI.preventDefaultEvent=function(evt){if(evt.preventDefault){evt.preventDefault()}evt.returnValue=false;return false};$FSI.getElementDimension=function(elem){return{width:elem.offsetWidth,height:elem.offsetHeight}};$FSI.getElementInnerDimension=function(elem){var ret={width:elem.clientWidth,height:elem.clientHeight};var padding=$FSI.getElementPaddings(elem);ret.width-=padding.left+padding.right;ret.height-=padding.top+padding.bottom;return ret};$FSI.getViewportSize=function(wnd){return{width:wnd.innerWidth,height:wnd.innerHeight}};$FSI.mergeObjects=function(o1,o2){for(var o in o2){o1[o]=o2[o]}return o1};$FSI.cloneArray=function(ar){if(ar==undefined||ar.length==undefined){return[]}return ar.concat([])};$FSI.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.push)=="function"){ret=$FSI.cloneArray(val)}else{ret=$FSI.cloneObject(val)}break;default:ret=val}return ret};$FSI.cloneObject=function(obj){var ret={};for(var o in obj){ret[o]=$FSI.cloneValue(obj[o])}return ret};$FSI.cloneParameters=function(parameters){return $FSI.cloneObject(parameters)};$FSI.removeChild=function(parent,child){try{parent.removeChild(child)}catch(e){$FSI.console.error(e.message);$FSI.console.log(parent);$FSI.console.log(child)}};$FSI.oCustomEventListenerClasses={};$FSI.oCustomEventListenerInstances={};$FSI.oCustomEventListeners={};$FSI.nCustomEventListeners=0;$FSI.nCustomEventListenerID=0;$FSI.addCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var obj,listenerID;var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){if(typeof($FSI.oCustomEventListenerClasses[myEvent])=="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is undefined.");return false}listener=$FSI.oCustomEventListenerInstances[myEvent]=new $FSI.oCustomEventListenerClasses[myEvent](myObj,myFunc)}obj=listener.addListener(myObj,myFunc);if(obj!=undefined){listenerID=obj.nCustomEventListenerID=$FSI.nCustomEventListenerID++;$FSI.oCustomEventListeners[obj.nCustomEventListenerID]=obj;$FSI.nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc,bCapturingPhase){var listener=$FSI.oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&$FSI.oCustomEventListeners[obj.nCustomEventListenerID]!=undefined){delete $FSI.oCustomEventListeners[obj.nCustomEventListenerID];$FSI.nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=$FSI.oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};$FSI.removeEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.removeEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.removeEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.detachEvent&&myObj){myObj.detachEvent("on"+myEvent,myFunc)}}};$FSI.addEvent=function(myObj,myEvent,myFunc,bCapturingPhase){if(window.addEventListener&&myObj){if(bCapturingPhase==undefined){bCapturingPhase=true}myObj.addEventListener(myEvent,myFunc,bCapturingPhase)}else{if(window.attachEvent&&myObj){myObj.attachEvent("on"+myEvent,myFunc)}}};$FSI.getScriptTagByFileName=function(strScriptName){var tag;if(typeof(document.querySelector)=="function"){var strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector)}else{var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"s*$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};$FSI.getScriptPath=function(strScriptName,depth){depth++;var ret="";var scripts=document.getElementsByTagName("script");var t="/"+strScriptName;var tag=$FSI.getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};$FSI.guessFSIViewerLocation=function(strScriptName,depth){if($FSI._FSIViewerLocation!=undefined){return $FSI._FSIViewerLocation}var ret=$FSI.getScriptPath(strScriptName,depth);if(ret){$FSI._FSIViewerLocation=ret}return ret};$FSI.createJavascriptLoader=function(){if(typeof($FSI.iLoaderJavascript)!="object"){if(typeof($FSI.LoaderJavascript)!="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}$FSI.iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThroigh)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!$FSI.createJavascriptLoader()){return false}return $FSI.iLoaderJavascript.release(strScriptPath,idInstance)};$FSI.customTags={};$FSI.bCustomTagsAdded=false;$FSI.customTagDimFromAttributes=function(el){var rpl=function(nam){var tmp=el.getAttribute(nam);if(typeof(tmp)=="string"&&tmp.length>0){if(!tmp.match(/[^0-9\s]/)){tmp+="px"}el.style[nam]=tmp}};rpl("width");rpl("height")};$FSI.setParameters=function(node,parameters){if(!node||typeof(node.tagName)!="string"){return false}var t=typeof(parameters);if(t!="object"&&t!="function"){return false}node._fsi_parameters=parameters};$FSI.getParameters=function(node){if(!node||typeof(node.tagName)!="string"){return false}return node._fsi_parameters};$FSI.initCustomNode=function(node){if($FSI.BrowserSupports.registerElement()){return true}if(!node||typeof(node.tagName)!="string"){return false}var strTagName=node.tagName.toLowerCase();var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}oCustomTag.replaceTag(node);return true};$FSI.initCustomTags=function(){if($FSI.BrowserSupports.registerElement()){return}for(var o in $FSI.customTags){$FSI.initCustomTag(o)}};$FSI.initCustomTag=function(strTagName){if($FSI.BrowserSupports.registerElement()){return}var oCustomTag=$FSI.customTags[strTagName];if(!oCustomTag||typeof(oCustomTag.replaceTag)!="function"){return false}var ar=document.getElementsByTagName(strTagName);if(ar&&ar.length>0){if(oCustomTag.replaceTagInit){oCustomTag.replaceTagInit();delete oCustomTag.replaceTagInit}for(var i=0;i<ar.length;i++){oCustomTag.replaceTag(ar[i])}}};$FSI.registerCustomTag=function(strTagName,oFunctions){var oCustomTag=$FSI.customTags[strTagName];if(oCustomTag){return false}oCustomTag=$FSI.customTags[strTagName]={};if($FSI.BrowserSupports.registerElement()){oCustomTag.bRegistered=true;oFunctions.registerElement()}else{oCustomTag.bRegistered=false;oCustomTag.replaceTag=oFunctions.replaceTag;if(typeof(oFunctions.replaceTagInit)=="function"){oCustomTag.replaceTagInit=oFunctions.replaceTagInit}if(!$FSI.bCustomTagsAdded){$FSI.bCustomTagsAdded=true;$FSI.addEvent(window,"DOMContentLoaded",$FSI.initCustomTags)}}return true};$FSI.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};$FSI.oViewerClassCSSRules={};$FSI.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!="string"||strClass.length<1){return}if(typeof(strRule)!="string"||strRule.length<1){return}var res=$FSI.oViewerClassCSSRules[strClass];if(res==strRule){return}$FSI.addCSSRule(strClass,strRule,0);$FSI.oViewerClassCSSRules[strClass]=strRule};$FSI.getWindowOffset=function(el){var ofsX=0;var ofsY=0;try{if(el.frameElement){var w=el;while(w.frameElement){var node=w.frameElement;var nodePos=$FSI.getElementPosition(node);ofsX+=nodePos.left;ofsY+=nodePos.top;w=w.parent}}}catch(e){}return{x:ofsX,y:ofsY}};$FSI.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};$FSI.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};$FSI.getBoundingClientRect=function(el){var ret;try{ret=el.getBoundingClientRect()}catch(e){ret={top:0,left:0,right:0,bottom:0,width:0,height:0}}return ret};$FSI.getElementClientDim=function(element){var rc=$FSI.getBoundingClientRect(element);return{width:(rc.right-rc.left),height:(rc.bottom-rc.top)}};$FSI.getElementClientPos=function(element){return $FSI.getBoundingClientRect(element)};$FSI.getElementPosition=function(element){var node=element;var rc=$FSI.getBoundingClientRect(element);var bl=element.clientLeft;var bt=element.clientTop;var br=0;var bb=0;var pl=0;var pr=0;var pt=0;var pb=0;try{var style=window.getComputedStyle(element,null);pl=parseFloat(style.paddingLeft);pr=parseFloat(style.paddingRight);pt=parseFloat(style.paddingTop);pb=parseFloat(style.paddingBottom);bl=parseFloat(style.borderLeftWidth);br=parseFloat(style.borderRightWidth);bt=parseFloat(style.borderTopWidth);bb=parseFloat(style.borderBottomWidth)}catch(e){}var x1=rc.left+bl+pl;var y1=rc.top+bt+pt;var x2=rc.right-br-pr;var y2=rc.bottom-bb-pb;return{left:x1,top:y1,right:x2,bottom:y2}};$FSI.trim=function(s){if(!s||typeof(s)!="string"||s.length<1){return s}return s.replace(/(^\s+)|(\s+$)/g,"")};$FSI.escapeRegEx=function(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};$FSI.addClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)");var strCurrent=$FSI.trim(el.className);var bFound=strCurrent.match(regex);if(!bFound){if(strCurrent.length>0){strCurrent+=" "+strClass}else{strCurrent+=strClass}el.className=strCurrent}};$FSI.removeClass=function(el,strClass){if(!el||typeof(el.className)!="string"){return}if(typeof(strClass)!="string"){return}strClass=$FSI.trim(strClass);if(strClass.length<1){return}var needle=$FSI.escapeRegEx(strClass);var regex=new RegExp("(^|\\s+)"+needle+"(\\s+|$)","g");var str=$FSI.trim(el.className.replace(regex," "));if(str.length>0){el.className=str}else{el.removeAttribute("class")}};$FSI.urlDecode=function(str){str=str.replace($FSI.regexPlusToSpace," ");return decodeURIComponent(str)};$FSI.getCSSTransformStyleName=function(){if($FSI._CSSTransformStyleName!=undefined){return $FSI._CSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!="translate( 0 , 0)"){ret=ar[i];break}}div=null;$FSI._CSSTransformStyleName=ret;return ret};$FSI.getFSIServerImageDim=function(wSource,hSource,wTarget,hTarget,range,keepAspectRatio){var sourceDim={width:wSource,height:hSource};var targetDim={width:wTarget,height:hTarget};$FSI.calcFSIServerImageDim(sourceDim,targetDim,range,keepAspectRatio);return targetDim};$FSI.calcFSIServerImageDim=function(sourceDimension,targetDimension,range,keepAspectRatio){if(typeof(range)!="object"){range={left:0,top:0,width:1,height:1}}else{range.left=range.left<0?0:range.left>1?1:range.left;range.top=range.top<0?0:range.top>1?1:range.top;range.width=range.width<0?1-range.left:range.width+range.left>1?1-range.left:range.width;range.height=range.height<0?1-range.top:range.height+range.top>1?1-range.top:range.height}targetDimension.width=targetDimension.width<=0||targetDimension.width===undefined?-1:targetDimension.width;targetDimension.height=targetDimension.height<=0||targetDimension.height===undefined?-1:targetDimension.height;var scale={};if(targetDimension.width!=-1&&targetDimension.height!=-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=targetDimension.height/(sourceDimension.height*range.height)}else{if(targetDimension.height==-1){scale.x=targetDimension.width/(sourceDimension.width*range.width);scale.y=scale.x}else{scale.y=targetDimension.height/(sourceDimension.height*range.height);scale.x=scale.y}}if(targetDimension.width==-1||targetDimension.height==-1){var scaleFactor=Math.min(scale.x,scale.y);if(targetDimension.width==-1){targetDimension.width=Math.round(sourceDimension.width*range.width*scaleFactor)}else{if(targetDimension.height==-1){targetDimension.height=Math.round(sourceDimension.height*range.height*scaleFactor)}}scale.x=scaleFactor;scale.y=scaleFactor}if(keepAspectRatio&&Math.abs(scale.x-scale.y)>1e-7){if(scale.x>scale.y){var preciseTargetWidth=targetDimension.height*sourceDimension.width*range.width/(sourceDimension.height*range.height);scale.x=preciseTargetWidth/sourceDimension.width;targetDimension.width=Math.round(preciseTargetWidth)}else{var preciseTargetHeight=targetDimension.width*sourceDimension.height*range.height/(sourceDimension.width*range.width);scale.y=preciseTargetHeight/sourceDimension.height;targetDimension.height=Math.round(preciseTargetHeight)}}targetDimension.width=targetDimension.width==0?1:targetDimension.width;targetDimension.height=targetDimension.height==0?1:targetDimension.height;return scale};if(typeof(window.JSON)=="undefined"){$FSI.JSON={};$FSI.JSON._emulated=true}else{$FSI.JSON=JSON}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof $FSI.JSON.stringify!=="function"){$FSI.JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof $FSI.JSON.parse!=="function"){$FSI.JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());$FSI.BrowserSupports.registerElement=function(){var res=false;try{if(typeof(document.registerElement)=="function"){res=true}}catch(e){}$FSI.BrowserSupports.registerElement=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.canvas=function(){var res=false;try{var cv=document.createElement("canvas");var ctx=cv.getContext("2d");if(ctx&&ctx.clearRect!=undefined){res=true}}catch(e){}$FSI.BrowserSupports.canvas=$FSI.BrowserSupports[res];return res};$FSI.BrowserSupports.cssTouchAction=function(){var res=false;try{if($FSI.isTouch){if(typeof(window.getComputedStyle)=="function"){var stl=window.getComputedStyle(document.body);res=(typeof(stl.touchAction)=="string")}}}catch(e){}$FSI.BrowserSupports.cssTouchAction=$FSI.BrowserSupports[res];return res};var ret=($FSI.isMobileDevice||$FSI.isIETouch||$FSI.isTouch||($FSI.isMac&&$FSI.isSafari))?true:false;$FSI.BrowserSupports.documentZoom=$FSI.BrowserSupports[ret];return true}()}$FSI.EmptyDebugger=function(){this.log=this.error=this.dir=this.setPrefix=function(){};this.on=false};$FSI.Debugger=function(){var a="FSI";this.on=true;this.doNothing=function(){};this.log=this.doNothing;this.error=this.doNothing;this.dir=this.doNothing;try{if(console&&console.log){this.log=function(c){console.log(a+c)}}if(console&&console.error){this.error=function(c){console.error(a+c)}}if(console&&console.dir){this.dir=function(c){console.dir(c)}}}catch(b){}this.setPrefix=function(c){a=c+"> "}};$FSI.CORSLoader=function(){var f=this;var b=0;var a={};var d=false;var g;var c=null;if($FSI.isInternetExplorer&&$FSI.versionInternetExplorer<10){g=function(i){var e;if(!$FSI.isCrossDomain(i)){d=false;e=new XMLHttpRequest()}else{d=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){g=function(){return new XMLHttpRequest()}}}if(!g){try{c=new ActiveXObject("Msxml2.XMLHTTP");g=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(h){try{c=new ActiveXObject("Microsoft.XMLHTTP");g=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(h){c=null;g=function(){return null}}}}this.getSupported=function(){return(g()!=null)};this.load=function(k,l,n,p){var j=g(k);if(!j){return}if(n&&j.overrideMimeType){j.overrideMimeType(n)}j._url=k;var m=b;a[b]=j;b++;var i=-1;if(d){j.onerror=function(){delete a[m];if(l==undefined||this.FSIaborted){return}l(this,this.responseText,p,400)};j.onload=function(){delete a[m];if(l==undefined||this.FSIaborted){return}var q=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var r=new ActiveXObject("Microsoft.XMLDOM");r.async=false;r.loadXML(q);q=this.responseXML=r}catch(s){}break}l(this,q,p,200)}}else{j.onreadystatechange=function(e){if(j.readyState!=4){return}delete a[m];if(l==undefined||this.FSIaborted){return}var q=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;l(this,q,p,j.status)}}try{j.open("GET",k,true);j.send(null)}catch(o){l(this,"",p,500)}return j};this.stopPendingRequests=function(){for(var i in a){var e=a[i];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){f.reset()};this.reset=function(){this.stopPendingRequests();a={}}};$FSI.CanvasProgressBar=function(p,j,h,b,n,c){var o=this;var p=p;if(!c){c={}}if(typeof(c.border)!="string"){c.frame="#58a8ff"}if(typeof(c.color)!="string"){c.color="#58a8ff"}if(typeof(c.background)!="string"){c.background="rgba(255,255,255,0.5)"}if(typeof(c.text)!="string"){c.text="#FFFFFF"}var m=j;var l=h;var e=n;var i=b;var f=0;this.draw=function(q){var r=i/100*q;g(m,l,i,e,f);a(m,l,r,e,f,i);d(m,l,r,e,f,i)};this.setCtx=function(q){p=q};this.setPos=function(q,r){m=q;l=r};var g=function(s,u,t,r,q){p.save();p.fillStyle=c.border;k(s-1,u-1,t+2,1,q);k(s-1,u+r,t+2,1,q);k(s-1,u-1,1,r+2,q);k(s+t,u-1,1,r+2,q);p.fillStyle=c.background;k(s,u,t,r,q);p.restore()};var a=function(t,v,u,s,r,q){p.fillStyle=c.color;k(t,v,u,s,r)};var k=function(s,u,t,r,q){p.fillRect(s,u,t,r)};var d=function(w,u,q,A,t,v){p.save();p.font="10px Arial";p.textAlign="start";p.textBaseline="alphabetic";p.fillStyle=c.text;var z=Math.floor(q/v*100)+"%";var r=p.measureText(z).width;var s=w+q-r-t/2-4;if(q<=t+r){s=w+t/2}p.fillText(z,s,u+A/2+3.25);p.restore()}};$FSI.Config=function(j,s){if(!s||typeof(s)!="object"){s={}}this.parameters=(j)?j:{};this.queryParameters=undefined;try{this.XMLSerializer=(XMLSerializer)?new XMLSerializer():undefined}catch(y){}this.plugins=new Object();this.arPlugins=new Array();this.nPluginToInit=-1;this.arUnrecognizedConfigNodes=new Array();this.locales=new Object();this.locales.tips=new Object();var c=false;var l=this;this.strListFilePrefix="";this.strListFileSuffix="";var k={};var v=0;var u=false;var g;var w={};var p="FSI> ";var m=new $FSI.EmptyDebugger();var o=false;var d={};var z;var t;var q=false;this.strConfigFileExtension=".xml";l.strTemplateSuffix=".json";var r;var f=null;if($FSI.isInternetExplorer&&$FSI.versionInternetExplorer<10){r=function(B){var e;if(!$FSI.isCrossDomain(B)){q=false;e=new XMLHttpRequest()}else{q=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){r=function(){return new XMLHttpRequest()}}}if(!r){try{f=new ActiveXObject("Msxml2.XMLHTTP");r=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(y){try{f=new ActiveXObject("Microsoft.XMLHTTP");r=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(y){f=null;r=function(){return null}}}}this.bForceVersion5=false;this.pluginDefaultParameters=new Object();this.pluginDefaultParameters.pages={};this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",renderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfgAliasNamesSecondLevel={renderer:"fpxservertemplate"};this.cfg=this.cfgDefaults={defaultcfg:"_default",headers:"cors",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(B){l.reset();if(B){if(l.parameters){l.parameters=$FSI.mergeObjects(l.parameters,B)}else{l.parameters=B}}i(l.parameters);l.getQueryParameters();l.cloneParameters(l.cfgDefaults,l.cfg);l.cloneParameters(l.queryParameters,l.cfg);l.elevateToHTTPS();n();l.BaseURL=l.getBaseURL();if(l.bForceVersion5==true){}var e=l.queryParameters.fsiviewerversion;if(l.bForceVersion5==true){e="5"}if(e!=undefined){if(parseInt(e)<6){l.strConfigFileExtension=".fsi"}}var C=l.queryParameters.fsiserverversion;if(l.bForceVersion5==true){C="2"}if(C!=undefined){if(parseInt(C)<3){l.strTemplateSuffix="_json"}}if(l.queryParameters.fsiviewerlocation!=undefined){l.locationFSIViewer=l.queryParameters.fsiviewerlocation}else{if($FSI!=undefined&&$FSI._FSIViewerLocation!=undefined){m.log("FSI Viewer location gussed based on script location: "+$FSI._FSIViewerLocation);l.locationFSIViewer=$FSI._FSIViewerLocation}else{l.locationFSIViewer=l.BaseURL.split("/");if(l.locationFSIViewer.length>4){l.locationFSIViewer.splice(l.locationFSIViewer.length-3,2);l.locationFSIViewer=l.locationFSIViewer.join("/")}}}if(l.locationFSIViewer.charAt(l.locationFSIViewer.length-1)!="/"){l.locationFSIViewer+="/"}l.nextConfigURL=l.getReloadPath(l.locationFSIViewer,l.expandFSIPath(l.cfg.defaultcfg));l.checkDebug(false)};var i=this.makeObjectPropertiesLowerCase=function(e){for(var B in e){var C=B.toLowerCase();if(B!=C){if(e[C]==undefined){e[C]=e[B]}delete e[B]}}};var n=function(){c=l.makeBool(l.cfg.usenc,false);if(l.cfg.usencquery!=undefined&&l.cfg.usencquery.length>0){o=l.cfg.usencquery;c=true;l.queryToObject("?"+o,d)}};this.stopPendingRequests=function(){for(var B in k){var e=k[B];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}};this.destroy=function(){l.stopPendingRequests()};this.getBaseURL=function(){var C;var B=document.getElementsByTagName("base");if(B&&B.length>0){C=B[B.length-1].href;if(C&&C.charAt(C.length-1)!="/"){C+="/"}}else{C=document.location.href;var e=C.indexOf("?");if(e!=-1){C=C.slice(0,e)}e=C.indexOf("#");if(e!=-1){C=C.substring(0,e)}e=C.lastIndexOf("/");if(e!=-1){C=C.slice(0,e+1)}}return C};this.reset=function(){m=new $FSI.EmptyDebugger();l.stopPendingRequests();g=Math.random();l.nIncludedConfigs=0;l.completedConfigs=new Object();l.plugins=new Object();l.cfg=new Object();l.queryParameters=undefined;l.arUnrecognizedConfigNodes=[]};this.getQueryParameters=function(){if(l.queryParameters!=undefined){return}l.queryParameters=new Object();l.cloneParameters(l.parameters,l.queryParameters)};this.makeBool=function(D,e){if(typeof(e)!="boolean"){e=false}var B=e;switch(typeof(D)){case"string":var C=$FSI.makeBool(D);if(C!=undefined){B=C}break;case"number":B=Boolean(D);break;case"boolean":B=D;break}return B};this.loadLanguageFile=function(){var B=l.cfg.language;if(B==undefined){B="english"}var e=l.locationFSIViewer+"/languages/"+B+".xml";var C={};l.finishRequestParams(C);Ext.Ajax.request({url:e,overrideMimeType:"application/xml",params:C,method:"GET",scope:l,success:function(D,E){l.logXMLResponseOK(D);l.onLanguageLoaded(true,D)},failure:function(D,E){l.logLoadFileFailed(D,E);l.onLanguageLoaded(false,D)}})};this.logLoadFileFailed=function(e,D){if(!m.on){return}if(e&&e.status!=undefined){var C="HTTP "+e.status;if(e&&e.statusText){C+=", "+e.statusText}var B=(e._url)?e._url:"";m.error("Failed to load "+B+" ("+C+")")}else{m.error("Failed loading a file");if(e&&e._url){m.error(e._url)}}};this.logXMLResponseOK=function(e){};this.parseLanguage=function(E){if(!E||!E.firstChild){return false}var e=E.firstChild.childNodes;var F,C,D;for(var B=0;B<e.length;B++){C=e[B];F=l.getAttributeValue(C,"id");if(F==undefined){continue}F=F.toLowerCase();if(C.childNodes.length>0){D=l.XMLChildNodesToString(C)}else{D=l.getAttributeValue(C,"txt")}l.locales.tips[F]=D}return true};this.getAttributeValue=function(B,e){if(!B){return}return B.getAttribute(e)};this.onLanguageLoaded=function(B,e){m.log("Language loaded");if(B){l.parseLanguage(e.responseXML)}l.initPagesParameters();if(s.onConfigReady){s.onConfigReady()}};this.onConfigReadyDone=function(){if(!l.readCustomPageNumbers()){l.loadImageList()}};this.swapParameters=function(C,e){C=C.toLowerCase();e=e.toLowerCase();var B=l.plugins.pages.parameters;if(B==undefined){return}l.swapValues(B,C,e);l.swapValues(l.cfg,"pages_"+C,"pages_"+e)};this.swapValues=function(D,C,B){var e=D[C];D[C]=D[B];D[B]=e};this.initPagesParameters=function(){l.LinkTemplates=l.getPagesParameter("LinkTemplates","").split(",");for(var e=0;e<l.LinkTemplates.length;e++){l.LinkTemplates[e]=$FSI.urlDecode(l.LinkTemplates[e])}l.LinkTemplateData=l.getPagesParameter("LinkTemplateData","").split(",");for(var e=0;e<l.LinkTemplateData.length;e++){l.LinkTemplateData[e]=$FSI.urlDecode(l.LinkTemplateData[e])}l.LinkTemplateCount=Math.max(l.LinkTemplates.length,l.LinkTemplateData.length)};this.getTranslation=function(B){var e=l.locales.tips[B.toLowerCase()];if(e==undefined){e=B}return e};this.getImageURL=function(C,e){if(C==undefined){return""}if(e==undefined){e={}}if(e.type==undefined){e.type="image"}if(e.renderer==undefined){e.renderer="jpeg"}e.source=C;for(var B in w){if(e[B]==undefined){e[B]=w[B]}}return l.requestBase+"?"+l.objectToQuery(e)};this.getImageInfoURL=function(B,e){if(B==undefined){return""}if(e==undefined){e={}}if(e.type==undefined){e.type="info"}if(e.tpl==undefined){if(l.cfg.fpxinfotemplate!=undefined){e.tpl=l.cfg.fpxinfotemplate}else{e.tpl="info.json"}}if(l.cfg.headers&&l.cfg.headers.length>0){e.headers=l.cfg.headers}if(!e.tpl.match(/.json$/)){e.tpl+=".json"}e.source=B;return l.requestBase+"?"+l.objectToQuery(e)};this.queryToObject=function(E,C){if(C==undefined){C={}}var D,G,F,e,B;D=E.indexOf("?");if(D!=-1){B=E.slice(D+1)}else{B=""}D=B.indexOf("#");if(D!=-1){B=B.substring(0,D)}B=B.split("&");for(D=0;D<B.length;D++){G=B[D].split("=");F=$FSI.urlDecode(G[0]).toLowerCase();if(F.length>0){e=$FSI.urlDecode(G[1]);C[F]=e}}return C};this.objectToQuery=function(B){var e=[];if(c&&o!==false){for(var D in d){B[D]=d[D]}}for(var D in B){var C=encodeURIComponent(B[D]);e.push(encodeURIComponent(D)+"="+C)}return e.join("&")};this.loadConfigs=function(){l.loadNextConfig(true)};this.loadFile=function(B,C,E,F){if(!B||B.length<0){if(C){C(this,"",F)}return}if(E==undefined){E="application/json"}var e=r(B);if(!e){return}if(E&&e.overrideMimeType){e.overrideMimeType(E)}e._url=B;var D=v;k[v]=e;v++;if(q){e.onerror=function(){delete k[D];if(C==undefined||this.FSIaborted){return}l.logLoadFileFailed(this)};e.onload=function(){delete k[D];if(C==undefined||this.FSIaborted){return}var G=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var H=new ActiveXObject("Microsoft.XMLDOM");H.async=false;H.loadXML(G);G=this.responseXML=H}catch(I){m.log("Failed parsing XML using Microsoft.XMLDOM");m.log(B)}break;case"application/json":G={};try{G=$FSI.JSON.parse(this.responseText)}catch(I){m.error("Failed parsing JSON from URL: "+B+" ("+I.message+")")}break}C(this,G,F)}}else{e.onreadystatechange=function(G){var H;if(e.readyState!=4){return}delete k[D];if(C==undefined||this.FSIaborted){return}if(this.status>299){l.logLoadFileFailed(this)}switch(E){case"application/xml":case"text/xml":H=this.responseXML;break;case"application/json":H={};try{H=$FSI.JSON.parse(this.responseText)}catch(I){m.error("Failed parsing JSON from URL: "+B+" ("+I.message+")")}break}C(this,H,F)}}e.open("GET",B,true);e.send(null);return e};this.onConfigXMLLoaded=function(e,B){l.logXMLResponseOK(e.response);l.onConfigLoaded(e.responseXML)};this.loadNextConfig=function(C){if(l.nextConfigURL==undefined){l.finalCheck();return}var e=!l.makeBool(l.cfg.ConfigCaching,true);var D={};if(l.makeBool(l.cfg.debug)||(!C&&!l.makeBool(l.cfg.configcaching,true)&&l.makeBool(l.cfg.enableconfigcachingparameter))){l.addNoCacheParams(D)}l.finishRequestParams(D);var B=l.addURLParameters(l.nextConfigURL,D);m.log("LOAD CONFIG: "+B);l.loadFile(B,l.onConfigXMLLoaded,"application/xml")};this.parseMargins=function(C,B,e,D){if(e==undefined){e=_root._FSI.StageWidth}if(D==undefined){D=_root._FSI.StageHeight}C[B+"Left"]=l.getFloatParameterPercent(B+"Left",0,e);C[B+"Top"]=l.getFloatParameterPercent(B+"Top",0,D);C[B+"Right"]=l.getFloatParameterPercent(B+"Right",0,e);C[B+"Bottom"]=l.getFloatParameterPercent(B+"Bottom",0,D);C[B+"Inner"]=l.getFloatParameterPercent(B+"Inner",0,e);C[B+"Outer"]=l.getFloatParameterPercent(B+"Outer",0,e)};this.getFloatParameterPercent=function(e,B,C){return l.parseFloatPercentDef(l.getPagesParameter(e),C,B,-1000000)};this.parseFloatPercentDef=function(D,C,B,e){if(D==undefined||D.length<1){return B}return Math.max(e,l.parseFloatPercent(D,C))};this.parsePercentDef=function(C,e){if(C==undefined||C.length<1){return e}var B=parseFloat(C);if(isNaN(B)){B=0}else{if(C.indexOf("%")!=-1){B/=100}}return B};this.parseFloatPercent=function(C,B){var e=parseFloat(C);if(isNaN(e)||e<0){e=0}else{if(C.indexOf("%")!=-1){e=Math.round(e*B/100)}else{e=Math.ceil(e)}}return e};this.setDebugPrefix=function(e){p=e+"> "};this.setDebugger=function(e){m=e};this.checkDebug=function(B){var e;if(l.makeBool(l.cfg.debug)){if(!m||!m.on){m=new $FSI.Debugger();if(s.onDebuggerChange){e=s.onDebuggerChange(m,B)}}}else{if(!m||m.on===true){m=new $FSI.EmptyDebugger();if(s.onDebuggerChange){e=s.onDebuggerChange(m,B)}}}return e};this.onConfigLoaded=function(B){l.parseConfig(B);l.elevateToHTTPS();if(l.checkDebug(true)==true){return}n();var e;if(l.cfg.includeconfig!=undefined&&l.nIncludedConfigs<10){e=l.getFSIPath(l.locationFSIViewer,l.expandFSIPath(l.cfg.includeconfig));l.nIncludedConfigs++;l.cfg["includeconfig("+l.nIncludedConfigs+")"]=l.cfg.includeconfig;l.cfg.includeconfig=undefined}else{if(l.cfg.cfg!=undefined){e=l.getFSIPath(l.locationFSIViewer,l.expandFSIPath(l.cfg.cfg))}}if(e!=undefined&&!l.completedConfigs[e]){l.completedConfigs[e]=true;l.nextConfigURL=e;l.loadNextConfig()}else{l.evaluateQuery(l.queryParameters,l.cfg);l.finalCheck()}};this.elevateToHTTPS=function(){if(!$FSI.bHTTPS){return}if(!l.makeBool(l.cfg.autoelevatetohttps,true)){return}b("fpxbase");b("fpxserver")};var b=function(e){if(l.cfg[e]!=undefined&&l.cfg[e].length>0&&l.cfg[e].indexOf("http://")==0){l.cfg[e]="https"+l.cfg[e].substr(4)}};this.evaluateQuery=function(B,e){for(var C in B){l.setConfigParamByValue(e,C.toLowerCase(),B[C])}};this.parseConfig=function(B){var K="";if(B!=undefined){var C=B.firstChild;if(C&&C.nodeName=="xml"){C=C.nextSibling}var J=C.childNodes;for(var G=0;G<J.length;G++){var E=J[G];if(E.nodeType!=1){continue}var H=E.nodeName.toLowerCase();K=H;var D=E.childNodes;switch(H){case"licence":break;case"plugins":for(var F=0;F<D.length;F++){l.parsePluginNode(D[F])}break;case"info":case"options":K=undefined;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(var F=0;F<D.length;F++){var I=D[F];if(I.nodeType!=1){continue}var e=l.getValueFromXMLNode(I,K);l.setConfigParam(l.cfg,e)}break;default:l.arUnrecognizedConfigNodes.push(E)}}}};this.getData=function(){var e={};e.cfg={};for(var B in l.cfg){e.cfg[B]=l.cfg[B]}return e};this.setData=function(e){if(!e||!e.cfg){return}l.cfg={};this.setCfgValues(e.cfg)};this.setCfgValues=function(e){for(var B in e){l.cfg[B]=e[B]}a()};this.getImagesNodeList=function(C){var e=[];if(C==undefined){C=l.getUnrecognizedConfigNode("images")}if(C){var D=C.firstChild;while(D){if(D.nodeType==1){var B={};B.attributes={};h(D,B.attributes);B.cfg={};l.parseConfigFragment(D,B.cfg);e.push(B)}D=D.nextSibling}}return e};this.removeUnrecognizedConfigNodes=function(){l.arUnrecognizedConfigNodes=[]};this.getUnrecognizedConfigNode=function(D){var e;D=D.toLowerCase();for(var B=l.arUnrecognizedConfigNodes.length-1;B>-1;B--){var C=l.arUnrecognizedConfigNodes[B];if(C&&C.nodeName.toLowerCase()==D){e=C;break}}return e};this.parseConfigFragment=function(D,H,G){var L="";if(D!=undefined&&H!=undefined){if(G==undefined){G=[]}var B=D;var K=B.childNodes;for(var F=0;F<K.length;F++){var D=K[F];if(D.nodeType!=1){continue}var I=D.nodeName.toLowerCase();L=I;var C=D.childNodes;switch(I){case"info":case"options":L=undefined;case"fpx":case"image":case"include":for(var E=0;E<C.length;E++){var J=C[E];if(J.nodeType!=1){continue}var e=l.getValueFromXMLNode(J,L);l.setConfigParam(H,e)}break;default:G.push(D)}}}};this.findXMLNode=function(B,e){if(B==undefined||B.nodeType==undefined){return undefined}while(B){if(B.nodeName.toLowerCase()==e){break}if(B.firstChild!=undefined){B=B.firstChild}else{if(B.nextSibling!=undefined){B=B.nextSibling}else{B=B.parentNode.nextSibling}}}return B};this.getValueFromXMLNode=function(C,e){if(!C||C.nodeType!=1){return}var B=new Object();var D=(e)?e:"";B.name=D+C.nodeName.toLowerCase();var E=C.getAttribute("value");if(E){B.value=E;return B}B.value=l.XMLChildNodesToString(C);B.node=C;return B};this.getXMLNodeAttribute=function(D,C,e){if(!D||D.nodeType!=1||!D.getAttribute){return e}var B=D.getAttribute(C);if(B==undefined||B==null){B=e}return B};this.XMLChildNodesToString=function(B){if(!B||!B.firstChild){return""}var e="";if(B.childNodes.length==1&&B.firstChild.nodeType==3){e=B.firstChild.nodeValue}else{e=l._XMLChildNodesToString(B)}return e};this.hasPlugin=function(e){return(l.plugins&&l.plugins[e]!=undefined)};this.getPluginParameter=function(G,B,e,F){G=G.toLowerCase();B=B.toLowerCase();if(l.plugins[G]==undefined){m.error("CANNOT GET PLUGIN PARAMETER, because plugin not defined: "+G+"."+B);return e}var E;var D=G+"_"+B;if(l.cfg[D]!=undefined){E=l.cfg[D]}else{var C=l.plugins[G].parameters;if(C!=undefined&&C[B]!=undefined){E=C[B]}}if(E==undefined){E=e}if(F){E=l.makeBool(E,e)}return E};this.getUnescapedPagesParameter=function(D,C,B){var e=l.getPagesParameter(D,C);if(e==undefined&&B!=undefined){e=l.getPagesParameter(B,C)}if(e!=undefined){e=$FSI.urlDecode(e)}return e};this.getIntParameterMinMax=function(B,C,e,D){return Math.min(D,Math.max(e,l.getIntParameter(B,C)))};this.getIntParameter=function(B,C){var e=parseInt(l.cfg[B.toLowerCase()]);if(isNaN(e)){e=C}return e};this.getStringParameter=function(B,C){var e=l.cfg[B.toLowerCase()];if(e==undefined){e=C}return e};this.getFloatParameter=function(B,C){var e=parseFloat(l.cfg[B.toLowerCase()]);if(isNaN(e)){e=C}return e};this.getRGBAValue=function(B){var e=new Object();if(B==undefined){B=""}if(B.charAt(0)=="#"){B=B.substr(1)}if(B.length>8){B=B.substr(0,8)}if(B.length>5){e.webColor="#"+B.substr(0,6);e.red=parseInt(B.substr(0,2),16);e.green=parseInt(B.substr(2,2),16);e.blue=parseInt(B.substr(4,2),16);if(B.length<7){e.alpha=255}else{e.alpha=parseInt(B.substr(6,2),16)}}else{e.alpha=255;e.webColor="#000000";e.red=e.green=e.blue=0}e.webAlpha=e.alpha/255;return e};this.getPagesParameter=function(B,e,C){return l.getPluginParameter("pages",B,e,C)};var h=function(F,B){if(!F||!F.attributes||!F.attributes.length||!B){return false}var C=F.attributes;for(var E=0;E<C.length;E++){var e=C[E];var D=e.nodeName.toLowerCase();B[D]=e.value}return true};this.parsePluginNode=function(C){if(C.nodeType!=1){return}var E=new Object();h(C,E);var D=C.childNodes;for(var e=0;e<D.length;e++){var F=D[e];if(F.nodeType!=1){continue}var B=l.getValueFromXMLNode(F);if(B.value!=undefined){E[B.name]=B.value;if(B.node!=undefined){E[B.name+".node"]=B.node}}}this.addPluginFromString(E.src,E)};this.trimString=function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};this.addPluginsFromString=function(C){if(C==undefined||C.split==undefined||C.length<1){return}var e=C.split(",");for(var B=0;B<e.length;B++){var D=l.trimString(e[B]);l.addPluginFromString(D)}};this.addPluginFromString=function(B,C){if(B==undefined||B.length<1){m.error("PLUGIN without src parameter:");return}B=B.toLowerCase();if(C==undefined){C=new Object()}var e=l.plugins[B]=new Object();e.name=B;if(l.pluginDefaultParameters[B]!=undefined){e.parameters=new Object();l.cloneParameters(l.pluginDefaultParameters[B],e.parameters);l.cloneParameters(C,e.parameters)}else{e.parameters=C}};this.setConfigParamByValue=function(B,C,e){l.setConfigParam(B,{name:C.toLowerCase(),value:e})};this.setConfigParam=function(B,C){var D=C.name;var e=C.value;if(D==undefined){return}if(l.cfgAliasNames[D]!=undefined){D=l.cfgAliasNames[D]}if(B[D]!=undefined&&(typeof(e)=="string"&&$FSI.BoolTable[e.toLowerCase()]==false)&&$FSI.BoolTable[B[D]]==undefined){delete B[D]}else{switch(D){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":if(B[D]!=undefined&&B[D].length>0&&B[D].indexOf(e)==-1){B[D]+=","+e}else{B[D]=e}break;case"plugins":l.addPluginsFromString(e);break;case"fpxpath":B[D]=e;B.fpxsrc=encodeURIComponent(e);break;default:B[D]=e;if(C.node!=undefined){B[D+".node"]=C.node}}}};var a=function(){l.serverProfile=l.cfg.fpxservertemplate;l.serverProfileDoublePage=l.cfg.fpxservertemplatedoublepage;if(l.serverProfileDoublePage==undefined){l.serverProfileDoublePage="doublepage"}l.serverBase=l.cfg.fpxserver;if(l.serverBase==undefined){m.log("Note:",true);m.log("Parameter 'imageserver' undefined, guess from ["+l.locationFSIViewer+"]",true);var B;B=l.locationFSIViewer.indexOf("/users/");if(B!=-1){l.serverBase=l.locationFSIViewer.substring(0,B)+"/server"}else{B=l.locationFSIViewer.indexOf("/viewer/");l.serverBase=l.locationFSIViewer.substring(0,B)+"/server"}m.log("guessed location is: ["+l.serverBase+"]",true)}l.requestBase=l.serverBase;w={};var e=l.cfg.effects;if(e!=undefined){w.effects=e}e=l.cfg.lefteffects;if(e!=undefined){w.lefteffects=e}e=l.cfg.righteffects;if(e!=undefined){w.righteffects=e}e=l.cfg.quality;if(e!=undefined){w.quality=e}};this.finalCheck=function(){l.elevateToHTTPS();a();if(s.onConfigsReady){s.onConfigsReady()}m.log("Evaluated Configuration:");m.dir(l.cfg)};var A=l.finishURL=function(e){if(!c||e==undefined){return e}var B;if(o===false){B="cache=0&cachernd="+g;if(e.indexOf("?")==-1){e+="?"+B}else{e+="&"+B}}else{B=o;if(e.indexOf("?")==-1){e+="?"+B}else{e+=B}}return e};this.addURLParameters=function(B,C){if(!B||!C){return B}var e=[];for(var D in C){e.push(encodeURIComponent(D)+"="+encodeURIComponent(C[D]))}if(e.length>0){if(B.indexOf("?")==-1){B+="?"}else{B+="&"}B+=e.join("&")}return B};this.finishRequestParams=function(B){if(c){if(o===false){B.cache=0;B.cachernd=g}else{for(var e in d){B[e]=d[e]}}}};this.addNoCacheParams=function(e){e.cache=0;e.cachernd=g};this.parseQuery=function(B,e){if(e==undefined||B==undefined||B.length<1){return}l.queryToObject(B,e);if(e.ignorequeryparameters!=undefined){delete e.ignorequeryparameters}if(e.enableconfigcachingparameter!=undefined){delete e.enableconfigcachingparameter}};this.cloneParameters=function(e,B){if(e==undefined||B==undefined){m.error("Cloning object failed: "+e+" / "+B)}for(var C in e){B[C]=e[C]}};this.getFSIPath=function(B,C){if(C.indexOf("://")!=-1){return C}if(l.cfg.fsibase!=undefined){C=l.cfg.fsibase+C}var e=l.getReloadPath(B,C);return e};this.expandFSIPath=function(B){var e=$FSI.urlDecode(B);if(e.indexOf("?")!=-1||e.indexOf(l.strConfigFileExtension)==(e.length-4)){return B}return B+l.strConfigFileExtension};this.getReloadPath=function(D,F){var B,G,e,E;if(D==undefined){D=l.locationFSIViewer}if(F==undefined){F=""}var C="/";if(F.indexOf("://")!=-1){return F}B=D;E=B.lastIndexOf("?");if(E==-1){E=B.length}G=B.lastIndexOf("\\",E);e=B.lastIndexOf("/",E);G=Math.max(G,e);if(G==-1){G=B.length-1}B=B.slice(0,G);if(B.length>0&&F.indexOf(C)!=0){B+=C}return B+F};this.cloneValueObject=function(B){var e=new Object();for(var C in B){e[C]=B[C]}return e};this._getXMLConfigValue=function(e){var B;if(!e){return}if(e.childNodes.length>0){B=l._XMLChildNodesToString(e)}else{B=e.getAttribute("value")}return B};this._XMLChildNodesToString=function(D){if(!D||!D.firstChild){return""}var B="";try{if(D.xml!=undefined){for(var C=0;C<D.childNodes.length;C++){B+=D.childNodes[C].xml}}else{for(var C=0;C<D.childNodes.length;C++){B+=l.XMLSerializer.serializeToString(D.childNodes[C])}}}catch(E){}return B};this._findFirstXMLNode=function(C,D){var B,e;while(C){if(C.nodeName==D){e=C;break}B=C.firstChild;if(!B){B=C.nextSibling}if(!B&&C.parentNode){B=C.parentNode.nextSibling}C=B}return e};this._parseXMLImageList=function(E){var F={};var e=F.arImages=[];var B;if(!E){return e}var C=l._findFirstXMLNode(E,"images");if(!C){return e}var C=l._findFirstXMLNode(C,"image");if(!C){return e}while(C){if(C.nodeType==1){B=l._findFirstXMLNode(C,"path");var D=l._getXMLConfigValue(B);if(!D){D=$FSI.urlDecode(l.getAttributeValue(C,"file"))}if(D!=undefined){e.push(D)}if(F.width==undefined){B=l._findFirstXMLNode(C,"width");B=l._getXMLConfigValue(B);if(B!=undefined){F.width=parseInt(B)}B=l._findFirstXMLNode(C,"height");B=l._getXMLConfigValue(B);if(B!=undefined){F.height=parseInt(B)}}}C=C.nextSibling}return F};this.getImageList=function(){var e;if(l.cfg&&l.cfg.fpxsources!=undefined){e={};e.oXML=null;e.arImages=l.cfg.fpxsources.split(",");for(var C=0;C<e.arImages.length;C++){e.arImages[C]=$FSI.urlDecode(e.arImages[C])}return e}if(l.arUnrecognizedConfigNodes&&l.arUnrecognizedConfigNodes.length>0){var B=l.arUnrecognizedConfigNodes;for(var C=0;C<B.length;C++){var D=B[C];if(D&&D.nodeName.toLowerCase()=="images"){e=l._parseXMLImageList(D);e.oXML=D}}}if(l.cfg&&l.cfg.fpxsrc!=undefined){e={};e.oXML=null;e.arImages=[];e.arImages.push($FSI.urlDecode(l.cfg.fpxsrc));return e}return e};this.loadImageList=function(D,E,G,F){if(!l.serverBase||!D){return false}var C=l.serverBase+"?type=list";if(D.indexOf("tpl")==-1){var B=l.cfg.listtemplate;if(B&&B.length>0&&B.indexOf(".json")==-1&&B.indexOf(".xml")==-1){B+=".json"}C+="&tpl="+B}if(l.cfg.headers&&l.cfg.headers.length>0&&d.headers==undefined){C+="&headers="+l.cfg.headers}C+="&source="+encodeURIComponent(D);if(G!=undefined){C+=G}C=A(C);var e=l.loadFile(C,function(H,K){if(typeof(K)=="object"&&typeof(K.images)=="object"){K.images.pop();var L="";if(K&&K.imagesattributes&&K.imagesattributes.dir){L=K.imagesattributes.dir}var I=new Array(K.images.length);for(var J=0;J<K.images.length;J++){I[J]=L+K.images[J].src}E(I,K,F)}else{E([],K,F)}},"application/json",F);return e}};$FSI.Rect=function(c,e,f,a){var d=this;d.left=(isNaN(c))?0:c;d.top=(isNaN(e))?0:e;d.right=(isNaN(f))?0:f;d.bottom=(isNaN(a))?0:a;this.width=function(){var b=d.right-d.left;return(b<0)?-b:b};this.height=function(){var b=d.bottom-d.top;return(b<0)?-b:b};this.offsetRect=function(g,b){d.left+=g;d.right+=g;d.top+=b;d.bottom+=b};this.inflateRect=function(h,g){var b=h/2;var i=g/2;d.left-=b;d.top-=i;d.right+=b;d.bottom+=i};this.normalizeRect=function(){var b;if(d.left>d.right){b=d.left;d.left=d.right;d.right=b}if(d.top>d.bottom){b=d.top;d.top=d.bottom;d.bottom=b}};this.setRect=function(h,i,j,g){d.left=h;d.top=i;d.right=j;d.bottom=g};this.scaleRect=function(b){if(b==1){return}d.left*=b;d.top*=b;d.right*=b;d.bottom*=b};this.scaleRectXY=function(g,b){d.left*=g;d.top*=b;d.right*=g;d.bottom*=b};this.scaleRectInt=function(b){if(b==1){return}d.left=Math.round(d.left*b);d.top=Math.round(d.top*b);d.right=Math.round(d.right*b);d.bottom=Math.round(d.bottom*b)};this.interSectRect=function(j){d.normalizeRect();j.normalizeRect();var i=Math.max(d.left,j.left);var b=Math.max(d.top,j.top);var g=Math.min(d.right,j.right);var h=Math.min(d.bottom,j.bottom);d.setRect(i,b,g,h)};this.interSectRectValidate=function(b){d.interSectRect(b);if(d.right<d.left){d.left=d.right=0}if(d.bottom<d.top){d.top=d.bottom=0}};this.isInsideRect=function(b){return(d.left>=b.left&&d.top>=b.top&&d.right<=b.right&&d.bottom<=b.bottom)};this.isRectInsideMe=function(b){return(d.left<=b.left&&d.top<=b.top&&d.right>=b.right&&d.bottom>=b.bottom)};this.getBoundingRect=function(k){d.normalizeRect();k.normalizeRect();var j=Math.min(d.left,k.left);var b=Math.min(d.top,k.top);var h=Math.max(d.right,k.right);var i=Math.max(d.bottom,k.bottom);var g=new $FSI.Rect(j,b,h,i);return g};this.equalRect=function(b){if(d.left==b.left&&d.top==b.top&&d.right==b.right&&d.bottom==b.bottom){return true}else{return false}};this.copyRect=function(b){d.setRect(b.left,b.top,b.right,b.bottom)};this.duplicateRect=function(){return new $FSI.Rect(d.left,d.top,d.right,d.bottom)};this.round=function(b){var g=function(i,h){i*=h;i=(i>=0)?Math.floor(i+0.5):Math.ceil(i-0.5);return i/h};if(isNaN(b)){b=1000000}d.left=g(d.left,b);d.top=g(d.top,b);d.right=g(d.right,b);d.bottom=g(d.bottom,b)};this.toString=function(){return d.left+","+d.top+","+d.right+","+d.bottom};this.getRange=function(){var b={};b.left=d.left;b.top=d.top;b.width=d.width();b.height=d.height();return b}};$FSI.CroppedImage=function(){var n=this;var c=new $FSI.Rect(0,0,0,0);var l,b;var g=new $FSI.Rect();var f=new $FSI.Rect(0,0,1,1);var a={width:0,height:0};var i=false;var m=function(r,q){if(typeof(r)!="string"){return q}var o=r.split(",");var p=o.length;while(o.length<4){o.push(q[p]);p++}return o};this.setCropFromConfig=function(o){if(o.cropvalues!=undefined){n.setCropValuesParam(o.cropvalues)}else{if(o.croprect!=undefined){n.setCropRectParam(o.croprect)}}};this.setCropRectParam=function(p){var o=m(p,["0","0","1","1"]);n.setCropRect(o[0],o[1],o[2],o[3])};var e=function(q,p){var o;if(isNaN(q)){o=p}else{o=Math.max(0,Math.min(1,q))}return o};var h=function(p,o){return Math.round(p*o)};this.setCropRect=function(p,q,s,o){l={l:p,t:q,r:s,b:o};b=undefined;p=e(p,0);q=e(q,0);s=e(s,1);o=e(o,1);f.setRect(p,q,1-s,1-o);p=h(p,a.width);q=h(q,a.height);s=a.width-h(s,a.width);o=a.height-h(o,a.height);d(p,q,s,o)};var d=function(p,q,s,o){s=Math.min(a.width-p,s);o=Math.min(a.height-q,o);c.setRect(p,q,s,o);i=(p!=0||q!=0||s!=0||o!=0);g.setRect(p,q,a.width-s,a.height-o)};this.setCropValuesParam=function(p){var o=m(p,["0","0","0","0"]);n.setCropValues(o[0],o[1],o[2],o[3])};var k=function(q,o){var p={};if(q.indexOf("%")!=-1){q=Math.max(0,Math.min(100,parseFloat(q)));p.floatVal=q/100;p.pxVal=Math.round(q*o/100)}else{if(q.indexOf("px")!=-1){q=parseInt(q);p.pxVal=Math.max(0,Math.min(o,q));p.floatVal=p.pxVal/o}else{p.floatVal=Math.max(0,Math.min(1,parseFloat(q)));p.pxVal=Math.round(p.floatVal*o)}}return p};this.setCropValues=function(p,q,s,o){b={l:p,t:q,r:s,b:o};l=undefined;p=k(p,a.width);s=k(s,a.width);q=k(q,a.height);o=k(o,a.height);f.setRect(p.floatVal,q.floatVal,s.floatVal,o.floatVal);d(p.pxVal,q.pxVal,s.pxVal,o.pxVal)};this.setSourceDimension=function(o,p){a.width=o;a.height=p;j()};this.getSourceDimension=function(){return{width:a.width,height:a.height}};this.isCropped=function(){return i};this.getImageRect=function(){return g.duplicateRect()};this.getFloatValues=function(){return f.duplicateRect()};this.getFloatRect=function(){var o=f.duplicateRect();o.right=1-o.right;o.bottom=1-o.bottom;return o};this.getCropMargins=function(){return c.duplicateRect()};var j=function(){if(l!=undefined){n.setCropRect(l.l,l.t,l.r,l.b)}else{if(b!=undefined){n.setCropValues(b.l,b.t,b.r,b.b)}else{d(0,0,0,0);f.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(o,t,p,r){var s=g.width();var q=g.height();o=Math.max(0,Math.min(s,o));t=Math.max(0,Math.min(q,t));p=Math.max(0,Math.min(s-o,p));r=Math.max(0,Math.min(q-t,r));o+=g.left;t+=g.top;return new $FSI.Rect(o,t,p,r)};this.getPixelRangeRectByRefWidth=function(o){};this.getPixelRangeRect=function(p,s,u,t,z,q){var o,v;if(p==undefined&&s==undefined){p=g.width();s=g.height();v=1}else{if(p!=undefined){v=g.width()/p;if(s==undefined){s=g.height()/v}}else{v=g.height()/s;if(p==undefined){p=g.width()/v}}}if(u==undefined){u=t=0;z=p;q=s}if(!i){o=new $FSI.Rect(u,t,z,q);o._refWidth=p;o._refHeight=s}else{p*=v;s*=v;var r=new $FSI.Rect(u,t,z,q);r.scaleRect(v);o=n.getOffsettedPixelRangeRect(r.left,r.top,r.right,r.bottom);o.scaleRectInt(1/v);p+=c.left+c.right;s+=c.top+c.bottom;p/=v;s/=v;o._refWidth=Math.round(p);o._refHeight=Math.round(s);o.right=Math.min(o._refWidth-o.left,o.right);o.bottom=Math.min(o._refHeight-o.top,o.bottom)}return o};this.getPixelRangeParameters=function(v,s,o,u,p,r){var q;var t=n.getPixelRangeRect(v,s,o,u,p,r);if(t.left==0&&t.top==0&&t.width()==t._refWidth&&t.height()==t._refHeight){q="&width="+t._refWidth}else{q="&pixelRange="+t.left+","+t.top+","+t.right+","+t.bottom+"&referenceWidth="+t._refWidth+"&referenceHeight="+t._refHeight}return q};this.getPixelRangeParametersByCalculatedResult=function(p){var o;if(p.left==0&&p.top==0&&p.width()==p._refWidth&&p.height()==p._refHeight){o="&width="+p._refWidth}else{o="&pixelRange="+p.left+","+p.top+","+p.right+","+p.bottom+"&referenceWidth="+p._refWidth+"&referenceHeight="+p._refHeight}return o}};$FSI.Sprite=function(g,d,q,l,p,j){var k=this;var a=0.075;var b;var c=true;var r;var f;var s=1;var i=k.margin={left:0,top:0,right:0,bottom:0};var o={};o.width=d;o.height=q;var m=(p)?"canvas":"div";var b=k.element=document.createElement(m);b.setAttribute("draggable","false");var e="";switch(j){case"inline":break;default:e+="position:absolute;z-index:"+l}$FSI.setStyleAttr(b,e);if(p){k.canvas=k.element;k.canvas.setAttribute("crossorigin","anonymous");k.canvas.setAttribute("width",o.width);k.canvas.setAttribute("height",o.height);k.ctx=k.canvas.getContext("2d")}g.appendChild(b);this.remove=function(){$FSI.removeChild(g,b)};this.setPos=function(h,t){k.x=h;k.y=t;b.style.marginLeft=h+"px";b.style.marginTop=t+"px"};this.isVisible=function(){return(s>0)?true:false};this.show=function(h,t){if(c==h){return}c=h;if(!t){s=(h)?1:0;b.style.display=(h)?"block":"none"}else{if(f!=undefined){cancelAnimationFrame(f);f=undefined}r=(h)?a:-a;if(h){b.style.display="block"}n()}};this.updateMargins=function(){i=k.margin=$FSI.getElementMargins(b)};this.getClientDim=function(){var h=$FSI.getElementClientDim(k.element);return h};this.updateDimension=function(){o=$FSI.getElementClientDim(b)};this.width=function(){return o.width};this.height=function(){return o.height};var n=function(){s+=r;if(r>0){if(s>=1){s=1;f=undefined}else{f=requestAnimationFrame(n)}}else{if(s<=0){s=0;f=undefined;b.style.display="none"}else{f=requestAnimationFrame(n)}}b.style.opacity=s};if(!p){this.setSize=function(t,u){o.width=t;o.height=u;if(typeof(t)!="string"){t+="px"}if(typeof(u)!="string"){u+="px"}k.element.style.width=t;k.element.style.height=u};this.clear=function(){}}else{this.setSize=function(t,u){o.width=t;o.height=u;k.canvas.width=t;k.canvas.height=u};this.clear=function(){k.ctx.clearRect(0,0,o.width,o.height)}}};$FSI.ToolTip=function(a){var o=this;var l;var f;var b;var j;var h;var i=false;var c={};var e=false;var g;var n=function(){l=document.createElement("div");$FSI.setStyleAttr(l,"display:inline-block;position:relative;max-width:400px;z-index:1000;");f=document.createElement("div");$FSI.addClass(f,"fsi-ui-tool-tip");l.appendChild(f);b=document.createElement("div");$FSI.setStyleAttr(b,"position:relative;");$FSI.addClass(b,"fsi-ui-tool-tip-arrow");l.appendChild(b)};var k=this.destroy=function(){o.hide();clearTimeout(h)};this.setContent=function(p){g=p};this.show=function(r,q,p,u,t){if(!g){return}c.strTip=r;c.elSrc=q;c.x=p;c.y=u;c.fnGetToolTipText=t;clearTimeout(j);var s=(i)?100:1000;j=setTimeout(d,s)};var d=function(){clearTimeout(j);var r=c.strTip;var s;if(c.fnGetToolTipText!=undefined){s=c.fnGetToolTipText(r,g);if(s==undefined){s=g[r]}}else{s=g[r]}if(s!=undefined){r=s}else{r="<b>"+r+"</b>"}f.innerHTML=r;a.appendChild(l);b.style.left="12px";b.style.left=(l.offsetWidth/2-7.5)+"px";var p=c.x;if(p==undefined){p=0}var u=c.y;if(u==undefined){u=0}if(c.elSrc!=undefined){var t=$FSI.getElementPosition(a);var q=$FSI.getElementPosition(c.elSrc);p+=q.left-t.left+(q.right-q.left)/2;u+=q.top-t.top}l.style.left=(p-l.offsetWidth/2)+"px";l.style.top=(u-l.offsetHeight-2)+"px";e=true;i=true;clearTimeout(h);h=setTimeout(m,1000)};var m=function(){i=false};this.hide=function(){clearTimeout(j);if(e){$FSI.removeChild(a,l);e=false}};n()};$FSI.FullScreen={};$FSI.FullScreen.__initDone=false;$FSI.FullScreen.__init=function(){var b=$FSI.FullScreen;if(b.__initDone){return}b.__initDone=true;var a=0;if(document.exitFullscreen){a=0}else{if(document.msExitFullscreen){a=1}else{if(document.mozCancelFullScreen){a=2}else{if(document.webkitExitFullscreen){a=3}}}}switch(a){case 1:b.requestFullscreen="msRequestFullscreen";b.exitFullscreen="msExitFullscreen";b.fullscreenPsudoClass=":-ms-fullscreen";b.fullscreenChange="MSFullscreenChange";b.fullscreenError="MSFullscreenError";b.fullScreen="msFullscreenElement";b.fullscreenElement="msFullscreenElement";break;case 2:b.requestFullscreen="mozRequestFullScreen";b.exitFullscreen="mozCancelFullScreen";b.fullscreenPsudoClass=":-moz-full-screen";b.fullscreenChange="mozfullscreenchange";b.fullscreenError="mozfullscreenerror";b.fullScreen="mozFullScreen";b.fullscreenElement="mozFullscreenElement";break;case 3:b.requestFullscreen="webkitRequestFullscreen";b.exitFullscreen="webkitExitFullscreen";b.fullscreenPsudoClass=":-webkit-full-screen";b.fullscreenChange="webkitfullscreenchange";b.fullscreenError="webkitfullscreenerror";b.fullScreen="webkitIsFullScreen";b.fullscreenElement="webkitFullscreenElement";break;default:b.requestFullscreen="requestFullscreen";b.exitFullscreen="exitFullscreen";b.fullscreenPsudoClass=":fullscreen";b.fullscreenChange="fullscreenChange";b.fullscreenError="fullscreenError";b.fullScreen="fullScreen";b.fullscreenElement="fullscreenElement"}b.nMode=a};$FSI.FullScreen.start=function(a){$FSI.FullScreen.__init();$FSI.FullScreen.quit();a[$FSI.FullScreen.requestFullscreen]()};$FSI.FullScreen.quit=function(){$FSI.FullScreen.__init();document[$FSI.FullScreen.exitFullscreen]()};$FSI.FullScreen.toggle=function(a){if($FSI.FullScreen.getEnabled()){$FSI.FullScreen.quit()}else{$FSI.FullScreen.start(a)}};$FSI.FullScreen.getFullscreenPseudoClass=function(){$FSI.FullScreen.__init();return $FSI.FullScreen.fullscreenPsudoClass};$FSI.FullScreen.addChangeEvents=function(b,c,a){if(!b){return}$FSI.FullScreen.__init();if(typeof(c)=="function"){$FSI.addEvent(window,$FSI.FullScreen.fullscreenChange,c)}if(typeof(a)=="function"){$FSI.addEvent(window,$FSI.FullScreen.fullscreenError,a)}};$FSI.FullScreen.removeChangeEvents=function(b,c,a){if(!b){return}$FSI.FullScreen.__init();if(typeof(c)=="function"){$FSI.removeEvent(window,$FSI.FullScreen.fullscreenChange,c)}if(typeof(a)=="function"){$FSI.removeEvent(window,$FSI.FullScreen.fullscreenError,a)}};$FSI.FullScreen.getAvailable=function(b){$FSI.FullScreen.__init();var a=b[$FSI.FullScreen.requestFullscreen];return(!a)?false:true};$FSI.FullScreen.getEnabled=function(){$FSI.FullScreen.__init();var a=$FSI.FullScreen.getElement();return(!a)?false:true};$FSI.FullScreen.getElement=function(){$FSI.FullScreen.__init();return document[$FSI.FullScreen.fullscreenElement]};$FSI.Easing={easeInQuad:function(e,f,a,g){return g*(e/=f)*e+a},easeOutQuad:function(e,f,a,g){return -g*(e/=f)*(e-2)+a},easeInOutQuad:function(e,f,a,g){if((e/=f/2)<1){return g/2*e*e+a}return -g/2*((--e)*(e-2)-1)+a},easeInCubic:function(e,f,a,g){return g*(e/=f)*e*e+a},easeOutCubic:function(e,f,a,g){return g*((e=e/f-1)*e*e+1)+a},easeInOutCubic:function(e,f,a,g){if((e/=f/2)<1){return g/2*e*e*e+a}return g/2*((e-=2)*e*e+2)+a},easeInQuart:function(e,f,a,g){return g*(e/=f)*e*e*e+a},easeOutQuart:function(e,f,a,g){return -g*((e=e/f-1)*e*e*e-1)+a},easeInOutQuart:function(e,f,a,g){if((e/=f/2)<1){return g/2*e*e*e*e+a}return -g/2*((e-=2)*e*e*e-2)+a},easeInQuint:function(e,f,a,g){return g*(e/=f)*e*e*e*e+a},easeOutQuint:function(e,f,a,g){return g*((e=e/f-1)*e*e*e*e+1)+a},easeInOutQuint:function(e,f,a,g){if((e/=f/2)<1){return g/2*e*e*e*e*e+a}return g/2*((e-=2)*e*e*e*e+2)+a},easeInSine:function(e,f,a,g){return -g*Math.cos(e/f*(Math.PI/2))+g+a},easeOutSine:function(e,f,a,g){return g*Math.sin(e/f*(Math.PI/2))+a},easeInOutSine:function(e,f,a,g){return -g/2*(Math.cos(Math.PI*e/f)-1)+a},easeInExpo:function(e,f,a,g){return(e==0)?a:g*Math.pow(2,10*(e/f-1))+a},easeOutExpo:function(e,f,a,g){return(e==f)?a+g:g*(-Math.pow(2,-10*e/f)+1)+a},easeInOutExpo:function(e,f,a,g){if(e==0){return a}if(e==f){return a+g}if((e/=f/2)<1){return g/2*Math.pow(2,10*(e-1))+a}return g/2*(-Math.pow(2,-10*--e)+2)+a},easeInCirc:function(e,f,a,g){return -g*(Math.sqrt(1-(e/=f)*e)-1)+a},easeOutCirc:function(e,f,a,g){return g*Math.sqrt(1-(e=e/f-1)*e)+a},easeInOutCirc:function(e,f,a,g){if((e/=f/2)<1){return -g/2*(Math.sqrt(1-e*e)-1)+a}return g/2*(Math.sqrt(1-(e-=2)*e)+1)+a},easeInElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j)==1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){var h=1.70158;var i=0;var f=k;if(g==0){return e}if((g/=j/2)==2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;var h=i/4}else{var h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(e,g,a,h,f){if(f==undefined){f=1.70158}return h*(e/=g)*e*((f+1)*e-f)+a},easeOutBack:function(e,g,a,h,f){if(f==undefined){f=1.70158}return h*((e=e/g-1)*e*((f+1)*e+f)+1)+a},easeInOutBack:function(e,g,a,h,f){if(f==undefined){f=1.70158}if((e/=g/2)<1){return h/2*(e*e*(((f*=(1.525))+1)*e-f))+a}return h/2*((e-=2)*e*(((f*=(1.525))+1)*e+f)+2)+a},easeInBounce:function(e,f,a,g){return g-jQuery.easing.easeOutBounce(x,f-e,0,g,f)+a},easeOutBounce:function(e,f,a,g){if((e/=f)<(1/2.75)){return g*(7.5625*e*e)+a}else{if(e<(2/2.75)){return g*(7.5625*(e-=(1.5/2.75))*e+0.75)+a}else{if(e<(2.5/2.75)){return g*(7.5625*(e-=(2.25/2.75))*e+0.9375)+a}else{return g*(7.5625*(e-=(2.625/2.75))*e+0.984375)+a}}}},easeInOutBounce:function(e,f,a,g){if(e<f/2){return jQuery.easing.easeInBounce(x,e*2,0,g,f)*0.5+a}return jQuery.easing.easeOutBounce(x,e*2-f,0,g,f)*0.5+g*0.5+a}};$FSI.TouchHandler=function(j,aR,ah,c,aL){var aB=this;var aI=false;var ag=true;var l=false;var aP=false;var aH=false;var az,B,g,Z;var aA,V,aF;var e=false;var aa;var n;var aU={};var an=[];var Y=0;var F=window;var o;var aQ;var b;var aT=[];var aN={x:0,y:0};var r={x:0,y:0};var ao=40;var k={};k.enabled=false;k.factor=5;k.fEndDiff=1;var av={};av.enabled=false;av.minFrames=14;av.factorAmount=23;av.factorFrames=2.6;av.offsetFrames=5;var aw;var aE,s,i;var C;var ap={};var U;var aK=false;var v=false;var ai={};ai.name="none";var K;var T;var W={};if(!aR||typeof(aR)!="object"){aR={}}var ak=function(){if(aI){aB.destroy()}aQ=w;o=undefined;if($FSI.topWindow!=window){o=$FSI.topWindow;try{var aZ=$FSI.getWindowOffset(window);if(aZ.x!=undefined&&aZ.y!=undefined){aQ=am}}catch(aY){aQ=w;o=undefined}}else{o=undefined}C=aR.oPassTrough;if(aR.getPageCoords){n=aC}else{n=J}if(aR.afterTouch){for(var a0 in aR.afterTouch){av[a0]=aR.afterTouch[a0]}}if(av.fnStartStopAfterTouch&&typeof(av.fnStartStopAfterTouch)!="function"){av.fnStartStopAfterTouch=undefined}if(av.fnStartStopAfterTouch){av.useAnimationFrame=undefined}if(typeof(av.modifyTarget)!="function"){av.modifyTarget=undefined}if(typeof(av.fnGetAfterTouchEnabled)=="function"){aw=av.fnGetAfterTouchEnabled}else{aw=undefined}if(aR.smoothing){for(var a0 in aR.smoothing){k[a0]=aR.smoothing[a0]}}if(aR.detectClick==true){U=true}if(aR.preventSelection!==false){aR.preventSelection=true}if(!j){return}if(typeof(j.join)!="function"){j=[j]}if(typeof(ah)!="function"){ah=w}if(typeof(c)!="function"){c=w}if(typeof(aL)!="function"){aL=w}if(typeof(aR.onPinchChange)=="function"){K=aR.onPinchChange}else{K=undefined}aK=aR.detectGestures;aT=[];au(true,aK);for(var aX=0;aX<j.length;aX++){var aW=j[aX];if(aW&&typeof(aW.nodeName)!="undefined"){var a0={};a0.element=aW;aT.push(a0);$FSI.addEvent(aW,"mousedown",O);if($FSI.isTouch){al(aW,O);try{if(aW.style!=undefined){if($FSI.BrowserSupports.cssTouchAction()){if(ap.cssTouchAction!=undefined){m(aW,ap.cssTouchAction)}}}}catch(aY){}}}}};var P=this.enable=function(aW){if(ag==aW){return}if(!aW){N();ad(false,false)}else{ad(ap.captureScrollUser,ap.capturePinchUser)}ag=aW};this.getEnabled=function(){return ag};this.cancel=function(){M();ac();aG();N()};var aG=function(){if(k.enabled){f()}y()};this.cancelAfterTouch=function(){y()};this.getInitialDownEvent=function(){return T};var N=function(){if(!l){return}aG();l=false;T=undefined;v=false;a();aU={};an=[];Y=0};this.destroy=function(){aB.cancel();var aW;for(var aX=0;aX<aT.length;aX++){var aY=aT[aX];aW=aY.element;$FSI.removeEvent(aW,"mousedown",O);t(aW,O)}ap={}};var ay=function(aX){if(!aX||!aX.style){return}var aW=aX.style.touchAction;if(aW==undefined){aW=aX.style.msTouchAction}return aW};var m=function(aW,aX){if(!$FSI.BrowserSupports.cssTouchAction()||!aW||!aW.style){return}aW.style.touchAction=aW.style.msTouchAction=aX};var aj=function(aX){for(var aW=0;aW<aT.length;aW++){al(aT[aW].element,aX)}};var D=function(aX){for(var aW=0;aW<aT.length;aW++){t(aT[aW].element,aX)}};var al=function(aX,aW){$FSI.addEvent(aX,"touchstart",aW);$FSI.addEvent(aX,"MSPointerDown",aW);$FSI.addEvent(aX,"pointerdown",aW);$FSI.addEvent(aX,"MSHoldVisual",$FSI.preventDefaultEvent)};var t=function(aX,aW){$FSI.removeEvent(aX,"touchstart",aW);$FSI.removeEvent(aX,"MSPointerDown",aW);$FSI.removeEvent(aX,"pointerdown",aW);$FSI.removeEvent(aX,"MSHoldVisual",$FSI.preventDefaultEvent)};var w=function(){return true};var aM=function(aW){if(aH){S(aW,aW.pointerId)}else{var aX=aW.changedTouches;for(var aY=0;aY<aX.length;aY++){S(aX[aY],aX[aY].identifier)}}};var S=function(aW,aY){if(aY==undefined||aU[aY]!=undefined){if(aR.debug){if(aY==undefined){$FSI.console.error("doRegisterPointer: no pointerId")}if(aU[aY]!=undefined){$FSI.console.error("doRegisterPointer: pointerId already registered: "+aY)}}return}Y++;var aX=aU[aY]={};aX.identifier=aY;n(aX,aW);an.push(aX)};var af=function(aW){var aY=false;if(aH){aY=H(aW.pointerId)}else{var aX=aW.changedTouches;if(aX){for(var aZ=0;aZ<aX.length;aZ++){aY=H(aX[aZ].identifier)}}}if(aY){an=new Array(Y);var a1=0;for(var a0 in aU){an[a1++]=aU[a0]}}};var H=function(aW){if(aW==undefined||aU[aW]==undefined){if(aR.debug){if(aW==undefined){$FSI.console.error("doUnregisterPointer: no pointerId")}if(aU[aW]==undefined){$FSI.console.error("doUnregisterPointer: pointerId not registered: "+aW)}}return false}delete aU[aW];Y--;return true};var J=function(aX,aW){aX.x=aW.clientX;aX.y=aW.clientY};var aC=function(aX,aW){aX.x=aW.pageX;aX.y=aW.pageY};var p=function(aW){var aX=aW.changedTouches;if(aX){for(var aZ=0;aZ<aX.length;aZ++){var aY=aU[aX[aZ].identifier];if(aY){n(aY,aX[aZ])}}}if(an.length>0){aN.x=an[0].x;aN.y=an[0].y}};var at=function(aW){var aX=aU[aW.pointerId];if(aX){n(aX,aW)}if(an.length>0){aN.x=an[0].x;aN.y=an[0].y;aQ(aW,aN)}};var R=function(aW){n(aN,aW);aQ(aW,aN)};this.getMousePositionPage=function(aX){var aW={};aC(aW,aX);aQ(aX,aW);return aW};this.getMousePositionClient=function(aX){var aW={};J(aW,aX);aQ(aX,aW);return aW};var q=function(aW,aX){if(window!=aW.view){var aY=$FSI.getWindowOffset(window);aX.x-=aY.x;aX.y-=aY.y}};var am=function(aW){try{q(aW);aQ=q}catch(aX){aQ=w}};var ax=function(aW){if(!ag){return}var aY=Y;if(v&&aY==0){v=false}var aZ=aW.type;if(l||ai.started){if(aZ!=az){if(ai.started){M();ac()}else{aW._FSI_Canceled=true;aV(aW,true)}}}az=aZ;b=false;var aX=true;switch(aZ){case"touchstart":aP=true;aH=false;aa=p;g="touchmove";B="touchend";Z="touchcancel";aE=false;break;case"MSPointerDown":aa=at;aP=true;aH=true;g="MSPointerDown";B="MSPointerUp";Z="MSPointerCancel";aE=false;b=true;break;case"pointerdown":aa=at;aP=true;aH=true;g="pointermove";B="pointerup";Z="pointercancel";aE=true;b=true;break;default:aP=false;aH=false;if(aR.preventSelection){aE=true}else{aE=false}aX=false;aa=R;g="mousemove";B="mouseup";Z=undefined;b=true}if(aP&&aX){aM(aW)}aa(aW);if(aE&&aW.preventDefault){aW.preventDefault()}if(Y>1){W.bClick=false}s=false;if(aX&&ae(aW)){if(aY==0){y();A()}return false}return true};var O=function(aW){if(!ax(aW)){return}if(l||aW.which>1){return}d(aW)};this.getCurrentPos=function(){return r};var d=function(aW){aG();if(l){return}av.evtMove=undefined;if(k.enabled){r={x:aN.x,y:aN.y}}else{r=aN}W.x=aN.x;W.y=aN.y;var aX=T;T=aW;if(!ah.call(F,aW,r,C)){T=aX;return false}l=true;if(U&&!v){W.bClick=true;W.clickRadiusX=W.clickRadiusY=0}else{W.bClick=false}A();if(av.enabled){av.x=av.y=0;av.lastX=aN.x;av.lastY=aN.y;if(av.nInterval){clearInterval(av.nInterval)}av.nInterval=setInterval(X,30)}return true};var a=function(){if(e&&V!=undefined){e=false;$FSI.removeEvent(window,V,ab);$FSI.removeEvent(window,aA,aV);if(b&&o){try{$FSI.removeEvent(o,V,ab);$FSI.removeEvent(o,aA,aV)}catch(aW){}}if(aF!=undefined){$FSI.removeEvent(window,aF,aq)}V=aA=aF=undefined}};var A=function(){if(e){a()}e=true;V=g;aA=B;aF=Z;$FSI.addEvent(window,V,ab);$FSI.addEvent(window,aA,aV);if(b&&o){try{$FSI.addEvent(o,V,ab);$FSI.addEvent(o,aA,aV)}catch(aW){}}if(Z!=undefined){$FSI.addEvent(window,aF,aq)}};var ab=function(aW){aa(aW);aW.FSI_start_x=W.x;aW.FSI_start_y=W.y;if(av.enabled&&av.evtMove==undefined){av.evtMove=aW}if(l){if(W.bClick){W.clickRadiusX=Math.max(W.clickRadiusX,Math.abs(aN.x-W.x));if(W.clickRadiusX>10){W.bClick=false}else{W.clickRadiusY=Math.max(W.clickRadiusY,Math.abs(aN.y-W.y));if(W.clickRadiusY>10){W.bClick=false}}}if(k.enabled){k.evt=aW;aS()}else{c.call(F,aW,r,C)}}else{if(ai.started){if(ai.nType==1){ar(aW)}}}if(s&&!aW.FSI_allowEventDefault){aW.preventDefault()}};var ar=function(aW){var aX=h();if(!K){return}aW._FSI_PinchDeltaStart=ai.nPinchDistance-ai.pinchDistanceStart;aW._FSI_PinchDeltaRelative=ai.nPinchDistance-ai.pinchDistanceLast;aW._FSI_PinchScale=Math.max(ao,ai.pinchDistanceLast)/ai.pinchDistanceStartMaxed;ai.pinchDistanceLast=ai.nPinchDistance;aW._FSI_PinchDistance=aX;K.call(F,aW,aN,C)};var aq=function(aW){if(aP){af(aW);if(Y<1){if(l){aW._FSI_Canceled=true;aV(aW,true);return}else{N();return}}}aa(aW);ae(aW)};var aV=function(aW,aX){if(aX){aW._FSI_Canceled=true}if(aP){af(aW)}aa(aW);if(!aX&&ae(aW)){return}aG();if(!aX){if(!l||Y>0){return}}aW.FSI_start_x=W.x;aW.FSI_start_y=W.y;var aY=false;if(!aX&&av.enabled){if(aw==undefined||aw()){aY=Q(aW)}}if(aY){N();u(aW)}else{if(U){aW._FSI_Click=W.bClick}aL.call(F,aW,r,C);N()}if(aW.preventDefault){aW.preventDefault()}};var aJ=function(aW){return Y};var E=function(aW){return an};var aS=function(){if(k.animationFrame!=undefined){return}aO()};var f=function(){if(k.animationFrame==undefined){return}cancelAnimationFrame(k.animationFrame);k.animationFrame=undefined};var aO=function(){var aW=Math.abs(r.x-aN.x)+Math.abs(r.y-aN.y);if(aW>k.fEndDiff){r.x+=(aN.x-r.x)/k.factor;r.y+=(aN.y-r.y)/k.factor;k.animationFrame=requestAnimationFrame(aO)}else{r.x=aN.x;r.y=aN.y;k.animationFrame=undefined}c.call(F,k.evt,r,C)};var Q=function(aW){if(!av.enabled){return false}if(av.running){y()}av.pos=0;var aY=av.factorAmount;av.startX=r.x;av.startY=r.y;var aX={};aX.x=av.startX+aY*av.x;aX.y=av.startY+aY*av.y;if(av.roundTargetPos){aX.x=Math.round(aX.x);aX.y=Math.round(aX.y)}if(av.modifyTarget){aX=av.modifyTarget.call(F,aX,C)}av.amountX=aX.x-av.startX;av.amountY=aX.y-av.startY;aY=av.factorFrames/100;av.frames=av.offsetFrames+Math.round(aY*Math.abs(av.amountX)+aY*Math.abs(av.amountY));if(av.frames<av.minFrames){return false}return true};this.isAfterTouchRunning=function(){return av.running};var u=function(aW){if(typeof(aR.onAfterTouchStart)=="function"){aR.onAfterTouchStart.call(F,aW,r,C)}av.running=true;av.evtUp=aW;if(av.fnStartStopAfterTouch){av.fnStartStopAfterTouch.call(F,true,av.evtMove,C)}else{if(av.useAnimationFrame){av.animationFrameRun=requestAnimationFrame(G)}else{av.intervalRun=setInterval(G,16)}}return true};var aD=function(aX,aW,aZ,aY){return aZ*((aX=aX/aY-1)*aX*aX+1)+aW};var G=this.runAfterTouch=function(){var aW=false;av.pos++;r.x=aD(av.pos,av.startX,av.amountX,av.frames);r.y=aD(av.pos,av.startY,av.amountY,av.frames);c.call(F,av.evtMove,r,C);if(av.pos==av.frames){y(true)}else{if(av.useAnimationFrame){av.animationFrameRun=requestAnimationFrame(G)}aW=true}return aW};this.enableAfterTouch=function(aW){if(av.enabled==aW){return}if(!aW){y()}av.enabled=aW};var y=function(aW){if(!av.running){return}if(av.fnStartStopAfterTouch){av.fnStartStopAfterTouch.call(F,false,av.evtMove,C)}else{if(av.useAnimationFrame){if(av.animationFrameRun){cancelAnimationFrame(av.animationFrameRun)}}else{if(av.intervalRun){clearInterval(av.intervalRun);av.intervalRun=undefined}}}if(typeof(av.onAfterTouchEnd)=="function"){av.onAfterTouchEnd.call(F,av.evtMove,C)}av.evtMove=undefined;av.running=false;av.evtUp._FSI_Canceled=(aW!==true);av.evtUp._FSI_fromAfterTouch=true;aL.call(F,av.evtUp,r,C)};var X=function(){av.x=(2*av.x+aN.x-av.lastX)/5;av.y=(2*av.y+aN.y-av.lastY)/5;av.lastX=aN.x;av.lastY=aN.y};var au=this.setCapture=function(aW,aY){var aX=ad(aW,aY);if(aX){ap.captureScrollUser=aW;ap.capturePinchUser=aY}return aX};var ad=function(aW,aY){var aX=0;if(aW){aX+=2}if(aY){aX+=4}if(aX==ap.nCheck){return}ap.nCheck=aX;ap.captureScroll=aW;ap.capturePinch=aY;if($FSI.BrowserSupports.cssTouchAction()){L(aW,aY)}return true};var L=function(aW,a0){var aZ;switch(ap.nCheck){case 0:aZ="auto";break;case 2:aZ="pinch-zoom double-tap-zoom ";break;case 4:aZ="pan-x pan-y double-tap-zoom";break;default:aZ="double-tap-zoom"}ap.cssTouchAction=aZ;for(var aY=0;aY<j.length;aY++){var aX=j[aY];m(aX,ap.cssTouchAction)}};var h=function(){if(an.length<1){return 0}var aX=Math.abs(an[1].x-an[0].x);var aW=Math.abs(an[1].y-an[0].y);var aY=ai.nPinchDistance=Math.sqrt(aX*aX+aW*aW);return aY};var ae=function(aW){s=false;if(!ag){return}var aX=an.length;if(!aK){s=(aX==1&&ap.captureScroll);return}if(ai.pointerCount!=aX){M(aW);if(aX>1){ac();ai.nPointers=aX;switch(aX){case 2:ai.started=true;ai.name="pinch";ai.nType=1;if(typeof(aR.onPinchStart)=="function"){I(aW);ai.nPinchDistance=0;ai.nPinchDistance=h();ai.pinchDistanceStart=ai.pinchDistanceLast=ai.nPinchDistance;ai.pinchDistanceStartMaxed=Math.max(ao,ai.pinchDistanceStart);aW._FSI_PinchDistance=ai.nPinchDistance;aR.onPinchStart.call(F,aW,aN,C)}break;default:ai.started=true;ai.name="unknown";ai.nType=-1}if(ai.started){v=true;if(l){aG();l=false;aW._FSI_Canceled=true;aL.call(F,aW,r,C)}if(typeof(aR.onGestureStart)=="function"){I(aW);aR.onGestureStart.call(F,aW,aN,C)}}}else{if(aX<1){ac()}}ai.pointerCount=aX;s=false;if(aX==1){if(ap.captureScroll){s=true}}else{if(ap.capturePinch&&ai.nType==1){s=true}}}return ai.started};var ac=function(){if(!ai.timeoutRestartDown){return}clearTimeout(ai.timeoutRestartDown);ai.timeoutRestartDown=undefined};var z=function(){if(Y!=1){return}d(T);ac()};var I=function(aW){aW._FSI_Gesture=ai.name;aW._FSI_GestureType=ai.nType;aW._FSI_PointerCount=ai.nPointers};var M=function(aW){if(!ai.started){return}ai.started=false;if(!aW){aW={}}if(ai.nType==1&&typeof(aR.onPinchEnd)=="function"){I(aW);aW._FSI_PinchDistance=ai.nPinchDistance;aR.onPinchEnd.call(F,aW,aN,C)}if(typeof(aR.onGestureEnd)=="function"){I(aW);aR.onGestureEnd.call(F,aW,aN,C)}ai.name="none";ai.nType=0;if(aW&&Y==1){ac();ai.timeoutRestartDown=setTimeout(z,20)}};ak()};$FSI.LoaderCSSSkin=function(){var i=this;var b=0;var d={};var c=0;var e=new $FSI.CORSLoader();var a=function(k){var j=false;try{if(k.cssRules!=undefined){j=k.cssRules}else{j=k.rules}}catch(l){console.error(l.message)}return j};var f=function(l,o,n,p){var k=this;var j;this.uniqueID=c++;this.bReleased=false;this.getSkinName=function(){return o.getSkinName()};this.callReadyDelayed=function(q,r,s){j=setTimeout(function(){k.callReady(q,r,s)},1)};this.callReady=function(q,r,s){m();if(this.bReleased){return}n.call(p,q,r,s)};var m=function(){if(j!=undefined){clearTimeout(j);j=undefined}};this.remove=function(){m();if(k.bReleased){return}o.removeWaiter(k.uniqueID);this.bReleased=true}};var h=function(j,l){var k=this;this.sheet=l;this.skinName=j;var m;var n=function(){m=k.rulesReg={};var q=a(l);if(typeof(q)!="object"||q.length<1){return}for(var o=0;o<q.length;o++){var p=q[o];if(typeof(p.selectorText)=="string"){m[p.selectorText]=p.style}}};this.getStyle=function(o,r,q){if(m==undefined){n()}var p=undefined;if(m[o]!=undefined){p=m[o][r];if(r=="content"){p=p.replace(/^["']/,"");p=p.replace(/["']$/,"");p=$FSI.trim(p);p=p.replace(/\\"/g,'"')}if(q){p=p.replace(/^[^{]*/g,"");p=p.replace(/[^}]*$/g,"");if(p.length>0){try{p=$FSI.JSON.parse(p)}catch(s){$FSI.console.error("ERROR parsing JSON from CSS selector '"+o+"' property '"+r+"'.");$FSI.console.error(s.message)}}else{p={}}}}if(q&&p==undefined){p={}}return p}};var g=function(j){var t=false;var k=0;var v={};var q=false;var r=false;var s;var o;var m;var p;m=j.match(/(.*)\/[^/]*$/);m=m[1]+"/";o=j.replace(/\.[^/]*$/,"");o=o.match(/([^/]*)$/);o=o[1].toLowerCase();var l=new h(j);this.removeWaiter=function(w){if(v[w]==undefined){return}delete v[w];k--};this.addWaiter=function(w){if(w.uniqueID==undefined){return}if(q){w.callReadyDelayed(r,l,"ALREADY LOADED")}else{if(v[w.uniqueID]==undefined){v[w.uniqueID]=w;k++;if(!t){u()}}}};this.getSkinName=function(){return o};var n=function(E,z,F,A){var D=false;if(A>299||typeof(z)!="string"){$FSI.console.error("Failed to load Skin CSS (HTTP "+A+"): "+j)}else{D=true;z=z.replace(/\/\*.*\*\//g,"");z=z.replace(/([:|,])\s*url\s*\(\s*['"]*\s*([^)'"]*)[^)]*\)/gi,function(H,J,K){var I=H;if(!K.match(/:\/\//)){I=J+'url("'+m+K+'")'}return I});s=document.createElement("style");s.setAttribute("type","text/css");s.setAttribute("x_generated_by","FSI");s.setAttribute("x_fsi_skin",o);s.appendChild(document.createTextNode(z));var C=document.head;if(!C){C=document.getElementsByTagName("head");if(C&&C.length>0){C=C[0]}}if(C&&C.firstChild){try{var y=C.firstChild;var G=C.getElementsByTagName("style");if(G.length>0){y=G[0]}C.insertBefore(s,y)}catch(B){C.appendChild(s)}}else{C.appendChild(s)}l=new h(o,s.sheet);q=true;r=D}for(var w in v){v[w].callReady(D,l,"onLoaded")}v={};k=0};var u=function(){t=true;if(typeof(j)!="string"||j.length<0){return false}e.load(j,n,"text/css");return true}};this.load=function(j,m,l){var o=false;if($FSI.versionInternetExplorer<9){o=true}if(o){$FSI.console.error("Unable to load skin: unsupported browser version.");if(l){l.call(m,false)}return false}if($FSI._FSIViewerLocation==undefined||typeof(j)!="string"||j.length<1){$FSI.console.error("Unable to load skin:");if($FSI._FSIViewerLocation==undefined){$FSI.console.error("FSI Viewer path not known")}else{$FSI.console.error("Invalid skin URL "+j)}if(l){l.call(m,false)}return false}var k=j;if(k.indexOf("http")!=0){k=$FSI._FSIViewerLocation+"/skins/"+k}if(!k.match(/\.css$/)){k+=".css"}var n;if(d[k]==undefined){b++;n=d[k]=new g(k)}else{n=d[k]}var p=new f(k,n,l,m);n.addWaiter(p);return p}};$FSI.LoaderJavascript=function(){var c={};this.load=function(f,j,l,h,k){var i=c[f];if(l==undefined){l=window}if(typeof(h)!="function"){return false}if(i==undefined){i=c[f]={};i.path=f;i.loaded=false;i.failed=false;d(i);if(!e(i)){i.failed=true;i.loaded=true;i.addNodeFailed=true}}else{if(i.oListeners[j]!=undefined){b(f,j)}}i.nListeners++;var g=i.oListeners[j]={};g.argScope=l;g.argFunction=h;g.oPassThrough=k;if(i.loaded==true){a(i)}return true};var b=this.release=function(f,h){var g=c[f];if(g==undefined){return}if(g.oListeners[h]!=undefined){delete g.oListeners[h];g.nListeners--}};var e=function(k){var g=false;try{var h=document.getElementsByTagName("head");if(h&&h.length>0){h=h[0];var i=k.node=document.createElement("script");var j=k.onLoad=function(m){if(m.type=="error"){k.failed=true;a(k)}else{k.failed=false;a(k)}k.loaded=true};$FSI.addEvent(i,"load",j);var f=k.onError=function(m){k.failed=true;a(k);k.loaded=true};$FSI.addEvent(i,"error",j);h.appendChild(i);i.src=k.path;g=true}}catch(l){}return g};var a=function(h){var f=!h.failed;$FSI.removeEvent(h.node,h.onLoad);$FSI.removeEvent(h.node,h.onError);for(var i in h.oListeners){var g=h.oListeners[i];g.argFunction.call(g.argScope,f,h.path,g.oPassThrough)}d(h)};var d=function(f){f.oListeners={};f.nListeners=0}};$FSI.AboutWindow=function(b,j){var l=this;var c;var e;var f;var d;var g;var h;var k=function(){c=document.createElement("div");$FSI.setStyleAttr(c,"position: absolute;z-index:1000;width:12em;");c.className="fsi-ui-info-window";f=document.createElement("div");f.className="fsi-ui-title";d=document.createElement("div");d.style.display="inline-block";d.innerHTML=j.title;f.appendChild(d);h=document.createElement("div");h.style.display="inline-block";h.style["float"]="right";h.style.cursor="pointer";h.innerHTML="X";f.appendChild(h);c.appendChild(f);e=document.createElement("div");e.className="fsi-ui-content";var n=j.strLongVersion;n="<h3>"+n.replace(/ build/,'</h3><span class="small">build')+"</span>";var m;if(j.strCopyright==undefined){m="<br/><br/>&copy; 2016 NeptuneLabs GmbH<br/>";m+="<hr/><span class='small'>FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany</span>"}else{j.strCopy=j.strCopyright}n+="<br/>"+m;e.innerHTML=n;c.appendChild(e);b.appendChild(c);$FSI.addEvent(c,"click",i);a()};var a=function(){var n=$FSI.getElementPosition(b);n.width=(n.right-n.left);n.height=(n.bottom-n.top);var m=$FSI.getElementPosition(c);m.width=(m.right-m.left);m.height=(m.bottom-m.top);c.style.left=Math.round(0*n.left+(n.width-m.width)/2)+"px";c.style.top=Math.round(0*n.left+(n.height-m.height)/2)+"px"};var i=this.destroy=function(){if(typeof(j.fnOnDestroy)=="function"){if(!j.fnOnDestroy.call(this)){return}}$FSI.removeEvent(c,"click",i);$FSI.removeChild(c.parentNode,c)};k()};$FSI.CustomEventListener=function(i){var k=this;var b=[];var e={};var f={};var g=0;k._strClassName="$FSI.CustomEventListener";var j=function(){if($FSI.eventFunctionID==undefined){$FSI.eventFunctionID=0}if($FSI.eventElementID==undefined){$FSI.eventElementID=0}};var h=this.destroy=function(){for(var l=0;l<b.length;l++){var m=b[l];d(m.element,m.fn)}b=[];e={};f={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;l.fn.call(l.element,m);return true};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<b.length;n++){var l=b[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};var a=this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){$FSI.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI==undefined){p.__FSI={}}if(p.__FSI.eventElementID==undefined){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=$FSI.eventElementID++}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID==undefined){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=$FSI.eventFunctionID++}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(e[m]==undefined){var l=e[m]={};l.nFunction=0;l.oFunctions={}}if(e[m].oFunctions[n]==undefined){e[m].nFunction++;e[m].oFunctions[n]=[]}else{$FSI.console.warn(k._strClassName+": There is already a listener for this exact element and function");$FSI.console.log(p);$FSI.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=g++;e[m].oFunctions[n].push(q);b.push(q);f[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(b.length);return q};this.setListenerProps=function(o,m,n){var l=f[o];if(!l){return false}if(l.props==undefined){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=f[n];if(l==undefined||l.enabled==m){return}l.enabled=m};this.pauseListener=function(n,m){var l=f[n];if(l==undefined||l.paused==m){return}l.paused=m};var d=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){$FSI.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(p.__FSI==undefined||p.__FSI.eventElementID==undefined||o.__FSIEventFunctionID==undefined){if(o.__FSIEventFunctionID==undefined){$FSI.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{$FSI.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!e[l]){$FSI.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=e[l].oFunctions[n];if(m==undefined||typeof(m.pop)!="function"){$FSI.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount==0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount==0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length==0){delete e[l].oFunctions[n];e[l].nFunction--;if(e[l].nFunction==0){delete e[l]}}delete f[q.uniqueID];c();k._onListenerRemove(q);k._onListenerCountChange(b.length);return q};this.getEventListenerByID=function(l){return f[l]};this.getListenerObjectByID=function(l){return f[l]};this.getListenersArray=function(){return b};this.getListenerCount=function(){return b.length};var c=function(){b=[];for(var m in e){var o=e[m].oFunctions;for(var n in o){var l=o[n];b=b.concat(l)}}};this.dump=function(){$FSI.console.dir(e);$FSI.console.dir(b)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()};$FSI.CustomEventListenerDocumentZoom=$FSI.oCustomEventListenerClasses.FSIDocumentZoomChange=function(){var l=this;var a=false;var d;var e;var k=0;var i=0;var c=false;var b;$FSI.CustomEventListener.prototype.constructor.call(l,"FSIDocumentZoomChange");l._strClassName="$FSI.CustomEventListenerDocumentZoom";var g=function(){if(a){return}a=true;$FSI.addEvent(window,"orientationchange",j);b=0;e=setInterval(j,50);d=$FSI.getDocumentScaleWithPixelRatio()};var f=function(){if(!a){return}a=false;$FSI.removeEvent(window,"orientationchange",j);clearInterval(e);e=undefined};this.onDestroy=function(){f()};this._onListenerCountChange=function(m){var n=(m>0);if(n!=a){if(n){g()}else{f()}}};var j=function(){var m;var n=$FSI.getDocumentScaleWithPixelRatio();if(d!=n){if(c==false){b=0;clearInterval(e);e=setInterval(j,50)}i=0;d=n;h(n);m=true}else{m=false;if(b<3){i++;if(i==20){b=1;clearInterval(e);e=setInterval(j,150)}else{if(i==40){b=2;clearInterval(e);e=setInterval(j,300)}else{if(i==50){b=3;clearInterval(e);e=setInterval(j,600)}}}}}return m};this.triggerEvent=function(o){var m=l.getEventListenerByID(o);if(!m){return}var n={};n.FSI_scale=$FSI.getDocumentScale();n.FSI_scale_with_pixel_ratio=$FSI.getDocumentScaleWithPixelRatio();l.fireEvent(m,n)};this.triggerEvents=function(){h($FSI.getDocumentScaleWithPixelRatio())};var h=function(n){var m={};m.FSI_scale=$FSI.getDocumentScale();m.FSI_scale_with_pixel_ratio=n;l.fireEvents(m)}};$FSI.CustomEventListenerViewport=$FSI.oCustomEventListenerClasses.FSIViewport=function(){var k=this;var b=false;var g=new $FSI.Rect(0,0,0,0);var h=new $FSI.Rect(0,0,0,0);var l=new $FSI.Rect(0,0,0,0);var G=new $FSI.Rect(0,0,0,0);var t={left:0,top:0};var R;var B;var C="";var c=false;var o=undefined;var y;var i=1;var n=1;var q=10;var F;var s=0;var u;var E;var Q=0;var a=100;var n=1;var z=1;var M=32;var w;var p;try{p=window.frameElement}catch(O){}$FSI.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var L=function(){if(b){return}b=true;f($FSI.addEvent);F=$FSI.addCustomEvent(k,"FSIDocumentZoomChange",H);n=$FSI.getDocumentScale();z=n*$FSI.getDevicePixelRatio()};var m=function(){if(!b){return}b=false;f($FSI.removeEvent);$FSI.removeCustomEvent(k,"FSIDocumentZoomChange",H);F=undefined;if(o){clearInterval(o);o=undefined}r();s=0;if(w!=undefined){clearTimeout(w);w=undefined}};var f=function(S){var e=window;S(e.document,"scroll",j,false);S(e,"resize",j,false);if($FSI.isTouch&&!$FSI.isIETouch&&p){S(e,"touchmove",P,false)}while(e.frameElement){e=e.parent.window;if(e){S(e.document,"scroll",j,false);if($FSI.isTouch&&!$FSI.isIETouch&&e.frameElement){S(e,"touchmove",P,false)}S(e,"resize",j,false)}}S(window,"orientationchange",j,false)};this.setListenerProps=function(U,S,T){if(typeof(S)!="string"){return false}var e=k.getListenerObjectByID(U);if(!e){return false}switch(S){case"treshold":if(e.tresholdEnd!=undefined){s--;e.tresholdEnd=undefined}if(T&&T>0){s++;e.tresholdEnd=T}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=T;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!=undefined){s--}};this._onListenerCountChange=function(e){var S=(e>0);if(S!=b){if(S){L()}else{m()}}};var H=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!=undefined){return}w=setTimeout(J,M);J()};var J=function(){if(w!=undefined){clearTimeout(w);w=undefined}var e=false;var S=K();if(C!=S){C=S;e=true;d()}return e};var I=function(){n=$FSI.getDocumentScale();z=n*$FSI.getDevicePixelRatio();K()};this.triggerEvent=function(T){var e=k.getEventListenerByID(T);if(!e){return}I();var S=N();k.fireEvent(e,S)};this.triggerEvents=function(){I();d()};var d=this.fireEvents=function(){var S=N();var T=k.getListenersArray();for(var U=0;U<T.length;U++){var e=T[U];if(!e.fireTresholdEventOnly){k.fireEvent(e,S)}}A()};var N=function(){var e={};e.FSI_scale=$FSI.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*$FSI.getDevicePixelRatio();e.FSI_viewport_rect=h;e.FSI_scroll=t;e.FSI_client_rect_body_top=R;e.FSI_viewport_size_top=B;return e};var K=function(){B=$FSI.getViewportSize($FSI.topWindow);R=$FSI.getBoundingClientRect($FSI.topWindow.document.documentElement);g.left=$FSI.topWindow.pageXOffset;g.top=$FSI.topWindow.pageYOffset;g.right=g.left+B.width;g.bottom=g.top+B.height;if(p){var e=$FSI.getViewportSize(window);var S=$FSI.getWindowOffset(window);h.left=0;h.top=0;h.right=h.left+e.width;h.bottom=h.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(h);l.left=-S.x+g.left+R.left;l.top=-S.y+g.top+R.top;l.right=l.left+B.width;l.bottom=l.top+B.height;h.interSectRectValidate(l);var T=$FSI.getBoundingClientRect(window.document.body);G.copyRect(h);G.offsetRect(S.x+T.top,S.y+T.left)}else{t.left=R.left;t.top=R.top;G.copyRect(g);h.copyRect(g);h.offsetRect(R.left,R.top)}return n+"_"+G.toString()+" "+B.width+" x "+B.height};var P=function(){y=q;if(o!=undefined){return}o=setInterval(v,100)};var v=function(){if(!J()){y--}else{y=q}if(y<1){clearInterval(o);o=undefined}};var r=function(){if(E!=undefined){clearInterval(E);E=undefined;u=undefined}};var A=function(){r();if(s>0){E=setInterval(D,a)}};var D=function(){Q+=a;if(u==undefined){Q=a;u=[];var T=k.getListenersArray();for(var U=0;U<T.length;U++){var e=T[U];if(e.tresholdEnd>0){u.push(e)}}}var S;for(var U=u.length-1;U>-1;U--){var e=u[U];if(e.tresholdEnd<=Q){if(k.getEventListenerByID(e.uniqueID)!=undefined){if(S==undefined){S=N();S.FSI_after_treshold=true}k.fireEvent(e,S)}u.splice(U,1)}}if(u.length==0){r()}}};$FSI.CustomEventListenerElementDimension=$FSI.oCustomEventListenerClasses.FSIElementDimension=function(){var k=this;var a=false;var g=25;var d;var b=0;var e={};e[0]=25;e[25]=50;e[50]=100;e[75]=250;var h=76;var c=-1;$FSI.CustomEventListener.prototype.constructor.call(k,"FSIElementDimension");k._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(l){if(l<1){clearInterval(d);d=undefined}else{if(d==undefined){d=setInterval(j,e[0])}}};this._onListenerAdd=function(l){l.__elementWidth=l.element.offsetWidth;l.__elementHeight=l.element.offsetHeight};this.setListenerProps=function(o,m,n){if(typeof(m)!="string"){return false}var l=k.getListenerObjectByID(o);if(!l){return false}switch(m){case"treshold":if(n&&n>0){l.tresholdEnd=n}break;case"fireTresholdEventOnly":l.fireTresholdEventOnly=n;break}};var j=function(){var m=k.getListenersArray();var p=false;for(var o=0;o<m.length;o++){var l=m[o];if(l.__elementWidth!=l.element.offsetWidth||l.__elementHeight!=l.element.offsetHeight){p=true;if(l.tresholdEnd){l.treshold=g}i(l,false)}else{if(l.treshold>0){l.treshold+=g;if(l.treshold>=l.tresholdEnd){i(l,true);l.treshold=0}}}}if(p){b=0;f(e[0])}else{if(b<h){b++;var n=e[b];if(n!=undefined){f(n)}}}};var f=function(l){if(l==g||d==undefined){return}g=l;clearInterval(d);d=setInterval(j,g)};var i=function(l,n){var m={};if(n){m.FSI_after_treshold=l.treshold}m.FSI_target=l.element;m.FSI_dimension_old={width:l.__elementWidth,height:l.__elementHeight};l.__elementWidth=l.element.offsetWidth;l.__elementHeight=l.element.offsetHeight;m.FSI_dimension={width:l.__elementWidth,height:l.__elementHeight};if(n||!l.fireTresholdEventOnly){k.fireEvent(l,m)}};this.triggerEvent=function(m){var l=k.getEventListenerByID(m);if(!l){return}if(l.tresholdEnd){l.treshold=1}i(l)};this.triggerEvents=function(){var l=k.getListenersArray();for(var m=0;m<l.length;m++){if(l[m].tresholdEnd){l[m].treshold=1}i(l[m])}}};$FSI.CustomEventListenerMouseWheel=$FSI.oCustomEventListenerClasses.FSIMouseWheel=function(){var a=this;var d=false;var c=100000;$FSI.CustomEventListener.prototype.constructor.call(a,"FSIMouseWheel");a._strClassName="$FSI.CustomEventListenerMouseWheel";this._onListenerAdd=function(e){e.callback=function(f){b(e,f)};$FSI.addEvent(e.element,"mousewheel",e.callback);$FSI.addEvent(e.element,"DOMMouseScroll",e.callback)};this._onListenerRemove=function(e){$FSI.removeEvent(e.element,"mousewheel",e.callback);$FSI.removeEvent(e.element,"DOMMouseScroll",e.callback)};var b=function(e,f){var g=0;if(f.detail){g=f.detail}else{if(f.wheelDelta){g=-f.wheelDelta}}if(g!=0){c=Math.min(c,Math.abs(g))}f.FSI_delta=-g;f.FSI_weighted_delta=f.FSI_delta/c;a.fireEvent(e,f)}};$FSI.NavigatorWindow=function(m,z,t,C){var h=this;var ac=m.iViewer;var r;var v;var o={};var Y=0;var k;var l,A;var e;var D,n;var f,c;var O,N;var s=false;var u=false;var q=m.getRootContainer();var I=m.getElementSpace();var J=m.getinPlaceZoom();var d=ac.getImageIsTransparent();var R=m.getDrawRatio();var p=ac.getSrcDim();var aa=m.getdrawRatioUnZoomed();var E=m.getdrawRatioUnResized();var T=m.viewport;var F;var S;var a={x:2,y:2};var b;var ab;var K=false;var V;var M;var y;var G;var X=function(){s=z.result.autoHideNav;k=[];Y=4;e=16;var ag=j(z.result.navWidth,T.width,120);var an=j(z.result.navHeight,T.height,120);var ak=Math.min(I.width-2*Y,ag);var al=Math.min(I.height-2*Y-20,an);ak=Math.max(60,ak);al=Math.max(40,al);var aj,ae;aj=ak;ae=aj/aa.imageWidth*aa.imageHeight;if(ae>al){ae=al;aj=ae/aa.imageHeight*aa.imageWidth}l=Math.max(10,Math.round(aj));A=Math.max(10,Math.round(ae));var am=l+2*Y;var ai=A+2*Y+e;D=am;n=ai;h.sprite=new $FSI.Sprite(q,am,ai,500);$FSI.addClass(h.sprite.element,"fsi-ui-nav-window");h.sprite.element.style.width=h.sprite.element.style.height="auto";if(t){b=t.navFrameBorderColor;ab=t.navFrameBackgroundColor}else{b="red";ab="rgba(255,255,255,0.5)"}var ah=h.sprite.getClientDim();h.canvasSprite=new $FSI.Sprite(h.sprite.element,l,A,2,true,"inline");h.canvasSprite.element.style.clear="both";$FSI.addClass(h.canvasSprite.element,"fsi-ui-nav-window-image");if(z.hasPlugin("zoommeter")){F=document.createElement("div");$FSI.addClass(F,"fsi-ui-nav-window-zoom-text");h.sprite.element.appendChild(F);S=document.createTextNode("100 %");F.appendChild(S);var af=z.getPluginParameter("zoommeter","color");if(af){F.style.color="#"+af}K=z.getPluginParameter("zoommeter","srcrelative",false,true)}h.sprite.updateMargins();h.sprite.updateDimension();var ad={};ad.smoothing={enabled:true,factor:7,fEndDiff:0.03};y=new $FSI.TouchHandler(h.canvasSprite.canvas,ad,P,U,Q);M=h.canvasSprite.ctx;H();if(s){h.sprite.show(false)}};var W=this.destroy=function(){if(y){y.destroy();y=undefined}$FSI.removeChild(q,h.sprite.element)};var g=this.enable=function(ad){y.enable(ad)};var j=function(ag,ae,af){var ad=parseInt(ag);if(typeof(ag)=="string"&&ag.indexOf("%")!=-1){ad=Math.max(0,Math.min(100,ad));ad=Math.round(ad*ae/100)}else{ad=parseInt(ag)}if(isNaN(ad)){ad=af}return ad};this.isDragging=function(){return u};var P=function(ae,ah){var af=$FSI.getElementPosition(h.canvasSprite.element);f=-af.left;c=-af.top;var ad=ah.x+f;var ag=ah.y+c;if(ad<0||ag<0||ad>l||ag>A){return false}u=true;m.stopDesktopAnimation();m.stopAfterTouch();w(ah,true);m.autoShowHideHotSpots(false);return true};var U=function(ad,ae){w(ae,true)};var Q=function(ad,ae){u=false;w(ae,false);m.onAfterinPlaceZoomChanged();m.autoShowHideHotSpots(true)};var w=function(ag,ae){var ad=ag.x+f-l/2;var af=ag.y+c-A/2;J.panPos.left=G*-ad;J.panPos.top=G*-af;m.updateInPlaceZoom(ae)};var L=function(au,ar,ag,ai,aj){ar=Math.max(1,Math.round(ar/2));if(ar<ai){ar=ai}ag=Math.max(1,Math.round(ag/2));if(ag<aj){ag=aj}var al,ah,ad,af,ap,at,an,ak;ah=af=document.createElement("canvas");af.setAttribute("crossorigin","anonymous");af.width=ar;af.height=ag;ap=af.getContext("2d");ap.drawImage(au,0,0,ar,ag);var ae=document.createElement("canvas");ae.setAttribute("crossorigin","anonymous");var ao=ae.getContext("2d");var am=false;while(ar>ai||ag>aj){al=ah;an=ar;ak=ag;if(am){ah=af;ad=ap;am=false}else{ah=ae;ad=ao;am=true}ar=Math.round(ar/2);if(ar<ai){ar=ai}ag=Math.round(ag/2);if(ag<aj){ag=aj}ah.width=ar;ah.height=ag;ad.drawImage(al,0,0,an,ak,0,0,ar,ag)}var av;try{av=ad.getImageData(0,0,ar,ag);V=B}catch(aq){av=ah;V=i}return av};var B=function(ae,ad,af){M.putImageData(ae,ad,af)};var i=function(ae,ad,af){M.drawImage(ae,ad,af)};var H=function(){switch(a.x){case 1:O=(I.width-h.sprite.width())/2;break;case 2:O=I.width-h.sprite.width()-h.sprite.margin.right;break;default:O=h.sprite.margin.left;break}switch(a.y){case 1:N=(I.height-h.sprite.height())/2;break;case 2:N=I.height-h.sprite.height()-h.sprite.margin.bottom-ac.getMenuHeight("navWindow");break;default:N=h.sprite.margin.top;break}h.sprite.setPos(O,N)};this.setContainerSize=function(ad,ag,af){var ae=h.sprite.element.style.display;h.sprite.element.style.display="block";h.sprite.updateDimension();R=ag;aa=af;I=ad;H();h.sprite.element.style.display=ae};var Z=this.autoShowHide=function(ad){if(!s){return}if(J.scale<1.05){h.sprite.show(false,ad)}else{h.sprite.show(true,ad)}};this.update=function(aw,ai){Z(true);if(!h.sprite.isVisible()){return}G=R.imageWidth/l;var an=M;if(k[aw]==undefined){var aq=m.getPreviewImage(aw);k[aw]=L(aq,aq.width,aq.height,l,A)}an.lineWidth=0;var ak=0;var aj=0;if(F&&r!=ai){r=ai;var ar,ad;if(K){ar=ai*E.imageWidth/p.width}else{ar=R.imageWidth/aa.imageWidth}ar=Math.round(100*10*ar)/10;ad=""+ar;if(ad.indexOf(".")==-1){ad+=".0"}ad+=" %";S.nodeValue=ad}V(k[aw],ak,aj);var av=J.scale;if(av>1.05){var am=l/E.imageWidth/av;var ag=am*T.width;var ao=am*T.height;var at=l/R.imageWidth;var al=(l-ag)/2-J.panPos.left*at;var au=(A-ao)/2-J.panPos.top*at;var af=ak+al;var ae=aj+au;var ah=ak;var ap=aj;if(ag<4||ao<4){af+=ag/2;ae+=ao/2;an.strokeStyle=b;an.strokeRect(af,ae-3,1,7);an.strokeRect(af-3,ae,7,1)}else{an.save();an.fillStyle=ab;an.beginPath();an.rect(ah,ap,l,ae-ap);an.rect(ah,ae,af-ah,ao);an.rect(af+ag,ae,l-al-ag,ao);an.rect(ah,ae+ao,l,A-au-ao);an.closePath();an.clip();an.fillRect(ak,aj,l,A);an.restore();an.save();an.strokeStyle=b;an.beginPath();an.rect(ak,aj,l,A);an.clip();an.strokeRect(af,ae,ag,ao);an.restore()}}};this.reverseImageSequence=function(){k.reverse();k.unshift(k.pop())};X()};$FSI.MenuBar=function(o,k,g){var r=this;var d=this.myViewer=o.iViewer;var s=o.getRootContainer();var E=o.getElementSpace();var j;var t;var u;var a=o.getToolTipObject();var e=this.nIconWidth=32;var B=this.nIconHeight=32;var l=[];this.bEnabled=undefined;var z=this.oButtonOffset={x:0,y:0};var m=false;var n={};var i={};var q=0;var y=0;var p="";var b="fsi-ui-button-icon";var v=function(){r.btnID=0;r.sprite=new $FSI.Sprite(s,E.width,q,450);$FSI.addClass(r.sprite.element,"fsi-ui-menu-bar");r.sprite.element.style.width="100%";r.iconClassNamesNormal=b;r.iconClassNamesHover=b+" "+b+"-hover";r.iconClassNamesActive=b+" "+b+"-active";r.iconClassNamesDisabled=b+" "+b+"-disabled";setTimeout(w,1)};var w=function(){var G=r.sprite.getClientDim();q=Math.round(G.height);r.sprite.setSize("100%",q);r.setEnabled(false);f();if(typeof(k.urlLogo)=="string"&&k.urlLogo.length>0){j=document.createElement("div");$FSI.addClass(j,"fsi-ui-viewer-logo");$FSI.setStyleAttr(j,"position:absolute");var F=document.createElement("img");F.src=k.urlLogo;j.appendChild(F);r.sprite.element.appendChild(j);$FSI.addEvent(j,"click",d.showAboutWindow)}$FSI.addEvent(r.sprite.element,"mouseup",D);$FSI.addEvent(r.sprite.element,"contextmenu",C);if(m){r.sprite.show(false,false)}g()};var A=this.destroy=function(){if(j){$FSI.removeEvent(j,"click",d.showAboutWindow)}$FSI.removeEvent(r.sprite.element,"mouseup",D);$FSI.removeEvent(r.sprite.element,"contextmenu",C);for(var F=0;F<l.length;F++){l[F].destroy()}$FSI.removeChild(s,r.sprite.element)};var D=function(F){if(F.which&&F.which==3){y=new Date().getTime()}};var C=function(G){if(y){var F=new Date().getTime()-y;if(F<300){return}}G.preventDefault&&G.preventDefault()};this.getHeight=function(){return q};var h=function(F,H){var I;if(!F||!H){return I}if(F.indexOf("_")!=-1){var G=F.split("_");switch(G[0]){case"MouseMode":I="";if(H.Mode){I+="<b>"+H.Mode+"</b>"}if(H["Mode"+G[1]]){I+=" "+H["Mode"+G[1]]}break}}return I};this.showButtonToolTip=function(F){if(!a){return}r.showToolTip(F.getCMD(),F.elButton)};this.showToolTip=function(H,G,F,I){if(!a){return}a.show(H,G,F,I,h)};this.hideToolTip=function(){if(!a){return}a.hide()};this.setEnabled=function(F,G){if(r.bEnabled==F){return}r.bEnabled=F;if(G){return}if(F){$FSI.removeClass(r.sprite.element,"fsi-ui-menu-bar-disabled")}else{$FSI.addClass(r.sprite.element,"fsi-ui-menu-bar-disabled")}};this.getButtonEnabled=function(G){var F=i[G];if(F==undefined){return}return F.bEnabled};this.enableButton=function(H,F){var G=i[H];if(G==undefined){return false}G.setEnabled(F);return true};this.getButtonPressed=function(G){var F=i[G];if(F==undefined){return false}return F.getPressed()};this.setButtonPressed=function(H,F){var G=i[H];if(G==undefined){return false}G.setPressed(F);return true};var c=function(G,H){var F;if(n[H]==undefined){F=n[H]={};F.arButtons=[]}else{F=n[H]}F.arButtons.push(G);G.oGroup=F;G.makeRadioButton()};this.removeButtons=function(F){l=[];n={};i={};f()};this.addButtons=function(H){var G;var L=q-6;var F,K;var J;if(u){u.remove()}u=new $FSI.Sprite(r.sprite.element,E.width,q,2);$FSI.setStyleAttr(u.element,"position:relative");$FSI.addClass(u.element,"fsi-ui-button-container");for(var I=0;I<H.length;I++){G=H[I];if(G.cmd){if(G.width==undefined){F=L}else{F=G.width}if(G.height==undefined){K=L}else{K=G.height}J=new $FSI.MenuBarButton(r,u.element,G.cmd,G.bCheckButton);i[G.cmd]=J;l.push(J);if(G.groupID!=undefined){c(J,G.groupID)}}if(G.enabled===false){r.enableButton(G.cmd,false)}}for(var M in n){n[M].arButtons[0].setPressed(true)}f()};var f=function(){var G=0;var F=E.height-q;r.sprite.setPos(G,F)};this.setContainerSize=function(F){var G=r.sprite.element.style.display;r.sprite.element.style.display="block";var H=$FSI.getElementClientDim(r.sprite.element);q=H.height;r.sprite.updateDimension();E=F;r.sprite.setSize("100%",q);f();r.sprite.element.style.display=G;r.sprite.show(true)};v()};$FSI.MenuBarButton=function(p,d,q,e){var n=this;var f=p;var u;this.bEnabled=true;var g;var k;this.id=f.btnID++;var b={};var i=false;var t;var a;var h="";var r=function(){t=n.elButton=document.createElement("div");$FSI.addClass(t,"fsi-ui-button");a=document.createElement("div");$FSI.addClass(a,f.iconClassNamesNormal);t.appendChild(a);d.appendChild(t);if(q.length>0){h=q.toLowerCase()}else{h==""}if(!$FSI.isMobileDevice){$FSI.addEvent(t,"mousedown",n.onMouseDown);$FSI.addEvent(t,"mouseup",n.onMouseUp);$FSI.addEvent(t,"mouseout",n.onMouseOut);$FSI.addEvent(t,"mouseover",n.onMouseOver)}if($FSI.isTouch){$FSI.addEvent(t,"touchstart",n.onTouchDown);$FSI.addEvent(t,"touchcancel",n.onTouchUp);$FSI.addEvent(t,"touchend",n.onTouchUp)}o(1)};this.destroy=function(){if(!$FSI.isMobileDevice){$FSI.removeEvent(t,"mousedown",n.onMouseDown);$FSI.removeEvent(t,"mouseup",n.onMouseUp);$FSI.removeEvent(t,"mouseout",n.onMouseOut);$FSI.removeEvent(t,"mouseover",n.onMouseOver)}if($FSI.isTouch){$FSI.removeEvent(t,"touchstart",n.onTouchDown);$FSI.removeEvent(t,"touchcancel",n.onTouchUp);$FSI.removeEvent(t,"touchend",n.onTouchUp)}};this.getCMD=function(){return q};this.makeCheckButton=function(){e=true};this.makeRadioButton=function(){e=true;i=true};this.getState=function(){return u};var o=this.setState=function(v){if(u==v){return}l(v)};var l=this.setState=function(z){u=z;var y;var A="fsi-ui-button "+h+" ";if(!n.bEnabled){A+="fsi-ui-button-disabled ";y=f.iconClassNamesDisabled}else{y=f.iconClassNamesNormal}switch(u){case 2:A+="fsi-ui-button-hover";y=f.iconClassNamesHover;break;case 3:A+="fsi-ui-button-active";y=f.iconClassNamesActive;break;case 4:A+="fsi-ui-button-active";y=f.iconClassNamesActive;if(n.oGroup!=undefined){for(var w=0;w<n.oGroup.arButtons.length;w++){var v=n.oGroup.arButtons[w];if(v.id!=n.id){v.setPressed(false)}}}break;default:break}t.className=A;a.className=y};this.onMouseOver=function(v){f.showButtonToolTip(n);if(!n.bEnabled||!f.bEnabled){return}if(u==1){o(2)}};this.onMouseOut=function(v){f.hideToolTip();if(!n.bEnabled||!f.bEnabled){return}if(u==3){n.onMouseUpOutside()}if(u!=1&&u!=4){o(1)}};this.onMouseDown=function(v){if(v.type=="mousedown"){if(v.which!=1){return true}v.cancelBubble=true;if(v.stopPropagation){v.stopPropagation()}if(v.preventDefault){v.preventDefault()}}f.hideToolTip();if(!n.bEnabled||!f.bEnabled){return}if(e){if(u==4){if(!i){o(3)}}else{o(4)}}else{o(3)}m(v)};this.onTouchDown=function(v){n.onMouseDown(v);if(v.preventDefault){v.preventDefault()}};this.onTouchUp=function(v){n.onMouseUp(v);if(v.preventDefault){v.preventDefault()}};this.onMouseUp=function(w){if(!n.bEnabled||!f.bEnabled){return}var v=(w.type=="touchend")?1:2;if(e){if(u==3){o(v)}}else{o(v)}j()};this.onMouseUpOutside=function(v){if(!e){o(1)}j()};this.setEnabled=function(v){if(n.bEnabled==v){return}if(!v&&(u==1||!e)){n.setState(1)}if(v){$FSI.removeClass(t,"fsi-ui-button-disabled")}else{$FSI.addClass(t,"fsi-ui-button-disabled")}n.bEnabled=v};var s=this.getPressed=function(){return(u>2)};var c=this.setPressed=function(v){if(!e){return}if(v){o(4)}else{o(1)}};var m=function(v){f.myViewer.onMenuButtonPress(q,v)};var j=function(){f.myViewer.onMenuButtonRelease(q)};r()};$FSI.Viewer=function(e0,di){var bY=new $FSI.ClassDef(this,"FSI Viewer","1.1.2","16.02.08");var aJ=bY.instance;$FSI.guessFSIViewerLocation("fsiviewer.js",3);if(!$FSI._FSIViewerLocation){$FSI.guessFSIViewerLocation("FSI.Viewer.js",3)}var cT=$FSI.getViewerInstanceID();var fp;var ac;var j;var e6;var M;var cG;var fn={};var w;var dT;var a2;var ct=false;var dN=8;var fQ=1;var V;var cv;var b=false;var fA;var eN;var aY;var cg;var dZ;var fH,b8;var dY;var a3=true;var fa=100;var bt=true;var dC;var bi;var am;var cd;var fz;var cD;var dJ;var n;var aU;var cR=false;var ee=new $FSI.CroppedImage();var ed=new $FSI.Rect();var ar=$FSI.Easing.easeOutCubic;var dQ;var dR={width:0,height:0};var a9;var N;var ai={};var fo;var a1;var aA={};var bX=10000;var fL=bX;var dX;var aW;var K;var cq;var fh;var U;var aE=new $FSI.Rect(0,0,-1,-1);var cO=new $FSI.Rect(0,0,-1,-1);var ek=new $FSI.Rect(0,0,-1,-1);var ez=new $FSI.Rect(0,0,-1,-1);var eL=new $FSI.Rect(0,0,-1,-1);var av=new $FSI.Rect(0,0,0,0);var fe=new $FSI.Rect(0,0,0,0);var al=false;var L=true;var A;var c4=false;var a8=false;var bb=false;var cf=true;var cP=false;var v;var fE;var cn=false;var fc=true;var fy=false;var eI=false;var ef;var bq=new $FSI.Rect(0,0,0,0);var dx=0;var dn=0;var db=0;var bS=0;var cI={x:0,y:0};var Q={};var aL={};var r={};var dz="auto";var dB;var eg=1;var af;var aS;var e7=true;var aC={};aC.cursors={};var ep=undefined;var d;var ci;var fO=false;var dE=false;var cX=true;var cs=true;var e2=false;var bJ=false;var d2=false;var es;var bw;var fs;var aX=false;var ff;var dA;var aM;var d5={};var bP;var cu;var eU;var bQ;var cZ;var R;var c8;var dk;var cB;var fK;var c=[];var fw=[];var cJ;var cQ={};var bU={};var eW;var c7=false;var cS;var G;var cL;var P;var fB={};var Y;var aK=fn.viewport={};var cH=$FSI.SVGNameSpaceURL;var eD="1.1";var a0;var fx;var ae;var bA=1;var b2;var ap;var bC;var b1=0;var d0;var ej=0;var dW=1;var ad=2;var eP=ej;var eZ;var f=false;var E;var bh;var eH;var fF;var at=false;var ex=false;var e1;var dL=1;var br={};var z=false;var aO;var eQ;var e8;var eo;var b7={width:0,height:0};var bs=false;var bH=/((\?)|&)(width|height)=[^&]*/ig;var aq=false;var c6;var bD="&limit=0,360";var dU;var cz=true;var fq=false;var s;var dI=undefined;var fC;var eh=false;var bm;var bL="&effects=Matte(FFFFFF)";var a;var d1;var aj;var aT=true;var eS;var b5;var eB;var cN;var bI;var fk;var a5=0;var bT=0;var a6={};var b3=false;var dS=true;var B;var ea={};var ab=0;var c9={};var cE=new $FSI.EmptyDebugger();var fG=function(fR,o){if(o&&!cE.on&&fR.on){eW.stopPendingRequests();aJ.destroy();aJ.init(G,c9,true);aJ.start();return true}cE=fR;if(cE.on){cE.setPrefix(bY.strClassName+" ["+G+"]")}};this.init=function(fR,fV,o){if(typeof(fR)=="object"){if(typeof(fR.id)=="string"){G=fR.id}}else{if(typeof(fR)=="string"){G=fR}}if(!G){G="fsi.viewer #"+cT}if(aJ._fsi_parameters){fV=aJ._fsi_parameters;delete aJ._fsi_parameters}if($FSI.isMobileDevice){eZ=5000000}else{eZ=8000000}if(e2){aJ.destroy()}var fT;if(typeof(fR)=="object"&&fR.tagName!=undefined){fT=fR}else{fT=document.getElementById(fR)}if(typeof(fV)=="object"&&typeof(window[fV.oninit])=="function"){var fS=window[fV.oninit](aJ,G,fV)}c9=(fV&&typeof(fV)=="object")?$FSI.cloneParameters(fV):{};var fW={};fW.onConfigsReady=c1;fW.onDebuggerChange=fG;eW=new $FSI.Config(null,fW);var fU=c9;if(o){fU=$FSI.cloneObject(c9);fU.debug=true}eW.init(fU);if(cE.on){cE.log(aJ.getVersion())}u();if(!fT){cE.error("A DOM element with the id '"+fR+"' could not be found. Aborting.");return}a0="1.5px";if($FSI.isSmallMobileDevice){cE.log("Small mobile Device detected.");bs="fsi-ui-hotspot-mobile fsi-ui-hotspot-mobile-small";a0="4px"}else{if($FSI.isMobileDevice){cE.log("Mobile Device detected.");bs="fsi-ui-hotspot-mobile"}}if(fT.firstChild!=undefined){fT.innerHTML=""}ac=fT;if(ac.tagName.toLowerCase()!="fsi-viewer"){$FSI.addClass(ac,"fsi-viewer")}ac.setAttribute("x-fsi-id",G);d0=($FSI.isMobileDevice)?0.2:0.1;if(!fp){fp=document.createElement("div");fp.className="fsi-viewer-root";$FSI.setStyleAttr(fp,"position:relative;left:0px;top:0px;padding:0px;margin:0px;border:0px none;z-index:0;width:100%;height:100%;text-align:left;vertical-align:top;");fT.appendChild(fp)}X();if(cE.on){cE.log("Container element: "+Y.width+" x "+Y.height+" ("+fT.nodeName+")")}e2=true;aU=$FSI.getCSSTransformStyleName();if(aU=="msTransform"||(!isNaN($FSI.versionInternetExplorer)&&$FSI.versionInternetExplorer<11)){dC=false;bt=false}else{if($FSI.mobileOS=="ios"){dC=false}else{dC=true}}dC=false};this.getInitDone=function(){return e2};var X=function(){Y=$FSI.getElementDimension(fp);var o=(e6&&e6.minInstanceSize>1)?e6.minInstanceSize:60;if(Y.width<o||Y.height-bT<o){Y.visible=false;Y.width=o;Y.height=o+bT}else{Y.visible=true}aK.width=Y.width;aK.height=Y.height-bT};var bl=function(o){if(bm==o){return}bm=o;fF.style.cursor=aC.cursors[o]};var et=function(fX,fW,fZ,fV,o){var fT=aK.width*ai.scale;var fR=aK.height*ai.scale;if(fX==undefined){fX=fT/2}if(fW==undefined){fW=fR/2}var fS;if(fZ!=undefined){fS=Math.max(1,Math.min(br.maxScale,br.scale+fZ))}else{fS=br.defaultZoom}var fY=fS/br.scale;var fX=fY*(br.panPos.left-(fX-fT/2));var fW=fY*(br.panPos.top-(fW-fR/2));var fU=(fV)?0:o;dM(fX,fW,fS,fU)};var e3=function(o,fU,fS,fR){if(!br.enabled){return}if(br.panPos.left==0&&br.panPos.top==0&&(fx<=1||(K&&br.targetZoom==1))){return}var fT=(fS)?0:fR;dM(0,0,1,fT)};var dF=function(o){if(ai.scale>1){o.scaleRect(1/ai.scale)}var f0=o.width();var fV=o.height();if(f0<1||fV<1){return}var fW=f0/fV;var fU=aK.width/aK.height;if(fW>fU){fV=f0*aK.height/aK.width;o.inflateRect(0,fV-o.height())}else{if(fW<fU){f0=fV*aK.width/aK.height;o.inflateRect(f0-o.width(),0)}}var fR=fx*aK.width/f0;fR=Math.max(1,Math.min(br.maxScale,fR));var fZ=fR/fx;var fT=o.left+o.width()/2;var fS=o.top+o.height()/2;var fY=(br.panPos.left-fT+aK.width/2)*fZ;var fX=(br.panPos.top-fS+aK.height/2)*fZ;dM(fY*ai.scale,fX*ai.scale,fR)};var dM=function(o,fU,fT,fR){fT=Math.max(1,Math.min(br.maxScale,fT));dv();br.pos=0;br.frames=(fR!=undefined)?fR:28;if(br.frames<1){br.frames=1}br.sourceZoom=br.scale;br.sourceX=br.panPos.left;br.sourceY=br.panPos.top;if(o==undefined){o=br.sourceX}if(fU==undefined){fU=br.sourceY}var fS=fv(o,fU,fT);br.targetX=fS.x;br.targetY=fS.y;br.targetZoom=fT;br.dX=fS.x-br.sourceX;br.dY=fS.y-br.sourceY;br.dZoom=fT-br.sourceZoom;aN()};var t=fn.stopAfterTouch=function(){if(B){B.cancelAfterTouch()}};var ax=fn.autoShowHideHotSpots=function(o){if(cs==o){return}cs=o;if(!dE||!$FSI.isMobileDevice){return}cX=o;eO(o);cM();if(o){fD()}};var aN=function(){if(K){return}br.lockPanAnimation=false;z=true;ax(false);K=true;fD()};var dv=fn.stopDesktopAnimation=function(){if(K){ax(true);z=false;K=false;br.pos=br.frames=0;br.targetZoom=undefined;bp();cU();eC();ca()}};var bz=function(){if(K||fO){return}if(typeof aJ.onAnimationComplete=="function"){aJ.onAnimationComplete(aJ)}};var em=function(){br.pos++;eM(ar(br.pos,br.frames,br.sourceZoom,br.dZoom,3));if(!br.lockPanAnimation){br.panPos.left=ar(br.pos,br.frames,br.sourceX,br.dX,3);br.panPos.top=ar(br.pos,br.frames,br.sourceY,br.dY,3)}bp();if(br.pos==br.frames){dv();bz();return false}return true};var dP=fn.onAfterinPlaceZoomChanged=function(){bp();cU();eC()};this.getMouseMode=function(){return dz};var d4=this.setMouseMode=function(o){var fR=dz;dz=o;switch(o){case"auto":if(s){o=(br.bZoomedIn)?1:0}else{o=(br.bAutoMouseModePan)?1:2}break;case 0:case 1:break;case 2:if(s){o=(br.bZoomedIn)?1:0}else{o=2}break}b0(o)};var b0=function(o){if(B){B.cancel()}dB=o;switch(dB){case 0:bl("zoom");break;case 1:bl("pan");break;case 2:bl("rotate");break}if(b5){b5.setButtonPressed("MouseMode_"+dB,true)}};var eC=function(){if(!br.enabled||dz!="auto"){return}var o=(fx>1);if(br.bZoomedIn==o){return}br.bZoomedIn=o;if(o){br.bAutoMouseModePan=true;if(s){b0(1)}else{b0(1)}}else{br.bAutoMouseModePan=false;if(s){b0(0)}else{b0(2)}}};var fv=function(o,fX,fW){var fU={x:o,y:fX};var fV=Math.round(aL.imageWidth*fW);var fS=Math.round(aL.imageHeight*fW);var fT=Math.max(0,(fV-Q.maxPanReferenceWidth)/2);var fR=Math.max(0,(fS-Q.maxPanReferenceHeight)/2);fU.x=Math.max(-fT,Math.min(fT,o));fU.y=Math.max(-fR,Math.min(fR,fX));return fU};this.getZoom=function(){var o=fx/br.maxScale*100;return o};this.setZoom=function(fS,o,fR){if(!bJ||!br.enabled){return false}an(true);dv();var fS=fS*br.maxScale/100;if(fR){dM(undefined,undefined,fS);return}else{eM(fS)}bp(o);if(!o){cU();eC()}return true};var bR=this.getViewString=function(){var fR=[];var fX=1+Math.round(dx/(dn/fw.length));if(isNaN(fX)){fX=1}var o=Q.imageWidth;var fT=o/aj.width*aj.height;var fU=1/fx;var fW=0.5-br.panPos.left/o-fU/2;var fS=0.5-br.panPos.top/fT-fU/2;var fV=new $FSI.Rect(fW,fS,fW+fU,fS+fU);fV.round();fR.push(1);fR.push(fX);fR.push(fV.toString());return fR.join(",")};var dH=function(fR){var o=parseFloat(fR);if(isNaN(o)){o=def}return o};var dr=function(fW){var fV={};if(fW==undefined||typeof(fW)!="string"||fW.length<3){return fV}var fX=fW.split(",");if(fX.length<2){return fV}fV.scene=parseInt(fX[1]);if(isNaN(fV.scene)){fV.scene=1}fV.scene=fV.scene%fw.length-1;if(fV.scene<0){fV.scene+=fw.length}fV.frame=fV.scene*dn/fw.length;if(fX.length>5){var f0=dH(fX[2]);var fS=dH(fX[3]);var fZ=dH(fX[4]);var fT=dH(fX[5]);var fR=fV.rc=new $FSI.Rect(f0,fS,fZ,fT);fR.normalizeRect();var fU=fR.width();var f1=fR.height();var f2=1/Math.max(fU,f1);fV.zoom=f2=Math.max(1,Math.min(br.maxScale,f2));var fY=aL.imageWidth;var f3=aL.imageWidth/aj.width*aj.height;fV.x=-fY*f2*((fR.left+fR.width()/2)-0.5);fV.y=-f3*f2*((fR.top+fR.height()/2)-0.5)}return fV};var ft=this.gotoViewString=function(fS,fT){if(!bJ){return false}var o=(fT)?30:0;var fR=dr(fS);if(fR.scene==undefined){return false}var fU=dr(bR());if(fR.scene==fU.scene&&Math.abs(fR.x-fU.x)<1&&Math.abs(fR.y-fU.y)<1&&Math.abs(fR.zoom-fU.zoom)<0.000001){return true}aJ.spinToTarget(fR.frame,o);if(br.enabled&&fR.rc!=undefined){dM(fR.x,fR.y,fR.zoom,o)}return true};this.changeImage=function(o,fR){eW.makeObjectPropertiesLowerCase(o);if(!d2){es=arguments;return}eW.stopPendingRequests();var fS=false;if(o!=undefined){if(o.fpxsrc!=undefined||o.imagepath!=undefined){fS=true}if(o.dir!=undefined){fS=true}}if(!fS){return aJ.gotoViewString(fR,true)}eW.setData(d1);if(o.imagepath!=undefined){o.fpxsrc=o.imagepath;o.imagepath=undefined}eW.cfg.fpxsrc=undefined;eW.cfg.imagepath=undefined;eW.cfg.imagewidth=undefined;eW.cfg.imageheight=undefined;eW.cfg.transparency=undefined;eW.setCfgValues(o);u();a=fR;aV();ev();return true};var bG=function(){var fR={};var o=aL.imageWidth/aj.width*aj.height;fR.x=((aK.width-aL.imageWidth)/aL.imageWidth);fR.y=((aK.height-o)/o);return fR};var eR=function(){var o=a9;if(fx<=1){dZ=1;o=ap;return o}var fS=fx*r.imageWidth;var fU=Math.round(aj.width/dR.width*fS);var fT;for(var fR=0;fR<aY.length;fR++){if(aY[fR]>=fU){fT=N=aY[fR];break}}if(!fT){if(aY.length>0){fT=aY[aY.length-1]}if(fT<=1.1*r.imageWidth){fT=undefined}}if(fT){o=Math.round(fT*ee.getImageRect().width()/aj.width)}dZ=o/ap;return o};var eM=function(o){o=Math.max(1,Math.min(br.maxScale,o));br.scale=o;fx=br.scale*ai.scale;ae=Math.min(br.maxScaleInitial,bA*br.scale);cg=br.scale*bA};var ey=function(){var o=Math.min(br.maxScaleInitial,bA);if(o*br.scale>br.maxScaleInitial){br.scale=br.maxScaleInitial/o}ae=Math.min(br.maxScaleInitial,bA*br.scale);return o};var S=function(o){ai.scale=o;fx=ai.scale*br.scale;ae=Math.min(br.maxScaleInitial,bA*br.scale);br.scale=Math.max(1,ae/bA);cg=bA*br.scale};var bp=fn.updateInPlaceZoom=function(fR){if(K){fR=true}var fS=false;if(fR){if(br.nLastScalePreliminary!=fx){br.nLastScalePreliminary=fx;fS=true}}else{if(br.nLastScaleFinal!=fx){br.nLastScaleFinal=fx;fS=true}}if(fS){if(fR&&cu&&fx-cu.renderScale<-1){ec()}Q.imageWidth=fB.testWidth=Math.round(r.imageWidth*fx);Q.imageHeight=Math.round(r.imageHeight*fx);Q.imageX=Math.round(aL.imageX-(Q.imageWidth-aL.imageWidth)/2);Q.imageY=Math.round(aL.imageY-(Q.imageHeight-aL.imageHeight)/2);Q.maxImageOffsetX=Math.max(0,(Q.imageWidth-Q.maxPanReferenceWidth)/2);Q.maxImageOffsetY=Math.max(0,(Q.imageHeight-Q.maxPanReferenceHeight)/2);if(fs){Q.videoWidth=Math.round(r.videoWidth*fx);Q.videoHeight=Math.round(r.videoHeight*fx);Q.videoX=aL.videoX-(Q.videoWidth-aL.videoWidth)/2;Q.videoY=aL.videoY-(Q.videoHeight-aL.videoHeight)/2}if(!fR){if(b5){var o;o=(br.scale>1);if(o!=b5.getButtonEnabled("ZoomOut")){b5.enableButton("ZoomOut",o);if(eP<ad){b5.enableButton("MouseMode_1",o)}}o=(br.scale<br.maxScale);if(o!=b5.getButtonEnabled("ZoomIn")){b5.enableButton("ZoomIn",o)}b5.enableButton("MaxZoom",dR.width!=Q.imageWidth)}a9=eR()}if(aJ.onZoomChange!=undefined){var fT=fx*100/br.maxScale;aJ.onZoomChange(fT)}}if(!K){br.panPos.left=Math.max(-Q.maxImageOffsetX,Math.min(Q.maxImageOffsetX,br.panPos.left));br.panPos.top=Math.max(-Q.maxImageOffsetY,Math.min(Q.maxImageOffsetY,br.panPos.top))}if(!fR){br.panPos.left=Math.round(br.panPos.left);br.panPos.top=Math.round(br.panPos.top)}fy=true;cM();v=true;fD()};var cU=function(){if(!ci&&!fO){d7()}};var bB=function(){var o=$FSI.getElementClientPos(dY);aE.copyRect(bq);eL.copyRect(o);aE.interSectRectValidate(eL);aE.offsetRect(-eL.left,-eL.top);var fR=(aE.width()>0&&aE.height()>0);var fS=(fR!=ai.visible);ai.visible=fR;return fS};var bF=function(o){ez.copyRect(o);ez.offsetRect(-r.imageX,-r.imageY);if(a3&&ez.width()>0&&ez.height()>0){ez.inflateRect(fa/fx,fa/fx)}ez.scaleRect(dZ)};var h=function(){var fR;var o;var fS=cg;fR=(aE.left+aE.width()/2)-ai.widthUnScaled/2;if(ai.leftLast!=fR){ai.leftLast=fR;if(fR<0){fR=0}if(fR>ai.maxLeft){fR=ai.maxLeft}ai.left=fR}ai.drawOffsetX=ai.scale*(-fR-ai.left+fR);o=(aE.top+aE.height()/2)-ai.heightUnScaled/2;if(ai.topLast!=o){ai.topLast=o;if(o<0){o=0}if(o>ai.maxTop){o=ai.maxTop}ai.top=o}ai.drawOffsetY=ai.scale*(-o-ai.top+o);if(c4){cQ.renderer.setSize(ai.totalWidth,ai.totalHeight);fy=true;cM()}};var p=function(fR){var fY=bA;if(!f){i(Q.widthForRatio,Q.heightForRatio,true);fD();return}var fU=false;var fS=ey();cg=br.scale*bA;var fV=bB();if(fV){fR=true;if(ai.visible){}else{}}else{if(!ai.visible){return}}if(!fR&&cu){if((fV&&!ai.visible)||(ai.widthUnScaled<aE.width()||ai.heightUnScaled<aE.height())||(Math.abs(fS-ai.scale)>1)){if(fS>1){fY=fS=1;fR=true}}}if(!fR){var fT=ai.left;var f2=ai.top;h();cq=(ai.left!=fT||f2!=ai.top);v=true;fD();return}if(ai.lastScale!=fS){ai.lastScale=fS;S(fS);var fW=Math.round(aK.width*fS);var o=Math.round(aK.height*fS);var f1,f0;var fZ=0;if(a3){fZ=fa}ai.maxWidth=Math.round((window.innerWidth*bA+fZ)*fS/fY);ai.maxHeight=Math.round((window.innerHeight*bA+fZ)*fS/fY);if(fW>ai.maxWidth){f1=ai.maxWidth}else{f1=fW}if(o>ai.maxHeight){f0=ai.maxHeight}else{f0=o}ai.width=f1;ai.height=f0;ai.widthUnScaled=Math.ceil(f1/fS);ai.heightUnScaled=Math.ceil(f0/fS);ai.totalWidth=fW;ai.totalHeight=o;fU=(eU.width!=f1||eU.height!=f0)}ai.maxLeft=(ai.totalWidth-ai.width)/ai.scale;ai.maxTop=(ai.totalHeight-ai.height)/ai.scale;if(dC){if(ai.scale!=1){var fX=1/ai.scale;if(bt){ai.strTransformScale=" scale3d("+fX+","+fX+","+fX+")"}else{ai.strTransformScale=" scale("+fX+","+fX+")"}}else{ai.strTransformScale=""}}else{ai.strTransformScale=""}h();if(fU){if(bt){e(eU,"translate3d("+ai.left+"px,"+ai.top+"px,0px)"+ai.strTransformScale)}else{e(eU,"translate("+ai.left+"px,"+ai.top+"px)"+ai.strTransformScale)}if(!dC){eU.style.width=f1/fS+"px";eU.style.height=f0/fS+"px"}eU.width=f1;eU.height=f0;bQ=eU.getContext("2d");fH=fW;b8=o;i(Q.widthForRatio,Q.heightForRatio,true);a9=eR();if(br.enabled){ce();bp()}}else{if(bt){e(eU,"translate3d("+ai.left+"px,"+ai.top+"px,0px)"+ai.strTransformScale)}else{e(eU,"translate("+ai.left+"px,"+ai.top+"px)"+ai.strTransformScale)}if(!dC){eU.style.width=eU.width/fS+"px";eU.style.height=eU.height/fS+"px"}}if(!bw){d7();v=true;fD()}else{bZ()}};var e=function(o,fR){o.style[aU]=fR};this.showAboutWindow=function(){if(j){j.destroy();j=undefined;return}var o={};o.title="About FSI Viewer";o.fnOnDestroy=fN;o.strLongVersion=aJ.getVersion();j=new $FSI.AboutWindow(fp,o)};var fN=function(){j=undefined;return true};this.changeConfig=function(o,fR){if(B){B.cancel()}eW.stopPendingRequests();fi();delete eW.cfg.dir;delete eW.cfg.fpxsrc;delete eW.cfg.fpxpath;delete eW.cfg.fpxsources;eY();if(fR!=undefined){c9=$FSI.cloneParameters(fR)}if(o!=undefined){c9.cfg=o}eW.init(c9);aJ.start()};var d6=function(o,fR){if(!o){return}if(!fR){if(o.FSI_prevDisplayState==undefined){o.FSI_prevDisplayState=o.style.display}o.style.display="none"}else{if(o.FSI_prevDisplayState!=undefined){o.style.display=o.FSI_prevDisplayState}o.FSI_prevDisplayState=undefined}};var c0=function(o){if(o==cz){return}cz=o;d6(dY,o);d6(fF,o);eO(o)};var eO=function(o){if(!ct){o=false}d6(P,o)};var dh=function(fR,fS,o){if(fR==undefined){return}fR.style.width=(typeof(fS)!="string")?fS+"px":fS;fR.style.height=(typeof(fS)!="string")?o+"px":o};var cK=function(fR,o){dh(dY,fR,o);dh(fF,fR,o)};var aF=function(o){if(!dX){dX=true;fI();aW=bR();if(B){B.cancel()}c0(false);d6(dY,true);eU.style.width=eU.style.height="100%";if(eB){eB.hide()}}dY.style.display="none";var fT=$FSI.getElementDimension(fp);dY.style.display="block";var fS=fT.width;var fU=fT.height-bT;var fR;if(fS/fU>aK.width/aK.height){fR=fU*aK.width/aK.height;dY.style.marginLeft=(fS-fR)/2+"px";dY.style.marginTop="0px";fS=fR}else{fR=fS*aK.height/aK.width;dY.style.marginLeft="0px";dY.style.marginTop=(fU-fR)/2+"px";fU=fR}dY.style.width=fS+"px";dY.style.height=fU+"px";if(b5){b5.setContainerSize(fT)}if(eS){eS.setContainerSize(fT,Q,aL)}if(o.FSI_after_treshold!=undefined){bk()}};var bk=this.updateSize=function(){dt();X();cK(aK.width,aK.height);c0(true);dX=false;if(eU==undefined||aK.width<1||aK.height<1){return}var o=cd;p();er();eU.style.width=eU.style.height="";dY.style.marginLeft=dY.style.marginTop="";if(eU!=undefined){fH=eU.width=ai.widthUnScaled=aK.width;b8=eU.height=ai.heightUnScaled=aK.height}i(Q.widthForRatio,Q.heightForRatio);if(c4){cQ.renderer.setSize(aK.width,aK.height);by();cM();v=true;fy=true}dJ=cd=undefined;ec();au();if(eS){eS.setContainerSize(Y,Q,aL)}if(b5){b5.setContainerSize(Y)}ft(aW);d3();bp();dO(o)};var eY=function(o){aA={};d1=undefined;cE=new $FSI.EmptyDebugger();u();if(eW){eW.reset();eW.init(c9)}e6={}};var fi=function(){if(dQ&&bh){dQ.lockImageSourceDimension(bh,false);dQ.lockImage(bh,false);dQ.removeImages(bh,false)}};var ce=function(){br.nLastScalePreliminary=undefined;br.nLastScaleFinal=undefined};var au=function(){ce();a9=N=undefined;ef=undefined};var fb=function(){fB={}};var dt=function(){ai={};S(1);var o,fR;if(eU){o=eU.width;fR=eU.height}ai.leftLast=ai.topLast=undefined;ai.width=ai.widthUnScaled=ai.totalWidth=o;ai.height=ai.heightUnScaled=ai.totalHeight=fR;ai.left=ai.top=0;ai.drawOffsetX=ai.drawOffsetY=0};var u=function(){fc=true;a4();if(B){B.cancel()}an();bf();dv();I();fI();ec();Z();dj();br.panPos={left:0,top:0};br.maxScale=br.maxScaleInitial=1;br.scaleToSourceImage=1;br.scale=1;br.pos=br.frames=0;br.sourceX=br.sourceY=0;br.targetX=br.targetY=0;br.sourceZoom=br.targetZoom=1;br.dX=br.dY=br.dZoom=0;br.lockPanAnimation=false;dt();eM(1);bA=dL=1;fb();a1=undefined;dR={width:0,height:0};ab++;au();cX=true;eO(false);am=undefined;cd=undefined;dJ=undefined;fO=false;cf=true;bb=false;if(b5){b5.setEnabled(false,true)}aX=false;a=undefined;bJ=false;if(!f&&bh){$FSI.removeEvent(bh,"load",cy)}b7={width:0,height:0};fi();fL=bX;eC();if(eQ){clearTimeout(eQ);eQ=undefined}if(c6){clearTimeout(c6);c6=undefined}dl("image");delete cZ;c=new Array();if(dE){for(var o=0;o<e6.hotspots.points.length;o++){var fR=e6.hotspots.points[o];if(fR&&fR.tooltip){if(fR.interactive){$FSI.removeEvent(fR.tooltip,"mouseover",d8);$FSI.removeEvent(fR.tooltip,"mouseout",d8)}$FSI.removeChild(fR.tooltip.parentNode,fR.tooltip);$FSI.removeChild(fR.marker.parentNode,fR.marker)}}}bw=false;dE=false;dn=undefined;aM="";cJ=0;E=undefined;fw=[];dj();if(bP){delete bP}d5={};c8=undefined};var dj=function(){if(cS){eq(cS);if(cS.parentNode){$FSI.removeChild(cS.parentNode,cS)}delete cS;cS=undefined}};var eq=function(fS){try{if(fS&&fS.FSIEvents){for(var fU in fS.FSIEvents){var fR=fS.FSIEvents[fU];$FSI.removeEvent(fS,fU,fR.fn,fR.phase)}}}catch(fT){}};var dm=function(o,fR){if(o.touches){if(o.touches.length>0){fR.x=o.touches[0].clientX;fR.y=o.touches[0].clientY}}else{fR.x=o.clientX;fR.y=o.clientY}};var dq=function(o,fT,fS){if(!bJ){return false}cm("mousedown");an();fI();bf();if(br.enabled){var fR=(K)?br.targetZoom:br.scale;dS=(fR<=1);dv()}ci=true;if(dQ&&dB==2&&!s){dQ.lockImageSourceDimension(bh,true);dQ.lockImage(bh,true)}eU.lastOffsetX=fT.x;eU.lastOffsetY=fT.y;bS=db;cI.x=fT.x;cI.y=fT.y;switch(dB){case 0:if(br.enabled){av.clientOffset=$FSI.getElementPosition(fF);av.setRect(fT.x,fT.y,fT.x,fT.y);eI=true;fD()}break;case 2:bn("mouseDown");break}return true};var O=function(fS,fX,fV){var fR=eU.lastOffsetX-fX.x;var o=eU.lastOffsetY-fX.y;switch(dB){case 0:if(br.enabled){av.setRect(av.left,av.top,fX.x,fX.y);fD()}break;case 2:if(Math.abs(o)>3*Math.abs(fR)){fS.FSI_allowEventDefault=true}fu(bS-(fX.x-fS.FSI_start_x)/eg);cJ=(fR<0)?-1:1;break;default:var fW=false;if(br.enabled){var fU=br.panPos.left;var fT=br.panPos.top;br.panPos.left-=fR*ai.scale;br.panPos.top-=o*ai.scale;bp();fW=(fU!=br.panPos.left||fT!=br.panPos.top);if(!fW){ax(true);fS.FSI_allowEventDefault=true}else{ax(false);fD()}}else{fS.FSI_allowEventDefault=true}}eU.lastOffsetX=fX.x;eU.lastOffsetY=fX.y};var ew=function(fR,fW,fV){if(!ea.bActive){ax(true)}var o=fR._FSI_Canceled;var fT=fR._FSI_Click;ci=false;eI=false;cm("mouseup");if(o){if(dB==2){eX("pointer up - canceled")}return}switch(dB){case 0:if(br.enabled){e4();if(!fT&&br.maxScale>1){dF(fe)}fD()}break;case 1:if(eP==ad&&fx<=1){e3(0,0)}break;case 2:var fS=false;if(!fR._FSI_fromAfterTouch){dG(undefined,false)}else{var fU=cr(db,false);de(fU,fU,1,1);eX("pointer up")}break}eC();if(fT){bj(fR,fW,fV)}};var aP=function(){return(dB==2||(dB==1&&fx>1))};var H=function(fX){if(dB==2){var fS=dn/(fw.length);var fR=fX.x-cI.x;var o=-fR/eg+bS;var fW=Math.round(o/fS)*fS;var fV=-(fW-bS)*eg;fX.x=fV+cI.x;var fU=fX.x-cI.x;var fT=-(fX.x-cI.x)/eg+bS}return fX};var bj=function(fR,fV,fT){if(e1&&cm("click")){return}if(!dS){e3(0,0)}else{if(br.maxScale>1){var fS=$FSI.getElementPosition(fF);var o=fV.x-fS.left;var fU=fV.y-fS.top;et(o*ai.scale,fU*ai.scale)}}};var cm=function(fR){var fS=B.getInitialDownEvent();if(!fS||!fS.target){return false}var o=fS.target;if(o.FSIHotspot){eE(fR,o);return true}};var eV=function(fS,fR,fV,fT){for(var fU in fV){fR[fU]=fS.getFloatParameter(fT+fU,fV[fU])}};var dg=function(fS,fR,fV,fT){for(var fU in fV){fR[fU]=fS.getIntParameter(fT+fU,fV[fU])}};var cw=function(fT,fS,fR,fU){for(var fV in fR){fS[fV]=fT.getStringParameter(fU+fV,fR[fV])}},q=function(fS,fR,fU,fT){for(var fV in fU){fR[fV]=fS.makeBool(fS.getStringParameter(fT+fV),fU[fV])}};var ck=function(fR,o,fT,fS){var fU;if(fT&&fT.length>0){if(o[fT]==undefined){o[fT]={}}fS=fS[fT];fU=o[fT]}else{fU=o}if(fS.strings){cw(fR,fU,fS.strings,fT)}if(fS.booleans){q(fR,fU,fS.booleans,fT)}if(fS.floats){eV(fR,fU,fS.floats,fT)}if(fS.integers){dg(fR,fU,fS.integers,fT)}};var bM=function(fR){var fS={strings:{dir:"",skin:"black",language:"english",backgroundColor:"#FFF",hotspotLineColor1:"#000000",hotspotLineColor2:"#FFFFFF",hotspotDotColor1:"#58a8ff",hotspotDotColor2:"#FFFFFF",hotspotCallbackFunction:undefined,headers:"cors",fpxservertemplate:undefined,imagemattecolor:"FFFFFF",initialview:"",initialMouseMode:"auto",navWidth:"120",navHeight:"120",panLimits:"strict",inPlaceZoom:"auto",documentZoom:"auto",hideUI:"false"},booleans:{useDevicePixelRatio:true,adaptiveUISize:true,drawCube:false,drawTable:false,drawGroundPlate:false,pellets:true,enableHotspots:true,decodeHTMLEntitiesInHotSpotTexts:false,enableZoom:true,noCanvas:false,useMaskedJPEGs:true,noNav:false,autoHideNav:true,autoDisablePointerActions:true,loadExactPreviewImagesAfterResize:false,preventImageTransparency:false},floats:{pelletsOpacity:0.15,fMouseSensitivity:1,desktopClickZoomScale:3,autoSpinSpeed:0,tableDiameter:950,maxZoom:100},integers:{hotspotDotRadius:4,zoomPrecision:1,minInstanceSize:60,quality:-1},video:{strings:{skin:"black",base:"videos/",source:"",spinDirection:"right"},integers:{captureFrames:120,frameOffset:0},floats:{captureOffsetStart:0,captureOffsetEnd:0,widthCorrectionFactor:1,heightCorrectionFactor:1,xCorrectionFactor:0,yCorrectionFactor:0}},camera:{floats:{digitalCropFactor:1,focalLength:50,distanceToTableCenter:1500,heightAboveTable:500,heightTable:undefined,heightCamera:undefined,targetHeightOffset:0,targetWidthOffset:0,shiftX:0}},virtualSpace:{floats:{cubeSizeX:100,cubeSizeY:100,cubeSizeZ:100,cubeLineWidth:1,baseRotationY:0,shiftX:0,shiftZ:0,shiftY:0}}};if(fR==undefined){fR={}}fR.serverBase=eW.serverBase;ck(eW,fR,"",fS);ck(eW,fR,"camera",fS);ck(eW,fR,"virtualSpace",fS);ck(eW,fR,"video",fS);if(e6.enableHotspots){var o=eW.getUnrecognizedConfigNode("hotspots3d");cj(o)}bL="&effects=Matte("+encodeURIComponent(e6.imagemattecolor)+")"};var cj=function(fT){var f1={strings:{normalClass:"fsi-ui-hotspot",hoverClass:"fsi-ui-hotspot-hover",activeClass:"fsi-ui-hotspot-active",text:"",actionParameter:undefined,url:undefined,urlTarget:"_self",cssStyle:"",cssClass:""},booleans:{interactive:false},floats:{perimeterZoom:1,perimeterImageWidth:0,perimeterAngle:undefined,perimeterAngleRange:30,perimeterAngleFadeOut:10,verticalMarkerSize:100,horizontalMarkerSize:30,markerAngle:45,horizontalMarkerPosition:0,verticalMarkerPosition:0.5,perimeterDistance:undefined,perimeterTerminator:undefined,x:0,y:0,z:0}};var fV=[];var fU;var fZ=new $FSI.Config();if(eW.cfg.hotspots!=undefined&&eW.cfg.hotspots.length>0&&typeof(eW.cfg.hotspots.join)=="function"){cE.log("Using HotSpots from JS parameters");e6.hotspots={};e6.hotspots.defaults={};e6.hotspots.points=new Array(eW.cfg.hotspots.length);var fS=eW.cfg.hotspotsdefaults;if(fS==undefined){fS=eW.cfg.hotspotdefaults}if(fS!=undefined){fZ.makeObjectPropertiesLowerCase(fS);fZ.cfg=fS;fU={};ck(fZ,fU,"",f1);for(var fR in f1){var fY=f1[fR];for(var f2 in fY){if(fU[f2]!=undefined){fY[f2]=fU[f2]}}}var fS=fU;fU={};for(var fR in fS){if(fS[fR]!=undefined){fU[fR]=fS[fR]}}e6.hotspots.defaults=fU}for(var fX=0;fX<eW.cfg.hotspots.length;fX++){var f0=eW.cfg.hotspots[fX];fZ.makeObjectPropertiesLowerCase(f0);fZ.cfg=f0;var f0={};ck(fZ,f0,"",f1);e6.hotspots.points[fX]=f0}}else{if(!fT){return}fT=fT.firstChild;while(fT){if(fT.nodeType!=1){fT=fT.nextSibling;continue}var fW=fT.nodeName.toLowerCase();switch(fW){case"hotspot":fV.push(fT);break;case"defaults":fU=dy(fZ,fT,f1);break}fT=fT.nextSibling}if(fU!=undefined){for(var fR in f1){var fY=f1[fR];for(var f2 in fY){if(fU[f2]!=undefined){fY[f2]=fU[f2]}}}var fS=fU;fU={};for(var fR in fS){if(fS[fR]!=undefined){fU[fR]=fS[fR]}}}if(fV.length>0){for(var fX=0;fX<fV.length;fX++){fV[fX]=dy(fZ,fV[fX],f1)}e6.hotspots={};e6.hotspots.points=fV;e6.hotspots.defaults=fU}}if(e6.hotspots&&e6.hotspots.points){cE.log("HotSpots parsed: "+e6.hotspots.points.length);dE=(e6.hotspots.points.length>0)}else{dE=false}};var dy=function(fR,fU,fT){var o={};fU=fU.firstChild;while(fU){if(fU.nodeType!=1){fU=fU.nextSibling;continue}var fS=fR.getValueFromXMLNode(fU,"");o[fS.name]=fS.value;fU=fU.nextSibling}fR.cfg=o;var fV={};ck(fR,fV,"",fT);return fV};var eK=function(o){var fR=e6[o];if(fR==undefined){return}if(fR.indexOf("r")==-1&&fR.indexOf("#")!=0){e6[o]="#"+fR}};var c3=function(){bM(e6);eW.result=e6;e6.virtualSpace.baseRotationYRad=e6.virtualSpace.baseRotationY*Math.PI/180};var fd=function(o,f0){cE.log("Video Dimension: "+o+" x "+f0+"px");var fW=ee.isCropped();var fX=false;var fR=ee.getCropMargins();var fU=aj.width;var fZ=fU/o;var fY=f0*fZ;var fV=Math.round((aj.height-fY)/2);if(fV>fR.top){fX=true;fR.top=fV}if(fV>fR.bottom){fX=true;fR.bottom=fV}if(fX){cE.log("Cropping images to match video dimension ("+fV+"px)");ee.setCropValues(fR.left+"px",fR.top+"px",fR.right+"px",fR.bottom+"px");l()}if(fW){fR=ee.getCropMargins();fR.scaleRectInt(1/fZ);fV=Math.round(fV/fZ);ed.left=fR.left;ed.right=fR.right;ed.top=fR.top-fV;ed.bottom=fR.bottom-fV}else{ed.setRect(0,0,0,0)}a1=undefined;bc();var fS=o-ed.left-ed.right;var fT=f0-ed.top-ed.bottom;b7={width:o,height:f0,croppedWidth:fS,croppedHeight:fT};i(fS,fT);cV();fM();if(bQ&&e6.pellets&&e6.pelletsOpacity>0){bO()}};var i=function(f0,gf,f3){if(!e6||!e6.video||!e6.video.widthCorrectionFactor){return}var f1=0;var fZ=0;var f2,gc,f8,fU;if(!f){f8=aK.width;fU=aK.height}else{f8=fH;fU=b8}var gg=f0/gf;var fY=f8/fU;var fX,o;if(gg>fY){fX=f8}else{o=fU}bc();var f7=ee.getFloatRect();var f4=f7.getRange();var f6=$FSI.getFSIServerImageDim(aj.width,aj.height,fX,o,f4,true);f2=f6.width;gc=f6.height;if(f2>dR.width||gc>dR.height){f2=dR.width;gc=dR.height}a9=Math.min(fL,Math.round(f2));f1=Math.round((f8-f2)/2);fZ=Math.round((fU-gc)/2);Q.widthForRatio=f0;Q.heightForRatio=gf;Q.imageWidth=f2;Q.imageHeight=gc;Q.imageX=f1;Q.imageY=fZ;Q.videoWidth=f2*e6.video.widthCorrectionFactor;Q.videoHeight=gc*e6.video.heightCorrectionFactor;Q.videoX=f1+f2*e6.video.xCorrectionFactor-(f2*e6.video.widthCorrectionFactor-f2)/2;Q.videoY=fZ+gc*e6.video.yCorrectionFactor-(gc*e6.video.heightCorrectionFactor-gc)/2;if(!f3){ap=a9;dw(r)}dw(aL);if(!f3){var f7=ee.getImageRect();var f9;if(f7.width()>0){f9=aj.width/f7.width()}else{f9=0}var fV=Math.ceil(f9*r.imageWidth);if(aj.__levelsCalculatedFor!=fV){aj.__levelsCalculatedFor=fV;cE.log("Calculating image levels for image base width: "+fV+" px");cE.log("Source image dimension: "+aj.width+" x "+aj.height);var f5=Math.ceil(1.1*fV);aY=new Array();if(fV>0){if(aj.levels&&aj.levels.length>0){var ge=new Array();for(var ga=0;ga<aj.levels.length;ga++){var fT=parseInt(aj.levels[ga].width);if(!isNaN(fT)){if(fT>f5){ge.push(fT)}else{break}}}if(cE.on){cE.log("Matching server side image levels: "+ge.join(", "))}if(ge.length>0){ge.push(fV);var fS=ge[0];aY.push(fS);for(var ga=1;ga<ge.length;ga++){var gb=ge[ga];var fW=fS/gb;while(fW>2.5){fS/=2;fW=fS/gb;if(fS>f5){aY.push(Math.round(fS))}}aY.push(gb);fS=gb}aY.pop();ge.pop();aY.reverse()}if(cE.on){var gd=(aY.length-ge.length);if(gd==0){cE.log("Using server side image levels only.")}else{cE.log("Using "+gd+" additional virtual image levels.")}}}else{cE.log("No image level information from server. Using virtual image levels.");var fR=aj.width;var gh=aj.height;if(f5>0){while(fR>f5&&gh>0){aY.push(fR);fR=Math.round(fR/2);gh=Math.round(gh/2)}}aY.reverse()}}if(cE.on){cE.log("Using image levels: "+aY.join(", "))}}aQ()}switch(eP){case ej:Q.maxPanReferenceWidth=aK.width*ai.scale;Q.maxPanReferenceHeight=aK.height*ai.scale;break;case ad:Q.maxPanReferenceWidth=0;Q.maxPanReferenceHeight=0;break;default:Q.maxPanReferenceWidth=aL.imageWidth;Q.maxPanReferenceHeight=aL.imageHeight;break}};var dw=function(fR){for(var fS in Q){fR[fS]=Q[fS]}};var ag=function(){var o=e6.video.source;if(o&&o.indexOf("[static]")==0&&e6.serverBase!=undefined){var fR=e6.serverBase;fR=fR.split("/");fR.pop();fR=fR.join("/");o=o.replace(/\[static\]\/*/,fR+"/static/")}return o};this.start=function(){df();if(b5){b5.destroy();b5=undefined}if(!e2){return}du()};var du=function(o){e6={};eW.loadConfigs()};var c1=function(){if($FSI.oSupportedViewers[bY.strClassName]==undefined){var fS=false;try{var fU=fp.getBoundingClientRect();fS=(!$FSI.isInternetExplorer||$FSI.versionInternetExplorer>8)}catch(fW){}$FSI.oSupportedViewers[bY.strClassName]=fS}c3();X();if(eW.hasPlugin("fullscreen")&&!eW.hasPlugin("resize")){eW.addPluginFromString("resize")}var fV=e6.enableZoom;f=($FSI.BrowserSupports.canvas());br.enabled=false;n=false;if(fV&&$FSI.BrowserSupports.canvas()){var fR=""+e6.inPlaceZoom;switch(fR.toLowerCase()){case"auto":br.enabled=(!$FSI.isMobileDevice);break;default:br.enabled=eW.makeBool(fR,true);break}fR=""+e6.documentZoom;switch(fR.toLowerCase()){case"auto":n=($FSI.isTouch);break;default:n=eW.makeBool(fR,true);break}}b=false;var fR=""+e6.hideUI;fR=fR.toLowerCase();if(($FSI.isMobileDevice&&fR=="onmobiledevices")||(!br.enabled&&fR=="ifnoinplacezoom")||eW.makeBool(e6.hideUI)==true){b=true}aT=(!e6.noNav&&!b&&br.enabled);if(f){dQ=undefined}else{dQ=$FSI._FSITouchZoomInstance}if(f&&eW.hasPlugin("resize")){if(!fq){var o=$FSI.addCustomEvent(fp,"FSIElementDimension",aF);$FSI.setCustomEventListenerProperty(o,"treshold",250);fq=true}}else{if(fq){$FSI.removeCustomEvent(fp,"FSIElementDimension",aF);fq=false}}if(e6.noCanvas){f=false}var fT=e6.skin;cE.log("Loading skin: "+fT+".css");if(ff){ff.remove()}if($FSI.oSupportedViewers[bY.strClassName]==true){ff=$FSI.loadSkinCSS(fT,aJ,ch);aC.name=ff.getSkinName();aC.className="fsi-skin-"+aC.name;fp.className="fsi-viewer-root "+aC.className}else{ch(false)}};var ch=function(fR,o){if(fR){cE.log("Skin loaded successfully. ")}else{cE.error("Failed to load skin.")}if(fR){b6(o)}dc()};this.getMenuHeight=function(fR){var o=a5;if(fR!=undefined){switch(fR){case"navWindow":if(dA.bFloatingNavWindow){o=0}break}}return o};var ei=function(o){if(typeof(o)!="string"){return o}if(o.indexOf("url(")!=0){return o}o=o.replace(/^url\(["'\s]*/,"");o=o.replace(/["'\s]*\)$/,"");if(o.indexOf("http")!=0){o=o.replace(/^\/*/,"");o=$FSI._FSIViewerLocation+"/skins/"+o}return o};var b6=function(fT){if(aC._nameParsedLast!=aC.name){aC._nameParsedLast=aC.name;var fX="."+aC.className+" .";var fR=function(f2,f1,f0,fZ){var fY=fT.getStyle(fX+f2,f1,fZ);if(fY==undefined){fY=f0}return fY};dA=fR("fsi-ui-info","content",undefined,true);dA.bFloatingMenuBar=eW.makeBool(dA.floatingMenuBar);dA.bFloatingNavWindow=eW.makeBool(dA.floatingNavWindow);aC.cursors={};var fW=$FSI._FSIViewerLocation+"/skins/resources/"+aC.name+"/";var fS=function(fZ,fY){var f0=fR("fsi-ui-cursor-"+fZ,"content");if(typeof(f0)!="string"){return fY}if(f0.indexOf(".")!=-1&&f0.indexOf("http://")!=0&&f0.indexOf("https://")!=0){f0=f0.replace(/^[\/]*/,"");f0="url('"+fW+f0+"'),"+fY}return f0};aC.cursors.wait=fS("wait","progress");if(br.enabled){aC.cursors.zoom=fS("zoom","crosshair")}else{aC.cursors.zoom="default"}aC.cursors.pan=fS("pan","move");aC.cursors.rotate=fS("rotate","ew-resize");aC.navFrameBorderColor=fR("fsi-ui-nav-frame","border-color","red");aC.navFrameBackgroundColor=fR("fsi-ui-nav-frame","background-color","rgba(255,255,255,0.5)");af=fR("fsi-ui-select-frame","border-color","red");aS=fR("fsi-ui-select-frame","background-color","rgba(255,255,255,0.25)");aC.oProgressBarStyle={};aC.oProgressBarStyle.color=fR("fsi-ui-progressbar","color","#CCC");aC.oProgressBarStyle.background=fR("fsi-ui-progressbar","background-color","#FFF");aC.oProgressBarStyle.border=fR("fsi-ui-progressbar","border-color","#CCC");aC.oProgressBarStyle.text=fR("fsi-ui-progressbar-text","color","#555");aC.urlLogo=ei(fR("fsi-ui-logo-url","background-image"));var fV=16;var o=8;if(dA){if(!isNaN(dA.baseSize)&&dA.baseSize>0){fV=dA.baseSize}if(!isNaN(dA.baseEnlargement)&&dA.baseEnlargement>0){o=dA.baseEnlargement}}else{dA={}}var fU=1;if(e6.adaptiveUISize==true){fU=$FSI.getDevicePixelRatio()}U=Math.round(fV+o*fU);dA._baseSkinSize=U}fp.style.fontSize=U+"px"};var dc=function(){b3=($FSI.oSupportedViewers[bY.strClassName]==true&&b!=true);if(b3){g()}else{a5=bT=0;c2()}};var c2=function(){if(b5){a5=b5.getHeight()}if(dA&&dA.bFloatingMenuBar){bT=0}else{bT=a5}X();aV()};var g=function(){if(eB==undefined){if($FSI._FSIViewerLocation!=undefined){eB=new $FSI.ToolTip(fp)}}ev();if(b5){b5.destroy()}b5=new $FSI.MenuBar(fn,aC,c2)};var ev=function(){if(eB!=undefined){var fR=e6.language;var fS=fR+".xml";var o=$FSI._FSIViewerLocation+"/languages/"+fS;if(o!=fk){bI=o;cE.log("Loading language file: "+o);eW.loadFile(o,eA,"application/xml")}}};var dK=function(){if(!b5){return}var fT;var fR=[];fR.push({cmd:"Reset"});if(br.enabled==true){fR.push({cmd:"ZoomOut",enabled:false});fR.push({cmd:"ZoomIn"})}if(eW.hasPlugin("mousemodes")||eW.hasPlugin("mousemodeselect")){var fW=eW.getPluginParameter("mousemodes","sequence","0,1,3,2");fW=fW.split(",");var fU=[];for(var fS=0;fS<4;fS++){fU[fS]=eW.getPluginParameter("mousemodes","mode"+fS,true,true)}if(!br.enabled){fU[0]=fU[1]=false}var fV=function(fX){if(isNaN(fX)||fX<0||fX>2){return}if(!fU[fX]){return}if(fX==2&&fw.length<2){return}var fY=true;if(fX==1){fY=(eP>dW)}fR.push({cmd:"MouseMode_"+fX,groupID:"MouseMode",enabled:fY})};for(var fS=0;fS<fW.length;fS++){fV(parseInt(fW[fS]))}}if(eW.hasPlugin("maxzoom")&&br.enabled){fR.push({cmd:"MaxZoom"})}if(dE){if(!eW.hasPlugin("hotspots")){eW.addPluginFromString("hotspots")}if(eW.getPluginParameter("hotspots","button","true",true)){fR.push({cmd:"Hotspots",bCheckButton:true})}ct=eW.getPluginParameter("hotspots","visible","true",true)}if($FSI.FullScreen.getAvailable(fp)&&eW.hasPlugin("fullscreen")){if($FSI.bFullScreenFSIViewerCSSAdded!=true){$FSI.bFullScreenFSIViewerCSSAdded=true;var o=".fsi-viewer-root"+$FSI.FullScreen.getFullscreenPseudoClass();$FSI.addCSSRule(o,"position:absolute!important;left:0px!important;top:0px!important;width:100%!important;height:100%!important;",0)}fR.push({cmd:"FullScreen",bCheckButton:1})}b5.addButtons(fR);if(dE&&ct){b5.setButtonPressed("Hotspots",true)}};var er=function(){var o;if(!n){o=Math.round(Math.max(1,fQ)*Math.max(aK.width,aK.height))}else{o=Math.round(Math.max(1,fQ)*Math.max(screen.width,screen.height))}eo=Math.min(1024,Math.max(2,Math.ceil(o/3/128))*128)};var aV=function(){if(e6.useDevicePixelRatio){fQ=$FSI.getDevicePixelRatio()}else{fQ=1}er();ee=new $FSI.CroppedImage();ee.setCropFromConfig(eW.cfg);switch(e6.panLimits){case"loose":eP=ad;break;case"medium":eP=dW;break;default:eP=ej;break}k();d2=true;if(es!=undefined){var fS=es;es=undefined;aJ.changeImage.apply(aJ,fS);return}var fR=e6.dir;if(!fR||fR.length==0){var o=eW.getImageList();if(o){bd(o.arImages,o.oXML,o)}else{return cl()}}else{eW.loadImageList(e6.dir,bd,bD)}};var bd=function(o,fS){if(!o||o.length<1){cE.error("Failed to load image list.");return cl()}fw=o;cE.log("Image list loaded ("+fw.length+" images)");if(fw.length>0){var fR=eW.getImageInfoURL(fw[0]);eW.loadFile(fR,bg)}else{aZ()}};var cl=function(){bl("default");if(b5){b5.setEnabled(false)}};var bg=function(fR,o){aj=o;aj.transparency=eW.makeBool(aj.alpha);aj.width=parseInt(aj.width);aj.height=parseInt(aj.height);if(e6.fpxservertemplate!=undefined){d5.renderer=e6.fpxservertemplate}if(e6.headers!=undefined){d5.headers=e6.headers}cR=(aj.transparency&&!e6.preventImageTransparency);if(cR){if(f){aX=e6.useMaskedJPEGs}else{var fS=eW.cfg.fpxservertemplate;if((e6.video==undefined||!e6.video.source.length)&&(fS==undefined||fS=="jpeg")){d5.renderer="png"}}}fE=(!cR||!aX);if(typeof(aj.levels)=="object"&&typeof(aj.levels.sort)=="function"){aj.levels.sort(aw)}else{aj.levels=undefined}ee.setSourceDimension(aj.width,aj.height);l();i(dR.width,dR.height);cV();aZ()};var aw=function(fR,o){return o.width-fR.width};var cV=function(){if(ee.isCropped()){var fR=ee.getImageRect();var o=fR.width()/Q.imageWidth;aA.cropScaleX=aj.width/fR.width();aA.cropScaleY=aj.height/fR.height();aA.x=(fR.left+fR.width()/2-aj.width/2)/o;aA.y=(fR.top+fR.height()/2-aj.height/2)/o}else{aA.cropScaleX=1;aA.cropScaleY=1;aA.x=0;aA.y=0}};var l=function(){var o;if(ee.isCropped()){o=ee.getPixelRangeRect();dR.width=o.right;dR.height=o.bottom}else{dR.width=aj.width;dR.height=aj.height;o=new $FSI.Rect(0,0,dR.width,dR.height)}};var aZ=function(){fb();c4=false;a8=false;var o=true;if($FSI.BrowserSupports.canvas()){if(e6.drawCube||e6.drawGroundPlate||e6.drawTable){a8=c4=true}if(!c4&&e6.enableHotspots){if(e6.hotspots&&e6.hotspots.points&&e6.hotspots.points.length>0){c4=true}}var fR="js/three_custom_min.js";if($FSI._FSIViewerLocation!=undefined){fR=$FSI._FSIViewerLocation+"/applications/viewer/"+fR}o=false;if(c4){if(typeof(window.THREE)=="object"){o=true}else{if(!$FSI.loadJavascript(fR,cT,aJ,dV)){o=true;c4=false}}}else{$FSI.releaseLoadJavascript(fR,cT);o=true}}if(!c4){a8=false}if(o){cF()}};var dV=function(o,fS,fR){if(typeof(window.THREE)!="object"){c4=false}if(!c4){a8=false}cF()};var cF=function(){if(e6.video.spinDirection&&e6.video.spinDirection.toLowerCase()=="left"){e6._reverseVideoDirection=true}if(e6.spinDirectionImage!=undefined){if(e6.spinDirectionImage.toLowerCase()=="left"){e6._reverseImageDirection=true}}else{e6._reverseImageDirection=e6._reverseVideoDirection}if(e6._reverseImageDirection){fw.reverse();fw.unshift(fw.pop())}var o=e6.video.captureFrames;if(o==undefined||isNaN(o)){e6.video.captureFrames=120}e6.video.captureFrames-=e6.video.captureFrames%fw.length;if(e6.video.captureFrames<fw.length){e6.video.captureFrames=fw.length}d=ag();b9();dK();if(dE){eO(true)}else{eO(false)}if(eU){eF()}};var eA=function(o,fT){fk=bI;if(fT){cN={};var fS=eW.findXMLNode(fT,"data");if(fS){fS=eW.findXMLNode(fS,"tip")}while(fS){if(fS.nodeType==1){var fU=fS.getAttribute("id");var fR=eW.XMLChildNodesToString(fS);cN[fU]=fR}fS=fS.nextSibling}eB.setContent(cN)}};var bV=function(){if(b5&&dB!=undefined){b5.setButtonPressed("MouseMode_"+dB,true)}if(aT){cb()}};var b9=function(){if(dR.width){fL=Math.min(bX,dR.width)}else{fL=bX}aQ()};var aQ=function(){br.scaleToSourceImage=Math.max(1,dR.width/aL.imageWidth);br.maxScale=br.maxScaleInitial=e6.maxZoom/100*br.scaleToSourceImage;br.defaultZoom=Math.min(e6.desktopClickZoomScale,br.maxScale)};this.destroy=function(){ac.removeAttribute("x-fsi-id");$FSI.removeClass(ac,"fsi-viewer");if(j){j.destroy()}if(ff){ff.remove();ff=undefined}if(a2!=undefined){$FSI.removeCustomEvent(fp,"FSIMouseWheel",eu);a2=undefined}if(w!=undefined){$FSI.removeCustomEvent(fF,"FSIDocumentZoomChange",cY);w=undefined}if(dT!=undefined){$FSI.removeCustomEvent(dY,"FSIViewport",aI);dT=undefined}if(fq){$FSI.removeCustomEvent(fp,"FSIElementDimension",aF);fq=false}if(c6){clearTimeout(c6);c6=undefined}I();if(eB){eB.destroy();eB=undefined}if(b5){b5.destroy();b5=undefined}df();if(B){B.destroy();B=undefined}e2=false;eY();if(fp){if(eU){$FSI.removeChild(dY,eU);$FSI.removeChild(fp,dY);eU=undefined}if(fp.parentNode==ac){$FSI.removeChild(ac,fp)}fp=undefined}if(P){$FSI.removeChild(P.parentNode,P);P=undefined}if(fF){if(!$FSI.isMobileDevice){$FSI.removeEvent(fF,"keydown",cc);$FSI.removeEvent(fF,"keyup",bE)}$FSI.removeChild(fF.parentNode,fF);fF=undefined}cz=true};var k=function(){if(!aK||aK.width<10||aK.height<10){return false}if(fF==undefined){fF=document.createElement("div");fF.className="fsi-event-overlay";var fR=";-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;";if($FSI.isInternetExplorer){$FSI.setStyleAttr(fF,"position:absolute;z-index:300;background-color:rgba(0,0,0,0)"+fR)}else{$FSI.setStyleAttr(fF,"position:absolute;z-index:300"+fR)}bl("wait");if(!$FSI.isMobileDevice){fF.setAttribute("tabIndex","0")}fp.appendChild(fF);if(!B){var fS={};fS.detectGestures=true;fS.afterTouch={enabled:true};fS.afterTouch.modifyTarget=H;fS.afterTouch.fnGetAfterTouchEnabled=aP;fS.afterTouch.fnStartStopAfterTouch=C;if(br.enabled){fS.detectClick=true;fS.onPinchStart=m;fS.onPinchChange=cW;fS.onPinchEnd=fm}B=new $FSI.TouchHandler(fF,fS,dq,O,ew)}if(!$FSI.isMobileDevice){$FSI.addEvent(fF,"keydown",cc);$FSI.addEvent(fF,"keyup",bE)}if(br.enabled){a2=$FSI.addCustomEvent(fp,"FSIMouseWheel",eu)}else{if(a2!=undefined){$FSI.removeCustomEvent(fp,"FSIMouseWheel",eu);a2=undefined}}if(br.enabled){if(w==undefined){w=$FSI.addCustomEvent(fF,"FSIDocumentZoomChange",cY);$FSI.triggerCustomEvent(w)}}else{if(w){$FSI.removeCustomEvent(fF,"FSIDocumentZoomChange",cY);w=undefined}if(B){B.enable(true)}}}if(P==undefined&&dE){P=document.createElement("div");$FSI.setStyleAttr(P,"position:absolute;z-index:4;");fF.appendChild(P)}if(P){d6(P,false)}if(eU==undefined||eU.FSIisCanvas!=f){if(eU!=undefined&&eU.FSIisCanvas!=f){$FSI.removeChild(fp,eU);eH=eU=bh=undefined}dY=document.createElement("div");dY.setAttribute("draggable","false");$FSI.setStyleAttr(dY,"position:absolute;overflow:hidden;width:100%;height:100%;overflow:hidden");if(f){eU=document.createElement("canvas")}else{eU=document.createElement("div")}dY.appendChild(eU);fp.appendChild(dY);var o="z-index:1;position:absolute;transform-origin:0px 0px;	-webkit-transform-origin:0px 0px;	-ms-transform-origin:0px 0px;";o+="backface-visibility: hidden;-webkit-backface-visibility: hidden;";$FSI.setStyleAttr(eU,o);if(f){bQ=eU.getContext("2d");cG=bQ.webkitBackingStorePixelRatio||bQ.mozBackingStorePixelRatio||bQ.msBackingStorePixelRatio||bQ.oBackingStorePixelRatio||bQ.backingStorePixelRatio||1;if(!dC){eU.style.width=eU.style.height=""}}else{eU.style.textAlign="left"}eU.FSIisCanvas=f}if(typeof(e6.backgroundColor)=="string"&&e6.backgroundColor.toLowerCase()=="none"){e6.backgroundColor="transparent"}fp.style.backgroundColor=e6.backgroundColor;if(!f){if(eH==undefined){eH=bh;bh=undefined}if(bh!=undefined){$FSI.removeChild(bh.parentNode,bh)}bh=document.createElement("img");if(eH!=undefined){bh.style.display="none"}eU.appendChild(bh)}if(f){if(dT==undefined){dT=$FSI.addCustomEvent(dY,"FSIViewport",aI);$FSI.setCustomEventListenerProperty(dT,"treshold",350)}}else{if(dT!=undefined){$FSI.removeCustomEvent(dY,"FSIViewport",aI);dT=undefined}aE.setRect(0,0,aK.width,aK.height)}fH=eU.width=aK.width*ai.scale;b8=eU.height=aK.height*ai.scale;eU.lastOffsetX=eU.lastOffsetY=0;if(($FSI.BrowserSupports.documentZoom()&&!$FSI.isMobileDevice)||($FSI.isMobileDevice&&!f)){ex=true}cK(aK.width,aK.height);dt();return true};var m=function(o,fT,fS){if(br.maxScale<=1){ea.bActive=false;return}ea.bActive=true;ea.lastX=fT.x;ea.lastY=fT.y;ea.distanceStart=o._FSI_PinchDistance;var fR=$FSI.getElementPosition(fF);ea.offsetX=-fR.left-aK.width/2;ea.offsetY=-fR.top-aK.height/2;ea.startZoom=br.scale;ax(false)};var cW=function(fX,fV,fY){if(!ea.bActive){return}var fT=fX._FSI_PinchDistance;var fS=fV.x-ea.lastX;var o=fV.y-ea.lastY;ea.lastX=fV.x;ea.lastY=fV.y;var f0=ea.startZoom*fX._FSI_PinchScale;f0=Math.max(1,Math.min(br.maxScale,f0));var fZ=f0*100/br.maxScale;var fW=fV.x+ea.offsetX;var fU=fV.y+ea.offsetY;var fR=f0/br.scale;br.panPos.left-=fW;br.panPos.top-=fU;br.panPos.left*=fR;br.panPos.top*=fR;br.panPos.left+=fW;br.panPos.top+=fU;br.panPos.left+=fS;br.panPos.top+=o;aJ.setZoom(fZ,true,false)};var fm=function(o,fT,fS){if(!ea.bActive){return}ea.bActive=false;ax(true);var fR=br.scale*100/br.maxScale;aJ.setZoom(fR,false,false)};var D=function(fS){var fR=fS;var o=$FSI.getDevicePixelRatio();if(o<1||e6.useDevicePixelRatio){fS=o*fS}if(ef!=fS){ef=fS;br.maxScale=Math.max(1,br.maxScaleInitial/fS);cM();bA=fS;if(dE){if(dL!=bA){dL=bA;cP=true}if(!bw){fD()}}}};var aI=function(o){bq=o.FSI_viewport_rect;D(o.FSI_scale);if(!bJ){return}p(o.FSI_after_treshold)};var cY=function(o){d3()};var d3=function(){if(e6.autoDisablePointerActions){var o=(aJ.getInFullScreenMode()||(Y.width<=window.innerWidth&&Y.height<=window.innerHeight));if(o!=e7){e7=o;B.enable(o);if(eS){eS.enable(o)}}}};var az=function(){return(ci&&(!B||!B.isAfterTouchRunning()))};var eu=function(fY){if(fY.preventDefault){fY.preventDefault()}t();be();var fZ=az();if(bw||fZ){return}if(br.maxScale<=1){return}var fX=fY.FSI_weighted_delta;bU=B.getMousePositionClient(fY);var fW=$FSI.getElementPosition(fF);var fS=1+Math.abs(fX)/6;if(fX<0){fS=1/fS}var f0=Math.max(1,Math.min(br.maxScale,br.scale*fS));var fV=bU.x*ai.scale-fW.left-aK.width*ai.scale/2;var fU=bU.y*ai.scale-fW.top-aK.height*ai.scale/2;var o=f0/br.scale;var fT=br.panPos.left-fV;var fR=br.panPos.top-fU;fT*=o;fR*=o;fT+=fV;fR+=fU;dM(fT,fR,f0,13);if(eS&&eS.isDragging()){br.lockPanAnimation=true}fY.cancelBubble=true};var C=function(o){fh=o;if(o){fD()}};var dD=function(){if(fw.length<2){cZ=undefined;al=false;return}if(!f){return}var fR=aK.width/3;var o=(aK.width-fR)/2;var fS=aK.height-26;cZ=new $FSI.CanvasProgressBar(bQ,o,fS,fR,14,aC.oProgressBarStyle);bZ()};var bZ=function(){if(!cZ){return}var fR=aK.width/3*ai.scale;var o=(bA*aK.width-fR)/2;var fS=bA*aK.height-26;cZ.setPos(o,fS)};var eF=function(){var fV=false;aq=(!$FSI.isMobileDevice&&($FSI.isOpera||$FSI.isInternetExplorer));dD();bl("wait");var fX="";if(d.indexOf("http")!=0){fX=e6.video.base}if(!f||$FSI.isMobileDevice||!d){cE.log("Using image sequence w/o video.");return cp()}var f0=e6.video.captureOffsetStart;if(f0==undefined||isNaN(f0)){f0=0}var fT=e6.video.captureOffsetEnd;if(fT==undefined||isNaN(fT)){fT=0}var fW;var f1=document.createElement("canvas");f1.setAttribute("webkit-playsinline","");var fY=f1.getContext("2d");if(!cB){cB=document.createElement("canvas");fK=cB.getContext("2d")}var f2=fX+d;if($FSI.isInternetExplorer&&$FSI.versionInternetExplorer<10&&$FSI.isCrossDomain(f2)){cE.error("CROSS DOMAIN VIDEO ACCESS not possible with this browser.");cE.log("Falling back to using image sequence.");return cp()}cE.log("Capture "+e6.video.captureFrames+" video frames");cS=document.createElement("video");cS.setAttribute("muted","muted");cS.setAttribute("preload","auto");cS.setAttribute("webkit-playsinline","");cS.setAttribute("crossorigin","anonymous");$FSI.setStyleAttr(cS,"position:absolute;z-index:10000;width:1px;height:1px");cS.style.marginLeft=aK.width/2+"px";cS.style.marginTop=aK.height/2+"px";if(!$FSI.isSafari&&!$FSI.isInternetExplorer){var fS=document.createElement("source");fS.setAttribute("src",fX+d+".webm");cS.appendChild(fS)}var fR=document.createElement("source");fR.setAttribute("src",fX+d+".mp4");cS.appendChild(fR);if(!$FSI.isSafari&&!$FSI.isInternetExplorer){var o=document.createElement("source");o.setAttribute("src",fX+d+".ogv");cS.appendChild(fR)}fp.appendChild(cS);cS.FSIEvents={};var fZ=function(f4,f5,f3){cS.FSIEvents[f4]={fn:f5,phase:f3};$FSI.addEvent(cS,f4,f5,f3)};fZ("error",function(f3){if(cS.networkState==cS.NETWORK_NO_SOURCE){cE.error('Failed loading the video: "'+d+'"');cE.log("Falling back to using image sequence w/o video.");cp()}},true);fZ("loadedmetadata",function(f4){bw=true;dl("video");var f5=cS.videoWidth;var f3=cS.videoHeight;cS.setAttribute("width",f5);cS.setAttribute("height",f3);fW=(cS.duration-f0-fT)/e6.video.captureFrames;fd(f5,f3);f1.setAttribute("width",b7.croppedWidth);f1.setAttribute("height",b7.croppedHeight);cB.setAttribute("width",b7.croppedWidth);cB.setAttribute("height",b7.croppedHeight);bV()},true);fZ("canplaythrough",function(f3){if(!fV){fV=true;this.currentTime=Math.max(0,f0)}},true);var fU=0;fZ("seeked",function(f3){if(!bw){return}var f4=cS.duration;if($FSI.isInternetExplorer){f4-=0.3}if(c.length<e6.video.captureFrames){try{fY.drawImage(f3.target,0,0,b7.width,b7.height,-ed.left,-ed.top,b7.width,b7.height);var f6=fY.getImageData(0,0,f1.width,f1.height);c.push(f6)}catch(f5){cE.error('Failed capturing the video: "'+d+'"');cE.log("REASON: "+f5.message);cE.log("Falling back to using image sequence w/o video.");bw=false;cp();return}if(cZ){R=100*c.length/e6.video.captureFrames;al=true}bx(c.length-1);fD();fU=Math.min(f4,fW*c.length+f0);if(aq){c6=setTimeout(function(f7){cS.currentTime=fU},1)}else{cS.currentTime=fU}}else{bo()}},true)};var an=function(o){if(!dI){return}eX("autoSpin");clearInterval(dI);dI=0;if(o){dG()}};var eG=function(){var o=dx+fC;if(o>=dn){o-=dn}else{if(o<0){o+=dn}}bx(o);fD()};var bo=function(){bx(0);if(fs){aY.unshift(r.imageWidth)}al=false;bb=c4;bP=undefined;if(e6._reverseImageDirection&&eS){eS.reverseImageSequence()}if(dQ){fD()}dj();delete cZ;dn=c.length;if(dn>1){s=false;if($FSI.isIETouch){fF.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}if(e6.autoSpinSpeed!=0){bn("autoSpin");if(e6.autoSpinSpeed<0){e6.autoSpinSpeed=-e6.autoSpinSpeed;fC=-1}else{fC=1}var fR=e6.autoSpinSpeed*1000/dn;if(fR==0){fR=1}while(fR<20&&Math.abs(fC)<dn/2){fR*=2;fC*=2}fR=Math.max(20,Math.ceil(fR));dI=setInterval(eG,fR)}}else{s=true;if($FSI.isIETouch){fF.style.msTouchAction=undefined}if(!br.enabled){bl("default")}}var fR=e6.initialMouseMode;if(fR!="auto"){fR=parseInt(fR)}d4(fR);bw=false;cL=dn/120;if(fs&&e6._reverseVideoDirection){c.reverse();c.unshift(c.pop())}eg=160/dn*4/e6.fMouseSensitivity;var o;if(e6.video.frameOffset&&fs){o=e6.video.frameOffset}else{o=0}if(o<0){o=fJ(dn+o)}bx(o);bv();bJ=true;if(b5){b5.setEnabled(true)}if(a!=undefined){ft(a,(fw.length>1));a=undefined}else{if(e6&&e6.initialview!=undefined&&e6.initialview.length>0){ft(e6.initialview,(fw.length>1))}}if(typeof aJ.onReady=="function"){aJ.onReady(aJ)}bz();if(br.enabled){bp()}if(!br.enabled){if(s){B.setCapture(false,false)}else{B.setCapture(true,false)}}if(dT){$FSI.triggerCustomEvent(dT);p(true)}};var cp=function(){dl("image");e6.pellets=false;dj();i(dR.width,dR.height);bV();eb()};var cy=function(){$FSI.removeEvent(bh,"load",cy);if(eH!=undefined&&eH.parentNode!=undefined){$FSI.removeChild(eH.parentNode,eH);eH=undefined}bh.style.display="inline";eU.style.paddingLeft=Q.imageX+"px";eU.style.paddingTop=Q.imageY+"px"};var eb=function(){bw=true;fM();if(!f){bh.width=Q.imageWidth;bh.height=Q.imageHeight;$FSI.addEvent(bh,"load",cy,true);if(eH==undefined){try{eU.style.paddingLeft=eU.style.paddingRight="auto";eU.style.paddingTop=eU.style.paddingRight="auto"}catch(fR){}}}if(cB){cB.setAttribute("width",Q.imageWidth);cB.setAttribute("height",Q.imageHeight)}var o=dU=new Image();o.FSI_nImage=0;$FSI.addEvent(o,"load",e9);eJ(o,fl(o.FSI_nImage).fullURL)};var eJ=function(o,fR){if(!aX){o.FSI_image_context=o;$FSI.loadImageCors(o,fR)}else{var fT=fR;fT+=bL;o.FSI_image_context=o;o.FSI_url=fT;var fS=o._FSI_alpha_mask=new Image();fS.FSI_my_img=o;fS.crossOrigin="anonymous";$FSI.addEvent(fS,"load",cA);fR=$FSI.changeRendererInURL(fR,"png.alpha");fS.src=fR}};var cA=function(){$FSI.removeEvent(this,"load",cA);var o=this.FSI_my_img;o.FSI_alpha_channel=this;$FSI.loadImageCors(o,o.FSI_url)};var bN=function(fS){if(!fS){return}if(fS.FSI_alpha_channel){var fR=fS.width;var fU=fS.height;var fT=fS.FSI_image_context=document.createElement("canvas");fT.setAttribute("width",fR);fT.setAttribute("height",fU);fT.setAttribute("crossorigin","anonymous");var o=fT.getContext("2d");o.drawImage(fS.FSI_alpha_channel,0,0,fR,fU);o.globalCompositeOperation="xor";o.drawImage(fS,0,0,fR,fU);fS.FSI_alpha_channel=undefined}};var e9=function(fS){if(!dU){return}bN(dU);var fR=(dU.width-Q.imageWidth)/2;var o=(dU.height-Q.imageHeight)/2;if(f){c.push(dU)}else{c.push(dU.src)}if(cZ){R=100*c.length/fw.length;al=true}bx(c.length-1);fD();if(++dU.FSI_nImage>=fw.length){Z();if(dQ){dQ.addImage(bh)}bo();return}var fT=dU;if(f){$FSI.removeEvent(dU,"load",e9);var fU=dU.FSI_nImage;fT=dU=new Image();fT.FSI_nImage=fU;$FSI.addEvent(fT,"load",e9)}eJ(fT,fl(fT.FSI_nImage).fullURL)};var Z=function(){if(dU==undefined){return}$FSI.removeEvent(dU,"load",e9);dU=undefined};var fu=function(o){db=o;var fR=fJ(Math.round(o));if(fR!=fJ(dx)){cM();dx=fR;fD()}};var bn=function(o){if(fO){return}A=L;L=true;fO=true;I();cf=false;I();v=false};var eX=function(o){if(!fO){return}L=A;dx=fJ(dx);fO=false;cf=true;v=true;if(!cu||dx!=cu.spinPos){if(cu){ec()}d7()}else{ca(50)}};var bx=function(o){dx=db=o};var bO=function(){c8=document.createElement("canvas");c8.setAttribute("width",b7.croppedWidth);c8.setAttribute("height",b7.croppedHeight);dk=c8.getContext("2d");var fU=c8.width;var fR=c8.height;var fT=dk.createImageData(fU,fR);var fV=fT.data;for(var fW=0;fW<fR;fW++){if(fW%4==0){for(var o=0;o<fU;o++){if(o%4!=0){var fS=fW*fU*4+o*4;fV[fS]=0;fV[fS+1]=0;fV[fS+2]=0;fV[fS+3]=255}}}else{if(fW%4==1||fW%4==2){for(var o=1;o<fU;o+=4){var fS=fW*fU*4+o*4;fV[fS]=0;fV[fS+1]=0;fV[fS+2]=0;fV[fS+3]=255}}}}dk.putImageData(fT,0,0)};var fD=function(o){if(dX){return}if(aO!=undefined){return}aO=requestAnimationFrame(function(){ah()})};var fI=function(){if(aO==undefined){return}cancelAnimationFrame(aO);aO=undefined};var ah=function(){var o=false;aO=undefined;if(fh){if(B.runAfterTouch()){o=true}}if(!f){if(E!=dx){bh.src=c[dx];E=dx}}else{if(K){if(em()){o=true}}bQ.globalAlpha=1;bQ.clearRect(0,0,fH,b8);eN();if(cf&&cu){if(fP()){o=true}}}if(bb){if(fy){var fU=fx*aK.width;var fS=fx*aK.height;fy=false;var fT=-ai.drawOffsetX+(fU-aK.width*ai.scale)/2-br.panPos.left+aA.x*br.scale;var fR=-ai.drawOffsetY+(fS-aK.height*ai.scale)/2-br.panPos.top+aA.y*br.scale;cQ.camera.setViewOffset(fU,fS,fT,fR,ai.totalWidth,ai.totalHeight)}if(cn){d9(0,(dx*Math.PI*-2)/dn,0)}if(a8){cQ.renderer.draw(cQ.scene,cQ.camera)}if(cn){cn=false;if(dE&&cX){if(!a8){cQ.renderer.render(cQ.scene,cQ.camera)}ba()}}}if(fc){fc=false;if(eS){eS.update(dx,ae)}}if(eI){e4();bQ.fillStyle=aS;bQ.fillRect(fe.left+1,fe.top+1,fe.width()-1,fe.height()-1);bQ.fillStyle=af;bQ.fillRect(fe.left,fe.top,fe.width(),1);bQ.fillRect(fe.left,fe.bottom,fe.width(),1);bQ.fillRect(fe.left,fe.top,1,fe.height());bQ.fillRect(fe.right,fe.top,1,fe.height())}if(al){cZ.draw(R)}if(cq){if(bt){e(eU,"translate3d("+ai.left+"px,"+ai.top+"px,0px)"+ai.strTransformScale)}else{e(eU,"translate("+ai.left+"px,"+ai.top+"px)"+ai.strTransformScale)}}if(o){fD()}};var e4=function(){fe.copyRect(av);fe.offsetRect(-av.clientOffset.left,-av.clientOffset.top);fe.normalizeRect();if(ai.scale!=1){fe.scaleRect(ai.scale)}};var cM=function(){cn=fc=true};var dp=function(o){return false};var F=function(o){bQ.drawImage(o.img.FSI_image_context,o.x,o.y,o.width,o.height);return false};var fj=function(fR){var o;fR.alpha+=d0;if(fR.alpha>=1){fR.fnDraw=F;fR.alpha=1;o=false}else{o=true}bQ.globalAlpha=fR.alpha;F(fR);bQ.globalAlpha=1;return o};var fP=function(){var o=false;if(v){fr()}if(cu.nVisibleTiles>0){var fV=ai.drawOffsetX+Q.imageX+br.panPos.left;var fU=ai.drawOffsetY+Q.imageY+br.panPos.top;var fT=Q.imageWidth/cu.width;bQ.save();bQ.translate(fV,fU);bQ.scale(fT,fT);var fR=cu.arVisibleTiles;for(var fS=0;fS<cu.nVisibleTiles;fS++){if(fR[fS].fnDraw(fR[fS])){o=true}}bQ.restore()}cu.bTilesFading=o;if(L&&!o&&cu.bFilesArePreparedForLoading){if(bP.nTilesLoading==0&&cu.arTilesToLoad.length==0){L=false}}return o};var el=function(){var o=false;if(v){fr()}if(cu.nVisibleTiles>0){var fV=ai.drawOffsetX+Q.imageX+br.panPos.left;var fU=ai.drawOffsetY+Q.imageY+br.panPos.top;var fT=Q.imageWidth/cu.width;var fR=cu.arVisibleTiles;for(var fS=0;fS<cu.nVisibleTiles;fS++){if(fR[fS].fnDraw(fR[fS],fV,fU,fT)){o=true}}}cu.bTilesFading=o;if(L&&!o&&cu.bFilesArePreparedForLoading){if(bP.nTilesLoading==0&&cu.arTilesToLoad.length==0){L=false}}return o};var dl=function(o){fs=(o=="video");if(fs){dJ=undefined;cD=cB;bi=fn.getPreviewImage=ao;eN=bK}else{bi=fn.getPreviewImage=bW;eN=e5}};var ao=function(o){if(dJ==o){return cD}dJ=o;fK.putImageData(c[o],0,0);cD=cB;return cD};var bW=function(o){if(dJ==o){return cD}dJ=o;if(!cd){cd=r.imageWidth;if(fE){am=document.createElement("canvas");am.setAttribute("width",r.imageWidth);am.setAttribute("height",r.imageHeight);fz=am.getContext("2d")}}if(!fE){cD=c[o].FSI_image_context}else{fz.drawImage(c[o].FSI_image_context,0,0,r.imageWidth,r.imageHeight);cD=am}return cD};var bK=function(){bQ.globalAlpha=1;var fR=fx*r.videoWidth/b7.croppedWidth;var o=ao(dx);ak(ao(dx),Q.videoX,Q.videoY,fR);if(L&&e6.pellets&&!z){bQ.globalAlpha=e6.pelletsOpacity;bQ.globalCompositeOperation="xor";ak(c8,Q.videoX,Q.videoY,fR);bQ.globalAlpha=1;bQ.globalCompositeOperation="source-over"}};var e5=function(){ak(bW(dx),Q.imageX,Q.imageY,fx)};var ak=function(fT,f0,fX,fR){var fZ,fY;var fU=ai.drawOffsetX+f0+br.panPos.left;var fS=ai.drawOffsetY+fX+br.panPos.top;if(fU<0){fZ=-fU/fR;fU=0}else{fZ=0}if(fS<0){fY=-fS/fR;fS=0}else{fY=0}var f1=fT.width-fZ;var fW=fT.height-fY;var fV=f1*fR;var o=fW*fR;bQ.drawImage(fT,fZ,fY,f1,fW,fU,fS,fV,o)};var cb=function(){if(eS!=undefined){df()}if(br.enabled&&f){eS=new $FSI.NavigatorWindow(fn,eW,aC)}};var df=function(){if(eS==undefined){return}eS.destroy();eS=undefined};var by=function(){if(!c4||!cQ.targetObj){return}var fS=aK.width*ai.scale;var fW=aK.height*ai.scale;cQ.sceneWidth=aL.imageWidth*aA.cropScaleX;cQ.sceneHeight=aL.imageHeight*aA.cropScaleY;var fT=cQ.sceneWidth;var o=fT/1.5;var fV=o/fW;var fU=e6.camera.digitalCropFactor*e6.camera.focalLength*fV;var fR=2*THREE.Math.radToDeg(Math.atan(24/fU/2));cQ.camera=new THREE.PerspectiveCamera(fR,cQ.sceneWidth/cQ.sceneHeight,0.1,10000);if(e6.camera.heightTable!=undefined&&e6.camera.heightCamera!=undefined){e6.camera.heightAboveTable=e6.camera.heightCamera-e6.camera.heightTable}if(e6.camera.shiftX==undefined){e6.camera.shiftX=0}cQ.camera.position.x=e6.camera.shiftX;cQ.camera.position.z=e6.camera.distanceToTableCenter;cQ.camera.position.y=e6.camera.heightAboveTable;cQ.camera.lookAt(cQ.targetObj.position);cQ.camera.setViewOffset(fS,fW,-ai.drawOffsetX+aA.x,-ai.drawOffsetY+aA.y,fS,fW)};var fM=function(){if(!c4){return}var gi;gi=window.THREE;if($FSI.BrowserSupports.canvas()&&typeof gi!=="undefined"){if(f){cQ.renderer=new gi.CanvasRenderer({canvas:eU,clearColor:0,clearAlpha:0,devicePixelRatio:1});cQ.renderer.autoClear=false;cQ.renderer.setSize(aK.width*ai.scale,aK.height*ai.scale)}else{cQ.renderer=new gi.CanvasRenderer({clearColor:0,clearAlpha:0});cQ.renderer.autoClear=false;cQ.renderer.setSize(aK.width,aK.height)}cQ.scene=new gi.Scene();cQ.projector=new gi.Projector();cQ.objects=new gi.Object3D();var f1=new gi.Object3D();f1.position.x=e6.camera.targetWidthOffset;f1.position.y=e6.camera.targetHeightOffset;f1.position.z=0;cQ.scene.add(f1.position);cQ.targetObj=f1;var f0;if(e6.virtualSpace.cubeLineWidth>0&&e6.drawCube){var gg,fS;if(e6.virtualSpace.cubeSizeX){gg=new gi.CubeGeometry(e6.virtualSpace.cubeSizeX,e6.virtualSpace.cubeSizeY,e6.virtualSpace.cubeSizeZ);f0=e6.virtualSpace.cubeSizeY/2}else{gg=new gi.CubeGeometry(e6.virtualSpace.cubeSize,e6.virtualSpace.cubeSize,e6.virtualSpace.cubeSize);f0=e6.virtualSpace.cubeSize/2}fS=new gi.MeshBasicMaterial({color:65280,wireframe:true,wireframeLinewidth:e6.virtualSpace.cubeLineWidth});var fW=new gi.Mesh(gg,fS);if(e6.virtualSpace.shiftY==undefined){e6.virtualSpace.shiftY=0}fW.position.x=e6.virtualSpace.shiftX;fW.position.y=f0+e6.virtualSpace.shiftY;fW.position.z=e6.virtualSpace.shiftZ;cQ.cube=fW;cQ.objects.add(fW)}if(e6.drawGroundPlate){var f7=new gi.PlaneGeometry(500,500,10,10);var f2=new gi.MeshLambertMaterial({color:15626314,wireframe:true});var fT=new gi.Mesh(f7,f2);fT.rotation.x=-Math.PI/2;fT.position.y=0;cQ.objects.add(fT);cQ.plane=fT}if(e6.drawTable){var o=e6.tableDiameter/2;var gc=50;var fR=new gi.Geometry();var gl;gl=Math.PI*2/360;var f8=0;var fX=function(gp,go){var gr=0;var gs=0;var gw=0;var gq=0;for(var gt=0;gt<=36;gt++,f8+=4){var gn=Math.sin(gl*gt)*gp;var gv=Math.cos(gl*gt)*gp;var gm=Math.sin(gl*gt)*go;var gu=Math.cos(gl*gt)*go;fR.vertices.push(new gi.Vector3(gm,gu,0));fR.vertices.push(new gi.Vector3(gw,gq,0));fR.vertices.push(new gi.Vector3(gr,gs,0));fR.vertices.push(new gi.Vector3(gn,gv,0));fR.faces.push(new gi.Face4(f8,f8+1,f8+2,f8+3));gr=gn;gs=gv;gw=gm;gq=gu}};var fY=0;var fV=0;for(var gh=0;gh<=4;gh++,f8+=3){var f6=Math.sin(gl*gh*90)*gc;var f5=Math.cos(gl*gh*90)*gc;fR.vertices.push(new gi.Vector3(0,0,0));fR.vertices.push(new gi.Vector3(f6,f5,0));fR.vertices.push(new gi.Vector3(fY,fV,0));fR.faces.push(new gi.Face3(f8,f8+1,f8+2));fY=f6;fV=f5}gl=Math.PI*2/36;var gb=0;var ga=gc;while(ga<o){gb+=gc;ga=gb+gc;if(ga>o){ga=o}fX(gb,ga)}var gf=new gi.Mesh(fR,new gi.MeshLambertMaterial({color:5810431,wireframe:true}));gf.rotation.x=-Math.PI/2;cQ.disk=gf;cQ.objects.add(gf)}var gk=new gi.Vector3(0,1,0);var f9=new gi.Color(16755200);var f4=new gi.Face3(0,1,2,gk,f9,0);cQ.objects.add(f4);if(e6.hotspots&&e6.hotspots.points){aB();e1=e6.hotspotCallbackFunction;if(typeof(e1)=="string"){try{e1=window[e1]}catch(ge){}}else{if(typeof(e1)!="function"){e1=undefined}}for(var gd=0;gd<e6.hotspots.points.length;gd++){var fZ=e6.hotspots.points[gd];fZ.FSIHotspotID=gd;if(fZ.perimeterAngle&&fZ.perimeterAngle<0){fZ.perimeterAngle=360+fZ.perimeterAngle}fZ.perimeterAngleFadeOut=Math.min(fZ.perimeterAngleRange,fZ.perimeterAngleFadeOut);var f3=new gi.Object3D();f3.position.x=fZ.x+e6.virtualSpace.shiftX;f3.position.y=fZ.y;f3.position.z=fZ.z+e6.virtualSpace.shiftZ;fZ.object=f3;cQ.objects.add(f3);if(e6.hotspots.visible){var gj=new gi.Mesh(new gi.SphereGeometry(5,8,4),new gi.MeshLambertMaterial({color:255,wireframe:false}));gj.position.x=fZ.x;gj.position.y=fZ.y;gj.position.z=fZ.z;cQ.objects.add(gj)}if(e6.hotspots.defaults){for(var fU in e6.hotspots.defaults){if(fZ[fU]==undefined){fZ[fU]=e6.hotspots.defaults[fU]}}}cx(fZ)}cE.log(gd+" HotSpots created.")}cQ.scene.add(cQ.objects);by()}};var d8=function(o){var fR=o.type;eE(fR,this)};var eE=function(fT,o){var fS=o.FSIHotspot;if(!fS||!fT){return}switch(fT){case"mouseover":$FSI.addClass(o,fS.hoverClass);break;case"mousedown":$FSI.addClass(o,fS.activeClass);break;case"mouseout":$FSI.removeClass(o,fS.hoverClass);break;default:$FSI.removeClass(o,fS.activeClass)}if(fT=="click"&&fS.url!=undefined){window.open(fS.url,fS.urlTarget)}if(!e1){return}var fV=fS.FSIHotspotID;var fR=fS.tooltip;var fW=fS.actionParameter;var fU=fS.perimeterAngle;e1(fT,aJ,G,fV,fR,fW,fU)};var da=function(){if(!c4){return}cQ.objects.remove(cQ.cube);cQ.objects.remove(cQ.plane);cQ.objects.remove(cQ.disk)};var d9=function(fS,fR,o){cQ.objects.rotation.x=fS;cQ.objects.rotation.y=fR+e6.virtualSpace.baseRotationYRad;cQ.objects.rotation.z=o};var ba=function(){if(cP){cP=false;var fT=1/dL;fB.testWidth=fx*r.imageWidth;P.style.webkitTransform="scale("+fT+")";P.style.transform="scale("+fT+","+fT+")"}var ga=dL*ai.left;var f8=dL*ai.top;var gb=dL*aK.width/2;var fV=dL*aK.height/2;var fY,f0;var f6=false;var fZ,ge;var gd=aK.width*dL;var gc=aK.height*dL;if(fB.spinFrame!=dx){fB.spinFrame=dx;if(fB.arSpotsAtFrame==undefined){fB.arSpotsAtFrame=new Array(dn)}var f4=fB.hotSpotsAtThisFrame;fB.hotSpotsAtThisFrame=fB.arSpotsAtFrame[dx];if(fB.hotSpotsAtThisFrame==undefined){var f9=360*fJ(dx)/dn;fB.hotSpotsAtThisFrame=fB.arSpotsAtFrame[dx]=new Array();for(var f7=0;f7<e6.hotspots.points.length;f7++){fZ=e6.hotspots.points[f7];f0=1;if(fZ.perimeterAngle!=undefined){var gf=Math.abs(fZ.perimeterAngle-f9);if(gf>180){gf=360-gf}if(gf<fZ.perimeterAngleRange){if(gf>fZ.perimeterAngleRange-fZ.perimeterAngleFadeOut){f0=(fZ.perimeterAngleRange-gf)/fZ.perimeterAngleFadeOut}}else{f0=0}}if(f0!=0){var f3={};f3.index=f7;f3.hotspot=fZ;f3.op=f0;fB.hotSpotsAtThisFrame.push(f3);fY=fZ.object.matrixWorld.getPosition();ge=cQ.projector.projectVector(fY,cQ.camera);ge=cQ.projector.unprojectVector(fY,cQ.camera);f3.zIndex=Math.round(ge.z)}}}if(f4&&f4.length>0){var f2={};for(var f5=0;f5<fB.hotSpotsAtThisFrame.length;f5++){var fS=fB.hotSpotsAtThisFrame[f5];fZ=fS.hotspot;fZ.marker.style.zIndex=fZ.tooltip.style.zIndex=fS.zIndex;f2[fS.index]=fZ.bVisible}for(var f5=0;f5<f4.length;f5++){if(!f2[f4[f5].index]){a7(f4[f5].hotspot,false)}}}}if(fB.scale!=dL){fB.scale=dL;f6=true}for(var f7=0;f7<fB.hotSpotsAtThisFrame.length;f7++){var fU=fB.hotSpotsAtThisFrame[f7];fZ=fU.hotspot;f0=fU.op;if(!f6&&fZ._opScale!=undefined){if(fZ._opScale==0){f0=0}}else{fZ._opScale=1;if(e6.enableZoom&&fZ.perimeterZoom!=undefined){if(fx<fZ.perimeterZoom){f0=fZ._opScale=0}}if(f0!=0&&fZ.perimeterImageWidth!=undefined){if(fB.testWidth<fZ.perimeterImageWidth){f0=fZ._opScale=0}}}if(f0!=0){fY=fZ.object.matrixWorld.getPosition();var fR=cQ.projector.projectVector(fY,cQ.camera);var fX=Math.round(ga+fR.x*gb+gb);var fW=Math.round(f8+fV-fR.y*fV);if(br.enabled){if(fX<0||fW<0||fX>gd||fW>gc){f0=0}}}if(f0!=0){a7(fZ,true);if(fZ._opacity!=f0){fZ._opacity=f0;fZ.marker.style.opacity=fZ.tooltip.style.opacity=f0}var f1=fZ.oSvg;fZ.tooltip.style.left=fX+f1.endX+(fZ.tooltip.offsetWidth*f1.xAlign)+"px";fZ.tooltip.style.top=fW+f1.endY+(fZ.tooltip.offsetHeight*f1.yAlign)+"px";fZ.marker.style.left=fX+f1.startX+"px";fZ.marker.style.top=fW+f1.startY+"px"}else{fZ._opacity=0;a7(fZ,false)}}};var ay=function(fT,fY,fR,fX,o,fW,fU,fS,fV){if(fS==undefined){fS=a0}if(fV==undefined){fV=1}var fZ=document.createElementNS(cH,"polyline");fZ.setAttribute("points",fT+","+fY+" "+fR+","+fX+" "+o+" , "+fW+" "+fR+","+fX+" "+fT+","+fY);fZ.setAttribute("stroke",fU);fZ.setAttribute("stroke-width",fS);fZ.setAttribute("stroke-opacity",fV);fZ.setAttribute("stroke-linecap","square");return fZ};var aB=function(){var fU=at=document.createElementNS(cH,"svg");try{if(!fU.style){at=undefined;cE.log("ERROR: SVG Gradient not supported");return false}}catch(fW){at=undefined;cE.log("ERROR: SVG Gradient not supported");return false}var f1=$FSI.getSVGID();var fV=e6.hotspotDotRadius;var fS=0,f3=0;var fR=1,f0=1;var o=2,fY=2;fU.setAttribute("xmlns",cH);fU.setAttribute("version",eD);fU.setAttribute("baseProfile","tiny");var fT=fU.cloneNode(true);try{var f4=document.createElementNS(cH,"radialGradient");f4.setAttribute("id",f1);f4.setAttribute("cx","0.5");f4.setAttribute("cy","0.5");f4.setAttribute("r","0.5");var f2=document.createElementNS(cH,"stop");f2.setAttribute("stop-color",e6.hotspotDotColor1);f2.setAttribute("offset","0.5");var fZ=document.createElementNS(cH,"stop");fZ.setAttribute("stop-color",e6.hotspotDotColor2);fZ.setAttribute("offset","1");f4.appendChild(f2);f4.appendChild(fZ);fT.appendChild(f4);fT.style.position="absolute";P.appendChild(fT)}catch(fW){cE.log("ERROR: SVG Gradient not supported")}var fX=document.createElementNS(cH,"circle");fX.setAttribute("r",fV);fX.setAttribute("stroke",e6.hotspotLineColor2);fX.setAttribute("stroke-width","1px");fX.setAttribute("stroke-opacity","0.85");fX.setAttribute("fill","url(#"+f1+")");fX.setAttribute("fill-opacity","0.5");fU.appendChild(fX);return true};var aG=function(fW){var f1=fW.horizontalMarkerSize;var f6=Math.abs(fW.verticalMarkerSize);var ga;if(!at){return{width:0,height:0,startX:0,startY:0,endX:0,endY:0,xAlign:0,yAlign:0}}var fY=fW.markerAngle*Math.PI/180;var f7,fU,f5,fT,f3,fS;var gc={};var fV=gc.radius=e6.hotspotDotRadius+1;ga=Math.max(0,Math.min(1,fW.horizontalMarkerPosition));if(ga>0.5){f1=-f1}gc.xAlign=-ga;ga=Math.max(0,Math.min(1,fW.verticalMarkerPosition));gc.yAlign=-ga;f7=0;fU=0;f5=f7+Math.sin(fY)*f6;fT=fU-Math.cos(fY)*f6;f3=f5+f1;var f8=Math.min(f7-fV,f5);var o=Math.min(fU-fV,fT);f8=Math.min(f8,f3);var f0=Math.sin(fY);var f2=Math.cos(fY);f7-=f8;f5-=f8;f3-=f8;fU-=o;fT-=o;fS=fT;gc.startX=-f7;gc.startY=-fU;gc.endX=gc.startX+f3;gc.endY=gc.startY+fS;var gb=Math.max(f7+fV,f5);gb=Math.max(gb,f3);var fR=Math.max(fU+fV,fT);var fZ=gc.svg=at.cloneNode(true);var fX=gc.width=gb;var f4=gc.height=fR;fZ.setAttribute("width",fX);fZ.setAttribute("height",f4);fZ.setAttribute("viewBox","0 0 "+fX+" "+f4);var f9=fZ.firstChild;f9.setAttribute("cx",f7);f9.setAttribute("cy",fU);f7+=Math.sin(fY)*fV;fU-=Math.cos(fY)*fV;fZ.appendChild(ay(f7,fU,f5,fT,f3,fS,e6.hotspotLineColor1,"5px","0.25"));fZ.appendChild(ay(f7,fU,f5,fT,f3,fS,e6.hotspotLineColor2,"1px"));return gc};var a7=function(fR,o){if(fR.bVisible==o){return}fR.bVisible=o;fR.marker.style.display=fR.tooltip.style.display=(o)?"block":"none"};var cx=function(fU){var fR=document.createElement("div");if(fU.cssClass!=undefined){fU.normalClass=fU.normalClass+" "+fU.cssClass}if(bs){fU.normalClass+=bs}fR.className=fU.normalClass;var fS="position:absolute;left:0px;top:0px;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;"+fU.cssStyle;$FSI.setStyleAttr(fR,fS);fR.innerHTML=fU.text;if(e6.decodeHTMLEntitiesInHotSpotTexts){fR.innerHTML=fR.innerText}var fT=aG(fU);var o;if(fT&&fT.svg){o=fT.svg;o.style.position="absolute";P.appendChild(o)}else{o={style:{}}}if(fU.interactive){fR.FSIHotspot=fU;P.appendChild(fR);$FSI.addEvent(fR,"mouseover",d8);$FSI.addEvent(fR,"mouseout",d8)}else{fR.style.zIndex="1";P.appendChild(fR)}fU.bVisible=false;fU.tooltip=fR;fU.marker=o;fU.oSvg=fT;fR.style.display="none";o.style.display="none"};var cc=function(o){an();var fR=true;var fS=(dn&&!ci);eh=o.shiftKey;switch(o.keyCode){case 37:if(fS){bf();cJ=1;fu(db+cL)}fR=false;break;case 39:if(fS){bf();cJ=-1;fu(db-cL)}fR=false;break;case 32:fR=false;break}if(!fR&&o.preventDefault){o.preventDefault()}return fR};var ds=function(fR){var fS=Math.round(100*fR);var o=""+fS/100;if(fS%100==0){o+=".0"}if(fS%10==0){o+="0"}return o};var bE=function(o){eh=o.shiftKey;if(cE&&cE.on){if(!eh){bl(bm)}}var fR=true;var fS=(dn&&!ci);switch(o.keyCode){case 37:if(fS){dG(dx,true)}fR=false;break;case 39:if(fS){dG(dx,true)}fR=false;break;case 32:aJ.resetView();fR=false;break}if(!fR){o.cancelBubble=true;if(o.stopPropagation){o.stopPropagation()}if(o.preventDefault){o.preventDefault()}}return fR};this.resetView=function(){dv();var o=(dn&&!ci);if(o){aJ.spinToTarget(0)}if(br.enabled){e3(0,0)}};this.spinToDegree=function(o){if(!bJ){return}var fR=fJ(Math.round(o/360*dn));aJ.spinToTarget(fR)};this.spinToTarget=function(o,fU){if(!bJ){return}o=cr(o);var fS=fJ(dx);var fT=o-fS;if(fT==0){de(o,o,0,0);return true}cJ=(fT>0)?1:-1;var fR=fS;if(Math.abs(fT)>dn/2){if(cJ>0){o-=dn}else{fR-=dn}cJ=-cJ;fT=Math.abs(o-fR)}bf();if(fU==undefined){fU=Math.ceil(1.5*Math.abs(fT))}de(fR,o,0,fU);return true};var fJ=function(o){if(dn){o%=dn;if(o<0){o=dn+o}}return o};var cr=function(fR,fU){var fT;var o=dn/(fw.length);var fS=Math.round(fR/o)*o;if(!fU||fR==fS){fT=fS}else{if(cJ==1){fT=Math.round(fS+o)}else{fT=Math.round(fS-o)}}fT=fJ(fT);return fT};var dG=function(o,fT){var fR=(o!=undefined)?o:dx;var fS=cr(fR,fT);aJ.spinToTarget(fS)};var de=function(o,fS,fT,fR){bf();if(aR(o,fS,fT,fR)){bn("spinToFrame")}};var bf=function(){if(ep==undefined){return}cancelAnimationFrame(ep);ep=undefined;eX("cancelSpinToFrame")};var aR=function(fR,fV,fW,fU){var o=fV-fR;var fT=ar(fW,fU,fR,o);if(fW!=fU){if(dQ){dQ.lockImageSourceDimension(bh,true);dQ.lockImage(bh,true)}var fS=Math.round(fT);if(fS<0){fS=dn+fS}else{if(fS==dn){fS=0}}ep=requestAnimationFrame(function(){if(fS!=dx){cM();bx(fS);fD()}bx(fS);aR(fR,fV,++fW,fU)});return true}else{ep=undefined;if(dQ){dQ.lockImage(bh,false)}bx(fJ(fV));bv();bz();eX("doSpinToFrame")}};var bv=function(){dx=fJ(dx);fD();if(f){d7()}};var fl=function(fR){var o={};o.baseURL=eW.getImageURL(fw[fR],d5);o.fullURL=o.baseURL+fo;return o};var ec=function(){if(!cu){return}bC=undefined;cu=undefined;aM=undefined;L=true;I()};var bc=function(){if(a1==a9){return}a1=a9;var o=ee.getPixelRangeRect(a9);fo=ee.getPixelRangeParametersByCalculatedResult(o)};var d7=function(f4){if(f&&!fs&&fx<=1){ec();return}if(dX||bC==a9){return}bC=a9;if(f4==undefined){f4=Math.round(dx/(dn/fw.length))}if(isNaN(f4)||f4<0||f4>=fw.length){cE.error("invalid image index in loadHDImage "+f4);return}bc();var fR=fl(f4);if(aM==fR.fullURL){return}if(cu&&fR.fullURL==cu.src){return}bP={};bP.img=new Image();bP.nImage=f4;bP.renderScale=fx;var fS=dn/fw.length;bP.spinPos=cr(f4*fS);bP.img.crossOrigin="anonymous";bP.img.FSI_ImageObject=bP;aM=bP.src=fR.fullURL;if(f){L=true;bP.bTilesFading=false;bP.bFillsViewport=false;var fZ=dR.width;var fY=dR.height;var fX=a9;var fV=Math.round(fX/fZ*fY);bP.width=fX;bP.height=fV;var o="&referenceWidth="+fX+"&referenceHeight="+fV;var f5=eo;bP.tiles=[];var f2=0;var f0=0;var f3=f5;var f1=f5;f3=Math.min(f3,fX);f1=Math.min(f1,fV);var fU;var fT=false;while(f0<fV){fU={};fU.fnDraw=dp;fU.FSI_ImageObject=bP;fU.x=f2;fU.y=f0;if(f2+f3>=fX){fU.width=fX-f2;f3=Math.min(f5,fX-f2);fT=true}fU.width=f3;fU.height=f1;var fW=ee.getPixelRangeParameters(fX,fV,f2,f0,f3,f1);fU.url=fR.baseURL+fW;if(fT){fT=false;f0+=f5;f2=0;f3=f5;if(f0+f5>fV){f1=Math.min(f5,fV-f0)}}else{f2+=f5}bP.tiles.push(fU)}bP.nTiles=bP.tiles.length;bP.arVisibleTiles=new Array(bP.nTiles);bP.nVisibleTiles=0;bP.nTilesLoading=0;bP.nTilesLoaded=0;bP.nTilesRequested=0;bP.nTileColumns=Math.ceil(fX/f5);bP.nTileRows=Math.ceil(fV/f5);v=true;J(null,bP)}};var dd=function(o){o.bLoading=true;o.img=new Image();o.img.oTile=o;$FSI.addEvent(o.img,"load",aH);eJ(o.img,o.url)};var aH=function(){$FSI.removeEvent(this,"load",aH);var fR=this.oTile;fR.bLoaded=true;var o=fR.FSI_ImageObject;if(o.nTilesLoaded==o.nTiles){o.bComplete=true;o.bFillsViewport=true}if(o.src!=aM){return}fR.alpha=0;fR.fnDraw=fj;o.nTilesLoading--;o.nTilesLoaded++;J(null,o);bN(this);fD();ca(25)};var bu=function(fR,o){return o.distance-fR.distance};var fr=function(){v=false;if(!cu){return}var fX=cu;var f7,f6,fS,o;var fW;if(br.enabled){ek.setRect(0,0,aK.width,aK.height);ek.scaleRect(1/br.scale);ek.offsetRect(-br.panPos.left/fx,-br.panPos.top/fx);ek.offsetRect((aK.width-ek.width())/2,(aK.height-ek.height())/2);cO.copyRect(aE);cO.scaleRect(1/br.scale);cO.offsetRect(ek.left,ek.top);fW=cO}else{fW=aE}bF(fW);f7=ez.left;f6=ez.top;fS=ez.right;o=ez.bottom;var f4=Math.max(0,Math.floor(f7/eo));var fT=Math.min(fX.nTileColumns-1,Math.floor(fS/eo));var f3=Math.max(0,Math.floor(f6/eo));var fR=Math.min(fX.nTileRows-1,Math.floor(o/eo));var fU=fT-f4+1;var fZ=fR-f3+1;var f0=Math.max(0,fZ)*fU;if(fX.nFirstTileXLastGetVisible==f4&&fX.nFirstTileYLastGetVisible==f3&&fX.nTilesLastGetVisible==f0){return}fX.nFirstTileXLastGetVisible=f4;fX.nFirstTileYLastGetVisible=f3;fX.nTilesLastGetVisible=f0;var f9=fX.tiles;var f8=fX.arVisibleTiles;var f1=f3*fX.nTileColumns;var fV=f4;var f2;var fY=L;L=false;for(var f5=0;f5<f0;f5++){f2=f8[f5]=f9[f1+fV];if(!L&&f2.alpha!=1){L=true}if(++fV>fT){fV=f4;f1+=fX.nTileColumns}}fX.nVisibleTiles=f0;fX.bFilesArePreparedForLoading=false;if(L&&!fY){bQ.globalAlpha=1;eN()}ca(50)};var I=function(){if(e8){clearTimeout(e8);e8=undefined}};var ca=function(o){if(e8!=undefined){return}if(!cu||cu.bRequestsComplete){return}e8=setTimeout(fg,o)};var fg=function(){I();y()};var y=function(){if(K){return}var fU=cu;if(fU.nTilesLoading>=dN){return}var fX,fS,fR;if(!fU.bFilesArePreparedForLoading){fU.bFilesArePreparedForLoading=true;if(!fU.arTilesToLoad||fU.arTilesToLoad.length!=0){fU.arTilesToLoad=[]}fX=fU.arTilesToLoad;var fV=fU.arVisibleTiles;for(var fT=0;fT<fU.nVisibleTiles;fT++){if(!fV[fT].bLoading){fX.push(fV[fT])}}if(fX.length>1){br.centerX=ez.left+ez.width()/2;br.centerY=ez.top+ez.height()/2;for(var fT=0;fT<fX.length;fT++){var fW=fX[fT];fS=fW.x-br.centerX+fW.width/2;fR=fW.y-br.centerY+fW.height/2;fW.distance=Math.abs(fS)+Math.abs(fR)}fX.sort(bu)}}var o=0;fX=fU.arTilesToLoad;while(fU.nTilesLoading<dN&&fX.length>0){var fW=fX.pop();dd(fW);o++;fU.nTilesLoading++}fU.nTilesRequested+=o;if(fU.nTilesRequested==fU.nTiles){fU.bRequestsComplete=true}};var J=function(o,fR){if(fR==undefined){$FSI.removeEvent(this,"load",J);fR=this.FSI_ImageObject;fR.width=this.width;fR.height=this.height}if(fR.src!=aM){return}bN(this);cu=fR;if(fO){return}fD()};this.onMenuButtonPress=function(fR){dv();be();var o,fS;if(fR.indexOf("_")!=-1){o=fR.split("_");fR=o[0];fS=o[1]}switch(fR){case"Reset":aJ.resetView();break;case"ZoomOut":case"ZoomIn":T(fR,150,10);break;case"MouseMode":d4(parseInt(fS));break;case"MaxZoom":et(undefined,undefined,br.scaleToSourceImage-fx,false,30);break}};this.onMenuButtonRelease=function(fR){be();var o,fS;if(fR.indexOf("_")!=-1){o=fR.split("_");fR=o[0];fS=o[1]}switch(fR){case"FullScreen":if($FSI.FullScreen.getEnabled()){cC();$FSI.FullScreen.quit()}else{$FSI.FullScreen.start(fp);cC()}break;case"Hotspots":ct=b5.getButtonPressed("Hotspots");eO(ct);break}};var W=function(fR){if(!br.enabled){return}var o=fx;eM(fR);br.panPos.left*=fx/o;br.panPos.top*=fx/o;bp(true)};var en=function(fR){if(fR==undefined){fR=a6.cmd;a6.nRepeatCount++}switch(fR){case"ZoomOut":var o=(a6.nRepeatCount<1)?1.01:1.035;W(br.scale/o);break;case"ZoomIn":var o=(a6.nRepeatCount<1)?1.01:1.035;W(br.scale*o);break}if(a6.nRepeatCount==1){if(a6.intervalTimeFirst!=a6.intervalTimeRepeat){clearInterval(a6.interval);a6.interval=setInterval(en,a6.intervalTimeRepeat)}}};var T=function(fS,o,fR){ax(false);be();a6={};a6.bRunning=true;if(o==undefined){o=500}a6.intervalTimeFirst=o;if(fR==undefined){a6.intervalTimeRepeat=o}else{a6.intervalTimeRepeat=fR}a6.nRepeatCount=0;a6.cmd=fS;en(fS);a6.interval=setInterval(en,a6.intervalTimeFirst)};var be=function(){if(!a6.bRunning){return}ax(true);clearInterval(a6.interval);switch(a6.cmd){case"ZoomOut":case"ZoomIn":dP();break}a6={}};var dO=function(o){if(M!=undefined){if(M.width!=aL.imageWidth){a4()}else{return}}if(fs){return}M={};M.previewImageCanvasWidthBeforeResize=o;M.uniqueInstanceID=ab;M.nTimeout=setTimeout(c5,50)};var c5=function(){if(!bJ){M.nTimeout=setTimeout(c5,250);return}if(!e6.loadExactPreviewImagesAfterResize){var fR=M.previewImageCanvasWidthBeforeResize/aL.imageWidth;if(Math.abs(1-fR)<0.05){a4();return}}M.nTimeout=undefined;M.img=new Image();$FSI.addEvent(M.img,"load",aa);M.pos=0;M.arIndex=new Array(c.length);M.arIndex[0]=dx;for(var o=0,fS=1;o<c.length;o++){if(o!=dx){M.arIndex[fS++]=o}}aa()};var aa=function(o){if(o!=undefined){if(!M||M.uniqueInstanceID!=ab){return}$FSI.removeEvent(M.img,"load",aa);bN(M.img);c[M.indexCurrent]=M.img;if(M.pos==1){am=undefined;cd=undefined;dJ=undefined;bi(M.indexCurrent)}if(M.indexCurrent==dx){dJ=undefined;fD()}M.img=new Image();$FSI.addEvent(M.img,"load",aa)}M.indexCurrent=M.arIndex[M.pos];M.pos++;if(M.pos>c.length){a4()}else{var fR=a9;a9=ap;bc();M.url=fl(M.indexCurrent).fullURL;a9=fR;bc();M.nTimeout=setTimeout(co,50)}};var co=function(){eJ(M.img,M.url)};var a4=function(){if(M==undefined){return}if(M.nTimeout){clearTimeout(M.nTimeout);M.nTimeout=undefined}$FSI.removeEvent(M.img,"load",aa);M=undefined};var b4=function(){cC()};var aD=function(){cE.error("ERROR entering FullScreen")};var cC=function(){var o=$FSI.FullScreen.getEnabled();if(b5){b5.setButtonPressed("FullScreen",o)}if(o==c7){return}c7=o;if(o==true){$FSI.FullScreen.addChangeEvents(window,b4,aD)}else{$FSI.FullScreen.removeChangeEvents(window,b4,aD)}};this.getInFullScreenMode=function(){return c7};this.getSpinFrames=function(){return dn};this.getImageIsTransparent=function(){return cR};this.getSrcDim=function(){return dR};var eT=fn;eT.iViewer=aJ;eT.getToolTipObject=function(){return eB};eT.getElementSpace=function(){return Y};eT.getDrawRatio=function(){return Q};eT.getdrawRatioUnZoomed=function(){return aL};eT.getdrawRatioUnResized=function(){return r};eT.getinPlaceZoom=function(){return br};eT.getRootContainer=function(){return fp};if(typeof(di)!="object"||$FSI.makeBool(di.autoInit,true)){aJ.init(e0,di)}};$FSI.InitCustomTagsViewer=function(){var b="fsi-viewer";var c="display:block;width:300px;height:300px;";var e=$FSI.customTags[b];if(e){return}var a=function(g){var f=$FSI.attributes2parameters(g);if(f.src!=undefined&&f.imagesrc==undefined){f.imagesrc=f.src}return f};var d={};d.registerElement=function(){$FSI.addViewerClassCSSRule(b,c);var f=Object.create(HTMLDivElement.prototype);f.createdCallback=function(){$FSI.customTagDimFromAttributes(this);$FSI.Viewer.prototype.constructor.call(this,this,{autoInit:false})};f.attachedCallback=function(){if(this.getInitDone()){return}this.init(this,a(this));this.start()};document.registerElement(b,{prototype:f})};d.replaceTagInit=function(f){$FSI.addViewerClassCSSRule(b,c)};d.replaceTag=function(f){if(!f||(typeof(f.getInitDone)=="function"&&f.getInitDone())){return}$FSI.customTagDimFromAttributes(f);$FSI.Viewer.prototype.constructor.call(f,f,a(f));f.start()};e=$FSI.registerCustomTag(b,d)}();delete $FSI.InitCustomTagsViewer;