/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ErodeOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;
    private float[] kdata;

    public ErodeOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.kdata = kernelJAI.getKernelData();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        for (int i = 0; i < n3; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    int n12;
                    int n13 = 0;
                    int n14 = n10;
                    float f = Float.POSITIVE_INFINITY;
                    for (n12 = 0; n12 < this.kh; ++n12) {
                        int n15 = n14;
                        for (int i2 = 0; i2 < this.kw; ++i2) {
                            float f2 = (float)(byArray4[n15] & 0xFF) - this.kdata[n13 + i2];
                            if (f2 < f) {
                                f = f2;
                            }
                            n15 += n6;
                        }
                        n13 += this.kw;
                        n14 += n7;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    if ((n12 = (int)f) < 0) {
                        n12 = 0;
                    } else if (n12 > 255) {
                        n12 = 255;
                    }
                    byArray3[n11] = (byte)n12;
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    int n12;
                    int n13 = 0;
                    int n14 = n10;
                    float f = Float.POSITIVE_INFINITY;
                    for (n12 = 0; n12 < this.kh; ++n12) {
                        int n15 = n14;
                        for (int i2 = 0; i2 < this.kw; ++i2) {
                            float f2 = (float)sArray4[n15] - this.kdata[n13 + i2];
                            if (f2 < f) {
                                f = f2;
                            }
                            n15 += n6;
                        }
                        n13 += this.kw;
                        n14 += n7;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    if ((n12 = (int)f) < Short.MIN_VALUE) {
                        n12 = Short.MIN_VALUE;
                    } else if (n12 > Short.MAX_VALUE) {
                        n12 = Short.MAX_VALUE;
                    }
                    sArray3[n11] = (short)n12;
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    int n12;
                    int n13 = 0;
                    int n14 = n10;
                    float f = Float.POSITIVE_INFINITY;
                    for (n12 = 0; n12 < this.kh; ++n12) {
                        int n15 = n14;
                        for (int i2 = 0; i2 < this.kw; ++i2) {
                            float f2 = (float)(sArray4[n15] & 0xFFFF) - this.kdata[n13 + i2];
                            if (f2 < f) {
                                f = f2;
                            }
                            n15 += n6;
                        }
                        n13 += this.kw;
                        n14 += n7;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    if ((n12 = (int)f) < 0) {
                        n12 = 0;
                    } else if (n12 > 65535) {
                        n12 = 65535;
                    }
                    sArray3[n11] = (short)n12;
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        for (int i = 0; i < n3; ++i) {
            int[] nArray5 = nArray3[i];
            int[] nArray6 = nArray4[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    int n12 = 0;
                    int n13 = n10;
                    float f = Float.POSITIVE_INFINITY;
                    for (int i2 = 0; i2 < this.kh; ++i2) {
                        int n14 = n13;
                        for (int i3 = 0; i3 < this.kw; ++i3) {
                            float f2 = (float)nArray6[n14] - this.kdata[n12 + i3];
                            if (f2 < f) {
                                f = f2;
                            }
                            n14 += n6;
                        }
                        n12 += this.kw;
                        n13 += n7;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    nArray5[n11] = (int)f;
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        for (int i = 0; i < n3; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    int n12 = 0;
                    int n13 = n10;
                    float f = Float.POSITIVE_INFINITY;
                    for (int i2 = 0; i2 < this.kh; ++i2) {
                        int n14 = n13;
                        for (int i3 = 0; i3 < this.kw; ++i3) {
                            float f2 = fArray4[n14] - this.kdata[n12 + i3];
                            if (f2 < f) {
                                f = f2;
                            }
                            n14 += n6;
                        }
                        n12 += this.kw;
                        n13 += n7;
                    }
                    if (Float.isInfinite(f)) {
                        f = 0.0f;
                    }
                    fArray3[n11] = f;
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray2[i];
            int n9 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n; ++k) {
                    int n12 = 0;
                    int n13 = n10;
                    double d = Double.POSITIVE_INFINITY;
                    for (int i2 = 0; i2 < this.kh; ++i2) {
                        int n14 = n13;
                        for (int i3 = 0; i3 < this.kw; ++i3) {
                            double d2 = dArray4[n14] - (double)this.kdata[n12 + i3];
                            if (d2 < d) {
                                d = d2;
                            }
                            n14 += n6;
                        }
                        n12 += this.kw;
                        n13 += n7;
                    }
                    if (Double.isInfinite(d)) {
                        d = 0.0;
                    }
                    dArray3[n11] = d;
                    n10 += n6;
                    n11 += n4;
                }
                n8 += n7;
                n9 += n5;
            }
        }
    }
}

