/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.operator;

import com.sun.media.jai.operator.I18N;
import com.sun.media.jai.operator.ImageReadPropertyGenerator;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.EventListener;
import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class ImageReadDescriptor
extends OperationDescriptorImpl {
    public static final String PROPERTY_NAME_IMAGE_READ_PARAM = "JAI.ImageReadParam";
    public static final String PROPERTY_NAME_IMAGE_READER = "JAI.ImageReader";
    public static final String PROPERTY_NAME_METADATA_IMAGE = "JAI.ImageMetadata";
    public static final String PROPERTY_NAME_METADATA_STREAM = "JAI.StreamMetadata";
    public static final String PROPERTY_NAME_THUMBNAILS = "JAI.Thumbnails";
    public static final String PROPERTY_NAME_RENDERABLE_INPUT = "JAI.RenderableInput";
    private static final String OPERATION_NAME = "ImageRead";
    private static final String[][] resources = new String[][]{{"GlobalName", "ImageRead"}, {"LocalName", "ImageRead"}, {"Vendor", "com.sun.media.jai"}, {"Description", I18N.getString("ImageReadDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ImageReadDescriptor.html"}, {"Version", I18N.getString("DescriptorVersion")}, {"arg0Desc", I18N.getString("ImageReadDescriptor1")}, {"arg1Desc", I18N.getString("ImageReadDescriptor2")}, {"arg2Desc", I18N.getString("ImageReadDescriptor3")}, {"arg3Desc", I18N.getString("ImageReadDescriptor4")}, {"arg4Desc", I18N.getString("ImageReadDescriptor5")}, {"arg5Desc", I18N.getString("ImageReadDescriptor6")}, {"arg6Desc", I18N.getString("ImageReadDescriptor7")}, {"arg7Desc", I18N.getString("ImageReadDescriptor8")}, {"arg8Desc", I18N.getString("ImageReadDescriptor9")}};
    private static final String[] paramNames = new String[]{"Input", "ImageChoice", "ReadMetadata", "ReadThumbnails", "VerifyInput", "Listeners", "Locale", "ReadParam", "Reader"};
    private static final Class[] renderedParamClasses = new Class[]{Object.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, EventListener[].class, Locale.class, ImageReadParam.class, ImageReader.class};
    private static final Object[] renderedParamDefaults = new Object[]{NO_PARAMETER_DEFAULT, new Integer(0), Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null, null, null, null};
    private static final Class[] renderableParamClasses = new Class[]{Object.class, int[].class, Boolean.class, Boolean.class, Boolean.class, EventListener[].class, Locale.class, ImageReadParam.class, ImageReader.class};
    private static final Object[] renderableParamDefaults = new Object[]{NO_PARAMETER_DEFAULT, null, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null, null, null, null};
    private static final Class[] collectionParamClasses = renderableParamClasses;
    private static final Object[] collectionParamDefaults = renderableParamDefaults;

    public ImageReadDescriptor() {
        super(resources, new String[]{"rendered", "renderable", "collection"}, null, (Class[][])new Class[][]{null, null, null}, paramNames, (Class[][])new Class[][]{renderedParamClasses, renderableParamClasses, collectionParamClasses}, (Object[][])new Object[][]{renderedParamDefaults, renderableParamDefaults, collectionParamDefaults}, (Object[][])new Object[][]{null, null, null});
    }

    public static RenderedOp create(ImageInputStream imageInputStream, Integer n, Boolean bl, Boolean bl2, Boolean bl3, EventListener[] eventListenerArray, Locale locale, ImageReadParam imageReadParam, ImageReader imageReader, RenderingHints renderingHints) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(imageInputStream);
        parameterBlock.add(n);
        parameterBlock.add(bl);
        parameterBlock.add(bl2);
        parameterBlock.add(bl3);
        parameterBlock.add(eventListenerArray);
        parameterBlock.add(locale);
        parameterBlock.add(imageReadParam);
        parameterBlock.add(imageReader);
        return JAI.create((String)OPERATION_NAME, (ParameterBlock)parameterBlock, (RenderingHints)renderingHints);
    }

    public static Collection createCollection(ImageInputStream imageInputStream, int[] nArray, Boolean bl, Boolean bl2, Boolean bl3, EventListener[] eventListenerArray, Locale locale, ImageReadParam imageReadParam, ImageReader imageReader, RenderingHints renderingHints) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(imageInputStream);
        parameterBlock.add(nArray);
        parameterBlock.add(bl);
        parameterBlock.add(bl2);
        parameterBlock.add(bl3);
        parameterBlock.add(eventListenerArray);
        parameterBlock.add(locale);
        parameterBlock.add(imageReadParam);
        parameterBlock.add(imageReader);
        return JAI.createCollection((String)OPERATION_NAME, (ParameterBlock)parameterBlock, (RenderingHints)renderingHints);
    }

    public static RenderableOp createRenderable(ImageInputStream imageInputStream, int[] nArray, Boolean bl, Boolean bl2, Boolean bl3, EventListener[] eventListenerArray, Locale locale, ImageReadParam imageReadParam, ImageReader imageReader, RenderingHints renderingHints) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(imageInputStream);
        parameterBlock.add(nArray);
        parameterBlock.add(bl);
        parameterBlock.add(bl2);
        parameterBlock.add(bl3);
        parameterBlock.add(eventListenerArray);
        parameterBlock.add(locale);
        parameterBlock.add(imageReadParam);
        parameterBlock.add(imageReader);
        return JAI.createRenderable((String)OPERATION_NAME, (ParameterBlock)parameterBlock, (RenderingHints)renderingHints);
    }

    public PropertyGenerator[] getPropertyGenerators(String string) {
        PropertyGenerator[] propertyGeneratorArray;
        if (string.equalsIgnoreCase("renderable")) {
            PropertyGenerator[] propertyGeneratorArray2 = new PropertyGenerator[1];
            propertyGeneratorArray = propertyGeneratorArray2;
            propertyGeneratorArray2[0] = new ImageReadPropertyGenerator();
        } else {
            propertyGeneratorArray = null;
        }
        return propertyGeneratorArray;
    }

    protected boolean validateParameters(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        Object object;
        if (!super.validateParameters(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (string.equalsIgnoreCase("rendered")) {
            if (parameterBlock.getIntParameter(1) < 0) {
                stringBuffer.append(I18N.getString("ImageReadDescriptor10"));
                return false;
            }
        } else {
            object = (int[])parameterBlock.getObjectParameter(1);
            if (object != null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (object[i] >= 0) continue;
                    stringBuffer.append(I18N.getString("ImageReadDescriptor10"));
                    return false;
                }
            }
        }
        if ((object = (Object)((Boolean)parameterBlock.getObjectParameter(4))).booleanValue()) {
            Object object2 = parameterBlock.getObjectParameter(0);
            if (object2 instanceof File || object2 instanceof String) {
                File file = null;
                String string2 = null;
                if (object2 instanceof File) {
                    file = (File)object2;
                    string2 = file.getPath();
                } else if (object2 instanceof String) {
                    string2 = (String)object2;
                    file = new File(string2);
                }
                if (file != null) {
                    if (!file.exists()) {
                        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)object2);
                        if (inputStream == null) {
                            stringBuffer.append("\"" + string2 + "\": " + I18N.getString("ImageReadDescriptor11"));
                            return false;
                        }
                    } else if (!file.canRead()) {
                        stringBuffer.append("\"" + string2 + "\": " + I18N.getString("ImageReadDescriptor12"));
                        return false;
                    }
                }
            } else if (object2 instanceof Socket) {
                Socket socket = (Socket)object2;
                if (socket.isInputShutdown()) {
                    stringBuffer.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor13"));
                    return false;
                }
                if (socket.isClosed()) {
                    stringBuffer.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor14"));
                    return false;
                }
                if (!socket.isBound()) {
                    stringBuffer.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor15"));
                    return false;
                }
                if (!socket.isConnected()) {
                    stringBuffer.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor16"));
                    return false;
                }
            }
        }
        return true;
    }
}

